// SPDX-License-Identifier: LGPL-2.1-only OR LGPL-3.0-only OR LicenseRef-KDE-Accepted-LGPL
// SPDX-FileCopyrightText: 2024 Arjen Hiemstra <ahiemstra@heimr.nl>
//
// This file is automatically generated from qml_group.cpp.j2.
// To regenerate, run `tools/propertygenerator/generate_properties.py`.

#include "BackgroundPropertyGroup.h"

#include <QQmlEngine>

#include "QuickStyle.h"

using namespace Union::Properties;
using namespace Qt::StringLiterals;

BackgroundPropertyGroup::BackgroundPropertyGroup(QuickStyle *style)
    : QObject()
    , m_style(style)
{
    m_image = std::make_unique<ImagePropertyGroup>(m_style);
}

void BackgroundPropertyGroup::update(BackgroundProperty *newState)
{
    if (newState == m_state) {
        return;
    }

    m_state = newState;

    if (!newState) {
        m_image->update(nullptr);
    } else {
        m_image->update(newState->image());
    }

    Q_EMIT colorChanged();
    Q_EMIT updated();
}

void BackgroundPropertyGroup::refreshColors()
{
    Q_EMIT colorChanged();
    m_image->refreshColors();
}

QJSValue BackgroundPropertyGroup::color() const
{
    if (!m_state) {
        return QJSValue(QJSValue::UndefinedValue);
    }

    auto value = m_state->color();
    if (value) {
        return m_style->engine()->toScriptValue(value.value().toQColor());
    }

    return QJSValue(QJSValue::UndefinedValue);
}

ImagePropertyGroup *BackgroundPropertyGroup::image() const
{
    return m_image.get();
}

#include "moc_BackgroundPropertyGroup.cpp"