/* -*- Mode: C++; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* vim:set ts=2 sw=2 sts=2 et cindent: */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/. */

/* THIS FILE IS AUTOGENERATED FROM FormDataEvent.webidl BY Codegen.py - DO NOT EDIT */

#include "EventBinding.h"
#include "FormDataEvent.h"
#include "FormDataEventBinding.h"
#include "js/GCAPI.h"
#include "mozilla/HoldDropJSObjects.h"
#include "mozilla/dom/BindingCallContext.h"
#include "mozilla/dom/FormData.h"
#include "mozilla/dom/FormDataEvent.h"
#include "mozilla/dom/Nullable.h"
#include "mozilla/dom/PrimitiveConversions.h"

namespace mozilla::dom {


NS_IMPL_CYCLE_COLLECTION_CLASS(FormDataEvent)

NS_IMPL_ADDREF_INHERITED(FormDataEvent, Event)
NS_IMPL_RELEASE_INHERITED(FormDataEvent, Event)

NS_IMPL_CYCLE_COLLECTION_TRAVERSE_BEGIN_INHERITED(FormDataEvent, Event)
  NS_IMPL_CYCLE_COLLECTION_TRAVERSE(mFormData)
NS_IMPL_CYCLE_COLLECTION_TRAVERSE_END

NS_IMPL_CYCLE_COLLECTION_TRACE_BEGIN_INHERITED(FormDataEvent, Event)
NS_IMPL_CYCLE_COLLECTION_TRACE_END

NS_IMPL_CYCLE_COLLECTION_UNLINK_BEGIN_INHERITED(FormDataEvent, Event)
  NS_IMPL_CYCLE_COLLECTION_UNLINK(mFormData)
NS_IMPL_CYCLE_COLLECTION_UNLINK_END

NS_INTERFACE_MAP_BEGIN_CYCLE_COLLECTION(FormDataEvent)
NS_INTERFACE_MAP_END_INHERITING(Event)

FormDataEvent::FormDataEvent(mozilla::dom::EventTarget* aOwner)
  : Event(aOwner, nullptr, nullptr)
{
}

FormDataEvent::~FormDataEvent()
{
}

FormDataEvent*
FormDataEvent::AsFormDataEvent()
{
  return this;
}

JSObject*
FormDataEvent::WrapObjectInternal(JSContext* aCx, JS::Handle<JSObject*> aGivenProto)
{
  return FormDataEvent_Binding::Wrap(aCx, this, aGivenProto);
}

already_AddRefed<FormDataEvent>
FormDataEvent::Constructor(mozilla::dom::EventTarget* aOwner, const nsAString& aType, const FormDataEventInit& aEventInitDict)
{
  RefPtr<FormDataEvent> e = new FormDataEvent(aOwner);
  bool trusted = e->Init(aOwner);
  e->InitEvent(aType, aEventInitDict.mBubbles, aEventInitDict.mCancelable);
  e->mFormData = aEventInitDict.mFormData;
  e->SetTrusted(trusted);
  e->SetComposed(aEventInitDict.mComposed);
  return e.forget();
}

already_AddRefed<FormDataEvent>
FormDataEvent::Constructor(const GlobalObject& aGlobal, const nsAString& aType, const FormDataEventInit& aEventInitDict)
{
  nsCOMPtr<mozilla::dom::EventTarget> owner = do_QueryInterface(aGlobal.GetAsSupports());
  return Constructor(owner, aType, aEventInitDict);
}

FormData*
FormDataEvent::GetFormData() const
{
  return mFormData;
}


} // namespace mozilla::dom
