/* THIS FILE IS AUTOGENERATED FROM ExtensionRuntime.webidl BY Codegen.py - DO NOT EDIT */

#include <type_traits>
#include "ExtensionRuntimeBinding.h"
#include "FunctionBinding.h"
#include "MainThreadUtils.h"
#include "WrapperFactory.h"
#include "js/CallAndConstruct.h"
#include "js/Exception.h"
#include "js/MapAndSet.h"
#include "js/Object.h"
#include "js/PropertyAndElement.h"
#include "js/PropertyDescriptor.h"
#include "js/experimental/JitInfo.h"
#include "mozilla/OwningNonNull.h"
#include "mozilla/ProfilerLabels.h"
#include "mozilla/dom/BindingCallContext.h"
#include "mozilla/dom/BindingUtils.h"
#include "mozilla/dom/DOMJSClass.h"
#include "mozilla/dom/NonRefcountedDOMObject.h"
#include "mozilla/extensions/ExtensionEventManager.h"
#include "mozilla/extensions/ExtensionPort.h"
#include "mozilla/extensions/ExtensionRuntime.h"
#include "nsThreadUtils.h"

namespace mozilla::dom {

namespace binding_detail {}; // Just to make sure it's known as a namespace
using namespace mozilla::dom::binding_detail;


namespace ExtensionRuntime_Binding {

MOZ_CAN_RUN_SCRIPT static bool
openOptionsPage(JSContext* cx_, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  BindingCallContext cx(cx_, "ExtensionRuntime.openOptionsPage");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "ExtensionRuntime", "openOptionsPage", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::extensions::ExtensionRuntime*>(void_self);
  Optional<OwningNonNull<Function>> arg0;
  if (args.hasDefined(0)) {
    arg0.Construct();
    if (args[0].isObject()) {
      if (JS::IsCallable(&args[0].toObject())) {
      { // scope for tempRoot and tempGlobalRoot if needed
        JS::Rooted<JSObject*> tempRoot(cx, &args[0].toObject());
        JS::Rooted<JSObject*> tempGlobalRoot(cx, JS::CurrentGlobalOrNull(cx));
        arg0.Value() = new Function(cx, tempRoot, tempGlobalRoot, GetIncumbentGlobal());
      }
      } else {
        cx.ThrowErrorMessage<MSG_NOT_CALLABLE>("Argument 1");
        return false;
      }
    } else {
      cx.ThrowErrorMessage<MSG_NOT_OBJECT>("Argument 1");
      return false;
    }
  }
  // Collecting all args js values into the single sequence argument
  // passed to the webextensions stub method.
  //
  // NOTE: The stub method will receive the original non-normalized js values,
  // but those arguments will still be normalized on the main thread by the
  // WebExtensions API request handler using the same JSONSchema defnition
  // used by the non-webIDL webextensions API bindings.
  AutoSequence<JS::Value> args_sequence;
  SequenceRooter<JS::Value> args_sequence_holder(cx, &args_sequence);

  // maximum number of arguments expected by the WebExtensions API method
  // excluding the last optional chrome-compatible callback argument (which
  // is being passed to the stub method as a separate additional argument).
  uint32_t maxArgsSequenceLen = 0;

  uint32_t sequenceArgsLen = args.length() <= maxArgsSequenceLen ?
    args.length() : maxArgsSequenceLen;

  if (sequenceArgsLen > 0) {
    if (!args_sequence.SetCapacity(sequenceArgsLen, mozilla::fallible)) {
      JS_ReportOutOfMemory(cx);
      return false;
    }
    for (uint32_t argIdx = 0; argIdx < sequenceArgsLen; ++argIdx) {
      // OK to do infallible append here, since we ensured capacity already.
      JS::Value& slot = *args_sequence.AppendElement();
      slot = args[argIdx];
    }
  }
  FastErrorResult rv;
  JS::Rooted<JS::Value> result(cx);
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->CallWebExtMethodAsync(cx, u"openOptionsPage"_ns, Constify(args_sequence), MOZ_KnownLive(NonNullHelper(Constify(arg0))), &result, rv))>, "Should be returning void here");
  MOZ_KnownLive(self)->CallWebExtMethodAsync(cx, u"openOptionsPage"_ns, Constify(args_sequence), MOZ_KnownLive(NonNullHelper(Constify(arg0))), &result, rv);
  if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "ExtensionRuntime.openOptionsPage"))) {
    return false;
  }
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  JS::ExposeValueToActiveJS(result);
  args.rval().set(result);
  if (!MaybeWrapValue(cx, args.rval())) {
    return false;
  }
  return true;
}

static const JSJitInfo openOptionsPage_methodinfo = {
  { (JSJitGetterOp)openOptionsPage },
  { prototypes::id::ExtensionRuntime },
  { PrototypeTraits<prototypes::id::ExtensionRuntime>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNKNOWN,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
getManifest(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "ExtensionRuntime", "getManifest", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::extensions::ExtensionRuntime*>(void_self);
  // Collecting all args js values into the single sequence argument
  // passed to the webextensions stub method.
  //
  // NOTE: The stub method will receive the original non-normalized js values,
  // but those arguments will still be normalized on the main thread by the
  // WebExtensions API request handler using the same JSONSchema defnition
  // used by the non-webIDL webextensions API bindings.
  AutoSequence<JS::Value> args_sequence;
  SequenceRooter<JS::Value> args_sequence_holder(cx, &args_sequence);

  // maximum number of arguments expected by the WebExtensions API method
  // excluding the last optional chrome-compatible callback argument (which
  // is being passed to the stub method as a separate additional argument).
  uint32_t maxArgsSequenceLen = 0;

  uint32_t sequenceArgsLen = args.length() <= maxArgsSequenceLen ?
    args.length() : maxArgsSequenceLen;

  if (sequenceArgsLen > 0) {
    if (!args_sequence.SetCapacity(sequenceArgsLen, mozilla::fallible)) {
      JS_ReportOutOfMemory(cx);
      return false;
    }
    for (uint32_t argIdx = 0; argIdx < sequenceArgsLen; ++argIdx) {
      // OK to do infallible append here, since we ensured capacity already.
      JS::Value& slot = *args_sequence.AppendElement();
      slot = args[argIdx];
    }
  }
  FastErrorResult rv;
  JS::Rooted<JS::Value> result(cx);
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->CallWebExtMethod(cx, u"getManifest"_ns, Constify(args_sequence), &result, rv))>, "Should be returning void here");
  MOZ_KnownLive(self)->CallWebExtMethod(cx, u"getManifest"_ns, Constify(args_sequence), &result, rv);
  if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "ExtensionRuntime.getManifest"))) {
    return false;
  }
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  JS::ExposeValueToActiveJS(result);
  args.rval().set(result);
  if (!MaybeWrapValue(cx, args.rval())) {
    return false;
  }
  return true;
}

static const JSJitInfo getManifest_methodinfo = {
  { (JSJitGetterOp)getManifest },
  { prototypes::id::ExtensionRuntime },
  { PrototypeTraits<prototypes::id::ExtensionRuntime>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNKNOWN,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
getURL(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "ExtensionRuntime", "getURL", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::extensions::ExtensionRuntime*>(void_self);
  if (!args.requireAtLeast(cx, "ExtensionRuntime.getURL", 1)) {
    return false;
  }
  binding_detail::FakeString<char16_t> arg0;
  if (!ConvertJSValueToString(cx, args[0], eStringify, eStringify, arg0)) {
    return false;
  }
  // Collecting all args js values into the single sequence argument
  // passed to the webextensions stub method.
  //
  // NOTE: The stub method will receive the original non-normalized js values,
  // but those arguments will still be normalized on the main thread by the
  // WebExtensions API request handler using the same JSONSchema defnition
  // used by the non-webIDL webextensions API bindings.
  AutoSequence<JS::Value> args_sequence;
  SequenceRooter<JS::Value> args_sequence_holder(cx, &args_sequence);

  // maximum number of arguments expected by the WebExtensions API method
  // excluding the last optional chrome-compatible callback argument (which
  // is being passed to the stub method as a separate additional argument).
  uint32_t maxArgsSequenceLen = 1;

  uint32_t sequenceArgsLen = args.length() <= maxArgsSequenceLen ?
    args.length() : maxArgsSequenceLen;

  if (sequenceArgsLen > 0) {
    if (!args_sequence.SetCapacity(sequenceArgsLen, mozilla::fallible)) {
      JS_ReportOutOfMemory(cx);
      return false;
    }
    for (uint32_t argIdx = 0; argIdx < sequenceArgsLen; ++argIdx) {
      // OK to do infallible append here, since we ensured capacity already.
      JS::Value& slot = *args_sequence.AppendElement();
      slot = args[argIdx];
    }
  }
  FastErrorResult rv;
  DOMString result;
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->CallWebExtMethodReturnsString(cx, u"getURL"_ns, Constify(args_sequence), result, rv))>, "Should be returning void here");
  MOZ_KnownLive(self)->CallWebExtMethodReturnsString(cx, u"getURL"_ns, Constify(args_sequence), result, rv);
  if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "ExtensionRuntime.getURL"))) {
    return false;
  }
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (!xpc::NonVoidStringToJsval(cx, result, args.rval())) {
    return false;
  }
  return true;
}

static const JSJitInfo getURL_methodinfo = {
  { (JSJitGetterOp)getURL },
  { prototypes::id::ExtensionRuntime },
  { PrototypeTraits<prototypes::id::ExtensionRuntime>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
setUninstallURL(JSContext* cx_, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  BindingCallContext cx(cx_, "ExtensionRuntime.setUninstallURL");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "ExtensionRuntime", "setUninstallURL", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::extensions::ExtensionRuntime*>(void_self);
  unsigned argcount = std::min(args.length(), 2u);
  switch (argcount) {
    case 0: {
      Optional<OwningNonNull<Function>> arg0;
      if (args.hasDefined(0)) {
        arg0.Construct();
        if (args[0].isObject()) {
          if (JS::IsCallable(&args[0].toObject())) {
          { // scope for tempRoot and tempGlobalRoot if needed
            JS::Rooted<JSObject*> tempRoot(cx, &args[0].toObject());
            JS::Rooted<JSObject*> tempGlobalRoot(cx, JS::CurrentGlobalOrNull(cx));
            arg0.Value() = new Function(cx, tempRoot, tempGlobalRoot, GetIncumbentGlobal());
          }
          } else {
            cx.ThrowErrorMessage<MSG_NOT_CALLABLE>("Argument 1");
            return false;
          }
        } else {
          cx.ThrowErrorMessage<MSG_NOT_OBJECT>("Argument 1");
          return false;
        }
      }
      // Collecting all args js values into the single sequence argument
      // passed to the webextensions stub method.
      //
      // NOTE: The stub method will receive the original non-normalized js values,
      // but those arguments will still be normalized on the main thread by the
      // WebExtensions API request handler using the same JSONSchema defnition
      // used by the non-webIDL webextensions API bindings.
      AutoSequence<JS::Value> args_sequence;
      SequenceRooter<JS::Value> args_sequence_holder(cx, &args_sequence);

      // maximum number of arguments expected by the WebExtensions API method
      // excluding the last optional chrome-compatible callback argument (which
      // is being passed to the stub method as a separate additional argument).
      uint32_t maxArgsSequenceLen = 0;

      uint32_t sequenceArgsLen = args.length() <= maxArgsSequenceLen ?
        args.length() : maxArgsSequenceLen;

      if (sequenceArgsLen > 0) {
        if (!args_sequence.SetCapacity(sequenceArgsLen, mozilla::fallible)) {
          JS_ReportOutOfMemory(cx);
          return false;
        }
        for (uint32_t argIdx = 0; argIdx < sequenceArgsLen; ++argIdx) {
          // OK to do infallible append here, since we ensured capacity already.
          JS::Value& slot = *args_sequence.AppendElement();
          slot = args[argIdx];
        }
      }
      FastErrorResult rv;
      JS::Rooted<JS::Value> result(cx);
      // NOTE: This assert does NOT call the function.
      static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->CallWebExtMethodAsync(cx, u"setUninstallURL"_ns, Constify(args_sequence), MOZ_KnownLive(NonNullHelper(Constify(arg0))), &result, rv))>, "Should be returning void here");
      MOZ_KnownLive(self)->CallWebExtMethodAsync(cx, u"setUninstallURL"_ns, Constify(args_sequence), MOZ_KnownLive(NonNullHelper(Constify(arg0))), &result, rv);
      if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "ExtensionRuntime.setUninstallURL"))) {
        return false;
      }
      MOZ_ASSERT(!JS_IsExceptionPending(cx));
      JS::ExposeValueToActiveJS(result);
      args.rval().set(result);
      if (!MaybeWrapValue(cx, args.rval())) {
        return false;
      }
      return true;
      break;
    }
    case 1: {
      if (args[0].isUndefined()) {
        Optional<OwningNonNull<Function>> arg0;
        if (args.hasDefined(0)) {
          arg0.Construct();
          if (args[0].isObject()) {
            if (JS::IsCallable(&args[0].toObject())) {
            { // scope for tempRoot and tempGlobalRoot if needed
              JS::Rooted<JSObject*> tempRoot(cx, &args[0].toObject());
              JS::Rooted<JSObject*> tempGlobalRoot(cx, JS::CurrentGlobalOrNull(cx));
              arg0.Value() = new Function(cx, tempRoot, tempGlobalRoot, GetIncumbentGlobal());
            }
            } else {
              cx.ThrowErrorMessage<MSG_NOT_CALLABLE>("Argument 1");
              return false;
            }
          } else {
            cx.ThrowErrorMessage<MSG_NOT_OBJECT>("Argument 1");
            return false;
          }
        }
        // Collecting all args js values into the single sequence argument
        // passed to the webextensions stub method.
        //
        // NOTE: The stub method will receive the original non-normalized js values,
        // but those arguments will still be normalized on the main thread by the
        // WebExtensions API request handler using the same JSONSchema defnition
        // used by the non-webIDL webextensions API bindings.
        AutoSequence<JS::Value> args_sequence;
        SequenceRooter<JS::Value> args_sequence_holder(cx, &args_sequence);

        // maximum number of arguments expected by the WebExtensions API method
        // excluding the last optional chrome-compatible callback argument (which
        // is being passed to the stub method as a separate additional argument).
        uint32_t maxArgsSequenceLen = 0;

        uint32_t sequenceArgsLen = args.length() <= maxArgsSequenceLen ?
          args.length() : maxArgsSequenceLen;

        if (sequenceArgsLen > 0) {
          if (!args_sequence.SetCapacity(sequenceArgsLen, mozilla::fallible)) {
            JS_ReportOutOfMemory(cx);
            return false;
          }
          for (uint32_t argIdx = 0; argIdx < sequenceArgsLen; ++argIdx) {
            // OK to do infallible append here, since we ensured capacity already.
            JS::Value& slot = *args_sequence.AppendElement();
            slot = args[argIdx];
          }
        }
        FastErrorResult rv;
        JS::Rooted<JS::Value> result(cx);
        // NOTE: This assert does NOT call the function.
        static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->CallWebExtMethodAsync(cx, u"setUninstallURL"_ns, Constify(args_sequence), MOZ_KnownLive(NonNullHelper(Constify(arg0))), &result, rv))>, "Should be returning void here");
        MOZ_KnownLive(self)->CallWebExtMethodAsync(cx, u"setUninstallURL"_ns, Constify(args_sequence), MOZ_KnownLive(NonNullHelper(Constify(arg0))), &result, rv);
        if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "ExtensionRuntime.setUninstallURL"))) {
          return false;
        }
        MOZ_ASSERT(!JS_IsExceptionPending(cx));
        JS::ExposeValueToActiveJS(result);
        args.rval().set(result);
        if (!MaybeWrapValue(cx, args.rval())) {
          return false;
        }
        return true;
      }
      if (args[0].isObject()) {
        do {
          Optional<OwningNonNull<Function>> arg0;
          if (args.hasDefined(0)) {
            arg0.Construct();
            if (JS::IsCallable(&args[0].toObject())) {
            { // scope for tempRoot and tempGlobalRoot if needed
              JS::Rooted<JSObject*> tempRoot(cx, &args[0].toObject());
              JS::Rooted<JSObject*> tempGlobalRoot(cx, JS::CurrentGlobalOrNull(cx));
              arg0.Value() = new Function(cx, tempRoot, tempGlobalRoot, GetIncumbentGlobal());
            }
            } else {
              break;
            }
          }
          // Collecting all args js values into the single sequence argument
          // passed to the webextensions stub method.
          //
          // NOTE: The stub method will receive the original non-normalized js values,
          // but those arguments will still be normalized on the main thread by the
          // WebExtensions API request handler using the same JSONSchema defnition
          // used by the non-webIDL webextensions API bindings.
          AutoSequence<JS::Value> args_sequence;
          SequenceRooter<JS::Value> args_sequence_holder(cx, &args_sequence);

          // maximum number of arguments expected by the WebExtensions API method
          // excluding the last optional chrome-compatible callback argument (which
          // is being passed to the stub method as a separate additional argument).
          uint32_t maxArgsSequenceLen = 0;

          uint32_t sequenceArgsLen = args.length() <= maxArgsSequenceLen ?
            args.length() : maxArgsSequenceLen;

          if (sequenceArgsLen > 0) {
            if (!args_sequence.SetCapacity(sequenceArgsLen, mozilla::fallible)) {
              JS_ReportOutOfMemory(cx);
              return false;
            }
            for (uint32_t argIdx = 0; argIdx < sequenceArgsLen; ++argIdx) {
              // OK to do infallible append here, since we ensured capacity already.
              JS::Value& slot = *args_sequence.AppendElement();
              slot = args[argIdx];
            }
          }
          FastErrorResult rv;
          JS::Rooted<JS::Value> result(cx);
          // NOTE: This assert does NOT call the function.
          static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->CallWebExtMethodAsync(cx, u"setUninstallURL"_ns, Constify(args_sequence), MOZ_KnownLive(NonNullHelper(Constify(arg0))), &result, rv))>, "Should be returning void here");
          MOZ_KnownLive(self)->CallWebExtMethodAsync(cx, u"setUninstallURL"_ns, Constify(args_sequence), MOZ_KnownLive(NonNullHelper(Constify(arg0))), &result, rv);
          if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "ExtensionRuntime.setUninstallURL"))) {
            return false;
          }
          MOZ_ASSERT(!JS_IsExceptionPending(cx));
          JS::ExposeValueToActiveJS(result);
          args.rval().set(result);
          if (!MaybeWrapValue(cx, args.rval())) {
            return false;
          }
          return true;
        } while (false);
      }
      binding_detail::FakeString<char16_t> arg0;
      if (!ConvertJSValueToString(cx, args[0], eStringify, eStringify, arg0)) {
        return false;
      }
      Optional<OwningNonNull<Function>> arg1;
      if (args.hasDefined(1)) {
        arg1.Construct();
        if (args[1].isObject()) {
          if (JS::IsCallable(&args[1].toObject())) {
          { // scope for tempRoot and tempGlobalRoot if needed
            JS::Rooted<JSObject*> tempRoot(cx, &args[1].toObject());
            JS::Rooted<JSObject*> tempGlobalRoot(cx, JS::CurrentGlobalOrNull(cx));
            arg1.Value() = new Function(cx, tempRoot, tempGlobalRoot, GetIncumbentGlobal());
          }
          } else {
            cx.ThrowErrorMessage<MSG_NOT_CALLABLE>("Argument 2");
            return false;
          }
        } else {
          cx.ThrowErrorMessage<MSG_NOT_OBJECT>("Argument 2");
          return false;
        }
      }
      // Collecting all args js values into the single sequence argument
      // passed to the webextensions stub method.
      //
      // NOTE: The stub method will receive the original non-normalized js values,
      // but those arguments will still be normalized on the main thread by the
      // WebExtensions API request handler using the same JSONSchema defnition
      // used by the non-webIDL webextensions API bindings.
      AutoSequence<JS::Value> args_sequence;
      SequenceRooter<JS::Value> args_sequence_holder(cx, &args_sequence);

      // maximum number of arguments expected by the WebExtensions API method
      // excluding the last optional chrome-compatible callback argument (which
      // is being passed to the stub method as a separate additional argument).
      uint32_t maxArgsSequenceLen = 1;

      uint32_t sequenceArgsLen = args.length() <= maxArgsSequenceLen ?
        args.length() : maxArgsSequenceLen;

      if (sequenceArgsLen > 0) {
        if (!args_sequence.SetCapacity(sequenceArgsLen, mozilla::fallible)) {
          JS_ReportOutOfMemory(cx);
          return false;
        }
        for (uint32_t argIdx = 0; argIdx < sequenceArgsLen; ++argIdx) {
          // OK to do infallible append here, since we ensured capacity already.
          JS::Value& slot = *args_sequence.AppendElement();
          slot = args[argIdx];
        }
      }
      FastErrorResult rv;
      JS::Rooted<JS::Value> result(cx);
      // NOTE: This assert does NOT call the function.
      static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->CallWebExtMethodAsync(cx, u"setUninstallURL"_ns, Constify(args_sequence), MOZ_KnownLive(NonNullHelper(Constify(arg1))), &result, rv))>, "Should be returning void here");
      MOZ_KnownLive(self)->CallWebExtMethodAsync(cx, u"setUninstallURL"_ns, Constify(args_sequence), MOZ_KnownLive(NonNullHelper(Constify(arg1))), &result, rv);
      if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "ExtensionRuntime.setUninstallURL"))) {
        return false;
      }
      MOZ_ASSERT(!JS_IsExceptionPending(cx));
      JS::ExposeValueToActiveJS(result);
      args.rval().set(result);
      if (!MaybeWrapValue(cx, args.rval())) {
        return false;
      }
      return true;
      break;
    }
    case 2: {
      binding_detail::FakeString<char16_t> arg0;
      if (!ConvertJSValueToString(cx, args[0], eStringify, eStringify, arg0)) {
        return false;
      }
      Optional<OwningNonNull<Function>> arg1;
      if (args.hasDefined(1)) {
        arg1.Construct();
        if (args[1].isObject()) {
          if (JS::IsCallable(&args[1].toObject())) {
          { // scope for tempRoot and tempGlobalRoot if needed
            JS::Rooted<JSObject*> tempRoot(cx, &args[1].toObject());
            JS::Rooted<JSObject*> tempGlobalRoot(cx, JS::CurrentGlobalOrNull(cx));
            arg1.Value() = new Function(cx, tempRoot, tempGlobalRoot, GetIncumbentGlobal());
          }
          } else {
            cx.ThrowErrorMessage<MSG_NOT_CALLABLE>("Argument 2");
            return false;
          }
        } else {
          cx.ThrowErrorMessage<MSG_NOT_OBJECT>("Argument 2");
          return false;
        }
      }
      // Collecting all args js values into the single sequence argument
      // passed to the webextensions stub method.
      //
      // NOTE: The stub method will receive the original non-normalized js values,
      // but those arguments will still be normalized on the main thread by the
      // WebExtensions API request handler using the same JSONSchema defnition
      // used by the non-webIDL webextensions API bindings.
      AutoSequence<JS::Value> args_sequence;
      SequenceRooter<JS::Value> args_sequence_holder(cx, &args_sequence);

      // maximum number of arguments expected by the WebExtensions API method
      // excluding the last optional chrome-compatible callback argument (which
      // is being passed to the stub method as a separate additional argument).
      uint32_t maxArgsSequenceLen = 1;

      uint32_t sequenceArgsLen = args.length() <= maxArgsSequenceLen ?
        args.length() : maxArgsSequenceLen;

      if (sequenceArgsLen > 0) {
        if (!args_sequence.SetCapacity(sequenceArgsLen, mozilla::fallible)) {
          JS_ReportOutOfMemory(cx);
          return false;
        }
        for (uint32_t argIdx = 0; argIdx < sequenceArgsLen; ++argIdx) {
          // OK to do infallible append here, since we ensured capacity already.
          JS::Value& slot = *args_sequence.AppendElement();
          slot = args[argIdx];
        }
      }
      FastErrorResult rv;
      JS::Rooted<JS::Value> result(cx);
      // NOTE: This assert does NOT call the function.
      static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->CallWebExtMethodAsync(cx, u"setUninstallURL"_ns, Constify(args_sequence), MOZ_KnownLive(NonNullHelper(Constify(arg1))), &result, rv))>, "Should be returning void here");
      MOZ_KnownLive(self)->CallWebExtMethodAsync(cx, u"setUninstallURL"_ns, Constify(args_sequence), MOZ_KnownLive(NonNullHelper(Constify(arg1))), &result, rv);
      if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "ExtensionRuntime.setUninstallURL"))) {
        return false;
      }
      MOZ_ASSERT(!JS_IsExceptionPending(cx));
      JS::ExposeValueToActiveJS(result);
      args.rval().set(result);
      if (!MaybeWrapValue(cx, args.rval())) {
        return false;
      }
      return true;
      break;
    }
    default: {
      // Using nsPrintfCString here would require including that
      // header.  Let's not worry about it.
      nsAutoCString argCountStr;
      argCountStr.AppendPrintf("%u", args.length());
      return cx.ThrowErrorMessage<MSG_INVALID_OVERLOAD_ARGCOUNT>(argCountStr.get());
    }
  }
  MOZ_CRASH("We have an always-returning default case");
  return false;
}

static const JSJitInfo setUninstallURL_methodinfo = {
  { (JSJitGetterOp)setUninstallURL },
  { prototypes::id::ExtensionRuntime },
  { PrototypeTraits<prototypes::id::ExtensionRuntime>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNKNOWN,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
reload(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "ExtensionRuntime", "reload", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::extensions::ExtensionRuntime*>(void_self);
  // Collecting all args js values into the single sequence argument
  // passed to the webextensions stub method.
  //
  // NOTE: The stub method will receive the original non-normalized js values,
  // but those arguments will still be normalized on the main thread by the
  // WebExtensions API request handler using the same JSONSchema defnition
  // used by the non-webIDL webextensions API bindings.
  AutoSequence<JS::Value> args_sequence;
  SequenceRooter<JS::Value> args_sequence_holder(cx, &args_sequence);

  // maximum number of arguments expected by the WebExtensions API method
  // excluding the last optional chrome-compatible callback argument (which
  // is being passed to the stub method as a separate additional argument).
  uint32_t maxArgsSequenceLen = 0;

  uint32_t sequenceArgsLen = args.length() <= maxArgsSequenceLen ?
    args.length() : maxArgsSequenceLen;

  if (sequenceArgsLen > 0) {
    if (!args_sequence.SetCapacity(sequenceArgsLen, mozilla::fallible)) {
      JS_ReportOutOfMemory(cx);
      return false;
    }
    for (uint32_t argIdx = 0; argIdx < sequenceArgsLen; ++argIdx) {
      // OK to do infallible append here, since we ensured capacity already.
      JS::Value& slot = *args_sequence.AppendElement();
      slot = args[argIdx];
    }
  }
  FastErrorResult rv;
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->CallWebExtMethodNoReturn(cx, u"reload"_ns, Constify(args_sequence), rv))>, "Should be returning void here");
  MOZ_KnownLive(self)->CallWebExtMethodNoReturn(cx, u"reload"_ns, Constify(args_sequence), rv);
  if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "ExtensionRuntime.reload"))) {
    return false;
  }
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setUndefined();
  return true;
}

static const JSJitInfo reload_methodinfo = {
  { (JSJitGetterOp)reload },
  { prototypes::id::ExtensionRuntime },
  { PrototypeTraits<prototypes::id::ExtensionRuntime>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
connect(JSContext* cx_, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  BindingCallContext cx(cx_, "ExtensionRuntime.connect");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "ExtensionRuntime", "connect", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::extensions::ExtensionRuntime*>(void_self);
  unsigned argcount = std::min(args.length(), 2u);
  switch (argcount) {
    case 0: {
      // Collecting all args js values into the single sequence argument
      // passed to the webextensions stub method.
      //
      // NOTE: The stub method will receive the original non-normalized js values,
      // but those arguments will still be normalized on the main thread by the
      // WebExtensions API request handler using the same JSONSchema defnition
      // used by the non-webIDL webextensions API bindings.
      AutoSequence<JS::Value> args_sequence;
      SequenceRooter<JS::Value> args_sequence_holder(cx, &args_sequence);

      // maximum number of arguments expected by the WebExtensions API method
      // excluding the last optional chrome-compatible callback argument (which
      // is being passed to the stub method as a separate additional argument).
      uint32_t maxArgsSequenceLen = 0;

      uint32_t sequenceArgsLen = args.length() <= maxArgsSequenceLen ?
        args.length() : maxArgsSequenceLen;

      if (sequenceArgsLen > 0) {
        if (!args_sequence.SetCapacity(sequenceArgsLen, mozilla::fallible)) {
          JS_ReportOutOfMemory(cx);
          return false;
        }
        for (uint32_t argIdx = 0; argIdx < sequenceArgsLen; ++argIdx) {
          // OK to do infallible append here, since we ensured capacity already.
          JS::Value& slot = *args_sequence.AppendElement();
          slot = args[argIdx];
        }
      }
      FastErrorResult rv;
      auto result(StrongOrRawPtr<mozilla::extensions::ExtensionPort>(MOZ_KnownLive(self)->CallWebExtMethodReturnsPort(cx, u"connect"_ns, Constify(args_sequence), rv)));
      if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "ExtensionRuntime.connect"))) {
        return false;
      }
      MOZ_ASSERT(!JS_IsExceptionPending(cx));
      if (!GetOrCreateDOMReflector(cx, result, args.rval())) {
        MOZ_ASSERT(JS_IsExceptionPending(cx));
        return false;
      }
      return true;
      break;
    }
    case 1: {
      JS::Rooted<JS::Value> arg0(cx);
      arg0 = args[0];
      // Collecting all args js values into the single sequence argument
      // passed to the webextensions stub method.
      //
      // NOTE: The stub method will receive the original non-normalized js values,
      // but those arguments will still be normalized on the main thread by the
      // WebExtensions API request handler using the same JSONSchema defnition
      // used by the non-webIDL webextensions API bindings.
      AutoSequence<JS::Value> args_sequence;
      SequenceRooter<JS::Value> args_sequence_holder(cx, &args_sequence);

      // maximum number of arguments expected by the WebExtensions API method
      // excluding the last optional chrome-compatible callback argument (which
      // is being passed to the stub method as a separate additional argument).
      uint32_t maxArgsSequenceLen = 1;

      uint32_t sequenceArgsLen = args.length() <= maxArgsSequenceLen ?
        args.length() : maxArgsSequenceLen;

      if (sequenceArgsLen > 0) {
        if (!args_sequence.SetCapacity(sequenceArgsLen, mozilla::fallible)) {
          JS_ReportOutOfMemory(cx);
          return false;
        }
        for (uint32_t argIdx = 0; argIdx < sequenceArgsLen; ++argIdx) {
          // OK to do infallible append here, since we ensured capacity already.
          JS::Value& slot = *args_sequence.AppendElement();
          slot = args[argIdx];
        }
      }
      FastErrorResult rv;
      auto result(StrongOrRawPtr<mozilla::extensions::ExtensionPort>(MOZ_KnownLive(self)->CallWebExtMethodReturnsPort(cx, u"connect"_ns, Constify(args_sequence), rv)));
      if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "ExtensionRuntime.connect"))) {
        return false;
      }
      MOZ_ASSERT(!JS_IsExceptionPending(cx));
      if (!GetOrCreateDOMReflector(cx, result, args.rval())) {
        MOZ_ASSERT(JS_IsExceptionPending(cx));
        return false;
      }
      return true;
      break;
    }
    case 2: {
      binding_detail::FakeString<char16_t> arg0;
      if (!ConvertJSValueToString(cx, args[0], eStringify, eStringify, arg0)) {
        return false;
      }
      JS::Rooted<JS::Value> arg1(cx);
      arg1 = args[1];
      // Collecting all args js values into the single sequence argument
      // passed to the webextensions stub method.
      //
      // NOTE: The stub method will receive the original non-normalized js values,
      // but those arguments will still be normalized on the main thread by the
      // WebExtensions API request handler using the same JSONSchema defnition
      // used by the non-webIDL webextensions API bindings.
      AutoSequence<JS::Value> args_sequence;
      SequenceRooter<JS::Value> args_sequence_holder(cx, &args_sequence);

      // maximum number of arguments expected by the WebExtensions API method
      // excluding the last optional chrome-compatible callback argument (which
      // is being passed to the stub method as a separate additional argument).
      uint32_t maxArgsSequenceLen = 2;

      uint32_t sequenceArgsLen = args.length() <= maxArgsSequenceLen ?
        args.length() : maxArgsSequenceLen;

      if (sequenceArgsLen > 0) {
        if (!args_sequence.SetCapacity(sequenceArgsLen, mozilla::fallible)) {
          JS_ReportOutOfMemory(cx);
          return false;
        }
        for (uint32_t argIdx = 0; argIdx < sequenceArgsLen; ++argIdx) {
          // OK to do infallible append here, since we ensured capacity already.
          JS::Value& slot = *args_sequence.AppendElement();
          slot = args[argIdx];
        }
      }
      FastErrorResult rv;
      auto result(StrongOrRawPtr<mozilla::extensions::ExtensionPort>(MOZ_KnownLive(self)->CallWebExtMethodReturnsPort(cx, u"connect"_ns, Constify(args_sequence), rv)));
      if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "ExtensionRuntime.connect"))) {
        return false;
      }
      MOZ_ASSERT(!JS_IsExceptionPending(cx));
      if (!GetOrCreateDOMReflector(cx, result, args.rval())) {
        MOZ_ASSERT(JS_IsExceptionPending(cx));
        return false;
      }
      return true;
      break;
    }
    default: {
      // Using nsPrintfCString here would require including that
      // header.  Let's not worry about it.
      nsAutoCString argCountStr;
      argCountStr.AppendPrintf("%u", args.length());
      return cx.ThrowErrorMessage<MSG_INVALID_OVERLOAD_ARGCOUNT>(argCountStr.get());
    }
  }
  MOZ_CRASH("We have an always-returning default case");
  return false;
}

static const JSJitInfo connect_methodinfo = {
  { (JSJitGetterOp)connect },
  { prototypes::id::ExtensionRuntime },
  { PrototypeTraits<prototypes::id::ExtensionRuntime>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_OBJECT,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
connectNative(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "ExtensionRuntime", "connectNative", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::extensions::ExtensionRuntime*>(void_self);
  if (!args.requireAtLeast(cx, "ExtensionRuntime.connectNative", 1)) {
    return false;
  }
  binding_detail::FakeString<char16_t> arg0;
  if (!ConvertJSValueToString(cx, args[0], eStringify, eStringify, arg0)) {
    return false;
  }
  // Collecting all args js values into the single sequence argument
  // passed to the webextensions stub method.
  //
  // NOTE: The stub method will receive the original non-normalized js values,
  // but those arguments will still be normalized on the main thread by the
  // WebExtensions API request handler using the same JSONSchema defnition
  // used by the non-webIDL webextensions API bindings.
  AutoSequence<JS::Value> args_sequence;
  SequenceRooter<JS::Value> args_sequence_holder(cx, &args_sequence);

  // maximum number of arguments expected by the WebExtensions API method
  // excluding the last optional chrome-compatible callback argument (which
  // is being passed to the stub method as a separate additional argument).
  uint32_t maxArgsSequenceLen = 1;

  uint32_t sequenceArgsLen = args.length() <= maxArgsSequenceLen ?
    args.length() : maxArgsSequenceLen;

  if (sequenceArgsLen > 0) {
    if (!args_sequence.SetCapacity(sequenceArgsLen, mozilla::fallible)) {
      JS_ReportOutOfMemory(cx);
      return false;
    }
    for (uint32_t argIdx = 0; argIdx < sequenceArgsLen; ++argIdx) {
      // OK to do infallible append here, since we ensured capacity already.
      JS::Value& slot = *args_sequence.AppendElement();
      slot = args[argIdx];
    }
  }
  FastErrorResult rv;
  auto result(StrongOrRawPtr<mozilla::extensions::ExtensionPort>(MOZ_KnownLive(self)->CallWebExtMethodReturnsPort(cx, u"connectNative"_ns, Constify(args_sequence), rv)));
  if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "ExtensionRuntime.connectNative"))) {
    return false;
  }
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (!GetOrCreateDOMReflector(cx, result, args.rval())) {
    MOZ_ASSERT(JS_IsExceptionPending(cx));
    return false;
  }
  return true;
}

static const JSJitInfo connectNative_methodinfo = {
  { (JSJitGetterOp)connectNative },
  { prototypes::id::ExtensionRuntime },
  { PrototypeTraits<prototypes::id::ExtensionRuntime>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_OBJECT,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
sendMessage(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "ExtensionRuntime", "sendMessage", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::extensions::ExtensionRuntime*>(void_self);
  AutoSequence<JS::Value> arg0;
  SequenceRooter<JS::Value> arg0_holder(cx, &arg0);
  if (args.length() > 0) {
    if (!arg0.SetCapacity(args.length() - 0, mozilla::fallible)) {
      JS_ReportOutOfMemory(cx);
      return false;
    }
    for (uint32_t variadicArg = 0; variadicArg < args.length(); ++variadicArg) {
      // OK to do infallible append here, since we ensured capacity already.
      JS::Value& slot = *arg0.AppendElement();
      slot = args[variadicArg];
    }
  }
  FastErrorResult rv;
  JS::Rooted<JS::Value> result(cx);
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->CallWebExtMethodAsyncAmbiguous(cx, u"sendMessage"_ns, Constify(arg0), &result, rv))>, "Should be returning void here");
  MOZ_KnownLive(self)->CallWebExtMethodAsyncAmbiguous(cx, u"sendMessage"_ns, Constify(arg0), &result, rv);
  if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "ExtensionRuntime.sendMessage"))) {
    return false;
  }
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  JS::ExposeValueToActiveJS(result);
  args.rval().set(result);
  if (!MaybeWrapValue(cx, args.rval())) {
    return false;
  }
  return true;
}

static const JSJitInfo sendMessage_methodinfo = {
  { (JSJitGetterOp)sendMessage },
  { prototypes::id::ExtensionRuntime },
  { PrototypeTraits<prototypes::id::ExtensionRuntime>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNKNOWN,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
sendNativeMessage(JSContext* cx_, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  BindingCallContext cx(cx_, "ExtensionRuntime.sendNativeMessage");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "ExtensionRuntime", "sendNativeMessage", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::extensions::ExtensionRuntime*>(void_self);
  if (!args.requireAtLeast(cx, "ExtensionRuntime.sendNativeMessage", 2)) {
    return false;
  }
  binding_detail::FakeString<char16_t> arg0;
  if (!ConvertJSValueToString(cx, args[0], eStringify, eStringify, arg0)) {
    return false;
  }
  JS::Rooted<JS::Value> arg1(cx);
  arg1 = args[1];
  Optional<OwningNonNull<Function>> arg2;
  if (args.hasDefined(2)) {
    arg2.Construct();
    if (args[2].isObject()) {
      if (JS::IsCallable(&args[2].toObject())) {
      { // scope for tempRoot and tempGlobalRoot if needed
        JS::Rooted<JSObject*> tempRoot(cx, &args[2].toObject());
        JS::Rooted<JSObject*> tempGlobalRoot(cx, JS::CurrentGlobalOrNull(cx));
        arg2.Value() = new Function(cx, tempRoot, tempGlobalRoot, GetIncumbentGlobal());
      }
      } else {
        cx.ThrowErrorMessage<MSG_NOT_CALLABLE>("Argument 3");
        return false;
      }
    } else {
      cx.ThrowErrorMessage<MSG_NOT_OBJECT>("Argument 3");
      return false;
    }
  }
  // Collecting all args js values into the single sequence argument
  // passed to the webextensions stub method.
  //
  // NOTE: The stub method will receive the original non-normalized js values,
  // but those arguments will still be normalized on the main thread by the
  // WebExtensions API request handler using the same JSONSchema defnition
  // used by the non-webIDL webextensions API bindings.
  AutoSequence<JS::Value> args_sequence;
  SequenceRooter<JS::Value> args_sequence_holder(cx, &args_sequence);

  // maximum number of arguments expected by the WebExtensions API method
  // excluding the last optional chrome-compatible callback argument (which
  // is being passed to the stub method as a separate additional argument).
  uint32_t maxArgsSequenceLen = 2;

  uint32_t sequenceArgsLen = args.length() <= maxArgsSequenceLen ?
    args.length() : maxArgsSequenceLen;

  if (sequenceArgsLen > 0) {
    if (!args_sequence.SetCapacity(sequenceArgsLen, mozilla::fallible)) {
      JS_ReportOutOfMemory(cx);
      return false;
    }
    for (uint32_t argIdx = 0; argIdx < sequenceArgsLen; ++argIdx) {
      // OK to do infallible append here, since we ensured capacity already.
      JS::Value& slot = *args_sequence.AppendElement();
      slot = args[argIdx];
    }
  }
  FastErrorResult rv;
  JS::Rooted<JS::Value> result(cx);
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->CallWebExtMethodAsync(cx, u"sendNativeMessage"_ns, Constify(args_sequence), MOZ_KnownLive(NonNullHelper(Constify(arg2))), &result, rv))>, "Should be returning void here");
  MOZ_KnownLive(self)->CallWebExtMethodAsync(cx, u"sendNativeMessage"_ns, Constify(args_sequence), MOZ_KnownLive(NonNullHelper(Constify(arg2))), &result, rv);
  if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "ExtensionRuntime.sendNativeMessage"))) {
    return false;
  }
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  JS::ExposeValueToActiveJS(result);
  args.rval().set(result);
  if (!MaybeWrapValue(cx, args.rval())) {
    return false;
  }
  return true;
}

static const JSJitInfo sendNativeMessage_methodinfo = {
  { (JSJitGetterOp)sendNativeMessage },
  { prototypes::id::ExtensionRuntime },
  { PrototypeTraits<prototypes::id::ExtensionRuntime>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNKNOWN,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
getBrowserInfo(JSContext* cx_, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  BindingCallContext cx(cx_, "ExtensionRuntime.getBrowserInfo");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "ExtensionRuntime", "getBrowserInfo", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::extensions::ExtensionRuntime*>(void_self);
  Optional<OwningNonNull<Function>> arg0;
  if (args.hasDefined(0)) {
    arg0.Construct();
    if (args[0].isObject()) {
      if (JS::IsCallable(&args[0].toObject())) {
      { // scope for tempRoot and tempGlobalRoot if needed
        JS::Rooted<JSObject*> tempRoot(cx, &args[0].toObject());
        JS::Rooted<JSObject*> tempGlobalRoot(cx, JS::CurrentGlobalOrNull(cx));
        arg0.Value() = new Function(cx, tempRoot, tempGlobalRoot, GetIncumbentGlobal());
      }
      } else {
        cx.ThrowErrorMessage<MSG_NOT_CALLABLE>("Argument 1");
        return false;
      }
    } else {
      cx.ThrowErrorMessage<MSG_NOT_OBJECT>("Argument 1");
      return false;
    }
  }
  // Collecting all args js values into the single sequence argument
  // passed to the webextensions stub method.
  //
  // NOTE: The stub method will receive the original non-normalized js values,
  // but those arguments will still be normalized on the main thread by the
  // WebExtensions API request handler using the same JSONSchema defnition
  // used by the non-webIDL webextensions API bindings.
  AutoSequence<JS::Value> args_sequence;
  SequenceRooter<JS::Value> args_sequence_holder(cx, &args_sequence);

  // maximum number of arguments expected by the WebExtensions API method
  // excluding the last optional chrome-compatible callback argument (which
  // is being passed to the stub method as a separate additional argument).
  uint32_t maxArgsSequenceLen = 0;

  uint32_t sequenceArgsLen = args.length() <= maxArgsSequenceLen ?
    args.length() : maxArgsSequenceLen;

  if (sequenceArgsLen > 0) {
    if (!args_sequence.SetCapacity(sequenceArgsLen, mozilla::fallible)) {
      JS_ReportOutOfMemory(cx);
      return false;
    }
    for (uint32_t argIdx = 0; argIdx < sequenceArgsLen; ++argIdx) {
      // OK to do infallible append here, since we ensured capacity already.
      JS::Value& slot = *args_sequence.AppendElement();
      slot = args[argIdx];
    }
  }
  FastErrorResult rv;
  JS::Rooted<JS::Value> result(cx);
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->CallWebExtMethodAsync(cx, u"getBrowserInfo"_ns, Constify(args_sequence), MOZ_KnownLive(NonNullHelper(Constify(arg0))), &result, rv))>, "Should be returning void here");
  MOZ_KnownLive(self)->CallWebExtMethodAsync(cx, u"getBrowserInfo"_ns, Constify(args_sequence), MOZ_KnownLive(NonNullHelper(Constify(arg0))), &result, rv);
  if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "ExtensionRuntime.getBrowserInfo"))) {
    return false;
  }
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  JS::ExposeValueToActiveJS(result);
  args.rval().set(result);
  if (!MaybeWrapValue(cx, args.rval())) {
    return false;
  }
  return true;
}

static const JSJitInfo getBrowserInfo_methodinfo = {
  { (JSJitGetterOp)getBrowserInfo },
  { prototypes::id::ExtensionRuntime },
  { PrototypeTraits<prototypes::id::ExtensionRuntime>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNKNOWN,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
getPlatformInfo(JSContext* cx_, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  BindingCallContext cx(cx_, "ExtensionRuntime.getPlatformInfo");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "ExtensionRuntime", "getPlatformInfo", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::extensions::ExtensionRuntime*>(void_self);
  Optional<OwningNonNull<Function>> arg0;
  if (args.hasDefined(0)) {
    arg0.Construct();
    if (args[0].isObject()) {
      if (JS::IsCallable(&args[0].toObject())) {
      { // scope for tempRoot and tempGlobalRoot if needed
        JS::Rooted<JSObject*> tempRoot(cx, &args[0].toObject());
        JS::Rooted<JSObject*> tempGlobalRoot(cx, JS::CurrentGlobalOrNull(cx));
        arg0.Value() = new Function(cx, tempRoot, tempGlobalRoot, GetIncumbentGlobal());
      }
      } else {
        cx.ThrowErrorMessage<MSG_NOT_CALLABLE>("Argument 1");
        return false;
      }
    } else {
      cx.ThrowErrorMessage<MSG_NOT_OBJECT>("Argument 1");
      return false;
    }
  }
  // Collecting all args js values into the single sequence argument
  // passed to the webextensions stub method.
  //
  // NOTE: The stub method will receive the original non-normalized js values,
  // but those arguments will still be normalized on the main thread by the
  // WebExtensions API request handler using the same JSONSchema defnition
  // used by the non-webIDL webextensions API bindings.
  AutoSequence<JS::Value> args_sequence;
  SequenceRooter<JS::Value> args_sequence_holder(cx, &args_sequence);

  // maximum number of arguments expected by the WebExtensions API method
  // excluding the last optional chrome-compatible callback argument (which
  // is being passed to the stub method as a separate additional argument).
  uint32_t maxArgsSequenceLen = 0;

  uint32_t sequenceArgsLen = args.length() <= maxArgsSequenceLen ?
    args.length() : maxArgsSequenceLen;

  if (sequenceArgsLen > 0) {
    if (!args_sequence.SetCapacity(sequenceArgsLen, mozilla::fallible)) {
      JS_ReportOutOfMemory(cx);
      return false;
    }
    for (uint32_t argIdx = 0; argIdx < sequenceArgsLen; ++argIdx) {
      // OK to do infallible append here, since we ensured capacity already.
      JS::Value& slot = *args_sequence.AppendElement();
      slot = args[argIdx];
    }
  }
  FastErrorResult rv;
  JS::Rooted<JS::Value> result(cx);
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->CallWebExtMethodAsync(cx, u"getPlatformInfo"_ns, Constify(args_sequence), MOZ_KnownLive(NonNullHelper(Constify(arg0))), &result, rv))>, "Should be returning void here");
  MOZ_KnownLive(self)->CallWebExtMethodAsync(cx, u"getPlatformInfo"_ns, Constify(args_sequence), MOZ_KnownLive(NonNullHelper(Constify(arg0))), &result, rv);
  if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "ExtensionRuntime.getPlatformInfo"))) {
    return false;
  }
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  JS::ExposeValueToActiveJS(result);
  args.rval().set(result);
  if (!MaybeWrapValue(cx, args.rval())) {
    return false;
  }
  return true;
}

static const JSJitInfo getPlatformInfo_methodinfo = {
  { (JSJitGetterOp)getPlatformInfo },
  { prototypes::id::ExtensionRuntime },
  { PrototypeTraits<prototypes::id::ExtensionRuntime>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNKNOWN,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_onStartup(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "ExtensionRuntime", "onStartup", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::extensions::ExtensionRuntime*>(void_self);
  auto result(StrongOrRawPtr<mozilla::extensions::ExtensionEventManager>(MOZ_KnownLive(self)->OnStartup()));
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (!GetOrCreateDOMReflector(cx, result, args.rval())) {
    MOZ_ASSERT(JS_IsExceptionPending(cx));
    return false;
  }
  return true;
}

MOZ_CAN_RUN_SCRIPT static bool
set_onStartup(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "ExtensionRuntime", "onStartup", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_SETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  return JS_DefineProperty(cx, obj, "onStartup", args[0], JSPROP_ENUMERATE);
}

static const JSJitInfo onStartup_getterinfo = {
  { get_onStartup },
  { prototypes::id::ExtensionRuntime },
  { PrototypeTraits<prototypes::id::ExtensionRuntime>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasNone, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_OBJECT,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  true,  /* isMovable.  Not relevant for setters. */
  true, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo onStartup_setterinfo = {
  { (JSJitGetterOp)set_onStartup },
  { prototypes::id::ExtensionRuntime },
  { PrototypeTraits<prototypes::id::ExtensionRuntime>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_onInstalled(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "ExtensionRuntime", "onInstalled", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::extensions::ExtensionRuntime*>(void_self);
  auto result(StrongOrRawPtr<mozilla::extensions::ExtensionEventManager>(MOZ_KnownLive(self)->OnInstalled()));
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (!GetOrCreateDOMReflector(cx, result, args.rval())) {
    MOZ_ASSERT(JS_IsExceptionPending(cx));
    return false;
  }
  return true;
}

MOZ_CAN_RUN_SCRIPT static bool
set_onInstalled(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "ExtensionRuntime", "onInstalled", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_SETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  return JS_DefineProperty(cx, obj, "onInstalled", args[0], JSPROP_ENUMERATE);
}

static const JSJitInfo onInstalled_getterinfo = {
  { get_onInstalled },
  { prototypes::id::ExtensionRuntime },
  { PrototypeTraits<prototypes::id::ExtensionRuntime>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasNone, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_OBJECT,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  true,  /* isMovable.  Not relevant for setters. */
  true, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo onInstalled_setterinfo = {
  { (JSJitGetterOp)set_onInstalled },
  { prototypes::id::ExtensionRuntime },
  { PrototypeTraits<prototypes::id::ExtensionRuntime>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_onUpdateAvailable(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "ExtensionRuntime", "onUpdateAvailable", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::extensions::ExtensionRuntime*>(void_self);
  auto result(StrongOrRawPtr<mozilla::extensions::ExtensionEventManager>(MOZ_KnownLive(self)->OnUpdateAvailable()));
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (!GetOrCreateDOMReflector(cx, result, args.rval())) {
    MOZ_ASSERT(JS_IsExceptionPending(cx));
    return false;
  }
  return true;
}

MOZ_CAN_RUN_SCRIPT static bool
set_onUpdateAvailable(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "ExtensionRuntime", "onUpdateAvailable", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_SETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  return JS_DefineProperty(cx, obj, "onUpdateAvailable", args[0], JSPROP_ENUMERATE);
}

static const JSJitInfo onUpdateAvailable_getterinfo = {
  { get_onUpdateAvailable },
  { prototypes::id::ExtensionRuntime },
  { PrototypeTraits<prototypes::id::ExtensionRuntime>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasNone, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_OBJECT,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  true,  /* isMovable.  Not relevant for setters. */
  true, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo onUpdateAvailable_setterinfo = {
  { (JSJitGetterOp)set_onUpdateAvailable },
  { prototypes::id::ExtensionRuntime },
  { PrototypeTraits<prototypes::id::ExtensionRuntime>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_onConnect(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "ExtensionRuntime", "onConnect", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::extensions::ExtensionRuntime*>(void_self);
  auto result(StrongOrRawPtr<mozilla::extensions::ExtensionEventManager>(MOZ_KnownLive(self)->OnConnect()));
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (!GetOrCreateDOMReflector(cx, result, args.rval())) {
    MOZ_ASSERT(JS_IsExceptionPending(cx));
    return false;
  }
  return true;
}

MOZ_CAN_RUN_SCRIPT static bool
set_onConnect(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "ExtensionRuntime", "onConnect", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_SETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  return JS_DefineProperty(cx, obj, "onConnect", args[0], JSPROP_ENUMERATE);
}

static const JSJitInfo onConnect_getterinfo = {
  { get_onConnect },
  { prototypes::id::ExtensionRuntime },
  { PrototypeTraits<prototypes::id::ExtensionRuntime>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasNone, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_OBJECT,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  true,  /* isMovable.  Not relevant for setters. */
  true, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo onConnect_setterinfo = {
  { (JSJitGetterOp)set_onConnect },
  { prototypes::id::ExtensionRuntime },
  { PrototypeTraits<prototypes::id::ExtensionRuntime>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_onConnectExternal(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "ExtensionRuntime", "onConnectExternal", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::extensions::ExtensionRuntime*>(void_self);
  auto result(StrongOrRawPtr<mozilla::extensions::ExtensionEventManager>(MOZ_KnownLive(self)->OnConnectExternal()));
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (!GetOrCreateDOMReflector(cx, result, args.rval())) {
    MOZ_ASSERT(JS_IsExceptionPending(cx));
    return false;
  }
  return true;
}

MOZ_CAN_RUN_SCRIPT static bool
set_onConnectExternal(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "ExtensionRuntime", "onConnectExternal", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_SETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  return JS_DefineProperty(cx, obj, "onConnectExternal", args[0], JSPROP_ENUMERATE);
}

static const JSJitInfo onConnectExternal_getterinfo = {
  { get_onConnectExternal },
  { prototypes::id::ExtensionRuntime },
  { PrototypeTraits<prototypes::id::ExtensionRuntime>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasNone, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_OBJECT,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  true,  /* isMovable.  Not relevant for setters. */
  true, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo onConnectExternal_setterinfo = {
  { (JSJitGetterOp)set_onConnectExternal },
  { prototypes::id::ExtensionRuntime },
  { PrototypeTraits<prototypes::id::ExtensionRuntime>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_onMessage(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "ExtensionRuntime", "onMessage", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::extensions::ExtensionRuntime*>(void_self);
  auto result(StrongOrRawPtr<mozilla::extensions::ExtensionEventManager>(MOZ_KnownLive(self)->OnMessage()));
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (!GetOrCreateDOMReflector(cx, result, args.rval())) {
    MOZ_ASSERT(JS_IsExceptionPending(cx));
    return false;
  }
  return true;
}

MOZ_CAN_RUN_SCRIPT static bool
set_onMessage(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "ExtensionRuntime", "onMessage", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_SETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  return JS_DefineProperty(cx, obj, "onMessage", args[0], JSPROP_ENUMERATE);
}

static const JSJitInfo onMessage_getterinfo = {
  { get_onMessage },
  { prototypes::id::ExtensionRuntime },
  { PrototypeTraits<prototypes::id::ExtensionRuntime>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasNone, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_OBJECT,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  true,  /* isMovable.  Not relevant for setters. */
  true, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo onMessage_setterinfo = {
  { (JSJitGetterOp)set_onMessage },
  { prototypes::id::ExtensionRuntime },
  { PrototypeTraits<prototypes::id::ExtensionRuntime>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_onMessageExternal(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "ExtensionRuntime", "onMessageExternal", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::extensions::ExtensionRuntime*>(void_self);
  auto result(StrongOrRawPtr<mozilla::extensions::ExtensionEventManager>(MOZ_KnownLive(self)->OnMessageExternal()));
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (!GetOrCreateDOMReflector(cx, result, args.rval())) {
    MOZ_ASSERT(JS_IsExceptionPending(cx));
    return false;
  }
  return true;
}

MOZ_CAN_RUN_SCRIPT static bool
set_onMessageExternal(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "ExtensionRuntime", "onMessageExternal", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_SETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  return JS_DefineProperty(cx, obj, "onMessageExternal", args[0], JSPROP_ENUMERATE);
}

static const JSJitInfo onMessageExternal_getterinfo = {
  { get_onMessageExternal },
  { prototypes::id::ExtensionRuntime },
  { PrototypeTraits<prototypes::id::ExtensionRuntime>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasNone, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_OBJECT,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  true,  /* isMovable.  Not relevant for setters. */
  true, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo onMessageExternal_setterinfo = {
  { (JSJitGetterOp)set_onMessageExternal },
  { prototypes::id::ExtensionRuntime },
  { PrototypeTraits<prototypes::id::ExtensionRuntime>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_lastError(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "ExtensionRuntime", "lastError", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::extensions::ExtensionRuntime*>(void_self);
  JS::Rooted<JS::Value> result(cx);
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->GetLastError(cx, &result))>, "Should be returning void here");
  MOZ_KnownLive(self)->GetLastError(cx, &result);
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  JS::ExposeValueToActiveJS(result);
  args.rval().set(result);
  if (!MaybeWrapValue(cx, args.rval())) {
    return false;
  }
  return true;
}

MOZ_CAN_RUN_SCRIPT static bool
set_lastError(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "ExtensionRuntime", "lastError", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_SETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  return JS_DefineProperty(cx, obj, "lastError", args[0], JSPROP_ENUMERATE);
}

static const JSJitInfo lastError_getterinfo = {
  { get_lastError },
  { prototypes::id::ExtensionRuntime },
  { PrototypeTraits<prototypes::id::ExtensionRuntime>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNKNOWN,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo lastError_setterinfo = {
  { (JSJitGetterOp)set_lastError },
  { prototypes::id::ExtensionRuntime },
  { PrototypeTraits<prototypes::id::ExtensionRuntime>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_id(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "ExtensionRuntime", "id", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::extensions::ExtensionRuntime*>(void_self);
  DOMString result;
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->GetId(result))>, "Should be returning void here");
  MOZ_KnownLive(self)->GetId(result);
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (!xpc::NonVoidStringToJsval(cx, result, args.rval())) {
    return false;
  }
  return true;
}

MOZ_CAN_RUN_SCRIPT static bool
set_id(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "ExtensionRuntime", "id", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_SETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  return JS_DefineProperty(cx, obj, "id", args[0], JSPROP_ENUMERATE);
}

static const JSJitInfo id_getterinfo = {
  { get_id },
  { prototypes::id::ExtensionRuntime },
  { PrototypeTraits<prototypes::id::ExtensionRuntime>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo id_setterinfo = {
  { (JSJitGetterOp)set_id },
  { prototypes::id::ExtensionRuntime },
  { PrototypeTraits<prototypes::id::ExtensionRuntime>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

static void
_finalize(JS::GCContext* gcx, JSObject* obj)
{
  mozilla::extensions::ExtensionRuntime* self = UnwrapPossiblyNotInitializedDOMObject<mozilla::extensions::ExtensionRuntime>(obj);
  if (self) {
    JS::SetReservedSlot(obj, DOM_OBJECT_SLOT, JS::UndefinedValue());
    ClearWrapper(self, self, obj);
    if (size_t mallocBytes = BindingJSObjectMallocBytes(self)) {
      JS::RemoveAssociatedMemory(obj, mallocBytes,
                                 JS::MemoryUse::DOMBinding);
    }
    AddForDeferredFinalization<mozilla::extensions::ExtensionRuntime>(self);
  }
}

MOZ_GLOBINIT static const JSFunctionSpec sMethods_specs[] = {
  JS_FNSPEC("openOptionsPage", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&openOptionsPage_methodinfo), 0, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("getManifest", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&getManifest_methodinfo), 0, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("getURL", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&getURL_methodinfo), 1, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("setUninstallURL", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&setUninstallURL_methodinfo), 0, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("reload", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&reload_methodinfo), 0, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("connect", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&connect_methodinfo), 0, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("connectNative", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&connectNative_methodinfo), 1, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("sendMessage", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&sendMessage_methodinfo), 0, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("sendNativeMessage", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&sendNativeMessage_methodinfo), 2, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("getBrowserInfo", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&getBrowserInfo_methodinfo), 0, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("getPlatformInfo", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&getPlatformInfo_methodinfo), 0, JSPROP_ENUMERATE, nullptr),
  JS_FS_END
};


static const Prefable<const JSFunctionSpec> sMethods[] = {
  { nullptr, &sMethods_specs[0] },
  { nullptr, nullptr }
};

MOZ_GLOBINIT static const JSPropertySpec sAttributes_specs[] = {
  JSPropertySpec::nativeAccessors("onStartup", JSPROP_ENUMERATE, GenericGetter<NormalThisPolicy, ThrowExceptions>, &onStartup_getterinfo, GenericSetter<NormalThisPolicy>, &onStartup_setterinfo),
  JSPropertySpec::nativeAccessors("onInstalled", JSPROP_ENUMERATE, GenericGetter<NormalThisPolicy, ThrowExceptions>, &onInstalled_getterinfo, GenericSetter<NormalThisPolicy>, &onInstalled_setterinfo),
  JSPropertySpec::nativeAccessors("onUpdateAvailable", JSPROP_ENUMERATE, GenericGetter<NormalThisPolicy, ThrowExceptions>, &onUpdateAvailable_getterinfo, GenericSetter<NormalThisPolicy>, &onUpdateAvailable_setterinfo),
  JSPropertySpec::nativeAccessors("onConnect", JSPROP_ENUMERATE, GenericGetter<NormalThisPolicy, ThrowExceptions>, &onConnect_getterinfo, GenericSetter<NormalThisPolicy>, &onConnect_setterinfo),
  JSPropertySpec::nativeAccessors("onConnectExternal", JSPROP_ENUMERATE, GenericGetter<NormalThisPolicy, ThrowExceptions>, &onConnectExternal_getterinfo, GenericSetter<NormalThisPolicy>, &onConnectExternal_setterinfo),
  JSPropertySpec::nativeAccessors("onMessage", JSPROP_ENUMERATE, GenericGetter<NormalThisPolicy, ThrowExceptions>, &onMessage_getterinfo, GenericSetter<NormalThisPolicy>, &onMessage_setterinfo),
  JSPropertySpec::nativeAccessors("onMessageExternal", JSPROP_ENUMERATE, GenericGetter<NormalThisPolicy, ThrowExceptions>, &onMessageExternal_getterinfo, GenericSetter<NormalThisPolicy>, &onMessageExternal_setterinfo),
  JSPropertySpec::nativeAccessors("lastError", JSPROP_ENUMERATE, GenericGetter<NormalThisPolicy, ThrowExceptions>, &lastError_getterinfo, GenericSetter<NormalThisPolicy>, &lastError_setterinfo),
  JSPropertySpec::nativeAccessors("id", JSPROP_ENUMERATE, GenericGetter<NormalThisPolicy, ThrowExceptions>, &id_getterinfo, GenericSetter<NormalThisPolicy>, &id_setterinfo),
  JS_PS_END
};


static const Prefable<const JSPropertySpec> sAttributes[] = {
  { nullptr, &sAttributes_specs[0] },
  { nullptr, nullptr }
};


static const NativePropertiesN<2> sNativeProperties = {
  false, 0,
  false, 0,
  true,  0 /* sMethods */,
  true,  1 /* sAttributes */,
  false, 0,
  false, 0,
  false, 0,
  -1,
  0,
  nullptr,
  {
    { sMethods, nullptr },
    { sAttributes, nullptr }
  }
};

static const DOMIfaceAndProtoJSClass sPrototypeClass = {
  {
    "ExtensionRuntimePrototype",
    JSCLASS_IS_DOMIFACEANDPROTOJSCLASS | JSCLASS_HAS_RESERVED_SLOTS(DOM_INTERFACE_PROTO_SLOTS_BASE),
    JS_NULL_CLASS_OPS,
    JS_NULL_CLASS_SPEC,
    JS_NULL_CLASS_EXT,
    JS_NULL_OBJECT_OPS
  },
  eInterfacePrototype,
  prototypes::id::ExtensionRuntime,
  PrototypeTraits<prototypes::id::ExtensionRuntime>::Depth,
  &sEmptyNativePropertyHooks,
  JS::GetRealmObjectPrototype
};

static JS::Handle<JSObject*>
GetProtoObjectHandle(JSContext* aCx);

static const JSClassOps sClassOps = {
  nullptr,               /* addProperty */
  nullptr,               /* delProperty */
  nullptr,               /* enumerate */
  nullptr, /* newEnumerate */
  nullptr, /* resolve */
  nullptr, /* mayResolve */
  _finalize, /* finalize */
  nullptr, /* call */
  nullptr,               /* construct */
  nullptr, /* trace */
};

static const DOMJSClass sClass = {
  { "ExtensionRuntime",
    JSCLASS_IS_DOMJSCLASS | JSCLASS_FOREGROUND_FINALIZE | JSCLASS_HAS_RESERVED_SLOTS(1) | JSCLASS_PRESERVES_WRAPPER,
    &sClassOps,
    JS_NULL_CLASS_SPEC,
    &NativeTypeHelpers<mozilla::extensions::ExtensionRuntime>::sClassExtension,
    JS_NULL_OBJECT_OPS
  },
  { prototypes::id::ExtensionRuntime, prototypes::id::_ID_Count, prototypes::id::_ID_Count, prototypes::id::_ID_Count, prototypes::id::_ID_Count, prototypes::id::_ID_Count, prototypes::id::_ID_Count, prototypes::id::_ID_Count },
  std::is_base_of_v<nsISupports, mozilla::extensions::ExtensionRuntime>,
  &sEmptyNativePropertyHooks,
  FindAssociatedGlobalForNative<mozilla::extensions::ExtensionRuntime>::Get,
  GetProtoObjectHandle,
  GetCCParticipant<mozilla::extensions::ExtensionRuntime>::Get(),
  nullptr,
  NativeTypeHelpers<mozilla::extensions::ExtensionRuntime>::GetWrapperCache
};
static_assert(1 == DOM_INSTANCE_RESERVED_SLOTS,
              "Must have the right minimal number of reserved slots.");
static_assert(1 >= 1,
              "Must have enough reserved slots.");

bool
Wrap(JSContext* aCx, mozilla::extensions::ExtensionRuntime* aObject, nsWrapperCache* aCache, JS::Handle<JSObject*> aGivenProto, JS::MutableHandle<JSObject*> aReflector)
{
  static_assert(!std::is_base_of_v<NonRefcountedDOMObject, mozilla::extensions::ExtensionRuntime>,
                "Shouldn't have wrappercached things that are not refcounted.");
  static_assert(std::is_same_v<decltype(aObject), mozilla::extensions::ExtensionRuntime*>);
  MOZ_ASSERT(ToSupportsIsCorrect(aObject));
  MOZ_ASSERT_IF(aGivenProto, js::IsObjectInContextCompartment(aGivenProto, aCx));
  MOZ_ASSERT(!aCache->GetWrapper(),
             "You should probably not be using Wrap() directly; use "
             "GetOrCreateDOMReflector instead");

  MOZ_ASSERT(ToSupportsIsOnPrimaryInheritanceChain(aObject, aCache),
             "nsISupports must be on our primary inheritance chain");

  // If the wrapper cache contains a dead reflector then finalize that
  // now, ensuring that the finalizer for the old reflector always
  // runs before the new reflector is created and attached. This
  // avoids the awkward situation where there are multiple reflector
  // objects that contain pointers to the same native.

  if (JSObject* oldReflector = aCache->GetWrapperMaybeDead()) {
    _finalize(nullptr /* unused */, oldReflector);
    MOZ_ASSERT(!aCache->GetWrapperMaybeDead());
  }

  JS::Rooted<JSObject*> global(aCx, FindAssociatedGlobal(aCx, aObject->GetParentObject()));
  if (!global) {
    return false;
  }
  MOZ_ASSERT(JS_IsGlobalObject(global));
  JS::AssertObjectIsNotGray(global);

  // That might have ended up wrapping us already, due to the wonders
  // of XBL.  Check for that, and bail out as needed.
  aReflector.set(aCache->GetWrapper());
  if (aReflector) {
#ifdef DEBUG
    AssertReflectorHasGivenProto(aCx, aReflector, aGivenProto);
#endif // DEBUG
    return true;
  }

  JSAutoRealm ar(aCx, global);
  JS::Handle<JSObject*> canonicalProto = GetProtoObjectHandle(aCx);
  if (!canonicalProto) {
    return false;
  }
  JS::Rooted<JSObject*> proto(aCx);
  if (aGivenProto) {
    proto = aGivenProto;
    // Unfortunately, while aGivenProto was in the compartment of aCx
    // coming in, we changed compartments to that of "parent" so may need
    // to wrap the proto here.
    if (js::GetContextCompartment(aCx) != JS::GetCompartment(proto)) {
      if (!JS_WrapObject(aCx, &proto)) {
        return false;
      }
    }
  } else {
    proto = canonicalProto;
  }

  BindingJSObjectCreator<mozilla::extensions::ExtensionRuntime> creator(aCx);
  creator.CreateObject(aCx, sClass.ToJSClass(), proto, aObject, aReflector);
  if (!aReflector) {
    return false;
  }

  aCache->SetWrapper(aReflector);
  creator.InitializationSucceeded();

  MOZ_ASSERT(aCache->GetWrapperPreserveColor() &&
             aCache->GetWrapperPreserveColor() == aReflector);
  // If proto != canonicalProto, we have to preserve our wrapper;
  // otherwise we won't be able to properly recreate it later, since
  // we won't know what proto to use.  Note that we don't check
  // aGivenProto here, since it's entirely possible (and even
  // somewhat common) to have a non-null aGivenProto which is the
  // same as canonicalProto.
  if (proto != canonicalProto) {
    PreserveWrapper(aObject);
  }

  return true;
}

void
CreateInterfaceObjects(JSContext* aCx, JS::Handle<JSObject*> aGlobal, ProtoAndIfaceCache& aProtoAndIfaceCache, DefineInterfaceProperty aDefineOnGlobal)
{
  JS::Heap<JSObject*>* protoCache = &aProtoAndIfaceCache.EntrySlotOrCreate(prototypes::id::ExtensionRuntime);
  JS::Heap<JSObject*>* interfaceCache = nullptr;

  JS::Handle<JSObject*> parentProto(JS::GetRealmObjectPrototypeHandle(aCx));
  if (!parentProto) {
    return;
  }

  dom::CreateInterfaceObjects(aCx, aGlobal, parentProto,
                              &sPrototypeClass, protoCache,
                              nullptr, nullptr, 0, false, Span<const LegacyFactoryFunction, 0>{},
                              interfaceCache,
                              sNativeProperties.Upcast(),
                              nullptr,
                              "ExtensionRuntime",
                              aDefineOnGlobal != DefineInterfaceProperty::No,
                              nullptr,
                              false,
                              nullptr);
}

static JS::Handle<JSObject*>
GetProtoObjectHandle(JSContext* aCx)
{
  /* Get the interface prototype object for this class.  This will create the
     object as needed. */
  return GetPerInterfaceObjectHandle(aCx, prototypes::id::ExtensionRuntime,
                                     &CreateInterfaceObjects,
                                     DefineInterfaceProperty::CheckExposure);

}

} // namespace ExtensionRuntime_Binding



} // namespace mozilla::dom
