const char metrics_tarantool_spaces_lua[] =
"local utils = require('metrics.utils')\n"
"\n"
"local collectors_list = {}\n"
"local spaces = {}\n"
"\n"
"local function update_spaces_metrics()\n"
"    if not utils.box_is_configured() then\n"
"        return\n"
"    end\n"
"\n"
"    local include_vinyl_count = rawget(_G, 'include_vinyl_count') or false\n"
"\n"
"    local new_spaces = {}\n"
"    for _, s in box.space._space:pairs() do\n"
"        local total = 0\n"
"        local space_name = s[3]\n"
"        local flags = s[6]\n"
"\n"
"        if s[1] <= box.schema.SYSTEM_ID_MAX or flags.temporary or space_name:match('^_') then\n"
"            goto continue\n"
"        end\n"
"\n"
"        local sp = box.space[space_name]\n"
"        if sp == nil or sp.index[0] == nil then\n"
"            goto continue\n"
"        end\n"
"\n"
"        new_spaces[space_name] = {indexes = {}}\n"
"\n"
"        local labels = { name = sp.name }\n"
"\n"
"        for space_id, i in pairs(sp.index) do\n"
"            if type(space_id) == 'number' then\n"
"                local l = table.copy(labels)\n"
"                l.index_name = i.name\n"
"                collectors_list.space_index_bsize =\n"
"                    utils.set_gauge('space_index_bsize', 'Index bsize', i:bsize(), l,\n"
"                        nil, {default = true})\n"
"                total = total + i:bsize()\n"
"\n"
"                if spaces[space_name] ~= nil then\n"
"                    spaces[space_name].indexes[space_id] = nil\n"
"                end\n"
"                new_spaces[space_name].indexes[space_id] = l\n"
"            end\n"
"        end\n"
"\n"
"        if spaces[space_name] ~= nil then\n"
"            for _, index in pairs(spaces[space_name].indexes) do\n"
"                collectors_list.space_index_bsize:remove(index)\n"
"            end\n"
"        end\n"
"\n"
"        if sp.engine == 'memtx' then\n"
"            local sp_bsize = sp:bsize()\n"
"\n"
"            labels.engine = 'memtx'\n"
"\n"
"            collectors_list.space_len =\n"
"                utils.set_gauge('space_len' , 'Space length', sp:len(), labels,\n"
"                    nil, {default = true})\n"
"\n"
"            collectors_list.space_bsize =\n"
"                utils.set_gauge('space_bsize', 'Space bsize', sp_bsize, labels,\n"
"                    nil, {default = true})\n"
"\n"
"            collectors_list.space_total_bsize =\n"
"                utils.set_gauge('space_total_bsize', 'Space total bsize', sp_bsize + total, labels,\n"
"                    nil, {default = true})\n"
"            new_spaces[space_name].memtx_labels = labels\n"
"\n"
"            spaces[space_name] = nil\n"
"        else\n"
"            if include_vinyl_count then\n"
"                labels.engine = 'vinyl'\n"
"                local count = sp:count()\n"
"                collectors_list.vinyl_tuples =\n"
"                    utils.set_gauge('vinyl_tuples', 'Vinyl space tuples count', count, labels,\n"
"                        nil, {default = true})\n"
"                new_spaces[space_name].vinyl_labels = labels\n"
"\n"
"                spaces[space_name] = nil\n"
"            end\n"
"        end\n"
"\n"
"        ::continue::\n"
"    end\n"
"\n"
"    for _, space in pairs(spaces) do\n"
"        for _, index in pairs(space.indexes) do\n"
"            collectors_list.space_index_bsize:remove(index)\n"
"        end\n"
"        if space.memtx_labels ~= nil then\n"
"            collectors_list.space_len:remove(space.memtx_labels)\n"
"            collectors_list.space_bsize:remove(space.memtx_labels)\n"
"            collectors_list.space_total_bsize:remove(space.memtx_labels)\n"
"        end\n"
"        if space.vinyl_labels ~= nil then\n"
"            collectors_list.vinyl_tuples:remove(space.vinyl_labels)\n"
"        end\n"
"    end\n"
"    spaces = new_spaces\n"
"end\n"
"\n"
"return {\n"
"    update = update_spaces_metrics,\n"
"    list = collectors_list,\n"
"}\n"
""
;
