const char metrics_tarantool_info_lua[] =
"local utils = require('metrics.utils')\n"
"\n"
"local collectors_list = {}\n"
"\n"
"local read_only_status = {\n"
"    [true] = 1,\n"
"    [false] = 0,\n"
"}\n"
"\n"
"local election_states = {\n"
"    follower = 0,\n"
"    candidate = 1,\n"
"    leader = 2,\n"
"}\n"
"\n"
"local function update_info_metrics()\n"
"    if not utils.box_is_configured() then\n"
"        return\n"
"    end\n"
"\n"
"    local info = box.info()\n"
"\n"
"    collectors_list.info_lsn = utils.set_gauge('info_lsn', 'Tarantool lsn',\n"
"        info.lsn, nil, nil, {default = true})\n"
"    collectors_list.info_uptime = utils.set_gauge('info_uptime', 'Tarantool uptime',\n"
"        info.uptime, nil, nil, {default = true})\n"
"\n"
"    for k, v in pairs(info.vclock) do\n"
"        collectors_list.info_vclock = utils.set_gauge('info_vclock', 'VClock',\n"
"            v, {id = k}, nil, {default = true})\n"
"    end\n"
"\n"
"    for k, v in pairs(info.replication) do\n"
"        if k ~= info.id then\n"
"            if v.upstream ~= nil then\n"
"                collectors_list.replication_lag =\n"
"                    utils.set_gauge('replication_lag', 'Replication lag',\n"
"                        v.upstream.lag, {stream = 'upstream', id = k}, nil, {default = true})\n"
"                collectors_list.replication_status =\n"
"                    utils.set_gauge('replication_status', 'Replication status',\n"
"                        v.upstream.status == 'follow' and 1 or 0, {stream = 'upstream', id = k},\n"
"                        nil, {default = true})\n"
"            end\n"
"            if v.downstream ~= nil then\n"
"                collectors_list.replication_lag =\n"
"                    utils.set_gauge('replication_lag', 'Replication lag',\n"
"                        v.downstream.lag, {stream = 'downstream', id = k},\n"
"                        nil, {default = true})\n"
"                collectors_list.replication_status =\n"
"                    utils.set_gauge('replication_status', 'Replication status',\n"
"                        v.downstream.status == 'follow' and 1 or 0, {stream = 'downstream', id = k},\n"
"                        nil, {default = true})\n"
"            end\n"
"        end\n"
"    end\n"
"\n"
"    collectors_list.read_only = utils.set_gauge('read_only', 'Is instance read only',\n"
"        read_only_status[info.ro], nil, nil, {default = true})\n"
"\n"
"    if info.synchro ~= nil then\n"
"        collectors_list.synchro_queue_owner =\n"
"            utils.set_gauge('synchro_queue_owner', 'Synchro queue owner',\n"
"                info.synchro.queue.owner, nil, nil, {default = true})\n"
"\n"
"        collectors_list.synchro_queue_term =\n"
"            utils.set_gauge('synchro_queue_term', 'Synchro queue term',\n"
"                info.synchro.queue.term, nil, nil, {default = true})\n"
"\n"
"        collectors_list.synchro_queue_len =\n"
"            utils.set_gauge('synchro_queue_len', 'Amount of transactions are collecting confirmations now',\n"
"                info.synchro.queue.len, nil, nil, {default = true})\n"
"\n"
"        collectors_list.synchro_queue_busy =\n"
"            utils.set_gauge('synchro_queue_busy', 'Is synchro queue busy',\n"
"                info.synchro.busy == true and 1 or 0, nil, nil, {default = true})\n"
"    end\n"
"\n"
"    if info.election ~= nil then\n"
"        collectors_list.election_state =\n"
"            utils.set_gauge('election_state', 'Election state of the node',\n"
"                election_states[info.election.state], nil, nil, {default = true})\n"
"\n"
"        collectors_list.election_vote =\n"
"            utils.set_gauge('election_vote', 'ID of a node the current node votes for',\n"
"                info.election.vote, nil, nil, {default = true})\n"
"\n"
"        collectors_list.election_leader =\n"
"            utils.set_gauge('election_leader', 'Leader node ID in the current term',\n"
"                info.election.leader, nil, nil, {default = true})\n"
"\n"
"        collectors_list.election_term =\n"
"            utils.set_gauge('election_term', 'Current election term',\n"
"                info.election.term, nil, nil, {default = true})\n"
"\n"
"        if info.election.leader_idle ~= nil then\n"
"            collectors_list.election_leader_idle =\n"
"                utils.set_gauge('election_leader_idle', 'Current idle for elected leader',\n"
"                    info.election.leader_idle, nil, nil, {default = true})\n"
"        end\n"
"    end\n"
"end\n"
"\n"
"return {\n"
"    update = update_info_metrics,\n"
"    list = collectors_list,\n"
"}\n"
""
;
