/* synapse-main.c generated by valac 0.56.17, the Vala compiler
 * generated from synapse-main.vala, do not modify */

/*
 * Copyright (C) 2010 Michal Hruby <michal.mhr@gmail.com>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authored by Alberto Aldegheri <albyrock87+dev@gmail.com>
 *             Michal Hruby <michal.mhr@gmail.com>
 *
 */

#include <glib-object.h>
#include <gtk/gtk.h>
#include <synapse-core.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gdk/gdk.h>
#include <keybinder.h>
#include <glib/gi18n-lib.h>
#include <plugins.h>
#include <glib/gstdio.h>
#include <locale.h>
#include "config.h"
#include <libnotify/notify.h>
#include <gio/gio.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define SYNAPSE_TYPE_UI_LAUNCHER (synapse_ui_launcher_get_type ())
#define SYNAPSE_UI_LAUNCHER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNAPSE_TYPE_UI_LAUNCHER, SynapseUILauncher))
#define SYNAPSE_UI_LAUNCHER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SYNAPSE_TYPE_UI_LAUNCHER, SynapseUILauncherClass))
#define SYNAPSE_IS_UI_LAUNCHER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNAPSE_TYPE_UI_LAUNCHER))
#define SYNAPSE_IS_UI_LAUNCHER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SYNAPSE_TYPE_UI_LAUNCHER))
#define SYNAPSE_UI_LAUNCHER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SYNAPSE_TYPE_UI_LAUNCHER, SynapseUILauncherClass))

typedef struct _SynapseUILauncher SynapseUILauncher;
typedef struct _SynapseUILauncherClass SynapseUILauncherClass;
typedef struct _SynapseUILauncherPrivate SynapseUILauncherPrivate;

#define SYNAPSE_GUI_TYPE_SETTINGS_WINDOW (synapse_gui_settings_window_get_type ())
#define SYNAPSE_GUI_SETTINGS_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNAPSE_GUI_TYPE_SETTINGS_WINDOW, SynapseGuiSettingsWindow))
#define SYNAPSE_GUI_SETTINGS_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SYNAPSE_GUI_TYPE_SETTINGS_WINDOW, SynapseGuiSettingsWindowClass))
#define SYNAPSE_GUI_IS_SETTINGS_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNAPSE_GUI_TYPE_SETTINGS_WINDOW))
#define SYNAPSE_GUI_IS_SETTINGS_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SYNAPSE_GUI_TYPE_SETTINGS_WINDOW))
#define SYNAPSE_GUI_SETTINGS_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SYNAPSE_GUI_TYPE_SETTINGS_WINDOW, SynapseGuiSettingsWindowClass))

typedef struct _SynapseGuiSettingsWindow SynapseGuiSettingsWindow;
typedef struct _SynapseGuiSettingsWindowClass SynapseGuiSettingsWindowClass;

#define SYNAPSE_GUI_TYPE_KEY_COMBO_CONFIG (synapse_gui_key_combo_config_get_type ())
#define SYNAPSE_GUI_KEY_COMBO_CONFIG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNAPSE_GUI_TYPE_KEY_COMBO_CONFIG, SynapseGuiKeyComboConfig))
#define SYNAPSE_GUI_KEY_COMBO_CONFIG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SYNAPSE_GUI_TYPE_KEY_COMBO_CONFIG, SynapseGuiKeyComboConfigClass))
#define SYNAPSE_GUI_IS_KEY_COMBO_CONFIG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNAPSE_GUI_TYPE_KEY_COMBO_CONFIG))
#define SYNAPSE_GUI_IS_KEY_COMBO_CONFIG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SYNAPSE_GUI_TYPE_KEY_COMBO_CONFIG))
#define SYNAPSE_GUI_KEY_COMBO_CONFIG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SYNAPSE_GUI_TYPE_KEY_COMBO_CONFIG, SynapseGuiKeyComboConfigClass))

typedef struct _SynapseGuiKeyComboConfig SynapseGuiKeyComboConfig;
typedef struct _SynapseGuiKeyComboConfigClass SynapseGuiKeyComboConfigClass;

#define SYNAPSE_GUI_TYPE_CATEGORY_CONFIG (synapse_gui_category_config_get_type ())
#define SYNAPSE_GUI_CATEGORY_CONFIG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNAPSE_GUI_TYPE_CATEGORY_CONFIG, SynapseGuiCategoryConfig))
#define SYNAPSE_GUI_CATEGORY_CONFIG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SYNAPSE_GUI_TYPE_CATEGORY_CONFIG, SynapseGuiCategoryConfigClass))
#define SYNAPSE_GUI_IS_CATEGORY_CONFIG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNAPSE_GUI_TYPE_CATEGORY_CONFIG))
#define SYNAPSE_GUI_IS_CATEGORY_CONFIG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SYNAPSE_GUI_TYPE_CATEGORY_CONFIG))
#define SYNAPSE_GUI_CATEGORY_CONFIG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SYNAPSE_GUI_TYPE_CATEGORY_CONFIG, SynapseGuiCategoryConfigClass))

typedef struct _SynapseGuiCategoryConfig SynapseGuiCategoryConfig;
typedef struct _SynapseGuiCategoryConfigClass SynapseGuiCategoryConfigClass;

#define SYNAPSE_GUI_TYPE_ICONTROLLER (synapse_gui_icontroller_get_type ())
#define SYNAPSE_GUI_ICONTROLLER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNAPSE_GUI_TYPE_ICONTROLLER, SynapseGuiIController))
#define SYNAPSE_GUI_IS_ICONTROLLER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNAPSE_GUI_TYPE_ICONTROLLER))
#define SYNAPSE_GUI_ICONTROLLER_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), SYNAPSE_GUI_TYPE_ICONTROLLER, SynapseGuiIControllerIface))

typedef struct _SynapseGuiIController SynapseGuiIController;
typedef struct _SynapseGuiIControllerIface SynapseGuiIControllerIface;
enum  {
	SYNAPSE_UI_LAUNCHER_0_PROPERTY,
	SYNAPSE_UI_LAUNCHER_NUM_PROPERTIES
};
static GParamSpec* synapse_ui_launcher_properties[SYNAPSE_UI_LAUNCHER_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

#define SYNAPSE_GUI_TYPE_CONTROLLER (synapse_gui_controller_get_type ())
#define SYNAPSE_GUI_CONTROLLER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNAPSE_GUI_TYPE_CONTROLLER, SynapseGuiController))
#define SYNAPSE_GUI_CONTROLLER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SYNAPSE_GUI_TYPE_CONTROLLER, SynapseGuiControllerClass))
#define SYNAPSE_GUI_IS_CONTROLLER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNAPSE_GUI_TYPE_CONTROLLER))
#define SYNAPSE_GUI_IS_CONTROLLER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SYNAPSE_GUI_TYPE_CONTROLLER))
#define SYNAPSE_GUI_CONTROLLER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SYNAPSE_GUI_TYPE_CONTROLLER, SynapseGuiControllerClass))

typedef struct _SynapseGuiController SynapseGuiController;
typedef struct _SynapseGuiControllerClass SynapseGuiControllerClass;
typedef struct _Block1Data Block1Data;
typedef struct _Block2Data Block2Data;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_option_context_free0(var) ((var == NULL) ? NULL : (var = (g_option_context_free (var), NULL)))

struct _SynapseUILauncher {
	GObject parent_instance;
	SynapseUILauncherPrivate * priv;
};

struct _SynapseUILauncherClass {
	GObjectClass parent_class;
};

struct _SynapseGuiIControllerIface {
	GTypeInterface parent_iface;
	void (*key_press_event) (SynapseGuiIController* self, GdkEventKey* event);
	void (*category_changed_event) (SynapseGuiIController* self, gint category_index);
	void (*fire_focus_context_switch_event) (SynapseGuiIController* self);
	void (*fire_focus) (SynapseGuiIController* self);
	void (*selected_index_changed_event) (SynapseGuiIController* self, gint focus_index);
	void (*set_view) (SynapseGuiIController* self, GType view_type);
	void (*summon_or_vanish) (SynapseGuiIController* self);
	gboolean (*is_in_initial_state) (SynapseGuiIController* self);
	gboolean (*searched_for_recent) (SynapseGuiIController* self);
	SynapseDataSink* (*get_data_sink) (SynapseGuiIController* self);
	void (*set_data_sink) (SynapseGuiIController* self, SynapseDataSink* value);
	SynapseGuiKeyComboConfig* (*get_key_combo_config) (SynapseGuiIController* self);
	void (*set_key_combo_config) (SynapseGuiIController* self, SynapseGuiKeyComboConfig* value);
	SynapseGuiCategoryConfig* (*get_category_config) (SynapseGuiIController* self);
	void (*set_category_config) (SynapseGuiIController* self, SynapseGuiCategoryConfig* value);
};

struct _SynapseUILauncherPrivate {
	SynapseGuiSettingsWindow* settings;
	SynapseDataSink* data_sink;
	SynapseGuiKeyComboConfig* key_combo_config;
	SynapseGuiCategoryConfig* category_config;
	gchar* current_shortcut;
	SynapseConfigService* config;
	GtkStatusIcon* status_icon;
	SynapseGuiIController* controller;
};

struct _Block1Data {
	int _ref_count_;
	SynapseUILauncher* self;
	GtkMenu* indicator_menu;
};

struct _Block2Data {
	int _ref_count_;
	SynapseUILauncher* launcher;
};

static gint SynapseUILauncher_private_offset;
static gpointer synapse_ui_launcher_parent_class = NULL;
static gboolean synapse_ui_launcher_is_startup;
static gboolean synapse_ui_launcher_is_startup = FALSE;

VALA_EXTERN GType synapse_ui_launcher_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SynapseUILauncher, g_object_unref)
VALA_EXTERN GType synapse_gui_settings_window_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SynapseGuiSettingsWindow, g_object_unref)
VALA_EXTERN GType synapse_gui_key_combo_config_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SynapseGuiKeyComboConfig, g_object_unref)
VALA_EXTERN GType synapse_gui_category_config_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SynapseGuiCategoryConfig, g_object_unref)
VALA_EXTERN GType synapse_gui_icontroller_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SynapseGuiIController, g_object_unref)
VALA_EXTERN SynapseUILauncher* synapse_ui_launcher_new (void);
VALA_EXTERN SynapseUILauncher* synapse_ui_launcher_construct (GType object_type);
VALA_EXTERN void synapse_gui_key_combo_config_update_bindings (SynapseGuiKeyComboConfig* self);
static void synapse_ui_launcher_register_plugins (SynapseUILauncher* self);
VALA_EXTERN SynapseGuiSettingsWindow* synapse_gui_settings_window_new (SynapseDataSink* data_sink,
                                                           SynapseGuiKeyComboConfig* key_combo_config);
VALA_EXTERN SynapseGuiSettingsWindow* synapse_gui_settings_window_construct (GType object_type,
                                                                 SynapseDataSink* data_sink,
                                                                 SynapseGuiKeyComboConfig* key_combo_config);
static void synapse_ui_launcher_change_keyboard_shortcut (SynapseUILauncher* self,
                                                   const gchar* key);
static void _synapse_ui_launcher_change_keyboard_shortcut_synapse_gui_settings_window_keybinding_changed (SynapseGuiSettingsWindow* _sender,
                                                                                                   const gchar* keybinding,
                                                                                                   gpointer self);
static void synapse_ui_launcher_bind_keyboard_shortcut (SynapseUILauncher* self);
VALA_EXTERN GType synapse_gui_controller_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SynapseGuiController, g_object_unref)
static void __lambda40_ (SynapseUILauncher* self);
VALA_EXTERN void synapse_gui_icontroller_summon_or_vanish (SynapseGuiIController* self);
static void ___lambda40__synapse_gui_icontroller_show_settings_requested (SynapseGuiIController* _sender,
                                                                   gpointer self);
static void synapse_ui_launcher_init_ui (SynapseUILauncher* self,
                                  GType t);
VALA_EXTERN GType synapse_gui_settings_window_get_current_theme (SynapseGuiSettingsWindow* self);
static void _synapse_ui_launcher_init_ui_synapse_gui_settings_window_theme_selected (SynapseGuiSettingsWindow* _sender,
                                                                              GType theme,
                                                                              gpointer self);
static void synapse_ui_launcher_init_indicator (SynapseUILauncher* self);
VALA_EXTERN void synapse_gui_icontroller_set_view (SynapseGuiIController* self,
                                       GType view_type);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (void * _userdata_);
static void __lambda41_ (SynapseUILauncher* self);
VALA_EXTERN void synapse_ui_launcher_show_ui (SynapseUILauncher* self);
static void ___lambda41__gtk_menu_item_activate (GtkMenuItem* _sender,
                                          gpointer self);
static void __lambda42_ (SynapseUILauncher* self);
static void ___lambda42__gtk_menu_item_activate (GtkMenuItem* _sender,
                                          gpointer self);
static void _gtk_main_quit_gtk_menu_item_activate (GtkMenuItem* _sender,
                                            gpointer self);
static void __lambda43_ (Block1Data* _data1_,
                  GtkStatusIcon* icon,
                  guint button,
                  guint event_time);
static void _gtk_status_icon_position_menu_gtk_menu_position_func (GtkMenu* menu,
                                                            gint* x,
                                                            gint* y,
                                                            gboolean* push_in,
                                                            gpointer self);
static void ___lambda43__gtk_status_icon_popup_menu (GtkStatusIcon* _sender,
                                              guint button,
                                              guint activate_time,
                                              gpointer self);
static void __lambda44_ (SynapseUILauncher* self);
static void ___lambda44__gtk_status_icon_activate (GtkStatusIcon* _sender,
                                            gpointer self);
VALA_EXTERN gboolean synapse_gui_settings_window_get_indicator_active (SynapseGuiSettingsWindow* self);
static void __lambda45_ (SynapseUILauncher* self);
static void ___lambda45__g_object_notify (GObject* _sender,
                                   GParamSpec* pspec,
                                   gpointer self);
VALA_EXTERN const gchar* synapse_gui_key_combo_config_get_activate (SynapseGuiKeyComboConfig* self);
VALA_EXTERN void synapse_gui_settings_window_set_keybinding (SynapseGuiSettingsWindow* self,
                                                 const gchar* key,
                                                 gboolean emit);
static void synapse_ui_launcher_handle_shortcut (const gchar* key,
                                          void* data);
static void _synapse_ui_launcher_handle_shortcut_keybinder_handler (const gchar* keystring,
                                                             void* udata);
VALA_EXTERN void synapse_ui_launcher_run (SynapseUILauncher* self);
static void synapse_ui_launcher_load_custom_style (void);
static void synapse_ui_launcher_ibus_fix (void);
static gint synapse_ui_launcher_main (gchar** argv,
                               gint argv_length1);
static Block2Data* block2_data_ref (Block2Data* _data2_);
static void block2_data_unref (void * _userdata_);
static void ____lambda46_ (Block2Data* _data2_);
static void _____lambda46__g_application_activate (GApplication* _sender,
                                            gpointer self);
static void synapse_ui_launcher_finalize (GObject * obj);
static GType synapse_ui_launcher_get_type_once (void);

static const GOptionEntry SYNAPSE_UI_LAUNCHER_options[2] = {{"startup", 's', (gint) 0, G_OPTION_ARG_NONE, &synapse_ui_launcher_is_startup, "Startup mode (hide the UI until activated).", NULL}, {NULL}};

static inline gpointer
synapse_ui_launcher_get_instance_private (SynapseUILauncher* self)
{
	return G_STRUCT_MEMBER_P (self, SynapseUILauncher_private_offset);
}

static void
_synapse_ui_launcher_change_keyboard_shortcut_synapse_gui_settings_window_keybinding_changed (SynapseGuiSettingsWindow* _sender,
                                                                                              const gchar* keybinding,
                                                                                              gpointer self)
{
#line 60 "synapse-main.vala"
	synapse_ui_launcher_change_keyboard_shortcut ((SynapseUILauncher*) self, keybinding);
#line 293 "synapse-main.c"
}

static void
__lambda40_ (SynapseUILauncher* self)
{
	SynapseGuiSettingsWindow* _tmp0_;
	guint32 timestamp = 0U;
	SynapseGuiSettingsWindow* _tmp1_;
	SynapseGuiSettingsWindow* _tmp2_;
	SynapseGuiSettingsWindow* _tmp3_;
	GdkWindow* _tmp4_;
	SynapseGuiSettingsWindow* _tmp5_;
	GdkWindow* _tmp6_;
	SynapseGuiIController* _tmp7_;
#line 71 "synapse-main.vala"
	_tmp0_ = self->priv->settings;
#line 71 "synapse-main.vala"
	gtk_widget_show ((GtkWidget*) _tmp0_);
#line 72 "synapse-main.vala"
	timestamp = gtk_get_current_event_time ();
#line 74 "synapse-main.vala"
	_tmp1_ = self->priv->settings;
#line 74 "synapse-main.vala"
	gtk_window_deiconify ((GtkWindow*) _tmp1_);
#line 75 "synapse-main.vala"
	_tmp2_ = self->priv->settings;
#line 75 "synapse-main.vala"
	gtk_window_present_with_time ((GtkWindow*) _tmp2_, timestamp);
#line 76 "synapse-main.vala"
	_tmp3_ = self->priv->settings;
#line 76 "synapse-main.vala"
	_tmp4_ = gtk_widget_get_window ((GtkWidget*) _tmp3_);
#line 76 "synapse-main.vala"
	gdk_window_raise (_tmp4_);
#line 77 "synapse-main.vala"
	_tmp5_ = self->priv->settings;
#line 77 "synapse-main.vala"
	_tmp6_ = gtk_widget_get_window ((GtkWidget*) _tmp5_);
#line 77 "synapse-main.vala"
	gdk_window_focus (_tmp6_, timestamp);
#line 78 "synapse-main.vala"
	_tmp7_ = self->priv->controller;
#line 78 "synapse-main.vala"
	synapse_gui_icontroller_summon_or_vanish (_tmp7_);
#line 338 "synapse-main.c"
}

static void
___lambda40__synapse_gui_icontroller_show_settings_requested (SynapseGuiIController* _sender,
                                                              gpointer self)
{
#line 70 "synapse-main.vala"
	__lambda40_ ((SynapseUILauncher*) self);
#line 347 "synapse-main.c"
}

static void
_synapse_ui_launcher_init_ui_synapse_gui_settings_window_theme_selected (SynapseGuiSettingsWindow* _sender,
                                                                         GType theme,
                                                                         gpointer self)
{
#line 85 "synapse-main.vala"
	synapse_ui_launcher_init_ui ((SynapseUILauncher*) self, theme);
#line 357 "synapse-main.c"
}

SynapseUILauncher*
synapse_ui_launcher_construct (GType object_type)
{
	SynapseUILauncher * self = NULL;
	SynapseConfigService* _tmp0_;
	SynapseDataSink* _tmp1_;
	SynapseConfigService* _tmp2_;
	SynapseConfigObject* _tmp3_;
	SynapseConfigService* _tmp4_;
	SynapseConfigObject* _tmp5_;
	SynapseGuiKeyComboConfig* _tmp6_;
	SynapseDataSink* _tmp7_;
	SynapseGuiKeyComboConfig* _tmp8_;
	SynapseGuiSettingsWindow* _tmp9_;
	SynapseGuiSettingsWindow* _tmp10_;
	SynapseDataSink* _tmp11_;
	SynapseGuiKeyComboConfig* _tmp12_;
	SynapseGuiCategoryConfig* _tmp13_;
	GObject* _tmp14_;
	GObject* _tmp15_;
	SynapseGuiIController* _tmp16_;
	SynapseGuiIController* _tmp17_;
	SynapseGuiSettingsWindow* _tmp18_;
	SynapseGuiSettingsWindow* _tmp20_;
#line 51 "synapse-main.vala"
	self = (SynapseUILauncher*) g_object_new (object_type, NULL);
#line 53 "synapse-main.vala"
	_tmp0_ = synapse_config_service_get_default ();
#line 53 "synapse-main.vala"
	_g_object_unref0 (self->priv->config);
#line 53 "synapse-main.vala"
	self->priv->config = _tmp0_;
#line 54 "synapse-main.vala"
	_tmp1_ = synapse_data_sink_new ();
#line 54 "synapse-main.vala"
	_g_object_unref0 (self->priv->data_sink);
#line 54 "synapse-main.vala"
	self->priv->data_sink = _tmp1_;
#line 55 "synapse-main.vala"
	_tmp2_ = self->priv->config;
#line 55 "synapse-main.vala"
	_tmp3_ = synapse_config_service_bind_config (_tmp2_, "ui", "shortcuts", SYNAPSE_GUI_TYPE_KEY_COMBO_CONFIG);
#line 55 "synapse-main.vala"
	_g_object_unref0 (self->priv->key_combo_config);
#line 55 "synapse-main.vala"
	self->priv->key_combo_config = G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, SYNAPSE_GUI_TYPE_KEY_COMBO_CONFIG, SynapseGuiKeyComboConfig);
#line 56 "synapse-main.vala"
	_tmp4_ = self->priv->config;
#line 56 "synapse-main.vala"
	_tmp5_ = synapse_config_service_get_config (_tmp4_, "ui", "categories", SYNAPSE_GUI_TYPE_CATEGORY_CONFIG);
#line 56 "synapse-main.vala"
	_g_object_unref0 (self->priv->category_config);
#line 56 "synapse-main.vala"
	self->priv->category_config = G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, SYNAPSE_GUI_TYPE_CATEGORY_CONFIG, SynapseGuiCategoryConfig);
#line 57 "synapse-main.vala"
	_tmp6_ = self->priv->key_combo_config;
#line 57 "synapse-main.vala"
	synapse_gui_key_combo_config_update_bindings (_tmp6_);
#line 58 "synapse-main.vala"
	synapse_ui_launcher_register_plugins (self);
#line 59 "synapse-main.vala"
	_tmp7_ = self->priv->data_sink;
#line 59 "synapse-main.vala"
	_tmp8_ = self->priv->key_combo_config;
#line 59 "synapse-main.vala"
	_tmp9_ = synapse_gui_settings_window_new (_tmp7_, _tmp8_);
#line 59 "synapse-main.vala"
	g_object_ref_sink (_tmp9_);
#line 59 "synapse-main.vala"
	_g_object_unref0 (self->priv->settings);
#line 59 "synapse-main.vala"
	self->priv->settings = _tmp9_;
#line 60 "synapse-main.vala"
	_tmp10_ = self->priv->settings;
#line 60 "synapse-main.vala"
	g_signal_connect_object (_tmp10_, "keybinding-changed", (GCallback) _synapse_ui_launcher_change_keyboard_shortcut_synapse_gui_settings_window_keybinding_changed, self, 0);
#line 62 "synapse-main.vala"
	keybinder_init ();
#line 63 "synapse-main.vala"
	synapse_ui_launcher_bind_keyboard_shortcut (self);
#line 65 "synapse-main.vala"
	_tmp11_ = self->priv->data_sink;
#line 65 "synapse-main.vala"
	_tmp12_ = self->priv->key_combo_config;
#line 65 "synapse-main.vala"
	_tmp13_ = self->priv->category_config;
#line 65 "synapse-main.vala"
	_tmp14_ = g_object_new (SYNAPSE_GUI_TYPE_CONTROLLER, "data-sink", _tmp11_, "key-combo-config", _tmp12_, "category-config", _tmp13_, NULL);
#line 65 "synapse-main.vala"
	_tmp15_ = G_IS_INITIALLY_UNOWNED (_tmp14_) ? g_object_ref_sink (_tmp14_) : _tmp14_;
#line 65 "synapse-main.vala"
	_tmp16_ = SYNAPSE_GUI_IS_ICONTROLLER (_tmp15_) ? ((SynapseGuiIController*) _tmp15_) : NULL;
#line 65 "synapse-main.vala"
	if (_tmp16_ == NULL) {
#line 65 "synapse-main.vala"
		_g_object_unref0 (_tmp15_);
#line 456 "synapse-main.c"
	}
#line 65 "synapse-main.vala"
	_g_object_unref0 (self->priv->controller);
#line 65 "synapse-main.vala"
	self->priv->controller = _tmp16_;
#line 70 "synapse-main.vala"
	_tmp17_ = self->priv->controller;
#line 70 "synapse-main.vala"
	g_signal_connect_object (_tmp17_, "show-settings-requested", (GCallback) ___lambda40__synapse_gui_icontroller_show_settings_requested, self, 0);
#line 81 "synapse-main.vala"
	_tmp18_ = self->priv->settings;
#line 81 "synapse-main.vala"
	synapse_ui_launcher_init_ui (self, synapse_gui_settings_window_get_current_theme (_tmp18_));
#line 83 "synapse-main.vala"
	if (!synapse_ui_launcher_is_startup) {
#line 472 "synapse-main.c"
		SynapseGuiIController* _tmp19_;
#line 83 "synapse-main.vala"
		_tmp19_ = self->priv->controller;
#line 83 "synapse-main.vala"
		synapse_gui_icontroller_summon_or_vanish (_tmp19_);
#line 478 "synapse-main.c"
	}
#line 85 "synapse-main.vala"
	_tmp20_ = self->priv->settings;
#line 85 "synapse-main.vala"
	g_signal_connect_object (_tmp20_, "theme-selected", (GCallback) _synapse_ui_launcher_init_ui_synapse_gui_settings_window_theme_selected, self, 0);
#line 86 "synapse-main.vala"
	synapse_ui_launcher_init_indicator (self);
#line 65 "synapse-main.vala"
	return self;
#line 488 "synapse-main.c"
}

SynapseUILauncher*
synapse_ui_launcher_new (void)
{
#line 51 "synapse-main.vala"
	return synapse_ui_launcher_construct (SYNAPSE_TYPE_UI_LAUNCHER);
#line 496 "synapse-main.c"
}

static void
synapse_ui_launcher_init_ui (SynapseUILauncher* self,
                             GType t)
{
	SynapseGuiIController* _tmp0_;
#line 89 "synapse-main.vala"
	g_return_if_fail (self != NULL);
#line 91 "synapse-main.vala"
	_tmp0_ = self->priv->controller;
#line 91 "synapse-main.vala"
	synapse_gui_icontroller_set_view (_tmp0_, t);
#line 510 "synapse-main.c"
}

static Block1Data*
block1_data_ref (Block1Data* _data1_)
{
#line 99 "synapse-main.vala"
	g_atomic_int_inc (&_data1_->_ref_count_);
#line 99 "synapse-main.vala"
	return _data1_;
#line 520 "synapse-main.c"
}

static void
block1_data_unref (void * _userdata_)
{
	Block1Data* _data1_;
	_data1_ = (Block1Data*) _userdata_;
#line 99 "synapse-main.vala"
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
#line 530 "synapse-main.c"
		SynapseUILauncher* self;
#line 99 "synapse-main.vala"
		self = _data1_->self;
#line 99 "synapse-main.vala"
		_g_object_unref0 (_data1_->indicator_menu);
#line 99 "synapse-main.vala"
		_g_object_unref0 (self);
#line 99 "synapse-main.vala"
		g_slice_free (Block1Data, _data1_);
#line 540 "synapse-main.c"
	}
}

static void
__lambda41_ (SynapseUILauncher* self)
{
#line 105 "synapse-main.vala"
	synapse_ui_launcher_show_ui (self);
#line 549 "synapse-main.c"
}

static void
___lambda41__gtk_menu_item_activate (GtkMenuItem* _sender,
                                     gpointer self)
{
#line 104 "synapse-main.vala"
	__lambda41_ ((SynapseUILauncher*) self);
#line 558 "synapse-main.c"
}

static void
__lambda42_ (SynapseUILauncher* self)
{
	SynapseGuiSettingsWindow* _tmp0_;
#line 110 "synapse-main.vala"
	_tmp0_ = self->priv->settings;
#line 110 "synapse-main.vala"
	gtk_widget_show ((GtkWidget*) _tmp0_);
#line 569 "synapse-main.c"
}

static void
___lambda42__gtk_menu_item_activate (GtkMenuItem* _sender,
                                     gpointer self)
{
#line 109 "synapse-main.vala"
	__lambda42_ ((SynapseUILauncher*) self);
#line 578 "synapse-main.c"
}

static void
_gtk_main_quit_gtk_menu_item_activate (GtkMenuItem* _sender,
                                       gpointer self)
{
#line 115 "synapse-main.vala"
	gtk_main_quit ();
#line 587 "synapse-main.c"
}

static void
_gtk_status_icon_position_menu_gtk_menu_position_func (GtkMenu* menu,
                                                       gint* x,
                                                       gint* y,
                                                       gboolean* push_in,
                                                       gpointer self)
{
#line 136 "synapse-main.vala"
	gtk_status_icon_position_menu (menu, x, y, push_in, (GtkStatusIcon*) self);
#line 136 "synapse-main.vala"
	g_object_unref (self);
#line 601 "synapse-main.c"
}

static void
__lambda43_ (Block1Data* _data1_,
             GtkStatusIcon* icon,
             guint button,
             guint event_time)
{
	SynapseUILauncher* self;
	GtkStatusIcon* _tmp0_;
#line 135 "synapse-main.vala"
	self = _data1_->self;
#line 135 "synapse-main.vala"
	g_return_if_fail (icon != NULL);
#line 136 "synapse-main.vala"
	_tmp0_ = self->priv->status_icon;
#line 136 "synapse-main.vala"
	gtk_menu_popup (_data1_->indicator_menu, NULL, NULL, _gtk_status_icon_position_menu_gtk_menu_position_func, g_object_ref (_tmp0_), button, (guint32) event_time);
#line 620 "synapse-main.c"
}

static void
___lambda43__gtk_status_icon_popup_menu (GtkStatusIcon* _sender,
                                         guint button,
                                         guint activate_time,
                                         gpointer self)
{
#line 135 "synapse-main.vala"
	__lambda43_ (self, _sender, button, activate_time);
#line 631 "synapse-main.c"
}

static void
__lambda44_ (SynapseUILauncher* self)
{
#line 139 "synapse-main.vala"
	synapse_ui_launcher_show_ui (self);
#line 639 "synapse-main.c"
}

static void
___lambda44__gtk_status_icon_activate (GtkStatusIcon* _sender,
                                       gpointer self)
{
#line 138 "synapse-main.vala"
	__lambda44_ ((SynapseUILauncher*) self);
#line 648 "synapse-main.c"
}

static void
__lambda45_ (SynapseUILauncher* self)
{
	GtkStatusIcon* _tmp0_;
	SynapseGuiSettingsWindow* _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
#line 144 "synapse-main.vala"
	_tmp0_ = self->priv->status_icon;
#line 144 "synapse-main.vala"
	_tmp1_ = self->priv->settings;
#line 144 "synapse-main.vala"
	_tmp2_ = synapse_gui_settings_window_get_indicator_active (_tmp1_);
#line 144 "synapse-main.vala"
	_tmp3_ = _tmp2_;
#line 144 "synapse-main.vala"
	gtk_status_icon_set_visible (_tmp0_, _tmp3_);
#line 668 "synapse-main.c"
}

static void
___lambda45__g_object_notify (GObject* _sender,
                              GParamSpec* pspec,
                              gpointer self)
{
#line 143 "synapse-main.vala"
	__lambda45_ ((SynapseUILauncher*) self);
#line 678 "synapse-main.c"
}

static void
synapse_ui_launcher_init_indicator (SynapseUILauncher* self)
{
	Block1Data* _data1_;
	GtkMenu* _tmp0_;
	GtkImageMenuItem* activate_item = NULL;
	GtkImageMenuItem* _tmp1_;
	GtkImage* _tmp2_;
	GtkImage* _tmp3_;
	GtkImageMenuItem* settings_item = NULL;
	GtkImageMenuItem* _tmp4_;
	GtkSeparatorMenuItem* _tmp5_;
	GtkSeparatorMenuItem* _tmp6_;
	GtkImageMenuItem* quit_item = NULL;
	GtkImageMenuItem* _tmp7_;
	GtkStatusIcon* _tmp8_;
	GtkStatusIcon* _tmp9_;
	GtkStatusIcon* _tmp10_;
	GtkStatusIcon* _tmp11_;
	SynapseGuiSettingsWindow* _tmp12_;
	gboolean _tmp13_;
	gboolean _tmp14_;
	SynapseGuiSettingsWindow* _tmp15_;
#line 99 "synapse-main.vala"
	g_return_if_fail (self != NULL);
#line 99 "synapse-main.vala"
	_data1_ = g_slice_new0 (Block1Data);
#line 99 "synapse-main.vala"
	_data1_->_ref_count_ = 1;
#line 99 "synapse-main.vala"
	_data1_->self = g_object_ref (self);
#line 101 "synapse-main.vala"
	_tmp0_ = (GtkMenu*) gtk_menu_new ();
#line 101 "synapse-main.vala"
	g_object_ref_sink (_tmp0_);
#line 101 "synapse-main.vala"
	_data1_->indicator_menu = _tmp0_;
#line 102 "synapse-main.vala"
	_tmp1_ = (GtkImageMenuItem*) gtk_image_menu_item_new_with_label (_ ("Activate"));
#line 102 "synapse-main.vala"
	g_object_ref_sink (_tmp1_);
#line 102 "synapse-main.vala"
	activate_item = _tmp1_;
#line 103 "synapse-main.vala"
	_tmp2_ = (GtkImage*) gtk_image_new_from_stock (GTK_STOCK_EXECUTE, (GtkIconSize) GTK_ICON_SIZE_MENU);
#line 103 "synapse-main.vala"
	g_object_ref_sink (_tmp2_);
#line 103 "synapse-main.vala"
	_tmp3_ = _tmp2_;
#line 103 "synapse-main.vala"
	gtk_image_menu_item_set_image (activate_item, (GtkWidget*) _tmp3_);
#line 103 "synapse-main.vala"
	_g_object_unref0 (_tmp3_);
#line 104 "synapse-main.vala"
	g_signal_connect_object ((GtkMenuItem*) activate_item, "activate", (GCallback) ___lambda41__gtk_menu_item_activate, self, 0);
#line 107 "synapse-main.vala"
	gtk_menu_shell_append ((GtkMenuShell*) _data1_->indicator_menu, (GtkMenuItem*) activate_item);
#line 108 "synapse-main.vala"
	_tmp4_ = (GtkImageMenuItem*) gtk_image_menu_item_new_from_stock (GTK_STOCK_PREFERENCES, NULL);
#line 108 "synapse-main.vala"
	g_object_ref_sink (_tmp4_);
#line 108 "synapse-main.vala"
	settings_item = _tmp4_;
#line 109 "synapse-main.vala"
	g_signal_connect_object ((GtkMenuItem*) settings_item, "activate", (GCallback) ___lambda42__gtk_menu_item_activate, self, 0);
#line 112 "synapse-main.vala"
	gtk_menu_shell_append ((GtkMenuShell*) _data1_->indicator_menu, (GtkMenuItem*) settings_item);
#line 113 "synapse-main.vala"
	_tmp5_ = (GtkSeparatorMenuItem*) gtk_separator_menu_item_new ();
#line 113 "synapse-main.vala"
	g_object_ref_sink (_tmp5_);
#line 113 "synapse-main.vala"
	_tmp6_ = _tmp5_;
#line 113 "synapse-main.vala"
	gtk_menu_shell_append ((GtkMenuShell*) _data1_->indicator_menu, (GtkMenuItem*) _tmp6_);
#line 113 "synapse-main.vala"
	_g_object_unref0 (_tmp6_);
#line 114 "synapse-main.vala"
	_tmp7_ = (GtkImageMenuItem*) gtk_image_menu_item_new_from_stock (GTK_STOCK_QUIT, NULL);
#line 114 "synapse-main.vala"
	g_object_ref_sink (_tmp7_);
#line 114 "synapse-main.vala"
	quit_item = _tmp7_;
#line 115 "synapse-main.vala"
	g_signal_connect ((GtkMenuItem*) quit_item, "activate", (GCallback) _gtk_main_quit_gtk_menu_item_activate, NULL);
#line 116 "synapse-main.vala"
	gtk_menu_shell_append ((GtkMenuShell*) _data1_->indicator_menu, (GtkMenuItem*) quit_item);
#line 117 "synapse-main.vala"
	gtk_widget_show_all ((GtkWidget*) _data1_->indicator_menu);
#line 133 "synapse-main.vala"
	_tmp8_ = gtk_status_icon_new_from_icon_name ("synapse");
#line 133 "synapse-main.vala"
	_g_object_unref0 (self->priv->status_icon);
#line 133 "synapse-main.vala"
	self->priv->status_icon = _tmp8_;
#line 135 "synapse-main.vala"
	_tmp9_ = self->priv->status_icon;
#line 135 "synapse-main.vala"
	g_signal_connect_data (_tmp9_, "popup-menu", (GCallback) ___lambda43__gtk_status_icon_popup_menu, block1_data_ref (_data1_), (GClosureNotify) block1_data_unref, 0);
#line 138 "synapse-main.vala"
	_tmp10_ = self->priv->status_icon;
#line 138 "synapse-main.vala"
	g_signal_connect_object (_tmp10_, "activate", (GCallback) ___lambda44__gtk_status_icon_activate, self, 0);
#line 141 "synapse-main.vala"
	_tmp11_ = self->priv->status_icon;
#line 141 "synapse-main.vala"
	_tmp12_ = self->priv->settings;
#line 141 "synapse-main.vala"
	_tmp13_ = synapse_gui_settings_window_get_indicator_active (_tmp12_);
#line 141 "synapse-main.vala"
	_tmp14_ = _tmp13_;
#line 141 "synapse-main.vala"
	gtk_status_icon_set_visible (_tmp11_, _tmp14_);
#line 143 "synapse-main.vala"
	_tmp15_ = self->priv->settings;
#line 143 "synapse-main.vala"
	g_signal_connect_object ((GObject*) _tmp15_, "notify::indicator-active", (GCallback) ___lambda45__g_object_notify, self, 0);
#line 99 "synapse-main.vala"
	_g_object_unref0 (quit_item);
#line 99 "synapse-main.vala"
	_g_object_unref0 (settings_item);
#line 99 "synapse-main.vala"
	_g_object_unref0 (activate_item);
#line 99 "synapse-main.vala"
	block1_data_unref (_data1_);
#line 99 "synapse-main.vala"
	_data1_ = NULL;
#line 808 "synapse-main.c"
}

static void
synapse_ui_launcher_register_plugins (SynapseUILauncher* self)
{
	GType* plugin_types = NULL;
	GType* _tmp0_;
	gint plugin_types_length1;
	gint _plugin_types_size_;
	GType* _tmp1_;
	gint _tmp1__length1;
#line 149 "synapse-main.vala"
	g_return_if_fail (self != NULL);
#line 152 "synapse-main.vala"
	_tmp0_ = g_new0 (GType, 28);
#line 152 "synapse-main.vala"
	_tmp0_[0] = SYNAPSE_TYPE_DESKTOP_FILE_PLUGIN;
#line 152 "synapse-main.vala"
	_tmp0_[1] = SYNAPSE_TYPE_HYBRID_SEARCH_PLUGIN;
#line 152 "synapse-main.vala"
	_tmp0_[2] = SYNAPSE_TYPE_GNOME_BOOKMARKS_PLUGIN;
#line 152 "synapse-main.vala"
	_tmp0_[3] = SYNAPSE_TYPE_GNOME_SESSION_PLUGIN;
#line 152 "synapse-main.vala"
	_tmp0_[4] = SYNAPSE_TYPE_SCREEN_SAVER_PLUGIN;
#line 152 "synapse-main.vala"
	_tmp0_[5] = SYNAPSE_TYPE_SYSTEM_MANAGEMENT_PLUGIN;
#line 152 "synapse-main.vala"
	_tmp0_[6] = SYNAPSE_TYPE_COMMAND_PLUGIN;
#line 152 "synapse-main.vala"
	_tmp0_[7] = SYNAPSE_TYPE_RHYTHMBOX_ACTIONS;
#line 152 "synapse-main.vala"
	_tmp0_[8] = SYNAPSE_TYPE_BANSHEE_ACTIONS;
#line 152 "synapse-main.vala"
	_tmp0_[9] = SYNAPSE_TYPE_DIRECTORY_PLUGIN;
#line 152 "synapse-main.vala"
	_tmp0_[10] = SYNAPSE_TYPE_LAUNCHPAD_PLUGIN;
#line 152 "synapse-main.vala"
	_tmp0_[11] = SYNAPSE_TYPE_CALCULATOR_PLUGIN;
#line 152 "synapse-main.vala"
	_tmp0_[12] = SYNAPSE_TYPE_SELECTION_PLUGIN;
#line 152 "synapse-main.vala"
	_tmp0_[13] = SYNAPSE_TYPE_SSH_PLUGIN;
#line 152 "synapse-main.vala"
	_tmp0_[14] = SYNAPSE_TYPE_XNOISE_ACTIONS;
#line 152 "synapse-main.vala"
	_tmp0_[15] = SYNAPSE_TYPE_CHROMIUM_PLUGIN;
#line 152 "synapse-main.vala"
	_tmp0_[16] = SYNAPSE_TYPE_FILE_OP_PLUGIN;
#line 152 "synapse-main.vala"
	_tmp0_[17] = SYNAPSE_TYPE_PIDGIN_PLUGIN;
#line 152 "synapse-main.vala"
	_tmp0_[18] = SYNAPSE_TYPE_PASS_PLUGIN;
#line 152 "synapse-main.vala"
	_tmp0_[19] = SYNAPSE_TYPE_CHAT_ACTIONS;
#line 152 "synapse-main.vala"
	_tmp0_[20] = SYNAPSE_TYPE_ZEAL_PLUGIN;
#line 152 "synapse-main.vala"
	_tmp0_[21] = SYNAPSE_TYPE_ZEITGEIST_PLUGIN;
#line 152 "synapse-main.vala"
	_tmp0_[22] = SYNAPSE_TYPE_ZEITGEIST_RELATED;
#line 152 "synapse-main.vala"
	_tmp0_[23] = SYNAPSE_TYPE_DEVHELP_PLUGIN;
#line 152 "synapse-main.vala"
	_tmp0_[24] = SYNAPSE_TYPE_OPEN_SEARCH_PLUGIN;
#line 152 "synapse-main.vala"
	_tmp0_[25] = SYNAPSE_TYPE_LOCATE_PLUGIN;
#line 152 "synapse-main.vala"
	_tmp0_[26] = SYNAPSE_TYPE_PASTEBIN_PLUGIN;
#line 152 "synapse-main.vala"
	_tmp0_[27] = SYNAPSE_TYPE_DICTIONARY_PLUGIN;
#line 152 "synapse-main.vala"
	plugin_types = _tmp0_;
#line 152 "synapse-main.vala"
	plugin_types_length1 = 28;
#line 152 "synapse-main.vala"
	_plugin_types_size_ = plugin_types_length1;
#line 194 "synapse-main.vala"
	_tmp1_ = plugin_types;
#line 194 "synapse-main.vala"
	_tmp1__length1 = plugin_types_length1;
#line 890 "synapse-main.c"
	{
		GType* t_collection = NULL;
		gint t_collection_length1 = 0;
		gint _t_collection_size_ = 0;
		gint t_it = 0;
#line 194 "synapse-main.vala"
		t_collection = _tmp1_;
#line 194 "synapse-main.vala"
		t_collection_length1 = _tmp1__length1;
#line 194 "synapse-main.vala"
		for (t_it = 0; t_it < t_collection_length1; t_it = t_it + 1) {
#line 902 "synapse-main.c"
			GType t = 0UL;
#line 194 "synapse-main.vala"
			t = t_collection[t_it];
#line 906 "synapse-main.c"
			{
				SynapseDataSink* _tmp2_;
#line 196 "synapse-main.vala"
				_tmp2_ = self->priv->data_sink;
#line 196 "synapse-main.vala"
				synapse_data_sink_register_static_plugin (_tmp2_, t);
#line 913 "synapse-main.c"
			}
		}
	}
#line 149 "synapse-main.vala"
	plugin_types = (g_free (plugin_types), NULL);
#line 919 "synapse-main.c"
}

void
synapse_ui_launcher_show_ui (SynapseUILauncher* self)
{
	SynapseGuiIController* _tmp0_;
	SynapseGuiIController* _tmp1_;
#line 200 "synapse-main.vala"
	g_return_if_fail (self != NULL);
#line 202 "synapse-main.vala"
	_tmp0_ = self->priv->controller;
#line 202 "synapse-main.vala"
	if (_tmp0_ == NULL) {
#line 202 "synapse-main.vala"
		return;
#line 935 "synapse-main.c"
	}
#line 203 "synapse-main.vala"
	_tmp1_ = self->priv->controller;
#line 203 "synapse-main.vala"
	synapse_gui_icontroller_summon_or_vanish (_tmp1_);
#line 941 "synapse-main.c"
}

static void
_synapse_ui_launcher_handle_shortcut_keybinder_handler (const gchar* keystring,
                                                        void* udata)
{
#line 211 "synapse-main.vala"
	synapse_ui_launcher_handle_shortcut (keystring, udata);
#line 950 "synapse-main.c"
}

static void
synapse_ui_launcher_bind_keyboard_shortcut (SynapseUILauncher* self)
{
	SynapseGuiKeyComboConfig* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	const gchar* _tmp4_;
	SynapseGuiSettingsWindow* _tmp5_;
	const gchar* _tmp6_;
	const gchar* _tmp7_;
#line 206 "synapse-main.vala"
	g_return_if_fail (self != NULL);
#line 208 "synapse-main.vala"
	_tmp0_ = self->priv->key_combo_config;
#line 208 "synapse-main.vala"
	_tmp1_ = synapse_gui_key_combo_config_get_activate (_tmp0_);
#line 208 "synapse-main.vala"
	_tmp2_ = _tmp1_;
#line 208 "synapse-main.vala"
	_tmp3_ = g_strdup (_tmp2_);
#line 208 "synapse-main.vala"
	_g_free0 (self->priv->current_shortcut);
#line 208 "synapse-main.vala"
	self->priv->current_shortcut = _tmp3_;
#line 209 "synapse-main.vala"
	_tmp4_ = self->priv->current_shortcut;
#line 209 "synapse-main.vala"
	g_message ("synapse-main.vala:209: Binding activation to %s", _tmp4_);
#line 210 "synapse-main.vala"
	_tmp5_ = self->priv->settings;
#line 210 "synapse-main.vala"
	_tmp6_ = self->priv->current_shortcut;
#line 210 "synapse-main.vala"
	synapse_gui_settings_window_set_keybinding (_tmp5_, _tmp6_, FALSE);
#line 211 "synapse-main.vala"
	_tmp7_ = self->priv->current_shortcut;
#line 211 "synapse-main.vala"
	keybinder_bind (_tmp7_, _synapse_ui_launcher_handle_shortcut_keybinder_handler, self);
#line 992 "synapse-main.c"
}

static void
synapse_ui_launcher_handle_shortcut (const gchar* key,
                                     void* data)
{
#line 214 "synapse-main.vala"
	g_return_if_fail (key != NULL);
#line 216 "synapse-main.vala"
	synapse_ui_launcher_show_ui (G_TYPE_CHECK_INSTANCE_CAST (data, SYNAPSE_TYPE_UI_LAUNCHER, SynapseUILauncher));
#line 1003 "synapse-main.c"
}

static void
synapse_ui_launcher_change_keyboard_shortcut (SynapseUILauncher* self,
                                              const gchar* key)
{
	const gchar* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
#line 219 "synapse-main.vala"
	g_return_if_fail (self != NULL);
#line 219 "synapse-main.vala"
	g_return_if_fail (key != NULL);
#line 221 "synapse-main.vala"
	_tmp0_ = self->priv->current_shortcut;
#line 221 "synapse-main.vala"
	keybinder_unbind (_tmp0_, _synapse_ui_launcher_handle_shortcut_keybinder_handler);
#line 222 "synapse-main.vala"
	_tmp1_ = g_strdup (key);
#line 222 "synapse-main.vala"
	_g_free0 (self->priv->current_shortcut);
#line 222 "synapse-main.vala"
	self->priv->current_shortcut = _tmp1_;
#line 223 "synapse-main.vala"
	_tmp2_ = self->priv->current_shortcut;
#line 223 "synapse-main.vala"
	keybinder_bind (_tmp2_, _synapse_ui_launcher_handle_shortcut_keybinder_handler, self);
#line 1031 "synapse-main.c"
}

void
synapse_ui_launcher_run (SynapseUILauncher* self)
{
#line 226 "synapse-main.vala"
	g_return_if_fail (self != NULL);
#line 228 "synapse-main.vala"
	g_unsetenv ("DESKTOP_AUTOSTART_ID");
#line 229 "synapse-main.vala"
	gdk_window_process_all_updates ();
#line 230 "synapse-main.vala"
	gtk_main ();
#line 1045 "synapse-main.c"
}

static void
synapse_ui_launcher_load_custom_style (void)
{
	gchar* custom_gtkrc = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
#line 235 "synapse-main.vala"
	_tmp0_ = g_get_user_config_dir ();
#line 235 "synapse-main.vala"
	_tmp1_ = g_build_filename (_tmp0_, "synapse", "gtkrc", NULL);
#line 235 "synapse-main.vala"
	custom_gtkrc = _tmp1_;
#line 240 "synapse-main.vala"
	_tmp2_ = custom_gtkrc;
#line 240 "synapse-main.vala"
	if (g_file_test (_tmp2_, G_FILE_TEST_EXISTS)) {
#line 1065 "synapse-main.c"
		const gchar* _tmp3_;
#line 242 "synapse-main.vala"
		_tmp3_ = custom_gtkrc;
#line 242 "synapse-main.vala"
		gtk_rc_add_default_file (_tmp3_);
#line 243 "synapse-main.vala"
		gtk_rc_reparse_all ();
#line 1073 "synapse-main.c"
	}
#line 233 "synapse-main.vala"
	_g_free0 (custom_gtkrc);
#line 1077 "synapse-main.c"
}

static gboolean
string_contains (const gchar* self,
                 const gchar* needle)
{
	gchar* _tmp0_;
	gboolean result;
#line 1584 "glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, FALSE);
#line 1584 "glib-2.0.vapi"
	g_return_val_if_fail (needle != NULL, FALSE);
#line 1585 "glib-2.0.vapi"
	_tmp0_ = strstr ((gchar*) self, (gchar*) needle);
#line 1585 "glib-2.0.vapi"
	result = _tmp0_ != NULL;
#line 1585 "glib-2.0.vapi"
	return result;
#line 1096 "synapse-main.c"
}

static void
synapse_ui_launcher_ibus_fix (void)
{
	gchar* ibus_no_snooper = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gboolean _tmp2_ = FALSE;
	const gchar* _tmp3_;
	const gchar* _tmp5_;
	const gchar* _tmp6_;
	const gchar* _tmp9_;
	gchar* _tmp10_;
	const gchar* _tmp11_;
#line 250 "synapse-main.vala"
	_tmp0_ = g_getenv ("IBUS_NO_SNOOPER_APPS");
#line 250 "synapse-main.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 250 "synapse-main.vala"
	ibus_no_snooper = _tmp1_;
#line 251 "synapse-main.vala"
	_tmp3_ = ibus_no_snooper;
#line 251 "synapse-main.vala"
	if (_tmp3_ == NULL) {
#line 251 "synapse-main.vala"
		_tmp2_ = TRUE;
#line 1124 "synapse-main.c"
	} else {
		const gchar* _tmp4_;
#line 251 "synapse-main.vala"
		_tmp4_ = ibus_no_snooper;
#line 251 "synapse-main.vala"
		_tmp2_ = g_strcmp0 (_tmp4_, "") == 0;
#line 1131 "synapse-main.c"
	}
#line 251 "synapse-main.vala"
	if (_tmp2_) {
#line 253 "synapse-main.vala"
		g_setenv ("IBUS_NO_SNOOPER_APPS", "synapse", TRUE);
#line 254 "synapse-main.vala"
		_g_free0 (ibus_no_snooper);
#line 254 "synapse-main.vala"
		return;
#line 1141 "synapse-main.c"
	}
#line 256 "synapse-main.vala"
	_tmp5_ = ibus_no_snooper;
#line 256 "synapse-main.vala"
	if (string_contains (_tmp5_, "synapse")) {
#line 256 "synapse-main.vala"
		_g_free0 (ibus_no_snooper);
#line 256 "synapse-main.vala"
		return;
#line 1151 "synapse-main.c"
	}
#line 258 "synapse-main.vala"
	_tmp6_ = ibus_no_snooper;
#line 258 "synapse-main.vala"
	if (!g_str_has_suffix (_tmp6_, ",")) {
#line 1157 "synapse-main.c"
		const gchar* _tmp7_;
		gchar* _tmp8_;
#line 259 "synapse-main.vala"
		_tmp7_ = ibus_no_snooper;
#line 259 "synapse-main.vala"
		_tmp8_ = g_strconcat (_tmp7_, ",", NULL);
#line 259 "synapse-main.vala"
		_g_free0 (ibus_no_snooper);
#line 259 "synapse-main.vala"
		ibus_no_snooper = _tmp8_;
#line 1168 "synapse-main.c"
	}
#line 260 "synapse-main.vala"
	_tmp9_ = ibus_no_snooper;
#line 260 "synapse-main.vala"
	_tmp10_ = g_strconcat (_tmp9_, "synapse", NULL);
#line 260 "synapse-main.vala"
	_g_free0 (ibus_no_snooper);
#line 260 "synapse-main.vala"
	ibus_no_snooper = _tmp10_;
#line 261 "synapse-main.vala"
	_tmp11_ = ibus_no_snooper;
#line 261 "synapse-main.vala"
	g_setenv ("IBUS_NO_SNOOPER_APPS", _tmp11_, TRUE);
#line 247 "synapse-main.vala"
	_g_free0 (ibus_no_snooper);
#line 1184 "synapse-main.c"
}

static Block2Data*
block2_data_ref (Block2Data* _data2_)
{
#line 288 "synapse-main.vala"
	g_atomic_int_inc (&_data2_->_ref_count_);
#line 288 "synapse-main.vala"
	return _data2_;
#line 1194 "synapse-main.c"
}

static void
block2_data_unref (void * _userdata_)
{
	Block2Data* _data2_;
	_data2_ = (Block2Data*) _userdata_;
#line 288 "synapse-main.vala"
	if (g_atomic_int_dec_and_test (&_data2_->_ref_count_)) {
#line 288 "synapse-main.vala"
		_g_object_unref0 (_data2_->launcher);
#line 288 "synapse-main.vala"
		g_slice_free (Block2Data, _data2_);
#line 1208 "synapse-main.c"
	}
}

static void
____lambda46_ (Block2Data* _data2_)
{
	SynapseUILauncher* _tmp0_;
#line 296 "synapse-main.vala"
	_tmp0_ = _data2_->launcher;
#line 296 "synapse-main.vala"
	synapse_ui_launcher_show_ui (_tmp0_);
#line 1220 "synapse-main.c"
}

static void
_____lambda46__g_application_activate (GApplication* _sender,
                                       gpointer self)
{
#line 295 "synapse-main.vala"
	____lambda46_ (self);
#line 1229 "synapse-main.c"
}

static gint
synapse_ui_launcher_main (gchar** argv,
                          gint argv_length1)
{
	GOptionContext* context = NULL;
	GOptionContext* _tmp0_;
	GOptionContext* _tmp1_;
	GOptionContext* _tmp2_;
	GOptionGroup* _tmp3_;
	GError* _inner_error0_ = NULL;
	gint result;
#line 266 "synapse-main.vala"
	synapse_utils_logger_initialize ();
#line 267 "synapse-main.vala"
	g_message ("synapse-main.vala:267: Starting up...");
#line 268 "synapse-main.vala"
	synapse_ui_launcher_ibus_fix ();
#line 270 "synapse-main.vala"
	setlocale (LC_ALL, "");
#line 271 "synapse-main.vala"
	bindtextdomain (GETTEXT_PACKAGE, DATADIR "/locale");
#line 272 "synapse-main.vala"
	bind_textdomain_codeset (GETTEXT_PACKAGE, "UTF-8");
#line 273 "synapse-main.vala"
	textdomain (GETTEXT_PACKAGE);
#line 275 "synapse-main.vala"
	_tmp0_ = g_option_context_new (" - Synapse");
#line 275 "synapse-main.vala"
	context = _tmp0_;
#line 276 "synapse-main.vala"
	_tmp1_ = context;
#line 276 "synapse-main.vala"
	g_option_context_add_main_entries (_tmp1_, SYNAPSE_UI_LAUNCHER_options, NULL);
#line 277 "synapse-main.vala"
	_tmp2_ = context;
#line 277 "synapse-main.vala"
	_tmp3_ = gtk_get_option_group (FALSE);
#line 277 "synapse-main.vala"
	g_option_context_add_group (_tmp2_, _tmp3_);
#line 1271 "synapse-main.c"
	{
		GOptionContext* _tmp4_;
		GApplication* app = NULL;
		GApplication* _tmp5_;
		gboolean _tmp6_ = FALSE;
		gboolean _tmp7_ = FALSE;
		GApplication* _tmp8_;
#line 280 "synapse-main.vala"
		_tmp4_ = context;
#line 280 "synapse-main.vala"
		g_option_context_parse (_tmp4_, (gint*) (&argv_length1), &argv, &_inner_error0_);
#line 280 "synapse-main.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 1285 "synapse-main.c"
			goto __catch0_g_error;
		}
#line 283 "synapse-main.vala"
		synapse_ui_launcher_load_custom_style ();
#line 284 "synapse-main.vala"
		gtk_init ((gint*) (&argv_length1), &argv);
#line 285 "synapse-main.vala"
		notify_init ("synapse");
#line 287 "synapse-main.vala"
		_tmp5_ = g_application_new ("org.gnome.Synapse", G_APPLICATION_FLAGS_NONE);
#line 287 "synapse-main.vala"
		app = _tmp5_;
#line 288 "synapse-main.vala"
		_tmp8_ = app;
#line 288 "synapse-main.vala"
		_tmp7_ = g_application_register (_tmp8_, NULL, &_inner_error0_);
#line 288 "synapse-main.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 288 "synapse-main.vala"
			_g_object_unref0 (app);
#line 1306 "synapse-main.c"
			goto __catch0_g_error;
		}
#line 288 "synapse-main.vala"
		if (!_tmp7_) {
#line 288 "synapse-main.vala"
			_tmp6_ = TRUE;
#line 1313 "synapse-main.c"
		} else {
			GApplication* _tmp9_;
#line 288 "synapse-main.vala"
			_tmp9_ = app;
#line 288 "synapse-main.vala"
			_tmp6_ = g_application_get_is_remote (_tmp9_);
#line 1320 "synapse-main.c"
		}
#line 288 "synapse-main.vala"
		if (_tmp6_) {
#line 1324 "synapse-main.c"
			GApplication* _tmp10_;
#line 289 "synapse-main.vala"
			g_message ("synapse-main.vala:289: Synapse is already running, activating...");
#line 290 "synapse-main.vala"
			_tmp10_ = app;
#line 290 "synapse-main.vala"
			g_application_activate (_tmp10_);
#line 1332 "synapse-main.c"
		} else {
			Block2Data* _data2_;
			SynapseUILauncher* _tmp11_;
			GApplication* _tmp12_;
			SynapseUILauncher* _tmp13_;
#line 288 "synapse-main.vala"
			_data2_ = g_slice_new0 (Block2Data);
#line 288 "synapse-main.vala"
			_data2_->_ref_count_ = 1;
#line 294 "synapse-main.vala"
			_tmp11_ = synapse_ui_launcher_new ();
#line 294 "synapse-main.vala"
			_data2_->launcher = _tmp11_;
#line 295 "synapse-main.vala"
			_tmp12_ = app;
#line 295 "synapse-main.vala"
			g_signal_connect_data (_tmp12_, "activate", (GCallback) _____lambda46__g_application_activate, block2_data_ref (_data2_), (GClosureNotify) block2_data_unref, 0);
#line 299 "synapse-main.vala"
			_tmp13_ = _data2_->launcher;
#line 299 "synapse-main.vala"
			synapse_ui_launcher_run (_tmp13_);
#line 288 "synapse-main.vala"
			block2_data_unref (_data2_);
#line 288 "synapse-main.vala"
			_data2_ = NULL;
#line 1358 "synapse-main.c"
		}
#line 278 "synapse-main.vala"
		_g_object_unref0 (app);
#line 1362 "synapse-main.c"
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* err = NULL;
		GError* _tmp14_;
		const gchar* _tmp15_;
#line 278 "synapse-main.vala"
		err = _inner_error0_;
#line 278 "synapse-main.vala"
		_inner_error0_ = NULL;
#line 304 "synapse-main.vala"
		_tmp14_ = err;
#line 304 "synapse-main.vala"
		_tmp15_ = _tmp14_->message;
#line 304 "synapse-main.vala"
		g_warning ("synapse-main.vala:304: %s", _tmp15_);
#line 278 "synapse-main.vala"
		_g_error_free0 (err);
#line 1382 "synapse-main.c"
	}
	__finally0:
#line 278 "synapse-main.vala"
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 1387 "synapse-main.c"
		gint _tmp16_ = -1;
#line 278 "synapse-main.vala"
		_g_option_context_free0 (context);
#line 278 "synapse-main.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 278 "synapse-main.vala"
		g_clear_error (&_inner_error0_);
#line 278 "synapse-main.vala"
		return _tmp16_;
#line 1397 "synapse-main.c"
	}
#line 307 "synapse-main.vala"
	result = 0;
#line 307 "synapse-main.vala"
	_g_option_context_free0 (context);
#line 307 "synapse-main.vala"
	return result;
#line 1405 "synapse-main.c"
}

int
main (int argc,
      char ** argv)
{
#line 264 "synapse-main.vala"
	return synapse_ui_launcher_main (argv, argc);
#line 1414 "synapse-main.c"
}

static void
synapse_ui_launcher_class_init (SynapseUILauncherClass * klass,
                                gpointer klass_data)
{
#line 24 "synapse-main.vala"
	synapse_ui_launcher_parent_class = g_type_class_peek_parent (klass);
#line 24 "synapse-main.vala"
	g_type_class_adjust_private_offset (klass, &SynapseUILauncher_private_offset);
#line 24 "synapse-main.vala"
	G_OBJECT_CLASS (klass)->finalize = synapse_ui_launcher_finalize;
#line 1427 "synapse-main.c"
}

static void
synapse_ui_launcher_instance_init (SynapseUILauncher * self,
                                   gpointer klass)
{
#line 24 "synapse-main.vala"
	self->priv = synapse_ui_launcher_get_instance_private (self);
#line 1436 "synapse-main.c"
}

static void
synapse_ui_launcher_finalize (GObject * obj)
{
	SynapseUILauncher * self;
	SynapseConfigService* _tmp0_;
#line 24 "synapse-main.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SYNAPSE_TYPE_UI_LAUNCHER, SynapseUILauncher);
#line 96 "synapse-main.vala"
	_tmp0_ = self->priv->config;
#line 96 "synapse-main.vala"
	synapse_config_service_save (_tmp0_);
#line 38 "synapse-main.vala"
	_g_object_unref0 (self->priv->settings);
#line 39 "synapse-main.vala"
	_g_object_unref0 (self->priv->data_sink);
#line 40 "synapse-main.vala"
	_g_object_unref0 (self->priv->key_combo_config);
#line 41 "synapse-main.vala"
	_g_object_unref0 (self->priv->category_config);
#line 42 "synapse-main.vala"
	_g_free0 (self->priv->current_shortcut);
#line 43 "synapse-main.vala"
	_g_object_unref0 (self->priv->config);
#line 47 "synapse-main.vala"
	_g_object_unref0 (self->priv->status_icon);
#line 49 "synapse-main.vala"
	_g_object_unref0 (self->priv->controller);
#line 51 "synapse-main.vala"
	G_OBJECT_CLASS (synapse_ui_launcher_parent_class)->finalize (obj);
#line 1468 "synapse-main.c"
}

static GType
synapse_ui_launcher_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SynapseUILauncherClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) synapse_ui_launcher_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SynapseUILauncher), 0, (GInstanceInitFunc) synapse_ui_launcher_instance_init, NULL };
	GType synapse_ui_launcher_type_id;
	synapse_ui_launcher_type_id = g_type_register_static (G_TYPE_OBJECT, "SynapseUILauncher", &g_define_type_info, 0);
	SynapseUILauncher_private_offset = g_type_add_instance_private (synapse_ui_launcher_type_id, sizeof (SynapseUILauncherPrivate));
	return synapse_ui_launcher_type_id;
}

GType
synapse_ui_launcher_get_type (void)
{
	static volatile gsize synapse_ui_launcher_type_id__once = 0;
	if (g_once_init_enter (&synapse_ui_launcher_type_id__once)) {
		GType synapse_ui_launcher_type_id;
		synapse_ui_launcher_type_id = synapse_ui_launcher_get_type_once ();
		g_once_init_leave (&synapse_ui_launcher_type_id__once, synapse_ui_launcher_type_id);
	}
	return synapse_ui_launcher_type_id__once;
}

