/* CUPSNotifier.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from CUPSNotifier.vala, do not modify */

/* -*- Mode: vala; indent-tabs-mode: nil; tab-width: 4 -*-*/
/*-
 * Copyright 2015 - 2022 elementary, Inc. (https://elementary.io)
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 51 Franklin Street - Fifth Floor,
 * Boston, MA 02110-1301, USA.
 *
 * Authored by: Corentin Noël <corentin@elementary.io>
 */

#include "io.elementary.settings.printers.h"
#include <gio/gio.h>
#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

typedef GDBusProxy CupsNotifierDBusProxy;
typedef GDBusProxyClass CupsNotifierDBusProxyClass;
enum  {
	CUPS_NOTIFIER_0_PROPERTY,
	CUPS_NOTIFIER_NUM_PROPERTIES
};
static GParamSpec* cups_notifier_properties[CUPS_NOTIFIER_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
enum  {
	CUPS_NOTIFIER_SERVER_RESTARTED_SIGNAL,
	CUPS_NOTIFIER_SERVER_STARTED_SIGNAL,
	CUPS_NOTIFIER_SERVER_STOPPED_SIGNAL,
	CUPS_NOTIFIER_SERVER_AUDIT_SIGNAL,
	CUPS_NOTIFIER_PRINTER_STATE_CHANGED_SIGNAL,
	CUPS_NOTIFIER_PRINTER_FINISHINGS_CHANGED_SIGNAL,
	CUPS_NOTIFIER_PRINTER_MEDIA_CHANGED_SIGNAL,
	CUPS_NOTIFIER_PRINTER_ADDED_SIGNAL,
	CUPS_NOTIFIER_PRINTER_DELETED_SIGNAL,
	CUPS_NOTIFIER_PRINTER_MODIFIED_SIGNAL,
	CUPS_NOTIFIER_JOB_CREATED_SIGNAL,
	CUPS_NOTIFIER_JOB_COMPLETED_SIGNAL,
	CUPS_NOTIFIER_JOB_STOPPED_SIGNAL,
	CUPS_NOTIFIER_JOB_CONFIG_CHANGED_SIGNAL,
	CUPS_NOTIFIER_JOB_PROGRESS_SIGNAL,
	CUPS_NOTIFIER_JOB_STATE_SIGNAL,
	CUPS_NOTIFIER_JOB_STATE_CHANGED_SIGNAL,
	CUPS_NOTIFIER_NUM_SIGNALS
};
static guint cups_notifier_signals[CUPS_NOTIFIER_NUM_SIGNALS] = {0};

struct _CupsNotifierPrivate {
	CupsNotifierDBus* dbus_notifier;
};

static gint CupsNotifier_private_offset;
static gpointer cups_notifier_parent_class = NULL;
static CupsNotifier* cups_notifier_notifier;
static CupsNotifier* cups_notifier_notifier = NULL;

static GType cups_notifier_dbus_get_type_once (void);
static void cups_notifier_dbus_proxy_g_signal (GDBusProxy* proxy,
                                        const gchar* sender_name,
                                        const gchar* signal_name,
                                        GVariant* parameters);
static void cups_notifier_dbus_proxy_cups_notifier_dbus_interface_init (CupsNotifierDBusIface* iface);
static void cups_notifier_dbus_dbus_interface_method_call (GDBusConnection* connection,
                                                    const gchar* sender,
                                                    const gchar* object_path,
                                                    const gchar* interface_name,
                                                    const gchar* method_name,
                                                    GVariant* parameters,
                                                    GDBusMethodInvocation* invocation,
                                                    gpointer user_data);
static GVariant* cups_notifier_dbus_dbus_interface_get_property (GDBusConnection* connection,
                                                          const gchar* sender,
                                                          const gchar* object_path,
                                                          const gchar* interface_name,
                                                          const gchar* property_name,
                                                          GError** error,
                                                          gpointer user_data);
static gboolean cups_notifier_dbus_dbus_interface_set_property (GDBusConnection* connection,
                                                         const gchar* sender,
                                                         const gchar* object_path,
                                                         const gchar* interface_name,
                                                         const gchar* property_name,
                                                         GVariant* value,
                                                         GError** error,
                                                         gpointer user_data);
static void _cups_notifier_dbus_unregister_object (gpointer user_data);
static CupsNotifier* cups_notifier_new (void);
static CupsNotifier* cups_notifier_construct (GType object_type);
static void __lambda4_ (CupsNotifier* self,
                 GObject* obj,
                 GAsyncResult* res);
static void cups_notifier_subscription_callback (CupsNotifier* self,
                                          GDBusConnection* connection,
                                          const gchar* sender_name,
                                          const gchar* object_path,
                                          const gchar* interface_name,
                                          const gchar* signal_name,
                                          GVariant* parameters);
static void _cups_notifier_subscription_callback_gd_bus_signal_callback (GDBusConnection* connection,
                                                                  const gchar* sender_name,
                                                                  const gchar* object_path,
                                                                  const gchar* interface_name,
                                                                  const gchar* signal_name,
                                                                  GVariant* parameters,
                                                                  gpointer self);
static void ___lambda4__gasync_ready_callback (GObject* source_object,
                                        GAsyncResult* res,
                                        gpointer self);
static void cups_notifier_send_server_event (CupsNotifier* self,
                                      const gchar* signal_name,
                                      GVariant* parameters);
static void cups_notifier_send_printer_event (CupsNotifier* self,
                                       const gchar* signal_name,
                                       GVariant* parameters);
static void cups_notifier_send_job_event (CupsNotifier* self,
                                   const gchar* signal_name,
                                   GVariant* parameters);
static void g_cclosure_user_marshal_VOID__STRING_STRING_STRING_UINT_STRING_BOOLEAN (GClosure * closure,
                                                                             GValue * return_value,
                                                                             guint n_param_values,
                                                                             const GValue * param_values,
                                                                             gpointer invocation_hint,
                                                                             gpointer marshal_data);
static void g_cclosure_user_marshal_VOID__STRING_STRING_STRING_UINT_STRING_BOOLEAN_UINT_UINT_STRING_STRING_UINT (GClosure * closure,
                                                                                                          GValue * return_value,
                                                                                                          guint n_param_values,
                                                                                                          const GValue * param_values,
                                                                                                          gpointer invocation_hint,
                                                                                                          gpointer marshal_data);
static void cups_notifier_finalize (GObject * obj);
static GType cups_notifier_get_type_once (void);

static const GDBusMethodInfo * const _cups_notifier_dbus_dbus_method_info[] = {NULL};
static const GDBusSignalInfo * const _cups_notifier_dbus_dbus_signal_info[] = {NULL};
static const GDBusPropertyInfo * const _cups_notifier_dbus_dbus_property_info[] = {NULL};
static const GDBusInterfaceInfo _cups_notifier_dbus_dbus_interface_info = {-1, "org.cups.cupsd.Notifier", (GDBusMethodInfo **) (&_cups_notifier_dbus_dbus_method_info), (GDBusSignalInfo **) (&_cups_notifier_dbus_dbus_signal_info), (GDBusPropertyInfo **) (&_cups_notifier_dbus_dbus_property_info), NULL};
static const GDBusInterfaceVTable _cups_notifier_dbus_dbus_interface_vtable = {cups_notifier_dbus_dbus_interface_method_call, cups_notifier_dbus_dbus_interface_get_property, cups_notifier_dbus_dbus_interface_set_property};

static void
cups_notifier_dbus_default_init (CupsNotifierDBusIface * iface,
                                 gpointer iface_data)
{
}

static GType
cups_notifier_dbus_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (CupsNotifierDBusIface), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) cups_notifier_dbus_default_init, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
	GType cups_notifier_dbus_type_id;
	cups_notifier_dbus_type_id = g_type_register_static (G_TYPE_INTERFACE, "CupsNotifierDBus", &g_define_type_info, 0);
	g_type_interface_add_prerequisite (cups_notifier_dbus_type_id, G_TYPE_OBJECT);
	g_type_set_qdata (cups_notifier_dbus_type_id, g_quark_from_static_string ("vala-dbus-proxy-type"), (void*) cups_notifier_dbus_proxy_get_type);
	g_type_set_qdata (cups_notifier_dbus_type_id, g_quark_from_static_string ("vala-dbus-interface-name"), "org.cups.cupsd.Notifier");
	g_type_set_qdata (cups_notifier_dbus_type_id, g_quark_from_static_string ("vala-dbus-interface-info"), (void*) (&_cups_notifier_dbus_dbus_interface_info));
	g_type_set_qdata (cups_notifier_dbus_type_id, g_quark_from_static_string ("vala-dbus-register-object"), (void*) cups_notifier_dbus_register_object);
	return cups_notifier_dbus_type_id;
}

GType
cups_notifier_dbus_get_type (void)
{
	static volatile gsize cups_notifier_dbus_type_id__once = 0;
	if (g_once_init_enter (&cups_notifier_dbus_type_id__once)) {
		GType cups_notifier_dbus_type_id;
		cups_notifier_dbus_type_id = cups_notifier_dbus_get_type_once ();
		g_once_init_leave (&cups_notifier_dbus_type_id__once, cups_notifier_dbus_type_id);
	}
	return cups_notifier_dbus_type_id__once;
}

G_DEFINE_TYPE_EXTENDED (CupsNotifierDBusProxy, cups_notifier_dbus_proxy, G_TYPE_DBUS_PROXY, 0, G_IMPLEMENT_INTERFACE (CUPS_TYPE_NOTIFIER_DBUS, cups_notifier_dbus_proxy_cups_notifier_dbus_interface_init) )
static void
cups_notifier_dbus_proxy_class_init (CupsNotifierDBusProxyClass* klass)
{
	G_DBUS_PROXY_CLASS (klass)->g_signal = cups_notifier_dbus_proxy_g_signal;
}

static void
cups_notifier_dbus_proxy_g_signal (GDBusProxy* proxy,
                                   const gchar* sender_name,
                                   const gchar* signal_name,
                                   GVariant* parameters)
{
}

static void
cups_notifier_dbus_proxy_init (CupsNotifierDBusProxy* self)
{
	g_dbus_proxy_set_interface_info (G_DBUS_PROXY (self), (GDBusInterfaceInfo *) (&_cups_notifier_dbus_dbus_interface_info));
}

static void
cups_notifier_dbus_proxy_cups_notifier_dbus_interface_init (CupsNotifierDBusIface* iface)
{
}

static void
cups_notifier_dbus_dbus_interface_method_call (GDBusConnection* connection,
                                               const gchar* sender,
                                               const gchar* object_path,
                                               const gchar* interface_name,
                                               const gchar* method_name,
                                               GVariant* parameters,
                                               GDBusMethodInvocation* invocation,
                                               gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	g_object_unref (invocation);
}

static GVariant*
cups_notifier_dbus_dbus_interface_get_property (GDBusConnection* connection,
                                                const gchar* sender,
                                                const gchar* object_path,
                                                const gchar* interface_name,
                                                const gchar* property_name,
                                                GError** error,
                                                gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return NULL;
}

static gboolean
cups_notifier_dbus_dbus_interface_set_property (GDBusConnection* connection,
                                                const gchar* sender,
                                                const gchar* object_path,
                                                const gchar* interface_name,
                                                const gchar* property_name,
                                                GVariant* value,
                                                GError** error,
                                                gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return FALSE;
}

guint
cups_notifier_dbus_register_object (gpointer object,
                                    GDBusConnection* connection,
                                    const gchar* path,
                                    GError** error)
{
	guint result;
	gpointer *data;
	data = g_new (gpointer, 3);
	data[0] = g_object_ref (object);
	data[1] = g_object_ref (connection);
	data[2] = g_strdup (path);
	result = g_dbus_connection_register_object (connection, path, (GDBusInterfaceInfo *) (&_cups_notifier_dbus_dbus_interface_info), &_cups_notifier_dbus_dbus_interface_vtable, data, _cups_notifier_dbus_unregister_object, error);
	if (!result) {
		return 0;
	}
	return result;
}

static void
_cups_notifier_dbus_unregister_object (gpointer user_data)
{
	gpointer* data;
	data = user_data;
	g_object_unref (data[0]);
	g_object_unref (data[1]);
	g_free (data[2]);
	g_free (data);
}

static inline gpointer
cups_notifier_get_instance_private (CupsNotifier* self)
{
	return G_STRUCT_MEMBER_P (self, CupsNotifier_private_offset);
}

CupsNotifier*
cups_notifier_get_default (void)
{
	CupsNotifier* _tmp0_;
	CupsNotifier* _tmp2_;
	CupsNotifier* result;
	_tmp0_ = cups_notifier_notifier;
	if (_tmp0_ == NULL) {
		CupsNotifier* _tmp1_;
		_tmp1_ = cups_notifier_new ();
		_g_object_unref0 (cups_notifier_notifier);
		cups_notifier_notifier = _tmp1_;
	}
	_tmp2_ = cups_notifier_notifier;
	result = _tmp2_;
	return result;
}

static void
_cups_notifier_subscription_callback_gd_bus_signal_callback (GDBusConnection* connection,
                                                             const gchar* sender_name,
                                                             const gchar* object_path,
                                                             const gchar* interface_name,
                                                             const gchar* signal_name,
                                                             GVariant* parameters,
                                                             gpointer self)
{
	cups_notifier_subscription_callback ((CupsNotifier*) self, connection, sender_name, object_path, interface_name, signal_name, parameters);
}

static void
__lambda4_ (CupsNotifier* self,
            GObject* obj,
            GAsyncResult* res)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (res != NULL);
	{
		CupsNotifierDBus* _tmp0_ = NULL;
		CupsNotifierDBus* _tmp1_;
		CupsNotifierDBus* _tmp2_;
		CupsNotifierDBus* _tmp3_;
		CupsNotifierDBus* _tmp4_;
		GDBusConnection* _tmp5_;
		GDBusConnection* _tmp6_;
		GDBusConnection* _tmp7_;
		_tmp1_ = g_async_result_get_source_object (res);
		_tmp2_ = (CupsNotifierDBus*) g_async_initable_new_finish ((GAsyncInitable *) _tmp1_, res, &_inner_error0_);
		g_object_unref (_tmp1_);
		_tmp0_ = (CupsNotifierDBus*) _tmp2_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_IO_ERROR) {
				goto __catch0_g_io_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
		_tmp3_ = _tmp0_;
		_tmp0_ = NULL;
		_g_object_unref0 (self->priv->dbus_notifier);
		self->priv->dbus_notifier = _tmp3_;
		_tmp4_ = self->priv->dbus_notifier;
		g_object_get (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, g_dbus_proxy_get_type (), GDBusProxy), "g-connection", &_tmp5_, NULL);
		_tmp6_ = _tmp5_;
		_tmp7_ = _tmp6_;
		g_dbus_connection_signal_subscribe (_tmp7_, NULL, "org.cups.cupsd.Notifier", NULL, "/org/cups/cupsd/Notifier", NULL, G_DBUS_SIGNAL_FLAGS_NONE, _cups_notifier_subscription_callback_gd_bus_signal_callback, g_object_ref (self), g_object_unref);
		_g_object_unref0 (_tmp7_);
		_g_object_unref0 (_tmp0_);
	}
	goto __finally0;
	__catch0_g_io_error:
	{
		GError* e = NULL;
		GError* _tmp8_;
		const gchar* _tmp9_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp8_ = e;
		_tmp9_ = _tmp8_->message;
		g_critical ("CUPSNotifier.vala:68: %s", _tmp9_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
___lambda4__gasync_ready_callback (GObject* source_object,
                                   GAsyncResult* res,
                                   gpointer self)
{
	__lambda4_ ((CupsNotifier*) self, source_object, res);
	g_object_unref (self);
}

static CupsNotifier*
cups_notifier_construct (GType object_type)
{
	CupsNotifier * self = NULL;
	GError* _inner_error0_ = NULL;
	self = (CupsNotifier*) g_object_new (object_type, NULL);
	g_async_initable_new_async (CUPS_TYPE_NOTIFIER_DBUS_PROXY, 0, NULL, ___lambda4__gasync_ready_callback, g_object_ref (self), "g-flags", G_DBUS_PROXY_FLAGS_NONE, "g-name", "org.cups.cupsd.Notifier", "g-bus-type", G_BUS_TYPE_SYSTEM, "g-object-path", "/org/cups/cupsd/Notifier", "g-interface-name", "org.cups.cupsd.Notifier", NULL);
	return self;
}

static CupsNotifier*
cups_notifier_new (void)
{
	return cups_notifier_construct (CUPS_TYPE_NOTIFIER);
}

static void
cups_notifier_subscription_callback (CupsNotifier* self,
                                     GDBusConnection* connection,
                                     const gchar* sender_name,
                                     const gchar* object_path,
                                     const gchar* interface_name,
                                     const gchar* signal_name,
                                     GVariant* parameters)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (connection != NULL);
	g_return_if_fail (object_path != NULL);
	g_return_if_fail (interface_name != NULL);
	g_return_if_fail (signal_name != NULL);
	g_return_if_fail (parameters != NULL);
	if (g_str_has_prefix (signal_name, "Server")) {
		cups_notifier_send_server_event (self, signal_name, parameters);
	} else {
		if (g_str_has_prefix (signal_name, "Printer")) {
			cups_notifier_send_printer_event (self, signal_name, parameters);
		} else {
			if (g_str_has_prefix (signal_name, "Job")) {
				cups_notifier_send_job_event (self, signal_name, parameters);
			} else {
				g_warning ("CUPSNotifier.vala:81: Unhandled CUPSNotifier signal %s", signal_name);
			}
		}
	}
}

static void
cups_notifier_send_server_event (CupsNotifier* self,
                                 const gchar* signal_name,
                                 GVariant* parameters)
{
	gchar* text = NULL;
	GVariant* _tmp0_;
	GVariant* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	const gchar* _tmp5_;
	GQuark _tmp7_ = 0U;
	static GQuark _tmp6_label0 = 0;
	static GQuark _tmp6_label1 = 0;
	static GQuark _tmp6_label2 = 0;
	static GQuark _tmp6_label3 = 0;
	g_return_if_fail (self != NULL);
	g_return_if_fail (signal_name != NULL);
	g_return_if_fail (parameters != NULL);
	_tmp0_ = g_variant_get_child_value (parameters, (gsize) 0);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_variant_get_string (_tmp1_, NULL);
	_tmp3_ = g_strdup (_tmp2_);
	_tmp4_ = _tmp3_;
	_g_variant_unref0 (_tmp1_);
	text = _tmp4_;
	_tmp5_ = signal_name;
	_tmp7_ = (NULL == _tmp5_) ? 0 : g_quark_from_string (_tmp5_);
	if (_tmp7_ == ((0 != _tmp6_label0) ? _tmp6_label0 : (_tmp6_label0 = g_quark_from_static_string ("ServerRestarted")))) {
		switch (0) {
			default:
			{
				const gchar* _tmp8_;
				_tmp8_ = text;
				g_signal_emit (self, cups_notifier_signals[CUPS_NOTIFIER_SERVER_RESTARTED_SIGNAL], 0, _tmp8_);
				break;
			}
		}
	} else if (_tmp7_ == ((0 != _tmp6_label1) ? _tmp6_label1 : (_tmp6_label1 = g_quark_from_static_string ("ServerStarted")))) {
		switch (0) {
			default:
			{
				const gchar* _tmp9_;
				_tmp9_ = text;
				g_signal_emit (self, cups_notifier_signals[CUPS_NOTIFIER_SERVER_STARTED_SIGNAL], 0, _tmp9_);
				break;
			}
		}
	} else if (_tmp7_ == ((0 != _tmp6_label2) ? _tmp6_label2 : (_tmp6_label2 = g_quark_from_static_string ("ServerStopped")))) {
		switch (0) {
			default:
			{
				const gchar* _tmp10_;
				_tmp10_ = text;
				g_signal_emit (self, cups_notifier_signals[CUPS_NOTIFIER_SERVER_STOPPED_SIGNAL], 0, _tmp10_);
				break;
			}
		}
	} else if (_tmp7_ == ((0 != _tmp6_label3) ? _tmp6_label3 : (_tmp6_label3 = g_quark_from_static_string ("ServerAudit")))) {
		switch (0) {
			default:
			{
				const gchar* _tmp11_;
				_tmp11_ = text;
				g_signal_emit (self, cups_notifier_signals[CUPS_NOTIFIER_SERVER_AUDIT_SIGNAL], 0, _tmp11_);
				break;
			}
		}
	} else {
		switch (0) {
			default:
			{
				g_debug ("CUPSNotifier.vala:101: Signal `%s` isn't handled by the plug", signal_name);
				break;
			}
		}
	}
	_g_free0 (text);
}

static void
cups_notifier_send_printer_event (CupsNotifier* self,
                                  const gchar* signal_name,
                                  GVariant* parameters)
{
	gchar* text = NULL;
	GVariant* _tmp0_;
	GVariant* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* printer_uri = NULL;
	GVariant* _tmp5_;
	GVariant* _tmp6_;
	const gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* name = NULL;
	GVariant* _tmp10_;
	GVariant* _tmp11_;
	const gchar* _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
	guint32 state = 0U;
	GVariant* _tmp15_;
	GVariant* _tmp16_;
	guint32 _tmp17_;
	gchar* state_reasons = NULL;
	GVariant* _tmp18_;
	GVariant* _tmp19_;
	const gchar* _tmp20_;
	gchar* _tmp21_;
	gchar* _tmp22_;
	gboolean is_accepting_jobs = FALSE;
	GVariant* _tmp23_;
	GVariant* _tmp24_;
	gboolean _tmp25_;
	const gchar* _tmp26_;
	GQuark _tmp28_ = 0U;
	static GQuark _tmp27_label0 = 0;
	static GQuark _tmp27_label1 = 0;
	static GQuark _tmp27_label2 = 0;
	static GQuark _tmp27_label3 = 0;
	static GQuark _tmp27_label4 = 0;
	static GQuark _tmp27_label5 = 0;
	static GQuark _tmp27_label6 = 0;
	static GQuark _tmp27_label7 = 0;
	static GQuark _tmp27_label8 = 0;
	g_return_if_fail (self != NULL);
	g_return_if_fail (signal_name != NULL);
	g_return_if_fail (parameters != NULL);
	_tmp0_ = g_variant_get_child_value (parameters, (gsize) 0);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_variant_get_string (_tmp1_, NULL);
	_tmp3_ = g_strdup (_tmp2_);
	_tmp4_ = _tmp3_;
	_g_variant_unref0 (_tmp1_);
	text = _tmp4_;
	_tmp5_ = g_variant_get_child_value (parameters, (gsize) 1);
	_tmp6_ = _tmp5_;
	_tmp7_ = g_variant_get_string (_tmp6_, NULL);
	_tmp8_ = g_strdup (_tmp7_);
	_tmp9_ = _tmp8_;
	_g_variant_unref0 (_tmp6_);
	printer_uri = _tmp9_;
	_tmp10_ = g_variant_get_child_value (parameters, (gsize) 2);
	_tmp11_ = _tmp10_;
	_tmp12_ = g_variant_get_string (_tmp11_, NULL);
	_tmp13_ = g_strdup (_tmp12_);
	_tmp14_ = _tmp13_;
	_g_variant_unref0 (_tmp11_);
	name = _tmp14_;
	_tmp15_ = g_variant_get_child_value (parameters, (gsize) 3);
	_tmp16_ = _tmp15_;
	_tmp17_ = g_variant_get_uint32 (_tmp16_);
	_g_variant_unref0 (_tmp16_);
	state = _tmp17_;
	_tmp18_ = g_variant_get_child_value (parameters, (gsize) 4);
	_tmp19_ = _tmp18_;
	_tmp20_ = g_variant_get_string (_tmp19_, NULL);
	_tmp21_ = g_strdup (_tmp20_);
	_tmp22_ = _tmp21_;
	_g_variant_unref0 (_tmp19_);
	state_reasons = _tmp22_;
	_tmp23_ = g_variant_get_child_value (parameters, (gsize) 5);
	_tmp24_ = _tmp23_;
	_tmp25_ = g_variant_get_boolean (_tmp24_);
	_g_variant_unref0 (_tmp24_);
	is_accepting_jobs = _tmp25_;
	_tmp26_ = signal_name;
	_tmp28_ = (NULL == _tmp26_) ? 0 : g_quark_from_string (_tmp26_);
	if ((((_tmp28_ == ((0 != _tmp27_label0) ? _tmp27_label0 : (_tmp27_label0 = g_quark_from_static_string ("PrinterRestarted")))) || (_tmp28_ == ((0 != _tmp27_label1) ? _tmp27_label1 : (_tmp27_label1 = g_quark_from_static_string ("PrinterShutdown"))))) || (_tmp28_ == ((0 != _tmp27_label2) ? _tmp27_label2 : (_tmp27_label2 = g_quark_from_static_string ("PrinterStopped"))))) || (_tmp28_ == ((0 != _tmp27_label3) ? _tmp27_label3 : (_tmp27_label3 = g_quark_from_static_string ("PrinterStateChanged"))))) {
		switch (0) {
			default:
			{
				const gchar* _tmp29_;
				const gchar* _tmp30_;
				const gchar* _tmp31_;
				const gchar* _tmp32_;
				_tmp29_ = text;
				_tmp30_ = printer_uri;
				_tmp31_ = name;
				_tmp32_ = state_reasons;
				g_signal_emit (self, cups_notifier_signals[CUPS_NOTIFIER_PRINTER_STATE_CHANGED_SIGNAL], 0, _tmp29_, _tmp30_, _tmp31_, state, _tmp32_, is_accepting_jobs);
				break;
			}
		}
	} else if (_tmp28_ == ((0 != _tmp27_label4) ? _tmp27_label4 : (_tmp27_label4 = g_quark_from_static_string ("PrinterFinishingsChanged")))) {
		switch (0) {
			default:
			{
				const gchar* _tmp33_;
				const gchar* _tmp34_;
				const gchar* _tmp35_;
				const gchar* _tmp36_;
				_tmp33_ = text;
				_tmp34_ = printer_uri;
				_tmp35_ = name;
				_tmp36_ = state_reasons;
				g_signal_emit (self, cups_notifier_signals[CUPS_NOTIFIER_PRINTER_FINISHINGS_CHANGED_SIGNAL], 0, _tmp33_, _tmp34_, _tmp35_, state, _tmp36_, is_accepting_jobs);
				break;
			}
		}
	} else if (_tmp28_ == ((0 != _tmp27_label5) ? _tmp27_label5 : (_tmp27_label5 = g_quark_from_static_string ("PrinterMediaChanged")))) {
		switch (0) {
			default:
			{
				const gchar* _tmp37_;
				const gchar* _tmp38_;
				const gchar* _tmp39_;
				const gchar* _tmp40_;
				_tmp37_ = text;
				_tmp38_ = printer_uri;
				_tmp39_ = name;
				_tmp40_ = state_reasons;
				g_signal_emit (self, cups_notifier_signals[CUPS_NOTIFIER_PRINTER_MEDIA_CHANGED_SIGNAL], 0, _tmp37_, _tmp38_, _tmp39_, state, _tmp40_, is_accepting_jobs);
				break;
			}
		}
	} else if (_tmp28_ == ((0 != _tmp27_label6) ? _tmp27_label6 : (_tmp27_label6 = g_quark_from_static_string ("PrinterAdded")))) {
		switch (0) {
			default:
			{
				const gchar* _tmp41_;
				const gchar* _tmp42_;
				const gchar* _tmp43_;
				const gchar* _tmp44_;
				_tmp41_ = text;
				_tmp42_ = printer_uri;
				_tmp43_ = name;
				_tmp44_ = state_reasons;
				g_signal_emit (self, cups_notifier_signals[CUPS_NOTIFIER_PRINTER_ADDED_SIGNAL], 0, _tmp41_, _tmp42_, _tmp43_, state, _tmp44_, is_accepting_jobs);
				break;
			}
		}
	} else if (_tmp28_ == ((0 != _tmp27_label7) ? _tmp27_label7 : (_tmp27_label7 = g_quark_from_static_string ("PrinterDeleted")))) {
		switch (0) {
			default:
			{
				const gchar* _tmp45_;
				const gchar* _tmp46_;
				const gchar* _tmp47_;
				const gchar* _tmp48_;
				_tmp45_ = text;
				_tmp46_ = printer_uri;
				_tmp47_ = name;
				_tmp48_ = state_reasons;
				g_signal_emit (self, cups_notifier_signals[CUPS_NOTIFIER_PRINTER_DELETED_SIGNAL], 0, _tmp45_, _tmp46_, _tmp47_, state, _tmp48_, is_accepting_jobs);
				break;
			}
		}
	} else if (_tmp28_ == ((0 != _tmp27_label8) ? _tmp27_label8 : (_tmp27_label8 = g_quark_from_static_string ("PrinterModified")))) {
		switch (0) {
			default:
			{
				const gchar* _tmp49_;
				const gchar* _tmp50_;
				const gchar* _tmp51_;
				const gchar* _tmp52_;
				_tmp49_ = text;
				_tmp50_ = printer_uri;
				_tmp51_ = name;
				_tmp52_ = state_reasons;
				g_signal_emit (self, cups_notifier_signals[CUPS_NOTIFIER_PRINTER_MODIFIED_SIGNAL], 0, _tmp49_, _tmp50_, _tmp51_, state, _tmp52_, is_accepting_jobs);
				break;
			}
		}
	} else {
		switch (0) {
			default:
			{
				g_debug ("CUPSNotifier.vala:137: Signal `%s` isn't handled by the plug", signal_name);
				break;
			}
		}
	}
	_g_free0 (state_reasons);
	_g_free0 (name);
	_g_free0 (printer_uri);
	_g_free0 (text);
}

static void
cups_notifier_send_job_event (CupsNotifier* self,
                              const gchar* signal_name,
                              GVariant* parameters)
{
	gchar* text = NULL;
	GVariant* _tmp0_;
	GVariant* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* printer_uri = NULL;
	GVariant* _tmp5_;
	GVariant* _tmp6_;
	const gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* name = NULL;
	GVariant* _tmp10_;
	GVariant* _tmp11_;
	const gchar* _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
	guint32 printer_state = 0U;
	GVariant* _tmp15_;
	GVariant* _tmp16_;
	guint32 _tmp17_;
	gchar* state_reasons = NULL;
	GVariant* _tmp18_;
	GVariant* _tmp19_;
	const gchar* _tmp20_;
	gchar* _tmp21_;
	gchar* _tmp22_;
	gboolean is_accepting_jobs = FALSE;
	GVariant* _tmp23_;
	GVariant* _tmp24_;
	gboolean _tmp25_;
	guint32 job_id = 0U;
	GVariant* _tmp26_;
	GVariant* _tmp27_;
	guint32 _tmp28_;
	guint32 job_state = 0U;
	GVariant* _tmp29_;
	GVariant* _tmp30_;
	guint32 _tmp31_;
	gchar* job_state_reason = NULL;
	GVariant* _tmp32_;
	GVariant* _tmp33_;
	const gchar* _tmp34_;
	gchar* _tmp35_;
	gchar* _tmp36_;
	gchar* job_name = NULL;
	GVariant* _tmp37_;
	GVariant* _tmp38_;
	const gchar* _tmp39_;
	gchar* _tmp40_;
	gchar* _tmp41_;
	guint32 job_impressions_completed = 0U;
	GVariant* _tmp42_;
	GVariant* _tmp43_;
	guint32 _tmp44_;
	const gchar* _tmp45_;
	GQuark _tmp47_ = 0U;
	static GQuark _tmp46_label0 = 0;
	static GQuark _tmp46_label1 = 0;
	static GQuark _tmp46_label2 = 0;
	static GQuark _tmp46_label3 = 0;
	static GQuark _tmp46_label4 = 0;
	static GQuark _tmp46_label5 = 0;
	static GQuark _tmp46_label6 = 0;
	g_return_if_fail (self != NULL);
	g_return_if_fail (signal_name != NULL);
	g_return_if_fail (parameters != NULL);
	_tmp0_ = g_variant_get_child_value (parameters, (gsize) 0);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_variant_get_string (_tmp1_, NULL);
	_tmp3_ = g_strdup (_tmp2_);
	_tmp4_ = _tmp3_;
	_g_variant_unref0 (_tmp1_);
	text = _tmp4_;
	_tmp5_ = g_variant_get_child_value (parameters, (gsize) 1);
	_tmp6_ = _tmp5_;
	_tmp7_ = g_variant_get_string (_tmp6_, NULL);
	_tmp8_ = g_strdup (_tmp7_);
	_tmp9_ = _tmp8_;
	_g_variant_unref0 (_tmp6_);
	printer_uri = _tmp9_;
	_tmp10_ = g_variant_get_child_value (parameters, (gsize) 2);
	_tmp11_ = _tmp10_;
	_tmp12_ = g_variant_get_string (_tmp11_, NULL);
	_tmp13_ = g_strdup (_tmp12_);
	_tmp14_ = _tmp13_;
	_g_variant_unref0 (_tmp11_);
	name = _tmp14_;
	_tmp15_ = g_variant_get_child_value (parameters, (gsize) 3);
	_tmp16_ = _tmp15_;
	_tmp17_ = g_variant_get_uint32 (_tmp16_);
	_g_variant_unref0 (_tmp16_);
	printer_state = _tmp17_;
	_tmp18_ = g_variant_get_child_value (parameters, (gsize) 4);
	_tmp19_ = _tmp18_;
	_tmp20_ = g_variant_get_string (_tmp19_, NULL);
	_tmp21_ = g_strdup (_tmp20_);
	_tmp22_ = _tmp21_;
	_g_variant_unref0 (_tmp19_);
	state_reasons = _tmp22_;
	_tmp23_ = g_variant_get_child_value (parameters, (gsize) 5);
	_tmp24_ = _tmp23_;
	_tmp25_ = g_variant_get_boolean (_tmp24_);
	_g_variant_unref0 (_tmp24_);
	is_accepting_jobs = _tmp25_;
	_tmp26_ = g_variant_get_child_value (parameters, (gsize) 6);
	_tmp27_ = _tmp26_;
	_tmp28_ = g_variant_get_uint32 (_tmp27_);
	_g_variant_unref0 (_tmp27_);
	job_id = _tmp28_;
	_tmp29_ = g_variant_get_child_value (parameters, (gsize) 7);
	_tmp30_ = _tmp29_;
	_tmp31_ = g_variant_get_uint32 (_tmp30_);
	_g_variant_unref0 (_tmp30_);
	job_state = _tmp31_;
	_tmp32_ = g_variant_get_child_value (parameters, (gsize) 8);
	_tmp33_ = _tmp32_;
	_tmp34_ = g_variant_get_string (_tmp33_, NULL);
	_tmp35_ = g_strdup (_tmp34_);
	_tmp36_ = _tmp35_;
	_g_variant_unref0 (_tmp33_);
	job_state_reason = _tmp36_;
	_tmp37_ = g_variant_get_child_value (parameters, (gsize) 9);
	_tmp38_ = _tmp37_;
	_tmp39_ = g_variant_get_string (_tmp38_, NULL);
	_tmp40_ = g_strdup (_tmp39_);
	_tmp41_ = _tmp40_;
	_g_variant_unref0 (_tmp38_);
	job_name = _tmp41_;
	_tmp42_ = g_variant_get_child_value (parameters, (gsize) 10);
	_tmp43_ = _tmp42_;
	_tmp44_ = g_variant_get_uint32 (_tmp43_);
	_g_variant_unref0 (_tmp43_);
	job_impressions_completed = _tmp44_;
	_tmp45_ = signal_name;
	_tmp47_ = (NULL == _tmp45_) ? 0 : g_quark_from_string (_tmp45_);
	if (_tmp47_ == ((0 != _tmp46_label0) ? _tmp46_label0 : (_tmp46_label0 = g_quark_from_static_string ("JobCreated")))) {
		switch (0) {
			default:
			{
				const gchar* _tmp48_;
				const gchar* _tmp49_;
				const gchar* _tmp50_;
				const gchar* _tmp51_;
				const gchar* _tmp52_;
				const gchar* _tmp53_;
				_tmp48_ = text;
				_tmp49_ = printer_uri;
				_tmp50_ = name;
				_tmp51_ = state_reasons;
				_tmp52_ = job_state_reason;
				_tmp53_ = job_name;
				g_signal_emit (self, cups_notifier_signals[CUPS_NOTIFIER_JOB_CREATED_SIGNAL], 0, _tmp48_, _tmp49_, _tmp50_, printer_state, _tmp51_, is_accepting_jobs, job_id, job_state, _tmp52_, _tmp53_, job_impressions_completed);
				break;
			}
		}
	} else if ((_tmp47_ == ((0 != _tmp46_label1) ? _tmp46_label1 : (_tmp46_label1 = g_quark_from_static_string ("JobConfigChanged")))) || (_tmp47_ == ((0 != _tmp46_label2) ? _tmp46_label2 : (_tmp46_label2 = g_quark_from_static_string ("JobProgress"))))) {
		switch (0) {
			default:
			{
				const gchar* _tmp54_;
				const gchar* _tmp55_;
				const gchar* _tmp56_;
				const gchar* _tmp57_;
				const gchar* _tmp58_;
				const gchar* _tmp59_;
				_tmp54_ = text;
				_tmp55_ = printer_uri;
				_tmp56_ = name;
				_tmp57_ = state_reasons;
				_tmp58_ = job_state_reason;
				_tmp59_ = job_name;
				g_signal_emit (self, cups_notifier_signals[CUPS_NOTIFIER_JOB_PROGRESS_SIGNAL], 0, _tmp54_, _tmp55_, _tmp56_, printer_state, _tmp57_, is_accepting_jobs, job_id, job_state, _tmp58_, _tmp59_, job_impressions_completed);
				break;
			}
		}
	} else if (_tmp47_ == ((0 != _tmp46_label3) ? _tmp46_label3 : (_tmp46_label3 = g_quark_from_static_string ("JobCompleted")))) {
		switch (0) {
			default:
			{
				const gchar* _tmp60_;
				const gchar* _tmp61_;
				const gchar* _tmp62_;
				const gchar* _tmp63_;
				const gchar* _tmp64_;
				const gchar* _tmp65_;
				_tmp60_ = text;
				_tmp61_ = printer_uri;
				_tmp62_ = name;
				_tmp63_ = state_reasons;
				_tmp64_ = job_state_reason;
				_tmp65_ = job_name;
				g_signal_emit (self, cups_notifier_signals[CUPS_NOTIFIER_JOB_COMPLETED_SIGNAL], 0, _tmp60_, _tmp61_, _tmp62_, printer_state, _tmp63_, is_accepting_jobs, job_id, job_state, _tmp64_, _tmp65_, job_impressions_completed);
				break;
			}
		}
	} else if (((_tmp47_ == ((0 != _tmp46_label4) ? _tmp46_label4 : (_tmp46_label4 = g_quark_from_static_string ("JobStopped")))) || (_tmp47_ == ((0 != _tmp46_label5) ? _tmp46_label5 : (_tmp46_label5 = g_quark_from_static_string ("JobState"))))) || (_tmp47_ == ((0 != _tmp46_label6) ? _tmp46_label6 : (_tmp46_label6 = g_quark_from_static_string ("JobStateChanged"))))) {
		switch (0) {
			default:
			{
				const gchar* _tmp66_;
				const gchar* _tmp67_;
				const gchar* _tmp68_;
				const gchar* _tmp69_;
				const gchar* _tmp70_;
				const gchar* _tmp71_;
				_tmp66_ = text;
				_tmp67_ = printer_uri;
				_tmp68_ = name;
				_tmp69_ = state_reasons;
				_tmp70_ = job_state_reason;
				_tmp71_ = job_name;
				g_signal_emit (self, cups_notifier_signals[CUPS_NOTIFIER_JOB_STATE_CHANGED_SIGNAL], 0, _tmp66_, _tmp67_, _tmp68_, printer_state, _tmp69_, is_accepting_jobs, job_id, job_state, _tmp70_, _tmp71_, job_impressions_completed);
				break;
			}
		}
	} else {
		switch (0) {
			default:
			{
				g_debug ("CUPSNotifier.vala:171: Signal `%s` isn't handled by the plug", signal_name);
				break;
			}
		}
	}
	_g_free0 (job_name);
	_g_free0 (job_state_reason);
	_g_free0 (state_reasons);
	_g_free0 (name);
	_g_free0 (printer_uri);
	_g_free0 (text);
}

static void
g_cclosure_user_marshal_VOID__STRING_STRING_STRING_UINT_STRING_BOOLEAN (GClosure * closure,
                                                                        GValue * return_value,
                                                                        guint n_param_values,
                                                                        const GValue * param_values,
                                                                        gpointer invocation_hint,
                                                                        gpointer marshal_data)
{
	typedef void (*GMarshalFunc_VOID__STRING_STRING_STRING_UINT_STRING_BOOLEAN) (gpointer data1, const char* arg_1, const char* arg_2, const char* arg_3, guint32 arg_4, const char* arg_5, gboolean arg_6, gpointer data2);
	register GMarshalFunc_VOID__STRING_STRING_STRING_UINT_STRING_BOOLEAN callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 7);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__STRING_STRING_STRING_UINT_STRING_BOOLEAN) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_string (param_values + 1), g_value_get_string (param_values + 2), g_value_get_string (param_values + 3), g_value_get_uint (param_values + 4), g_value_get_string (param_values + 5), g_value_get_boolean (param_values + 6), data2);
}

static void
g_cclosure_user_marshal_VOID__STRING_STRING_STRING_UINT_STRING_BOOLEAN_UINT_UINT_STRING_STRING_UINT (GClosure * closure,
                                                                                                     GValue * return_value,
                                                                                                     guint n_param_values,
                                                                                                     const GValue * param_values,
                                                                                                     gpointer invocation_hint,
                                                                                                     gpointer marshal_data)
{
	typedef void (*GMarshalFunc_VOID__STRING_STRING_STRING_UINT_STRING_BOOLEAN_UINT_UINT_STRING_STRING_UINT) (gpointer data1, const char* arg_1, const char* arg_2, const char* arg_3, guint32 arg_4, const char* arg_5, gboolean arg_6, guint32 arg_7, guint32 arg_8, const char* arg_9, const char* arg_10, guint32 arg_11, gpointer data2);
	register GMarshalFunc_VOID__STRING_STRING_STRING_UINT_STRING_BOOLEAN_UINT_UINT_STRING_STRING_UINT callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 12);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__STRING_STRING_STRING_UINT_STRING_BOOLEAN_UINT_UINT_STRING_STRING_UINT) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_string (param_values + 1), g_value_get_string (param_values + 2), g_value_get_string (param_values + 3), g_value_get_uint (param_values + 4), g_value_get_string (param_values + 5), g_value_get_boolean (param_values + 6), g_value_get_uint (param_values + 7), g_value_get_uint (param_values + 8), g_value_get_string (param_values + 9), g_value_get_string (param_values + 10), g_value_get_uint (param_values + 11), data2);
}

static void
cups_notifier_class_init (CupsNotifierClass * klass,
                          gpointer klass_data)
{
	cups_notifier_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &CupsNotifier_private_offset);
	G_OBJECT_CLASS (klass)->finalize = cups_notifier_finalize;
	cups_notifier_signals[CUPS_NOTIFIER_SERVER_RESTARTED_SIGNAL] = g_signal_new ("server-restarted", CUPS_TYPE_NOTIFIER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__STRING, G_TYPE_NONE, 1, G_TYPE_STRING);
	cups_notifier_signals[CUPS_NOTIFIER_SERVER_STARTED_SIGNAL] = g_signal_new ("server-started", CUPS_TYPE_NOTIFIER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__STRING, G_TYPE_NONE, 1, G_TYPE_STRING);
	cups_notifier_signals[CUPS_NOTIFIER_SERVER_STOPPED_SIGNAL] = g_signal_new ("server-stopped", CUPS_TYPE_NOTIFIER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__STRING, G_TYPE_NONE, 1, G_TYPE_STRING);
	cups_notifier_signals[CUPS_NOTIFIER_SERVER_AUDIT_SIGNAL] = g_signal_new ("server-audit", CUPS_TYPE_NOTIFIER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__STRING, G_TYPE_NONE, 1, G_TYPE_STRING);
	cups_notifier_signals[CUPS_NOTIFIER_PRINTER_STATE_CHANGED_SIGNAL] = g_signal_new ("printer-state-changed", CUPS_TYPE_NOTIFIER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__STRING_STRING_STRING_UINT_STRING_BOOLEAN, G_TYPE_NONE, 6, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_UINT, G_TYPE_STRING, G_TYPE_BOOLEAN);
	cups_notifier_signals[CUPS_NOTIFIER_PRINTER_FINISHINGS_CHANGED_SIGNAL] = g_signal_new ("printer-finishings-changed", CUPS_TYPE_NOTIFIER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__STRING_STRING_STRING_UINT_STRING_BOOLEAN, G_TYPE_NONE, 6, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_UINT, G_TYPE_STRING, G_TYPE_BOOLEAN);
	cups_notifier_signals[CUPS_NOTIFIER_PRINTER_MEDIA_CHANGED_SIGNAL] = g_signal_new ("printer-media-changed", CUPS_TYPE_NOTIFIER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__STRING_STRING_STRING_UINT_STRING_BOOLEAN, G_TYPE_NONE, 6, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_UINT, G_TYPE_STRING, G_TYPE_BOOLEAN);
	cups_notifier_signals[CUPS_NOTIFIER_PRINTER_ADDED_SIGNAL] = g_signal_new ("printer-added", CUPS_TYPE_NOTIFIER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__STRING_STRING_STRING_UINT_STRING_BOOLEAN, G_TYPE_NONE, 6, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_UINT, G_TYPE_STRING, G_TYPE_BOOLEAN);
	cups_notifier_signals[CUPS_NOTIFIER_PRINTER_DELETED_SIGNAL] = g_signal_new ("printer-deleted", CUPS_TYPE_NOTIFIER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__STRING_STRING_STRING_UINT_STRING_BOOLEAN, G_TYPE_NONE, 6, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_UINT, G_TYPE_STRING, G_TYPE_BOOLEAN);
	cups_notifier_signals[CUPS_NOTIFIER_PRINTER_MODIFIED_SIGNAL] = g_signal_new ("printer-modified", CUPS_TYPE_NOTIFIER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__STRING_STRING_STRING_UINT_STRING_BOOLEAN, G_TYPE_NONE, 6, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_UINT, G_TYPE_STRING, G_TYPE_BOOLEAN);
	cups_notifier_signals[CUPS_NOTIFIER_JOB_CREATED_SIGNAL] = g_signal_new ("job-created", CUPS_TYPE_NOTIFIER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__STRING_STRING_STRING_UINT_STRING_BOOLEAN_UINT_UINT_STRING_STRING_UINT, G_TYPE_NONE, 11, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_UINT, G_TYPE_STRING, G_TYPE_BOOLEAN, G_TYPE_UINT, G_TYPE_UINT, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_UINT);
	cups_notifier_signals[CUPS_NOTIFIER_JOB_COMPLETED_SIGNAL] = g_signal_new ("job-completed", CUPS_TYPE_NOTIFIER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__STRING_STRING_STRING_UINT_STRING_BOOLEAN_UINT_UINT_STRING_STRING_UINT, G_TYPE_NONE, 11, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_UINT, G_TYPE_STRING, G_TYPE_BOOLEAN, G_TYPE_UINT, G_TYPE_UINT, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_UINT);
	cups_notifier_signals[CUPS_NOTIFIER_JOB_STOPPED_SIGNAL] = g_signal_new ("job-stopped", CUPS_TYPE_NOTIFIER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__STRING_STRING_STRING_UINT_STRING_BOOLEAN_UINT_UINT_STRING_STRING_UINT, G_TYPE_NONE, 11, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_UINT, G_TYPE_STRING, G_TYPE_BOOLEAN, G_TYPE_UINT, G_TYPE_UINT, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_UINT);
	cups_notifier_signals[CUPS_NOTIFIER_JOB_CONFIG_CHANGED_SIGNAL] = g_signal_new ("job-config-changed", CUPS_TYPE_NOTIFIER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__STRING_STRING_STRING_UINT_STRING_BOOLEAN_UINT_UINT_STRING_STRING_UINT, G_TYPE_NONE, 11, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_UINT, G_TYPE_STRING, G_TYPE_BOOLEAN, G_TYPE_UINT, G_TYPE_UINT, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_UINT);
	cups_notifier_signals[CUPS_NOTIFIER_JOB_PROGRESS_SIGNAL] = g_signal_new ("job-progress", CUPS_TYPE_NOTIFIER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__STRING_STRING_STRING_UINT_STRING_BOOLEAN_UINT_UINT_STRING_STRING_UINT, G_TYPE_NONE, 11, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_UINT, G_TYPE_STRING, G_TYPE_BOOLEAN, G_TYPE_UINT, G_TYPE_UINT, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_UINT);
	cups_notifier_signals[CUPS_NOTIFIER_JOB_STATE_SIGNAL] = g_signal_new ("job-state", CUPS_TYPE_NOTIFIER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__STRING_STRING_STRING_UINT_STRING_BOOLEAN_UINT_UINT_STRING_STRING_UINT, G_TYPE_NONE, 11, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_UINT, G_TYPE_STRING, G_TYPE_BOOLEAN, G_TYPE_UINT, G_TYPE_UINT, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_UINT);
	cups_notifier_signals[CUPS_NOTIFIER_JOB_STATE_CHANGED_SIGNAL] = g_signal_new ("job-state-changed", CUPS_TYPE_NOTIFIER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__STRING_STRING_STRING_UINT_STRING_BOOLEAN_UINT_UINT_STRING_STRING_UINT, G_TYPE_NONE, 11, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_UINT, G_TYPE_STRING, G_TYPE_BOOLEAN, G_TYPE_UINT, G_TYPE_UINT, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_UINT);
}

static void
cups_notifier_instance_init (CupsNotifier * self,
                             gpointer klass)
{
	self->priv = cups_notifier_get_instance_private (self);
}

static void
cups_notifier_finalize (GObject * obj)
{
	CupsNotifier * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, CUPS_TYPE_NOTIFIER, CupsNotifier);
	_g_object_unref0 (self->priv->dbus_notifier);
	G_OBJECT_CLASS (cups_notifier_parent_class)->finalize (obj);
}

static GType
cups_notifier_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (CupsNotifierClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) cups_notifier_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (CupsNotifier), 0, (GInstanceInitFunc) cups_notifier_instance_init, NULL };
	GType cups_notifier_type_id;
	cups_notifier_type_id = g_type_register_static (G_TYPE_OBJECT, "CupsNotifier", &g_define_type_info, 0);
	CupsNotifier_private_offset = g_type_add_instance_private (cups_notifier_type_id, sizeof (CupsNotifierPrivate));
	return cups_notifier_type_id;
}

GType
cups_notifier_get_type (void)
{
	static volatile gsize cups_notifier_type_id__once = 0;
	if (g_once_init_enter (&cups_notifier_type_id__once)) {
		GType cups_notifier_type_id;
		cups_notifier_type_id = cups_notifier_get_type_once ();
		g_once_init_leave (&cups_notifier_type_id__once, cups_notifier_type_id);
	}
	return cups_notifier_type_id__once;
}

