/* CategoryView.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from CategoryView.vala, do not modify */

/*
 * SPDX-License-Identifier: LGPL-2.1-or-later
 * SPDX-FileCopyrightText: 2011-2024 elementary, Inc. (https://elementary.io)
 *
 * Authored by: Avi Romanoff <aviromanoff@gmail.com>
 */

#include <adwaita.h>
#include <glib-object.h>
#include <gee.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gtk/gtk.h>
#include <gio/gio.h>
#include "switchboard.h"
#include <glib/gi18n-lib.h>
#include <granite-7.h>
#include <gdk/gdk.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define SWITCHBOARD_TYPE_CATEGORY_VIEW (switchboard_category_view_get_type ())
#define SWITCHBOARD_CATEGORY_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SWITCHBOARD_TYPE_CATEGORY_VIEW, SwitchboardCategoryView))
#define SWITCHBOARD_CATEGORY_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SWITCHBOARD_TYPE_CATEGORY_VIEW, SwitchboardCategoryViewClass))
#define SWITCHBOARD_IS_CATEGORY_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SWITCHBOARD_TYPE_CATEGORY_VIEW))
#define SWITCHBOARD_IS_CATEGORY_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SWITCHBOARD_TYPE_CATEGORY_VIEW))
#define SWITCHBOARD_CATEGORY_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SWITCHBOARD_TYPE_CATEGORY_VIEW, SwitchboardCategoryViewClass))

typedef struct _SwitchboardCategoryView SwitchboardCategoryView;
typedef struct _SwitchboardCategoryViewClass SwitchboardCategoryViewClass;
typedef struct _SwitchboardCategoryViewPrivate SwitchboardCategoryViewPrivate;

#define SWITCHBOARD_TYPE_SEARCH_ENTRY (switchboard_search_entry_get_type ())
typedef struct _SwitchboardSearchEntry SwitchboardSearchEntry;

#define SWITCHBOARD_TYPE_PLUGS_SEARCH (switchboard_plugs_search_get_type ())
#define SWITCHBOARD_PLUGS_SEARCH(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SWITCHBOARD_TYPE_PLUGS_SEARCH, SwitchboardPlugsSearch))
#define SWITCHBOARD_PLUGS_SEARCH_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SWITCHBOARD_TYPE_PLUGS_SEARCH, SwitchboardPlugsSearchClass))
#define SWITCHBOARD_IS_PLUGS_SEARCH(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SWITCHBOARD_TYPE_PLUGS_SEARCH))
#define SWITCHBOARD_IS_PLUGS_SEARCH_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SWITCHBOARD_TYPE_PLUGS_SEARCH))
#define SWITCHBOARD_PLUGS_SEARCH_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SWITCHBOARD_TYPE_PLUGS_SEARCH, SwitchboardPlugsSearchClass))

typedef struct _SwitchboardPlugsSearch SwitchboardPlugsSearch;
typedef struct _SwitchboardPlugsSearchClass SwitchboardPlugsSearchClass;

#define SWITCHBOARD_TYPE_CATEGORY (switchboard_category_get_type ())
#define SWITCHBOARD_CATEGORY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SWITCHBOARD_TYPE_CATEGORY, SwitchboardCategory))
#define SWITCHBOARD_CATEGORY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SWITCHBOARD_TYPE_CATEGORY, SwitchboardCategoryClass))
#define SWITCHBOARD_IS_CATEGORY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SWITCHBOARD_TYPE_CATEGORY))
#define SWITCHBOARD_IS_CATEGORY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SWITCHBOARD_TYPE_CATEGORY))
#define SWITCHBOARD_CATEGORY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SWITCHBOARD_TYPE_CATEGORY, SwitchboardCategoryClass))

typedef struct _SwitchboardCategory SwitchboardCategory;
typedef struct _SwitchboardCategoryClass SwitchboardCategoryClass;
enum  {
	SWITCHBOARD_CATEGORY_VIEW_0_PROPERTY,
	SWITCHBOARD_CATEGORY_VIEW_PLUG_SEARCH_RESULT_PROPERTY,
	SWITCHBOARD_CATEGORY_VIEW_PLUG_TO_OPEN_PROPERTY,
	SWITCHBOARD_CATEGORY_VIEW_NUM_PROPERTIES
};
static GParamSpec* switchboard_category_view_properties[SWITCHBOARD_CATEGORY_VIEW_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _switchboard_plugs_search_unref0(var) ((var == NULL) ? NULL : (var = (switchboard_plugs_search_unref (var), NULL)))
typedef struct _SwitchboardCategoryViewLoadDefaultPlugsData SwitchboardCategoryViewLoadDefaultPlugsData;

#define SWITCHBOARD_TYPE_CATEGORY_ICON (switchboard_category_icon_get_type ())
#define SWITCHBOARD_CATEGORY_ICON(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SWITCHBOARD_TYPE_CATEGORY_ICON, SwitchboardCategoryIcon))
#define SWITCHBOARD_CATEGORY_ICON_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SWITCHBOARD_TYPE_CATEGORY_ICON, SwitchboardCategoryIconClass))
#define SWITCHBOARD_IS_CATEGORY_ICON(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SWITCHBOARD_TYPE_CATEGORY_ICON))
#define SWITCHBOARD_IS_CATEGORY_ICON_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SWITCHBOARD_TYPE_CATEGORY_ICON))
#define SWITCHBOARD_CATEGORY_ICON_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SWITCHBOARD_TYPE_CATEGORY_ICON, SwitchboardCategoryIconClass))

typedef struct _SwitchboardCategoryIcon SwitchboardCategoryIcon;
typedef struct _SwitchboardCategoryIconClass SwitchboardCategoryIconClass;

#define SWITCHBOARD_TYPE_SWITCHBOARD_APP (switchboard_switchboard_app_get_type ())
#define SWITCHBOARD_SWITCHBOARD_APP(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SWITCHBOARD_TYPE_SWITCHBOARD_APP, SwitchboardSwitchboardApp))
#define SWITCHBOARD_SWITCHBOARD_APP_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SWITCHBOARD_TYPE_SWITCHBOARD_APP, SwitchboardSwitchboardAppClass))
#define SWITCHBOARD_IS_SWITCHBOARD_APP(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SWITCHBOARD_TYPE_SWITCHBOARD_APP))
#define SWITCHBOARD_IS_SWITCHBOARD_APP_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SWITCHBOARD_TYPE_SWITCHBOARD_APP))
#define SWITCHBOARD_SWITCHBOARD_APP_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SWITCHBOARD_TYPE_SWITCHBOARD_APP, SwitchboardSwitchboardAppClass))

typedef struct _SwitchboardSwitchboardApp SwitchboardSwitchboardApp;
typedef struct _SwitchboardSwitchboardAppClass SwitchboardSwitchboardAppClass;

#define SWITCHBOARD_TYPE_SEARCH_VIEW (switchboard_search_view_get_type ())
#define SWITCHBOARD_SEARCH_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SWITCHBOARD_TYPE_SEARCH_VIEW, SwitchboardSearchView))
#define SWITCHBOARD_SEARCH_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SWITCHBOARD_TYPE_SEARCH_VIEW, SwitchboardSearchViewClass))
#define SWITCHBOARD_IS_SEARCH_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SWITCHBOARD_TYPE_SEARCH_VIEW))
#define SWITCHBOARD_IS_SEARCH_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SWITCHBOARD_TYPE_SEARCH_VIEW))
#define SWITCHBOARD_SEARCH_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SWITCHBOARD_TYPE_SEARCH_VIEW, SwitchboardSearchViewClass))

typedef struct _SwitchboardSearchView SwitchboardSearchView;
typedef struct _SwitchboardSearchViewClass SwitchboardSearchViewClass;
typedef struct _Block3Data Block3Data;

struct _SwitchboardCategoryView {
	AdwNavigationPage parent_instance;
	SwitchboardCategoryViewPrivate * priv;
};

struct _SwitchboardCategoryViewClass {
	AdwNavigationPageClass parent_class;
};

struct _SwitchboardSearchEntry {
	gchar* plug_name;
	gchar* ui_elements;
	gchar* open_window;
};

struct _SwitchboardCategoryViewPrivate {
	GeeArrayList* _plug_search_result;
	gchar* _plug_to_open;
	GtkSearchEntry* search_box;
	GtkStack* stack;
	SwitchboardPlugsSearch* plug_search;
	SwitchboardCategory* hardware_category;
	SwitchboardCategory* network_category;
	SwitchboardCategory* personal_category;
	SwitchboardCategory* system_category;
};

struct _SwitchboardCategoryViewLoadDefaultPlugsData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	SwitchboardCategoryView* self;
	SwitchboardPlugsManager* plugsmanager;
	SwitchboardPlugsManager* _tmp0_;
	SwitchboardPlugsManager* _tmp1_;
	GeeIterator* _plug_it;
	SwitchboardPlugsManager* _tmp2_;
	GeeCollection* _tmp3_;
	GeeCollection* _tmp4_;
	GeeIterator* _tmp5_;
	GeeIterator* _tmp6_;
	GeeIterator* _tmp7_;
	SwitchboardPlug* plug;
	GeeIterator* _tmp8_;
	gpointer _tmp9_;
	SwitchboardPlug* _tmp10_;
};

struct _Block3Data {
	int _ref_count_;
	SwitchboardCategoryView* self;
	SwitchboardSearchView* searchview;
	GtkBox* category_box;
	GtkEventControllerKey* eventcontrollerkey;
};

static gint SwitchboardCategoryView_private_offset;
static gpointer switchboard_category_view_parent_class = NULL;

VALA_EXTERN GType switchboard_category_view_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SwitchboardCategoryView, g_object_unref)
VALA_EXTERN GType switchboard_search_entry_get_type (void) G_GNUC_CONST ;
VALA_EXTERN SwitchboardSearchEntry* switchboard_search_entry_dup (const SwitchboardSearchEntry* self);
VALA_EXTERN void switchboard_search_entry_free (SwitchboardSearchEntry* self);
VALA_EXTERN void switchboard_search_entry_copy (const SwitchboardSearchEntry* self,
                                    SwitchboardSearchEntry* dest);
VALA_EXTERN void switchboard_search_entry_destroy (SwitchboardSearchEntry* self);
G_DEFINE_AUTO_CLEANUP_CLEAR_FUNC (SwitchboardSearchEntry, switchboard_search_entry_destroy)
VALA_EXTERN gpointer switchboard_plugs_search_ref (gpointer instance);
VALA_EXTERN void switchboard_plugs_search_unref (gpointer instance);
VALA_EXTERN GParamSpec* switchboard_param_spec_plugs_search (const gchar* name,
                                                 const gchar* nick,
                                                 const gchar* blurb,
                                                 GType object_type,
                                                 GParamFlags flags);
VALA_EXTERN void switchboard_value_set_plugs_search (GValue* value,
                                         gpointer v_object);
VALA_EXTERN void switchboard_value_take_plugs_search (GValue* value,
                                          gpointer v_object);
VALA_EXTERN gpointer switchboard_value_get_plugs_search (const GValue* value);
VALA_EXTERN GType switchboard_plugs_search_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SwitchboardPlugsSearch, switchboard_plugs_search_unref)
VALA_EXTERN GType switchboard_category_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SwitchboardCategory, g_object_unref)
VALA_EXTERN SwitchboardCategoryView* switchboard_category_view_new (const gchar* plug);
VALA_EXTERN SwitchboardCategoryView* switchboard_category_view_construct (GType object_type,
                                                              const gchar* plug);
static void switchboard_category_view_load_default_plugs_data_free (gpointer _data);
VALA_EXTERN void switchboard_category_view_load_default_plugs (SwitchboardCategoryView* self,
                                                   GAsyncReadyCallback _callback_,
                                                   gpointer _user_data_);
VALA_EXTERN void switchboard_category_view_load_default_plugs_finish (SwitchboardCategoryView* self,
                                                          GAsyncResult* _res_);
static gboolean switchboard_category_view_load_default_plugs_co (SwitchboardCategoryViewLoadDefaultPlugsData* _data_);
static void __lambda10_ (SwitchboardCategoryView* self,
                  SwitchboardPlug* plug);
static void switchboard_category_view_add_plug (SwitchboardCategoryView* self,
                                         SwitchboardPlug* plug);
static void ___lambda10__switchboard_plugs_manager_plug_added (SwitchboardPlugsManager* _sender,
                                                        SwitchboardPlug* plug,
                                                        gpointer self);
VALA_EXTERN GType switchboard_category_icon_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SwitchboardCategoryIcon, g_object_unref)
VALA_EXTERN SwitchboardCategoryIcon* switchboard_category_icon_new (SwitchboardPlug* plug);
VALA_EXTERN SwitchboardCategoryIcon* switchboard_category_icon_construct (GType object_type,
                                                              SwitchboardPlug* plug);
VALA_EXTERN void switchboard_category_add (SwitchboardCategory* self,
                               GtkWidget* widget);
VALA_EXTERN gboolean switchboard_category_has_child (SwitchboardCategory* self);
VALA_EXTERN const gchar* switchboard_category_view_get_plug_to_open (SwitchboardCategoryView* self);
VALA_EXTERN GType switchboard_switchboard_app_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SwitchboardSwitchboardApp, g_object_unref)
VALA_EXTERN void switchboard_switchboard_app_load_plug (SwitchboardSwitchboardApp* self,
                                            SwitchboardPlug* plug);
VALA_EXTERN void switchboard_category_view_set_plug_to_open (SwitchboardCategoryView* self,
                                                 const gchar* value);
VALA_EXTERN gchar* switchboard_category_view_get_category_name (SwitchboardPlugCategory category);
VALA_EXTERN GeeArrayList* switchboard_category_view_get_plug_search_result (SwitchboardCategoryView* self);
static void switchboard_category_view_set_plug_search_result (SwitchboardCategoryView* self,
                                                       GeeArrayList* value);
static GObject * switchboard_category_view_constructor (GType type,
                                                 guint n_construct_properties,
                                                 GObjectConstructParam * construct_properties);
VALA_EXTERN GType switchboard_search_view_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SwitchboardSearchView, g_object_unref)
static Block3Data* block3_data_ref (Block3Data* _data3_);
static void block3_data_unref (void * _userdata_);
VALA_EXTERN SwitchboardSearchView* switchboard_search_view_new (GtkSearchEntry* search_entry);
VALA_EXTERN SwitchboardSearchView* switchboard_search_view_construct (GType object_type,
                                                          GtkSearchEntry* search_entry);
VALA_EXTERN SwitchboardCategory* switchboard_category_new (SwitchboardPlugCategory category);
VALA_EXTERN SwitchboardCategory* switchboard_category_construct (GType object_type,
                                                     SwitchboardPlugCategory category);
VALA_EXTERN SwitchboardPlugsSearch* switchboard_plugs_search_new (void);
VALA_EXTERN SwitchboardPlugsSearch* switchboard_plugs_search_construct (GType object_type);
static void _switchboard_category_view___lambda13_ (Block3Data* _data3_);
static void __switchboard_category_view___lambda13__gtk_search_entry_search_changed (GtkSearchEntry* _sender,
                                                                              gpointer self);
static void _switchboard_category_view___lambda14_ (Block3Data* _data3_);
VALA_EXTERN void switchboard_search_view_activate_first_item (SwitchboardSearchView* self);
static void __switchboard_category_view___lambda14__gtk_search_entry_activate (GtkSearchEntry* _sender,
                                                                        gpointer self);
static void _switchboard_category_view___lambda15_ (SwitchboardCategoryView* self,
                                             guint keyval,
                                             guint keycode,
                                             GdkModifierType state);
static void __switchboard_category_view___lambda15__gtk_event_controller_key_key_released (GtkEventControllerKey* _sender,
                                                                                    guint keyval,
                                                                                    guint keycode,
                                                                                    GdkModifierType state,
                                                                                    gpointer self);
static gboolean _switchboard_category_view___lambda16_ (Block3Data* _data3_,
                                                 guint keyval,
                                                 guint keycode,
                                                 GdkModifierType state);
static gboolean __switchboard_category_view___lambda16__gtk_event_controller_key_key_pressed (GtkEventControllerKey* _sender,
                                                                                       guint keyval,
                                                                                       guint keycode,
                                                                                       GdkModifierType state,
                                                                                       gpointer self);
static void switchboard_category_view_finalize (GObject * obj);
static GType switchboard_category_view_get_type_once (void);
static void _vala_switchboard_category_view_get_property (GObject * object,
                                                   guint property_id,
                                                   GValue * value,
                                                   GParamSpec * pspec);
static void _vala_switchboard_category_view_set_property (GObject * object,
                                                   guint property_id,
                                                   const GValue * value,
                                                   GParamSpec * pspec);

static inline gpointer
switchboard_category_view_get_instance_private (SwitchboardCategoryView* self)
{
	return G_STRUCT_MEMBER_P (self, SwitchboardCategoryView_private_offset);
}

SwitchboardCategoryView*
switchboard_category_view_construct (GType object_type,
                                     const gchar* plug)
{
	SwitchboardCategoryView * self = NULL;
	self = (SwitchboardCategoryView*) g_object_new (object_type, "plug-to-open", plug, NULL);
	return self;
}

SwitchboardCategoryView*
switchboard_category_view_new (const gchar* plug)
{
	return switchboard_category_view_construct (SWITCHBOARD_TYPE_CATEGORY_VIEW, plug);
}

static void
switchboard_category_view_load_default_plugs_data_free (gpointer _data)
{
	SwitchboardCategoryViewLoadDefaultPlugsData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (SwitchboardCategoryViewLoadDefaultPlugsData, _data_);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

void
switchboard_category_view_load_default_plugs (SwitchboardCategoryView* self,
                                              GAsyncReadyCallback _callback_,
                                              gpointer _user_data_)
{
	SwitchboardCategoryViewLoadDefaultPlugsData* _data_;
	SwitchboardCategoryView* _tmp0_;
	g_return_if_fail (self != NULL);
	_data_ = g_slice_new0 (SwitchboardCategoryViewLoadDefaultPlugsData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, switchboard_category_view_load_default_plugs_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	switchboard_category_view_load_default_plugs_co (_data_);
}

void
switchboard_category_view_load_default_plugs_finish (SwitchboardCategoryView* self,
                                                     GAsyncResult* _res_)
{
	SwitchboardCategoryViewLoadDefaultPlugsData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

static void
__lambda10_ (SwitchboardCategoryView* self,
             SwitchboardPlug* plug)
{
	g_return_if_fail (plug != NULL);
	switchboard_category_view_add_plug (self, plug);
}

static void
___lambda10__switchboard_plugs_manager_plug_added (SwitchboardPlugsManager* _sender,
                                                   SwitchboardPlug* plug,
                                                   gpointer self)
{
	__lambda10_ ((SwitchboardCategoryView*) self, plug);
}

static gboolean
switchboard_category_view_load_default_plugs_co (SwitchboardCategoryViewLoadDefaultPlugsData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = switchboard_plugs_manager_get_default ();
	_data_->plugsmanager = _data_->_tmp0_;
	_data_->_tmp1_ = _data_->plugsmanager;
	g_signal_connect_object (_data_->_tmp1_, "plug-added", (GCallback) ___lambda10__switchboard_plugs_manager_plug_added, _data_->self, 0);
	{
		_data_->_tmp2_ = _data_->plugsmanager;
		_data_->_tmp3_ = switchboard_plugs_manager_get_plugs (_data_->_tmp2_);
		_data_->_tmp4_ = _data_->_tmp3_;
		_data_->_tmp5_ = gee_iterable_iterator ((GeeIterable*) _data_->_tmp4_);
		_data_->_tmp6_ = _data_->_tmp5_;
		_g_object_unref0 (_data_->_tmp4_);
		_data_->_plug_it = _data_->_tmp6_;
		while (TRUE) {
			_data_->_tmp7_ = _data_->_plug_it;
			if (!gee_iterator_next (_data_->_tmp7_)) {
				break;
			}
			_data_->_tmp8_ = _data_->_plug_it;
			_data_->_tmp9_ = gee_iterator_get (_data_->_tmp8_);
			_data_->plug = (SwitchboardPlug*) _data_->_tmp9_;
			_data_->_tmp10_ = _data_->plug;
			switchboard_category_view_add_plug (_data_->self, _data_->_tmp10_);
			_g_object_unref0 (_data_->plug);
		}
		_g_object_unref0 (_data_->_plug_it);
	}
	_g_object_unref0 (_data_->plugsmanager);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
switchboard_category_view_add_plug (SwitchboardCategoryView* self,
                                    SwitchboardPlug* plug)
{
	SwitchboardCategoryIcon* icon = NULL;
	SwitchboardCategoryIcon* _tmp0_;
	SwitchboardPlugCategory _tmp1_;
	SwitchboardPlugCategory _tmp2_;
	gboolean any_found = FALSE;
	SwitchboardCategory* _tmp11_;
	SwitchboardCategory* _tmp12_;
	SwitchboardCategory* _tmp13_;
	SwitchboardCategory* _tmp14_;
	gboolean _tmp16_ = FALSE;
	const gchar* _tmp17_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (plug != NULL);
	_tmp0_ = switchboard_category_icon_new (plug);
	g_object_ref_sink (_tmp0_);
	icon = _tmp0_;
	_tmp1_ = switchboard_plug_get_category (plug);
	_tmp2_ = _tmp1_;
	switch (_tmp2_) {
		case SWITCHBOARD_PLUG_CATEGORY_PERSONAL:
		{
			SwitchboardCategory* _tmp3_;
			SwitchboardCategoryIcon* _tmp4_;
			_tmp3_ = self->priv->personal_category;
			_tmp4_ = icon;
			switchboard_category_add (_tmp3_, (GtkWidget*) _tmp4_);
			break;
		}
		case SWITCHBOARD_PLUG_CATEGORY_HARDWARE:
		{
			SwitchboardCategory* _tmp5_;
			SwitchboardCategoryIcon* _tmp6_;
			_tmp5_ = self->priv->hardware_category;
			_tmp6_ = icon;
			switchboard_category_add (_tmp5_, (GtkWidget*) _tmp6_);
			break;
		}
		case SWITCHBOARD_PLUG_CATEGORY_NETWORK:
		{
			SwitchboardCategory* _tmp7_;
			SwitchboardCategoryIcon* _tmp8_;
			_tmp7_ = self->priv->network_category;
			_tmp8_ = icon;
			switchboard_category_add (_tmp7_, (GtkWidget*) _tmp8_);
			break;
		}
		case SWITCHBOARD_PLUG_CATEGORY_SYSTEM:
		{
			SwitchboardCategory* _tmp9_;
			SwitchboardCategoryIcon* _tmp10_;
			_tmp9_ = self->priv->system_category;
			_tmp10_ = icon;
			switchboard_category_add (_tmp9_, (GtkWidget*) _tmp10_);
			break;
		}
		default:
		{
			_g_object_unref0 (icon);
			return;
		}
	}
	any_found = FALSE;
	_tmp11_ = self->priv->personal_category;
	if (switchboard_category_has_child (_tmp11_)) {
		any_found = TRUE;
	}
	_tmp12_ = self->priv->hardware_category;
	if (switchboard_category_has_child (_tmp12_)) {
		any_found = TRUE;
	}
	_tmp13_ = self->priv->network_category;
	if (switchboard_category_has_child (_tmp13_)) {
		any_found = TRUE;
	}
	_tmp14_ = self->priv->system_category;
	if (switchboard_category_has_child (_tmp14_)) {
		any_found = TRUE;
	}
	if (any_found) {
		GtkStack* _tmp15_;
		_tmp15_ = self->priv->stack;
		gtk_stack_set_visible_child_name (_tmp15_, "category-grid");
	}
	_tmp17_ = self->priv->_plug_to_open;
	if (_tmp17_ != NULL) {
		const gchar* _tmp18_;
		const gchar* _tmp19_;
		const gchar* _tmp20_;
		_tmp18_ = self->priv->_plug_to_open;
		_tmp19_ = switchboard_plug_get_code_name (plug);
		_tmp20_ = _tmp19_;
		_tmp16_ = g_str_has_suffix (_tmp18_, _tmp20_);
	} else {
		_tmp16_ = FALSE;
	}
	if (_tmp16_) {
		SwitchboardSwitchboardApp* app = NULL;
		GApplication* _tmp21_;
		SwitchboardSwitchboardApp* _tmp22_;
		_tmp21_ = g_application_get_default ();
		app = G_TYPE_CHECK_INSTANCE_CAST (_tmp21_, SWITCHBOARD_TYPE_SWITCHBOARD_APP, SwitchboardSwitchboardApp);
		_tmp22_ = app;
		switchboard_switchboard_app_load_plug (_tmp22_, plug);
		switchboard_category_view_set_plug_to_open (self, NULL);
	}
	_g_object_unref0 (icon);
}

gchar*
switchboard_category_view_get_category_name (SwitchboardPlugCategory category)
{
	gchar* result;
	switch (category) {
		case SWITCHBOARD_PLUG_CATEGORY_PERSONAL:
		{
			gchar* _tmp0_;
			_tmp0_ = g_strdup (_ ("Personal"));
			result = _tmp0_;
			return result;
		}
		case SWITCHBOARD_PLUG_CATEGORY_HARDWARE:
		{
			gchar* _tmp1_;
			_tmp1_ = g_strdup (_ ("Hardware"));
			result = _tmp1_;
			return result;
		}
		case SWITCHBOARD_PLUG_CATEGORY_NETWORK:
		{
			gchar* _tmp2_;
			_tmp2_ = g_strdup (_ ("Network & Wireless"));
			result = _tmp2_;
			return result;
		}
		case SWITCHBOARD_PLUG_CATEGORY_SYSTEM:
		{
			gchar* _tmp3_;
			_tmp3_ = g_strdup (_ ("Administration"));
			result = _tmp3_;
			return result;
		}
		default:
		break;
	}
	result = NULL;
	return result;
}

GeeArrayList*
switchboard_category_view_get_plug_search_result (SwitchboardCategoryView* self)
{
	GeeArrayList* result;
	GeeArrayList* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_plug_search_result;
	result = _tmp0_;
	return result;
}

static void
switchboard_category_view_set_plug_search_result (SwitchboardCategoryView* self,
                                                  GeeArrayList* value)
{
	GeeArrayList* old_value;
	g_return_if_fail (self != NULL);
	old_value = switchboard_category_view_get_plug_search_result (self);
	if (old_value != value) {
		GeeArrayList* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_plug_search_result);
		self->priv->_plug_search_result = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, switchboard_category_view_properties[SWITCHBOARD_CATEGORY_VIEW_PLUG_SEARCH_RESULT_PROPERTY]);
	}
}

const gchar*
switchboard_category_view_get_plug_to_open (SwitchboardCategoryView* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_plug_to_open;
	result = _tmp0_;
	return result;
}

void
switchboard_category_view_set_plug_to_open (SwitchboardCategoryView* self,
                                            const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = switchboard_category_view_get_plug_to_open (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_plug_to_open);
		self->priv->_plug_to_open = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, switchboard_category_view_properties[SWITCHBOARD_CATEGORY_VIEW_PLUG_TO_OPEN_PROPERTY]);
	}
}

static Block3Data*
block3_data_ref (Block3Data* _data3_)
{
	g_atomic_int_inc (&_data3_->_ref_count_);
	return _data3_;
}

static void
block3_data_unref (void * _userdata_)
{
	Block3Data* _data3_;
	_data3_ = (Block3Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data3_->_ref_count_)) {
		SwitchboardCategoryView* self;
		self = _data3_->self;
		_g_object_unref0 (_data3_->eventcontrollerkey);
		_g_object_unref0 (_data3_->category_box);
		_g_object_unref0 (_data3_->searchview);
		_g_object_unref0 (self);
		g_slice_free (Block3Data, _data3_);
	}
}

static void
_switchboard_category_view___lambda13_ (Block3Data* _data3_)
{
	SwitchboardCategoryView* self;
	GtkSearchEntry* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	self = _data3_->self;
	_tmp0_ = self->priv->search_box;
	_tmp1_ = gtk_editable_get_text ((GtkEditable*) _tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = strlen (_tmp2_);
	_tmp4_ = _tmp3_;
	if (_tmp4_ > 0) {
		GtkStack* _tmp5_;
		SwitchboardSearchView* _tmp6_;
		_tmp5_ = self->priv->stack;
		_tmp6_ = _data3_->searchview;
		gtk_stack_set_visible_child (_tmp5_, (GtkWidget*) _tmp6_);
	} else {
		GtkStack* _tmp7_;
		GtkBox* _tmp8_;
		_tmp7_ = self->priv->stack;
		_tmp8_ = _data3_->category_box;
		gtk_stack_set_visible_child (_tmp7_, (GtkWidget*) _tmp8_);
	}
}

static void
__switchboard_category_view___lambda13__gtk_search_entry_search_changed (GtkSearchEntry* _sender,
                                                                         gpointer self)
{
	_switchboard_category_view___lambda13_ (self);
}

static void
_switchboard_category_view___lambda14_ (Block3Data* _data3_)
{
	SwitchboardCategoryView* self;
	SwitchboardSearchView* _tmp0_;
	self = _data3_->self;
	_tmp0_ = _data3_->searchview;
	switchboard_search_view_activate_first_item (_tmp0_);
}

static void
__switchboard_category_view___lambda14__gtk_search_entry_activate (GtkSearchEntry* _sender,
                                                                   gpointer self)
{
	_switchboard_category_view___lambda14_ (self);
}

static void
_switchboard_category_view___lambda15_ (SwitchboardCategoryView* self,
                                        guint keyval,
                                        guint keycode,
                                        GdkModifierType state)
{
	switch (keyval) {
		case GDK_KEY_Down:
		{
			GtkSearchEntry* _tmp0_;
			_tmp0_ = self->priv->search_box;
			g_signal_emit_by_name ((GtkWidget*) _tmp0_, "move-focus", GTK_DIR_TAB_FORWARD);
			break;
		}
		case GDK_KEY_Escape:
		{
			GtkSearchEntry* _tmp1_;
			_tmp1_ = self->priv->search_box;
			gtk_editable_set_text ((GtkEditable*) _tmp1_, "");
			break;
		}
		default:
		{
			break;
		}
	}
}

static void
__switchboard_category_view___lambda15__gtk_event_controller_key_key_released (GtkEventControllerKey* _sender,
                                                                               guint keyval,
                                                                               guint keycode,
                                                                               GdkModifierType state,
                                                                               gpointer self)
{
	_switchboard_category_view___lambda15_ ((SwitchboardCategoryView*) self, keyval, keycode, state);
}

static gboolean
_switchboard_category_view___lambda16_ (Block3Data* _data3_,
                                        guint keyval,
                                        guint keycode,
                                        GdkModifierType state)
{
	SwitchboardCategoryView* self;
	GdkModifierType mods = 0U;
	gboolean is_printable_char = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean result;
	self = _data3_->self;
	mods = state & gtk_accelerator_get_default_mod_mask ();
	is_printable_char = g_unichar_isprint ((gunichar) gdk_keyval_to_unicode (keyval));
	if (keyval == GDK_KEY_Down) {
		_tmp1_ = TRUE;
	} else {
		gboolean _tmp2_ = FALSE;
		if (is_printable_char) {
			_tmp2_ = mods == 0;
		} else {
			_tmp2_ = FALSE;
		}
		_tmp1_ = _tmp2_;
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		gboolean _tmp3_ = FALSE;
		if (is_printable_char) {
			_tmp3_ = mods == GDK_SHIFT_MASK;
		} else {
			_tmp3_ = FALSE;
		}
		_tmp0_ = _tmp3_;
	}
	if (_tmp0_) {
		GtkEventControllerKey* _tmp4_;
		GtkSearchEntry* _tmp5_;
		GtkEditable* _tmp6_;
		GtkSearchEntry* _tmp7_;
		_tmp4_ = _data3_->eventcontrollerkey;
		_tmp5_ = self->priv->search_box;
		_tmp6_ = gtk_editable_get_delegate ((GtkEditable*) _tmp5_);
		gtk_event_controller_key_forward (_tmp4_, (GtkWidget*) _tmp6_);
		_tmp7_ = self->priv->search_box;
		gtk_widget_grab_focus ((GtkWidget*) _tmp7_);
		result = GDK_EVENT_STOP;
		return result;
	}
	result = GDK_EVENT_PROPAGATE;
	return result;
}

static gboolean
__switchboard_category_view___lambda16__gtk_event_controller_key_key_pressed (GtkEventControllerKey* _sender,
                                                                              guint keyval,
                                                                              guint keycode,
                                                                              GdkModifierType state,
                                                                              gpointer self)
{
	gboolean result;
	result = _switchboard_category_view___lambda16_ (self, keyval, keycode, state);
	return result;
}

static GObject *
switchboard_category_view_constructor (GType type,
                                       guint n_construct_properties,
                                       GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	SwitchboardCategoryView * self;
	Block3Data* _data3_;
	GtkEventControllerKey* search_box_eventcontrollerkey = NULL;
	GtkEventControllerKey* _tmp0_;
	gchar* _tmp1_;
	GtkSearchEntry* _tmp2_ = NULL;
	GtkSearchEntry* _tmp3_;
	GtkEventControllerKey* _tmp4_;
	GtkEventController* _tmp5_;
	AdwClamp* search_clamp = NULL;
	GtkSearchEntry* _tmp6_;
	GtkWidget* _tmp7_;
	AdwClamp* _tmp8_ = NULL;
	GtkHeaderBar* headerbar = NULL;
	AdwClamp* _tmp9_;
	GtkWidget* _tmp10_;
	GtkHeaderBar* _tmp11_ = NULL;
	GtkSearchEntry* _tmp12_;
	SwitchboardSearchView* _tmp13_;
	GranitePlaceholder* alert_view = NULL;
	gchar* _tmp14_;
	GThemedIcon* _tmp15_;
	GranitePlaceholder* _tmp16_ = NULL;
	SwitchboardCategory* _tmp17_;
	SwitchboardCategory* _tmp18_;
	SwitchboardCategory* _tmp19_;
	SwitchboardCategory* _tmp20_;
	SwitchboardPlugsSearch* _tmp21_;
	GeeArrayList* _tmp22_;
	GeeArrayList* _tmp23_;
	GtkBox* _tmp24_ = NULL;
	GtkBox* _tmp25_;
	SwitchboardCategory* _tmp26_;
	GtkBox* _tmp27_;
	SwitchboardCategory* _tmp28_;
	GtkBox* _tmp29_;
	SwitchboardCategory* _tmp30_;
	GtkBox* _tmp31_;
	SwitchboardCategory* _tmp32_;
	GtkBox* _tmp33_;
	GtkStack* _tmp34_ = NULL;
	GtkStack* _tmp35_;
	GtkBox* _tmp36_;
	GtkStack* _tmp37_;
	SwitchboardSearchView* _tmp38_;
	AdwClamp* clamp = NULL;
	GtkStack* _tmp39_;
	GtkWidget* _tmp40_;
	AdwClamp* _tmp41_ = NULL;
	AdwClamp* _tmp42_;
	GtkScrolledWindow* scrolled = NULL;
	AdwClamp* _tmp43_;
	GtkWidget* _tmp44_;
	GtkScrolledWindow* _tmp45_ = NULL;
	AdwToolbarView* toolbarview = NULL;
	GtkScrolledWindow* _tmp46_;
	GtkWidget* _tmp47_;
	AdwToolbarView* _tmp48_ = NULL;
	AdwToolbarView* _tmp49_;
	GtkHeaderBar* _tmp50_;
	GtkWindowHandle* window_handle = NULL;
	AdwToolbarView* _tmp51_;
	GtkWidget* _tmp52_;
	GtkWindowHandle* _tmp53_ = NULL;
	GtkWindowHandle* _tmp54_;
	SwitchboardPlugsManager* _tmp55_;
	SwitchboardPlugsManager* _tmp56_;
	gboolean _tmp57_;
	GtkSearchEntry* _tmp63_;
	GtkSearchEntry* _tmp64_;
	GtkEventControllerKey* _tmp65_;
	GtkEventControllerKey* _tmp66_;
	GtkEventControllerKey* _tmp67_;
	GtkEventControllerKey* _tmp68_;
	GtkEventController* _tmp69_;
	parent_class = G_OBJECT_CLASS (switchboard_category_view_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SWITCHBOARD_TYPE_CATEGORY_VIEW, SwitchboardCategoryView);
	_data3_ = g_slice_new0 (Block3Data);
	_data3_->_ref_count_ = 1;
	_data3_->self = g_object_ref (self);
	_tmp0_ = (GtkEventControllerKey*) gtk_event_controller_key_new ();
	search_box_eventcontrollerkey = _tmp0_;
	_tmp1_ = g_strdup (_ ("Search Settings"));
	_tmp2_ = (GtkSearchEntry*) gtk_search_entry_new ();
	g_object_set (_tmp2_, "placeholder-text", _tmp1_, NULL);
	_g_free0 (_tmp1_);
	g_object_ref_sink (_tmp2_);
	_g_object_unref0 (self->priv->search_box);
	self->priv->search_box = _tmp2_;
	_tmp3_ = self->priv->search_box;
	_tmp4_ = search_box_eventcontrollerkey;
	_tmp5_ = _g_object_ref0 ((GtkEventController*) _tmp4_);
	gtk_widget_add_controller ((GtkWidget*) _tmp3_, _tmp5_);
	_tmp6_ = self->priv->search_box;
	_tmp7_ = _g_object_ref0 ((GtkWidget*) _tmp6_);
	_tmp8_ = (AdwClamp*) adw_clamp_new ();
	adw_clamp_set_child (_tmp8_, _tmp7_);
	_g_object_unref0 (_tmp7_);
	adw_clamp_set_maximum_size (_tmp8_, 800);
	adw_clamp_set_tightening_threshold (_tmp8_, 800);
	g_object_ref_sink (_tmp8_);
	search_clamp = _tmp8_;
	_tmp9_ = search_clamp;
	_tmp10_ = _g_object_ref0 ((GtkWidget*) _tmp9_);
	_tmp11_ = (GtkHeaderBar*) gtk_header_bar_new ();
	gtk_header_bar_set_show_title_buttons (_tmp11_, TRUE);
	gtk_header_bar_set_title_widget (_tmp11_, _tmp10_);
	_g_object_unref0 (_tmp10_);
	g_object_ref_sink (_tmp11_);
	headerbar = _tmp11_;
	_tmp12_ = self->priv->search_box;
	_tmp13_ = switchboard_search_view_new (_tmp12_);
	g_object_ref_sink (_tmp13_);
	_data3_->searchview = _tmp13_;
	_tmp14_ = g_strdup (_ ("Install settings plugins and re-launch System Settings."));
	_tmp15_ = (GThemedIcon*) g_themed_icon_new ("dialog-warning");
	_tmp16_ = granite_placeholder_new (_ ("No Settings Found"));
	granite_placeholder_set_description (_tmp16_, _tmp14_);
	_g_free0 (_tmp14_);
	granite_placeholder_set_icon (_tmp16_, (GIcon*) _tmp15_);
	_g_object_unref0 (_tmp15_);
	g_object_ref_sink (_tmp16_);
	alert_view = _tmp16_;
	_tmp17_ = switchboard_category_new (SWITCHBOARD_PLUG_CATEGORY_PERSONAL);
	g_object_ref_sink (_tmp17_);
	_g_object_unref0 (self->priv->personal_category);
	self->priv->personal_category = _tmp17_;
	_tmp18_ = switchboard_category_new (SWITCHBOARD_PLUG_CATEGORY_HARDWARE);
	g_object_ref_sink (_tmp18_);
	_g_object_unref0 (self->priv->hardware_category);
	self->priv->hardware_category = _tmp18_;
	_tmp19_ = switchboard_category_new (SWITCHBOARD_PLUG_CATEGORY_NETWORK);
	g_object_ref_sink (_tmp19_);
	_g_object_unref0 (self->priv->network_category);
	self->priv->network_category = _tmp19_;
	_tmp20_ = switchboard_category_new (SWITCHBOARD_PLUG_CATEGORY_SYSTEM);
	g_object_ref_sink (_tmp20_);
	_g_object_unref0 (self->priv->system_category);
	self->priv->system_category = _tmp20_;
	_tmp21_ = switchboard_plugs_search_new ();
	_switchboard_plugs_search_unref0 (self->priv->plug_search);
	self->priv->plug_search = _tmp21_;
	_tmp22_ = gee_array_list_new (SWITCHBOARD_TYPE_SEARCH_ENTRY, (GBoxedCopyFunc) switchboard_search_entry_dup, (GDestroyNotify) switchboard_search_entry_free, NULL, NULL, NULL);
	_tmp23_ = _tmp22_;
	switchboard_category_view_set_plug_search_result (self, _tmp23_);
	_g_object_unref0 (_tmp23_);
	_tmp24_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 0);
	gtk_widget_set_vexpand ((GtkWidget*) _tmp24_, TRUE);
	g_object_ref_sink (_tmp24_);
	_data3_->category_box = _tmp24_;
	_tmp25_ = _data3_->category_box;
	_tmp26_ = self->priv->personal_category;
	gtk_box_append (_tmp25_, (GtkWidget*) _tmp26_);
	_tmp27_ = _data3_->category_box;
	_tmp28_ = self->priv->hardware_category;
	gtk_box_append (_tmp27_, (GtkWidget*) _tmp28_);
	_tmp29_ = _data3_->category_box;
	_tmp30_ = self->priv->network_category;
	gtk_box_append (_tmp29_, (GtkWidget*) _tmp30_);
	_tmp31_ = _data3_->category_box;
	_tmp32_ = self->priv->system_category;
	gtk_box_append (_tmp31_, (GtkWidget*) _tmp32_);
	_tmp33_ = _data3_->category_box;
	gtk_widget_add_css_class ((GtkWidget*) _tmp33_, "category-box");
	_tmp34_ = (GtkStack*) gtk_stack_new ();
	gtk_stack_set_transition_type (_tmp34_, GTK_STACK_TRANSITION_TYPE_CROSSFADE);
	gtk_stack_set_vhomogeneous (_tmp34_, FALSE);
	g_object_ref_sink (_tmp34_);
	_g_object_unref0 (self->priv->stack);
	self->priv->stack = _tmp34_;
	_tmp35_ = self->priv->stack;
	_tmp36_ = _data3_->category_box;
	gtk_stack_add_named (_tmp35_, (GtkWidget*) _tmp36_, "category-grid");
	_tmp37_ = self->priv->stack;
	_tmp38_ = _data3_->searchview;
	gtk_stack_add_child (_tmp37_, (GtkWidget*) _tmp38_);
	_tmp39_ = self->priv->stack;
	_tmp40_ = _g_object_ref0 ((GtkWidget*) _tmp39_);
	_tmp41_ = (AdwClamp*) adw_clamp_new ();
	adw_clamp_set_child (_tmp41_, _tmp40_);
	_g_object_unref0 (_tmp40_);
	adw_clamp_set_maximum_size (_tmp41_, 800);
	adw_clamp_set_tightening_threshold (_tmp41_, 800);
	g_object_ref_sink (_tmp41_);
	clamp = _tmp41_;
	_tmp42_ = clamp;
	gtk_widget_add_css_class ((GtkWidget*) _tmp42_, "main-clamp");
	_tmp43_ = clamp;
	_tmp44_ = _g_object_ref0 ((GtkWidget*) _tmp43_);
	_tmp45_ = (GtkScrolledWindow*) gtk_scrolled_window_new ();
	gtk_scrolled_window_set_child (_tmp45_, _tmp44_);
	_g_object_unref0 (_tmp44_);
	g_object_set (_tmp45_, "hscrollbar-policy", GTK_POLICY_NEVER, NULL);
	g_object_ref_sink (_tmp45_);
	scrolled = _tmp45_;
	_tmp46_ = scrolled;
	_tmp47_ = _g_object_ref0 ((GtkWidget*) _tmp46_);
	_tmp48_ = (AdwToolbarView*) adw_toolbar_view_new ();
	adw_toolbar_view_set_content (_tmp48_, _tmp47_);
	_g_object_unref0 (_tmp47_);
	g_object_ref_sink (_tmp48_);
	toolbarview = _tmp48_;
	_tmp49_ = toolbarview;
	_tmp50_ = headerbar;
	adw_toolbar_view_add_top_bar (_tmp49_, (GtkWidget*) _tmp50_);
	_tmp51_ = toolbarview;
	_tmp52_ = _g_object_ref0 ((GtkWidget*) _tmp51_);
	_tmp53_ = (GtkWindowHandle*) gtk_window_handle_new ();
	gtk_window_handle_set_child (_tmp53_, _tmp52_);
	_g_object_unref0 (_tmp52_);
	g_object_ref_sink (_tmp53_);
	window_handle = _tmp53_;
	_tmp54_ = window_handle;
	adw_navigation_page_set_child ((AdwNavigationPage*) self, (GtkWidget*) _tmp54_);
	adw_navigation_page_set_title ((AdwNavigationPage*) self, _ ("All Settings"));
	switchboard_category_view_load_default_plugs (self, NULL, NULL);
	_tmp55_ = switchboard_plugs_manager_get_default ();
	_tmp56_ = _tmp55_;
	_tmp57_ = switchboard_plugs_manager_has_plugs (_tmp56_) == FALSE;
	_g_object_unref0 (_tmp56_);
	if (_tmp57_) {
		GtkStack* _tmp58_;
		GranitePlaceholder* _tmp59_;
		GtkStack* _tmp60_;
		GranitePlaceholder* _tmp61_;
		GtkSearchEntry* _tmp62_;
		_tmp58_ = self->priv->stack;
		_tmp59_ = alert_view;
		gtk_stack_add_child (_tmp58_, (GtkWidget*) _tmp59_);
		_tmp60_ = self->priv->stack;
		_tmp61_ = alert_view;
		gtk_stack_set_visible_child (_tmp60_, (GtkWidget*) _tmp61_);
		_tmp62_ = self->priv->search_box;
		gtk_widget_set_sensitive ((GtkWidget*) _tmp62_, FALSE);
	}
	_tmp63_ = self->priv->search_box;
	g_signal_connect_data (_tmp63_, "search-changed", (GCallback) __switchboard_category_view___lambda13__gtk_search_entry_search_changed, block3_data_ref (_data3_), (GClosureNotify) block3_data_unref, 0);
	_tmp64_ = self->priv->search_box;
	g_signal_connect_data (_tmp64_, "activate", (GCallback) __switchboard_category_view___lambda14__gtk_search_entry_activate, block3_data_ref (_data3_), (GClosureNotify) block3_data_unref, 0);
	_tmp65_ = search_box_eventcontrollerkey;
	g_signal_connect_object (_tmp65_, "key-released", (GCallback) __switchboard_category_view___lambda15__gtk_event_controller_key_key_released, self, 0);
	_tmp66_ = (GtkEventControllerKey*) gtk_event_controller_key_new ();
	_data3_->eventcontrollerkey = _tmp66_;
	_tmp67_ = _data3_->eventcontrollerkey;
	g_signal_connect_data (_tmp67_, "key-pressed", (GCallback) __switchboard_category_view___lambda16__gtk_event_controller_key_key_pressed, block3_data_ref (_data3_), (GClosureNotify) block3_data_unref, 0);
	_tmp68_ = _data3_->eventcontrollerkey;
	_tmp69_ = _g_object_ref0 ((GtkEventController*) _tmp68_);
	gtk_widget_add_controller ((GtkWidget*) self, _tmp69_);
	_g_object_unref0 (window_handle);
	_g_object_unref0 (toolbarview);
	_g_object_unref0 (scrolled);
	_g_object_unref0 (clamp);
	_g_object_unref0 (alert_view);
	_g_object_unref0 (headerbar);
	_g_object_unref0 (search_clamp);
	_g_object_unref0 (search_box_eventcontrollerkey);
	block3_data_unref (_data3_);
	_data3_ = NULL;
	return obj;
}

static void
switchboard_category_view_base_init (SwitchboardCategoryViewClass * klass)
{
	gtk_widget_class_set_css_name (GTK_WIDGET_CLASS (klass), "category-view");
}

static void
switchboard_category_view_class_init (SwitchboardCategoryViewClass * klass,
                                      gpointer klass_data)
{
	switchboard_category_view_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &SwitchboardCategoryView_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_switchboard_category_view_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_switchboard_category_view_set_property;
	G_OBJECT_CLASS (klass)->constructor = switchboard_category_view_constructor;
	G_OBJECT_CLASS (klass)->finalize = switchboard_category_view_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), SWITCHBOARD_CATEGORY_VIEW_PLUG_SEARCH_RESULT_PROPERTY, switchboard_category_view_properties[SWITCHBOARD_CATEGORY_VIEW_PLUG_SEARCH_RESULT_PROPERTY] = g_param_spec_object ("plug-search-result", "plug-search-result", "plug-search-result", GEE_TYPE_ARRAY_LIST, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SWITCHBOARD_CATEGORY_VIEW_PLUG_TO_OPEN_PROPERTY, switchboard_category_view_properties[SWITCHBOARD_CATEGORY_VIEW_PLUG_TO_OPEN_PROPERTY] = g_param_spec_string ("plug-to-open", "plug-to-open", "plug-to-open", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
}

static void
switchboard_category_view_instance_init (SwitchboardCategoryView * self,
                                         gpointer klass)
{
	self->priv = switchboard_category_view_get_instance_private (self);
	self->priv->_plug_to_open = NULL;
}

static void
switchboard_category_view_finalize (GObject * obj)
{
	SwitchboardCategoryView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SWITCHBOARD_TYPE_CATEGORY_VIEW, SwitchboardCategoryView);
	_g_object_unref0 (self->priv->_plug_search_result);
	_g_free0 (self->priv->_plug_to_open);
	_g_object_unref0 (self->priv->search_box);
	_g_object_unref0 (self->priv->stack);
	_switchboard_plugs_search_unref0 (self->priv->plug_search);
	_g_object_unref0 (self->priv->hardware_category);
	_g_object_unref0 (self->priv->network_category);
	_g_object_unref0 (self->priv->personal_category);
	_g_object_unref0 (self->priv->system_category);
	G_OBJECT_CLASS (switchboard_category_view_parent_class)->finalize (obj);
}

static GType
switchboard_category_view_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SwitchboardCategoryViewClass), (GBaseInitFunc) switchboard_category_view_base_init, (GBaseFinalizeFunc) NULL, (GClassInitFunc) switchboard_category_view_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SwitchboardCategoryView), 0, (GInstanceInitFunc) switchboard_category_view_instance_init, NULL };
	GType switchboard_category_view_type_id;
	switchboard_category_view_type_id = g_type_register_static (adw_navigation_page_get_type (), "SwitchboardCategoryView", &g_define_type_info, 0);
	SwitchboardCategoryView_private_offset = g_type_add_instance_private (switchboard_category_view_type_id, sizeof (SwitchboardCategoryViewPrivate));
	return switchboard_category_view_type_id;
}

GType
switchboard_category_view_get_type (void)
{
	static volatile gsize switchboard_category_view_type_id__once = 0;
	if (g_once_init_enter (&switchboard_category_view_type_id__once)) {
		GType switchboard_category_view_type_id;
		switchboard_category_view_type_id = switchboard_category_view_get_type_once ();
		g_once_init_leave (&switchboard_category_view_type_id__once, switchboard_category_view_type_id);
	}
	return switchboard_category_view_type_id__once;
}

static void
_vala_switchboard_category_view_get_property (GObject * object,
                                              guint property_id,
                                              GValue * value,
                                              GParamSpec * pspec)
{
	SwitchboardCategoryView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SWITCHBOARD_TYPE_CATEGORY_VIEW, SwitchboardCategoryView);
	switch (property_id) {
		case SWITCHBOARD_CATEGORY_VIEW_PLUG_SEARCH_RESULT_PROPERTY:
		g_value_set_object (value, switchboard_category_view_get_plug_search_result (self));
		break;
		case SWITCHBOARD_CATEGORY_VIEW_PLUG_TO_OPEN_PROPERTY:
		g_value_set_string (value, switchboard_category_view_get_plug_to_open (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_switchboard_category_view_set_property (GObject * object,
                                              guint property_id,
                                              const GValue * value,
                                              GParamSpec * pspec)
{
	SwitchboardCategoryView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SWITCHBOARD_TYPE_CATEGORY_VIEW, SwitchboardCategoryView);
	switch (property_id) {
		case SWITCHBOARD_CATEGORY_VIEW_PLUG_SEARCH_RESULT_PROPERTY:
		switchboard_category_view_set_plug_search_result (self, g_value_get_object (value));
		break;
		case SWITCHBOARD_CATEGORY_VIEW_PLUG_TO_OPEN_PROPERTY:
		switchboard_category_view_set_plug_to_open (self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

