#include "init.c"
#include "getargs.c"
#include "getargsfast.c"
#include "int_ops.c"
#include "float_ops.c"
#include "str_ops.c"
#include "bytes_ops.c"
#include "list_ops.c"
#include "dict_ops.c"
#include "set_ops.c"
#include "tuple_ops.c"
#include "exc_ops.c"
#include "misc_ops.c"
#include "generic_ops.c"
#include "pythonsupport.c"
#include "__native_md.h"
#include "__native_internal_md.h"

PyObject *CPyDef___mypyc__MessDetectorPlugin_setup(PyObject *cpy_r_type);
PyObject *CPyDef_MessDetectorPlugin(void);

static PyObject *
MessDetectorPlugin_new(PyTypeObject *type, PyObject *args, PyObject *kwds)
{
    if (type != CPyType_MessDetectorPlugin) {
        PyErr_SetString(PyExc_TypeError, "interpreted classes cannot inherit from compiled");
        return NULL;
    }
    PyObject *self = CPyDef___mypyc__MessDetectorPlugin_setup((PyObject*)type);
    if (self == NULL)
        return NULL;
    return self;
}

static int
MessDetectorPlugin_traverse(charset_normalizer___md___MessDetectorPluginObject *self, visitproc visit, void *arg)
{
    return 0;
}

static int
MessDetectorPlugin_clear(charset_normalizer___md___MessDetectorPluginObject *self)
{
    return 0;
}

static void
MessDetectorPlugin_dealloc(charset_normalizer___md___MessDetectorPluginObject *self)
{
    PyObject_GC_UnTrack(self);
    CPy_TRASHCAN_BEGIN(self, MessDetectorPlugin_dealloc)
    MessDetectorPlugin_clear(self);
    Py_TYPE(self)->tp_free((PyObject *)self);
    CPy_TRASHCAN_END(self)
}

static CPyVTableItem MessDetectorPlugin_vtable[4];
static bool
CPyDef_MessDetectorPlugin_trait_vtable_setup(void)
{
    CPyVTableItem MessDetectorPlugin_vtable_scratch[] = {
        (CPyVTableItem)CPyDef_MessDetectorPlugin___eligible,
        (CPyVTableItem)CPyDef_MessDetectorPlugin___feed,
        (CPyVTableItem)CPyDef_MessDetectorPlugin___reset,
        (CPyVTableItem)CPyDef_MessDetectorPlugin___ratio,
    };
    memcpy(MessDetectorPlugin_vtable, MessDetectorPlugin_vtable_scratch, sizeof(MessDetectorPlugin_vtable));
    return 1;
}

static PyObject *
MessDetectorPlugin_get_ratio(charset_normalizer___md___MessDetectorPluginObject *self, void *closure);

static PyGetSetDef MessDetectorPlugin_getseters[] = {
    {"ratio",
     (getter)MessDetectorPlugin_get_ratio,
    NULL, NULL, NULL},
    {NULL}  /* Sentinel */
};

static PyMethodDef MessDetectorPlugin_methods[] = {
    {"eligible",
     (PyCFunction)CPyPy_MessDetectorPlugin___eligible,
     METH_FASTCALL | METH_KEYWORDS, PyDoc_STR("eligible($self, character)\n--\n\n")},
    {"feed",
     (PyCFunction)CPyPy_MessDetectorPlugin___feed,
     METH_FASTCALL | METH_KEYWORDS, PyDoc_STR("feed($self, character)\n--\n\n")},
    {"reset",
     (PyCFunction)CPyPy_MessDetectorPlugin___reset,
     METH_FASTCALL | METH_KEYWORDS, PyDoc_STR("reset($self)\n--\n\n")},
    {"__setstate__", (PyCFunction)CPyPickle_SetState, METH_O, NULL},
    {"__getstate__", (PyCFunction)CPyPickle_GetState, METH_NOARGS, NULL},
    {NULL}  /* Sentinel */
};

static PyTypeObject CPyType_MessDetectorPlugin_template_ = {
    PyVarObject_HEAD_INIT(NULL, 0)
    .tp_name = "MessDetectorPlugin",
    .tp_new = MessDetectorPlugin_new,
    .tp_dealloc = (destructor)MessDetectorPlugin_dealloc,
    .tp_traverse = (traverseproc)MessDetectorPlugin_traverse,
    .tp_clear = (inquiry)MessDetectorPlugin_clear,
    .tp_getset = MessDetectorPlugin_getseters,
    .tp_methods = MessDetectorPlugin_methods,
    .tp_basicsize = sizeof(charset_normalizer___md___MessDetectorPluginObject),
    .tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_HEAPTYPE | Py_TPFLAGS_BASETYPE | Py_TPFLAGS_HAVE_GC,
    .tp_doc = PyDoc_STR("MessDetectorPlugin()\n--\n\n"),
};
static PyTypeObject *CPyType_MessDetectorPlugin_template = &CPyType_MessDetectorPlugin_template_;

PyObject *CPyDef___mypyc__MessDetectorPlugin_setup(PyObject *cpy_r_type)
{
    PyTypeObject *type = (PyTypeObject*)cpy_r_type;
    charset_normalizer___md___MessDetectorPluginObject *self;
    self = (charset_normalizer___md___MessDetectorPluginObject *)type->tp_alloc(type, 0);
    if (self == NULL)
        return NULL;
    self->vtable = MessDetectorPlugin_vtable;
    return (PyObject *)self;
}

PyObject *CPyDef_MessDetectorPlugin(void)
{
    PyObject *self = CPyDef___mypyc__MessDetectorPlugin_setup((PyObject *)CPyType_MessDetectorPlugin);
    if (self == NULL)
        return NULL;
    return self;
}


static PyObject *
MessDetectorPlugin_get_ratio(charset_normalizer___md___MessDetectorPluginObject *self, void *closure)
{
    double retval = CPyDef_MessDetectorPlugin___ratio((PyObject *) self);
    if (retval == -113.0 && PyErr_Occurred()) {
        return NULL;
    }
    PyObject *retbox = PyFloat_FromDouble(retval);
    return retbox;
}

static int
TooManySymbolOrPunctuationPlugin_init(PyObject *self, PyObject *args, PyObject *kwds)
{
    return 0;
}
PyObject *CPyDef___mypyc__TooManySymbolOrPunctuationPlugin_setup(PyObject *cpy_r_type);
PyObject *CPyDef_TooManySymbolOrPunctuationPlugin(void);

static PyObject *
TooManySymbolOrPunctuationPlugin_new(PyTypeObject *type, PyObject *args, PyObject *kwds)
{
    if (type != CPyType_TooManySymbolOrPunctuationPlugin) {
        PyErr_SetString(PyExc_TypeError, "interpreted classes cannot inherit from compiled");
        return NULL;
    }
    PyObject *self = CPyDef___mypyc__TooManySymbolOrPunctuationPlugin_setup((PyObject*)type);
    if (self == NULL)
        return NULL;
    PyObject *ret = CPyPy_TooManySymbolOrPunctuationPlugin_____init__(self, args, kwds);
    if (ret == NULL)
        return NULL;
    return self;
}

static int
TooManySymbolOrPunctuationPlugin_traverse(charset_normalizer___md___TooManySymbolOrPunctuationPluginObject *self, visitproc visit, void *arg)
{
    if (CPyTagged_CheckLong(self->__punctuation_count)) {
        Py_VISIT(CPyTagged_LongAsObject(self->__punctuation_count));
    }
    if (CPyTagged_CheckLong(self->__symbol_count)) {
        Py_VISIT(CPyTagged_LongAsObject(self->__symbol_count));
    }
    if (CPyTagged_CheckLong(self->__character_count)) {
        Py_VISIT(CPyTagged_LongAsObject(self->__character_count));
    }
    Py_VISIT(self->__last_printable_char);
    return 0;
}

static int
TooManySymbolOrPunctuationPlugin_clear(charset_normalizer___md___TooManySymbolOrPunctuationPluginObject *self)
{
    if (CPyTagged_CheckLong(self->__punctuation_count)) {
        CPyTagged __tmp = self->__punctuation_count;
        self->__punctuation_count = CPY_INT_TAG;
        Py_XDECREF(CPyTagged_LongAsObject(__tmp));
    }
    if (CPyTagged_CheckLong(self->__symbol_count)) {
        CPyTagged __tmp = self->__symbol_count;
        self->__symbol_count = CPY_INT_TAG;
        Py_XDECREF(CPyTagged_LongAsObject(__tmp));
    }
    if (CPyTagged_CheckLong(self->__character_count)) {
        CPyTagged __tmp = self->__character_count;
        self->__character_count = CPY_INT_TAG;
        Py_XDECREF(CPyTagged_LongAsObject(__tmp));
    }
    Py_CLEAR(self->__last_printable_char);
    return 0;
}

static void
TooManySymbolOrPunctuationPlugin_dealloc(charset_normalizer___md___TooManySymbolOrPunctuationPluginObject *self)
{
    PyObject_GC_UnTrack(self);
    CPy_TRASHCAN_BEGIN(self, TooManySymbolOrPunctuationPlugin_dealloc)
    TooManySymbolOrPunctuationPlugin_clear(self);
    Py_TYPE(self)->tp_free((PyObject *)self);
    CPy_TRASHCAN_END(self)
}

static CPyVTableItem TooManySymbolOrPunctuationPlugin_vtable[9];
static bool
CPyDef_TooManySymbolOrPunctuationPlugin_trait_vtable_setup(void)
{
    CPyVTableItem TooManySymbolOrPunctuationPlugin_vtable_scratch[] = {
        (CPyVTableItem)CPyDef_TooManySymbolOrPunctuationPlugin___eligible,
        (CPyVTableItem)CPyDef_TooManySymbolOrPunctuationPlugin___feed,
        (CPyVTableItem)CPyDef_TooManySymbolOrPunctuationPlugin___reset,
        (CPyVTableItem)CPyDef_TooManySymbolOrPunctuationPlugin___ratio,
        (CPyVTableItem)CPyDef_TooManySymbolOrPunctuationPlugin_____init__,
        (CPyVTableItem)CPyDef_TooManySymbolOrPunctuationPlugin___eligible,
        (CPyVTableItem)CPyDef_TooManySymbolOrPunctuationPlugin___feed,
        (CPyVTableItem)CPyDef_TooManySymbolOrPunctuationPlugin___reset,
        (CPyVTableItem)CPyDef_TooManySymbolOrPunctuationPlugin___ratio,
    };
    memcpy(TooManySymbolOrPunctuationPlugin_vtable, TooManySymbolOrPunctuationPlugin_vtable_scratch, sizeof(TooManySymbolOrPunctuationPlugin_vtable));
    return 1;
}

static PyObject *
TooManySymbolOrPunctuationPlugin_get__punctuation_count(charset_normalizer___md___TooManySymbolOrPunctuationPluginObject *self, void *closure);
static int
TooManySymbolOrPunctuationPlugin_set__punctuation_count(charset_normalizer___md___TooManySymbolOrPunctuationPluginObject *self, PyObject *value, void *closure);
static PyObject *
TooManySymbolOrPunctuationPlugin_get__symbol_count(charset_normalizer___md___TooManySymbolOrPunctuationPluginObject *self, void *closure);
static int
TooManySymbolOrPunctuationPlugin_set__symbol_count(charset_normalizer___md___TooManySymbolOrPunctuationPluginObject *self, PyObject *value, void *closure);
static PyObject *
TooManySymbolOrPunctuationPlugin_get__character_count(charset_normalizer___md___TooManySymbolOrPunctuationPluginObject *self, void *closure);
static int
TooManySymbolOrPunctuationPlugin_set__character_count(charset_normalizer___md___TooManySymbolOrPunctuationPluginObject *self, PyObject *value, void *closure);
static PyObject *
TooManySymbolOrPunctuationPlugin_get__last_printable_char(charset_normalizer___md___TooManySymbolOrPunctuationPluginObject *self, void *closure);
static int
TooManySymbolOrPunctuationPlugin_set__last_printable_char(charset_normalizer___md___TooManySymbolOrPunctuationPluginObject *self, PyObject *value, void *closure);
static PyObject *
TooManySymbolOrPunctuationPlugin_get__frenzy_symbol_in_word(charset_normalizer___md___TooManySymbolOrPunctuationPluginObject *self, void *closure);
static int
TooManySymbolOrPunctuationPlugin_set__frenzy_symbol_in_word(charset_normalizer___md___TooManySymbolOrPunctuationPluginObject *self, PyObject *value, void *closure);
static PyObject *
TooManySymbolOrPunctuationPlugin_get_ratio(charset_normalizer___md___TooManySymbolOrPunctuationPluginObject *self, void *closure);

static PyGetSetDef TooManySymbolOrPunctuationPlugin_getseters[] = {
    {"_punctuation_count",
     (getter)TooManySymbolOrPunctuationPlugin_get__punctuation_count, (setter)TooManySymbolOrPunctuationPlugin_set__punctuation_count,
     NULL, NULL},
    {"_symbol_count",
     (getter)TooManySymbolOrPunctuationPlugin_get__symbol_count, (setter)TooManySymbolOrPunctuationPlugin_set__symbol_count,
     NULL, NULL},
    {"_character_count",
     (getter)TooManySymbolOrPunctuationPlugin_get__character_count, (setter)TooManySymbolOrPunctuationPlugin_set__character_count,
     NULL, NULL},
    {"_last_printable_char",
     (getter)TooManySymbolOrPunctuationPlugin_get__last_printable_char, (setter)TooManySymbolOrPunctuationPlugin_set__last_printable_char,
     NULL, NULL},
    {"_frenzy_symbol_in_word",
     (getter)TooManySymbolOrPunctuationPlugin_get__frenzy_symbol_in_word, (setter)TooManySymbolOrPunctuationPlugin_set__frenzy_symbol_in_word,
     NULL, NULL},
    {"ratio",
     (getter)TooManySymbolOrPunctuationPlugin_get_ratio,
    NULL, NULL, NULL},
    {NULL}  /* Sentinel */
};

static PyMethodDef TooManySymbolOrPunctuationPlugin_methods[] = {
    {"__init__",
     (PyCFunction)CPyPy_TooManySymbolOrPunctuationPlugin_____init__,
     METH_FASTCALL | METH_KEYWORDS, PyDoc_STR("__init__($self)\n--\n\n")},
    {"eligible",
     (PyCFunction)CPyPy_TooManySymbolOrPunctuationPlugin___eligible,
     METH_FASTCALL | METH_KEYWORDS, PyDoc_STR("eligible($self, character)\n--\n\n")},
    {"feed",
     (PyCFunction)CPyPy_TooManySymbolOrPunctuationPlugin___feed,
     METH_FASTCALL | METH_KEYWORDS, PyDoc_STR("feed($self, character)\n--\n\n")},
    {"reset",
     (PyCFunction)CPyPy_TooManySymbolOrPunctuationPlugin___reset,
     METH_FASTCALL | METH_KEYWORDS, PyDoc_STR("reset($self)\n--\n\n")},
    {"__setstate__", (PyCFunction)CPyPickle_SetState, METH_O, NULL},
    {"__getstate__", (PyCFunction)CPyPickle_GetState, METH_NOARGS, NULL},
    {NULL}  /* Sentinel */
};

static PyTypeObject CPyType_TooManySymbolOrPunctuationPlugin_template_ = {
    PyVarObject_HEAD_INIT(NULL, 0)
    .tp_name = "TooManySymbolOrPunctuationPlugin",
    .tp_new = TooManySymbolOrPunctuationPlugin_new,
    .tp_dealloc = (destructor)TooManySymbolOrPunctuationPlugin_dealloc,
    .tp_traverse = (traverseproc)TooManySymbolOrPunctuationPlugin_traverse,
    .tp_clear = (inquiry)TooManySymbolOrPunctuationPlugin_clear,
    .tp_getset = TooManySymbolOrPunctuationPlugin_getseters,
    .tp_methods = TooManySymbolOrPunctuationPlugin_methods,
    .tp_init = TooManySymbolOrPunctuationPlugin_init,
    .tp_basicsize = sizeof(charset_normalizer___md___TooManySymbolOrPunctuationPluginObject),
    .tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_HEAPTYPE | Py_TPFLAGS_BASETYPE | Py_TPFLAGS_HAVE_GC,
    .tp_doc = PyDoc_STR("TooManySymbolOrPunctuationPlugin()\n--\n\n"),
};
static PyTypeObject *CPyType_TooManySymbolOrPunctuationPlugin_template = &CPyType_TooManySymbolOrPunctuationPlugin_template_;

PyObject *CPyDef___mypyc__TooManySymbolOrPunctuationPlugin_setup(PyObject *cpy_r_type)
{
    PyTypeObject *type = (PyTypeObject*)cpy_r_type;
    charset_normalizer___md___TooManySymbolOrPunctuationPluginObject *self;
    self = (charset_normalizer___md___TooManySymbolOrPunctuationPluginObject *)type->tp_alloc(type, 0);
    if (self == NULL)
        return NULL;
    self->vtable = TooManySymbolOrPunctuationPlugin_vtable;
    self->__punctuation_count = CPY_INT_TAG;
    self->__symbol_count = CPY_INT_TAG;
    self->__character_count = CPY_INT_TAG;
    self->__frenzy_symbol_in_word = 2;
    return (PyObject *)self;
}

PyObject *CPyDef_TooManySymbolOrPunctuationPlugin(void)
{
    PyObject *self = CPyDef___mypyc__TooManySymbolOrPunctuationPlugin_setup((PyObject *)CPyType_TooManySymbolOrPunctuationPlugin);
    if (self == NULL)
        return NULL;
    char res = CPyDef_TooManySymbolOrPunctuationPlugin_____init__(self);
    if (res == 2) {
        Py_DECREF(self);
        return NULL;
    }
    return self;
}

static PyObject *
TooManySymbolOrPunctuationPlugin_get__punctuation_count(charset_normalizer___md___TooManySymbolOrPunctuationPluginObject *self, void *closure)
{
    if (unlikely(self->__punctuation_count == CPY_INT_TAG)) {
        PyErr_SetString(PyExc_AttributeError,
            "attribute '_punctuation_count' of 'TooManySymbolOrPunctuationPlugin' undefined");
        return NULL;
    }
    CPyTagged_INCREF(self->__punctuation_count);
    PyObject *retval = CPyTagged_StealAsObject(self->__punctuation_count);
    return retval;
}

static int
TooManySymbolOrPunctuationPlugin_set__punctuation_count(charset_normalizer___md___TooManySymbolOrPunctuationPluginObject *self, PyObject *value, void *closure)
{
    if (value == NULL) {
        PyErr_SetString(PyExc_AttributeError,
            "'TooManySymbolOrPunctuationPlugin' object attribute '_punctuation_count' cannot be deleted");
        return -1;
    }
    if (self->__punctuation_count != CPY_INT_TAG) {
        CPyTagged_DECREF(self->__punctuation_count);
    }
    CPyTagged tmp;
    if (likely(PyLong_Check(value)))
        tmp = CPyTagged_FromObject(value);
    else {
        CPy_TypeError("int", value); return -1;
    }
    CPyTagged_INCREF(tmp);
    self->__punctuation_count = tmp;
    return 0;
}

static PyObject *
TooManySymbolOrPunctuationPlugin_get__symbol_count(charset_normalizer___md___TooManySymbolOrPunctuationPluginObject *self, void *closure)
{
    if (unlikely(self->__symbol_count == CPY_INT_TAG)) {
        PyErr_SetString(PyExc_AttributeError,
            "attribute '_symbol_count' of 'TooManySymbolOrPunctuationPlugin' undefined");
        return NULL;
    }
    CPyTagged_INCREF(self->__symbol_count);
    PyObject *retval = CPyTagged_StealAsObject(self->__symbol_count);
    return retval;
}

static int
TooManySymbolOrPunctuationPlugin_set__symbol_count(charset_normalizer___md___TooManySymbolOrPunctuationPluginObject *self, PyObject *value, void *closure)
{
    if (value == NULL) {
        PyErr_SetString(PyExc_AttributeError,
            "'TooManySymbolOrPunctuationPlugin' object attribute '_symbol_count' cannot be deleted");
        return -1;
    }
    if (self->__symbol_count != CPY_INT_TAG) {
        CPyTagged_DECREF(self->__symbol_count);
    }
    CPyTagged tmp;
    if (likely(PyLong_Check(value)))
        tmp = CPyTagged_FromObject(value);
    else {
        CPy_TypeError("int", value); return -1;
    }
    CPyTagged_INCREF(tmp);
    self->__symbol_count = tmp;
    return 0;
}

static PyObject *
TooManySymbolOrPunctuationPlugin_get__character_count(charset_normalizer___md___TooManySymbolOrPunctuationPluginObject *self, void *closure)
{
    if (unlikely(self->__character_count == CPY_INT_TAG)) {
        PyErr_SetString(PyExc_AttributeError,
            "attribute '_character_count' of 'TooManySymbolOrPunctuationPlugin' undefined");
        return NULL;
    }
    CPyTagged_INCREF(self->__character_count);
    PyObject *retval = CPyTagged_StealAsObject(self->__character_count);
    return retval;
}

static int
TooManySymbolOrPunctuationPlugin_set__character_count(charset_normalizer___md___TooManySymbolOrPunctuationPluginObject *self, PyObject *value, void *closure)
{
    if (value == NULL) {
        PyErr_SetString(PyExc_AttributeError,
            "'TooManySymbolOrPunctuationPlugin' object attribute '_character_count' cannot be deleted");
        return -1;
    }
    if (self->__character_count != CPY_INT_TAG) {
        CPyTagged_DECREF(self->__character_count);
    }
    CPyTagged tmp;
    if (likely(PyLong_Check(value)))
        tmp = CPyTagged_FromObject(value);
    else {
        CPy_TypeError("int", value); return -1;
    }
    CPyTagged_INCREF(tmp);
    self->__character_count = tmp;
    return 0;
}

static PyObject *
TooManySymbolOrPunctuationPlugin_get__last_printable_char(charset_normalizer___md___TooManySymbolOrPunctuationPluginObject *self, void *closure)
{
    if (unlikely(self->__last_printable_char == NULL)) {
        PyErr_SetString(PyExc_AttributeError,
            "attribute '_last_printable_char' of 'TooManySymbolOrPunctuationPlugin' undefined");
        return NULL;
    }
    CPy_INCREF(self->__last_printable_char);
    PyObject *retval = self->__last_printable_char;
    return retval;
}

static int
TooManySymbolOrPunctuationPlugin_set__last_printable_char(charset_normalizer___md___TooManySymbolOrPunctuationPluginObject *self, PyObject *value, void *closure)
{
    if (value == NULL) {
        PyErr_SetString(PyExc_AttributeError,
            "'TooManySymbolOrPunctuationPlugin' object attribute '_last_printable_char' cannot be deleted");
        return -1;
    }
    if (self->__last_printable_char != NULL) {
        CPy_DECREF(self->__last_printable_char);
    }
    PyObject *tmp;
    if (PyUnicode_Check(value))
        tmp = value;
    else {
        tmp = NULL;
    }
    if (tmp != NULL) goto __LL1;
    if (value == Py_None)
        tmp = value;
    else {
        tmp = NULL;
    }
    if (tmp != NULL) goto __LL1;
    CPy_TypeError("str or None", value); 
    tmp = NULL;
__LL1: ;
    if (!tmp)
        return -1;
    CPy_INCREF(tmp);
    self->__last_printable_char = tmp;
    return 0;
}

static PyObject *
TooManySymbolOrPunctuationPlugin_get__frenzy_symbol_in_word(charset_normalizer___md___TooManySymbolOrPunctuationPluginObject *self, void *closure)
{
    PyObject *retval = self->__frenzy_symbol_in_word ? Py_True : Py_False;
    CPy_INCREF(retval);
    return retval;
}

static int
TooManySymbolOrPunctuationPlugin_set__frenzy_symbol_in_word(charset_normalizer___md___TooManySymbolOrPunctuationPluginObject *self, PyObject *value, void *closure)
{
    if (value == NULL) {
        PyErr_SetString(PyExc_AttributeError,
            "'TooManySymbolOrPunctuationPlugin' object attribute '_frenzy_symbol_in_word' cannot be deleted");
        return -1;
    }
    char tmp;
    if (unlikely(!PyBool_Check(value))) {
        CPy_TypeError("bool", value); return -1;
    } else
        tmp = value == Py_True;
    self->__frenzy_symbol_in_word = tmp;
    return 0;
}

static PyObject *
TooManySymbolOrPunctuationPlugin_get_ratio(charset_normalizer___md___TooManySymbolOrPunctuationPluginObject *self, void *closure)
{
    double retval = CPyDef_TooManySymbolOrPunctuationPlugin___ratio((PyObject *) self);
    if (retval == -113.0 && PyErr_Occurred()) {
        return NULL;
    }
    PyObject *retbox = PyFloat_FromDouble(retval);
    return retbox;
}

static int
TooManyAccentuatedPlugin_init(PyObject *self, PyObject *args, PyObject *kwds)
{
    return 0;
}
PyObject *CPyDef___mypyc__TooManyAccentuatedPlugin_setup(PyObject *cpy_r_type);
PyObject *CPyDef_TooManyAccentuatedPlugin(void);

static PyObject *
TooManyAccentuatedPlugin_new(PyTypeObject *type, PyObject *args, PyObject *kwds)
{
    if (type != CPyType_TooManyAccentuatedPlugin) {
        PyErr_SetString(PyExc_TypeError, "interpreted classes cannot inherit from compiled");
        return NULL;
    }
    PyObject *self = CPyDef___mypyc__TooManyAccentuatedPlugin_setup((PyObject*)type);
    if (self == NULL)
        return NULL;
    PyObject *ret = CPyPy_TooManyAccentuatedPlugin_____init__(self, args, kwds);
    if (ret == NULL)
        return NULL;
    return self;
}

static int
TooManyAccentuatedPlugin_traverse(charset_normalizer___md___TooManyAccentuatedPluginObject *self, visitproc visit, void *arg)
{
    if (CPyTagged_CheckLong(self->__character_count)) {
        Py_VISIT(CPyTagged_LongAsObject(self->__character_count));
    }
    if (CPyTagged_CheckLong(self->__accentuated_count)) {
        Py_VISIT(CPyTagged_LongAsObject(self->__accentuated_count));
    }
    return 0;
}

static int
TooManyAccentuatedPlugin_clear(charset_normalizer___md___TooManyAccentuatedPluginObject *self)
{
    if (CPyTagged_CheckLong(self->__character_count)) {
        CPyTagged __tmp = self->__character_count;
        self->__character_count = CPY_INT_TAG;
        Py_XDECREF(CPyTagged_LongAsObject(__tmp));
    }
    if (CPyTagged_CheckLong(self->__accentuated_count)) {
        CPyTagged __tmp = self->__accentuated_count;
        self->__accentuated_count = CPY_INT_TAG;
        Py_XDECREF(CPyTagged_LongAsObject(__tmp));
    }
    return 0;
}

static void
TooManyAccentuatedPlugin_dealloc(charset_normalizer___md___TooManyAccentuatedPluginObject *self)
{
    PyObject_GC_UnTrack(self);
    CPy_TRASHCAN_BEGIN(self, TooManyAccentuatedPlugin_dealloc)
    TooManyAccentuatedPlugin_clear(self);
    Py_TYPE(self)->tp_free((PyObject *)self);
    CPy_TRASHCAN_END(self)
}

static CPyVTableItem TooManyAccentuatedPlugin_vtable[9];
static bool
CPyDef_TooManyAccentuatedPlugin_trait_vtable_setup(void)
{
    CPyVTableItem TooManyAccentuatedPlugin_vtable_scratch[] = {
        (CPyVTableItem)CPyDef_TooManyAccentuatedPlugin___eligible,
        (CPyVTableItem)CPyDef_TooManyAccentuatedPlugin___feed,
        (CPyVTableItem)CPyDef_TooManyAccentuatedPlugin___reset,
        (CPyVTableItem)CPyDef_TooManyAccentuatedPlugin___ratio,
        (CPyVTableItem)CPyDef_TooManyAccentuatedPlugin_____init__,
        (CPyVTableItem)CPyDef_TooManyAccentuatedPlugin___eligible,
        (CPyVTableItem)CPyDef_TooManyAccentuatedPlugin___feed,
        (CPyVTableItem)CPyDef_TooManyAccentuatedPlugin___reset,
        (CPyVTableItem)CPyDef_TooManyAccentuatedPlugin___ratio,
    };
    memcpy(TooManyAccentuatedPlugin_vtable, TooManyAccentuatedPlugin_vtable_scratch, sizeof(TooManyAccentuatedPlugin_vtable));
    return 1;
}

static PyObject *
TooManyAccentuatedPlugin_get__character_count(charset_normalizer___md___TooManyAccentuatedPluginObject *self, void *closure);
static int
TooManyAccentuatedPlugin_set__character_count(charset_normalizer___md___TooManyAccentuatedPluginObject *self, PyObject *value, void *closure);
static PyObject *
TooManyAccentuatedPlugin_get__accentuated_count(charset_normalizer___md___TooManyAccentuatedPluginObject *self, void *closure);
static int
TooManyAccentuatedPlugin_set__accentuated_count(charset_normalizer___md___TooManyAccentuatedPluginObject *self, PyObject *value, void *closure);
static PyObject *
TooManyAccentuatedPlugin_get_ratio(charset_normalizer___md___TooManyAccentuatedPluginObject *self, void *closure);

static PyGetSetDef TooManyAccentuatedPlugin_getseters[] = {
    {"_character_count",
     (getter)TooManyAccentuatedPlugin_get__character_count, (setter)TooManyAccentuatedPlugin_set__character_count,
     NULL, NULL},
    {"_accentuated_count",
     (getter)TooManyAccentuatedPlugin_get__accentuated_count, (setter)TooManyAccentuatedPlugin_set__accentuated_count,
     NULL, NULL},
    {"ratio",
     (getter)TooManyAccentuatedPlugin_get_ratio,
    NULL, NULL, NULL},
    {NULL}  /* Sentinel */
};

static PyMethodDef TooManyAccentuatedPlugin_methods[] = {
    {"__init__",
     (PyCFunction)CPyPy_TooManyAccentuatedPlugin_____init__,
     METH_FASTCALL | METH_KEYWORDS, PyDoc_STR("__init__($self)\n--\n\n")},
    {"eligible",
     (PyCFunction)CPyPy_TooManyAccentuatedPlugin___eligible,
     METH_FASTCALL | METH_KEYWORDS, PyDoc_STR("eligible($self, character)\n--\n\n")},
    {"feed",
     (PyCFunction)CPyPy_TooManyAccentuatedPlugin___feed,
     METH_FASTCALL | METH_KEYWORDS, PyDoc_STR("feed($self, character)\n--\n\n")},
    {"reset",
     (PyCFunction)CPyPy_TooManyAccentuatedPlugin___reset,
     METH_FASTCALL | METH_KEYWORDS, PyDoc_STR("reset($self)\n--\n\n")},
    {"__setstate__", (PyCFunction)CPyPickle_SetState, METH_O, NULL},
    {"__getstate__", (PyCFunction)CPyPickle_GetState, METH_NOARGS, NULL},
    {NULL}  /* Sentinel */
};

static PyTypeObject CPyType_TooManyAccentuatedPlugin_template_ = {
    PyVarObject_HEAD_INIT(NULL, 0)
    .tp_name = "TooManyAccentuatedPlugin",
    .tp_new = TooManyAccentuatedPlugin_new,
    .tp_dealloc = (destructor)TooManyAccentuatedPlugin_dealloc,
    .tp_traverse = (traverseproc)TooManyAccentuatedPlugin_traverse,
    .tp_clear = (inquiry)TooManyAccentuatedPlugin_clear,
    .tp_getset = TooManyAccentuatedPlugin_getseters,
    .tp_methods = TooManyAccentuatedPlugin_methods,
    .tp_init = TooManyAccentuatedPlugin_init,
    .tp_basicsize = sizeof(charset_normalizer___md___TooManyAccentuatedPluginObject),
    .tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_HEAPTYPE | Py_TPFLAGS_BASETYPE | Py_TPFLAGS_HAVE_GC,
    .tp_doc = PyDoc_STR("TooManyAccentuatedPlugin()\n--\n\n"),
};
static PyTypeObject *CPyType_TooManyAccentuatedPlugin_template = &CPyType_TooManyAccentuatedPlugin_template_;

PyObject *CPyDef___mypyc__TooManyAccentuatedPlugin_setup(PyObject *cpy_r_type)
{
    PyTypeObject *type = (PyTypeObject*)cpy_r_type;
    charset_normalizer___md___TooManyAccentuatedPluginObject *self;
    self = (charset_normalizer___md___TooManyAccentuatedPluginObject *)type->tp_alloc(type, 0);
    if (self == NULL)
        return NULL;
    self->vtable = TooManyAccentuatedPlugin_vtable;
    self->__character_count = CPY_INT_TAG;
    self->__accentuated_count = CPY_INT_TAG;
    return (PyObject *)self;
}

PyObject *CPyDef_TooManyAccentuatedPlugin(void)
{
    PyObject *self = CPyDef___mypyc__TooManyAccentuatedPlugin_setup((PyObject *)CPyType_TooManyAccentuatedPlugin);
    if (self == NULL)
        return NULL;
    char res = CPyDef_TooManyAccentuatedPlugin_____init__(self);
    if (res == 2) {
        Py_DECREF(self);
        return NULL;
    }
    return self;
}

static PyObject *
TooManyAccentuatedPlugin_get__character_count(charset_normalizer___md___TooManyAccentuatedPluginObject *self, void *closure)
{
    if (unlikely(self->__character_count == CPY_INT_TAG)) {
        PyErr_SetString(PyExc_AttributeError,
            "attribute '_character_count' of 'TooManyAccentuatedPlugin' undefined");
        return NULL;
    }
    CPyTagged_INCREF(self->__character_count);
    PyObject *retval = CPyTagged_StealAsObject(self->__character_count);
    return retval;
}

static int
TooManyAccentuatedPlugin_set__character_count(charset_normalizer___md___TooManyAccentuatedPluginObject *self, PyObject *value, void *closure)
{
    if (value == NULL) {
        PyErr_SetString(PyExc_AttributeError,
            "'TooManyAccentuatedPlugin' object attribute '_character_count' cannot be deleted");
        return -1;
    }
    if (self->__character_count != CPY_INT_TAG) {
        CPyTagged_DECREF(self->__character_count);
    }
    CPyTagged tmp;
    if (likely(PyLong_Check(value)))
        tmp = CPyTagged_FromObject(value);
    else {
        CPy_TypeError("int", value); return -1;
    }
    CPyTagged_INCREF(tmp);
    self->__character_count = tmp;
    return 0;
}

static PyObject *
TooManyAccentuatedPlugin_get__accentuated_count(charset_normalizer___md___TooManyAccentuatedPluginObject *self, void *closure)
{
    if (unlikely(self->__accentuated_count == CPY_INT_TAG)) {
        PyErr_SetString(PyExc_AttributeError,
            "attribute '_accentuated_count' of 'TooManyAccentuatedPlugin' undefined");
        return NULL;
    }
    CPyTagged_INCREF(self->__accentuated_count);
    PyObject *retval = CPyTagged_StealAsObject(self->__accentuated_count);
    return retval;
}

static int
TooManyAccentuatedPlugin_set__accentuated_count(charset_normalizer___md___TooManyAccentuatedPluginObject *self, PyObject *value, void *closure)
{
    if (value == NULL) {
        PyErr_SetString(PyExc_AttributeError,
            "'TooManyAccentuatedPlugin' object attribute '_accentuated_count' cannot be deleted");
        return -1;
    }
    if (self->__accentuated_count != CPY_INT_TAG) {
        CPyTagged_DECREF(self->__accentuated_count);
    }
    CPyTagged tmp;
    if (likely(PyLong_Check(value)))
        tmp = CPyTagged_FromObject(value);
    else {
        CPy_TypeError("int", value); return -1;
    }
    CPyTagged_INCREF(tmp);
    self->__accentuated_count = tmp;
    return 0;
}

static PyObject *
TooManyAccentuatedPlugin_get_ratio(charset_normalizer___md___TooManyAccentuatedPluginObject *self, void *closure)
{
    double retval = CPyDef_TooManyAccentuatedPlugin___ratio((PyObject *) self);
    if (retval == -113.0 && PyErr_Occurred()) {
        return NULL;
    }
    PyObject *retbox = PyFloat_FromDouble(retval);
    return retbox;
}

static int
UnprintablePlugin_init(PyObject *self, PyObject *args, PyObject *kwds)
{
    return 0;
}
PyObject *CPyDef___mypyc__UnprintablePlugin_setup(PyObject *cpy_r_type);
PyObject *CPyDef_UnprintablePlugin(void);

static PyObject *
UnprintablePlugin_new(PyTypeObject *type, PyObject *args, PyObject *kwds)
{
    if (type != CPyType_UnprintablePlugin) {
        PyErr_SetString(PyExc_TypeError, "interpreted classes cannot inherit from compiled");
        return NULL;
    }
    PyObject *self = CPyDef___mypyc__UnprintablePlugin_setup((PyObject*)type);
    if (self == NULL)
        return NULL;
    PyObject *ret = CPyPy_UnprintablePlugin_____init__(self, args, kwds);
    if (ret == NULL)
        return NULL;
    return self;
}

static int
UnprintablePlugin_traverse(charset_normalizer___md___UnprintablePluginObject *self, visitproc visit, void *arg)
{
    if (CPyTagged_CheckLong(self->__unprintable_count)) {
        Py_VISIT(CPyTagged_LongAsObject(self->__unprintable_count));
    }
    if (CPyTagged_CheckLong(self->__character_count)) {
        Py_VISIT(CPyTagged_LongAsObject(self->__character_count));
    }
    return 0;
}

static int
UnprintablePlugin_clear(charset_normalizer___md___UnprintablePluginObject *self)
{
    if (CPyTagged_CheckLong(self->__unprintable_count)) {
        CPyTagged __tmp = self->__unprintable_count;
        self->__unprintable_count = CPY_INT_TAG;
        Py_XDECREF(CPyTagged_LongAsObject(__tmp));
    }
    if (CPyTagged_CheckLong(self->__character_count)) {
        CPyTagged __tmp = self->__character_count;
        self->__character_count = CPY_INT_TAG;
        Py_XDECREF(CPyTagged_LongAsObject(__tmp));
    }
    return 0;
}

static void
UnprintablePlugin_dealloc(charset_normalizer___md___UnprintablePluginObject *self)
{
    PyObject_GC_UnTrack(self);
    CPy_TRASHCAN_BEGIN(self, UnprintablePlugin_dealloc)
    UnprintablePlugin_clear(self);
    Py_TYPE(self)->tp_free((PyObject *)self);
    CPy_TRASHCAN_END(self)
}

static CPyVTableItem UnprintablePlugin_vtable[9];
static bool
CPyDef_UnprintablePlugin_trait_vtable_setup(void)
{
    CPyVTableItem UnprintablePlugin_vtable_scratch[] = {
        (CPyVTableItem)CPyDef_UnprintablePlugin___eligible,
        (CPyVTableItem)CPyDef_UnprintablePlugin___feed,
        (CPyVTableItem)CPyDef_UnprintablePlugin___reset,
        (CPyVTableItem)CPyDef_UnprintablePlugin___ratio,
        (CPyVTableItem)CPyDef_UnprintablePlugin_____init__,
        (CPyVTableItem)CPyDef_UnprintablePlugin___eligible,
        (CPyVTableItem)CPyDef_UnprintablePlugin___feed,
        (CPyVTableItem)CPyDef_UnprintablePlugin___reset,
        (CPyVTableItem)CPyDef_UnprintablePlugin___ratio,
    };
    memcpy(UnprintablePlugin_vtable, UnprintablePlugin_vtable_scratch, sizeof(UnprintablePlugin_vtable));
    return 1;
}

static PyObject *
UnprintablePlugin_get__unprintable_count(charset_normalizer___md___UnprintablePluginObject *self, void *closure);
static int
UnprintablePlugin_set__unprintable_count(charset_normalizer___md___UnprintablePluginObject *self, PyObject *value, void *closure);
static PyObject *
UnprintablePlugin_get__character_count(charset_normalizer___md___UnprintablePluginObject *self, void *closure);
static int
UnprintablePlugin_set__character_count(charset_normalizer___md___UnprintablePluginObject *self, PyObject *value, void *closure);
static PyObject *
UnprintablePlugin_get_ratio(charset_normalizer___md___UnprintablePluginObject *self, void *closure);

static PyGetSetDef UnprintablePlugin_getseters[] = {
    {"_unprintable_count",
     (getter)UnprintablePlugin_get__unprintable_count, (setter)UnprintablePlugin_set__unprintable_count,
     NULL, NULL},
    {"_character_count",
     (getter)UnprintablePlugin_get__character_count, (setter)UnprintablePlugin_set__character_count,
     NULL, NULL},
    {"ratio",
     (getter)UnprintablePlugin_get_ratio,
    NULL, NULL, NULL},
    {NULL}  /* Sentinel */
};

static PyMethodDef UnprintablePlugin_methods[] = {
    {"__init__",
     (PyCFunction)CPyPy_UnprintablePlugin_____init__,
     METH_FASTCALL | METH_KEYWORDS, PyDoc_STR("__init__($self)\n--\n\n")},
    {"eligible",
     (PyCFunction)CPyPy_UnprintablePlugin___eligible,
     METH_FASTCALL | METH_KEYWORDS, PyDoc_STR("eligible($self, character)\n--\n\n")},
    {"feed",
     (PyCFunction)CPyPy_UnprintablePlugin___feed,
     METH_FASTCALL | METH_KEYWORDS, PyDoc_STR("feed($self, character)\n--\n\n")},
    {"reset",
     (PyCFunction)CPyPy_UnprintablePlugin___reset,
     METH_FASTCALL | METH_KEYWORDS, PyDoc_STR("reset($self)\n--\n\n")},
    {"__setstate__", (PyCFunction)CPyPickle_SetState, METH_O, NULL},
    {"__getstate__", (PyCFunction)CPyPickle_GetState, METH_NOARGS, NULL},
    {NULL}  /* Sentinel */
};

static PyTypeObject CPyType_UnprintablePlugin_template_ = {
    PyVarObject_HEAD_INIT(NULL, 0)
    .tp_name = "UnprintablePlugin",
    .tp_new = UnprintablePlugin_new,
    .tp_dealloc = (destructor)UnprintablePlugin_dealloc,
    .tp_traverse = (traverseproc)UnprintablePlugin_traverse,
    .tp_clear = (inquiry)UnprintablePlugin_clear,
    .tp_getset = UnprintablePlugin_getseters,
    .tp_methods = UnprintablePlugin_methods,
    .tp_init = UnprintablePlugin_init,
    .tp_basicsize = sizeof(charset_normalizer___md___UnprintablePluginObject),
    .tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_HEAPTYPE | Py_TPFLAGS_BASETYPE | Py_TPFLAGS_HAVE_GC,
    .tp_doc = PyDoc_STR("UnprintablePlugin()\n--\n\n"),
};
static PyTypeObject *CPyType_UnprintablePlugin_template = &CPyType_UnprintablePlugin_template_;

PyObject *CPyDef___mypyc__UnprintablePlugin_setup(PyObject *cpy_r_type)
{
    PyTypeObject *type = (PyTypeObject*)cpy_r_type;
    charset_normalizer___md___UnprintablePluginObject *self;
    self = (charset_normalizer___md___UnprintablePluginObject *)type->tp_alloc(type, 0);
    if (self == NULL)
        return NULL;
    self->vtable = UnprintablePlugin_vtable;
    self->__unprintable_count = CPY_INT_TAG;
    self->__character_count = CPY_INT_TAG;
    return (PyObject *)self;
}

PyObject *CPyDef_UnprintablePlugin(void)
{
    PyObject *self = CPyDef___mypyc__UnprintablePlugin_setup((PyObject *)CPyType_UnprintablePlugin);
    if (self == NULL)
        return NULL;
    char res = CPyDef_UnprintablePlugin_____init__(self);
    if (res == 2) {
        Py_DECREF(self);
        return NULL;
    }
    return self;
}

static PyObject *
UnprintablePlugin_get__unprintable_count(charset_normalizer___md___UnprintablePluginObject *self, void *closure)
{
    if (unlikely(self->__unprintable_count == CPY_INT_TAG)) {
        PyErr_SetString(PyExc_AttributeError,
            "attribute '_unprintable_count' of 'UnprintablePlugin' undefined");
        return NULL;
    }
    CPyTagged_INCREF(self->__unprintable_count);
    PyObject *retval = CPyTagged_StealAsObject(self->__unprintable_count);
    return retval;
}

static int
UnprintablePlugin_set__unprintable_count(charset_normalizer___md___UnprintablePluginObject *self, PyObject *value, void *closure)
{
    if (value == NULL) {
        PyErr_SetString(PyExc_AttributeError,
            "'UnprintablePlugin' object attribute '_unprintable_count' cannot be deleted");
        return -1;
    }
    if (self->__unprintable_count != CPY_INT_TAG) {
        CPyTagged_DECREF(self->__unprintable_count);
    }
    CPyTagged tmp;
    if (likely(PyLong_Check(value)))
        tmp = CPyTagged_FromObject(value);
    else {
        CPy_TypeError("int", value); return -1;
    }
    CPyTagged_INCREF(tmp);
    self->__unprintable_count = tmp;
    return 0;
}

static PyObject *
UnprintablePlugin_get__character_count(charset_normalizer___md___UnprintablePluginObject *self, void *closure)
{
    if (unlikely(self->__character_count == CPY_INT_TAG)) {
        PyErr_SetString(PyExc_AttributeError,
            "attribute '_character_count' of 'UnprintablePlugin' undefined");
        return NULL;
    }
    CPyTagged_INCREF(self->__character_count);
    PyObject *retval = CPyTagged_StealAsObject(self->__character_count);
    return retval;
}

static int
UnprintablePlugin_set__character_count(charset_normalizer___md___UnprintablePluginObject *self, PyObject *value, void *closure)
{
    if (value == NULL) {
        PyErr_SetString(PyExc_AttributeError,
            "'UnprintablePlugin' object attribute '_character_count' cannot be deleted");
        return -1;
    }
    if (self->__character_count != CPY_INT_TAG) {
        CPyTagged_DECREF(self->__character_count);
    }
    CPyTagged tmp;
    if (likely(PyLong_Check(value)))
        tmp = CPyTagged_FromObject(value);
    else {
        CPy_TypeError("int", value); return -1;
    }
    CPyTagged_INCREF(tmp);
    self->__character_count = tmp;
    return 0;
}

static PyObject *
UnprintablePlugin_get_ratio(charset_normalizer___md___UnprintablePluginObject *self, void *closure)
{
    double retval = CPyDef_UnprintablePlugin___ratio((PyObject *) self);
    if (retval == -113.0 && PyErr_Occurred()) {
        return NULL;
    }
    PyObject *retbox = PyFloat_FromDouble(retval);
    return retbox;
}

static int
SuspiciousDuplicateAccentPlugin_init(PyObject *self, PyObject *args, PyObject *kwds)
{
    return 0;
}
PyObject *CPyDef___mypyc__SuspiciousDuplicateAccentPlugin_setup(PyObject *cpy_r_type);
PyObject *CPyDef_SuspiciousDuplicateAccentPlugin(void);

static PyObject *
SuspiciousDuplicateAccentPlugin_new(PyTypeObject *type, PyObject *args, PyObject *kwds)
{
    if (type != CPyType_SuspiciousDuplicateAccentPlugin) {
        PyErr_SetString(PyExc_TypeError, "interpreted classes cannot inherit from compiled");
        return NULL;
    }
    PyObject *self = CPyDef___mypyc__SuspiciousDuplicateAccentPlugin_setup((PyObject*)type);
    if (self == NULL)
        return NULL;
    PyObject *ret = CPyPy_SuspiciousDuplicateAccentPlugin_____init__(self, args, kwds);
    if (ret == NULL)
        return NULL;
    return self;
}

static int
SuspiciousDuplicateAccentPlugin_traverse(charset_normalizer___md___SuspiciousDuplicateAccentPluginObject *self, visitproc visit, void *arg)
{
    if (CPyTagged_CheckLong(self->__successive_count)) {
        Py_VISIT(CPyTagged_LongAsObject(self->__successive_count));
    }
    if (CPyTagged_CheckLong(self->__character_count)) {
        Py_VISIT(CPyTagged_LongAsObject(self->__character_count));
    }
    Py_VISIT(self->__last_latin_character);
    return 0;
}

static int
SuspiciousDuplicateAccentPlugin_clear(charset_normalizer___md___SuspiciousDuplicateAccentPluginObject *self)
{
    if (CPyTagged_CheckLong(self->__successive_count)) {
        CPyTagged __tmp = self->__successive_count;
        self->__successive_count = CPY_INT_TAG;
        Py_XDECREF(CPyTagged_LongAsObject(__tmp));
    }
    if (CPyTagged_CheckLong(self->__character_count)) {
        CPyTagged __tmp = self->__character_count;
        self->__character_count = CPY_INT_TAG;
        Py_XDECREF(CPyTagged_LongAsObject(__tmp));
    }
    Py_CLEAR(self->__last_latin_character);
    return 0;
}

static void
SuspiciousDuplicateAccentPlugin_dealloc(charset_normalizer___md___SuspiciousDuplicateAccentPluginObject *self)
{
    PyObject_GC_UnTrack(self);
    CPy_TRASHCAN_BEGIN(self, SuspiciousDuplicateAccentPlugin_dealloc)
    SuspiciousDuplicateAccentPlugin_clear(self);
    Py_TYPE(self)->tp_free((PyObject *)self);
    CPy_TRASHCAN_END(self)
}

static CPyVTableItem SuspiciousDuplicateAccentPlugin_vtable[9];
static bool
CPyDef_SuspiciousDuplicateAccentPlugin_trait_vtable_setup(void)
{
    CPyVTableItem SuspiciousDuplicateAccentPlugin_vtable_scratch[] = {
        (CPyVTableItem)CPyDef_SuspiciousDuplicateAccentPlugin___eligible,
        (CPyVTableItem)CPyDef_SuspiciousDuplicateAccentPlugin___feed,
        (CPyVTableItem)CPyDef_SuspiciousDuplicateAccentPlugin___reset,
        (CPyVTableItem)CPyDef_SuspiciousDuplicateAccentPlugin___ratio,
        (CPyVTableItem)CPyDef_SuspiciousDuplicateAccentPlugin_____init__,
        (CPyVTableItem)CPyDef_SuspiciousDuplicateAccentPlugin___eligible,
        (CPyVTableItem)CPyDef_SuspiciousDuplicateAccentPlugin___feed,
        (CPyVTableItem)CPyDef_SuspiciousDuplicateAccentPlugin___reset,
        (CPyVTableItem)CPyDef_SuspiciousDuplicateAccentPlugin___ratio,
    };
    memcpy(SuspiciousDuplicateAccentPlugin_vtable, SuspiciousDuplicateAccentPlugin_vtable_scratch, sizeof(SuspiciousDuplicateAccentPlugin_vtable));
    return 1;
}

static PyObject *
SuspiciousDuplicateAccentPlugin_get__successive_count(charset_normalizer___md___SuspiciousDuplicateAccentPluginObject *self, void *closure);
static int
SuspiciousDuplicateAccentPlugin_set__successive_count(charset_normalizer___md___SuspiciousDuplicateAccentPluginObject *self, PyObject *value, void *closure);
static PyObject *
SuspiciousDuplicateAccentPlugin_get__character_count(charset_normalizer___md___SuspiciousDuplicateAccentPluginObject *self, void *closure);
static int
SuspiciousDuplicateAccentPlugin_set__character_count(charset_normalizer___md___SuspiciousDuplicateAccentPluginObject *self, PyObject *value, void *closure);
static PyObject *
SuspiciousDuplicateAccentPlugin_get__last_latin_character(charset_normalizer___md___SuspiciousDuplicateAccentPluginObject *self, void *closure);
static int
SuspiciousDuplicateAccentPlugin_set__last_latin_character(charset_normalizer___md___SuspiciousDuplicateAccentPluginObject *self, PyObject *value, void *closure);
static PyObject *
SuspiciousDuplicateAccentPlugin_get_ratio(charset_normalizer___md___SuspiciousDuplicateAccentPluginObject *self, void *closure);

static PyGetSetDef SuspiciousDuplicateAccentPlugin_getseters[] = {
    {"_successive_count",
     (getter)SuspiciousDuplicateAccentPlugin_get__successive_count, (setter)SuspiciousDuplicateAccentPlugin_set__successive_count,
     NULL, NULL},
    {"_character_count",
     (getter)SuspiciousDuplicateAccentPlugin_get__character_count, (setter)SuspiciousDuplicateAccentPlugin_set__character_count,
     NULL, NULL},
    {"_last_latin_character",
     (getter)SuspiciousDuplicateAccentPlugin_get__last_latin_character, (setter)SuspiciousDuplicateAccentPlugin_set__last_latin_character,
     NULL, NULL},
    {"ratio",
     (getter)SuspiciousDuplicateAccentPlugin_get_ratio,
    NULL, NULL, NULL},
    {NULL}  /* Sentinel */
};

static PyMethodDef SuspiciousDuplicateAccentPlugin_methods[] = {
    {"__init__",
     (PyCFunction)CPyPy_SuspiciousDuplicateAccentPlugin_____init__,
     METH_FASTCALL | METH_KEYWORDS, PyDoc_STR("__init__($self)\n--\n\n")},
    {"eligible",
     (PyCFunction)CPyPy_SuspiciousDuplicateAccentPlugin___eligible,
     METH_FASTCALL | METH_KEYWORDS, PyDoc_STR("eligible($self, character)\n--\n\n")},
    {"feed",
     (PyCFunction)CPyPy_SuspiciousDuplicateAccentPlugin___feed,
     METH_FASTCALL | METH_KEYWORDS, PyDoc_STR("feed($self, character)\n--\n\n")},
    {"reset",
     (PyCFunction)CPyPy_SuspiciousDuplicateAccentPlugin___reset,
     METH_FASTCALL | METH_KEYWORDS, PyDoc_STR("reset($self)\n--\n\n")},
    {"__setstate__", (PyCFunction)CPyPickle_SetState, METH_O, NULL},
    {"__getstate__", (PyCFunction)CPyPickle_GetState, METH_NOARGS, NULL},
    {NULL}  /* Sentinel */
};

static PyTypeObject CPyType_SuspiciousDuplicateAccentPlugin_template_ = {
    PyVarObject_HEAD_INIT(NULL, 0)
    .tp_name = "SuspiciousDuplicateAccentPlugin",
    .tp_new = SuspiciousDuplicateAccentPlugin_new,
    .tp_dealloc = (destructor)SuspiciousDuplicateAccentPlugin_dealloc,
    .tp_traverse = (traverseproc)SuspiciousDuplicateAccentPlugin_traverse,
    .tp_clear = (inquiry)SuspiciousDuplicateAccentPlugin_clear,
    .tp_getset = SuspiciousDuplicateAccentPlugin_getseters,
    .tp_methods = SuspiciousDuplicateAccentPlugin_methods,
    .tp_init = SuspiciousDuplicateAccentPlugin_init,
    .tp_basicsize = sizeof(charset_normalizer___md___SuspiciousDuplicateAccentPluginObject),
    .tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_HEAPTYPE | Py_TPFLAGS_BASETYPE | Py_TPFLAGS_HAVE_GC,
    .tp_doc = PyDoc_STR("SuspiciousDuplicateAccentPlugin()\n--\n\n"),
};
static PyTypeObject *CPyType_SuspiciousDuplicateAccentPlugin_template = &CPyType_SuspiciousDuplicateAccentPlugin_template_;

PyObject *CPyDef___mypyc__SuspiciousDuplicateAccentPlugin_setup(PyObject *cpy_r_type)
{
    PyTypeObject *type = (PyTypeObject*)cpy_r_type;
    charset_normalizer___md___SuspiciousDuplicateAccentPluginObject *self;
    self = (charset_normalizer___md___SuspiciousDuplicateAccentPluginObject *)type->tp_alloc(type, 0);
    if (self == NULL)
        return NULL;
    self->vtable = SuspiciousDuplicateAccentPlugin_vtable;
    self->__successive_count = CPY_INT_TAG;
    self->__character_count = CPY_INT_TAG;
    return (PyObject *)self;
}

PyObject *CPyDef_SuspiciousDuplicateAccentPlugin(void)
{
    PyObject *self = CPyDef___mypyc__SuspiciousDuplicateAccentPlugin_setup((PyObject *)CPyType_SuspiciousDuplicateAccentPlugin);
    if (self == NULL)
        return NULL;
    char res = CPyDef_SuspiciousDuplicateAccentPlugin_____init__(self);
    if (res == 2) {
        Py_DECREF(self);
        return NULL;
    }
    return self;
}

static PyObject *
SuspiciousDuplicateAccentPlugin_get__successive_count(charset_normalizer___md___SuspiciousDuplicateAccentPluginObject *self, void *closure)
{
    if (unlikely(self->__successive_count == CPY_INT_TAG)) {
        PyErr_SetString(PyExc_AttributeError,
            "attribute '_successive_count' of 'SuspiciousDuplicateAccentPlugin' undefined");
        return NULL;
    }
    CPyTagged_INCREF(self->__successive_count);
    PyObject *retval = CPyTagged_StealAsObject(self->__successive_count);
    return retval;
}

static int
SuspiciousDuplicateAccentPlugin_set__successive_count(charset_normalizer___md___SuspiciousDuplicateAccentPluginObject *self, PyObject *value, void *closure)
{
    if (value == NULL) {
        PyErr_SetString(PyExc_AttributeError,
            "'SuspiciousDuplicateAccentPlugin' object attribute '_successive_count' cannot be deleted");
        return -1;
    }
    if (self->__successive_count != CPY_INT_TAG) {
        CPyTagged_DECREF(self->__successive_count);
    }
    CPyTagged tmp;
    if (likely(PyLong_Check(value)))
        tmp = CPyTagged_FromObject(value);
    else {
        CPy_TypeError("int", value); return -1;
    }
    CPyTagged_INCREF(tmp);
    self->__successive_count = tmp;
    return 0;
}

static PyObject *
SuspiciousDuplicateAccentPlugin_get__character_count(charset_normalizer___md___SuspiciousDuplicateAccentPluginObject *self, void *closure)
{
    if (unlikely(self->__character_count == CPY_INT_TAG)) {
        PyErr_SetString(PyExc_AttributeError,
            "attribute '_character_count' of 'SuspiciousDuplicateAccentPlugin' undefined");
        return NULL;
    }
    CPyTagged_INCREF(self->__character_count);
    PyObject *retval = CPyTagged_StealAsObject(self->__character_count);
    return retval;
}

static int
SuspiciousDuplicateAccentPlugin_set__character_count(charset_normalizer___md___SuspiciousDuplicateAccentPluginObject *self, PyObject *value, void *closure)
{
    if (value == NULL) {
        PyErr_SetString(PyExc_AttributeError,
            "'SuspiciousDuplicateAccentPlugin' object attribute '_character_count' cannot be deleted");
        return -1;
    }
    if (self->__character_count != CPY_INT_TAG) {
        CPyTagged_DECREF(self->__character_count);
    }
    CPyTagged tmp;
    if (likely(PyLong_Check(value)))
        tmp = CPyTagged_FromObject(value);
    else {
        CPy_TypeError("int", value); return -1;
    }
    CPyTagged_INCREF(tmp);
    self->__character_count = tmp;
    return 0;
}

static PyObject *
SuspiciousDuplicateAccentPlugin_get__last_latin_character(charset_normalizer___md___SuspiciousDuplicateAccentPluginObject *self, void *closure)
{
    if (unlikely(self->__last_latin_character == NULL)) {
        PyErr_SetString(PyExc_AttributeError,
            "attribute '_last_latin_character' of 'SuspiciousDuplicateAccentPlugin' undefined");
        return NULL;
    }
    CPy_INCREF(self->__last_latin_character);
    PyObject *retval = self->__last_latin_character;
    return retval;
}

static int
SuspiciousDuplicateAccentPlugin_set__last_latin_character(charset_normalizer___md___SuspiciousDuplicateAccentPluginObject *self, PyObject *value, void *closure)
{
    if (value == NULL) {
        PyErr_SetString(PyExc_AttributeError,
            "'SuspiciousDuplicateAccentPlugin' object attribute '_last_latin_character' cannot be deleted");
        return -1;
    }
    if (self->__last_latin_character != NULL) {
        CPy_DECREF(self->__last_latin_character);
    }
    PyObject *tmp;
    if (PyUnicode_Check(value))
        tmp = value;
    else {
        tmp = NULL;
    }
    if (tmp != NULL) goto __LL2;
    if (value == Py_None)
        tmp = value;
    else {
        tmp = NULL;
    }
    if (tmp != NULL) goto __LL2;
    CPy_TypeError("str or None", value); 
    tmp = NULL;
__LL2: ;
    if (!tmp)
        return -1;
    CPy_INCREF(tmp);
    self->__last_latin_character = tmp;
    return 0;
}

static PyObject *
SuspiciousDuplicateAccentPlugin_get_ratio(charset_normalizer___md___SuspiciousDuplicateAccentPluginObject *self, void *closure)
{
    double retval = CPyDef_SuspiciousDuplicateAccentPlugin___ratio((PyObject *) self);
    if (retval == -113.0 && PyErr_Occurred()) {
        return NULL;
    }
    PyObject *retbox = PyFloat_FromDouble(retval);
    return retbox;
}

static int
SuspiciousRange_init(PyObject *self, PyObject *args, PyObject *kwds)
{
    return 0;
}
PyObject *CPyDef___mypyc__SuspiciousRange_setup(PyObject *cpy_r_type);
PyObject *CPyDef_SuspiciousRange(void);

static PyObject *
SuspiciousRange_new(PyTypeObject *type, PyObject *args, PyObject *kwds)
{
    if (type != CPyType_SuspiciousRange) {
        PyErr_SetString(PyExc_TypeError, "interpreted classes cannot inherit from compiled");
        return NULL;
    }
    PyObject *self = CPyDef___mypyc__SuspiciousRange_setup((PyObject*)type);
    if (self == NULL)
        return NULL;
    PyObject *ret = CPyPy_SuspiciousRange_____init__(self, args, kwds);
    if (ret == NULL)
        return NULL;
    return self;
}

static int
SuspiciousRange_traverse(charset_normalizer___md___SuspiciousRangeObject *self, visitproc visit, void *arg)
{
    if (CPyTagged_CheckLong(self->__suspicious_successive_range_count)) {
        Py_VISIT(CPyTagged_LongAsObject(self->__suspicious_successive_range_count));
    }
    if (CPyTagged_CheckLong(self->__character_count)) {
        Py_VISIT(CPyTagged_LongAsObject(self->__character_count));
    }
    Py_VISIT(self->__last_printable_seen);
    return 0;
}

static int
SuspiciousRange_clear(charset_normalizer___md___SuspiciousRangeObject *self)
{
    if (CPyTagged_CheckLong(self->__suspicious_successive_range_count)) {
        CPyTagged __tmp = self->__suspicious_successive_range_count;
        self->__suspicious_successive_range_count = CPY_INT_TAG;
        Py_XDECREF(CPyTagged_LongAsObject(__tmp));
    }
    if (CPyTagged_CheckLong(self->__character_count)) {
        CPyTagged __tmp = self->__character_count;
        self->__character_count = CPY_INT_TAG;
        Py_XDECREF(CPyTagged_LongAsObject(__tmp));
    }
    Py_CLEAR(self->__last_printable_seen);
    return 0;
}

static void
SuspiciousRange_dealloc(charset_normalizer___md___SuspiciousRangeObject *self)
{
    PyObject_GC_UnTrack(self);
    CPy_TRASHCAN_BEGIN(self, SuspiciousRange_dealloc)
    SuspiciousRange_clear(self);
    Py_TYPE(self)->tp_free((PyObject *)self);
    CPy_TRASHCAN_END(self)
}

static CPyVTableItem SuspiciousRange_vtable[9];
static bool
CPyDef_SuspiciousRange_trait_vtable_setup(void)
{
    CPyVTableItem SuspiciousRange_vtable_scratch[] = {
        (CPyVTableItem)CPyDef_SuspiciousRange___eligible,
        (CPyVTableItem)CPyDef_SuspiciousRange___feed,
        (CPyVTableItem)CPyDef_SuspiciousRange___reset,
        (CPyVTableItem)CPyDef_SuspiciousRange___ratio,
        (CPyVTableItem)CPyDef_SuspiciousRange_____init__,
        (CPyVTableItem)CPyDef_SuspiciousRange___eligible,
        (CPyVTableItem)CPyDef_SuspiciousRange___feed,
        (CPyVTableItem)CPyDef_SuspiciousRange___reset,
        (CPyVTableItem)CPyDef_SuspiciousRange___ratio,
    };
    memcpy(SuspiciousRange_vtable, SuspiciousRange_vtable_scratch, sizeof(SuspiciousRange_vtable));
    return 1;
}

static PyObject *
SuspiciousRange_get__suspicious_successive_range_count(charset_normalizer___md___SuspiciousRangeObject *self, void *closure);
static int
SuspiciousRange_set__suspicious_successive_range_count(charset_normalizer___md___SuspiciousRangeObject *self, PyObject *value, void *closure);
static PyObject *
SuspiciousRange_get__character_count(charset_normalizer___md___SuspiciousRangeObject *self, void *closure);
static int
SuspiciousRange_set__character_count(charset_normalizer___md___SuspiciousRangeObject *self, PyObject *value, void *closure);
static PyObject *
SuspiciousRange_get__last_printable_seen(charset_normalizer___md___SuspiciousRangeObject *self, void *closure);
static int
SuspiciousRange_set__last_printable_seen(charset_normalizer___md___SuspiciousRangeObject *self, PyObject *value, void *closure);
static PyObject *
SuspiciousRange_get_ratio(charset_normalizer___md___SuspiciousRangeObject *self, void *closure);

static PyGetSetDef SuspiciousRange_getseters[] = {
    {"_suspicious_successive_range_count",
     (getter)SuspiciousRange_get__suspicious_successive_range_count, (setter)SuspiciousRange_set__suspicious_successive_range_count,
     NULL, NULL},
    {"_character_count",
     (getter)SuspiciousRange_get__character_count, (setter)SuspiciousRange_set__character_count,
     NULL, NULL},
    {"_last_printable_seen",
     (getter)SuspiciousRange_get__last_printable_seen, (setter)SuspiciousRange_set__last_printable_seen,
     NULL, NULL},
    {"ratio",
     (getter)SuspiciousRange_get_ratio,
    NULL, NULL, NULL},
    {NULL}  /* Sentinel */
};

static PyMethodDef SuspiciousRange_methods[] = {
    {"__init__",
     (PyCFunction)CPyPy_SuspiciousRange_____init__,
     METH_FASTCALL | METH_KEYWORDS, PyDoc_STR("__init__($self)\n--\n\n")},
    {"eligible",
     (PyCFunction)CPyPy_SuspiciousRange___eligible,
     METH_FASTCALL | METH_KEYWORDS, PyDoc_STR("eligible($self, character)\n--\n\n")},
    {"feed",
     (PyCFunction)CPyPy_SuspiciousRange___feed,
     METH_FASTCALL | METH_KEYWORDS, PyDoc_STR("feed($self, character)\n--\n\n")},
    {"reset",
     (PyCFunction)CPyPy_SuspiciousRange___reset,
     METH_FASTCALL | METH_KEYWORDS, PyDoc_STR("reset($self)\n--\n\n")},
    {"__setstate__", (PyCFunction)CPyPickle_SetState, METH_O, NULL},
    {"__getstate__", (PyCFunction)CPyPickle_GetState, METH_NOARGS, NULL},
    {NULL}  /* Sentinel */
};

static PyTypeObject CPyType_SuspiciousRange_template_ = {
    PyVarObject_HEAD_INIT(NULL, 0)
    .tp_name = "SuspiciousRange",
    .tp_new = SuspiciousRange_new,
    .tp_dealloc = (destructor)SuspiciousRange_dealloc,
    .tp_traverse = (traverseproc)SuspiciousRange_traverse,
    .tp_clear = (inquiry)SuspiciousRange_clear,
    .tp_getset = SuspiciousRange_getseters,
    .tp_methods = SuspiciousRange_methods,
    .tp_init = SuspiciousRange_init,
    .tp_basicsize = sizeof(charset_normalizer___md___SuspiciousRangeObject),
    .tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_HEAPTYPE | Py_TPFLAGS_BASETYPE | Py_TPFLAGS_HAVE_GC,
    .tp_doc = PyDoc_STR("SuspiciousRange()\n--\n\n"),
};
static PyTypeObject *CPyType_SuspiciousRange_template = &CPyType_SuspiciousRange_template_;

PyObject *CPyDef___mypyc__SuspiciousRange_setup(PyObject *cpy_r_type)
{
    PyTypeObject *type = (PyTypeObject*)cpy_r_type;
    charset_normalizer___md___SuspiciousRangeObject *self;
    self = (charset_normalizer___md___SuspiciousRangeObject *)type->tp_alloc(type, 0);
    if (self == NULL)
        return NULL;
    self->vtable = SuspiciousRange_vtable;
    self->__suspicious_successive_range_count = CPY_INT_TAG;
    self->__character_count = CPY_INT_TAG;
    return (PyObject *)self;
}

PyObject *CPyDef_SuspiciousRange(void)
{
    PyObject *self = CPyDef___mypyc__SuspiciousRange_setup((PyObject *)CPyType_SuspiciousRange);
    if (self == NULL)
        return NULL;
    char res = CPyDef_SuspiciousRange_____init__(self);
    if (res == 2) {
        Py_DECREF(self);
        return NULL;
    }
    return self;
}

static PyObject *
SuspiciousRange_get__suspicious_successive_range_count(charset_normalizer___md___SuspiciousRangeObject *self, void *closure)
{
    if (unlikely(self->__suspicious_successive_range_count == CPY_INT_TAG)) {
        PyErr_SetString(PyExc_AttributeError,
            "attribute '_suspicious_successive_range_count' of 'SuspiciousRange' undefined");
        return NULL;
    }
    CPyTagged_INCREF(self->__suspicious_successive_range_count);
    PyObject *retval = CPyTagged_StealAsObject(self->__suspicious_successive_range_count);
    return retval;
}

static int
SuspiciousRange_set__suspicious_successive_range_count(charset_normalizer___md___SuspiciousRangeObject *self, PyObject *value, void *closure)
{
    if (value == NULL) {
        PyErr_SetString(PyExc_AttributeError,
            "'SuspiciousRange' object attribute '_suspicious_successive_range_count' cannot be deleted");
        return -1;
    }
    if (self->__suspicious_successive_range_count != CPY_INT_TAG) {
        CPyTagged_DECREF(self->__suspicious_successive_range_count);
    }
    CPyTagged tmp;
    if (likely(PyLong_Check(value)))
        tmp = CPyTagged_FromObject(value);
    else {
        CPy_TypeError("int", value); return -1;
    }
    CPyTagged_INCREF(tmp);
    self->__suspicious_successive_range_count = tmp;
    return 0;
}

static PyObject *
SuspiciousRange_get__character_count(charset_normalizer___md___SuspiciousRangeObject *self, void *closure)
{
    if (unlikely(self->__character_count == CPY_INT_TAG)) {
        PyErr_SetString(PyExc_AttributeError,
            "attribute '_character_count' of 'SuspiciousRange' undefined");
        return NULL;
    }
    CPyTagged_INCREF(self->__character_count);
    PyObject *retval = CPyTagged_StealAsObject(self->__character_count);
    return retval;
}

static int
SuspiciousRange_set__character_count(charset_normalizer___md___SuspiciousRangeObject *self, PyObject *value, void *closure)
{
    if (value == NULL) {
        PyErr_SetString(PyExc_AttributeError,
            "'SuspiciousRange' object attribute '_character_count' cannot be deleted");
        return -1;
    }
    if (self->__character_count != CPY_INT_TAG) {
        CPyTagged_DECREF(self->__character_count);
    }
    CPyTagged tmp;
    if (likely(PyLong_Check(value)))
        tmp = CPyTagged_FromObject(value);
    else {
        CPy_TypeError("int", value); return -1;
    }
    CPyTagged_INCREF(tmp);
    self->__character_count = tmp;
    return 0;
}

static PyObject *
SuspiciousRange_get__last_printable_seen(charset_normalizer___md___SuspiciousRangeObject *self, void *closure)
{
    if (unlikely(self->__last_printable_seen == NULL)) {
        PyErr_SetString(PyExc_AttributeError,
            "attribute '_last_printable_seen' of 'SuspiciousRange' undefined");
        return NULL;
    }
    CPy_INCREF(self->__last_printable_seen);
    PyObject *retval = self->__last_printable_seen;
    return retval;
}

static int
SuspiciousRange_set__last_printable_seen(charset_normalizer___md___SuspiciousRangeObject *self, PyObject *value, void *closure)
{
    if (value == NULL) {
        PyErr_SetString(PyExc_AttributeError,
            "'SuspiciousRange' object attribute '_last_printable_seen' cannot be deleted");
        return -1;
    }
    if (self->__last_printable_seen != NULL) {
        CPy_DECREF(self->__last_printable_seen);
    }
    PyObject *tmp;
    if (PyUnicode_Check(value))
        tmp = value;
    else {
        tmp = NULL;
    }
    if (tmp != NULL) goto __LL3;
    if (value == Py_None)
        tmp = value;
    else {
        tmp = NULL;
    }
    if (tmp != NULL) goto __LL3;
    CPy_TypeError("str or None", value); 
    tmp = NULL;
__LL3: ;
    if (!tmp)
        return -1;
    CPy_INCREF(tmp);
    self->__last_printable_seen = tmp;
    return 0;
}

static PyObject *
SuspiciousRange_get_ratio(charset_normalizer___md___SuspiciousRangeObject *self, void *closure)
{
    double retval = CPyDef_SuspiciousRange___ratio((PyObject *) self);
    if (retval == -113.0 && PyErr_Occurred()) {
        return NULL;
    }
    PyObject *retbox = PyFloat_FromDouble(retval);
    return retbox;
}

static int
SuperWeirdWordPlugin_init(PyObject *self, PyObject *args, PyObject *kwds)
{
    return 0;
}
PyObject *CPyDef___mypyc__SuperWeirdWordPlugin_setup(PyObject *cpy_r_type);
PyObject *CPyDef_SuperWeirdWordPlugin(void);

static PyObject *
SuperWeirdWordPlugin_new(PyTypeObject *type, PyObject *args, PyObject *kwds)
{
    if (type != CPyType_SuperWeirdWordPlugin) {
        PyErr_SetString(PyExc_TypeError, "interpreted classes cannot inherit from compiled");
        return NULL;
    }
    PyObject *self = CPyDef___mypyc__SuperWeirdWordPlugin_setup((PyObject*)type);
    if (self == NULL)
        return NULL;
    PyObject *ret = CPyPy_SuperWeirdWordPlugin_____init__(self, args, kwds);
    if (ret == NULL)
        return NULL;
    return self;
}

static int
SuperWeirdWordPlugin_traverse(charset_normalizer___md___SuperWeirdWordPluginObject *self, visitproc visit, void *arg)
{
    if (CPyTagged_CheckLong(self->__word_count)) {
        Py_VISIT(CPyTagged_LongAsObject(self->__word_count));
    }
    if (CPyTagged_CheckLong(self->__bad_word_count)) {
        Py_VISIT(CPyTagged_LongAsObject(self->__bad_word_count));
    }
    if (CPyTagged_CheckLong(self->__foreign_long_count)) {
        Py_VISIT(CPyTagged_LongAsObject(self->__foreign_long_count));
    }
    if (CPyTagged_CheckLong(self->__character_count)) {
        Py_VISIT(CPyTagged_LongAsObject(self->__character_count));
    }
    if (CPyTagged_CheckLong(self->__bad_character_count)) {
        Py_VISIT(CPyTagged_LongAsObject(self->__bad_character_count));
    }
    Py_VISIT(self->__buffer);
    if (CPyTagged_CheckLong(self->__buffer_accent_count)) {
        Py_VISIT(CPyTagged_LongAsObject(self->__buffer_accent_count));
    }
    if (CPyTagged_CheckLong(self->__buffer_glyph_count)) {
        Py_VISIT(CPyTagged_LongAsObject(self->__buffer_glyph_count));
    }
    return 0;
}

static int
SuperWeirdWordPlugin_clear(charset_normalizer___md___SuperWeirdWordPluginObject *self)
{
    if (CPyTagged_CheckLong(self->__word_count)) {
        CPyTagged __tmp = self->__word_count;
        self->__word_count = CPY_INT_TAG;
        Py_XDECREF(CPyTagged_LongAsObject(__tmp));
    }
    if (CPyTagged_CheckLong(self->__bad_word_count)) {
        CPyTagged __tmp = self->__bad_word_count;
        self->__bad_word_count = CPY_INT_TAG;
        Py_XDECREF(CPyTagged_LongAsObject(__tmp));
    }
    if (CPyTagged_CheckLong(self->__foreign_long_count)) {
        CPyTagged __tmp = self->__foreign_long_count;
        self->__foreign_long_count = CPY_INT_TAG;
        Py_XDECREF(CPyTagged_LongAsObject(__tmp));
    }
    if (CPyTagged_CheckLong(self->__character_count)) {
        CPyTagged __tmp = self->__character_count;
        self->__character_count = CPY_INT_TAG;
        Py_XDECREF(CPyTagged_LongAsObject(__tmp));
    }
    if (CPyTagged_CheckLong(self->__bad_character_count)) {
        CPyTagged __tmp = self->__bad_character_count;
        self->__bad_character_count = CPY_INT_TAG;
        Py_XDECREF(CPyTagged_LongAsObject(__tmp));
    }
    Py_CLEAR(self->__buffer);
    if (CPyTagged_CheckLong(self->__buffer_accent_count)) {
        CPyTagged __tmp = self->__buffer_accent_count;
        self->__buffer_accent_count = CPY_INT_TAG;
        Py_XDECREF(CPyTagged_LongAsObject(__tmp));
    }
    if (CPyTagged_CheckLong(self->__buffer_glyph_count)) {
        CPyTagged __tmp = self->__buffer_glyph_count;
        self->__buffer_glyph_count = CPY_INT_TAG;
        Py_XDECREF(CPyTagged_LongAsObject(__tmp));
    }
    return 0;
}

static void
SuperWeirdWordPlugin_dealloc(charset_normalizer___md___SuperWeirdWordPluginObject *self)
{
    PyObject_GC_UnTrack(self);
    CPy_TRASHCAN_BEGIN(self, SuperWeirdWordPlugin_dealloc)
    SuperWeirdWordPlugin_clear(self);
    Py_TYPE(self)->tp_free((PyObject *)self);
    CPy_TRASHCAN_END(self)
}

static CPyVTableItem SuperWeirdWordPlugin_vtable[9];
static bool
CPyDef_SuperWeirdWordPlugin_trait_vtable_setup(void)
{
    CPyVTableItem SuperWeirdWordPlugin_vtable_scratch[] = {
        (CPyVTableItem)CPyDef_SuperWeirdWordPlugin___eligible,
        (CPyVTableItem)CPyDef_SuperWeirdWordPlugin___feed,
        (CPyVTableItem)CPyDef_SuperWeirdWordPlugin___reset,
        (CPyVTableItem)CPyDef_SuperWeirdWordPlugin___ratio,
        (CPyVTableItem)CPyDef_SuperWeirdWordPlugin_____init__,
        (CPyVTableItem)CPyDef_SuperWeirdWordPlugin___eligible,
        (CPyVTableItem)CPyDef_SuperWeirdWordPlugin___feed,
        (CPyVTableItem)CPyDef_SuperWeirdWordPlugin___reset,
        (CPyVTableItem)CPyDef_SuperWeirdWordPlugin___ratio,
    };
    memcpy(SuperWeirdWordPlugin_vtable, SuperWeirdWordPlugin_vtable_scratch, sizeof(SuperWeirdWordPlugin_vtable));
    return 1;
}

static PyObject *
SuperWeirdWordPlugin_get__word_count(charset_normalizer___md___SuperWeirdWordPluginObject *self, void *closure);
static int
SuperWeirdWordPlugin_set__word_count(charset_normalizer___md___SuperWeirdWordPluginObject *self, PyObject *value, void *closure);
static PyObject *
SuperWeirdWordPlugin_get__bad_word_count(charset_normalizer___md___SuperWeirdWordPluginObject *self, void *closure);
static int
SuperWeirdWordPlugin_set__bad_word_count(charset_normalizer___md___SuperWeirdWordPluginObject *self, PyObject *value, void *closure);
static PyObject *
SuperWeirdWordPlugin_get__foreign_long_count(charset_normalizer___md___SuperWeirdWordPluginObject *self, void *closure);
static int
SuperWeirdWordPlugin_set__foreign_long_count(charset_normalizer___md___SuperWeirdWordPluginObject *self, PyObject *value, void *closure);
static PyObject *
SuperWeirdWordPlugin_get__is_current_word_bad(charset_normalizer___md___SuperWeirdWordPluginObject *self, void *closure);
static int
SuperWeirdWordPlugin_set__is_current_word_bad(charset_normalizer___md___SuperWeirdWordPluginObject *self, PyObject *value, void *closure);
static PyObject *
SuperWeirdWordPlugin_get__foreign_long_watch(charset_normalizer___md___SuperWeirdWordPluginObject *self, void *closure);
static int
SuperWeirdWordPlugin_set__foreign_long_watch(charset_normalizer___md___SuperWeirdWordPluginObject *self, PyObject *value, void *closure);
static PyObject *
SuperWeirdWordPlugin_get__character_count(charset_normalizer___md___SuperWeirdWordPluginObject *self, void *closure);
static int
SuperWeirdWordPlugin_set__character_count(charset_normalizer___md___SuperWeirdWordPluginObject *self, PyObject *value, void *closure);
static PyObject *
SuperWeirdWordPlugin_get__bad_character_count(charset_normalizer___md___SuperWeirdWordPluginObject *self, void *closure);
static int
SuperWeirdWordPlugin_set__bad_character_count(charset_normalizer___md___SuperWeirdWordPluginObject *self, PyObject *value, void *closure);
static PyObject *
SuperWeirdWordPlugin_get__buffer(charset_normalizer___md___SuperWeirdWordPluginObject *self, void *closure);
static int
SuperWeirdWordPlugin_set__buffer(charset_normalizer___md___SuperWeirdWordPluginObject *self, PyObject *value, void *closure);
static PyObject *
SuperWeirdWordPlugin_get__buffer_accent_count(charset_normalizer___md___SuperWeirdWordPluginObject *self, void *closure);
static int
SuperWeirdWordPlugin_set__buffer_accent_count(charset_normalizer___md___SuperWeirdWordPluginObject *self, PyObject *value, void *closure);
static PyObject *
SuperWeirdWordPlugin_get__buffer_glyph_count(charset_normalizer___md___SuperWeirdWordPluginObject *self, void *closure);
static int
SuperWeirdWordPlugin_set__buffer_glyph_count(charset_normalizer___md___SuperWeirdWordPluginObject *self, PyObject *value, void *closure);
static PyObject *
SuperWeirdWordPlugin_get_ratio(charset_normalizer___md___SuperWeirdWordPluginObject *self, void *closure);

static PyGetSetDef SuperWeirdWordPlugin_getseters[] = {
    {"_word_count",
     (getter)SuperWeirdWordPlugin_get__word_count, (setter)SuperWeirdWordPlugin_set__word_count,
     NULL, NULL},
    {"_bad_word_count",
     (getter)SuperWeirdWordPlugin_get__bad_word_count, (setter)SuperWeirdWordPlugin_set__bad_word_count,
     NULL, NULL},
    {"_foreign_long_count",
     (getter)SuperWeirdWordPlugin_get__foreign_long_count, (setter)SuperWeirdWordPlugin_set__foreign_long_count,
     NULL, NULL},
    {"_is_current_word_bad",
     (getter)SuperWeirdWordPlugin_get__is_current_word_bad, (setter)SuperWeirdWordPlugin_set__is_current_word_bad,
     NULL, NULL},
    {"_foreign_long_watch",
     (getter)SuperWeirdWordPlugin_get__foreign_long_watch, (setter)SuperWeirdWordPlugin_set__foreign_long_watch,
     NULL, NULL},
    {"_character_count",
     (getter)SuperWeirdWordPlugin_get__character_count, (setter)SuperWeirdWordPlugin_set__character_count,
     NULL, NULL},
    {"_bad_character_count",
     (getter)SuperWeirdWordPlugin_get__bad_character_count, (setter)SuperWeirdWordPlugin_set__bad_character_count,
     NULL, NULL},
    {"_buffer",
     (getter)SuperWeirdWordPlugin_get__buffer, (setter)SuperWeirdWordPlugin_set__buffer,
     NULL, NULL},
    {"_buffer_accent_count",
     (getter)SuperWeirdWordPlugin_get__buffer_accent_count, (setter)SuperWeirdWordPlugin_set__buffer_accent_count,
     NULL, NULL},
    {"_buffer_glyph_count",
     (getter)SuperWeirdWordPlugin_get__buffer_glyph_count, (setter)SuperWeirdWordPlugin_set__buffer_glyph_count,
     NULL, NULL},
    {"ratio",
     (getter)SuperWeirdWordPlugin_get_ratio,
    NULL, NULL, NULL},
    {NULL}  /* Sentinel */
};

static PyMethodDef SuperWeirdWordPlugin_methods[] = {
    {"__init__",
     (PyCFunction)CPyPy_SuperWeirdWordPlugin_____init__,
     METH_FASTCALL | METH_KEYWORDS, PyDoc_STR("__init__($self)\n--\n\n")},
    {"eligible",
     (PyCFunction)CPyPy_SuperWeirdWordPlugin___eligible,
     METH_FASTCALL | METH_KEYWORDS, PyDoc_STR("eligible($self, character)\n--\n\n")},
    {"feed",
     (PyCFunction)CPyPy_SuperWeirdWordPlugin___feed,
     METH_FASTCALL | METH_KEYWORDS, PyDoc_STR("feed($self, character)\n--\n\n")},
    {"reset",
     (PyCFunction)CPyPy_SuperWeirdWordPlugin___reset,
     METH_FASTCALL | METH_KEYWORDS, PyDoc_STR("reset($self)\n--\n\n")},
    {"__setstate__", (PyCFunction)CPyPickle_SetState, METH_O, NULL},
    {"__getstate__", (PyCFunction)CPyPickle_GetState, METH_NOARGS, NULL},
    {NULL}  /* Sentinel */
};

static PyTypeObject CPyType_SuperWeirdWordPlugin_template_ = {
    PyVarObject_HEAD_INIT(NULL, 0)
    .tp_name = "SuperWeirdWordPlugin",
    .tp_new = SuperWeirdWordPlugin_new,
    .tp_dealloc = (destructor)SuperWeirdWordPlugin_dealloc,
    .tp_traverse = (traverseproc)SuperWeirdWordPlugin_traverse,
    .tp_clear = (inquiry)SuperWeirdWordPlugin_clear,
    .tp_getset = SuperWeirdWordPlugin_getseters,
    .tp_methods = SuperWeirdWordPlugin_methods,
    .tp_init = SuperWeirdWordPlugin_init,
    .tp_basicsize = sizeof(charset_normalizer___md___SuperWeirdWordPluginObject),
    .tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_HEAPTYPE | Py_TPFLAGS_BASETYPE | Py_TPFLAGS_HAVE_GC,
    .tp_doc = PyDoc_STR("SuperWeirdWordPlugin()\n--\n\n"),
};
static PyTypeObject *CPyType_SuperWeirdWordPlugin_template = &CPyType_SuperWeirdWordPlugin_template_;

PyObject *CPyDef___mypyc__SuperWeirdWordPlugin_setup(PyObject *cpy_r_type)
{
    PyTypeObject *type = (PyTypeObject*)cpy_r_type;
    charset_normalizer___md___SuperWeirdWordPluginObject *self;
    self = (charset_normalizer___md___SuperWeirdWordPluginObject *)type->tp_alloc(type, 0);
    if (self == NULL)
        return NULL;
    self->vtable = SuperWeirdWordPlugin_vtable;
    self->__word_count = CPY_INT_TAG;
    self->__bad_word_count = CPY_INT_TAG;
    self->__foreign_long_count = CPY_INT_TAG;
    self->__is_current_word_bad = 2;
    self->__foreign_long_watch = 2;
    self->__character_count = CPY_INT_TAG;
    self->__bad_character_count = CPY_INT_TAG;
    self->__buffer_accent_count = CPY_INT_TAG;
    self->__buffer_glyph_count = CPY_INT_TAG;
    return (PyObject *)self;
}

PyObject *CPyDef_SuperWeirdWordPlugin(void)
{
    PyObject *self = CPyDef___mypyc__SuperWeirdWordPlugin_setup((PyObject *)CPyType_SuperWeirdWordPlugin);
    if (self == NULL)
        return NULL;
    char res = CPyDef_SuperWeirdWordPlugin_____init__(self);
    if (res == 2) {
        Py_DECREF(self);
        return NULL;
    }
    return self;
}

static PyObject *
SuperWeirdWordPlugin_get__word_count(charset_normalizer___md___SuperWeirdWordPluginObject *self, void *closure)
{
    if (unlikely(self->__word_count == CPY_INT_TAG)) {
        PyErr_SetString(PyExc_AttributeError,
            "attribute '_word_count' of 'SuperWeirdWordPlugin' undefined");
        return NULL;
    }
    CPyTagged_INCREF(self->__word_count);
    PyObject *retval = CPyTagged_StealAsObject(self->__word_count);
    return retval;
}

static int
SuperWeirdWordPlugin_set__word_count(charset_normalizer___md___SuperWeirdWordPluginObject *self, PyObject *value, void *closure)
{
    if (value == NULL) {
        PyErr_SetString(PyExc_AttributeError,
            "'SuperWeirdWordPlugin' object attribute '_word_count' cannot be deleted");
        return -1;
    }
    if (self->__word_count != CPY_INT_TAG) {
        CPyTagged_DECREF(self->__word_count);
    }
    CPyTagged tmp;
    if (likely(PyLong_Check(value)))
        tmp = CPyTagged_FromObject(value);
    else {
        CPy_TypeError("int", value); return -1;
    }
    CPyTagged_INCREF(tmp);
    self->__word_count = tmp;
    return 0;
}

static PyObject *
SuperWeirdWordPlugin_get__bad_word_count(charset_normalizer___md___SuperWeirdWordPluginObject *self, void *closure)
{
    if (unlikely(self->__bad_word_count == CPY_INT_TAG)) {
        PyErr_SetString(PyExc_AttributeError,
            "attribute '_bad_word_count' of 'SuperWeirdWordPlugin' undefined");
        return NULL;
    }
    CPyTagged_INCREF(self->__bad_word_count);
    PyObject *retval = CPyTagged_StealAsObject(self->__bad_word_count);
    return retval;
}

static int
SuperWeirdWordPlugin_set__bad_word_count(charset_normalizer___md___SuperWeirdWordPluginObject *self, PyObject *value, void *closure)
{
    if (value == NULL) {
        PyErr_SetString(PyExc_AttributeError,
            "'SuperWeirdWordPlugin' object attribute '_bad_word_count' cannot be deleted");
        return -1;
    }
    if (self->__bad_word_count != CPY_INT_TAG) {
        CPyTagged_DECREF(self->__bad_word_count);
    }
    CPyTagged tmp;
    if (likely(PyLong_Check(value)))
        tmp = CPyTagged_FromObject(value);
    else {
        CPy_TypeError("int", value); return -1;
    }
    CPyTagged_INCREF(tmp);
    self->__bad_word_count = tmp;
    return 0;
}

static PyObject *
SuperWeirdWordPlugin_get__foreign_long_count(charset_normalizer___md___SuperWeirdWordPluginObject *self, void *closure)
{
    if (unlikely(self->__foreign_long_count == CPY_INT_TAG)) {
        PyErr_SetString(PyExc_AttributeError,
            "attribute '_foreign_long_count' of 'SuperWeirdWordPlugin' undefined");
        return NULL;
    }
    CPyTagged_INCREF(self->__foreign_long_count);
    PyObject *retval = CPyTagged_StealAsObject(self->__foreign_long_count);
    return retval;
}

static int
SuperWeirdWordPlugin_set__foreign_long_count(charset_normalizer___md___SuperWeirdWordPluginObject *self, PyObject *value, void *closure)
{
    if (value == NULL) {
        PyErr_SetString(PyExc_AttributeError,
            "'SuperWeirdWordPlugin' object attribute '_foreign_long_count' cannot be deleted");
        return -1;
    }
    if (self->__foreign_long_count != CPY_INT_TAG) {
        CPyTagged_DECREF(self->__foreign_long_count);
    }
    CPyTagged tmp;
    if (likely(PyLong_Check(value)))
        tmp = CPyTagged_FromObject(value);
    else {
        CPy_TypeError("int", value); return -1;
    }
    CPyTagged_INCREF(tmp);
    self->__foreign_long_count = tmp;
    return 0;
}

static PyObject *
SuperWeirdWordPlugin_get__is_current_word_bad(charset_normalizer___md___SuperWeirdWordPluginObject *self, void *closure)
{
    PyObject *retval = self->__is_current_word_bad ? Py_True : Py_False;
    CPy_INCREF(retval);
    return retval;
}

static int
SuperWeirdWordPlugin_set__is_current_word_bad(charset_normalizer___md___SuperWeirdWordPluginObject *self, PyObject *value, void *closure)
{
    if (value == NULL) {
        PyErr_SetString(PyExc_AttributeError,
            "'SuperWeirdWordPlugin' object attribute '_is_current_word_bad' cannot be deleted");
        return -1;
    }
    char tmp;
    if (unlikely(!PyBool_Check(value))) {
        CPy_TypeError("bool", value); return -1;
    } else
        tmp = value == Py_True;
    self->__is_current_word_bad = tmp;
    return 0;
}

static PyObject *
SuperWeirdWordPlugin_get__foreign_long_watch(charset_normalizer___md___SuperWeirdWordPluginObject *self, void *closure)
{
    PyObject *retval = self->__foreign_long_watch ? Py_True : Py_False;
    CPy_INCREF(retval);
    return retval;
}

static int
SuperWeirdWordPlugin_set__foreign_long_watch(charset_normalizer___md___SuperWeirdWordPluginObject *self, PyObject *value, void *closure)
{
    if (value == NULL) {
        PyErr_SetString(PyExc_AttributeError,
            "'SuperWeirdWordPlugin' object attribute '_foreign_long_watch' cannot be deleted");
        return -1;
    }
    char tmp;
    if (unlikely(!PyBool_Check(value))) {
        CPy_TypeError("bool", value); return -1;
    } else
        tmp = value == Py_True;
    self->__foreign_long_watch = tmp;
    return 0;
}

static PyObject *
SuperWeirdWordPlugin_get__character_count(charset_normalizer___md___SuperWeirdWordPluginObject *self, void *closure)
{
    if (unlikely(self->__character_count == CPY_INT_TAG)) {
        PyErr_SetString(PyExc_AttributeError,
            "attribute '_character_count' of 'SuperWeirdWordPlugin' undefined");
        return NULL;
    }
    CPyTagged_INCREF(self->__character_count);
    PyObject *retval = CPyTagged_StealAsObject(self->__character_count);
    return retval;
}

static int
SuperWeirdWordPlugin_set__character_count(charset_normalizer___md___SuperWeirdWordPluginObject *self, PyObject *value, void *closure)
{
    if (value == NULL) {
        PyErr_SetString(PyExc_AttributeError,
            "'SuperWeirdWordPlugin' object attribute '_character_count' cannot be deleted");
        return -1;
    }
    if (self->__character_count != CPY_INT_TAG) {
        CPyTagged_DECREF(self->__character_count);
    }
    CPyTagged tmp;
    if (likely(PyLong_Check(value)))
        tmp = CPyTagged_FromObject(value);
    else {
        CPy_TypeError("int", value); return -1;
    }
    CPyTagged_INCREF(tmp);
    self->__character_count = tmp;
    return 0;
}

static PyObject *
SuperWeirdWordPlugin_get__bad_character_count(charset_normalizer___md___SuperWeirdWordPluginObject *self, void *closure)
{
    if (unlikely(self->__bad_character_count == CPY_INT_TAG)) {
        PyErr_SetString(PyExc_AttributeError,
            "attribute '_bad_character_count' of 'SuperWeirdWordPlugin' undefined");
        return NULL;
    }
    CPyTagged_INCREF(self->__bad_character_count);
    PyObject *retval = CPyTagged_StealAsObject(self->__bad_character_count);
    return retval;
}

static int
SuperWeirdWordPlugin_set__bad_character_count(charset_normalizer___md___SuperWeirdWordPluginObject *self, PyObject *value, void *closure)
{
    if (value == NULL) {
        PyErr_SetString(PyExc_AttributeError,
            "'SuperWeirdWordPlugin' object attribute '_bad_character_count' cannot be deleted");
        return -1;
    }
    if (self->__bad_character_count != CPY_INT_TAG) {
        CPyTagged_DECREF(self->__bad_character_count);
    }
    CPyTagged tmp;
    if (likely(PyLong_Check(value)))
        tmp = CPyTagged_FromObject(value);
    else {
        CPy_TypeError("int", value); return -1;
    }
    CPyTagged_INCREF(tmp);
    self->__bad_character_count = tmp;
    return 0;
}

static PyObject *
SuperWeirdWordPlugin_get__buffer(charset_normalizer___md___SuperWeirdWordPluginObject *self, void *closure)
{
    if (unlikely(self->__buffer == NULL)) {
        PyErr_SetString(PyExc_AttributeError,
            "attribute '_buffer' of 'SuperWeirdWordPlugin' undefined");
        return NULL;
    }
    CPy_INCREF(self->__buffer);
    PyObject *retval = self->__buffer;
    return retval;
}

static int
SuperWeirdWordPlugin_set__buffer(charset_normalizer___md___SuperWeirdWordPluginObject *self, PyObject *value, void *closure)
{
    if (value == NULL) {
        PyErr_SetString(PyExc_AttributeError,
            "'SuperWeirdWordPlugin' object attribute '_buffer' cannot be deleted");
        return -1;
    }
    if (self->__buffer != NULL) {
        CPy_DECREF(self->__buffer);
    }
    PyObject *tmp;
    if (likely(PyUnicode_Check(value)))
        tmp = value;
    else {
        CPy_TypeError("str", value); 
        tmp = NULL;
    }
    if (!tmp)
        return -1;
    CPy_INCREF(tmp);
    self->__buffer = tmp;
    return 0;
}

static PyObject *
SuperWeirdWordPlugin_get__buffer_accent_count(charset_normalizer___md___SuperWeirdWordPluginObject *self, void *closure)
{
    if (unlikely(self->__buffer_accent_count == CPY_INT_TAG)) {
        PyErr_SetString(PyExc_AttributeError,
            "attribute '_buffer_accent_count' of 'SuperWeirdWordPlugin' undefined");
        return NULL;
    }
    CPyTagged_INCREF(self->__buffer_accent_count);
    PyObject *retval = CPyTagged_StealAsObject(self->__buffer_accent_count);
    return retval;
}

static int
SuperWeirdWordPlugin_set__buffer_accent_count(charset_normalizer___md___SuperWeirdWordPluginObject *self, PyObject *value, void *closure)
{
    if (value == NULL) {
        PyErr_SetString(PyExc_AttributeError,
            "'SuperWeirdWordPlugin' object attribute '_buffer_accent_count' cannot be deleted");
        return -1;
    }
    if (self->__buffer_accent_count != CPY_INT_TAG) {
        CPyTagged_DECREF(self->__buffer_accent_count);
    }
    CPyTagged tmp;
    if (likely(PyLong_Check(value)))
        tmp = CPyTagged_FromObject(value);
    else {
        CPy_TypeError("int", value); return -1;
    }
    CPyTagged_INCREF(tmp);
    self->__buffer_accent_count = tmp;
    return 0;
}

static PyObject *
SuperWeirdWordPlugin_get__buffer_glyph_count(charset_normalizer___md___SuperWeirdWordPluginObject *self, void *closure)
{
    if (unlikely(self->__buffer_glyph_count == CPY_INT_TAG)) {
        PyErr_SetString(PyExc_AttributeError,
            "attribute '_buffer_glyph_count' of 'SuperWeirdWordPlugin' undefined");
        return NULL;
    }
    CPyTagged_INCREF(self->__buffer_glyph_count);
    PyObject *retval = CPyTagged_StealAsObject(self->__buffer_glyph_count);
    return retval;
}

static int
SuperWeirdWordPlugin_set__buffer_glyph_count(charset_normalizer___md___SuperWeirdWordPluginObject *self, PyObject *value, void *closure)
{
    if (value == NULL) {
        PyErr_SetString(PyExc_AttributeError,
            "'SuperWeirdWordPlugin' object attribute '_buffer_glyph_count' cannot be deleted");
        return -1;
    }
    if (self->__buffer_glyph_count != CPY_INT_TAG) {
        CPyTagged_DECREF(self->__buffer_glyph_count);
    }
    CPyTagged tmp;
    if (likely(PyLong_Check(value)))
        tmp = CPyTagged_FromObject(value);
    else {
        CPy_TypeError("int", value); return -1;
    }
    CPyTagged_INCREF(tmp);
    self->__buffer_glyph_count = tmp;
    return 0;
}

static PyObject *
SuperWeirdWordPlugin_get_ratio(charset_normalizer___md___SuperWeirdWordPluginObject *self, void *closure)
{
    double retval = CPyDef_SuperWeirdWordPlugin___ratio((PyObject *) self);
    if (retval == -113.0 && PyErr_Occurred()) {
        return NULL;
    }
    PyObject *retbox = PyFloat_FromDouble(retval);
    return retbox;
}

static int
CjkUncommonPlugin_init(PyObject *self, PyObject *args, PyObject *kwds)
{
    return 0;
}
PyObject *CPyDef___mypyc__CjkUncommonPlugin_setup(PyObject *cpy_r_type);
PyObject *CPyDef_CjkUncommonPlugin(void);

static PyObject *
CjkUncommonPlugin_new(PyTypeObject *type, PyObject *args, PyObject *kwds)
{
    if (type != CPyType_CjkUncommonPlugin) {
        PyErr_SetString(PyExc_TypeError, "interpreted classes cannot inherit from compiled");
        return NULL;
    }
    PyObject *self = CPyDef___mypyc__CjkUncommonPlugin_setup((PyObject*)type);
    if (self == NULL)
        return NULL;
    PyObject *ret = CPyPy_CjkUncommonPlugin_____init__(self, args, kwds);
    if (ret == NULL)
        return NULL;
    return self;
}

static int
CjkUncommonPlugin_traverse(charset_normalizer___md___CjkUncommonPluginObject *self, visitproc visit, void *arg)
{
    if (CPyTagged_CheckLong(self->__character_count)) {
        Py_VISIT(CPyTagged_LongAsObject(self->__character_count));
    }
    if (CPyTagged_CheckLong(self->__uncommon_count)) {
        Py_VISIT(CPyTagged_LongAsObject(self->__uncommon_count));
    }
    return 0;
}

static int
CjkUncommonPlugin_clear(charset_normalizer___md___CjkUncommonPluginObject *self)
{
    if (CPyTagged_CheckLong(self->__character_count)) {
        CPyTagged __tmp = self->__character_count;
        self->__character_count = CPY_INT_TAG;
        Py_XDECREF(CPyTagged_LongAsObject(__tmp));
    }
    if (CPyTagged_CheckLong(self->__uncommon_count)) {
        CPyTagged __tmp = self->__uncommon_count;
        self->__uncommon_count = CPY_INT_TAG;
        Py_XDECREF(CPyTagged_LongAsObject(__tmp));
    }
    return 0;
}

static void
CjkUncommonPlugin_dealloc(charset_normalizer___md___CjkUncommonPluginObject *self)
{
    PyObject_GC_UnTrack(self);
    CPy_TRASHCAN_BEGIN(self, CjkUncommonPlugin_dealloc)
    CjkUncommonPlugin_clear(self);
    Py_TYPE(self)->tp_free((PyObject *)self);
    CPy_TRASHCAN_END(self)
}

static CPyVTableItem CjkUncommonPlugin_vtable[9];
static bool
CPyDef_CjkUncommonPlugin_trait_vtable_setup(void)
{
    CPyVTableItem CjkUncommonPlugin_vtable_scratch[] = {
        (CPyVTableItem)CPyDef_CjkUncommonPlugin___eligible,
        (CPyVTableItem)CPyDef_CjkUncommonPlugin___feed,
        (CPyVTableItem)CPyDef_CjkUncommonPlugin___reset,
        (CPyVTableItem)CPyDef_CjkUncommonPlugin___ratio,
        (CPyVTableItem)CPyDef_CjkUncommonPlugin_____init__,
        (CPyVTableItem)CPyDef_CjkUncommonPlugin___eligible,
        (CPyVTableItem)CPyDef_CjkUncommonPlugin___feed,
        (CPyVTableItem)CPyDef_CjkUncommonPlugin___reset,
        (CPyVTableItem)CPyDef_CjkUncommonPlugin___ratio,
    };
    memcpy(CjkUncommonPlugin_vtable, CjkUncommonPlugin_vtable_scratch, sizeof(CjkUncommonPlugin_vtable));
    return 1;
}

static PyObject *
CjkUncommonPlugin_get__character_count(charset_normalizer___md___CjkUncommonPluginObject *self, void *closure);
static int
CjkUncommonPlugin_set__character_count(charset_normalizer___md___CjkUncommonPluginObject *self, PyObject *value, void *closure);
static PyObject *
CjkUncommonPlugin_get__uncommon_count(charset_normalizer___md___CjkUncommonPluginObject *self, void *closure);
static int
CjkUncommonPlugin_set__uncommon_count(charset_normalizer___md___CjkUncommonPluginObject *self, PyObject *value, void *closure);
static PyObject *
CjkUncommonPlugin_get_ratio(charset_normalizer___md___CjkUncommonPluginObject *self, void *closure);

static PyGetSetDef CjkUncommonPlugin_getseters[] = {
    {"_character_count",
     (getter)CjkUncommonPlugin_get__character_count, (setter)CjkUncommonPlugin_set__character_count,
     NULL, NULL},
    {"_uncommon_count",
     (getter)CjkUncommonPlugin_get__uncommon_count, (setter)CjkUncommonPlugin_set__uncommon_count,
     NULL, NULL},
    {"ratio",
     (getter)CjkUncommonPlugin_get_ratio,
    NULL, NULL, NULL},
    {NULL}  /* Sentinel */
};

static PyMethodDef CjkUncommonPlugin_methods[] = {
    {"__init__",
     (PyCFunction)CPyPy_CjkUncommonPlugin_____init__,
     METH_FASTCALL | METH_KEYWORDS, PyDoc_STR("__init__($self)\n--\n\n")},
    {"eligible",
     (PyCFunction)CPyPy_CjkUncommonPlugin___eligible,
     METH_FASTCALL | METH_KEYWORDS, PyDoc_STR("eligible($self, character)\n--\n\n")},
    {"feed",
     (PyCFunction)CPyPy_CjkUncommonPlugin___feed,
     METH_FASTCALL | METH_KEYWORDS, PyDoc_STR("feed($self, character)\n--\n\n")},
    {"reset",
     (PyCFunction)CPyPy_CjkUncommonPlugin___reset,
     METH_FASTCALL | METH_KEYWORDS, PyDoc_STR("reset($self)\n--\n\n")},
    {"__setstate__", (PyCFunction)CPyPickle_SetState, METH_O, NULL},
    {"__getstate__", (PyCFunction)CPyPickle_GetState, METH_NOARGS, NULL},
    {NULL}  /* Sentinel */
};

static PyTypeObject CPyType_CjkUncommonPlugin_template_ = {
    PyVarObject_HEAD_INIT(NULL, 0)
    .tp_name = "CjkUncommonPlugin",
    .tp_new = CjkUncommonPlugin_new,
    .tp_dealloc = (destructor)CjkUncommonPlugin_dealloc,
    .tp_traverse = (traverseproc)CjkUncommonPlugin_traverse,
    .tp_clear = (inquiry)CjkUncommonPlugin_clear,
    .tp_getset = CjkUncommonPlugin_getseters,
    .tp_methods = CjkUncommonPlugin_methods,
    .tp_init = CjkUncommonPlugin_init,
    .tp_basicsize = sizeof(charset_normalizer___md___CjkUncommonPluginObject),
    .tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_HEAPTYPE | Py_TPFLAGS_BASETYPE | Py_TPFLAGS_HAVE_GC,
    .tp_doc = PyDoc_STR("CjkUncommonPlugin()\n--\n\n"),
};
static PyTypeObject *CPyType_CjkUncommonPlugin_template = &CPyType_CjkUncommonPlugin_template_;

PyObject *CPyDef___mypyc__CjkUncommonPlugin_setup(PyObject *cpy_r_type)
{
    PyTypeObject *type = (PyTypeObject*)cpy_r_type;
    charset_normalizer___md___CjkUncommonPluginObject *self;
    self = (charset_normalizer___md___CjkUncommonPluginObject *)type->tp_alloc(type, 0);
    if (self == NULL)
        return NULL;
    self->vtable = CjkUncommonPlugin_vtable;
    self->__character_count = CPY_INT_TAG;
    self->__uncommon_count = CPY_INT_TAG;
    return (PyObject *)self;
}

PyObject *CPyDef_CjkUncommonPlugin(void)
{
    PyObject *self = CPyDef___mypyc__CjkUncommonPlugin_setup((PyObject *)CPyType_CjkUncommonPlugin);
    if (self == NULL)
        return NULL;
    char res = CPyDef_CjkUncommonPlugin_____init__(self);
    if (res == 2) {
        Py_DECREF(self);
        return NULL;
    }
    return self;
}

static PyObject *
CjkUncommonPlugin_get__character_count(charset_normalizer___md___CjkUncommonPluginObject *self, void *closure)
{
    if (unlikely(self->__character_count == CPY_INT_TAG)) {
        PyErr_SetString(PyExc_AttributeError,
            "attribute '_character_count' of 'CjkUncommonPlugin' undefined");
        return NULL;
    }
    CPyTagged_INCREF(self->__character_count);
    PyObject *retval = CPyTagged_StealAsObject(self->__character_count);
    return retval;
}

static int
CjkUncommonPlugin_set__character_count(charset_normalizer___md___CjkUncommonPluginObject *self, PyObject *value, void *closure)
{
    if (value == NULL) {
        PyErr_SetString(PyExc_AttributeError,
            "'CjkUncommonPlugin' object attribute '_character_count' cannot be deleted");
        return -1;
    }
    if (self->__character_count != CPY_INT_TAG) {
        CPyTagged_DECREF(self->__character_count);
    }
    CPyTagged tmp;
    if (likely(PyLong_Check(value)))
        tmp = CPyTagged_FromObject(value);
    else {
        CPy_TypeError("int", value); return -1;
    }
    CPyTagged_INCREF(tmp);
    self->__character_count = tmp;
    return 0;
}

static PyObject *
CjkUncommonPlugin_get__uncommon_count(charset_normalizer___md___CjkUncommonPluginObject *self, void *closure)
{
    if (unlikely(self->__uncommon_count == CPY_INT_TAG)) {
        PyErr_SetString(PyExc_AttributeError,
            "attribute '_uncommon_count' of 'CjkUncommonPlugin' undefined");
        return NULL;
    }
    CPyTagged_INCREF(self->__uncommon_count);
    PyObject *retval = CPyTagged_StealAsObject(self->__uncommon_count);
    return retval;
}

static int
CjkUncommonPlugin_set__uncommon_count(charset_normalizer___md___CjkUncommonPluginObject *self, PyObject *value, void *closure)
{
    if (value == NULL) {
        PyErr_SetString(PyExc_AttributeError,
            "'CjkUncommonPlugin' object attribute '_uncommon_count' cannot be deleted");
        return -1;
    }
    if (self->__uncommon_count != CPY_INT_TAG) {
        CPyTagged_DECREF(self->__uncommon_count);
    }
    CPyTagged tmp;
    if (likely(PyLong_Check(value)))
        tmp = CPyTagged_FromObject(value);
    else {
        CPy_TypeError("int", value); return -1;
    }
    CPyTagged_INCREF(tmp);
    self->__uncommon_count = tmp;
    return 0;
}

static PyObject *
CjkUncommonPlugin_get_ratio(charset_normalizer___md___CjkUncommonPluginObject *self, void *closure)
{
    double retval = CPyDef_CjkUncommonPlugin___ratio((PyObject *) self);
    if (retval == -113.0 && PyErr_Occurred()) {
        return NULL;
    }
    PyObject *retbox = PyFloat_FromDouble(retval);
    return retbox;
}

static int
ArchaicUpperLowerPlugin_init(PyObject *self, PyObject *args, PyObject *kwds)
{
    return 0;
}
PyObject *CPyDef___mypyc__ArchaicUpperLowerPlugin_setup(PyObject *cpy_r_type);
PyObject *CPyDef_ArchaicUpperLowerPlugin(void);

static PyObject *
ArchaicUpperLowerPlugin_new(PyTypeObject *type, PyObject *args, PyObject *kwds)
{
    if (type != CPyType_ArchaicUpperLowerPlugin) {
        PyErr_SetString(PyExc_TypeError, "interpreted classes cannot inherit from compiled");
        return NULL;
    }
    PyObject *self = CPyDef___mypyc__ArchaicUpperLowerPlugin_setup((PyObject*)type);
    if (self == NULL)
        return NULL;
    PyObject *ret = CPyPy_ArchaicUpperLowerPlugin_____init__(self, args, kwds);
    if (ret == NULL)
        return NULL;
    return self;
}

static int
ArchaicUpperLowerPlugin_traverse(charset_normalizer___md___ArchaicUpperLowerPluginObject *self, visitproc visit, void *arg)
{
    if (CPyTagged_CheckLong(self->__character_count_since_last_sep)) {
        Py_VISIT(CPyTagged_LongAsObject(self->__character_count_since_last_sep));
    }
    if (CPyTagged_CheckLong(self->__successive_upper_lower_count)) {
        Py_VISIT(CPyTagged_LongAsObject(self->__successive_upper_lower_count));
    }
    if (CPyTagged_CheckLong(self->__successive_upper_lower_count_final)) {
        Py_VISIT(CPyTagged_LongAsObject(self->__successive_upper_lower_count_final));
    }
    if (CPyTagged_CheckLong(self->__character_count)) {
        Py_VISIT(CPyTagged_LongAsObject(self->__character_count));
    }
    Py_VISIT(self->__last_alpha_seen);
    return 0;
}

static int
ArchaicUpperLowerPlugin_clear(charset_normalizer___md___ArchaicUpperLowerPluginObject *self)
{
    if (CPyTagged_CheckLong(self->__character_count_since_last_sep)) {
        CPyTagged __tmp = self->__character_count_since_last_sep;
        self->__character_count_since_last_sep = CPY_INT_TAG;
        Py_XDECREF(CPyTagged_LongAsObject(__tmp));
    }
    if (CPyTagged_CheckLong(self->__successive_upper_lower_count)) {
        CPyTagged __tmp = self->__successive_upper_lower_count;
        self->__successive_upper_lower_count = CPY_INT_TAG;
        Py_XDECREF(CPyTagged_LongAsObject(__tmp));
    }
    if (CPyTagged_CheckLong(self->__successive_upper_lower_count_final)) {
        CPyTagged __tmp = self->__successive_upper_lower_count_final;
        self->__successive_upper_lower_count_final = CPY_INT_TAG;
        Py_XDECREF(CPyTagged_LongAsObject(__tmp));
    }
    if (CPyTagged_CheckLong(self->__character_count)) {
        CPyTagged __tmp = self->__character_count;
        self->__character_count = CPY_INT_TAG;
        Py_XDECREF(CPyTagged_LongAsObject(__tmp));
    }
    Py_CLEAR(self->__last_alpha_seen);
    return 0;
}

static void
ArchaicUpperLowerPlugin_dealloc(charset_normalizer___md___ArchaicUpperLowerPluginObject *self)
{
    PyObject_GC_UnTrack(self);
    CPy_TRASHCAN_BEGIN(self, ArchaicUpperLowerPlugin_dealloc)
    ArchaicUpperLowerPlugin_clear(self);
    Py_TYPE(self)->tp_free((PyObject *)self);
    CPy_TRASHCAN_END(self)
}

static CPyVTableItem ArchaicUpperLowerPlugin_vtable[9];
static bool
CPyDef_ArchaicUpperLowerPlugin_trait_vtable_setup(void)
{
    CPyVTableItem ArchaicUpperLowerPlugin_vtable_scratch[] = {
        (CPyVTableItem)CPyDef_ArchaicUpperLowerPlugin___eligible,
        (CPyVTableItem)CPyDef_ArchaicUpperLowerPlugin___feed,
        (CPyVTableItem)CPyDef_ArchaicUpperLowerPlugin___reset,
        (CPyVTableItem)CPyDef_ArchaicUpperLowerPlugin___ratio,
        (CPyVTableItem)CPyDef_ArchaicUpperLowerPlugin_____init__,
        (CPyVTableItem)CPyDef_ArchaicUpperLowerPlugin___eligible,
        (CPyVTableItem)CPyDef_ArchaicUpperLowerPlugin___feed,
        (CPyVTableItem)CPyDef_ArchaicUpperLowerPlugin___reset,
        (CPyVTableItem)CPyDef_ArchaicUpperLowerPlugin___ratio,
    };
    memcpy(ArchaicUpperLowerPlugin_vtable, ArchaicUpperLowerPlugin_vtable_scratch, sizeof(ArchaicUpperLowerPlugin_vtable));
    return 1;
}

static PyObject *
ArchaicUpperLowerPlugin_get__buf(charset_normalizer___md___ArchaicUpperLowerPluginObject *self, void *closure);
static int
ArchaicUpperLowerPlugin_set__buf(charset_normalizer___md___ArchaicUpperLowerPluginObject *self, PyObject *value, void *closure);
static PyObject *
ArchaicUpperLowerPlugin_get__character_count_since_last_sep(charset_normalizer___md___ArchaicUpperLowerPluginObject *self, void *closure);
static int
ArchaicUpperLowerPlugin_set__character_count_since_last_sep(charset_normalizer___md___ArchaicUpperLowerPluginObject *self, PyObject *value, void *closure);
static PyObject *
ArchaicUpperLowerPlugin_get__successive_upper_lower_count(charset_normalizer___md___ArchaicUpperLowerPluginObject *self, void *closure);
static int
ArchaicUpperLowerPlugin_set__successive_upper_lower_count(charset_normalizer___md___ArchaicUpperLowerPluginObject *self, PyObject *value, void *closure);
static PyObject *
ArchaicUpperLowerPlugin_get__successive_upper_lower_count_final(charset_normalizer___md___ArchaicUpperLowerPluginObject *self, void *closure);
static int
ArchaicUpperLowerPlugin_set__successive_upper_lower_count_final(charset_normalizer___md___ArchaicUpperLowerPluginObject *self, PyObject *value, void *closure);
static PyObject *
ArchaicUpperLowerPlugin_get__character_count(charset_normalizer___md___ArchaicUpperLowerPluginObject *self, void *closure);
static int
ArchaicUpperLowerPlugin_set__character_count(charset_normalizer___md___ArchaicUpperLowerPluginObject *self, PyObject *value, void *closure);
static PyObject *
ArchaicUpperLowerPlugin_get__last_alpha_seen(charset_normalizer___md___ArchaicUpperLowerPluginObject *self, void *closure);
static int
ArchaicUpperLowerPlugin_set__last_alpha_seen(charset_normalizer___md___ArchaicUpperLowerPluginObject *self, PyObject *value, void *closure);
static PyObject *
ArchaicUpperLowerPlugin_get__current_ascii_only(charset_normalizer___md___ArchaicUpperLowerPluginObject *self, void *closure);
static int
ArchaicUpperLowerPlugin_set__current_ascii_only(charset_normalizer___md___ArchaicUpperLowerPluginObject *self, PyObject *value, void *closure);
static PyObject *
ArchaicUpperLowerPlugin_get_ratio(charset_normalizer___md___ArchaicUpperLowerPluginObject *self, void *closure);

static PyGetSetDef ArchaicUpperLowerPlugin_getseters[] = {
    {"_buf",
     (getter)ArchaicUpperLowerPlugin_get__buf, (setter)ArchaicUpperLowerPlugin_set__buf,
     NULL, NULL},
    {"_character_count_since_last_sep",
     (getter)ArchaicUpperLowerPlugin_get__character_count_since_last_sep, (setter)ArchaicUpperLowerPlugin_set__character_count_since_last_sep,
     NULL, NULL},
    {"_successive_upper_lower_count",
     (getter)ArchaicUpperLowerPlugin_get__successive_upper_lower_count, (setter)ArchaicUpperLowerPlugin_set__successive_upper_lower_count,
     NULL, NULL},
    {"_successive_upper_lower_count_final",
     (getter)ArchaicUpperLowerPlugin_get__successive_upper_lower_count_final, (setter)ArchaicUpperLowerPlugin_set__successive_upper_lower_count_final,
     NULL, NULL},
    {"_character_count",
     (getter)ArchaicUpperLowerPlugin_get__character_count, (setter)ArchaicUpperLowerPlugin_set__character_count,
     NULL, NULL},
    {"_last_alpha_seen",
     (getter)ArchaicUpperLowerPlugin_get__last_alpha_seen, (setter)ArchaicUpperLowerPlugin_set__last_alpha_seen,
     NULL, NULL},
    {"_current_ascii_only",
     (getter)ArchaicUpperLowerPlugin_get__current_ascii_only, (setter)ArchaicUpperLowerPlugin_set__current_ascii_only,
     NULL, NULL},
    {"ratio",
     (getter)ArchaicUpperLowerPlugin_get_ratio,
    NULL, NULL, NULL},
    {NULL}  /* Sentinel */
};

static PyMethodDef ArchaicUpperLowerPlugin_methods[] = {
    {"__init__",
     (PyCFunction)CPyPy_ArchaicUpperLowerPlugin_____init__,
     METH_FASTCALL | METH_KEYWORDS, PyDoc_STR("__init__($self)\n--\n\n")},
    {"eligible",
     (PyCFunction)CPyPy_ArchaicUpperLowerPlugin___eligible,
     METH_FASTCALL | METH_KEYWORDS, PyDoc_STR("eligible($self, character)\n--\n\n")},
    {"feed",
     (PyCFunction)CPyPy_ArchaicUpperLowerPlugin___feed,
     METH_FASTCALL | METH_KEYWORDS, PyDoc_STR("feed($self, character)\n--\n\n")},
    {"reset",
     (PyCFunction)CPyPy_ArchaicUpperLowerPlugin___reset,
     METH_FASTCALL | METH_KEYWORDS, PyDoc_STR("reset($self)\n--\n\n")},
    {"__setstate__", (PyCFunction)CPyPickle_SetState, METH_O, NULL},
    {"__getstate__", (PyCFunction)CPyPickle_GetState, METH_NOARGS, NULL},
    {NULL}  /* Sentinel */
};

static PyTypeObject CPyType_ArchaicUpperLowerPlugin_template_ = {
    PyVarObject_HEAD_INIT(NULL, 0)
    .tp_name = "ArchaicUpperLowerPlugin",
    .tp_new = ArchaicUpperLowerPlugin_new,
    .tp_dealloc = (destructor)ArchaicUpperLowerPlugin_dealloc,
    .tp_traverse = (traverseproc)ArchaicUpperLowerPlugin_traverse,
    .tp_clear = (inquiry)ArchaicUpperLowerPlugin_clear,
    .tp_getset = ArchaicUpperLowerPlugin_getseters,
    .tp_methods = ArchaicUpperLowerPlugin_methods,
    .tp_init = ArchaicUpperLowerPlugin_init,
    .tp_basicsize = sizeof(charset_normalizer___md___ArchaicUpperLowerPluginObject),
    .tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_HEAPTYPE | Py_TPFLAGS_BASETYPE | Py_TPFLAGS_HAVE_GC,
    .tp_doc = PyDoc_STR("ArchaicUpperLowerPlugin()\n--\n\n"),
};
static PyTypeObject *CPyType_ArchaicUpperLowerPlugin_template = &CPyType_ArchaicUpperLowerPlugin_template_;

PyObject *CPyDef___mypyc__ArchaicUpperLowerPlugin_setup(PyObject *cpy_r_type)
{
    PyTypeObject *type = (PyTypeObject*)cpy_r_type;
    charset_normalizer___md___ArchaicUpperLowerPluginObject *self;
    self = (charset_normalizer___md___ArchaicUpperLowerPluginObject *)type->tp_alloc(type, 0);
    if (self == NULL)
        return NULL;
    self->vtable = ArchaicUpperLowerPlugin_vtable;
    self->__buf = 2;
    self->__character_count_since_last_sep = CPY_INT_TAG;
    self->__successive_upper_lower_count = CPY_INT_TAG;
    self->__successive_upper_lower_count_final = CPY_INT_TAG;
    self->__character_count = CPY_INT_TAG;
    self->__current_ascii_only = 2;
    return (PyObject *)self;
}

PyObject *CPyDef_ArchaicUpperLowerPlugin(void)
{
    PyObject *self = CPyDef___mypyc__ArchaicUpperLowerPlugin_setup((PyObject *)CPyType_ArchaicUpperLowerPlugin);
    if (self == NULL)
        return NULL;
    char res = CPyDef_ArchaicUpperLowerPlugin_____init__(self);
    if (res == 2) {
        Py_DECREF(self);
        return NULL;
    }
    return self;
}

static PyObject *
ArchaicUpperLowerPlugin_get__buf(charset_normalizer___md___ArchaicUpperLowerPluginObject *self, void *closure)
{
    PyObject *retval = self->__buf ? Py_True : Py_False;
    CPy_INCREF(retval);
    return retval;
}

static int
ArchaicUpperLowerPlugin_set__buf(charset_normalizer___md___ArchaicUpperLowerPluginObject *self, PyObject *value, void *closure)
{
    if (value == NULL) {
        PyErr_SetString(PyExc_AttributeError,
            "'ArchaicUpperLowerPlugin' object attribute '_buf' cannot be deleted");
        return -1;
    }
    char tmp;
    if (unlikely(!PyBool_Check(value))) {
        CPy_TypeError("bool", value); return -1;
    } else
        tmp = value == Py_True;
    self->__buf = tmp;
    return 0;
}

static PyObject *
ArchaicUpperLowerPlugin_get__character_count_since_last_sep(charset_normalizer___md___ArchaicUpperLowerPluginObject *self, void *closure)
{
    if (unlikely(self->__character_count_since_last_sep == CPY_INT_TAG)) {
        PyErr_SetString(PyExc_AttributeError,
            "attribute '_character_count_since_last_sep' of 'ArchaicUpperLowerPlugin' undefined");
        return NULL;
    }
    CPyTagged_INCREF(self->__character_count_since_last_sep);
    PyObject *retval = CPyTagged_StealAsObject(self->__character_count_since_last_sep);
    return retval;
}

static int
ArchaicUpperLowerPlugin_set__character_count_since_last_sep(charset_normalizer___md___ArchaicUpperLowerPluginObject *self, PyObject *value, void *closure)
{
    if (value == NULL) {
        PyErr_SetString(PyExc_AttributeError,
            "'ArchaicUpperLowerPlugin' object attribute '_character_count_since_last_sep' cannot be deleted");
        return -1;
    }
    if (self->__character_count_since_last_sep != CPY_INT_TAG) {
        CPyTagged_DECREF(self->__character_count_since_last_sep);
    }
    CPyTagged tmp;
    if (likely(PyLong_Check(value)))
        tmp = CPyTagged_FromObject(value);
    else {
        CPy_TypeError("int", value); return -1;
    }
    CPyTagged_INCREF(tmp);
    self->__character_count_since_last_sep = tmp;
    return 0;
}

static PyObject *
ArchaicUpperLowerPlugin_get__successive_upper_lower_count(charset_normalizer___md___ArchaicUpperLowerPluginObject *self, void *closure)
{
    if (unlikely(self->__successive_upper_lower_count == CPY_INT_TAG)) {
        PyErr_SetString(PyExc_AttributeError,
            "attribute '_successive_upper_lower_count' of 'ArchaicUpperLowerPlugin' undefined");
        return NULL;
    }
    CPyTagged_INCREF(self->__successive_upper_lower_count);
    PyObject *retval = CPyTagged_StealAsObject(self->__successive_upper_lower_count);
    return retval;
}

static int
ArchaicUpperLowerPlugin_set__successive_upper_lower_count(charset_normalizer___md___ArchaicUpperLowerPluginObject *self, PyObject *value, void *closure)
{
    if (value == NULL) {
        PyErr_SetString(PyExc_AttributeError,
            "'ArchaicUpperLowerPlugin' object attribute '_successive_upper_lower_count' cannot be deleted");
        return -1;
    }
    if (self->__successive_upper_lower_count != CPY_INT_TAG) {
        CPyTagged_DECREF(self->__successive_upper_lower_count);
    }
    CPyTagged tmp;
    if (likely(PyLong_Check(value)))
        tmp = CPyTagged_FromObject(value);
    else {
        CPy_TypeError("int", value); return -1;
    }
    CPyTagged_INCREF(tmp);
    self->__successive_upper_lower_count = tmp;
    return 0;
}

static PyObject *
ArchaicUpperLowerPlugin_get__successive_upper_lower_count_final(charset_normalizer___md___ArchaicUpperLowerPluginObject *self, void *closure)
{
    if (unlikely(self->__successive_upper_lower_count_final == CPY_INT_TAG)) {
        PyErr_SetString(PyExc_AttributeError,
            "attribute '_successive_upper_lower_count_final' of 'ArchaicUpperLowerPlugin' undefined");
        return NULL;
    }
    CPyTagged_INCREF(self->__successive_upper_lower_count_final);
    PyObject *retval = CPyTagged_StealAsObject(self->__successive_upper_lower_count_final);
    return retval;
}

static int
ArchaicUpperLowerPlugin_set__successive_upper_lower_count_final(charset_normalizer___md___ArchaicUpperLowerPluginObject *self, PyObject *value, void *closure)
{
    if (value == NULL) {
        PyErr_SetString(PyExc_AttributeError,
            "'ArchaicUpperLowerPlugin' object attribute '_successive_upper_lower_count_final' cannot be deleted");
        return -1;
    }
    if (self->__successive_upper_lower_count_final != CPY_INT_TAG) {
        CPyTagged_DECREF(self->__successive_upper_lower_count_final);
    }
    CPyTagged tmp;
    if (likely(PyLong_Check(value)))
        tmp = CPyTagged_FromObject(value);
    else {
        CPy_TypeError("int", value); return -1;
    }
    CPyTagged_INCREF(tmp);
    self->__successive_upper_lower_count_final = tmp;
    return 0;
}

static PyObject *
ArchaicUpperLowerPlugin_get__character_count(charset_normalizer___md___ArchaicUpperLowerPluginObject *self, void *closure)
{
    if (unlikely(self->__character_count == CPY_INT_TAG)) {
        PyErr_SetString(PyExc_AttributeError,
            "attribute '_character_count' of 'ArchaicUpperLowerPlugin' undefined");
        return NULL;
    }
    CPyTagged_INCREF(self->__character_count);
    PyObject *retval = CPyTagged_StealAsObject(self->__character_count);
    return retval;
}

static int
ArchaicUpperLowerPlugin_set__character_count(charset_normalizer___md___ArchaicUpperLowerPluginObject *self, PyObject *value, void *closure)
{
    if (value == NULL) {
        PyErr_SetString(PyExc_AttributeError,
            "'ArchaicUpperLowerPlugin' object attribute '_character_count' cannot be deleted");
        return -1;
    }
    if (self->__character_count != CPY_INT_TAG) {
        CPyTagged_DECREF(self->__character_count);
    }
    CPyTagged tmp;
    if (likely(PyLong_Check(value)))
        tmp = CPyTagged_FromObject(value);
    else {
        CPy_TypeError("int", value); return -1;
    }
    CPyTagged_INCREF(tmp);
    self->__character_count = tmp;
    return 0;
}

static PyObject *
ArchaicUpperLowerPlugin_get__last_alpha_seen(charset_normalizer___md___ArchaicUpperLowerPluginObject *self, void *closure)
{
    if (unlikely(self->__last_alpha_seen == NULL)) {
        PyErr_SetString(PyExc_AttributeError,
            "attribute '_last_alpha_seen' of 'ArchaicUpperLowerPlugin' undefined");
        return NULL;
    }
    CPy_INCREF(self->__last_alpha_seen);
    PyObject *retval = self->__last_alpha_seen;
    return retval;
}

static int
ArchaicUpperLowerPlugin_set__last_alpha_seen(charset_normalizer___md___ArchaicUpperLowerPluginObject *self, PyObject *value, void *closure)
{
    if (value == NULL) {
        PyErr_SetString(PyExc_AttributeError,
            "'ArchaicUpperLowerPlugin' object attribute '_last_alpha_seen' cannot be deleted");
        return -1;
    }
    if (self->__last_alpha_seen != NULL) {
        CPy_DECREF(self->__last_alpha_seen);
    }
    PyObject *tmp;
    if (PyUnicode_Check(value))
        tmp = value;
    else {
        tmp = NULL;
    }
    if (tmp != NULL) goto __LL4;
    if (value == Py_None)
        tmp = value;
    else {
        tmp = NULL;
    }
    if (tmp != NULL) goto __LL4;
    CPy_TypeError("str or None", value); 
    tmp = NULL;
__LL4: ;
    if (!tmp)
        return -1;
    CPy_INCREF(tmp);
    self->__last_alpha_seen = tmp;
    return 0;
}

static PyObject *
ArchaicUpperLowerPlugin_get__current_ascii_only(charset_normalizer___md___ArchaicUpperLowerPluginObject *self, void *closure)
{
    PyObject *retval = self->__current_ascii_only ? Py_True : Py_False;
    CPy_INCREF(retval);
    return retval;
}

static int
ArchaicUpperLowerPlugin_set__current_ascii_only(charset_normalizer___md___ArchaicUpperLowerPluginObject *self, PyObject *value, void *closure)
{
    if (value == NULL) {
        PyErr_SetString(PyExc_AttributeError,
            "'ArchaicUpperLowerPlugin' object attribute '_current_ascii_only' cannot be deleted");
        return -1;
    }
    char tmp;
    if (unlikely(!PyBool_Check(value))) {
        CPy_TypeError("bool", value); return -1;
    } else
        tmp = value == Py_True;
    self->__current_ascii_only = tmp;
    return 0;
}

static PyObject *
ArchaicUpperLowerPlugin_get_ratio(charset_normalizer___md___ArchaicUpperLowerPluginObject *self, void *closure)
{
    double retval = CPyDef_ArchaicUpperLowerPlugin___ratio((PyObject *) self);
    if (retval == -113.0 && PyErr_Occurred()) {
        return NULL;
    }
    PyObject *retbox = PyFloat_FromDouble(retval);
    return retbox;
}

static int
ArabicIsolatedFormPlugin_init(PyObject *self, PyObject *args, PyObject *kwds)
{
    return 0;
}
PyObject *CPyDef___mypyc__ArabicIsolatedFormPlugin_setup(PyObject *cpy_r_type);
PyObject *CPyDef_ArabicIsolatedFormPlugin(void);

static PyObject *
ArabicIsolatedFormPlugin_new(PyTypeObject *type, PyObject *args, PyObject *kwds)
{
    if (type != CPyType_ArabicIsolatedFormPlugin) {
        PyErr_SetString(PyExc_TypeError, "interpreted classes cannot inherit from compiled");
        return NULL;
    }
    PyObject *self = CPyDef___mypyc__ArabicIsolatedFormPlugin_setup((PyObject*)type);
    if (self == NULL)
        return NULL;
    PyObject *ret = CPyPy_ArabicIsolatedFormPlugin_____init__(self, args, kwds);
    if (ret == NULL)
        return NULL;
    return self;
}

static int
ArabicIsolatedFormPlugin_traverse(charset_normalizer___md___ArabicIsolatedFormPluginObject *self, visitproc visit, void *arg)
{
    if (CPyTagged_CheckLong(self->__character_count)) {
        Py_VISIT(CPyTagged_LongAsObject(self->__character_count));
    }
    if (CPyTagged_CheckLong(self->__isolated_form_count)) {
        Py_VISIT(CPyTagged_LongAsObject(self->__isolated_form_count));
    }
    return 0;
}

static int
ArabicIsolatedFormPlugin_clear(charset_normalizer___md___ArabicIsolatedFormPluginObject *self)
{
    if (CPyTagged_CheckLong(self->__character_count)) {
        CPyTagged __tmp = self->__character_count;
        self->__character_count = CPY_INT_TAG;
        Py_XDECREF(CPyTagged_LongAsObject(__tmp));
    }
    if (CPyTagged_CheckLong(self->__isolated_form_count)) {
        CPyTagged __tmp = self->__isolated_form_count;
        self->__isolated_form_count = CPY_INT_TAG;
        Py_XDECREF(CPyTagged_LongAsObject(__tmp));
    }
    return 0;
}

static void
ArabicIsolatedFormPlugin_dealloc(charset_normalizer___md___ArabicIsolatedFormPluginObject *self)
{
    PyObject_GC_UnTrack(self);
    CPy_TRASHCAN_BEGIN(self, ArabicIsolatedFormPlugin_dealloc)
    ArabicIsolatedFormPlugin_clear(self);
    Py_TYPE(self)->tp_free((PyObject *)self);
    CPy_TRASHCAN_END(self)
}

static CPyVTableItem ArabicIsolatedFormPlugin_vtable[9];
static bool
CPyDef_ArabicIsolatedFormPlugin_trait_vtable_setup(void)
{
    CPyVTableItem ArabicIsolatedFormPlugin_vtable_scratch[] = {
        (CPyVTableItem)CPyDef_ArabicIsolatedFormPlugin___eligible,
        (CPyVTableItem)CPyDef_ArabicIsolatedFormPlugin___feed,
        (CPyVTableItem)CPyDef_ArabicIsolatedFormPlugin___reset,
        (CPyVTableItem)CPyDef_ArabicIsolatedFormPlugin___ratio,
        (CPyVTableItem)CPyDef_ArabicIsolatedFormPlugin_____init__,
        (CPyVTableItem)CPyDef_ArabicIsolatedFormPlugin___reset,
        (CPyVTableItem)CPyDef_ArabicIsolatedFormPlugin___eligible,
        (CPyVTableItem)CPyDef_ArabicIsolatedFormPlugin___feed,
        (CPyVTableItem)CPyDef_ArabicIsolatedFormPlugin___ratio,
    };
    memcpy(ArabicIsolatedFormPlugin_vtable, ArabicIsolatedFormPlugin_vtable_scratch, sizeof(ArabicIsolatedFormPlugin_vtable));
    return 1;
}

static PyObject *
ArabicIsolatedFormPlugin_get__character_count(charset_normalizer___md___ArabicIsolatedFormPluginObject *self, void *closure);
static int
ArabicIsolatedFormPlugin_set__character_count(charset_normalizer___md___ArabicIsolatedFormPluginObject *self, PyObject *value, void *closure);
static PyObject *
ArabicIsolatedFormPlugin_get__isolated_form_count(charset_normalizer___md___ArabicIsolatedFormPluginObject *self, void *closure);
static int
ArabicIsolatedFormPlugin_set__isolated_form_count(charset_normalizer___md___ArabicIsolatedFormPluginObject *self, PyObject *value, void *closure);
static PyObject *
ArabicIsolatedFormPlugin_get_ratio(charset_normalizer___md___ArabicIsolatedFormPluginObject *self, void *closure);

static PyGetSetDef ArabicIsolatedFormPlugin_getseters[] = {
    {"_character_count",
     (getter)ArabicIsolatedFormPlugin_get__character_count, (setter)ArabicIsolatedFormPlugin_set__character_count,
     NULL, NULL},
    {"_isolated_form_count",
     (getter)ArabicIsolatedFormPlugin_get__isolated_form_count, (setter)ArabicIsolatedFormPlugin_set__isolated_form_count,
     NULL, NULL},
    {"ratio",
     (getter)ArabicIsolatedFormPlugin_get_ratio,
    NULL, NULL, NULL},
    {NULL}  /* Sentinel */
};

static PyMethodDef ArabicIsolatedFormPlugin_methods[] = {
    {"__init__",
     (PyCFunction)CPyPy_ArabicIsolatedFormPlugin_____init__,
     METH_FASTCALL | METH_KEYWORDS, PyDoc_STR("__init__($self)\n--\n\n")},
    {"reset",
     (PyCFunction)CPyPy_ArabicIsolatedFormPlugin___reset,
     METH_FASTCALL | METH_KEYWORDS, PyDoc_STR("reset($self)\n--\n\n")},
    {"eligible",
     (PyCFunction)CPyPy_ArabicIsolatedFormPlugin___eligible,
     METH_FASTCALL | METH_KEYWORDS, PyDoc_STR("eligible($self, character)\n--\n\n")},
    {"feed",
     (PyCFunction)CPyPy_ArabicIsolatedFormPlugin___feed,
     METH_FASTCALL | METH_KEYWORDS, PyDoc_STR("feed($self, character)\n--\n\n")},
    {"__setstate__", (PyCFunction)CPyPickle_SetState, METH_O, NULL},
    {"__getstate__", (PyCFunction)CPyPickle_GetState, METH_NOARGS, NULL},
    {NULL}  /* Sentinel */
};

static PyTypeObject CPyType_ArabicIsolatedFormPlugin_template_ = {
    PyVarObject_HEAD_INIT(NULL, 0)
    .tp_name = "ArabicIsolatedFormPlugin",
    .tp_new = ArabicIsolatedFormPlugin_new,
    .tp_dealloc = (destructor)ArabicIsolatedFormPlugin_dealloc,
    .tp_traverse = (traverseproc)ArabicIsolatedFormPlugin_traverse,
    .tp_clear = (inquiry)ArabicIsolatedFormPlugin_clear,
    .tp_getset = ArabicIsolatedFormPlugin_getseters,
    .tp_methods = ArabicIsolatedFormPlugin_methods,
    .tp_init = ArabicIsolatedFormPlugin_init,
    .tp_basicsize = sizeof(charset_normalizer___md___ArabicIsolatedFormPluginObject),
    .tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_HEAPTYPE | Py_TPFLAGS_BASETYPE | Py_TPFLAGS_HAVE_GC,
    .tp_doc = PyDoc_STR("ArabicIsolatedFormPlugin()\n--\n\n"),
};
static PyTypeObject *CPyType_ArabicIsolatedFormPlugin_template = &CPyType_ArabicIsolatedFormPlugin_template_;

PyObject *CPyDef___mypyc__ArabicIsolatedFormPlugin_setup(PyObject *cpy_r_type)
{
    PyTypeObject *type = (PyTypeObject*)cpy_r_type;
    charset_normalizer___md___ArabicIsolatedFormPluginObject *self;
    self = (charset_normalizer___md___ArabicIsolatedFormPluginObject *)type->tp_alloc(type, 0);
    if (self == NULL)
        return NULL;
    self->vtable = ArabicIsolatedFormPlugin_vtable;
    self->__character_count = CPY_INT_TAG;
    self->__isolated_form_count = CPY_INT_TAG;
    return (PyObject *)self;
}

PyObject *CPyDef_ArabicIsolatedFormPlugin(void)
{
    PyObject *self = CPyDef___mypyc__ArabicIsolatedFormPlugin_setup((PyObject *)CPyType_ArabicIsolatedFormPlugin);
    if (self == NULL)
        return NULL;
    char res = CPyDef_ArabicIsolatedFormPlugin_____init__(self);
    if (res == 2) {
        Py_DECREF(self);
        return NULL;
    }
    return self;
}

static PyObject *
ArabicIsolatedFormPlugin_get__character_count(charset_normalizer___md___ArabicIsolatedFormPluginObject *self, void *closure)
{
    if (unlikely(self->__character_count == CPY_INT_TAG)) {
        PyErr_SetString(PyExc_AttributeError,
            "attribute '_character_count' of 'ArabicIsolatedFormPlugin' undefined");
        return NULL;
    }
    CPyTagged_INCREF(self->__character_count);
    PyObject *retval = CPyTagged_StealAsObject(self->__character_count);
    return retval;
}

static int
ArabicIsolatedFormPlugin_set__character_count(charset_normalizer___md___ArabicIsolatedFormPluginObject *self, PyObject *value, void *closure)
{
    if (value == NULL) {
        PyErr_SetString(PyExc_AttributeError,
            "'ArabicIsolatedFormPlugin' object attribute '_character_count' cannot be deleted");
        return -1;
    }
    if (self->__character_count != CPY_INT_TAG) {
        CPyTagged_DECREF(self->__character_count);
    }
    CPyTagged tmp;
    if (likely(PyLong_Check(value)))
        tmp = CPyTagged_FromObject(value);
    else {
        CPy_TypeError("int", value); return -1;
    }
    CPyTagged_INCREF(tmp);
    self->__character_count = tmp;
    return 0;
}

static PyObject *
ArabicIsolatedFormPlugin_get__isolated_form_count(charset_normalizer___md___ArabicIsolatedFormPluginObject *self, void *closure)
{
    if (unlikely(self->__isolated_form_count == CPY_INT_TAG)) {
        PyErr_SetString(PyExc_AttributeError,
            "attribute '_isolated_form_count' of 'ArabicIsolatedFormPlugin' undefined");
        return NULL;
    }
    CPyTagged_INCREF(self->__isolated_form_count);
    PyObject *retval = CPyTagged_StealAsObject(self->__isolated_form_count);
    return retval;
}

static int
ArabicIsolatedFormPlugin_set__isolated_form_count(charset_normalizer___md___ArabicIsolatedFormPluginObject *self, PyObject *value, void *closure)
{
    if (value == NULL) {
        PyErr_SetString(PyExc_AttributeError,
            "'ArabicIsolatedFormPlugin' object attribute '_isolated_form_count' cannot be deleted");
        return -1;
    }
    if (self->__isolated_form_count != CPY_INT_TAG) {
        CPyTagged_DECREF(self->__isolated_form_count);
    }
    CPyTagged tmp;
    if (likely(PyLong_Check(value)))
        tmp = CPyTagged_FromObject(value);
    else {
        CPy_TypeError("int", value); return -1;
    }
    CPyTagged_INCREF(tmp);
    self->__isolated_form_count = tmp;
    return 0;
}

static PyObject *
ArabicIsolatedFormPlugin_get_ratio(charset_normalizer___md___ArabicIsolatedFormPluginObject *self, void *closure)
{
    double retval = CPyDef_ArabicIsolatedFormPlugin___ratio((PyObject *) self);
    if (retval == -113.0 && PyErr_Occurred()) {
        return NULL;
    }
    PyObject *retbox = PyFloat_FromDouble(retval);
    return retbox;
}
static PyMethodDef module_methods[] = {
    {"is_suspiciously_successive_range", (PyCFunction)CPyPy_is_suspiciously_successive_range, METH_FASTCALL | METH_KEYWORDS, PyDoc_STR("is_suspiciously_successive_range(unicode_range_a, unicode_range_b)\n--\n\n") /* docstring */},
    {"mess_ratio", (PyCFunction)CPyPy_mess_ratio, METH_FASTCALL | METH_KEYWORDS, PyDoc_STR("mess_ratio(decoded_sequence, maximum_threshold=0.2, debug=False, /)\n--\n\n") /* docstring */},
    {NULL, NULL, 0, NULL}
};

int CPyExec_charset_normalizer___md(PyObject *module)
{
    PyObject* modname = NULL;
    modname = PyObject_GetAttrString((PyObject *)CPyModule_charset_normalizer___md__internal, "__name__");
    CPyStatic_globals = PyModule_GetDict(CPyModule_charset_normalizer___md__internal);
    if (unlikely(CPyStatic_globals == NULL))
        goto fail;
    if (CPyGlobalsInit() < 0)
        goto fail;
    char result = CPyDef___top_level__();
    if (result == 2)
        goto fail;
    Py_DECREF(modname);
    return 0;
    fail:
    Py_CLEAR(CPyModule_charset_normalizer___md__internal);
    Py_CLEAR(modname);
    Py_CLEAR(CPyType_MessDetectorPlugin);
    Py_CLEAR(CPyType_TooManySymbolOrPunctuationPlugin);
    Py_CLEAR(CPyType_TooManyAccentuatedPlugin);
    Py_CLEAR(CPyType_UnprintablePlugin);
    Py_CLEAR(CPyType_SuspiciousDuplicateAccentPlugin);
    Py_CLEAR(CPyType_SuspiciousRange);
    Py_CLEAR(CPyType_SuperWeirdWordPlugin);
    Py_CLEAR(CPyType_CjkUncommonPlugin);
    Py_CLEAR(CPyType_ArchaicUpperLowerPlugin);
    Py_CLEAR(CPyType_ArabicIsolatedFormPlugin);
    return -1;
}
static struct PyModuleDef module = {
    PyModuleDef_HEAD_INIT,
    "charset_normalizer.md",
    NULL, /* docstring */
    0,       /* size of per-interpreter state of the module */
    module_methods,
    NULL,
};

PyObject *CPyInit_charset_normalizer___md(void)
{
    if (CPyModule_charset_normalizer___md__internal) {
        Py_INCREF(CPyModule_charset_normalizer___md__internal);
        return CPyModule_charset_normalizer___md__internal;
    }
    CPyModule_charset_normalizer___md__internal = PyModule_Create(&module);
    if (unlikely(CPyModule_charset_normalizer___md__internal == NULL))
        goto fail;
    if (CPyExec_charset_normalizer___md(CPyModule_charset_normalizer___md__internal) != 0)
        goto fail;
    return CPyModule_charset_normalizer___md__internal;
    fail:
    return NULL;
}

char CPyDef_MessDetectorPlugin___eligible(PyObject *cpy_r_self, PyObject *cpy_r_character) {
    PyObject *cpy_r_r0;
    PyObject *cpy_r_r1;
    PyObject *cpy_r_r2;
    char cpy_r_r3;
    cpy_r_r0 = CPyModule_builtins;
    cpy_r_r1 = CPyStatics[3]; /* 'NotImplementedError' */
    cpy_r_r2 = CPyObject_GetAttr(cpy_r_r0, cpy_r_r1);
    if (unlikely(cpy_r_r2 == NULL)) {
        CPy_AddTraceback("src/charset_normalizer/md.py", "eligible", 43, CPyStatic_globals);
        goto CPyL3;
    }
    CPy_Raise(cpy_r_r2);
    CPy_DECREF(cpy_r_r2);
    if (unlikely(!0)) {
        CPy_AddTraceback("src/charset_normalizer/md.py", "eligible", 43, CPyStatic_globals);
        goto CPyL3;
    }
    CPy_Unreachable();
CPyL3: ;
    cpy_r_r3 = 2;
    return cpy_r_r3;
}

PyObject *CPyPy_MessDetectorPlugin___eligible(PyObject *self, PyObject *const *args, size_t nargs, PyObject *kwnames) {
    PyObject *obj_self = self;
    static const char * const kwlist[] = {"character", 0};
    static CPyArg_Parser parser = {"O:eligible", kwlist, 0};
    PyObject *obj_character;
    if (!CPyArg_ParseStackAndKeywordsOneArg(args, nargs, kwnames, &parser, &obj_character)) {
        return NULL;
    }
    PyObject *arg_self;
    if (likely(PyObject_TypeCheck(obj_self, CPyType_MessDetectorPlugin)))
        arg_self = obj_self;
    else {
        CPy_TypeError("charset_normalizer.md.MessDetectorPlugin", obj_self); 
        goto fail;
    }
    PyObject *arg_character;
    if (likely(PyUnicode_Check(obj_character)))
        arg_character = obj_character;
    else {
        CPy_TypeError("str", obj_character); 
        goto fail;
    }
    char retval = CPyDef_MessDetectorPlugin___eligible(arg_self, arg_character);
    if (retval == 2) {
        return NULL;
    }
    PyObject *retbox = retval ? Py_True : Py_False;
    CPy_INCREF(retbox);
    return retbox;
fail: ;
    CPy_AddTraceback("src/charset_normalizer/md.py", "eligible", 39, CPyStatic_globals);
    return NULL;
}

char CPyDef_MessDetectorPlugin___feed(PyObject *cpy_r_self, PyObject *cpy_r_character) {
    PyObject *cpy_r_r0;
    PyObject *cpy_r_r1;
    PyObject *cpy_r_r2;
    char cpy_r_r3;
    cpy_r_r0 = CPyModule_builtins;
    cpy_r_r1 = CPyStatics[3]; /* 'NotImplementedError' */
    cpy_r_r2 = CPyObject_GetAttr(cpy_r_r0, cpy_r_r1);
    if (unlikely(cpy_r_r2 == NULL)) {
        CPy_AddTraceback("src/charset_normalizer/md.py", "feed", 50, CPyStatic_globals);
        goto CPyL3;
    }
    CPy_Raise(cpy_r_r2);
    CPy_DECREF(cpy_r_r2);
    if (unlikely(!0)) {
        CPy_AddTraceback("src/charset_normalizer/md.py", "feed", 50, CPyStatic_globals);
        goto CPyL3;
    }
    CPy_Unreachable();
CPyL3: ;
    cpy_r_r3 = 2;
    return cpy_r_r3;
}

PyObject *CPyPy_MessDetectorPlugin___feed(PyObject *self, PyObject *const *args, size_t nargs, PyObject *kwnames) {
    PyObject *obj_self = self;
    static const char * const kwlist[] = {"character", 0};
    static CPyArg_Parser parser = {"O:feed", kwlist, 0};
    PyObject *obj_character;
    if (!CPyArg_ParseStackAndKeywordsOneArg(args, nargs, kwnames, &parser, &obj_character)) {
        return NULL;
    }
    PyObject *arg_self;
    if (likely(PyObject_TypeCheck(obj_self, CPyType_MessDetectorPlugin)))
        arg_self = obj_self;
    else {
        CPy_TypeError("charset_normalizer.md.MessDetectorPlugin", obj_self); 
        goto fail;
    }
    PyObject *arg_character;
    if (likely(PyUnicode_Check(obj_character)))
        arg_character = obj_character;
    else {
        CPy_TypeError("str", obj_character); 
        goto fail;
    }
    char retval = CPyDef_MessDetectorPlugin___feed(arg_self, arg_character);
    if (retval == 2) {
        return NULL;
    }
    PyObject *retbox = Py_None;
    CPy_INCREF(retbox);
    return retbox;
fail: ;
    CPy_AddTraceback("src/charset_normalizer/md.py", "feed", 45, CPyStatic_globals);
    return NULL;
}

char CPyDef_MessDetectorPlugin___reset(PyObject *cpy_r_self) {
    PyObject *cpy_r_r0;
    PyObject *cpy_r_r1;
    PyObject *cpy_r_r2;
    char cpy_r_r3;
    cpy_r_r0 = CPyModule_builtins;
    cpy_r_r1 = CPyStatics[3]; /* 'NotImplementedError' */
    cpy_r_r2 = CPyObject_GetAttr(cpy_r_r0, cpy_r_r1);
    if (unlikely(cpy_r_r2 == NULL)) {
        CPy_AddTraceback("src/charset_normalizer/md.py", "reset", 56, CPyStatic_globals);
        goto CPyL3;
    }
    CPy_Raise(cpy_r_r2);
    CPy_DECREF(cpy_r_r2);
    if (unlikely(!0)) {
        CPy_AddTraceback("src/charset_normalizer/md.py", "reset", 56, CPyStatic_globals);
        goto CPyL3;
    }
    CPy_Unreachable();
CPyL3: ;
    cpy_r_r3 = 2;
    return cpy_r_r3;
}

PyObject *CPyPy_MessDetectorPlugin___reset(PyObject *self, PyObject *const *args, size_t nargs, PyObject *kwnames) {
    PyObject *obj_self = self;
    static const char * const kwlist[] = {0};
    static CPyArg_Parser parser = {":reset", kwlist, 0};
    if (!CPyArg_ParseStackAndKeywordsNoArgs(args, nargs, kwnames, &parser)) {
        return NULL;
    }
    PyObject *arg_self;
    if (likely(PyObject_TypeCheck(obj_self, CPyType_MessDetectorPlugin)))
        arg_self = obj_self;
    else {
        CPy_TypeError("charset_normalizer.md.MessDetectorPlugin", obj_self); 
        goto fail;
    }
    char retval = CPyDef_MessDetectorPlugin___reset(arg_self);
    if (retval == 2) {
        return NULL;
    }
    PyObject *retbox = Py_None;
    CPy_INCREF(retbox);
    return retbox;
fail: ;
    CPy_AddTraceback("src/charset_normalizer/md.py", "reset", 52, CPyStatic_globals);
    return NULL;
}

double CPyDef_MessDetectorPlugin___ratio(PyObject *cpy_r_self) {
    PyObject *cpy_r_r0;
    PyObject *cpy_r_r1;
    PyObject *cpy_r_r2;
    double cpy_r_r3;
    cpy_r_r0 = CPyModule_builtins;
    cpy_r_r1 = CPyStatics[3]; /* 'NotImplementedError' */
    cpy_r_r2 = CPyObject_GetAttr(cpy_r_r0, cpy_r_r1);
    if (unlikely(cpy_r_r2 == NULL)) {
        CPy_AddTraceback("src/charset_normalizer/md.py", "ratio", 64, CPyStatic_globals);
        goto CPyL3;
    }
    CPy_Raise(cpy_r_r2);
    CPy_DECREF(cpy_r_r2);
    if (unlikely(!0)) {
        CPy_AddTraceback("src/charset_normalizer/md.py", "ratio", 64, CPyStatic_globals);
        goto CPyL3;
    }
    CPy_Unreachable();
CPyL3: ;
    cpy_r_r3 = -113.0;
    return cpy_r_r3;
}

PyObject *CPyPy_MessDetectorPlugin___ratio(PyObject *self, PyObject *const *args, size_t nargs, PyObject *kwnames) {
    PyObject *obj_self = self;
    static const char * const kwlist[] = {0};
    static CPyArg_Parser parser = {":ratio", kwlist, 0};
    if (!CPyArg_ParseStackAndKeywordsNoArgs(args, nargs, kwnames, &parser)) {
        return NULL;
    }
    PyObject *arg_self;
    if (likely(PyObject_TypeCheck(obj_self, CPyType_MessDetectorPlugin)))
        arg_self = obj_self;
    else {
        CPy_TypeError("charset_normalizer.md.MessDetectorPlugin", obj_self); 
        goto fail;
    }
    double retval = CPyDef_MessDetectorPlugin___ratio(arg_self);
    if (retval == -113.0 && PyErr_Occurred()) {
        return NULL;
    }
    PyObject *retbox = PyFloat_FromDouble(retval);
    return retbox;
fail: ;
    CPy_AddTraceback("src/charset_normalizer/md.py", "ratio", 59, CPyStatic_globals);
    return NULL;
}

char CPyDef_TooManySymbolOrPunctuationPlugin_____init__(PyObject *cpy_r_self) {
    PyObject *cpy_r_r0;
    ((charset_normalizer___md___TooManySymbolOrPunctuationPluginObject *)cpy_r_self)->__punctuation_count = 0;
    ((charset_normalizer___md___TooManySymbolOrPunctuationPluginObject *)cpy_r_self)->__symbol_count = 0;
    ((charset_normalizer___md___TooManySymbolOrPunctuationPluginObject *)cpy_r_self)->__character_count = 0;
    cpy_r_r0 = Py_None;
    ((charset_normalizer___md___TooManySymbolOrPunctuationPluginObject *)cpy_r_self)->__last_printable_char = cpy_r_r0;
    ((charset_normalizer___md___TooManySymbolOrPunctuationPluginObject *)cpy_r_self)->__frenzy_symbol_in_word = 0;
    return 1;
}

PyObject *CPyPy_TooManySymbolOrPunctuationPlugin_____init__(PyObject *self, PyObject *args, PyObject *kw) {
    PyObject *obj_self = self;
    static const char * const kwlist[] = {0};
    if (!CPyArg_ParseTupleAndKeywords(args, kw, "", "__init__", kwlist)) {
        return NULL;
    }
    PyObject *arg_self;
    if (likely(Py_TYPE(obj_self) == CPyType_TooManySymbolOrPunctuationPlugin))
        arg_self = obj_self;
    else {
        CPy_TypeError("charset_normalizer.md.TooManySymbolOrPunctuationPlugin", obj_self); 
        goto fail;
    }
    char retval = CPyDef_TooManySymbolOrPunctuationPlugin_____init__(arg_self);
    if (retval == 2) {
        return NULL;
    }
    PyObject *retbox = Py_None;
    CPy_INCREF(retbox);
    return retbox;
fail: ;
    CPy_AddTraceback("src/charset_normalizer/md.py", "__init__", 68, CPyStatic_globals);
    return NULL;
}

char CPyDef_TooManySymbolOrPunctuationPlugin___eligible(PyObject *cpy_r_self, PyObject *cpy_r_character) {
    PyObject *cpy_r_r0;
    PyObject **cpy_r_r2;
    PyObject *cpy_r_r3;
    char cpy_r_r4;
    char cpy_r_r5;
    cpy_r_r0 = CPyStatics[4]; /* 'isprintable' */
    PyObject *cpy_r_r1[1] = {cpy_r_character};
    cpy_r_r2 = (PyObject **)&cpy_r_r1;
    cpy_r_r3 = PyObject_VectorcallMethod(cpy_r_r0, cpy_r_r2, 9223372036854775809ULL, 0);
    if (unlikely(cpy_r_r3 == NULL)) {
        CPy_AddTraceback("src/charset_normalizer/md.py", "eligible", 77, CPyStatic_globals);
        goto CPyL3;
    }
    if (unlikely(!PyBool_Check(cpy_r_r3))) {
        CPy_TypeError("bool", cpy_r_r3); cpy_r_r4 = 2;
    } else
        cpy_r_r4 = cpy_r_r3 == Py_True;
    CPy_DECREF(cpy_r_r3);
    if (unlikely(cpy_r_r4 == 2)) {
        CPy_AddTraceback("src/charset_normalizer/md.py", "eligible", 77, CPyStatic_globals);
        goto CPyL3;
    }
    return cpy_r_r4;
CPyL3: ;
    cpy_r_r5 = 2;
    return cpy_r_r5;
}

PyObject *CPyPy_TooManySymbolOrPunctuationPlugin___eligible(PyObject *self, PyObject *const *args, size_t nargs, PyObject *kwnames) {
    PyObject *obj_self = self;
    static const char * const kwlist[] = {"character", 0};
    static CPyArg_Parser parser = {"O:eligible", kwlist, 0};
    PyObject *obj_character;
    if (!CPyArg_ParseStackAndKeywordsOneArg(args, nargs, kwnames, &parser, &obj_character)) {
        return NULL;
    }
    PyObject *arg_self;
    if (likely(Py_TYPE(obj_self) == CPyType_TooManySymbolOrPunctuationPlugin))
        arg_self = obj_self;
    else {
        CPy_TypeError("charset_normalizer.md.TooManySymbolOrPunctuationPlugin", obj_self); 
        goto fail;
    }
    PyObject *arg_character;
    if (likely(PyUnicode_Check(obj_character)))
        arg_character = obj_character;
    else {
        CPy_TypeError("str", obj_character); 
        goto fail;
    }
    char retval = CPyDef_TooManySymbolOrPunctuationPlugin___eligible(arg_self, arg_character);
    if (retval == 2) {
        return NULL;
    }
    PyObject *retbox = retval ? Py_True : Py_False;
    CPy_INCREF(retbox);
    return retbox;
fail: ;
    CPy_AddTraceback("src/charset_normalizer/md.py", "eligible", 76, CPyStatic_globals);
    return NULL;
}

char CPyDef_TooManySymbolOrPunctuationPlugin___feed(PyObject *cpy_r_self, PyObject *cpy_r_character) {
    CPyTagged cpy_r_r0;
    CPyTagged cpy_r_r1;
    char cpy_r_r2;
    PyObject *cpy_r_r3;
    PyObject *cpy_r_r4;
    char cpy_r_r5;
    char cpy_r_r6;
    PyObject *cpy_r_r7;
    char cpy_r_r8;
    char cpy_r_r9;
    PyObject *cpy_r_r10;
    PyObject *cpy_r_r11;
    PyObject *cpy_r_r12;
    PyObject *cpy_r_r13;
    int32_t cpy_r_r14;
    char cpy_r_r15;
    char cpy_r_r16;
    char cpy_r_r17;
    PyObject *cpy_r_r18;
    PyObject *cpy_r_r19;
    PyObject *cpy_r_r20;
    PyObject **cpy_r_r22;
    PyObject *cpy_r_r23;
    char cpy_r_r24;
    CPyTagged cpy_r_r25;
    CPyTagged cpy_r_r26;
    char cpy_r_r27;
    PyObject *cpy_r_r28;
    PyObject **cpy_r_r30;
    PyObject *cpy_r_r31;
    char cpy_r_r32;
    PyObject *cpy_r_r33;
    PyObject *cpy_r_r34;
    char cpy_r_r35;
    PyObject *cpy_r_r36;
    PyObject *cpy_r_r37;
    PyObject *cpy_r_r38;
    PyObject **cpy_r_r40;
    PyObject *cpy_r_r41;
    char cpy_r_r42;
    PyObject *cpy_r_r43;
    PyObject *cpy_r_r44;
    PyObject *cpy_r_r45;
    PyObject **cpy_r_r47;
    PyObject *cpy_r_r48;
    char cpy_r_r49;
    PyObject *cpy_r_r50;
    PyObject *cpy_r_r51;
    char cpy_r_r52;
    CPyTagged cpy_r_r53;
    CPyTagged cpy_r_r54;
    char cpy_r_r55;
    char cpy_r_r56;
    char cpy_r_r57;
    cpy_r_r0 = ((charset_normalizer___md___TooManySymbolOrPunctuationPluginObject *)cpy_r_self)->__character_count;
    cpy_r_r1 = CPyTagged_Add(cpy_r_r0, 2);
    CPyTagged_DECREF(((charset_normalizer___md___TooManySymbolOrPunctuationPluginObject *)cpy_r_self)->__character_count);
    ((charset_normalizer___md___TooManySymbolOrPunctuationPluginObject *)cpy_r_self)->__character_count = cpy_r_r1;
    cpy_r_r3 = ((charset_normalizer___md___TooManySymbolOrPunctuationPluginObject *)cpy_r_self)->__last_printable_char;
    CPy_INCREF(cpy_r_r3);
    cpy_r_r4 = (PyObject *)&_Py_NoneStruct;
    cpy_r_r5 = cpy_r_r3 == cpy_r_r4;
    if (!cpy_r_r5) goto CPyL2;
    cpy_r_r6 = 1;
    goto CPyL3;
CPyL2: ;
    cpy_r_r7 = cpy_r_r3;
    cpy_r_r8 = CPyStr_Equal(cpy_r_r7, cpy_r_character);
    cpy_r_r9 = cpy_r_r8 == 0;
    cpy_r_r6 = cpy_r_r9;
CPyL3: ;
    CPy_DECREF(cpy_r_r3);
    if (!cpy_r_r6) goto CPyL25;
    cpy_r_r10 = CPyStatic_globals;
    cpy_r_r11 = CPyStatics[5]; /* 'COMMON_SAFE_ASCII_CHARACTERS' */
    cpy_r_r12 = CPyDict_GetItem(cpy_r_r10, cpy_r_r11);
    if (unlikely(cpy_r_r12 == NULL)) {
        CPy_AddTraceback("src/charset_normalizer/md.py", "feed", 84, CPyStatic_globals);
        goto CPyL26;
    }
    if (likely(PySet_Check(cpy_r_r12)))
        cpy_r_r13 = cpy_r_r12;
    else {
        CPy_TypeErrorTraceback("src/charset_normalizer/md.py", "feed", 84, CPyStatic_globals, "set", cpy_r_r12);
        goto CPyL26;
    }
    cpy_r_r14 = PySet_Contains(cpy_r_r13, cpy_r_character);
    CPy_DECREF(cpy_r_r13);
    cpy_r_r15 = cpy_r_r14 >= 0;
    if (unlikely(!cpy_r_r15)) {
        CPy_AddTraceback("src/charset_normalizer/md.py", "feed", 84, CPyStatic_globals);
        goto CPyL26;
    }
    cpy_r_r16 = cpy_r_r14;
    cpy_r_r17 = cpy_r_r16 ^ 1;
    if (!cpy_r_r17) goto CPyL25;
    cpy_r_r18 = CPyStatic_globals;
    cpy_r_r19 = CPyStatics[6]; /* 'is_punctuation' */
    cpy_r_r20 = CPyDict_GetItem(cpy_r_r18, cpy_r_r19);
    if (unlikely(cpy_r_r20 == NULL)) {
        CPy_AddTraceback("src/charset_normalizer/md.py", "feed", 86, CPyStatic_globals);
        goto CPyL26;
    }
    PyObject *cpy_r_r21[1] = {cpy_r_character};
    cpy_r_r22 = (PyObject **)&cpy_r_r21;
    cpy_r_r23 = PyObject_Vectorcall(cpy_r_r20, cpy_r_r22, 1, 0);
    CPy_DECREF(cpy_r_r20);
    if (unlikely(cpy_r_r23 == NULL)) {
        CPy_AddTraceback("src/charset_normalizer/md.py", "feed", 86, CPyStatic_globals);
        goto CPyL26;
    }
    if (unlikely(!PyBool_Check(cpy_r_r23))) {
        CPy_TypeError("bool", cpy_r_r23); cpy_r_r24 = 2;
    } else
        cpy_r_r24 = cpy_r_r23 == Py_True;
    CPy_DECREF(cpy_r_r23);
    if (unlikely(cpy_r_r24 == 2)) {
        CPy_AddTraceback("src/charset_normalizer/md.py", "feed", 86, CPyStatic_globals);
        goto CPyL26;
    }
    if (!cpy_r_r24) goto CPyL13;
    cpy_r_r25 = ((charset_normalizer___md___TooManySymbolOrPunctuationPluginObject *)cpy_r_self)->__punctuation_count;
    cpy_r_r26 = CPyTagged_Add(cpy_r_r25, 2);
    CPyTagged_DECREF(((charset_normalizer___md___TooManySymbolOrPunctuationPluginObject *)cpy_r_self)->__punctuation_count);
    ((charset_normalizer___md___TooManySymbolOrPunctuationPluginObject *)cpy_r_self)->__punctuation_count = cpy_r_r26;
    goto CPyL25;
CPyL13: ;
    cpy_r_r28 = CPyStatics[7]; /* 'isdigit' */
    PyObject *cpy_r_r29[1] = {cpy_r_character};
    cpy_r_r30 = (PyObject **)&cpy_r_r29;
    cpy_r_r31 = PyObject_VectorcallMethod(cpy_r_r28, cpy_r_r30, 9223372036854775809ULL, 0);
    if (unlikely(cpy_r_r31 == NULL)) {
        CPy_AddTraceback("src/charset_normalizer/md.py", "feed", 89, CPyStatic_globals);
        goto CPyL26;
    }
    if (unlikely(!PyBool_Check(cpy_r_r31))) {
        CPy_TypeError("bool", cpy_r_r31); cpy_r_r32 = 2;
    } else
        cpy_r_r32 = cpy_r_r31 == Py_True;
    CPy_DECREF(cpy_r_r31);
    if (unlikely(cpy_r_r32 == 2)) {
        CPy_AddTraceback("src/charset_normalizer/md.py", "feed", 89, CPyStatic_globals);
        goto CPyL26;
    }
    cpy_r_r33 = cpy_r_r32 ? Py_True : Py_False;
    cpy_r_r34 = 0 ? Py_True : Py_False;
    cpy_r_r35 = cpy_r_r33 == cpy_r_r34;
    if (!cpy_r_r35) goto CPyL25;
    cpy_r_r36 = CPyStatic_globals;
    cpy_r_r37 = CPyStatics[8]; /* 'is_symbol' */
    cpy_r_r38 = CPyDict_GetItem(cpy_r_r36, cpy_r_r37);
    if (unlikely(cpy_r_r38 == NULL)) {
        CPy_AddTraceback("src/charset_normalizer/md.py", "feed", 90, CPyStatic_globals);
        goto CPyL26;
    }
    PyObject *cpy_r_r39[1] = {cpy_r_character};
    cpy_r_r40 = (PyObject **)&cpy_r_r39;
    cpy_r_r41 = PyObject_Vectorcall(cpy_r_r38, cpy_r_r40, 1, 0);
    CPy_DECREF(cpy_r_r38);
    if (unlikely(cpy_r_r41 == NULL)) {
        CPy_AddTraceback("src/charset_normalizer/md.py", "feed", 90, CPyStatic_globals);
        goto CPyL26;
    }
    if (unlikely(!PyBool_Check(cpy_r_r41))) {
        CPy_TypeError("bool", cpy_r_r41); cpy_r_r42 = 2;
    } else
        cpy_r_r42 = cpy_r_r41 == Py_True;
    CPy_DECREF(cpy_r_r41);
    if (unlikely(cpy_r_r42 == 2)) {
        CPy_AddTraceback("src/charset_normalizer/md.py", "feed", 90, CPyStatic_globals);
        goto CPyL26;
    }
    if (!cpy_r_r42) goto CPyL25;
    cpy_r_r43 = CPyStatic_globals;
    cpy_r_r44 = CPyStatics[9]; /* 'is_emoticon' */
    cpy_r_r45 = CPyDict_GetItem(cpy_r_r43, cpy_r_r44);
    if (unlikely(cpy_r_r45 == NULL)) {
        CPy_AddTraceback("src/charset_normalizer/md.py", "feed", 91, CPyStatic_globals);
        goto CPyL26;
    }
    PyObject *cpy_r_r46[1] = {cpy_r_character};
    cpy_r_r47 = (PyObject **)&cpy_r_r46;
    cpy_r_r48 = PyObject_Vectorcall(cpy_r_r45, cpy_r_r47, 1, 0);
    CPy_DECREF(cpy_r_r45);
    if (unlikely(cpy_r_r48 == NULL)) {
        CPy_AddTraceback("src/charset_normalizer/md.py", "feed", 91, CPyStatic_globals);
        goto CPyL26;
    }
    if (unlikely(!PyBool_Check(cpy_r_r48))) {
        CPy_TypeError("bool", cpy_r_r48); cpy_r_r49 = 2;
    } else
        cpy_r_r49 = cpy_r_r48 == Py_True;
    CPy_DECREF(cpy_r_r48);
    if (unlikely(cpy_r_r49 == 2)) {
        CPy_AddTraceback("src/charset_normalizer/md.py", "feed", 91, CPyStatic_globals);
        goto CPyL26;
    }
    cpy_r_r50 = cpy_r_r49 ? Py_True : Py_False;
    cpy_r_r51 = 0 ? Py_True : Py_False;
    cpy_r_r52 = cpy_r_r50 == cpy_r_r51;
    if (!cpy_r_r52) goto CPyL25;
    cpy_r_r53 = ((charset_normalizer___md___TooManySymbolOrPunctuationPluginObject *)cpy_r_self)->__symbol_count;
    cpy_r_r54 = CPyTagged_Add(cpy_r_r53, 4);
    CPyTagged_DECREF(((charset_normalizer___md___TooManySymbolOrPunctuationPluginObject *)cpy_r_self)->__symbol_count);
    ((charset_normalizer___md___TooManySymbolOrPunctuationPluginObject *)cpy_r_self)->__symbol_count = cpy_r_r54;
CPyL25: ;
    CPy_INCREF(cpy_r_character);
    CPy_DECREF(((charset_normalizer___md___TooManySymbolOrPunctuationPluginObject *)cpy_r_self)->__last_printable_char);
    ((charset_normalizer___md___TooManySymbolOrPunctuationPluginObject *)cpy_r_self)->__last_printable_char = cpy_r_character;
    return 1;
CPyL26: ;
    cpy_r_r57 = 2;
    return cpy_r_r57;
}

PyObject *CPyPy_TooManySymbolOrPunctuationPlugin___feed(PyObject *self, PyObject *const *args, size_t nargs, PyObject *kwnames) {
    PyObject *obj_self = self;
    static const char * const kwlist[] = {"character", 0};
    static CPyArg_Parser parser = {"O:feed", kwlist, 0};
    PyObject *obj_character;
    if (!CPyArg_ParseStackAndKeywordsOneArg(args, nargs, kwnames, &parser, &obj_character)) {
        return NULL;
    }
    PyObject *arg_self;
    if (likely(Py_TYPE(obj_self) == CPyType_TooManySymbolOrPunctuationPlugin))
        arg_self = obj_self;
    else {
        CPy_TypeError("charset_normalizer.md.TooManySymbolOrPunctuationPlugin", obj_self); 
        goto fail;
    }
    PyObject *arg_character;
    if (likely(PyUnicode_Check(obj_character)))
        arg_character = obj_character;
    else {
        CPy_TypeError("str", obj_character); 
        goto fail;
    }
    char retval = CPyDef_TooManySymbolOrPunctuationPlugin___feed(arg_self, arg_character);
    if (retval == 2) {
        return NULL;
    }
    PyObject *retbox = Py_None;
    CPy_INCREF(retbox);
    return retbox;
fail: ;
    CPy_AddTraceback("src/charset_normalizer/md.py", "feed", 79, CPyStatic_globals);
    return NULL;
}

char CPyDef_TooManySymbolOrPunctuationPlugin___reset(PyObject *cpy_r_self) {
    char cpy_r_r0;
    char cpy_r_r1;
    char cpy_r_r2;
    CPyTagged_DECREF(((charset_normalizer___md___TooManySymbolOrPunctuationPluginObject *)cpy_r_self)->__punctuation_count);
    ((charset_normalizer___md___TooManySymbolOrPunctuationPluginObject *)cpy_r_self)->__punctuation_count = 0;
    CPyTagged_DECREF(((charset_normalizer___md___TooManySymbolOrPunctuationPluginObject *)cpy_r_self)->__character_count);
    ((charset_normalizer___md___TooManySymbolOrPunctuationPluginObject *)cpy_r_self)->__character_count = 0;
    CPyTagged_DECREF(((charset_normalizer___md___TooManySymbolOrPunctuationPluginObject *)cpy_r_self)->__symbol_count);
    ((charset_normalizer___md___TooManySymbolOrPunctuationPluginObject *)cpy_r_self)->__symbol_count = 0;
    return 1;
}

PyObject *CPyPy_TooManySymbolOrPunctuationPlugin___reset(PyObject *self, PyObject *const *args, size_t nargs, PyObject *kwnames) {
    PyObject *obj_self = self;
    static const char * const kwlist[] = {0};
    static CPyArg_Parser parser = {":reset", kwlist, 0};
    if (!CPyArg_ParseStackAndKeywordsNoArgs(args, nargs, kwnames, &parser)) {
        return NULL;
    }
    PyObject *arg_self;
    if (likely(Py_TYPE(obj_self) == CPyType_TooManySymbolOrPunctuationPlugin))
        arg_self = obj_self;
    else {
        CPy_TypeError("charset_normalizer.md.TooManySymbolOrPunctuationPlugin", obj_self); 
        goto fail;
    }
    char retval = CPyDef_TooManySymbolOrPunctuationPlugin___reset(arg_self);
    if (retval == 2) {
        return NULL;
    }
    PyObject *retbox = Py_None;
    CPy_INCREF(retbox);
    return retbox;
fail: ;
    CPy_AddTraceback("src/charset_normalizer/md.py", "reset", 97, CPyStatic_globals);
    return NULL;
}

double CPyDef_TooManySymbolOrPunctuationPlugin___ratio(PyObject *cpy_r_self) {
    CPyTagged cpy_r_r0;
    char cpy_r_r1;
    CPyTagged cpy_r_r2;
    CPyTagged cpy_r_r3;
    CPyTagged cpy_r_r4;
    CPyTagged cpy_r_r5;
    double cpy_r_r6;
    char cpy_r_r7;
    char cpy_r_r8;
    PyObject *cpy_r_r9;
    double cpy_r_r10;
    double cpy_r_r11;
    cpy_r_r0 = ((charset_normalizer___md___TooManySymbolOrPunctuationPluginObject *)cpy_r_self)->__character_count;
    cpy_r_r1 = cpy_r_r0 == 0;
    if (!cpy_r_r1) goto CPyL2;
    return 0.0;
CPyL2: ;
    cpy_r_r2 = ((charset_normalizer___md___TooManySymbolOrPunctuationPluginObject *)cpy_r_self)->__punctuation_count;
    cpy_r_r3 = ((charset_normalizer___md___TooManySymbolOrPunctuationPluginObject *)cpy_r_self)->__symbol_count;
    cpy_r_r4 = CPyTagged_Add(cpy_r_r2, cpy_r_r3);
    cpy_r_r5 = ((charset_normalizer___md___TooManySymbolOrPunctuationPluginObject *)cpy_r_self)->__character_count;
    CPyTagged_INCREF(cpy_r_r5);
    cpy_r_r6 = CPyTagged_TrueDivide(cpy_r_r4, cpy_r_r5);
    CPyTagged_DECREF(cpy_r_r4);
    CPyTagged_DECREF(cpy_r_r5);
    cpy_r_r7 = cpy_r_r6 == -113.0;
    if (unlikely(cpy_r_r7)) goto CPyL4;
CPyL3: ;
    cpy_r_r8 = cpy_r_r6 >= 0.3;
    if (cpy_r_r8) {
        goto CPyL5;
    } else
        goto CPyL6;
CPyL4: ;
    cpy_r_r9 = PyErr_Occurred();
    if (unlikely(cpy_r_r9 != NULL)) {
        CPy_AddTraceback("src/charset_normalizer/md.py", "ratio", 107, CPyStatic_globals);
        goto CPyL8;
    } else
        goto CPyL3;
CPyL5: ;
    cpy_r_r10 = cpy_r_r6;
    goto CPyL7;
CPyL6: ;
    cpy_r_r10 = 0.0;
CPyL7: ;
    return cpy_r_r10;
CPyL8: ;
    cpy_r_r11 = -113.0;
    return cpy_r_r11;
}

PyObject *CPyPy_TooManySymbolOrPunctuationPlugin___ratio(PyObject *self, PyObject *const *args, size_t nargs, PyObject *kwnames) {
    PyObject *obj_self = self;
    static const char * const kwlist[] = {0};
    static CPyArg_Parser parser = {":ratio", kwlist, 0};
    if (!CPyArg_ParseStackAndKeywordsNoArgs(args, nargs, kwnames, &parser)) {
        return NULL;
    }
    PyObject *arg_self;
    if (likely(Py_TYPE(obj_self) == CPyType_TooManySymbolOrPunctuationPlugin))
        arg_self = obj_self;
    else {
        CPy_TypeError("charset_normalizer.md.TooManySymbolOrPunctuationPlugin", obj_self); 
        goto fail;
    }
    double retval = CPyDef_TooManySymbolOrPunctuationPlugin___ratio(arg_self);
    if (retval == -113.0 && PyErr_Occurred()) {
        return NULL;
    }
    PyObject *retbox = PyFloat_FromDouble(retval);
    return retbox;
fail: ;
    CPy_AddTraceback("src/charset_normalizer/md.py", "ratio", 103, CPyStatic_globals);
    return NULL;
}

char CPyDef_TooManyAccentuatedPlugin_____init__(PyObject *cpy_r_self) {
    ((charset_normalizer___md___TooManyAccentuatedPluginObject *)cpy_r_self)->__character_count = 0;
    ((charset_normalizer___md___TooManyAccentuatedPluginObject *)cpy_r_self)->__accentuated_count = 0;
    return 1;
}

PyObject *CPyPy_TooManyAccentuatedPlugin_____init__(PyObject *self, PyObject *args, PyObject *kw) {
    PyObject *obj_self = self;
    static const char * const kwlist[] = {0};
    if (!CPyArg_ParseTupleAndKeywords(args, kw, "", "__init__", kwlist)) {
        return NULL;
    }
    PyObject *arg_self;
    if (likely(Py_TYPE(obj_self) == CPyType_TooManyAccentuatedPlugin))
        arg_self = obj_self;
    else {
        CPy_TypeError("charset_normalizer.md.TooManyAccentuatedPlugin", obj_self); 
        goto fail;
    }
    char retval = CPyDef_TooManyAccentuatedPlugin_____init__(arg_self);
    if (retval == 2) {
        return NULL;
    }
    PyObject *retbox = Py_None;
    CPy_INCREF(retbox);
    return retbox;
fail: ;
    CPy_AddTraceback("src/charset_normalizer/md.py", "__init__", 115, CPyStatic_globals);
    return NULL;
}

char CPyDef_TooManyAccentuatedPlugin___eligible(PyObject *cpy_r_self, PyObject *cpy_r_character) {
    PyObject *cpy_r_r0;
    PyObject **cpy_r_r2;
    PyObject *cpy_r_r3;
    char cpy_r_r4;
    char cpy_r_r5;
    cpy_r_r0 = CPyStatics[10]; /* 'isalpha' */
    PyObject *cpy_r_r1[1] = {cpy_r_character};
    cpy_r_r2 = (PyObject **)&cpy_r_r1;
    cpy_r_r3 = PyObject_VectorcallMethod(cpy_r_r0, cpy_r_r2, 9223372036854775809ULL, 0);
    if (unlikely(cpy_r_r3 == NULL)) {
        CPy_AddTraceback("src/charset_normalizer/md.py", "eligible", 120, CPyStatic_globals);
        goto CPyL3;
    }
    if (unlikely(!PyBool_Check(cpy_r_r3))) {
        CPy_TypeError("bool", cpy_r_r3); cpy_r_r4 = 2;
    } else
        cpy_r_r4 = cpy_r_r3 == Py_True;
    CPy_DECREF(cpy_r_r3);
    if (unlikely(cpy_r_r4 == 2)) {
        CPy_AddTraceback("src/charset_normalizer/md.py", "eligible", 120, CPyStatic_globals);
        goto CPyL3;
    }
    return cpy_r_r4;
CPyL3: ;
    cpy_r_r5 = 2;
    return cpy_r_r5;
}

PyObject *CPyPy_TooManyAccentuatedPlugin___eligible(PyObject *self, PyObject *const *args, size_t nargs, PyObject *kwnames) {
    PyObject *obj_self = self;
    static const char * const kwlist[] = {"character", 0};
    static CPyArg_Parser parser = {"O:eligible", kwlist, 0};
    PyObject *obj_character;
    if (!CPyArg_ParseStackAndKeywordsOneArg(args, nargs, kwnames, &parser, &obj_character)) {
        return NULL;
    }
    PyObject *arg_self;
    if (likely(Py_TYPE(obj_self) == CPyType_TooManyAccentuatedPlugin))
        arg_self = obj_self;
    else {
        CPy_TypeError("charset_normalizer.md.TooManyAccentuatedPlugin", obj_self); 
        goto fail;
    }
    PyObject *arg_character;
    if (likely(PyUnicode_Check(obj_character)))
        arg_character = obj_character;
    else {
        CPy_TypeError("str", obj_character); 
        goto fail;
    }
    char retval = CPyDef_TooManyAccentuatedPlugin___eligible(arg_self, arg_character);
    if (retval == 2) {
        return NULL;
    }
    PyObject *retbox = retval ? Py_True : Py_False;
    CPy_INCREF(retbox);
    return retbox;
fail: ;
    CPy_AddTraceback("src/charset_normalizer/md.py", "eligible", 119, CPyStatic_globals);
    return NULL;
}

char CPyDef_TooManyAccentuatedPlugin___feed(PyObject *cpy_r_self, PyObject *cpy_r_character) {
    CPyTagged cpy_r_r0;
    CPyTagged cpy_r_r1;
    char cpy_r_r2;
    PyObject *cpy_r_r3;
    PyObject *cpy_r_r4;
    PyObject *cpy_r_r5;
    PyObject **cpy_r_r7;
    PyObject *cpy_r_r8;
    char cpy_r_r9;
    CPyTagged cpy_r_r10;
    CPyTagged cpy_r_r11;
    char cpy_r_r12;
    char cpy_r_r13;
    cpy_r_r0 = ((charset_normalizer___md___TooManyAccentuatedPluginObject *)cpy_r_self)->__character_count;
    cpy_r_r1 = CPyTagged_Add(cpy_r_r0, 2);
    CPyTagged_DECREF(((charset_normalizer___md___TooManyAccentuatedPluginObject *)cpy_r_self)->__character_count);
    ((charset_normalizer___md___TooManyAccentuatedPluginObject *)cpy_r_self)->__character_count = cpy_r_r1;
    cpy_r_r3 = CPyStatic_globals;
    cpy_r_r4 = CPyStatics[11]; /* 'is_accentuated' */
    cpy_r_r5 = CPyDict_GetItem(cpy_r_r3, cpy_r_r4);
    if (unlikely(cpy_r_r5 == NULL)) {
        CPy_AddTraceback("src/charset_normalizer/md.py", "feed", 125, CPyStatic_globals);
        goto CPyL6;
    }
    PyObject *cpy_r_r6[1] = {cpy_r_character};
    cpy_r_r7 = (PyObject **)&cpy_r_r6;
    cpy_r_r8 = PyObject_Vectorcall(cpy_r_r5, cpy_r_r7, 1, 0);
    CPy_DECREF(cpy_r_r5);
    if (unlikely(cpy_r_r8 == NULL)) {
        CPy_AddTraceback("src/charset_normalizer/md.py", "feed", 125, CPyStatic_globals);
        goto CPyL6;
    }
    if (unlikely(!PyBool_Check(cpy_r_r8))) {
        CPy_TypeError("bool", cpy_r_r8); cpy_r_r9 = 2;
    } else
        cpy_r_r9 = cpy_r_r8 == Py_True;
    CPy_DECREF(cpy_r_r8);
    if (unlikely(cpy_r_r9 == 2)) {
        CPy_AddTraceback("src/charset_normalizer/md.py", "feed", 125, CPyStatic_globals);
        goto CPyL6;
    }
    if (!cpy_r_r9) goto CPyL5;
    cpy_r_r10 = ((charset_normalizer___md___TooManyAccentuatedPluginObject *)cpy_r_self)->__accentuated_count;
    cpy_r_r11 = CPyTagged_Add(cpy_r_r10, 2);
    CPyTagged_DECREF(((charset_normalizer___md___TooManyAccentuatedPluginObject *)cpy_r_self)->__accentuated_count);
    ((charset_normalizer___md___TooManyAccentuatedPluginObject *)cpy_r_self)->__accentuated_count = cpy_r_r11;
CPyL5: ;
    return 1;
CPyL6: ;
    cpy_r_r13 = 2;
    return cpy_r_r13;
}

PyObject *CPyPy_TooManyAccentuatedPlugin___feed(PyObject *self, PyObject *const *args, size_t nargs, PyObject *kwnames) {
    PyObject *obj_self = self;
    static const char * const kwlist[] = {"character", 0};
    static CPyArg_Parser parser = {"O:feed", kwlist, 0};
    PyObject *obj_character;
    if (!CPyArg_ParseStackAndKeywordsOneArg(args, nargs, kwnames, &parser, &obj_character)) {
        return NULL;
    }
    PyObject *arg_self;
    if (likely(Py_TYPE(obj_self) == CPyType_TooManyAccentuatedPlugin))
        arg_self = obj_self;
    else {
        CPy_TypeError("charset_normalizer.md.TooManyAccentuatedPlugin", obj_self); 
        goto fail;
    }
    PyObject *arg_character;
    if (likely(PyUnicode_Check(obj_character)))
        arg_character = obj_character;
    else {
        CPy_TypeError("str", obj_character); 
        goto fail;
    }
    char retval = CPyDef_TooManyAccentuatedPlugin___feed(arg_self, arg_character);
    if (retval == 2) {
        return NULL;
    }
    PyObject *retbox = Py_None;
    CPy_INCREF(retbox);
    return retbox;
fail: ;
    CPy_AddTraceback("src/charset_normalizer/md.py", "feed", 122, CPyStatic_globals);
    return NULL;
}

char CPyDef_TooManyAccentuatedPlugin___reset(PyObject *cpy_r_self) {
    char cpy_r_r0;
    char cpy_r_r1;
    CPyTagged_DECREF(((charset_normalizer___md___TooManyAccentuatedPluginObject *)cpy_r_self)->__character_count);
    ((charset_normalizer___md___TooManyAccentuatedPluginObject *)cpy_r_self)->__character_count = 0;
    CPyTagged_DECREF(((charset_normalizer___md___TooManyAccentuatedPluginObject *)cpy_r_self)->__accentuated_count);
    ((charset_normalizer___md___TooManyAccentuatedPluginObject *)cpy_r_self)->__accentuated_count = 0;
    return 1;
}

PyObject *CPyPy_TooManyAccentuatedPlugin___reset(PyObject *self, PyObject *const *args, size_t nargs, PyObject *kwnames) {
    PyObject *obj_self = self;
    static const char * const kwlist[] = {0};
    static CPyArg_Parser parser = {":reset", kwlist, 0};
    if (!CPyArg_ParseStackAndKeywordsNoArgs(args, nargs, kwnames, &parser)) {
        return NULL;
    }
    PyObject *arg_self;
    if (likely(Py_TYPE(obj_self) == CPyType_TooManyAccentuatedPlugin))
        arg_self = obj_self;
    else {
        CPy_TypeError("charset_normalizer.md.TooManyAccentuatedPlugin", obj_self); 
        goto fail;
    }
    char retval = CPyDef_TooManyAccentuatedPlugin___reset(arg_self);
    if (retval == 2) {
        return NULL;
    }
    PyObject *retbox = Py_None;
    CPy_INCREF(retbox);
    return retbox;
fail: ;
    CPy_AddTraceback("src/charset_normalizer/md.py", "reset", 128, CPyStatic_globals);
    return NULL;
}

double CPyDef_TooManyAccentuatedPlugin___ratio(PyObject *cpy_r_self) {
    CPyTagged cpy_r_r0;
    int64_t cpy_r_r1;
    char cpy_r_r2;
    int64_t cpy_r_r3;
    char cpy_r_r4;
    char cpy_r_r5;
    char cpy_r_r6;
    CPyTagged cpy_r_r7;
    CPyTagged cpy_r_r8;
    double cpy_r_r9;
    char cpy_r_r10;
    char cpy_r_r11;
    PyObject *cpy_r_r12;
    double cpy_r_r13;
    double cpy_r_r14;
    cpy_r_r0 = ((charset_normalizer___md___TooManyAccentuatedPluginObject *)cpy_r_self)->__character_count;
    cpy_r_r1 = cpy_r_r0 & 1;
    cpy_r_r2 = cpy_r_r1 != 0;
    if (cpy_r_r2) goto CPyL2;
    cpy_r_r3 = 16 & 1;
    cpy_r_r4 = cpy_r_r3 != 0;
    if (!cpy_r_r4) goto CPyL3;
CPyL2: ;
    cpy_r_r5 = CPyTagged_IsLt_(cpy_r_r0, 16);
    if (cpy_r_r5) {
        goto CPyL4;
    } else
        goto CPyL5;
CPyL3: ;
    cpy_r_r6 = (Py_ssize_t)cpy_r_r0 < (Py_ssize_t)16;
    if (!cpy_r_r6) goto CPyL5;
CPyL4: ;
    return 0.0;
CPyL5: ;
    cpy_r_r7 = ((charset_normalizer___md___TooManyAccentuatedPluginObject *)cpy_r_self)->__accentuated_count;
    CPyTagged_INCREF(cpy_r_r7);
    cpy_r_r8 = ((charset_normalizer___md___TooManyAccentuatedPluginObject *)cpy_r_self)->__character_count;
    CPyTagged_INCREF(cpy_r_r8);
    cpy_r_r9 = CPyTagged_TrueDivide(cpy_r_r7, cpy_r_r8);
    CPyTagged_DECREF(cpy_r_r7);
    CPyTagged_DECREF(cpy_r_r8);
    cpy_r_r10 = cpy_r_r9 == -113.0;
    if (unlikely(cpy_r_r10)) goto CPyL7;
CPyL6: ;
    cpy_r_r11 = cpy_r_r9 >= 0.35;
    if (cpy_r_r11) {
        goto CPyL8;
    } else
        goto CPyL9;
CPyL7: ;
    cpy_r_r12 = PyErr_Occurred();
    if (unlikely(cpy_r_r12 != NULL)) {
        CPy_AddTraceback("src/charset_normalizer/md.py", "ratio", 137, CPyStatic_globals);
        goto CPyL11;
    } else
        goto CPyL6;
CPyL8: ;
    cpy_r_r13 = cpy_r_r9;
    goto CPyL10;
CPyL9: ;
    cpy_r_r13 = 0.0;
CPyL10: ;
    return cpy_r_r13;
CPyL11: ;
    cpy_r_r14 = -113.0;
    return cpy_r_r14;
}

PyObject *CPyPy_TooManyAccentuatedPlugin___ratio(PyObject *self, PyObject *const *args, size_t nargs, PyObject *kwnames) {
    PyObject *obj_self = self;
    static const char * const kwlist[] = {0};
    static CPyArg_Parser parser = {":ratio", kwlist, 0};
    if (!CPyArg_ParseStackAndKeywordsNoArgs(args, nargs, kwnames, &parser)) {
        return NULL;
    }
    PyObject *arg_self;
    if (likely(Py_TYPE(obj_self) == CPyType_TooManyAccentuatedPlugin))
        arg_self = obj_self;
    else {
        CPy_TypeError("charset_normalizer.md.TooManyAccentuatedPlugin", obj_self); 
        goto fail;
    }
    double retval = CPyDef_TooManyAccentuatedPlugin___ratio(arg_self);
    if (retval == -113.0 && PyErr_Occurred()) {
        return NULL;
    }
    PyObject *retbox = PyFloat_FromDouble(retval);
    return retbox;
fail: ;
    CPy_AddTraceback("src/charset_normalizer/md.py", "ratio", 133, CPyStatic_globals);
    return NULL;
}

char CPyDef_UnprintablePlugin_____init__(PyObject *cpy_r_self) {
    ((charset_normalizer___md___UnprintablePluginObject *)cpy_r_self)->__unprintable_count = 0;
    ((charset_normalizer___md___UnprintablePluginObject *)cpy_r_self)->__character_count = 0;
    return 1;
}

PyObject *CPyPy_UnprintablePlugin_____init__(PyObject *self, PyObject *args, PyObject *kw) {
    PyObject *obj_self = self;
    static const char * const kwlist[] = {0};
    if (!CPyArg_ParseTupleAndKeywords(args, kw, "", "__init__", kwlist)) {
        return NULL;
    }
    PyObject *arg_self;
    if (likely(Py_TYPE(obj_self) == CPyType_UnprintablePlugin))
        arg_self = obj_self;
    else {
        CPy_TypeError("charset_normalizer.md.UnprintablePlugin", obj_self); 
        goto fail;
    }
    char retval = CPyDef_UnprintablePlugin_____init__(arg_self);
    if (retval == 2) {
        return NULL;
    }
    PyObject *retbox = Py_None;
    CPy_INCREF(retbox);
    return retbox;
fail: ;
    CPy_AddTraceback("src/charset_normalizer/md.py", "__init__", 142, CPyStatic_globals);
    return NULL;
}

char CPyDef_UnprintablePlugin___eligible(PyObject *cpy_r_self, PyObject *cpy_r_character) {
    return 1;
}

PyObject *CPyPy_UnprintablePlugin___eligible(PyObject *self, PyObject *const *args, size_t nargs, PyObject *kwnames) {
    PyObject *obj_self = self;
    static const char * const kwlist[] = {"character", 0};
    static CPyArg_Parser parser = {"O:eligible", kwlist, 0};
    PyObject *obj_character;
    if (!CPyArg_ParseStackAndKeywordsOneArg(args, nargs, kwnames, &parser, &obj_character)) {
        return NULL;
    }
    PyObject *arg_self;
    if (likely(Py_TYPE(obj_self) == CPyType_UnprintablePlugin))
        arg_self = obj_self;
    else {
        CPy_TypeError("charset_normalizer.md.UnprintablePlugin", obj_self); 
        goto fail;
    }
    PyObject *arg_character;
    if (likely(PyUnicode_Check(obj_character)))
        arg_character = obj_character;
    else {
        CPy_TypeError("str", obj_character); 
        goto fail;
    }
    char retval = CPyDef_UnprintablePlugin___eligible(arg_self, arg_character);
    if (retval == 2) {
        return NULL;
    }
    PyObject *retbox = retval ? Py_True : Py_False;
    CPy_INCREF(retbox);
    return retbox;
fail: ;
    CPy_AddTraceback("src/charset_normalizer/md.py", "eligible", 146, CPyStatic_globals);
    return NULL;
}

char CPyDef_UnprintablePlugin___feed(PyObject *cpy_r_self, PyObject *cpy_r_character) {
    PyObject *cpy_r_r0;
    PyObject *cpy_r_r1;
    PyObject *cpy_r_r2;
    PyObject **cpy_r_r4;
    PyObject *cpy_r_r5;
    char cpy_r_r6;
    CPyTagged cpy_r_r7;
    CPyTagged cpy_r_r8;
    char cpy_r_r9;
    CPyTagged cpy_r_r10;
    CPyTagged cpy_r_r11;
    char cpy_r_r12;
    char cpy_r_r13;
    cpy_r_r0 = CPyStatic_globals;
    cpy_r_r1 = CPyStatics[12]; /* 'is_unprintable' */
    cpy_r_r2 = CPyDict_GetItem(cpy_r_r0, cpy_r_r1);
    if (unlikely(cpy_r_r2 == NULL)) {
        CPy_AddTraceback("src/charset_normalizer/md.py", "feed", 150, CPyStatic_globals);
        goto CPyL6;
    }
    PyObject *cpy_r_r3[1] = {cpy_r_character};
    cpy_r_r4 = (PyObject **)&cpy_r_r3;
    cpy_r_r5 = PyObject_Vectorcall(cpy_r_r2, cpy_r_r4, 1, 0);
    CPy_DECREF(cpy_r_r2);
    if (unlikely(cpy_r_r5 == NULL)) {
        CPy_AddTraceback("src/charset_normalizer/md.py", "feed", 150, CPyStatic_globals);
        goto CPyL6;
    }
    if (unlikely(!PyBool_Check(cpy_r_r5))) {
        CPy_TypeError("bool", cpy_r_r5); cpy_r_r6 = 2;
    } else
        cpy_r_r6 = cpy_r_r5 == Py_True;
    CPy_DECREF(cpy_r_r5);
    if (unlikely(cpy_r_r6 == 2)) {
        CPy_AddTraceback("src/charset_normalizer/md.py", "feed", 150, CPyStatic_globals);
        goto CPyL6;
    }
    if (!cpy_r_r6) goto CPyL5;
    cpy_r_r7 = ((charset_normalizer___md___UnprintablePluginObject *)cpy_r_self)->__unprintable_count;
    cpy_r_r8 = CPyTagged_Add(cpy_r_r7, 2);
    CPyTagged_DECREF(((charset_normalizer___md___UnprintablePluginObject *)cpy_r_self)->__unprintable_count);
    ((charset_normalizer___md___UnprintablePluginObject *)cpy_r_self)->__unprintable_count = cpy_r_r8;
CPyL5: ;
    cpy_r_r10 = ((charset_normalizer___md___UnprintablePluginObject *)cpy_r_self)->__character_count;
    cpy_r_r11 = CPyTagged_Add(cpy_r_r10, 2);
    CPyTagged_DECREF(((charset_normalizer___md___UnprintablePluginObject *)cpy_r_self)->__character_count);
    ((charset_normalizer___md___UnprintablePluginObject *)cpy_r_self)->__character_count = cpy_r_r11;
    return 1;
CPyL6: ;
    cpy_r_r13 = 2;
    return cpy_r_r13;
}

PyObject *CPyPy_UnprintablePlugin___feed(PyObject *self, PyObject *const *args, size_t nargs, PyObject *kwnames) {
    PyObject *obj_self = self;
    static const char * const kwlist[] = {"character", 0};
    static CPyArg_Parser parser = {"O:feed", kwlist, 0};
    PyObject *obj_character;
    if (!CPyArg_ParseStackAndKeywordsOneArg(args, nargs, kwnames, &parser, &obj_character)) {
        return NULL;
    }
    PyObject *arg_self;
    if (likely(Py_TYPE(obj_self) == CPyType_UnprintablePlugin))
        arg_self = obj_self;
    else {
        CPy_TypeError("charset_normalizer.md.UnprintablePlugin", obj_self); 
        goto fail;
    }
    PyObject *arg_character;
    if (likely(PyUnicode_Check(obj_character)))
        arg_character = obj_character;
    else {
        CPy_TypeError("str", obj_character); 
        goto fail;
    }
    char retval = CPyDef_UnprintablePlugin___feed(arg_self, arg_character);
    if (retval == 2) {
        return NULL;
    }
    PyObject *retbox = Py_None;
    CPy_INCREF(retbox);
    return retbox;
fail: ;
    CPy_AddTraceback("src/charset_normalizer/md.py", "feed", 149, CPyStatic_globals);
    return NULL;
}

char CPyDef_UnprintablePlugin___reset(PyObject *cpy_r_self) {
    char cpy_r_r0;
    CPyTagged_DECREF(((charset_normalizer___md___UnprintablePluginObject *)cpy_r_self)->__unprintable_count);
    ((charset_normalizer___md___UnprintablePluginObject *)cpy_r_self)->__unprintable_count = 0;
    return 1;
}

PyObject *CPyPy_UnprintablePlugin___reset(PyObject *self, PyObject *const *args, size_t nargs, PyObject *kwnames) {
    PyObject *obj_self = self;
    static const char * const kwlist[] = {0};
    static CPyArg_Parser parser = {":reset", kwlist, 0};
    if (!CPyArg_ParseStackAndKeywordsNoArgs(args, nargs, kwnames, &parser)) {
        return NULL;
    }
    PyObject *arg_self;
    if (likely(Py_TYPE(obj_self) == CPyType_UnprintablePlugin))
        arg_self = obj_self;
    else {
        CPy_TypeError("charset_normalizer.md.UnprintablePlugin", obj_self); 
        goto fail;
    }
    char retval = CPyDef_UnprintablePlugin___reset(arg_self);
    if (retval == 2) {
        return NULL;
    }
    PyObject *retbox = Py_None;
    CPy_INCREF(retbox);
    return retbox;
fail: ;
    CPy_AddTraceback("src/charset_normalizer/md.py", "reset", 154, CPyStatic_globals);
    return NULL;
}

double CPyDef_UnprintablePlugin___ratio(PyObject *cpy_r_self) {
    CPyTagged cpy_r_r0;
    char cpy_r_r1;
    CPyTagged cpy_r_r2;
    CPyTagged cpy_r_r3;
    CPyTagged cpy_r_r4;
    double cpy_r_r5;
    char cpy_r_r6;
    PyObject *cpy_r_r7;
    double cpy_r_r8;
    cpy_r_r0 = ((charset_normalizer___md___UnprintablePluginObject *)cpy_r_self)->__character_count;
    cpy_r_r1 = cpy_r_r0 == 0;
    if (!cpy_r_r1) goto CPyL2;
    return 0.0;
CPyL2: ;
    cpy_r_r2 = ((charset_normalizer___md___UnprintablePluginObject *)cpy_r_self)->__unprintable_count;
    CPyTagged_INCREF(cpy_r_r2);
    cpy_r_r3 = CPyTagged_Multiply(cpy_r_r2, 16);
    CPyTagged_DECREF(cpy_r_r2);
    cpy_r_r4 = ((charset_normalizer___md___UnprintablePluginObject *)cpy_r_self)->__character_count;
    CPyTagged_INCREF(cpy_r_r4);
    cpy_r_r5 = CPyTagged_TrueDivide(cpy_r_r3, cpy_r_r4);
    CPyTagged_DECREF(cpy_r_r3);
    CPyTagged_DECREF(cpy_r_r4);
    cpy_r_r6 = cpy_r_r5 == -113.0;
    if (unlikely(cpy_r_r6)) goto CPyL4;
CPyL3: ;
    return cpy_r_r5;
CPyL4: ;
    cpy_r_r7 = PyErr_Occurred();
    if (unlikely(cpy_r_r7 != NULL)) {
        CPy_AddTraceback("src/charset_normalizer/md.py", "ratio", 162, CPyStatic_globals);
    } else
        goto CPyL3;
    cpy_r_r8 = -113.0;
    return cpy_r_r8;
}

PyObject *CPyPy_UnprintablePlugin___ratio(PyObject *self, PyObject *const *args, size_t nargs, PyObject *kwnames) {
    PyObject *obj_self = self;
    static const char * const kwlist[] = {0};
    static CPyArg_Parser parser = {":ratio", kwlist, 0};
    if (!CPyArg_ParseStackAndKeywordsNoArgs(args, nargs, kwnames, &parser)) {
        return NULL;
    }
    PyObject *arg_self;
    if (likely(Py_TYPE(obj_self) == CPyType_UnprintablePlugin))
        arg_self = obj_self;
    else {
        CPy_TypeError("charset_normalizer.md.UnprintablePlugin", obj_self); 
        goto fail;
    }
    double retval = CPyDef_UnprintablePlugin___ratio(arg_self);
    if (retval == -113.0 && PyErr_Occurred()) {
        return NULL;
    }
    PyObject *retbox = PyFloat_FromDouble(retval);
    return retbox;
fail: ;
    CPy_AddTraceback("src/charset_normalizer/md.py", "ratio", 158, CPyStatic_globals);
    return NULL;
}

char CPyDef_SuspiciousDuplicateAccentPlugin_____init__(PyObject *cpy_r_self) {
    PyObject *cpy_r_r0;
    ((charset_normalizer___md___SuspiciousDuplicateAccentPluginObject *)cpy_r_self)->__successive_count = 0;
    ((charset_normalizer___md___SuspiciousDuplicateAccentPluginObject *)cpy_r_self)->__character_count = 0;
    cpy_r_r0 = Py_None;
    ((charset_normalizer___md___SuspiciousDuplicateAccentPluginObject *)cpy_r_self)->__last_latin_character = cpy_r_r0;
    return 1;
}

PyObject *CPyPy_SuspiciousDuplicateAccentPlugin_____init__(PyObject *self, PyObject *args, PyObject *kw) {
    PyObject *obj_self = self;
    static const char * const kwlist[] = {0};
    if (!CPyArg_ParseTupleAndKeywords(args, kw, "", "__init__", kwlist)) {
        return NULL;
    }
    PyObject *arg_self;
    if (likely(Py_TYPE(obj_self) == CPyType_SuspiciousDuplicateAccentPlugin))
        arg_self = obj_self;
    else {
        CPy_TypeError("charset_normalizer.md.SuspiciousDuplicateAccentPlugin", obj_self); 
        goto fail;
    }
    char retval = CPyDef_SuspiciousDuplicateAccentPlugin_____init__(arg_self);
    if (retval == 2) {
        return NULL;
    }
    PyObject *retbox = Py_None;
    CPy_INCREF(retbox);
    return retbox;
fail: ;
    CPy_AddTraceback("src/charset_normalizer/md.py", "__init__", 166, CPyStatic_globals);
    return NULL;
}

char CPyDef_SuspiciousDuplicateAccentPlugin___eligible(PyObject *cpy_r_self, PyObject *cpy_r_character) {
    PyObject *cpy_r_r0;
    PyObject **cpy_r_r2;
    PyObject *cpy_r_r3;
    char cpy_r_r4;
    char cpy_r_r5;
    PyObject *cpy_r_r6;
    PyObject *cpy_r_r7;
    PyObject *cpy_r_r8;
    PyObject **cpy_r_r10;
    PyObject *cpy_r_r11;
    char cpy_r_r12;
    char cpy_r_r13;
    cpy_r_r0 = CPyStatics[10]; /* 'isalpha' */
    PyObject *cpy_r_r1[1] = {cpy_r_character};
    cpy_r_r2 = (PyObject **)&cpy_r_r1;
    cpy_r_r3 = PyObject_VectorcallMethod(cpy_r_r0, cpy_r_r2, 9223372036854775809ULL, 0);
    if (unlikely(cpy_r_r3 == NULL)) {
        CPy_AddTraceback("src/charset_normalizer/md.py", "eligible", 173, CPyStatic_globals);
        goto CPyL9;
    }
    if (unlikely(!PyBool_Check(cpy_r_r3))) {
        CPy_TypeError("bool", cpy_r_r3); cpy_r_r4 = 2;
    } else
        cpy_r_r4 = cpy_r_r3 == Py_True;
    CPy_DECREF(cpy_r_r3);
    if (unlikely(cpy_r_r4 == 2)) {
        CPy_AddTraceback("src/charset_normalizer/md.py", "eligible", 173, CPyStatic_globals);
        goto CPyL9;
    }
    if (cpy_r_r4) goto CPyL4;
    cpy_r_r5 = cpy_r_r4;
    goto CPyL8;
CPyL4: ;
    cpy_r_r6 = CPyStatic_globals;
    cpy_r_r7 = CPyStatics[13]; /* 'is_latin' */
    cpy_r_r8 = CPyDict_GetItem(cpy_r_r6, cpy_r_r7);
    if (unlikely(cpy_r_r8 == NULL)) {
        CPy_AddTraceback("src/charset_normalizer/md.py", "eligible", 173, CPyStatic_globals);
        goto CPyL9;
    }
    PyObject *cpy_r_r9[1] = {cpy_r_character};
    cpy_r_r10 = (PyObject **)&cpy_r_r9;
    cpy_r_r11 = PyObject_Vectorcall(cpy_r_r8, cpy_r_r10, 1, 0);
    CPy_DECREF(cpy_r_r8);
    if (unlikely(cpy_r_r11 == NULL)) {
        CPy_AddTraceback("src/charset_normalizer/md.py", "eligible", 173, CPyStatic_globals);
        goto CPyL9;
    }
    if (unlikely(!PyBool_Check(cpy_r_r11))) {
        CPy_TypeError("bool", cpy_r_r11); cpy_r_r12 = 2;
    } else
        cpy_r_r12 = cpy_r_r11 == Py_True;
    CPy_DECREF(cpy_r_r11);
    if (unlikely(cpy_r_r12 == 2)) {
        CPy_AddTraceback("src/charset_normalizer/md.py", "eligible", 173, CPyStatic_globals);
        goto CPyL9;
    }
    cpy_r_r5 = cpy_r_r12;
CPyL8: ;
    return cpy_r_r5;
CPyL9: ;
    cpy_r_r13 = 2;
    return cpy_r_r13;
}

PyObject *CPyPy_SuspiciousDuplicateAccentPlugin___eligible(PyObject *self, PyObject *const *args, size_t nargs, PyObject *kwnames) {
    PyObject *obj_self = self;
    static const char * const kwlist[] = {"character", 0};
    static CPyArg_Parser parser = {"O:eligible", kwlist, 0};
    PyObject *obj_character;
    if (!CPyArg_ParseStackAndKeywordsOneArg(args, nargs, kwnames, &parser, &obj_character)) {
        return NULL;
    }
    PyObject *arg_self;
    if (likely(Py_TYPE(obj_self) == CPyType_SuspiciousDuplicateAccentPlugin))
        arg_self = obj_self;
    else {
        CPy_TypeError("charset_normalizer.md.SuspiciousDuplicateAccentPlugin", obj_self); 
        goto fail;
    }
    PyObject *arg_character;
    if (likely(PyUnicode_Check(obj_character)))
        arg_character = obj_character;
    else {
        CPy_TypeError("str", obj_character); 
        goto fail;
    }
    char retval = CPyDef_SuspiciousDuplicateAccentPlugin___eligible(arg_self, arg_character);
    if (retval == 2) {
        return NULL;
    }
    PyObject *retbox = retval ? Py_True : Py_False;
    CPy_INCREF(retbox);
    return retbox;
fail: ;
    CPy_AddTraceback("src/charset_normalizer/md.py", "eligible", 172, CPyStatic_globals);
    return NULL;
}

char CPyDef_SuspiciousDuplicateAccentPlugin___feed(PyObject *cpy_r_self, PyObject *cpy_r_character) {
    CPyTagged cpy_r_r0;
    CPyTagged cpy_r_r1;
    char cpy_r_r2;
    PyObject *cpy_r_r3;
    PyObject *cpy_r_r4;
    char cpy_r_r5;
    PyObject *cpy_r_r6;
    PyObject *cpy_r_r7;
    PyObject *cpy_r_r8;
    PyObject **cpy_r_r10;
    PyObject *cpy_r_r11;
    char cpy_r_r12;
    PyObject *cpy_r_r13;
    PyObject *cpy_r_r14;
    PyObject *cpy_r_r15;
    PyObject *cpy_r_r16;
    PyObject *cpy_r_r17;
    PyObject **cpy_r_r19;
    PyObject *cpy_r_r20;
    char cpy_r_r21;
    PyObject *cpy_r_r22;
    PyObject **cpy_r_r24;
    PyObject *cpy_r_r25;
    char cpy_r_r26;
    PyObject *cpy_r_r27;
    PyObject *cpy_r_r28;
    PyObject *cpy_r_r29;
    PyObject **cpy_r_r31;
    PyObject *cpy_r_r32;
    char cpy_r_r33;
    CPyTagged cpy_r_r34;
    CPyTagged cpy_r_r35;
    char cpy_r_r36;
    PyObject *cpy_r_r37;
    PyObject *cpy_r_r38;
    PyObject *cpy_r_r39;
    PyObject **cpy_r_r41;
    PyObject *cpy_r_r42;
    PyObject *cpy_r_r43;
    PyObject *cpy_r_r44;
    PyObject *cpy_r_r45;
    PyObject *cpy_r_r46;
    PyObject *cpy_r_r47;
    PyObject *cpy_r_r48;
    PyObject **cpy_r_r50;
    PyObject *cpy_r_r51;
    PyObject *cpy_r_r52;
    char cpy_r_r53;
    CPyTagged cpy_r_r54;
    CPyTagged cpy_r_r55;
    char cpy_r_r56;
    char cpy_r_r57;
    char cpy_r_r58;
    cpy_r_r0 = ((charset_normalizer___md___SuspiciousDuplicateAccentPluginObject *)cpy_r_self)->__character_count;
    cpy_r_r1 = CPyTagged_Add(cpy_r_r0, 2);
    CPyTagged_DECREF(((charset_normalizer___md___SuspiciousDuplicateAccentPluginObject *)cpy_r_self)->__character_count);
    ((charset_normalizer___md___SuspiciousDuplicateAccentPluginObject *)cpy_r_self)->__character_count = cpy_r_r1;
    cpy_r_r3 = ((charset_normalizer___md___SuspiciousDuplicateAccentPluginObject *)cpy_r_self)->__last_latin_character;
    cpy_r_r4 = (PyObject *)&_Py_NoneStruct;
    cpy_r_r5 = cpy_r_r3 != cpy_r_r4;
    if (!cpy_r_r5) goto CPyL27;
    cpy_r_r6 = CPyStatic_globals;
    cpy_r_r7 = CPyStatics[11]; /* 'is_accentuated' */
    cpy_r_r8 = CPyDict_GetItem(cpy_r_r6, cpy_r_r7);
    if (unlikely(cpy_r_r8 == NULL)) {
        CPy_AddTraceback("src/charset_normalizer/md.py", "feed", 179, CPyStatic_globals);
        goto CPyL28;
    }
    PyObject *cpy_r_r9[1] = {cpy_r_character};
    cpy_r_r10 = (PyObject **)&cpy_r_r9;
    cpy_r_r11 = PyObject_Vectorcall(cpy_r_r8, cpy_r_r10, 1, 0);
    CPy_DECREF(cpy_r_r8);
    if (unlikely(cpy_r_r11 == NULL)) {
        CPy_AddTraceback("src/charset_normalizer/md.py", "feed", 179, CPyStatic_globals);
        goto CPyL28;
    }
    if (unlikely(!PyBool_Check(cpy_r_r11))) {
        CPy_TypeError("bool", cpy_r_r11); cpy_r_r12 = 2;
    } else
        cpy_r_r12 = cpy_r_r11 == Py_True;
    CPy_DECREF(cpy_r_r11);
    if (unlikely(cpy_r_r12 == 2)) {
        CPy_AddTraceback("src/charset_normalizer/md.py", "feed", 179, CPyStatic_globals);
        goto CPyL28;
    }
    if (!cpy_r_r12) goto CPyL27;
    cpy_r_r13 = ((charset_normalizer___md___SuspiciousDuplicateAccentPluginObject *)cpy_r_self)->__last_latin_character;
    CPy_INCREF(cpy_r_r13);
    if (likely(cpy_r_r13 != Py_None))
        cpy_r_r14 = cpy_r_r13;
    else {
        CPy_TypeErrorTraceback("src/charset_normalizer/md.py", "feed", 180, CPyStatic_globals, "str", cpy_r_r13);
        goto CPyL28;
    }
    cpy_r_r15 = CPyStatic_globals;
    cpy_r_r16 = CPyStatics[11]; /* 'is_accentuated' */
    cpy_r_r17 = CPyDict_GetItem(cpy_r_r15, cpy_r_r16);
    if (unlikely(cpy_r_r17 == NULL)) {
        CPy_AddTraceback("src/charset_normalizer/md.py", "feed", 180, CPyStatic_globals);
        goto CPyL29;
    }
    PyObject *cpy_r_r18[1] = {cpy_r_r14};
    cpy_r_r19 = (PyObject **)&cpy_r_r18;
    cpy_r_r20 = PyObject_Vectorcall(cpy_r_r17, cpy_r_r19, 1, 0);
    CPy_DECREF(cpy_r_r17);
    if (unlikely(cpy_r_r20 == NULL)) {
        CPy_AddTraceback("src/charset_normalizer/md.py", "feed", 180, CPyStatic_globals);
        goto CPyL29;
    }
    CPy_DECREF(cpy_r_r14);
    if (unlikely(!PyBool_Check(cpy_r_r20))) {
        CPy_TypeError("bool", cpy_r_r20); cpy_r_r21 = 2;
    } else
        cpy_r_r21 = cpy_r_r20 == Py_True;
    CPy_DECREF(cpy_r_r20);
    if (unlikely(cpy_r_r21 == 2)) {
        CPy_AddTraceback("src/charset_normalizer/md.py", "feed", 180, CPyStatic_globals);
        goto CPyL28;
    }
    if (!cpy_r_r21) goto CPyL27;
    cpy_r_r22 = CPyStatics[14]; /* 'isupper' */
    PyObject *cpy_r_r23[1] = {cpy_r_character};
    cpy_r_r24 = (PyObject **)&cpy_r_r23;
    cpy_r_r25 = PyObject_VectorcallMethod(cpy_r_r22, cpy_r_r24, 9223372036854775809ULL, 0);
    if (unlikely(cpy_r_r25 == NULL)) {
        CPy_AddTraceback("src/charset_normalizer/md.py", "feed", 182, CPyStatic_globals);
        goto CPyL28;
    }
    if (unlikely(!PyBool_Check(cpy_r_r25))) {
        CPy_TypeError("bool", cpy_r_r25); cpy_r_r26 = 2;
    } else
        cpy_r_r26 = cpy_r_r25 == Py_True;
    CPy_DECREF(cpy_r_r25);
    if (unlikely(cpy_r_r26 == 2)) {
        CPy_AddTraceback("src/charset_normalizer/md.py", "feed", 182, CPyStatic_globals);
        goto CPyL28;
    }
    if (!cpy_r_r26) goto CPyL18;
    cpy_r_r27 = ((charset_normalizer___md___SuspiciousDuplicateAccentPluginObject *)cpy_r_self)->__last_latin_character;
    CPy_INCREF(cpy_r_r27);
    if (likely(cpy_r_r27 != Py_None))
        cpy_r_r28 = cpy_r_r27;
    else {
        CPy_TypeErrorTraceback("src/charset_normalizer/md.py", "feed", 182, CPyStatic_globals, "str", cpy_r_r27);
        goto CPyL28;
    }
    cpy_r_r29 = CPyStatics[14]; /* 'isupper' */
    PyObject *cpy_r_r30[1] = {cpy_r_r28};
    cpy_r_r31 = (PyObject **)&cpy_r_r30;
    cpy_r_r32 = PyObject_VectorcallMethod(cpy_r_r29, cpy_r_r31, 9223372036854775809ULL, 0);
    if (unlikely(cpy_r_r32 == NULL)) {
        CPy_AddTraceback("src/charset_normalizer/md.py", "feed", 182, CPyStatic_globals);
        goto CPyL30;
    }
    CPy_DECREF(cpy_r_r28);
    if (unlikely(!PyBool_Check(cpy_r_r32))) {
        CPy_TypeError("bool", cpy_r_r32); cpy_r_r33 = 2;
    } else
        cpy_r_r33 = cpy_r_r32 == Py_True;
    CPy_DECREF(cpy_r_r32);
    if (unlikely(cpy_r_r33 == 2)) {
        CPy_AddTraceback("src/charset_normalizer/md.py", "feed", 182, CPyStatic_globals);
        goto CPyL28;
    }
    if (!cpy_r_r33) goto CPyL18;
    cpy_r_r34 = ((charset_normalizer___md___SuspiciousDuplicateAccentPluginObject *)cpy_r_self)->__successive_count;
    cpy_r_r35 = CPyTagged_Add(cpy_r_r34, 2);
    CPyTagged_DECREF(((charset_normalizer___md___SuspiciousDuplicateAccentPluginObject *)cpy_r_self)->__successive_count);
    ((charset_normalizer___md___SuspiciousDuplicateAccentPluginObject *)cpy_r_self)->__successive_count = cpy_r_r35;
CPyL18: ;
    cpy_r_r37 = CPyStatic_globals;
    cpy_r_r38 = CPyStatics[15]; /* 'remove_accent' */
    cpy_r_r39 = CPyDict_GetItem(cpy_r_r37, cpy_r_r38);
    if (unlikely(cpy_r_r39 == NULL)) {
        CPy_AddTraceback("src/charset_normalizer/md.py", "feed", 185, CPyStatic_globals);
        goto CPyL28;
    }
    PyObject *cpy_r_r40[1] = {cpy_r_character};
    cpy_r_r41 = (PyObject **)&cpy_r_r40;
    cpy_r_r42 = PyObject_Vectorcall(cpy_r_r39, cpy_r_r41, 1, 0);
    CPy_DECREF(cpy_r_r39);
    if (unlikely(cpy_r_r42 == NULL)) {
        CPy_AddTraceback("src/charset_normalizer/md.py", "feed", 185, CPyStatic_globals);
        goto CPyL28;
    }
    if (likely(PyUnicode_Check(cpy_r_r42)))
        cpy_r_r43 = cpy_r_r42;
    else {
        CPy_TypeErrorTraceback("src/charset_normalizer/md.py", "feed", 185, CPyStatic_globals, "str", cpy_r_r42);
        goto CPyL28;
    }
    cpy_r_r44 = ((charset_normalizer___md___SuspiciousDuplicateAccentPluginObject *)cpy_r_self)->__last_latin_character;
    CPy_INCREF(cpy_r_r44);
    if (likely(cpy_r_r44 != Py_None))
        cpy_r_r45 = cpy_r_r44;
    else {
        CPy_TypeErrorTraceback("src/charset_normalizer/md.py", "feed", 185, CPyStatic_globals, "str", cpy_r_r44);
        goto CPyL31;
    }
    cpy_r_r46 = CPyStatic_globals;
    cpy_r_r47 = CPyStatics[15]; /* 'remove_accent' */
    cpy_r_r48 = CPyDict_GetItem(cpy_r_r46, cpy_r_r47);
    if (unlikely(cpy_r_r48 == NULL)) {
        CPy_AddTraceback("src/charset_normalizer/md.py", "feed", 185, CPyStatic_globals);
        goto CPyL32;
    }
    PyObject *cpy_r_r49[1] = {cpy_r_r45};
    cpy_r_r50 = (PyObject **)&cpy_r_r49;
    cpy_r_r51 = PyObject_Vectorcall(cpy_r_r48, cpy_r_r50, 1, 0);
    CPy_DECREF(cpy_r_r48);
    if (unlikely(cpy_r_r51 == NULL)) {
        CPy_AddTraceback("src/charset_normalizer/md.py", "feed", 185, CPyStatic_globals);
        goto CPyL32;
    }
    CPy_DECREF(cpy_r_r45);
    if (likely(PyUnicode_Check(cpy_r_r51)))
        cpy_r_r52 = cpy_r_r51;
    else {
        CPy_TypeErrorTraceback("src/charset_normalizer/md.py", "feed", 185, CPyStatic_globals, "str", cpy_r_r51);
        goto CPyL31;
    }
    cpy_r_r53 = CPyStr_Equal(cpy_r_r43, cpy_r_r52);
    CPy_DECREF(cpy_r_r43);
    CPy_DECREF(cpy_r_r52);
    if (!cpy_r_r53) goto CPyL27;
    cpy_r_r54 = ((charset_normalizer___md___SuspiciousDuplicateAccentPluginObject *)cpy_r_self)->__successive_count;
    cpy_r_r55 = CPyTagged_Add(cpy_r_r54, 2);
    CPyTagged_DECREF(((charset_normalizer___md___SuspiciousDuplicateAccentPluginObject *)cpy_r_self)->__successive_count);
    ((charset_normalizer___md___SuspiciousDuplicateAccentPluginObject *)cpy_r_self)->__successive_count = cpy_r_r55;
CPyL27: ;
    CPy_INCREF(cpy_r_character);
    CPy_DECREF(((charset_normalizer___md___SuspiciousDuplicateAccentPluginObject *)cpy_r_self)->__last_latin_character);
    ((charset_normalizer___md___SuspiciousDuplicateAccentPluginObject *)cpy_r_self)->__last_latin_character = cpy_r_character;
    return 1;
CPyL28: ;
    cpy_r_r58 = 2;
    return cpy_r_r58;
CPyL29: ;
    CPy_DecRef(cpy_r_r14);
    goto CPyL28;
CPyL30: ;
    CPy_DecRef(cpy_r_r28);
    goto CPyL28;
CPyL31: ;
    CPy_DecRef(cpy_r_r43);
    goto CPyL28;
CPyL32: ;
    CPy_DecRef(cpy_r_r43);
    CPy_DecRef(cpy_r_r45);
    goto CPyL28;
}

PyObject *CPyPy_SuspiciousDuplicateAccentPlugin___feed(PyObject *self, PyObject *const *args, size_t nargs, PyObject *kwnames) {
    PyObject *obj_self = self;
    static const char * const kwlist[] = {"character", 0};
    static CPyArg_Parser parser = {"O:feed", kwlist, 0};
    PyObject *obj_character;
    if (!CPyArg_ParseStackAndKeywordsOneArg(args, nargs, kwnames, &parser, &obj_character)) {
        return NULL;
    }
    PyObject *arg_self;
    if (likely(Py_TYPE(obj_self) == CPyType_SuspiciousDuplicateAccentPlugin))
        arg_self = obj_self;
    else {
        CPy_TypeError("charset_normalizer.md.SuspiciousDuplicateAccentPlugin", obj_self); 
        goto fail;
    }
    PyObject *arg_character;
    if (likely(PyUnicode_Check(obj_character)))
        arg_character = obj_character;
    else {
        CPy_TypeError("str", obj_character); 
        goto fail;
    }
    char retval = CPyDef_SuspiciousDuplicateAccentPlugin___feed(arg_self, arg_character);
    if (retval == 2) {
        return NULL;
    }
    PyObject *retbox = Py_None;
    CPy_INCREF(retbox);
    return retbox;
fail: ;
    CPy_AddTraceback("src/charset_normalizer/md.py", "feed", 175, CPyStatic_globals);
    return NULL;
}

char CPyDef_SuspiciousDuplicateAccentPlugin___reset(PyObject *cpy_r_self) {
    char cpy_r_r0;
    char cpy_r_r1;
    PyObject *cpy_r_r2;
    char cpy_r_r3;
    CPyTagged_DECREF(((charset_normalizer___md___SuspiciousDuplicateAccentPluginObject *)cpy_r_self)->__successive_count);
    ((charset_normalizer___md___SuspiciousDuplicateAccentPluginObject *)cpy_r_self)->__successive_count = 0;
    CPyTagged_DECREF(((charset_normalizer___md___SuspiciousDuplicateAccentPluginObject *)cpy_r_self)->__character_count);
    ((charset_normalizer___md___SuspiciousDuplicateAccentPluginObject *)cpy_r_self)->__character_count = 0;
    cpy_r_r2 = Py_None;
    CPy_DECREF(((charset_normalizer___md___SuspiciousDuplicateAccentPluginObject *)cpy_r_self)->__last_latin_character);
    ((charset_normalizer___md___SuspiciousDuplicateAccentPluginObject *)cpy_r_self)->__last_latin_character = cpy_r_r2;
    return 1;
}

PyObject *CPyPy_SuspiciousDuplicateAccentPlugin___reset(PyObject *self, PyObject *const *args, size_t nargs, PyObject *kwnames) {
    PyObject *obj_self = self;
    static const char * const kwlist[] = {0};
    static CPyArg_Parser parser = {":reset", kwlist, 0};
    if (!CPyArg_ParseStackAndKeywordsNoArgs(args, nargs, kwnames, &parser)) {
        return NULL;
    }
    PyObject *arg_self;
    if (likely(Py_TYPE(obj_self) == CPyType_SuspiciousDuplicateAccentPlugin))
        arg_self = obj_self;
    else {
        CPy_TypeError("charset_normalizer.md.SuspiciousDuplicateAccentPlugin", obj_self); 
        goto fail;
    }
    char retval = CPyDef_SuspiciousDuplicateAccentPlugin___reset(arg_self);
    if (retval == 2) {
        return NULL;
    }
    PyObject *retbox = Py_None;
    CPy_INCREF(retbox);
    return retbox;
fail: ;
    CPy_AddTraceback("src/charset_normalizer/md.py", "reset", 189, CPyStatic_globals);
    return NULL;
}

double CPyDef_SuspiciousDuplicateAccentPlugin___ratio(PyObject *cpy_r_self) {
    CPyTagged cpy_r_r0;
    char cpy_r_r1;
    CPyTagged cpy_r_r2;
    CPyTagged cpy_r_r3;
    CPyTagged cpy_r_r4;
    double cpy_r_r5;
    char cpy_r_r6;
    PyObject *cpy_r_r7;
    double cpy_r_r8;
    cpy_r_r0 = ((charset_normalizer___md___SuspiciousDuplicateAccentPluginObject *)cpy_r_self)->__character_count;
    cpy_r_r1 = cpy_r_r0 == 0;
    if (!cpy_r_r1) goto CPyL2;
    return 0.0;
CPyL2: ;
    cpy_r_r2 = ((charset_normalizer___md___SuspiciousDuplicateAccentPluginObject *)cpy_r_self)->__successive_count;
    CPyTagged_INCREF(cpy_r_r2);
    cpy_r_r3 = CPyTagged_Multiply(cpy_r_r2, 4);
    CPyTagged_DECREF(cpy_r_r2);
    cpy_r_r4 = ((charset_normalizer___md___SuspiciousDuplicateAccentPluginObject *)cpy_r_self)->__character_count;
    CPyTagged_INCREF(cpy_r_r4);
    cpy_r_r5 = CPyTagged_TrueDivide(cpy_r_r3, cpy_r_r4);
    CPyTagged_DECREF(cpy_r_r3);
    CPyTagged_DECREF(cpy_r_r4);
    cpy_r_r6 = cpy_r_r5 == -113.0;
    if (unlikely(cpy_r_r6)) goto CPyL4;
CPyL3: ;
    return cpy_r_r5;
CPyL4: ;
    cpy_r_r7 = PyErr_Occurred();
    if (unlikely(cpy_r_r7 != NULL)) {
        CPy_AddTraceback("src/charset_normalizer/md.py", "ratio", 199, CPyStatic_globals);
    } else
        goto CPyL3;
    cpy_r_r8 = -113.0;
    return cpy_r_r8;
}

PyObject *CPyPy_SuspiciousDuplicateAccentPlugin___ratio(PyObject *self, PyObject *const *args, size_t nargs, PyObject *kwnames) {
    PyObject *obj_self = self;
    static const char * const kwlist[] = {0};
    static CPyArg_Parser parser = {":ratio", kwlist, 0};
    if (!CPyArg_ParseStackAndKeywordsNoArgs(args, nargs, kwnames, &parser)) {
        return NULL;
    }
    PyObject *arg_self;
    if (likely(Py_TYPE(obj_self) == CPyType_SuspiciousDuplicateAccentPlugin))
        arg_self = obj_self;
    else {
        CPy_TypeError("charset_normalizer.md.SuspiciousDuplicateAccentPlugin", obj_self); 
        goto fail;
    }
    double retval = CPyDef_SuspiciousDuplicateAccentPlugin___ratio(arg_self);
    if (retval == -113.0 && PyErr_Occurred()) {
        return NULL;
    }
    PyObject *retbox = PyFloat_FromDouble(retval);
    return retbox;
fail: ;
    CPy_AddTraceback("src/charset_normalizer/md.py", "ratio", 195, CPyStatic_globals);
    return NULL;
}

char CPyDef_SuspiciousRange_____init__(PyObject *cpy_r_self) {
    PyObject *cpy_r_r0;
    ((charset_normalizer___md___SuspiciousRangeObject *)cpy_r_self)->__suspicious_successive_range_count = 0;
    ((charset_normalizer___md___SuspiciousRangeObject *)cpy_r_self)->__character_count = 0;
    cpy_r_r0 = Py_None;
    ((charset_normalizer___md___SuspiciousRangeObject *)cpy_r_self)->__last_printable_seen = cpy_r_r0;
    return 1;
}

PyObject *CPyPy_SuspiciousRange_____init__(PyObject *self, PyObject *args, PyObject *kw) {
    PyObject *obj_self = self;
    static const char * const kwlist[] = {0};
    if (!CPyArg_ParseTupleAndKeywords(args, kw, "", "__init__", kwlist)) {
        return NULL;
    }
    PyObject *arg_self;
    if (likely(Py_TYPE(obj_self) == CPyType_SuspiciousRange))
        arg_self = obj_self;
    else {
        CPy_TypeError("charset_normalizer.md.SuspiciousRange", obj_self); 
        goto fail;
    }
    char retval = CPyDef_SuspiciousRange_____init__(arg_self);
    if (retval == 2) {
        return NULL;
    }
    PyObject *retbox = Py_None;
    CPy_INCREF(retbox);
    return retbox;
fail: ;
    CPy_AddTraceback("src/charset_normalizer/md.py", "__init__", 203, CPyStatic_globals);
    return NULL;
}

char CPyDef_SuspiciousRange___eligible(PyObject *cpy_r_self, PyObject *cpy_r_character) {
    PyObject *cpy_r_r0;
    PyObject **cpy_r_r2;
    PyObject *cpy_r_r3;
    char cpy_r_r4;
    char cpy_r_r5;
    cpy_r_r0 = CPyStatics[4]; /* 'isprintable' */
    PyObject *cpy_r_r1[1] = {cpy_r_character};
    cpy_r_r2 = (PyObject **)&cpy_r_r1;
    cpy_r_r3 = PyObject_VectorcallMethod(cpy_r_r0, cpy_r_r2, 9223372036854775809ULL, 0);
    if (unlikely(cpy_r_r3 == NULL)) {
        CPy_AddTraceback("src/charset_normalizer/md.py", "eligible", 209, CPyStatic_globals);
        goto CPyL3;
    }
    if (unlikely(!PyBool_Check(cpy_r_r3))) {
        CPy_TypeError("bool", cpy_r_r3); cpy_r_r4 = 2;
    } else
        cpy_r_r4 = cpy_r_r3 == Py_True;
    CPy_DECREF(cpy_r_r3);
    if (unlikely(cpy_r_r4 == 2)) {
        CPy_AddTraceback("src/charset_normalizer/md.py", "eligible", 209, CPyStatic_globals);
        goto CPyL3;
    }
    return cpy_r_r4;
CPyL3: ;
    cpy_r_r5 = 2;
    return cpy_r_r5;
}

PyObject *CPyPy_SuspiciousRange___eligible(PyObject *self, PyObject *const *args, size_t nargs, PyObject *kwnames) {
    PyObject *obj_self = self;
    static const char * const kwlist[] = {"character", 0};
    static CPyArg_Parser parser = {"O:eligible", kwlist, 0};
    PyObject *obj_character;
    if (!CPyArg_ParseStackAndKeywordsOneArg(args, nargs, kwnames, &parser, &obj_character)) {
        return NULL;
    }
    PyObject *arg_self;
    if (likely(Py_TYPE(obj_self) == CPyType_SuspiciousRange))
        arg_self = obj_self;
    else {
        CPy_TypeError("charset_normalizer.md.SuspiciousRange", obj_self); 
        goto fail;
    }
    PyObject *arg_character;
    if (likely(PyUnicode_Check(obj_character)))
        arg_character = obj_character;
    else {
        CPy_TypeError("str", obj_character); 
        goto fail;
    }
    char retval = CPyDef_SuspiciousRange___eligible(arg_self, arg_character);
    if (retval == 2) {
        return NULL;
    }
    PyObject *retbox = retval ? Py_True : Py_False;
    CPy_INCREF(retbox);
    return retbox;
fail: ;
    CPy_AddTraceback("src/charset_normalizer/md.py", "eligible", 208, CPyStatic_globals);
    return NULL;
}

char CPyDef_SuspiciousRange___feed(PyObject *cpy_r_self, PyObject *cpy_r_character) {
    CPyTagged cpy_r_r0;
    CPyTagged cpy_r_r1;
    char cpy_r_r2;
    PyObject *cpy_r_r3;
    PyObject **cpy_r_r5;
    PyObject *cpy_r_r6;
    char cpy_r_r7;
    PyObject *cpy_r_r8;
    PyObject *cpy_r_r9;
    PyObject *cpy_r_r10;
    PyObject **cpy_r_r12;
    PyObject *cpy_r_r13;
    char cpy_r_r14;
    PyObject *cpy_r_r15;
    PyObject *cpy_r_r16;
    PyObject *cpy_r_r17;
    PyObject *cpy_r_r18;
    int32_t cpy_r_r19;
    char cpy_r_r20;
    char cpy_r_r21;
    PyObject *cpy_r_r22;
    char cpy_r_r23;
    PyObject *cpy_r_r24;
    PyObject *cpy_r_r25;
    char cpy_r_r26;
    char cpy_r_r27;
    PyObject *cpy_r_r28;
    PyObject *cpy_r_r29;
    PyObject *cpy_r_r30;
    PyObject *cpy_r_r31;
    PyObject *cpy_r_r32;
    PyObject **cpy_r_r34;
    PyObject *cpy_r_r35;
    PyObject *cpy_r_r36;
    PyObject *cpy_r_r37;
    PyObject *cpy_r_r38;
    PyObject *cpy_r_r39;
    PyObject **cpy_r_r41;
    PyObject *cpy_r_r42;
    PyObject *cpy_r_r43;
    PyObject *cpy_r_r44;
    PyObject *cpy_r_r45;
    PyObject *cpy_r_r46;
    PyObject **cpy_r_r48;
    PyObject *cpy_r_r49;
    char cpy_r_r50;
    CPyTagged cpy_r_r51;
    CPyTagged cpy_r_r52;
    char cpy_r_r53;
    char cpy_r_r54;
    char cpy_r_r55;
    cpy_r_r0 = ((charset_normalizer___md___SuspiciousRangeObject *)cpy_r_self)->__character_count;
    cpy_r_r1 = CPyTagged_Add(cpy_r_r0, 2);
    CPyTagged_DECREF(((charset_normalizer___md___SuspiciousRangeObject *)cpy_r_self)->__character_count);
    ((charset_normalizer___md___SuspiciousRangeObject *)cpy_r_self)->__character_count = cpy_r_r1;
    cpy_r_r3 = CPyStatics[16]; /* 'isspace' */
    PyObject *cpy_r_r4[1] = {cpy_r_character};
    cpy_r_r5 = (PyObject **)&cpy_r_r4;
    cpy_r_r6 = PyObject_VectorcallMethod(cpy_r_r3, cpy_r_r5, 9223372036854775809ULL, 0);
    if (unlikely(cpy_r_r6 == NULL)) {
        CPy_AddTraceback("src/charset_normalizer/md.py", "feed", 215, CPyStatic_globals);
        goto CPyL27;
    }
    if (unlikely(!PyBool_Check(cpy_r_r6))) {
        CPy_TypeError("bool", cpy_r_r6); cpy_r_r7 = 2;
    } else
        cpy_r_r7 = cpy_r_r6 == Py_True;
    CPy_DECREF(cpy_r_r6);
    if (unlikely(cpy_r_r7 == 2)) {
        CPy_AddTraceback("src/charset_normalizer/md.py", "feed", 215, CPyStatic_globals);
        goto CPyL27;
    }
    if (cpy_r_r7) goto CPyL11;
    cpy_r_r8 = CPyStatic_globals;
    cpy_r_r9 = CPyStatics[6]; /* 'is_punctuation' */
    cpy_r_r10 = CPyDict_GetItem(cpy_r_r8, cpy_r_r9);
    if (unlikely(cpy_r_r10 == NULL)) {
        CPy_AddTraceback("src/charset_normalizer/md.py", "feed", 216, CPyStatic_globals);
        goto CPyL27;
    }
    PyObject *cpy_r_r11[1] = {cpy_r_character};
    cpy_r_r12 = (PyObject **)&cpy_r_r11;
    cpy_r_r13 = PyObject_Vectorcall(cpy_r_r10, cpy_r_r12, 1, 0);
    CPy_DECREF(cpy_r_r10);
    if (unlikely(cpy_r_r13 == NULL)) {
        CPy_AddTraceback("src/charset_normalizer/md.py", "feed", 216, CPyStatic_globals);
        goto CPyL27;
    }
    if (unlikely(!PyBool_Check(cpy_r_r13))) {
        CPy_TypeError("bool", cpy_r_r13); cpy_r_r14 = 2;
    } else
        cpy_r_r14 = cpy_r_r13 == Py_True;
    CPy_DECREF(cpy_r_r13);
    if (unlikely(cpy_r_r14 == 2)) {
        CPy_AddTraceback("src/charset_normalizer/md.py", "feed", 216, CPyStatic_globals);
        goto CPyL27;
    }
    if (cpy_r_r14) goto CPyL11;
    cpy_r_r15 = CPyStatic_globals;
    cpy_r_r16 = CPyStatics[5]; /* 'COMMON_SAFE_ASCII_CHARACTERS' */
    cpy_r_r17 = CPyDict_GetItem(cpy_r_r15, cpy_r_r16);
    if (unlikely(cpy_r_r17 == NULL)) {
        CPy_AddTraceback("src/charset_normalizer/md.py", "feed", 217, CPyStatic_globals);
        goto CPyL27;
    }
    if (likely(PySet_Check(cpy_r_r17)))
        cpy_r_r18 = cpy_r_r17;
    else {
        CPy_TypeErrorTraceback("src/charset_normalizer/md.py", "feed", 217, CPyStatic_globals, "set", cpy_r_r17);
        goto CPyL27;
    }
    cpy_r_r19 = PySet_Contains(cpy_r_r18, cpy_r_character);
    CPy_DECREF(cpy_r_r18);
    cpy_r_r20 = cpy_r_r19 >= 0;
    if (unlikely(!cpy_r_r20)) {
        CPy_AddTraceback("src/charset_normalizer/md.py", "feed", 217, CPyStatic_globals);
        goto CPyL27;
    }
    cpy_r_r21 = cpy_r_r19;
    if (!cpy_r_r21) goto CPyL12;
CPyL11: ;
    cpy_r_r22 = Py_None;
    CPy_DECREF(((charset_normalizer___md___SuspiciousRangeObject *)cpy_r_self)->__last_printable_seen);
    ((charset_normalizer___md___SuspiciousRangeObject *)cpy_r_self)->__last_printable_seen = cpy_r_r22;
    return 1;
CPyL12: ;
    cpy_r_r24 = ((charset_normalizer___md___SuspiciousRangeObject *)cpy_r_self)->__last_printable_seen;
    cpy_r_r25 = (PyObject *)&_Py_NoneStruct;
    cpy_r_r26 = cpy_r_r24 == cpy_r_r25;
    if (!cpy_r_r26) goto CPyL14;
    CPy_INCREF(cpy_r_character);
    CPy_DECREF(((charset_normalizer___md___SuspiciousRangeObject *)cpy_r_self)->__last_printable_seen);
    ((charset_normalizer___md___SuspiciousRangeObject *)cpy_r_self)->__last_printable_seen = cpy_r_character;
    return 1;
CPyL14: ;
    cpy_r_r28 = ((charset_normalizer___md___SuspiciousRangeObject *)cpy_r_self)->__last_printable_seen;
    CPy_INCREF(cpy_r_r28);
    if (likely(cpy_r_r28 != Py_None))
        cpy_r_r29 = cpy_r_r28;
    else {
        CPy_TypeErrorTraceback("src/charset_normalizer/md.py", "feed", 226, CPyStatic_globals, "str", cpy_r_r28);
        goto CPyL27;
    }
    cpy_r_r30 = CPyStatic_globals;
    cpy_r_r31 = CPyStatics[17]; /* 'unicode_range' */
    cpy_r_r32 = CPyDict_GetItem(cpy_r_r30, cpy_r_r31);
    if (unlikely(cpy_r_r32 == NULL)) {
        CPy_AddTraceback("src/charset_normalizer/md.py", "feed", 226, CPyStatic_globals);
        goto CPyL28;
    }
    PyObject *cpy_r_r33[1] = {cpy_r_r29};
    cpy_r_r34 = (PyObject **)&cpy_r_r33;
    cpy_r_r35 = PyObject_Vectorcall(cpy_r_r32, cpy_r_r34, 1, 0);
    CPy_DECREF(cpy_r_r32);
    if (unlikely(cpy_r_r35 == NULL)) {
        CPy_AddTraceback("src/charset_normalizer/md.py", "feed", 226, CPyStatic_globals);
        goto CPyL28;
    }
    CPy_DECREF(cpy_r_r29);
    if (PyUnicode_Check(cpy_r_r35))
        cpy_r_r36 = cpy_r_r35;
    else {
        cpy_r_r36 = NULL;
    }
    if (cpy_r_r36 != NULL) goto __LL5;
    if (cpy_r_r35 == Py_None)
        cpy_r_r36 = cpy_r_r35;
    else {
        cpy_r_r36 = NULL;
    }
    if (cpy_r_r36 != NULL) goto __LL5;
    CPy_TypeErrorTraceback("src/charset_normalizer/md.py", "feed", 226, CPyStatic_globals, "str or None", cpy_r_r35);
    goto CPyL27;
__LL5: ;
    cpy_r_r37 = CPyStatic_globals;
    cpy_r_r38 = CPyStatics[17]; /* 'unicode_range' */
    cpy_r_r39 = CPyDict_GetItem(cpy_r_r37, cpy_r_r38);
    if (unlikely(cpy_r_r39 == NULL)) {
        CPy_AddTraceback("src/charset_normalizer/md.py", "feed", 227, CPyStatic_globals);
        goto CPyL29;
    }
    PyObject *cpy_r_r40[1] = {cpy_r_character};
    cpy_r_r41 = (PyObject **)&cpy_r_r40;
    cpy_r_r42 = PyObject_Vectorcall(cpy_r_r39, cpy_r_r41, 1, 0);
    CPy_DECREF(cpy_r_r39);
    if (unlikely(cpy_r_r42 == NULL)) {
        CPy_AddTraceback("src/charset_normalizer/md.py", "feed", 227, CPyStatic_globals);
        goto CPyL29;
    }
    if (PyUnicode_Check(cpy_r_r42))
        cpy_r_r43 = cpy_r_r42;
    else {
        cpy_r_r43 = NULL;
    }
    if (cpy_r_r43 != NULL) goto __LL6;
    if (cpy_r_r42 == Py_None)
        cpy_r_r43 = cpy_r_r42;
    else {
        cpy_r_r43 = NULL;
    }
    if (cpy_r_r43 != NULL) goto __LL6;
    CPy_TypeErrorTraceback("src/charset_normalizer/md.py", "feed", 227, CPyStatic_globals, "str or None", cpy_r_r42);
    goto CPyL29;
__LL6: ;
    cpy_r_r44 = CPyStatic_globals;
    cpy_r_r45 = CPyStatics[18]; /* 'is_suspiciously_successive_range' */
    cpy_r_r46 = CPyDict_GetItem(cpy_r_r44, cpy_r_r45);
    if (unlikely(cpy_r_r46 == NULL)) {
        CPy_AddTraceback("src/charset_normalizer/md.py", "feed", 229, CPyStatic_globals);
        goto CPyL30;
    }
    PyObject *cpy_r_r47[2] = {cpy_r_r36, cpy_r_r43};
    cpy_r_r48 = (PyObject **)&cpy_r_r47;
    cpy_r_r49 = PyObject_Vectorcall(cpy_r_r46, cpy_r_r48, 2, 0);
    CPy_DECREF(cpy_r_r46);
    if (unlikely(cpy_r_r49 == NULL)) {
        CPy_AddTraceback("src/charset_normalizer/md.py", "feed", 229, CPyStatic_globals);
        goto CPyL30;
    }
    CPy_DECREF(cpy_r_r36);
    CPy_DECREF(cpy_r_r43);
    if (unlikely(!PyBool_Check(cpy_r_r49))) {
        CPy_TypeError("bool", cpy_r_r49); cpy_r_r50 = 2;
    } else
        cpy_r_r50 = cpy_r_r49 == Py_True;
    CPy_DECREF(cpy_r_r49);
    if (unlikely(cpy_r_r50 == 2)) {
        CPy_AddTraceback("src/charset_normalizer/md.py", "feed", 229, CPyStatic_globals);
        goto CPyL27;
    }
    if (!cpy_r_r50) goto CPyL26;
    cpy_r_r51 = ((charset_normalizer___md___SuspiciousRangeObject *)cpy_r_self)->__suspicious_successive_range_count;
    cpy_r_r52 = CPyTagged_Add(cpy_r_r51, 2);
    CPyTagged_DECREF(((charset_normalizer___md___SuspiciousRangeObject *)cpy_r_self)->__suspicious_successive_range_count);
    ((charset_normalizer___md___SuspiciousRangeObject *)cpy_r_self)->__suspicious_successive_range_count = cpy_r_r52;
CPyL26: ;
    CPy_INCREF(cpy_r_character);
    CPy_DECREF(((charset_normalizer___md___SuspiciousRangeObject *)cpy_r_self)->__last_printable_seen);
    ((charset_normalizer___md___SuspiciousRangeObject *)cpy_r_self)->__last_printable_seen = cpy_r_character;
    return 1;
CPyL27: ;
    cpy_r_r55 = 2;
    return cpy_r_r55;
CPyL28: ;
    CPy_DecRef(cpy_r_r29);
    goto CPyL27;
CPyL29: ;
    CPy_DecRef(cpy_r_r36);
    goto CPyL27;
CPyL30: ;
    CPy_DecRef(cpy_r_r36);
    CPy_DecRef(cpy_r_r43);
    goto CPyL27;
}

PyObject *CPyPy_SuspiciousRange___feed(PyObject *self, PyObject *const *args, size_t nargs, PyObject *kwnames) {
    PyObject *obj_self = self;
    static const char * const kwlist[] = {"character", 0};
    static CPyArg_Parser parser = {"O:feed", kwlist, 0};
    PyObject *obj_character;
    if (!CPyArg_ParseStackAndKeywordsOneArg(args, nargs, kwnames, &parser, &obj_character)) {
        return NULL;
    }
    PyObject *arg_self;
    if (likely(Py_TYPE(obj_self) == CPyType_SuspiciousRange))
        arg_self = obj_self;
    else {
        CPy_TypeError("charset_normalizer.md.SuspiciousRange", obj_self); 
        goto fail;
    }
    PyObject *arg_character;
    if (likely(PyUnicode_Check(obj_character)))
        arg_character = obj_character;
    else {
        CPy_TypeError("str", obj_character); 
        goto fail;
    }
    char retval = CPyDef_SuspiciousRange___feed(arg_self, arg_character);
    if (retval == 2) {
        return NULL;
    }
    PyObject *retbox = Py_None;
    CPy_INCREF(retbox);
    return retbox;
fail: ;
    CPy_AddTraceback("src/charset_normalizer/md.py", "feed", 211, CPyStatic_globals);
    return NULL;
}

char CPyDef_SuspiciousRange___reset(PyObject *cpy_r_self) {
    char cpy_r_r0;
    char cpy_r_r1;
    PyObject *cpy_r_r2;
    char cpy_r_r3;
    CPyTagged_DECREF(((charset_normalizer___md___SuspiciousRangeObject *)cpy_r_self)->__character_count);
    ((charset_normalizer___md___SuspiciousRangeObject *)cpy_r_self)->__character_count = 0;
    CPyTagged_DECREF(((charset_normalizer___md___SuspiciousRangeObject *)cpy_r_self)->__suspicious_successive_range_count);
    ((charset_normalizer___md___SuspiciousRangeObject *)cpy_r_self)->__suspicious_successive_range_count = 0;
    cpy_r_r2 = Py_None;
    CPy_DECREF(((charset_normalizer___md___SuspiciousRangeObject *)cpy_r_self)->__last_printable_seen);
    ((charset_normalizer___md___SuspiciousRangeObject *)cpy_r_self)->__last_printable_seen = cpy_r_r2;
    return 1;
}

PyObject *CPyPy_SuspiciousRange___reset(PyObject *self, PyObject *const *args, size_t nargs, PyObject *kwnames) {
    PyObject *obj_self = self;
    static const char * const kwlist[] = {0};
    static CPyArg_Parser parser = {":reset", kwlist, 0};
    if (!CPyArg_ParseStackAndKeywordsNoArgs(args, nargs, kwnames, &parser)) {
        return NULL;
    }
    PyObject *arg_self;
    if (likely(Py_TYPE(obj_self) == CPyType_SuspiciousRange))
        arg_self = obj_self;
    else {
        CPy_TypeError("charset_normalizer.md.SuspiciousRange", obj_self); 
        goto fail;
    }
    char retval = CPyDef_SuspiciousRange___reset(arg_self);
    if (retval == 2) {
        return NULL;
    }
    PyObject *retbox = Py_None;
    CPy_INCREF(retbox);
    return retbox;
fail: ;
    CPy_AddTraceback("src/charset_normalizer/md.py", "reset", 234, CPyStatic_globals);
    return NULL;
}

double CPyDef_SuspiciousRange___ratio(PyObject *cpy_r_self) {
    CPyTagged cpy_r_r0;
    int64_t cpy_r_r1;
    char cpy_r_r2;
    int64_t cpy_r_r3;
    char cpy_r_r4;
    char cpy_r_r5;
    char cpy_r_r6;
    char cpy_r_r7;
    CPyTagged cpy_r_r8;
    CPyTagged cpy_r_r9;
    CPyTagged cpy_r_r10;
    double cpy_r_r11;
    char cpy_r_r12;
    PyObject *cpy_r_r13;
    double cpy_r_r14;
    cpy_r_r0 = ((charset_normalizer___md___SuspiciousRangeObject *)cpy_r_self)->__character_count;
    cpy_r_r1 = cpy_r_r0 & 1;
    cpy_r_r2 = cpy_r_r1 != 0;
    if (cpy_r_r2) goto CPyL2;
    cpy_r_r3 = 26 & 1;
    cpy_r_r4 = cpy_r_r3 != 0;
    if (!cpy_r_r4) goto CPyL3;
CPyL2: ;
    cpy_r_r5 = CPyTagged_IsLt_(26, cpy_r_r0);
    cpy_r_r6 = cpy_r_r5 ^ 1;
    if (cpy_r_r6) {
        goto CPyL4;
    } else
        goto CPyL5;
CPyL3: ;
    cpy_r_r7 = (Py_ssize_t)cpy_r_r0 <= (Py_ssize_t)26;
    if (!cpy_r_r7) goto CPyL5;
CPyL4: ;
    return 0.0;
CPyL5: ;
    cpy_r_r8 = ((charset_normalizer___md___SuspiciousRangeObject *)cpy_r_self)->__suspicious_successive_range_count;
    CPyTagged_INCREF(cpy_r_r8);
    cpy_r_r9 = CPyTagged_Multiply(cpy_r_r8, 4);
    CPyTagged_DECREF(cpy_r_r8);
    cpy_r_r10 = ((charset_normalizer___md___SuspiciousRangeObject *)cpy_r_self)->__character_count;
    CPyTagged_INCREF(cpy_r_r10);
    cpy_r_r11 = CPyTagged_TrueDivide(cpy_r_r9, cpy_r_r10);
    CPyTagged_DECREF(cpy_r_r9);
    CPyTagged_DECREF(cpy_r_r10);
    cpy_r_r12 = cpy_r_r11 == -113.0;
    if (unlikely(cpy_r_r12)) goto CPyL7;
CPyL6: ;
    return cpy_r_r11;
CPyL7: ;
    cpy_r_r13 = PyErr_Occurred();
    if (unlikely(cpy_r_r13 != NULL)) {
        CPy_AddTraceback("src/charset_normalizer/md.py", "ratio", 244, CPyStatic_globals);
    } else
        goto CPyL6;
    cpy_r_r14 = -113.0;
    return cpy_r_r14;
}

PyObject *CPyPy_SuspiciousRange___ratio(PyObject *self, PyObject *const *args, size_t nargs, PyObject *kwnames) {
    PyObject *obj_self = self;
    static const char * const kwlist[] = {0};
    static CPyArg_Parser parser = {":ratio", kwlist, 0};
    if (!CPyArg_ParseStackAndKeywordsNoArgs(args, nargs, kwnames, &parser)) {
        return NULL;
    }
    PyObject *arg_self;
    if (likely(Py_TYPE(obj_self) == CPyType_SuspiciousRange))
        arg_self = obj_self;
    else {
        CPy_TypeError("charset_normalizer.md.SuspiciousRange", obj_self); 
        goto fail;
    }
    double retval = CPyDef_SuspiciousRange___ratio(arg_self);
    if (retval == -113.0 && PyErr_Occurred()) {
        return NULL;
    }
    PyObject *retbox = PyFloat_FromDouble(retval);
    return retbox;
fail: ;
    CPy_AddTraceback("src/charset_normalizer/md.py", "ratio", 240, CPyStatic_globals);
    return NULL;
}

char CPyDef_SuperWeirdWordPlugin_____init__(PyObject *cpy_r_self) {
    PyObject *cpy_r_r0;
    ((charset_normalizer___md___SuperWeirdWordPluginObject *)cpy_r_self)->__word_count = 0;
    ((charset_normalizer___md___SuperWeirdWordPluginObject *)cpy_r_self)->__bad_word_count = 0;
    ((charset_normalizer___md___SuperWeirdWordPluginObject *)cpy_r_self)->__foreign_long_count = 0;
    ((charset_normalizer___md___SuperWeirdWordPluginObject *)cpy_r_self)->__is_current_word_bad = 0;
    ((charset_normalizer___md___SuperWeirdWordPluginObject *)cpy_r_self)->__foreign_long_watch = 0;
    ((charset_normalizer___md___SuperWeirdWordPluginObject *)cpy_r_self)->__character_count = 0;
    ((charset_normalizer___md___SuperWeirdWordPluginObject *)cpy_r_self)->__bad_character_count = 0;
    cpy_r_r0 = CPyStatics[19]; /* '' */
    CPy_INCREF(cpy_r_r0);
    ((charset_normalizer___md___SuperWeirdWordPluginObject *)cpy_r_self)->__buffer = cpy_r_r0;
    ((charset_normalizer___md___SuperWeirdWordPluginObject *)cpy_r_self)->__buffer_accent_count = 0;
    ((charset_normalizer___md___SuperWeirdWordPluginObject *)cpy_r_self)->__buffer_glyph_count = 0;
    return 1;
}

PyObject *CPyPy_SuperWeirdWordPlugin_____init__(PyObject *self, PyObject *args, PyObject *kw) {
    PyObject *obj_self = self;
    static const char * const kwlist[] = {0};
    if (!CPyArg_ParseTupleAndKeywords(args, kw, "", "__init__", kwlist)) {
        return NULL;
    }
    PyObject *arg_self;
    if (likely(Py_TYPE(obj_self) == CPyType_SuperWeirdWordPlugin))
        arg_self = obj_self;
    else {
        CPy_TypeError("charset_normalizer.md.SuperWeirdWordPlugin", obj_self); 
        goto fail;
    }
    char retval = CPyDef_SuperWeirdWordPlugin_____init__(arg_self);
    if (retval == 2) {
        return NULL;
    }
    PyObject *retbox = Py_None;
    CPy_INCREF(retbox);
    return retbox;
fail: ;
    CPy_AddTraceback("src/charset_normalizer/md.py", "__init__", 252, CPyStatic_globals);
    return NULL;
}

char CPyDef_SuperWeirdWordPlugin___eligible(PyObject *cpy_r_self, PyObject *cpy_r_character) {
    return 1;
}

PyObject *CPyPy_SuperWeirdWordPlugin___eligible(PyObject *self, PyObject *const *args, size_t nargs, PyObject *kwnames) {
    PyObject *obj_self = self;
    static const char * const kwlist[] = {"character", 0};
    static CPyArg_Parser parser = {"O:eligible", kwlist, 0};
    PyObject *obj_character;
    if (!CPyArg_ParseStackAndKeywordsOneArg(args, nargs, kwnames, &parser, &obj_character)) {
        return NULL;
    }
    PyObject *arg_self;
    if (likely(Py_TYPE(obj_self) == CPyType_SuperWeirdWordPlugin))
        arg_self = obj_self;
    else {
        CPy_TypeError("charset_normalizer.md.SuperWeirdWordPlugin", obj_self); 
        goto fail;
    }
    PyObject *arg_character;
    if (likely(PyUnicode_Check(obj_character)))
        arg_character = obj_character;
    else {
        CPy_TypeError("str", obj_character); 
        goto fail;
    }
    char retval = CPyDef_SuperWeirdWordPlugin___eligible(arg_self, arg_character);
    if (retval == 2) {
        return NULL;
    }
    PyObject *retbox = retval ? Py_True : Py_False;
    CPy_INCREF(retbox);
    return retbox;
fail: ;
    CPy_AddTraceback("src/charset_normalizer/md.py", "eligible", 267, CPyStatic_globals);
    return NULL;
}

char CPyDef_SuperWeirdWordPlugin___feed(PyObject *cpy_r_self, PyObject *cpy_r_character) {
    PyObject *cpy_r_r0;
    PyObject **cpy_r_r2;
    PyObject *cpy_r_r3;
    char cpy_r_r4;
    PyObject *cpy_r_r5;
    PyObject *cpy_r_r6;
    char cpy_r_r7;
    PyObject *cpy_r_r8;
    PyObject *cpy_r_r9;
    PyObject *cpy_r_r10;
    PyObject **cpy_r_r12;
    PyObject *cpy_r_r13;
    char cpy_r_r14;
    CPyTagged cpy_r_r15;
    CPyTagged cpy_r_r16;
    char cpy_r_r17;
    char cpy_r_r18;
    PyObject *cpy_r_r19;
    PyObject *cpy_r_r20;
    char cpy_r_r21;
    PyObject *cpy_r_r22;
    PyObject *cpy_r_r23;
    PyObject *cpy_r_r24;
    PyObject **cpy_r_r26;
    PyObject *cpy_r_r27;
    char cpy_r_r28;
    PyObject *cpy_r_r29;
    PyObject *cpy_r_r30;
    char cpy_r_r31;
    PyObject *cpy_r_r32;
    PyObject *cpy_r_r33;
    PyObject *cpy_r_r34;
    PyObject **cpy_r_r36;
    PyObject *cpy_r_r37;
    char cpy_r_r38;
    PyObject *cpy_r_r39;
    PyObject *cpy_r_r40;
    PyObject *cpy_r_r41;
    PyObject **cpy_r_r43;
    PyObject *cpy_r_r44;
    char cpy_r_r45;
    PyObject *cpy_r_r46;
    PyObject *cpy_r_r47;
    char cpy_r_r48;
    PyObject *cpy_r_r49;
    PyObject *cpy_r_r50;
    PyObject *cpy_r_r51;
    PyObject **cpy_r_r53;
    PyObject *cpy_r_r54;
    char cpy_r_r55;
    PyObject *cpy_r_r56;
    PyObject *cpy_r_r57;
    char cpy_r_r58;
    PyObject *cpy_r_r59;
    PyObject *cpy_r_r60;
    PyObject *cpy_r_r61;
    PyObject **cpy_r_r63;
    PyObject *cpy_r_r64;
    char cpy_r_r65;
    PyObject *cpy_r_r66;
    PyObject *cpy_r_r67;
    char cpy_r_r68;
    PyObject *cpy_r_r69;
    PyObject *cpy_r_r70;
    PyObject *cpy_r_r71;
    PyObject **cpy_r_r73;
    PyObject *cpy_r_r74;
    char cpy_r_r75;
    PyObject *cpy_r_r76;
    PyObject *cpy_r_r77;
    char cpy_r_r78;
    PyObject *cpy_r_r79;
    PyObject *cpy_r_r80;
    PyObject *cpy_r_r81;
    PyObject **cpy_r_r83;
    PyObject *cpy_r_r84;
    char cpy_r_r85;
    PyObject *cpy_r_r86;
    PyObject *cpy_r_r87;
    char cpy_r_r88;
    char cpy_r_r89;
    PyObject *cpy_r_r90;
    PyObject *cpy_r_r91;
    PyObject *cpy_r_r92;
    PyObject **cpy_r_r94;
    PyObject *cpy_r_r95;
    char cpy_r_r96;
    PyObject *cpy_r_r97;
    PyObject *cpy_r_r98;
    PyObject *cpy_r_r99;
    PyObject **cpy_r_r101;
    PyObject *cpy_r_r102;
    char cpy_r_r103;
    PyObject *cpy_r_r104;
    PyObject *cpy_r_r105;
    PyObject *cpy_r_r106;
    PyObject **cpy_r_r108;
    PyObject *cpy_r_r109;
    char cpy_r_r110;
    PyObject *cpy_r_r111;
    PyObject *cpy_r_r112;
    PyObject *cpy_r_r113;
    PyObject **cpy_r_r115;
    PyObject *cpy_r_r116;
    char cpy_r_r117;
    PyObject *cpy_r_r118;
    PyObject *cpy_r_r119;
    PyObject *cpy_r_r120;
    PyObject **cpy_r_r122;
    PyObject *cpy_r_r123;
    char cpy_r_r124;
    CPyTagged cpy_r_r125;
    CPyTagged cpy_r_r126;
    char cpy_r_r127;
    PyObject *cpy_r_r128;
    char cpy_r_r129;
    PyObject *cpy_r_r130;
    PyObject **cpy_r_r132;
    PyObject *cpy_r_r133;
    char cpy_r_r134;
    PyObject *cpy_r_r135;
    PyObject *cpy_r_r136;
    PyObject *cpy_r_r137;
    PyObject **cpy_r_r139;
    PyObject *cpy_r_r140;
    char cpy_r_r141;
    PyObject *cpy_r_r142;
    PyObject *cpy_r_r143;
    PyObject *cpy_r_r144;
    PyObject **cpy_r_r146;
    PyObject *cpy_r_r147;
    char cpy_r_r148;
    PyObject *cpy_r_r149;
    char cpy_r_r150;
    CPyTagged cpy_r_r151;
    CPyTagged cpy_r_r152;
    char cpy_r_r153;
    PyObject *cpy_r_r154;
    int64_t cpy_r_r155;
    char cpy_r_r156;
    CPyTagged cpy_r_r157;
    CPyTagged cpy_r_buffer_length;
    CPyTagged cpy_r_r158;
    CPyTagged cpy_r_r159;
    char cpy_r_r160;
    int64_t cpy_r_r161;
    char cpy_r_r162;
    int64_t cpy_r_r163;
    char cpy_r_r164;
    char cpy_r_r165;
    char cpy_r_r166;
    char cpy_r_r167;
    CPyTagged cpy_r_r168;
    double cpy_r_r169;
    char cpy_r_r170;
    char cpy_r_r171;
    PyObject *cpy_r_r172;
    char cpy_r_r173;
    PyObject *cpy_r_r174;
    PyObject *cpy_r_r175;
    PyObject *cpy_r_r176;
    PyObject *cpy_r_r177;
    PyObject *cpy_r_r178;
    PyObject **cpy_r_r180;
    PyObject *cpy_r_r181;
    char cpy_r_r182;
    PyObject *cpy_r_r183;
    PyObject *cpy_r_r184;
    PyObject *cpy_r_r185;
    PyObject **cpy_r_r187;
    PyObject *cpy_r_r188;
    char cpy_r_r189;
    char cpy_r_r190;
    PyObject *cpy_r_r191;
    int64_t cpy_r_r192;
    char cpy_r_r193;
    int64_t cpy_r_r194;
    char cpy_r_r195;
    PyObject *cpy_r_r196;
    PyObject *cpy_r__;
    PyObject *cpy_r_r197;
    PyObject *cpy_r_r198;
    PyObject **cpy_r_r200;
    PyObject *cpy_r_r201;
    char cpy_r_r202;
    char cpy_r_r203;
    int64_t cpy_r_r204;
    PyObject *cpy_r_r205;
    PyObject *cpy_r_r206;
    char cpy_r_r207;
    CPyTagged cpy_r_r208;
    CPyTagged cpy_r_r209;
    char cpy_r_r210;
    char cpy_r_r211;
    CPyTagged cpy_r_r212;
    char cpy_r_r213;
    char cpy_r_r214;
    CPyTagged cpy_r_r215;
    CPyTagged cpy_r_r216;
    char cpy_r_r217;
    int64_t cpy_r_r218;
    char cpy_r_r219;
    int64_t cpy_r_r220;
    char cpy_r_r221;
    char cpy_r_r222;
    char cpy_r_r223;
    char cpy_r_r224;
    char cpy_r_r225;
    PyObject *cpy_r_r226;
    PyObject *cpy_r_r227;
    int64_t cpy_r_r228;
    char cpy_r_r229;
    int64_t cpy_r_r230;
    CPyTagged cpy_r_r231;
    CPyTagged cpy_r_i;
    char cpy_r_r232;
    int64_t cpy_r_r233;
    char cpy_r_r234;
    int64_t cpy_r_r235;
    char cpy_r_r236;
    char cpy_r_r237;
    char cpy_r_r238;
    PyObject *cpy_r_r239;
    PyObject *cpy_r_r240;
    PyObject **cpy_r_r242;
    PyObject *cpy_r_r243;
    char cpy_r_r244;
    PyObject *cpy_r_r245;
    int32_t cpy_r_r246;
    char cpy_r_r247;
    int64_t cpy_r_r248;
    CPyTagged cpy_r_r249;
    char cpy_r_probable_camel_cased;
    CPyPtr cpy_r_r250;
    int64_t cpy_r_r251;
    CPyTagged cpy_r_r252;
    char cpy_r_r253;
    CPyPtr cpy_r_r254;
    int64_t cpy_r_r255;
    CPyTagged cpy_r_r256;
    double cpy_r_r257;
    char cpy_r_r258;
    char cpy_r_r259;
    PyObject *cpy_r_r260;
    CPyTagged cpy_r_r261;
    CPyTagged cpy_r_r262;
    char cpy_r_r263;
    char cpy_r_r264;
    char cpy_r_r265;
    CPyTagged cpy_r_r266;
    CPyTagged cpy_r_r267;
    char cpy_r_r268;
    CPyTagged cpy_r_r269;
    PyObject *cpy_r_r270;
    int64_t cpy_r_r271;
    char cpy_r_r272;
    CPyTagged cpy_r_r273;
    CPyTagged cpy_r_r274;
    char cpy_r_r275;
    char cpy_r_r276;
    char cpy_r_r277;
    PyObject *cpy_r_r278;
    char cpy_r_r279;
    char cpy_r_r280;
    char cpy_r_r281;
    PyObject *cpy_r_r282;
    int32_t cpy_r_r283;
    char cpy_r_r284;
    char cpy_r_r285;
    char cpy_r_r286;
    PyObject *cpy_r_r287;
    PyObject **cpy_r_r289;
    PyObject *cpy_r_r290;
    char cpy_r_r291;
    PyObject *cpy_r_r292;
    PyObject *cpy_r_r293;
    char cpy_r_r294;
    PyObject *cpy_r_r295;
    PyObject *cpy_r_r296;
    PyObject *cpy_r_r297;
    PyObject **cpy_r_r299;
    PyObject *cpy_r_r300;
    char cpy_r_r301;
    char cpy_r_r302;
    PyObject *cpy_r_r303;
    PyObject *cpy_r_r304;
    char cpy_r_r305;
    char cpy_r_r306;
    cpy_r_r0 = CPyStatics[10]; /* 'isalpha' */
    PyObject *cpy_r_r1[1] = {cpy_r_character};
    cpy_r_r2 = (PyObject **)&cpy_r_r1;
    cpy_r_r3 = PyObject_VectorcallMethod(cpy_r_r0, cpy_r_r2, 9223372036854775809ULL, 0);
    if (unlikely(cpy_r_r3 == NULL)) {
        CPy_AddTraceback("src/charset_normalizer/md.py", "feed", 271, CPyStatic_globals);
        goto CPyL149;
    }
    if (unlikely(!PyBool_Check(cpy_r_r3))) {
        CPy_TypeError("bool", cpy_r_r3); cpy_r_r4 = 2;
    } else
        cpy_r_r4 = cpy_r_r3 == Py_True;
    CPy_DECREF(cpy_r_r3);
    if (unlikely(cpy_r_r4 == 2)) {
        CPy_AddTraceback("src/charset_normalizer/md.py", "feed", 271, CPyStatic_globals);
        goto CPyL149;
    }
    if (!cpy_r_r4) goto CPyL61;
    cpy_r_r5 = ((charset_normalizer___md___SuperWeirdWordPluginObject *)cpy_r_self)->__buffer;
    CPy_INCREF(cpy_r_r5);
    cpy_r_r6 = CPyStr_Append(cpy_r_r5, cpy_r_character);
    if (unlikely(cpy_r_r6 == NULL)) {
        CPy_AddTraceback("src/charset_normalizer/md.py", "feed", 272, CPyStatic_globals);
        goto CPyL149;
    }
    CPy_DECREF(((charset_normalizer___md___SuperWeirdWordPluginObject *)cpy_r_self)->__buffer);
    ((charset_normalizer___md___SuperWeirdWordPluginObject *)cpy_r_self)->__buffer = cpy_r_r6;
    cpy_r_r8 = CPyStatic_globals;
    cpy_r_r9 = CPyStatics[11]; /* 'is_accentuated' */
    cpy_r_r10 = CPyDict_GetItem(cpy_r_r8, cpy_r_r9);
    if (unlikely(cpy_r_r10 == NULL)) {
        CPy_AddTraceback("src/charset_normalizer/md.py", "feed", 273, CPyStatic_globals);
        goto CPyL149;
    }
    PyObject *cpy_r_r11[1] = {cpy_r_character};
    cpy_r_r12 = (PyObject **)&cpy_r_r11;
    cpy_r_r13 = PyObject_Vectorcall(cpy_r_r10, cpy_r_r12, 1, 0);
    CPy_DECREF(cpy_r_r10);
    if (unlikely(cpy_r_r13 == NULL)) {
        CPy_AddTraceback("src/charset_normalizer/md.py", "feed", 273, CPyStatic_globals);
        goto CPyL149;
    }
    if (unlikely(!PyBool_Check(cpy_r_r13))) {
        CPy_TypeError("bool", cpy_r_r13); cpy_r_r14 = 2;
    } else
        cpy_r_r14 = cpy_r_r13 == Py_True;
    CPy_DECREF(cpy_r_r13);
    if (unlikely(cpy_r_r14 == 2)) {
        CPy_AddTraceback("src/charset_normalizer/md.py", "feed", 273, CPyStatic_globals);
        goto CPyL149;
    }
    if (!cpy_r_r14) goto CPyL9;
    cpy_r_r15 = ((charset_normalizer___md___SuperWeirdWordPluginObject *)cpy_r_self)->__buffer_accent_count;
    cpy_r_r16 = CPyTagged_Add(cpy_r_r15, 2);
    CPyTagged_DECREF(((charset_normalizer___md___SuperWeirdWordPluginObject *)cpy_r_self)->__buffer_accent_count);
    ((charset_normalizer___md___SuperWeirdWordPluginObject *)cpy_r_self)->__buffer_accent_count = cpy_r_r16;
CPyL9: ;
    cpy_r_r18 = ((charset_normalizer___md___SuperWeirdWordPluginObject *)cpy_r_self)->__foreign_long_watch;
    cpy_r_r19 = cpy_r_r18 ? Py_True : Py_False;
    cpy_r_r20 = 0 ? Py_True : Py_False;
    cpy_r_r21 = cpy_r_r19 == cpy_r_r20;
    if (!cpy_r_r21) goto CPyL39;
    cpy_r_r22 = CPyStatic_globals;
    cpy_r_r23 = CPyStatics[13]; /* 'is_latin' */
    cpy_r_r24 = CPyDict_GetItem(cpy_r_r22, cpy_r_r23);
    if (unlikely(cpy_r_r24 == NULL)) {
        CPy_AddTraceback("src/charset_normalizer/md.py", "feed", 277, CPyStatic_globals);
        goto CPyL149;
    }
    PyObject *cpy_r_r25[1] = {cpy_r_character};
    cpy_r_r26 = (PyObject **)&cpy_r_r25;
    cpy_r_r27 = PyObject_Vectorcall(cpy_r_r24, cpy_r_r26, 1, 0);
    CPy_DECREF(cpy_r_r24);
    if (unlikely(cpy_r_r27 == NULL)) {
        CPy_AddTraceback("src/charset_normalizer/md.py", "feed", 277, CPyStatic_globals);
        goto CPyL149;
    }
    if (unlikely(!PyBool_Check(cpy_r_r27))) {
        CPy_TypeError("bool", cpy_r_r27); cpy_r_r28 = 2;
    } else
        cpy_r_r28 = cpy_r_r27 == Py_True;
    CPy_DECREF(cpy_r_r27);
    if (unlikely(cpy_r_r28 == 2)) {
        CPy_AddTraceback("src/charset_normalizer/md.py", "feed", 277, CPyStatic_globals);
        goto CPyL149;
    }
    cpy_r_r29 = cpy_r_r28 ? Py_True : Py_False;
    cpy_r_r30 = 0 ? Py_True : Py_False;
    cpy_r_r31 = cpy_r_r29 == cpy_r_r30;
    if (cpy_r_r31) goto CPyL18;
    cpy_r_r32 = CPyStatic_globals;
    cpy_r_r33 = CPyStatics[11]; /* 'is_accentuated' */
    cpy_r_r34 = CPyDict_GetItem(cpy_r_r32, cpy_r_r33);
    if (unlikely(cpy_r_r34 == NULL)) {
        CPy_AddTraceback("src/charset_normalizer/md.py", "feed", 277, CPyStatic_globals);
        goto CPyL149;
    }
    PyObject *cpy_r_r35[1] = {cpy_r_character};
    cpy_r_r36 = (PyObject **)&cpy_r_r35;
    cpy_r_r37 = PyObject_Vectorcall(cpy_r_r34, cpy_r_r36, 1, 0);
    CPy_DECREF(cpy_r_r34);
    if (unlikely(cpy_r_r37 == NULL)) {
        CPy_AddTraceback("src/charset_normalizer/md.py", "feed", 277, CPyStatic_globals);
        goto CPyL149;
    }
    if (unlikely(!PyBool_Check(cpy_r_r37))) {
        CPy_TypeError("bool", cpy_r_r37); cpy_r_r38 = 2;
    } else
        cpy_r_r38 = cpy_r_r37 == Py_True;
    CPy_DECREF(cpy_r_r37);
    if (unlikely(cpy_r_r38 == 2)) {
        CPy_AddTraceback("src/charset_normalizer/md.py", "feed", 277, CPyStatic_globals);
        goto CPyL149;
    }
    if (!cpy_r_r38) goto CPyL39;
CPyL18: ;
    cpy_r_r39 = CPyStatic_globals;
    cpy_r_r40 = CPyStatics[20]; /* 'is_cjk' */
    cpy_r_r41 = CPyDict_GetItem(cpy_r_r39, cpy_r_r40);
    if (unlikely(cpy_r_r41 == NULL)) {
        CPy_AddTraceback("src/charset_normalizer/md.py", "feed", 278, CPyStatic_globals);
        goto CPyL149;
    }
    PyObject *cpy_r_r42[1] = {cpy_r_character};
    cpy_r_r43 = (PyObject **)&cpy_r_r42;
    cpy_r_r44 = PyObject_Vectorcall(cpy_r_r41, cpy_r_r43, 1, 0);
    CPy_DECREF(cpy_r_r41);
    if (unlikely(cpy_r_r44 == NULL)) {
        CPy_AddTraceback("src/charset_normalizer/md.py", "feed", 278, CPyStatic_globals);
        goto CPyL149;
    }
    if (unlikely(!PyBool_Check(cpy_r_r44))) {
        CPy_TypeError("bool", cpy_r_r44); cpy_r_r45 = 2;
    } else
        cpy_r_r45 = cpy_r_r44 == Py_True;
    CPy_DECREF(cpy_r_r44);
    if (unlikely(cpy_r_r45 == 2)) {
        CPy_AddTraceback("src/charset_normalizer/md.py", "feed", 278, CPyStatic_globals);
        goto CPyL149;
    }
    cpy_r_r46 = cpy_r_r45 ? Py_True : Py_False;
    cpy_r_r47 = 0 ? Py_True : Py_False;
    cpy_r_r48 = cpy_r_r46 == cpy_r_r47;
    if (!cpy_r_r48) goto CPyL39;
    cpy_r_r49 = CPyStatic_globals;
    cpy_r_r50 = CPyStatics[21]; /* 'is_hangul' */
    cpy_r_r51 = CPyDict_GetItem(cpy_r_r49, cpy_r_r50);
    if (unlikely(cpy_r_r51 == NULL)) {
        CPy_AddTraceback("src/charset_normalizer/md.py", "feed", 279, CPyStatic_globals);
        goto CPyL149;
    }
    PyObject *cpy_r_r52[1] = {cpy_r_character};
    cpy_r_r53 = (PyObject **)&cpy_r_r52;
    cpy_r_r54 = PyObject_Vectorcall(cpy_r_r51, cpy_r_r53, 1, 0);
    CPy_DECREF(cpy_r_r51);
    if (unlikely(cpy_r_r54 == NULL)) {
        CPy_AddTraceback("src/charset_normalizer/md.py", "feed", 279, CPyStatic_globals);
        goto CPyL149;
    }
    if (unlikely(!PyBool_Check(cpy_r_r54))) {
        CPy_TypeError("bool", cpy_r_r54); cpy_r_r55 = 2;
    } else
        cpy_r_r55 = cpy_r_r54 == Py_True;
    CPy_DECREF(cpy_r_r54);
    if (unlikely(cpy_r_r55 == 2)) {
        CPy_AddTraceback("src/charset_normalizer/md.py", "feed", 279, CPyStatic_globals);
        goto CPyL149;
    }
    cpy_r_r56 = cpy_r_r55 ? Py_True : Py_False;
    cpy_r_r57 = 0 ? Py_True : Py_False;
    cpy_r_r58 = cpy_r_r56 == cpy_r_r57;
    if (!cpy_r_r58) goto CPyL39;
    cpy_r_r59 = CPyStatic_globals;
    cpy_r_r60 = CPyStatics[22]; /* 'is_katakana' */
    cpy_r_r61 = CPyDict_GetItem(cpy_r_r59, cpy_r_r60);
    if (unlikely(cpy_r_r61 == NULL)) {
        CPy_AddTraceback("src/charset_normalizer/md.py", "feed", 280, CPyStatic_globals);
        goto CPyL149;
    }
    PyObject *cpy_r_r62[1] = {cpy_r_character};
    cpy_r_r63 = (PyObject **)&cpy_r_r62;
    cpy_r_r64 = PyObject_Vectorcall(cpy_r_r61, cpy_r_r63, 1, 0);
    CPy_DECREF(cpy_r_r61);
    if (unlikely(cpy_r_r64 == NULL)) {
        CPy_AddTraceback("src/charset_normalizer/md.py", "feed", 280, CPyStatic_globals);
        goto CPyL149;
    }
    if (unlikely(!PyBool_Check(cpy_r_r64))) {
        CPy_TypeError("bool", cpy_r_r64); cpy_r_r65 = 2;
    } else
        cpy_r_r65 = cpy_r_r64 == Py_True;
    CPy_DECREF(cpy_r_r64);
    if (unlikely(cpy_r_r65 == 2)) {
        CPy_AddTraceback("src/charset_normalizer/md.py", "feed", 280, CPyStatic_globals);
        goto CPyL149;
    }
    cpy_r_r66 = cpy_r_r65 ? Py_True : Py_False;
    cpy_r_r67 = 0 ? Py_True : Py_False;
    cpy_r_r68 = cpy_r_r66 == cpy_r_r67;
    if (!cpy_r_r68) goto CPyL39;
    cpy_r_r69 = CPyStatic_globals;
    cpy_r_r70 = CPyStatics[23]; /* 'is_hiragana' */
    cpy_r_r71 = CPyDict_GetItem(cpy_r_r69, cpy_r_r70);
    if (unlikely(cpy_r_r71 == NULL)) {
        CPy_AddTraceback("src/charset_normalizer/md.py", "feed", 281, CPyStatic_globals);
        goto CPyL149;
    }
    PyObject *cpy_r_r72[1] = {cpy_r_character};
    cpy_r_r73 = (PyObject **)&cpy_r_r72;
    cpy_r_r74 = PyObject_Vectorcall(cpy_r_r71, cpy_r_r73, 1, 0);
    CPy_DECREF(cpy_r_r71);
    if (unlikely(cpy_r_r74 == NULL)) {
        CPy_AddTraceback("src/charset_normalizer/md.py", "feed", 281, CPyStatic_globals);
        goto CPyL149;
    }
    if (unlikely(!PyBool_Check(cpy_r_r74))) {
        CPy_TypeError("bool", cpy_r_r74); cpy_r_r75 = 2;
    } else
        cpy_r_r75 = cpy_r_r74 == Py_True;
    CPy_DECREF(cpy_r_r74);
    if (unlikely(cpy_r_r75 == 2)) {
        CPy_AddTraceback("src/charset_normalizer/md.py", "feed", 281, CPyStatic_globals);
        goto CPyL149;
    }
    cpy_r_r76 = cpy_r_r75 ? Py_True : Py_False;
    cpy_r_r77 = 0 ? Py_True : Py_False;
    cpy_r_r78 = cpy_r_r76 == cpy_r_r77;
    if (!cpy_r_r78) goto CPyL39;
    cpy_r_r79 = CPyStatic_globals;
    cpy_r_r80 = CPyStatics[24]; /* 'is_thai' */
    cpy_r_r81 = CPyDict_GetItem(cpy_r_r79, cpy_r_r80);
    if (unlikely(cpy_r_r81 == NULL)) {
        CPy_AddTraceback("src/charset_normalizer/md.py", "feed", 282, CPyStatic_globals);
        goto CPyL149;
    }
    PyObject *cpy_r_r82[1] = {cpy_r_character};
    cpy_r_r83 = (PyObject **)&cpy_r_r82;
    cpy_r_r84 = PyObject_Vectorcall(cpy_r_r81, cpy_r_r83, 1, 0);
    CPy_DECREF(cpy_r_r81);
    if (unlikely(cpy_r_r84 == NULL)) {
        CPy_AddTraceback("src/charset_normalizer/md.py", "feed", 282, CPyStatic_globals);
        goto CPyL149;
    }
    if (unlikely(!PyBool_Check(cpy_r_r84))) {
        CPy_TypeError("bool", cpy_r_r84); cpy_r_r85 = 2;
    } else
        cpy_r_r85 = cpy_r_r84 == Py_True;
    CPy_DECREF(cpy_r_r84);
    if (unlikely(cpy_r_r85 == 2)) {
        CPy_AddTraceback("src/charset_normalizer/md.py", "feed", 282, CPyStatic_globals);
        goto CPyL149;
    }
    cpy_r_r86 = cpy_r_r85 ? Py_True : Py_False;
    cpy_r_r87 = 0 ? Py_True : Py_False;
    cpy_r_r88 = cpy_r_r86 == cpy_r_r87;
    if (!cpy_r_r88) goto CPyL39;
    ((charset_normalizer___md___SuperWeirdWordPluginObject *)cpy_r_self)->__foreign_long_watch = 1;
CPyL39: ;
    cpy_r_r90 = CPyStatic_globals;
    cpy_r_r91 = CPyStatics[20]; /* 'is_cjk' */
    cpy_r_r92 = CPyDict_GetItem(cpy_r_r90, cpy_r_r91);
    if (unlikely(cpy_r_r92 == NULL)) {
        CPy_AddTraceback("src/charset_normalizer/md.py", "feed", 286, CPyStatic_globals);
        goto CPyL149;
    }
    PyObject *cpy_r_r93[1] = {cpy_r_character};
    cpy_r_r94 = (PyObject **)&cpy_r_r93;
    cpy_r_r95 = PyObject_Vectorcall(cpy_r_r92, cpy_r_r94, 1, 0);
    CPy_DECREF(cpy_r_r92);
    if (unlikely(cpy_r_r95 == NULL)) {
        CPy_AddTraceback("src/charset_normalizer/md.py", "feed", 286, CPyStatic_globals);
        goto CPyL149;
    }
    if (unlikely(!PyBool_Check(cpy_r_r95))) {
        CPy_TypeError("bool", cpy_r_r95); cpy_r_r96 = 2;
    } else
        cpy_r_r96 = cpy_r_r95 == Py_True;
    CPy_DECREF(cpy_r_r95);
    if (unlikely(cpy_r_r96 == 2)) {
        CPy_AddTraceback("src/charset_normalizer/md.py", "feed", 286, CPyStatic_globals);
        goto CPyL149;
    }
    if (cpy_r_r96) goto CPyL59;
    cpy_r_r97 = CPyStatic_globals;
    cpy_r_r98 = CPyStatics[21]; /* 'is_hangul' */
    cpy_r_r99 = CPyDict_GetItem(cpy_r_r97, cpy_r_r98);
    if (unlikely(cpy_r_r99 == NULL)) {
        CPy_AddTraceback("src/charset_normalizer/md.py", "feed", 287, CPyStatic_globals);
        goto CPyL149;
    }
    PyObject *cpy_r_r100[1] = {cpy_r_character};
    cpy_r_r101 = (PyObject **)&cpy_r_r100;
    cpy_r_r102 = PyObject_Vectorcall(cpy_r_r99, cpy_r_r101, 1, 0);
    CPy_DECREF(cpy_r_r99);
    if (unlikely(cpy_r_r102 == NULL)) {
        CPy_AddTraceback("src/charset_normalizer/md.py", "feed", 287, CPyStatic_globals);
        goto CPyL149;
    }
    if (unlikely(!PyBool_Check(cpy_r_r102))) {
        CPy_TypeError("bool", cpy_r_r102); cpy_r_r103 = 2;
    } else
        cpy_r_r103 = cpy_r_r102 == Py_True;
    CPy_DECREF(cpy_r_r102);
    if (unlikely(cpy_r_r103 == 2)) {
        CPy_AddTraceback("src/charset_normalizer/md.py", "feed", 287, CPyStatic_globals);
        goto CPyL149;
    }
    if (cpy_r_r103) goto CPyL59;
    cpy_r_r104 = CPyStatic_globals;
    cpy_r_r105 = CPyStatics[22]; /* 'is_katakana' */
    cpy_r_r106 = CPyDict_GetItem(cpy_r_r104, cpy_r_r105);
    if (unlikely(cpy_r_r106 == NULL)) {
        CPy_AddTraceback("src/charset_normalizer/md.py", "feed", 288, CPyStatic_globals);
        goto CPyL149;
    }
    PyObject *cpy_r_r107[1] = {cpy_r_character};
    cpy_r_r108 = (PyObject **)&cpy_r_r107;
    cpy_r_r109 = PyObject_Vectorcall(cpy_r_r106, cpy_r_r108, 1, 0);
    CPy_DECREF(cpy_r_r106);
    if (unlikely(cpy_r_r109 == NULL)) {
        CPy_AddTraceback("src/charset_normalizer/md.py", "feed", 288, CPyStatic_globals);
        goto CPyL149;
    }
    if (unlikely(!PyBool_Check(cpy_r_r109))) {
        CPy_TypeError("bool", cpy_r_r109); cpy_r_r110 = 2;
    } else
        cpy_r_r110 = cpy_r_r109 == Py_True;
    CPy_DECREF(cpy_r_r109);
    if (unlikely(cpy_r_r110 == 2)) {
        CPy_AddTraceback("src/charset_normalizer/md.py", "feed", 288, CPyStatic_globals);
        goto CPyL149;
    }
    if (cpy_r_r110) goto CPyL59;
    cpy_r_r111 = CPyStatic_globals;
    cpy_r_r112 = CPyStatics[23]; /* 'is_hiragana' */
    cpy_r_r113 = CPyDict_GetItem(cpy_r_r111, cpy_r_r112);
    if (unlikely(cpy_r_r113 == NULL)) {
        CPy_AddTraceback("src/charset_normalizer/md.py", "feed", 289, CPyStatic_globals);
        goto CPyL149;
    }
    PyObject *cpy_r_r114[1] = {cpy_r_character};
    cpy_r_r115 = (PyObject **)&cpy_r_r114;
    cpy_r_r116 = PyObject_Vectorcall(cpy_r_r113, cpy_r_r115, 1, 0);
    CPy_DECREF(cpy_r_r113);
    if (unlikely(cpy_r_r116 == NULL)) {
        CPy_AddTraceback("src/charset_normalizer/md.py", "feed", 289, CPyStatic_globals);
        goto CPyL149;
    }
    if (unlikely(!PyBool_Check(cpy_r_r116))) {
        CPy_TypeError("bool", cpy_r_r116); cpy_r_r117 = 2;
    } else
        cpy_r_r117 = cpy_r_r116 == Py_True;
    CPy_DECREF(cpy_r_r116);
    if (unlikely(cpy_r_r117 == 2)) {
        CPy_AddTraceback("src/charset_normalizer/md.py", "feed", 289, CPyStatic_globals);
        goto CPyL149;
    }
    if (cpy_r_r117) goto CPyL59;
    cpy_r_r118 = CPyStatic_globals;
    cpy_r_r119 = CPyStatics[24]; /* 'is_thai' */
    cpy_r_r120 = CPyDict_GetItem(cpy_r_r118, cpy_r_r119);
    if (unlikely(cpy_r_r120 == NULL)) {
        CPy_AddTraceback("src/charset_normalizer/md.py", "feed", 290, CPyStatic_globals);
        goto CPyL149;
    }
    PyObject *cpy_r_r121[1] = {cpy_r_character};
    cpy_r_r122 = (PyObject **)&cpy_r_r121;
    cpy_r_r123 = PyObject_Vectorcall(cpy_r_r120, cpy_r_r122, 1, 0);
    CPy_DECREF(cpy_r_r120);
    if (unlikely(cpy_r_r123 == NULL)) {
        CPy_AddTraceback("src/charset_normalizer/md.py", "feed", 290, CPyStatic_globals);
        goto CPyL149;
    }
    if (unlikely(!PyBool_Check(cpy_r_r123))) {
        CPy_TypeError("bool", cpy_r_r123); cpy_r_r124 = 2;
    } else
        cpy_r_r124 = cpy_r_r123 == Py_True;
    CPy_DECREF(cpy_r_r123);
    if (unlikely(cpy_r_r124 == 2)) {
        CPy_AddTraceback("src/charset_normalizer/md.py", "feed", 290, CPyStatic_globals);
        goto CPyL149;
    }
    if (!cpy_r_r124) goto CPyL60;
CPyL59: ;
    cpy_r_r125 = ((charset_normalizer___md___SuperWeirdWordPluginObject *)cpy_r_self)->__buffer_glyph_count;
    cpy_r_r126 = CPyTagged_Add(cpy_r_r125, 2);
    CPyTagged_DECREF(((charset_normalizer___md___SuperWeirdWordPluginObject *)cpy_r_self)->__buffer_glyph_count);
    ((charset_normalizer___md___SuperWeirdWordPluginObject *)cpy_r_self)->__buffer_glyph_count = cpy_r_r126;
CPyL60: ;
    return 1;
CPyL61: ;
    cpy_r_r128 = ((charset_normalizer___md___SuperWeirdWordPluginObject *)cpy_r_self)->__buffer;
    CPy_INCREF(cpy_r_r128);
    cpy_r_r129 = CPyStr_IsTrue(cpy_r_r128);
    CPy_DECREF(cpy_r_r128);
    if (cpy_r_r129) goto CPyL63;
    return 1;
CPyL63: ;
    cpy_r_r130 = CPyStatics[16]; /* 'isspace' */
    PyObject *cpy_r_r131[1] = {cpy_r_character};
    cpy_r_r132 = (PyObject **)&cpy_r_r131;
    cpy_r_r133 = PyObject_VectorcallMethod(cpy_r_r130, cpy_r_r132, 9223372036854775809ULL, 0);
    if (unlikely(cpy_r_r133 == NULL)) {
        CPy_AddTraceback("src/charset_normalizer/md.py", "feed", 297, CPyStatic_globals);
        goto CPyL149;
    }
    if (unlikely(!PyBool_Check(cpy_r_r133))) {
        CPy_TypeError("bool", cpy_r_r133); cpy_r_r134 = 2;
    } else
        cpy_r_r134 = cpy_r_r133 == Py_True;
    CPy_DECREF(cpy_r_r133);
    if (unlikely(cpy_r_r134 == 2)) {
        CPy_AddTraceback("src/charset_normalizer/md.py", "feed", 297, CPyStatic_globals);
        goto CPyL149;
    }
    if (cpy_r_r134) goto CPyL74;
    cpy_r_r135 = CPyStatic_globals;
    cpy_r_r136 = CPyStatics[6]; /* 'is_punctuation' */
    cpy_r_r137 = CPyDict_GetItem(cpy_r_r135, cpy_r_r136);
    if (unlikely(cpy_r_r137 == NULL)) {
        CPy_AddTraceback("src/charset_normalizer/md.py", "feed", 297, CPyStatic_globals);
        goto CPyL149;
    }
    PyObject *cpy_r_r138[1] = {cpy_r_character};
    cpy_r_r139 = (PyObject **)&cpy_r_r138;
    cpy_r_r140 = PyObject_Vectorcall(cpy_r_r137, cpy_r_r139, 1, 0);
    CPy_DECREF(cpy_r_r137);
    if (unlikely(cpy_r_r140 == NULL)) {
        CPy_AddTraceback("src/charset_normalizer/md.py", "feed", 297, CPyStatic_globals);
        goto CPyL149;
    }
    if (unlikely(!PyBool_Check(cpy_r_r140))) {
        CPy_TypeError("bool", cpy_r_r140); cpy_r_r141 = 2;
    } else
        cpy_r_r141 = cpy_r_r140 == Py_True;
    CPy_DECREF(cpy_r_r140);
    if (unlikely(cpy_r_r141 == 2)) {
        CPy_AddTraceback("src/charset_normalizer/md.py", "feed", 297, CPyStatic_globals);
        goto CPyL149;
    }
    if (cpy_r_r141) goto CPyL74;
    cpy_r_r142 = CPyStatic_globals;
    cpy_r_r143 = CPyStatics[25]; /* 'is_separator' */
    cpy_r_r144 = CPyDict_GetItem(cpy_r_r142, cpy_r_r143);
    if (unlikely(cpy_r_r144 == NULL)) {
        CPy_AddTraceback("src/charset_normalizer/md.py", "feed", 297, CPyStatic_globals);
        goto CPyL149;
    }
    PyObject *cpy_r_r145[1] = {cpy_r_character};
    cpy_r_r146 = (PyObject **)&cpy_r_r145;
    cpy_r_r147 = PyObject_Vectorcall(cpy_r_r144, cpy_r_r146, 1, 0);
    CPy_DECREF(cpy_r_r144);
    if (unlikely(cpy_r_r147 == NULL)) {
        CPy_AddTraceback("src/charset_normalizer/md.py", "feed", 297, CPyStatic_globals);
        goto CPyL149;
    }
    if (unlikely(!PyBool_Check(cpy_r_r147))) {
        CPy_TypeError("bool", cpy_r_r147); cpy_r_r148 = 2;
    } else
        cpy_r_r148 = cpy_r_r147 == Py_True;
    CPy_DECREF(cpy_r_r147);
    if (unlikely(cpy_r_r148 == 2)) {
        CPy_AddTraceback("src/charset_normalizer/md.py", "feed", 297, CPyStatic_globals);
        goto CPyL149;
    }
    if (!cpy_r_r148) goto CPyL137;
CPyL74: ;
    cpy_r_r149 = ((charset_normalizer___md___SuperWeirdWordPluginObject *)cpy_r_self)->__buffer;
    CPy_INCREF(cpy_r_r149);
    cpy_r_r150 = CPyStr_IsTrue(cpy_r_r149);
    CPy_DECREF(cpy_r_r149);
    if (!cpy_r_r150) goto CPyL137;
    cpy_r_r151 = ((charset_normalizer___md___SuperWeirdWordPluginObject *)cpy_r_self)->__word_count;
    cpy_r_r152 = CPyTagged_Add(cpy_r_r151, 2);
    CPyTagged_DECREF(((charset_normalizer___md___SuperWeirdWordPluginObject *)cpy_r_self)->__word_count);
    ((charset_normalizer___md___SuperWeirdWordPluginObject *)cpy_r_self)->__word_count = cpy_r_r152;
    cpy_r_r154 = ((charset_normalizer___md___SuperWeirdWordPluginObject *)cpy_r_self)->__buffer;
    CPy_INCREF(cpy_r_r154);
    cpy_r_r155 = CPyStr_Size_size_t(cpy_r_r154);
    CPy_DECREF(cpy_r_r154);
    cpy_r_r156 = cpy_r_r155 >= 0;
    if (unlikely(!cpy_r_r156)) {
        CPy_AddTraceback("src/charset_normalizer/md.py", "feed", 300, CPyStatic_globals);
        goto CPyL149;
    }
    cpy_r_r157 = cpy_r_r155 << 1;
    cpy_r_buffer_length = cpy_r_r157;
    cpy_r_r158 = ((charset_normalizer___md___SuperWeirdWordPluginObject *)cpy_r_self)->__character_count;
    cpy_r_r159 = CPyTagged_Add(cpy_r_r158, cpy_r_buffer_length);
    CPyTagged_DECREF(((charset_normalizer___md___SuperWeirdWordPluginObject *)cpy_r_self)->__character_count);
    ((charset_normalizer___md___SuperWeirdWordPluginObject *)cpy_r_self)->__character_count = cpy_r_r159;
    cpy_r_r161 = cpy_r_buffer_length & 1;
    cpy_r_r162 = cpy_r_r161 != 0;
    if (cpy_r_r162) goto CPyL78;
    cpy_r_r163 = 8 & 1;
    cpy_r_r164 = cpy_r_r163 != 0;
    if (!cpy_r_r164) goto CPyL79;
CPyL78: ;
    cpy_r_r165 = CPyTagged_IsLt_(cpy_r_buffer_length, 8);
    cpy_r_r166 = cpy_r_r165 ^ 1;
    if (cpy_r_r166) {
        goto CPyL80;
    } else
        goto CPyL107;
CPyL79: ;
    cpy_r_r167 = (Py_ssize_t)cpy_r_buffer_length >= (Py_ssize_t)8;
    if (!cpy_r_r167) goto CPyL107;
CPyL80: ;
    cpy_r_r168 = ((charset_normalizer___md___SuperWeirdWordPluginObject *)cpy_r_self)->__buffer_accent_count;
    CPyTagged_INCREF(cpy_r_r168);
    cpy_r_r169 = CPyTagged_TrueDivide(cpy_r_r168, cpy_r_buffer_length);
    CPyTagged_DECREF(cpy_r_r168);
    cpy_r_r170 = cpy_r_r169 == -113.0;
    if (unlikely(cpy_r_r170)) goto CPyL82;
CPyL81: ;
    cpy_r_r171 = cpy_r_r169 >= 0.5;
    if (cpy_r_r171) {
        goto CPyL83;
    } else
        goto CPyL84;
CPyL82: ;
    cpy_r_r172 = PyErr_Occurred();
    if (unlikely(cpy_r_r172 != NULL)) {
        CPy_AddTraceback("src/charset_normalizer/md.py", "feed", 305, CPyStatic_globals);
        goto CPyL150;
    } else
        goto CPyL81;
CPyL83: ;
    ((charset_normalizer___md___SuperWeirdWordPluginObject *)cpy_r_self)->__is_current_word_bad = 1;
    goto CPyL107;
CPyL84: ;
    cpy_r_r174 = ((charset_normalizer___md___SuperWeirdWordPluginObject *)cpy_r_self)->__buffer;
    CPy_INCREF(cpy_r_r174);
    cpy_r_r175 = CPyStr_GetItem(cpy_r_r174, -2);
    CPy_DECREF(cpy_r_r174);
    if (unlikely(cpy_r_r175 == NULL)) {
        CPy_AddTraceback("src/charset_normalizer/md.py", "feed", 310, CPyStatic_globals);
        goto CPyL150;
    }
    cpy_r_r176 = CPyStatic_globals;
    cpy_r_r177 = CPyStatics[11]; /* 'is_accentuated' */
    cpy_r_r178 = CPyDict_GetItem(cpy_r_r176, cpy_r_r177);
    if (unlikely(cpy_r_r178 == NULL)) {
        CPy_AddTraceback("src/charset_normalizer/md.py", "feed", 310, CPyStatic_globals);
        goto CPyL151;
    }
    PyObject *cpy_r_r179[1] = {cpy_r_r175};
    cpy_r_r180 = (PyObject **)&cpy_r_r179;
    cpy_r_r181 = PyObject_Vectorcall(cpy_r_r178, cpy_r_r180, 1, 0);
    CPy_DECREF(cpy_r_r178);
    if (unlikely(cpy_r_r181 == NULL)) {
        CPy_AddTraceback("src/charset_normalizer/md.py", "feed", 310, CPyStatic_globals);
        goto CPyL151;
    }
    CPy_DECREF(cpy_r_r175);
    if (unlikely(!PyBool_Check(cpy_r_r181))) {
        CPy_TypeError("bool", cpy_r_r181); cpy_r_r182 = 2;
    } else
        cpy_r_r182 = cpy_r_r181 == Py_True;
    CPy_DECREF(cpy_r_r181);
    if (unlikely(cpy_r_r182 == 2)) {
        CPy_AddTraceback("src/charset_normalizer/md.py", "feed", 310, CPyStatic_globals);
        goto CPyL150;
    }
    if (!cpy_r_r182) goto CPyL105;
    cpy_r_r183 = ((charset_normalizer___md___SuperWeirdWordPluginObject *)cpy_r_self)->__buffer;
    CPy_INCREF(cpy_r_r183);
    cpy_r_r184 = CPyStr_GetItem(cpy_r_r183, -2);
    CPy_DECREF(cpy_r_r183);
    if (unlikely(cpy_r_r184 == NULL)) {
        CPy_AddTraceback("src/charset_normalizer/md.py", "feed", 311, CPyStatic_globals);
        goto CPyL150;
    }
    cpy_r_r185 = CPyStatics[14]; /* 'isupper' */
    PyObject *cpy_r_r186[1] = {cpy_r_r184};
    cpy_r_r187 = (PyObject **)&cpy_r_r186;
    cpy_r_r188 = PyObject_VectorcallMethod(cpy_r_r185, cpy_r_r187, 9223372036854775809ULL, 0);
    if (unlikely(cpy_r_r188 == NULL)) {
        CPy_AddTraceback("src/charset_normalizer/md.py", "feed", 311, CPyStatic_globals);
        goto CPyL152;
    }
    CPy_DECREF(cpy_r_r184);
    if (unlikely(!PyBool_Check(cpy_r_r188))) {
        CPy_TypeError("bool", cpy_r_r188); cpy_r_r189 = 2;
    } else
        cpy_r_r189 = cpy_r_r188 == Py_True;
    CPy_DECREF(cpy_r_r188);
    if (unlikely(cpy_r_r189 == 2)) {
        CPy_AddTraceback("src/charset_normalizer/md.py", "feed", 311, CPyStatic_globals);
        goto CPyL150;
    }
    if (!cpy_r_r189) goto CPyL105;
    cpy_r_r190 = 1;
    cpy_r_r191 = ((charset_normalizer___md___SuperWeirdWordPluginObject *)cpy_r_self)->__buffer;
    CPy_INCREF(cpy_r_r191);
    cpy_r_r192 = CPyStr_Size_size_t(cpy_r_r191);
    cpy_r_r193 = cpy_r_r192 >= 0;
    if (unlikely(!cpy_r_r193)) {
        CPy_AddTraceback("src/charset_normalizer/md.py", "feed", 312, CPyStatic_globals);
        goto CPyL153;
    }
    cpy_r_r194 = 0;
CPyL95: ;
    cpy_r_r195 = cpy_r_r194 < cpy_r_r192;
    if (!cpy_r_r195) goto CPyL154;
    cpy_r_r196 = CPyStr_GetItemUnsafe(cpy_r_r191, cpy_r_r194);
    if (unlikely(cpy_r_r196 == NULL)) {
        CPy_AddTraceback("src/charset_normalizer/md.py", "feed", 312, CPyStatic_globals);
        goto CPyL153;
    }
    cpy_r__ = cpy_r_r196;
    if (likely(PyUnicode_Check(cpy_r__)))
        cpy_r_r197 = cpy_r__;
    else {
        CPy_TypeErrorTraceback("src/charset_normalizer/md.py", "feed", 312, CPyStatic_globals, "str", cpy_r__);
        goto CPyL153;
    }
    cpy_r_r198 = CPyStatics[14]; /* 'isupper' */
    PyObject *cpy_r_r199[1] = {cpy_r_r197};
    cpy_r_r200 = (PyObject **)&cpy_r_r199;
    cpy_r_r201 = PyObject_VectorcallMethod(cpy_r_r198, cpy_r_r200, 9223372036854775809ULL, 0);
    if (unlikely(cpy_r_r201 == NULL)) {
        CPy_AddTraceback("src/charset_normalizer/md.py", "feed", 312, CPyStatic_globals);
        goto CPyL155;
    }
    CPy_DECREF(cpy_r_r197);
    if (unlikely(!PyBool_Check(cpy_r_r201))) {
        CPy_TypeError("bool", cpy_r_r201); cpy_r_r202 = 2;
    } else
        cpy_r_r202 = cpy_r_r201 == Py_True;
    CPy_DECREF(cpy_r_r201);
    if (unlikely(cpy_r_r202 == 2)) {
        CPy_AddTraceback("src/charset_normalizer/md.py", "feed", 312, CPyStatic_globals);
        goto CPyL153;
    }
    cpy_r_r203 = cpy_r_r202 ^ 1;
    if (cpy_r_r203) {
        goto CPyL156;
    } else
        goto CPyL102;
CPyL101: ;
    cpy_r_r190 = 0;
    goto CPyL103;
CPyL102: ;
    cpy_r_r204 = cpy_r_r194 + 1;
    cpy_r_r194 = cpy_r_r204;
    goto CPyL95;
CPyL103: ;
    cpy_r_r205 = cpy_r_r190 ? Py_True : Py_False;
    cpy_r_r206 = 0 ? Py_True : Py_False;
    cpy_r_r207 = cpy_r_r205 == cpy_r_r206;
    if (!cpy_r_r207) goto CPyL105;
    cpy_r_r208 = ((charset_normalizer___md___SuperWeirdWordPluginObject *)cpy_r_self)->__foreign_long_count;
    cpy_r_r209 = CPyTagged_Add(cpy_r_r208, 2);
    CPyTagged_DECREF(((charset_normalizer___md___SuperWeirdWordPluginObject *)cpy_r_self)->__foreign_long_count);
    ((charset_normalizer___md___SuperWeirdWordPluginObject *)cpy_r_self)->__foreign_long_count = cpy_r_r209;
    ((charset_normalizer___md___SuperWeirdWordPluginObject *)cpy_r_self)->__is_current_word_bad = 1;
    goto CPyL107;
CPyL105: ;
    cpy_r_r212 = ((charset_normalizer___md___SuperWeirdWordPluginObject *)cpy_r_self)->__buffer_glyph_count;
    cpy_r_r213 = cpy_r_r212 == 2;
    if (!cpy_r_r213) goto CPyL107;
    ((charset_normalizer___md___SuperWeirdWordPluginObject *)cpy_r_self)->__is_current_word_bad = 1;
    cpy_r_r215 = ((charset_normalizer___md___SuperWeirdWordPluginObject *)cpy_r_self)->__foreign_long_count;
    cpy_r_r216 = CPyTagged_Add(cpy_r_r215, 2);
    CPyTagged_DECREF(((charset_normalizer___md___SuperWeirdWordPluginObject *)cpy_r_self)->__foreign_long_count);
    ((charset_normalizer___md___SuperWeirdWordPluginObject *)cpy_r_self)->__foreign_long_count = cpy_r_r216;
CPyL107: ;
    cpy_r_r218 = cpy_r_buffer_length & 1;
    cpy_r_r219 = cpy_r_r218 != 0;
    if (cpy_r_r219) goto CPyL109;
    cpy_r_r220 = 48 & 1;
    cpy_r_r221 = cpy_r_r220 != 0;
    if (!cpy_r_r221) goto CPyL110;
CPyL109: ;
    cpy_r_r222 = CPyTagged_IsLt_(cpy_r_buffer_length, 48);
    cpy_r_r223 = cpy_r_r222 ^ 1;
    if (cpy_r_r223) {
        goto CPyL111;
    } else
        goto CPyL157;
CPyL110: ;
    cpy_r_r224 = (Py_ssize_t)cpy_r_buffer_length >= (Py_ssize_t)48;
    if (!cpy_r_r224) goto CPyL157;
CPyL111: ;
    cpy_r_r225 = ((charset_normalizer___md___SuperWeirdWordPluginObject *)cpy_r_self)->__foreign_long_watch;
    if (!cpy_r_r225) goto CPyL157;
CPyL112: ;
    cpy_r_r226 = PyList_New(0);
    if (unlikely(cpy_r_r226 == NULL)) {
        CPy_AddTraceback("src/charset_normalizer/md.py", "feed", 320, CPyStatic_globals);
        goto CPyL150;
    }
    cpy_r_r227 = ((charset_normalizer___md___SuperWeirdWordPluginObject *)cpy_r_self)->__buffer;
    CPy_INCREF(cpy_r_r227);
    cpy_r_r228 = CPyStr_Size_size_t(cpy_r_r227);
    cpy_r_r229 = cpy_r_r228 >= 0;
    if (unlikely(!cpy_r_r229)) {
        CPy_AddTraceback("src/charset_normalizer/md.py", "feed", 320, CPyStatic_globals);
        goto CPyL158;
    }
    cpy_r_r230 = 0;
    cpy_r_r231 = 0;
    CPyTagged_INCREF(cpy_r_r231);
    cpy_r_i = cpy_r_r231;
CPyL115: ;
    cpy_r_r232 = cpy_r_r230 < cpy_r_r228;
    if (!cpy_r_r232) goto CPyL159;
    cpy_r_r233 = cpy_r_r231 & 1;
    cpy_r_r234 = cpy_r_r233 != 0;
    if (cpy_r_r234) goto CPyL118;
    cpy_r_r235 = cpy_r_buffer_length & 1;
    cpy_r_r236 = cpy_r_r235 != 0;
    if (!cpy_r_r236) goto CPyL119;
CPyL118: ;
    cpy_r_r237 = CPyTagged_IsLt_(cpy_r_r231, cpy_r_buffer_length);
    if (cpy_r_r237) {
        goto CPyL120;
    } else
        goto CPyL159;
CPyL119: ;
    cpy_r_r238 = (Py_ssize_t)cpy_r_r231 < (Py_ssize_t)cpy_r_buffer_length;
    if (!cpy_r_r238) goto CPyL159;
CPyL120: ;
    cpy_r_r239 = CPyStr_GetItemUnsafe(cpy_r_r227, cpy_r_r230);
    if (unlikely(cpy_r_r239 == NULL)) {
        CPy_AddTraceback("src/charset_normalizer/md.py", "feed", 320, CPyStatic_globals);
        goto CPyL160;
    }
    cpy_r_r240 = CPyStatics[14]; /* 'isupper' */
    PyObject *cpy_r_r241[1] = {cpy_r_r239};
    cpy_r_r242 = (PyObject **)&cpy_r_r241;
    cpy_r_r243 = PyObject_VectorcallMethod(cpy_r_r240, cpy_r_r242, 9223372036854775809ULL, 0);
    if (unlikely(cpy_r_r243 == NULL)) {
        CPy_AddTraceback("src/charset_normalizer/md.py", "feed", 323, CPyStatic_globals);
        goto CPyL161;
    }
    CPy_DECREF(cpy_r_r239);
    if (unlikely(!PyBool_Check(cpy_r_r243))) {
        CPy_TypeError("bool", cpy_r_r243); cpy_r_r244 = 2;
    } else
        cpy_r_r244 = cpy_r_r243 == Py_True;
    CPy_DECREF(cpy_r_r243);
    if (unlikely(cpy_r_r244 == 2)) {
        CPy_AddTraceback("src/charset_normalizer/md.py", "feed", 323, CPyStatic_globals);
        goto CPyL160;
    }
    if (!cpy_r_r244) goto CPyL162;
    cpy_r_r245 = CPyTagged_StealAsObject(cpy_r_i);
    cpy_r_r246 = PyList_Append(cpy_r_r226, cpy_r_r245);
    CPy_DECREF(cpy_r_r245);
    cpy_r_r247 = cpy_r_r246 >= 0;
    if (unlikely(!cpy_r_r247)) {
        CPy_AddTraceback("src/charset_normalizer/md.py", "feed", 320, CPyStatic_globals);
        goto CPyL163;
    }
CPyL125: ;
    cpy_r_r248 = cpy_r_r230 + 1;
    cpy_r_r230 = cpy_r_r248;
    cpy_r_r249 = CPyTagged_Add(cpy_r_r231, 2);
    CPyTagged_DECREF(cpy_r_r231);
    CPyTagged_INCREF(cpy_r_r249);
    cpy_r_r231 = cpy_r_r249;
    cpy_r_i = cpy_r_r249;
    goto CPyL115;
CPyL126: ;
    cpy_r_probable_camel_cased = 0;
    cpy_r_r250 = (CPyPtr)&((PyVarObject *)cpy_r_r226)->ob_size;
    cpy_r_r251 = *(int64_t *)cpy_r_r250;
    cpy_r_r252 = cpy_r_r251 << 1;
    cpy_r_r253 = cpy_r_r252 != 0;
    if (!cpy_r_r253) goto CPyL164;
    cpy_r_r254 = (CPyPtr)&((PyVarObject *)cpy_r_r226)->ob_size;
    cpy_r_r255 = *(int64_t *)cpy_r_r254;
    CPy_DECREF_NO_IMM(cpy_r_r226);
    cpy_r_r256 = cpy_r_r255 << 1;
    cpy_r_r257 = CPyTagged_TrueDivide(cpy_r_r256, cpy_r_buffer_length);
    CPyTagged_DECREF(cpy_r_buffer_length);
    cpy_r_r258 = cpy_r_r257 == -113.0;
    if (unlikely(cpy_r_r258)) goto CPyL129;
CPyL128: ;
    cpy_r_r259 = cpy_r_r257 <= 0.3;
    if (cpy_r_r259) {
        goto CPyL130;
    } else
        goto CPyL131;
CPyL129: ;
    cpy_r_r260 = PyErr_Occurred();
    if (unlikely(cpy_r_r260 != NULL)) {
        CPy_AddTraceback("src/charset_normalizer/md.py", "feed", 327, CPyStatic_globals);
        goto CPyL149;
    } else
        goto CPyL128;
CPyL130: ;
    cpy_r_probable_camel_cased = 1;
CPyL131: ;
    if (cpy_r_probable_camel_cased) goto CPyL133;
    cpy_r_r261 = ((charset_normalizer___md___SuperWeirdWordPluginObject *)cpy_r_self)->__foreign_long_count;
    cpy_r_r262 = CPyTagged_Add(cpy_r_r261, 2);
    CPyTagged_DECREF(((charset_normalizer___md___SuperWeirdWordPluginObject *)cpy_r_self)->__foreign_long_count);
    ((charset_normalizer___md___SuperWeirdWordPluginObject *)cpy_r_self)->__foreign_long_count = cpy_r_r262;
    ((charset_normalizer___md___SuperWeirdWordPluginObject *)cpy_r_self)->__is_current_word_bad = 1;
CPyL133: ;
    cpy_r_r265 = ((charset_normalizer___md___SuperWeirdWordPluginObject *)cpy_r_self)->__is_current_word_bad;
    if (!cpy_r_r265) goto CPyL136;
CPyL134: ;
    cpy_r_r266 = ((charset_normalizer___md___SuperWeirdWordPluginObject *)cpy_r_self)->__bad_word_count;
    cpy_r_r267 = CPyTagged_Add(cpy_r_r266, 2);
    CPyTagged_DECREF(((charset_normalizer___md___SuperWeirdWordPluginObject *)cpy_r_self)->__bad_word_count);
    ((charset_normalizer___md___SuperWeirdWordPluginObject *)cpy_r_self)->__bad_word_count = cpy_r_r267;
    cpy_r_r269 = ((charset_normalizer___md___SuperWeirdWordPluginObject *)cpy_r_self)->__bad_character_count;
    CPyTagged_INCREF(cpy_r_r269);
    cpy_r_r270 = ((charset_normalizer___md___SuperWeirdWordPluginObject *)cpy_r_self)->__buffer;
    CPy_INCREF(cpy_r_r270);
    cpy_r_r271 = CPyStr_Size_size_t(cpy_r_r270);
    CPy_DECREF(cpy_r_r270);
    cpy_r_r272 = cpy_r_r271 >= 0;
    if (unlikely(!cpy_r_r272)) {
        CPy_AddTraceback("src/charset_normalizer/md.py", "feed", 336, CPyStatic_globals);
        goto CPyL165;
    }
    cpy_r_r273 = cpy_r_r271 << 1;
    cpy_r_r274 = CPyTagged_Add(cpy_r_r269, cpy_r_r273);
    CPyTagged_DECREF(cpy_r_r269);
    CPyTagged_DECREF(((charset_normalizer___md___SuperWeirdWordPluginObject *)cpy_r_self)->__bad_character_count);
    ((charset_normalizer___md___SuperWeirdWordPluginObject *)cpy_r_self)->__bad_character_count = cpy_r_r274;
    ((charset_normalizer___md___SuperWeirdWordPluginObject *)cpy_r_self)->__is_current_word_bad = 0;
CPyL136: ;
    ((charset_normalizer___md___SuperWeirdWordPluginObject *)cpy_r_self)->__foreign_long_watch = 0;
    cpy_r_r278 = CPyStatics[19]; /* '' */
    CPy_INCREF(cpy_r_r278);
    CPy_DECREF(((charset_normalizer___md___SuperWeirdWordPluginObject *)cpy_r_self)->__buffer);
    ((charset_normalizer___md___SuperWeirdWordPluginObject *)cpy_r_self)->__buffer = cpy_r_r278;
    CPyTagged_DECREF(((charset_normalizer___md___SuperWeirdWordPluginObject *)cpy_r_self)->__buffer_accent_count);
    ((charset_normalizer___md___SuperWeirdWordPluginObject *)cpy_r_self)->__buffer_accent_count = 0;
    CPyTagged_DECREF(((charset_normalizer___md___SuperWeirdWordPluginObject *)cpy_r_self)->__buffer_glyph_count);
    ((charset_normalizer___md___SuperWeirdWordPluginObject *)cpy_r_self)->__buffer_glyph_count = 0;
    goto CPyL148;
CPyL137: ;
    cpy_r_r282 = CPyStatics[124]; /* frozenset({'<', '-', '>', '=', '~', '|', '_'}) */
    cpy_r_r283 = PySet_Contains(cpy_r_r282, cpy_r_character);
    cpy_r_r284 = cpy_r_r283 >= 0;
    if (unlikely(!cpy_r_r284)) {
        CPy_AddTraceback("src/charset_normalizer/md.py", "feed", 344, CPyStatic_globals);
        goto CPyL149;
    }
    cpy_r_r285 = cpy_r_r283;
    cpy_r_r286 = cpy_r_r285 ^ 1;
    if (!cpy_r_r286) goto CPyL148;
    cpy_r_r287 = CPyStatics[7]; /* 'isdigit' */
    PyObject *cpy_r_r288[1] = {cpy_r_character};
    cpy_r_r289 = (PyObject **)&cpy_r_r288;
    cpy_r_r290 = PyObject_VectorcallMethod(cpy_r_r287, cpy_r_r289, 9223372036854775809ULL, 0);
    if (unlikely(cpy_r_r290 == NULL)) {
        CPy_AddTraceback("src/charset_normalizer/md.py", "feed", 345, CPyStatic_globals);
        goto CPyL149;
    }
    if (unlikely(!PyBool_Check(cpy_r_r290))) {
        CPy_TypeError("bool", cpy_r_r290); cpy_r_r291 = 2;
    } else
        cpy_r_r291 = cpy_r_r290 == Py_True;
    CPy_DECREF(cpy_r_r290);
    if (unlikely(cpy_r_r291 == 2)) {
        CPy_AddTraceback("src/charset_normalizer/md.py", "feed", 345, CPyStatic_globals);
        goto CPyL149;
    }
    cpy_r_r292 = cpy_r_r291 ? Py_True : Py_False;
    cpy_r_r293 = 0 ? Py_True : Py_False;
    cpy_r_r294 = cpy_r_r292 == cpy_r_r293;
    if (!cpy_r_r294) goto CPyL148;
    cpy_r_r295 = CPyStatic_globals;
    cpy_r_r296 = CPyStatics[8]; /* 'is_symbol' */
    cpy_r_r297 = CPyDict_GetItem(cpy_r_r295, cpy_r_r296);
    if (unlikely(cpy_r_r297 == NULL)) {
        CPy_AddTraceback("src/charset_normalizer/md.py", "feed", 346, CPyStatic_globals);
        goto CPyL149;
    }
    PyObject *cpy_r_r298[1] = {cpy_r_character};
    cpy_r_r299 = (PyObject **)&cpy_r_r298;
    cpy_r_r300 = PyObject_Vectorcall(cpy_r_r297, cpy_r_r299, 1, 0);
    CPy_DECREF(cpy_r_r297);
    if (unlikely(cpy_r_r300 == NULL)) {
        CPy_AddTraceback("src/charset_normalizer/md.py", "feed", 346, CPyStatic_globals);
        goto CPyL149;
    }
    if (unlikely(!PyBool_Check(cpy_r_r300))) {
        CPy_TypeError("bool", cpy_r_r300); cpy_r_r301 = 2;
    } else
        cpy_r_r301 = cpy_r_r300 == Py_True;
    CPy_DECREF(cpy_r_r300);
    if (unlikely(cpy_r_r301 == 2)) {
        CPy_AddTraceback("src/charset_normalizer/md.py", "feed", 346, CPyStatic_globals);
        goto CPyL149;
    }
    if (!cpy_r_r301) goto CPyL148;
    ((charset_normalizer___md___SuperWeirdWordPluginObject *)cpy_r_self)->__is_current_word_bad = 1;
    cpy_r_r303 = ((charset_normalizer___md___SuperWeirdWordPluginObject *)cpy_r_self)->__buffer;
    CPy_INCREF(cpy_r_r303);
    cpy_r_r304 = CPyStr_Append(cpy_r_r303, cpy_r_character);
    if (unlikely(cpy_r_r304 == NULL)) {
        CPy_AddTraceback("src/charset_normalizer/md.py", "feed", 349, CPyStatic_globals);
        goto CPyL149;
    }
    CPy_DECREF(((charset_normalizer___md___SuperWeirdWordPluginObject *)cpy_r_self)->__buffer);
    ((charset_normalizer___md___SuperWeirdWordPluginObject *)cpy_r_self)->__buffer = cpy_r_r304;
CPyL148: ;
    return 1;
CPyL149: ;
    cpy_r_r306 = 2;
    return cpy_r_r306;
CPyL150: ;
    CPyTagged_DecRef(cpy_r_buffer_length);
    goto CPyL149;
CPyL151: ;
    CPyTagged_DecRef(cpy_r_buffer_length);
    CPy_DecRef(cpy_r_r175);
    goto CPyL149;
CPyL152: ;
    CPyTagged_DecRef(cpy_r_buffer_length);
    CPy_DecRef(cpy_r_r184);
    goto CPyL149;
CPyL153: ;
    CPyTagged_DecRef(cpy_r_buffer_length);
    CPy_DecRef(cpy_r_r191);
    goto CPyL149;
CPyL154: ;
    CPy_DECREF(cpy_r_r191);
    goto CPyL103;
CPyL155: ;
    CPyTagged_DecRef(cpy_r_buffer_length);
    CPy_DecRef(cpy_r_r191);
    CPy_DecRef(cpy_r_r197);
    goto CPyL149;
CPyL156: ;
    CPy_DECREF(cpy_r_r191);
    goto CPyL101;
CPyL157: ;
    CPyTagged_DECREF(cpy_r_buffer_length);
    goto CPyL133;
CPyL158: ;
    CPyTagged_DecRef(cpy_r_buffer_length);
    CPy_DecRef(cpy_r_r226);
    CPy_DecRef(cpy_r_r227);
    goto CPyL149;
CPyL159: ;
    CPy_DECREF(cpy_r_r227);
    CPyTagged_DECREF(cpy_r_r231);
    CPyTagged_DECREF(cpy_r_i);
    goto CPyL126;
CPyL160: ;
    CPyTagged_DecRef(cpy_r_buffer_length);
    CPy_DecRef(cpy_r_r226);
    CPy_DecRef(cpy_r_r227);
    CPyTagged_DecRef(cpy_r_r231);
    CPyTagged_DecRef(cpy_r_i);
    goto CPyL149;
CPyL161: ;
    CPyTagged_DecRef(cpy_r_buffer_length);
    CPy_DecRef(cpy_r_r226);
    CPy_DecRef(cpy_r_r227);
    CPyTagged_DecRef(cpy_r_r231);
    CPyTagged_DecRef(cpy_r_i);
    CPy_DecRef(cpy_r_r239);
    goto CPyL149;
CPyL162: ;
    CPyTagged_DECREF(cpy_r_i);
    goto CPyL125;
CPyL163: ;
    CPyTagged_DecRef(cpy_r_buffer_length);
    CPy_DecRef(cpy_r_r226);
    CPy_DecRef(cpy_r_r227);
    CPyTagged_DecRef(cpy_r_r231);
    goto CPyL149;
CPyL164: ;
    CPyTagged_DECREF(cpy_r_buffer_length);
    CPy_DECREF_NO_IMM(cpy_r_r226);
    goto CPyL131;
CPyL165: ;
    CPyTagged_DecRef(cpy_r_r269);
    goto CPyL149;
}

PyObject *CPyPy_SuperWeirdWordPlugin___feed(PyObject *self, PyObject *const *args, size_t nargs, PyObject *kwnames) {
    PyObject *obj_self = self;
    static const char * const kwlist[] = {"character", 0};
    static CPyArg_Parser parser = {"O:feed", kwlist, 0};
    PyObject *obj_character;
    if (!CPyArg_ParseStackAndKeywordsOneArg(args, nargs, kwnames, &parser, &obj_character)) {
        return NULL;
    }
    PyObject *arg_self;
    if (likely(Py_TYPE(obj_self) == CPyType_SuperWeirdWordPlugin))
        arg_self = obj_self;
    else {
        CPy_TypeError("charset_normalizer.md.SuperWeirdWordPlugin", obj_self); 
        goto fail;
    }
    PyObject *arg_character;
    if (likely(PyUnicode_Check(obj_character)))
        arg_character = obj_character;
    else {
        CPy_TypeError("str", obj_character); 
        goto fail;
    }
    char retval = CPyDef_SuperWeirdWordPlugin___feed(arg_self, arg_character);
    if (retval == 2) {
        return NULL;
    }
    PyObject *retbox = Py_None;
    CPy_INCREF(retbox);
    return retbox;
fail: ;
    CPy_AddTraceback("src/charset_normalizer/md.py", "feed", 270, CPyStatic_globals);
    return NULL;
}

char CPyDef_SuperWeirdWordPlugin___reset(PyObject *cpy_r_self) {
    PyObject *cpy_r_r0;
    char cpy_r_r1;
    char cpy_r_r2;
    char cpy_r_r3;
    char cpy_r_r4;
    char cpy_r_r5;
    char cpy_r_r6;
    char cpy_r_r7;
    char cpy_r_r8;
    cpy_r_r0 = CPyStatics[19]; /* '' */
    CPy_INCREF(cpy_r_r0);
    CPy_DECREF(((charset_normalizer___md___SuperWeirdWordPluginObject *)cpy_r_self)->__buffer);
    ((charset_normalizer___md___SuperWeirdWordPluginObject *)cpy_r_self)->__buffer = cpy_r_r0;
    ((charset_normalizer___md___SuperWeirdWordPluginObject *)cpy_r_self)->__is_current_word_bad = 0;
    ((charset_normalizer___md___SuperWeirdWordPluginObject *)cpy_r_self)->__foreign_long_watch = 0;
    CPyTagged_DECREF(((charset_normalizer___md___SuperWeirdWordPluginObject *)cpy_r_self)->__bad_word_count);
    ((charset_normalizer___md___SuperWeirdWordPluginObject *)cpy_r_self)->__bad_word_count = 0;
    CPyTagged_DECREF(((charset_normalizer___md___SuperWeirdWordPluginObject *)cpy_r_self)->__word_count);
    ((charset_normalizer___md___SuperWeirdWordPluginObject *)cpy_r_self)->__word_count = 0;
    CPyTagged_DECREF(((charset_normalizer___md___SuperWeirdWordPluginObject *)cpy_r_self)->__character_count);
    ((charset_normalizer___md___SuperWeirdWordPluginObject *)cpy_r_self)->__character_count = 0;
    CPyTagged_DECREF(((charset_normalizer___md___SuperWeirdWordPluginObject *)cpy_r_self)->__bad_character_count);
    ((charset_normalizer___md___SuperWeirdWordPluginObject *)cpy_r_self)->__bad_character_count = 0;
    CPyTagged_DECREF(((charset_normalizer___md___SuperWeirdWordPluginObject *)cpy_r_self)->__foreign_long_count);
    ((charset_normalizer___md___SuperWeirdWordPluginObject *)cpy_r_self)->__foreign_long_count = 0;
    return 1;
}

PyObject *CPyPy_SuperWeirdWordPlugin___reset(PyObject *self, PyObject *const *args, size_t nargs, PyObject *kwnames) {
    PyObject *obj_self = self;
    static const char * const kwlist[] = {0};
    static CPyArg_Parser parser = {":reset", kwlist, 0};
    if (!CPyArg_ParseStackAndKeywordsNoArgs(args, nargs, kwnames, &parser)) {
        return NULL;
    }
    PyObject *arg_self;
    if (likely(Py_TYPE(obj_self) == CPyType_SuperWeirdWordPlugin))
        arg_self = obj_self;
    else {
        CPy_TypeError("charset_normalizer.md.SuperWeirdWordPlugin", obj_self); 
        goto fail;
    }
    char retval = CPyDef_SuperWeirdWordPlugin___reset(arg_self);
    if (retval == 2) {
        return NULL;
    }
    PyObject *retbox = Py_None;
    CPy_INCREF(retbox);
    return retbox;
fail: ;
    CPy_AddTraceback("src/charset_normalizer/md.py", "reset", 351, CPyStatic_globals);
    return NULL;
}

double CPyDef_SuperWeirdWordPlugin___ratio(PyObject *cpy_r_self) {
    CPyTagged cpy_r_r0;
    int64_t cpy_r_r1;
    char cpy_r_r2;
    int64_t cpy_r_r3;
    char cpy_r_r4;
    char cpy_r_r5;
    char cpy_r_r6;
    char cpy_r_r7;
    CPyTagged cpy_r_r8;
    char cpy_r_r9;
    CPyTagged cpy_r_r10;
    CPyTagged cpy_r_r11;
    double cpy_r_r12;
    char cpy_r_r13;
    PyObject *cpy_r_r14;
    double cpy_r_r15;
    cpy_r_r0 = ((charset_normalizer___md___SuperWeirdWordPluginObject *)cpy_r_self)->__word_count;
    cpy_r_r1 = cpy_r_r0 & 1;
    cpy_r_r2 = cpy_r_r1 != 0;
    if (cpy_r_r2) goto CPyL2;
    cpy_r_r3 = 20 & 1;
    cpy_r_r4 = cpy_r_r3 != 0;
    if (!cpy_r_r4) goto CPyL3;
CPyL2: ;
    cpy_r_r5 = CPyTagged_IsLt_(20, cpy_r_r0);
    cpy_r_r6 = cpy_r_r5 ^ 1;
    if (cpy_r_r6) {
        goto CPyL4;
    } else
        goto CPyL6;
CPyL3: ;
    cpy_r_r7 = (Py_ssize_t)cpy_r_r0 <= (Py_ssize_t)20;
    if (!cpy_r_r7) goto CPyL6;
CPyL4: ;
    cpy_r_r8 = ((charset_normalizer___md___SuperWeirdWordPluginObject *)cpy_r_self)->__foreign_long_count;
    cpy_r_r9 = cpy_r_r8 == 0;
    if (!cpy_r_r9) goto CPyL6;
    return 0.0;
CPyL6: ;
    cpy_r_r10 = ((charset_normalizer___md___SuperWeirdWordPluginObject *)cpy_r_self)->__bad_character_count;
    CPyTagged_INCREF(cpy_r_r10);
    cpy_r_r11 = ((charset_normalizer___md___SuperWeirdWordPluginObject *)cpy_r_self)->__character_count;
    CPyTagged_INCREF(cpy_r_r11);
    cpy_r_r12 = CPyTagged_TrueDivide(cpy_r_r10, cpy_r_r11);
    CPyTagged_DECREF(cpy_r_r10);
    CPyTagged_DECREF(cpy_r_r11);
    cpy_r_r13 = cpy_r_r12 == -113.0;
    if (unlikely(cpy_r_r13)) goto CPyL8;
CPyL7: ;
    return cpy_r_r12;
CPyL8: ;
    cpy_r_r14 = PyErr_Occurred();
    if (unlikely(cpy_r_r14 != NULL)) {
        CPy_AddTraceback("src/charset_normalizer/md.py", "ratio", 366, CPyStatic_globals);
    } else
        goto CPyL7;
    cpy_r_r15 = -113.0;
    return cpy_r_r15;
}

PyObject *CPyPy_SuperWeirdWordPlugin___ratio(PyObject *self, PyObject *const *args, size_t nargs, PyObject *kwnames) {
    PyObject *obj_self = self;
    static const char * const kwlist[] = {0};
    static CPyArg_Parser parser = {":ratio", kwlist, 0};
    if (!CPyArg_ParseStackAndKeywordsNoArgs(args, nargs, kwnames, &parser)) {
        return NULL;
    }
    PyObject *arg_self;
    if (likely(Py_TYPE(obj_self) == CPyType_SuperWeirdWordPlugin))
        arg_self = obj_self;
    else {
        CPy_TypeError("charset_normalizer.md.SuperWeirdWordPlugin", obj_self); 
        goto fail;
    }
    double retval = CPyDef_SuperWeirdWordPlugin___ratio(arg_self);
    if (retval == -113.0 && PyErr_Occurred()) {
        return NULL;
    }
    PyObject *retbox = PyFloat_FromDouble(retval);
    return retbox;
fail: ;
    CPy_AddTraceback("src/charset_normalizer/md.py", "ratio", 362, CPyStatic_globals);
    return NULL;
}

char CPyDef_CjkUncommonPlugin_____init__(PyObject *cpy_r_self) {
    ((charset_normalizer___md___CjkUncommonPluginObject *)cpy_r_self)->__character_count = 0;
    ((charset_normalizer___md___CjkUncommonPluginObject *)cpy_r_self)->__uncommon_count = 0;
    return 1;
}

PyObject *CPyPy_CjkUncommonPlugin_____init__(PyObject *self, PyObject *args, PyObject *kw) {
    PyObject *obj_self = self;
    static const char * const kwlist[] = {0};
    if (!CPyArg_ParseTupleAndKeywords(args, kw, "", "__init__", kwlist)) {
        return NULL;
    }
    PyObject *arg_self;
    if (likely(Py_TYPE(obj_self) == CPyType_CjkUncommonPlugin))
        arg_self = obj_self;
    else {
        CPy_TypeError("charset_normalizer.md.CjkUncommonPlugin", obj_self); 
        goto fail;
    }
    char retval = CPyDef_CjkUncommonPlugin_____init__(arg_self);
    if (retval == 2) {
        return NULL;
    }
    PyObject *retbox = Py_None;
    CPy_INCREF(retbox);
    return retbox;
fail: ;
    CPy_AddTraceback("src/charset_normalizer/md.py", "__init__", 374, CPyStatic_globals);
    return NULL;
}

char CPyDef_CjkUncommonPlugin___eligible(PyObject *cpy_r_self, PyObject *cpy_r_character) {
    PyObject *cpy_r_r0;
    PyObject *cpy_r_r1;
    PyObject *cpy_r_r2;
    PyObject **cpy_r_r4;
    PyObject *cpy_r_r5;
    char cpy_r_r6;
    char cpy_r_r7;
    cpy_r_r0 = CPyStatic_globals;
    cpy_r_r1 = CPyStatics[20]; /* 'is_cjk' */
    cpy_r_r2 = CPyDict_GetItem(cpy_r_r0, cpy_r_r1);
    if (unlikely(cpy_r_r2 == NULL)) {
        CPy_AddTraceback("src/charset_normalizer/md.py", "eligible", 379, CPyStatic_globals);
        goto CPyL4;
    }
    PyObject *cpy_r_r3[1] = {cpy_r_character};
    cpy_r_r4 = (PyObject **)&cpy_r_r3;
    cpy_r_r5 = PyObject_Vectorcall(cpy_r_r2, cpy_r_r4, 1, 0);
    CPy_DECREF(cpy_r_r2);
    if (unlikely(cpy_r_r5 == NULL)) {
        CPy_AddTraceback("src/charset_normalizer/md.py", "eligible", 379, CPyStatic_globals);
        goto CPyL4;
    }
    if (unlikely(!PyBool_Check(cpy_r_r5))) {
        CPy_TypeError("bool", cpy_r_r5); cpy_r_r6 = 2;
    } else
        cpy_r_r6 = cpy_r_r5 == Py_True;
    CPy_DECREF(cpy_r_r5);
    if (unlikely(cpy_r_r6 == 2)) {
        CPy_AddTraceback("src/charset_normalizer/md.py", "eligible", 379, CPyStatic_globals);
        goto CPyL4;
    }
    return cpy_r_r6;
CPyL4: ;
    cpy_r_r7 = 2;
    return cpy_r_r7;
}

PyObject *CPyPy_CjkUncommonPlugin___eligible(PyObject *self, PyObject *const *args, size_t nargs, PyObject *kwnames) {
    PyObject *obj_self = self;
    static const char * const kwlist[] = {"character", 0};
    static CPyArg_Parser parser = {"O:eligible", kwlist, 0};
    PyObject *obj_character;
    if (!CPyArg_ParseStackAndKeywordsOneArg(args, nargs, kwnames, &parser, &obj_character)) {
        return NULL;
    }
    PyObject *arg_self;
    if (likely(Py_TYPE(obj_self) == CPyType_CjkUncommonPlugin))
        arg_self = obj_self;
    else {
        CPy_TypeError("charset_normalizer.md.CjkUncommonPlugin", obj_self); 
        goto fail;
    }
    PyObject *arg_character;
    if (likely(PyUnicode_Check(obj_character)))
        arg_character = obj_character;
    else {
        CPy_TypeError("str", obj_character); 
        goto fail;
    }
    char retval = CPyDef_CjkUncommonPlugin___eligible(arg_self, arg_character);
    if (retval == 2) {
        return NULL;
    }
    PyObject *retbox = retval ? Py_True : Py_False;
    CPy_INCREF(retbox);
    return retbox;
fail: ;
    CPy_AddTraceback("src/charset_normalizer/md.py", "eligible", 378, CPyStatic_globals);
    return NULL;
}

char CPyDef_CjkUncommonPlugin___feed(PyObject *cpy_r_self, PyObject *cpy_r_character) {
    CPyTagged cpy_r_r0;
    CPyTagged cpy_r_r1;
    char cpy_r_r2;
    PyObject *cpy_r_r3;
    PyObject *cpy_r_r4;
    PyObject *cpy_r_r5;
    PyObject **cpy_r_r7;
    PyObject *cpy_r_r8;
    char cpy_r_r9;
    CPyTagged cpy_r_r10;
    CPyTagged cpy_r_r11;
    char cpy_r_r12;
    char cpy_r_r13;
    cpy_r_r0 = ((charset_normalizer___md___CjkUncommonPluginObject *)cpy_r_self)->__character_count;
    cpy_r_r1 = CPyTagged_Add(cpy_r_r0, 2);
    CPyTagged_DECREF(((charset_normalizer___md___CjkUncommonPluginObject *)cpy_r_self)->__character_count);
    ((charset_normalizer___md___CjkUncommonPluginObject *)cpy_r_self)->__character_count = cpy_r_r1;
    cpy_r_r3 = CPyStatic_globals;
    cpy_r_r4 = CPyStatics[33]; /* 'is_cjk_uncommon' */
    cpy_r_r5 = CPyDict_GetItem(cpy_r_r3, cpy_r_r4);
    if (unlikely(cpy_r_r5 == NULL)) {
        CPy_AddTraceback("src/charset_normalizer/md.py", "feed", 384, CPyStatic_globals);
        goto CPyL6;
    }
    PyObject *cpy_r_r6[1] = {cpy_r_character};
    cpy_r_r7 = (PyObject **)&cpy_r_r6;
    cpy_r_r8 = PyObject_Vectorcall(cpy_r_r5, cpy_r_r7, 1, 0);
    CPy_DECREF(cpy_r_r5);
    if (unlikely(cpy_r_r8 == NULL)) {
        CPy_AddTraceback("src/charset_normalizer/md.py", "feed", 384, CPyStatic_globals);
        goto CPyL6;
    }
    if (unlikely(!PyBool_Check(cpy_r_r8))) {
        CPy_TypeError("bool", cpy_r_r8); cpy_r_r9 = 2;
    } else
        cpy_r_r9 = cpy_r_r8 == Py_True;
    CPy_DECREF(cpy_r_r8);
    if (unlikely(cpy_r_r9 == 2)) {
        CPy_AddTraceback("src/charset_normalizer/md.py", "feed", 384, CPyStatic_globals);
        goto CPyL6;
    }
    if (!cpy_r_r9) goto CPyL5;
    cpy_r_r10 = ((charset_normalizer___md___CjkUncommonPluginObject *)cpy_r_self)->__uncommon_count;
    cpy_r_r11 = CPyTagged_Add(cpy_r_r10, 2);
    CPyTagged_DECREF(((charset_normalizer___md___CjkUncommonPluginObject *)cpy_r_self)->__uncommon_count);
    ((charset_normalizer___md___CjkUncommonPluginObject *)cpy_r_self)->__uncommon_count = cpy_r_r11;
    return 1;
CPyL5: ;
    return 1;
CPyL6: ;
    cpy_r_r13 = 2;
    return cpy_r_r13;
}

PyObject *CPyPy_CjkUncommonPlugin___feed(PyObject *self, PyObject *const *args, size_t nargs, PyObject *kwnames) {
    PyObject *obj_self = self;
    static const char * const kwlist[] = {"character", 0};
    static CPyArg_Parser parser = {"O:feed", kwlist, 0};
    PyObject *obj_character;
    if (!CPyArg_ParseStackAndKeywordsOneArg(args, nargs, kwnames, &parser, &obj_character)) {
        return NULL;
    }
    PyObject *arg_self;
    if (likely(Py_TYPE(obj_self) == CPyType_CjkUncommonPlugin))
        arg_self = obj_self;
    else {
        CPy_TypeError("charset_normalizer.md.CjkUncommonPlugin", obj_self); 
        goto fail;
    }
    PyObject *arg_character;
    if (likely(PyUnicode_Check(obj_character)))
        arg_character = obj_character;
    else {
        CPy_TypeError("str", obj_character); 
        goto fail;
    }
    char retval = CPyDef_CjkUncommonPlugin___feed(arg_self, arg_character);
    if (retval == 2) {
        return NULL;
    }
    PyObject *retbox = Py_None;
    CPy_INCREF(retbox);
    return retbox;
fail: ;
    CPy_AddTraceback("src/charset_normalizer/md.py", "feed", 381, CPyStatic_globals);
    return NULL;
}

char CPyDef_CjkUncommonPlugin___reset(PyObject *cpy_r_self) {
    char cpy_r_r0;
    char cpy_r_r1;
    CPyTagged_DECREF(((charset_normalizer___md___CjkUncommonPluginObject *)cpy_r_self)->__character_count);
    ((charset_normalizer___md___CjkUncommonPluginObject *)cpy_r_self)->__character_count = 0;
    CPyTagged_DECREF(((charset_normalizer___md___CjkUncommonPluginObject *)cpy_r_self)->__uncommon_count);
    ((charset_normalizer___md___CjkUncommonPluginObject *)cpy_r_self)->__uncommon_count = 0;
    return 1;
}

PyObject *CPyPy_CjkUncommonPlugin___reset(PyObject *self, PyObject *const *args, size_t nargs, PyObject *kwnames) {
    PyObject *obj_self = self;
    static const char * const kwlist[] = {0};
    static CPyArg_Parser parser = {":reset", kwlist, 0};
    if (!CPyArg_ParseStackAndKeywordsNoArgs(args, nargs, kwnames, &parser)) {
        return NULL;
    }
    PyObject *arg_self;
    if (likely(Py_TYPE(obj_self) == CPyType_CjkUncommonPlugin))
        arg_self = obj_self;
    else {
        CPy_TypeError("charset_normalizer.md.CjkUncommonPlugin", obj_self); 
        goto fail;
    }
    char retval = CPyDef_CjkUncommonPlugin___reset(arg_self);
    if (retval == 2) {
        return NULL;
    }
    PyObject *retbox = Py_None;
    CPy_INCREF(retbox);
    return retbox;
fail: ;
    CPy_AddTraceback("src/charset_normalizer/md.py", "reset", 388, CPyStatic_globals);
    return NULL;
}

double CPyDef_CjkUncommonPlugin___ratio(PyObject *cpy_r_self) {
    CPyTagged cpy_r_r0;
    int64_t cpy_r_r1;
    char cpy_r_r2;
    int64_t cpy_r_r3;
    char cpy_r_r4;
    char cpy_r_r5;
    char cpy_r_r6;
    CPyTagged cpy_r_r7;
    CPyTagged cpy_r_r8;
    double cpy_r_r9;
    char cpy_r_r10;
    char cpy_r_r11;
    PyObject *cpy_r_r12;
    double cpy_r_r13;
    double cpy_r_r14;
    double cpy_r_r15;
    cpy_r_r0 = ((charset_normalizer___md___CjkUncommonPluginObject *)cpy_r_self)->__character_count;
    cpy_r_r1 = cpy_r_r0 & 1;
    cpy_r_r2 = cpy_r_r1 != 0;
    if (cpy_r_r2) goto CPyL2;
    cpy_r_r3 = 16 & 1;
    cpy_r_r4 = cpy_r_r3 != 0;
    if (!cpy_r_r4) goto CPyL3;
CPyL2: ;
    cpy_r_r5 = CPyTagged_IsLt_(cpy_r_r0, 16);
    if (cpy_r_r5) {
        goto CPyL4;
    } else
        goto CPyL5;
CPyL3: ;
    cpy_r_r6 = (Py_ssize_t)cpy_r_r0 < (Py_ssize_t)16;
    if (!cpy_r_r6) goto CPyL5;
CPyL4: ;
    return 0.0;
CPyL5: ;
    cpy_r_r7 = ((charset_normalizer___md___CjkUncommonPluginObject *)cpy_r_self)->__uncommon_count;
    CPyTagged_INCREF(cpy_r_r7);
    cpy_r_r8 = ((charset_normalizer___md___CjkUncommonPluginObject *)cpy_r_self)->__character_count;
    CPyTagged_INCREF(cpy_r_r8);
    cpy_r_r9 = CPyTagged_TrueDivide(cpy_r_r7, cpy_r_r8);
    CPyTagged_DECREF(cpy_r_r7);
    CPyTagged_DECREF(cpy_r_r8);
    cpy_r_r10 = cpy_r_r9 == -113.0;
    if (unlikely(cpy_r_r10)) goto CPyL7;
CPyL6: ;
    cpy_r_r11 = cpy_r_r9 > 0.5;
    if (cpy_r_r11) {
        goto CPyL8;
    } else
        goto CPyL9;
CPyL7: ;
    cpy_r_r12 = PyErr_Occurred();
    if (unlikely(cpy_r_r12 != NULL)) {
        CPy_AddTraceback("src/charset_normalizer/md.py", "ratio", 397, CPyStatic_globals);
        goto CPyL11;
    } else
        goto CPyL6;
CPyL8: ;
    cpy_r_r13 = cpy_r_r9 / 10.0;
    cpy_r_r14 = cpy_r_r13;
    goto CPyL10;
CPyL9: ;
    cpy_r_r14 = 0.0;
CPyL10: ;
    return cpy_r_r14;
CPyL11: ;
    cpy_r_r15 = -113.0;
    return cpy_r_r15;
}

PyObject *CPyPy_CjkUncommonPlugin___ratio(PyObject *self, PyObject *const *args, size_t nargs, PyObject *kwnames) {
    PyObject *obj_self = self;
    static const char * const kwlist[] = {0};
    static CPyArg_Parser parser = {":ratio", kwlist, 0};
    if (!CPyArg_ParseStackAndKeywordsNoArgs(args, nargs, kwnames, &parser)) {
        return NULL;
    }
    PyObject *arg_self;
    if (likely(Py_TYPE(obj_self) == CPyType_CjkUncommonPlugin))
        arg_self = obj_self;
    else {
        CPy_TypeError("charset_normalizer.md.CjkUncommonPlugin", obj_self); 
        goto fail;
    }
    double retval = CPyDef_CjkUncommonPlugin___ratio(arg_self);
    if (retval == -113.0 && PyErr_Occurred()) {
        return NULL;
    }
    PyObject *retbox = PyFloat_FromDouble(retval);
    return retbox;
fail: ;
    CPy_AddTraceback("src/charset_normalizer/md.py", "ratio", 393, CPyStatic_globals);
    return NULL;
}

char CPyDef_ArchaicUpperLowerPlugin_____init__(PyObject *cpy_r_self) {
    PyObject *cpy_r_r0;
    ((charset_normalizer___md___ArchaicUpperLowerPluginObject *)cpy_r_self)->__buf = 0;
    ((charset_normalizer___md___ArchaicUpperLowerPluginObject *)cpy_r_self)->__character_count_since_last_sep = 0;
    ((charset_normalizer___md___ArchaicUpperLowerPluginObject *)cpy_r_self)->__successive_upper_lower_count = 0;
    ((charset_normalizer___md___ArchaicUpperLowerPluginObject *)cpy_r_self)->__successive_upper_lower_count_final = 0;
    ((charset_normalizer___md___ArchaicUpperLowerPluginObject *)cpy_r_self)->__character_count = 0;
    cpy_r_r0 = Py_None;
    ((charset_normalizer___md___ArchaicUpperLowerPluginObject *)cpy_r_self)->__last_alpha_seen = cpy_r_r0;
    ((charset_normalizer___md___ArchaicUpperLowerPluginObject *)cpy_r_self)->__current_ascii_only = 1;
    return 1;
}

PyObject *CPyPy_ArchaicUpperLowerPlugin_____init__(PyObject *self, PyObject *args, PyObject *kw) {
    PyObject *obj_self = self;
    static const char * const kwlist[] = {0};
    if (!CPyArg_ParseTupleAndKeywords(args, kw, "", "__init__", kwlist)) {
        return NULL;
    }
    PyObject *arg_self;
    if (likely(Py_TYPE(obj_self) == CPyType_ArchaicUpperLowerPlugin))
        arg_self = obj_self;
    else {
        CPy_TypeError("charset_normalizer.md.ArchaicUpperLowerPlugin", obj_self); 
        goto fail;
    }
    char retval = CPyDef_ArchaicUpperLowerPlugin_____init__(arg_self);
    if (retval == 2) {
        return NULL;
    }
    PyObject *retbox = Py_None;
    CPy_INCREF(retbox);
    return retbox;
fail: ;
    CPy_AddTraceback("src/charset_normalizer/md.py", "__init__", 405, CPyStatic_globals);
    return NULL;
}

char CPyDef_ArchaicUpperLowerPlugin___eligible(PyObject *cpy_r_self, PyObject *cpy_r_character) {
    return 1;
}

PyObject *CPyPy_ArchaicUpperLowerPlugin___eligible(PyObject *self, PyObject *const *args, size_t nargs, PyObject *kwnames) {
    PyObject *obj_self = self;
    static const char * const kwlist[] = {"character", 0};
    static CPyArg_Parser parser = {"O:eligible", kwlist, 0};
    PyObject *obj_character;
    if (!CPyArg_ParseStackAndKeywordsOneArg(args, nargs, kwnames, &parser, &obj_character)) {
        return NULL;
    }
    PyObject *arg_self;
    if (likely(Py_TYPE(obj_self) == CPyType_ArchaicUpperLowerPlugin))
        arg_self = obj_self;
    else {
        CPy_TypeError("charset_normalizer.md.ArchaicUpperLowerPlugin", obj_self); 
        goto fail;
    }
    PyObject *arg_character;
    if (likely(PyUnicode_Check(obj_character)))
        arg_character = obj_character;
    else {
        CPy_TypeError("str", obj_character); 
        goto fail;
    }
    char retval = CPyDef_ArchaicUpperLowerPlugin___eligible(arg_self, arg_character);
    if (retval == 2) {
        return NULL;
    }
    PyObject *retbox = retval ? Py_True : Py_False;
    CPy_INCREF(retbox);
    return retbox;
fail: ;
    CPy_AddTraceback("src/charset_normalizer/md.py", "eligible", 418, CPyStatic_globals);
    return NULL;
}

char CPyDef_ArchaicUpperLowerPlugin___feed(PyObject *cpy_r_self, PyObject *cpy_r_character) {
    PyObject *cpy_r_r0;
    PyObject **cpy_r_r2;
    PyObject *cpy_r_r3;
    char cpy_r_r4;
    char cpy_r_r5;
    PyObject *cpy_r_r6;
    PyObject *cpy_r_r7;
    PyObject *cpy_r_r8;
    PyObject **cpy_r_r10;
    PyObject *cpy_r_r11;
    char cpy_r_r12;
    char cpy_r_is_concerned;
    PyObject *cpy_r_r13;
    PyObject *cpy_r_r14;
    char cpy_r_r15;
    char cpy_r_chunk_sep;
    CPyTagged cpy_r_r16;
    int64_t cpy_r_r17;
    char cpy_r_r18;
    int64_t cpy_r_r19;
    char cpy_r_r20;
    char cpy_r_r21;
    char cpy_r_r22;
    CPyTagged cpy_r_r23;
    int64_t cpy_r_r24;
    char cpy_r_r25;
    int64_t cpy_r_r26;
    char cpy_r_r27;
    char cpy_r_r28;
    char cpy_r_r29;
    char cpy_r_r30;
    PyObject *cpy_r_r31;
    PyObject **cpy_r_r33;
    PyObject *cpy_r_r34;
    char cpy_r_r35;
    PyObject *cpy_r_r36;
    PyObject *cpy_r_r37;
    char cpy_r_r38;
    char cpy_r_r39;
    PyObject *cpy_r_r40;
    PyObject *cpy_r_r41;
    char cpy_r_r42;
    CPyTagged cpy_r_r43;
    CPyTagged cpy_r_r44;
    CPyTagged cpy_r_r45;
    char cpy_r_r46;
    char cpy_r_r47;
    char cpy_r_r48;
    PyObject *cpy_r_r49;
    char cpy_r_r50;
    char cpy_r_r51;
    CPyTagged cpy_r_r52;
    CPyTagged cpy_r_r53;
    char cpy_r_r54;
    char cpy_r_r55;
    char cpy_r_r56;
    PyObject *cpy_r_r57;
    PyObject *cpy_r_r58;
    char cpy_r_r59;
    PyObject *cpy_r_r60;
    PyObject **cpy_r_r62;
    PyObject *cpy_r_r63;
    char cpy_r_r64;
    PyObject *cpy_r_r65;
    PyObject *cpy_r_r66;
    char cpy_r_r67;
    char cpy_r_r68;
    PyObject *cpy_r_r69;
    PyObject *cpy_r_r70;
    char cpy_r_r71;
    PyObject *cpy_r_r72;
    PyObject **cpy_r_r74;
    PyObject *cpy_r_r75;
    char cpy_r_r76;
    PyObject *cpy_r_r77;
    PyObject *cpy_r_r78;
    PyObject *cpy_r_r79;
    PyObject **cpy_r_r81;
    PyObject *cpy_r_r82;
    char cpy_r_r83;
    PyObject *cpy_r_r84;
    PyObject **cpy_r_r86;
    PyObject *cpy_r_r87;
    char cpy_r_r88;
    PyObject *cpy_r_r89;
    PyObject *cpy_r_r90;
    PyObject *cpy_r_r91;
    PyObject **cpy_r_r93;
    PyObject *cpy_r_r94;
    char cpy_r_r95;
    char cpy_r_r96;
    PyObject *cpy_r_r97;
    PyObject *cpy_r_r98;
    char cpy_r_r99;
    CPyTagged cpy_r_r100;
    CPyTagged cpy_r_r101;
    char cpy_r_r102;
    char cpy_r_r103;
    char cpy_r_r104;
    char cpy_r_r105;
    CPyTagged cpy_r_r106;
    CPyTagged cpy_r_r107;
    char cpy_r_r108;
    CPyTagged cpy_r_r109;
    CPyTagged cpy_r_r110;
    char cpy_r_r111;
    char cpy_r_r112;
    char cpy_r_r113;
    cpy_r_r0 = CPyStatics[10]; /* 'isalpha' */
    PyObject *cpy_r_r1[1] = {cpy_r_character};
    cpy_r_r2 = (PyObject **)&cpy_r_r1;
    cpy_r_r3 = PyObject_VectorcallMethod(cpy_r_r0, cpy_r_r2, 9223372036854775809ULL, 0);
    if (unlikely(cpy_r_r3 == NULL)) {
        CPy_AddTraceback("src/charset_normalizer/md.py", "feed", 422, CPyStatic_globals);
        goto CPyL48;
    }
    if (unlikely(!PyBool_Check(cpy_r_r3))) {
        CPy_TypeError("bool", cpy_r_r3); cpy_r_r4 = 2;
    } else
        cpy_r_r4 = cpy_r_r3 == Py_True;
    CPy_DECREF(cpy_r_r3);
    if (unlikely(cpy_r_r4 == 2)) {
        CPy_AddTraceback("src/charset_normalizer/md.py", "feed", 422, CPyStatic_globals);
        goto CPyL48;
    }
    if (cpy_r_r4) goto CPyL4;
    cpy_r_r5 = cpy_r_r4;
    goto CPyL8;
CPyL4: ;
    cpy_r_r6 = CPyStatic_globals;
    cpy_r_r7 = CPyStatics[34]; /* 'is_case_variable' */
    cpy_r_r8 = CPyDict_GetItem(cpy_r_r6, cpy_r_r7);
    if (unlikely(cpy_r_r8 == NULL)) {
        CPy_AddTraceback("src/charset_normalizer/md.py", "feed", 422, CPyStatic_globals);
        goto CPyL48;
    }
    PyObject *cpy_r_r9[1] = {cpy_r_character};
    cpy_r_r10 = (PyObject **)&cpy_r_r9;
    cpy_r_r11 = PyObject_Vectorcall(cpy_r_r8, cpy_r_r10, 1, 0);
    CPy_DECREF(cpy_r_r8);
    if (unlikely(cpy_r_r11 == NULL)) {
        CPy_AddTraceback("src/charset_normalizer/md.py", "feed", 422, CPyStatic_globals);
        goto CPyL48;
    }
    if (unlikely(!PyBool_Check(cpy_r_r11))) {
        CPy_TypeError("bool", cpy_r_r11); cpy_r_r12 = 2;
    } else
        cpy_r_r12 = cpy_r_r11 == Py_True;
    CPy_DECREF(cpy_r_r11);
    if (unlikely(cpy_r_r12 == 2)) {
        CPy_AddTraceback("src/charset_normalizer/md.py", "feed", 422, CPyStatic_globals);
        goto CPyL48;
    }
    cpy_r_r5 = cpy_r_r12;
CPyL8: ;
    cpy_r_is_concerned = cpy_r_r5;
    cpy_r_r13 = cpy_r_is_concerned ? Py_True : Py_False;
    cpy_r_r14 = 0 ? Py_True : Py_False;
    cpy_r_r15 = cpy_r_r13 == cpy_r_r14;
    cpy_r_chunk_sep = cpy_r_r15;
    if (!cpy_r_chunk_sep) goto CPyL23;
    cpy_r_r16 = ((charset_normalizer___md___ArchaicUpperLowerPluginObject *)cpy_r_self)->__character_count_since_last_sep;
    cpy_r_r17 = cpy_r_r16 & 1;
    cpy_r_r18 = cpy_r_r17 != 0;
    if (cpy_r_r18) goto CPyL11;
    cpy_r_r19 = 0 & 1;
    cpy_r_r20 = cpy_r_r19 != 0;
    if (!cpy_r_r20) goto CPyL12;
CPyL11: ;
    cpy_r_r21 = CPyTagged_IsLt_(0, cpy_r_r16);
    if (cpy_r_r21) {
        goto CPyL13;
    } else
        goto CPyL23;
CPyL12: ;
    cpy_r_r22 = (Py_ssize_t)cpy_r_r16 > (Py_ssize_t)0;
    if (!cpy_r_r22) goto CPyL23;
CPyL13: ;
    cpy_r_r23 = ((charset_normalizer___md___ArchaicUpperLowerPluginObject *)cpy_r_self)->__character_count_since_last_sep;
    cpy_r_r24 = cpy_r_r23 & 1;
    cpy_r_r25 = cpy_r_r24 != 0;
    if (cpy_r_r25) goto CPyL15;
    cpy_r_r26 = 128 & 1;
    cpy_r_r27 = cpy_r_r26 != 0;
    if (!cpy_r_r27) goto CPyL16;
CPyL15: ;
    cpy_r_r28 = CPyTagged_IsLt_(128, cpy_r_r23);
    cpy_r_r29 = cpy_r_r28 ^ 1;
    if (cpy_r_r29) {
        goto CPyL17;
    } else
        goto CPyL22;
CPyL16: ;
    cpy_r_r30 = (Py_ssize_t)cpy_r_r23 <= (Py_ssize_t)128;
    if (!cpy_r_r30) goto CPyL22;
CPyL17: ;
    cpy_r_r31 = CPyStatics[7]; /* 'isdigit' */
    PyObject *cpy_r_r32[1] = {cpy_r_character};
    cpy_r_r33 = (PyObject **)&cpy_r_r32;
    cpy_r_r34 = PyObject_VectorcallMethod(cpy_r_r31, cpy_r_r33, 9223372036854775809ULL, 0);
    if (unlikely(cpy_r_r34 == NULL)) {
        CPy_AddTraceback("src/charset_normalizer/md.py", "feed", 428, CPyStatic_globals);
        goto CPyL48;
    }
    if (unlikely(!PyBool_Check(cpy_r_r34))) {
        CPy_TypeError("bool", cpy_r_r34); cpy_r_r35 = 2;
    } else
        cpy_r_r35 = cpy_r_r34 == Py_True;
    CPy_DECREF(cpy_r_r34);
    if (unlikely(cpy_r_r35 == 2)) {
        CPy_AddTraceback("src/charset_normalizer/md.py", "feed", 428, CPyStatic_globals);
        goto CPyL48;
    }
    cpy_r_r36 = cpy_r_r35 ? Py_True : Py_False;
    cpy_r_r37 = 0 ? Py_True : Py_False;
    cpy_r_r38 = cpy_r_r36 == cpy_r_r37;
    if (!cpy_r_r38) goto CPyL22;
    cpy_r_r39 = ((charset_normalizer___md___ArchaicUpperLowerPluginObject *)cpy_r_self)->__current_ascii_only;
    cpy_r_r40 = cpy_r_r39 ? Py_True : Py_False;
    cpy_r_r41 = 0 ? Py_True : Py_False;
    cpy_r_r42 = cpy_r_r40 == cpy_r_r41;
    if (!cpy_r_r42) goto CPyL22;
    cpy_r_r43 = ((charset_normalizer___md___ArchaicUpperLowerPluginObject *)cpy_r_self)->__successive_upper_lower_count_final;
    cpy_r_r44 = ((charset_normalizer___md___ArchaicUpperLowerPluginObject *)cpy_r_self)->__successive_upper_lower_count;
    cpy_r_r45 = CPyTagged_Add(cpy_r_r43, cpy_r_r44);
    CPyTagged_DECREF(((charset_normalizer___md___ArchaicUpperLowerPluginObject *)cpy_r_self)->__successive_upper_lower_count_final);
    ((charset_normalizer___md___ArchaicUpperLowerPluginObject *)cpy_r_self)->__successive_upper_lower_count_final = cpy_r_r45;
CPyL22: ;
    CPyTagged_DECREF(((charset_normalizer___md___ArchaicUpperLowerPluginObject *)cpy_r_self)->__successive_upper_lower_count);
    ((charset_normalizer___md___ArchaicUpperLowerPluginObject *)cpy_r_self)->__successive_upper_lower_count = 0;
    CPyTagged_DECREF(((charset_normalizer___md___ArchaicUpperLowerPluginObject *)cpy_r_self)->__character_count_since_last_sep);
    ((charset_normalizer___md___ArchaicUpperLowerPluginObject *)cpy_r_self)->__character_count_since_last_sep = 0;
    cpy_r_r49 = Py_None;
    CPy_DECREF(((charset_normalizer___md___ArchaicUpperLowerPluginObject *)cpy_r_self)->__last_alpha_seen);
    ((charset_normalizer___md___ArchaicUpperLowerPluginObject *)cpy_r_self)->__last_alpha_seen = cpy_r_r49;
    ((charset_normalizer___md___ArchaicUpperLowerPluginObject *)cpy_r_self)->__buf = 0;
    cpy_r_r52 = ((charset_normalizer___md___ArchaicUpperLowerPluginObject *)cpy_r_self)->__character_count;
    cpy_r_r53 = CPyTagged_Add(cpy_r_r52, 2);
    CPyTagged_DECREF(((charset_normalizer___md___ArchaicUpperLowerPluginObject *)cpy_r_self)->__character_count);
    ((charset_normalizer___md___ArchaicUpperLowerPluginObject *)cpy_r_self)->__character_count = cpy_r_r53;
    ((charset_normalizer___md___ArchaicUpperLowerPluginObject *)cpy_r_self)->__current_ascii_only = 1;
    return 1;
CPyL23: ;
    cpy_r_r56 = ((charset_normalizer___md___ArchaicUpperLowerPluginObject *)cpy_r_self)->__current_ascii_only;
    cpy_r_r57 = cpy_r_r56 ? Py_True : Py_False;
    cpy_r_r58 = 1 ? Py_True : Py_False;
    cpy_r_r59 = cpy_r_r57 == cpy_r_r58;
    if (!cpy_r_r59) goto CPyL28;
    cpy_r_r60 = CPyStatics[35]; /* 'isascii' */
    PyObject *cpy_r_r61[1] = {cpy_r_character};
    cpy_r_r62 = (PyObject **)&cpy_r_r61;
    cpy_r_r63 = PyObject_VectorcallMethod(cpy_r_r60, cpy_r_r62, 9223372036854775809ULL, 0);
    if (unlikely(cpy_r_r63 == NULL)) {
        CPy_AddTraceback("src/charset_normalizer/md.py", "feed", 444, CPyStatic_globals);
        goto CPyL48;
    }
    if (unlikely(!PyBool_Check(cpy_r_r63))) {
        CPy_TypeError("bool", cpy_r_r63); cpy_r_r64 = 2;
    } else
        cpy_r_r64 = cpy_r_r63 == Py_True;
    CPy_DECREF(cpy_r_r63);
    if (unlikely(cpy_r_r64 == 2)) {
        CPy_AddTraceback("src/charset_normalizer/md.py", "feed", 444, CPyStatic_globals);
        goto CPyL48;
    }
    cpy_r_r65 = cpy_r_r64 ? Py_True : Py_False;
    cpy_r_r66 = 0 ? Py_True : Py_False;
    cpy_r_r67 = cpy_r_r65 == cpy_r_r66;
    if (!cpy_r_r67) goto CPyL28;
    ((charset_normalizer___md___ArchaicUpperLowerPluginObject *)cpy_r_self)->__current_ascii_only = 0;
CPyL28: ;
    cpy_r_r69 = ((charset_normalizer___md___ArchaicUpperLowerPluginObject *)cpy_r_self)->__last_alpha_seen;
    cpy_r_r70 = (PyObject *)&_Py_NoneStruct;
    cpy_r_r71 = cpy_r_r69 != cpy_r_r70;
    if (!cpy_r_r71) goto CPyL47;
    cpy_r_r72 = CPyStatics[14]; /* 'isupper' */
    PyObject *cpy_r_r73[1] = {cpy_r_character};
    cpy_r_r74 = (PyObject **)&cpy_r_r73;
    cpy_r_r75 = PyObject_VectorcallMethod(cpy_r_r72, cpy_r_r74, 9223372036854775809ULL, 0);
    if (unlikely(cpy_r_r75 == NULL)) {
        CPy_AddTraceback("src/charset_normalizer/md.py", "feed", 448, CPyStatic_globals);
        goto CPyL48;
    }
    if (unlikely(!PyBool_Check(cpy_r_r75))) {
        CPy_TypeError("bool", cpy_r_r75); cpy_r_r76 = 2;
    } else
        cpy_r_r76 = cpy_r_r75 == Py_True;
    CPy_DECREF(cpy_r_r75);
    if (unlikely(cpy_r_r76 == 2)) {
        CPy_AddTraceback("src/charset_normalizer/md.py", "feed", 448, CPyStatic_globals);
        goto CPyL48;
    }
    if (!cpy_r_r76) goto CPyL36;
    cpy_r_r77 = ((charset_normalizer___md___ArchaicUpperLowerPluginObject *)cpy_r_self)->__last_alpha_seen;
    CPy_INCREF(cpy_r_r77);
    if (likely(cpy_r_r77 != Py_None))
        cpy_r_r78 = cpy_r_r77;
    else {
        CPy_TypeErrorTraceback("src/charset_normalizer/md.py", "feed", 448, CPyStatic_globals, "str", cpy_r_r77);
        goto CPyL48;
    }
    cpy_r_r79 = CPyStatics[36]; /* 'islower' */
    PyObject *cpy_r_r80[1] = {cpy_r_r78};
    cpy_r_r81 = (PyObject **)&cpy_r_r80;
    cpy_r_r82 = PyObject_VectorcallMethod(cpy_r_r79, cpy_r_r81, 9223372036854775809ULL, 0);
    if (unlikely(cpy_r_r82 == NULL)) {
        CPy_AddTraceback("src/charset_normalizer/md.py", "feed", 448, CPyStatic_globals);
        goto CPyL49;
    }
    CPy_DECREF(cpy_r_r78);
    if (unlikely(!PyBool_Check(cpy_r_r82))) {
        CPy_TypeError("bool", cpy_r_r82); cpy_r_r83 = 2;
    } else
        cpy_r_r83 = cpy_r_r82 == Py_True;
    CPy_DECREF(cpy_r_r82);
    if (unlikely(cpy_r_r83 == 2)) {
        CPy_AddTraceback("src/charset_normalizer/md.py", "feed", 448, CPyStatic_globals);
        goto CPyL48;
    }
    if (cpy_r_r83) goto CPyL43;
CPyL36: ;
    cpy_r_r84 = CPyStatics[36]; /* 'islower' */
    PyObject *cpy_r_r85[1] = {cpy_r_character};
    cpy_r_r86 = (PyObject **)&cpy_r_r85;
    cpy_r_r87 = PyObject_VectorcallMethod(cpy_r_r84, cpy_r_r86, 9223372036854775809ULL, 0);
    if (unlikely(cpy_r_r87 == NULL)) {
        CPy_AddTraceback("src/charset_normalizer/md.py", "feed", 449, CPyStatic_globals);
        goto CPyL48;
    }
    if (unlikely(!PyBool_Check(cpy_r_r87))) {
        CPy_TypeError("bool", cpy_r_r87); cpy_r_r88 = 2;
    } else
        cpy_r_r88 = cpy_r_r87 == Py_True;
    CPy_DECREF(cpy_r_r87);
    if (unlikely(cpy_r_r88 == 2)) {
        CPy_AddTraceback("src/charset_normalizer/md.py", "feed", 449, CPyStatic_globals);
        goto CPyL48;
    }
    if (!cpy_r_r88) goto CPyL46;
    cpy_r_r89 = ((charset_normalizer___md___ArchaicUpperLowerPluginObject *)cpy_r_self)->__last_alpha_seen;
    CPy_INCREF(cpy_r_r89);
    if (likely(cpy_r_r89 != Py_None))
        cpy_r_r90 = cpy_r_r89;
    else {
        CPy_TypeErrorTraceback("src/charset_normalizer/md.py", "feed", 449, CPyStatic_globals, "str", cpy_r_r89);
        goto CPyL48;
    }
    cpy_r_r91 = CPyStatics[14]; /* 'isupper' */
    PyObject *cpy_r_r92[1] = {cpy_r_r90};
    cpy_r_r93 = (PyObject **)&cpy_r_r92;
    cpy_r_r94 = PyObject_VectorcallMethod(cpy_r_r91, cpy_r_r93, 9223372036854775809ULL, 0);
    if (unlikely(cpy_r_r94 == NULL)) {
        CPy_AddTraceback("src/charset_normalizer/md.py", "feed", 449, CPyStatic_globals);
        goto CPyL50;
    }
    CPy_DECREF(cpy_r_r90);
    if (unlikely(!PyBool_Check(cpy_r_r94))) {
        CPy_TypeError("bool", cpy_r_r94); cpy_r_r95 = 2;
    } else
        cpy_r_r95 = cpy_r_r94 == Py_True;
    CPy_DECREF(cpy_r_r94);
    if (unlikely(cpy_r_r95 == 2)) {
        CPy_AddTraceback("src/charset_normalizer/md.py", "feed", 449, CPyStatic_globals);
        goto CPyL48;
    }
    if (!cpy_r_r95) goto CPyL46;
CPyL43: ;
    cpy_r_r96 = ((charset_normalizer___md___ArchaicUpperLowerPluginObject *)cpy_r_self)->__buf;
    cpy_r_r97 = cpy_r_r96 ? Py_True : Py_False;
    cpy_r_r98 = 1 ? Py_True : Py_False;
    cpy_r_r99 = cpy_r_r97 == cpy_r_r98;
    if (!cpy_r_r99) goto CPyL45;
    cpy_r_r100 = ((charset_normalizer___md___ArchaicUpperLowerPluginObject *)cpy_r_self)->__successive_upper_lower_count;
    cpy_r_r101 = CPyTagged_Add(cpy_r_r100, 4);
    CPyTagged_DECREF(((charset_normalizer___md___ArchaicUpperLowerPluginObject *)cpy_r_self)->__successive_upper_lower_count);
    ((charset_normalizer___md___ArchaicUpperLowerPluginObject *)cpy_r_self)->__successive_upper_lower_count = cpy_r_r101;
    ((charset_normalizer___md___ArchaicUpperLowerPluginObject *)cpy_r_self)->__buf = 0;
    goto CPyL47;
CPyL45: ;
    ((charset_normalizer___md___ArchaicUpperLowerPluginObject *)cpy_r_self)->__buf = 1;
    goto CPyL47;
CPyL46: ;
    ((charset_normalizer___md___ArchaicUpperLowerPluginObject *)cpy_r_self)->__buf = 0;
CPyL47: ;
    cpy_r_r106 = ((charset_normalizer___md___ArchaicUpperLowerPluginObject *)cpy_r_self)->__character_count;
    cpy_r_r107 = CPyTagged_Add(cpy_r_r106, 2);
    CPyTagged_DECREF(((charset_normalizer___md___ArchaicUpperLowerPluginObject *)cpy_r_self)->__character_count);
    ((charset_normalizer___md___ArchaicUpperLowerPluginObject *)cpy_r_self)->__character_count = cpy_r_r107;
    cpy_r_r109 = ((charset_normalizer___md___ArchaicUpperLowerPluginObject *)cpy_r_self)->__character_count_since_last_sep;
    cpy_r_r110 = CPyTagged_Add(cpy_r_r109, 2);
    CPyTagged_DECREF(((charset_normalizer___md___ArchaicUpperLowerPluginObject *)cpy_r_self)->__character_count_since_last_sep);
    ((charset_normalizer___md___ArchaicUpperLowerPluginObject *)cpy_r_self)->__character_count_since_last_sep = cpy_r_r110;
    CPy_INCREF(cpy_r_character);
    CPy_DECREF(((charset_normalizer___md___ArchaicUpperLowerPluginObject *)cpy_r_self)->__last_alpha_seen);
    ((charset_normalizer___md___ArchaicUpperLowerPluginObject *)cpy_r_self)->__last_alpha_seen = cpy_r_character;
    return 1;
CPyL48: ;
    cpy_r_r113 = 2;
    return cpy_r_r113;
CPyL49: ;
    CPy_DecRef(cpy_r_r78);
    goto CPyL48;
CPyL50: ;
    CPy_DecRef(cpy_r_r90);
    goto CPyL48;
}

PyObject *CPyPy_ArchaicUpperLowerPlugin___feed(PyObject *self, PyObject *const *args, size_t nargs, PyObject *kwnames) {
    PyObject *obj_self = self;
    static const char * const kwlist[] = {"character", 0};
    static CPyArg_Parser parser = {"O:feed", kwlist, 0};
    PyObject *obj_character;
    if (!CPyArg_ParseStackAndKeywordsOneArg(args, nargs, kwnames, &parser, &obj_character)) {
        return NULL;
    }
    PyObject *arg_self;
    if (likely(Py_TYPE(obj_self) == CPyType_ArchaicUpperLowerPlugin))
        arg_self = obj_self;
    else {
        CPy_TypeError("charset_normalizer.md.ArchaicUpperLowerPlugin", obj_self); 
        goto fail;
    }
    PyObject *arg_character;
    if (likely(PyUnicode_Check(obj_character)))
        arg_character = obj_character;
    else {
        CPy_TypeError("str", obj_character); 
        goto fail;
    }
    char retval = CPyDef_ArchaicUpperLowerPlugin___feed(arg_self, arg_character);
    if (retval == 2) {
        return NULL;
    }
    PyObject *retbox = Py_None;
    CPy_INCREF(retbox);
    return retbox;
fail: ;
    CPy_AddTraceback("src/charset_normalizer/md.py", "feed", 421, CPyStatic_globals);
    return NULL;
}

char CPyDef_ArchaicUpperLowerPlugin___reset(PyObject *cpy_r_self) {
    char cpy_r_r0;
    char cpy_r_r1;
    char cpy_r_r2;
    char cpy_r_r3;
    PyObject *cpy_r_r4;
    char cpy_r_r5;
    char cpy_r_r6;
    char cpy_r_r7;
    CPyTagged_DECREF(((charset_normalizer___md___ArchaicUpperLowerPluginObject *)cpy_r_self)->__character_count);
    ((charset_normalizer___md___ArchaicUpperLowerPluginObject *)cpy_r_self)->__character_count = 0;
    CPyTagged_DECREF(((charset_normalizer___md___ArchaicUpperLowerPluginObject *)cpy_r_self)->__character_count_since_last_sep);
    ((charset_normalizer___md___ArchaicUpperLowerPluginObject *)cpy_r_self)->__character_count_since_last_sep = 0;
    CPyTagged_DECREF(((charset_normalizer___md___ArchaicUpperLowerPluginObject *)cpy_r_self)->__successive_upper_lower_count);
    ((charset_normalizer___md___ArchaicUpperLowerPluginObject *)cpy_r_self)->__successive_upper_lower_count = 0;
    CPyTagged_DECREF(((charset_normalizer___md___ArchaicUpperLowerPluginObject *)cpy_r_self)->__successive_upper_lower_count_final);
    ((charset_normalizer___md___ArchaicUpperLowerPluginObject *)cpy_r_self)->__successive_upper_lower_count_final = 0;
    cpy_r_r4 = Py_None;
    CPy_DECREF(((charset_normalizer___md___ArchaicUpperLowerPluginObject *)cpy_r_self)->__last_alpha_seen);
    ((charset_normalizer___md___ArchaicUpperLowerPluginObject *)cpy_r_self)->__last_alpha_seen = cpy_r_r4;
    ((charset_normalizer___md___ArchaicUpperLowerPluginObject *)cpy_r_self)->__buf = 0;
    ((charset_normalizer___md___ArchaicUpperLowerPluginObject *)cpy_r_self)->__current_ascii_only = 1;
    return 1;
}

PyObject *CPyPy_ArchaicUpperLowerPlugin___reset(PyObject *self, PyObject *const *args, size_t nargs, PyObject *kwnames) {
    PyObject *obj_self = self;
    static const char * const kwlist[] = {0};
    static CPyArg_Parser parser = {":reset", kwlist, 0};
    if (!CPyArg_ParseStackAndKeywordsNoArgs(args, nargs, kwnames, &parser)) {
        return NULL;
    }
    PyObject *arg_self;
    if (likely(Py_TYPE(obj_self) == CPyType_ArchaicUpperLowerPlugin))
        arg_self = obj_self;
    else {
        CPy_TypeError("charset_normalizer.md.ArchaicUpperLowerPlugin", obj_self); 
        goto fail;
    }
    char retval = CPyDef_ArchaicUpperLowerPlugin___reset(arg_self);
    if (retval == 2) {
        return NULL;
    }
    PyObject *retbox = Py_None;
    CPy_INCREF(retbox);
    return retbox;
fail: ;
    CPy_AddTraceback("src/charset_normalizer/md.py", "reset", 463, CPyStatic_globals);
    return NULL;
}

double CPyDef_ArchaicUpperLowerPlugin___ratio(PyObject *cpy_r_self) {
    CPyTagged cpy_r_r0;
    char cpy_r_r1;
    CPyTagged cpy_r_r2;
    CPyTagged cpy_r_r3;
    double cpy_r_r4;
    char cpy_r_r5;
    PyObject *cpy_r_r6;
    double cpy_r_r7;
    cpy_r_r0 = ((charset_normalizer___md___ArchaicUpperLowerPluginObject *)cpy_r_self)->__character_count;
    cpy_r_r1 = cpy_r_r0 == 0;
    if (!cpy_r_r1) goto CPyL2;
    return 0.0;
CPyL2: ;
    cpy_r_r2 = ((charset_normalizer___md___ArchaicUpperLowerPluginObject *)cpy_r_self)->__successive_upper_lower_count_final;
    CPyTagged_INCREF(cpy_r_r2);
    cpy_r_r3 = ((charset_normalizer___md___ArchaicUpperLowerPluginObject *)cpy_r_self)->__character_count;
    CPyTagged_INCREF(cpy_r_r3);
    cpy_r_r4 = CPyTagged_TrueDivide(cpy_r_r2, cpy_r_r3);
    CPyTagged_DECREF(cpy_r_r2);
    CPyTagged_DECREF(cpy_r_r3);
    cpy_r_r5 = cpy_r_r4 == -113.0;
    if (unlikely(cpy_r_r5)) goto CPyL4;
CPyL3: ;
    return cpy_r_r4;
CPyL4: ;
    cpy_r_r6 = PyErr_Occurred();
    if (unlikely(cpy_r_r6 != NULL)) {
        CPy_AddTraceback("src/charset_normalizer/md.py", "ratio", 477, CPyStatic_globals);
    } else
        goto CPyL3;
    cpy_r_r7 = -113.0;
    return cpy_r_r7;
}

PyObject *CPyPy_ArchaicUpperLowerPlugin___ratio(PyObject *self, PyObject *const *args, size_t nargs, PyObject *kwnames) {
    PyObject *obj_self = self;
    static const char * const kwlist[] = {0};
    static CPyArg_Parser parser = {":ratio", kwlist, 0};
    if (!CPyArg_ParseStackAndKeywordsNoArgs(args, nargs, kwnames, &parser)) {
        return NULL;
    }
    PyObject *arg_self;
    if (likely(Py_TYPE(obj_self) == CPyType_ArchaicUpperLowerPlugin))
        arg_self = obj_self;
    else {
        CPy_TypeError("charset_normalizer.md.ArchaicUpperLowerPlugin", obj_self); 
        goto fail;
    }
    double retval = CPyDef_ArchaicUpperLowerPlugin___ratio(arg_self);
    if (retval == -113.0 && PyErr_Occurred()) {
        return NULL;
    }
    PyObject *retbox = PyFloat_FromDouble(retval);
    return retbox;
fail: ;
    CPy_AddTraceback("src/charset_normalizer/md.py", "ratio", 473, CPyStatic_globals);
    return NULL;
}

char CPyDef_ArabicIsolatedFormPlugin_____init__(PyObject *cpy_r_self) {
    ((charset_normalizer___md___ArabicIsolatedFormPluginObject *)cpy_r_self)->__character_count = 0;
    ((charset_normalizer___md___ArabicIsolatedFormPluginObject *)cpy_r_self)->__isolated_form_count = 0;
    return 1;
}

PyObject *CPyPy_ArabicIsolatedFormPlugin_____init__(PyObject *self, PyObject *args, PyObject *kw) {
    PyObject *obj_self = self;
    static const char * const kwlist[] = {0};
    if (!CPyArg_ParseTupleAndKeywords(args, kw, "", "__init__", kwlist)) {
        return NULL;
    }
    PyObject *arg_self;
    if (likely(Py_TYPE(obj_self) == CPyType_ArabicIsolatedFormPlugin))
        arg_self = obj_self;
    else {
        CPy_TypeError("charset_normalizer.md.ArabicIsolatedFormPlugin", obj_self); 
        goto fail;
    }
    char retval = CPyDef_ArabicIsolatedFormPlugin_____init__(arg_self);
    if (retval == 2) {
        return NULL;
    }
    PyObject *retbox = Py_None;
    CPy_INCREF(retbox);
    return retbox;
fail: ;
    CPy_AddTraceback("src/charset_normalizer/md.py", "__init__", 481, CPyStatic_globals);
    return NULL;
}

char CPyDef_ArabicIsolatedFormPlugin___reset(PyObject *cpy_r_self) {
    char cpy_r_r0;
    char cpy_r_r1;
    CPyTagged_DECREF(((charset_normalizer___md___ArabicIsolatedFormPluginObject *)cpy_r_self)->__character_count);
    ((charset_normalizer___md___ArabicIsolatedFormPluginObject *)cpy_r_self)->__character_count = 0;
    CPyTagged_DECREF(((charset_normalizer___md___ArabicIsolatedFormPluginObject *)cpy_r_self)->__isolated_form_count);
    ((charset_normalizer___md___ArabicIsolatedFormPluginObject *)cpy_r_self)->__isolated_form_count = 0;
    return 1;
}

PyObject *CPyPy_ArabicIsolatedFormPlugin___reset(PyObject *self, PyObject *const *args, size_t nargs, PyObject *kwnames) {
    PyObject *obj_self = self;
    static const char * const kwlist[] = {0};
    static CPyArg_Parser parser = {":reset", kwlist, 0};
    if (!CPyArg_ParseStackAndKeywordsNoArgs(args, nargs, kwnames, &parser)) {
        return NULL;
    }
    PyObject *arg_self;
    if (likely(Py_TYPE(obj_self) == CPyType_ArabicIsolatedFormPlugin))
        arg_self = obj_self;
    else {
        CPy_TypeError("charset_normalizer.md.ArabicIsolatedFormPlugin", obj_self); 
        goto fail;
    }
    char retval = CPyDef_ArabicIsolatedFormPlugin___reset(arg_self);
    if (retval == 2) {
        return NULL;
    }
    PyObject *retbox = Py_None;
    CPy_INCREF(retbox);
    return retbox;
fail: ;
    CPy_AddTraceback("src/charset_normalizer/md.py", "reset", 485, CPyStatic_globals);
    return NULL;
}

char CPyDef_ArabicIsolatedFormPlugin___eligible(PyObject *cpy_r_self, PyObject *cpy_r_character) {
    PyObject *cpy_r_r0;
    PyObject *cpy_r_r1;
    PyObject *cpy_r_r2;
    PyObject **cpy_r_r4;
    PyObject *cpy_r_r5;
    char cpy_r_r6;
    char cpy_r_r7;
    cpy_r_r0 = CPyStatic_globals;
    cpy_r_r1 = CPyStatics[37]; /* 'is_arabic' */
    cpy_r_r2 = CPyDict_GetItem(cpy_r_r0, cpy_r_r1);
    if (unlikely(cpy_r_r2 == NULL)) {
        CPy_AddTraceback("src/charset_normalizer/md.py", "eligible", 490, CPyStatic_globals);
        goto CPyL4;
    }
    PyObject *cpy_r_r3[1] = {cpy_r_character};
    cpy_r_r4 = (PyObject **)&cpy_r_r3;
    cpy_r_r5 = PyObject_Vectorcall(cpy_r_r2, cpy_r_r4, 1, 0);
    CPy_DECREF(cpy_r_r2);
    if (unlikely(cpy_r_r5 == NULL)) {
        CPy_AddTraceback("src/charset_normalizer/md.py", "eligible", 490, CPyStatic_globals);
        goto CPyL4;
    }
    if (unlikely(!PyBool_Check(cpy_r_r5))) {
        CPy_TypeError("bool", cpy_r_r5); cpy_r_r6 = 2;
    } else
        cpy_r_r6 = cpy_r_r5 == Py_True;
    CPy_DECREF(cpy_r_r5);
    if (unlikely(cpy_r_r6 == 2)) {
        CPy_AddTraceback("src/charset_normalizer/md.py", "eligible", 490, CPyStatic_globals);
        goto CPyL4;
    }
    return cpy_r_r6;
CPyL4: ;
    cpy_r_r7 = 2;
    return cpy_r_r7;
}

PyObject *CPyPy_ArabicIsolatedFormPlugin___eligible(PyObject *self, PyObject *const *args, size_t nargs, PyObject *kwnames) {
    PyObject *obj_self = self;
    static const char * const kwlist[] = {"character", 0};
    static CPyArg_Parser parser = {"O:eligible", kwlist, 0};
    PyObject *obj_character;
    if (!CPyArg_ParseStackAndKeywordsOneArg(args, nargs, kwnames, &parser, &obj_character)) {
        return NULL;
    }
    PyObject *arg_self;
    if (likely(Py_TYPE(obj_self) == CPyType_ArabicIsolatedFormPlugin))
        arg_self = obj_self;
    else {
        CPy_TypeError("charset_normalizer.md.ArabicIsolatedFormPlugin", obj_self); 
        goto fail;
    }
    PyObject *arg_character;
    if (likely(PyUnicode_Check(obj_character)))
        arg_character = obj_character;
    else {
        CPy_TypeError("str", obj_character); 
        goto fail;
    }
    char retval = CPyDef_ArabicIsolatedFormPlugin___eligible(arg_self, arg_character);
    if (retval == 2) {
        return NULL;
    }
    PyObject *retbox = retval ? Py_True : Py_False;
    CPy_INCREF(retbox);
    return retbox;
fail: ;
    CPy_AddTraceback("src/charset_normalizer/md.py", "eligible", 489, CPyStatic_globals);
    return NULL;
}

char CPyDef_ArabicIsolatedFormPlugin___feed(PyObject *cpy_r_self, PyObject *cpy_r_character) {
    CPyTagged cpy_r_r0;
    CPyTagged cpy_r_r1;
    char cpy_r_r2;
    PyObject *cpy_r_r3;
    PyObject *cpy_r_r4;
    PyObject *cpy_r_r5;
    PyObject **cpy_r_r7;
    PyObject *cpy_r_r8;
    char cpy_r_r9;
    CPyTagged cpy_r_r10;
    CPyTagged cpy_r_r11;
    char cpy_r_r12;
    char cpy_r_r13;
    cpy_r_r0 = ((charset_normalizer___md___ArabicIsolatedFormPluginObject *)cpy_r_self)->__character_count;
    cpy_r_r1 = CPyTagged_Add(cpy_r_r0, 2);
    CPyTagged_DECREF(((charset_normalizer___md___ArabicIsolatedFormPluginObject *)cpy_r_self)->__character_count);
    ((charset_normalizer___md___ArabicIsolatedFormPluginObject *)cpy_r_self)->__character_count = cpy_r_r1;
    cpy_r_r3 = CPyStatic_globals;
    cpy_r_r4 = CPyStatics[38]; /* 'is_arabic_isolated_form' */
    cpy_r_r5 = CPyDict_GetItem(cpy_r_r3, cpy_r_r4);
    if (unlikely(cpy_r_r5 == NULL)) {
        CPy_AddTraceback("src/charset_normalizer/md.py", "feed", 495, CPyStatic_globals);
        goto CPyL6;
    }
    PyObject *cpy_r_r6[1] = {cpy_r_character};
    cpy_r_r7 = (PyObject **)&cpy_r_r6;
    cpy_r_r8 = PyObject_Vectorcall(cpy_r_r5, cpy_r_r7, 1, 0);
    CPy_DECREF(cpy_r_r5);
    if (unlikely(cpy_r_r8 == NULL)) {
        CPy_AddTraceback("src/charset_normalizer/md.py", "feed", 495, CPyStatic_globals);
        goto CPyL6;
    }
    if (unlikely(!PyBool_Check(cpy_r_r8))) {
        CPy_TypeError("bool", cpy_r_r8); cpy_r_r9 = 2;
    } else
        cpy_r_r9 = cpy_r_r8 == Py_True;
    CPy_DECREF(cpy_r_r8);
    if (unlikely(cpy_r_r9 == 2)) {
        CPy_AddTraceback("src/charset_normalizer/md.py", "feed", 495, CPyStatic_globals);
        goto CPyL6;
    }
    if (!cpy_r_r9) goto CPyL5;
    cpy_r_r10 = ((charset_normalizer___md___ArabicIsolatedFormPluginObject *)cpy_r_self)->__isolated_form_count;
    cpy_r_r11 = CPyTagged_Add(cpy_r_r10, 2);
    CPyTagged_DECREF(((charset_normalizer___md___ArabicIsolatedFormPluginObject *)cpy_r_self)->__isolated_form_count);
    ((charset_normalizer___md___ArabicIsolatedFormPluginObject *)cpy_r_self)->__isolated_form_count = cpy_r_r11;
CPyL5: ;
    return 1;
CPyL6: ;
    cpy_r_r13 = 2;
    return cpy_r_r13;
}

PyObject *CPyPy_ArabicIsolatedFormPlugin___feed(PyObject *self, PyObject *const *args, size_t nargs, PyObject *kwnames) {
    PyObject *obj_self = self;
    static const char * const kwlist[] = {"character", 0};
    static CPyArg_Parser parser = {"O:feed", kwlist, 0};
    PyObject *obj_character;
    if (!CPyArg_ParseStackAndKeywordsOneArg(args, nargs, kwnames, &parser, &obj_character)) {
        return NULL;
    }
    PyObject *arg_self;
    if (likely(Py_TYPE(obj_self) == CPyType_ArabicIsolatedFormPlugin))
        arg_self = obj_self;
    else {
        CPy_TypeError("charset_normalizer.md.ArabicIsolatedFormPlugin", obj_self); 
        goto fail;
    }
    PyObject *arg_character;
    if (likely(PyUnicode_Check(obj_character)))
        arg_character = obj_character;
    else {
        CPy_TypeError("str", obj_character); 
        goto fail;
    }
    char retval = CPyDef_ArabicIsolatedFormPlugin___feed(arg_self, arg_character);
    if (retval == 2) {
        return NULL;
    }
    PyObject *retbox = Py_None;
    CPy_INCREF(retbox);
    return retbox;
fail: ;
    CPy_AddTraceback("src/charset_normalizer/md.py", "feed", 492, CPyStatic_globals);
    return NULL;
}

double CPyDef_ArabicIsolatedFormPlugin___ratio(PyObject *cpy_r_self) {
    CPyTagged cpy_r_r0;
    int64_t cpy_r_r1;
    char cpy_r_r2;
    int64_t cpy_r_r3;
    char cpy_r_r4;
    char cpy_r_r5;
    char cpy_r_r6;
    CPyTagged cpy_r_r7;
    CPyTagged cpy_r_r8;
    double cpy_r_r9;
    char cpy_r_r10;
    PyObject *cpy_r_r11;
    double cpy_r_r12;
    cpy_r_r0 = ((charset_normalizer___md___ArabicIsolatedFormPluginObject *)cpy_r_self)->__character_count;
    cpy_r_r1 = cpy_r_r0 & 1;
    cpy_r_r2 = cpy_r_r1 != 0;
    if (cpy_r_r2) goto CPyL2;
    cpy_r_r3 = 16 & 1;
    cpy_r_r4 = cpy_r_r3 != 0;
    if (!cpy_r_r4) goto CPyL3;
CPyL2: ;
    cpy_r_r5 = CPyTagged_IsLt_(cpy_r_r0, 16);
    if (cpy_r_r5) {
        goto CPyL4;
    } else
        goto CPyL5;
CPyL3: ;
    cpy_r_r6 = (Py_ssize_t)cpy_r_r0 < (Py_ssize_t)16;
    if (!cpy_r_r6) goto CPyL5;
CPyL4: ;
    return 0.0;
CPyL5: ;
    cpy_r_r7 = ((charset_normalizer___md___ArabicIsolatedFormPluginObject *)cpy_r_self)->__isolated_form_count;
    CPyTagged_INCREF(cpy_r_r7);
    cpy_r_r8 = ((charset_normalizer___md___ArabicIsolatedFormPluginObject *)cpy_r_self)->__character_count;
    CPyTagged_INCREF(cpy_r_r8);
    cpy_r_r9 = CPyTagged_TrueDivide(cpy_r_r7, cpy_r_r8);
    CPyTagged_DECREF(cpy_r_r7);
    CPyTagged_DECREF(cpy_r_r8);
    cpy_r_r10 = cpy_r_r9 == -113.0;
    if (unlikely(cpy_r_r10)) goto CPyL7;
CPyL6: ;
    return cpy_r_r9;
CPyL7: ;
    cpy_r_r11 = PyErr_Occurred();
    if (unlikely(cpy_r_r11 != NULL)) {
        CPy_AddTraceback("src/charset_normalizer/md.py", "ratio", 503, CPyStatic_globals);
    } else
        goto CPyL6;
    cpy_r_r12 = -113.0;
    return cpy_r_r12;
}

PyObject *CPyPy_ArabicIsolatedFormPlugin___ratio(PyObject *self, PyObject *const *args, size_t nargs, PyObject *kwnames) {
    PyObject *obj_self = self;
    static const char * const kwlist[] = {0};
    static CPyArg_Parser parser = {":ratio", kwlist, 0};
    if (!CPyArg_ParseStackAndKeywordsNoArgs(args, nargs, kwnames, &parser)) {
        return NULL;
    }
    PyObject *arg_self;
    if (likely(Py_TYPE(obj_self) == CPyType_ArabicIsolatedFormPlugin))
        arg_self = obj_self;
    else {
        CPy_TypeError("charset_normalizer.md.ArabicIsolatedFormPlugin", obj_self); 
        goto fail;
    }
    double retval = CPyDef_ArabicIsolatedFormPlugin___ratio(arg_self);
    if (retval == -113.0 && PyErr_Occurred()) {
        return NULL;
    }
    PyObject *retbox = PyFloat_FromDouble(retval);
    return retbox;
fail: ;
    CPy_AddTraceback("src/charset_normalizer/md.py", "ratio", 499, CPyStatic_globals);
    return NULL;
}

char CPyDef_is_suspiciously_successive_range(PyObject *cpy_r_unicode_range_a, PyObject *cpy_r_unicode_range_b) {
    PyObject *cpy_r_r0;
    char cpy_r_r1;
    PyObject *cpy_r_r2;
    char cpy_r_r3;
    PyObject *cpy_r_r4;
    PyObject *cpy_r_r5;
    char cpy_r_r6;
    PyObject *cpy_r_r7;
    PyObject *cpy_r_r8;
    int32_t cpy_r_r9;
    char cpy_r_r10;
    char cpy_r_r11;
    PyObject *cpy_r_r12;
    PyObject *cpy_r_r13;
    int32_t cpy_r_r14;
    char cpy_r_r15;
    char cpy_r_r16;
    PyObject *cpy_r_r17;
    PyObject *cpy_r_r18;
    int32_t cpy_r_r19;
    char cpy_r_r20;
    char cpy_r_r21;
    PyObject *cpy_r_r22;
    PyObject *cpy_r_r23;
    int32_t cpy_r_r24;
    char cpy_r_r25;
    char cpy_r_r26;
    PyObject *cpy_r_r27;
    PyObject *cpy_r_r28;
    int32_t cpy_r_r29;
    char cpy_r_r30;
    char cpy_r_r31;
    PyObject *cpy_r_r32;
    PyObject *cpy_r_r33;
    int32_t cpy_r_r34;
    char cpy_r_r35;
    char cpy_r_r36;
    PyObject *cpy_r_r37;
    PyObject *cpy_r_r38;
    int32_t cpy_r_r39;
    char cpy_r_r40;
    char cpy_r_r41;
    PyObject *cpy_r_r42;
    PyObject *cpy_r_r43;
    int32_t cpy_r_r44;
    char cpy_r_r45;
    char cpy_r_r46;
    PyObject *cpy_r_r47;
    PyObject *cpy_r_r48;
    PyObject *cpy_r_r49;
    PyObject *cpy_r_r50;
    PyObject *cpy_r_r51;
    PyObject *cpy_r_r52;
    int64_t cpy_r_r53;
    CPyPtr cpy_r_r54;
    int64_t cpy_r_r55;
    char cpy_r_r56;
    CPyPtr cpy_r_r57;
    CPyPtr cpy_r_r58;
    int64_t cpy_r_r59;
    CPyPtr cpy_r_r60;
    PyObject *cpy_r_r61;
    PyObject *cpy_r_r62;
    PyObject *cpy_r_r63;
    PyObject *cpy_r_r64;
    PyObject *cpy_r_r65;
    PyObject *cpy_r_r66;
    int32_t cpy_r_r67;
    char cpy_r_r68;
    char cpy_r_r69;
    int32_t cpy_r_r70;
    char cpy_r_r71;
    char cpy_r_r72;
    int64_t cpy_r_r73;
    PyObject *cpy_r_r74;
    PyObject *cpy_r_r75;
    PyObject *cpy_r_r76;
    char cpy_r_r77;
    char cpy_r_r78;
    char cpy_r_r79;
    char cpy_r_r80;
    PyObject *cpy_r_r81;
    PyObject *cpy_r_r82;
    PyObject *cpy_r_r83;
    char cpy_r_r84;
    char cpy_r_r85;
    char cpy_r_r86;
    char cpy_r_r87;
    PyObject *cpy_r_r88;
    PyObject *cpy_r_r89;
    int32_t cpy_r_r90;
    char cpy_r_r91;
    char cpy_r_r92;
    PyObject *cpy_r_r93;
    PyObject *cpy_r_r94;
    int32_t cpy_r_r95;
    char cpy_r_r96;
    char cpy_r_r97;
    PyObject *cpy_r_r98;
    PyObject *cpy_r_r99;
    int32_t cpy_r_r100;
    char cpy_r_r101;
    char cpy_r_r102;
    PyObject *cpy_r_r103;
    PyObject *cpy_r_r104;
    int32_t cpy_r_r105;
    char cpy_r_r106;
    char cpy_r_r107;
    PyObject *cpy_r_r108;
    PyObject *cpy_r_r109;
    int32_t cpy_r_r110;
    char cpy_r_r111;
    char cpy_r_r112;
    PyObject *cpy_r_r113;
    PyObject *cpy_r_r114;
    int32_t cpy_r_r115;
    char cpy_r_r116;
    char cpy_r_r117;
    PyObject *cpy_r_r118;
    PyObject *cpy_r_r119;
    char cpy_r_r120;
    PyObject *cpy_r_r121;
    PyObject *cpy_r_r122;
    char cpy_r_r123;
    PyObject *cpy_r_r124;
    PyObject *cpy_r_r125;
    int32_t cpy_r_r126;
    char cpy_r_r127;
    char cpy_r_r128;
    PyObject *cpy_r_r129;
    PyObject *cpy_r_r130;
    int32_t cpy_r_r131;
    char cpy_r_r132;
    char cpy_r_r133;
    PyObject *cpy_r_r134;
    PyObject *cpy_r_r135;
    PyObject *cpy_r_r136;
    char cpy_r_r137;
    char cpy_r_r138;
    PyObject *cpy_r_r139;
    PyObject *cpy_r_r140;
    PyObject *cpy_r_r141;
    char cpy_r_r142;
    char cpy_r_r143;
    PyObject *cpy_r_r144;
    PyObject *cpy_r_r145;
    int32_t cpy_r_r146;
    char cpy_r_r147;
    char cpy_r_r148;
    PyObject *cpy_r_r149;
    PyObject *cpy_r_r150;
    int32_t cpy_r_r151;
    char cpy_r_r152;
    char cpy_r_r153;
    PyObject *cpy_r_r154;
    PyObject *cpy_r_r155;
    int32_t cpy_r_r156;
    char cpy_r_r157;
    char cpy_r_r158;
    PyObject *cpy_r_r159;
    PyObject *cpy_r_r160;
    int32_t cpy_r_r161;
    char cpy_r_r162;
    char cpy_r_r163;
    PyObject *cpy_r_r164;
    PyObject *cpy_r_r165;
    char cpy_r_r166;
    PyObject *cpy_r_r167;
    PyObject *cpy_r_r168;
    char cpy_r_r169;
    char cpy_r_r170;
    cpy_r_r0 = (PyObject *)&_Py_NoneStruct;
    cpy_r_r1 = cpy_r_unicode_range_a == cpy_r_r0;
    if (cpy_r_r1) goto CPyL2;
    cpy_r_r2 = (PyObject *)&_Py_NoneStruct;
    cpy_r_r3 = cpy_r_unicode_range_b == cpy_r_r2;
    if (!cpy_r_r3) goto CPyL3;
CPyL2: ;
    return 1;
CPyL3: ;
    CPy_INCREF(cpy_r_unicode_range_a);
    if (likely(cpy_r_unicode_range_a != Py_None))
        cpy_r_r4 = cpy_r_unicode_range_a;
    else {
        CPy_TypeErrorTraceback("src/charset_normalizer/md.py", "is_suspiciously_successive_range", 518, CPyStatic_globals, "str", cpy_r_unicode_range_a);
        goto CPyL125;
    }
    CPy_INCREF(cpy_r_unicode_range_b);
    if (likely(cpy_r_unicode_range_b != Py_None))
        cpy_r_r5 = cpy_r_unicode_range_b;
    else {
        CPy_TypeErrorTraceback("src/charset_normalizer/md.py", "is_suspiciously_successive_range", 518, CPyStatic_globals, "str", cpy_r_unicode_range_b);
        goto CPyL126;
    }
    cpy_r_r6 = CPyStr_Equal(cpy_r_r4, cpy_r_r5);
    CPy_DECREF(cpy_r_r4);
    CPy_DECREF(cpy_r_r5);
    if (!cpy_r_r6) goto CPyL7;
    return 0;
CPyL7: ;
    cpy_r_r7 = CPyStatics[39]; /* 'Latin' */
    CPy_INCREF(cpy_r_unicode_range_a);
    if (likely(cpy_r_unicode_range_a != Py_None))
        cpy_r_r8 = cpy_r_unicode_range_a;
    else {
        CPy_TypeErrorTraceback("src/charset_normalizer/md.py", "is_suspiciously_successive_range", 521, CPyStatic_globals, "str", cpy_r_unicode_range_a);
        goto CPyL125;
    }
    cpy_r_r9 = PyUnicode_Contains(cpy_r_r8, cpy_r_r7);
    CPy_DECREF(cpy_r_r8);
    cpy_r_r10 = cpy_r_r9 >= 0;
    if (unlikely(!cpy_r_r10)) {
        CPy_AddTraceback("src/charset_normalizer/md.py", "is_suspiciously_successive_range", 521, CPyStatic_globals);
        goto CPyL125;
    }
    cpy_r_r11 = cpy_r_r9;
    if (!cpy_r_r11) goto CPyL14;
    cpy_r_r12 = CPyStatics[39]; /* 'Latin' */
    CPy_INCREF(cpy_r_unicode_range_b);
    if (likely(cpy_r_unicode_range_b != Py_None))
        cpy_r_r13 = cpy_r_unicode_range_b;
    else {
        CPy_TypeErrorTraceback("src/charset_normalizer/md.py", "is_suspiciously_successive_range", 521, CPyStatic_globals, "str", cpy_r_unicode_range_b);
        goto CPyL125;
    }
    cpy_r_r14 = PyUnicode_Contains(cpy_r_r13, cpy_r_r12);
    CPy_DECREF(cpy_r_r13);
    cpy_r_r15 = cpy_r_r14 >= 0;
    if (unlikely(!cpy_r_r15)) {
        CPy_AddTraceback("src/charset_normalizer/md.py", "is_suspiciously_successive_range", 521, CPyStatic_globals);
        goto CPyL125;
    }
    cpy_r_r16 = cpy_r_r14;
    if (!cpy_r_r16) goto CPyL14;
    return 0;
CPyL14: ;
    cpy_r_r17 = CPyStatics[40]; /* 'Emoticons' */
    CPy_INCREF(cpy_r_unicode_range_a);
    if (likely(cpy_r_unicode_range_a != Py_None))
        cpy_r_r18 = cpy_r_unicode_range_a;
    else {
        CPy_TypeErrorTraceback("src/charset_normalizer/md.py", "is_suspiciously_successive_range", 524, CPyStatic_globals, "str", cpy_r_unicode_range_a);
        goto CPyL125;
    }
    cpy_r_r19 = PyUnicode_Contains(cpy_r_r18, cpy_r_r17);
    CPy_DECREF(cpy_r_r18);
    cpy_r_r20 = cpy_r_r19 >= 0;
    if (unlikely(!cpy_r_r20)) {
        CPy_AddTraceback("src/charset_normalizer/md.py", "is_suspiciously_successive_range", 524, CPyStatic_globals);
        goto CPyL125;
    }
    cpy_r_r21 = cpy_r_r19;
    if (cpy_r_r21) goto CPyL20;
    cpy_r_r22 = CPyStatics[40]; /* 'Emoticons' */
    CPy_INCREF(cpy_r_unicode_range_b);
    if (likely(cpy_r_unicode_range_b != Py_None))
        cpy_r_r23 = cpy_r_unicode_range_b;
    else {
        CPy_TypeErrorTraceback("src/charset_normalizer/md.py", "is_suspiciously_successive_range", 524, CPyStatic_globals, "str", cpy_r_unicode_range_b);
        goto CPyL125;
    }
    cpy_r_r24 = PyUnicode_Contains(cpy_r_r23, cpy_r_r22);
    CPy_DECREF(cpy_r_r23);
    cpy_r_r25 = cpy_r_r24 >= 0;
    if (unlikely(!cpy_r_r25)) {
        CPy_AddTraceback("src/charset_normalizer/md.py", "is_suspiciously_successive_range", 524, CPyStatic_globals);
        goto CPyL125;
    }
    cpy_r_r26 = cpy_r_r24;
    if (!cpy_r_r26) goto CPyL21;
CPyL20: ;
    return 0;
CPyL21: ;
    cpy_r_r27 = CPyStatics[39]; /* 'Latin' */
    CPy_INCREF(cpy_r_unicode_range_a);
    if (likely(cpy_r_unicode_range_a != Py_None))
        cpy_r_r28 = cpy_r_unicode_range_a;
    else {
        CPy_TypeErrorTraceback("src/charset_normalizer/md.py", "is_suspiciously_successive_range", 529, CPyStatic_globals, "str", cpy_r_unicode_range_a);
        goto CPyL125;
    }
    cpy_r_r29 = PyUnicode_Contains(cpy_r_r28, cpy_r_r27);
    CPy_DECREF(cpy_r_r28);
    cpy_r_r30 = cpy_r_r29 >= 0;
    if (unlikely(!cpy_r_r30)) {
        CPy_AddTraceback("src/charset_normalizer/md.py", "is_suspiciously_successive_range", 529, CPyStatic_globals);
        goto CPyL125;
    }
    cpy_r_r31 = cpy_r_r29;
    if (cpy_r_r31) goto CPyL27;
    cpy_r_r32 = CPyStatics[39]; /* 'Latin' */
    CPy_INCREF(cpy_r_unicode_range_b);
    if (likely(cpy_r_unicode_range_b != Py_None))
        cpy_r_r33 = cpy_r_unicode_range_b;
    else {
        CPy_TypeErrorTraceback("src/charset_normalizer/md.py", "is_suspiciously_successive_range", 529, CPyStatic_globals, "str", cpy_r_unicode_range_b);
        goto CPyL125;
    }
    cpy_r_r34 = PyUnicode_Contains(cpy_r_r33, cpy_r_r32);
    CPy_DECREF(cpy_r_r33);
    cpy_r_r35 = cpy_r_r34 >= 0;
    if (unlikely(!cpy_r_r35)) {
        CPy_AddTraceback("src/charset_normalizer/md.py", "is_suspiciously_successive_range", 529, CPyStatic_globals);
        goto CPyL125;
    }
    cpy_r_r36 = cpy_r_r34;
    if (!cpy_r_r36) goto CPyL34;
CPyL27: ;
    cpy_r_r37 = CPyStatics[41]; /* 'Combining' */
    CPy_INCREF(cpy_r_unicode_range_a);
    if (likely(cpy_r_unicode_range_a != Py_None))
        cpy_r_r38 = cpy_r_unicode_range_a;
    else {
        CPy_TypeErrorTraceback("src/charset_normalizer/md.py", "is_suspiciously_successive_range", 530, CPyStatic_globals, "str", cpy_r_unicode_range_a);
        goto CPyL125;
    }
    cpy_r_r39 = PyUnicode_Contains(cpy_r_r38, cpy_r_r37);
    CPy_DECREF(cpy_r_r38);
    cpy_r_r40 = cpy_r_r39 >= 0;
    if (unlikely(!cpy_r_r40)) {
        CPy_AddTraceback("src/charset_normalizer/md.py", "is_suspiciously_successive_range", 530, CPyStatic_globals);
        goto CPyL125;
    }
    cpy_r_r41 = cpy_r_r39;
    if (cpy_r_r41) goto CPyL33;
    cpy_r_r42 = CPyStatics[41]; /* 'Combining' */
    CPy_INCREF(cpy_r_unicode_range_b);
    if (likely(cpy_r_unicode_range_b != Py_None))
        cpy_r_r43 = cpy_r_unicode_range_b;
    else {
        CPy_TypeErrorTraceback("src/charset_normalizer/md.py", "is_suspiciously_successive_range", 530, CPyStatic_globals, "str", cpy_r_unicode_range_b);
        goto CPyL125;
    }
    cpy_r_r44 = PyUnicode_Contains(cpy_r_r43, cpy_r_r42);
    CPy_DECREF(cpy_r_r43);
    cpy_r_r45 = cpy_r_r44 >= 0;
    if (unlikely(!cpy_r_r45)) {
        CPy_AddTraceback("src/charset_normalizer/md.py", "is_suspiciously_successive_range", 530, CPyStatic_globals);
        goto CPyL125;
    }
    cpy_r_r46 = cpy_r_r44;
    if (!cpy_r_r46) goto CPyL34;
CPyL33: ;
    return 0;
CPyL34: ;
    CPy_INCREF(cpy_r_unicode_range_a);
    if (likely(cpy_r_unicode_range_a != Py_None))
        cpy_r_r47 = cpy_r_unicode_range_a;
    else {
        CPy_TypeErrorTraceback("src/charset_normalizer/md.py", "is_suspiciously_successive_range", 535, CPyStatic_globals, "str", cpy_r_unicode_range_a);
        goto CPyL125;
    }
    cpy_r_r48 = CPyStatics[42]; /* ' ' */
    cpy_r_r49 = PyUnicode_Split(cpy_r_r47, cpy_r_r48, -1);
    CPy_DECREF(cpy_r_r47);
    if (unlikely(cpy_r_r49 == NULL)) {
        CPy_AddTraceback("src/charset_normalizer/md.py", "is_suspiciously_successive_range", 535, CPyStatic_globals);
        goto CPyL125;
    }
    CPy_INCREF(cpy_r_unicode_range_b);
    if (likely(cpy_r_unicode_range_b != Py_None))
        cpy_r_r50 = cpy_r_unicode_range_b;
    else {
        CPy_TypeErrorTraceback("src/charset_normalizer/md.py", "is_suspiciously_successive_range", 536, CPyStatic_globals, "str", cpy_r_unicode_range_b);
        goto CPyL127;
    }
    cpy_r_r51 = CPyStatics[42]; /* ' ' */
    cpy_r_r52 = PyUnicode_Split(cpy_r_r50, cpy_r_r51, -1);
    CPy_DECREF(cpy_r_r50);
    if (unlikely(cpy_r_r52 == NULL)) {
        CPy_AddTraceback("src/charset_normalizer/md.py", "is_suspiciously_successive_range", 536, CPyStatic_globals);
        goto CPyL127;
    }
    cpy_r_r53 = 0;
CPyL39: ;
    cpy_r_r54 = (CPyPtr)&((PyVarObject *)cpy_r_r49)->ob_size;
    cpy_r_r55 = *(int64_t *)cpy_r_r54;
    cpy_r_r56 = cpy_r_r53 < cpy_r_r55;
    if (!cpy_r_r56) goto CPyL128;
    cpy_r_r57 = (CPyPtr)&((PyListObject *)cpy_r_r49)->ob_item;
    cpy_r_r58 = *(CPyPtr *)cpy_r_r57;
    cpy_r_r59 = cpy_r_r53 * 8;
    cpy_r_r60 = cpy_r_r58 + cpy_r_r59;
    cpy_r_r61 = *(PyObject * *)cpy_r_r60;
    CPy_INCREF(cpy_r_r61);
    if (likely(PyUnicode_Check(cpy_r_r61)))
        cpy_r_r62 = cpy_r_r61;
    else {
        CPy_TypeErrorTraceback("src/charset_normalizer/md.py", "is_suspiciously_successive_range", 539, CPyStatic_globals, "str", cpy_r_r61);
        goto CPyL129;
    }
    cpy_r_r63 = CPyStatic_globals;
    cpy_r_r64 = CPyStatics[43]; /* 'UNICODE_SECONDARY_RANGE_KEYWORD' */
    cpy_r_r65 = CPyDict_GetItem(cpy_r_r63, cpy_r_r64);
    if (unlikely(cpy_r_r65 == NULL)) {
        CPy_AddTraceback("src/charset_normalizer/md.py", "is_suspiciously_successive_range", 540, CPyStatic_globals);
        goto CPyL130;
    }
    if (likely(PyList_Check(cpy_r_r65)))
        cpy_r_r66 = cpy_r_r65;
    else {
        CPy_TypeErrorTraceback("src/charset_normalizer/md.py", "is_suspiciously_successive_range", 540, CPyStatic_globals, "list", cpy_r_r65);
        goto CPyL130;
    }
    cpy_r_r67 = PySequence_Contains(cpy_r_r66, cpy_r_r62);
    CPy_DECREF_NO_IMM(cpy_r_r66);
    cpy_r_r68 = cpy_r_r67 >= 0;
    if (unlikely(!cpy_r_r68)) {
        CPy_AddTraceback("src/charset_normalizer/md.py", "is_suspiciously_successive_range", 540, CPyStatic_globals);
        goto CPyL130;
    }
    cpy_r_r69 = cpy_r_r67;
    if (cpy_r_r69) goto CPyL131;
    cpy_r_r70 = PySequence_Contains(cpy_r_r52, cpy_r_r62);
    CPy_DECREF(cpy_r_r62);
    cpy_r_r71 = cpy_r_r70 >= 0;
    if (unlikely(!cpy_r_r71)) {
        CPy_AddTraceback("src/charset_normalizer/md.py", "is_suspiciously_successive_range", 542, CPyStatic_globals);
        goto CPyL129;
    }
    cpy_r_r72 = cpy_r_r70;
    if (cpy_r_r72) {
        goto CPyL132;
    } else
        goto CPyL48;
CPyL47: ;
    return 0;
CPyL48: ;
    cpy_r_r73 = cpy_r_r53 + 1;
    cpy_r_r53 = cpy_r_r73;
    goto CPyL39;
CPyL49: ;
    CPy_INCREF(cpy_r_unicode_range_a);
    if (likely(cpy_r_unicode_range_a != Py_None))
        cpy_r_r74 = cpy_r_unicode_range_a;
    else {
        CPy_TypeErrorTraceback("src/charset_normalizer/md.py", "is_suspiciously_successive_range", 547, CPyStatic_globals, "str", cpy_r_unicode_range_a);
        goto CPyL125;
    }
    cpy_r_r75 = CPyStatics[44]; /* 'Hiragana' */
    cpy_r_r76 = CPyStatics[45]; /* 'Katakana' */
    cpy_r_r77 = CPyStr_Equal(cpy_r_r74, cpy_r_r75);
    if (cpy_r_r77) goto CPyL133;
    cpy_r_r78 = CPyStr_Equal(cpy_r_r74, cpy_r_r76);
    CPy_DECREF(cpy_r_r74);
    if (cpy_r_r78) goto CPyL53;
    cpy_r_r79 = 0;
    goto CPyL54;
CPyL53: ;
    cpy_r_r79 = 1;
CPyL54: ;
    cpy_r_r80 = cpy_r_r79;
    CPy_INCREF(cpy_r_unicode_range_b);
    if (likely(cpy_r_unicode_range_b != Py_None))
        cpy_r_r81 = cpy_r_unicode_range_b;
    else {
        CPy_TypeErrorTraceback("src/charset_normalizer/md.py", "is_suspiciously_successive_range", 552, CPyStatic_globals, "str", cpy_r_unicode_range_b);
        goto CPyL125;
    }
    cpy_r_r82 = CPyStatics[44]; /* 'Hiragana' */
    cpy_r_r83 = CPyStatics[45]; /* 'Katakana' */
    cpy_r_r84 = CPyStr_Equal(cpy_r_r81, cpy_r_r82);
    if (cpy_r_r84) goto CPyL134;
    cpy_r_r85 = CPyStr_Equal(cpy_r_r81, cpy_r_r83);
    CPy_DECREF(cpy_r_r81);
    if (cpy_r_r85) goto CPyL58;
    cpy_r_r86 = 0;
    goto CPyL59;
CPyL58: ;
    cpy_r_r86 = 1;
CPyL59: ;
    cpy_r_r87 = cpy_r_r86;
    if (cpy_r_r80) goto CPyL61;
    if (!cpy_r_r87) goto CPyL68;
CPyL61: ;
    cpy_r_r88 = CPyStatics[46]; /* 'CJK' */
    CPy_INCREF(cpy_r_unicode_range_a);
    if (likely(cpy_r_unicode_range_a != Py_None))
        cpy_r_r89 = cpy_r_unicode_range_a;
    else {
        CPy_TypeErrorTraceback("src/charset_normalizer/md.py", "is_suspiciously_successive_range", 555, CPyStatic_globals, "str", cpy_r_unicode_range_a);
        goto CPyL125;
    }
    cpy_r_r90 = PyUnicode_Contains(cpy_r_r89, cpy_r_r88);
    CPy_DECREF(cpy_r_r89);
    cpy_r_r91 = cpy_r_r90 >= 0;
    if (unlikely(!cpy_r_r91)) {
        CPy_AddTraceback("src/charset_normalizer/md.py", "is_suspiciously_successive_range", 555, CPyStatic_globals);
        goto CPyL125;
    }
    cpy_r_r92 = cpy_r_r90;
    if (cpy_r_r92) goto CPyL67;
    cpy_r_r93 = CPyStatics[46]; /* 'CJK' */
    CPy_INCREF(cpy_r_unicode_range_b);
    if (likely(cpy_r_unicode_range_b != Py_None))
        cpy_r_r94 = cpy_r_unicode_range_b;
    else {
        CPy_TypeErrorTraceback("src/charset_normalizer/md.py", "is_suspiciously_successive_range", 555, CPyStatic_globals, "str", cpy_r_unicode_range_b);
        goto CPyL125;
    }
    cpy_r_r95 = PyUnicode_Contains(cpy_r_r94, cpy_r_r93);
    CPy_DECREF(cpy_r_r94);
    cpy_r_r96 = cpy_r_r95 >= 0;
    if (unlikely(!cpy_r_r96)) {
        CPy_AddTraceback("src/charset_normalizer/md.py", "is_suspiciously_successive_range", 555, CPyStatic_globals);
        goto CPyL125;
    }
    cpy_r_r97 = cpy_r_r95;
    if (!cpy_r_r97) goto CPyL68;
CPyL67: ;
    return 0;
CPyL68: ;
    if (!cpy_r_r80) goto CPyL71;
    if (!cpy_r_r87) goto CPyL71;
    return 0;
CPyL71: ;
    cpy_r_r98 = CPyStatics[47]; /* 'Hangul' */
    CPy_INCREF(cpy_r_unicode_range_a);
    if (likely(cpy_r_unicode_range_a != Py_None))
        cpy_r_r99 = cpy_r_unicode_range_a;
    else {
        CPy_TypeErrorTraceback("src/charset_normalizer/md.py", "is_suspiciously_successive_range", 561, CPyStatic_globals, "str", cpy_r_unicode_range_a);
        goto CPyL125;
    }
    cpy_r_r100 = PyUnicode_Contains(cpy_r_r99, cpy_r_r98);
    CPy_DECREF(cpy_r_r99);
    cpy_r_r101 = cpy_r_r100 >= 0;
    if (unlikely(!cpy_r_r101)) {
        CPy_AddTraceback("src/charset_normalizer/md.py", "is_suspiciously_successive_range", 561, CPyStatic_globals);
        goto CPyL125;
    }
    cpy_r_r102 = cpy_r_r100;
    if (cpy_r_r102) goto CPyL77;
    cpy_r_r103 = CPyStatics[47]; /* 'Hangul' */
    CPy_INCREF(cpy_r_unicode_range_b);
    if (likely(cpy_r_unicode_range_b != Py_None))
        cpy_r_r104 = cpy_r_unicode_range_b;
    else {
        CPy_TypeErrorTraceback("src/charset_normalizer/md.py", "is_suspiciously_successive_range", 561, CPyStatic_globals, "str", cpy_r_unicode_range_b);
        goto CPyL125;
    }
    cpy_r_r105 = PyUnicode_Contains(cpy_r_r104, cpy_r_r103);
    CPy_DECREF(cpy_r_r104);
    cpy_r_r106 = cpy_r_r105 >= 0;
    if (unlikely(!cpy_r_r106)) {
        CPy_AddTraceback("src/charset_normalizer/md.py", "is_suspiciously_successive_range", 561, CPyStatic_globals);
        goto CPyL125;
    }
    cpy_r_r107 = cpy_r_r105;
    if (!cpy_r_r107) goto CPyL89;
CPyL77: ;
    cpy_r_r108 = CPyStatics[46]; /* 'CJK' */
    CPy_INCREF(cpy_r_unicode_range_a);
    if (likely(cpy_r_unicode_range_a != Py_None))
        cpy_r_r109 = cpy_r_unicode_range_a;
    else {
        CPy_TypeErrorTraceback("src/charset_normalizer/md.py", "is_suspiciously_successive_range", 562, CPyStatic_globals, "str", cpy_r_unicode_range_a);
        goto CPyL125;
    }
    cpy_r_r110 = PyUnicode_Contains(cpy_r_r109, cpy_r_r108);
    CPy_DECREF(cpy_r_r109);
    cpy_r_r111 = cpy_r_r110 >= 0;
    if (unlikely(!cpy_r_r111)) {
        CPy_AddTraceback("src/charset_normalizer/md.py", "is_suspiciously_successive_range", 562, CPyStatic_globals);
        goto CPyL125;
    }
    cpy_r_r112 = cpy_r_r110;
    if (cpy_r_r112) goto CPyL83;
    cpy_r_r113 = CPyStatics[46]; /* 'CJK' */
    CPy_INCREF(cpy_r_unicode_range_b);
    if (likely(cpy_r_unicode_range_b != Py_None))
        cpy_r_r114 = cpy_r_unicode_range_b;
    else {
        CPy_TypeErrorTraceback("src/charset_normalizer/md.py", "is_suspiciously_successive_range", 562, CPyStatic_globals, "str", cpy_r_unicode_range_b);
        goto CPyL125;
    }
    cpy_r_r115 = PyUnicode_Contains(cpy_r_r114, cpy_r_r113);
    CPy_DECREF(cpy_r_r114);
    cpy_r_r116 = cpy_r_r115 >= 0;
    if (unlikely(!cpy_r_r116)) {
        CPy_AddTraceback("src/charset_normalizer/md.py", "is_suspiciously_successive_range", 562, CPyStatic_globals);
        goto CPyL125;
    }
    cpy_r_r117 = cpy_r_r115;
    if (!cpy_r_r117) goto CPyL84;
CPyL83: ;
    return 0;
CPyL84: ;
    CPy_INCREF(cpy_r_unicode_range_a);
    if (likely(cpy_r_unicode_range_a != Py_None))
        cpy_r_r118 = cpy_r_unicode_range_a;
    else {
        CPy_TypeErrorTraceback("src/charset_normalizer/md.py", "is_suspiciously_successive_range", 564, CPyStatic_globals, "str", cpy_r_unicode_range_a);
        goto CPyL125;
    }
    cpy_r_r119 = CPyStatics[48]; /* 'Basic Latin' */
    cpy_r_r120 = CPyStr_Equal(cpy_r_r118, cpy_r_r119);
    CPy_DECREF(cpy_r_r118);
    if (cpy_r_r120) goto CPyL88;
    CPy_INCREF(cpy_r_unicode_range_b);
    if (likely(cpy_r_unicode_range_b != Py_None))
        cpy_r_r121 = cpy_r_unicode_range_b;
    else {
        CPy_TypeErrorTraceback("src/charset_normalizer/md.py", "is_suspiciously_successive_range", 564, CPyStatic_globals, "str", cpy_r_unicode_range_b);
        goto CPyL125;
    }
    cpy_r_r122 = CPyStatics[48]; /* 'Basic Latin' */
    cpy_r_r123 = CPyStr_Equal(cpy_r_r121, cpy_r_r122);
    CPy_DECREF(cpy_r_r121);
    if (!cpy_r_r123) goto CPyL89;
CPyL88: ;
    return 0;
CPyL89: ;
    cpy_r_r124 = CPyStatics[46]; /* 'CJK' */
    CPy_INCREF(cpy_r_unicode_range_a);
    if (likely(cpy_r_unicode_range_a != Py_None))
        cpy_r_r125 = cpy_r_unicode_range_a;
    else {
        CPy_TypeErrorTraceback("src/charset_normalizer/md.py", "is_suspiciously_successive_range", 568, CPyStatic_globals, "str", cpy_r_unicode_range_a);
        goto CPyL125;
    }
    cpy_r_r126 = PyUnicode_Contains(cpy_r_r125, cpy_r_r124);
    CPy_DECREF(cpy_r_r125);
    cpy_r_r127 = cpy_r_r126 >= 0;
    if (unlikely(!cpy_r_r127)) {
        CPy_AddTraceback("src/charset_normalizer/md.py", "is_suspiciously_successive_range", 568, CPyStatic_globals);
        goto CPyL125;
    }
    cpy_r_r128 = cpy_r_r126;
    if (cpy_r_r128) goto CPyL105;
    cpy_r_r129 = CPyStatics[46]; /* 'CJK' */
    CPy_INCREF(cpy_r_unicode_range_b);
    if (likely(cpy_r_unicode_range_b != Py_None))
        cpy_r_r130 = cpy_r_unicode_range_b;
    else {
        CPy_TypeErrorTraceback("src/charset_normalizer/md.py", "is_suspiciously_successive_range", 568, CPyStatic_globals, "str", cpy_r_unicode_range_b);
        goto CPyL125;
    }
    cpy_r_r131 = PyUnicode_Contains(cpy_r_r130, cpy_r_r129);
    CPy_DECREF(cpy_r_r130);
    cpy_r_r132 = cpy_r_r131 >= 0;
    if (unlikely(!cpy_r_r132)) {
        CPy_AddTraceback("src/charset_normalizer/md.py", "is_suspiciously_successive_range", 568, CPyStatic_globals);
        goto CPyL125;
    }
    cpy_r_r133 = cpy_r_r131;
    if (cpy_r_r133) goto CPyL105;
    CPy_INCREF(cpy_r_unicode_range_a);
    if (likely(cpy_r_unicode_range_a != Py_None))
        cpy_r_r134 = cpy_r_unicode_range_a;
    else {
        CPy_TypeErrorTraceback("src/charset_normalizer/md.py", "is_suspiciously_successive_range", 569, CPyStatic_globals, "str", cpy_r_unicode_range_a);
        goto CPyL125;
    }
    cpy_r_r135 = CPyStatics[45]; /* 'Katakana' */
    cpy_r_r136 = CPyStatics[44]; /* 'Hiragana' */
    cpy_r_r137 = CPyStr_Equal(cpy_r_r134, cpy_r_r135);
    if (cpy_r_r137) goto CPyL135;
    cpy_r_r138 = CPyStr_Equal(cpy_r_r134, cpy_r_r136);
    CPy_DECREF(cpy_r_r134);
    if (cpy_r_r138) goto CPyL99;
    if (0) {
        goto CPyL100;
    } else
        goto CPyL124;
CPyL99: ;
    if (!1) goto CPyL124;
CPyL100: ;
    CPy_INCREF(cpy_r_unicode_range_b);
    if (likely(cpy_r_unicode_range_b != Py_None))
        cpy_r_r139 = cpy_r_unicode_range_b;
    else {
        CPy_TypeErrorTraceback("src/charset_normalizer/md.py", "is_suspiciously_successive_range", 570, CPyStatic_globals, "str", cpy_r_unicode_range_b);
        goto CPyL125;
    }
    cpy_r_r140 = CPyStatics[45]; /* 'Katakana' */
    cpy_r_r141 = CPyStatics[44]; /* 'Hiragana' */
    cpy_r_r142 = CPyStr_Equal(cpy_r_r139, cpy_r_r140);
    if (cpy_r_r142) goto CPyL136;
    cpy_r_r143 = CPyStr_Equal(cpy_r_r139, cpy_r_r141);
    CPy_DECREF(cpy_r_r139);
    if (cpy_r_r143) goto CPyL104;
    if (0) {
        goto CPyL105;
    } else
        goto CPyL124;
CPyL104: ;
    if (!1) goto CPyL124;
CPyL105: ;
    cpy_r_r144 = CPyStatics[49]; /* 'Punctuation' */
    CPy_INCREF(cpy_r_unicode_range_a);
    if (likely(cpy_r_unicode_range_a != Py_None))
        cpy_r_r145 = cpy_r_unicode_range_a;
    else {
        CPy_TypeErrorTraceback("src/charset_normalizer/md.py", "is_suspiciously_successive_range", 572, CPyStatic_globals, "str", cpy_r_unicode_range_a);
        goto CPyL125;
    }
    cpy_r_r146 = PyUnicode_Contains(cpy_r_r145, cpy_r_r144);
    CPy_DECREF(cpy_r_r145);
    cpy_r_r147 = cpy_r_r146 >= 0;
    if (unlikely(!cpy_r_r147)) {
        CPy_AddTraceback("src/charset_normalizer/md.py", "is_suspiciously_successive_range", 572, CPyStatic_globals);
        goto CPyL125;
    }
    cpy_r_r148 = cpy_r_r146;
    if (cpy_r_r148) goto CPyL111;
    cpy_r_r149 = CPyStatics[49]; /* 'Punctuation' */
    CPy_INCREF(cpy_r_unicode_range_b);
    if (likely(cpy_r_unicode_range_b != Py_None))
        cpy_r_r150 = cpy_r_unicode_range_b;
    else {
        CPy_TypeErrorTraceback("src/charset_normalizer/md.py", "is_suspiciously_successive_range", 572, CPyStatic_globals, "str", cpy_r_unicode_range_b);
        goto CPyL125;
    }
    cpy_r_r151 = PyUnicode_Contains(cpy_r_r150, cpy_r_r149);
    CPy_DECREF(cpy_r_r150);
    cpy_r_r152 = cpy_r_r151 >= 0;
    if (unlikely(!cpy_r_r152)) {
        CPy_AddTraceback("src/charset_normalizer/md.py", "is_suspiciously_successive_range", 572, CPyStatic_globals);
        goto CPyL125;
    }
    cpy_r_r153 = cpy_r_r151;
    if (!cpy_r_r153) goto CPyL112;
CPyL111: ;
    return 0;
CPyL112: ;
    cpy_r_r154 = CPyStatics[50]; /* 'Forms' */
    CPy_INCREF(cpy_r_unicode_range_a);
    if (likely(cpy_r_unicode_range_a != Py_None))
        cpy_r_r155 = cpy_r_unicode_range_a;
    else {
        CPy_TypeErrorTraceback("src/charset_normalizer/md.py", "is_suspiciously_successive_range", 574, CPyStatic_globals, "str", cpy_r_unicode_range_a);
        goto CPyL125;
    }
    cpy_r_r156 = PyUnicode_Contains(cpy_r_r155, cpy_r_r154);
    CPy_DECREF(cpy_r_r155);
    cpy_r_r157 = cpy_r_r156 >= 0;
    if (unlikely(!cpy_r_r157)) {
        CPy_AddTraceback("src/charset_normalizer/md.py", "is_suspiciously_successive_range", 574, CPyStatic_globals);
        goto CPyL125;
    }
    cpy_r_r158 = cpy_r_r156;
    if (cpy_r_r158) goto CPyL118;
    cpy_r_r159 = CPyStatics[50]; /* 'Forms' */
    CPy_INCREF(cpy_r_unicode_range_b);
    if (likely(cpy_r_unicode_range_b != Py_None))
        cpy_r_r160 = cpy_r_unicode_range_b;
    else {
        CPy_TypeErrorTraceback("src/charset_normalizer/md.py", "is_suspiciously_successive_range", 574, CPyStatic_globals, "str", cpy_r_unicode_range_b);
        goto CPyL125;
    }
    cpy_r_r161 = PyUnicode_Contains(cpy_r_r160, cpy_r_r159);
    CPy_DECREF(cpy_r_r160);
    cpy_r_r162 = cpy_r_r161 >= 0;
    if (unlikely(!cpy_r_r162)) {
        CPy_AddTraceback("src/charset_normalizer/md.py", "is_suspiciously_successive_range", 574, CPyStatic_globals);
        goto CPyL125;
    }
    cpy_r_r163 = cpy_r_r161;
    if (!cpy_r_r163) goto CPyL119;
CPyL118: ;
    return 0;
CPyL119: ;
    CPy_INCREF(cpy_r_unicode_range_a);
    if (likely(cpy_r_unicode_range_a != Py_None))
        cpy_r_r164 = cpy_r_unicode_range_a;
    else {
        CPy_TypeErrorTraceback("src/charset_normalizer/md.py", "is_suspiciously_successive_range", 576, CPyStatic_globals, "str", cpy_r_unicode_range_a);
        goto CPyL125;
    }
    cpy_r_r165 = CPyStatics[48]; /* 'Basic Latin' */
    cpy_r_r166 = CPyStr_Equal(cpy_r_r164, cpy_r_r165);
    CPy_DECREF(cpy_r_r164);
    if (cpy_r_r166) goto CPyL123;
    CPy_INCREF(cpy_r_unicode_range_b);
    if (likely(cpy_r_unicode_range_b != Py_None))
        cpy_r_r167 = cpy_r_unicode_range_b;
    else {
        CPy_TypeErrorTraceback("src/charset_normalizer/md.py", "is_suspiciously_successive_range", 576, CPyStatic_globals, "str", cpy_r_unicode_range_b);
        goto CPyL125;
    }
    cpy_r_r168 = CPyStatics[48]; /* 'Basic Latin' */
    cpy_r_r169 = CPyStr_Equal(cpy_r_r167, cpy_r_r168);
    CPy_DECREF(cpy_r_r167);
    if (!cpy_r_r169) goto CPyL124;
CPyL123: ;
    return 0;
CPyL124: ;
    return 1;
CPyL125: ;
    cpy_r_r170 = 2;
    return cpy_r_r170;
CPyL126: ;
    CPy_DecRef(cpy_r_r4);
    goto CPyL125;
CPyL127: ;
    CPy_DecRef(cpy_r_r49);
    goto CPyL125;
CPyL128: ;
    CPy_DECREF_NO_IMM(cpy_r_r49);
    CPy_DECREF_NO_IMM(cpy_r_r52);
    goto CPyL49;
CPyL129: ;
    CPy_DecRef(cpy_r_r49);
    CPy_DecRef(cpy_r_r52);
    goto CPyL125;
CPyL130: ;
    CPy_DecRef(cpy_r_r49);
    CPy_DecRef(cpy_r_r52);
    CPy_DecRef(cpy_r_r62);
    goto CPyL125;
CPyL131: ;
    CPy_DECREF(cpy_r_r62);
    goto CPyL48;
CPyL132: ;
    CPy_DECREF_NO_IMM(cpy_r_r49);
    CPy_DECREF_NO_IMM(cpy_r_r52);
    goto CPyL47;
CPyL133: ;
    CPy_DECREF(cpy_r_r74);
    goto CPyL53;
CPyL134: ;
    CPy_DECREF(cpy_r_r81);
    goto CPyL58;
CPyL135: ;
    CPy_DECREF(cpy_r_r134);
    goto CPyL99;
CPyL136: ;
    CPy_DECREF(cpy_r_r139);
    goto CPyL104;
}

PyObject *CPyPy_is_suspiciously_successive_range(PyObject *self, PyObject *const *args, size_t nargs, PyObject *kwnames) {
    static const char * const kwlist[] = {"unicode_range_a", "unicode_range_b", 0};
    static CPyArg_Parser parser = {"OO:is_suspiciously_successive_range", kwlist, 0};
    PyObject *obj_unicode_range_a;
    PyObject *obj_unicode_range_b;
    if (!CPyArg_ParseStackAndKeywordsSimple(args, nargs, kwnames, &parser, &obj_unicode_range_a, &obj_unicode_range_b)) {
        return NULL;
    }
    PyObject *arg_unicode_range_a;
    if (PyUnicode_Check(obj_unicode_range_a))
        arg_unicode_range_a = obj_unicode_range_a;
    else {
        arg_unicode_range_a = NULL;
    }
    if (arg_unicode_range_a != NULL) goto __LL7;
    if (obj_unicode_range_a == Py_None)
        arg_unicode_range_a = obj_unicode_range_a;
    else {
        arg_unicode_range_a = NULL;
    }
    if (arg_unicode_range_a != NULL) goto __LL7;
    CPy_TypeError("str or None", obj_unicode_range_a); 
    goto fail;
__LL7: ;
    PyObject *arg_unicode_range_b;
    if (PyUnicode_Check(obj_unicode_range_b))
        arg_unicode_range_b = obj_unicode_range_b;
    else {
        arg_unicode_range_b = NULL;
    }
    if (arg_unicode_range_b != NULL) goto __LL8;
    if (obj_unicode_range_b == Py_None)
        arg_unicode_range_b = obj_unicode_range_b;
    else {
        arg_unicode_range_b = NULL;
    }
    if (arg_unicode_range_b != NULL) goto __LL8;
    CPy_TypeError("str or None", obj_unicode_range_b); 
    goto fail;
__LL8: ;
    char retval = CPyDef_is_suspiciously_successive_range(arg_unicode_range_a, arg_unicode_range_b);
    if (retval == 2) {
        return NULL;
    }
    PyObject *retbox = retval ? Py_True : Py_False;
    CPy_INCREF(retbox);
    return retbox;
fail: ;
    CPy_AddTraceback("src/charset_normalizer/md.py", "is_suspiciously_successive_range", 509, CPyStatic_globals);
    return NULL;
}

double CPyDef_mess_ratio(PyObject *cpy_r_decoded_sequence, double cpy_r_maximum_threshold, char cpy_r_debug, uint32_t cpy_r___bitmap) {
    uint32_t cpy_r_r0;
    char cpy_r_r1;
    PyObject *cpy_r_r2;
    PyObject *cpy_r_r3;
    PyObject **cpy_r_r5;
    PyObject *cpy_r_r6;
    PyObject *cpy_r_r7;
    CPyPtr cpy_r_r8;
    int64_t cpy_r_r9;
    PyObject *cpy_r_r10;
    int64_t cpy_r_r11;
    CPyPtr cpy_r_r12;
    int64_t cpy_r_r13;
    char cpy_r_r14;
    CPyPtr cpy_r_r15;
    CPyPtr cpy_r_r16;
    int64_t cpy_r_r17;
    CPyPtr cpy_r_r18;
    PyObject *cpy_r_r19;
    PyObject *cpy_r_r20;
    PyObject *cpy_r_r21;
    int64_t cpy_r_r22;
    int64_t cpy_r_r23;
    char cpy_r_r24;
    CPyTagged cpy_r_r25;
    CPyTagged cpy_r_r26;
    double cpy_r_mean_mess_ratio;
    int64_t cpy_r_r27;
    char cpy_r_r28;
    int64_t cpy_r_r29;
    char cpy_r_r30;
    char cpy_r_r31;
    char cpy_r_r32;
    CPyTagged cpy_r_intermediary_mean_mess_ratio_calc;
    int64_t cpy_r_r33;
    char cpy_r_r34;
    int64_t cpy_r_r35;
    char cpy_r_r36;
    char cpy_r_r37;
    char cpy_r_r38;
    char cpy_r_r39;
    PyObject *cpy_r_r40;
    PyObject *cpy_r_r41;
    int64_t cpy_r_r42;
    char cpy_r_r43;
    int64_t cpy_r_r44;
    CPyTagged cpy_r_r45;
    CPyTagged cpy_r_index;
    char cpy_r_r46;
    int64_t cpy_r_r47;
    char cpy_r_r48;
    int64_t cpy_r_r49;
    char cpy_r_r50;
    char cpy_r_r51;
    char cpy_r_r52;
    PyObject *cpy_r_r53;
    int64_t cpy_r_r54;
    CPyPtr cpy_r_r55;
    int64_t cpy_r_r56;
    char cpy_r_r57;
    CPyPtr cpy_r_r58;
    CPyPtr cpy_r_r59;
    int64_t cpy_r_r60;
    CPyPtr cpy_r_r61;
    PyObject *cpy_r_r62;
    PyObject *cpy_r_r63;
    char cpy_r_r64;
    char cpy_r_r65;
    int64_t cpy_r_r66;
    int64_t cpy_r_r67;
    char cpy_r_r68;
    int64_t cpy_r_r69;
    char cpy_r_r70;
    char cpy_r_r71;
    char cpy_r_r72;
    CPyTagged cpy_r_r73;
    char cpy_r_r74;
    CPyTagged cpy_r_r75;
    int64_t cpy_r_r76;
    char cpy_r_r77;
    char cpy_r_r78;
    char cpy_r_r79;
    char cpy_r_r80;
    PyObject *cpy_r_r81;
    PyObject *cpy_r_r82;
    PyObject *cpy_r_r83;
    int64_t cpy_r_r84;
    CPyPtr cpy_r_r85;
    int64_t cpy_r_r86;
    char cpy_r_r87;
    CPyPtr cpy_r_r88;
    CPyPtr cpy_r_r89;
    int64_t cpy_r_r90;
    CPyPtr cpy_r_r91;
    PyObject *cpy_r_r92;
    PyObject *cpy_r_r93;
    double cpy_r_r94;
    char cpy_r_r95;
    PyObject *cpy_r_r96;
    PyObject *cpy_r_r97;
    PyObject *cpy_r_r98;
    PyObject *cpy_r_r99;
    int64_t cpy_r_r100;
    double cpy_r_r101;
    char cpy_r_r102;
    PyObject *cpy_r_r103;
    PyObject *cpy_r_r104;
    PyObject *cpy_r_r105;
    PyObject *cpy_r_r106;
    char cpy_r_r107;
    int64_t cpy_r_r108;
    CPyTagged cpy_r_r109;
    PyObject *cpy_r_r110;
    PyObject *cpy_r_r111;
    PyObject *cpy_r_r112;
    PyObject *cpy_r_r113;
    PyObject **cpy_r_r115;
    PyObject *cpy_r_r116;
    PyObject *cpy_r_r117;
    PyObject *cpy_r_r118;
    PyObject *cpy_r_r119;
    CPyTagged cpy_r_r120;
    PyObject *cpy_r_r121;
    PyObject *cpy_r_r122;
    PyObject *cpy_r_r123;
    PyObject *cpy_r_r124;
    PyObject *cpy_r_r125;
    PyObject *cpy_r_r126;
    PyObject *cpy_r_r127;
    PyObject *cpy_r_r128;
    PyObject *cpy_r_r129;
    PyObject *cpy_r_r130;
    PyObject *cpy_r_r131;
    PyObject **cpy_r_r133;
    PyObject *cpy_r_r134;
    int64_t cpy_r_r135;
    char cpy_r_r136;
    CPyTagged cpy_r_r137;
    char cpy_r_r138;
    PyObject *cpy_r_r139;
    PyObject *cpy_r_r140;
    PyObject *cpy_r_r141;
    CPyTagged cpy_r_r142;
    PyObject *cpy_r_r143;
    PyObject *cpy_r_r144;
    PyObject *cpy_r_r145;
    PyObject *cpy_r_r146;
    PyObject *cpy_r_r147;
    PyObject *cpy_r_r148;
    PyObject **cpy_r_r150;
    PyObject *cpy_r_r151;
    PyObject *cpy_r_r152;
    PyObject *cpy_r_r153;
    PyObject *cpy_r_r154;
    CPyTagged cpy_r_r155;
    PyObject *cpy_r_r156;
    PyObject *cpy_r_r157;
    PyObject *cpy_r_r158;
    PyObject *cpy_r_r159;
    PyObject *cpy_r_r160;
    PyObject *cpy_r_r161;
    PyObject **cpy_r_r163;
    PyObject *cpy_r_r164;
    int64_t cpy_r_r165;
    CPyPtr cpy_r_r166;
    int64_t cpy_r_r167;
    char cpy_r_r168;
    CPyPtr cpy_r_r169;
    CPyPtr cpy_r_r170;
    int64_t cpy_r_r171;
    CPyPtr cpy_r_r172;
    PyObject *cpy_r_r173;
    PyObject *cpy_r_r174;
    PyObject *cpy_r_r175;
    PyObject *cpy_r_r176;
    PyObject *cpy_r_r177;
    CPyTagged cpy_r_r178;
    PyObject *cpy_r_r179;
    PyObject *cpy_r_r180;
    PyObject *cpy_r_r181;
    double cpy_r_r182;
    char cpy_r_r183;
    PyObject *cpy_r_r184;
    PyObject *cpy_r_r185;
    PyObject *cpy_r_r186;
    PyObject *cpy_r_r187;
    PyObject *cpy_r_r188;
    PyObject *cpy_r_r189;
    PyObject **cpy_r_r191;
    PyObject *cpy_r_r192;
    int64_t cpy_r_r193;
    PyObject *cpy_r_r194;
    PyObject *cpy_r_r195;
    PyObject *cpy_r_r196;
    PyObject *cpy_r_r197;
    PyObject *cpy_r_r198;
    PyObject **cpy_r_r200;
    PyObject *cpy_r_r201;
    double cpy_r_r202;
    char cpy_r_r203;
    PyObject *cpy_r_r204;
    double cpy_r_r205;
    cpy_r_r0 = cpy_r___bitmap & 1;
    cpy_r_r1 = cpy_r_r0 == 0;
    if (!cpy_r_r1) goto CPyL2;
    cpy_r_maximum_threshold = 0.2;
CPyL2: ;
    if (cpy_r_debug != 2) goto CPyL4;
    cpy_r_debug = 0;
CPyL4: ;
    cpy_r_r2 = (PyObject *)CPyType_MessDetectorPlugin;
    cpy_r_r3 = CPyStatics[51]; /* '__subclasses__' */
    PyObject *cpy_r_r4[1] = {cpy_r_r2};
    cpy_r_r5 = (PyObject **)&cpy_r_r4;
    cpy_r_r6 = PyObject_VectorcallMethod(cpy_r_r3, cpy_r_r5, 9223372036854775809ULL, 0);
    if (unlikely(cpy_r_r6 == NULL)) {
        CPy_AddTraceback("src/charset_normalizer/md.py", "mess_ratio", 591, CPyStatic_globals);
        goto CPyL110;
    }
    if (likely(PyList_Check(cpy_r_r6)))
        cpy_r_r7 = cpy_r_r6;
    else {
        CPy_TypeErrorTraceback("src/charset_normalizer/md.py", "mess_ratio", 591, CPyStatic_globals, "list", cpy_r_r6);
        goto CPyL110;
    }
    cpy_r_r8 = (CPyPtr)&((PyVarObject *)cpy_r_r7)->ob_size;
    cpy_r_r9 = *(int64_t *)cpy_r_r8;
    cpy_r_r10 = PyList_New(cpy_r_r9);
    if (unlikely(cpy_r_r10 == NULL)) {
        CPy_AddTraceback("src/charset_normalizer/md.py", "mess_ratio", 590, CPyStatic_globals);
        goto CPyL111;
    }
    cpy_r_r11 = 0;
CPyL8: ;
    cpy_r_r12 = (CPyPtr)&((PyVarObject *)cpy_r_r7)->ob_size;
    cpy_r_r13 = *(int64_t *)cpy_r_r12;
    cpy_r_r14 = cpy_r_r11 < cpy_r_r13;
    if (!cpy_r_r14) goto CPyL112;
    cpy_r_r15 = (CPyPtr)&((PyListObject *)cpy_r_r7)->ob_item;
    cpy_r_r16 = *(CPyPtr *)cpy_r_r15;
    cpy_r_r17 = cpy_r_r11 * 8;
    cpy_r_r18 = cpy_r_r16 + cpy_r_r17;
    cpy_r_r19 = *(PyObject * *)cpy_r_r18;
    CPy_INCREF(cpy_r_r19);
    cpy_r_r20 = PyObject_Vectorcall(cpy_r_r19, 0, 0, 0);
    CPy_DECREF(cpy_r_r19);
    if (unlikely(cpy_r_r20 == NULL)) {
        CPy_AddTraceback("src/charset_normalizer/md.py", "mess_ratio", 591, CPyStatic_globals);
        goto CPyL113;
    }
    if (likely(PyObject_TypeCheck(cpy_r_r20, CPyType_MessDetectorPlugin)))
        cpy_r_r21 = cpy_r_r20;
    else {
        CPy_TypeErrorTraceback("src/charset_normalizer/md.py", "mess_ratio", 591, CPyStatic_globals, "charset_normalizer.md.MessDetectorPlugin", cpy_r_r20);
        goto CPyL113;
    }
    CPyList_SetItemUnsafe(cpy_r_r10, cpy_r_r11, cpy_r_r21);
    cpy_r_r22 = cpy_r_r11 + 1;
    cpy_r_r11 = cpy_r_r22;
    goto CPyL8;
CPyL13: ;
    cpy_r_r23 = CPyStr_Size_size_t(cpy_r_decoded_sequence);
    cpy_r_r24 = cpy_r_r23 >= 0;
    if (unlikely(!cpy_r_r24)) {
        CPy_AddTraceback("src/charset_normalizer/md.py", "mess_ratio", 594, CPyStatic_globals);
        goto CPyL114;
    }
    cpy_r_r25 = cpy_r_r23 << 1;
    cpy_r_r26 = CPyTagged_Add(cpy_r_r25, 2);
    cpy_r_mean_mess_ratio = 0.0;
    cpy_r_r27 = cpy_r_r26 & 1;
    cpy_r_r28 = cpy_r_r27 != 0;
    if (cpy_r_r28) goto CPyL16;
    cpy_r_r29 = 1024 & 1;
    cpy_r_r30 = cpy_r_r29 != 0;
    if (!cpy_r_r30) goto CPyL17;
CPyL16: ;
    cpy_r_r31 = CPyTagged_IsLt_(cpy_r_r26, 1024);
    if (cpy_r_r31) {
        goto CPyL18;
    } else
        goto CPyL19;
CPyL17: ;
    cpy_r_r32 = (Py_ssize_t)cpy_r_r26 < (Py_ssize_t)1024;
    if (!cpy_r_r32) goto CPyL19;
CPyL18: ;
    cpy_r_intermediary_mean_mess_ratio_calc = 64;
    goto CPyL25;
CPyL19: ;
    cpy_r_r33 = cpy_r_r26 & 1;
    cpy_r_r34 = cpy_r_r33 != 0;
    if (cpy_r_r34) goto CPyL21;
    cpy_r_r35 = 2048 & 1;
    cpy_r_r36 = cpy_r_r35 != 0;
    if (!cpy_r_r36) goto CPyL22;
CPyL21: ;
    cpy_r_r37 = CPyTagged_IsLt_(2048, cpy_r_r26);
    cpy_r_r38 = cpy_r_r37 ^ 1;
    if (cpy_r_r38) {
        goto CPyL23;
    } else
        goto CPyL24;
CPyL22: ;
    cpy_r_r39 = (Py_ssize_t)cpy_r_r26 <= (Py_ssize_t)2048;
    if (!cpy_r_r39) goto CPyL24;
CPyL23: ;
    cpy_r_intermediary_mean_mess_ratio_calc = 128;
    goto CPyL25;
CPyL24: ;
    cpy_r_intermediary_mean_mess_ratio_calc = 256;
CPyL25: ;
    cpy_r_r40 = CPyStatics[52]; /* '\n' */
    cpy_r_r41 = PyUnicode_Concat(cpy_r_decoded_sequence, cpy_r_r40);
    if (unlikely(cpy_r_r41 == NULL)) {
        CPy_AddTraceback("src/charset_normalizer/md.py", "mess_ratio", 605, CPyStatic_globals);
        goto CPyL115;
    }
    cpy_r_r42 = CPyStr_Size_size_t(cpy_r_r41);
    cpy_r_r43 = cpy_r_r42 >= 0;
    if (unlikely(!cpy_r_r43)) {
        CPy_AddTraceback("src/charset_normalizer/md.py", "mess_ratio", 605, CPyStatic_globals);
        goto CPyL116;
    }
    cpy_r_r44 = 0;
    cpy_r_r45 = 0;
    CPyTagged_INCREF(cpy_r_r45);
    cpy_r_index = cpy_r_r45;
CPyL28: ;
    cpy_r_r46 = cpy_r_r44 < cpy_r_r42;
    if (!cpy_r_r46) goto CPyL117;
    cpy_r_r47 = cpy_r_r45 & 1;
    cpy_r_r48 = cpy_r_r47 != 0;
    if (cpy_r_r48) goto CPyL31;
    cpy_r_r49 = cpy_r_r26 & 1;
    cpy_r_r50 = cpy_r_r49 != 0;
    if (!cpy_r_r50) goto CPyL32;
CPyL31: ;
    cpy_r_r51 = CPyTagged_IsLt_(cpy_r_r45, cpy_r_r26);
    if (cpy_r_r51) {
        goto CPyL33;
    } else
        goto CPyL117;
CPyL32: ;
    cpy_r_r52 = (Py_ssize_t)cpy_r_r45 < (Py_ssize_t)cpy_r_r26;
    if (!cpy_r_r52) goto CPyL117;
CPyL33: ;
    cpy_r_r53 = CPyStr_GetItemUnsafe(cpy_r_r41, cpy_r_r44);
    if (unlikely(cpy_r_r53 == NULL)) {
        CPy_AddTraceback("src/charset_normalizer/md.py", "mess_ratio", 605, CPyStatic_globals);
        goto CPyL118;
    }
    cpy_r_r54 = 0;
CPyL35: ;
    cpy_r_r55 = (CPyPtr)&((PyVarObject *)cpy_r_r10)->ob_size;
    cpy_r_r56 = *(int64_t *)cpy_r_r55;
    cpy_r_r57 = cpy_r_r54 < cpy_r_r56;
    if (!cpy_r_r57) goto CPyL119;
    cpy_r_r58 = (CPyPtr)&((PyListObject *)cpy_r_r10)->ob_item;
    cpy_r_r59 = *(CPyPtr *)cpy_r_r58;
    cpy_r_r60 = cpy_r_r54 * 8;
    cpy_r_r61 = cpy_r_r59 + cpy_r_r60;
    cpy_r_r62 = *(PyObject * *)cpy_r_r61;
    CPy_INCREF(cpy_r_r62);
    if (likely(PyObject_TypeCheck(cpy_r_r62, CPyType_MessDetectorPlugin)))
        cpy_r_r63 = cpy_r_r62;
    else {
        CPy_TypeErrorTraceback("src/charset_normalizer/md.py", "mess_ratio", 606, CPyStatic_globals, "charset_normalizer.md.MessDetectorPlugin", cpy_r_r62);
        goto CPyL120;
    }
    cpy_r_r64 = CPY_GET_METHOD(cpy_r_r63, CPyType_MessDetectorPlugin, 0, charset_normalizer___md___MessDetectorPluginObject, char (*)(PyObject *, PyObject *))(cpy_r_r63, cpy_r_r53); /* eligible */
    if (unlikely(cpy_r_r64 == 2)) {
        CPy_AddTraceback("src/charset_normalizer/md.py", "mess_ratio", 607, CPyStatic_globals);
        goto CPyL121;
    }
    if (!cpy_r_r64) goto CPyL122;
    cpy_r_r65 = CPY_GET_METHOD(cpy_r_r63, CPyType_MessDetectorPlugin, 1, charset_normalizer___md___MessDetectorPluginObject, char (*)(PyObject *, PyObject *))(cpy_r_r63, cpy_r_r53); /* feed */
    CPy_DECREF_NO_IMM(cpy_r_r63);
    if (unlikely(cpy_r_r65 == 2)) {
        CPy_AddTraceback("src/charset_normalizer/md.py", "mess_ratio", 608, CPyStatic_globals);
        goto CPyL120;
    }
CPyL40: ;
    cpy_r_r66 = cpy_r_r54 + 1;
    cpy_r_r54 = cpy_r_r66;
    goto CPyL35;
CPyL41: ;
    cpy_r_r67 = cpy_r_index & 1;
    cpy_r_r68 = cpy_r_r67 != 0;
    if (cpy_r_r68) goto CPyL43;
    cpy_r_r69 = 0 & 1;
    cpy_r_r70 = cpy_r_r69 != 0;
    if (!cpy_r_r70) goto CPyL44;
CPyL43: ;
    cpy_r_r71 = CPyTagged_IsLt_(0, cpy_r_index);
    if (cpy_r_r71) {
        goto CPyL45;
    } else
        goto CPyL47;
CPyL44: ;
    cpy_r_r72 = (Py_ssize_t)cpy_r_index > (Py_ssize_t)0;
    if (!cpy_r_r72) goto CPyL47;
CPyL45: ;
    cpy_r_r73 = CPyTagged_Remainder(cpy_r_index, cpy_r_intermediary_mean_mess_ratio_calc);
    if (unlikely(cpy_r_r73 == CPY_INT_TAG)) {
        CPy_AddTraceback("src/charset_normalizer/md.py", "mess_ratio", 611, CPyStatic_globals);
        goto CPyL118;
    }
    cpy_r_r74 = cpy_r_r73 == 0;
    CPyTagged_DECREF(cpy_r_r73);
    if (cpy_r_r74) goto CPyL123;
CPyL47: ;
    cpy_r_r75 = CPyTagged_Subtract(cpy_r_r26, 2);
    cpy_r_r76 = cpy_r_index & 1;
    cpy_r_r77 = cpy_r_r76 != 0;
    if (!cpy_r_r77) goto CPyL49;
    cpy_r_r78 = CPyTagged_IsEq_(cpy_r_index, cpy_r_r75);
    cpy_r_r79 = cpy_r_r78;
    goto CPyL50;
CPyL49: ;
    cpy_r_r80 = cpy_r_index == cpy_r_r75;
    cpy_r_r79 = cpy_r_r80;
CPyL50: ;
    CPyTagged_DECREF(cpy_r_index);
    CPyTagged_DECREF(cpy_r_r75);
    if (!cpy_r_r79) goto CPyL66;
CPyL51: ;
    cpy_r_r81 = CPyStatics[114]; /* 0 */
    if (CPyFloat_Check(cpy_r_r81))
        cpy_r_r82 = cpy_r_r81;
    else {
        cpy_r_r82 = NULL;
    }
    if (cpy_r_r82 != NULL) goto __LL9;
    if (PyLong_Check(cpy_r_r81))
        cpy_r_r82 = cpy_r_r81;
    else {
        cpy_r_r82 = NULL;
    }
    if (cpy_r_r82 != NULL) goto __LL9;
    CPy_TypeErrorTraceback("src/charset_normalizer/md.py", "mess_ratio", -1, CPyStatic_globals, "union[float, int]", cpy_r_r81);
    goto CPyL124;
__LL9: ;
    cpy_r_r83 = cpy_r_r82;
    cpy_r_r84 = 0;
CPyL53: ;
    cpy_r_r85 = (CPyPtr)&((PyVarObject *)cpy_r_r10)->ob_size;
    cpy_r_r86 = *(int64_t *)cpy_r_r85;
    cpy_r_r87 = cpy_r_r84 < cpy_r_r86;
    if (!cpy_r_r87) goto CPyL61;
    cpy_r_r88 = (CPyPtr)&((PyListObject *)cpy_r_r10)->ob_item;
    cpy_r_r89 = *(CPyPtr *)cpy_r_r88;
    cpy_r_r90 = cpy_r_r84 * 8;
    cpy_r_r91 = cpy_r_r89 + cpy_r_r90;
    cpy_r_r92 = *(PyObject * *)cpy_r_r91;
    CPy_INCREF(cpy_r_r92);
    if (likely(PyObject_TypeCheck(cpy_r_r92, CPyType_MessDetectorPlugin)))
        cpy_r_r93 = cpy_r_r92;
    else {
        CPy_TypeErrorTraceback("src/charset_normalizer/md.py", "mess_ratio", 613, CPyStatic_globals, "charset_normalizer.md.MessDetectorPlugin", cpy_r_r92);
        goto CPyL125;
    }
    cpy_r_r94 = CPY_GET_ATTR(cpy_r_r93, CPyType_MessDetectorPlugin, 3, charset_normalizer___md___MessDetectorPluginObject, double); /* ratio */
    CPy_DECREF_NO_IMM(cpy_r_r93);
    cpy_r_r95 = cpy_r_r94 == -113.0;
    if (unlikely(cpy_r_r95)) goto CPyL57;
CPyL56: ;
    cpy_r_r96 = PyFloat_FromDouble(cpy_r_r94);
    cpy_r_r97 = PyNumber_Add(cpy_r_r83, cpy_r_r96);
    CPy_DECREF(cpy_r_r83);
    CPy_DECREF(cpy_r_r96);
    if (unlikely(cpy_r_r97 == NULL)) {
        CPy_AddTraceback("src/charset_normalizer/md.py", "mess_ratio", -1, CPyStatic_globals);
        goto CPyL124;
    } else
        goto CPyL58;
CPyL57: ;
    cpy_r_r98 = PyErr_Occurred();
    if (unlikely(cpy_r_r98 != NULL)) {
        CPy_AddTraceback("src/charset_normalizer/md.py", "mess_ratio", 613, CPyStatic_globals);
        goto CPyL125;
    } else
        goto CPyL56;
CPyL58: ;
    if (CPyFloat_Check(cpy_r_r97))
        cpy_r_r99 = cpy_r_r97;
    else {
        cpy_r_r99 = NULL;
    }
    if (cpy_r_r99 != NULL) goto __LL10;
    if (PyLong_Check(cpy_r_r97))
        cpy_r_r99 = cpy_r_r97;
    else {
        cpy_r_r99 = NULL;
    }
    if (cpy_r_r99 != NULL) goto __LL10;
    CPy_TypeErrorTraceback("src/charset_normalizer/md.py", "mess_ratio", -1, CPyStatic_globals, "union[float, int]", cpy_r_r97);
    goto CPyL124;
__LL10: ;
    cpy_r_r83 = cpy_r_r99;
    cpy_r_r100 = cpy_r_r84 + 1;
    cpy_r_r84 = cpy_r_r100;
    goto CPyL53;
CPyL61: ;
    cpy_r_r101 = PyFloat_AsDouble(cpy_r_r83);
    if (cpy_r_r101 == -1.0 && PyErr_Occurred()) {
        CPy_TypeError("float", cpy_r_r83); cpy_r_r101 = -113.0;
    }
    CPy_DECREF(cpy_r_r83);
    cpy_r_r102 = cpy_r_r101 == -113.0;
    if (unlikely(cpy_r_r102)) goto CPyL63;
CPyL62: ;
    cpy_r_mean_mess_ratio = cpy_r_r101;
    cpy_r_r103 = PyFloat_FromDouble(cpy_r_mean_mess_ratio);
    cpy_r_r104 = PyFloat_FromDouble(cpy_r_maximum_threshold);
    cpy_r_r105 = PyObject_RichCompare(cpy_r_r103, cpy_r_r104, 5);
    CPy_DECREF(cpy_r_r103);
    CPy_DECREF(cpy_r_r104);
    if (unlikely(cpy_r_r105 == NULL)) {
        CPy_AddTraceback("src/charset_normalizer/md.py", "mess_ratio", 615, CPyStatic_globals);
        goto CPyL124;
    } else
        goto CPyL64;
CPyL63: ;
    cpy_r_r106 = PyErr_Occurred();
    if (unlikely(cpy_r_r106 != NULL)) {
        CPy_AddTraceback("src/charset_normalizer/md.py", "mess_ratio", 613, CPyStatic_globals);
        goto CPyL124;
    } else
        goto CPyL62;
CPyL64: ;
    if (unlikely(!PyBool_Check(cpy_r_r105))) {
        CPy_TypeError("bool", cpy_r_r105); cpy_r_r107 = 2;
    } else
        cpy_r_r107 = cpy_r_r105 == Py_True;
    CPy_DECREF(cpy_r_r105);
    if (unlikely(cpy_r_r107 == 2)) {
        CPy_AddTraceback("src/charset_normalizer/md.py", "mess_ratio", 615, CPyStatic_globals);
        goto CPyL124;
    }
    if (cpy_r_r107) goto CPyL126;
CPyL66: ;
    cpy_r_r108 = cpy_r_r44 + 1;
    cpy_r_r44 = cpy_r_r108;
    cpy_r_r109 = CPyTagged_Add(cpy_r_r45, 2);
    CPyTagged_DECREF(cpy_r_r45);
    CPyTagged_INCREF(cpy_r_r109);
    cpy_r_r45 = cpy_r_r109;
    cpy_r_index = cpy_r_r109;
    goto CPyL28;
CPyL67: ;
    if (!cpy_r_debug) goto CPyL127;
    cpy_r_r110 = CPyStatics[53]; /* 'charset_normalizer' */
    cpy_r_r111 = CPyStatic_globals;
    cpy_r_r112 = CPyStatics[54]; /* 'getLogger' */
    cpy_r_r113 = CPyDict_GetItem(cpy_r_r111, cpy_r_r112);
    if (unlikely(cpy_r_r113 == NULL)) {
        CPy_AddTraceback("src/charset_normalizer/md.py", "mess_ratio", 619, CPyStatic_globals);
        goto CPyL128;
    }
    PyObject *cpy_r_r114[1] = {cpy_r_r110};
    cpy_r_r115 = (PyObject **)&cpy_r_r114;
    cpy_r_r116 = PyObject_Vectorcall(cpy_r_r113, cpy_r_r115, 1, 0);
    CPy_DECREF(cpy_r_r113);
    if (unlikely(cpy_r_r116 == NULL)) {
        CPy_AddTraceback("src/charset_normalizer/md.py", "mess_ratio", 619, CPyStatic_globals);
        goto CPyL128;
    }
    cpy_r_r117 = CPyStatic_globals;
    cpy_r_r118 = CPyStatics[55]; /* 'TRACE' */
    cpy_r_r119 = CPyDict_GetItem(cpy_r_r117, cpy_r_r118);
    if (unlikely(cpy_r_r119 == NULL)) {
        CPy_AddTraceback("src/charset_normalizer/md.py", "mess_ratio", 622, CPyStatic_globals);
        goto CPyL129;
    }
    if (likely(PyLong_Check(cpy_r_r119)))
        cpy_r_r120 = CPyTagged_FromObject(cpy_r_r119);
    else {
        CPy_TypeError("int", cpy_r_r119); cpy_r_r120 = CPY_INT_TAG;
    }
    CPy_DECREF(cpy_r_r119);
    if (unlikely(cpy_r_r120 == CPY_INT_TAG)) {
        CPy_AddTraceback("src/charset_normalizer/md.py", "mess_ratio", 622, CPyStatic_globals);
        goto CPyL129;
    }
    cpy_r_r121 = CPyStatics[56]; /* ('Mess-detector extended-analysis start. '
                                    'intermediary_mean_mess_ratio_calc=') */
    cpy_r_r122 = CPyTagged_Str(cpy_r_intermediary_mean_mess_ratio_calc);
    CPyTagged_DECREF(cpy_r_intermediary_mean_mess_ratio_calc);
    if (unlikely(cpy_r_r122 == NULL)) {
        CPy_AddTraceback("src/charset_normalizer/md.py", "mess_ratio", 623, CPyStatic_globals);
        goto CPyL130;
    }
    cpy_r_r123 = CPyStatics[57]; /* ' mean_mess_ratio=' */
    cpy_r_r124 = PyFloat_FromDouble(cpy_r_mean_mess_ratio);
    cpy_r_r125 = PyObject_Str(cpy_r_r124);
    CPy_DECREF(cpy_r_r124);
    if (unlikely(cpy_r_r125 == NULL)) {
        CPy_AddTraceback("src/charset_normalizer/md.py", "mess_ratio", 623, CPyStatic_globals);
        goto CPyL131;
    }
    cpy_r_r126 = CPyStatics[58]; /* ' maximum_threshold=' */
    cpy_r_r127 = PyFloat_FromDouble(cpy_r_maximum_threshold);
    cpy_r_r128 = PyObject_Str(cpy_r_r127);
    CPy_DECREF(cpy_r_r127);
    if (unlikely(cpy_r_r128 == NULL)) {
        CPy_AddTraceback("src/charset_normalizer/md.py", "mess_ratio", 623, CPyStatic_globals);
        goto CPyL132;
    }
    cpy_r_r129 = CPyStr_Build(6, cpy_r_r121, cpy_r_r122, cpy_r_r123, cpy_r_r125, cpy_r_r126, cpy_r_r128);
    CPy_DECREF(cpy_r_r122);
    CPy_DECREF(cpy_r_r125);
    CPy_DECREF(cpy_r_r128);
    if (unlikely(cpy_r_r129 == NULL)) {
        CPy_AddTraceback("src/charset_normalizer/md.py", "mess_ratio", 623, CPyStatic_globals);
        goto CPyL130;
    }
    cpy_r_r130 = CPyStatics[59]; /* 'log' */
    cpy_r_r131 = CPyTagged_StealAsObject(cpy_r_r120);
    PyObject *cpy_r_r132[3] = {cpy_r_r116, cpy_r_r131, cpy_r_r129};
    cpy_r_r133 = (PyObject **)&cpy_r_r132;
    cpy_r_r134 = PyObject_VectorcallMethod(cpy_r_r130, cpy_r_r133, 9223372036854775811ULL, 0);
    if (unlikely(cpy_r_r134 == NULL)) {
        CPy_AddTraceback("src/charset_normalizer/md.py", "mess_ratio", 621, CPyStatic_globals);
        goto CPyL133;
    } else
        goto CPyL134;
CPyL77: ;
    CPy_DECREF(cpy_r_r131);
    CPy_DECREF(cpy_r_r129);
    cpy_r_r135 = CPyStr_Size_size_t(cpy_r_decoded_sequence);
    cpy_r_r136 = cpy_r_r135 >= 0;
    if (unlikely(!cpy_r_r136)) {
        CPy_AddTraceback("src/charset_normalizer/md.py", "mess_ratio", 628, CPyStatic_globals);
        goto CPyL135;
    }
    cpy_r_r137 = cpy_r_r135 << 1;
    cpy_r_r138 = (Py_ssize_t)cpy_r_r137 > (Py_ssize_t)32;
    if (!cpy_r_r138) goto CPyL92;
    cpy_r_r139 = CPyStatic_globals;
    cpy_r_r140 = CPyStatics[55]; /* 'TRACE' */
    cpy_r_r141 = CPyDict_GetItem(cpy_r_r139, cpy_r_r140);
    if (unlikely(cpy_r_r141 == NULL)) {
        CPy_AddTraceback("src/charset_normalizer/md.py", "mess_ratio", 629, CPyStatic_globals);
        goto CPyL135;
    }
    if (likely(PyLong_Check(cpy_r_r141)))
        cpy_r_r142 = CPyTagged_FromObject(cpy_r_r141);
    else {
        CPy_TypeError("int", cpy_r_r141); cpy_r_r142 = CPY_INT_TAG;
    }
    CPy_DECREF(cpy_r_r141);
    if (unlikely(cpy_r_r142 == CPY_INT_TAG)) {
        CPy_AddTraceback("src/charset_normalizer/md.py", "mess_ratio", 629, CPyStatic_globals);
        goto CPyL135;
    }
    cpy_r_r143 = CPyStatics[60]; /* 'Starting with: ' */
    cpy_r_r144 = CPyStr_GetSlice(cpy_r_decoded_sequence, 0, 32);
    if (unlikely(cpy_r_r144 == NULL)) {
        CPy_AddTraceback("src/charset_normalizer/md.py", "mess_ratio", 629, CPyStatic_globals);
        goto CPyL136;
    }
    if (likely(PyUnicode_Check(cpy_r_r144)))
        cpy_r_r145 = cpy_r_r144;
    else {
        CPy_TypeErrorTraceback("src/charset_normalizer/md.py", "mess_ratio", 629, CPyStatic_globals, "str", cpy_r_r144);
        goto CPyL136;
    }
    cpy_r_r146 = CPyStr_Build(2, cpy_r_r143, cpy_r_r145);
    CPy_DECREF(cpy_r_r145);
    if (unlikely(cpy_r_r146 == NULL)) {
        CPy_AddTraceback("src/charset_normalizer/md.py", "mess_ratio", 629, CPyStatic_globals);
        goto CPyL136;
    }
    cpy_r_r147 = CPyStatics[59]; /* 'log' */
    cpy_r_r148 = CPyTagged_StealAsObject(cpy_r_r142);
    PyObject *cpy_r_r149[3] = {cpy_r_r116, cpy_r_r148, cpy_r_r146};
    cpy_r_r150 = (PyObject **)&cpy_r_r149;
    cpy_r_r151 = PyObject_VectorcallMethod(cpy_r_r147, cpy_r_r150, 9223372036854775811ULL, 0);
    if (unlikely(cpy_r_r151 == NULL)) {
        CPy_AddTraceback("src/charset_normalizer/md.py", "mess_ratio", 629, CPyStatic_globals);
        goto CPyL137;
    } else
        goto CPyL138;
CPyL85: ;
    CPy_DECREF(cpy_r_r148);
    CPy_DECREF(cpy_r_r146);
    cpy_r_r152 = CPyStatic_globals;
    cpy_r_r153 = CPyStatics[55]; /* 'TRACE' */
    cpy_r_r154 = CPyDict_GetItem(cpy_r_r152, cpy_r_r153);
    if (unlikely(cpy_r_r154 == NULL)) {
        CPy_AddTraceback("src/charset_normalizer/md.py", "mess_ratio", 630, CPyStatic_globals);
        goto CPyL135;
    }
    if (likely(PyLong_Check(cpy_r_r154)))
        cpy_r_r155 = CPyTagged_FromObject(cpy_r_r154);
    else {
        CPy_TypeError("int", cpy_r_r154); cpy_r_r155 = CPY_INT_TAG;
    }
    CPy_DECREF(cpy_r_r154);
    if (unlikely(cpy_r_r155 == CPY_INT_TAG)) {
        CPy_AddTraceback("src/charset_normalizer/md.py", "mess_ratio", 630, CPyStatic_globals);
        goto CPyL135;
    }
    cpy_r_r156 = CPyStatics[61]; /* 'Ending with: ' */
    cpy_r_r157 = CPyStr_GetSlice(cpy_r_decoded_sequence, -32, 9223372036854775806LL);
    if (unlikely(cpy_r_r157 == NULL)) {
        CPy_AddTraceback("src/charset_normalizer/md.py", "mess_ratio", 630, CPyStatic_globals);
        goto CPyL139;
    }
    if (likely(PyUnicode_Check(cpy_r_r157)))
        cpy_r_r158 = cpy_r_r157;
    else {
        CPy_TypeErrorTraceback("src/charset_normalizer/md.py", "mess_ratio", 630, CPyStatic_globals, "str", cpy_r_r157);
        goto CPyL139;
    }
    cpy_r_r159 = CPyStr_Build(2, cpy_r_r156, cpy_r_r158);
    CPy_DECREF(cpy_r_r158);
    if (unlikely(cpy_r_r159 == NULL)) {
        CPy_AddTraceback("src/charset_normalizer/md.py", "mess_ratio", 630, CPyStatic_globals);
        goto CPyL139;
    }
    cpy_r_r160 = CPyStatics[59]; /* 'log' */
    cpy_r_r161 = CPyTagged_StealAsObject(cpy_r_r155);
    PyObject *cpy_r_r162[3] = {cpy_r_r116, cpy_r_r161, cpy_r_r159};
    cpy_r_r163 = (PyObject **)&cpy_r_r162;
    cpy_r_r164 = PyObject_VectorcallMethod(cpy_r_r160, cpy_r_r163, 9223372036854775811ULL, 0);
    if (unlikely(cpy_r_r164 == NULL)) {
        CPy_AddTraceback("src/charset_normalizer/md.py", "mess_ratio", 630, CPyStatic_globals);
        goto CPyL140;
    } else
        goto CPyL141;
CPyL91: ;
    CPy_DECREF(cpy_r_r161);
    CPy_DECREF(cpy_r_r159);
CPyL92: ;
    cpy_r_r165 = 0;
CPyL93: ;
    cpy_r_r166 = (CPyPtr)&((PyVarObject *)cpy_r_r10)->ob_size;
    cpy_r_r167 = *(int64_t *)cpy_r_r166;
    cpy_r_r168 = cpy_r_r165 < cpy_r_r167;
    if (!cpy_r_r168) goto CPyL142;
    cpy_r_r169 = (CPyPtr)&((PyListObject *)cpy_r_r10)->ob_item;
    cpy_r_r170 = *(CPyPtr *)cpy_r_r169;
    cpy_r_r171 = cpy_r_r165 * 8;
    cpy_r_r172 = cpy_r_r170 + cpy_r_r171;
    cpy_r_r173 = *(PyObject * *)cpy_r_r172;
    CPy_INCREF(cpy_r_r173);
    if (likely(PyObject_TypeCheck(cpy_r_r173, CPyType_MessDetectorPlugin)))
        cpy_r_r174 = cpy_r_r173;
    else {
        CPy_TypeErrorTraceback("src/charset_normalizer/md.py", "mess_ratio", 632, CPyStatic_globals, "charset_normalizer.md.MessDetectorPlugin", cpy_r_r173);
        goto CPyL135;
    }
    cpy_r_r175 = CPyStatic_globals;
    cpy_r_r176 = CPyStatics[55]; /* 'TRACE' */
    cpy_r_r177 = CPyDict_GetItem(cpy_r_r175, cpy_r_r176);
    if (unlikely(cpy_r_r177 == NULL)) {
        CPy_AddTraceback("src/charset_normalizer/md.py", "mess_ratio", 633, CPyStatic_globals);
        goto CPyL143;
    }
    if (likely(PyLong_Check(cpy_r_r177)))
        cpy_r_r178 = CPyTagged_FromObject(cpy_r_r177);
    else {
        CPy_TypeError("int", cpy_r_r177); cpy_r_r178 = CPY_INT_TAG;
    }
    CPy_DECREF(cpy_r_r177);
    if (unlikely(cpy_r_r178 == CPY_INT_TAG)) {
        CPy_AddTraceback("src/charset_normalizer/md.py", "mess_ratio", 633, CPyStatic_globals);
        goto CPyL143;
    }
    cpy_r_r179 = CPy_TYPE(cpy_r_r174);
    cpy_r_r180 = PyObject_Str(cpy_r_r179);
    CPy_DECREF(cpy_r_r179);
    if (unlikely(cpy_r_r180 == NULL)) {
        CPy_AddTraceback("src/charset_normalizer/md.py", "mess_ratio", 633, CPyStatic_globals);
        goto CPyL144;
    }
    cpy_r_r181 = CPyStatics[62]; /* ': ' */
    cpy_r_r182 = CPY_GET_ATTR(cpy_r_r174, CPyType_MessDetectorPlugin, 3, charset_normalizer___md___MessDetectorPluginObject, double); /* ratio */
    CPy_DECREF_NO_IMM(cpy_r_r174);
    cpy_r_r183 = cpy_r_r182 == -113.0;
    if (unlikely(cpy_r_r183)) goto CPyL100;
CPyL99: ;
    cpy_r_r184 = PyFloat_FromDouble(cpy_r_r182);
    cpy_r_r185 = PyObject_Str(cpy_r_r184);
    CPy_DECREF(cpy_r_r184);
    if (unlikely(cpy_r_r185 == NULL)) {
        CPy_AddTraceback("src/charset_normalizer/md.py", "mess_ratio", 633, CPyStatic_globals);
        goto CPyL145;
    } else
        goto CPyL101;
CPyL100: ;
    cpy_r_r186 = PyErr_Occurred();
    if (unlikely(cpy_r_r186 != NULL)) {
        CPy_AddTraceback("src/charset_normalizer/md.py", "mess_ratio", 633, CPyStatic_globals);
        goto CPyL145;
    } else
        goto CPyL99;
CPyL101: ;
    cpy_r_r187 = CPyStr_Build(3, cpy_r_r180, cpy_r_r181, cpy_r_r185);
    CPy_DECREF(cpy_r_r180);
    CPy_DECREF(cpy_r_r185);
    if (unlikely(cpy_r_r187 == NULL)) {
        CPy_AddTraceback("src/charset_normalizer/md.py", "mess_ratio", 633, CPyStatic_globals);
        goto CPyL146;
    }
    cpy_r_r188 = CPyStatics[59]; /* 'log' */
    cpy_r_r189 = CPyTagged_StealAsObject(cpy_r_r178);
    PyObject *cpy_r_r190[3] = {cpy_r_r116, cpy_r_r189, cpy_r_r187};
    cpy_r_r191 = (PyObject **)&cpy_r_r190;
    cpy_r_r192 = PyObject_VectorcallMethod(cpy_r_r188, cpy_r_r191, 9223372036854775811ULL, 0);
    if (unlikely(cpy_r_r192 == NULL)) {
        CPy_AddTraceback("src/charset_normalizer/md.py", "mess_ratio", 633, CPyStatic_globals);
        goto CPyL147;
    } else
        goto CPyL148;
CPyL103: ;
    CPy_DECREF(cpy_r_r189);
    CPy_DECREF(cpy_r_r187);
    cpy_r_r193 = cpy_r_r165 + 1;
    cpy_r_r165 = cpy_r_r193;
    goto CPyL93;
CPyL105: ;
    cpy_r_r194 = CPyModule_builtins;
    cpy_r_r195 = CPyStatics[63]; /* 'round' */
    cpy_r_r196 = CPyObject_GetAttr(cpy_r_r194, cpy_r_r195);
    if (unlikely(cpy_r_r196 == NULL)) {
        CPy_AddTraceback("src/charset_normalizer/md.py", "mess_ratio", 635, CPyStatic_globals);
        goto CPyL110;
    }
    cpy_r_r197 = PyFloat_FromDouble(cpy_r_mean_mess_ratio);
    cpy_r_r198 = CPyStatics[115]; /* 3 */
    PyObject *cpy_r_r199[2] = {cpy_r_r197, cpy_r_r198};
    cpy_r_r200 = (PyObject **)&cpy_r_r199;
    cpy_r_r201 = PyObject_Vectorcall(cpy_r_r196, cpy_r_r200, 2, 0);
    CPy_DECREF(cpy_r_r196);
    if (unlikely(cpy_r_r201 == NULL)) {
        CPy_AddTraceback("src/charset_normalizer/md.py", "mess_ratio", 635, CPyStatic_globals);
        goto CPyL149;
    }
    CPy_DECREF(cpy_r_r197);
    cpy_r_r202 = PyFloat_AsDouble(cpy_r_r201);
    if (cpy_r_r202 == -1.0 && PyErr_Occurred()) {
        CPy_TypeError("float", cpy_r_r201); cpy_r_r202 = -113.0;
    }
    CPy_DECREF(cpy_r_r201);
    cpy_r_r203 = cpy_r_r202 == -113.0;
    if (unlikely(cpy_r_r203)) goto CPyL109;
CPyL108: ;
    return cpy_r_r202;
CPyL109: ;
    cpy_r_r204 = PyErr_Occurred();
    if (unlikely(cpy_r_r204 != NULL)) {
        CPy_AddTraceback("src/charset_normalizer/md.py", "mess_ratio", 635, CPyStatic_globals);
    } else
        goto CPyL108;
CPyL110: ;
    cpy_r_r205 = -113.0;
    return cpy_r_r205;
CPyL111: ;
    CPy_DecRef(cpy_r_r7);
    goto CPyL110;
CPyL112: ;
    CPy_DECREF_NO_IMM(cpy_r_r7);
    goto CPyL13;
CPyL113: ;
    CPy_DecRef(cpy_r_r7);
    CPy_DecRef(cpy_r_r10);
    goto CPyL110;
CPyL114: ;
    CPy_DecRef(cpy_r_r10);
    goto CPyL110;
CPyL115: ;
    CPy_DecRef(cpy_r_r10);
    CPyTagged_DecRef(cpy_r_r26);
    CPyTagged_DecRef(cpy_r_intermediary_mean_mess_ratio_calc);
    goto CPyL110;
CPyL116: ;
    CPy_DecRef(cpy_r_r10);
    CPyTagged_DecRef(cpy_r_r26);
    CPyTagged_DecRef(cpy_r_intermediary_mean_mess_ratio_calc);
    CPy_DecRef(cpy_r_r41);
    goto CPyL110;
CPyL117: ;
    CPyTagged_DECREF(cpy_r_r26);
    CPy_DECREF(cpy_r_r41);
    CPyTagged_DECREF(cpy_r_r45);
    CPyTagged_DECREF(cpy_r_index);
    goto CPyL67;
CPyL118: ;
    CPy_DecRef(cpy_r_r10);
    CPyTagged_DecRef(cpy_r_r26);
    CPyTagged_DecRef(cpy_r_intermediary_mean_mess_ratio_calc);
    CPy_DecRef(cpy_r_r41);
    CPyTagged_DecRef(cpy_r_r45);
    CPyTagged_DecRef(cpy_r_index);
    goto CPyL110;
CPyL119: ;
    CPy_DECREF(cpy_r_r53);
    goto CPyL41;
CPyL120: ;
    CPy_DecRef(cpy_r_r10);
    CPyTagged_DecRef(cpy_r_r26);
    CPyTagged_DecRef(cpy_r_intermediary_mean_mess_ratio_calc);
    CPy_DecRef(cpy_r_r41);
    CPyTagged_DecRef(cpy_r_r45);
    CPyTagged_DecRef(cpy_r_index);
    CPy_DecRef(cpy_r_r53);
    goto CPyL110;
CPyL121: ;
    CPy_DecRef(cpy_r_r10);
    CPyTagged_DecRef(cpy_r_r26);
    CPyTagged_DecRef(cpy_r_intermediary_mean_mess_ratio_calc);
    CPy_DecRef(cpy_r_r41);
    CPyTagged_DecRef(cpy_r_r45);
    CPyTagged_DecRef(cpy_r_index);
    CPy_DecRef(cpy_r_r53);
    CPy_DecRef(cpy_r_r63);
    goto CPyL110;
CPyL122: ;
    CPy_DECREF_NO_IMM(cpy_r_r63);
    goto CPyL40;
CPyL123: ;
    CPyTagged_DECREF(cpy_r_index);
    goto CPyL51;
CPyL124: ;
    CPy_DecRef(cpy_r_r10);
    CPyTagged_DecRef(cpy_r_r26);
    CPyTagged_DecRef(cpy_r_intermediary_mean_mess_ratio_calc);
    CPy_DecRef(cpy_r_r41);
    CPyTagged_DecRef(cpy_r_r45);
    goto CPyL110;
CPyL125: ;
    CPy_DecRef(cpy_r_r10);
    CPyTagged_DecRef(cpy_r_r26);
    CPyTagged_DecRef(cpy_r_intermediary_mean_mess_ratio_calc);
    CPy_DecRef(cpy_r_r41);
    CPyTagged_DecRef(cpy_r_r45);
    CPy_DecRef(cpy_r_r83);
    goto CPyL110;
CPyL126: ;
    CPyTagged_DECREF(cpy_r_r26);
    CPy_DECREF(cpy_r_r41);
    CPyTagged_DECREF(cpy_r_r45);
    goto CPyL67;
CPyL127: ;
    CPy_DECREF_NO_IMM(cpy_r_r10);
    CPyTagged_DECREF(cpy_r_intermediary_mean_mess_ratio_calc);
    goto CPyL105;
CPyL128: ;
    CPy_DecRef(cpy_r_r10);
    CPyTagged_DecRef(cpy_r_intermediary_mean_mess_ratio_calc);
    goto CPyL110;
CPyL129: ;
    CPy_DecRef(cpy_r_r10);
    CPyTagged_DecRef(cpy_r_intermediary_mean_mess_ratio_calc);
    CPy_DecRef(cpy_r_r116);
    goto CPyL110;
CPyL130: ;
    CPy_DecRef(cpy_r_r10);
    CPy_DecRef(cpy_r_r116);
    CPyTagged_DecRef(cpy_r_r120);
    goto CPyL110;
CPyL131: ;
    CPy_DecRef(cpy_r_r10);
    CPy_DecRef(cpy_r_r116);
    CPyTagged_DecRef(cpy_r_r120);
    CPy_DecRef(cpy_r_r122);
    goto CPyL110;
CPyL132: ;
    CPy_DecRef(cpy_r_r10);
    CPy_DecRef(cpy_r_r116);
    CPyTagged_DecRef(cpy_r_r120);
    CPy_DecRef(cpy_r_r122);
    CPy_DecRef(cpy_r_r125);
    goto CPyL110;
CPyL133: ;
    CPy_DecRef(cpy_r_r10);
    CPy_DecRef(cpy_r_r116);
    CPy_DecRef(cpy_r_r129);
    CPy_DecRef(cpy_r_r131);
    goto CPyL110;
CPyL134: ;
    CPy_DECREF(cpy_r_r134);
    goto CPyL77;
CPyL135: ;
    CPy_DecRef(cpy_r_r10);
    CPy_DecRef(cpy_r_r116);
    goto CPyL110;
CPyL136: ;
    CPy_DecRef(cpy_r_r10);
    CPy_DecRef(cpy_r_r116);
    CPyTagged_DecRef(cpy_r_r142);
    goto CPyL110;
CPyL137: ;
    CPy_DecRef(cpy_r_r10);
    CPy_DecRef(cpy_r_r116);
    CPy_DecRef(cpy_r_r146);
    CPy_DecRef(cpy_r_r148);
    goto CPyL110;
CPyL138: ;
    CPy_DECREF(cpy_r_r151);
    goto CPyL85;
CPyL139: ;
    CPy_DecRef(cpy_r_r10);
    CPy_DecRef(cpy_r_r116);
    CPyTagged_DecRef(cpy_r_r155);
    goto CPyL110;
CPyL140: ;
    CPy_DecRef(cpy_r_r10);
    CPy_DecRef(cpy_r_r116);
    CPy_DecRef(cpy_r_r159);
    CPy_DecRef(cpy_r_r161);
    goto CPyL110;
CPyL141: ;
    CPy_DECREF(cpy_r_r164);
    goto CPyL91;
CPyL142: ;
    CPy_DECREF_NO_IMM(cpy_r_r10);
    CPy_DECREF(cpy_r_r116);
    goto CPyL105;
CPyL143: ;
    CPy_DecRef(cpy_r_r10);
    CPy_DecRef(cpy_r_r116);
    CPy_DecRef(cpy_r_r174);
    goto CPyL110;
CPyL144: ;
    CPy_DecRef(cpy_r_r10);
    CPy_DecRef(cpy_r_r116);
    CPy_DecRef(cpy_r_r174);
    CPyTagged_DecRef(cpy_r_r178);
    goto CPyL110;
CPyL145: ;
    CPy_DecRef(cpy_r_r10);
    CPy_DecRef(cpy_r_r116);
    CPyTagged_DecRef(cpy_r_r178);
    CPy_DecRef(cpy_r_r180);
    goto CPyL110;
CPyL146: ;
    CPy_DecRef(cpy_r_r10);
    CPy_DecRef(cpy_r_r116);
    CPyTagged_DecRef(cpy_r_r178);
    goto CPyL110;
CPyL147: ;
    CPy_DecRef(cpy_r_r10);
    CPy_DecRef(cpy_r_r116);
    CPy_DecRef(cpy_r_r187);
    CPy_DecRef(cpy_r_r189);
    goto CPyL110;
CPyL148: ;
    CPy_DECREF(cpy_r_r192);
    goto CPyL103;
CPyL149: ;
    CPy_DecRef(cpy_r_r197);
    goto CPyL110;
}

PyObject *CPyPy_mess_ratio(PyObject *self, PyObject *const *args, size_t nargs, PyObject *kwnames) {
    static const char * const kwlist[] = {"decoded_sequence", "maximum_threshold", "debug", 0};
    static CPyArg_Parser parser = {"O|OO:mess_ratio", kwlist, 0};
    PyObject *obj_decoded_sequence;
    PyObject *obj_maximum_threshold = NULL;
    PyObject *obj_debug = NULL;
    if (!CPyArg_ParseStackAndKeywordsSimple(args, nargs, kwnames, &parser, &obj_decoded_sequence, &obj_maximum_threshold, &obj_debug)) {
        return NULL;
    }
    uint32_t __bitmap = 0;
    PyObject *arg_decoded_sequence;
    if (likely(PyUnicode_Check(obj_decoded_sequence)))
        arg_decoded_sequence = obj_decoded_sequence;
    else {
        CPy_TypeError("str", obj_decoded_sequence); 
        goto fail;
    }
    double arg_maximum_threshold = -113.0;
    if (obj_maximum_threshold != NULL) {
        __bitmap |= 1 << 0;
        arg_maximum_threshold = PyFloat_AsDouble(obj_maximum_threshold);
        if (arg_maximum_threshold == -1.0 && PyErr_Occurred()) {
            CPy_TypeError("float", obj_maximum_threshold); goto fail;
        }
    }
    char arg_debug;
    if (obj_debug == NULL) {
        arg_debug = 2;
    } else if (unlikely(!PyBool_Check(obj_debug))) {
        CPy_TypeError("bool", obj_debug); goto fail;
    } else
        arg_debug = obj_debug == Py_True;
    double retval = CPyDef_mess_ratio(arg_decoded_sequence, arg_maximum_threshold, arg_debug, __bitmap);
    if (retval == -113.0 && PyErr_Occurred()) {
        return NULL;
    }
    PyObject *retbox = PyFloat_FromDouble(retval);
    return retbox;
fail: ;
    CPy_AddTraceback("src/charset_normalizer/md.py", "mess_ratio", 583, CPyStatic_globals);
    return NULL;
}

char CPyDef___top_level__(void) {
    PyObject *cpy_r_r0;
    PyObject *cpy_r_r1;
    char cpy_r_r2;
    PyObject *cpy_r_r3;
    PyObject *cpy_r_r4;
    PyObject *cpy_r_r5;
    PyObject *cpy_r_r6;
    PyObject *cpy_r_r7;
    PyObject *cpy_r_r8;
    PyObject *cpy_r_r9;
    PyObject *cpy_r_r10;
    PyObject *cpy_r_r11;
    PyObject *cpy_r_r12;
    PyObject *cpy_r_r13;
    PyObject *cpy_r_r14;
    PyObject *cpy_r_r15;
    PyObject *cpy_r_r16;
    PyObject *cpy_r_r17;
    PyObject *cpy_r_r18;
    PyObject *cpy_r_r19;
    PyObject *cpy_r_r20;
    PyObject *cpy_r_r21;
    PyObject *cpy_r_r22;
    PyObject *cpy_r_r23;
    PyObject *cpy_r_r24;
    PyObject *cpy_r_r25;
    PyObject *cpy_r_r26;
    PyObject *cpy_r_r27;
    PyObject *cpy_r_r28;
    char cpy_r_r29;
    PyObject *cpy_r_r30;
    PyObject *cpy_r_r31;
    int32_t cpy_r_r32;
    char cpy_r_r33;
    PyObject *cpy_r_r34;
    PyObject *cpy_r_r35;
    int32_t cpy_r_r36;
    char cpy_r_r37;
    PyObject *cpy_r_r38;
    PyObject *cpy_r_r39;
    PyObject *cpy_r_r40;
    PyObject *cpy_r_r41;
    PyObject *cpy_r_r42;
    char cpy_r_r43;
    PyObject *cpy_r_r44;
    PyObject *cpy_r_r45;
    PyObject *cpy_r_r46;
    PyObject *cpy_r_r47;
    PyObject *cpy_r_r48;
    PyObject *cpy_r_r49;
    PyObject *cpy_r_r50;
    int32_t cpy_r_r51;
    char cpy_r_r52;
    PyObject *cpy_r_r53;
    PyObject *cpy_r_r54;
    int32_t cpy_r_r55;
    char cpy_r_r56;
    PyObject *cpy_r_r57;
    PyObject *cpy_r_r58;
    PyObject *cpy_r_r59;
    PyObject *cpy_r_r60;
    PyObject *cpy_r_r61;
    char cpy_r_r62;
    PyObject *cpy_r_r63;
    PyObject *cpy_r_r64;
    PyObject *cpy_r_r65;
    PyObject *cpy_r_r66;
    int32_t cpy_r_r67;
    char cpy_r_r68;
    PyObject *cpy_r_r69;
    PyObject *cpy_r_r70;
    int32_t cpy_r_r71;
    char cpy_r_r72;
    PyObject *cpy_r_r73;
    PyObject *cpy_r_r74;
    PyObject *cpy_r_r75;
    PyObject *cpy_r_r76;
    PyObject *cpy_r_r77;
    char cpy_r_r78;
    PyObject *cpy_r_r79;
    PyObject *cpy_r_r80;
    PyObject *cpy_r_r81;
    PyObject *cpy_r_r82;
    int32_t cpy_r_r83;
    char cpy_r_r84;
    PyObject *cpy_r_r85;
    PyObject *cpy_r_r86;
    int32_t cpy_r_r87;
    char cpy_r_r88;
    PyObject *cpy_r_r89;
    PyObject *cpy_r_r90;
    PyObject *cpy_r_r91;
    PyObject *cpy_r_r92;
    PyObject *cpy_r_r93;
    char cpy_r_r94;
    PyObject *cpy_r_r95;
    PyObject *cpy_r_r96;
    PyObject *cpy_r_r97;
    PyObject *cpy_r_r98;
    PyObject *cpy_r_r99;
    int32_t cpy_r_r100;
    char cpy_r_r101;
    PyObject *cpy_r_r102;
    PyObject *cpy_r_r103;
    int32_t cpy_r_r104;
    char cpy_r_r105;
    PyObject *cpy_r_r106;
    PyObject *cpy_r_r107;
    PyObject *cpy_r_r108;
    PyObject *cpy_r_r109;
    PyObject *cpy_r_r110;
    char cpy_r_r111;
    PyObject *cpy_r_r112;
    PyObject *cpy_r_r113;
    PyObject *cpy_r_r114;
    PyObject *cpy_r_r115;
    PyObject *cpy_r_r116;
    int32_t cpy_r_r117;
    char cpy_r_r118;
    PyObject *cpy_r_r119;
    PyObject *cpy_r_r120;
    int32_t cpy_r_r121;
    char cpy_r_r122;
    PyObject *cpy_r_r123;
    PyObject *cpy_r_r124;
    PyObject *cpy_r_r125;
    PyObject *cpy_r_r126;
    PyObject *cpy_r_r127;
    char cpy_r_r128;
    PyObject *cpy_r_r129;
    PyObject *cpy_r_r130;
    PyObject *cpy_r_r131;
    PyObject *cpy_r_r132;
    PyObject *cpy_r_r133;
    PyObject *cpy_r_r134;
    PyObject *cpy_r_r135;
    PyObject *cpy_r_r136;
    PyObject *cpy_r_r137;
    PyObject *cpy_r_r138;
    PyObject *cpy_r_r139;
    PyObject *cpy_r_r140;
    int32_t cpy_r_r141;
    char cpy_r_r142;
    PyObject *cpy_r_r143;
    PyObject *cpy_r_r144;
    int32_t cpy_r_r145;
    char cpy_r_r146;
    PyObject *cpy_r_r147;
    PyObject *cpy_r_r148;
    PyObject *cpy_r_r149;
    PyObject *cpy_r_r150;
    PyObject *cpy_r_r151;
    char cpy_r_r152;
    PyObject *cpy_r_r153;
    PyObject *cpy_r_r154;
    PyObject *cpy_r_r155;
    PyObject *cpy_r_r156;
    int32_t cpy_r_r157;
    char cpy_r_r158;
    PyObject *cpy_r_r159;
    PyObject *cpy_r_r160;
    int32_t cpy_r_r161;
    char cpy_r_r162;
    PyObject *cpy_r_r163;
    PyObject *cpy_r_r164;
    PyObject *cpy_r_r165;
    PyObject *cpy_r_r166;
    PyObject *cpy_r_r167;
    char cpy_r_r168;
    PyObject *cpy_r_r169;
    PyObject *cpy_r_r170;
    PyObject *cpy_r_r171;
    PyObject *cpy_r_r172;
    PyObject *cpy_r_r173;
    PyObject *cpy_r_r174;
    PyObject *cpy_r_r175;
    PyObject *cpy_r_r176;
    PyObject *cpy_r_r177;
    int32_t cpy_r_r178;
    char cpy_r_r179;
    PyObject *cpy_r_r180;
    PyObject *cpy_r_r181;
    int32_t cpy_r_r182;
    char cpy_r_r183;
    PyObject *cpy_r_r184;
    PyObject *cpy_r_r185;
    PyObject *cpy_r_r186;
    PyObject *cpy_r_r187;
    PyObject *cpy_r_r188;
    char cpy_r_r189;
    PyObject *cpy_r_r190;
    PyObject *cpy_r_r191;
    PyObject *cpy_r_r192;
    PyObject *cpy_r_r193;
    int32_t cpy_r_r194;
    char cpy_r_r195;
    PyObject *cpy_r_r196;
    PyObject *cpy_r_r197;
    int32_t cpy_r_r198;
    char cpy_r_r199;
    PyObject *cpy_r_r200;
    PyObject *cpy_r_r201;
    PyObject *cpy_r_r202;
    PyObject *cpy_r_r203;
    PyObject *cpy_r_r204;
    PyObject *cpy_r_r205;
    PyObject *cpy_r_r206;
    PyObject **cpy_r_r208;
    PyObject *cpy_r_r209;
    PyObject *cpy_r_r210;
    PyObject **cpy_r_r212;
    PyObject *cpy_r_r213;
    PyObject *cpy_r_r214;
    PyObject *cpy_r_r215;
    int32_t cpy_r_r216;
    char cpy_r_r217;
    PyObject *cpy_r_r218;
    PyObject *cpy_r_r219;
    PyObject *cpy_r_r220;
    PyObject *cpy_r_r221;
    PyObject *cpy_r_r222;
    PyObject *cpy_r_r223;
    PyObject *cpy_r_r224;
    PyObject **cpy_r_r226;
    PyObject *cpy_r_r227;
    PyObject *cpy_r_r228;
    PyObject **cpy_r_r230;
    PyObject *cpy_r_r231;
    PyObject *cpy_r_r232;
    PyObject *cpy_r_r233;
    int32_t cpy_r_r234;
    char cpy_r_r235;
    char cpy_r_r236;
    cpy_r_r0 = CPyModule_builtins;
    cpy_r_r1 = (PyObject *)&_Py_NoneStruct;
    cpy_r_r2 = cpy_r_r0 != cpy_r_r1;
    if (cpy_r_r2) goto CPyL3;
    cpy_r_r3 = CPyStatics[64]; /* 'builtins' */
    cpy_r_r4 = PyImport_Import(cpy_r_r3);
    if (unlikely(cpy_r_r4 == NULL)) {
        CPy_AddTraceback("src/charset_normalizer/md.py", "<module>", -1, CPyStatic_globals);
        goto CPyL77;
    }
    CPyModule_builtins = cpy_r_r4;
    CPy_INCREF(CPyModule_builtins);
    CPy_DECREF(cpy_r_r4);
CPyL3: ;
    cpy_r_r5 = CPyStatics[118]; /* ('annotations',) */
    cpy_r_r6 = CPyStatics[66]; /* '__future__' */
    cpy_r_r7 = CPyStatic_globals;
    cpy_r_r8 = CPyImport_ImportFromMany(cpy_r_r6, cpy_r_r5, cpy_r_r5, cpy_r_r7);
    if (unlikely(cpy_r_r8 == NULL)) {
        CPy_AddTraceback("src/charset_normalizer/md.py", "<module>", 1, CPyStatic_globals);
        goto CPyL77;
    }
    CPyModule___future__ = cpy_r_r8;
    CPy_INCREF(CPyModule___future__);
    CPy_DECREF(cpy_r_r8);
    cpy_r_r9 = CPyStatics[119]; /* ('lru_cache',) */
    cpy_r_r10 = CPyStatics[68]; /* 'functools' */
    cpy_r_r11 = CPyStatic_globals;
    cpy_r_r12 = CPyImport_ImportFromMany(cpy_r_r10, cpy_r_r9, cpy_r_r9, cpy_r_r11);
    if (unlikely(cpy_r_r12 == NULL)) {
        CPy_AddTraceback("src/charset_normalizer/md.py", "<module>", 3, CPyStatic_globals);
        goto CPyL77;
    }
    CPyModule_functools = cpy_r_r12;
    CPy_INCREF(CPyModule_functools);
    CPy_DECREF(cpy_r_r12);
    cpy_r_r13 = CPyStatics[120]; /* ('getLogger',) */
    cpy_r_r14 = CPyStatics[69]; /* 'logging' */
    cpy_r_r15 = CPyStatic_globals;
    cpy_r_r16 = CPyImport_ImportFromMany(cpy_r_r14, cpy_r_r13, cpy_r_r13, cpy_r_r15);
    if (unlikely(cpy_r_r16 == NULL)) {
        CPy_AddTraceback("src/charset_normalizer/md.py", "<module>", 4, CPyStatic_globals);
        goto CPyL77;
    }
    CPyModule_logging = cpy_r_r16;
    CPy_INCREF(CPyModule_logging);
    CPy_DECREF(cpy_r_r16);
    cpy_r_r17 = CPyStatics[121]; /* ('COMMON_SAFE_ASCII_CHARACTERS', 'TRACE',
                                    'UNICODE_SECONDARY_RANGE_KEYWORD') */
    cpy_r_r18 = CPyStatics[70]; /* 'charset_normalizer.constant' */
    cpy_r_r19 = CPyStatic_globals;
    cpy_r_r20 = CPyImport_ImportFromMany(cpy_r_r18, cpy_r_r17, cpy_r_r17, cpy_r_r19);
    if (unlikely(cpy_r_r20 == NULL)) {
        CPy_AddTraceback("src/charset_normalizer/md.py", "<module>", 6, CPyStatic_globals);
        goto CPyL77;
    }
    CPyModule_charset_normalizer___constant = cpy_r_r20;
    CPy_INCREF(CPyModule_charset_normalizer___constant);
    CPy_DECREF(cpy_r_r20);
    cpy_r_r21 = CPyStatics[122]; /* ('is_accentuated', 'is_arabic', 'is_arabic_isolated_form',
                                    'is_case_variable', 'is_cjk', 'is_emoticon', 'is_hangul',
                                    'is_hiragana', 'is_katakana', 'is_latin',
                                    'is_punctuation', 'is_separator', 'is_symbol', 'is_thai',
                                    'is_unprintable', 'remove_accent', 'unicode_range',
                                    'is_cjk_uncommon') */
    cpy_r_r22 = CPyStatics[71]; /* 'charset_normalizer.utils' */
    cpy_r_r23 = CPyStatic_globals;
    cpy_r_r24 = CPyImport_ImportFromMany(cpy_r_r22, cpy_r_r21, cpy_r_r21, cpy_r_r23);
    if (unlikely(cpy_r_r24 == NULL)) {
        CPy_AddTraceback("src/charset_normalizer/md.py", "<module>", 11, CPyStatic_globals);
        goto CPyL77;
    }
    CPyModule_charset_normalizer___utils = cpy_r_r24;
    CPy_INCREF(CPyModule_charset_normalizer___utils);
    CPy_DECREF(cpy_r_r24);
    cpy_r_r25 = NULL;
    cpy_r_r26 = CPyStatics[72]; /* 'charset_normalizer.md' */
    cpy_r_r27 = (PyObject *)CPyType_MessDetectorPlugin_template;
    cpy_r_r28 = CPyType_FromTemplate(cpy_r_r27, cpy_r_r25, cpy_r_r26);
    if (unlikely(cpy_r_r28 == NULL)) {
        CPy_AddTraceback("src/charset_normalizer/md.py", "<module>", 33, CPyStatic_globals);
        goto CPyL77;
    }
    cpy_r_r29 = CPyDef_MessDetectorPlugin_trait_vtable_setup();
    if (unlikely(cpy_r_r29 == 2)) {
        CPy_AddTraceback("src/charset_normalizer/md.py", "<module>", -1, CPyStatic_globals);
        goto CPyL78;
    }
    cpy_r_r30 = CPyStatics[73]; /* '__mypyc_attrs__' */
    cpy_r_r31 = CPyTuple_LoadEmptyTupleConstant();
    cpy_r_r32 = PyObject_SetAttr(cpy_r_r28, cpy_r_r30, cpy_r_r31);
    CPy_DECREF(cpy_r_r31);
    cpy_r_r33 = cpy_r_r32 >= 0;
    if (unlikely(!cpy_r_r33)) {
        CPy_AddTraceback("src/charset_normalizer/md.py", "<module>", 33, CPyStatic_globals);
        goto CPyL78;
    }
    CPyType_MessDetectorPlugin = (PyTypeObject *)cpy_r_r28;
    CPy_INCREF(CPyType_MessDetectorPlugin);
    cpy_r_r34 = CPyStatic_globals;
    cpy_r_r35 = CPyStatics[74]; /* 'MessDetectorPlugin' */
    cpy_r_r36 = PyDict_SetItem(cpy_r_r34, cpy_r_r35, cpy_r_r28);
    CPy_DECREF(cpy_r_r28);
    cpy_r_r37 = cpy_r_r36 >= 0;
    if (unlikely(!cpy_r_r37)) {
        CPy_AddTraceback("src/charset_normalizer/md.py", "<module>", 33, CPyStatic_globals);
        goto CPyL77;
    }
    cpy_r_r38 = (PyObject *)CPyType_MessDetectorPlugin;
    cpy_r_r39 = PyTuple_Pack(1, cpy_r_r38);
    if (unlikely(cpy_r_r39 == NULL)) {
        CPy_AddTraceback("src/charset_normalizer/md.py", "<module>", 67, CPyStatic_globals);
        goto CPyL77;
    }
    cpy_r_r40 = CPyStatics[72]; /* 'charset_normalizer.md' */
    cpy_r_r41 = (PyObject *)CPyType_TooManySymbolOrPunctuationPlugin_template;
    cpy_r_r42 = CPyType_FromTemplate(cpy_r_r41, cpy_r_r39, cpy_r_r40);
    CPy_DECREF(cpy_r_r39);
    if (unlikely(cpy_r_r42 == NULL)) {
        CPy_AddTraceback("src/charset_normalizer/md.py", "<module>", 67, CPyStatic_globals);
        goto CPyL77;
    }
    cpy_r_r43 = CPyDef_TooManySymbolOrPunctuationPlugin_trait_vtable_setup();
    if (unlikely(cpy_r_r43 == 2)) {
        CPy_AddTraceback("src/charset_normalizer/md.py", "<module>", -1, CPyStatic_globals);
        goto CPyL79;
    }
    cpy_r_r44 = CPyStatics[73]; /* '__mypyc_attrs__' */
    cpy_r_r45 = CPyStatics[75]; /* '_punctuation_count' */
    cpy_r_r46 = CPyStatics[76]; /* '_symbol_count' */
    cpy_r_r47 = CPyStatics[77]; /* '_character_count' */
    cpy_r_r48 = CPyStatics[78]; /* '_last_printable_char' */
    cpy_r_r49 = CPyStatics[79]; /* '_frenzy_symbol_in_word' */
    cpy_r_r50 = PyTuple_Pack(5, cpy_r_r45, cpy_r_r46, cpy_r_r47, cpy_r_r48, cpy_r_r49);
    if (unlikely(cpy_r_r50 == NULL)) {
        CPy_AddTraceback("src/charset_normalizer/md.py", "<module>", 67, CPyStatic_globals);
        goto CPyL79;
    }
    cpy_r_r51 = PyObject_SetAttr(cpy_r_r42, cpy_r_r44, cpy_r_r50);
    CPy_DECREF(cpy_r_r50);
    cpy_r_r52 = cpy_r_r51 >= 0;
    if (unlikely(!cpy_r_r52)) {
        CPy_AddTraceback("src/charset_normalizer/md.py", "<module>", 67, CPyStatic_globals);
        goto CPyL79;
    }
    CPyType_TooManySymbolOrPunctuationPlugin = (PyTypeObject *)cpy_r_r42;
    CPy_INCREF(CPyType_TooManySymbolOrPunctuationPlugin);
    cpy_r_r53 = CPyStatic_globals;
    cpy_r_r54 = CPyStatics[80]; /* 'TooManySymbolOrPunctuationPlugin' */
    cpy_r_r55 = PyDict_SetItem(cpy_r_r53, cpy_r_r54, cpy_r_r42);
    CPy_DECREF(cpy_r_r42);
    cpy_r_r56 = cpy_r_r55 >= 0;
    if (unlikely(!cpy_r_r56)) {
        CPy_AddTraceback("src/charset_normalizer/md.py", "<module>", 67, CPyStatic_globals);
        goto CPyL77;
    }
    cpy_r_r57 = (PyObject *)CPyType_MessDetectorPlugin;
    cpy_r_r58 = PyTuple_Pack(1, cpy_r_r57);
    if (unlikely(cpy_r_r58 == NULL)) {
        CPy_AddTraceback("src/charset_normalizer/md.py", "<module>", 114, CPyStatic_globals);
        goto CPyL77;
    }
    cpy_r_r59 = CPyStatics[72]; /* 'charset_normalizer.md' */
    cpy_r_r60 = (PyObject *)CPyType_TooManyAccentuatedPlugin_template;
    cpy_r_r61 = CPyType_FromTemplate(cpy_r_r60, cpy_r_r58, cpy_r_r59);
    CPy_DECREF(cpy_r_r58);
    if (unlikely(cpy_r_r61 == NULL)) {
        CPy_AddTraceback("src/charset_normalizer/md.py", "<module>", 114, CPyStatic_globals);
        goto CPyL77;
    }
    cpy_r_r62 = CPyDef_TooManyAccentuatedPlugin_trait_vtable_setup();
    if (unlikely(cpy_r_r62 == 2)) {
        CPy_AddTraceback("src/charset_normalizer/md.py", "<module>", -1, CPyStatic_globals);
        goto CPyL80;
    }
    cpy_r_r63 = CPyStatics[73]; /* '__mypyc_attrs__' */
    cpy_r_r64 = CPyStatics[77]; /* '_character_count' */
    cpy_r_r65 = CPyStatics[81]; /* '_accentuated_count' */
    cpy_r_r66 = PyTuple_Pack(2, cpy_r_r64, cpy_r_r65);
    if (unlikely(cpy_r_r66 == NULL)) {
        CPy_AddTraceback("src/charset_normalizer/md.py", "<module>", 114, CPyStatic_globals);
        goto CPyL80;
    }
    cpy_r_r67 = PyObject_SetAttr(cpy_r_r61, cpy_r_r63, cpy_r_r66);
    CPy_DECREF(cpy_r_r66);
    cpy_r_r68 = cpy_r_r67 >= 0;
    if (unlikely(!cpy_r_r68)) {
        CPy_AddTraceback("src/charset_normalizer/md.py", "<module>", 114, CPyStatic_globals);
        goto CPyL80;
    }
    CPyType_TooManyAccentuatedPlugin = (PyTypeObject *)cpy_r_r61;
    CPy_INCREF(CPyType_TooManyAccentuatedPlugin);
    cpy_r_r69 = CPyStatic_globals;
    cpy_r_r70 = CPyStatics[82]; /* 'TooManyAccentuatedPlugin' */
    cpy_r_r71 = PyDict_SetItem(cpy_r_r69, cpy_r_r70, cpy_r_r61);
    CPy_DECREF(cpy_r_r61);
    cpy_r_r72 = cpy_r_r71 >= 0;
    if (unlikely(!cpy_r_r72)) {
        CPy_AddTraceback("src/charset_normalizer/md.py", "<module>", 114, CPyStatic_globals);
        goto CPyL77;
    }
    cpy_r_r73 = (PyObject *)CPyType_MessDetectorPlugin;
    cpy_r_r74 = PyTuple_Pack(1, cpy_r_r73);
    if (unlikely(cpy_r_r74 == NULL)) {
        CPy_AddTraceback("src/charset_normalizer/md.py", "<module>", 141, CPyStatic_globals);
        goto CPyL77;
    }
    cpy_r_r75 = CPyStatics[72]; /* 'charset_normalizer.md' */
    cpy_r_r76 = (PyObject *)CPyType_UnprintablePlugin_template;
    cpy_r_r77 = CPyType_FromTemplate(cpy_r_r76, cpy_r_r74, cpy_r_r75);
    CPy_DECREF(cpy_r_r74);
    if (unlikely(cpy_r_r77 == NULL)) {
        CPy_AddTraceback("src/charset_normalizer/md.py", "<module>", 141, CPyStatic_globals);
        goto CPyL77;
    }
    cpy_r_r78 = CPyDef_UnprintablePlugin_trait_vtable_setup();
    if (unlikely(cpy_r_r78 == 2)) {
        CPy_AddTraceback("src/charset_normalizer/md.py", "<module>", -1, CPyStatic_globals);
        goto CPyL81;
    }
    cpy_r_r79 = CPyStatics[73]; /* '__mypyc_attrs__' */
    cpy_r_r80 = CPyStatics[83]; /* '_unprintable_count' */
    cpy_r_r81 = CPyStatics[77]; /* '_character_count' */
    cpy_r_r82 = PyTuple_Pack(2, cpy_r_r80, cpy_r_r81);
    if (unlikely(cpy_r_r82 == NULL)) {
        CPy_AddTraceback("src/charset_normalizer/md.py", "<module>", 141, CPyStatic_globals);
        goto CPyL81;
    }
    cpy_r_r83 = PyObject_SetAttr(cpy_r_r77, cpy_r_r79, cpy_r_r82);
    CPy_DECREF(cpy_r_r82);
    cpy_r_r84 = cpy_r_r83 >= 0;
    if (unlikely(!cpy_r_r84)) {
        CPy_AddTraceback("src/charset_normalizer/md.py", "<module>", 141, CPyStatic_globals);
        goto CPyL81;
    }
    CPyType_UnprintablePlugin = (PyTypeObject *)cpy_r_r77;
    CPy_INCREF(CPyType_UnprintablePlugin);
    cpy_r_r85 = CPyStatic_globals;
    cpy_r_r86 = CPyStatics[84]; /* 'UnprintablePlugin' */
    cpy_r_r87 = PyDict_SetItem(cpy_r_r85, cpy_r_r86, cpy_r_r77);
    CPy_DECREF(cpy_r_r77);
    cpy_r_r88 = cpy_r_r87 >= 0;
    if (unlikely(!cpy_r_r88)) {
        CPy_AddTraceback("src/charset_normalizer/md.py", "<module>", 141, CPyStatic_globals);
        goto CPyL77;
    }
    cpy_r_r89 = (PyObject *)CPyType_MessDetectorPlugin;
    cpy_r_r90 = PyTuple_Pack(1, cpy_r_r89);
    if (unlikely(cpy_r_r90 == NULL)) {
        CPy_AddTraceback("src/charset_normalizer/md.py", "<module>", 165, CPyStatic_globals);
        goto CPyL77;
    }
    cpy_r_r91 = CPyStatics[72]; /* 'charset_normalizer.md' */
    cpy_r_r92 = (PyObject *)CPyType_SuspiciousDuplicateAccentPlugin_template;
    cpy_r_r93 = CPyType_FromTemplate(cpy_r_r92, cpy_r_r90, cpy_r_r91);
    CPy_DECREF(cpy_r_r90);
    if (unlikely(cpy_r_r93 == NULL)) {
        CPy_AddTraceback("src/charset_normalizer/md.py", "<module>", 165, CPyStatic_globals);
        goto CPyL77;
    }
    cpy_r_r94 = CPyDef_SuspiciousDuplicateAccentPlugin_trait_vtable_setup();
    if (unlikely(cpy_r_r94 == 2)) {
        CPy_AddTraceback("src/charset_normalizer/md.py", "<module>", -1, CPyStatic_globals);
        goto CPyL82;
    }
    cpy_r_r95 = CPyStatics[73]; /* '__mypyc_attrs__' */
    cpy_r_r96 = CPyStatics[85]; /* '_successive_count' */
    cpy_r_r97 = CPyStatics[77]; /* '_character_count' */
    cpy_r_r98 = CPyStatics[86]; /* '_last_latin_character' */
    cpy_r_r99 = PyTuple_Pack(3, cpy_r_r96, cpy_r_r97, cpy_r_r98);
    if (unlikely(cpy_r_r99 == NULL)) {
        CPy_AddTraceback("src/charset_normalizer/md.py", "<module>", 165, CPyStatic_globals);
        goto CPyL82;
    }
    cpy_r_r100 = PyObject_SetAttr(cpy_r_r93, cpy_r_r95, cpy_r_r99);
    CPy_DECREF(cpy_r_r99);
    cpy_r_r101 = cpy_r_r100 >= 0;
    if (unlikely(!cpy_r_r101)) {
        CPy_AddTraceback("src/charset_normalizer/md.py", "<module>", 165, CPyStatic_globals);
        goto CPyL82;
    }
    CPyType_SuspiciousDuplicateAccentPlugin = (PyTypeObject *)cpy_r_r93;
    CPy_INCREF(CPyType_SuspiciousDuplicateAccentPlugin);
    cpy_r_r102 = CPyStatic_globals;
    cpy_r_r103 = CPyStatics[87]; /* 'SuspiciousDuplicateAccentPlugin' */
    cpy_r_r104 = PyDict_SetItem(cpy_r_r102, cpy_r_r103, cpy_r_r93);
    CPy_DECREF(cpy_r_r93);
    cpy_r_r105 = cpy_r_r104 >= 0;
    if (unlikely(!cpy_r_r105)) {
        CPy_AddTraceback("src/charset_normalizer/md.py", "<module>", 165, CPyStatic_globals);
        goto CPyL77;
    }
    cpy_r_r106 = (PyObject *)CPyType_MessDetectorPlugin;
    cpy_r_r107 = PyTuple_Pack(1, cpy_r_r106);
    if (unlikely(cpy_r_r107 == NULL)) {
        CPy_AddTraceback("src/charset_normalizer/md.py", "<module>", 202, CPyStatic_globals);
        goto CPyL77;
    }
    cpy_r_r108 = CPyStatics[72]; /* 'charset_normalizer.md' */
    cpy_r_r109 = (PyObject *)CPyType_SuspiciousRange_template;
    cpy_r_r110 = CPyType_FromTemplate(cpy_r_r109, cpy_r_r107, cpy_r_r108);
    CPy_DECREF(cpy_r_r107);
    if (unlikely(cpy_r_r110 == NULL)) {
        CPy_AddTraceback("src/charset_normalizer/md.py", "<module>", 202, CPyStatic_globals);
        goto CPyL77;
    }
    cpy_r_r111 = CPyDef_SuspiciousRange_trait_vtable_setup();
    if (unlikely(cpy_r_r111 == 2)) {
        CPy_AddTraceback("src/charset_normalizer/md.py", "<module>", -1, CPyStatic_globals);
        goto CPyL83;
    }
    cpy_r_r112 = CPyStatics[73]; /* '__mypyc_attrs__' */
    cpy_r_r113 = CPyStatics[88]; /* '_suspicious_successive_range_count' */
    cpy_r_r114 = CPyStatics[77]; /* '_character_count' */
    cpy_r_r115 = CPyStatics[89]; /* '_last_printable_seen' */
    cpy_r_r116 = PyTuple_Pack(3, cpy_r_r113, cpy_r_r114, cpy_r_r115);
    if (unlikely(cpy_r_r116 == NULL)) {
        CPy_AddTraceback("src/charset_normalizer/md.py", "<module>", 202, CPyStatic_globals);
        goto CPyL83;
    }
    cpy_r_r117 = PyObject_SetAttr(cpy_r_r110, cpy_r_r112, cpy_r_r116);
    CPy_DECREF(cpy_r_r116);
    cpy_r_r118 = cpy_r_r117 >= 0;
    if (unlikely(!cpy_r_r118)) {
        CPy_AddTraceback("src/charset_normalizer/md.py", "<module>", 202, CPyStatic_globals);
        goto CPyL83;
    }
    CPyType_SuspiciousRange = (PyTypeObject *)cpy_r_r110;
    CPy_INCREF(CPyType_SuspiciousRange);
    cpy_r_r119 = CPyStatic_globals;
    cpy_r_r120 = CPyStatics[90]; /* 'SuspiciousRange' */
    cpy_r_r121 = PyDict_SetItem(cpy_r_r119, cpy_r_r120, cpy_r_r110);
    CPy_DECREF(cpy_r_r110);
    cpy_r_r122 = cpy_r_r121 >= 0;
    if (unlikely(!cpy_r_r122)) {
        CPy_AddTraceback("src/charset_normalizer/md.py", "<module>", 202, CPyStatic_globals);
        goto CPyL77;
    }
    cpy_r_r123 = (PyObject *)CPyType_MessDetectorPlugin;
    cpy_r_r124 = PyTuple_Pack(1, cpy_r_r123);
    if (unlikely(cpy_r_r124 == NULL)) {
        CPy_AddTraceback("src/charset_normalizer/md.py", "<module>", 251, CPyStatic_globals);
        goto CPyL77;
    }
    cpy_r_r125 = CPyStatics[72]; /* 'charset_normalizer.md' */
    cpy_r_r126 = (PyObject *)CPyType_SuperWeirdWordPlugin_template;
    cpy_r_r127 = CPyType_FromTemplate(cpy_r_r126, cpy_r_r124, cpy_r_r125);
    CPy_DECREF(cpy_r_r124);
    if (unlikely(cpy_r_r127 == NULL)) {
        CPy_AddTraceback("src/charset_normalizer/md.py", "<module>", 251, CPyStatic_globals);
        goto CPyL77;
    }
    cpy_r_r128 = CPyDef_SuperWeirdWordPlugin_trait_vtable_setup();
    if (unlikely(cpy_r_r128 == 2)) {
        CPy_AddTraceback("src/charset_normalizer/md.py", "<module>", -1, CPyStatic_globals);
        goto CPyL84;
    }
    cpy_r_r129 = CPyStatics[73]; /* '__mypyc_attrs__' */
    cpy_r_r130 = CPyStatics[91]; /* '_word_count' */
    cpy_r_r131 = CPyStatics[92]; /* '_bad_word_count' */
    cpy_r_r132 = CPyStatics[93]; /* '_foreign_long_count' */
    cpy_r_r133 = CPyStatics[94]; /* '_is_current_word_bad' */
    cpy_r_r134 = CPyStatics[95]; /* '_foreign_long_watch' */
    cpy_r_r135 = CPyStatics[77]; /* '_character_count' */
    cpy_r_r136 = CPyStatics[96]; /* '_bad_character_count' */
    cpy_r_r137 = CPyStatics[97]; /* '_buffer' */
    cpy_r_r138 = CPyStatics[98]; /* '_buffer_accent_count' */
    cpy_r_r139 = CPyStatics[99]; /* '_buffer_glyph_count' */
    cpy_r_r140 = PyTuple_Pack(10, cpy_r_r130, cpy_r_r131, cpy_r_r132, cpy_r_r133, cpy_r_r134, cpy_r_r135, cpy_r_r136, cpy_r_r137, cpy_r_r138, cpy_r_r139);
    if (unlikely(cpy_r_r140 == NULL)) {
        CPy_AddTraceback("src/charset_normalizer/md.py", "<module>", 251, CPyStatic_globals);
        goto CPyL84;
    }
    cpy_r_r141 = PyObject_SetAttr(cpy_r_r127, cpy_r_r129, cpy_r_r140);
    CPy_DECREF(cpy_r_r140);
    cpy_r_r142 = cpy_r_r141 >= 0;
    if (unlikely(!cpy_r_r142)) {
        CPy_AddTraceback("src/charset_normalizer/md.py", "<module>", 251, CPyStatic_globals);
        goto CPyL84;
    }
    CPyType_SuperWeirdWordPlugin = (PyTypeObject *)cpy_r_r127;
    CPy_INCREF(CPyType_SuperWeirdWordPlugin);
    cpy_r_r143 = CPyStatic_globals;
    cpy_r_r144 = CPyStatics[100]; /* 'SuperWeirdWordPlugin' */
    cpy_r_r145 = PyDict_SetItem(cpy_r_r143, cpy_r_r144, cpy_r_r127);
    CPy_DECREF(cpy_r_r127);
    cpy_r_r146 = cpy_r_r145 >= 0;
    if (unlikely(!cpy_r_r146)) {
        CPy_AddTraceback("src/charset_normalizer/md.py", "<module>", 251, CPyStatic_globals);
        goto CPyL77;
    }
    cpy_r_r147 = (PyObject *)CPyType_MessDetectorPlugin;
    cpy_r_r148 = PyTuple_Pack(1, cpy_r_r147);
    if (unlikely(cpy_r_r148 == NULL)) {
        CPy_AddTraceback("src/charset_normalizer/md.py", "<module>", 369, CPyStatic_globals);
        goto CPyL77;
    }
    cpy_r_r149 = CPyStatics[72]; /* 'charset_normalizer.md' */
    cpy_r_r150 = (PyObject *)CPyType_CjkUncommonPlugin_template;
    cpy_r_r151 = CPyType_FromTemplate(cpy_r_r150, cpy_r_r148, cpy_r_r149);
    CPy_DECREF(cpy_r_r148);
    if (unlikely(cpy_r_r151 == NULL)) {
        CPy_AddTraceback("src/charset_normalizer/md.py", "<module>", 369, CPyStatic_globals);
        goto CPyL77;
    }
    cpy_r_r152 = CPyDef_CjkUncommonPlugin_trait_vtable_setup();
    if (unlikely(cpy_r_r152 == 2)) {
        CPy_AddTraceback("src/charset_normalizer/md.py", "<module>", -1, CPyStatic_globals);
        goto CPyL85;
    }
    cpy_r_r153 = CPyStatics[73]; /* '__mypyc_attrs__' */
    cpy_r_r154 = CPyStatics[77]; /* '_character_count' */
    cpy_r_r155 = CPyStatics[101]; /* '_uncommon_count' */
    cpy_r_r156 = PyTuple_Pack(2, cpy_r_r154, cpy_r_r155);
    if (unlikely(cpy_r_r156 == NULL)) {
        CPy_AddTraceback("src/charset_normalizer/md.py", "<module>", 369, CPyStatic_globals);
        goto CPyL85;
    }
    cpy_r_r157 = PyObject_SetAttr(cpy_r_r151, cpy_r_r153, cpy_r_r156);
    CPy_DECREF(cpy_r_r156);
    cpy_r_r158 = cpy_r_r157 >= 0;
    if (unlikely(!cpy_r_r158)) {
        CPy_AddTraceback("src/charset_normalizer/md.py", "<module>", 369, CPyStatic_globals);
        goto CPyL85;
    }
    CPyType_CjkUncommonPlugin = (PyTypeObject *)cpy_r_r151;
    CPy_INCREF(CPyType_CjkUncommonPlugin);
    cpy_r_r159 = CPyStatic_globals;
    cpy_r_r160 = CPyStatics[102]; /* 'CjkUncommonPlugin' */
    cpy_r_r161 = PyDict_SetItem(cpy_r_r159, cpy_r_r160, cpy_r_r151);
    CPy_DECREF(cpy_r_r151);
    cpy_r_r162 = cpy_r_r161 >= 0;
    if (unlikely(!cpy_r_r162)) {
        CPy_AddTraceback("src/charset_normalizer/md.py", "<module>", 369, CPyStatic_globals);
        goto CPyL77;
    }
    cpy_r_r163 = (PyObject *)CPyType_MessDetectorPlugin;
    cpy_r_r164 = PyTuple_Pack(1, cpy_r_r163);
    if (unlikely(cpy_r_r164 == NULL)) {
        CPy_AddTraceback("src/charset_normalizer/md.py", "<module>", 404, CPyStatic_globals);
        goto CPyL77;
    }
    cpy_r_r165 = CPyStatics[72]; /* 'charset_normalizer.md' */
    cpy_r_r166 = (PyObject *)CPyType_ArchaicUpperLowerPlugin_template;
    cpy_r_r167 = CPyType_FromTemplate(cpy_r_r166, cpy_r_r164, cpy_r_r165);
    CPy_DECREF(cpy_r_r164);
    if (unlikely(cpy_r_r167 == NULL)) {
        CPy_AddTraceback("src/charset_normalizer/md.py", "<module>", 404, CPyStatic_globals);
        goto CPyL77;
    }
    cpy_r_r168 = CPyDef_ArchaicUpperLowerPlugin_trait_vtable_setup();
    if (unlikely(cpy_r_r168 == 2)) {
        CPy_AddTraceback("src/charset_normalizer/md.py", "<module>", -1, CPyStatic_globals);
        goto CPyL86;
    }
    cpy_r_r169 = CPyStatics[73]; /* '__mypyc_attrs__' */
    cpy_r_r170 = CPyStatics[103]; /* '_buf' */
    cpy_r_r171 = CPyStatics[104]; /* '_character_count_since_last_sep' */
    cpy_r_r172 = CPyStatics[105]; /* '_successive_upper_lower_count' */
    cpy_r_r173 = CPyStatics[106]; /* '_successive_upper_lower_count_final' */
    cpy_r_r174 = CPyStatics[77]; /* '_character_count' */
    cpy_r_r175 = CPyStatics[107]; /* '_last_alpha_seen' */
    cpy_r_r176 = CPyStatics[108]; /* '_current_ascii_only' */
    cpy_r_r177 = PyTuple_Pack(7, cpy_r_r170, cpy_r_r171, cpy_r_r172, cpy_r_r173, cpy_r_r174, cpy_r_r175, cpy_r_r176);
    if (unlikely(cpy_r_r177 == NULL)) {
        CPy_AddTraceback("src/charset_normalizer/md.py", "<module>", 404, CPyStatic_globals);
        goto CPyL86;
    }
    cpy_r_r178 = PyObject_SetAttr(cpy_r_r167, cpy_r_r169, cpy_r_r177);
    CPy_DECREF(cpy_r_r177);
    cpy_r_r179 = cpy_r_r178 >= 0;
    if (unlikely(!cpy_r_r179)) {
        CPy_AddTraceback("src/charset_normalizer/md.py", "<module>", 404, CPyStatic_globals);
        goto CPyL86;
    }
    CPyType_ArchaicUpperLowerPlugin = (PyTypeObject *)cpy_r_r167;
    CPy_INCREF(CPyType_ArchaicUpperLowerPlugin);
    cpy_r_r180 = CPyStatic_globals;
    cpy_r_r181 = CPyStatics[109]; /* 'ArchaicUpperLowerPlugin' */
    cpy_r_r182 = PyDict_SetItem(cpy_r_r180, cpy_r_r181, cpy_r_r167);
    CPy_DECREF(cpy_r_r167);
    cpy_r_r183 = cpy_r_r182 >= 0;
    if (unlikely(!cpy_r_r183)) {
        CPy_AddTraceback("src/charset_normalizer/md.py", "<module>", 404, CPyStatic_globals);
        goto CPyL77;
    }
    cpy_r_r184 = (PyObject *)CPyType_MessDetectorPlugin;
    cpy_r_r185 = PyTuple_Pack(1, cpy_r_r184);
    if (unlikely(cpy_r_r185 == NULL)) {
        CPy_AddTraceback("src/charset_normalizer/md.py", "<module>", 480, CPyStatic_globals);
        goto CPyL77;
    }
    cpy_r_r186 = CPyStatics[72]; /* 'charset_normalizer.md' */
    cpy_r_r187 = (PyObject *)CPyType_ArabicIsolatedFormPlugin_template;
    cpy_r_r188 = CPyType_FromTemplate(cpy_r_r187, cpy_r_r185, cpy_r_r186);
    CPy_DECREF(cpy_r_r185);
    if (unlikely(cpy_r_r188 == NULL)) {
        CPy_AddTraceback("src/charset_normalizer/md.py", "<module>", 480, CPyStatic_globals);
        goto CPyL77;
    }
    cpy_r_r189 = CPyDef_ArabicIsolatedFormPlugin_trait_vtable_setup();
    if (unlikely(cpy_r_r189 == 2)) {
        CPy_AddTraceback("src/charset_normalizer/md.py", "<module>", -1, CPyStatic_globals);
        goto CPyL87;
    }
    cpy_r_r190 = CPyStatics[73]; /* '__mypyc_attrs__' */
    cpy_r_r191 = CPyStatics[77]; /* '_character_count' */
    cpy_r_r192 = CPyStatics[110]; /* '_isolated_form_count' */
    cpy_r_r193 = PyTuple_Pack(2, cpy_r_r191, cpy_r_r192);
    if (unlikely(cpy_r_r193 == NULL)) {
        CPy_AddTraceback("src/charset_normalizer/md.py", "<module>", 480, CPyStatic_globals);
        goto CPyL87;
    }
    cpy_r_r194 = PyObject_SetAttr(cpy_r_r188, cpy_r_r190, cpy_r_r193);
    CPy_DECREF(cpy_r_r193);
    cpy_r_r195 = cpy_r_r194 >= 0;
    if (unlikely(!cpy_r_r195)) {
        CPy_AddTraceback("src/charset_normalizer/md.py", "<module>", 480, CPyStatic_globals);
        goto CPyL87;
    }
    CPyType_ArabicIsolatedFormPlugin = (PyTypeObject *)cpy_r_r188;
    CPy_INCREF(CPyType_ArabicIsolatedFormPlugin);
    cpy_r_r196 = CPyStatic_globals;
    cpy_r_r197 = CPyStatics[111]; /* 'ArabicIsolatedFormPlugin' */
    cpy_r_r198 = PyDict_SetItem(cpy_r_r196, cpy_r_r197, cpy_r_r188);
    CPy_DECREF(cpy_r_r188);
    cpy_r_r199 = cpy_r_r198 >= 0;
    if (unlikely(!cpy_r_r199)) {
        CPy_AddTraceback("src/charset_normalizer/md.py", "<module>", 480, CPyStatic_globals);
        goto CPyL77;
    }
    cpy_r_r200 = CPyStatic_globals;
    cpy_r_r201 = CPyStatics[18]; /* 'is_suspiciously_successive_range' */
    cpy_r_r202 = CPyDict_GetItem(cpy_r_r200, cpy_r_r201);
    if (unlikely(cpy_r_r202 == NULL)) {
        CPy_AddTraceback("src/charset_normalizer/md.py", "<module>", 508, CPyStatic_globals);
        goto CPyL77;
    }
    cpy_r_r203 = CPyStatic_globals;
    cpy_r_r204 = CPyStatics[67]; /* 'lru_cache' */
    cpy_r_r205 = CPyDict_GetItem(cpy_r_r203, cpy_r_r204);
    if (unlikely(cpy_r_r205 == NULL)) {
        CPy_AddTraceback("src/charset_normalizer/md.py", "<module>", 508, CPyStatic_globals);
        goto CPyL88;
    }
    cpy_r_r206 = CPyStatics[116]; /* 1024 */
    PyObject *cpy_r_r207[1] = {cpy_r_r206};
    cpy_r_r208 = (PyObject **)&cpy_r_r207;
    cpy_r_r209 = CPyStatics[123]; /* ('maxsize',) */
    cpy_r_r210 = PyObject_Vectorcall(cpy_r_r205, cpy_r_r208, 0, cpy_r_r209);
    CPy_DECREF(cpy_r_r205);
    if (unlikely(cpy_r_r210 == NULL)) {
        CPy_AddTraceback("src/charset_normalizer/md.py", "<module>", 508, CPyStatic_globals);
        goto CPyL88;
    }
    PyObject *cpy_r_r211[1] = {cpy_r_r202};
    cpy_r_r212 = (PyObject **)&cpy_r_r211;
    cpy_r_r213 = PyObject_Vectorcall(cpy_r_r210, cpy_r_r212, 1, 0);
    CPy_DECREF(cpy_r_r210);
    if (unlikely(cpy_r_r213 == NULL)) {
        CPy_AddTraceback("src/charset_normalizer/md.py", "<module>", 508, CPyStatic_globals);
        goto CPyL88;
    }
    CPy_DECREF(cpy_r_r202);
    cpy_r_r214 = CPyStatic_globals;
    cpy_r_r215 = CPyStatics[18]; /* 'is_suspiciously_successive_range' */
    cpy_r_r216 = PyDict_SetItem(cpy_r_r214, cpy_r_r215, cpy_r_r213);
    CPy_DECREF(cpy_r_r213);
    cpy_r_r217 = cpy_r_r216 >= 0;
    if (unlikely(!cpy_r_r217)) {
        CPy_AddTraceback("src/charset_normalizer/md.py", "<module>", 508, CPyStatic_globals);
        goto CPyL77;
    }
    cpy_r_r218 = CPyStatic_globals;
    cpy_r_r219 = CPyStatics[113]; /* 'mess_ratio' */
    cpy_r_r220 = CPyDict_GetItem(cpy_r_r218, cpy_r_r219);
    if (unlikely(cpy_r_r220 == NULL)) {
        CPy_AddTraceback("src/charset_normalizer/md.py", "<module>", 582, CPyStatic_globals);
        goto CPyL77;
    }
    cpy_r_r221 = CPyStatic_globals;
    cpy_r_r222 = CPyStatics[67]; /* 'lru_cache' */
    cpy_r_r223 = CPyDict_GetItem(cpy_r_r221, cpy_r_r222);
    if (unlikely(cpy_r_r223 == NULL)) {
        CPy_AddTraceback("src/charset_normalizer/md.py", "<module>", 582, CPyStatic_globals);
        goto CPyL89;
    }
    cpy_r_r224 = CPyStatics[117]; /* 2048 */
    PyObject *cpy_r_r225[1] = {cpy_r_r224};
    cpy_r_r226 = (PyObject **)&cpy_r_r225;
    cpy_r_r227 = CPyStatics[123]; /* ('maxsize',) */
    cpy_r_r228 = PyObject_Vectorcall(cpy_r_r223, cpy_r_r226, 0, cpy_r_r227);
    CPy_DECREF(cpy_r_r223);
    if (unlikely(cpy_r_r228 == NULL)) {
        CPy_AddTraceback("src/charset_normalizer/md.py", "<module>", 582, CPyStatic_globals);
        goto CPyL89;
    }
    PyObject *cpy_r_r229[1] = {cpy_r_r220};
    cpy_r_r230 = (PyObject **)&cpy_r_r229;
    cpy_r_r231 = PyObject_Vectorcall(cpy_r_r228, cpy_r_r230, 1, 0);
    CPy_DECREF(cpy_r_r228);
    if (unlikely(cpy_r_r231 == NULL)) {
        CPy_AddTraceback("src/charset_normalizer/md.py", "<module>", 582, CPyStatic_globals);
        goto CPyL89;
    }
    CPy_DECREF(cpy_r_r220);
    cpy_r_r232 = CPyStatic_globals;
    cpy_r_r233 = CPyStatics[113]; /* 'mess_ratio' */
    cpy_r_r234 = PyDict_SetItem(cpy_r_r232, cpy_r_r233, cpy_r_r231);
    CPy_DECREF(cpy_r_r231);
    cpy_r_r235 = cpy_r_r234 >= 0;
    if (unlikely(!cpy_r_r235)) {
        CPy_AddTraceback("src/charset_normalizer/md.py", "<module>", 582, CPyStatic_globals);
        goto CPyL77;
    }
    return 1;
CPyL77: ;
    cpy_r_r236 = 2;
    return cpy_r_r236;
CPyL78: ;
    CPy_DecRef(cpy_r_r28);
    goto CPyL77;
CPyL79: ;
    CPy_DecRef(cpy_r_r42);
    goto CPyL77;
CPyL80: ;
    CPy_DecRef(cpy_r_r61);
    goto CPyL77;
CPyL81: ;
    CPy_DecRef(cpy_r_r77);
    goto CPyL77;
CPyL82: ;
    CPy_DecRef(cpy_r_r93);
    goto CPyL77;
CPyL83: ;
    CPy_DecRef(cpy_r_r110);
    goto CPyL77;
CPyL84: ;
    CPy_DecRef(cpy_r_r127);
    goto CPyL77;
CPyL85: ;
    CPy_DecRef(cpy_r_r151);
    goto CPyL77;
CPyL86: ;
    CPy_DecRef(cpy_r_r167);
    goto CPyL77;
CPyL87: ;
    CPy_DecRef(cpy_r_r188);
    goto CPyL77;
CPyL88: ;
    CPy_DecRef(cpy_r_r202);
    goto CPyL77;
CPyL89: ;
    CPy_DecRef(cpy_r_r220);
    goto CPyL77;
}

int CPyGlobalsInit(void)
{
    static int is_initialized = 0;
    if (is_initialized) return 0;
    
    CPy_Init();
    CPyModule_charset_normalizer___md = Py_None;
    CPyModule_builtins = Py_None;
    CPyModule___future__ = Py_None;
    CPyModule_functools = Py_None;
    CPyModule_logging = Py_None;
    CPyModule_charset_normalizer___constant = Py_None;
    CPyModule_charset_normalizer___utils = Py_None;
    if (CPyStatics_Initialize(CPyStatics, CPyLit_Str, CPyLit_Bytes, CPyLit_Int, CPyLit_Float, CPyLit_Complex, CPyLit_Tuple, CPyLit_FrozenSet) < 0) {
        return -1;
    }
    is_initialized = 1;
    return 0;
}

PyObject *CPyStatics[125];
const char * const CPyLit_Str[] = {
    "\003\023NotImplementedError\visprintable\034COMMON_SAFE_ASCII_CHARACTERS",
    "\006\016is_punctuation\aisdigit\tis_symbol\vis_emoticon\aisalpha\016is_accentuated",
    "\006\016is_unprintable\bis_latin\aisupper\rremove_accent\aisspace\runicode_range",
    "\005 is_suspiciously_successive_range\000\006is_cjk\tis_hangul\vis_katakana",
    "\v\vis_hiragana\ais_thai\fis_separator\001<\001-\001>\001=\001~\001|\001_\017is_cjk_uncommon",
    "\005\020is_case_variable\aisascii\aislower\tis_arabic\027is_arabic_isolated_form",
    "\006\005Latin\tEmoticons\tCombining\001 \037UNICODE_SECONDARY_RANGE_KEYWORD\bHiragana",
    "\b\bKatakana\003CJK\006Hangul\vBasic Latin\vPunctuation\005Forms\016__subclasses__\001\n",
    "\003\022charset_normalizer\tgetLogger\005TRACE",
    "\001IMess-detector extended-analysis start. intermediary_mean_mess_ratio_calc=",
    "\004\021 mean_mess_ratio=\023 maximum_threshold=\003log\017Starting with: ",
    "\a\rEnding with: \002: \005round\bbuiltins\vannotations\n__future__\tlru_cache",
    "\003\tfunctools\alogging\033charset_normalizer.constant",
    "\003\030charset_normalizer.utils\025charset_normalizer.md\017__mypyc_attrs__",
    "\004\022MessDetectorPlugin\022_punctuation_count\r_symbol_count\020_character_count",
    "\002\024_last_printable_char\026_frenzy_symbol_in_word",
    "\002 TooManySymbolOrPunctuationPlugin\022_accentuated_count",
    "\003\030TooManyAccentuatedPlugin\022_unprintable_count\021UnprintablePlugin",
    "\002\021_successive_count\025_last_latin_character",
    "\002\037SuspiciousDuplicateAccentPlugin\"_suspicious_successive_range_count",
    "\004\024_last_printable_seen\017SuspiciousRange\v_word_count\017_bad_word_count",
    "\003\023_foreign_long_count\024_is_current_word_bad\023_foreign_long_watch",
    "\004\024_bad_character_count\a_buffer\024_buffer_accent_count\023_buffer_glyph_count",
    "\004\024SuperWeirdWordPlugin\017_uncommon_count\021CjkUncommonPlugin\004_buf",
    "\002\037_character_count_since_last_sep\035_successive_upper_lower_count",
    "\002#_successive_upper_lower_count_final\020_last_alpha_seen",
    "\003\023_current_ascii_only\027ArchaicUpperLowerPlugin\024_isolated_form_count",
    "\003\030ArabicIsolatedFormPlugin\amaxsize\nmess_ratio",
    "",
};
const char * const CPyLit_Bytes[] = {
    "",
};
const char * const CPyLit_Int[] = {
    "\0040\0003\0001024\0002048",
    "",
};
const double CPyLit_Float[] = {0};
const double CPyLit_Complex[] = {0};
const int CPyLit_Tuple[] = {
    6, 1, 65, 1, 67, 1, 54, 3, 5, 55, 43, 18, 11, 37, 38, 34, 20, 9, 21,
    23, 22, 13, 6, 25, 8, 24, 12, 15, 17, 33, 1, 112
};
const int CPyLit_FrozenSet[] = {1, 7, 26, 27, 28, 29, 30, 31, 32};
CPyModule *CPyModule_charset_normalizer___md__internal = NULL;
CPyModule *CPyModule_charset_normalizer___md;
PyObject *CPyStatic_globals;
CPyModule *CPyModule_builtins;
CPyModule *CPyModule___future__;
CPyModule *CPyModule_functools;
CPyModule *CPyModule_logging;
CPyModule *CPyModule_charset_normalizer___constant;
CPyModule *CPyModule_charset_normalizer___utils;
PyTypeObject *CPyType_MessDetectorPlugin;
PyObject *CPyDef_MessDetectorPlugin(void);
PyTypeObject *CPyType_TooManySymbolOrPunctuationPlugin;
PyObject *CPyDef_TooManySymbolOrPunctuationPlugin(void);
PyTypeObject *CPyType_TooManyAccentuatedPlugin;
PyObject *CPyDef_TooManyAccentuatedPlugin(void);
PyTypeObject *CPyType_UnprintablePlugin;
PyObject *CPyDef_UnprintablePlugin(void);
PyTypeObject *CPyType_SuspiciousDuplicateAccentPlugin;
PyObject *CPyDef_SuspiciousDuplicateAccentPlugin(void);
PyTypeObject *CPyType_SuspiciousRange;
PyObject *CPyDef_SuspiciousRange(void);
PyTypeObject *CPyType_SuperWeirdWordPlugin;
PyObject *CPyDef_SuperWeirdWordPlugin(void);
PyTypeObject *CPyType_CjkUncommonPlugin;
PyObject *CPyDef_CjkUncommonPlugin(void);
PyTypeObject *CPyType_ArchaicUpperLowerPlugin;
PyObject *CPyDef_ArchaicUpperLowerPlugin(void);
PyTypeObject *CPyType_ArabicIsolatedFormPlugin;
PyObject *CPyDef_ArabicIsolatedFormPlugin(void);
char CPyDef_MessDetectorPlugin___eligible(PyObject *cpy_r_self, PyObject *cpy_r_character);
PyObject *CPyPy_MessDetectorPlugin___eligible(PyObject *self, PyObject *const *args, size_t nargs, PyObject *kwnames);
char CPyDef_MessDetectorPlugin___feed(PyObject *cpy_r_self, PyObject *cpy_r_character);
PyObject *CPyPy_MessDetectorPlugin___feed(PyObject *self, PyObject *const *args, size_t nargs, PyObject *kwnames);
char CPyDef_MessDetectorPlugin___reset(PyObject *cpy_r_self);
PyObject *CPyPy_MessDetectorPlugin___reset(PyObject *self, PyObject *const *args, size_t nargs, PyObject *kwnames);
double CPyDef_MessDetectorPlugin___ratio(PyObject *cpy_r_self);
PyObject *CPyPy_MessDetectorPlugin___ratio(PyObject *self, PyObject *const *args, size_t nargs, PyObject *kwnames);
char CPyDef_TooManySymbolOrPunctuationPlugin_____init__(PyObject *cpy_r_self);
PyObject *CPyPy_TooManySymbolOrPunctuationPlugin_____init__(PyObject *self, PyObject *args, PyObject *kw);
char CPyDef_TooManySymbolOrPunctuationPlugin___eligible(PyObject *cpy_r_self, PyObject *cpy_r_character);
PyObject *CPyPy_TooManySymbolOrPunctuationPlugin___eligible(PyObject *self, PyObject *const *args, size_t nargs, PyObject *kwnames);
char CPyDef_TooManySymbolOrPunctuationPlugin___feed(PyObject *cpy_r_self, PyObject *cpy_r_character);
PyObject *CPyPy_TooManySymbolOrPunctuationPlugin___feed(PyObject *self, PyObject *const *args, size_t nargs, PyObject *kwnames);
char CPyDef_TooManySymbolOrPunctuationPlugin___reset(PyObject *cpy_r_self);
PyObject *CPyPy_TooManySymbolOrPunctuationPlugin___reset(PyObject *self, PyObject *const *args, size_t nargs, PyObject *kwnames);
double CPyDef_TooManySymbolOrPunctuationPlugin___ratio(PyObject *cpy_r_self);
PyObject *CPyPy_TooManySymbolOrPunctuationPlugin___ratio(PyObject *self, PyObject *const *args, size_t nargs, PyObject *kwnames);
char CPyDef_TooManyAccentuatedPlugin_____init__(PyObject *cpy_r_self);
PyObject *CPyPy_TooManyAccentuatedPlugin_____init__(PyObject *self, PyObject *args, PyObject *kw);
char CPyDef_TooManyAccentuatedPlugin___eligible(PyObject *cpy_r_self, PyObject *cpy_r_character);
PyObject *CPyPy_TooManyAccentuatedPlugin___eligible(PyObject *self, PyObject *const *args, size_t nargs, PyObject *kwnames);
char CPyDef_TooManyAccentuatedPlugin___feed(PyObject *cpy_r_self, PyObject *cpy_r_character);
PyObject *CPyPy_TooManyAccentuatedPlugin___feed(PyObject *self, PyObject *const *args, size_t nargs, PyObject *kwnames);
char CPyDef_TooManyAccentuatedPlugin___reset(PyObject *cpy_r_self);
PyObject *CPyPy_TooManyAccentuatedPlugin___reset(PyObject *self, PyObject *const *args, size_t nargs, PyObject *kwnames);
double CPyDef_TooManyAccentuatedPlugin___ratio(PyObject *cpy_r_self);
PyObject *CPyPy_TooManyAccentuatedPlugin___ratio(PyObject *self, PyObject *const *args, size_t nargs, PyObject *kwnames);
char CPyDef_UnprintablePlugin_____init__(PyObject *cpy_r_self);
PyObject *CPyPy_UnprintablePlugin_____init__(PyObject *self, PyObject *args, PyObject *kw);
char CPyDef_UnprintablePlugin___eligible(PyObject *cpy_r_self, PyObject *cpy_r_character);
PyObject *CPyPy_UnprintablePlugin___eligible(PyObject *self, PyObject *const *args, size_t nargs, PyObject *kwnames);
char CPyDef_UnprintablePlugin___feed(PyObject *cpy_r_self, PyObject *cpy_r_character);
PyObject *CPyPy_UnprintablePlugin___feed(PyObject *self, PyObject *const *args, size_t nargs, PyObject *kwnames);
char CPyDef_UnprintablePlugin___reset(PyObject *cpy_r_self);
PyObject *CPyPy_UnprintablePlugin___reset(PyObject *self, PyObject *const *args, size_t nargs, PyObject *kwnames);
double CPyDef_UnprintablePlugin___ratio(PyObject *cpy_r_self);
PyObject *CPyPy_UnprintablePlugin___ratio(PyObject *self, PyObject *const *args, size_t nargs, PyObject *kwnames);
char CPyDef_SuspiciousDuplicateAccentPlugin_____init__(PyObject *cpy_r_self);
PyObject *CPyPy_SuspiciousDuplicateAccentPlugin_____init__(PyObject *self, PyObject *args, PyObject *kw);
char CPyDef_SuspiciousDuplicateAccentPlugin___eligible(PyObject *cpy_r_self, PyObject *cpy_r_character);
PyObject *CPyPy_SuspiciousDuplicateAccentPlugin___eligible(PyObject *self, PyObject *const *args, size_t nargs, PyObject *kwnames);
char CPyDef_SuspiciousDuplicateAccentPlugin___feed(PyObject *cpy_r_self, PyObject *cpy_r_character);
PyObject *CPyPy_SuspiciousDuplicateAccentPlugin___feed(PyObject *self, PyObject *const *args, size_t nargs, PyObject *kwnames);
char CPyDef_SuspiciousDuplicateAccentPlugin___reset(PyObject *cpy_r_self);
PyObject *CPyPy_SuspiciousDuplicateAccentPlugin___reset(PyObject *self, PyObject *const *args, size_t nargs, PyObject *kwnames);
double CPyDef_SuspiciousDuplicateAccentPlugin___ratio(PyObject *cpy_r_self);
PyObject *CPyPy_SuspiciousDuplicateAccentPlugin___ratio(PyObject *self, PyObject *const *args, size_t nargs, PyObject *kwnames);
char CPyDef_SuspiciousRange_____init__(PyObject *cpy_r_self);
PyObject *CPyPy_SuspiciousRange_____init__(PyObject *self, PyObject *args, PyObject *kw);
char CPyDef_SuspiciousRange___eligible(PyObject *cpy_r_self, PyObject *cpy_r_character);
PyObject *CPyPy_SuspiciousRange___eligible(PyObject *self, PyObject *const *args, size_t nargs, PyObject *kwnames);
char CPyDef_SuspiciousRange___feed(PyObject *cpy_r_self, PyObject *cpy_r_character);
PyObject *CPyPy_SuspiciousRange___feed(PyObject *self, PyObject *const *args, size_t nargs, PyObject *kwnames);
char CPyDef_SuspiciousRange___reset(PyObject *cpy_r_self);
PyObject *CPyPy_SuspiciousRange___reset(PyObject *self, PyObject *const *args, size_t nargs, PyObject *kwnames);
double CPyDef_SuspiciousRange___ratio(PyObject *cpy_r_self);
PyObject *CPyPy_SuspiciousRange___ratio(PyObject *self, PyObject *const *args, size_t nargs, PyObject *kwnames);
char CPyDef_SuperWeirdWordPlugin_____init__(PyObject *cpy_r_self);
PyObject *CPyPy_SuperWeirdWordPlugin_____init__(PyObject *self, PyObject *args, PyObject *kw);
char CPyDef_SuperWeirdWordPlugin___eligible(PyObject *cpy_r_self, PyObject *cpy_r_character);
PyObject *CPyPy_SuperWeirdWordPlugin___eligible(PyObject *self, PyObject *const *args, size_t nargs, PyObject *kwnames);
char CPyDef_SuperWeirdWordPlugin___feed(PyObject *cpy_r_self, PyObject *cpy_r_character);
PyObject *CPyPy_SuperWeirdWordPlugin___feed(PyObject *self, PyObject *const *args, size_t nargs, PyObject *kwnames);
char CPyDef_SuperWeirdWordPlugin___reset(PyObject *cpy_r_self);
PyObject *CPyPy_SuperWeirdWordPlugin___reset(PyObject *self, PyObject *const *args, size_t nargs, PyObject *kwnames);
double CPyDef_SuperWeirdWordPlugin___ratio(PyObject *cpy_r_self);
PyObject *CPyPy_SuperWeirdWordPlugin___ratio(PyObject *self, PyObject *const *args, size_t nargs, PyObject *kwnames);
char CPyDef_CjkUncommonPlugin_____init__(PyObject *cpy_r_self);
PyObject *CPyPy_CjkUncommonPlugin_____init__(PyObject *self, PyObject *args, PyObject *kw);
char CPyDef_CjkUncommonPlugin___eligible(PyObject *cpy_r_self, PyObject *cpy_r_character);
PyObject *CPyPy_CjkUncommonPlugin___eligible(PyObject *self, PyObject *const *args, size_t nargs, PyObject *kwnames);
char CPyDef_CjkUncommonPlugin___feed(PyObject *cpy_r_self, PyObject *cpy_r_character);
PyObject *CPyPy_CjkUncommonPlugin___feed(PyObject *self, PyObject *const *args, size_t nargs, PyObject *kwnames);
char CPyDef_CjkUncommonPlugin___reset(PyObject *cpy_r_self);
PyObject *CPyPy_CjkUncommonPlugin___reset(PyObject *self, PyObject *const *args, size_t nargs, PyObject *kwnames);
double CPyDef_CjkUncommonPlugin___ratio(PyObject *cpy_r_self);
PyObject *CPyPy_CjkUncommonPlugin___ratio(PyObject *self, PyObject *const *args, size_t nargs, PyObject *kwnames);
char CPyDef_ArchaicUpperLowerPlugin_____init__(PyObject *cpy_r_self);
PyObject *CPyPy_ArchaicUpperLowerPlugin_____init__(PyObject *self, PyObject *args, PyObject *kw);
char CPyDef_ArchaicUpperLowerPlugin___eligible(PyObject *cpy_r_self, PyObject *cpy_r_character);
PyObject *CPyPy_ArchaicUpperLowerPlugin___eligible(PyObject *self, PyObject *const *args, size_t nargs, PyObject *kwnames);
char CPyDef_ArchaicUpperLowerPlugin___feed(PyObject *cpy_r_self, PyObject *cpy_r_character);
PyObject *CPyPy_ArchaicUpperLowerPlugin___feed(PyObject *self, PyObject *const *args, size_t nargs, PyObject *kwnames);
char CPyDef_ArchaicUpperLowerPlugin___reset(PyObject *cpy_r_self);
PyObject *CPyPy_ArchaicUpperLowerPlugin___reset(PyObject *self, PyObject *const *args, size_t nargs, PyObject *kwnames);
double CPyDef_ArchaicUpperLowerPlugin___ratio(PyObject *cpy_r_self);
PyObject *CPyPy_ArchaicUpperLowerPlugin___ratio(PyObject *self, PyObject *const *args, size_t nargs, PyObject *kwnames);
char CPyDef_ArabicIsolatedFormPlugin_____init__(PyObject *cpy_r_self);
PyObject *CPyPy_ArabicIsolatedFormPlugin_____init__(PyObject *self, PyObject *args, PyObject *kw);
char CPyDef_ArabicIsolatedFormPlugin___reset(PyObject *cpy_r_self);
PyObject *CPyPy_ArabicIsolatedFormPlugin___reset(PyObject *self, PyObject *const *args, size_t nargs, PyObject *kwnames);
char CPyDef_ArabicIsolatedFormPlugin___eligible(PyObject *cpy_r_self, PyObject *cpy_r_character);
PyObject *CPyPy_ArabicIsolatedFormPlugin___eligible(PyObject *self, PyObject *const *args, size_t nargs, PyObject *kwnames);
char CPyDef_ArabicIsolatedFormPlugin___feed(PyObject *cpy_r_self, PyObject *cpy_r_character);
PyObject *CPyPy_ArabicIsolatedFormPlugin___feed(PyObject *self, PyObject *const *args, size_t nargs, PyObject *kwnames);
double CPyDef_ArabicIsolatedFormPlugin___ratio(PyObject *cpy_r_self);
PyObject *CPyPy_ArabicIsolatedFormPlugin___ratio(PyObject *self, PyObject *const *args, size_t nargs, PyObject *kwnames);
char CPyDef_is_suspiciously_successive_range(PyObject *cpy_r_unicode_range_a, PyObject *cpy_r_unicode_range_b);
PyObject *CPyPy_is_suspiciously_successive_range(PyObject *self, PyObject *const *args, size_t nargs, PyObject *kwnames);
double CPyDef_mess_ratio(PyObject *cpy_r_decoded_sequence, double cpy_r_maximum_threshold, char cpy_r_debug, uint32_t cpy_r___bitmap);
PyObject *CPyPy_mess_ratio(PyObject *self, PyObject *const *args, size_t nargs, PyObject *kwnames);
char CPyDef___top_level__(void);

static int exec_md__mypyc(PyObject *module)
{
    int res;
    PyObject *capsule;
    PyObject *tmp;
    
    extern PyObject *CPyInit_charset_normalizer___md(void);
    capsule = PyCapsule_New((void *)CPyInit_charset_normalizer___md, "charset_normalizer.md__mypyc.init_charset_normalizer___md", NULL);
    if (!capsule) {
        goto fail;
    }
    res = PyObject_SetAttrString(module, "init_charset_normalizer___md", capsule);
    Py_DECREF(capsule);
    if (res < 0) {
        goto fail;
    }
    
    return 0;
    fail:
    return -1;
}
static PyModuleDef module_def_md__mypyc = {
    PyModuleDef_HEAD_INIT,
    .m_name = "charset_normalizer.md__mypyc",
    .m_doc = NULL,
    .m_size = -1,
    .m_methods = NULL,
};
PyMODINIT_FUNC PyInit_md__mypyc(void) {
    static PyObject *module = NULL;
    if (module) {
        Py_INCREF(module);
        return module;
    }
    module = PyModule_Create(&module_def_md__mypyc);
    if (!module) {
        return NULL;
    }
    if (exec_md__mypyc(module) < 0) {
        Py_DECREF(module);
        return NULL;
    }
    return module;
}
