/*
 * Constants and lookup tables for Daitch-Mokotoff Soundex
 *
 * Copyright (c) 2023-2025, PostgreSQL Global Development Group
 *
 * This file is generated by daitch_mokotoff_header.pl
 */

/* Coding chart table: Soundex codes */
typedef char dm_code[2 + 1];	/* One or two sequential code digits + NUL */
typedef dm_code dm_codes[3];	/* Start of name, before a vowel, any other */

/* Coding chart table: Letter in input sequence */
struct dm_letter
{
	char		letter;			/* Present letter in sequence */
	const struct dm_letter *letters;	/* List of possible successive letters */
	const dm_codes *codes;		/* Code sequence(s) for complete sequence */
};

typedef struct dm_letter dm_letter;

/* Codes for letter sequence at start of name, before a vowel, and any other. */
static const dm_codes codes_0_1_X[2] =
{
	{
		"0", "1", "X"
	}
};
static const dm_codes codes_0_7_X[2] =
{
	{
		"0", "7", "X"
	}
};
static const dm_codes codes_0_X_X[2] =
{
	{
		"0", "X", "X"
	}
};
static const dm_codes codes_1_1_X[2] =
{
	{
		"1", "1", "X"
	}
};
static const dm_codes codes_1_X_X[2] =
{
	{
		"1", "X", "X"
	}
};
static const dm_codes codes_1_X_X_or_4_4_4[2] =
{
	{
		"1", "X", "X"
	},
	{
		"4", "4", "4"
	}
};
static const dm_codes codes_2_43_43[2] =
{
	{
		"2", "43", "43"
	}
};
static const dm_codes codes_2_4_4[2] =
{
	{
		"2", "4", "4"
	}
};
static const dm_codes codes_3_3_3[2] =
{
	{
		"3", "3", "3"
	}
};
static const dm_codes codes_3_3_3_or_4_4_4[2] =
{
	{
		"3", "3", "3"
	},
	{
		"4", "4", "4"
	}
};
static const dm_codes codes_4_4_4[2] =
{
	{
		"4", "4", "4"
	}
};
static const dm_codes codes_5_54_54[2] =
{
	{
		"5", "54", "54"
	}
};
static const dm_codes codes_5_5_5[2] =
{
	{
		"5", "5", "5"
	}
};
static const dm_codes codes_5_5_5_or_45_45_45[2] =
{
	{
		"5", "5", "5"
	},
	{
		"45", "45", "45"
	}
};
static const dm_codes codes_5_5_5_or_4_4_4[2] =
{
	{
		"5", "5", "5"
	},
	{
		"4", "4", "4"
	}
};
static const dm_codes codes_5_5_X[2] =
{
	{
		"5", "5", "X"
	}
};
static const dm_codes codes_66_66_66[2] =
{
	{
		"66", "66", "66"
	}
};
static const dm_codes codes_6_6_6[2] =
{
	{
		"6", "6", "6"
	}
};
static const dm_codes codes_7_7_7[2] =
{
	{
		"7", "7", "7"
	}
};
static const dm_codes codes_8_8_8[2] =
{
	{
		"8", "8", "8"
	}
};
static const dm_codes codes_94_94_94_or_4_4_4[2] =
{
	{
		"94", "94", "94"
	},
	{
		"4", "4", "4"
	}
};
static const dm_codes codes_9_9_9[2] =
{
	{
		"9", "9", "9"
	}
};
static const dm_codes codes_X_X_6_or_X_X_X[2] =
{
	{
		"X", "X", "6"
	},
	{
		"X", "X", "X"
	}
};

/* Coding for alternative following letters in sequence. */
static const dm_letter letter_A[] =
{
	{
		'I', NULL, codes_0_1_X
	},
	{
		'J', NULL, codes_0_1_X
	},
	{
		'U', NULL, codes_0_7_X
	},
	{
		'Y', NULL, codes_0_1_X
	},
	{
		'\0'
	}
};
static const dm_letter letter_CH[] =
{
	{
		'S', NULL, codes_5_54_54
	},
	{
		'\0'
	}
};
static const dm_letter letter_CS[] =
{
	{
		'Z', NULL, codes_4_4_4
	},
	{
		'\0'
	}
};
static const dm_letter letter_CZ[] =
{
	{
		'S', NULL, codes_4_4_4
	},
	{
		'\0'
	}
};
static const dm_letter letter_C[] =
{
	{
		'H', letter_CH, codes_5_5_5_or_4_4_4
	},
	{
		'K', NULL, codes_5_5_5_or_45_45_45
	},
	{
		'S', letter_CS, codes_4_4_4
	},
	{
		'Z', letter_CZ, codes_4_4_4
	},
	{
		'\0'
	}
};
static const dm_letter letter_DR[] =
{
	{
		'S', NULL, codes_4_4_4
	},
	{
		'Z', NULL, codes_4_4_4
	},
	{
		'\0'
	}
};
static const dm_letter letter_DS[] =
{
	{
		'H', NULL, codes_4_4_4
	},
	{
		'Z', NULL, codes_4_4_4
	},
	{
		'\0'
	}
};
static const dm_letter letter_DZ[] =
{
	{
		'H', NULL, codes_4_4_4
	},
	{
		'S', NULL, codes_4_4_4
	},
	{
		'\0'
	}
};
static const dm_letter letter_D[] =
{
	{
		'R', letter_DR, NULL
	},
	{
		'S', letter_DS, codes_4_4_4
	},
	{
		'T', NULL, codes_3_3_3
	},
	{
		'Z', letter_DZ, codes_4_4_4
	},
	{
		'\0'
	}
};
static const dm_letter letter_E[] =
{
	{
		'I', NULL, codes_0_1_X
	},
	{
		'J', NULL, codes_0_1_X
	},
	{
		'U', NULL, codes_1_1_X
	},
	{
		'Y', NULL, codes_0_1_X
	},
	{
		'\0'
	}
};
static const dm_letter letter_F[] =
{
	{
		'B', NULL, codes_7_7_7
	},
	{
		'\0'
	}
};
static const dm_letter letter_I[] =
{
	{
		'A', NULL, codes_1_X_X
	},
	{
		'E', NULL, codes_1_X_X
	},
	{
		'O', NULL, codes_1_X_X
	},
	{
		'U', NULL, codes_1_X_X
	},
	{
		'\0'
	}
};
static const dm_letter letter_K[] =
{
	{
		'H', NULL, codes_5_5_5
	},
	{
		'S', NULL, codes_5_54_54
	},
	{
		'\0'
	}
};
static const dm_letter letter_M[] =
{
	{
		'N', NULL, codes_66_66_66
	},
	{
		'\0'
	}
};
static const dm_letter letter_N[] =
{
	{
		'M', NULL, codes_66_66_66
	},
	{
		'\0'
	}
};
static const dm_letter letter_O[] =
{
	{
		'I', NULL, codes_0_1_X
	},
	{
		'J', NULL, codes_0_1_X
	},
	{
		'Y', NULL, codes_0_1_X
	},
	{
		'\0'
	}
};
static const dm_letter letter_P[] =
{
	{
		'F', NULL, codes_7_7_7
	},
	{
		'H', NULL, codes_7_7_7
	},
	{
		'\0'
	}
};
static const dm_letter letter_R[] =
{
	{
		'S', NULL, codes_94_94_94_or_4_4_4
	},
	{
		'Z', NULL, codes_94_94_94_or_4_4_4
	},
	{
		'\0'
	}
};
static const dm_letter letter_SCHTC[] =
{
	{
		'H', NULL, codes_2_4_4
	},
	{
		'\0'
	}
};
static const dm_letter letter_SCHTSC[] =
{
	{
		'H', NULL, codes_2_4_4
	},
	{
		'\0'
	}
};
static const dm_letter letter_SCHTS[] =
{
	{
		'C', letter_SCHTSC, NULL
	},
	{
		'H', NULL, codes_2_4_4
	},
	{
		'\0'
	}
};
static const dm_letter letter_SCHT[] =
{
	{
		'C', letter_SCHTC, NULL
	},
	{
		'S', letter_SCHTS, NULL
	},
	{
		'\0'
	}
};
static const dm_letter letter_SCH[] =
{
	{
		'D', NULL, codes_2_43_43
	},
	{
		'T', letter_SCHT, codes_2_43_43
	},
	{
		'\0'
	}
};
static const dm_letter letter_SC[] =
{
	{
		'H', letter_SCH, codes_4_4_4
	},
	{
		'\0'
	}
};
static const dm_letter letter_SHC[] =
{
	{
		'H', NULL, codes_2_4_4
	},
	{
		'\0'
	}
};
static const dm_letter letter_SHTC[] =
{
	{
		'H', NULL, codes_2_4_4
	},
	{
		'\0'
	}
};
static const dm_letter letter_SHTS[] =
{
	{
		'H', NULL, codes_2_4_4
	},
	{
		'\0'
	}
};
static const dm_letter letter_SHT[] =
{
	{
		'C', letter_SHTC, NULL
	},
	{
		'S', letter_SHTS, NULL
	},
	{
		'\0'
	}
};
static const dm_letter letter_SH[] =
{
	{
		'C', letter_SHC, NULL
	},
	{
		'D', NULL, codes_2_43_43
	},
	{
		'T', letter_SHT, codes_2_43_43
	},
	{
		'\0'
	}
};
static const dm_letter letter_STC[] =
{
	{
		'H', NULL, codes_2_4_4
	},
	{
		'\0'
	}
};
static const dm_letter letter_STR[] =
{
	{
		'S', NULL, codes_2_4_4
	},
	{
		'Z', NULL, codes_2_4_4
	},
	{
		'\0'
	}
};
static const dm_letter letter_STSC[] =
{
	{
		'H', NULL, codes_2_4_4
	},
	{
		'\0'
	}
};
static const dm_letter letter_STS[] =
{
	{
		'C', letter_STSC, NULL
	},
	{
		'H', NULL, codes_2_4_4
	},
	{
		'\0'
	}
};
static const dm_letter letter_ST[] =
{
	{
		'C', letter_STC, NULL
	},
	{
		'R', letter_STR, NULL
	},
	{
		'S', letter_STS, NULL
	},
	{
		'\0'
	}
};
static const dm_letter letter_SZC[] =
{
	{
		'S', NULL, codes_2_4_4
	},
	{
		'Z', NULL, codes_2_4_4
	},
	{
		'\0'
	}
};
static const dm_letter letter_SZ[] =
{
	{
		'C', letter_SZC, NULL
	},
	{
		'D', NULL, codes_2_43_43
	},
	{
		'T', NULL, codes_2_43_43
	},
	{
		'\0'
	}
};
static const dm_letter letter_S[] =
{
	{
		'C', letter_SC, codes_2_4_4
	},
	{
		'D', NULL, codes_2_43_43
	},
	{
		'H', letter_SH, codes_4_4_4
	},
	{
		'T', letter_ST, codes_2_43_43
	},
	{
		'Z', letter_SZ, codes_4_4_4
	},
	{
		'\0'
	}
};
static const dm_letter letter_TC[] =
{
	{
		'H', NULL, codes_4_4_4
	},
	{
		'\0'
	}
};
static const dm_letter letter_TR[] =
{
	{
		'S', NULL, codes_4_4_4
	},
	{
		'Z', NULL, codes_4_4_4
	},
	{
		'\0'
	}
};
static const dm_letter letter_TSC[] =
{
	{
		'H', NULL, codes_4_4_4
	},
	{
		'\0'
	}
};
static const dm_letter letter_TS[] =
{
	{
		'C', letter_TSC, NULL
	},
	{
		'H', NULL, codes_4_4_4
	},
	{
		'Z', NULL, codes_4_4_4
	},
	{
		'\0'
	}
};
static const dm_letter letter_TTC[] =
{
	{
		'H', NULL, codes_4_4_4
	},
	{
		'\0'
	}
};
static const dm_letter letter_TTSC[] =
{
	{
		'H', NULL, codes_4_4_4
	},
	{
		'\0'
	}
};
static const dm_letter letter_TTS[] =
{
	{
		'C', letter_TTSC, NULL
	},
	{
		'Z', NULL, codes_4_4_4
	},
	{
		'\0'
	}
};
static const dm_letter letter_TT[] =
{
	{
		'C', letter_TTC, NULL
	},
	{
		'S', letter_TTS, codes_4_4_4
	},
	{
		'Z', NULL, codes_4_4_4
	},
	{
		'\0'
	}
};
static const dm_letter letter_TZ[] =
{
	{
		'S', NULL, codes_4_4_4
	},
	{
		'\0'
	}
};
static const dm_letter letter_T[] =
{
	{
		'C', letter_TC, codes_4_4_4
	},
	{
		'H', NULL, codes_3_3_3
	},
	{
		'R', letter_TR, NULL
	},
	{
		'S', letter_TS, codes_4_4_4
	},
	{
		'T', letter_TT, NULL
	},
	{
		'Z', letter_TZ, codes_4_4_4
	},
	{
		'\0'
	}
};
static const dm_letter letter_U[] =
{
	{
		'E', NULL, codes_0_1_X
	},
	{
		'I', NULL, codes_0_1_X
	},
	{
		'J', NULL, codes_0_1_X
	},
	{
		'Y', NULL, codes_0_1_X
	},
	{
		'\0'
	}
};
static const dm_letter letter_ZDZ[] =
{
	{
		'H', NULL, codes_2_4_4
	},
	{
		'\0'
	}
};
static const dm_letter letter_ZD[] =
{
	{
		'Z', letter_ZDZ, codes_2_4_4
	},
	{
		'\0'
	}
};
static const dm_letter letter_ZHDZ[] =
{
	{
		'H', NULL, codes_2_4_4
	},
	{
		'\0'
	}
};
static const dm_letter letter_ZHD[] =
{
	{
		'Z', letter_ZHDZ, NULL
	},
	{
		'\0'
	}
};
static const dm_letter letter_ZH[] =
{
	{
		'D', letter_ZHD, codes_2_43_43
	},
	{
		'\0'
	}
};
static const dm_letter letter_ZSC[] =
{
	{
		'H', NULL, codes_4_4_4
	},
	{
		'\0'
	}
};
static const dm_letter letter_ZS[] =
{
	{
		'C', letter_ZSC, NULL
	},
	{
		'H', NULL, codes_4_4_4
	},
	{
		'\0'
	}
};
static const dm_letter letter_Z[] =
{
	{
		'D', letter_ZD, codes_2_43_43
	},
	{
		'H', letter_ZH, codes_4_4_4
	},
	{
		'S', letter_ZS, codes_4_4_4
	},
	{
		'\0'
	}
};
static const dm_letter letter_[] =
{
	{
		'A', letter_A, codes_0_X_X
	},
	{
		'B', NULL, codes_7_7_7
	},
	{
		'C', letter_C, codes_5_5_5_or_4_4_4
	},
	{
		'D', letter_D, codes_3_3_3
	},
	{
		'E', letter_E, codes_0_X_X
	},
	{
		'F', letter_F, codes_7_7_7
	},
	{
		'G', NULL, codes_5_5_5
	},
	{
		'H', NULL, codes_5_5_X
	},
	{
		'I', letter_I, codes_0_X_X
	},
	{
		'J', NULL, codes_1_X_X_or_4_4_4
	},
	{
		'K', letter_K, codes_5_5_5
	},
	{
		'L', NULL, codes_8_8_8
	},
	{
		'M', letter_M, codes_6_6_6
	},
	{
		'N', letter_N, codes_6_6_6
	},
	{
		'O', letter_O, codes_0_X_X
	},
	{
		'P', letter_P, codes_7_7_7
	},
	{
		'Q', NULL, codes_5_5_5
	},
	{
		'R', letter_R, codes_9_9_9
	},
	{
		'S', letter_S, codes_4_4_4
	},
	{
		'T', letter_T, codes_3_3_3
	},
	{
		'U', letter_U, codes_0_X_X
	},
	{
		'V', NULL, codes_7_7_7
	},
	{
		'W', NULL, codes_7_7_7
	},
	{
		'X', NULL, codes_5_54_54
	},
	{
		'Y', NULL, codes_1_X_X
	},
	{
		'Z', letter_Z, codes_4_4_4
	},
	{
		'a', NULL, codes_X_X_6_or_X_X_X
	},
	{
		'e', NULL, codes_X_X_6_or_X_X_X
	},
	{
		't', NULL, codes_3_3_3_or_4_4_4
	},
	{
		'\0'
	}
};
