/*
 * This file was generated automatically by ExtUtils::ParseXS version 3.57 from the
 * contents of interrupts.xxs. Do not edit this file, edit interrupts.xxs instead.
 *
 *    ANY CHANGES MADE HERE WILL BE LOST!
 *
 */

#line 1 "/build/polymake/src/polymake-4.15/lib/core/src/perl/interrupts.xxs"
/* Copyright (c) 1997-2024
   Ewgenij Gawrilow, Michael Joswig, and the polymake team
   Technische Universität Berlin, Germany
   https://polymake.org

   This program is free software; you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by the
   Free Software Foundation; either version 2, or (at your option) any
   later version: http://www.gnu.org/licenses/gpl.txt.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
--------------------------------------------------------------------------------
*/

#include "polymake/perl/Ext.h"
#include <signal.h>
#include <errno.h>
#include <unistd.h>

namespace pm { namespace perl { namespace glue {

namespace {

SV* state = nullptr;
SV* handler = nullptr;
SV* safe_interrupt_cv = nullptr;
int interrupt_signum = 0;

bool must_reset_state = false;

void prepare_safe_interrupt(pTHX)
{
   if (PL_psig_pend[SIGINT] == 0) {
      PL_psig_pend[SIGINT] = 1;
      ++PL_sig_pending;
      SvREFCNT_dec(PL_psig_ptr[SIGINT]);
      PL_psig_ptr[SIGINT] = SvREFCNT_inc_simple_NN(safe_interrupt_cv);
   }
}

int reset_state(pTHX_ SV* sv, MAGIC* mg)
{
   sv_setiv(state, 0);
   PL_tmps_stack[++PL_tmps_ix] = mg->mg_obj;
   return 0;
}

int handle_deferred(pTHX_ SV* sv, MAGIC* mg)
{
   prepare_safe_interrupt(aTHX);
   return 0;
}

const MGVTBL reset_state_vtbl = { nullptr, nullptr, nullptr, nullptr, &reset_state };

const MGVTBL handle_deferred_vtbl = { nullptr, nullptr, nullptr, nullptr, &handle_deferred };

#if (PerlVersion < 5310 ? defined(HAS_SIGACTION) && defined(SA_SIGINFO) : defined(PERL_USE_3ARG_SIGHANDLER))
#  define PmCallPerl_sighandler(sig) Perl_csighandler(sig, nullptr, nullptr)
#else
#  define PmCallPerl_sighandler(sig) Perl_csighandler(sig)
#endif

void interrupt_handler(int)
{
   dTHX;
   // repeated signal while still processing the first one
   if (SvIVX(state) != 0) return;
   if (PL_curstackinfo->si_prev || cxstack_ix >= 0 && PL_tmps_ix >= 0) {
      // we are deep enough within the perl code
      if (SvROK(handler)) {
         if (SvTYPE(SvRV(handler)) == SVt_PVCV) {
            // execute the handler immediately
            SvREFCNT_dec(PL_psig_ptr[SIGINT]);
            PL_psig_ptr[SIGINT] = SvREFCNT_inc_simple_NN(handler);
            PmCallPerl_sighandler(SIGINT);
         } else {
            // set the interrupt flag, do nothing else
            sv_setiv(SvRV(handler), 1);
         }
      } else if (SvOK(handler)) {
         if (SvTRUE(handler)) {
            // interrupts are blocked, prepare for deferred handling
            if (SvTYPE(handler) < SVt_PVMG)
               sv_magicext(handler, nullptr, PERL_MAGIC_ext, &handle_deferred_vtbl, nullptr, 0);
         }
         // else: disabled altogether
      } else {
         // default case: break at the next OP
         prepare_safe_interrupt(aTHX);
         // kill child processes started via 'open pipes'
         if (PL_fdpid && AvFILLp(PL_fdpid) >= 0) {
            for (SV **pidp = AvARRAY(PL_fdpid), **last = pidp + AvFILLp(PL_fdpid);  pidp <= last;  ++pidp) {
               SV* pidsv = *pidp;
               pid_t child_pid;
               if (pidsv && SvTYPE(pidsv) == SVt_IV && (child_pid = pid_t(SvIVX(pidsv))) > 0)
                  kill(child_pid, SIGINT);
            }
         }
      }
   }
}

OP* pp_local_set_handler(pTHX)
{
   dSP;
   dPOPss;
   ops::localize_scalar(aTHX_ handler, sv);
   RETURN;
}

OP* pp_set_handler(pTHX)
{
   dSP;
   dPOPss;
   sv_setsv(handler, sv);
   RETURN;
}

}

void set_interrupt_signal(pTHX_ int signum, bool must_reset_state_arg)
{
   if (signum <= 0 || signum >= SIG_SIZE)
      Perl_croak(aTHX_ "set_interrupt_signal: invalid signal number %d\n", signum);
   must_reset_state = must_reset_state_arg;
   if (interrupt_signum == signum)
      return;
   reset_interrupt_signal();
   struct sigaction sa;
   sa.sa_handler = interrupt_handler;
   sa.sa_flags = 0;
   sigemptyset(&sa.sa_mask);
   sigaddset(&sa.sa_mask, SIGINT);
   sigaddset(&sa.sa_mask, SIGQUIT);
   sigaddset(&sa.sa_mask, SIGALRM);
   sigaddset(&sa.sa_mask, SIGPIPE);
   if (sigaction(signum, &sa, nullptr) < 0)
      Perl_croak(aTHX_ "set_interrupt_signal: sigaction failed: %d\n", errno);
   interrupt_signum = signum;
}

void reset_interrupt_signal()
{
   if (interrupt_signum != 0) {
      struct sigaction sa;
      sa.sa_handler = SIG_DFL;
      sa.sa_flags = 0;
      sigaction(interrupt_signum, &sa, nullptr);
      interrupt_signum = 0;
   }
}

int parse_interrupts_op(pTHX_ const bool localize, OP** op_ptr)
{
   OP* value_op = parse_expression_in_parens(aTHX);
   if (!value_op) {
      report_parse_error(localize ? "expected: local interrupts(EXPR);" : "expected: interrupts(EXPR);");
      return KEYWORD_PLUGIN_DECLINE;
   }
   if (value_op->op_type == OP_CONST) {
      SV* sv = cSVOPx_sv(value_op);
      SV* new_value = nullptr;
      if (SvPOK(sv)) {
         switch (SvCUR(sv)) {
         case 0:
            new_value = sv;  // false = disable
            break;
         case 1:
            if (*SvPVX(sv) == '1')
               new_value = &PL_sv_undef;     // true = enable
            break;
         case 5:
            if (!strncmp(SvPVX(sv), "block", 5))
               new_value = &PL_sv_yes;
            break;
         case 6:
            if (!strncmp(SvPVX(sv), "enable", 6))
               new_value = &PL_sv_undef;
            break;
         case 7:
            if (!strncmp(SvPVX(sv), "disable", 7))
               new_value = &PL_sv_no;
            break;
         }
      }
      op_free(value_op);
      if (!new_value) {
         report_parse_error("invalid interrupts operation; expected \"enable\", \"disable\", \"block\", or a bolean constant");
         return KEYWORD_PLUGIN_DECLINE;
      }
      value_op = newSVOP(OP_CONST, 0, new_value);
   }
   OP* set_op = newUNOP(OP_NULL, 0, op_scalar_context(value_op));
   set_op->op_type = OP_CUSTOM;
   set_op->op_ppaddr = localize ? pp_local_set_handler : pp_set_handler;
   *op_ptr = set_op;
   return KEYWORD_PLUGIN_EXPR;
}

} } }

using namespace pm::perl::glue;

#line 218 "/build/polymake/src/polymake-4.15/build/perlx/5.42.0/x86_64-linux-thread-multi/interrupts.cc"
#ifndef PERL_UNUSED_VAR
#  define PERL_UNUSED_VAR(var) if (0) var = var
#endif

#ifndef dVAR
#  define dVAR		dNOOP
#endif


/* This stuff is not part of the API! You have been warned. */
#ifndef PERL_VERSION_DECIMAL
#  define PERL_VERSION_DECIMAL(r,v,s) (r*1000000 + v*1000 + s)
#endif
#ifndef PERL_DECIMAL_VERSION
#  define PERL_DECIMAL_VERSION \
	  PERL_VERSION_DECIMAL(PERL_REVISION,PERL_VERSION,PERL_SUBVERSION)
#endif
#ifndef PERL_VERSION_GE
#  define PERL_VERSION_GE(r,v,s) \
	  (PERL_DECIMAL_VERSION >= PERL_VERSION_DECIMAL(r,v,s))
#endif
#ifndef PERL_VERSION_LE
#  define PERL_VERSION_LE(r,v,s) \
	  (PERL_DECIMAL_VERSION <= PERL_VERSION_DECIMAL(r,v,s))
#endif

/* XS_INTERNAL is the explicit static-linkage variant of the default
 * XS macro.
 *
 * XS_EXTERNAL is the same as XS_INTERNAL except it does not include
 * "STATIC", ie. it exports XSUB symbols. You probably don't want that
 * for anything but the BOOT XSUB.
 *
 * See XSUB.h in core!
 */


/* TODO: This might be compatible further back than 5.10.0. */
#if PERL_VERSION_GE(5, 10, 0) && PERL_VERSION_LE(5, 15, 1)
#  undef XS_EXTERNAL
#  undef XS_INTERNAL
#  if defined(__CYGWIN__) && defined(USE_DYNAMIC_LOADING)
#    define XS_EXTERNAL(name) __declspec(dllexport) XSPROTO(name)
#    define XS_INTERNAL(name) STATIC XSPROTO(name)
#  endif
#  if defined(__SYMBIAN32__)
#    define XS_EXTERNAL(name) EXPORT_C XSPROTO(name)
#    define XS_INTERNAL(name) EXPORT_C STATIC XSPROTO(name)
#  endif
#  ifndef XS_EXTERNAL
#    if defined(HASATTRIBUTE_UNUSED) && !defined(__cplusplus)
#      define XS_EXTERNAL(name) void name(pTHX_ CV* cv __attribute__unused__)
#      define XS_INTERNAL(name) STATIC void name(pTHX_ CV* cv __attribute__unused__)
#    else
#      ifdef __cplusplus
#        define XS_EXTERNAL(name) extern "C" XSPROTO(name)
#        define XS_INTERNAL(name) static XSPROTO(name)
#      else
#        define XS_EXTERNAL(name) XSPROTO(name)
#        define XS_INTERNAL(name) STATIC XSPROTO(name)
#      endif
#    endif
#  endif
#endif

/* perl >= 5.10.0 && perl <= 5.15.1 */


/* The XS_EXTERNAL macro is used for functions that must not be static
 * like the boot XSUB of a module. If perl didn't have an XS_EXTERNAL
 * macro defined, the best we can do is assume XS is the same.
 * Dito for XS_INTERNAL.
 */
#ifndef XS_EXTERNAL
#  define XS_EXTERNAL(name) XS(name)
#endif
#ifndef XS_INTERNAL
#  define XS_INTERNAL(name) XS(name)
#endif

/* Now, finally, after all this mess, we want an ExtUtils::ParseXS
 * internal macro that we're free to redefine for varying linkage due
 * to the EXPORT_XSUB_SYMBOLS XS keyword. This is internal, use
 * XS_EXTERNAL(name) or XS_INTERNAL(name) in your code if you need to!
 */

#undef XS_EUPXS
#if defined(PERL_EUPXS_ALWAYS_EXPORT)
#  define XS_EUPXS(name) XS_EXTERNAL(name)
#else
   /* default to internal */
#  define XS_EUPXS(name) XS_INTERNAL(name)
#endif

#ifndef PERL_ARGS_ASSERT_CROAK_XS_USAGE
#define PERL_ARGS_ASSERT_CROAK_XS_USAGE assert(cv); assert(params)

/* prototype to pass -Wmissing-prototypes */
STATIC void
S_croak_xs_usage(const CV *const cv, const char *const params);

STATIC void
S_croak_xs_usage(const CV *const cv, const char *const params)
{
    const GV *const gv = CvGV(cv);

    PERL_ARGS_ASSERT_CROAK_XS_USAGE;

    if (gv) {
        const char *const gvname = GvNAME(gv);
        const HV *const stash = GvSTASH(gv);
        const char *const hvname = stash ? HvNAME(stash) : NULL;

        if (hvname)
	    Perl_croak_nocontext("Usage: %s::%s(%s)", hvname, gvname, params);
        else
	    Perl_croak_nocontext("Usage: %s(%s)", gvname, params);
    } else {
        /* Pants. I don't think that it should be possible to get here. */
	Perl_croak_nocontext("Usage: CODE(0x%" UVxf ")(%s)", PTR2UV(cv), params);
    }
}
#undef  PERL_ARGS_ASSERT_CROAK_XS_USAGE

#define croak_xs_usage        S_croak_xs_usage

#endif

/* NOTE: the prototype of newXSproto() is different in versions of perls,
 * so we define a portable version of newXSproto()
 */
#ifdef newXS_flags
#define newXSproto_portable(name, c_impl, file, proto) newXS_flags(name, c_impl, file, proto, 0)
#else
#define newXSproto_portable(name, c_impl, file, proto) (PL_Sv=(SV*)newXS(name, c_impl, file), sv_setpv(PL_Sv, proto), (CV*)PL_Sv)
#endif /* !defined(newXS_flags) */

#if PERL_VERSION_LE(5, 21, 5)
#  define newXS_deffile(a,b) Perl_newXS(aTHX_ a,b,file)
#else
#  define newXS_deffile(a,b) Perl_newXS_deffile(aTHX_ a,b)
#endif

/* simple backcompat versions of the TARGx() macros with no optimisation */
#ifndef TARGi
#  define TARGi(iv, do_taint) sv_setiv_mg(TARG, iv)
#  define TARGu(uv, do_taint) sv_setuv_mg(TARG, uv)
#  define TARGn(nv, do_taint) sv_setnv_mg(TARG, nv)
#endif

#line 369 "/build/polymake/src/polymake-4.15/build/perlx/5.42.0/x86_64-linux-thread-multi/interrupts.cc"

XS_EUPXS(XS_Polymake__Interrupts_safe_interrupt); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Polymake__Interrupts_safe_interrupt)
{
    dVAR; dXSARGS;
    PERL_UNUSED_VAR(cv); /* -W */
    PERL_UNUSED_VAR(items); /* -W */
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
#line 214 "/build/polymake/src/polymake-4.15/lib/core/src/perl/interrupts.xxs"
{
   sv_setiv(state, 1);
   if (must_reset_state) {
      // In a callable library setup, there is no unique place where the state flag could be reset
      // because there are many entry points into the library.
      // We capture the very first temporary variable slot for this cleanup.
      SV* some_temp = PL_tmps_stack[0];
      SV* reset_sv = newSV_type(SVt_PVMG);
      sv_magicext(reset_sv, some_temp, PERL_MAGIC_ext, &reset_state_vtbl, nullptr, 0);
      SvTEMP_on(reset_sv);
      PL_tmps_stack[0] = reset_sv;
   }
   Perl_croak(aTHX_ "Interrupted\n");
}
#line 395 "/build/polymake/src/polymake-4.15/build/perlx/5.42.0/x86_64-linux-thread-multi/interrupts.cc"
	PUTBACK;
	return;
    }
}


XS_EUPXS(XS_Polymake__Interrupts_install_handler); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Polymake__Interrupts_install_handler)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
#line 231 "/build/polymake/src/polymake-4.15/lib/core/src/perl/interrupts.xxs"
{
   set_interrupt_signal(aTHX_ SIGINT, false);
}
#line 415 "/build/polymake/src/polymake-4.15/build/perlx/5.42.0/x86_64-linux-thread-multi/interrupts.cc"
	PUTBACK;
	return;
    }
}

#ifdef __cplusplus
extern "C" {
#endif
XS_EXTERNAL(boot_Polymake__Interrupts); /* prototype to pass -Wmissing-prototypes */
XS_EXTERNAL(boot_Polymake__Interrupts)
{
#if PERL_VERSION_LE(5, 21, 5)
    dVAR; dXSARGS;
#else
    dVAR; dXSBOOTARGSXSAPIVERCHK;
#endif
#if PERL_VERSION_LE(5, 8, 999) /* PERL_VERSION_LT is 5.33+ */
    char* file = __FILE__;
#else
    const char* file = __FILE__;
#endif

    PERL_UNUSED_VAR(file);

    PERL_UNUSED_VAR(cv); /* -W */
    PERL_UNUSED_VAR(items); /* -W */
#if PERL_VERSION_LE(5, 21, 5)
    XS_VERSION_BOOTCHECK;
#  ifdef XS_APIVERSION_BOOTCHECK
    XS_APIVERSION_BOOTCHECK;
#  endif
#endif

        newXS_deffile("Polymake::Interrupts::safe_interrupt", XS_Polymake__Interrupts_safe_interrupt);
        newXS_deffile("Polymake::Interrupts::install_handler", XS_Polymake__Interrupts_install_handler);

    /* Initialisation Section */

#line 236 "/build/polymake/src/polymake-4.15/lib/core/src/perl/interrupts.xxs"
{
   state = GvSV(get_named_variable(aTHX_ "Polymake::Interrupts::state", SVt_PV));
   handler = newSV(0);
   safe_interrupt_cv = newRV((SV*)get_cv("Polymake::Interrupts::safe_interrupt", 0));
   if (PL_DBgv) {
      CvNODEBUG_on(SvRV(safe_interrupt_cv));
   }
}

#line 464 "/build/polymake/src/polymake-4.15/build/perlx/5.42.0/x86_64-linux-thread-multi/interrupts.cc"

    /* End of Initialisation Section */

#if PERL_VERSION_LE(5, 21, 5)
#  if PERL_VERSION_GE(5, 9, 0)
    if (PL_unitcheckav)
        call_list(PL_scopestack_ix, PL_unitcheckav);
#  endif
    XSRETURN_YES;
#else
    Perl_xs_boot_epilog(aTHX_ ax);
#endif
}

#ifdef __cplusplus
}
#endif
