/* A Bison parser, made by GNU Bison 3.8.2.  */

/* Bison implementation for Yacc-like parsers in C

   Copyright (C) 1984, 1989-1990, 2000-2015, 2018-2021 Free Software Foundation,
   Inc.

   This program is free software: you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <https://www.gnu.org/licenses/>.  */

/* As a special exception, you may create a larger work that contains
   part or all of the Bison parser skeleton and distribute that work
   under terms of your choice, so long as that work isn't itself a
   parser generator using the skeleton or a modified version thereof
   as a parser skeleton.  Alternatively, if you modify or redistribute
   the parser skeleton itself, you may (at your option) remove this
   special exception, which will cause the skeleton and the resulting
   Bison output files to be licensed under the GNU General Public
   License without this special exception.

   This special exception was added by the Free Software Foundation in
   version 2.2 of Bison.  */

/* C LALR(1) parser skeleton written by Richard Stallman, by
   simplifying the original so-called "semantic" parser.  */

/* DO NOT RELY ON FEATURES THAT ARE NOT DOCUMENTED in the manual,
   especially those whose name start with YY_ or yy_.  They are
   private implementation details that can be changed or removed.  */

/* All symbols defined below should begin with yy or YY, to avoid
   infringing on user name space.  This should be done even for local
   variables, as they might otherwise be expanded by user macros.
   There are some unavoidable exceptions within include files to
   define necessary library symbols; they are noted "INFRINGES ON
   USER NAME SPACE" below.  */

/* Identify Bison output, and Bison version.  */
#define YYBISON 30802

/* Bison version string.  */
#define YYBISON_VERSION "3.8.2"

/* Skeleton name.  */
#define YYSKELETON_NAME "yacc.c"

/* Pure parsers.  */
#define YYPURE 0

/* Push parsers.  */
#define YYPUSH 0

/* Pull parsers.  */
#define YYPULL 1




/* First part of user prologue.  */
#line 79 "cfg.y"


#include <stdlib.h>
#include <stdio.h>
#include <sys/socket.h>
#include <unistd.h>
#include <netinet/in.h>
#include <netinet/in_systm.h>
#include <netinet/ip.h>
#include <arpa/inet.h>
#include <string.h>
#include <errno.h>
#include "route_struct.h"
#include "globals.h"
#include "route.h"
#include "dprint.h"
#include "cfg_pp.h"
#include "sr_module.h"
#include "modparam.h"
#include "ip_addr.h"
#include "resolve.h"
#include "socket_info.h"
#include "name_alias.h"
#include "ut.h"
#include "pt_scaling.h"
#include "dset.h"
#include "pvar.h"
#include "blacklists.h"
#include "xlog.h"
#include "db/db_insertq.h"
#include "bin_interface.h"
#include "net/trans.h"
#include "config.h"
#include "mem/rpm_mem.h"
#include "poll_types.h"

#ifdef SHM_EXTRA_STATS
#include "mem/module_info.h"
#endif

#ifdef DEBUG_DMALLOC
#include <dmalloc.h>
#endif

/* hack to avoid alloca usage in the generated C file (needed for compiler
 with no built in alloca, like icc*/
#undef _ALLOCA_H

#undef MIN
#undef MAX

extern int yylex();
static void yyerror(char* s);
static void yyerrorf(char* fmt, ...);
static char* tmp;
static int i_tmp, rc;
static struct socket_id* lst_tmp;
static int rt;  /* Type of route block for find_export */
static str s_tmp;
static str tstr;
static struct net* net_tmp;
static pv_spec_t *spec;
static pv_elem_t *elem;
static struct bl_rule *bl_head = 0;
static struct bl_rule *bl_tail = 0;
static struct script_route_ref *rt_ref = NULL;

action_elem_t elems[MAX_ACTION_ELEMS];
static action_elem_t route_elems[MAX_ACTION_ELEMS];
action_elem_t *a_tmp;

struct port_range {
	int min;
	int max;
	struct port_range *next;
} *pr_tmp;
static struct script_return_param sr_tmp;

static inline void warn(char* s);
static struct socket_id* mk_listen_id(char*, enum sip_protos, int);
static struct socket_id* mk_listen_id_range(char*, enum sip_protos, struct port_range *);
static struct socket_id* set_listen_id_adv(struct socket_id *, char *, int);
static struct multi_str *new_string(char *s);
static struct port_range* mk_port_range(int, int);
static int parse_ipnet(char *in, int len, struct net **ipnet);
static struct script_return_param *mk_script_return(enum script_return_type type)
{
	struct script_return_param *param = pkg_malloc(sizeof *param);
	if (!param)
		return NULL;
	*param = sr_tmp;
	param->type = type;
	param->next = NULL;
	return param;
}

extern int line;
extern int column;
extern int startcolumn;
extern char *finame;

struct listen_param {
	enum si_flags flags;
	int workers;
	int tos;
	struct socket_id *socket;
	char *tag;
	char *auto_scaling_profile;
} p_tmp;
static void fill_socket_id(struct listen_param *param, struct socket_id *s);

union route_name_var {
	int iname;
	struct _pv_spec *sname;
	struct _pv_elem *ename;
	void *data;
} rn_tmp;

#ifndef SHM_EXTRA_STATS
struct multi_str{
	char *s;
	struct multi_str* next;
};
#else
static struct multi_str *tmp_mod;
#endif

#define get_cfg_file_name \
	((finame) ? finame : cfg_file ? cfg_file : "default")

#define si_subdomain_to_alias_flag(_flags) (int) _flags & SI_ACCEPT_SUBDOMAIN_ALIAS

#define mk_action_(_res, _type, _no, _elems) \
	do { \
		_res = mk_action(_type, _no, _elems, line, get_cfg_file_name); \
	} while(0)
#define mk_action0(_res, _type) \
	do { \
		_res = mk_action(_type, 0, 0, line, get_cfg_file_name); \
	} while(0)
#define mk_action1(_res, _type, _p1_type, _p1) \
	do { \
		elems[0].type = _p1_type; \
		elems[0].u.data = _p1; \
		_res = mk_action(_type, 1, elems, line, get_cfg_file_name); \
	} while(0)
#define	mk_action2(_res, _type, _p1_type, _p2_type, _p1, _p2) \
	do { \
		elems[0].type = _p1_type; \
		elems[0].u.data = _p1; \
		elems[1].type = _p2_type; \
		elems[1].u.data = _p2; \
		_res = mk_action(_type, 2, elems, line, get_cfg_file_name); \
	} while(0)
#define mk_action3(_res, _type, _p1_type, _p2_type, _p3_type, _p1, _p2, _p3) \
	do { \
		elems[0].type = _p1_type; \
		elems[0].u.data = _p1; \
		elems[1].type = _p2_type; \
		elems[1].u.data = _p2; \
		elems[2].type = _p3_type; \
		elems[2].u.data = _p3; \
		_res = mk_action(_type, 3, elems, line, get_cfg_file_name); \
	} while(0)

extern int cfg_parse_only_routes;
#define IFOR(_instr) \
	if (cfg_parse_only_routes==1) {_instr;break;}


#line 242 "cfg.tab.c"

# ifndef YY_CAST
#  ifdef __cplusplus
#   define YY_CAST(Type, Val) static_cast<Type> (Val)
#   define YY_REINTERPRET_CAST(Type, Val) reinterpret_cast<Type> (Val)
#  else
#   define YY_CAST(Type, Val) ((Type) (Val))
#   define YY_REINTERPRET_CAST(Type, Val) ((Type) (Val))
#  endif
# endif
# ifndef YY_NULLPTR
#  if defined __cplusplus
#   if 201103L <= __cplusplus
#    define YY_NULLPTR nullptr
#   else
#    define YY_NULLPTR 0
#   endif
#  else
#   define YY_NULLPTR ((void*)0)
#  endif
# endif

#include "cfg.tab.h"
/* Symbol kind.  */
enum yysymbol_kind_t
{
  YYSYMBOL_YYEMPTY = -2,
  YYSYMBOL_YYEOF = 0,                      /* "end of file"  */
  YYSYMBOL_YYerror = 1,                    /* error  */
  YYSYMBOL_YYUNDEF = 2,                    /* "invalid token"  */
  YYSYMBOL_DROP = 3,                       /* DROP  */
  YYSYMBOL_ASSERT = 4,                     /* ASSERT  */
  YYSYMBOL_EXIT = 5,                       /* EXIT  */
  YYSYMBOL_RETURN = 6,                     /* RETURN  */
  YYSYMBOL_LOG_TOK = 7,                    /* LOG_TOK  */
  YYSYMBOL_ERROR = 8,                      /* ERROR  */
  YYSYMBOL_ROUTE = 9,                      /* ROUTE  */
  YYSYMBOL_ROUTE_FAILURE = 10,             /* ROUTE_FAILURE  */
  YYSYMBOL_ROUTE_ONREPLY = 11,             /* ROUTE_ONREPLY  */
  YYSYMBOL_ROUTE_BRANCH = 12,              /* ROUTE_BRANCH  */
  YYSYMBOL_ROUTE_ERROR = 13,               /* ROUTE_ERROR  */
  YYSYMBOL_ROUTE_LOCAL = 14,               /* ROUTE_LOCAL  */
  YYSYMBOL_ROUTE_STARTUP = 15,             /* ROUTE_STARTUP  */
  YYSYMBOL_ROUTE_TIMER = 16,               /* ROUTE_TIMER  */
  YYSYMBOL_ROUTE_EVENT = 17,               /* ROUTE_EVENT  */
  YYSYMBOL_IF = 18,                        /* IF  */
  YYSYMBOL_ELSE = 19,                      /* ELSE  */
  YYSYMBOL_SWITCH = 20,                    /* SWITCH  */
  YYSYMBOL_CASE = 21,                      /* CASE  */
  YYSYMBOL_DEFAULT = 22,                   /* DEFAULT  */
  YYSYMBOL_BREAK = 23,                     /* BREAK  */
  YYSYMBOL_WHILE = 24,                     /* WHILE  */
  YYSYMBOL_FOR = 25,                       /* FOR  */
  YYSYMBOL_IN = 26,                        /* IN  */
  YYSYMBOL_READONLY = 27,                  /* READONLY  */
  YYSYMBOL_EXPIRE = 28,                    /* EXPIRE  */
  YYSYMBOL_NULLV = 29,                     /* NULLV  */
  YYSYMBOL_XDBG = 30,                      /* XDBG  */
  YYSYMBOL_XLOG = 31,                      /* XLOG  */
  YYSYMBOL_XLOG_BUF_SIZE = 32,             /* XLOG_BUF_SIZE  */
  YYSYMBOL_XLOG_FORCE_COLOR = 33,          /* XLOG_FORCE_COLOR  */
  YYSYMBOL_XLOG_PRINT_LEVEL = 34,          /* XLOG_PRINT_LEVEL  */
  YYSYMBOL_XLOG_LEVEL = 35,                /* XLOG_LEVEL  */
  YYSYMBOL_PV_PRINT_BUF_SIZE = 36,         /* PV_PRINT_BUF_SIZE  */
  YYSYMBOL_DEBUG_MODE = 37,                /* DEBUG_MODE  */
  YYSYMBOL_ENABLE_ASSERTS = 38,            /* ENABLE_ASSERTS  */
  YYSYMBOL_ABORT_ON_ASSERT = 39,           /* ABORT_ON_ASSERT  */
  YYSYMBOL_LOGLEVEL = 40,                  /* LOGLEVEL  */
  YYSYMBOL_LOGPREFIX = 41,                 /* LOGPREFIX  */
  YYSYMBOL_LOGSTDOUT = 42,                 /* LOGSTDOUT  */
  YYSYMBOL_LOGSTDERROR = 43,               /* LOGSTDERROR  */
  YYSYMBOL_STDERROR_ENABLED = 44,          /* STDERROR_ENABLED  */
  YYSYMBOL_SYSLOG_ENABLED = 45,            /* SYSLOG_ENABLED  */
  YYSYMBOL_LOG_EVENT_ENABLED = 46,         /* LOG_EVENT_ENABLED  */
  YYSYMBOL_STDERROR_LEVEL_FILTER = 47,     /* STDERROR_LEVEL_FILTER  */
  YYSYMBOL_SYSLOG_LEVEL_FILTER = 48,       /* SYSLOG_LEVEL_FILTER  */
  YYSYMBOL_LOG_EVENT_LEVEL_FILTER = 49,    /* LOG_EVENT_LEVEL_FILTER  */
  YYSYMBOL_STDERROR_FORMAT = 50,           /* STDERROR_FORMAT  */
  YYSYMBOL_SYSLOG_FORMAT = 51,             /* SYSLOG_FORMAT  */
  YYSYMBOL_LOG_JSON_BUF_SIZE = 52,         /* LOG_JSON_BUF_SIZE  */
  YYSYMBOL_LOG_MSG_BUF_SIZE = 53,          /* LOG_MSG_BUF_SIZE  */
  YYSYMBOL_LOGFACILITY = 54,               /* LOGFACILITY  */
  YYSYMBOL_SYSLOG_FACILITY = 55,           /* SYSLOG_FACILITY  */
  YYSYMBOL_LOGNAME = 56,                   /* LOGNAME  */
  YYSYMBOL_SYSLOG_NAME = 57,               /* SYSLOG_NAME  */
  YYSYMBOL_AVP_ALIASES = 58,               /* AVP_ALIASES  */
  YYSYMBOL_LISTEN = 59,                    /* LISTEN  */
  YYSYMBOL_SOCKET = 60,                    /* SOCKET  */
  YYSYMBOL_MEMGROUP = 61,                  /* MEMGROUP  */
  YYSYMBOL_ALIAS = 62,                     /* ALIAS  */
  YYSYMBOL_AUTO_ALIASES = 63,              /* AUTO_ALIASES  */
  YYSYMBOL_TAG = 64,                       /* TAG  */
  YYSYMBOL_DNS = 65,                       /* DNS  */
  YYSYMBOL_REV_DNS = 66,                   /* REV_DNS  */
  YYSYMBOL_DNS_TRY_IPV6 = 67,              /* DNS_TRY_IPV6  */
  YYSYMBOL_DNS_TRY_NAPTR = 68,             /* DNS_TRY_NAPTR  */
  YYSYMBOL_DNS_RETR_TIME = 69,             /* DNS_RETR_TIME  */
  YYSYMBOL_DNS_RETR_NO = 70,               /* DNS_RETR_NO  */
  YYSYMBOL_DNS_SERVERS_NO = 71,            /* DNS_SERVERS_NO  */
  YYSYMBOL_DNS_USE_SEARCH = 72,            /* DNS_USE_SEARCH  */
  YYSYMBOL_MAX_WHILE_LOOPS = 73,           /* MAX_WHILE_LOOPS  */
  YYSYMBOL_UDP_WORKERS = 74,               /* UDP_WORKERS  */
  YYSYMBOL_CHECK_VIA = 75,                 /* CHECK_VIA  */
  YYSYMBOL_SHM_HASH_SPLIT_PERCENTAGE = 76, /* SHM_HASH_SPLIT_PERCENTAGE  */
  YYSYMBOL_SHM_SECONDARY_HASH_SIZE = 77,   /* SHM_SECONDARY_HASH_SIZE  */
  YYSYMBOL_MEM_WARMING_ENABLED = 78,       /* MEM_WARMING_ENABLED  */
  YYSYMBOL_MEM_WARMING_PATTERN_FILE = 79,  /* MEM_WARMING_PATTERN_FILE  */
  YYSYMBOL_MEM_WARMING_PERCENTAGE = 80,    /* MEM_WARMING_PERCENTAGE  */
  YYSYMBOL_RPM_MEM_FILE = 81,              /* RPM_MEM_FILE  */
  YYSYMBOL_RPM_MEM_SIZE = 82,              /* RPM_MEM_SIZE  */
  YYSYMBOL_MEMLOG = 83,                    /* MEMLOG  */
  YYSYMBOL_MEMDUMP = 84,                   /* MEMDUMP  */
  YYSYMBOL_SHM_MEMLOG_SIZE = 85,           /* SHM_MEMLOG_SIZE  */
  YYSYMBOL_EXECMSGTHRESHOLD = 86,          /* EXECMSGTHRESHOLD  */
  YYSYMBOL_EXECDNSTHRESHOLD = 87,          /* EXECDNSTHRESHOLD  */
  YYSYMBOL_TCPTHRESHOLD = 88,              /* TCPTHRESHOLD  */
  YYSYMBOL_EVENT_SHM_THRESHOLD = 89,       /* EVENT_SHM_THRESHOLD  */
  YYSYMBOL_EVENT_PKG_THRESHOLD = 90,       /* EVENT_PKG_THRESHOLD  */
  YYSYMBOL_QUERYBUFFERSIZE = 91,           /* QUERYBUFFERSIZE  */
  YYSYMBOL_QUERYFLUSHTIME = 92,            /* QUERYFLUSHTIME  */
  YYSYMBOL_SIP_WARNING = 93,               /* SIP_WARNING  */
  YYSYMBOL_SERVER_SIGNATURE = 94,          /* SERVER_SIGNATURE  */
  YYSYMBOL_SERVER_HEADER = 95,             /* SERVER_HEADER  */
  YYSYMBOL_USER_AGENT_HEADER = 96,         /* USER_AGENT_HEADER  */
  YYSYMBOL_LOADMODULE = 97,                /* LOADMODULE  */
  YYSYMBOL_MPATH = 98,                     /* MPATH  */
  YYSYMBOL_MODPARAM = 99,                  /* MODPARAM  */
  YYSYMBOL_MAXBUFFER = 100,                /* MAXBUFFER  */
  YYSYMBOL_CHROOT = 101,                   /* CHROOT  */
  YYSYMBOL_WDIR = 102,                     /* WDIR  */
  YYSYMBOL_MHOMED = 103,                   /* MHOMED  */
  YYSYMBOL_POLL_METHOD = 104,              /* POLL_METHOD  */
  YYSYMBOL_TCP_ACCEPT_ALIASES = 105,       /* TCP_ACCEPT_ALIASES  */
  YYSYMBOL_TCP_WORKERS = 106,              /* TCP_WORKERS  */
  YYSYMBOL_TCP_CONNECT_TIMEOUT = 107,      /* TCP_CONNECT_TIMEOUT  */
  YYSYMBOL_TCP_CON_LIFETIME = 108,         /* TCP_CON_LIFETIME  */
  YYSYMBOL_TCP_SOCKET_BACKLOG = 109,       /* TCP_SOCKET_BACKLOG  */
  YYSYMBOL_TCP_MAX_CONNECTIONS = 110,      /* TCP_MAX_CONNECTIONS  */
  YYSYMBOL_TCP_NO_NEW_CONN_BFLAG = 111,    /* TCP_NO_NEW_CONN_BFLAG  */
  YYSYMBOL_TCP_NO_NEW_CONN_RPLFLAG = 112,  /* TCP_NO_NEW_CONN_RPLFLAG  */
  YYSYMBOL_TCP_KEEPALIVE = 113,            /* TCP_KEEPALIVE  */
  YYSYMBOL_TCP_KEEPCOUNT = 114,            /* TCP_KEEPCOUNT  */
  YYSYMBOL_TCP_KEEPIDLE = 115,             /* TCP_KEEPIDLE  */
  YYSYMBOL_TCP_KEEPINTERVAL = 116,         /* TCP_KEEPINTERVAL  */
  YYSYMBOL_TCP_MAX_MSG_TIME = 117,         /* TCP_MAX_MSG_TIME  */
  YYSYMBOL_TCP_PARALLEL_READ_ON_WORKERS = 118, /* TCP_PARALLEL_READ_ON_WORKERS  */
  YYSYMBOL_ADVERTISED_ADDRESS = 119,       /* ADVERTISED_ADDRESS  */
  YYSYMBOL_ADVERTISED_PORT = 120,          /* ADVERTISED_PORT  */
  YYSYMBOL_DISABLE_CORE = 121,             /* DISABLE_CORE  */
  YYSYMBOL_OPEN_FD_LIMIT = 122,            /* OPEN_FD_LIMIT  */
  YYSYMBOL_MCAST_LOOPBACK = 123,           /* MCAST_LOOPBACK  */
  YYSYMBOL_MCAST_TTL = 124,                /* MCAST_TTL  */
  YYSYMBOL_TOS = 125,                      /* TOS  */
  YYSYMBOL_DISABLE_DNS_FAILOVER = 126,     /* DISABLE_DNS_FAILOVER  */
  YYSYMBOL_DISABLE_DNS_BLACKLIST = 127,    /* DISABLE_DNS_BLACKLIST  */
  YYSYMBOL_DST_BLACKLIST = 128,            /* DST_BLACKLIST  */
  YYSYMBOL_DISABLE_STATELESS_FWD = 129,    /* DISABLE_STATELESS_FWD  */
  YYSYMBOL_DB_VERSION_TABLE = 130,         /* DB_VERSION_TABLE  */
  YYSYMBOL_DB_DEFAULT_URL = 131,           /* DB_DEFAULT_URL  */
  YYSYMBOL_DB_MAX_ASYNC_CONNECTIONS = 132, /* DB_MAX_ASYNC_CONNECTIONS  */
  YYSYMBOL_DISABLE_503_TRANSLATION = 133,  /* DISABLE_503_TRANSLATION  */
  YYSYMBOL_SYNC_TOKEN = 134,               /* SYNC_TOKEN  */
  YYSYMBOL_ASYNC_TOKEN = 135,              /* ASYNC_TOKEN  */
  YYSYMBOL_LAUNCH_TOKEN = 136,             /* LAUNCH_TOKEN  */
  YYSYMBOL_AUTO_SCALING_PROFILE = 137,     /* AUTO_SCALING_PROFILE  */
  YYSYMBOL_AUTO_SCALING_CYCLE = 138,       /* AUTO_SCALING_CYCLE  */
  YYSYMBOL_TIMER_WORKERS = 139,            /* TIMER_WORKERS  */
  YYSYMBOL_EQUAL = 140,                    /* EQUAL  */
  YYSYMBOL_EQUAL_T = 141,                  /* EQUAL_T  */
  YYSYMBOL_GT = 142,                       /* GT  */
  YYSYMBOL_LT = 143,                       /* LT  */
  YYSYMBOL_GTE = 144,                      /* GTE  */
  YYSYMBOL_LTE = 145,                      /* LTE  */
  YYSYMBOL_DIFF = 146,                     /* DIFF  */
  YYSYMBOL_MATCH = 147,                    /* MATCH  */
  YYSYMBOL_NOTMATCH = 148,                 /* NOTMATCH  */
  YYSYMBOL_COLONEQ = 149,                  /* COLONEQ  */
  YYSYMBOL_PLUSEQ = 150,                   /* PLUSEQ  */
  YYSYMBOL_MINUSEQ = 151,                  /* MINUSEQ  */
  YYSYMBOL_SLASHEQ = 152,                  /* SLASHEQ  */
  YYSYMBOL_MULTEQ = 153,                   /* MULTEQ  */
  YYSYMBOL_MODULOEQ = 154,                 /* MODULOEQ  */
  YYSYMBOL_BANDEQ = 155,                   /* BANDEQ  */
  YYSYMBOL_BOREQ = 156,                    /* BOREQ  */
  YYSYMBOL_BXOREQ = 157,                   /* BXOREQ  */
  YYSYMBOL_OR = 158,                       /* OR  */
  YYSYMBOL_AND = 159,                      /* AND  */
  YYSYMBOL_BOR = 160,                      /* BOR  */
  YYSYMBOL_BAND = 161,                     /* BAND  */
  YYSYMBOL_BXOR = 162,                     /* BXOR  */
  YYSYMBOL_BLSHIFT = 163,                  /* BLSHIFT  */
  YYSYMBOL_BRSHIFT = 164,                  /* BRSHIFT  */
  YYSYMBOL_PLUS = 165,                     /* PLUS  */
  YYSYMBOL_MINUS = 166,                    /* MINUS  */
  YYSYMBOL_MULT = 167,                     /* MULT  */
  YYSYMBOL_MODULO = 168,                   /* MODULO  */
  YYSYMBOL_NOT = 169,                      /* NOT  */
  YYSYMBOL_BNOT = 170,                     /* BNOT  */
  YYSYMBOL_NUMBER = 171,                   /* NUMBER  */
  YYSYMBOL_ZERO = 172,                     /* ZERO  */
  YYSYMBOL_ID = 173,                       /* ID  */
  YYSYMBOL_STRING = 174,                   /* STRING  */
  YYSYMBOL_SCRIPTVAR = 175,                /* SCRIPTVAR  */
  YYSYMBOL_IPV6ADDR = 176,                 /* IPV6ADDR  */
  YYSYMBOL_IPV4ADDR = 177,                 /* IPV4ADDR  */
  YYSYMBOL_IPNET = 178,                    /* IPNET  */
  YYSYMBOL_COMMA = 179,                    /* COMMA  */
  YYSYMBOL_SEMICOLON = 180,                /* SEMICOLON  */
  YYSYMBOL_RPAREN = 181,                   /* RPAREN  */
  YYSYMBOL_LPAREN = 182,                   /* LPAREN  */
  YYSYMBOL_LBRACE = 183,                   /* LBRACE  */
  YYSYMBOL_RBRACE = 184,                   /* RBRACE  */
  YYSYMBOL_LBRACK = 185,                   /* LBRACK  */
  YYSYMBOL_RBRACK = 186,                   /* RBRACK  */
  YYSYMBOL_SLASH = 187,                    /* SLASH  */
  YYSYMBOL_AS = 188,                       /* AS  */
  YYSYMBOL_USE_WORKERS = 189,              /* USE_WORKERS  */
  YYSYMBOL_SOCK_TOS = 190,                 /* SOCK_TOS  */
  YYSYMBOL_USE_AUTO_SCALING_PROFILE = 191, /* USE_AUTO_SCALING_PROFILE  */
  YYSYMBOL_MAX = 192,                      /* MAX  */
  YYSYMBOL_MIN = 193,                      /* MIN  */
  YYSYMBOL_DOT = 194,                      /* DOT  */
  YYSYMBOL_CR = 195,                       /* CR  */
  YYSYMBOL_COLON = 196,                    /* COLON  */
  YYSYMBOL_ANY = 197,                      /* ANY  */
  YYSYMBOL_ANYCAST = 198,                  /* ANYCAST  */
  YYSYMBOL_ACCEPT_SUBDOMAIN = 199,         /* ACCEPT_SUBDOMAIN  */
  YYSYMBOL_FRAG = 200,                     /* FRAG  */
  YYSYMBOL_REUSE_PORT = 201,               /* REUSE_PORT  */
  YYSYMBOL_SCRIPTVARERR = 202,             /* SCRIPTVARERR  */
  YYSYMBOL_SCALE_UP_TO = 203,              /* SCALE_UP_TO  */
  YYSYMBOL_SCALE_DOWN_TO = 204,            /* SCALE_DOWN_TO  */
  YYSYMBOL_ON = 205,                       /* ON  */
  YYSYMBOL_CYCLES = 206,                   /* CYCLES  */
  YYSYMBOL_CYCLES_WITHIN = 207,            /* CYCLES_WITHIN  */
  YYSYMBOL_PERCENTAGE = 208,               /* PERCENTAGE  */
  YYSYMBOL_YYACCEPT = 209,                 /* $accept  */
  YYSYMBOL_cfg = 210,                      /* cfg  */
  YYSYMBOL_statements = 211,               /* statements  */
  YYSYMBOL_statement = 212,                /* statement  */
  YYSYMBOL_213_1 = 213,                    /* $@1  */
  YYSYMBOL_214_2 = 214,                    /* $@2  */
  YYSYMBOL_215_3 = 215,                    /* $@3  */
  YYSYMBOL_216_4 = 216,                    /* $@4  */
  YYSYMBOL_217_5 = 217,                    /* $@5  */
  YYSYMBOL_218_6 = 218,                    /* $@6  */
  YYSYMBOL_219_7 = 219,                    /* $@7  */
  YYSYMBOL_220_8 = 220,                    /* $@8  */
  YYSYMBOL_221_9 = 221,                    /* $@9  */
  YYSYMBOL_listen_id = 222,                /* listen_id  */
  YYSYMBOL_host_sep = 223,                 /* host_sep  */
  YYSYMBOL_host = 224,                     /* host  */
  YYSYMBOL_proto = 225,                    /* proto  */
  YYSYMBOL_port = 226,                     /* port  */
  YYSYMBOL_portrange = 227,                /* portrange  */
  YYSYMBOL_snumber = 228,                  /* snumber  */
  YYSYMBOL_phostport = 229,                /* phostport  */
  YYSYMBOL_phostportrange = 230,           /* phostportrange  */
  YYSYMBOL_any_alias = 231,                /* any_alias  */
  YYSYMBOL_alias_def = 232,                /* alias_def  */
  YYSYMBOL_id_lst = 233,                   /* id_lst  */
  YYSYMBOL_listen_id_def = 234,            /* listen_id_def  */
  YYSYMBOL_socket_def_param = 235,         /* socket_def_param  */
  YYSYMBOL_socket_def_params = 236,        /* socket_def_params  */
  YYSYMBOL_socket_def = 237,               /* socket_def  */
  YYSYMBOL_238_10 = 238,                   /* $@10  */
  YYSYMBOL_any_proto = 239,                /* any_proto  */
  YYSYMBOL_multi_string = 240,             /* multi_string  */
  YYSYMBOL_blst_elem = 241,                /* blst_elem  */
  YYSYMBOL_blst_def = 242,                 /* blst_def  */
  YYSYMBOL_blst_flag = 243,                /* blst_flag  */
  YYSYMBOL_blst_flags = 244,               /* blst_flags  */
  YYSYMBOL_blst_elem_list = 245,           /* blst_elem_list  */
  YYSYMBOL_auto_scale_profile_def = 246,   /* auto_scale_profile_def  */
  YYSYMBOL_assign_stm = 247,               /* assign_stm  */
  YYSYMBOL_module_stm = 248,               /* module_stm  */
  YYSYMBOL_ip = 249,                       /* ip  */
  YYSYMBOL_ipv4 = 250,                     /* ipv4  */
  YYSYMBOL_ipv6addr = 251,                 /* ipv6addr  */
  YYSYMBOL_ipv6 = 252,                     /* ipv6  */
  YYSYMBOL_ipnet = 253,                    /* ipnet  */
  YYSYMBOL_folded_string = 254,            /* folded_string  */
  YYSYMBOL_route_name = 255,               /* route_name  */
  YYSYMBOL_route_name_var = 256,           /* route_name_var  */
  YYSYMBOL_route_stm = 257,                /* route_stm  */
  YYSYMBOL_failure_route_stm = 258,        /* failure_route_stm  */
  YYSYMBOL_onreply_route_stm = 259,        /* onreply_route_stm  */
  YYSYMBOL_branch_route_stm = 260,         /* branch_route_stm  */
  YYSYMBOL_error_route_stm = 261,          /* error_route_stm  */
  YYSYMBOL_local_route_stm = 262,          /* local_route_stm  */
  YYSYMBOL_startup_route_stm = 263,        /* startup_route_stm  */
  YYSYMBOL_timer_route_stm = 264,          /* timer_route_stm  */
  YYSYMBOL_event_route_stm = 265,          /* event_route_stm  */
  YYSYMBOL_exp = 266,                      /* exp  */
  YYSYMBOL_equalop = 267,                  /* equalop  */
  YYSYMBOL_compop = 268,                   /* compop  */
  YYSYMBOL_matchop = 269,                  /* matchop  */
  YYSYMBOL_intop = 270,                    /* intop  */
  YYSYMBOL_strop = 271,                    /* strop  */
  YYSYMBOL_script_var = 272,               /* script_var  */
  YYSYMBOL_exp_elem = 273,                 /* exp_elem  */
  YYSYMBOL_exp_cond = 274,                 /* exp_cond  */
  YYSYMBOL_assignop = 275,                 /* assignop  */
  YYSYMBOL_assignexp = 276,                /* assignexp  */
  YYSYMBOL_assign_cmd = 277,               /* assign_cmd  */
  YYSYMBOL_exp_stm = 278,                  /* exp_stm  */
  YYSYMBOL_brk_stm = 279,                  /* brk_stm  */
  YYSYMBOL_stm = 280,                      /* stm  */
  YYSYMBOL_actions = 281,                  /* actions  */
  YYSYMBOL_brk_actions = 282,              /* brk_actions  */
  YYSYMBOL_action = 283,                   /* action  */
  YYSYMBOL_brk_action = 284,               /* brk_action  */
  YYSYMBOL_brk_if_cmd = 285,               /* brk_if_cmd  */
  YYSYMBOL_if_cmd = 286,                   /* if_cmd  */
  YYSYMBOL_while_cmd = 287,                /* while_cmd  */
  YYSYMBOL_foreach_cmd = 288,              /* foreach_cmd  */
  YYSYMBOL_switch_cmd = 289,               /* switch_cmd  */
  YYSYMBOL_switch_stm = 290,               /* switch_stm  */
  YYSYMBOL_case_stms = 291,                /* case_stms  */
  YYSYMBOL_case_stm = 292,                 /* case_stm  */
  YYSYMBOL_default_stm = 293,              /* default_stm  */
  YYSYMBOL_func_param = 294,               /* func_param  */
  YYSYMBOL_route_param = 295,              /* route_param  */
  YYSYMBOL_async_func = 296,               /* async_func  */
  YYSYMBOL_return_param = 297,             /* return_param  */
  YYSYMBOL_return_params = 298,            /* return_params  */
  YYSYMBOL_cmd = 299                       /* cmd  */
};
typedef enum yysymbol_kind_t yysymbol_kind_t;




#ifdef short
# undef short
#endif

/* On compilers that do not define __PTRDIFF_MAX__ etc., make sure
   <limits.h> and (if available) <stdint.h> are included
   so that the code can choose integer types of a good width.  */

#ifndef __PTRDIFF_MAX__
# include <limits.h> /* INFRINGES ON USER NAME SPACE */
# if defined __STDC_VERSION__ && 199901 <= __STDC_VERSION__
#  include <stdint.h> /* INFRINGES ON USER NAME SPACE */
#  define YY_STDINT_H
# endif
#endif

/* Narrow types that promote to a signed type and that can represent a
   signed or unsigned integer of at least N bits.  In tables they can
   save space and decrease cache pressure.  Promoting to a signed type
   helps avoid bugs in integer arithmetic.  */

#ifdef __INT_LEAST8_MAX__
typedef __INT_LEAST8_TYPE__ yytype_int8;
#elif defined YY_STDINT_H
typedef int_least8_t yytype_int8;
#else
typedef signed char yytype_int8;
#endif

#ifdef __INT_LEAST16_MAX__
typedef __INT_LEAST16_TYPE__ yytype_int16;
#elif defined YY_STDINT_H
typedef int_least16_t yytype_int16;
#else
typedef short yytype_int16;
#endif

/* Work around bug in HP-UX 11.23, which defines these macros
   incorrectly for preprocessor constants.  This workaround can likely
   be removed in 2023, as HPE has promised support for HP-UX 11.23
   (aka HP-UX 11i v2) only through the end of 2022; see Table 2 of
   <https://h20195.www2.hpe.com/V2/getpdf.aspx/4AA4-7673ENW.pdf>.  */
#ifdef __hpux
# undef UINT_LEAST8_MAX
# undef UINT_LEAST16_MAX
# define UINT_LEAST8_MAX 255
# define UINT_LEAST16_MAX 65535
#endif

#if defined __UINT_LEAST8_MAX__ && __UINT_LEAST8_MAX__ <= __INT_MAX__
typedef __UINT_LEAST8_TYPE__ yytype_uint8;
#elif (!defined __UINT_LEAST8_MAX__ && defined YY_STDINT_H \
       && UINT_LEAST8_MAX <= INT_MAX)
typedef uint_least8_t yytype_uint8;
#elif !defined __UINT_LEAST8_MAX__ && UCHAR_MAX <= INT_MAX
typedef unsigned char yytype_uint8;
#else
typedef short yytype_uint8;
#endif

#if defined __UINT_LEAST16_MAX__ && __UINT_LEAST16_MAX__ <= __INT_MAX__
typedef __UINT_LEAST16_TYPE__ yytype_uint16;
#elif (!defined __UINT_LEAST16_MAX__ && defined YY_STDINT_H \
       && UINT_LEAST16_MAX <= INT_MAX)
typedef uint_least16_t yytype_uint16;
#elif !defined __UINT_LEAST16_MAX__ && USHRT_MAX <= INT_MAX
typedef unsigned short yytype_uint16;
#else
typedef int yytype_uint16;
#endif

#ifndef YYPTRDIFF_T
# if defined __PTRDIFF_TYPE__ && defined __PTRDIFF_MAX__
#  define YYPTRDIFF_T __PTRDIFF_TYPE__
#  define YYPTRDIFF_MAXIMUM __PTRDIFF_MAX__
# elif defined PTRDIFF_MAX
#  ifndef ptrdiff_t
#   include <stddef.h> /* INFRINGES ON USER NAME SPACE */
#  endif
#  define YYPTRDIFF_T ptrdiff_t
#  define YYPTRDIFF_MAXIMUM PTRDIFF_MAX
# else
#  define YYPTRDIFF_T long
#  define YYPTRDIFF_MAXIMUM LONG_MAX
# endif
#endif

#ifndef YYSIZE_T
# ifdef __SIZE_TYPE__
#  define YYSIZE_T __SIZE_TYPE__
# elif defined size_t
#  define YYSIZE_T size_t
# elif defined __STDC_VERSION__ && 199901 <= __STDC_VERSION__
#  include <stddef.h> /* INFRINGES ON USER NAME SPACE */
#  define YYSIZE_T size_t
# else
#  define YYSIZE_T unsigned
# endif
#endif

#define YYSIZE_MAXIMUM                                  \
  YY_CAST (YYPTRDIFF_T,                                 \
           (YYPTRDIFF_MAXIMUM < YY_CAST (YYSIZE_T, -1)  \
            ? YYPTRDIFF_MAXIMUM                         \
            : YY_CAST (YYSIZE_T, -1)))

#define YYSIZEOF(X) YY_CAST (YYPTRDIFF_T, sizeof (X))


/* Stored state numbers (used for stacks). */
typedef yytype_int16 yy_state_t;

/* State numbers in computations.  */
typedef int yy_state_fast_t;

#ifndef YY_
# if defined YYENABLE_NLS && YYENABLE_NLS
#  if ENABLE_NLS
#   include <libintl.h> /* INFRINGES ON USER NAME SPACE */
#   define YY_(Msgid) dgettext ("bison-runtime", Msgid)
#  endif
# endif
# ifndef YY_
#  define YY_(Msgid) Msgid
# endif
#endif


#ifndef YY_ATTRIBUTE_PURE
# if defined __GNUC__ && 2 < __GNUC__ + (96 <= __GNUC_MINOR__)
#  define YY_ATTRIBUTE_PURE __attribute__ ((__pure__))
# else
#  define YY_ATTRIBUTE_PURE
# endif
#endif

#ifndef YY_ATTRIBUTE_UNUSED
# if defined __GNUC__ && 2 < __GNUC__ + (7 <= __GNUC_MINOR__)
#  define YY_ATTRIBUTE_UNUSED __attribute__ ((__unused__))
# else
#  define YY_ATTRIBUTE_UNUSED
# endif
#endif

/* Suppress unused-variable warnings by "using" E.  */
#if ! defined lint || defined __GNUC__
# define YY_USE(E) ((void) (E))
#else
# define YY_USE(E) /* empty */
#endif

/* Suppress an incorrect diagnostic about yylval being uninitialized.  */
#if defined __GNUC__ && ! defined __ICC && 406 <= __GNUC__ * 100 + __GNUC_MINOR__
# if __GNUC__ * 100 + __GNUC_MINOR__ < 407
#  define YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN                           \
    _Pragma ("GCC diagnostic push")                                     \
    _Pragma ("GCC diagnostic ignored \"-Wuninitialized\"")
# else
#  define YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN                           \
    _Pragma ("GCC diagnostic push")                                     \
    _Pragma ("GCC diagnostic ignored \"-Wuninitialized\"")              \
    _Pragma ("GCC diagnostic ignored \"-Wmaybe-uninitialized\"")
# endif
# define YY_IGNORE_MAYBE_UNINITIALIZED_END      \
    _Pragma ("GCC diagnostic pop")
#else
# define YY_INITIAL_VALUE(Value) Value
#endif
#ifndef YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
# define YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
# define YY_IGNORE_MAYBE_UNINITIALIZED_END
#endif
#ifndef YY_INITIAL_VALUE
# define YY_INITIAL_VALUE(Value) /* Nothing. */
#endif

#if defined __cplusplus && defined __GNUC__ && ! defined __ICC && 6 <= __GNUC__
# define YY_IGNORE_USELESS_CAST_BEGIN                          \
    _Pragma ("GCC diagnostic push")                            \
    _Pragma ("GCC diagnostic ignored \"-Wuseless-cast\"")
# define YY_IGNORE_USELESS_CAST_END            \
    _Pragma ("GCC diagnostic pop")
#endif
#ifndef YY_IGNORE_USELESS_CAST_BEGIN
# define YY_IGNORE_USELESS_CAST_BEGIN
# define YY_IGNORE_USELESS_CAST_END
#endif


#define YY_ASSERT(E) ((void) (0 && (E)))

#if !defined yyoverflow

/* The parser invokes alloca or malloc; define the necessary symbols.  */

# ifdef YYSTACK_USE_ALLOCA
#  if YYSTACK_USE_ALLOCA
#   ifdef __GNUC__
#    define YYSTACK_ALLOC __builtin_alloca
#   elif defined __BUILTIN_VA_ARG_INCR
#    include <alloca.h> /* INFRINGES ON USER NAME SPACE */
#   elif defined _AIX
#    define YYSTACK_ALLOC __alloca
#   elif defined _MSC_VER
#    include <malloc.h> /* INFRINGES ON USER NAME SPACE */
#    define alloca _alloca
#   else
#    define YYSTACK_ALLOC alloca
#    if ! defined _ALLOCA_H && ! defined EXIT_SUCCESS
#     include <stdlib.h> /* INFRINGES ON USER NAME SPACE */
      /* Use EXIT_SUCCESS as a witness for stdlib.h.  */
#     ifndef EXIT_SUCCESS
#      define EXIT_SUCCESS 0
#     endif
#    endif
#   endif
#  endif
# endif

# ifdef YYSTACK_ALLOC
   /* Pacify GCC's 'empty if-body' warning.  */
#  define YYSTACK_FREE(Ptr) do { /* empty */; } while (0)
#  ifndef YYSTACK_ALLOC_MAXIMUM
    /* The OS might guarantee only one guard page at the bottom of the stack,
       and a page size can be as small as 4096 bytes.  So we cannot safely
       invoke alloca (N) if N exceeds 4096.  Use a slightly smaller number
       to allow for a few compiler-allocated temporary stack slots.  */
#   define YYSTACK_ALLOC_MAXIMUM 4032 /* reasonable circa 2006 */
#  endif
# else
#  define YYSTACK_ALLOC YYMALLOC
#  define YYSTACK_FREE YYFREE
#  ifndef YYSTACK_ALLOC_MAXIMUM
#   define YYSTACK_ALLOC_MAXIMUM YYSIZE_MAXIMUM
#  endif
#  if (defined __cplusplus && ! defined EXIT_SUCCESS \
       && ! ((defined YYMALLOC || defined malloc) \
             && (defined YYFREE || defined free)))
#   include <stdlib.h> /* INFRINGES ON USER NAME SPACE */
#   ifndef EXIT_SUCCESS
#    define EXIT_SUCCESS 0
#   endif
#  endif
#  ifndef YYMALLOC
#   define YYMALLOC malloc
#   if ! defined malloc && ! defined EXIT_SUCCESS
void *malloc (YYSIZE_T); /* INFRINGES ON USER NAME SPACE */
#   endif
#  endif
#  ifndef YYFREE
#   define YYFREE free
#   if ! defined free && ! defined EXIT_SUCCESS
void free (void *); /* INFRINGES ON USER NAME SPACE */
#   endif
#  endif
# endif
#endif /* !defined yyoverflow */

#if (! defined yyoverflow \
     && (! defined __cplusplus \
         || (defined YYSTYPE_IS_TRIVIAL && YYSTYPE_IS_TRIVIAL)))

/* A type that is properly aligned for any stack member.  */
union yyalloc
{
  yy_state_t yyss_alloc;
  YYSTYPE yyvs_alloc;
};

/* The size of the maximum gap between one aligned stack and the next.  */
# define YYSTACK_GAP_MAXIMUM (YYSIZEOF (union yyalloc) - 1)

/* The size of an array large to enough to hold all stacks, each with
   N elements.  */
# define YYSTACK_BYTES(N) \
     ((N) * (YYSIZEOF (yy_state_t) + YYSIZEOF (YYSTYPE)) \
      + YYSTACK_GAP_MAXIMUM)

# define YYCOPY_NEEDED 1

/* Relocate STACK from its old location to the new one.  The
   local variables YYSIZE and YYSTACKSIZE give the old and new number of
   elements in the stack, and YYPTR gives the new location of the
   stack.  Advance YYPTR to a properly aligned location for the next
   stack.  */
# define YYSTACK_RELOCATE(Stack_alloc, Stack)                           \
    do                                                                  \
      {                                                                 \
        YYPTRDIFF_T yynewbytes;                                         \
        YYCOPY (&yyptr->Stack_alloc, Stack, yysize);                    \
        Stack = &yyptr->Stack_alloc;                                    \
        yynewbytes = yystacksize * YYSIZEOF (*Stack) + YYSTACK_GAP_MAXIMUM; \
        yyptr += yynewbytes / YYSIZEOF (*yyptr);                        \
      }                                                                 \
    while (0)

#endif

#if defined YYCOPY_NEEDED && YYCOPY_NEEDED
/* Copy COUNT objects from SRC to DST.  The source and destination do
   not overlap.  */
# ifndef YYCOPY
#  if defined __GNUC__ && 1 < __GNUC__
#   define YYCOPY(Dst, Src, Count) \
      __builtin_memcpy (Dst, Src, YY_CAST (YYSIZE_T, (Count)) * sizeof (*(Src)))
#  else
#   define YYCOPY(Dst, Src, Count)              \
      do                                        \
        {                                       \
          YYPTRDIFF_T yyi;                      \
          for (yyi = 0; yyi < (Count); yyi++)   \
            (Dst)[yyi] = (Src)[yyi];            \
        }                                       \
      while (0)
#  endif
# endif
#endif /* !YYCOPY_NEEDED */

/* YYFINAL -- State number of the termination state.  */
#define YYFINAL  234
/* YYLAST -- Last index in YYTABLE.  */
#define YYLAST   2393

/* YYNTOKENS -- Number of terminals.  */
#define YYNTOKENS  209
/* YYNNTS -- Number of nonterminals.  */
#define YYNNTS  91
/* YYNRULES -- Number of rules.  */
#define YYNRULES  538
/* YYNSTATES -- Number of states.  */
#define YYNSTATES  1021

/* YYMAXUTOK -- Last valid token kind.  */
#define YYMAXUTOK   463


/* YYTRANSLATE(TOKEN-NUM) -- Symbol number corresponding to TOKEN-NUM
   as returned by yylex, with out-of-bounds checking.  */
#define YYTRANSLATE(YYX)                                \
  (0 <= (YYX) && (YYX) <= YYMAXUTOK                     \
   ? YY_CAST (yysymbol_kind_t, yytranslate[YYX])        \
   : YYSYMBOL_YYUNDEF)

/* YYTRANSLATE[TOKEN-NUM] -- Symbol number corresponding to TOKEN-NUM
   as returned by yylex.  */
static const yytype_uint8 yytranslate[] =
{
       0,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     1,     2,     3,     4,
       5,     6,     7,     8,     9,    10,    11,    12,    13,    14,
      15,    16,    17,    18,    19,    20,    21,    22,    23,    24,
      25,    26,    27,    28,    29,    30,    31,    32,    33,    34,
      35,    36,    37,    38,    39,    40,    41,    42,    43,    44,
      45,    46,    47,    48,    49,    50,    51,    52,    53,    54,
      55,    56,    57,    58,    59,    60,    61,    62,    63,    64,
      65,    66,    67,    68,    69,    70,    71,    72,    73,    74,
      75,    76,    77,    78,    79,    80,    81,    82,    83,    84,
      85,    86,    87,    88,    89,    90,    91,    92,    93,    94,
      95,    96,    97,    98,    99,   100,   101,   102,   103,   104,
     105,   106,   107,   108,   109,   110,   111,   112,   113,   114,
     115,   116,   117,   118,   119,   120,   121,   122,   123,   124,
     125,   126,   127,   128,   129,   130,   131,   132,   133,   134,
     135,   136,   137,   138,   139,   140,   141,   142,   143,   144,
     145,   146,   147,   148,   149,   150,   151,   152,   153,   154,
     155,   156,   157,   158,   159,   160,   161,   162,   163,   164,
     165,   166,   167,   168,   169,   170,   171,   172,   173,   174,
     175,   176,   177,   178,   179,   180,   181,   182,   183,   184,
     185,   186,   187,   188,   189,   190,   191,   192,   193,   194,
     195,   196,   197,   198,   199,   200,   201,   202,   203,   204,
     205,   206,   207,   208
};

#if YYDEBUG
/* YYRLINE[YYN] -- Source line where rule number YYN was defined.  */
static const yytype_int16 yyrline[] =
{
       0,   527,   527,   530,   531,   532,   535,   536,   537,   537,
     538,   538,   539,   539,   540,   540,   541,   541,   542,   542,
     543,   543,   544,   544,   545,   545,   547,   550,   565,   574,
     589,   590,   593,   594,   608,   613,   623,   624,   627,   640,
     649,   656,   658,   659,   660,   664,   666,   668,   673,   681,
     683,   685,   687,   689,   694,   701,   703,   705,   707,   711,
     714,   715,   721,   722,   725,   727,   729,   735,   738,   741,
     744,   747,   750,   753,   756,   759,   764,   765,   768,   769,
     769,   776,   777,   779,   780,   783,   791,   800,   806,   813,
     819,   826,   832,   839,   845,   852,   858,   867,   868,   869,
     872,   873,   874,   877,   878,   881,   882,   883,   887,   895,
     903,   909,   917,   921,   933,   934,   935,   936,   937,   938,
     953,   955,   958,   959,   980,   981,   992,   993,  1004,  1005,
    1014,  1015,  1021,  1022,  1028,  1029,  1031,  1032,  1057,  1082,
    1090,  1091,  1099,  1100,  1107,  1108,  1114,  1115,  1118,  1119,
    1120,  1121,  1122,  1123,  1124,  1125,  1126,  1127,  1128,  1129,
    1130,  1131,  1132,  1133,  1134,  1135,  1136,  1137,  1138,  1139,
    1140,  1141,  1142,  1146,  1147,  1150,  1154,  1155,  1156,  1164,
    1172,  1180,  1188,  1196,  1204,  1212,  1220,  1228,  1236,  1239,
    1240,  1243,  1244,  1245,  1246,  1247,  1248,  1249,  1250,  1251,
    1252,  1253,  1254,  1255,  1256,  1266,  1267,  1281,  1282,  1283,
    1284,  1285,  1286,  1287,  1288,  1289,  1290,  1291,  1292,  1293,
    1294,  1295,  1296,  1306,  1316,  1317,  1322,  1323,  1326,  1330,
    1331,  1336,  1337,  1340,  1341,  1344,  1345,  1348,  1349,  1356,
    1357,  1364,  1366,  1369,  1370,  1373,  1374,  1377,  1380,  1387,
    1388,  1395,  1396,  1403,  1404,  1406,  1407,  1411,  1412,  1415,
    1416,  1418,  1419,  1421,  1423,  1425,  1426,  1427,  1428,  1430,
    1431,  1440,  1443,  1453,  1456,  1500,  1501,  1506,  1508,  1510,
    1511,  1517,  1519,  1533,  1535,  1538,  1539,  1542,  1543,  1550,
    1551,  1558,  1559,  1563,  1591,  1592,  1594,  1595,  1598,  1599,
    1602,  1603,  1613,  1623,  1625,  1627,  1628,  1630,  1631,  1633,
    1636,  1638,  1641,  1642,  1645,  1647,  1650,  1653,  1657,  1658,
    1664,  1670,  1676,  1680,  1681,  1684,  1700,  1716,  1717,  1720,
    1726,  1736,  1746,  1757,  1760,  1769,  1774,  1797,  1802,  1810,
    1826,  1829,  1835,  1838,  1846,  1852,  1855,  1861,  1864,  1872,
    1875,  1883,  1886,  1894,  1897,  1910,  1913,  1919,  1924,  1925,
    1926,  1927,  1928,  1929,  1932,  1933,  1936,  1937,  1938,  1939,
    1941,  1942,  1945,  1946,  1949,  1950,  1951,  1954,  1970,  1975,
    1976,  1977,  1979,  1984,  1987,  1990,  1993,  1996,  2002,  2003,
    2004,  2005,  2006,  2007,  2008,  2009,  2010,  2011,  2015,  2016,
    2017,  2018,  2019,  2020,  2023,  2026,  2029,  2032,  2035,  2038,
    2041,  2044,  2047,  2050,  2053,  2056,  2069,  2082,  2097,  2098,
    2099,  2100,  2101,  2104,  2105,  2106,  2109,  2110,  2111,  2114,
    2115,  2116,  2120,  2121,  2122,  2125,  2126,  2127,  2128,  2129,
    2130,  2131,  2132,  2135,  2136,  2137,  2138,  2139,  2140,  2141,
    2142,  2143,  2146,  2154,  2164,  2172,  2182,  2190,  2208,  2217,
    2218,  2220,  2221,  2224,  2230,  2236,  2242,  2250,  2253,  2256,
    2261,  2271,  2278,  2285,  2295,  2300,  2307,  2317,  2322,  2329,
    2341,  2346,  2351,  2356,  2361,  2371,  2381,  2391,  2403,  2421,
    2452,  2456,  2462,  2463,  2464,  2466,  2469,  2470,  2473,  2476,
    2479,  2480,  2481,  2482,  2483,  2489,  2495,  2501,  2507,  2513,
    2519,  2525,  2531,  2536,  2539,  2545,  2546,  2548,  2554,  2555,
    2557,  2561,  2580,  2581,  2583,  2606,  2642,  2644,  2647,  2649,
    2651,  2653,  2655,  2657,  2659,  2666,  2673,  2680,  2687
};
#endif

/** Accessing symbol of state STATE.  */
#define YY_ACCESSING_SYMBOL(State) YY_CAST (yysymbol_kind_t, yystos[State])

#if YYDEBUG || 0
/* The user-facing name of the symbol whose (internal) number is
   YYSYMBOL.  No bounds checking.  */
static const char *yysymbol_name (yysymbol_kind_t yysymbol) YY_ATTRIBUTE_UNUSED;

/* YYTNAME[SYMBOL-NUM] -- String name of the symbol SYMBOL-NUM.
   First, the terminals, then, starting at YYNTOKENS, nonterminals.  */
static const char *const yytname[] =
{
  "\"end of file\"", "error", "\"invalid token\"", "DROP", "ASSERT",
  "EXIT", "RETURN", "LOG_TOK", "ERROR", "ROUTE", "ROUTE_FAILURE",
  "ROUTE_ONREPLY", "ROUTE_BRANCH", "ROUTE_ERROR", "ROUTE_LOCAL",
  "ROUTE_STARTUP", "ROUTE_TIMER", "ROUTE_EVENT", "IF", "ELSE", "SWITCH",
  "CASE", "DEFAULT", "BREAK", "WHILE", "FOR", "IN", "READONLY", "EXPIRE",
  "NULLV", "XDBG", "XLOG", "XLOG_BUF_SIZE", "XLOG_FORCE_COLOR",
  "XLOG_PRINT_LEVEL", "XLOG_LEVEL", "PV_PRINT_BUF_SIZE", "DEBUG_MODE",
  "ENABLE_ASSERTS", "ABORT_ON_ASSERT", "LOGLEVEL", "LOGPREFIX",
  "LOGSTDOUT", "LOGSTDERROR", "STDERROR_ENABLED", "SYSLOG_ENABLED",
  "LOG_EVENT_ENABLED", "STDERROR_LEVEL_FILTER", "SYSLOG_LEVEL_FILTER",
  "LOG_EVENT_LEVEL_FILTER", "STDERROR_FORMAT", "SYSLOG_FORMAT",
  "LOG_JSON_BUF_SIZE", "LOG_MSG_BUF_SIZE", "LOGFACILITY",
  "SYSLOG_FACILITY", "LOGNAME", "SYSLOG_NAME", "AVP_ALIASES", "LISTEN",
  "SOCKET", "MEMGROUP", "ALIAS", "AUTO_ALIASES", "TAG", "DNS", "REV_DNS",
  "DNS_TRY_IPV6", "DNS_TRY_NAPTR", "DNS_RETR_TIME", "DNS_RETR_NO",
  "DNS_SERVERS_NO", "DNS_USE_SEARCH", "MAX_WHILE_LOOPS", "UDP_WORKERS",
  "CHECK_VIA", "SHM_HASH_SPLIT_PERCENTAGE", "SHM_SECONDARY_HASH_SIZE",
  "MEM_WARMING_ENABLED", "MEM_WARMING_PATTERN_FILE",
  "MEM_WARMING_PERCENTAGE", "RPM_MEM_FILE", "RPM_MEM_SIZE", "MEMLOG",
  "MEMDUMP", "SHM_MEMLOG_SIZE", "EXECMSGTHRESHOLD", "EXECDNSTHRESHOLD",
  "TCPTHRESHOLD", "EVENT_SHM_THRESHOLD", "EVENT_PKG_THRESHOLD",
  "QUERYBUFFERSIZE", "QUERYFLUSHTIME", "SIP_WARNING", "SERVER_SIGNATURE",
  "SERVER_HEADER", "USER_AGENT_HEADER", "LOADMODULE", "MPATH", "MODPARAM",
  "MAXBUFFER", "CHROOT", "WDIR", "MHOMED", "POLL_METHOD",
  "TCP_ACCEPT_ALIASES", "TCP_WORKERS", "TCP_CONNECT_TIMEOUT",
  "TCP_CON_LIFETIME", "TCP_SOCKET_BACKLOG", "TCP_MAX_CONNECTIONS",
  "TCP_NO_NEW_CONN_BFLAG", "TCP_NO_NEW_CONN_RPLFLAG", "TCP_KEEPALIVE",
  "TCP_KEEPCOUNT", "TCP_KEEPIDLE", "TCP_KEEPINTERVAL", "TCP_MAX_MSG_TIME",
  "TCP_PARALLEL_READ_ON_WORKERS", "ADVERTISED_ADDRESS", "ADVERTISED_PORT",
  "DISABLE_CORE", "OPEN_FD_LIMIT", "MCAST_LOOPBACK", "MCAST_TTL", "TOS",
  "DISABLE_DNS_FAILOVER", "DISABLE_DNS_BLACKLIST", "DST_BLACKLIST",
  "DISABLE_STATELESS_FWD", "DB_VERSION_TABLE", "DB_DEFAULT_URL",
  "DB_MAX_ASYNC_CONNECTIONS", "DISABLE_503_TRANSLATION", "SYNC_TOKEN",
  "ASYNC_TOKEN", "LAUNCH_TOKEN", "AUTO_SCALING_PROFILE",
  "AUTO_SCALING_CYCLE", "TIMER_WORKERS", "EQUAL", "EQUAL_T", "GT", "LT",
  "GTE", "LTE", "DIFF", "MATCH", "NOTMATCH", "COLONEQ", "PLUSEQ",
  "MINUSEQ", "SLASHEQ", "MULTEQ", "MODULOEQ", "BANDEQ", "BOREQ", "BXOREQ",
  "OR", "AND", "BOR", "BAND", "BXOR", "BLSHIFT", "BRSHIFT", "PLUS",
  "MINUS", "MULT", "MODULO", "NOT", "BNOT", "NUMBER", "ZERO", "ID",
  "STRING", "SCRIPTVAR", "IPV6ADDR", "IPV4ADDR", "IPNET", "COMMA",
  "SEMICOLON", "RPAREN", "LPAREN", "LBRACE", "RBRACE", "LBRACK", "RBRACK",
  "SLASH", "AS", "USE_WORKERS", "SOCK_TOS", "USE_AUTO_SCALING_PROFILE",
  "MAX", "MIN", "DOT", "CR", "COLON", "ANY", "ANYCAST", "ACCEPT_SUBDOMAIN",
  "FRAG", "REUSE_PORT", "SCRIPTVARERR", "SCALE_UP_TO", "SCALE_DOWN_TO",
  "ON", "CYCLES", "CYCLES_WITHIN", "PERCENTAGE", "$accept", "cfg",
  "statements", "statement", "$@1", "$@2", "$@3", "$@4", "$@5", "$@6",
  "$@7", "$@8", "$@9", "listen_id", "host_sep", "host", "proto", "port",
  "portrange", "snumber", "phostport", "phostportrange", "any_alias",
  "alias_def", "id_lst", "listen_id_def", "socket_def_param",
  "socket_def_params", "socket_def", "$@10", "any_proto", "multi_string",
  "blst_elem", "blst_def", "blst_flag", "blst_flags", "blst_elem_list",
  "auto_scale_profile_def", "assign_stm", "module_stm", "ip", "ipv4",
  "ipv6addr", "ipv6", "ipnet", "folded_string", "route_name",
  "route_name_var", "route_stm", "failure_route_stm", "onreply_route_stm",
  "branch_route_stm", "error_route_stm", "local_route_stm",
  "startup_route_stm", "timer_route_stm", "event_route_stm", "exp",
  "equalop", "compop", "matchop", "intop", "strop", "script_var",
  "exp_elem", "exp_cond", "assignop", "assignexp", "assign_cmd", "exp_stm",
  "brk_stm", "stm", "actions", "brk_actions", "action", "brk_action",
  "brk_if_cmd", "if_cmd", "while_cmd", "foreach_cmd", "switch_cmd",
  "switch_stm", "case_stms", "case_stm", "default_stm", "func_param",
  "route_param", "async_func", "return_param", "return_params", "cmd", YY_NULLPTR
};

static const char *
yysymbol_name (yysymbol_kind_t yysymbol)
{
  return yytname[yysymbol];
}
#endif

#define YYPACT_NINF (-881)

#define yypact_value_is_default(Yyn) \
  ((Yyn) == YYPACT_NINF)

#define YYTABLE_NINF (-468)

#define yytable_value_is_error(Yyn) \
  0

/* YYPACT[STATE-NUM] -- Index in YYTABLE of the portion describing
   STATE-NUM.  */
static const yytype_int16 yypact[] =
{
    2198,  -103,   -68,   -32,     8,   203,   251,   267,   273,   281,
     293,   307,   315,   320,   343,   355,   371,   391,   441,   471,
     493,   509,   516,   519,   548,   556,   567,   581,   586,   618,
     621,   629,   634,   637,   665,    28,    46,    48,    49,    55,
     131,   682,   696,   703,   706,   712,   720,   734,   735,   744,
     750,   762,   763,   774,   791,   801,   805,   817,   818,   834,
     847,   848,   851,   858,   859,    38,   869,    57,   880,   881,
     883,   889,   890,   893,   895,   899,   900,   902,   903,   904,
     906,   907,   908,   910,   919,   920,   936,   937,   941,   952,
     953,   957,   967,   968,   345,   374,   970,   974,   976,   978,
     986,   987,   988,   989,   990,  -881,    34,  2034,  -881,   154,
     135,   161,   257,   356,   534,   577,   623,   699,  -881,  -881,
    -881,    91,    99,   158,   364,   174,   361,   362,   363,    -5,
      50,   369,   381,   382,   383,   384,   425,   475,   477,   419,
     565,   386,   395,    85,   109,    94,   118,   124,   129,   689,
     272,   396,   407,   408,  -881,   700,  -881,   717,  -881,   887,
    -881,   898,  -881,   961,  -881,   962,   423,   436,   437,   443,
     452,   460,   130,   464,   134,   466,   501,   524,   535,   480,
     486,   497,   499,   500,   522,   549,   570,   571,   136,   138,
    -881,  -881,   139,  -881,   926,   594,   112,   126,   597,   133,
     599,   604,   605,   611,   612,   614,   152,   184,   644,   646,
     649,   660,   662,   663,   204,   684,   685,   690,   701,   702,
     249,  -881,   966,  -881,   973,   710,   985,   140,   156,   709,
     711,   259,   716,   995,  -881,  -103,  -881,    32,  -881,     9,
    -881,    40,  -881,    42,  -881,    17,  -881,    43,  -881,    84,
    -881,    62,  -881,    63,  -881,  -881,  -881,  -881,  -881,  -881,
    -881,  -881,   996,   997,  -881,  -881,  -881,  -881,  -881,  -881,
    -881,  -881,  -881,  -881,  -881,  -881,  -881,  -881,  -881,  -881,
    -881,  -881,  -881,  -881,  -881,  -881,  -881,  -881,  -881,  -881,
    -881,  -881,  -881,  -881,  -881,  -881,  -881,  -881,  -881,  -881,
    -881,  -881,  -881,  -881,  -881,  -881,  -881,  -881,  -881,   939,
     960,  -881,  -881,  -881,   942,  -881,  1138,   949,  -881,  -881,
    -881,   981,   982,  -881,   -48,   983,  -881,   971,  1037,  -881,
    -881,  -881,  -881,  -881,  -881,  -881,  -881,  -881,  -881,  -881,
    -881,  -881,  -881,  -881,  -881,  -881,  -881,  -881,  -881,   994,
    -881,  -881,  -881,  -881,  -881,  -881,  -881,  -881,  -881,  -881,
    -881,  -881,  -881,  -881,  -881,  -881,  -881,  -881,  -881,  -881,
    -881,  -881,  -881,  -881,  -881,  -881,  -881,  -881,  -881,  -881,
    -881,  -881,  -881,  -881,  -881,  -881,  -881,  -881,  -881,  -881,
    -881,  -881,  -881,  -881,  -881,  -881,  1002,  -881,  -881,  -881,
    -881,  -881,  -881,  -881,  -881,  -881,  -881,  -881,  -881,  -881,
    -881,  -881,  -881,   998,  -881,  -881,  -881,  -881,  -881,  -881,
    -881,  -881,  -881,  -881,  -881,  -881,  -881,  -881,  -881,  -881,
    -881,  -881,  -881,  -881,  -881,  -881,  -881,  -881,  -881,  -881,
    -881,  -881,  -881,  -881,  -881,  -881,  -881,  -881,  -881,  -881,
    -881,  -881,  -881,  -881,  -881,  -881,  -113,  -881,  -881,  -881,
    -881,  -881,  -881,  -881,  -881,  -881,  -881,   993,  -881,  -881,
    -881,   999,  -881,  1858,   200,  -881,   200,  -881,  1858,   200,
    -881,   200,  -881,  1858,  -881,  1858,  -881,  1858,  -881,   200,
    -881,   200,  -881,  -881,  1053,   964,   157,  -881,  1011,   766,
    -881,   283,  1028,   766,  -881,  -881,  1032,  1033,  1039,   873,
    1019,  -881,  1035,  1042,  1036,  1043,  1051,   562,    95,    96,
     106,  1054,  1055,  1057,  1059,  1067,  1071,  1073,  1076,   108,
    -881,  -881,  -881,  1631,  1044,   742,  -881,  -881,  -881,  -881,
    -881,    23,  -881,  -881,  -881,  1049,  1074,   788,  1080,  1082,
     820,   861,   929,  1040,  1094,  1066,  1085,  1109,   766,  1096,
    1113,  1112,  -881,  -881,  -881,  -881,   964,  -881,  -881,  1114,
    -881,  -881,  1091,  -881,  -881,  1105,  -881,  1127,  -881,  -881,
    -881,  -881,  -881,   -46,   602,  1087,  -881,  1133,  1390,  1134,
     804,  -881,  -881,  -881,   308,  -881,   170,  -881,    78,  1390,
    -108,  1390,  -108,  1142,  1143,  1146,  1146,  -881,   347,  1261,
    1291,  -881,  -881,  -881,  -881,  -881,  -881,  -881,  -881,  1575,
    -881,  -881,  -881,  -881,  -881,  -881,  1140,  1144,  -881,  1147,
    1148,  -881,  -881,  -881,  1150,  1149,   718,   722,  -881,  1129,
    -881,  -881,  -881,  -881,  -881,  -881,     5,    21,   815,   873,
    -881,   743,  -881,   918,  -881,  -881,    75,  -881,  -881,  1155,
    -881,  1390,  1390,  1595,  1575,  -881,   338,  1572,  -881,  -881,
    -881,  -881,  -881,  -881,  -881,   297,  -881,  -106,     3,  1152,
    1156,  1157,  1158,  1159,  1161,  -881,   213,  -881,   -38,  1163,
      -4,  1314,   205,   346,   551,   630,   111,  1166,   248,  1165,
    -881,   896,  -881,  -881,  -881,   457,  -881,  -881,  1575,  -881,
    1575,  -881,  1259,  -881,  1383,  -881,  1858,  1858,  1858,  1858,
    1164,  1858,  -881,  1181,  1170,  -881,  1170,   723,  -881,  -881,
    -881,  -881,  -881,  -881,   656,  1172,   658,  -881,   918,  -881,
    -881,  -881,  1175,   557,  -881,  1117,  -881,  1183,  -881,   550,
    -881,  1007,  1111,  1390,  1390,  1182,  -881,  -881,  -881,  -881,
    -881,  -881,  -881,  -881,  -881,   164,   -60,  -881,    -5,   -58,
    -881,  -881,  -881,  -881,  -881,   574,   297,  -881,   297,  -881,
    -881,  -881,  1184,  -881,  1186,  -881,   399,  -881,  1626,  1174,
    1441,  -108,  -881,  -881,  -881,  -881,  1194,  -881,  -881,  -881,
     453,   200,   200,  -881,  -881,  -881,  -881,  -881,  1029,  -881,
    -881,  1270,  1575,  1575,  1575,  1575,  1575,  1575,  1575,  1575,
    1575,  1575,  1048,  1081,  1116,  1168,  1188,  1239,  1198,  1201,
    -881,  1170,  -881,  -881,  -881,  1176,   609,   841,   -35,  -881,
    -881,  1348,  -881,  -881,  -881,  -881,  -881,  1196,  -881,  -881,
    -881,  -881,  -881,   297,  -881,   620,   635,  1199,  1200,  -881,
    -881,  -881,  -881,   678,  1675,  1360,  -881,  1363,  1203,  1206,
    -881,  1492,  1207,  -881,  -881,  -881,  -881,  -881,  -881,    64,
    1209,   661,   667,  1210,  -881,   748,   767,   771,  -881,  -881,
    -881,  -881,   731,   731,   731,   731,   731,  -881,  -881,  -881,
    -881,  -881,  -881,  -881,  -881,  -881,  1858,  -881,  -881,  1226,
     841,   -35,  -881,   783,  1228,  1240,  -881,  -881,  -881,  -881,
    -881,  -881,   451,  -881,  -881,  1304,  1626,   909,  1229,   554,
    -881,  1390,  -881,  -881,   579,  -881,  -881,  -881,  -881,  1441,
    -881,  -881,  -881,  -881,  1244,  -881,  1236,  -881,  1358,  1245,
     792,  1237,   -35,  -881,  -881,   211,  -881,  -881,  -881,  -881,
    -881,  -881,  1221,  1230,  -881,  1231,  -881,  -881,   576,  -881,
    -881,  -881,  -881,  1241,  1243,  -881,  -881,   -35,  -881,  -881,
     803,  1224,  1254,  1809,  1809,  1809,  1441,  -881,  -881,   813,
    1255,  -881,  1271,  1248,   485,   538,   674,  1424,  1279,  -881,
    1273,  1250,  1285,  1441,  1277,  -881,  1289,  1257,  -881,  -881,
    1295,  1296,  1443,  1301,  1299,  1448,  1268,  1305,  -881,  1269,
    -881
};

/* YYDEFACT[STATE-NUM] -- Default reduction number in state STATE-NUM.
   Performed when YYTABLE does not specify something else to do.  Zero
   means the default is an error.  */
static const yytype_int16 yydefact[] =
{
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    26,     0,     0,     4,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     6,     7,
     316,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   156,     0,   158,     0,   160,     0,
     162,     0,   164,     0,   166,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     318,   317,     0,   322,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   298,     0,   300,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     1,     5,     3,     0,     9,     0,
      11,     0,    13,     0,    15,     0,    17,     0,    19,     0,
      21,     0,    23,     0,    25,   265,   262,   266,   263,   267,
     264,   269,     0,     0,    42,   268,   261,   260,   120,   119,
     116,   115,   118,   117,   112,   114,   113,   122,   121,   124,
     123,   126,   125,   128,   127,   130,   129,   132,   131,   134,
     133,   136,   135,   137,   138,   140,   139,   142,   141,   144,
     143,   146,   145,   148,   147,   150,   149,   273,    35,     0,
      78,   272,   271,   270,     0,   277,     0,    32,    28,   326,
     325,     0,     0,    55,    29,     0,    59,    60,    62,   276,
      27,   323,   327,   324,   279,   278,   152,   151,   154,   153,
     155,   157,   159,   161,   163,   165,   168,   167,   173,   171,
     177,   176,   179,   178,   181,   180,   183,   182,   185,   184,
     187,   186,   189,   188,   191,   190,   193,   192,   197,   196,
     195,   194,   199,   198,   201,   200,   203,   202,   205,   204,
     207,   206,   209,   208,   211,   210,   213,   212,   255,   254,
     257,   256,   259,   258,   296,   295,     0,   170,   169,   216,
     215,   214,   219,   218,   217,   221,   220,   224,   222,   223,
     226,   225,   229,   227,   231,   230,   233,   232,   235,   234,
     237,   236,   239,   238,   241,   240,   243,   242,   249,   248,
     251,   250,   253,   252,   245,   244,   247,   246,   281,    32,
     280,   283,   282,   285,   284,   287,   286,   289,   288,   291,
     290,   294,   292,   293,   297,   299,    99,   303,   305,   304,
     307,   306,   309,   308,   311,   310,   313,     0,   312,   315,
     314,   174,   340,     0,     0,   342,     0,   345,     0,     0,
     347,     0,   349,     0,   351,     0,   353,     0,   355,     0,
     357,     0,    43,    44,     0,     0,     0,    48,     0,     0,
      31,     0,     0,     0,    61,    63,     0,     0,     0,     0,
       0,   302,     0,     0,   500,     0,   502,   512,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     377,   441,   378,     0,     0,     0,   430,   436,   437,   438,
     439,     0,   334,   333,   335,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    49,    50,     0,     0,     0,
       0,     0,    67,    70,    68,    69,    76,    80,   275,    83,
     274,   328,    56,    34,    33,    45,   172,     0,   228,   102,
     100,   101,   104,    99,     0,     0,   175,     0,     0,     0,
       0,   507,   504,   515,     0,   518,     0,   522,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   527,     0,   388,
     389,   390,   391,   392,   393,   394,   395,   396,   397,     0,
     440,   431,   338,   429,   442,   435,     0,     0,   343,     0,
       0,   348,   350,   352,     0,     0,     0,     0,    74,    64,
      73,    71,    72,    75,    77,    84,     0,     0,     0,     0,
     301,     0,   329,     0,    98,   106,     0,   330,    95,     0,
     501,     0,     0,     0,     0,   381,     0,   382,   363,   379,
     420,   380,   419,   418,   503,     0,   510,     0,     0,     0,
       0,     0,     0,     0,     0,   336,     0,   337,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     469,   471,   524,   474,   477,     0,   416,   417,     0,   399,
       0,   398,   400,   401,   415,   402,     0,     0,     0,     0,
       0,     0,    53,    41,    51,    54,    52,     0,    58,    36,
      37,    57,    47,    46,     0,     0,     0,   103,     0,    96,
      81,    82,     0,     0,   107,     0,    97,     0,   360,     0,
     422,     0,     0,     0,     0,     0,   499,   364,   366,   367,
     368,   369,   365,   370,   371,   372,   373,   376,     0,     0,
     495,   494,   493,   492,   496,     0,     0,   508,     0,   505,
     516,   513,     0,   519,     0,   523,     0,   520,     0,     0,
       0,     0,   331,   528,   332,   529,     0,   530,   531,   491,
       0,     0,     0,   538,   526,   472,   475,   478,   473,   525,
     413,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      66,    65,   319,   321,   320,     0,     0,     0,     0,    93,
     105,     0,   361,   421,   362,   359,   358,     0,   386,   387,
     385,   384,   383,     0,   511,     0,     0,     0,     0,   482,
     480,   481,   483,     0,     0,   454,   426,     0,     0,     0,
     450,     0,     0,   456,   423,   445,   446,   447,   448,     0,
       0,     0,     0,     0,   488,     0,     0,     0,   470,   476,
     479,   414,   409,   408,   410,   411,   412,   403,   404,   405,
     407,   406,   339,   341,   344,   346,     0,   356,    40,    39,
       0,     0,    94,     0,     0,     0,   498,   497,   509,   506,
     514,   517,     0,   521,   428,     0,     0,     0,     0,   460,
     462,     0,   443,   425,     0,   433,   449,   451,   444,     0,
     532,   533,   490,   489,     0,   534,     0,   537,     0,     0,
       0,     0,     0,    89,    91,     0,   487,   484,   485,   486,
     427,   455,     0,     0,   458,     0,   461,   459,     0,   434,
     424,   432,   457,     0,     0,   354,    38,     0,    90,    92,
       0,   111,     0,   466,   464,   468,     0,   535,   536,     0,
       0,    87,     0,   110,     0,     0,     0,   452,     0,    88,
       0,     0,     0,     0,     0,    85,     0,     0,   453,    86,
       0,     0,     0,     0,     0,     0,     0,     0,   109,     0,
     108
};

/* YYPGOTO[NTERM-NUM].  */
static const yytype_int16 yypgoto[] =
{
    -881,  -881,  -881,  1371,  -881,  -881,  -881,  -881,  -881,  -881,
    -881,  -881,  -881,  -198,  -881,  -881,  -149,  -616,  -589,  -124,
    -881,  -881,  -881,  -881,  1153,  -881,  -881,   914,  1334,  -881,
     745,   916,   741,   921,   838,  -881,  -881,  -881,  -881,  -881,
    -127,  -881,  1169,  -881,  -582,  -558,  -449,  -881,  -881,  -881,
    -881,  -881,  -881,  -881,  -881,  -881,  -881,  -573,  -881,  -881,
    -881,  -881,  -881,  -497,  -881,  -563,  -881,    92,  -580,  -881,
    -880,   563,  -476,    18,  -490,   -18,  -881,  -533,  -787,  -720,
    -544,  -881,  -881,   573,  -881,   691,  -881,   886,   650,   229,
    -584
};

/* YYDEFGOTO[NTERM-NUM].  */
static const yytype_int16 yydefgoto[] =
{
       0,   106,   107,   108,   109,   110,   111,   112,   113,   114,
     115,   116,   117,   323,   502,   324,   309,   731,   724,   711,
     326,   310,   327,   328,   329,   640,   566,   567,   311,   495,
     742,   570,   655,   511,   582,   583,   656,   468,   118,   119,
     657,   331,   332,   333,   658,   693,   545,   686,   238,   240,
     242,   244,   246,   248,   250,   252,   254,   666,   765,   766,
     767,   768,   769,   533,   668,   713,   619,   714,   534,   671,
     873,   865,   535,   934,   536,   874,   875,   537,   538,   539,
     540,   928,   929,   930,   967,   705,   863,   697,   774,   775,
     541
};

/* YYTABLE[YYPACT[STATE-NUM]] -- What to do in state STATE-NUM.  If
   positive, shift that token.  If negative, reduce the rule whose
   number is the opposite.  If YYTABLE_NINF, syntax error.  */
static const yytype_int16 yytable[] =
{
     265,   325,   547,   876,   673,   274,   728,   550,   670,   551,
     475,   552,   288,   290,   292,   673,   440,   673,   482,   670,
     592,   670,   732,   330,   624,   669,   688,   546,   690,   154,
     548,   733,   549,   472,   234,   715,   669,   120,   669,   190,
     553,   477,   554,   480,   484,   623,   695,   156,   726,   158,
     160,   275,   367,   369,   371,   672,   162,   623,   193,   972,
     623,   623,   623,   488,   490,   937,   672,   530,   672,   739,
     877,   743,   121,   776,   509,   777,   744,   673,   673,   684,
     715,   670,   670,   510,   876,   486,   299,   330,   748,   749,
     736,   667,   255,   678,   532,   303,   593,   595,   669,   669,
     257,   687,   667,   689,   667,   691,   997,   597,   122,   607,
     301,   704,   799,   399,  -375,  -375,   851,   530,   500,   305,
     753,   754,   712,  1008,   715,   307,   715,   402,   672,   672,
     312,   358,   164,   649,   407,   362,   729,   390,   831,   392,
     394,   458,  -375,   788,   532,   239,   501,   876,   123,   685,
     510,   877,   876,   422,   753,   754,   836,   460,   568,   259,
     262,   263,   730,   237,   667,   667,   264,   712,   155,   673,
     673,   682,   241,   670,   670,   266,   729,   790,   773,   325,
     845,   846,   778,   849,   779,   424,   157,   751,   159,   161,
     669,   669,   729,   848,   476,   163,   876,   876,   876,   876,
     483,   330,   730,   625,   807,   438,   879,   876,   876,   876,
     872,   712,   191,   712,   877,   473,   876,   474,   730,   877,
     672,   672,   914,   478,   276,   479,   485,   481,   715,   715,
     715,   715,   715,   715,   715,   715,   715,   715,   882,   194,
     822,   823,   824,   825,   938,   827,   878,   489,   491,   542,
     451,   543,   544,   530,   745,   913,   667,   667,   300,   746,
     466,   623,   256,   877,   877,   877,   877,   487,   304,   243,
     258,   165,   852,   315,   877,   877,   877,   594,   596,   773,
     532,   773,   302,   877,   573,   400,   401,   879,   598,   862,
     608,   872,   306,   800,   880,   951,   556,   308,   866,   403,
     404,   572,   308,   704,   359,   575,   408,   409,   363,   679,
     391,   890,   393,   395,   459,   712,   712,   712,   712,   712,
     712,   712,   712,   712,   712,   423,   770,   878,   950,   260,
     461,   569,   623,   623,   623,   623,   980,   623,  -374,  -374,
     319,   320,   652,   124,   683,   267,   221,   673,   699,   321,
     879,   670,   886,   887,   872,   879,   773,   425,   968,   872,
     639,   989,   268,   270,   272,   261,  -374,   330,   669,   245,
     277,   542,   330,   543,   544,   223,   330,   439,   318,   792,
     319,   320,   279,   281,   283,   285,   793,   295,   925,   321,
     878,   125,   786,   591,   787,   878,   297,   334,   672,   879,
     879,   879,   879,   872,   872,   872,   872,   126,   336,   338,
     879,   879,   879,   127,   872,   872,   872,   981,   982,   879,
     452,   128,   453,   872,   346,   959,   287,   802,   859,   803,
     948,   330,   467,   129,   667,   623,   866,   348,   350,   878,
     878,   878,   878,   316,   352,   317,   318,   130,   319,   320,
     878,   878,   878,   354,   883,   131,   -30,   321,   623,   878,
     132,   356,   262,   263,   665,   360,   677,   364,   264,   322,
     681,   771,   530,   262,   263,   665,   289,   665,   291,   264,
     956,   372,   680,   133,   703,   222,   969,   374,   514,   515,
     516,   517,   518,   519,   520,   134,   753,   754,   376,   532,
     378,   380,   366,   868,   741,   522,  -465,  -465,   869,   523,
     524,   135,   262,   263,   224,   525,   526,   755,   264,   756,
     794,   700,   530,   382,   735,   368,   701,   795,   702,   262,
     263,   136,   269,   271,   273,   264,   370,   665,   665,   969,
     278,   514,   515,   516,   517,   518,   519,   520,   247,   532,
     384,   772,   280,   282,   284,   286,   868,   296,   522,  -463,
    -463,   869,   523,   524,   262,   263,   298,   335,   525,   526,
     264,   386,   388,   860,   530,   927,   965,   806,   337,   339,
     969,   137,   514,   515,   516,   517,   518,   519,   520,   741,
     262,   263,   249,   293,   347,   397,   264,   868,   405,   522,
     410,   532,   869,   523,   524,   412,   414,   349,   351,   525,
     526,   138,   416,   418,   353,   420,   262,   263,   262,   263,
     527,   528,   264,   355,   264,   957,   530,   700,   530,   665,
     665,   357,   701,   139,   884,   361,   808,   365,   809,   251,
     262,   263,   262,   263,   850,   426,   264,   428,   264,   140,
     430,   373,   772,   532,   772,   532,   141,   375,   529,   142,
     530,   432,   861,   434,   436,   870,   262,   263,   377,  -465,
     379,   381,   264,   527,   528,   969,   703,   514,   515,   516,
     517,   518,   519,   520,   889,   441,   443,   532,   143,   262,
     263,   445,   868,   383,   522,   264,   144,   869,   523,   524,
     262,   263,   447,   449,   525,   526,   264,   145,   753,   754,
     462,   529,   464,   530,   527,   528,   253,   469,   870,   722,
     385,   146,  -463,   725,   830,   792,   147,   262,   263,   772,
     796,   842,   797,   264,   753,   754,   838,   530,   839,   294,
     532,   387,   389,   621,   590,   514,   515,   516,   517,   518,
     519,   520,   529,   853,   530,   854,   752,   986,   148,   870,
     521,   149,   522,   970,   532,   398,   523,   524,   406,   150,
     411,   651,   525,   526,   151,   413,   415,   152,   319,   320,
     652,   532,   417,   419,   653,   421,   654,   321,   911,   621,
     912,   514,   515,   516,   517,   518,   519,   520,   958,   853,
     810,   918,   811,   963,   794,   153,   521,   665,   522,   527,
     528,   798,   523,   524,   853,   427,   919,   429,   525,   526,
     431,   621,   166,   514,   515,   516,   517,   518,   519,   520,
     792,   433,   794,   435,   437,   792,   167,   832,   521,   834,
     522,   794,   940,   168,   523,   524,   169,   529,   941,   530,
     525,   526,   170,   935,   870,   442,   444,   922,  -467,   923,
     171,   446,   621,   314,   514,   515,   516,   517,   518,   519,
     520,   340,   448,   450,   172,   173,   532,   527,   528,   521,
     463,   522,   465,   456,   174,   523,   524,   470,   341,   723,
     175,   525,   526,   723,   723,   579,   817,   818,   819,   820,
     580,   581,   176,   177,   892,   893,   894,   895,   896,   897,
     898,   899,   900,   901,   178,   529,   971,   530,   821,   319,
     320,   652,   531,   527,   528,   738,   622,   808,   321,   943,
     621,   179,   514,   515,   516,   517,   518,   519,   520,   439,
     318,   180,   319,   320,   532,   181,   944,   521,   945,   522,
     946,   321,   947,   523,   524,   527,   528,   182,   183,   525,
     526,   529,   952,   530,   953,   935,   935,   935,   531,   262,
     263,   977,   628,   978,   184,   264,   971,   971,   971,   530,
     262,   263,   990,   675,   991,   676,   264,   185,   186,   734,
     532,   187,   998,   529,   999,   530,   527,   528,   188,   189,
     531,   994,   995,   996,   631,   855,   532,   856,   621,   192,
     514,   515,   516,   517,   518,   519,   520,   319,   320,   652,
     195,   196,   532,   197,   -79,   521,   321,   522,   557,   198,
     199,   523,   524,   200,   529,   201,   530,   525,   526,   202,
     203,   531,   204,   205,   206,   632,   207,   208,   209,   621,
     210,   514,   515,   516,   517,   518,   519,   520,   342,   211,
     212,   262,   263,   532,   527,   528,   521,   264,   522,   343,
     805,   530,   523,   524,   262,   263,   213,   214,   525,   526,
     264,   215,   621,   962,   514,   515,   516,   517,   518,   519,
     520,   308,   216,   217,   319,   320,   652,   218,   532,   521,
     396,   522,   529,   321,   530,   523,   524,   219,   220,   531,
     225,   525,   526,   633,   226,   740,   227,   621,   228,   514,
     515,   516,   517,   518,   519,   520,   229,   230,   231,   232,
     233,   532,   344,   345,   521,   494,   522,   454,   496,   497,
     523,   524,   527,   528,   455,   -35,   525,   526,   -79,   -79,
     -79,   -79,   558,   559,   560,   561,   457,   319,   -79,   -79,
     -79,   -79,   562,   563,   564,   565,   471,   492,   493,   621,
     504,   514,   515,   516,   517,   518,   519,   520,   499,   503,
     529,   507,   530,   527,   528,   506,   521,   531,   522,   508,
     513,   843,   523,   524,   262,   263,   512,   571,   525,   526,
     264,   574,   584,   888,   530,   576,   585,   577,   316,   532,
     317,   318,   578,   319,   320,   586,   527,   528,   587,   634,
     555,   529,   321,   530,   620,   588,   439,   318,   531,   319,
     320,   532,   902,   589,   322,   626,   599,   600,   321,   601,
     621,   602,   514,   515,   516,   517,   518,   519,   520,   603,
     532,   527,   528,   604,   529,   605,   530,   521,   606,   522,
     627,   531,   636,   523,   524,   903,   629,   641,   630,   525,
     526,   812,   813,   814,   815,   816,   817,   818,   819,   820,
     635,   637,   638,   532,   642,   643,   651,   646,   569,   529,
     706,   530,   659,   319,   320,   652,   531,   844,   821,   653,
     904,   647,   321,   527,   528,   621,   648,   514,   515,   516,
     517,   518,   519,   520,   660,   674,   692,   694,   532,   696,
     707,   720,   521,   716,   522,   727,   747,   717,   523,   524,
     718,   719,   721,   780,   525,   526,   782,   781,   784,   783,
     791,   529,   785,   530,   789,   801,   804,   828,   531,   829,
     826,   841,   905,   833,   837,   910,   847,   867,   857,   621,
     858,   514,   515,   516,   517,   518,   519,   520,   881,   908,
     532,   906,   909,   915,   527,   528,   521,   916,   522,   926,
     920,   921,   523,   524,   927,   931,   932,   936,   525,   526,
     939,   942,   949,   514,   515,   516,   517,   518,   519,   520,
     757,   758,   759,   760,   761,   762,   763,   764,   521,   954,
     974,   955,   529,   964,   530,   973,   976,   983,   979,   531,
     525,   526,   987,   907,   988,   993,   984,   985,   992,  1000,
     812,   813,   814,   815,   816,   817,   818,   819,   820,   527,
     528,   532,  1001,  1003,   514,   515,   516,   517,   518,   519,
     520,   891,  1002,  1004,  1005,  1006,  1007,   821,  1009,   868,
    1010,   522,  1011,  1012,   869,   523,   524,  1013,  1014,  1015,
    1016,   525,   526,  1017,  1018,  1020,  1019,   529,   236,   530,
     644,   505,   313,   835,   531,   645,   840,   737,   960,   961,
     498,   885,   698,   527,   528,   514,   515,   516,   517,   518,
     519,   520,   966,   917,   650,     0,   532,     0,     0,     0,
     868,     0,   522,     0,     0,   869,   523,   524,     0,     0,
       0,     0,   525,   526,     0,   527,   528,     0,     0,     0,
       0,   529,     0,   530,     0,     0,     0,     0,   531,     0,
       0,     0,   975,   812,   813,   814,   815,   816,   817,   818,
     819,   820,     0,     0,     0,   262,   263,     0,     0,   661,
     532,   264,     0,   529,     0,   530,     0,     0,     0,     0,
     821,     0,   662,   663,     0,   664,   527,   528,   514,   515,
     516,   517,   518,   519,   520,     0,     0,     0,     0,     0,
       0,     0,   532,     0,     0,     0,     0,     0,   514,   515,
     516,   517,   518,   519,   520,   525,   526,     0,     0,     0,
       0,     0,     0,   521,   529,   522,   530,     0,     0,   523,
     524,   870,     0,     0,   871,   525,   526,   527,   528,   514,
     515,   516,   517,   518,   519,   520,     0,     0,     0,     0,
       0,     0,     0,   532,   521,     0,   522,     0,     0,     0,
     523,   524,     0,     0,     0,     0,   525,   526,     0,     0,
       0,     0,     0,     0,     0,   529,     0,   530,     0,     0,
       0,     0,   870,     0,     0,     0,   933,     0,   514,   515,
     516,   517,   518,   519,   520,     0,     0,     0,     0,     0,
       0,     0,     0,   521,   532,   522,     0,     0,     0,   523,
     524,     0,     0,     0,     0,   525,   526,     0,     0,     0,
     527,   528,   609,   757,   758,   759,   760,   761,   762,   763,
     764,   610,   611,   612,   613,   614,   615,   616,   617,   618,
     527,   528,     0,     0,     0,     0,     0,     0,     0,     0,
     262,   263,     0,     0,     0,   708,   264,     0,   529,   709,
     530,     0,     0,     0,     0,     0,     0,   710,     0,     0,
       0,   527,   528,     0,     0,     0,     0,     0,   529,     0,
     530,   609,     0,     0,     0,   531,     0,   532,     0,   750,
     610,   611,   612,   613,   614,   615,   616,   617,   618,     0,
       0,     0,     0,     0,     0,     0,     0,   532,     0,   529,
       0,   530,     0,     0,     0,     0,   531,     0,     0,   864,
     527,   528,   514,   515,   516,   517,   518,   519,   520,     0,
       0,     0,     0,     0,     0,     0,     0,   868,   532,   522,
       0,     0,   869,   523,   524,     0,     0,     0,     0,   525,
     526,     0,     0,     0,     0,     0,     0,     0,   529,     0,
     530,     0,     0,     0,     0,   531,     0,     0,     0,   924,
       0,   514,   515,   516,   517,   518,   519,   520,     0,     0,
       0,     0,     0,     0,     0,     0,   521,   532,   522,     0,
       0,     0,   523,   524,     0,     0,     0,     0,   525,   526,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   527,   528,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   529,     0,   530,     0,     0,     0,     0,   870,
       0,     0,     0,   527,   528,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   532,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   529,     0,   530,    -2,   235,     0,     0,   531,     0,
       0,     0,     0,    -8,   -10,   -12,   -14,   -16,   -18,   -20,
     -22,   -24,     0,     0,     0,     0,     0,     0,     0,     0,
     532,     0,     0,     0,     0,     0,     2,     3,     4,     5,
       6,     7,     8,     9,    10,    11,    12,    13,    14,    15,
      16,    17,    18,    19,    20,    21,    22,    23,    24,    25,
      26,    27,     0,    28,    29,    30,    31,    32,     0,    33,
      34,    35,    36,    37,    38,    39,    40,    41,    42,    43,
      44,    45,    46,    47,    48,    49,    50,    51,    52,    53,
      54,    55,    56,    57,    58,    59,    60,    61,    62,    63,
      64,    65,    66,    67,    68,    69,    70,    71,    72,    73,
      74,    75,    76,    77,    78,    79,    80,    81,    82,    83,
      84,    85,    86,    87,    88,    89,    90,    91,    92,    93,
      94,    95,    96,    97,    98,    99,   100,   101,     0,     0,
       0,   102,   103,   104,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     1,
       0,     0,     0,     0,     0,     0,     0,    -8,   -10,   -12,
     -14,   -16,   -18,   -20,   -22,   -24,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   105,
       2,     3,     4,     5,     6,     7,     8,     9,    10,    11,
      12,    13,    14,    15,    16,    17,    18,    19,    20,    21,
      22,    23,    24,    25,    26,    27,     0,    28,    29,    30,
      31,    32,     0,    33,    34,    35,    36,    37,    38,    39,
      40,    41,    42,    43,    44,    45,    46,    47,    48,    49,
      50,    51,    52,    53,    54,    55,    56,    57,    58,    59,
      60,    61,    62,    63,    64,    65,    66,    67,    68,    69,
      70,    71,    72,    73,    74,    75,    76,    77,    78,    79,
      80,    81,    82,    83,    84,    85,    86,    87,    88,    89,
      90,    91,    92,    93,    94,    95,    96,    97,    98,    99,
     100,   101,     0,     0,     0,   102,   103,   104,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   105
};

static const yytype_int16 yycheck[] =
{
     124,   150,   478,   790,   588,   129,     1,   483,   588,   485,
       1,   487,   136,   137,   138,   599,   214,   601,     1,   599,
     517,   601,     1,   150,     1,   588,   599,   476,   601,     1,
     479,   647,   481,     1,     0,   619,   599,   140,   601,     1,
     489,     1,   491,     1,     1,   535,   604,     1,   637,     1,
       1,     1,   176,   177,   178,   588,     1,   547,     1,   939,
     550,   551,   552,     1,     1,     1,   599,   175,   601,   651,
     790,   653,   140,   179,   187,   181,     1,   661,   662,     1,
     664,   661,   662,   196,   871,     1,     1,   214,   661,   662,
     648,   588,     1,   590,   202,     1,     1,     1,   661,   662,
       1,   598,   599,   600,   601,   602,   986,     1,   140,     1,
       1,   608,     1,     1,   174,   175,   174,   175,   166,     1,
     158,   159,   619,  1003,   708,     1,   710,     1,   661,   662,
       1,     1,     1,   179,     1,     1,   171,     1,   727,     1,
       1,     1,   202,   181,   202,    10,   194,   934,   140,   598,
     196,   871,   939,     1,   158,   159,   738,     1,     1,     1,
     165,   166,   197,     9,   661,   662,   171,   664,   140,   753,
     754,     1,    11,   753,   754,     1,   171,   181,   675,   328,
     753,   754,   179,   765,   181,     1,   140,   663,   140,   140,
     753,   754,   171,    29,   185,   140,   983,   984,   985,   986,
     183,   328,   197,   180,   701,     1,   790,   994,   995,   996,
     790,   708,   174,   710,   934,   183,  1003,   185,   197,   939,
     753,   754,   838,   183,   174,   185,   183,   185,   812,   813,
     814,   815,   816,   817,   818,   819,   820,   821,   796,   182,
     716,   717,   718,   719,   180,   721,   790,   185,   185,   171,
       1,   173,   174,   175,   179,   837,   753,   754,   173,   184,
       1,   751,   171,   983,   984,   985,   986,   183,   174,    12,
     171,   140,   769,     1,   994,   995,   996,   182,   182,   776,
     202,   778,   173,  1003,     1,   173,   174,   871,   182,   786,
     182,   871,   174,   182,   791,   911,   494,   173,   788,   173,
     174,   499,   173,   800,   174,   503,   173,   174,   174,     1,
     174,   808,   174,   174,   174,   812,   813,   814,   815,   816,
     817,   818,   819,   820,   821,   173,    29,   871,   910,   171,
     174,   174,   822,   823,   824,   825,   952,   827,   174,   175,
     176,   177,   178,   140,   174,   171,     1,   931,     1,   185,
     934,   931,   801,   802,   934,   939,   853,   173,   931,   939,
     558,   977,     1,     1,     1,     1,   202,   494,   931,    13,
       1,   171,   499,   173,   174,     1,   503,   173,   174,   174,
     176,   177,     1,     1,     1,     1,   181,     1,   864,   185,
     934,   140,   179,   517,   181,   939,     1,     1,   931,   983,
     984,   985,   986,   983,   984,   985,   986,   140,     1,     1,
     994,   995,   996,   140,   994,   995,   996,   206,   207,  1003,
     171,   140,   173,  1003,     1,   922,     1,   179,    29,   181,
     906,   558,   173,   140,   931,   925,   926,     1,     1,   983,
     984,   985,   986,   171,     1,   173,   174,   140,   176,   177,
     994,   995,   996,     1,     1,   140,   173,   185,   948,  1003,
     140,     1,   165,   166,   588,     1,   590,     1,   171,   197,
     594,   174,   175,   165,   166,   599,     1,   601,     1,   171,
      29,     1,   174,   140,   608,   140,     1,     1,     3,     4,
       5,     6,     7,     8,     9,   140,   158,   159,     1,   202,
       1,     1,     1,    18,   653,    20,    21,    22,    23,    24,
      25,   140,   165,   166,   140,    30,    31,   179,   171,   181,
     174,   174,   175,     1,   648,     1,   179,   181,   181,   165,
     166,   140,   171,   171,   171,   171,     1,   661,   662,     1,
     171,     3,     4,     5,     6,     7,     8,     9,    14,   202,
       1,   675,   171,   171,   171,   171,    18,   171,    20,    21,
      22,    23,    24,    25,   165,   166,   171,   171,    30,    31,
     171,     1,     1,   174,   175,    21,    22,   701,   171,   171,
       1,   140,     3,     4,     5,     6,     7,     8,     9,   738,
     165,   166,    15,   174,   171,     1,   171,    18,     1,    20,
       1,   202,    23,    24,    25,     1,     1,   171,   171,    30,
      31,   140,     1,     1,   171,     1,   165,   166,   165,   166,
     135,   136,   171,   171,   171,   174,   175,   174,   175,   753,
     754,   171,   179,   140,   181,   171,   179,   171,   181,    16,
     165,   166,   165,   166,   768,     1,   171,     1,   171,   140,
       1,   171,   776,   202,   778,   202,   140,   171,   173,   140,
     175,     1,   786,     1,     1,   180,   165,   166,   171,   184,
     171,   171,   171,   135,   136,     1,   800,     3,     4,     5,
       6,     7,     8,     9,   808,     1,     1,   202,   140,   165,
     166,     1,    18,   171,    20,   171,   140,    23,    24,    25,
     165,   166,     1,     1,    30,    31,   171,   140,   158,   159,
       1,   173,     1,   175,   135,   136,    17,     1,   180,     1,
     171,   140,   184,     1,     1,   174,   140,   165,   166,   853,
     179,   181,   181,   171,   158,   159,   179,   175,   181,   174,
     202,   171,   171,     1,   182,     3,     4,     5,     6,     7,
       8,     9,   173,   179,   175,   181,   664,   181,   140,   180,
      18,   140,    20,   184,   202,   171,    24,    25,   171,   140,
     171,   169,    30,    31,   140,   171,   171,   140,   176,   177,
     178,   202,   171,   171,   182,   171,   184,   185,   179,     1,
     181,     3,     4,     5,     6,     7,     8,     9,   922,   179,
     708,   181,   710,   927,   174,   140,    18,   931,    20,   135,
     136,   181,    24,    25,   179,   171,   181,   171,    30,    31,
     171,     1,   140,     3,     4,     5,     6,     7,     8,     9,
     174,   171,   174,   171,   171,   174,   140,   181,    18,   181,
      20,   174,   181,   140,    24,    25,   140,   173,   181,   175,
      30,    31,   140,   871,   180,   171,   171,   179,   184,   181,
     140,   171,     1,   174,     3,     4,     5,     6,     7,     8,
       9,   171,   171,   171,   140,   140,   202,   135,   136,    18,
     171,    20,   171,   173,   140,    24,    25,   171,   171,   171,
     140,    30,    31,   171,   171,    22,   165,   166,   167,   168,
      27,    28,   140,   140,   812,   813,   814,   815,   816,   817,
     818,   819,   820,   821,   140,   173,   934,   175,   187,   176,
     177,   178,   180,   135,   136,   182,   184,   179,   185,   181,
       1,   140,     3,     4,     5,     6,     7,     8,     9,   173,
     174,   140,   176,   177,   202,   140,   179,    18,   181,    20,
     179,   185,   181,    24,    25,   135,   136,   140,   140,    30,
      31,   173,   179,   175,   181,   983,   984,   985,   180,   165,
     166,   179,   184,   181,   140,   171,   994,   995,   996,   175,
     165,   166,   179,   179,   181,   181,   171,   140,   140,   174,
     202,   140,   179,   173,   181,   175,   135,   136,   140,   140,
     180,   983,   984,   985,   184,   776,   202,   778,     1,   140,
       3,     4,     5,     6,     7,     8,     9,   176,   177,   178,
     140,   140,   202,   140,    64,    18,   185,    20,    64,   140,
     140,    24,    25,   140,   173,   140,   175,    30,    31,   140,
     140,   180,   140,   140,   140,   184,   140,   140,   140,     1,
     140,     3,     4,     5,     6,     7,     8,     9,   171,   140,
     140,   165,   166,   202,   135,   136,    18,   171,    20,   171,
     174,   175,    24,    25,   165,   166,   140,   140,    30,    31,
     171,   140,     1,   174,     3,     4,     5,     6,     7,     8,
       9,   173,   140,   140,   176,   177,   178,   140,   202,    18,
     174,    20,   173,   185,   175,    24,    25,   140,   140,   180,
     140,    30,    31,   184,   140,   197,   140,     1,   140,     3,
       4,     5,     6,     7,     8,     9,   140,   140,   140,   140,
     140,   202,   171,   171,    18,   196,    20,   171,   196,     1,
      24,    25,   135,   136,   171,   196,    30,    31,   188,   189,
     190,   191,   188,   189,   190,   191,   171,   176,   198,   199,
     200,   201,   198,   199,   200,   201,   171,   171,   171,     1,
     199,     3,     4,     5,     6,     7,     8,     9,   196,   196,
     173,   179,   175,   135,   136,   191,    18,   180,    20,   191,
     191,   184,    24,    25,   165,   166,   203,   186,    30,    31,
     171,   173,   183,   174,   175,   173,   171,   174,   171,   202,
     173,   174,   173,   176,   177,   173,   135,   136,   182,   179,
     167,   173,   185,   175,   180,   182,   173,   174,   180,   176,
     177,   202,   184,   182,   197,   186,   182,   182,   185,   182,
       1,   182,     3,     4,     5,     6,     7,     8,     9,   182,
     202,   135,   136,   182,   173,   182,   175,    18,   182,    20,
     186,   180,   196,    24,    25,   184,   186,   171,   186,    30,
      31,   160,   161,   162,   163,   164,   165,   166,   167,   168,
     186,   196,   173,   202,   171,   173,   169,   196,   174,   173,
      29,   175,   205,   176,   177,   178,   180,   186,   187,   182,
     184,   196,   185,   135,   136,     1,   179,     3,     4,     5,
       6,     7,     8,     9,   181,   181,   174,   174,   202,   173,
      29,   171,    18,   183,    20,   196,   171,   183,    24,    25,
     183,   183,   183,   181,    30,    31,   179,   181,   179,   181,
      26,   173,   181,   175,   181,   179,   181,   166,   180,   179,
     186,   168,   184,   181,   179,   179,   174,   183,   174,     1,
     174,     3,     4,     5,     6,     7,     8,     9,   174,   171,
     202,   183,   171,    25,   135,   136,    18,   181,    20,    19,
     181,   181,    24,    25,    21,   182,   180,   180,    30,    31,
     181,   181,   166,     3,     4,     5,     6,     7,     8,     9,
     141,   142,   143,   144,   145,   146,   147,   148,    18,   181,
     174,   171,   173,   184,   175,   171,   171,   196,   181,   180,
      30,    31,   181,   184,   181,   171,   196,   196,   204,   174,
     160,   161,   162,   163,   164,   165,   166,   167,   168,   135,
     136,   202,   171,    19,     3,     4,     5,     6,     7,     8,
       9,   181,   204,   174,   181,   205,   171,   187,   181,    18,
     171,    20,   205,   168,    23,    24,    25,   171,    25,   168,
     171,    30,    31,    25,   206,   206,   171,   173,   107,   175,
     566,   328,   148,   738,   180,   569,   745,   649,   184,   926,
     321,   800,   606,   135,   136,     3,     4,     5,     6,     7,
       8,     9,   929,   853,   583,    -1,   202,    -1,    -1,    -1,
      18,    -1,    20,    -1,    -1,    23,    24,    25,    -1,    -1,
      -1,    -1,    30,    31,    -1,   135,   136,    -1,    -1,    -1,
      -1,   173,    -1,   175,    -1,    -1,    -1,    -1,   180,    -1,
      -1,    -1,   184,   160,   161,   162,   163,   164,   165,   166,
     167,   168,    -1,    -1,    -1,   165,   166,    -1,    -1,   169,
     202,   171,    -1,   173,    -1,   175,    -1,    -1,    -1,    -1,
     187,    -1,   182,   183,    -1,   185,   135,   136,     3,     4,
       5,     6,     7,     8,     9,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   202,    -1,    -1,    -1,    -1,    -1,     3,     4,
       5,     6,     7,     8,     9,    30,    31,    -1,    -1,    -1,
      -1,    -1,    -1,    18,   173,    20,   175,    -1,    -1,    24,
      25,   180,    -1,    -1,   183,    30,    31,   135,   136,     3,
       4,     5,     6,     7,     8,     9,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   202,    18,    -1,    20,    -1,    -1,    -1,
      24,    25,    -1,    -1,    -1,    -1,    30,    31,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   173,    -1,   175,    -1,    -1,
      -1,    -1,   180,    -1,    -1,    -1,   184,    -1,     3,     4,
       5,     6,     7,     8,     9,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    18,   202,    20,    -1,    -1,    -1,    24,
      25,    -1,    -1,    -1,    -1,    30,    31,    -1,    -1,    -1,
     135,   136,   140,   141,   142,   143,   144,   145,   146,   147,
     148,   149,   150,   151,   152,   153,   154,   155,   156,   157,
     135,   136,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     165,   166,    -1,    -1,    -1,   170,   171,    -1,   173,   174,
     175,    -1,    -1,    -1,    -1,    -1,    -1,   182,    -1,    -1,
      -1,   135,   136,    -1,    -1,    -1,    -1,    -1,   173,    -1,
     175,   140,    -1,    -1,    -1,   180,    -1,   202,    -1,   184,
     149,   150,   151,   152,   153,   154,   155,   156,   157,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   202,    -1,   173,
      -1,   175,    -1,    -1,    -1,    -1,   180,    -1,    -1,   183,
     135,   136,     3,     4,     5,     6,     7,     8,     9,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    18,   202,    20,
      -1,    -1,    23,    24,    25,    -1,    -1,    -1,    -1,    30,
      31,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   173,    -1,
     175,    -1,    -1,    -1,    -1,   180,    -1,    -1,    -1,   184,
      -1,     3,     4,     5,     6,     7,     8,     9,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    18,   202,    20,    -1,
      -1,    -1,    24,    25,    -1,    -1,    -1,    -1,    30,    31,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   135,   136,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   173,    -1,   175,    -1,    -1,    -1,    -1,   180,
      -1,    -1,    -1,   135,   136,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   202,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   173,    -1,   175,     0,     1,    -1,    -1,   180,    -1,
      -1,    -1,    -1,     9,    10,    11,    12,    13,    14,    15,
      16,    17,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     202,    -1,    -1,    -1,    -1,    -1,    32,    33,    34,    35,
      36,    37,    38,    39,    40,    41,    42,    43,    44,    45,
      46,    47,    48,    49,    50,    51,    52,    53,    54,    55,
      56,    57,    -1,    59,    60,    61,    62,    63,    -1,    65,
      66,    67,    68,    69,    70,    71,    72,    73,    74,    75,
      76,    77,    78,    79,    80,    81,    82,    83,    84,    85,
      86,    87,    88,    89,    90,    91,    92,    93,    94,    95,
      96,    97,    98,    99,   100,   101,   102,   103,   104,   105,
     106,   107,   108,   109,   110,   111,   112,   113,   114,   115,
     116,   117,   118,   119,   120,   121,   122,   123,   124,   125,
     126,   127,   128,   129,   130,   131,   132,   133,    -1,    -1,
      -1,   137,   138,   139,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,     1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,     9,    10,    11,
      12,    13,    14,    15,    16,    17,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   195,
      32,    33,    34,    35,    36,    37,    38,    39,    40,    41,
      42,    43,    44,    45,    46,    47,    48,    49,    50,    51,
      52,    53,    54,    55,    56,    57,    -1,    59,    60,    61,
      62,    63,    -1,    65,    66,    67,    68,    69,    70,    71,
      72,    73,    74,    75,    76,    77,    78,    79,    80,    81,
      82,    83,    84,    85,    86,    87,    88,    89,    90,    91,
      92,    93,    94,    95,    96,    97,    98,    99,   100,   101,
     102,   103,   104,   105,   106,   107,   108,   109,   110,   111,
     112,   113,   114,   115,   116,   117,   118,   119,   120,   121,
     122,   123,   124,   125,   126,   127,   128,   129,   130,   131,
     132,   133,    -1,    -1,    -1,   137,   138,   139,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   195
};

/* YYSTOS[STATE-NUM] -- The symbol kind of the accessing symbol of
   state STATE-NUM.  */
static const yytype_int16 yystos[] =
{
       0,     1,    32,    33,    34,    35,    36,    37,    38,    39,
      40,    41,    42,    43,    44,    45,    46,    47,    48,    49,
      50,    51,    52,    53,    54,    55,    56,    57,    59,    60,
      61,    62,    63,    65,    66,    67,    68,    69,    70,    71,
      72,    73,    74,    75,    76,    77,    78,    79,    80,    81,
      82,    83,    84,    85,    86,    87,    88,    89,    90,    91,
      92,    93,    94,    95,    96,    97,    98,    99,   100,   101,
     102,   103,   104,   105,   106,   107,   108,   109,   110,   111,
     112,   113,   114,   115,   116,   117,   118,   119,   120,   121,
     122,   123,   124,   125,   126,   127,   128,   129,   130,   131,
     132,   133,   137,   138,   139,   195,   210,   211,   212,   213,
     214,   215,   216,   217,   218,   219,   220,   221,   247,   248,
     140,   140,   140,   140,   140,   140,   140,   140,   140,   140,
     140,   140,   140,   140,   140,   140,   140,   140,   140,   140,
     140,   140,   140,   140,   140,   140,   140,   140,   140,   140,
     140,   140,   140,   140,     1,   140,     1,   140,     1,   140,
       1,   140,     1,   140,     1,   140,   140,   140,   140,   140,
     140,   140,   140,   140,   140,   140,   140,   140,   140,   140,
     140,   140,   140,   140,   140,   140,   140,   140,   140,   140,
       1,   174,   140,     1,   182,   140,   140,   140,   140,   140,
     140,   140,   140,   140,   140,   140,   140,   140,   140,   140,
     140,   140,   140,   140,   140,   140,   140,   140,   140,   140,
     140,     1,   140,     1,   140,   140,   140,   140,   140,   140,
     140,   140,   140,   140,     0,     1,   212,     9,   257,    10,
     258,    11,   259,    12,   260,    13,   261,    14,   262,    15,
     263,    16,   264,    17,   265,     1,   171,     1,   171,     1,
     171,     1,   165,   166,   171,   228,     1,   171,     1,   171,
       1,   171,     1,   171,   228,     1,   174,     1,   171,     1,
     171,     1,   171,     1,   171,     1,   171,     1,   228,     1,
     228,     1,   228,   174,   174,     1,   171,     1,   171,     1,
     173,     1,   173,     1,   174,     1,   174,     1,   173,   225,
     230,   237,     1,   237,   174,     1,   171,   173,   174,   176,
     177,   185,   197,   222,   224,   225,   229,   231,   232,   233,
     249,   250,   251,   252,     1,   171,     1,   171,     1,   171,
     171,   171,   171,   171,   171,   171,     1,   171,     1,   171,
       1,   171,     1,   171,     1,   171,     1,   171,     1,   174,
       1,   171,     1,   174,     1,   171,     1,   228,     1,   228,
       1,   228,     1,   171,     1,   171,     1,   171,     1,   171,
       1,   171,     1,   171,     1,   171,     1,   171,     1,   171,
       1,   174,     1,   174,     1,   174,   174,     1,   171,     1,
     173,   174,     1,   173,   174,     1,   171,     1,   173,   174,
       1,   171,     1,   171,     1,   171,     1,   171,     1,   171,
       1,   171,     1,   173,     1,   173,     1,   171,     1,   171,
       1,   171,     1,   171,     1,   171,     1,   171,     1,   173,
     222,     1,   171,     1,   171,     1,   171,     1,   171,     1,
     171,     1,   171,   173,   171,   171,   173,   171,     1,   174,
       1,   174,     1,   171,     1,   171,     1,   173,   246,     1,
     171,   171,     1,   183,   185,     1,   185,     1,   183,   185,
       1,   185,     1,   183,     1,   183,     1,   183,     1,   185,
       1,   185,   171,   171,   196,   238,   196,     1,   251,   196,
     166,   194,   223,   196,   199,   233,   191,   179,   191,   187,
     196,   242,   203,   191,     3,     4,     5,     6,     7,     8,
       9,    18,    20,    24,    25,    30,    31,   135,   136,   173,
     175,   180,   202,   272,   277,   281,   283,   286,   287,   288,
     289,   299,   171,   173,   174,   255,   255,   281,   255,   255,
     281,   281,   281,   255,   255,   167,   222,    64,   188,   189,
     190,   191,   198,   199,   200,   201,   235,   236,     1,   174,
     240,   186,   222,     1,   173,   222,   173,   174,   173,    22,
      27,    28,   243,   244,   183,   171,   173,   182,   182,   182,
     182,   228,   272,     1,   182,     1,   182,     1,   182,   182,
     182,   182,   182,   182,   182,   182,   182,     1,   182,   140,
     149,   150,   151,   152,   153,   154,   155,   156,   157,   275,
     180,     1,   184,   283,     1,   180,   186,   186,   184,   186,
     186,   184,   184,   184,   179,   186,   196,   196,   173,   222,
     234,   171,   171,   173,   236,   240,   196,   196,   179,   179,
     242,   169,   178,   182,   184,   241,   245,   249,   253,   205,
     181,   169,   182,   183,   185,   228,   266,   272,   273,   274,
     277,   278,   286,   299,   181,   179,   181,   228,   272,     1,
     174,   228,     1,   174,     1,   255,   256,   272,   266,   272,
     266,   272,   174,   254,   174,   254,   173,   296,   296,     1,
     174,   179,   181,   228,   272,   294,    29,    29,   170,   174,
     182,   228,   272,   274,   276,   299,   183,   183,   183,   183,
     171,   183,     1,   171,   227,     1,   227,   196,     1,   171,
     197,   226,     1,   226,   174,   228,   254,   243,   182,   253,
     197,   225,   239,   253,     1,   179,   184,   171,   266,   266,
     184,   281,   276,   158,   159,   179,   181,   141,   142,   143,
     144,   145,   146,   147,   148,   267,   268,   269,   270,   271,
      29,   174,   228,   272,   297,   298,   179,   181,   179,   181,
     181,   181,   179,   181,   179,   181,   179,   181,   181,   181,
     181,    26,   174,   181,   174,   181,   179,   181,   181,     1,
     182,   179,   179,   181,   181,   174,   228,   272,   179,   181,
     276,   276,   160,   161,   162,   163,   164,   165,   166,   167,
     168,   187,   281,   281,   281,   281,   186,   281,   166,   179,
       1,   227,   181,   181,   181,   239,   253,   179,   179,   181,
     241,   168,   181,   184,   186,   266,   266,   174,    29,   253,
     228,   174,   272,   179,   181,   298,   298,   174,   174,    29,
     174,   228,   272,   295,   183,   280,   283,   183,    18,    23,
     180,   183,   277,   279,   284,   285,   287,   288,   289,   299,
     272,   174,   254,     1,   181,   294,   255,   255,   174,   228,
     272,   181,   276,   276,   276,   276,   276,   276,   276,   276,
     276,   276,   184,   184,   184,   184,   183,   184,   171,   171,
     179,   179,   181,   253,   226,    25,   181,   297,   181,   181,
     181,   181,   179,   181,   184,   281,    19,    21,   290,   291,
     292,   182,   180,   184,   282,   284,   180,     1,   180,   181,
     181,   181,   181,   181,   179,   181,   179,   181,   281,   166,
     253,   226,   179,   181,   181,   171,    29,   174,   228,   272,
     184,   280,   174,   228,   184,    22,   292,   293,   266,     1,
     184,   284,   279,   171,   174,   184,   171,   179,   181,   181,
     226,   206,   207,   196,   196,   196,   181,   181,   181,   226,
     179,   181,   204,   171,   282,   282,   282,   279,   179,   181,
     174,   171,   204,    19,   174,   181,   205,   171,   279,   181,
     171,   205,   168,   171,    25,   168,   171,    25,   206,   171,
     206
};

/* YYR1[RULE-NUM] -- Symbol kind of the left-hand side of rule RULE-NUM.  */
static const yytype_int16 yyr1[] =
{
       0,   209,   210,   211,   211,   211,   212,   212,   213,   212,
     214,   212,   215,   212,   216,   212,   217,   212,   218,   212,
     219,   212,   220,   212,   221,   212,   212,   222,   222,   222,
     223,   223,   224,   224,   224,   225,   226,   226,   227,   227,
     227,   227,   228,   228,   228,   229,   229,   229,   229,   230,
     230,   230,   230,   230,   230,   231,   231,   231,   231,   231,
     232,   232,   233,   233,   234,   234,   234,   235,   235,   235,
     235,   235,   235,   235,   235,   235,   236,   236,   237,   238,
     237,   239,   239,   240,   240,   241,   241,   241,   241,   241,
     241,   241,   241,   241,   241,   241,   241,   242,   242,   242,
     243,   243,   243,   244,   244,   245,   245,   245,   246,   246,
     246,   246,   247,   247,   247,   247,   247,   247,   247,   247,
     247,   247,   247,   247,   247,   247,   247,   247,   247,   247,
     247,   247,   247,   247,   247,   247,   247,   247,   247,   247,
     247,   247,   247,   247,   247,   247,   247,   247,   247,   247,
     247,   247,   247,   247,   247,   247,   247,   247,   247,   247,
     247,   247,   247,   247,   247,   247,   247,   247,   247,   247,
     247,   247,   247,   247,   247,   247,   247,   247,   247,   247,
     247,   247,   247,   247,   247,   247,   247,   247,   247,   247,
     247,   247,   247,   247,   247,   247,   247,   247,   247,   247,
     247,   247,   247,   247,   247,   247,   247,   247,   247,   247,
     247,   247,   247,   247,   247,   247,   247,   247,   247,   247,
     247,   247,   247,   247,   247,   247,   247,   247,   247,   247,
     247,   247,   247,   247,   247,   247,   247,   247,   247,   247,
     247,   247,   247,   247,   247,   247,   247,   247,   247,   247,
     247,   247,   247,   247,   247,   247,   247,   247,   247,   247,
     247,   247,   247,   247,   247,   247,   247,   247,   247,   247,
     247,   247,   247,   247,   247,   247,   247,   247,   247,   247,
     247,   247,   247,   247,   247,   247,   247,   247,   247,   247,
     247,   247,   247,   247,   247,   247,   247,   247,   247,   247,
     247,   247,   247,   247,   247,   247,   247,   247,   247,   247,
     247,   247,   247,   247,   247,   247,   247,   248,   248,   248,
     248,   248,   248,   249,   249,   250,   251,   252,   252,   253,
     253,   254,   254,   255,   255,   255,   256,   256,   257,   257,
     257,   258,   258,   259,   259,   259,   260,   260,   261,   261,
     262,   262,   263,   263,   264,   264,   265,   265,   266,   266,
     266,   266,   266,   266,   267,   267,   268,   268,   268,   268,
     269,   269,   270,   270,   271,   271,   271,   272,   272,   273,
     273,   273,   273,   274,   274,   274,   274,   274,   275,   275,
     275,   275,   275,   275,   275,   275,   275,   275,   276,   276,
     276,   276,   276,   276,   276,   276,   276,   276,   276,   276,
     276,   276,   276,   276,   276,   277,   277,   277,   278,   278,
     278,   278,   278,   279,   279,   279,   280,   280,   280,   281,
     281,   281,   282,   282,   282,   283,   283,   283,   283,   283,
     283,   283,   283,   284,   284,   284,   284,   284,   284,   284,
     284,   284,   285,   285,   286,   286,   287,   288,   289,   290,
     290,   291,   291,   292,   292,   292,   292,   293,   293,   294,
     294,   294,   294,   294,   294,   294,   294,   294,   294,   294,
     295,   295,   295,   295,   295,   295,   295,   295,   296,   296,
     296,   296,   297,   297,   297,   297,   298,   298,   299,   299,
     299,   299,   299,   299,   299,   299,   299,   299,   299,   299,
     299,   299,   299,   299,   299,   299,   299,   299,   299,   299,
     299,   299,   299,   299,   299,   299,   299,   299,   299,   299,
     299,   299,   299,   299,   299,   299,   299,   299,   299
};

/* YYR2[RULE-NUM] -- Number of symbols on the right-hand side of rule RULE-NUM.  */
static const yytype_int8 yyr2[] =
{
       0,     2,     1,     2,     1,     2,     1,     1,     0,     2,
       0,     2,     0,     2,     0,     2,     0,     2,     0,     2,
       0,     2,     0,     2,     0,     2,     1,     1,     1,     1,
       1,     1,     1,     3,     3,     1,     1,     1,     5,     3,
       3,     1,     1,     2,     2,     3,     5,     5,     2,     3,
       3,     5,     5,     5,     5,     1,     3,     5,     5,     1,
       1,     2,     1,     2,     1,     3,     3,     1,     1,     1,
       1,     2,     2,     2,     2,     2,     1,     2,     1,     0,
       3,     1,     1,     1,     2,     9,    10,     7,     8,     5,
       6,     5,     6,     3,     4,     1,     2,     4,     3,     0,
       1,     1,     1,     3,     1,     3,     1,     2,    18,    17,
      10,     9,     3,     3,     3,     3,     3,     3,     3,     3,
       3,     3,     3,     3,     3,     3,     3,     3,     3,     3,
       3,     3,     3,     3,     3,     3,     3,     3,     3,     3,
       3,     3,     3,     3,     3,     3,     3,     3,     3,     3,
       3,     3,     3,     3,     3,     3,     2,     3,     2,     3,
       2,     3,     2,     3,     2,     3,     2,     3,     3,     3,
       3,     3,     5,     3,     3,     5,     3,     3,     3,     3,
       3,     3,     3,     3,     3,     3,     3,     3,     3,     3,
       3,     3,     3,     3,     3,     3,     3,     3,     3,     3,
       3,     3,     3,     3,     3,     3,     3,     3,     3,     3,
       3,     3,     3,     3,     3,     3,     3,     3,     3,     3,
       3,     3,     3,     3,     3,     3,     3,     3,     5,     3,
       3,     3,     3,     3,     3,     3,     3,     3,     3,     3,
       3,     3,     3,     3,     3,     3,     3,     3,     3,     3,
       3,     3,     3,     3,     3,     3,     3,     3,     3,     3,
       3,     3,     3,     3,     3,     3,     3,     3,     3,     3,
       3,     3,     3,     3,     5,     5,     3,     3,     3,     3,
       3,     3,     3,     3,     3,     3,     3,     3,     3,     3,
       3,     3,     3,     3,     3,     3,     3,     3,     2,     3,
       2,     6,     4,     3,     3,     3,     3,     3,     3,     3,
       3,     3,     3,     3,     3,     3,     2,     2,     2,     8,
       8,     8,     2,     1,     1,     1,     1,     1,     3,     1,
       1,     2,     2,     1,     1,     1,     1,     1,     4,     7,
       2,     7,     2,     4,     7,     2,     7,     2,     4,     2,
       4,     2,     4,     2,     9,     2,     7,     2,     3,     3,
       2,     3,     3,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     3,     3,     3,     3,     3,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     3,     3,     3,     3,     3,     3,     3,
       3,     3,     3,     2,     3,     3,     3,     3,     1,     1,
       1,     3,     2,     1,     3,     2,     1,     3,     2,     2,
       1,     2,     2,     1,     2,     2,     1,     1,     1,     1,
       2,     1,     2,     2,     2,     1,     1,     1,     1,     2,
       1,     2,     5,     7,     5,     7,     5,     7,     7,     2,
       1,     2,     1,     4,     3,     4,     3,     3,     2,     1,
       3,     1,     2,     2,     1,     2,     3,     1,     2,     3,
       1,     1,     1,     1,     3,     3,     3,     3,     3,     4,
       4,     2,     1,     1,     1,     1,     1,     3,     6,     4,
       1,     3,     1,     3,     2,     4,     6,     2,     4,     6,
       3,     5,     1,     4,     6,     2,     4,     6,     2,     4,
       4,     6,     2,     4,     3,     4,     4,     2,     4,     4,
       4,     4,     6,     6,     6,     8,     8,     6,     4
};


enum { YYENOMEM = -2 };

#define yyerrok         (yyerrstatus = 0)
#define yyclearin       (yychar = YYEMPTY)

#define YYACCEPT        goto yyacceptlab
#define YYABORT         goto yyabortlab
#define YYERROR         goto yyerrorlab
#define YYNOMEM         goto yyexhaustedlab


#define YYRECOVERING()  (!!yyerrstatus)

#define YYBACKUP(Token, Value)                                    \
  do                                                              \
    if (yychar == YYEMPTY)                                        \
      {                                                           \
        yychar = (Token);                                         \
        yylval = (Value);                                         \
        YYPOPSTACK (yylen);                                       \
        yystate = *yyssp;                                         \
        goto yybackup;                                            \
      }                                                           \
    else                                                          \
      {                                                           \
        yyerror (YY_("syntax error: cannot back up")); \
        YYERROR;                                                  \
      }                                                           \
  while (0)

/* Backward compatibility with an undocumented macro.
   Use YYerror or YYUNDEF. */
#define YYERRCODE YYUNDEF


/* Enable debugging if requested.  */
#if YYDEBUG

# ifndef YYFPRINTF
#  include <stdio.h> /* INFRINGES ON USER NAME SPACE */
#  define YYFPRINTF fprintf
# endif

# define YYDPRINTF(Args)                        \
do {                                            \
  if (yydebug)                                  \
    YYFPRINTF Args;                             \
} while (0)




# define YY_SYMBOL_PRINT(Title, Kind, Value, Location)                    \
do {                                                                      \
  if (yydebug)                                                            \
    {                                                                     \
      YYFPRINTF (stderr, "%s ", Title);                                   \
      yy_symbol_print (stderr,                                            \
                  Kind, Value); \
      YYFPRINTF (stderr, "\n");                                           \
    }                                                                     \
} while (0)


/*-----------------------------------.
| Print this symbol's value on YYO.  |
`-----------------------------------*/

static void
yy_symbol_value_print (FILE *yyo,
                       yysymbol_kind_t yykind, YYSTYPE const * const yyvaluep)
{
  FILE *yyoutput = yyo;
  YY_USE (yyoutput);
  if (!yyvaluep)
    return;
  YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
  YY_USE (yykind);
  YY_IGNORE_MAYBE_UNINITIALIZED_END
}


/*---------------------------.
| Print this symbol on YYO.  |
`---------------------------*/

static void
yy_symbol_print (FILE *yyo,
                 yysymbol_kind_t yykind, YYSTYPE const * const yyvaluep)
{
  YYFPRINTF (yyo, "%s %s (",
             yykind < YYNTOKENS ? "token" : "nterm", yysymbol_name (yykind));

  yy_symbol_value_print (yyo, yykind, yyvaluep);
  YYFPRINTF (yyo, ")");
}

/*------------------------------------------------------------------.
| yy_stack_print -- Print the state stack from its BOTTOM up to its |
| TOP (included).                                                   |
`------------------------------------------------------------------*/

static void
yy_stack_print (yy_state_t *yybottom, yy_state_t *yytop)
{
  YYFPRINTF (stderr, "Stack now");
  for (; yybottom <= yytop; yybottom++)
    {
      int yybot = *yybottom;
      YYFPRINTF (stderr, " %d", yybot);
    }
  YYFPRINTF (stderr, "\n");
}

# define YY_STACK_PRINT(Bottom, Top)                            \
do {                                                            \
  if (yydebug)                                                  \
    yy_stack_print ((Bottom), (Top));                           \
} while (0)


/*------------------------------------------------.
| Report that the YYRULE is going to be reduced.  |
`------------------------------------------------*/

static void
yy_reduce_print (yy_state_t *yyssp, YYSTYPE *yyvsp,
                 int yyrule)
{
  int yylno = yyrline[yyrule];
  int yynrhs = yyr2[yyrule];
  int yyi;
  YYFPRINTF (stderr, "Reducing stack by rule %d (line %d):\n",
             yyrule - 1, yylno);
  /* The symbols being reduced.  */
  for (yyi = 0; yyi < yynrhs; yyi++)
    {
      YYFPRINTF (stderr, "   $%d = ", yyi + 1);
      yy_symbol_print (stderr,
                       YY_ACCESSING_SYMBOL (+yyssp[yyi + 1 - yynrhs]),
                       &yyvsp[(yyi + 1) - (yynrhs)]);
      YYFPRINTF (stderr, "\n");
    }
}

# define YY_REDUCE_PRINT(Rule)          \
do {                                    \
  if (yydebug)                          \
    yy_reduce_print (yyssp, yyvsp, Rule); \
} while (0)

/* Nonzero means print parse trace.  It is left uninitialized so that
   multiple parsers can coexist.  */
int yydebug;
#else /* !YYDEBUG */
# define YYDPRINTF(Args) ((void) 0)
# define YY_SYMBOL_PRINT(Title, Kind, Value, Location)
# define YY_STACK_PRINT(Bottom, Top)
# define YY_REDUCE_PRINT(Rule)
#endif /* !YYDEBUG */


/* YYINITDEPTH -- initial size of the parser's stacks.  */
#ifndef YYINITDEPTH
# define YYINITDEPTH 200
#endif

/* YYMAXDEPTH -- maximum size the stacks can grow to (effective only
   if the built-in stack extension method is used).

   Do not make this value too large; the results are undefined if
   YYSTACK_ALLOC_MAXIMUM < YYSTACK_BYTES (YYMAXDEPTH)
   evaluated with infinite-precision integer arithmetic.  */

#ifndef YYMAXDEPTH
# define YYMAXDEPTH 10000
#endif






/*-----------------------------------------------.
| Release the memory associated to this symbol.  |
`-----------------------------------------------*/

static void
yydestruct (const char *yymsg,
            yysymbol_kind_t yykind, YYSTYPE *yyvaluep)
{
  YY_USE (yyvaluep);
  if (!yymsg)
    yymsg = "Deleting";
  YY_SYMBOL_PRINT (yymsg, yykind, yyvaluep, yylocationp);

  YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
  YY_USE (yykind);
  YY_IGNORE_MAYBE_UNINITIALIZED_END
}


/* Lookahead token kind.  */
int yychar;

/* The semantic value of the lookahead symbol.  */
YYSTYPE yylval;
/* Number of syntax errors so far.  */
int yynerrs;




/*----------.
| yyparse.  |
`----------*/

int
yyparse (void)
{
    yy_state_fast_t yystate = 0;
    /* Number of tokens to shift before error messages enabled.  */
    int yyerrstatus = 0;

    /* Refer to the stacks through separate pointers, to allow yyoverflow
       to reallocate them elsewhere.  */

    /* Their size.  */
    YYPTRDIFF_T yystacksize = YYINITDEPTH;

    /* The state stack: array, bottom, top.  */
    yy_state_t yyssa[YYINITDEPTH];
    yy_state_t *yyss = yyssa;
    yy_state_t *yyssp = yyss;

    /* The semantic value stack: array, bottom, top.  */
    YYSTYPE yyvsa[YYINITDEPTH];
    YYSTYPE *yyvs = yyvsa;
    YYSTYPE *yyvsp = yyvs;

  int yyn;
  /* The return value of yyparse.  */
  int yyresult;
  /* Lookahead symbol kind.  */
  yysymbol_kind_t yytoken = YYSYMBOL_YYEMPTY;
  /* The variables used to return semantic value and location from the
     action routines.  */
  YYSTYPE yyval;



#define YYPOPSTACK(N)   (yyvsp -= (N), yyssp -= (N))

  /* The number of symbols on the RHS of the reduced rule.
     Keep to zero when no symbol should be popped.  */
  int yylen = 0;

  YYDPRINTF ((stderr, "Starting parse\n"));

  yychar = YYEMPTY; /* Cause a token to be read.  */

  goto yysetstate;


/*------------------------------------------------------------.
| yynewstate -- push a new state, which is found in yystate.  |
`------------------------------------------------------------*/
yynewstate:
  /* In all cases, when you get here, the value and location stacks
     have just been pushed.  So pushing a state here evens the stacks.  */
  yyssp++;


/*--------------------------------------------------------------------.
| yysetstate -- set current state (the top of the stack) to yystate.  |
`--------------------------------------------------------------------*/
yysetstate:
  YYDPRINTF ((stderr, "Entering state %d\n", yystate));
  YY_ASSERT (0 <= yystate && yystate < YYNSTATES);
  YY_IGNORE_USELESS_CAST_BEGIN
  *yyssp = YY_CAST (yy_state_t, yystate);
  YY_IGNORE_USELESS_CAST_END
  YY_STACK_PRINT (yyss, yyssp);

  if (yyss + yystacksize - 1 <= yyssp)
#if !defined yyoverflow && !defined YYSTACK_RELOCATE
    YYNOMEM;
#else
    {
      /* Get the current used size of the three stacks, in elements.  */
      YYPTRDIFF_T yysize = yyssp - yyss + 1;

# if defined yyoverflow
      {
        /* Give user a chance to reallocate the stack.  Use copies of
           these so that the &'s don't force the real ones into
           memory.  */
        yy_state_t *yyss1 = yyss;
        YYSTYPE *yyvs1 = yyvs;

        /* Each stack pointer address is followed by the size of the
           data in use in that stack, in bytes.  This used to be a
           conditional around just the two extra args, but that might
           be undefined if yyoverflow is a macro.  */
        yyoverflow (YY_("memory exhausted"),
                    &yyss1, yysize * YYSIZEOF (*yyssp),
                    &yyvs1, yysize * YYSIZEOF (*yyvsp),
                    &yystacksize);
        yyss = yyss1;
        yyvs = yyvs1;
      }
# else /* defined YYSTACK_RELOCATE */
      /* Extend the stack our own way.  */
      if (YYMAXDEPTH <= yystacksize)
        YYNOMEM;
      yystacksize *= 2;
      if (YYMAXDEPTH < yystacksize)
        yystacksize = YYMAXDEPTH;

      {
        yy_state_t *yyss1 = yyss;
        union yyalloc *yyptr =
          YY_CAST (union yyalloc *,
                   YYSTACK_ALLOC (YY_CAST (YYSIZE_T, YYSTACK_BYTES (yystacksize))));
        if (! yyptr)
          YYNOMEM;
        YYSTACK_RELOCATE (yyss_alloc, yyss);
        YYSTACK_RELOCATE (yyvs_alloc, yyvs);
#  undef YYSTACK_RELOCATE
        if (yyss1 != yyssa)
          YYSTACK_FREE (yyss1);
      }
# endif

      yyssp = yyss + yysize - 1;
      yyvsp = yyvs + yysize - 1;

      YY_IGNORE_USELESS_CAST_BEGIN
      YYDPRINTF ((stderr, "Stack size increased to %ld\n",
                  YY_CAST (long, yystacksize)));
      YY_IGNORE_USELESS_CAST_END

      if (yyss + yystacksize - 1 <= yyssp)
        YYABORT;
    }
#endif /* !defined yyoverflow && !defined YYSTACK_RELOCATE */


  if (yystate == YYFINAL)
    YYACCEPT;

  goto yybackup;


/*-----------.
| yybackup.  |
`-----------*/
yybackup:
  /* Do appropriate processing given the current state.  Read a
     lookahead token if we need one and don't already have one.  */

  /* First try to decide what to do without reference to lookahead token.  */
  yyn = yypact[yystate];
  if (yypact_value_is_default (yyn))
    goto yydefault;

  /* Not known => get a lookahead token if don't already have one.  */

  /* YYCHAR is either empty, or end-of-input, or a valid lookahead.  */
  if (yychar == YYEMPTY)
    {
      YYDPRINTF ((stderr, "Reading a token\n"));
      yychar = yylex ();
    }

  if (yychar <= YYEOF)
    {
      yychar = YYEOF;
      yytoken = YYSYMBOL_YYEOF;
      YYDPRINTF ((stderr, "Now at end of input.\n"));
    }
  else if (yychar == YYerror)
    {
      /* The scanner already issued an error message, process directly
         to error recovery.  But do not keep the error token as
         lookahead, it is too special and may lead us to an endless
         loop in error recovery. */
      yychar = YYUNDEF;
      yytoken = YYSYMBOL_YYerror;
      goto yyerrlab1;
    }
  else
    {
      yytoken = YYTRANSLATE (yychar);
      YY_SYMBOL_PRINT ("Next token is", yytoken, &yylval, &yylloc);
    }

  /* If the proper action on seeing token YYTOKEN is to reduce or to
     detect an error, take that action.  */
  yyn += yytoken;
  if (yyn < 0 || YYLAST < yyn || yycheck[yyn] != yytoken)
    goto yydefault;
  yyn = yytable[yyn];
  if (yyn <= 0)
    {
      if (yytable_value_is_error (yyn))
        goto yyerrlab;
      yyn = -yyn;
      goto yyreduce;
    }

  /* Count tokens shifted since error; after three, turn off error
     status.  */
  if (yyerrstatus)
    yyerrstatus--;

  /* Shift the lookahead token.  */
  YY_SYMBOL_PRINT ("Shifting", yytoken, &yylval, &yylloc);
  yystate = yyn;
  YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
  *++yyvsp = yylval;
  YY_IGNORE_MAYBE_UNINITIALIZED_END

  /* Discard the shifted token.  */
  yychar = YYEMPTY;
  goto yynewstate;


/*-----------------------------------------------------------.
| yydefault -- do the default action for the current state.  |
`-----------------------------------------------------------*/
yydefault:
  yyn = yydefact[yystate];
  if (yyn == 0)
    goto yyerrlab;
  goto yyreduce;


/*-----------------------------.
| yyreduce -- do a reduction.  |
`-----------------------------*/
yyreduce:
  /* yyn is the number of a rule to reduce with.  */
  yylen = yyr2[yyn];

  /* If YYLEN is nonzero, implement the default value of the action:
     '$$ = $1'.

     Otherwise, the following line sets YYVAL to garbage.
     This behavior is undocumented and Bison
     users should not rely upon it.  Assigning to YYVAL
     unconditionally makes the parser a bit smaller, and it avoids a
     GCC warning that YYVAL may be used uninitialized.  */
  yyval = yyvsp[1-yylen];


  YY_REDUCE_PRINT (yyn);
  switch (yyn)
    {
  case 3: /* statements: statements statement  */
#line 530 "cfg.y"
                                     {}
#line 2556 "cfg.tab.c"
    break;

  case 4: /* statements: statement  */
#line 531 "cfg.y"
                            {}
#line 2562 "cfg.tab.c"
    break;

  case 5: /* statements: statements error  */
#line 532 "cfg.y"
                                   { yyerror(""); YYABORT;}
#line 2568 "cfg.tab.c"
    break;

  case 8: /* $@1: %empty  */
#line 537 "cfg.y"
                  {rt=REQUEST_ROUTE;}
#line 2574 "cfg.tab.c"
    break;

  case 10: /* $@2: %empty  */
#line 538 "cfg.y"
                  {rt=FAILURE_ROUTE;}
#line 2580 "cfg.tab.c"
    break;

  case 12: /* $@3: %empty  */
#line 539 "cfg.y"
                  {rt=ONREPLY_ROUTE;}
#line 2586 "cfg.tab.c"
    break;

  case 14: /* $@4: %empty  */
#line 540 "cfg.y"
                  {rt=BRANCH_ROUTE;}
#line 2592 "cfg.tab.c"
    break;

  case 16: /* $@5: %empty  */
#line 541 "cfg.y"
                  {rt=ERROR_ROUTE;}
#line 2598 "cfg.tab.c"
    break;

  case 18: /* $@6: %empty  */
#line 542 "cfg.y"
                  {rt=LOCAL_ROUTE;}
#line 2604 "cfg.tab.c"
    break;

  case 20: /* $@7: %empty  */
#line 543 "cfg.y"
                  {rt=STARTUP_ROUTE;}
#line 2610 "cfg.tab.c"
    break;

  case 22: /* $@8: %empty  */
#line 544 "cfg.y"
                  {rt=TIMER_ROUTE;}
#line 2616 "cfg.tab.c"
    break;

  case 24: /* $@9: %empty  */
#line 545 "cfg.y"
                  {rt=EVENT_ROUTE;}
#line 2622 "cfg.tab.c"
    break;

  case 27: /* listen_id: ip  */
#line 550 "cfg.y"
                                        { IFOR();
							tmp=ip_addr2a((yyvsp[0].ipaddr));
							if(tmp==0){
								LM_CRIT("cfg. parser: bad ip address.\n");
								(yyval.strval)=0;
							}else{
								(yyval.strval)=pkg_malloc(strlen(tmp)+1);
								if ((yyval.strval)==0){
									LM_CRIT("cfg. parser: out of memory.\n");
									YYABORT;
								}else{
									memcpy((yyval.strval), tmp, strlen(tmp)+1);
								}
							}
						}
#line 2642 "cfg.tab.c"
    break;

  case 28: /* listen_id: STRING  */
#line 565 "cfg.y"
                                        { IFOR();
							(yyval.strval)=pkg_malloc(strlen((yyvsp[0].strval))+1);
							if ((yyval.strval)==0){
									LM_CRIT("cfg. parser: out of memory.\n");
									YYABORT;
							}else{
									memcpy((yyval.strval), (yyvsp[0].strval), strlen((yyvsp[0].strval))+1);
							}
						}
#line 2656 "cfg.tab.c"
    break;

  case 29: /* listen_id: host  */
#line 574 "cfg.y"
                                        { IFOR();
							if ((yyvsp[0].strval)==0) {
								(yyval.strval) = 0;
							} else {
								(yyval.strval)=pkg_malloc(strlen((yyvsp[0].strval))+1);
								if ((yyval.strval)==0){
									LM_CRIT("cfg. parser: out of memory.\n");
									YYABORT;
								}else{
									memcpy((yyval.strval), (yyvsp[0].strval), strlen((yyvsp[0].strval))+1);
								}
							}
						}
#line 2674 "cfg.tab.c"
    break;

  case 30: /* host_sep: DOT  */
#line 589 "cfg.y"
                    {(yyval.strval)=".";}
#line 2680 "cfg.tab.c"
    break;

  case 31: /* host_sep: MINUS  */
#line 590 "cfg.y"
                              {(yyval.strval)="-"; }
#line 2686 "cfg.tab.c"
    break;

  case 32: /* host: ID  */
#line 593 "cfg.y"
                                        { (yyval.strval)=(yyvsp[0].strval); }
#line 2692 "cfg.tab.c"
    break;

  case 33: /* host: host host_sep ID  */
#line 594 "cfg.y"
                                { IFOR();
						(yyval.strval)=(char*)pkg_malloc(strlen((yyvsp[-2].strval))+1+strlen((yyvsp[0].strval))+1);
						if ((yyval.strval)==0){
							LM_CRIT("cfg. parser: memory allocation"
										" failure while parsing host\n");
							YYABORT;
						}else{
							memcpy((yyval.strval), (yyvsp[-2].strval), strlen((yyvsp[-2].strval)));
							(yyval.strval)[strlen((yyvsp[-2].strval))]=*(yyvsp[-1].strval);
							memcpy((yyval.strval)+strlen((yyvsp[-2].strval))+1, (yyvsp[0].strval), strlen((yyvsp[0].strval)));
							(yyval.strval)[strlen((yyvsp[-2].strval))+1+strlen((yyvsp[0].strval))]=0;
						}
						pkg_free((yyvsp[-2].strval)); pkg_free((yyvsp[0].strval));
					}
#line 2711 "cfg.tab.c"
    break;

  case 34: /* host: host DOT error  */
#line 608 "cfg.y"
                         { (yyval.strval)=0; pkg_free((yyvsp[-2].strval));
					yyerror("invalid hostname (use quotes if hostname "
						"has config keywords)"); }
#line 2719 "cfg.tab.c"
    break;

  case 35: /* proto: ID  */
#line 613 "cfg.y"
           { IFOR();
		if (parse_proto((unsigned char *)(yyvsp[0].strval), strlen((yyvsp[0].strval)), &i_tmp) < 0) {
			yyerrorf("cannot handle protocol <%s>\n", (yyvsp[0].strval));
			YYABORT;
		}
		pkg_free((yyvsp[0].strval));
		(yyval.intval) = i_tmp;
	 }
#line 2732 "cfg.tab.c"
    break;

  case 36: /* port: NUMBER  */
#line 623 "cfg.y"
                        { (yyval.intval)=(yyvsp[0].intval); }
#line 2738 "cfg.tab.c"
    break;

  case 37: /* port: ANY  */
#line 624 "cfg.y"
                                { (yyval.intval)=0; }
#line 2744 "cfg.tab.c"
    break;

  case 38: /* portrange: portrange COMMA NUMBER MINUS NUMBER  */
#line 627 "cfg.y"
                                               { IFOR();
				if ((yyvsp[-2].intval) > (yyvsp[0].intval)) {
					yyerrorf("invalid port range (%d > %d)\n", (int)(yyvsp[-2].intval), (int)(yyvsp[0].intval));
					YYABORT;
				}
				pr_tmp = mk_port_range((yyvsp[-2].intval), (yyvsp[0].intval));
				if (!pr_tmp) {
					yyerror("cannot allocate new portrange\n");
					YYABORT;
				}
				pr_tmp->next = (yyvsp[-4].portrange);
				(yyval.portrange) = pr_tmp;
			}
#line 2762 "cfg.tab.c"
    break;

  case 39: /* portrange: portrange COMMA NUMBER  */
#line 640 "cfg.y"
                                          { IFOR();
				pr_tmp = mk_port_range((yyvsp[0].intval), (yyvsp[0].intval));
				if (!pr_tmp) {
					yyerror("cannot allocate new portrange\n");
					YYABORT;
				}
				pr_tmp->next = (yyvsp[-2].portrange);
				(yyval.portrange) = pr_tmp;
			}
#line 2776 "cfg.tab.c"
    break;

  case 40: /* portrange: NUMBER MINUS NUMBER  */
#line 649 "cfg.y"
                                       { IFOR();
				if ((yyvsp[-2].intval) > (yyvsp[0].intval)) {
					yyerrorf("invalid port range (%d > %d)\n", (int)(yyvsp[-2].intval), (int)(yyvsp[0].intval));
					YYABORT;
				}
				(yyval.portrange)=mk_port_range((yyvsp[-2].intval), (yyvsp[0].intval));
			}
#line 2788 "cfg.tab.c"
    break;

  case 41: /* portrange: NUMBER  */
#line 656 "cfg.y"
                          { IFOR(); (yyval.portrange)=mk_port_range((yyvsp[0].intval), (yyvsp[0].intval)); }
#line 2794 "cfg.tab.c"
    break;

  case 42: /* snumber: NUMBER  */
#line 658 "cfg.y"
                        { (yyval.intval)=(yyvsp[0].intval); }
#line 2800 "cfg.tab.c"
    break;

  case 43: /* snumber: PLUS NUMBER  */
#line 659 "cfg.y"
                                { (yyval.intval)=(yyvsp[0].intval); }
#line 2806 "cfg.tab.c"
    break;

  case 44: /* snumber: MINUS NUMBER  */
#line 660 "cfg.y"
                                { (yyval.intval)=-(yyvsp[0].intval); }
#line 2812 "cfg.tab.c"
    break;

  case 45: /* phostport: proto COLON listen_id  */
#line 664 "cfg.y"
                                        { IFOR();
				(yyval.sockid)=mk_listen_id((yyvsp[0].strval), (yyvsp[-2].intval), 0); }
#line 2819 "cfg.tab.c"
    break;

  case 46: /* phostport: proto COLON listen_id COLON port  */
#line 666 "cfg.y"
                                                                { IFOR();
				(yyval.sockid)=mk_listen_id((yyvsp[-2].strval), (yyvsp[-4].intval), (yyvsp[0].intval));}
#line 2826 "cfg.tab.c"
    break;

  case 47: /* phostport: proto COLON listen_id COLON error  */
#line 668 "cfg.y"
                                                            {
				(yyval.sockid)=0;
				yyerror("port number expected");
				YYABORT;
				}
#line 2836 "cfg.tab.c"
    break;

  case 48: /* phostport: NUMBER error  */
#line 673 "cfg.y"
                                       { (yyval.sockid)=0;
				yyerror("protocol expected");
				YYABORT;
			}
#line 2845 "cfg.tab.c"
    break;

  case 49: /* phostportrange: proto COLON MULT  */
#line 681 "cfg.y"
                                                                { IFOR();
				(yyval.sockid)=mk_listen_id(0, (yyvsp[-2].intval), 0); }
#line 2852 "cfg.tab.c"
    break;

  case 50: /* phostportrange: proto COLON listen_id  */
#line 683 "cfg.y"
                                                { IFOR();
				(yyval.sockid)=mk_listen_id_range((yyvsp[0].strval), (yyvsp[-2].intval), 0); }
#line 2859 "cfg.tab.c"
    break;

  case 51: /* phostportrange: proto COLON MULT COLON portrange  */
#line 685 "cfg.y"
                                                                { IFOR();
				(yyval.sockid)=mk_listen_id_range(0, (yyvsp[-4].intval), (yyvsp[0].portrange)); }
#line 2866 "cfg.tab.c"
    break;

  case 52: /* phostportrange: proto COLON listen_id COLON portrange  */
#line 687 "cfg.y"
                                                                { IFOR();
				(yyval.sockid)=mk_listen_id_range((yyvsp[-2].strval), (yyvsp[-4].intval), (yyvsp[0].portrange)); }
#line 2873 "cfg.tab.c"
    break;

  case 53: /* phostportrange: proto COLON MULT COLON error  */
#line 689 "cfg.y"
                                                        { IFOR();
				(yyval.sockid)=0;
				yyerror("invalid port range");
				YYABORT;
			}
#line 2883 "cfg.tab.c"
    break;

  case 54: /* phostportrange: proto COLON listen_id COLON error  */
#line 694 "cfg.y"
                                                                { IFOR();
				(yyval.sockid)=0;
				yyerror("invalid port range");
				YYABORT;
			}
#line 2893 "cfg.tab.c"
    break;

  case 55: /* any_alias: listen_id  */
#line 701 "cfg.y"
                                                                        { IFOR();
				(yyval.sockid)=mk_listen_id((yyvsp[0].strval), PROTO_NONE, 0); }
#line 2900 "cfg.tab.c"
    break;

  case 56: /* any_alias: ANY COLON listen_id  */
#line 703 "cfg.y"
                                                                        { IFOR();
		 		(yyval.sockid)=mk_listen_id((yyvsp[0].strval), PROTO_NONE, 0); }
#line 2907 "cfg.tab.c"
    break;

  case 57: /* any_alias: ANY COLON listen_id COLON port  */
#line 705 "cfg.y"
                                                        { IFOR();
		 		(yyval.sockid)=mk_listen_id((yyvsp[-2].strval), PROTO_NONE, (yyvsp[0].intval)); }
#line 2914 "cfg.tab.c"
    break;

  case 58: /* any_alias: ANY COLON listen_id COLON error  */
#line 707 "cfg.y"
                                                        {
				(yyval.sockid)=0;
				yyerror(" port number expected");
				}
#line 2923 "cfg.tab.c"
    break;

  case 60: /* alias_def: any_alias  */
#line 714 "cfg.y"
                                              { (yyval.sockid)=(yyvsp[0].sockid); }
#line 2929 "cfg.tab.c"
    break;

  case 61: /* alias_def: any_alias ACCEPT_SUBDOMAIN  */
#line 715 "cfg.y"
                                              {
				(yyval.sockid)=(yyvsp[-1].sockid);
				(yyval.sockid)->flags |= SI_ACCEPT_SUBDOMAIN_ALIAS;
				}
#line 2938 "cfg.tab.c"
    break;

  case 62: /* id_lst: alias_def  */
#line 721 "cfg.y"
                                        { IFOR();  (yyval.sockid)=(yyvsp[0].sockid) ; }
#line 2944 "cfg.tab.c"
    break;

  case 63: /* id_lst: alias_def id_lst  */
#line 722 "cfg.y"
                                        { IFOR(); (yyval.sockid)=(yyvsp[-1].sockid); (yyval.sockid)->next=(yyvsp[0].sockid); }
#line 2950 "cfg.tab.c"
    break;

  case 64: /* listen_id_def: listen_id  */
#line 725 "cfg.y"
                                                                { IFOR();
					(yyval.sockid)=mk_listen_id((yyvsp[0].strval), PROTO_NONE, 0); }
#line 2957 "cfg.tab.c"
    break;

  case 65: /* listen_id_def: listen_id COLON portrange  */
#line 727 "cfg.y"
                                                                { IFOR();
					(yyval.sockid)=mk_listen_id_range((yyvsp[-2].strval), PROTO_NONE, (yyvsp[0].portrange)); }
#line 2964 "cfg.tab.c"
    break;

  case 66: /* listen_id_def: listen_id COLON error  */
#line 729 "cfg.y"
                                                      {
					(yyval.sockid)=0;
					yyerror(" port number expected");
					}
#line 2973 "cfg.tab.c"
    break;

  case 67: /* socket_def_param: ANYCAST  */
#line 735 "cfg.y"
                          { IFOR();
					p_tmp.flags |= SI_IS_ANYCAST;
					}
#line 2981 "cfg.tab.c"
    break;

  case 68: /* socket_def_param: FRAG  */
#line 738 "cfg.y"
                                       { IFOR();
					p_tmp.flags |= SI_FRAG;
					}
#line 2989 "cfg.tab.c"
    break;

  case 69: /* socket_def_param: REUSE_PORT  */
#line 741 "cfg.y"
                                             { IFOR();
					p_tmp.flags |= SI_REUSEPORT;
					}
#line 2997 "cfg.tab.c"
    break;

  case 70: /* socket_def_param: ACCEPT_SUBDOMAIN  */
#line 744 "cfg.y"
                                                   { IFOR();
					p_tmp.flags |= SI_ACCEPT_SUBDOMAIN_ALIAS;
					}
#line 3005 "cfg.tab.c"
    break;

  case 71: /* socket_def_param: USE_WORKERS NUMBER  */
#line 747 "cfg.y"
                                                     { IFOR();
					p_tmp.workers=(yyvsp[0].intval);
					}
#line 3013 "cfg.tab.c"
    break;

  case 72: /* socket_def_param: SOCK_TOS NUMBER  */
#line 750 "cfg.y"
                                                  { IFOR();
					p_tmp.tos=(yyvsp[0].intval);
					}
#line 3021 "cfg.tab.c"
    break;

  case 73: /* socket_def_param: AS listen_id_def  */
#line 753 "cfg.y"
                                                   { IFOR();
					p_tmp.socket = (yyvsp[0].sockid);
					}
#line 3029 "cfg.tab.c"
    break;

  case 74: /* socket_def_param: TAG ID  */
#line 756 "cfg.y"
                                         { IFOR();
					p_tmp.tag = (yyvsp[0].strval);
					}
#line 3037 "cfg.tab.c"
    break;

  case 75: /* socket_def_param: USE_AUTO_SCALING_PROFILE ID  */
#line 759 "cfg.y"
                                                              { IFOR();
					p_tmp.auto_scaling_profile=(yyvsp[0].strval);
					}
#line 3045 "cfg.tab.c"
    break;

  case 78: /* socket_def: phostportrange  */
#line 768 "cfg.y"
                                { (yyval.sockid)=(yyvsp[0].sockid); }
#line 3051 "cfg.tab.c"
    break;

  case 79: /* $@10: %empty  */
#line 769 "cfg.y"
                                         { IFOR();
					memset(&p_tmp, 0, sizeof(p_tmp));
				}
#line 3059 "cfg.tab.c"
    break;

  case 80: /* socket_def: phostportrange $@10 socket_def_params  */
#line 771 "cfg.y"
                                                        { IFOR();
					(yyval.sockid)=(yyvsp[-2].sockid); fill_socket_id(&p_tmp, (yyval.sockid));
				}
#line 3067 "cfg.tab.c"
    break;

  case 81: /* any_proto: ANY  */
#line 776 "cfg.y"
                        { (yyval.intval)=PROTO_NONE; }
#line 3073 "cfg.tab.c"
    break;

  case 82: /* any_proto: proto  */
#line 777 "cfg.y"
                                { (yyval.intval)=(yyvsp[0].intval); }
#line 3079 "cfg.tab.c"
    break;

  case 83: /* multi_string: STRING  */
#line 779 "cfg.y"
                       {  IFOR(); (yyval.multistr)=new_string((yyvsp[0].strval)); }
#line 3085 "cfg.tab.c"
    break;

  case 84: /* multi_string: STRING multi_string  */
#line 780 "cfg.y"
                                      { IFOR(); (yyval.multistr)=new_string((yyvsp[-1].strval)); (yyval.multistr)->next=(yyvsp[0].multistr); }
#line 3091 "cfg.tab.c"
    break;

  case 85: /* blst_elem: LPAREN any_proto COMMA ipnet COMMA port COMMA STRING RPAREN  */
#line 783 "cfg.y"
                                                                       {
				IFOR(pkg_free((yyvsp[-5].ipnet)));
				s_tmp.s=(yyvsp[-1].strval);
				s_tmp.len=strlen((yyvsp[-1].strval));
				if (add_rule_to_list(&bl_head,&bl_tail,(yyvsp[-5].ipnet),&s_tmp,(yyvsp[-3].intval),(yyvsp[-7].intval),0)) {
					yyerror("failed to add backlist element\n");YYABORT;
				}
			}
#line 3104 "cfg.tab.c"
    break;

  case 86: /* blst_elem: NOT LPAREN any_proto COMMA ipnet COMMA port COMMA STRING RPAREN  */
#line 791 "cfg.y"
                                                                                  {
				IFOR(pkg_free((yyvsp[-5].ipnet)));
				s_tmp.s=(yyvsp[-1].strval);
				s_tmp.len=strlen((yyvsp[-1].strval));
				if (add_rule_to_list(&bl_head,&bl_tail,(yyvsp[-5].ipnet),&s_tmp,
				(yyvsp[-3].intval),(yyvsp[-7].intval),BLR_APPLY_CONTRARY)) {
					yyerror("failed to add backlist element\n");YYABORT;
				}
			}
#line 3118 "cfg.tab.c"
    break;

  case 87: /* blst_elem: LPAREN any_proto COMMA ipnet COMMA port RPAREN  */
#line 800 "cfg.y"
                                                                 {
				IFOR(pkg_free((yyvsp[-3].ipnet)));
				if (add_rule_to_list(&bl_head,&bl_tail,(yyvsp[-3].ipnet),NULL,(yyvsp[-1].intval),(yyvsp[-5].intval),0)) {
					yyerror("failed to add backlist element\n");YYABORT;
				}
			}
#line 3129 "cfg.tab.c"
    break;

  case 88: /* blst_elem: NOT LPAREN any_proto COMMA ipnet COMMA port RPAREN  */
#line 806 "cfg.y"
                                                                     {
				IFOR(pkg_free((yyvsp[-3].ipnet)));
				if (add_rule_to_list(&bl_head,&bl_tail,(yyvsp[-3].ipnet),NULL,
				(yyvsp[-1].intval),(yyvsp[-5].intval),BLR_APPLY_CONTRARY)) {
					yyerror("failed to add backlist element\n");YYABORT;
				}
			}
#line 3141 "cfg.tab.c"
    break;

  case 89: /* blst_elem: LPAREN any_proto COMMA ipnet RPAREN  */
#line 813 "cfg.y"
                                                      {
				IFOR(pkg_free((yyvsp[-1].ipnet)));
				if (add_rule_to_list(&bl_head,&bl_tail,(yyvsp[-1].ipnet),NULL,0,(yyvsp[-3].intval),0)) {
					yyerror("failed to add backlist element\n");YYABORT;
				}
			}
#line 3152 "cfg.tab.c"
    break;

  case 90: /* blst_elem: NOT LPAREN any_proto COMMA ipnet RPAREN  */
#line 819 "cfg.y"
                                                          {
				IFOR(pkg_free((yyvsp[-1].ipnet)));
				if (add_rule_to_list(&bl_head,&bl_tail,(yyvsp[-1].ipnet),NULL,
				0,(yyvsp[-3].intval),BLR_APPLY_CONTRARY)) {
					yyerror("failed to add backlist element\n");YYABORT;
				}
			}
#line 3164 "cfg.tab.c"
    break;

  case 91: /* blst_elem: LPAREN ipnet COMMA port RPAREN  */
#line 826 "cfg.y"
                                                 {
				IFOR(pkg_free((yyvsp[-3].ipnet)));
				if (add_rule_to_list(&bl_head,&bl_tail,(yyvsp[-3].ipnet),NULL,(yyvsp[-1].intval),PROTO_NONE,0)) {
					yyerror("failed to add backlist element\n");YYABORT;
				}
			}
#line 3175 "cfg.tab.c"
    break;

  case 92: /* blst_elem: NOT LPAREN ipnet COMMA port RPAREN  */
#line 832 "cfg.y"
                                                     {
				IFOR(pkg_free((yyvsp[-3].ipnet)));
				if (add_rule_to_list(&bl_head,&bl_tail,(yyvsp[-3].ipnet),NULL,
				(yyvsp[-1].intval),PROTO_NONE,BLR_APPLY_CONTRARY)) {
					yyerror("failed to add backlist element\n");YYABORT;
				}
			}
#line 3187 "cfg.tab.c"
    break;

  case 93: /* blst_elem: LPAREN ipnet RPAREN  */
#line 839 "cfg.y"
                                      {
				IFOR(pkg_free((yyvsp[-1].ipnet)));
				if (add_rule_to_list(&bl_head,&bl_tail,(yyvsp[-1].ipnet),NULL,0,PROTO_NONE,0)) {
					yyerror("failed to add backlist element\n"); YYABORT;
				}
			}
#line 3198 "cfg.tab.c"
    break;

  case 94: /* blst_elem: NOT LPAREN ipnet RPAREN  */
#line 845 "cfg.y"
                                          {
				IFOR(pkg_free((yyvsp[-1].ipnet)));
				if (add_rule_to_list(&bl_head,&bl_tail,(yyvsp[-1].ipnet),NULL,
				0,PROTO_NONE,BLR_APPLY_CONTRARY)) {
					yyerror("failed to add backlist element\n");YYABORT;
				}
			}
#line 3210 "cfg.tab.c"
    break;

  case 95: /* blst_elem: ipnet  */
#line 852 "cfg.y"
                        {
				IFOR(pkg_free((yyvsp[0].ipnet)));
				if (add_rule_to_list(&bl_head,&bl_tail,(yyvsp[0].ipnet),NULL,0,PROTO_NONE,0)) {
					yyerror("failed to add backlist element\n"); YYABORT;
				}
			}
#line 3221 "cfg.tab.c"
    break;

  case 96: /* blst_elem: NOT ipnet  */
#line 858 "cfg.y"
                            {
				IFOR(pkg_free((yyvsp[0].ipnet)));
				if (add_rule_to_list(&bl_head,&bl_tail,(yyvsp[0].ipnet),NULL,
				0,PROTO_NONE,BLR_APPLY_CONTRARY)) {
					yyerror("failed to add backlist element\n");YYABORT;
				}
			}
#line 3233 "cfg.tab.c"
    break;

  case 100: /* blst_flag: READONLY  */
#line 872 "cfg.y"
                    { (yyval.intval) = BL_READONLY_LIST; }
#line 3239 "cfg.tab.c"
    break;

  case 101: /* blst_flag: EXPIRE  */
#line 873 "cfg.y"
                          { (yyval.intval) = BL_DO_EXPIRE; }
#line 3245 "cfg.tab.c"
    break;

  case 102: /* blst_flag: DEFAULT  */
#line 874 "cfg.y"
                           { (yyval.intval) = BL_BY_DEFAULT; }
#line 3251 "cfg.tab.c"
    break;

  case 103: /* blst_flags: blst_flags COMMA blst_flag  */
#line 877 "cfg.y"
                                       { (yyval.intval) = (yyvsp[-2].intval) | (yyvsp[0].intval); }
#line 3257 "cfg.tab.c"
    break;

  case 104: /* blst_flags: blst_flag  */
#line 878 "cfg.y"
                            {}
#line 3263 "cfg.tab.c"
    break;

  case 105: /* blst_elem_list: blst_elem_list COMMA blst_elem  */
#line 881 "cfg.y"
                                               {}
#line 3269 "cfg.tab.c"
    break;

  case 106: /* blst_elem_list: blst_elem  */
#line 882 "cfg.y"
                            {}
#line 3275 "cfg.tab.c"
    break;

  case 107: /* blst_elem_list: blst_elem_list error  */
#line 883 "cfg.y"
                                       { yyerror("bad black list element");}
#line 3281 "cfg.tab.c"
    break;

  case 108: /* auto_scale_profile_def: ID SCALE_UP_TO NUMBER ON NUMBER MODULO FOR NUMBER CYCLES_WITHIN NUMBER SCALE_DOWN_TO NUMBER ON NUMBER MODULO FOR NUMBER CYCLES  */
#line 890 "cfg.y"
                                              { IFOR();
			if (create_auto_scaling_profile((yyvsp[-17].strval),(yyvsp[-15].intval),(yyvsp[-13].intval),(yyvsp[-10].intval),(yyvsp[-8].intval),
			(yyvsp[-6].intval), (yyvsp[-4].intval), (yyvsp[-1].intval),10*(yyvsp[-1].intval))<0)
				yyerror("failed to create auto scaling profile");
		 }
#line 3291 "cfg.tab.c"
    break;

  case 109: /* auto_scale_profile_def: ID SCALE_UP_TO NUMBER ON NUMBER MODULO FOR NUMBER CYCLES SCALE_DOWN_TO NUMBER ON NUMBER MODULO FOR NUMBER CYCLES  */
#line 898 "cfg.y"
                                              { IFOR();
			if (create_auto_scaling_profile((yyvsp[-16].strval),(yyvsp[-14].intval),(yyvsp[-12].intval),(yyvsp[-9].intval),(yyvsp[-9].intval),
			(yyvsp[-6].intval), (yyvsp[-4].intval), (yyvsp[-1].intval), 10*(yyvsp[-1].intval))<0)
				yyerror("failed to create auto scaling profile");
		 }
#line 3301 "cfg.tab.c"
    break;

  case 110: /* auto_scale_profile_def: ID SCALE_UP_TO NUMBER ON NUMBER MODULO FOR NUMBER CYCLES_WITHIN NUMBER  */
#line 904 "cfg.y"
                                                            { IFOR();
			if (create_auto_scaling_profile((yyvsp[-9].strval),(yyvsp[-7].intval),(yyvsp[-5].intval),(yyvsp[-2].intval),(yyvsp[0].intval),
			0, 0, 0, 0)<0)
				yyerror("failed to create auto scaling profile");
		}
#line 3311 "cfg.tab.c"
    break;

  case 111: /* auto_scale_profile_def: ID SCALE_UP_TO NUMBER ON NUMBER MODULO FOR NUMBER CYCLES  */
#line 910 "cfg.y"
                                              { IFOR();
			if (create_auto_scaling_profile((yyvsp[-8].strval),(yyvsp[-6].intval),(yyvsp[-4].intval),(yyvsp[-1].intval),(yyvsp[-1].intval),
			0, 0, 0, 0)<0)
				yyerror("failed to create auto scaling profile");
		}
#line 3321 "cfg.tab.c"
    break;

  case 112: /* assign_stm: LOGLEVEL EQUAL snumber  */
#line 917 "cfg.y"
                                   { IFOR();
			/* in debug mode, force logging to DEBUG level*/
			*log_level = debug_mode?L_DBG:(yyvsp[0].intval);
			}
#line 3330 "cfg.tab.c"
    break;

  case 113: /* assign_stm: LOGPREFIX EQUAL STRING  */
#line 921 "cfg.y"
                                         { IFOR();
			if (*(yyvsp[0].strval)) {
				int len = strlen((yyvsp[0].strval));
				char *buf = pkg_malloc(len + 2);
				if (!buf)
					yyerror("oom");
				sprintf(buf, "%s:", (yyvsp[0].strval));
				log_prefix = buf;
			} else {
				log_prefix = (yyvsp[0].strval);
			}
			}
#line 3347 "cfg.tab.c"
    break;

  case 114: /* assign_stm: LOGPREFIX EQUAL error  */
#line 933 "cfg.y"
                                         { yyerror("string value expected"); }
#line 3353 "cfg.tab.c"
    break;

  case 115: /* assign_stm: ENABLE_ASSERTS EQUAL NUMBER  */
#line 934 "cfg.y"
                                               { IFOR(); enable_asserts=(yyvsp[0].intval); }
#line 3359 "cfg.tab.c"
    break;

  case 116: /* assign_stm: ENABLE_ASSERTS EQUAL error  */
#line 935 "cfg.y"
                                              { yyerror("boolean value expected"); }
#line 3365 "cfg.tab.c"
    break;

  case 117: /* assign_stm: ABORT_ON_ASSERT EQUAL NUMBER  */
#line 936 "cfg.y"
                                                { IFOR(); abort_on_assert=(yyvsp[0].intval); }
#line 3371 "cfg.tab.c"
    break;

  case 118: /* assign_stm: ABORT_ON_ASSERT EQUAL error  */
#line 937 "cfg.y"
                                               { yyerror("boolean value expected"); }
#line 3377 "cfg.tab.c"
    break;

  case 119: /* assign_stm: DEBUG_MODE EQUAL NUMBER  */
#line 938 "cfg.y"
                                           { IFOR();
			debug_mode=(yyvsp[0].intval);
			if (debug_mode) {
				*log_level = L_DBG;
				stderr_enabled=1;
				syslog_enabled=0;

				s_tmp.s=STDERR_CONSUMER_NAME;
				s_tmp.len=strlen(STDERR_CONSUMER_NAME);
				set_log_consumer_mute_state(&s_tmp, 0);
				s_tmp.s=SYSLOG_CONSUMER_NAME;
				s_tmp.len=strlen(SYSLOG_CONSUMER_NAME);
				set_log_consumer_mute_state(&s_tmp, 1);
			}
			}
#line 3397 "cfg.tab.c"
    break;

  case 120: /* assign_stm: DEBUG_MODE EQUAL error  */
#line 954 "cfg.y"
                        { yyerror("boolean value expected for debug_mode"); }
#line 3403 "cfg.tab.c"
    break;

  case 121: /* assign_stm: LOGSTDOUT EQUAL NUMBER  */
#line 957 "cfg.y"
                        { IFOR(); log_stdout=(yyvsp[0].intval); }
#line 3409 "cfg.tab.c"
    break;

  case 122: /* assign_stm: LOGSTDOUT EQUAL error  */
#line 958 "cfg.y"
                                        { yyerror("boolean value expected"); }
#line 3415 "cfg.tab.c"
    break;

  case 123: /* assign_stm: LOGSTDERROR EQUAL NUMBER  */
#line 959 "cfg.y"
                                           {
			IFOR();
			warn("'log_stderror' is deprecated, use 'stderror_enabled' and/or"
				"'syslog_enabled' instead");
			if (!config_check && !debug_mode) {
				if ((yyvsp[0].intval)) {
					stderr_enabled=1;
					syslog_enabled=0;
				} else {
					stderr_enabled=0;
					syslog_enabled=1;
				}

				s_tmp.s=STDERR_CONSUMER_NAME;
				s_tmp.len=strlen(STDERR_CONSUMER_NAME);
				set_log_consumer_mute_state(&s_tmp, !(yyvsp[0].intval));
				s_tmp.s=SYSLOG_CONSUMER_NAME;
				s_tmp.len=strlen(SYSLOG_CONSUMER_NAME);
				set_log_consumer_mute_state(&s_tmp, (yyvsp[0].intval));
			}
			}
#line 3441 "cfg.tab.c"
    break;

  case 124: /* assign_stm: LOGSTDERROR EQUAL error  */
#line 980 "cfg.y"
                                          { yyerror("boolean value expected"); }
#line 3447 "cfg.tab.c"
    break;

  case 125: /* assign_stm: STDERROR_ENABLED EQUAL NUMBER  */
#line 981 "cfg.y"
                                                {
			/* in config-check or debug mode we force logging
			 * to standard error */
			IFOR();
			if (!config_check && !debug_mode) {
				stderr_enabled=(yyvsp[0].intval);
				s_tmp.s=STDERR_CONSUMER_NAME;
				s_tmp.len=strlen(STDERR_CONSUMER_NAME);
				set_log_consumer_mute_state(&s_tmp, !(yyvsp[0].intval));
			}
			}
#line 3463 "cfg.tab.c"
    break;

  case 126: /* assign_stm: STDERROR_ENABLED EQUAL error  */
#line 992 "cfg.y"
                                               { yyerror("boolean value expected"); }
#line 3469 "cfg.tab.c"
    break;

  case 127: /* assign_stm: SYSLOG_ENABLED EQUAL NUMBER  */
#line 993 "cfg.y"
                                              {
			IFOR();
			/* in config-check or debug mode we force logging
			 * to standard error */
			if (!config_check && !debug_mode) {
				syslog_enabled=(yyvsp[0].intval);
				s_tmp.s=SYSLOG_CONSUMER_NAME;
				s_tmp.len=strlen(SYSLOG_CONSUMER_NAME);
				set_log_consumer_mute_state(&s_tmp, !(yyvsp[0].intval));
			}
			}
#line 3485 "cfg.tab.c"
    break;

  case 128: /* assign_stm: SYSLOG_ENABLED EQUAL error  */
#line 1004 "cfg.y"
                                             { yyerror("boolean value expected"); }
#line 3491 "cfg.tab.c"
    break;

  case 129: /* assign_stm: LOG_EVENT_ENABLED EQUAL NUMBER  */
#line 1005 "cfg.y"
                                                 {
			IFOR();
			if ((yyvsp[0].intval)) {
				if (init_log_msg_buf(0) < 0) {
					yyerror("failed to allocate msg log buffer");
					YYABORT;
				}
			}
			log_event_enabled=(yyvsp[0].intval); }
#line 3505 "cfg.tab.c"
    break;

  case 130: /* assign_stm: LOG_EVENT_ENABLED EQUAL error  */
#line 1014 "cfg.y"
                                                { yyerror("boolean value expected"); }
#line 3511 "cfg.tab.c"
    break;

  case 131: /* assign_stm: STDERROR_LEVEL_FILTER EQUAL snumber  */
#line 1015 "cfg.y"
                                                      {
			IFOR();
			s_tmp.s=STDERR_CONSUMER_NAME;
			s_tmp.len=strlen(STDERR_CONSUMER_NAME);
			set_log_consumer_level_filter(&s_tmp, (yyvsp[0].intval));
			}
#line 3522 "cfg.tab.c"
    break;

  case 132: /* assign_stm: STDERROR_LEVEL_FILTER EQUAL error  */
#line 1021 "cfg.y"
                                                    { yyerror("number expected"); }
#line 3528 "cfg.tab.c"
    break;

  case 133: /* assign_stm: SYSLOG_LEVEL_FILTER EQUAL snumber  */
#line 1022 "cfg.y"
                                                    {
			IFOR();
			s_tmp.s=SYSLOG_CONSUMER_NAME;
			s_tmp.len=strlen(SYSLOG_CONSUMER_NAME);
			set_log_consumer_level_filter(&s_tmp, (yyvsp[0].intval));
			}
#line 3539 "cfg.tab.c"
    break;

  case 134: /* assign_stm: SYSLOG_LEVEL_FILTER EQUAL error  */
#line 1028 "cfg.y"
                                                  { yyerror("number expected"); }
#line 3545 "cfg.tab.c"
    break;

  case 135: /* assign_stm: LOG_EVENT_LEVEL_FILTER EQUAL snumber  */
#line 1029 "cfg.y"
                                                       { IFOR();
							log_event_level_filter = (yyvsp[0].intval); }
#line 3552 "cfg.tab.c"
    break;

  case 136: /* assign_stm: LOG_EVENT_LEVEL_FILTER EQUAL error  */
#line 1031 "cfg.y"
                                                     { yyerror("number expected"); }
#line 3558 "cfg.tab.c"
    break;

  case 137: /* assign_stm: STDERROR_FORMAT EQUAL STRING  */
#line 1032 "cfg.y"
                                               { IFOR();
			s_tmp.s = (yyvsp[0].strval);
			s_tmp.len = strlen((yyvsp[0].strval));
			if ((i_tmp = parse_log_format(&s_tmp)) < 0) {
				yyerror("unknown log format");
			} else {
				if (i_tmp != LOG_FORMAT_PLAIN) {
					if (init_log_json_buf(0) < 0) {
						yyerror("failed to allocate json log buffer");
						YYABORT;
					}
					if (init_log_msg_buf(0) < 0) {
						yyerror("failed to allocate msg log buffer");
						YYABORT;
					}

					if (i_tmp == LOG_FORMAT_JSON_CEE && init_log_cee_hostname() < 0) {
						yyerror("failed to allocate hostname buffer");
						YYABORT;
					}
				}

				stderr_log_format = i_tmp;
			}
			}
#line 3588 "cfg.tab.c"
    break;

  case 138: /* assign_stm: SYSLOG_FORMAT EQUAL STRING  */
#line 1057 "cfg.y"
                                             { IFOR();
			s_tmp.s = (yyvsp[0].strval);
			s_tmp.len = strlen((yyvsp[0].strval));
			if ((i_tmp = parse_log_format(&s_tmp)) < 0) {
				yyerror("unknown log format");
			} else {
				if (i_tmp != LOG_FORMAT_PLAIN) {
					if (init_log_json_buf(0) < 0) {
						yyerror("failed to allocate json log buffer");
						YYABORT;
					}
					if (init_log_msg_buf(0) < 0) {
						yyerror("failed to allocate msg log buffer");
						YYABORT;
					}

					if (i_tmp == LOG_FORMAT_JSON_CEE && init_log_cee_hostname() < 0) {
						yyerror("failed to allocate hostname buffer");
						YYABORT;
					}
				}

				syslog_log_format = i_tmp;
			}
			}
#line 3618 "cfg.tab.c"
    break;

  case 139: /* assign_stm: LOG_JSON_BUF_SIZE EQUAL NUMBER  */
#line 1082 "cfg.y"
                                                 {
			IFOR();
			log_json_buf_size = (yyvsp[0].intval);
			if (init_log_json_buf(1) < 0) {
				yyerror("failed to realloc json log buffer");
				YYABORT;
			}
			}
#line 3631 "cfg.tab.c"
    break;

  case 140: /* assign_stm: LOG_JSON_BUF_SIZE EQUAL error  */
#line 1090 "cfg.y"
                                                { yyerror("number expected"); }
#line 3637 "cfg.tab.c"
    break;

  case 141: /* assign_stm: LOG_MSG_BUF_SIZE EQUAL NUMBER  */
#line 1091 "cfg.y"
                                                {
			IFOR();
			log_msg_buf_size = (yyvsp[0].intval);
			if (init_log_msg_buf(1) < 0) {
				yyerror("failed to realloc msg log buffer");
				YYABORT;
			}
			}
#line 3650 "cfg.tab.c"
    break;

  case 142: /* assign_stm: LOG_MSG_BUF_SIZE EQUAL error  */
#line 1099 "cfg.y"
                                               { yyerror("number expected"); }
#line 3656 "cfg.tab.c"
    break;

  case 143: /* assign_stm: LOGFACILITY EQUAL ID  */
#line 1100 "cfg.y"
                                       { IFOR();
			warn("'log_facility' is deprecated, use 'syslog_facility' instead");
			if ( (i_tmp=str2facility((yyvsp[0].strval)))==-1)
				yyerror("bad facility (see syslog(3) man page)");
			if (!config_check)
				log_facility=i_tmp;
			}
#line 3668 "cfg.tab.c"
    break;

  case 144: /* assign_stm: LOGFACILITY EQUAL error  */
#line 1107 "cfg.y"
                                          { yyerror("ID expected"); }
#line 3674 "cfg.tab.c"
    break;

  case 145: /* assign_stm: SYSLOG_FACILITY EQUAL ID  */
#line 1108 "cfg.y"
                                           { IFOR();
			if ( (i_tmp=str2facility((yyvsp[0].strval)))==-1)
				yyerror("bad facility (see syslog(3) man page)");
			if (!config_check)
				log_facility=i_tmp;
			}
#line 3685 "cfg.tab.c"
    break;

  case 146: /* assign_stm: SYSLOG_FACILITY EQUAL error  */
#line 1114 "cfg.y"
                                              { yyerror("ID expected"); }
#line 3691 "cfg.tab.c"
    break;

  case 147: /* assign_stm: LOGNAME EQUAL STRING  */
#line 1115 "cfg.y"
                                       { IFOR();
			warn("'log_name' is deprecated, use 'syslog_name' instead");
			log_name=(yyvsp[0].strval); }
#line 3699 "cfg.tab.c"
    break;

  case 148: /* assign_stm: LOGNAME EQUAL error  */
#line 1118 "cfg.y"
                                      { yyerror("string value expected"); }
#line 3705 "cfg.tab.c"
    break;

  case 149: /* assign_stm: SYSLOG_NAME EQUAL STRING  */
#line 1119 "cfg.y"
                                           { IFOR(); log_name=(yyvsp[0].strval); }
#line 3711 "cfg.tab.c"
    break;

  case 150: /* assign_stm: SYSLOG_NAME EQUAL error  */
#line 1120 "cfg.y"
                                          { yyerror("string value expected"); }
#line 3717 "cfg.tab.c"
    break;

  case 151: /* assign_stm: DNS EQUAL NUMBER  */
#line 1121 "cfg.y"
                                     { IFOR(); received_dns|= ((yyvsp[0].intval))?DO_DNS:0; }
#line 3723 "cfg.tab.c"
    break;

  case 152: /* assign_stm: DNS EQUAL error  */
#line 1122 "cfg.y"
                                  { yyerror("boolean value expected"); }
#line 3729 "cfg.tab.c"
    break;

  case 153: /* assign_stm: REV_DNS EQUAL NUMBER  */
#line 1123 "cfg.y"
                                       { IFOR(); received_dns|= ((yyvsp[0].intval))?DO_REV_DNS:0; }
#line 3735 "cfg.tab.c"
    break;

  case 154: /* assign_stm: REV_DNS EQUAL error  */
#line 1124 "cfg.y"
                                      { yyerror("boolean value expected"); }
#line 3741 "cfg.tab.c"
    break;

  case 155: /* assign_stm: DNS_TRY_IPV6 EQUAL NUMBER  */
#line 1125 "cfg.y"
                                              { IFOR(); dns_try_ipv6=(yyvsp[0].intval); }
#line 3747 "cfg.tab.c"
    break;

  case 156: /* assign_stm: DNS_TRY_IPV6 error  */
#line 1126 "cfg.y"
                                     { yyerror("boolean value expected"); }
#line 3753 "cfg.tab.c"
    break;

  case 157: /* assign_stm: DNS_TRY_NAPTR EQUAL NUMBER  */
#line 1127 "cfg.y"
                                               { IFOR(); dns_try_naptr=(yyvsp[0].intval); }
#line 3759 "cfg.tab.c"
    break;

  case 158: /* assign_stm: DNS_TRY_NAPTR error  */
#line 1128 "cfg.y"
                                      { yyerror("boolean value expected"); }
#line 3765 "cfg.tab.c"
    break;

  case 159: /* assign_stm: DNS_RETR_TIME EQUAL NUMBER  */
#line 1129 "cfg.y"
                                               { IFOR(); dns_retr_time=(yyvsp[0].intval); }
#line 3771 "cfg.tab.c"
    break;

  case 160: /* assign_stm: DNS_RETR_TIME error  */
#line 1130 "cfg.y"
                                      { yyerror("number expected"); }
#line 3777 "cfg.tab.c"
    break;

  case 161: /* assign_stm: DNS_RETR_NO EQUAL NUMBER  */
#line 1131 "cfg.y"
                                             { IFOR(); dns_retr_no=(yyvsp[0].intval); }
#line 3783 "cfg.tab.c"
    break;

  case 162: /* assign_stm: DNS_RETR_NO error  */
#line 1132 "cfg.y"
                                    { yyerror("number expected"); }
#line 3789 "cfg.tab.c"
    break;

  case 163: /* assign_stm: DNS_SERVERS_NO EQUAL NUMBER  */
#line 1133 "cfg.y"
                                                { IFOR(); dns_servers_no=(yyvsp[0].intval); }
#line 3795 "cfg.tab.c"
    break;

  case 164: /* assign_stm: DNS_SERVERS_NO error  */
#line 1134 "cfg.y"
                                       { yyerror("number expected"); }
#line 3801 "cfg.tab.c"
    break;

  case 165: /* assign_stm: DNS_USE_SEARCH EQUAL NUMBER  */
#line 1135 "cfg.y"
                                                { IFOR(); dns_search_list=(yyvsp[0].intval); }
#line 3807 "cfg.tab.c"
    break;

  case 166: /* assign_stm: DNS_USE_SEARCH error  */
#line 1136 "cfg.y"
                                       { yyerror("boolean value expected"); }
#line 3813 "cfg.tab.c"
    break;

  case 167: /* assign_stm: MAX_WHILE_LOOPS EQUAL NUMBER  */
#line 1137 "cfg.y"
                                               { IFOR(); max_while_loops=(yyvsp[0].intval); }
#line 3819 "cfg.tab.c"
    break;

  case 168: /* assign_stm: MAX_WHILE_LOOPS EQUAL error  */
#line 1138 "cfg.y"
                                              { yyerror("number expected"); }
#line 3825 "cfg.tab.c"
    break;

  case 169: /* assign_stm: MAXBUFFER EQUAL NUMBER  */
#line 1139 "cfg.y"
                                         { IFOR(); maxbuffer=(yyvsp[0].intval); }
#line 3831 "cfg.tab.c"
    break;

  case 170: /* assign_stm: MAXBUFFER EQUAL error  */
#line 1140 "cfg.y"
                                        { yyerror("number expected"); }
#line 3837 "cfg.tab.c"
    break;

  case 171: /* assign_stm: UDP_WORKERS EQUAL NUMBER  */
#line 1141 "cfg.y"
                                           { IFOR(); udp_workers_no=(yyvsp[0].intval); }
#line 3843 "cfg.tab.c"
    break;

  case 172: /* assign_stm: UDP_WORKERS EQUAL NUMBER USE_AUTO_SCALING_PROFILE ID  */
#line 1142 "cfg.y"
                                                                       { IFOR();
				udp_workers_no=(yyvsp[-2].intval);
				udp_auto_scaling_profile=(yyvsp[0].strval);
		}
#line 3852 "cfg.tab.c"
    break;

  case 173: /* assign_stm: UDP_WORKERS EQUAL error  */
#line 1146 "cfg.y"
                                          { yyerror("number expected"); }
#line 3858 "cfg.tab.c"
    break;

  case 174: /* assign_stm: TIMER_WORKERS EQUAL NUMBER  */
#line 1147 "cfg.y"
                                             { IFOR();
				timer_workers_no=(yyvsp[0].intval);
		}
#line 3866 "cfg.tab.c"
    break;

  case 175: /* assign_stm: TIMER_WORKERS EQUAL NUMBER USE_AUTO_SCALING_PROFILE ID  */
#line 1150 "cfg.y"
                                                                         { IFOR();
				timer_workers_no=(yyvsp[-2].intval);
				timer_auto_scaling_profile=(yyvsp[0].strval);
		}
#line 3875 "cfg.tab.c"
    break;

  case 176: /* assign_stm: CHECK_VIA EQUAL NUMBER  */
#line 1154 "cfg.y"
                                         { check_via=(yyvsp[0].intval); }
#line 3881 "cfg.tab.c"
    break;

  case 177: /* assign_stm: CHECK_VIA EQUAL error  */
#line 1155 "cfg.y"
                                        { yyerror("boolean value expected"); }
#line 3887 "cfg.tab.c"
    break;

  case 178: /* assign_stm: SHM_HASH_SPLIT_PERCENTAGE EQUAL NUMBER  */
#line 1156 "cfg.y"
                                                         { IFOR();
			#ifdef HP_MALLOC
			shm_hash_split_percentage=(yyvsp[0].intval);
			#else
			LM_ERR("Cannot set parameter; Please recompile with support "
				"for HP_MALLOC\n");
			#endif
			}
#line 3900 "cfg.tab.c"
    break;

  case 179: /* assign_stm: SHM_HASH_SPLIT_PERCENTAGE EQUAL error  */
#line 1164 "cfg.y"
                                                        {
			#ifdef HP_MALLOC
			yyerror("number expected");
			#else
			LM_ERR("Cannot set parameter; Please recompile with support "
				"for HP_MALLOC\n");
			#endif
				}
#line 3913 "cfg.tab.c"
    break;

  case 180: /* assign_stm: SHM_SECONDARY_HASH_SIZE EQUAL NUMBER  */
#line 1172 "cfg.y"
                                                       { IFOR();
			#ifdef HP_MALLOC
			shm_secondary_hash_size=(yyvsp[0].intval);
			#else
			LM_ERR("Cannot set parameter; Please recompile with support"
				" for HP_MALLOC\n");
			#endif
			}
#line 3926 "cfg.tab.c"
    break;

  case 181: /* assign_stm: SHM_SECONDARY_HASH_SIZE EQUAL error  */
#line 1180 "cfg.y"
                                                      {
			#ifdef HP_MALLOC
			yyerror("number expected");
			#else
			LM_ERR("Cannot set parameter; Please recompile with support "
				"for HP_MALLOC\n");
			#endif
			}
#line 3939 "cfg.tab.c"
    break;

  case 182: /* assign_stm: MEM_WARMING_ENABLED EQUAL NUMBER  */
#line 1188 "cfg.y"
                                                   { IFOR();
			#ifdef HP_MALLOC
			mem_warming_enabled = (yyvsp[0].intval);
			#else
			LM_ERR("Cannot set parameter; Please recompile with support"
				" for HP_MALLOC\n");
			#endif
			}
#line 3952 "cfg.tab.c"
    break;

  case 183: /* assign_stm: MEM_WARMING_ENABLED EQUAL error  */
#line 1196 "cfg.y"
                                                  {
			#ifdef HP_MALLOC
			yyerror("number expected");
			#else
			LM_ERR("Cannot set parameter; Please recompile with support "
				"for HP_MALLOC\n");
			#endif
			}
#line 3965 "cfg.tab.c"
    break;

  case 184: /* assign_stm: MEM_WARMING_PATTERN_FILE EQUAL STRING  */
#line 1204 "cfg.y"
                                                        { IFOR();
			#ifdef HP_MALLOC
			mem_warming_pattern_file = (yyvsp[0].strval);
			#else
			LM_ERR("Cannot set parameter; Please recompile with "
				"support for HP_MALLOC\n");
			#endif
			}
#line 3978 "cfg.tab.c"
    break;

  case 185: /* assign_stm: MEM_WARMING_PATTERN_FILE EQUAL error  */
#line 1212 "cfg.y"
                                                       {
			#ifdef HP_MALLOC
			yyerror("string expected");
			#else
			LM_ERR("Cannot set parameter; Please recompile with support "
				"for HP_MALLOC\n");
			#endif
			}
#line 3991 "cfg.tab.c"
    break;

  case 186: /* assign_stm: MEM_WARMING_PERCENTAGE EQUAL NUMBER  */
#line 1220 "cfg.y"
                                                      { IFOR();
			#ifdef HP_MALLOC
			mem_warming_percentage = (yyvsp[0].intval);
			#else
			LM_ERR("Cannot set parameter; Please recompile with "
				"support for HP_MALLOC\n");
			#endif
			}
#line 4004 "cfg.tab.c"
    break;

  case 187: /* assign_stm: MEM_WARMING_PERCENTAGE EQUAL error  */
#line 1228 "cfg.y"
                                                     {
			#ifdef HP_MALLOC
			yyerror("number expected");
			#else
			LM_ERR("Cannot set parameter; Please recompile with support "
				"for HP_MALLOC\n");
			#endif
			}
#line 4017 "cfg.tab.c"
    break;

  case 188: /* assign_stm: RPM_MEM_FILE EQUAL STRING  */
#line 1236 "cfg.y"
                                            { IFOR();
			rpm_mem_file = (yyvsp[0].strval);
			}
#line 4025 "cfg.tab.c"
    break;

  case 189: /* assign_stm: RPM_MEM_FILE EQUAL error  */
#line 1239 "cfg.y"
                                           { yyerror("string value expected"); }
#line 4031 "cfg.tab.c"
    break;

  case 190: /* assign_stm: RPM_MEM_SIZE EQUAL NUMBER  */
#line 1240 "cfg.y"
                                            { IFOR();
			rpm_mem_size = (yyvsp[0].intval) * 1024 * 1024;
			}
#line 4039 "cfg.tab.c"
    break;

  case 191: /* assign_stm: RPM_MEM_SIZE EQUAL error  */
#line 1243 "cfg.y"
                                           { yyerror("int value expected"); }
#line 4045 "cfg.tab.c"
    break;

  case 192: /* assign_stm: MEMLOG EQUAL snumber  */
#line 1244 "cfg.y"
                                       { IFOR(); memlog=(yyvsp[0].intval); memdump=(yyvsp[0].intval); }
#line 4051 "cfg.tab.c"
    break;

  case 193: /* assign_stm: MEMLOG EQUAL error  */
#line 1245 "cfg.y"
                                     { yyerror("int value expected"); }
#line 4057 "cfg.tab.c"
    break;

  case 194: /* assign_stm: SHM_MEMLOG_SIZE EQUAL snumber  */
#line 1246 "cfg.y"
                                                { IFOR(); shm_memlog_size=(yyvsp[0].intval);}
#line 4063 "cfg.tab.c"
    break;

  case 195: /* assign_stm: SHM_MEMLOG_SIZE EQUAL error  */
#line 1247 "cfg.y"
                                              { yyerror("int value expected"); }
#line 4069 "cfg.tab.c"
    break;

  case 196: /* assign_stm: MEMDUMP EQUAL snumber  */
#line 1248 "cfg.y"
                                        { IFOR(); memdump=(yyvsp[0].intval); }
#line 4075 "cfg.tab.c"
    break;

  case 197: /* assign_stm: MEMDUMP EQUAL error  */
#line 1249 "cfg.y"
                                      { yyerror("int value expected"); }
#line 4081 "cfg.tab.c"
    break;

  case 198: /* assign_stm: EXECMSGTHRESHOLD EQUAL NUMBER  */
#line 1250 "cfg.y"
                                                {  IFOR();execmsgthreshold=(yyvsp[0].intval); }
#line 4087 "cfg.tab.c"
    break;

  case 199: /* assign_stm: EXECMSGTHRESHOLD EQUAL error  */
#line 1251 "cfg.y"
                                               { yyerror("int value expected"); }
#line 4093 "cfg.tab.c"
    break;

  case 200: /* assign_stm: EXECDNSTHRESHOLD EQUAL NUMBER  */
#line 1252 "cfg.y"
                                                { IFOR(); execdnsthreshold=(yyvsp[0].intval); }
#line 4099 "cfg.tab.c"
    break;

  case 201: /* assign_stm: EXECDNSTHRESHOLD EQUAL error  */
#line 1253 "cfg.y"
                                               { yyerror("int value expected"); }
#line 4105 "cfg.tab.c"
    break;

  case 202: /* assign_stm: TCPTHRESHOLD EQUAL NUMBER  */
#line 1254 "cfg.y"
                                            { IFOR(); tcpthreshold=(yyvsp[0].intval); }
#line 4111 "cfg.tab.c"
    break;

  case 203: /* assign_stm: TCPTHRESHOLD EQUAL error  */
#line 1255 "cfg.y"
                                           { yyerror("int value expected"); }
#line 4117 "cfg.tab.c"
    break;

  case 204: /* assign_stm: EVENT_SHM_THRESHOLD EQUAL NUMBER  */
#line 1256 "cfg.y"
                                                   { IFOR();
			#ifdef STATISTICS
			if ((yyvsp[0].intval) < 0 || (yyvsp[0].intval) > 100)
				yyerror("SHM threshold has to be a percentage between"
					" 0 and 100");
			event_shm_threshold=(yyvsp[0].intval);
			#else
			yyerror("statistics support not compiled in");
			#endif /* STATISTICS */
			}
#line 4132 "cfg.tab.c"
    break;

  case 205: /* assign_stm: EVENT_SHM_THRESHOLD EQUAL error  */
#line 1266 "cfg.y"
                                                  { yyerror("int value expected"); }
#line 4138 "cfg.tab.c"
    break;

  case 206: /* assign_stm: EVENT_PKG_THRESHOLD EQUAL NUMBER  */
#line 1267 "cfg.y"
                                                   { IFOR();
			#ifdef PKG_MALLOC
			#ifdef STATISTICS
			if ((yyvsp[0].intval) < 0 || (yyvsp[0].intval) > 100)
				yyerror("PKG threshold has to be a percentage between "
					"0 and 100");
			event_pkg_threshold=(yyvsp[0].intval);
			#else
			yyerror("statistics support not compiled in");
			#endif
			#else
			yyerror("pkg_malloc support not compiled in");
			#endif
			}
#line 4157 "cfg.tab.c"
    break;

  case 207: /* assign_stm: EVENT_PKG_THRESHOLD EQUAL error  */
#line 1281 "cfg.y"
                                                  { yyerror("int value expected"); }
#line 4163 "cfg.tab.c"
    break;

  case 208: /* assign_stm: QUERYBUFFERSIZE EQUAL NUMBER  */
#line 1282 "cfg.y"
                                               { IFOR(); query_buffer_size=(yyvsp[0].intval); }
#line 4169 "cfg.tab.c"
    break;

  case 209: /* assign_stm: QUERYBUFFERSIZE EQUAL error  */
#line 1283 "cfg.y"
                                              { yyerror("int value expected"); }
#line 4175 "cfg.tab.c"
    break;

  case 210: /* assign_stm: QUERYFLUSHTIME EQUAL NUMBER  */
#line 1284 "cfg.y"
                                              { IFOR(); query_flush_time=(yyvsp[0].intval); }
#line 4181 "cfg.tab.c"
    break;

  case 211: /* assign_stm: QUERYFLUSHTIME EQUAL error  */
#line 1285 "cfg.y"
                                             { yyerror("int value expected"); }
#line 4187 "cfg.tab.c"
    break;

  case 212: /* assign_stm: SIP_WARNING EQUAL NUMBER  */
#line 1286 "cfg.y"
                                           { IFOR(); sip_warning=(yyvsp[0].intval); }
#line 4193 "cfg.tab.c"
    break;

  case 213: /* assign_stm: SIP_WARNING EQUAL error  */
#line 1287 "cfg.y"
                                          { yyerror("boolean value expected"); }
#line 4199 "cfg.tab.c"
    break;

  case 214: /* assign_stm: CHROOT EQUAL STRING  */
#line 1288 "cfg.y"
                                          { IFOR(); chroot_dir=(yyvsp[0].strval); }
#line 4205 "cfg.tab.c"
    break;

  case 215: /* assign_stm: CHROOT EQUAL ID  */
#line 1289 "cfg.y"
                                          { IFOR(); chroot_dir=(yyvsp[0].strval); }
#line 4211 "cfg.tab.c"
    break;

  case 216: /* assign_stm: CHROOT EQUAL error  */
#line 1290 "cfg.y"
                                          { yyerror("string value expected"); }
#line 4217 "cfg.tab.c"
    break;

  case 217: /* assign_stm: WDIR EQUAL STRING  */
#line 1291 "cfg.y"
                                        { IFOR(); working_dir=(yyvsp[0].strval); }
#line 4223 "cfg.tab.c"
    break;

  case 218: /* assign_stm: WDIR EQUAL ID  */
#line 1292 "cfg.y"
                                        { IFOR(); working_dir=(yyvsp[0].strval); }
#line 4229 "cfg.tab.c"
    break;

  case 219: /* assign_stm: WDIR EQUAL error  */
#line 1293 "cfg.y"
                                        { yyerror("string value expected"); }
#line 4235 "cfg.tab.c"
    break;

  case 220: /* assign_stm: MHOMED EQUAL NUMBER  */
#line 1294 "cfg.y"
                                      { IFOR(); mhomed=(yyvsp[0].intval); }
#line 4241 "cfg.tab.c"
    break;

  case 221: /* assign_stm: MHOMED EQUAL error  */
#line 1295 "cfg.y"
                                     { yyerror("boolean value expected"); }
#line 4247 "cfg.tab.c"
    break;

  case 222: /* assign_stm: POLL_METHOD EQUAL ID  */
#line 1296 "cfg.y"
                                       { IFOR();
									io_poll_method=get_poll_type((yyvsp[0].strval));
									if (io_poll_method==POLL_NONE){
										LM_CRIT("bad poll method name:"
											" %s\n, try one of %s.\n",
											(yyvsp[0].strval), poll_support);
										yyerror("bad poll_method "
											"value");
									}
								}
#line 4262 "cfg.tab.c"
    break;

  case 223: /* assign_stm: POLL_METHOD EQUAL STRING  */
#line 1306 "cfg.y"
                                           { IFOR();
									io_poll_method=get_poll_type((yyvsp[0].strval));
									if (io_poll_method==POLL_NONE){
										LM_CRIT("bad poll method name:"
											" %s\n, try one of %s.\n",
											(yyvsp[0].strval), poll_support);
										yyerror("bad poll_method "
											"value");
									}
									}
#line 4277 "cfg.tab.c"
    break;

  case 224: /* assign_stm: POLL_METHOD EQUAL error  */
#line 1316 "cfg.y"
                                          { yyerror("poll method name expected"); }
#line 4283 "cfg.tab.c"
    break;

  case 225: /* assign_stm: TCP_ACCEPT_ALIASES EQUAL NUMBER  */
#line 1317 "cfg.y"
                                                  { IFOR();
				if ((yyvsp[0].intval) < TCP_ALIAS_NEVER || (yyvsp[0].intval) > TCP_ALIAS_ALWAYS)
					yyerror("invalid 'tcp_accept_aliases' value");
				tcp_accept_aliases=(yyvsp[0].intval);
		}
#line 4293 "cfg.tab.c"
    break;

  case 226: /* assign_stm: TCP_ACCEPT_ALIASES EQUAL error  */
#line 1322 "cfg.y"
                                                 { yyerror("boolean value expected"); }
#line 4299 "cfg.tab.c"
    break;

  case 227: /* assign_stm: TCP_WORKERS EQUAL NUMBER  */
#line 1323 "cfg.y"
                                           { IFOR();
				tcp_workers_no=(yyvsp[0].intval);
		}
#line 4307 "cfg.tab.c"
    break;

  case 228: /* assign_stm: TCP_WORKERS EQUAL NUMBER USE_AUTO_SCALING_PROFILE ID  */
#line 1326 "cfg.y"
                                                                      { IFOR();
				tcp_workers_no=(yyvsp[-2].intval);
				tcp_auto_scaling_profile=(yyvsp[0].strval);
		}
#line 4316 "cfg.tab.c"
    break;

  case 229: /* assign_stm: TCP_WORKERS EQUAL error  */
#line 1330 "cfg.y"
                                          { yyerror("number expected"); }
#line 4322 "cfg.tab.c"
    break;

  case 230: /* assign_stm: TCP_CONNECT_TIMEOUT EQUAL NUMBER  */
#line 1331 "cfg.y"
                                                   { IFOR();
				if ((yyvsp[0].intval) <= 0)
					yyerror("invalid 'tcp_connect_timeout' (value too low!)");
				tcp_connect_timeout=(yyvsp[0].intval);
		}
#line 4332 "cfg.tab.c"
    break;

  case 231: /* assign_stm: TCP_CONNECT_TIMEOUT EQUAL error  */
#line 1336 "cfg.y"
                                                  { yyerror("number expected"); }
#line 4338 "cfg.tab.c"
    break;

  case 232: /* assign_stm: TCP_CON_LIFETIME EQUAL NUMBER  */
#line 1337 "cfg.y"
                                                { IFOR();
				tcp_con_lifetime=(yyvsp[0].intval);
		}
#line 4346 "cfg.tab.c"
    break;

  case 233: /* assign_stm: TCP_CON_LIFETIME EQUAL error  */
#line 1340 "cfg.y"
                                               { yyerror("number expected"); }
#line 4352 "cfg.tab.c"
    break;

  case 234: /* assign_stm: TCP_SOCKET_BACKLOG EQUAL NUMBER  */
#line 1341 "cfg.y"
                                                  { IFOR();
				tcp_socket_backlog=(yyvsp[0].intval);
		}
#line 4360 "cfg.tab.c"
    break;

  case 235: /* assign_stm: TCP_SOCKET_BACKLOG EQUAL error  */
#line 1344 "cfg.y"
                                                 { yyerror("number expected"); }
#line 4366 "cfg.tab.c"
    break;

  case 236: /* assign_stm: TCP_MAX_CONNECTIONS EQUAL NUMBER  */
#line 1345 "cfg.y"
                                                   { IFOR();
				tcp_max_connections=(yyvsp[0].intval);
		}
#line 4374 "cfg.tab.c"
    break;

  case 237: /* assign_stm: TCP_MAX_CONNECTIONS EQUAL error  */
#line 1348 "cfg.y"
                                                  { yyerror("number expected"); }
#line 4380 "cfg.tab.c"
    break;

  case 238: /* assign_stm: TCP_NO_NEW_CONN_BFLAG EQUAL ID  */
#line 1349 "cfg.y"
                                                 { IFOR();
				tcp_no_new_conn_bflag =
					get_flag_id_by_name(FLAG_TYPE_BRANCH, (yyvsp[0].strval), 0);
				if (!flag_in_range( (flag_t)tcp_no_new_conn_bflag ) )
					yyerror("invalid TCP no_new_conn Branch Flag");
				flag_idx2mask( &tcp_no_new_conn_bflag );
		}
#line 4392 "cfg.tab.c"
    break;

  case 239: /* assign_stm: TCP_NO_NEW_CONN_BFLAG EQUAL error  */
#line 1356 "cfg.y"
                                                    { yyerror("number value expected"); }
#line 4398 "cfg.tab.c"
    break;

  case 240: /* assign_stm: TCP_NO_NEW_CONN_RPLFLAG EQUAL ID  */
#line 1357 "cfg.y"
                                                   { IFOR();
				tcp_no_new_conn_rplflag =
					get_flag_id_by_name(FLAG_TYPE_MSG, (yyvsp[0].strval), 0);
				if (!flag_in_range( (flag_t)tcp_no_new_conn_rplflag ) )
					yyerror("invalid TCP no_new_conn RePLy Flag");
				flag_idx2mask( &tcp_no_new_conn_rplflag );
		}
#line 4410 "cfg.tab.c"
    break;

  case 241: /* assign_stm: TCP_NO_NEW_CONN_RPLFLAG EQUAL error  */
#line 1364 "cfg.y"
                                                      { yyerror("number value expected"); }
#line 4416 "cfg.tab.c"
    break;

  case 242: /* assign_stm: TCP_KEEPALIVE EQUAL NUMBER  */
#line 1366 "cfg.y"
                                             { IFOR();
				tcp_keepalive=!!(yyvsp[0].intval);
		}
#line 4424 "cfg.tab.c"
    break;

  case 243: /* assign_stm: TCP_KEEPALIVE EQUAL error  */
#line 1369 "cfg.y"
                                            { yyerror("boolean value expected"); }
#line 4430 "cfg.tab.c"
    break;

  case 244: /* assign_stm: TCP_MAX_MSG_TIME EQUAL NUMBER  */
#line 1370 "cfg.y"
                                                { IFOR();
				tcp_max_msg_time=(yyvsp[0].intval);
		}
#line 4438 "cfg.tab.c"
    break;

  case 245: /* assign_stm: TCP_MAX_MSG_TIME EQUAL error  */
#line 1373 "cfg.y"
                                               { yyerror("boolean value expected"); }
#line 4444 "cfg.tab.c"
    break;

  case 246: /* assign_stm: TCP_PARALLEL_READ_ON_WORKERS EQUAL NUMBER  */
#line 1374 "cfg.y"
                                                            { IFOR();
				tcp_parallel_read_on_workers=!!(yyvsp[0].intval);
		}
#line 4452 "cfg.tab.c"
    break;

  case 247: /* assign_stm: TCP_PARALLEL_READ_ON_WORKERS EQUAL error  */
#line 1377 "cfg.y"
                                                           {
			yyerror("boolean value expected");
		}
#line 4460 "cfg.tab.c"
    break;

  case 248: /* assign_stm: TCP_KEEPCOUNT EQUAL NUMBER  */
#line 1380 "cfg.y"
                                                        { IFOR();
			#ifndef HAVE_TCP_KEEPCNT
				warn("cannot be enabled TCP_KEEPCOUNT (no OS support)");
			#else
				tcp_keepcount=(yyvsp[0].intval);
			#endif
		}
#line 4472 "cfg.tab.c"
    break;

  case 249: /* assign_stm: TCP_KEEPCOUNT EQUAL error  */
#line 1387 "cfg.y"
                                            { yyerror("int value expected"); }
#line 4478 "cfg.tab.c"
    break;

  case 250: /* assign_stm: TCP_KEEPIDLE EQUAL NUMBER  */
#line 1388 "cfg.y"
                                                        { IFOR();
			#ifndef HAVE_TCP_KEEPIDLE
				warn("cannot be enabled TCP_KEEPIDLE (no OS support)");
			#else
				tcp_keepidle=(yyvsp[0].intval);
			#endif
		}
#line 4490 "cfg.tab.c"
    break;

  case 251: /* assign_stm: TCP_KEEPIDLE EQUAL error  */
#line 1395 "cfg.y"
                                           { yyerror("int value expected"); }
#line 4496 "cfg.tab.c"
    break;

  case 252: /* assign_stm: TCP_KEEPINTERVAL EQUAL NUMBER  */
#line 1396 "cfg.y"
                                                { IFOR();
			#ifndef HAVE_TCP_KEEPINTVL
				warn("cannot be enabled TCP_KEEPINTERVAL (no OS support)");
			#else
				tcp_keepinterval=(yyvsp[0].intval);
			 #endif
		}
#line 4508 "cfg.tab.c"
    break;

  case 253: /* assign_stm: TCP_KEEPINTERVAL EQUAL error  */
#line 1403 "cfg.y"
                                               { yyerror("int value expected"); }
#line 4514 "cfg.tab.c"
    break;

  case 254: /* assign_stm: SERVER_SIGNATURE EQUAL NUMBER  */
#line 1404 "cfg.y"
                                                { IFOR();
							server_signature=(yyvsp[0].intval); }
#line 4521 "cfg.tab.c"
    break;

  case 255: /* assign_stm: SERVER_SIGNATURE EQUAL error  */
#line 1406 "cfg.y"
                                               { yyerror("boolean value expected"); }
#line 4527 "cfg.tab.c"
    break;

  case 256: /* assign_stm: SERVER_HEADER EQUAL STRING  */
#line 1407 "cfg.y"
                                             { IFOR();
							server_header->s=(yyvsp[0].strval);
							server_header->len=strlen((yyvsp[0].strval));
							}
#line 4536 "cfg.tab.c"
    break;

  case 257: /* assign_stm: SERVER_HEADER EQUAL error  */
#line 1411 "cfg.y"
                                            { yyerror("string value expected"); }
#line 4542 "cfg.tab.c"
    break;

  case 258: /* assign_stm: USER_AGENT_HEADER EQUAL STRING  */
#line 1412 "cfg.y"
                                                 { user_agent_header->s=(yyvsp[0].strval);
			user_agent_header->len=strlen((yyvsp[0].strval));
									}
#line 4550 "cfg.tab.c"
    break;

  case 259: /* assign_stm: USER_AGENT_HEADER EQUAL error  */
#line 1415 "cfg.y"
                                                { yyerror("string value expected"); }
#line 4556 "cfg.tab.c"
    break;

  case 260: /* assign_stm: PV_PRINT_BUF_SIZE EQUAL NUMBER  */
#line 1416 "cfg.y"
                                                 { IFOR();
							pv_print_buf_size = (yyvsp[0].intval); }
#line 4563 "cfg.tab.c"
    break;

  case 261: /* assign_stm: PV_PRINT_BUF_SIZE EQUAL error  */
#line 1418 "cfg.y"
                                                { yyerror("number expected"); }
#line 4569 "cfg.tab.c"
    break;

  case 262: /* assign_stm: XLOG_BUF_SIZE EQUAL NUMBER  */
#line 1419 "cfg.y"
                                             { IFOR();
							xlog_buf_size = (yyvsp[0].intval); }
#line 4576 "cfg.tab.c"
    break;

  case 263: /* assign_stm: XLOG_FORCE_COLOR EQUAL NUMBER  */
#line 1421 "cfg.y"
                                                { IFOR();
							xlog_force_color = (yyvsp[0].intval); }
#line 4583 "cfg.tab.c"
    break;

  case 264: /* assign_stm: XLOG_PRINT_LEVEL EQUAL NUMBER  */
#line 1423 "cfg.y"
                                                { IFOR();
							xlog_print_level = (yyvsp[0].intval); }
#line 4590 "cfg.tab.c"
    break;

  case 265: /* assign_stm: XLOG_BUF_SIZE EQUAL error  */
#line 1425 "cfg.y"
                                            { yyerror("number expected"); }
#line 4596 "cfg.tab.c"
    break;

  case 266: /* assign_stm: XLOG_FORCE_COLOR EQUAL error  */
#line 1426 "cfg.y"
                                               { yyerror("boolean value expected"); }
#line 4602 "cfg.tab.c"
    break;

  case 267: /* assign_stm: XLOG_PRINT_LEVEL EQUAL error  */
#line 1427 "cfg.y"
                                               { yyerror("number expected"); }
#line 4608 "cfg.tab.c"
    break;

  case 268: /* assign_stm: XLOG_LEVEL EQUAL snumber  */
#line 1428 "cfg.y"
                                           { IFOR();
							*xlog_level = (yyvsp[0].intval); }
#line 4615 "cfg.tab.c"
    break;

  case 269: /* assign_stm: XLOG_LEVEL EQUAL error  */
#line 1430 "cfg.y"
                                         { yyerror("number expected"); }
#line 4621 "cfg.tab.c"
    break;

  case 270: /* assign_stm: SOCKET EQUAL socket_def  */
#line 1431 "cfg.y"
                                          { IFOR();
							for (lst_tmp = (yyvsp[0].sockid); lst_tmp; lst_tmp = lst_tmp->next) {
								if (add_listening_socket(lst_tmp)!=0){
									LM_CRIT("cfg. parser: failed"
											" to add listening socket\n");
									break;
								}
							}
						}
#line 4635 "cfg.tab.c"
    break;

  case 271: /* assign_stm: SOCKET EQUAL error  */
#line 1440 "cfg.y"
                                      { yyerror("ip address or hostname "
						"expected (use quotes if the hostname includes"
						" config keywords)"); }
#line 4643 "cfg.tab.c"
    break;

  case 272: /* assign_stm: LISTEN EQUAL socket_def  */
#line 1443 "cfg.y"
                                          { IFOR();
							warn("'listen' is deprecated, use 'socket' instead");
							for (lst_tmp = (yyvsp[0].sockid); lst_tmp; lst_tmp = lst_tmp->next) {
								if (add_listening_socket(lst_tmp)!=0){
									LM_CRIT("cfg. parser: failed"
											" to add listen address\n");
									break;
								}
							}
						}
#line 4658 "cfg.tab.c"
    break;

  case 273: /* assign_stm: LISTEN EQUAL error  */
#line 1453 "cfg.y"
                                      { yyerror("ip address or hostname "
						"expected (use quotes if the hostname includes"
						" config keywords)"); }
#line 4666 "cfg.tab.c"
    break;

  case 274: /* assign_stm: MEMGROUP EQUAL STRING COLON multi_string  */
#line 1456 "cfg.y"
                                                           { IFOR();
							/* convert STIRNG ($3) to an ID */
							/* update the memstats type for each module */
							#ifndef SHM_EXTRA_STATS
								LM_CRIT("SHM_EXTRA_STATS not defined");
								YYABORT;
							#else

							#ifdef SHM_SHOW_DEFAULT_GROUP
							if(strcmp((yyvsp[-2].strval), "default") == 0){
								LM_CRIT("default group  name is not allowed");
								YYABORT;
							}
							#endif

							for(tmp_mod = mod_names; tmp_mod; tmp_mod=tmp_mod->next){
								if(strcmp((yyvsp[-2].strval), tmp_mod->s) == 0){
									LM_CRIT("The same mem-group name is used twice: [%s] [%s]\n", (yyvsp[-2].strval), tmp_mod->s);
									YYABORT;
								}
							}

							tmp_mod = pkg_malloc(sizeof(struct multi_str));
							if(!tmp_mod){
								LM_CRIT("out of pkg memory");
								YYABORT;
							}

							tmp_mod->s = (yyvsp[-2].strval);
							tmp_mod->next = mod_names;
							mod_names = tmp_mod;
							for (tmp_mod = (yyvsp[0].multistr); tmp_mod; tmp_mod = tmp_mod->next){
								if(set_mem_idx(tmp_mod->s, mem_free_idx)){
									YYABORT;
								}
							}

							mem_free_idx++;

							if(alloc_group_stat()){
								YYABORT;
							}
							#endif
						}
#line 4715 "cfg.tab.c"
    break;

  case 275: /* assign_stm: MEMGROUP EQUAL STRING COLON error  */
#line 1500 "cfg.y"
                                                    { yyerror("invalid or no module specified"); }
#line 4721 "cfg.tab.c"
    break;

  case 276: /* assign_stm: ALIAS EQUAL id_lst  */
#line 1501 "cfg.y"
                                      { IFOR();
							for(lst_tmp=(yyvsp[0].sockid); lst_tmp; lst_tmp=lst_tmp->next)
								add_alias(lst_tmp->name, strlen(lst_tmp->name),
											lst_tmp->port, lst_tmp->proto, si_subdomain_to_alias_flag(lst_tmp->flags));
							  }
#line 4731 "cfg.tab.c"
    break;

  case 277: /* assign_stm: ALIAS EQUAL error  */
#line 1506 "cfg.y"
                                      { yyerror("hostname expected (use quotes"
							" if the hostname includes config keywords)"); }
#line 4738 "cfg.tab.c"
    break;

  case 278: /* assign_stm: AUTO_ALIASES EQUAL NUMBER  */
#line 1508 "cfg.y"
                                            { IFOR();
								auto_aliases=(yyvsp[0].intval); }
#line 4745 "cfg.tab.c"
    break;

  case 279: /* assign_stm: AUTO_ALIASES EQUAL error  */
#line 1510 "cfg.y"
                                            { yyerror("number  expected"); }
#line 4751 "cfg.tab.c"
    break;

  case 280: /* assign_stm: ADVERTISED_ADDRESS EQUAL listen_id  */
#line 1511 "cfg.y"
                                                     { IFOR();
								if ((yyvsp[0].strval)) {
									default_global_address->s=(yyvsp[0].strval);
									default_global_address->len=strlen((yyvsp[0].strval));
								}
								}
#line 4762 "cfg.tab.c"
    break;

  case 281: /* assign_stm: ADVERTISED_ADDRESS EQUAL error  */
#line 1517 "cfg.y"
                                                 {yyerror("ip address or hostname "
												"expected"); }
#line 4769 "cfg.tab.c"
    break;

  case 282: /* assign_stm: ADVERTISED_PORT EQUAL NUMBER  */
#line 1519 "cfg.y"
                                               { IFOR();
								tmp = int2str((yyvsp[0].intval), &i_tmp);
								if (i_tmp > default_global_port->len)
									default_global_port->s =
									pkg_realloc(default_global_port->s, i_tmp);
								if (!default_global_port->s) {
									LM_CRIT("cfg. parser: out of memory.\n");
									YYABORT;
								} else {
									default_global_port->len = i_tmp;
									memcpy(default_global_port->s, tmp,
											default_global_port->len);
								}
								}
#line 4788 "cfg.tab.c"
    break;

  case 283: /* assign_stm: ADVERTISED_PORT EQUAL error  */
#line 1533 "cfg.y"
                                             {yyerror("ip address or hostname "
												"expected"); }
#line 4795 "cfg.tab.c"
    break;

  case 284: /* assign_stm: DISABLE_CORE EQUAL NUMBER  */
#line 1535 "cfg.y"
                                            { IFOR();
										disable_core_dump=(yyvsp[0].intval);
									}
#line 4803 "cfg.tab.c"
    break;

  case 285: /* assign_stm: DISABLE_CORE EQUAL error  */
#line 1538 "cfg.y"
                                           { yyerror("boolean value expected"); }
#line 4809 "cfg.tab.c"
    break;

  case 286: /* assign_stm: OPEN_FD_LIMIT EQUAL NUMBER  */
#line 1539 "cfg.y"
                                             { IFOR();
										open_files_limit=(yyvsp[0].intval);
									}
#line 4817 "cfg.tab.c"
    break;

  case 287: /* assign_stm: OPEN_FD_LIMIT EQUAL error  */
#line 1542 "cfg.y"
                                            { yyerror("number expected"); }
#line 4823 "cfg.tab.c"
    break;

  case 288: /* assign_stm: MCAST_LOOPBACK EQUAL NUMBER  */
#line 1543 "cfg.y"
                                              { IFOR();
								#ifdef USE_MCAST
										mcast_loopback=(yyvsp[0].intval);
								#else
									warn("no multicast support compiled in");
								#endif
		  }
#line 4835 "cfg.tab.c"
    break;

  case 289: /* assign_stm: MCAST_LOOPBACK EQUAL error  */
#line 1550 "cfg.y"
                                             { yyerror("boolean value expected"); }
#line 4841 "cfg.tab.c"
    break;

  case 290: /* assign_stm: MCAST_TTL EQUAL NUMBER  */
#line 1551 "cfg.y"
                                         { IFOR();
								#ifdef USE_MCAST
										mcast_ttl=(yyvsp[0].intval);
								#else
									warn("no multicast support compiled in");
								#endif
		  }
#line 4853 "cfg.tab.c"
    break;

  case 291: /* assign_stm: MCAST_TTL EQUAL error  */
#line 1558 "cfg.y"
                                        { yyerror("number expected as tos"); }
#line 4859 "cfg.tab.c"
    break;

  case 292: /* assign_stm: TOS EQUAL NUMBER  */
#line 1559 "cfg.y"
                                   { IFOR(); tos = (yyvsp[0].intval);
							if (tos<0)
								yyerror("invalid tos value");
		 }
#line 4868 "cfg.tab.c"
    break;

  case 293: /* assign_stm: TOS EQUAL ID  */
#line 1563 "cfg.y"
                               { IFOR();
							if (strcasecmp((yyvsp[0].strval),"IPTOS_LOWDELAY")) {
								tos=IPTOS_LOWDELAY;
							} else if (strcasecmp((yyvsp[0].strval),"IPTOS_THROUGHPUT")) {
								tos=IPTOS_THROUGHPUT;
							} else if (strcasecmp((yyvsp[0].strval),"IPTOS_RELIABILITY")) {
								tos=IPTOS_RELIABILITY;
#if defined(IPTOS_MINCOST)
							} else if (strcasecmp((yyvsp[0].strval),"IPTOS_MINCOST")) {
								tos=IPTOS_MINCOST;
#endif
#if defined(IPTOS_LOWCOST)
							} else if (strcasecmp((yyvsp[0].strval),"IPTOS_LOWCOST")) {
								tos=IPTOS_LOWCOST;
#endif
							} else {
								yyerror("invalid tos value - allowed: "
									"IPTOS_LOWDELAY,IPTOS_THROUGHPUT,"
									"IPTOS_RELIABILITY"
#if defined(IPTOS_LOWCOST)
									",IPTOS_LOWCOST"
#endif
#if defined(IPTOS_MINCOST)
									",IPTOS_MINCOST"
#endif
									"\n");
							}
		 }
#line 4901 "cfg.tab.c"
    break;

  case 294: /* assign_stm: TOS EQUAL error  */
#line 1591 "cfg.y"
                                  { yyerror("number expected"); }
#line 4907 "cfg.tab.c"
    break;

  case 295: /* assign_stm: MPATH EQUAL STRING  */
#line 1592 "cfg.y"
                                     {IFOR();
				add_mpath((yyvsp[0].strval)); }
#line 4914 "cfg.tab.c"
    break;

  case 296: /* assign_stm: MPATH EQUAL error  */
#line 1594 "cfg.y"
                                     { yyerror("string value expected"); }
#line 4920 "cfg.tab.c"
    break;

  case 297: /* assign_stm: DISABLE_DNS_FAILOVER EQUAL NUMBER  */
#line 1595 "cfg.y"
                                                    { IFOR();
										disable_dns_failover=(yyvsp[0].intval);
									}
#line 4928 "cfg.tab.c"
    break;

  case 298: /* assign_stm: DISABLE_DNS_FAILOVER error  */
#line 1598 "cfg.y"
                                             { yyerror("boolean value expected"); }
#line 4934 "cfg.tab.c"
    break;

  case 299: /* assign_stm: DISABLE_DNS_BLACKLIST EQUAL NUMBER  */
#line 1599 "cfg.y"
                                                     { IFOR();
										disable_dns_blacklist=(yyvsp[0].intval);
									}
#line 4942 "cfg.tab.c"
    break;

  case 300: /* assign_stm: DISABLE_DNS_BLACKLIST error  */
#line 1602 "cfg.y"
                                              { yyerror("boolean value expected"); }
#line 4948 "cfg.tab.c"
    break;

  case 301: /* assign_stm: DST_BLACKLIST EQUAL ID SLASH blst_flags blst_def  */
#line 1603 "cfg.y"
                                                                   { IFOR();
				s_tmp.s = (yyvsp[-3].strval);
				s_tmp.len = strlen((yyvsp[-3].strval));
				if (create_bl_head(_str("script"), (yyvsp[-1].intval),
				    bl_head, bl_tail, &s_tmp)==0) {
					yyerror("failed to create blacklist\n");
					YYABORT;
				}
				bl_head = bl_tail = NULL;
				}
#line 4963 "cfg.tab.c"
    break;

  case 302: /* assign_stm: DST_BLACKLIST EQUAL ID blst_def  */
#line 1613 "cfg.y"
                                                  { IFOR();
				s_tmp.s = (yyvsp[-1].strval);
				s_tmp.len = strlen((yyvsp[-1].strval));
				if (create_bl_head(_str("script"), BL_READONLY_LIST,
				    bl_head, bl_tail, &s_tmp)==0) {
					yyerror("failed to create blacklist\n");
					YYABORT;
				}
				bl_head = bl_tail = NULL;
				}
#line 4978 "cfg.tab.c"
    break;

  case 303: /* assign_stm: DISABLE_STATELESS_FWD EQUAL NUMBER  */
#line 1623 "cfg.y"
                                                     { IFOR();
				sl_fwd_disabled=(yyvsp[0].intval); }
#line 4985 "cfg.tab.c"
    break;

  case 304: /* assign_stm: DB_VERSION_TABLE EQUAL STRING  */
#line 1625 "cfg.y"
                                                { IFOR();
				db_version_table=(yyvsp[0].strval); }
#line 4992 "cfg.tab.c"
    break;

  case 305: /* assign_stm: DB_VERSION_TABLE EQUAL error  */
#line 1627 "cfg.y"
                                               { yyerror("string value expected"); }
#line 4998 "cfg.tab.c"
    break;

  case 306: /* assign_stm: DB_DEFAULT_URL EQUAL STRING  */
#line 1628 "cfg.y"
                                              { IFOR();
				db_default_url=(yyvsp[0].strval); }
#line 5005 "cfg.tab.c"
    break;

  case 307: /* assign_stm: DB_DEFAULT_URL EQUAL error  */
#line 1630 "cfg.y"
                                             { yyerror("string value expected"); }
#line 5011 "cfg.tab.c"
    break;

  case 308: /* assign_stm: DB_MAX_ASYNC_CONNECTIONS EQUAL NUMBER  */
#line 1631 "cfg.y"
                                                        { IFOR();
				db_max_async_connections=(yyvsp[0].intval); }
#line 5018 "cfg.tab.c"
    break;

  case 309: /* assign_stm: DB_MAX_ASYNC_CONNECTIONS EQUAL error  */
#line 1633 "cfg.y"
                                                       {
				yyerror("integer value expected");
				}
#line 5026 "cfg.tab.c"
    break;

  case 310: /* assign_stm: DISABLE_503_TRANSLATION EQUAL NUMBER  */
#line 1636 "cfg.y"
                                                       { IFOR();
				disable_503_translation=(yyvsp[0].intval); }
#line 5033 "cfg.tab.c"
    break;

  case 311: /* assign_stm: DISABLE_503_TRANSLATION EQUAL error  */
#line 1638 "cfg.y"
                                                      {
				yyerror("integer value expected");
				}
#line 5041 "cfg.tab.c"
    break;

  case 312: /* assign_stm: AUTO_SCALING_PROFILE EQUAL auto_scale_profile_def  */
#line 1641 "cfg.y"
                                                                    {}
#line 5047 "cfg.tab.c"
    break;

  case 313: /* assign_stm: AUTO_SCALING_PROFILE EQUAL error  */
#line 1642 "cfg.y"
                                                   {
				yyerror("bad auto-scaling profile definition");
				}
#line 5055 "cfg.tab.c"
    break;

  case 314: /* assign_stm: AUTO_SCALING_CYCLE EQUAL NUMBER  */
#line 1645 "cfg.y"
                                                  { IFOR();
				auto_scaling_cycle=(yyvsp[0].intval); }
#line 5062 "cfg.tab.c"
    break;

  case 315: /* assign_stm: AUTO_SCALING_CYCLE EQUAL error  */
#line 1647 "cfg.y"
                                                 {
				yyerror("integer value expected");
				}
#line 5070 "cfg.tab.c"
    break;

  case 316: /* assign_stm: error EQUAL  */
#line 1650 "cfg.y"
                              { yyerror("unknown config variable"); }
#line 5076 "cfg.tab.c"
    break;

  case 317: /* module_stm: LOADMODULE STRING  */
#line 1653 "cfg.y"
                                        { IFOR();
			if (load_module((yyvsp[0].strval)) < 0)
				yyerrorf("failed to load module %s\n", (yyvsp[0].strval));
		}
#line 5085 "cfg.tab.c"
    break;

  case 318: /* module_stm: LOADMODULE error  */
#line 1657 "cfg.y"
                                        { yyerror("string expected");  }
#line 5091 "cfg.tab.c"
    break;

  case 319: /* module_stm: MODPARAM LPAREN STRING COMMA STRING COMMA STRING RPAREN  */
#line 1658 "cfg.y"
                                                                          { IFOR();
				if (set_mod_param_regex((yyvsp[-5].strval), (yyvsp[-3].strval), STR_PARAM, (yyvsp[-1].strval)) != 0) {
					yyerrorf("Parameter <%s> not found in module <%s> - "
						"can't set", (yyvsp[-3].strval), (yyvsp[-5].strval));
				}
			}
#line 5102 "cfg.tab.c"
    break;

  case 320: /* module_stm: MODPARAM LPAREN STRING COMMA STRING COMMA folded_string RPAREN  */
#line 1664 "cfg.y"
                                                                                 { IFOR();
				if (set_mod_param_regex((yyvsp[-5].strval), (yyvsp[-3].strval), STR_PARAM, (yyvsp[-1].strval)) != 0) {
					yyerrorf("Parameter <%s> not found in module <%s> - "
						"can't set", (yyvsp[-3].strval), (yyvsp[-5].strval));
				}
			}
#line 5113 "cfg.tab.c"
    break;

  case 321: /* module_stm: MODPARAM LPAREN STRING COMMA STRING COMMA snumber RPAREN  */
#line 1670 "cfg.y"
                                                                           { IFOR();
				if (set_mod_param_regex((yyvsp[-5].strval), (yyvsp[-3].strval), INT_PARAM, (void*)(yyvsp[-1].intval)) != 0) {
					yyerrorf("Parameter <%s> not found in module <%s> - "
						"can't set", (yyvsp[-3].strval), (yyvsp[-5].strval));
				}
			}
#line 5124 "cfg.tab.c"
    break;

  case 322: /* module_stm: MODPARAM error  */
#line 1676 "cfg.y"
                                 { yyerror("Invalid arguments"); }
#line 5130 "cfg.tab.c"
    break;

  case 323: /* ip: ipv4  */
#line 1680 "cfg.y"
                       { (yyval.ipaddr)=(yyvsp[0].ipaddr); }
#line 5136 "cfg.tab.c"
    break;

  case 324: /* ip: ipv6  */
#line 1681 "cfg.y"
                       { (yyval.ipaddr)=(yyvsp[0].ipaddr); }
#line 5142 "cfg.tab.c"
    break;

  case 325: /* ipv4: IPV4ADDR  */
#line 1684 "cfg.y"
                 {
					(yyval.ipaddr)=pkg_malloc(sizeof(struct ip_addr));
					if ((yyval.ipaddr)==0){
						LM_CRIT("ERROR: cfg. parser: out of memory.\n");
						YYABORT;
					}else{
						memset((yyval.ipaddr), 0, sizeof(struct ip_addr));
						(yyval.ipaddr)->af=AF_INET;
						(yyval.ipaddr)->len=16;
						if (inet_pton(AF_INET, (yyvsp[0].strval), (yyval.ipaddr)->u.addr)<=0){
							yyerror("bad ipv4 address");
						}
					}
				}
#line 5161 "cfg.tab.c"
    break;

  case 326: /* ipv6addr: IPV6ADDR  */
#line 1700 "cfg.y"
                         {
					(yyval.ipaddr)=pkg_malloc(sizeof(struct ip_addr));
					if ((yyval.ipaddr)==0){
						LM_CRIT("ERROR: cfg. parser: out of memory.\n");
						YYABORT;
					}else{
						memset((yyval.ipaddr), 0, sizeof(struct ip_addr));
						(yyval.ipaddr)->af=AF_INET6;
						(yyval.ipaddr)->len=16;
						if (inet_pton(AF_INET6, (yyvsp[0].strval), (yyval.ipaddr)->u.addr)<=0){
							yyerror("bad ipv6 address");
						}
					}
				}
#line 5180 "cfg.tab.c"
    break;

  case 327: /* ipv6: ipv6addr  */
#line 1716 "cfg.y"
                 { (yyval.ipaddr)=(yyvsp[0].ipaddr); }
#line 5186 "cfg.tab.c"
    break;

  case 328: /* ipv6: LBRACK ipv6addr RBRACK  */
#line 1717 "cfg.y"
                                 {(yyval.ipaddr)=(yyvsp[-1].ipaddr); }
#line 5192 "cfg.tab.c"
    break;

  case 329: /* ipnet: IPNET  */
#line 1720 "cfg.y"
                {
				if (parse_ipnet((yyvsp[0].strval), strlen((yyvsp[0].strval)), &net_tmp) < 0)
					yyerror("unable to parse ip and/or netmask\n");

				(yyval.ipnet) = net_tmp;
			}
#line 5203 "cfg.tab.c"
    break;

  case 330: /* ipnet: ip  */
#line 1726 "cfg.y"
                        {
				(yyval.ipnet)=mk_net_bitlen((yyvsp[0].ipaddr), (yyvsp[0].ipaddr)->len*8);
				pkg_free((yyvsp[0].ipaddr));
			}
#line 5212 "cfg.tab.c"
    break;

  case 331: /* folded_string: STRING STRING  */
#line 1736 "cfg.y"
                              {
				(yyval.strval) = pkg_malloc( strlen((yyvsp[-1].strval)) + strlen((yyvsp[0].strval)) + 1);
				if ((yyval.strval)==0){
					yyerror("cfg. parser: out of memory");
					YYABORT;
				} else {
					strcpy((yyval.strval),(yyvsp[-1].strval)); strcat((yyval.strval),(yyvsp[0].strval));
					pkg_free((yyvsp[-1].strval)); pkg_free((yyvsp[0].strval));
				}
			}
#line 5227 "cfg.tab.c"
    break;

  case 332: /* folded_string: folded_string STRING  */
#line 1746 "cfg.y"
                                       {
				(yyval.strval) = pkg_malloc( strlen((yyvsp[-1].strval)) + strlen((yyvsp[0].strval)) + 1);
				if ((yyval.strval)==0){
					LM_CRIT("ERROR: cfg. parser: out of memory.\n");
					YYABORT;
				} else {
					strcpy((yyval.strval),(yyvsp[-1].strval)); strcat((yyval.strval),(yyvsp[0].strval));
					pkg_free((yyvsp[-1].strval)); pkg_free((yyvsp[0].strval));
				}
			}
#line 5242 "cfg.tab.c"
    break;

  case 333: /* route_name: ID  */
#line 1757 "cfg.y"
                {
				(yyval.strval) = (yyvsp[0].strval);
				}
#line 5250 "cfg.tab.c"
    break;

  case 334: /* route_name: NUMBER  */
#line 1760 "cfg.y"
                         {
				tmp=int2str((yyvsp[0].intval), &i_tmp);
				if (((yyval.strval)=pkg_malloc(i_tmp+1))==0) {
					yyerror("cfg. parser: out of memory.\n");
					YYABORT;
				}
				memcpy( (yyval.strval), tmp, i_tmp);
				(yyval.strval)[i_tmp] = 0;
				}
#line 5264 "cfg.tab.c"
    break;

  case 335: /* route_name: STRING  */
#line 1769 "cfg.y"
                        {
				(yyval.strval) = (yyvsp[0].strval);
		}
#line 5272 "cfg.tab.c"
    break;

  case 336: /* route_name_var: route_name  */
#line 1774 "cfg.y"
                           {
				/* check to see if there are any "$" in the string name */
				tmp = strchr((yyvsp[0].strval), '$');
				if (!tmp) {
					/* route name is a cosntant string - search for the route */
					rn_tmp.data = 0;
					rn_tmp.iname = get_script_route_idx((yyvsp[0].strval), sroutes->request,
							RT_NO, 0);
					if (rn_tmp.iname==-1)
						yyerror("too many script routes");
					(yyval.intval) = NUMBER_ST;
				} else {
					tstr.s = (yyvsp[0].strval);
					tstr.len = strlen(tstr.s);
					if (pv_parse_format(&tstr, &elem) < 0) {
						yyerror("cannot parse format");
						YYABORT;
					}
					/* the route name is a format, so we can't evaluate it now */
					rn_tmp.ename = elem;
					(yyval.intval) = SCRIPTVAR_ELEM_ST;
				}
			}
#line 5300 "cfg.tab.c"
    break;

  case 337: /* route_name_var: script_var  */
#line 1797 "cfg.y"
                             {
				rn_tmp.sname = (yyvsp[0].specval);
				(yyval.intval) = SCRIPTVAR_ST;
		}
#line 5309 "cfg.tab.c"
    break;

  case 338: /* route_stm: ROUTE LBRACE actions RBRACE  */
#line 1802 "cfg.y"
                                        {
						if (sroutes->request[DEFAULT_RT].a!=0) {
							yyerror("overwriting default "
								"request routing table");
							YYABORT;
						}
						push((yyvsp[-1].action), &sroutes->request[DEFAULT_RT].a);
					}
#line 5322 "cfg.tab.c"
    break;

  case 339: /* route_stm: ROUTE LBRACK route_name RBRACK LBRACE actions RBRACE  */
#line 1810 "cfg.y"
                                                                       {
						if ( strtol((yyvsp[-4].strval),&tmp,10)==0 && *tmp==0) {
							/* route[0] detected */
							if (sroutes->request[DEFAULT_RT].a!=0) {
								yyerror("overwriting(2) default "
									"request routing table");
								YYABORT;
							}
							push((yyvsp[-1].action), &sroutes->request[DEFAULT_RT].a);
						} else {
							i_tmp = get_script_route_idx( (yyvsp[-4].strval),
								sroutes->request, RT_NO,1);
							if (i_tmp==-1) YYABORT;
							push((yyvsp[-1].action), &sroutes->request[i_tmp].a);
						}
					}
#line 5343 "cfg.tab.c"
    break;

  case 340: /* route_stm: ROUTE error  */
#line 1826 "cfg.y"
                              { yyerror("invalid  route  statement"); }
#line 5349 "cfg.tab.c"
    break;

  case 341: /* failure_route_stm: ROUTE_FAILURE LBRACK route_name RBRACK LBRACE actions RBRACE  */
#line 1829 "cfg.y"
                                                                                {
						i_tmp = get_script_route_idx( (yyvsp[-4].strval), sroutes->failure,
							FAILURE_RT_NO,1);
						if (i_tmp==-1) YYABORT;
						push((yyvsp[-1].action), &sroutes->failure[i_tmp].a);
					}
#line 5360 "cfg.tab.c"
    break;

  case 342: /* failure_route_stm: ROUTE_FAILURE error  */
#line 1835 "cfg.y"
                                      { yyerror("invalid failure_route statement"); }
#line 5366 "cfg.tab.c"
    break;

  case 343: /* onreply_route_stm: ROUTE_ONREPLY LBRACE actions RBRACE  */
#line 1838 "cfg.y"
                                                       {
						if (sroutes->onreply[DEFAULT_RT].a!=0) {
							yyerror("overwriting default "
								"onreply routing table");
							YYABORT;
						}
						push((yyvsp[-1].action), &sroutes->onreply[DEFAULT_RT].a);
					}
#line 5379 "cfg.tab.c"
    break;

  case 344: /* onreply_route_stm: ROUTE_ONREPLY LBRACK route_name RBRACK LBRACE actions RBRACE  */
#line 1846 "cfg.y"
                                                                               {
						i_tmp = get_script_route_idx( (yyvsp[-4].strval), sroutes->onreply,
							ONREPLY_RT_NO,1);
						if (i_tmp==-1) YYABORT;
						push((yyvsp[-1].action), &sroutes->onreply[i_tmp].a);
					}
#line 5390 "cfg.tab.c"
    break;

  case 345: /* onreply_route_stm: ROUTE_ONREPLY error  */
#line 1852 "cfg.y"
                                      { yyerror("invalid onreply_route statement"); }
#line 5396 "cfg.tab.c"
    break;

  case 346: /* branch_route_stm: ROUTE_BRANCH LBRACK route_name RBRACK LBRACE actions RBRACE  */
#line 1855 "cfg.y"
                                                                              {
						i_tmp = get_script_route_idx( (yyvsp[-4].strval), sroutes->branch,
							BRANCH_RT_NO,1);
						if (i_tmp==-1) YYABORT;
						push((yyvsp[-1].action), &sroutes->branch[i_tmp].a);
					}
#line 5407 "cfg.tab.c"
    break;

  case 347: /* branch_route_stm: ROUTE_BRANCH error  */
#line 1861 "cfg.y"
                                     { yyerror("invalid branch_route statement"); }
#line 5413 "cfg.tab.c"
    break;

  case 348: /* error_route_stm: ROUTE_ERROR LBRACE actions RBRACE  */
#line 1864 "cfg.y"
                                                    {
						if (sroutes->error.a!=0) {
							yyerror("overwriting default "
								"error routing table");
							YYABORT;
						}
						push((yyvsp[-1].action), &sroutes->error.a);
					}
#line 5426 "cfg.tab.c"
    break;

  case 349: /* error_route_stm: ROUTE_ERROR error  */
#line 1872 "cfg.y"
                                    { yyerror("invalid error_route statement"); }
#line 5432 "cfg.tab.c"
    break;

  case 350: /* local_route_stm: ROUTE_LOCAL LBRACE actions RBRACE  */
#line 1875 "cfg.y"
                                                    {
						if (sroutes->local.a!=0) {
							yyerror("re-definition of local "
								"route detected");
							YYABORT;
						}
						push((yyvsp[-1].action), &sroutes->local.a);
					}
#line 5445 "cfg.tab.c"
    break;

  case 351: /* local_route_stm: ROUTE_LOCAL error  */
#line 1883 "cfg.y"
                                    { yyerror("invalid local_route statement"); }
#line 5451 "cfg.tab.c"
    break;

  case 352: /* startup_route_stm: ROUTE_STARTUP LBRACE actions RBRACE  */
#line 1886 "cfg.y"
                                                        {
						if (sroutes->startup.a!=0) {
							yyerror("re-definition of startup "
								"route detected");
							YYABORT;
						}
						push((yyvsp[-1].action), &sroutes->startup.a);
					}
#line 5464 "cfg.tab.c"
    break;

  case 353: /* startup_route_stm: ROUTE_STARTUP error  */
#line 1894 "cfg.y"
                                      { yyerror("invalid startup_route statement"); }
#line 5470 "cfg.tab.c"
    break;

  case 354: /* timer_route_stm: ROUTE_TIMER LBRACK route_name COMMA NUMBER RBRACK LBRACE actions RBRACE  */
#line 1897 "cfg.y"
                                                                                          {
						i_tmp = 0;
						while(i_tmp<TIMER_RT_NO && sroutes->timer[i_tmp].a!=0){
							i_tmp++;
						}
						if(i_tmp == TIMER_RT_NO) {
							yyerror("Too many timer routes defined\n");
							YYABORT;
						}
						sroutes->timer[i_tmp].name = (yyvsp[-6].strval);
						sroutes->timer[i_tmp].interval = (yyvsp[-4].intval);
						push((yyvsp[-1].action), &sroutes->timer[i_tmp].a);
					}
#line 5488 "cfg.tab.c"
    break;

  case 355: /* timer_route_stm: ROUTE_TIMER error  */
#line 1910 "cfg.y"
                                    { yyerror("invalid timer_route statement"); }
#line 5494 "cfg.tab.c"
    break;

  case 356: /* event_route_stm: ROUTE_EVENT LBRACK route_name RBRACK LBRACE actions RBRACE  */
#line 1913 "cfg.y"
                                                                            {
						i_tmp = get_script_route_idx((yyvsp[-4].strval), sroutes->event,
								EVENT_RT_NO,1);
						if (i_tmp==-1) YYABORT;
						push((yyvsp[-1].action), &sroutes->event[i_tmp].a);
					}
#line 5505 "cfg.tab.c"
    break;

  case 357: /* event_route_stm: ROUTE_EVENT error  */
#line 1919 "cfg.y"
                                    { yyerror("invalid event_route statement"); }
#line 5511 "cfg.tab.c"
    break;

  case 358: /* exp: exp AND exp  */
#line 1924 "cfg.y"
                        { (yyval.expr)=mk_exp(AND_OP, (yyvsp[-2].expr), (yyvsp[0].expr)); }
#line 5517 "cfg.tab.c"
    break;

  case 359: /* exp: exp OR exp  */
#line 1925 "cfg.y"
                                { (yyval.expr)=mk_exp(OR_OP, (yyvsp[-2].expr), (yyvsp[0].expr));  }
#line 5523 "cfg.tab.c"
    break;

  case 360: /* exp: NOT exp  */
#line 1926 "cfg.y"
                                        { (yyval.expr)=mk_exp(NOT_OP, (yyvsp[0].expr), 0);  }
#line 5529 "cfg.tab.c"
    break;

  case 361: /* exp: LPAREN exp RPAREN  */
#line 1927 "cfg.y"
                                { (yyval.expr)=mk_exp(EVAL_OP, (yyvsp[-1].expr), 0); }
#line 5535 "cfg.tab.c"
    break;

  case 362: /* exp: LBRACK assignexp RBRACK  */
#line 1928 "cfg.y"
                                  { (yyval.expr)=(yyvsp[-1].expr); }
#line 5541 "cfg.tab.c"
    break;

  case 363: /* exp: exp_elem  */
#line 1929 "cfg.y"
                                        { (yyval.expr)=(yyvsp[0].expr); }
#line 5547 "cfg.tab.c"
    break;

  case 364: /* equalop: EQUAL_T  */
#line 1932 "cfg.y"
                          {(yyval.intval)=EQUAL_OP; }
#line 5553 "cfg.tab.c"
    break;

  case 365: /* equalop: DIFF  */
#line 1933 "cfg.y"
                                {(yyval.intval)=DIFF_OP; }
#line 5559 "cfg.tab.c"
    break;

  case 366: /* compop: GT  */
#line 1936 "cfg.y"
                {(yyval.intval)=GT_OP; }
#line 5565 "cfg.tab.c"
    break;

  case 367: /* compop: LT  */
#line 1937 "cfg.y"
                        {(yyval.intval)=LT_OP; }
#line 5571 "cfg.tab.c"
    break;

  case 368: /* compop: GTE  */
#line 1938 "cfg.y"
                        {(yyval.intval)=GTE_OP; }
#line 5577 "cfg.tab.c"
    break;

  case 369: /* compop: LTE  */
#line 1939 "cfg.y"
                        {(yyval.intval)=LTE_OP; }
#line 5583 "cfg.tab.c"
    break;

  case 370: /* matchop: MATCH  */
#line 1941 "cfg.y"
                {(yyval.intval)=MATCH_OP; }
#line 5589 "cfg.tab.c"
    break;

  case 371: /* matchop: NOTMATCH  */
#line 1942 "cfg.y"
                                {(yyval.intval)=NOTMATCH_OP; }
#line 5595 "cfg.tab.c"
    break;

  case 372: /* intop: equalop  */
#line 1945 "cfg.y"
                {(yyval.intval)=(yyvsp[0].intval); }
#line 5601 "cfg.tab.c"
    break;

  case 373: /* intop: compop  */
#line 1946 "cfg.y"
                        {(yyval.intval)=(yyvsp[0].intval); }
#line 5607 "cfg.tab.c"
    break;

  case 374: /* strop: equalop  */
#line 1949 "cfg.y"
                {(yyval.intval)=(yyvsp[0].intval); }
#line 5613 "cfg.tab.c"
    break;

  case 375: /* strop: compop  */
#line 1950 "cfg.y"
                     {(yyval.intval)=(yyvsp[0].intval); }
#line 5619 "cfg.tab.c"
    break;

  case 376: /* strop: matchop  */
#line 1951 "cfg.y"
                                {(yyval.intval)=(yyvsp[0].intval); }
#line 5625 "cfg.tab.c"
    break;

  case 377: /* script_var: SCRIPTVAR  */
#line 1954 "cfg.y"
                                {
				spec = (pv_spec_t*)pkg_malloc(sizeof(pv_spec_t));
				if (spec==NULL){
					yyerror("no more pkg memory\n");
					YYABORT;
				}
				memset(spec, 0, sizeof(pv_spec_t));
				tstr.s = (yyvsp[0].strval);
				tstr.len = strlen(tstr.s);
				if(pv_parse_spec(&tstr, spec)==NULL)
				{
					yyerror("unknown script variable");
				}

				(yyval.specval) = spec;
			}
#line 5646 "cfg.tab.c"
    break;

  case 378: /* script_var: SCRIPTVARERR  */
#line 1970 "cfg.y"
                               {
			(yyval.specval)=0; yyerror("invalid script variable name");
		}
#line 5654 "cfg.tab.c"
    break;

  case 379: /* exp_elem: exp_cond  */
#line 1975 "cfg.y"
                                {(yyval.expr)=(yyvsp[0].expr); }
#line 5660 "cfg.tab.c"
    break;

  case 380: /* exp_elem: exp_stm  */
#line 1976 "cfg.y"
                                        {(yyval.expr)=mk_elem( NO_OP, ACTION_O, 0, ACTIONS_ST, (yyvsp[0].action) ); }
#line 5666 "cfg.tab.c"
    break;

  case 381: /* exp_elem: snumber  */
#line 1977 "cfg.y"
                                        {(yyval.expr)=mk_elem( NO_OP, NUMBER_O, 0, NUMBER_ST,
											(void*)(yyvsp[0].intval) ); }
#line 5673 "cfg.tab.c"
    break;

  case 382: /* exp_elem: script_var  */
#line 1979 "cfg.y"
                                {
				(yyval.expr)=mk_elem(NO_OP, SCRIPTVAR_O,0,SCRIPTVAR_ST,(void*)(yyvsp[0].specval));
			}
#line 5681 "cfg.tab.c"
    break;

  case 383: /* exp_cond: script_var strop script_var  */
#line 1984 "cfg.y"
                                      {
				(yyval.expr)=mk_elem( (yyvsp[-1].intval), SCRIPTVAR_O,(void*)(yyvsp[-2].specval),SCRIPTVAR_ST,(void*)(yyvsp[0].specval));
			}
#line 5689 "cfg.tab.c"
    break;

  case 384: /* exp_cond: script_var strop STRING  */
#line 1987 "cfg.y"
                                          {
				(yyval.expr)=mk_elem( (yyvsp[-1].intval), SCRIPTVAR_O,(void*)(yyvsp[-2].specval),STR_ST,(yyvsp[0].strval));
			}
#line 5697 "cfg.tab.c"
    break;

  case 385: /* exp_cond: script_var intop snumber  */
#line 1990 "cfg.y"
                                           {
				(yyval.expr)=mk_elem( (yyvsp[-1].intval), SCRIPTVAR_O,(void*)(yyvsp[-2].specval),NUMBER_ST,(void *)(yyvsp[0].intval));
			}
#line 5705 "cfg.tab.c"
    break;

  case 386: /* exp_cond: script_var equalop NULLV  */
#line 1993 "cfg.y"
                                                {
				(yyval.expr)=mk_elem( (yyvsp[-1].intval), SCRIPTVAR_O,(void*)(yyvsp[-2].specval), NULLV_ST, 0);
			}
#line 5713 "cfg.tab.c"
    break;

  case 387: /* exp_cond: script_var equalop ipnet  */
#line 1996 "cfg.y"
                                           {
				(yyval.expr)=mk_elem((yyvsp[-1].intval), SCRIPTVAR_O, (void*)(yyvsp[-2].specval), NET_ST, (yyvsp[0].ipnet));
			}
#line 5721 "cfg.tab.c"
    break;

  case 388: /* assignop: EQUAL  */
#line 2002 "cfg.y"
              { (yyval.intval) = EQ_T; }
#line 5727 "cfg.tab.c"
    break;

  case 389: /* assignop: COLONEQ  */
#line 2003 "cfg.y"
                  { (yyval.intval) = COLONEQ_T; }
#line 5733 "cfg.tab.c"
    break;

  case 390: /* assignop: PLUSEQ  */
#line 2004 "cfg.y"
                 { (yyval.intval) = PLUSEQ_T; }
#line 5739 "cfg.tab.c"
    break;

  case 391: /* assignop: MINUSEQ  */
#line 2005 "cfg.y"
                  { (yyval.intval) = MINUSEQ_T;}
#line 5745 "cfg.tab.c"
    break;

  case 392: /* assignop: SLASHEQ  */
#line 2006 "cfg.y"
                  { (yyval.intval) = DIVEQ_T; }
#line 5751 "cfg.tab.c"
    break;

  case 393: /* assignop: MULTEQ  */
#line 2007 "cfg.y"
                 { (yyval.intval) = MULTEQ_T; }
#line 5757 "cfg.tab.c"
    break;

  case 394: /* assignop: MODULOEQ  */
#line 2008 "cfg.y"
                   { (yyval.intval) = MODULOEQ_T; }
#line 5763 "cfg.tab.c"
    break;

  case 395: /* assignop: BANDEQ  */
#line 2009 "cfg.y"
                 { (yyval.intval) = BANDEQ_T; }
#line 5769 "cfg.tab.c"
    break;

  case 396: /* assignop: BOREQ  */
#line 2010 "cfg.y"
                { (yyval.intval) = BOREQ_T; }
#line 5775 "cfg.tab.c"
    break;

  case 397: /* assignop: BXOREQ  */
#line 2011 "cfg.y"
                 { (yyval.intval) = BXOREQ_T; }
#line 5781 "cfg.tab.c"
    break;

  case 398: /* assignexp: snumber  */
#line 2015 "cfg.y"
                { (yyval.expr) = mk_elem(VALUE_OP, NUMBERV_O, (void*)(yyvsp[0].intval), 0, 0); }
#line 5787 "cfg.tab.c"
    break;

  case 399: /* assignexp: STRING  */
#line 2016 "cfg.y"
                 { (yyval.expr) = mk_elem(VALUE_OP, STRINGV_O, (yyvsp[0].strval), 0, 0); }
#line 5793 "cfg.tab.c"
    break;

  case 400: /* assignexp: script_var  */
#line 2017 "cfg.y"
                     { (yyval.expr) = mk_elem(VALUE_OP, SCRIPTVAR_O, (yyvsp[0].specval), 0, 0); }
#line 5799 "cfg.tab.c"
    break;

  case 401: /* assignexp: exp_cond  */
#line 2018 "cfg.y"
                   { (yyval.expr)= (yyvsp[0].expr); }
#line 5805 "cfg.tab.c"
    break;

  case 402: /* assignexp: cmd  */
#line 2019 "cfg.y"
              { (yyval.expr)=mk_elem( NO_OP, ACTION_O, 0, ACTIONS_ST, (yyvsp[0].action) ); }
#line 5811 "cfg.tab.c"
    break;

  case 403: /* assignexp: assignexp PLUS assignexp  */
#line 2020 "cfg.y"
                                   {
				(yyval.expr) = mk_elem(PLUS_OP, EXPR_O, (yyvsp[-2].expr), EXPR_ST, (yyvsp[0].expr));
			}
#line 5819 "cfg.tab.c"
    break;

  case 404: /* assignexp: assignexp MINUS assignexp  */
#line 2023 "cfg.y"
                                    {
				(yyval.expr) = mk_elem(MINUS_OP, EXPR_O, (yyvsp[-2].expr), EXPR_ST, (yyvsp[0].expr));
			}
#line 5827 "cfg.tab.c"
    break;

  case 405: /* assignexp: assignexp MULT assignexp  */
#line 2026 "cfg.y"
                                   {
				(yyval.expr) = mk_elem(MULT_OP, EXPR_O, (yyvsp[-2].expr), EXPR_ST, (yyvsp[0].expr));
			}
#line 5835 "cfg.tab.c"
    break;

  case 406: /* assignexp: assignexp SLASH assignexp  */
#line 2029 "cfg.y"
                                    {
				(yyval.expr) = mk_elem(DIV_OP, EXPR_O, (yyvsp[-2].expr), EXPR_ST, (yyvsp[0].expr));
			}
#line 5843 "cfg.tab.c"
    break;

  case 407: /* assignexp: assignexp MODULO assignexp  */
#line 2032 "cfg.y"
                                     {
				(yyval.expr) = mk_elem(MODULO_OP, EXPR_O, (yyvsp[-2].expr), EXPR_ST, (yyvsp[0].expr));
			}
#line 5851 "cfg.tab.c"
    break;

  case 408: /* assignexp: assignexp BAND assignexp  */
#line 2035 "cfg.y"
                                   {
				(yyval.expr) = mk_elem(BAND_OP, EXPR_O, (yyvsp[-2].expr), EXPR_ST, (yyvsp[0].expr));
			}
#line 5859 "cfg.tab.c"
    break;

  case 409: /* assignexp: assignexp BOR assignexp  */
#line 2038 "cfg.y"
                                  {
				(yyval.expr) = mk_elem(BOR_OP, EXPR_O, (yyvsp[-2].expr), EXPR_ST, (yyvsp[0].expr));
			}
#line 5867 "cfg.tab.c"
    break;

  case 410: /* assignexp: assignexp BXOR assignexp  */
#line 2041 "cfg.y"
                                   {
				(yyval.expr) = mk_elem(BXOR_OP, EXPR_O, (yyvsp[-2].expr), EXPR_ST, (yyvsp[0].expr));
			}
#line 5875 "cfg.tab.c"
    break;

  case 411: /* assignexp: assignexp BLSHIFT assignexp  */
#line 2044 "cfg.y"
                                      {
				(yyval.expr) = mk_elem(BLSHIFT_OP, EXPR_O, (yyvsp[-2].expr), EXPR_ST, (yyvsp[0].expr));
			}
#line 5883 "cfg.tab.c"
    break;

  case 412: /* assignexp: assignexp BRSHIFT assignexp  */
#line 2047 "cfg.y"
                                      {
				(yyval.expr) = mk_elem(BRSHIFT_OP, EXPR_O, (yyvsp[-2].expr), EXPR_ST, (yyvsp[0].expr));
			}
#line 5891 "cfg.tab.c"
    break;

  case 413: /* assignexp: BNOT assignexp  */
#line 2050 "cfg.y"
                         {
				(yyval.expr) = mk_elem(BNOT_OP, EXPR_O, (yyvsp[0].expr), 0, 0);
			}
#line 5899 "cfg.tab.c"
    break;

  case 414: /* assignexp: LPAREN assignexp RPAREN  */
#line 2053 "cfg.y"
                                  { (yyval.expr) = (yyvsp[-1].expr); }
#line 5905 "cfg.tab.c"
    break;

  case 415: /* assign_cmd: script_var assignop assignexp  */
#line 2056 "cfg.y"
                                          {
			if(!pv_is_w((yyvsp[-2].specval)))
				yyerror("invalid left operand in assignment");
			if((yyvsp[-2].specval)->trans!=0)
				yyerror("transformations not accepted in left side "
					"of assignment");

			mk_action2( (yyval.action), (yyvsp[-1].intval),
					SCRIPTVAR_ST,
					EXPR_ST,
					(yyvsp[-2].specval),
					(yyvsp[0].expr));
		}
#line 5923 "cfg.tab.c"
    break;

  case 416: /* assign_cmd: script_var EQUAL NULLV  */
#line 2069 "cfg.y"
                                  {
			if(!pv_is_w((yyvsp[-2].specval)))
				yyerror("invalid left operand in assignment");
			if((yyvsp[-2].specval)->trans!=0)
				yyerror("transformations not accepted in left side "
					"of assignment");

			mk_action2( (yyval.action), EQ_T,
					SCRIPTVAR_ST,
					NULLV_ST,
					(yyvsp[-2].specval),
					0);
		}
#line 5941 "cfg.tab.c"
    break;

  case 417: /* assign_cmd: script_var COLONEQ NULLV  */
#line 2082 "cfg.y"
                                    {
			if(!pv_is_w((yyvsp[-2].specval)))
				yyerror("invalid left operand in assignment");
			if((yyvsp[-2].specval)->trans!=0)
				yyerror("transformations not accepted in left side "
					"of assignment");

			mk_action2( (yyval.action), COLONEQ_T,
					SCRIPTVAR_ST,
					NULLV_ST,
					(yyvsp[-2].specval),
					0);
		}
#line 5959 "cfg.tab.c"
    break;

  case 418: /* exp_stm: cmd  */
#line 2097 "cfg.y"
                                                                { (yyval.action)=(yyvsp[0].action); }
#line 5965 "cfg.tab.c"
    break;

  case 419: /* exp_stm: if_cmd  */
#line 2098 "cfg.y"
                                                                { (yyval.action)=(yyvsp[0].action); }
#line 5971 "cfg.tab.c"
    break;

  case 420: /* exp_stm: assign_cmd  */
#line 2099 "cfg.y"
                                                                { (yyval.action)=(yyvsp[0].action); }
#line 5977 "cfg.tab.c"
    break;

  case 421: /* exp_stm: LBRACE actions RBRACE  */
#line 2100 "cfg.y"
                                                { (yyval.action)=(yyvsp[-1].action); }
#line 5983 "cfg.tab.c"
    break;

  case 422: /* exp_stm: LBRACE RBRACE  */
#line 2101 "cfg.y"
                                                        { (yyval.action)=0; }
#line 5989 "cfg.tab.c"
    break;

  case 423: /* brk_stm: brk_action  */
#line 2104 "cfg.y"
                                                                { (yyval.action)=(yyvsp[0].action); }
#line 5995 "cfg.tab.c"
    break;

  case 424: /* brk_stm: LBRACE brk_actions RBRACE  */
#line 2105 "cfg.y"
                                                        { (yyval.action)=(yyvsp[-1].action); }
#line 6001 "cfg.tab.c"
    break;

  case 425: /* brk_stm: LBRACE RBRACE  */
#line 2106 "cfg.y"
                                                        { (yyval.action)=0; }
#line 6007 "cfg.tab.c"
    break;

  case 426: /* stm: action  */
#line 2109 "cfg.y"
                                                        { (yyval.action)=(yyvsp[0].action); }
#line 6013 "cfg.tab.c"
    break;

  case 427: /* stm: LBRACE actions RBRACE  */
#line 2110 "cfg.y"
                                                { (yyval.action)=(yyvsp[-1].action); }
#line 6019 "cfg.tab.c"
    break;

  case 428: /* stm: LBRACE RBRACE  */
#line 2111 "cfg.y"
                                                        { (yyval.action)=0; }
#line 6025 "cfg.tab.c"
    break;

  case 429: /* actions: actions action  */
#line 2114 "cfg.y"
                                {(yyval.action)=append_action((yyvsp[-1].action), (yyvsp[0].action)); }
#line 6031 "cfg.tab.c"
    break;

  case 430: /* actions: action  */
#line 2115 "cfg.y"
                                                {(yyval.action)=(yyvsp[0].action);}
#line 6037 "cfg.tab.c"
    break;

  case 431: /* actions: actions error  */
#line 2116 "cfg.y"
                                { (yyval.action)=0; yyerror("bad command!)"); }
#line 6043 "cfg.tab.c"
    break;

  case 432: /* brk_actions: brk_actions brk_action  */
#line 2120 "cfg.y"
                                        {(yyval.action)=append_action((yyvsp[-1].action), (yyvsp[0].action)); }
#line 6049 "cfg.tab.c"
    break;

  case 433: /* brk_actions: brk_action  */
#line 2121 "cfg.y"
                                                {(yyval.action)=(yyvsp[0].action);}
#line 6055 "cfg.tab.c"
    break;

  case 434: /* brk_actions: brk_actions error  */
#line 2122 "cfg.y"
                                    { (yyval.action)=0; yyerror("bad command!)"); }
#line 6061 "cfg.tab.c"
    break;

  case 435: /* action: cmd SEMICOLON  */
#line 2125 "cfg.y"
                              {(yyval.action)=(yyvsp[-1].action);}
#line 6067 "cfg.tab.c"
    break;

  case 436: /* action: if_cmd  */
#line 2126 "cfg.y"
                         {(yyval.action)=(yyvsp[0].action);}
#line 6073 "cfg.tab.c"
    break;

  case 437: /* action: while_cmd  */
#line 2127 "cfg.y"
                            {(yyval.action)=(yyvsp[0].action);}
#line 6079 "cfg.tab.c"
    break;

  case 438: /* action: foreach_cmd  */
#line 2128 "cfg.y"
                              {(yyval.action)=(yyvsp[0].action);}
#line 6085 "cfg.tab.c"
    break;

  case 439: /* action: switch_cmd  */
#line 2129 "cfg.y"
                             {(yyval.action)=(yyvsp[0].action);}
#line 6091 "cfg.tab.c"
    break;

  case 440: /* action: assign_cmd SEMICOLON  */
#line 2130 "cfg.y"
                                       {(yyval.action)=(yyvsp[-1].action);}
#line 6097 "cfg.tab.c"
    break;

  case 441: /* action: SEMICOLON  */
#line 2131 "cfg.y"
                                              {(yyval.action)=0;}
#line 6103 "cfg.tab.c"
    break;

  case 442: /* action: cmd error  */
#line 2132 "cfg.y"
                            { (yyval.action)=0; yyerror("bad command: missing ';'?"); }
#line 6109 "cfg.tab.c"
    break;

  case 443: /* brk_action: BREAK SEMICOLON  */
#line 2135 "cfg.y"
                            { mk_action0((yyval.action), BREAK_T);}
#line 6115 "cfg.tab.c"
    break;

  case 444: /* brk_action: cmd SEMICOLON  */
#line 2136 "cfg.y"
                                {(yyval.action)=(yyvsp[-1].action);}
#line 6121 "cfg.tab.c"
    break;

  case 445: /* brk_action: brk_if_cmd  */
#line 2137 "cfg.y"
                             {(yyval.action)=(yyvsp[0].action);}
#line 6127 "cfg.tab.c"
    break;

  case 446: /* brk_action: while_cmd  */
#line 2138 "cfg.y"
                            {(yyval.action)=(yyvsp[0].action);}
#line 6133 "cfg.tab.c"
    break;

  case 447: /* brk_action: foreach_cmd  */
#line 2139 "cfg.y"
                              {(yyval.action)=(yyvsp[0].action);}
#line 6139 "cfg.tab.c"
    break;

  case 448: /* brk_action: switch_cmd  */
#line 2140 "cfg.y"
                             {(yyval.action)=(yyvsp[0].action);}
#line 6145 "cfg.tab.c"
    break;

  case 449: /* brk_action: assign_cmd SEMICOLON  */
#line 2141 "cfg.y"
                                       {(yyval.action)=(yyvsp[-1].action);}
#line 6151 "cfg.tab.c"
    break;

  case 450: /* brk_action: SEMICOLON  */
#line 2142 "cfg.y"
                                              {(yyval.action)=0;}
#line 6157 "cfg.tab.c"
    break;

  case 451: /* brk_action: cmd error  */
#line 2143 "cfg.y"
                            { (yyval.action)=0; yyerror("bad command: missing ';'?"); }
#line 6163 "cfg.tab.c"
    break;

  case 452: /* brk_if_cmd: IF LPAREN exp RPAREN brk_stm  */
#line 2146 "cfg.y"
                                                                { mk_action3( (yyval.action), IF_T,
													 EXPR_ST,
													 ACTIONS_ST,
													 NOSUBTYPE,
													 (yyvsp[-2].expr),
													 (yyvsp[0].action),
													 0);
									}
#line 6176 "cfg.tab.c"
    break;

  case 453: /* brk_if_cmd: IF LPAREN exp RPAREN brk_stm ELSE brk_stm  */
#line 2154 "cfg.y"
                                                                        { mk_action3( (yyval.action), IF_T,
													 EXPR_ST,
													 ACTIONS_ST,
													 ACTIONS_ST,
													 (yyvsp[-4].expr),
													 (yyvsp[-2].action),
													 (yyvsp[0].action));
									}
#line 6189 "cfg.tab.c"
    break;

  case 454: /* if_cmd: IF LPAREN exp RPAREN stm  */
#line 2164 "cfg.y"
                                                                        { mk_action3( (yyval.action), IF_T,
													 EXPR_ST,
													 ACTIONS_ST,
													 NOSUBTYPE,
													 (yyvsp[-2].expr),
													 (yyvsp[0].action),
													 0);
									}
#line 6202 "cfg.tab.c"
    break;

  case 455: /* if_cmd: IF LPAREN exp RPAREN stm ELSE stm  */
#line 2172 "cfg.y"
                                                                { mk_action3( (yyval.action), IF_T,
													 EXPR_ST,
													 ACTIONS_ST,
													 ACTIONS_ST,
													 (yyvsp[-4].expr),
													 (yyvsp[-2].action),
													 (yyvsp[0].action));
									}
#line 6215 "cfg.tab.c"
    break;

  case 456: /* while_cmd: WHILE LPAREN exp RPAREN brk_stm  */
#line 2182 "cfg.y"
                                                        { mk_action2( (yyval.action), WHILE_T,
													 EXPR_ST,
													 ACTIONS_ST,
													 (yyvsp[-2].expr),
													 (yyvsp[0].action));
									}
#line 6226 "cfg.tab.c"
    break;

  case 457: /* foreach_cmd: FOR LPAREN script_var IN script_var RPAREN brk_stm  */
#line 2190 "cfg.y"
                                                                   {
					if ((yyvsp[-4].specval)->type != PVT_SCRIPTVAR &&
					    (yyvsp[-4].specval)->type != PVT_AVP &&
						pv_type((yyvsp[-4].specval)->type) != PVT_JSON) {
						yyerror("\nfor-each statement: only \"var\", \"avp\" "
					            "and \"json\" iterators are supported!");
					}

					mk_action3( (yyval.action), FOR_EACH_T,
					            SCRIPTVAR_ST,
					            SCRIPTVAR_ST,
					            ACTIONS_ST,
					            (yyvsp[-4].specval),
					            (yyvsp[-2].specval),
					            (yyvsp[0].action));
					}
#line 6247 "cfg.tab.c"
    break;

  case 458: /* switch_cmd: SWITCH LPAREN script_var RPAREN LBRACE switch_stm RBRACE  */
#line 2208 "cfg.y"
                                                                                        {
											mk_action2( (yyval.action), SWITCH_T,
														SCRIPTVAR_ST,
														ACTIONS_ST,
														(yyvsp[-4].specval),
														(yyvsp[-1].action));
									}
#line 6259 "cfg.tab.c"
    break;

  case 459: /* switch_stm: case_stms default_stm  */
#line 2217 "cfg.y"
                                  { (yyval.action)=append_action((yyvsp[-1].action), (yyvsp[0].action)); }
#line 6265 "cfg.tab.c"
    break;

  case 460: /* switch_stm: case_stms  */
#line 2218 "cfg.y"
                                                { (yyval.action)=(yyvsp[0].action); }
#line 6271 "cfg.tab.c"
    break;

  case 461: /* case_stms: case_stms case_stm  */
#line 2220 "cfg.y"
                                        {(yyval.action)=append_action((yyvsp[-1].action), (yyvsp[0].action)); }
#line 6277 "cfg.tab.c"
    break;

  case 462: /* case_stms: case_stm  */
#line 2221 "cfg.y"
                                                {(yyval.action)=(yyvsp[0].action);}
#line 6283 "cfg.tab.c"
    break;

  case 463: /* case_stm: CASE snumber COLON brk_actions  */
#line 2224 "cfg.y"
                                         { mk_action2( (yyval.action), CASE_T,
													NUMBER_ST,
													ACTIONS_ST,
													(void*)(yyvsp[-2].intval),
													(yyvsp[0].action));
											}
#line 6294 "cfg.tab.c"
    break;

  case 464: /* case_stm: CASE snumber COLON  */
#line 2230 "cfg.y"
                                     { mk_action2( (yyval.action), CASE_T,
													NUMBER_ST,
													ACTIONS_ST,
													(void*)(yyvsp[-1].intval),
													NULL);
							}
#line 6305 "cfg.tab.c"
    break;

  case 465: /* case_stm: CASE STRING COLON brk_actions  */
#line 2236 "cfg.y"
                                                { mk_action2( (yyval.action), CASE_T,
													STR_ST,
													ACTIONS_ST,
													(void*)(yyvsp[-2].strval),
													(yyvsp[0].action));
											}
#line 6316 "cfg.tab.c"
    break;

  case 466: /* case_stm: CASE STRING COLON  */
#line 2242 "cfg.y"
                                    { mk_action2( (yyval.action), CASE_T,
													STR_ST,
													ACTIONS_ST,
													(void*)(yyvsp[-1].strval),
													NULL);
							}
#line 6327 "cfg.tab.c"
    break;

  case 467: /* default_stm: DEFAULT COLON brk_actions  */
#line 2250 "cfg.y"
                                       { mk_action1( (yyval.action), DEFAULT_T,
													ACTIONS_ST, (yyvsp[0].action));
									}
#line 6335 "cfg.tab.c"
    break;

  case 468: /* default_stm: DEFAULT COLON  */
#line 2253 "cfg.y"
                                { mk_action1( (yyval.action), DEFAULT_T, ACTIONS_ST, NULL); }
#line 6341 "cfg.tab.c"
    break;

  case 469: /* func_param: STRING  */
#line 2256 "cfg.y"
                   {
										elems[1].type = STR_ST;
										elems[1].u.data = (yyvsp[0].strval);
										(yyval.intval)=1;
										}
#line 6351 "cfg.tab.c"
    break;

  case 470: /* func_param: func_param COMMA STRING  */
#line 2261 "cfg.y"
                                          {
										if ((yyvsp[-2].intval)+1>=MAX_ACTION_ELEMS) {
											yyerror("too many arguments "
												"in function\n");
											(yyval.intval)=0;
										}
										elems[(yyvsp[-2].intval)+1].type = STR_ST;
										elems[(yyvsp[-2].intval)+1].u.data = (yyvsp[0].strval);
										(yyval.intval)=(yyvsp[-2].intval)+1;
										}
#line 6366 "cfg.tab.c"
    break;

  case 471: /* func_param: COMMA  */
#line 2271 "cfg.y"
                        {
										elems[1].type = NULLV_ST;
										elems[1].u.data = NULL;
										elems[2].type = NULLV_ST;
										elems[2].u.data = NULL;
										(yyval.intval)=2;
										}
#line 6378 "cfg.tab.c"
    break;

  case 472: /* func_param: COMMA STRING  */
#line 2278 "cfg.y"
                               {
										elems[1].type = NULLV_ST;
										elems[1].u.data = NULL;
										elems[2].type = STR_ST;
										elems[2].u.data = (yyvsp[0].strval);
										(yyval.intval)=2;
										}
#line 6390 "cfg.tab.c"
    break;

  case 473: /* func_param: func_param COMMA  */
#line 2285 "cfg.y"
                                   {
										if ((yyvsp[-1].intval)+1>=MAX_ACTION_ELEMS) {
											yyerror("too many arguments "
												"in function\n");
											(yyval.intval)=0;
										}
										elems[(yyvsp[-1].intval)+1].type = NULLV_ST;
										elems[(yyvsp[-1].intval)+1].u.data = NULL;
										(yyval.intval)=(yyvsp[-1].intval)+1;
										}
#line 6405 "cfg.tab.c"
    break;

  case 474: /* func_param: snumber  */
#line 2295 "cfg.y"
                          {
										elems[1].type = NUMBER_ST;
										elems[1].u.number = (yyvsp[0].intval);
										(yyval.intval)=1;
										}
#line 6415 "cfg.tab.c"
    break;

  case 475: /* func_param: COMMA snumber  */
#line 2300 "cfg.y"
                                {
										elems[1].type = NULLV_ST;
										elems[1].u.data = NULL;
										elems[2].type = NUMBER_ST;
										elems[2].u.number = (yyvsp[0].intval);
										(yyval.intval)=2;
										}
#line 6427 "cfg.tab.c"
    break;

  case 476: /* func_param: func_param COMMA snumber  */
#line 2307 "cfg.y"
                                           {
										if ((yyvsp[-2].intval)+1>=MAX_ACTION_ELEMS) {
											yyerror("too many arguments "
												"in function\n");
											(yyval.intval)=0;
										}
										elems[(yyvsp[-2].intval)+1].type = NUMBER_ST;
										elems[(yyvsp[-2].intval)+1].u.number = (yyvsp[0].intval);
										(yyval.intval)=(yyvsp[-2].intval)+1;
										}
#line 6442 "cfg.tab.c"
    break;

  case 477: /* func_param: script_var  */
#line 2317 "cfg.y"
                             {
										elems[1].type = SCRIPTVAR_ST;
										elems[1].u.data = (yyvsp[0].specval);
										(yyval.intval)=1;
										}
#line 6452 "cfg.tab.c"
    break;

  case 478: /* func_param: COMMA script_var  */
#line 2322 "cfg.y"
                                   {
										elems[1].type = NULLV_ST;
										elems[1].u.data = NULL;
										elems[2].type = SCRIPTVAR_ST;
										elems[2].u.data = (yyvsp[0].specval);
										(yyval.intval)=2;
										}
#line 6464 "cfg.tab.c"
    break;

  case 479: /* func_param: func_param COMMA script_var  */
#line 2329 "cfg.y"
                                              {
										if ((yyvsp[-2].intval)+1>=MAX_ACTION_ELEMS) {
											yyerror("too many arguments "
												"in function\n");
											(yyval.intval)=0;
										}
										elems[(yyvsp[-2].intval)+1].type = SCRIPTVAR_ST;
										elems[(yyvsp[-2].intval)+1].u.data = (yyvsp[0].specval);
										(yyval.intval)=(yyvsp[-2].intval)+1;
										}
#line 6479 "cfg.tab.c"
    break;

  case 480: /* route_param: STRING  */
#line 2341 "cfg.y"
                    {
						route_elems[0].type = STRING_ST;
						route_elems[0].u.string = (yyvsp[0].strval);
						(yyval.intval)=1;
			}
#line 6489 "cfg.tab.c"
    break;

  case 481: /* route_param: snumber  */
#line 2346 "cfg.y"
                          {
						route_elems[0].type = NUMBER_ST;
						route_elems[0].u.number = (long)(yyvsp[0].intval);
						(yyval.intval)=1;
			}
#line 6499 "cfg.tab.c"
    break;

  case 482: /* route_param: NULLV  */
#line 2351 "cfg.y"
                        {
						route_elems[0].type = NULLV_ST;
						route_elems[0].u.data = 0;
						(yyval.intval)=1;
			}
#line 6509 "cfg.tab.c"
    break;

  case 483: /* route_param: script_var  */
#line 2356 "cfg.y"
                             {
						route_elems[0].type = SCRIPTVAR_ST;
						route_elems[0].u.data = (yyvsp[0].specval);
						(yyval.intval)=1;
			}
#line 6519 "cfg.tab.c"
    break;

  case 484: /* route_param: route_param COMMA STRING  */
#line 2361 "cfg.y"
                                           {
						if ((yyvsp[-2].intval)>=MAX_ACTION_ELEMS) {
							yyerror("too many arguments in function\n");
							(yyval.intval)=-1;
						} else {
							route_elems[(yyvsp[-2].intval)].type = STRING_ST;
							route_elems[(yyvsp[-2].intval)].u.data = (yyvsp[0].strval);
							(yyval.intval)=(yyvsp[-2].intval)+1;
						}
			}
#line 6534 "cfg.tab.c"
    break;

  case 485: /* route_param: route_param COMMA snumber  */
#line 2371 "cfg.y"
                                            {
						if ((yyvsp[-2].intval)>=MAX_ACTION_ELEMS) {
							yyerror("too many arguments in function\n");
							(yyval.intval)=-1;
						} else {
							route_elems[(yyvsp[-2].intval)].type = NUMBER_ST;
							route_elems[(yyvsp[-2].intval)].u.data = (void*)(long)(yyvsp[0].intval);
							(yyval.intval)=(yyvsp[-2].intval)+1;
						}
			}
#line 6549 "cfg.tab.c"
    break;

  case 486: /* route_param: route_param COMMA script_var  */
#line 2381 "cfg.y"
                                               {
						if ((yyvsp[-2].intval)+1>=MAX_ACTION_ELEMS) {
							yyerror("too many arguments in function\n");
							(yyval.intval)=-1;
						} else {
							route_elems[(yyvsp[-2].intval)].type = SCRIPTVAR_ST;
							route_elems[(yyvsp[-2].intval)].u.data = (yyvsp[0].specval);
							(yyval.intval)=(yyvsp[-2].intval)+1;
						}
			}
#line 6564 "cfg.tab.c"
    break;

  case 487: /* route_param: route_param COMMA NULLV  */
#line 2391 "cfg.y"
                                          {
						if ((yyvsp[-2].intval)+1>=MAX_ACTION_ELEMS) {
							yyerror("too many arguments in function\n");
							(yyval.intval)=-1;
						} else {
							route_elems[(yyvsp[-2].intval)].type = NULLV_ST;
							route_elems[(yyvsp[-2].intval)].u.data = 0;
							(yyval.intval)=(yyvsp[-2].intval)+1;
						}
			}
#line 6579 "cfg.tab.c"
    break;

  case 488: /* async_func: ID LPAREN RPAREN  */
#line 2403 "cfg.y"
                             {
				const acmd_export_t* acmd_tmp=find_mod_acmd_export_t((yyvsp[-2].strval));
				if (acmd_tmp==0){
					yyerrorf("unknown async command <%s>, "
						"missing loadmodule?", (yyvsp[-2].strval));
					(yyval.action)=0;
				}else{
					if (check_acmd_call_params(acmd_tmp,elems,0)<0) {
						yyerrorf("too few parameters "
							"for command <%s>\n", (yyvsp[-2].strval));
						(yyval.action)=0;
					} else {
						elems[0].type = ACMD_ST;
						elems[0].u.data_const = acmd_tmp;
						mk_action_((yyval.action), AMODULE_T, 1, elems);
					}
				}
			}
#line 6602 "cfg.tab.c"
    break;

  case 489: /* async_func: ID LPAREN func_param RPAREN  */
#line 2421 "cfg.y"
                                                      {
				const acmd_export_t* acmd_tmp=find_mod_acmd_export_t((yyvsp[-3].strval));
				if (acmd_tmp==0){
					yyerrorf("unknown async command <%s>, "
						"missing loadmodule?", (yyvsp[-3].strval));
					(yyval.action)=0;
				}else{
					rc = check_acmd_call_params(acmd_tmp,elems,(yyvsp[-1].intval));
					switch (rc) {
					case -1:
						yyerrorf("too few parameters "
							"for async command <%s>\n", (yyvsp[-3].strval));
						(yyval.action)=0;
						break;
					case -2:
						yyerrorf("too many parameters "
							"for async command <%s>\n", (yyvsp[-3].strval));
						(yyval.action)=0;
						break;
					case -3:
						yyerrorf("mandatory parameter "
							" omitted for async command <%s>\n", (yyvsp[-3].strval));
						(yyval.action)=0;
						break;
					default:
						elems[0].type = ACMD_ST;
						elems[0].u.data_const = acmd_tmp;
						mk_action_((yyval.action), AMODULE_T, (yyvsp[-1].intval)+1, elems);
					}
				}
			}
#line 6638 "cfg.tab.c"
    break;

  case 490: /* async_func: ID LPAREN error RPAREN  */
#line 2452 "cfg.y"
                                                 {
				(yyval.action)=0;
				yyerrorf("bad arguments for command <%s>", (yyvsp[-3].strval));
			}
#line 6647 "cfg.tab.c"
    break;

  case 491: /* async_func: ID error  */
#line 2456 "cfg.y"
                                   {
				(yyval.action)=0;
				yyerrorf("bare word <%s> found, command calls need '()'", (yyvsp[-1].strval));
			}
#line 6656 "cfg.tab.c"
    break;

  case 492: /* return_param: script_var  */
#line 2462 "cfg.y"
                         { sr_tmp.rspec = (yyvsp[0].specval); (yyval.return_params) = mk_script_return(SCRIPT_ROUTE_RET_VAR);}
#line 6662 "cfg.tab.c"
    break;

  case 493: /* return_param: snumber  */
#line 2463 "cfg.y"
                          { sr_tmp.rint = (yyvsp[0].intval); (yyval.return_params) = mk_script_return(SCRIPT_ROUTE_RET_INT);}
#line 6668 "cfg.tab.c"
    break;

  case 494: /* return_param: STRING  */
#line 2464 "cfg.y"
                         { sr_tmp.rstr.s = (yyvsp[0].strval); sr_tmp.rstr.len = strlen((yyvsp[0].strval));
					(yyval.return_params) = mk_script_return(SCRIPT_ROUTE_RET_STR);}
#line 6675 "cfg.tab.c"
    break;

  case 495: /* return_param: NULLV  */
#line 2466 "cfg.y"
                        { (yyval.return_params) = mk_script_return(SCRIPT_ROUTE_RET_NULL);}
#line 6681 "cfg.tab.c"
    break;

  case 496: /* return_params: return_param  */
#line 2469 "cfg.y"
                            { (yyval.return_params) = (yyvsp[0].return_params); }
#line 6687 "cfg.tab.c"
    break;

  case 497: /* return_params: return_params COMMA return_param  */
#line 2470 "cfg.y"
                                                   { (yyvsp[0].return_params)->next = (yyvsp[-2].return_params); (yyval.return_params) = (yyvsp[0].return_params); }
#line 6693 "cfg.tab.c"
    break;

  case 498: /* cmd: ASSERT LPAREN exp COMMA STRING RPAREN  */
#line 2473 "cfg.y"
                                                 {
			mk_action2( (yyval.action), ASSERT_T, EXPR_ST, STRING_ST, (yyvsp[-3].expr), (yyvsp[-1].strval));
			}
#line 6701 "cfg.tab.c"
    break;

  case 499: /* cmd: ASSERT LPAREN exp RPAREN  */
#line 2476 "cfg.y"
                                                 {
			mk_action2( (yyval.action), ASSERT_T, EXPR_ST, STRING_ST, (yyvsp[-1].expr), NULL);
			}
#line 6709 "cfg.tab.c"
    break;

  case 500: /* cmd: DROP  */
#line 2479 "cfg.y"
                                                 {mk_action0( (yyval.action), DROP_T); }
#line 6715 "cfg.tab.c"
    break;

  case 501: /* cmd: DROP LPAREN RPAREN  */
#line 2480 "cfg.y"
                                     {mk_action0( (yyval.action), DROP_T); }
#line 6721 "cfg.tab.c"
    break;

  case 502: /* cmd: EXIT  */
#line 2481 "cfg.y"
                                                 {mk_action0( (yyval.action), EXIT_T); }
#line 6727 "cfg.tab.c"
    break;

  case 503: /* cmd: EXIT LPAREN RPAREN  */
#line 2482 "cfg.y"
                                     {mk_action0( (yyval.action), EXIT_T); }
#line 6733 "cfg.tab.c"
    break;

  case 504: /* cmd: RETURN script_var  */
#line 2484 "cfg.y"
                                                         {mk_action2( (yyval.action), RETURN_T,
								SCRIPTVAR_ST,
								NULLV_ST,
								(void*)(yyvsp[0].specval),
								NULL); }
#line 6743 "cfg.tab.c"
    break;

  case 505: /* cmd: RETURN LPAREN script_var RPAREN  */
#line 2490 "cfg.y"
                                                         {mk_action2( (yyval.action), RETURN_T,
								SCRIPTVAR_ST,
								NULLV_ST,
								(void*)(yyvsp[-1].specval),
								NULL); }
#line 6753 "cfg.tab.c"
    break;

  case 506: /* cmd: RETURN LPAREN script_var COMMA return_params RPAREN  */
#line 2496 "cfg.y"
                                                         {mk_action2( (yyval.action), RETURN_T,
								SCRIPTVAR_ST,
								EXPR_ST,
								(void*)(yyvsp[-3].specval),
								(yyvsp[-1].return_params)); }
#line 6763 "cfg.tab.c"
    break;

  case 507: /* cmd: RETURN snumber  */
#line 2502 "cfg.y"
                                                         {mk_action2( (yyval.action), RETURN_T,
								NUMBER_ST,
								NULLV_ST,
								(void*)(yyvsp[0].intval),
								NULL); }
#line 6773 "cfg.tab.c"
    break;

  case 508: /* cmd: RETURN LPAREN snumber RPAREN  */
#line 2508 "cfg.y"
                                                         {mk_action2( (yyval.action), RETURN_T,
								NUMBER_ST,
								NULLV_ST,
								(void*)(yyvsp[-1].intval),
								NULL); }
#line 6783 "cfg.tab.c"
    break;

  case 509: /* cmd: RETURN LPAREN snumber COMMA return_params RPAREN  */
#line 2514 "cfg.y"
                                                         {mk_action2( (yyval.action), RETURN_T,
								NUMBER_ST,
								EXPR_ST,
								(void*)(yyvsp[-3].intval),
								(yyvsp[-1].return_params)); }
#line 6793 "cfg.tab.c"
    break;

  case 510: /* cmd: RETURN LPAREN RPAREN  */
#line 2520 "cfg.y"
                                                         {mk_action2( (yyval.action), RETURN_T,
								NUMBER_ST,
								NULLV_ST,
								(void*)1,
								NULL); }
#line 6803 "cfg.tab.c"
    break;

  case 511: /* cmd: RETURN LPAREN COMMA return_params RPAREN  */
#line 2526 "cfg.y"
                                                         {mk_action2( (yyval.action), RETURN_T,
								NUMBER_ST,
								EXPR_ST,
								(void*)1,
								(yyvsp[-1].return_params)); }
#line 6813 "cfg.tab.c"
    break;

  case 512: /* cmd: RETURN  */
#line 2531 "cfg.y"
                                                 {mk_action2( (yyval.action), RETURN_T,
								NUMBER_ST,
								NULLV_ST,
								(void*)1,
								NULL); }
#line 6823 "cfg.tab.c"
    break;

  case 513: /* cmd: LOG_TOK LPAREN STRING RPAREN  */
#line 2536 "cfg.y"
                                                {mk_action2( (yyval.action), LOG_T, NUMBER_ST,
													STRING_ST,(void*)4,(yyvsp[-1].strval));
									}
#line 6831 "cfg.tab.c"
    break;

  case 514: /* cmd: LOG_TOK LPAREN snumber COMMA STRING RPAREN  */
#line 2539 "cfg.y"
                                                                {mk_action2( (yyval.action), LOG_T,
																NUMBER_ST,
																STRING_ST,
																(void*)(yyvsp[-3].intval),
																(yyvsp[-1].strval));
												}
#line 6842 "cfg.tab.c"
    break;

  case 515: /* cmd: LOG_TOK error  */
#line 2545 "cfg.y"
                                { (yyval.action)=0; yyerror("missing '(' or ')' ?"); }
#line 6848 "cfg.tab.c"
    break;

  case 516: /* cmd: LOG_TOK LPAREN error RPAREN  */
#line 2546 "cfg.y"
                                              { (yyval.action)=0; yyerror("bad log"
									"argument"); }
#line 6855 "cfg.tab.c"
    break;

  case 517: /* cmd: ERROR LPAREN STRING COMMA STRING RPAREN  */
#line 2548 "cfg.y"
                                                          {mk_action2( (yyval.action), ERROR_T,
																STRING_ST,
																STRING_ST,
																(yyvsp[-3].strval),
																(yyvsp[-1].strval));
												  }
#line 6866 "cfg.tab.c"
    break;

  case 518: /* cmd: ERROR error  */
#line 2554 "cfg.y"
                              { (yyval.action)=0; yyerror("missing '(' or ')' ?"); }
#line 6872 "cfg.tab.c"
    break;

  case 519: /* cmd: ERROR LPAREN error RPAREN  */
#line 2555 "cfg.y"
                                            { (yyval.action)=0; yyerror("bad error"
														"argument"); }
#line 6879 "cfg.tab.c"
    break;

  case 520: /* cmd: ROUTE LPAREN route_name_var RPAREN  */
#line 2557 "cfg.y"
                                                        {
						mk_action2( (yyval.action), ROUTE_T, (yyvsp[-1].intval), 0, rn_tmp.data, 0);
					}
#line 6887 "cfg.tab.c"
    break;

  case 521: /* cmd: ROUTE LPAREN route_name_var COMMA route_param RPAREN  */
#line 2561 "cfg.y"
                                                                        {
						if ((yyvsp[-1].intval) <= 0) yyerror("too many route parameters");

						/* duplicate the list */
						a_tmp = pkg_malloc((yyvsp[-1].intval) * sizeof(action_elem_t));
						if (!a_tmp) {
							yyerror("no more pkg memory");
							YYABORT;
						}
						memcpy(a_tmp, route_elems, (yyvsp[-1].intval)*sizeof(action_elem_t));

						mk_action3( (yyval.action), ROUTE_T, (yyvsp[-3].intval),	/* route idx */
							NUMBER_ST,					/* number of params */
							SCRIPTVAR_ST,				/* parameters */
							rn_tmp.data,
							(void*)(long)(yyvsp[-1].intval),
							(void*)a_tmp);
					}
#line 6910 "cfg.tab.c"
    break;

  case 522: /* cmd: ROUTE error  */
#line 2580 "cfg.y"
                              { (yyval.action)=0; yyerror("missing '(' or ')' ?"); }
#line 6916 "cfg.tab.c"
    break;

  case 523: /* cmd: ROUTE LPAREN error RPAREN  */
#line 2581 "cfg.y"
                                            { (yyval.action)=0; yyerror("bad route"
						"argument"); }
#line 6923 "cfg.tab.c"
    break;

  case 524: /* cmd: ID LPAREN RPAREN  */
#line 2583 "cfg.y"
                                        {
								const cmd_export_t* cmd_tmp=find_cmd_export_t((yyvsp[-2].strval), rt);
								if (cmd_tmp==0){
									if (find_cmd_export_t((yyvsp[-2].strval), 0)) {
										yyerrorf("Command <%s> cannot be "
											"used in the block\n", (yyvsp[-2].strval));
									} else {
										yyerrorf("unknown command <%s>, "
											"missing loadmodule?", (yyvsp[-2].strval));
									}
									(yyval.action)=0;
								}else{
									if (check_cmd_call_params(cmd_tmp,elems,0)<0) {
										yyerrorf("too few parameters "
											"for command <%s>\n", (yyvsp[-2].strval));
										(yyval.action)=0;
									} else {
										elems[0].type = CMD_ST;
										elems[0].u.data_const = cmd_tmp;
										mk_action_((yyval.action), CMD_T, 1, elems);
									}
								}
							}
#line 6951 "cfg.tab.c"
    break;

  case 525: /* cmd: ID LPAREN func_param RPAREN  */
#line 2606 "cfg.y"
                                                {
								const cmd_export_t* cmd_tmp=find_cmd_export_t((yyvsp[-3].strval), rt);
								if (cmd_tmp==0){
									if (find_cmd_export_t((yyvsp[-3].strval), 0)) {
										yyerrorf("Command <%s> cannot be "
											"used in the block\n", (yyvsp[-3].strval));
									} else {
										yyerrorf("unknown command <%s>, "
											"missing loadmodule?", (yyvsp[-3].strval));
									}
									(yyval.action)=0;
								}else{
									rc = check_cmd_call_params(cmd_tmp,elems,(yyvsp[-1].intval));
									switch (rc) {
									case -1:
										yyerrorf("too few parameters "
											"for command <%s>\n", (yyvsp[-3].strval));
										(yyval.action)=0;
										break;
									case -2:
										yyerrorf("too many parameters "
											"for command <%s>\n", (yyvsp[-3].strval));
										(yyval.action)=0;
										break;
									case -3:
										yyerrorf("mandatory parameter "
											"omitted for command <%s>\n", (yyvsp[-3].strval));
										(yyval.action)=0;
										break;
									default:
										elems[0].type = CMD_ST;
										elems[0].u.data_const = cmd_tmp;
										mk_action_((yyval.action), CMD_T, (yyvsp[-1].intval)+1, elems);
									}
								}
							}
#line 6992 "cfg.tab.c"
    break;

  case 526: /* cmd: ID LPAREN error RPAREN  */
#line 2642 "cfg.y"
                                         { (yyval.action)=0; yyerrorf("bad arguments for "
												"command <%s>", (yyvsp[-3].strval)); }
#line 6999 "cfg.tab.c"
    break;

  case 527: /* cmd: ID error  */
#line 2644 "cfg.y"
                           { (yyval.action)=0;
			yyerrorf("bare word <%s> found, command calls need '()'", (yyvsp[-1].strval));
			}
#line 7007 "cfg.tab.c"
    break;

  case 528: /* cmd: XDBG LPAREN STRING RPAREN  */
#line 2647 "cfg.y"
                                            {
				mk_action1((yyval.action), XDBG_T, STR_ST, (yyvsp[-1].strval));	}
#line 7014 "cfg.tab.c"
    break;

  case 529: /* cmd: XDBG LPAREN folded_string RPAREN  */
#line 2649 "cfg.y"
                                                   {
				mk_action1((yyval.action), XDBG_T, STR_ST, (yyvsp[-1].strval));	}
#line 7021 "cfg.tab.c"
    break;

  case 530: /* cmd: XLOG LPAREN STRING RPAREN  */
#line 2651 "cfg.y"
                                            {
				mk_action1((yyval.action), XLOG_T, STR_ST, (yyvsp[-1].strval)); }
#line 7028 "cfg.tab.c"
    break;

  case 531: /* cmd: XLOG LPAREN folded_string RPAREN  */
#line 2653 "cfg.y"
                                                   {
				mk_action1((yyval.action), XLOG_T, STR_ST, (yyvsp[-1].strval)); }
#line 7035 "cfg.tab.c"
    break;

  case 532: /* cmd: XLOG LPAREN STRING COMMA STRING RPAREN  */
#line 2655 "cfg.y"
                                                         {
				mk_action2((yyval.action), XLOG_T, STR_ST, STR_ST, (yyvsp[-3].strval), (yyvsp[-1].strval)); }
#line 7042 "cfg.tab.c"
    break;

  case 533: /* cmd: XLOG LPAREN STRING COMMA folded_string RPAREN  */
#line 2657 "cfg.y"
                                                                {
				mk_action2((yyval.action), XLOG_T, STR_ST, STR_ST, (yyvsp[-3].strval), (yyvsp[-1].strval)); }
#line 7049 "cfg.tab.c"
    break;

  case 534: /* cmd: ASYNC_TOKEN LPAREN async_func COMMA route_name RPAREN  */
#line 2659 "cfg.y"
                                                                        {
				rt_ref = ref_script_route_by_name( (yyvsp[-1].strval), sroutes->request,
					RT_NO, REQUEST_ROUTE, 0);
				if (rt_ref==NULL) yyerror("fail to create route reference");
				mk_action2((yyval.action), ASYNC_T, ACTIONS_ST, ROUTE_REF_ST,
						(yyvsp[-3].action), (void*)rt_ref);
				}
#line 7061 "cfg.tab.c"
    break;

  case 535: /* cmd: ASYNC_TOKEN LPAREN async_func COMMA route_name COMMA NUMBER RPAREN  */
#line 2666 "cfg.y"
                                                                                     {
				rt_ref = ref_script_route_by_name( (yyvsp[-3].strval), sroutes->request,
					RT_NO, REQUEST_ROUTE, 0);
				if (rt_ref==NULL) yyerror("fail to create route reference");
				mk_action3((yyval.action), ASYNC_T, ACTIONS_ST, ROUTE_REF_ST, NUMBER_ST,
						(yyvsp[-5].action), (void*)rt_ref, (void*)(long)(yyvsp[-1].intval));
				}
#line 7073 "cfg.tab.c"
    break;

  case 536: /* cmd: LAUNCH_TOKEN LPAREN async_func COMMA route_name COMMA STRING RPAREN  */
#line 2673 "cfg.y"
                                                                                      {
				rt_ref = ref_script_route_by_name( (yyvsp[-3].strval), sroutes->request,
					RT_NO, REQUEST_ROUTE, 0);
				if (rt_ref==NULL) yyerror("fail to create route reference");
				mk_action3((yyval.action), LAUNCH_T, ACTIONS_ST, ROUTE_REF_ST, STRING_ST,
						(yyvsp[-5].action), (void*)rt_ref, (yyvsp[-1].strval));
				}
#line 7085 "cfg.tab.c"
    break;

  case 537: /* cmd: LAUNCH_TOKEN LPAREN async_func COMMA route_name RPAREN  */
#line 2680 "cfg.y"
                                                                         {
				rt_ref = ref_script_route_by_name( (yyvsp[-1].strval), sroutes->request,
					RT_NO, REQUEST_ROUTE, 0);
				if (rt_ref==NULL) yyerror("fail to create route reference");
				mk_action2((yyval.action), LAUNCH_T, ACTIONS_ST, ROUTE_REF_ST,
						(yyvsp[-3].action), (void*)rt_ref);
				}
#line 7097 "cfg.tab.c"
    break;

  case 538: /* cmd: LAUNCH_TOKEN LPAREN async_func RPAREN  */
#line 2687 "cfg.y"
                                                        {
				mk_action2((yyval.action), LAUNCH_T, ACTIONS_ST, ROUTE_REF_ST,
						(yyvsp[-1].action), (void*)NULL);
				}
#line 7106 "cfg.tab.c"
    break;


#line 7110 "cfg.tab.c"

      default: break;
    }
  /* User semantic actions sometimes alter yychar, and that requires
     that yytoken be updated with the new translation.  We take the
     approach of translating immediately before every use of yytoken.
     One alternative is translating here after every semantic action,
     but that translation would be missed if the semantic action invokes
     YYABORT, YYACCEPT, or YYERROR immediately after altering yychar or
     if it invokes YYBACKUP.  In the case of YYABORT or YYACCEPT, an
     incorrect destructor might then be invoked immediately.  In the
     case of YYERROR or YYBACKUP, subsequent parser actions might lead
     to an incorrect destructor call or verbose syntax error message
     before the lookahead is translated.  */
  YY_SYMBOL_PRINT ("-> $$ =", YY_CAST (yysymbol_kind_t, yyr1[yyn]), &yyval, &yyloc);

  YYPOPSTACK (yylen);
  yylen = 0;

  *++yyvsp = yyval;

  /* Now 'shift' the result of the reduction.  Determine what state
     that goes to, based on the state we popped back to and the rule
     number reduced by.  */
  {
    const int yylhs = yyr1[yyn] - YYNTOKENS;
    const int yyi = yypgoto[yylhs] + *yyssp;
    yystate = (0 <= yyi && yyi <= YYLAST && yycheck[yyi] == *yyssp
               ? yytable[yyi]
               : yydefgoto[yylhs]);
  }

  goto yynewstate;


/*--------------------------------------.
| yyerrlab -- here on detecting error.  |
`--------------------------------------*/
yyerrlab:
  /* Make sure we have latest lookahead translation.  See comments at
     user semantic actions for why this is necessary.  */
  yytoken = yychar == YYEMPTY ? YYSYMBOL_YYEMPTY : YYTRANSLATE (yychar);
  /* If not already recovering from an error, report this error.  */
  if (!yyerrstatus)
    {
      ++yynerrs;
      yyerror (YY_("syntax error"));
    }

  if (yyerrstatus == 3)
    {
      /* If just tried and failed to reuse lookahead token after an
         error, discard it.  */

      if (yychar <= YYEOF)
        {
          /* Return failure if at end of input.  */
          if (yychar == YYEOF)
            YYABORT;
        }
      else
        {
          yydestruct ("Error: discarding",
                      yytoken, &yylval);
          yychar = YYEMPTY;
        }
    }

  /* Else will try to reuse lookahead token after shifting the error
     token.  */
  goto yyerrlab1;


/*---------------------------------------------------.
| yyerrorlab -- error raised explicitly by YYERROR.  |
`---------------------------------------------------*/
yyerrorlab:
  /* Pacify compilers when the user code never invokes YYERROR and the
     label yyerrorlab therefore never appears in user code.  */
  if (0)
    YYERROR;
  ++yynerrs;

  /* Do not reclaim the symbols of the rule whose action triggered
     this YYERROR.  */
  YYPOPSTACK (yylen);
  yylen = 0;
  YY_STACK_PRINT (yyss, yyssp);
  yystate = *yyssp;
  goto yyerrlab1;


/*-------------------------------------------------------------.
| yyerrlab1 -- common code for both syntax error and YYERROR.  |
`-------------------------------------------------------------*/
yyerrlab1:
  yyerrstatus = 3;      /* Each real token shifted decrements this.  */

  /* Pop stack until we find a state that shifts the error token.  */
  for (;;)
    {
      yyn = yypact[yystate];
      if (!yypact_value_is_default (yyn))
        {
          yyn += YYSYMBOL_YYerror;
          if (0 <= yyn && yyn <= YYLAST && yycheck[yyn] == YYSYMBOL_YYerror)
            {
              yyn = yytable[yyn];
              if (0 < yyn)
                break;
            }
        }

      /* Pop the current state because it cannot handle the error token.  */
      if (yyssp == yyss)
        YYABORT;


      yydestruct ("Error: popping",
                  YY_ACCESSING_SYMBOL (yystate), yyvsp);
      YYPOPSTACK (1);
      yystate = *yyssp;
      YY_STACK_PRINT (yyss, yyssp);
    }

  YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
  *++yyvsp = yylval;
  YY_IGNORE_MAYBE_UNINITIALIZED_END


  /* Shift the error token.  */
  YY_SYMBOL_PRINT ("Shifting", YY_ACCESSING_SYMBOL (yyn), yyvsp, yylsp);

  yystate = yyn;
  goto yynewstate;


/*-------------------------------------.
| yyacceptlab -- YYACCEPT comes here.  |
`-------------------------------------*/
yyacceptlab:
  yyresult = 0;
  goto yyreturnlab;


/*-----------------------------------.
| yyabortlab -- YYABORT comes here.  |
`-----------------------------------*/
yyabortlab:
  yyresult = 1;
  goto yyreturnlab;


/*-----------------------------------------------------------.
| yyexhaustedlab -- YYNOMEM (memory exhaustion) comes here.  |
`-----------------------------------------------------------*/
yyexhaustedlab:
  yyerror (YY_("memory exhausted"));
  yyresult = 2;
  goto yyreturnlab;


/*----------------------------------------------------------.
| yyreturnlab -- parsing is finished, clean up and return.  |
`----------------------------------------------------------*/
yyreturnlab:
  if (yychar != YYEMPTY)
    {
      /* Make sure we have latest lookahead translation.  See comments at
         user semantic actions for why this is necessary.  */
      yytoken = YYTRANSLATE (yychar);
      yydestruct ("Cleanup: discarding lookahead",
                  yytoken, &yylval);
    }
  /* Do not reclaim the symbols of the rule whose action triggered
     this YYABORT or YYACCEPT.  */
  YYPOPSTACK (yylen);
  YY_STACK_PRINT (yyss, yyssp);
  while (yyssp != yyss)
    {
      yydestruct ("Cleanup: popping",
                  YY_ACCESSING_SYMBOL (+*yyssp), yyvsp);
      YYPOPSTACK (1);
    }
#ifndef yyoverflow
  if (yyss != yyssa)
    YYSTACK_FREE (yyss);
#endif

  return yyresult;
}

#line 2694 "cfg.y"


static inline void ALLOW_UNUSED warn(char* s)
{
	LM_WARN("warning in config file %s, line %d, column %d-%d: %s\n",
			get_cfg_file_name, line, startcolumn, column, s);
}

static void yyerror(char* s)
{
	cfg_dump_backtrace();
	LM_CRIT("parse error in %s:%d:%d-%d: %s\n",
			get_cfg_file_name, line, startcolumn, column, s);
	_cfg_dump_context(get_cfg_file_name, line, startcolumn, column, 1);
	cfg_errors++;
}

#define ERROR_MAXLEN 1024
static void yyerrorf(char *fmt, ...)
{
	char *tmp = pkg_malloc(ERROR_MAXLEN);
	va_list ap;
	va_start(ap, fmt);

	vsnprintf(tmp, ERROR_MAXLEN, fmt, ap);
	yyerror(tmp);

	pkg_free(tmp);
	va_end(ap);
}


static struct socket_id* mk_listen_id(char* host, enum sip_protos proto,
																	int port)
{
	struct socket_id* l;
	l=pkg_malloc(sizeof(struct socket_id));
	if (l==0){
		LM_CRIT("cfg. parser: out of memory.\n");
	}else{
		memset(l, 0, sizeof(*l));
		l->name     = host;
		l->proto    = proto;
		l->port     = port;
	}

	return l;
}

static struct socket_id* mk_listen_id_range(char* host, enum sip_protos proto, struct port_range *pr)
{
	int port;
	struct socket_id *sid, *first_sid = NULL;
	if (!pr)
		return mk_listen_id(host, proto, 0);
	while (pr) {
		for (port = pr->max; port >= pr->min; port--) {
			sid = mk_listen_id(host, proto, port);
			if (!sid)
				return first_sid;
			sid->next = first_sid;
			first_sid = sid;
		}
		pr = pr->next;
	}
	return first_sid;
}

static void fill_socket_id(struct listen_param *param, struct socket_id *s)
{
	int warn;
	struct socket_id *socket;
	while (s) {
		s->flags |= param->flags;
		s->workers = param->workers;
		s->tos = param->tos;
		s->auto_scaling_profile = param->auto_scaling_profile;
		s->tag = param->tag;
		if (param->socket) {
			socket = param->socket;
			param->socket = param->socket->next;
			set_listen_id_adv(s, socket->name, socket->port);
			pkg_free(socket);
		} else if (!warn) {
			LM_WARN("inconsistent port range with advertised ports - skipping advertised\n");
			warn = 1;
		}
		s = s->next;
	}
	/* free remaining sockets, if any */
	while (param->socket) {
		if (!warn) {
			LM_WARN("inconsistent port range with advertised ports - too many adverised\n");
			warn = 1;
		}
		socket = param->socket->next;
		param->socket = param->socket->next;
		pkg_free(socket);
	}
}

static struct multi_str *new_string(char *s)
{
	struct multi_str *ms = pkg_malloc(sizeof(struct multi_str));
	if (!ms) {
		LM_CRIT("cfg. parser: out of memory.\n");
	}else{
		ms->s    = s;
		ms->next = NULL;
	}
	return ms;
}

static struct port_range* mk_port_range(int min, int max)
{
	struct port_range *pr = pkg_malloc(sizeof *pr);
	if (pr) {
		memset(pr, 0, sizeof *pr);
		pr->min = min;
		pr->max = max;
		pr->next = NULL;
	} else {
		LM_CRIT("cfg. parser: out of memory.\n");
	}
	return pr;
}

static struct socket_id* set_listen_id_adv(struct socket_id* sock,
											char *adv_name,
											int adv_port)
{
	sock->adv_name=adv_name;
	sock->adv_port=adv_port;
	return sock;
}

static int parse_ipnet(char *in, int len, struct net **ipnet)
{
	char *p = NULL;
	str ip_s, mask_s;
	struct ip_addr *ip = NULL, *mask = NULL, *ip_tmp;
	int af;
	unsigned int bitlen;

	p = q_memchr(in, '.', len);
	if (p)
		af = AF_INET;
	else if (q_memchr(in, ':', len)) {
		af = AF_INET6;
	} else {
		LM_ERR("Not an IP");
		return -1;
	}

	p = q_memchr(in, '/', len);
	if (!p) {
		LM_ERR("No netmask\n");
		return -1;
	}
	ip_s.s = in;
	ip_s.len = p - in;

	mask_s.s = p + 1;
	mask_s.len = len - ip_s.len - 1;
	if (!mask_s.s || mask_s.len == 0) {
		LM_ERR("Empty netmask\n");
		return -1;
	}

	ip_tmp = (af == AF_INET) ? str2ip(&ip_s) : str2ip6(&ip_s);
	if (!ip_tmp) {
		LM_ERR("Invalid IP\n");
		return -1;
	}
	ip = pkg_malloc(sizeof *ip);
	if (!ip) {
		LM_CRIT("No more pkg memory\n");
		return -1;
	}
	memcpy(ip, ip_tmp, sizeof *ip);

	p = (af == AF_INET) ? q_memchr(p, '.', len-(p-in)+1) : q_memchr(p, ':', len-(p-in)+1);
	if (p) {
		ip_tmp = (af == AF_INET) ? str2ip(&mask_s) : str2ip6(&mask_s);
		if (!ip_tmp) {
			LM_ERR("Invalid netmask\n");
			return -1;
		}
		mask = pkg_malloc(sizeof *mask);
		if (!mask) {
			LM_CRIT("No more pkg memory\n");
			return -1;
		}
		memcpy(mask, ip_tmp, sizeof *mask);

		*ipnet = mk_net(ip, mask);
	} else {
		if (str2int(&mask_s, &bitlen) < 0) {
			LM_ERR("Invalid netmask bitlen\n");
			return -1;
		}

		*ipnet = mk_net_bitlen(ip, bitlen);
	}

	pkg_free(ip);
	pkg_free(mask);

	if (*ipnet == NULL)
			return -1;

	return 0;
}
