// This file is generated by TypeBuilder_cpp.template.

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "src/inspector/protocol/Debugger.h"

#include "src/inspector/protocol/Protocol.h"

#include "../../deps/v8/third_party/inspector_protocol/crdtp/cbor.h"
#include "../../deps/v8/third_party/inspector_protocol/crdtp/find_by_first.h"
#include "../../deps/v8/third_party/inspector_protocol/crdtp/span.h"

namespace v8_inspector {
namespace protocol {
namespace Debugger {

using v8_crdtp::DeserializerState;
using v8_crdtp::ProtocolTypeTraits;

// ------------- Enum values from types.

const char Metainfo::domainName[] = "Debugger";
const char Metainfo::commandPrefix[] = "Debugger.";
const char Metainfo::version[] = "1.3";



V8_CRDTP_BEGIN_DESERIALIZER(Location)
    V8_CRDTP_DESERIALIZE_FIELD_OPT("columnNumber", m_columnNumber),
    V8_CRDTP_DESERIALIZE_FIELD("lineNumber", m_lineNumber),
    V8_CRDTP_DESERIALIZE_FIELD("scriptId", m_scriptId),
V8_CRDTP_END_DESERIALIZER()

V8_CRDTP_BEGIN_SERIALIZER(Location)
    V8_CRDTP_SERIALIZE_FIELD("scriptId", m_scriptId);
    V8_CRDTP_SERIALIZE_FIELD("lineNumber", m_lineNumber);
    V8_CRDTP_SERIALIZE_FIELD("columnNumber", m_columnNumber);
V8_CRDTP_END_SERIALIZER();


V8_CRDTP_BEGIN_DESERIALIZER(ScriptPosition)
    V8_CRDTP_DESERIALIZE_FIELD("columnNumber", m_columnNumber),
    V8_CRDTP_DESERIALIZE_FIELD("lineNumber", m_lineNumber),
V8_CRDTP_END_DESERIALIZER()

V8_CRDTP_BEGIN_SERIALIZER(ScriptPosition)
    V8_CRDTP_SERIALIZE_FIELD("lineNumber", m_lineNumber);
    V8_CRDTP_SERIALIZE_FIELD("columnNumber", m_columnNumber);
V8_CRDTP_END_SERIALIZER();


V8_CRDTP_BEGIN_DESERIALIZER(LocationRange)
    V8_CRDTP_DESERIALIZE_FIELD("end", m_end),
    V8_CRDTP_DESERIALIZE_FIELD("scriptId", m_scriptId),
    V8_CRDTP_DESERIALIZE_FIELD("start", m_start),
V8_CRDTP_END_DESERIALIZER()

V8_CRDTP_BEGIN_SERIALIZER(LocationRange)
    V8_CRDTP_SERIALIZE_FIELD("scriptId", m_scriptId);
    V8_CRDTP_SERIALIZE_FIELD("start", m_start);
    V8_CRDTP_SERIALIZE_FIELD("end", m_end);
V8_CRDTP_END_SERIALIZER();


V8_CRDTP_BEGIN_DESERIALIZER(CallFrame)
    V8_CRDTP_DESERIALIZE_FIELD("callFrameId", m_callFrameId),
    V8_CRDTP_DESERIALIZE_FIELD_OPT("canBeRestarted", m_canBeRestarted),
    V8_CRDTP_DESERIALIZE_FIELD_OPT("functionLocation", m_functionLocation),
    V8_CRDTP_DESERIALIZE_FIELD("functionName", m_functionName),
    V8_CRDTP_DESERIALIZE_FIELD("location", m_location),
    V8_CRDTP_DESERIALIZE_FIELD_OPT("returnValue", m_returnValue),
    V8_CRDTP_DESERIALIZE_FIELD("scopeChain", m_scopeChain),
    V8_CRDTP_DESERIALIZE_FIELD("this", m_this),
    V8_CRDTP_DESERIALIZE_FIELD("url", m_url),
V8_CRDTP_END_DESERIALIZER()

V8_CRDTP_BEGIN_SERIALIZER(CallFrame)
    V8_CRDTP_SERIALIZE_FIELD("callFrameId", m_callFrameId);
    V8_CRDTP_SERIALIZE_FIELD("functionName", m_functionName);
    V8_CRDTP_SERIALIZE_FIELD("functionLocation", m_functionLocation);
    V8_CRDTP_SERIALIZE_FIELD("location", m_location);
    V8_CRDTP_SERIALIZE_FIELD("url", m_url);
    V8_CRDTP_SERIALIZE_FIELD("scopeChain", m_scopeChain);
    V8_CRDTP_SERIALIZE_FIELD("this", m_this);
    V8_CRDTP_SERIALIZE_FIELD("returnValue", m_returnValue);
    V8_CRDTP_SERIALIZE_FIELD("canBeRestarted", m_canBeRestarted);
V8_CRDTP_END_SERIALIZER();



const char* Scope::TypeEnum::Global = "global";
const char* Scope::TypeEnum::Local = "local";
const char* Scope::TypeEnum::With = "with";
const char* Scope::TypeEnum::Closure = "closure";
const char* Scope::TypeEnum::Catch = "catch";
const char* Scope::TypeEnum::Block = "block";
const char* Scope::TypeEnum::Script = "script";
const char* Scope::TypeEnum::Eval = "eval";
const char* Scope::TypeEnum::Module = "module";
const char* Scope::TypeEnum::WasmExpressionStack = "wasm-expression-stack";
V8_CRDTP_BEGIN_DESERIALIZER(Scope)
    V8_CRDTP_DESERIALIZE_FIELD_OPT("endLocation", m_endLocation),
    V8_CRDTP_DESERIALIZE_FIELD_OPT("name", m_name),
    V8_CRDTP_DESERIALIZE_FIELD("object", m_object),
    V8_CRDTP_DESERIALIZE_FIELD_OPT("startLocation", m_startLocation),
    V8_CRDTP_DESERIALIZE_FIELD("type", m_type),
V8_CRDTP_END_DESERIALIZER()

V8_CRDTP_BEGIN_SERIALIZER(Scope)
    V8_CRDTP_SERIALIZE_FIELD("type", m_type);
    V8_CRDTP_SERIALIZE_FIELD("object", m_object);
    V8_CRDTP_SERIALIZE_FIELD("name", m_name);
    V8_CRDTP_SERIALIZE_FIELD("startLocation", m_startLocation);
    V8_CRDTP_SERIALIZE_FIELD("endLocation", m_endLocation);
V8_CRDTP_END_SERIALIZER();


V8_CRDTP_BEGIN_DESERIALIZER(SearchMatch)
    V8_CRDTP_DESERIALIZE_FIELD("lineContent", m_lineContent),
    V8_CRDTP_DESERIALIZE_FIELD("lineNumber", m_lineNumber),
V8_CRDTP_END_DESERIALIZER()

V8_CRDTP_BEGIN_SERIALIZER(SearchMatch)
    V8_CRDTP_SERIALIZE_FIELD("lineNumber", m_lineNumber);
    V8_CRDTP_SERIALIZE_FIELD("lineContent", m_lineContent);
V8_CRDTP_END_SERIALIZER();

// static
std::unique_ptr<API::SearchMatch> API::SearchMatch::fromBinary(const uint8_t* data, size_t length)
{
    return protocol::Debugger::SearchMatch::FromBinary(data, length);
}


const char* BreakLocation::TypeEnum::DebuggerStatement = "debuggerStatement";
const char* BreakLocation::TypeEnum::Call = "call";
const char* BreakLocation::TypeEnum::Return = "return";
V8_CRDTP_BEGIN_DESERIALIZER(BreakLocation)
    V8_CRDTP_DESERIALIZE_FIELD_OPT("columnNumber", m_columnNumber),
    V8_CRDTP_DESERIALIZE_FIELD("lineNumber", m_lineNumber),
    V8_CRDTP_DESERIALIZE_FIELD("scriptId", m_scriptId),
    V8_CRDTP_DESERIALIZE_FIELD_OPT("type", m_type),
V8_CRDTP_END_DESERIALIZER()

V8_CRDTP_BEGIN_SERIALIZER(BreakLocation)
    V8_CRDTP_SERIALIZE_FIELD("scriptId", m_scriptId);
    V8_CRDTP_SERIALIZE_FIELD("lineNumber", m_lineNumber);
    V8_CRDTP_SERIALIZE_FIELD("columnNumber", m_columnNumber);
    V8_CRDTP_SERIALIZE_FIELD("type", m_type);
V8_CRDTP_END_SERIALIZER();


V8_CRDTP_BEGIN_DESERIALIZER(WasmDisassemblyChunk)
    V8_CRDTP_DESERIALIZE_FIELD("bytecodeOffsets", m_bytecodeOffsets),
    V8_CRDTP_DESERIALIZE_FIELD("lines", m_lines),
V8_CRDTP_END_DESERIALIZER()

V8_CRDTP_BEGIN_SERIALIZER(WasmDisassemblyChunk)
    V8_CRDTP_SERIALIZE_FIELD("lines", m_lines);
    V8_CRDTP_SERIALIZE_FIELD("bytecodeOffsets", m_bytecodeOffsets);
V8_CRDTP_END_SERIALIZER();


namespace ScriptLanguageEnum {
const char JavaScript[] = "JavaScript";
const char WebAssembly[] = "WebAssembly";
} // namespace ScriptLanguageEnum



const char* DebugSymbols::TypeEnum::SourceMap = "SourceMap";
const char* DebugSymbols::TypeEnum::EmbeddedDWARF = "EmbeddedDWARF";
const char* DebugSymbols::TypeEnum::ExternalDWARF = "ExternalDWARF";
V8_CRDTP_BEGIN_DESERIALIZER(DebugSymbols)
    V8_CRDTP_DESERIALIZE_FIELD_OPT("externalURL", m_externalURL),
    V8_CRDTP_DESERIALIZE_FIELD("type", m_type),
V8_CRDTP_END_DESERIALIZER()

V8_CRDTP_BEGIN_SERIALIZER(DebugSymbols)
    V8_CRDTP_SERIALIZE_FIELD("type", m_type);
    V8_CRDTP_SERIALIZE_FIELD("externalURL", m_externalURL);
V8_CRDTP_END_SERIALIZER();


V8_CRDTP_BEGIN_DESERIALIZER(ResolvedBreakpoint)
    V8_CRDTP_DESERIALIZE_FIELD("breakpointId", m_breakpointId),
    V8_CRDTP_DESERIALIZE_FIELD("location", m_location),
V8_CRDTP_END_DESERIALIZER()

V8_CRDTP_BEGIN_SERIALIZER(ResolvedBreakpoint)
    V8_CRDTP_SERIALIZE_FIELD("breakpointId", m_breakpointId);
    V8_CRDTP_SERIALIZE_FIELD("location", m_location);
V8_CRDTP_END_SERIALIZER();


// ------------- Enum values from params.


namespace ContinueToLocation {
namespace TargetCallFramesEnum {
const char* Any = "any";
const char* Current = "current";
} // namespace TargetCallFramesEnum
} // namespace ContinueToLocation

namespace RestartFrame {
namespace ModeEnum {
const char* StepInto = "StepInto";
} // namespace ModeEnum
} // namespace RestartFrame

namespace SetInstrumentationBreakpoint {
namespace InstrumentationEnum {
const char* BeforeScriptExecution = "beforeScriptExecution";
const char* BeforeScriptWithSourceMapExecution = "beforeScriptWithSourceMapExecution";
} // namespace InstrumentationEnum
} // namespace SetInstrumentationBreakpoint

namespace SetPauseOnExceptions {
namespace StateEnum {
const char* None = "none";
const char* Caught = "caught";
const char* Uncaught = "uncaught";
const char* All = "all";
} // namespace StateEnum
} // namespace SetPauseOnExceptions

namespace SetScriptSource {
namespace StatusEnum {
const char* Ok = "Ok";
const char* CompileError = "CompileError";
const char* BlockedByActiveGenerator = "BlockedByActiveGenerator";
const char* BlockedByActiveFunction = "BlockedByActiveFunction";
const char* BlockedByTopLevelEsModuleChange = "BlockedByTopLevelEsModuleChange";
} // namespace StatusEnum
} // namespace SetScriptSource

namespace Paused {
namespace ReasonEnum {
const char* Ambiguous = "ambiguous";
const char* Assert = "assert";
const char* CSPViolation = "CSPViolation";
const char* DebugCommand = "debugCommand";
const char* DOM = "DOM";
const char* EventListener = "EventListener";
const char* Exception = "exception";
const char* Instrumentation = "instrumentation";
const char* OOM = "OOM";
const char* Other = "other";
const char* PromiseRejection = "promiseRejection";
const char* XHR = "XHR";
const char* Step = "step";
} // namespace ReasonEnum
} // namespace Paused

namespace API {
namespace Paused {
namespace ReasonEnum {
const char* Ambiguous = "ambiguous";
const char* Assert = "assert";
const char* CSPViolation = "CSPViolation";
const char* DebugCommand = "debugCommand";
const char* DOM = "DOM";
const char* EventListener = "EventListener";
const char* Exception = "exception";
const char* Instrumentation = "instrumentation";
const char* OOM = "OOM";
const char* Other = "other";
const char* PromiseRejection = "promiseRejection";
const char* XHR = "XHR";
const char* Step = "step";
} // namespace ReasonEnum
} // namespace Paused
} // namespace API

// ------------- Frontend notifications.

void Frontend::breakpointResolved(const String& breakpointId, std::unique_ptr<protocol::Debugger::Location> location)
{
    if (!frontend_channel_)
        return;
    v8_crdtp::ObjectSerializer serializer;
    serializer.AddField(v8_crdtp::MakeSpan("breakpointId"), breakpointId);
    serializer.AddField(v8_crdtp::MakeSpan("location"), location);
    frontend_channel_->SendProtocolNotification(v8_crdtp::CreateNotification("Debugger.breakpointResolved", serializer.Finish()));
}

void Frontend::paused(std::unique_ptr<protocol::Array<protocol::Debugger::CallFrame>> callFrames, const String& reason, std::unique_ptr<protocol::DictionaryValue> data, std::unique_ptr<protocol::Array<String>> hitBreakpoints, std::unique_ptr<protocol::Runtime::StackTrace> asyncStackTrace, std::unique_ptr<protocol::Runtime::StackTraceId> asyncStackTraceId, std::unique_ptr<protocol::Runtime::StackTraceId> asyncCallStackTraceId)
{
    if (!frontend_channel_)
        return;
    v8_crdtp::ObjectSerializer serializer;
    serializer.AddField(v8_crdtp::MakeSpan("callFrames"), callFrames);
    serializer.AddField(v8_crdtp::MakeSpan("reason"), reason);
    serializer.AddField(v8_crdtp::MakeSpan("data"), data);
    serializer.AddField(v8_crdtp::MakeSpan("hitBreakpoints"), hitBreakpoints);
    serializer.AddField(v8_crdtp::MakeSpan("asyncStackTrace"), asyncStackTrace);
    serializer.AddField(v8_crdtp::MakeSpan("asyncStackTraceId"), asyncStackTraceId);
    serializer.AddField(v8_crdtp::MakeSpan("asyncCallStackTraceId"), asyncCallStackTraceId);
    frontend_channel_->SendProtocolNotification(v8_crdtp::CreateNotification("Debugger.paused", serializer.Finish()));
}

void Frontend::resumed()
{
    if (!frontend_channel_)
        return;
    frontend_channel_->SendProtocolNotification(v8_crdtp::CreateNotification("Debugger.resumed"));
}

void Frontend::scriptFailedToParse(const String& scriptId, const String& url, int startLine, int startColumn, int endLine, int endColumn, int executionContextId, const String& hash, const String& buildId, std::unique_ptr<protocol::DictionaryValue> executionContextAuxData, std::optional<String> sourceMapURL, std::optional<bool> hasSourceURL, std::optional<bool> isModule, std::optional<int> length, std::unique_ptr<protocol::Runtime::StackTrace> stackTrace, std::optional<int> codeOffset, std::optional<String> scriptLanguage, std::optional<String> embedderName)
{
    if (!frontend_channel_)
        return;
    v8_crdtp::ObjectSerializer serializer;
    serializer.AddField(v8_crdtp::MakeSpan("scriptId"), scriptId);
    serializer.AddField(v8_crdtp::MakeSpan("url"), url);
    serializer.AddField(v8_crdtp::MakeSpan("startLine"), startLine);
    serializer.AddField(v8_crdtp::MakeSpan("startColumn"), startColumn);
    serializer.AddField(v8_crdtp::MakeSpan("endLine"), endLine);
    serializer.AddField(v8_crdtp::MakeSpan("endColumn"), endColumn);
    serializer.AddField(v8_crdtp::MakeSpan("executionContextId"), executionContextId);
    serializer.AddField(v8_crdtp::MakeSpan("hash"), hash);
    serializer.AddField(v8_crdtp::MakeSpan("buildId"), buildId);
    serializer.AddField(v8_crdtp::MakeSpan("executionContextAuxData"), executionContextAuxData);
    serializer.AddField(v8_crdtp::MakeSpan("sourceMapURL"), sourceMapURL);
    serializer.AddField(v8_crdtp::MakeSpan("hasSourceURL"), hasSourceURL);
    serializer.AddField(v8_crdtp::MakeSpan("isModule"), isModule);
    serializer.AddField(v8_crdtp::MakeSpan("length"), length);
    serializer.AddField(v8_crdtp::MakeSpan("stackTrace"), stackTrace);
    serializer.AddField(v8_crdtp::MakeSpan("codeOffset"), codeOffset);
    serializer.AddField(v8_crdtp::MakeSpan("scriptLanguage"), scriptLanguage);
    serializer.AddField(v8_crdtp::MakeSpan("embedderName"), embedderName);
    frontend_channel_->SendProtocolNotification(v8_crdtp::CreateNotification("Debugger.scriptFailedToParse", serializer.Finish()));
}

void Frontend::scriptParsed(const String& scriptId, const String& url, int startLine, int startColumn, int endLine, int endColumn, int executionContextId, const String& hash, const String& buildId, std::unique_ptr<protocol::DictionaryValue> executionContextAuxData, std::optional<bool> isLiveEdit, std::optional<String> sourceMapURL, std::optional<bool> hasSourceURL, std::optional<bool> isModule, std::optional<int> length, std::unique_ptr<protocol::Runtime::StackTrace> stackTrace, std::optional<int> codeOffset, std::optional<String> scriptLanguage, std::unique_ptr<protocol::Array<protocol::Debugger::DebugSymbols>> debugSymbols, std::optional<String> embedderName, std::unique_ptr<protocol::Array<protocol::Debugger::ResolvedBreakpoint>> resolvedBreakpoints)
{
    if (!frontend_channel_)
        return;
    v8_crdtp::ObjectSerializer serializer;
    serializer.AddField(v8_crdtp::MakeSpan("scriptId"), scriptId);
    serializer.AddField(v8_crdtp::MakeSpan("url"), url);
    serializer.AddField(v8_crdtp::MakeSpan("startLine"), startLine);
    serializer.AddField(v8_crdtp::MakeSpan("startColumn"), startColumn);
    serializer.AddField(v8_crdtp::MakeSpan("endLine"), endLine);
    serializer.AddField(v8_crdtp::MakeSpan("endColumn"), endColumn);
    serializer.AddField(v8_crdtp::MakeSpan("executionContextId"), executionContextId);
    serializer.AddField(v8_crdtp::MakeSpan("hash"), hash);
    serializer.AddField(v8_crdtp::MakeSpan("buildId"), buildId);
    serializer.AddField(v8_crdtp::MakeSpan("executionContextAuxData"), executionContextAuxData);
    serializer.AddField(v8_crdtp::MakeSpan("isLiveEdit"), isLiveEdit);
    serializer.AddField(v8_crdtp::MakeSpan("sourceMapURL"), sourceMapURL);
    serializer.AddField(v8_crdtp::MakeSpan("hasSourceURL"), hasSourceURL);
    serializer.AddField(v8_crdtp::MakeSpan("isModule"), isModule);
    serializer.AddField(v8_crdtp::MakeSpan("length"), length);
    serializer.AddField(v8_crdtp::MakeSpan("stackTrace"), stackTrace);
    serializer.AddField(v8_crdtp::MakeSpan("codeOffset"), codeOffset);
    serializer.AddField(v8_crdtp::MakeSpan("scriptLanguage"), scriptLanguage);
    serializer.AddField(v8_crdtp::MakeSpan("debugSymbols"), debugSymbols);
    serializer.AddField(v8_crdtp::MakeSpan("embedderName"), embedderName);
    serializer.AddField(v8_crdtp::MakeSpan("resolvedBreakpoints"), resolvedBreakpoints);
    frontend_channel_->SendProtocolNotification(v8_crdtp::CreateNotification("Debugger.scriptParsed", serializer.Finish()));
}

void Frontend::flush()
{
    frontend_channel_->FlushProtocolNotifications();
}

void Frontend::sendRawNotification(std::unique_ptr<Serializable> notification)
{
    frontend_channel_->SendProtocolNotification(std::move(notification));
}

// --------------------- Dispatcher.

class DomainDispatcherImpl : public protocol::DomainDispatcher {
public:
    DomainDispatcherImpl(FrontendChannel* frontendChannel, Backend* backend)
        : DomainDispatcher(frontendChannel)
        , m_backend(backend) {}
    ~DomainDispatcherImpl() override { }

    using CallHandler = void (DomainDispatcherImpl::*)(const v8_crdtp::Dispatchable& dispatchable);

    std::function<void(const v8_crdtp::Dispatchable&)> Dispatch(v8_crdtp::span<uint8_t> command_name) override;

    void continueToLocation(const v8_crdtp::Dispatchable& dispatchable);
    void disable(const v8_crdtp::Dispatchable& dispatchable);
    void enable(const v8_crdtp::Dispatchable& dispatchable);
    void evaluateOnCallFrame(const v8_crdtp::Dispatchable& dispatchable);
    void getPossibleBreakpoints(const v8_crdtp::Dispatchable& dispatchable);
    void getScriptSource(const v8_crdtp::Dispatchable& dispatchable);
    void disassembleWasmModule(const v8_crdtp::Dispatchable& dispatchable);
    void nextWasmDisassemblyChunk(const v8_crdtp::Dispatchable& dispatchable);
    void getWasmBytecode(const v8_crdtp::Dispatchable& dispatchable);
    void getStackTrace(const v8_crdtp::Dispatchable& dispatchable);
    void pause(const v8_crdtp::Dispatchable& dispatchable);
    void pauseOnAsyncCall(const v8_crdtp::Dispatchable& dispatchable);
    void removeBreakpoint(const v8_crdtp::Dispatchable& dispatchable);
    void restartFrame(const v8_crdtp::Dispatchable& dispatchable);
    void resume(const v8_crdtp::Dispatchable& dispatchable);
    void searchInContent(const v8_crdtp::Dispatchable& dispatchable);
    void setAsyncCallStackDepth(const v8_crdtp::Dispatchable& dispatchable);
    void setBlackboxExecutionContexts(const v8_crdtp::Dispatchable& dispatchable);
    void setBlackboxPatterns(const v8_crdtp::Dispatchable& dispatchable);
    void setBlackboxedRanges(const v8_crdtp::Dispatchable& dispatchable);
    void setBreakpoint(const v8_crdtp::Dispatchable& dispatchable);
    void setInstrumentationBreakpoint(const v8_crdtp::Dispatchable& dispatchable);
    void setBreakpointByUrl(const v8_crdtp::Dispatchable& dispatchable);
    void setBreakpointOnFunctionCall(const v8_crdtp::Dispatchable& dispatchable);
    void setBreakpointsActive(const v8_crdtp::Dispatchable& dispatchable);
    void setPauseOnExceptions(const v8_crdtp::Dispatchable& dispatchable);
    void setReturnValue(const v8_crdtp::Dispatchable& dispatchable);
    void setScriptSource(const v8_crdtp::Dispatchable& dispatchable);
    void setSkipAllPauses(const v8_crdtp::Dispatchable& dispatchable);
    void setVariableValue(const v8_crdtp::Dispatchable& dispatchable);
    void stepInto(const v8_crdtp::Dispatchable& dispatchable);
    void stepOut(const v8_crdtp::Dispatchable& dispatchable);
    void stepOver(const v8_crdtp::Dispatchable& dispatchable);
 protected:
    Backend* m_backend;
};

namespace {
// This helper method with a static map of command methods (instance methods
// of DomainDispatcherImpl declared just above) by their name is used immediately below,
// in the DomainDispatcherImpl::Dispatch method.
DomainDispatcherImpl::CallHandler CommandByName(v8_crdtp::span<uint8_t> command_name) {
  static auto* commands = [](){
    auto* commands = new std::vector<std::pair<v8_crdtp::span<uint8_t>,
                              DomainDispatcherImpl::CallHandler>>{
    {
          v8_crdtp::SpanFrom("continueToLocation"),
          &DomainDispatcherImpl::continueToLocation
    },
    {
          v8_crdtp::SpanFrom("disable"),
          &DomainDispatcherImpl::disable
    },
    {
          v8_crdtp::SpanFrom("disassembleWasmModule"),
          &DomainDispatcherImpl::disassembleWasmModule
    },
    {
          v8_crdtp::SpanFrom("enable"),
          &DomainDispatcherImpl::enable
    },
    {
          v8_crdtp::SpanFrom("evaluateOnCallFrame"),
          &DomainDispatcherImpl::evaluateOnCallFrame
    },
    {
          v8_crdtp::SpanFrom("getPossibleBreakpoints"),
          &DomainDispatcherImpl::getPossibleBreakpoints
    },
    {
          v8_crdtp::SpanFrom("getScriptSource"),
          &DomainDispatcherImpl::getScriptSource
    },
    {
          v8_crdtp::SpanFrom("getStackTrace"),
          &DomainDispatcherImpl::getStackTrace
    },
    {
          v8_crdtp::SpanFrom("getWasmBytecode"),
          &DomainDispatcherImpl::getWasmBytecode
    },
    {
          v8_crdtp::SpanFrom("nextWasmDisassemblyChunk"),
          &DomainDispatcherImpl::nextWasmDisassemblyChunk
    },
    {
          v8_crdtp::SpanFrom("pause"),
          &DomainDispatcherImpl::pause
    },
    {
          v8_crdtp::SpanFrom("pauseOnAsyncCall"),
          &DomainDispatcherImpl::pauseOnAsyncCall
    },
    {
          v8_crdtp::SpanFrom("removeBreakpoint"),
          &DomainDispatcherImpl::removeBreakpoint
    },
    {
          v8_crdtp::SpanFrom("restartFrame"),
          &DomainDispatcherImpl::restartFrame
    },
    {
          v8_crdtp::SpanFrom("resume"),
          &DomainDispatcherImpl::resume
    },
    {
          v8_crdtp::SpanFrom("searchInContent"),
          &DomainDispatcherImpl::searchInContent
    },
    {
          v8_crdtp::SpanFrom("setAsyncCallStackDepth"),
          &DomainDispatcherImpl::setAsyncCallStackDepth
    },
    {
          v8_crdtp::SpanFrom("setBlackboxExecutionContexts"),
          &DomainDispatcherImpl::setBlackboxExecutionContexts
    },
    {
          v8_crdtp::SpanFrom("setBlackboxPatterns"),
          &DomainDispatcherImpl::setBlackboxPatterns
    },
    {
          v8_crdtp::SpanFrom("setBlackboxedRanges"),
          &DomainDispatcherImpl::setBlackboxedRanges
    },
    {
          v8_crdtp::SpanFrom("setBreakpoint"),
          &DomainDispatcherImpl::setBreakpoint
    },
    {
          v8_crdtp::SpanFrom("setBreakpointByUrl"),
          &DomainDispatcherImpl::setBreakpointByUrl
    },
    {
          v8_crdtp::SpanFrom("setBreakpointOnFunctionCall"),
          &DomainDispatcherImpl::setBreakpointOnFunctionCall
    },
    {
          v8_crdtp::SpanFrom("setBreakpointsActive"),
          &DomainDispatcherImpl::setBreakpointsActive
    },
    {
          v8_crdtp::SpanFrom("setInstrumentationBreakpoint"),
          &DomainDispatcherImpl::setInstrumentationBreakpoint
    },
    {
          v8_crdtp::SpanFrom("setPauseOnExceptions"),
          &DomainDispatcherImpl::setPauseOnExceptions
    },
    {
          v8_crdtp::SpanFrom("setReturnValue"),
          &DomainDispatcherImpl::setReturnValue
    },
    {
          v8_crdtp::SpanFrom("setScriptSource"),
          &DomainDispatcherImpl::setScriptSource
    },
    {
          v8_crdtp::SpanFrom("setSkipAllPauses"),
          &DomainDispatcherImpl::setSkipAllPauses
    },
    {
          v8_crdtp::SpanFrom("setVariableValue"),
          &DomainDispatcherImpl::setVariableValue
    },
    {
          v8_crdtp::SpanFrom("stepInto"),
          &DomainDispatcherImpl::stepInto
    },
    {
          v8_crdtp::SpanFrom("stepOut"),
          &DomainDispatcherImpl::stepOut
    },
    {
          v8_crdtp::SpanFrom("stepOver"),
          &DomainDispatcherImpl::stepOver
    },
    };
    return commands;
  }();
  return v8_crdtp::FindByFirst<DomainDispatcherImpl::CallHandler>(*commands, command_name, nullptr);
}
}  // namespace

std::function<void(const v8_crdtp::Dispatchable&)> DomainDispatcherImpl::Dispatch(v8_crdtp::span<uint8_t> command_name) {
  CallHandler handler = CommandByName(command_name);
  if (!handler) return nullptr;

  return [this, handler](const v8_crdtp::Dispatchable& dispatchable) {
    (this->*handler)(dispatchable);
  };
}


namespace {

struct continueToLocationParams : public v8_crdtp::DeserializableProtocolObject<continueToLocationParams> {
    std::unique_ptr<protocol::Debugger::Location> location;
    std::optional<String> targetCallFrames;
    DECLARE_DESERIALIZATION_SUPPORT();
};

V8_CRDTP_BEGIN_DESERIALIZER(continueToLocationParams)
    V8_CRDTP_DESERIALIZE_FIELD("location", location),
    V8_CRDTP_DESERIALIZE_FIELD_OPT("targetCallFrames", targetCallFrames),
V8_CRDTP_END_DESERIALIZER()

}  // namespace

void DomainDispatcherImpl::continueToLocation(const v8_crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.
    auto deserializer = v8_crdtp::DeferredMessage::FromSpan(dispatchable.Params())->MakeDeserializer();
    continueToLocationParams params;
    if (!continueToLocationParams::Deserialize(&deserializer, &params)) {
      ReportInvalidParams(dispatchable, deserializer);
      return;
    }

    std::unique_ptr<DomainDispatcher::WeakPtr> weak = weakPtr();
    DispatchResponse response = m_backend->continueToLocation(std::move(params.location), std::move(params.targetCallFrames));
    if (response.IsFallThrough()) {
        channel()->FallThrough(dispatchable.CallId(), v8_crdtp::SpanFrom("Debugger.continueToLocation"), dispatchable.Serialized());
        return;
    }
    if (weak->get())
        weak->get()->sendResponse(dispatchable.CallId(), response);
    return;
}

namespace {


}  // namespace

void DomainDispatcherImpl::disable(const v8_crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.

    std::unique_ptr<DomainDispatcher::WeakPtr> weak = weakPtr();
    DispatchResponse response = m_backend->disable();
    if (response.IsFallThrough()) {
        channel()->FallThrough(dispatchable.CallId(), v8_crdtp::SpanFrom("Debugger.disable"), dispatchable.Serialized());
        return;
    }
    if (weak->get())
        weak->get()->sendResponse(dispatchable.CallId(), response);
    return;
}

namespace {

struct enableParams : public v8_crdtp::DeserializableProtocolObject<enableParams> {
    std::optional<double> maxScriptsCacheSize;
    DECLARE_DESERIALIZATION_SUPPORT();
};

V8_CRDTP_BEGIN_DESERIALIZER(enableParams)
    V8_CRDTP_DESERIALIZE_FIELD_OPT("maxScriptsCacheSize", maxScriptsCacheSize),
V8_CRDTP_END_DESERIALIZER()

}  // namespace

void DomainDispatcherImpl::enable(const v8_crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.
    auto deserializer = v8_crdtp::DeferredMessage::FromSpan(dispatchable.Params())->MakeDeserializer();
    enableParams params;
    if (!enableParams::Deserialize(&deserializer, &params)) {
      ReportInvalidParams(dispatchable, deserializer);
      return;
    }
    // Declare output parameters.
    String out_debuggerId;

    std::unique_ptr<DomainDispatcher::WeakPtr> weak = weakPtr();
    DispatchResponse response = m_backend->enable(std::move(params.maxScriptsCacheSize), &out_debuggerId);
    if (response.IsFallThrough()) {
        channel()->FallThrough(dispatchable.CallId(), v8_crdtp::SpanFrom("Debugger.enable"), dispatchable.Serialized());
        return;
    }
      if (weak->get()) {
        std::unique_ptr<v8_crdtp::Serializable> result;
        if (response.IsSuccess()) {
          v8_crdtp::ObjectSerializer serializer;
          serializer.AddField(v8_crdtp::MakeSpan("debuggerId"), out_debuggerId);
          result = serializer.Finish();
        } else {
          result = Serializable::From({});
        }
        weak->get()->sendResponse(dispatchable.CallId(), response, std::move(result));
      }
    return;
}

namespace {

struct evaluateOnCallFrameParams : public v8_crdtp::DeserializableProtocolObject<evaluateOnCallFrameParams> {
    String callFrameId;
    String expression;
    std::optional<String> objectGroup;
    std::optional<bool> includeCommandLineAPI;
    std::optional<bool> silent;
    std::optional<bool> returnByValue;
    std::optional<bool> generatePreview;
    std::optional<bool> throwOnSideEffect;
    std::optional<double> timeout;
    DECLARE_DESERIALIZATION_SUPPORT();
};

V8_CRDTP_BEGIN_DESERIALIZER(evaluateOnCallFrameParams)
    V8_CRDTP_DESERIALIZE_FIELD("callFrameId", callFrameId),
    V8_CRDTP_DESERIALIZE_FIELD("expression", expression),
    V8_CRDTP_DESERIALIZE_FIELD_OPT("generatePreview", generatePreview),
    V8_CRDTP_DESERIALIZE_FIELD_OPT("includeCommandLineAPI", includeCommandLineAPI),
    V8_CRDTP_DESERIALIZE_FIELD_OPT("objectGroup", objectGroup),
    V8_CRDTP_DESERIALIZE_FIELD_OPT("returnByValue", returnByValue),
    V8_CRDTP_DESERIALIZE_FIELD_OPT("silent", silent),
    V8_CRDTP_DESERIALIZE_FIELD_OPT("throwOnSideEffect", throwOnSideEffect),
    V8_CRDTP_DESERIALIZE_FIELD_OPT("timeout", timeout),
V8_CRDTP_END_DESERIALIZER()

}  // namespace

void DomainDispatcherImpl::evaluateOnCallFrame(const v8_crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.
    auto deserializer = v8_crdtp::DeferredMessage::FromSpan(dispatchable.Params())->MakeDeserializer();
    evaluateOnCallFrameParams params;
    if (!evaluateOnCallFrameParams::Deserialize(&deserializer, &params)) {
      ReportInvalidParams(dispatchable, deserializer);
      return;
    }
    // Declare output parameters.
    std::unique_ptr<protocol::Runtime::RemoteObject> out_result;
    std::unique_ptr<protocol::Runtime::ExceptionDetails> out_exceptionDetails;

    std::unique_ptr<DomainDispatcher::WeakPtr> weak = weakPtr();
    DispatchResponse response = m_backend->evaluateOnCallFrame(params.callFrameId, params.expression, std::move(params.objectGroup), std::move(params.includeCommandLineAPI), std::move(params.silent), std::move(params.returnByValue), std::move(params.generatePreview), std::move(params.throwOnSideEffect), std::move(params.timeout), &out_result, &out_exceptionDetails);
    if (response.IsFallThrough()) {
        channel()->FallThrough(dispatchable.CallId(), v8_crdtp::SpanFrom("Debugger.evaluateOnCallFrame"), dispatchable.Serialized());
        return;
    }
      if (weak->get()) {
        std::unique_ptr<v8_crdtp::Serializable> result;
        if (response.IsSuccess()) {
          v8_crdtp::ObjectSerializer serializer;
          serializer.AddField(v8_crdtp::MakeSpan("result"), out_result);
          serializer.AddField(v8_crdtp::MakeSpan("exceptionDetails"), out_exceptionDetails);
          result = serializer.Finish();
        } else {
          result = Serializable::From({});
        }
        weak->get()->sendResponse(dispatchable.CallId(), response, std::move(result));
      }
    return;
}

namespace {

struct getPossibleBreakpointsParams : public v8_crdtp::DeserializableProtocolObject<getPossibleBreakpointsParams> {
    std::unique_ptr<protocol::Debugger::Location> start;
    std::unique_ptr<protocol::Debugger::Location> end;
    std::optional<bool> restrictToFunction;
    DECLARE_DESERIALIZATION_SUPPORT();
};

V8_CRDTP_BEGIN_DESERIALIZER(getPossibleBreakpointsParams)
    V8_CRDTP_DESERIALIZE_FIELD_OPT("end", end),
    V8_CRDTP_DESERIALIZE_FIELD_OPT("restrictToFunction", restrictToFunction),
    V8_CRDTP_DESERIALIZE_FIELD("start", start),
V8_CRDTP_END_DESERIALIZER()

}  // namespace

void DomainDispatcherImpl::getPossibleBreakpoints(const v8_crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.
    auto deserializer = v8_crdtp::DeferredMessage::FromSpan(dispatchable.Params())->MakeDeserializer();
    getPossibleBreakpointsParams params;
    if (!getPossibleBreakpointsParams::Deserialize(&deserializer, &params)) {
      ReportInvalidParams(dispatchable, deserializer);
      return;
    }
    // Declare output parameters.
    std::unique_ptr<protocol::Array<protocol::Debugger::BreakLocation>> out_locations;

    std::unique_ptr<DomainDispatcher::WeakPtr> weak = weakPtr();
    DispatchResponse response = m_backend->getPossibleBreakpoints(std::move(params.start), std::move(params.end), std::move(params.restrictToFunction), &out_locations);
    if (response.IsFallThrough()) {
        channel()->FallThrough(dispatchable.CallId(), v8_crdtp::SpanFrom("Debugger.getPossibleBreakpoints"), dispatchable.Serialized());
        return;
    }
      if (weak->get()) {
        std::unique_ptr<v8_crdtp::Serializable> result;
        if (response.IsSuccess()) {
          v8_crdtp::ObjectSerializer serializer;
          serializer.AddField(v8_crdtp::MakeSpan("locations"), out_locations);
          result = serializer.Finish();
        } else {
          result = Serializable::From({});
        }
        weak->get()->sendResponse(dispatchable.CallId(), response, std::move(result));
      }
    return;
}

namespace {

struct getScriptSourceParams : public v8_crdtp::DeserializableProtocolObject<getScriptSourceParams> {
    String scriptId;
    DECLARE_DESERIALIZATION_SUPPORT();
};

V8_CRDTP_BEGIN_DESERIALIZER(getScriptSourceParams)
    V8_CRDTP_DESERIALIZE_FIELD("scriptId", scriptId),
V8_CRDTP_END_DESERIALIZER()

}  // namespace

void DomainDispatcherImpl::getScriptSource(const v8_crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.
    auto deserializer = v8_crdtp::DeferredMessage::FromSpan(dispatchable.Params())->MakeDeserializer();
    getScriptSourceParams params;
    if (!getScriptSourceParams::Deserialize(&deserializer, &params)) {
      ReportInvalidParams(dispatchable, deserializer);
      return;
    }
    // Declare output parameters.
    String out_scriptSource;
    std::optional<Binary> out_bytecode;

    std::unique_ptr<DomainDispatcher::WeakPtr> weak = weakPtr();
    DispatchResponse response = m_backend->getScriptSource(params.scriptId, &out_scriptSource, &out_bytecode);
    if (response.IsFallThrough()) {
        channel()->FallThrough(dispatchable.CallId(), v8_crdtp::SpanFrom("Debugger.getScriptSource"), dispatchable.Serialized());
        return;
    }
      if (weak->get()) {
        std::unique_ptr<v8_crdtp::Serializable> result;
        if (response.IsSuccess()) {
          v8_crdtp::ObjectSerializer serializer;
          serializer.AddField(v8_crdtp::MakeSpan("scriptSource"), out_scriptSource);
          serializer.AddField(v8_crdtp::MakeSpan("bytecode"), out_bytecode);
          result = serializer.Finish();
        } else {
          result = Serializable::From({});
        }
        weak->get()->sendResponse(dispatchable.CallId(), response, std::move(result));
      }
    return;
}

namespace {

struct disassembleWasmModuleParams : public v8_crdtp::DeserializableProtocolObject<disassembleWasmModuleParams> {
    String scriptId;
    DECLARE_DESERIALIZATION_SUPPORT();
};

V8_CRDTP_BEGIN_DESERIALIZER(disassembleWasmModuleParams)
    V8_CRDTP_DESERIALIZE_FIELD("scriptId", scriptId),
V8_CRDTP_END_DESERIALIZER()

}  // namespace

void DomainDispatcherImpl::disassembleWasmModule(const v8_crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.
    auto deserializer = v8_crdtp::DeferredMessage::FromSpan(dispatchable.Params())->MakeDeserializer();
    disassembleWasmModuleParams params;
    if (!disassembleWasmModuleParams::Deserialize(&deserializer, &params)) {
      ReportInvalidParams(dispatchable, deserializer);
      return;
    }
    // Declare output parameters.
    std::optional<String> out_streamId;
    int out_totalNumberOfLines;
    std::unique_ptr<protocol::Array<int>> out_functionBodyOffsets;
    std::unique_ptr<protocol::Debugger::WasmDisassemblyChunk> out_chunk;

    std::unique_ptr<DomainDispatcher::WeakPtr> weak = weakPtr();
    DispatchResponse response = m_backend->disassembleWasmModule(params.scriptId, &out_streamId, &out_totalNumberOfLines, &out_functionBodyOffsets, &out_chunk);
    if (response.IsFallThrough()) {
        channel()->FallThrough(dispatchable.CallId(), v8_crdtp::SpanFrom("Debugger.disassembleWasmModule"), dispatchable.Serialized());
        return;
    }
      if (weak->get()) {
        std::unique_ptr<v8_crdtp::Serializable> result;
        if (response.IsSuccess()) {
          v8_crdtp::ObjectSerializer serializer;
          serializer.AddField(v8_crdtp::MakeSpan("streamId"), out_streamId);
          serializer.AddField(v8_crdtp::MakeSpan("totalNumberOfLines"), out_totalNumberOfLines);
          serializer.AddField(v8_crdtp::MakeSpan("functionBodyOffsets"), out_functionBodyOffsets);
          serializer.AddField(v8_crdtp::MakeSpan("chunk"), out_chunk);
          result = serializer.Finish();
        } else {
          result = Serializable::From({});
        }
        weak->get()->sendResponse(dispatchable.CallId(), response, std::move(result));
      }
    return;
}

namespace {

struct nextWasmDisassemblyChunkParams : public v8_crdtp::DeserializableProtocolObject<nextWasmDisassemblyChunkParams> {
    String streamId;
    DECLARE_DESERIALIZATION_SUPPORT();
};

V8_CRDTP_BEGIN_DESERIALIZER(nextWasmDisassemblyChunkParams)
    V8_CRDTP_DESERIALIZE_FIELD("streamId", streamId),
V8_CRDTP_END_DESERIALIZER()

}  // namespace

void DomainDispatcherImpl::nextWasmDisassemblyChunk(const v8_crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.
    auto deserializer = v8_crdtp::DeferredMessage::FromSpan(dispatchable.Params())->MakeDeserializer();
    nextWasmDisassemblyChunkParams params;
    if (!nextWasmDisassemblyChunkParams::Deserialize(&deserializer, &params)) {
      ReportInvalidParams(dispatchable, deserializer);
      return;
    }
    // Declare output parameters.
    std::unique_ptr<protocol::Debugger::WasmDisassemblyChunk> out_chunk;

    std::unique_ptr<DomainDispatcher::WeakPtr> weak = weakPtr();
    DispatchResponse response = m_backend->nextWasmDisassemblyChunk(params.streamId, &out_chunk);
    if (response.IsFallThrough()) {
        channel()->FallThrough(dispatchable.CallId(), v8_crdtp::SpanFrom("Debugger.nextWasmDisassemblyChunk"), dispatchable.Serialized());
        return;
    }
      if (weak->get()) {
        std::unique_ptr<v8_crdtp::Serializable> result;
        if (response.IsSuccess()) {
          v8_crdtp::ObjectSerializer serializer;
          serializer.AddField(v8_crdtp::MakeSpan("chunk"), out_chunk);
          result = serializer.Finish();
        } else {
          result = Serializable::From({});
        }
        weak->get()->sendResponse(dispatchable.CallId(), response, std::move(result));
      }
    return;
}

namespace {

struct getWasmBytecodeParams : public v8_crdtp::DeserializableProtocolObject<getWasmBytecodeParams> {
    String scriptId;
    DECLARE_DESERIALIZATION_SUPPORT();
};

V8_CRDTP_BEGIN_DESERIALIZER(getWasmBytecodeParams)
    V8_CRDTP_DESERIALIZE_FIELD("scriptId", scriptId),
V8_CRDTP_END_DESERIALIZER()

}  // namespace

void DomainDispatcherImpl::getWasmBytecode(const v8_crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.
    auto deserializer = v8_crdtp::DeferredMessage::FromSpan(dispatchable.Params())->MakeDeserializer();
    getWasmBytecodeParams params;
    if (!getWasmBytecodeParams::Deserialize(&deserializer, &params)) {
      ReportInvalidParams(dispatchable, deserializer);
      return;
    }
    // Declare output parameters.
    Binary out_bytecode;

    std::unique_ptr<DomainDispatcher::WeakPtr> weak = weakPtr();
    DispatchResponse response = m_backend->getWasmBytecode(params.scriptId, &out_bytecode);
    if (response.IsFallThrough()) {
        channel()->FallThrough(dispatchable.CallId(), v8_crdtp::SpanFrom("Debugger.getWasmBytecode"), dispatchable.Serialized());
        return;
    }
      if (weak->get()) {
        std::unique_ptr<v8_crdtp::Serializable> result;
        if (response.IsSuccess()) {
          v8_crdtp::ObjectSerializer serializer;
          serializer.AddField(v8_crdtp::MakeSpan("bytecode"), out_bytecode);
          result = serializer.Finish();
        } else {
          result = Serializable::From({});
        }
        weak->get()->sendResponse(dispatchable.CallId(), response, std::move(result));
      }
    return;
}

namespace {

struct getStackTraceParams : public v8_crdtp::DeserializableProtocolObject<getStackTraceParams> {
    std::unique_ptr<protocol::Runtime::StackTraceId> stackTraceId;
    DECLARE_DESERIALIZATION_SUPPORT();
};

V8_CRDTP_BEGIN_DESERIALIZER(getStackTraceParams)
    V8_CRDTP_DESERIALIZE_FIELD("stackTraceId", stackTraceId),
V8_CRDTP_END_DESERIALIZER()

}  // namespace

void DomainDispatcherImpl::getStackTrace(const v8_crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.
    auto deserializer = v8_crdtp::DeferredMessage::FromSpan(dispatchable.Params())->MakeDeserializer();
    getStackTraceParams params;
    if (!getStackTraceParams::Deserialize(&deserializer, &params)) {
      ReportInvalidParams(dispatchable, deserializer);
      return;
    }
    // Declare output parameters.
    std::unique_ptr<protocol::Runtime::StackTrace> out_stackTrace;

    std::unique_ptr<DomainDispatcher::WeakPtr> weak = weakPtr();
    DispatchResponse response = m_backend->getStackTrace(std::move(params.stackTraceId), &out_stackTrace);
    if (response.IsFallThrough()) {
        channel()->FallThrough(dispatchable.CallId(), v8_crdtp::SpanFrom("Debugger.getStackTrace"), dispatchable.Serialized());
        return;
    }
      if (weak->get()) {
        std::unique_ptr<v8_crdtp::Serializable> result;
        if (response.IsSuccess()) {
          v8_crdtp::ObjectSerializer serializer;
          serializer.AddField(v8_crdtp::MakeSpan("stackTrace"), out_stackTrace);
          result = serializer.Finish();
        } else {
          result = Serializable::From({});
        }
        weak->get()->sendResponse(dispatchable.CallId(), response, std::move(result));
      }
    return;
}

namespace {


}  // namespace

void DomainDispatcherImpl::pause(const v8_crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.

    std::unique_ptr<DomainDispatcher::WeakPtr> weak = weakPtr();
    DispatchResponse response = m_backend->pause();
    if (response.IsFallThrough()) {
        channel()->FallThrough(dispatchable.CallId(), v8_crdtp::SpanFrom("Debugger.pause"), dispatchable.Serialized());
        return;
    }
    if (weak->get())
        weak->get()->sendResponse(dispatchable.CallId(), response);
    return;
}

namespace {

struct pauseOnAsyncCallParams : public v8_crdtp::DeserializableProtocolObject<pauseOnAsyncCallParams> {
    std::unique_ptr<protocol::Runtime::StackTraceId> parentStackTraceId;
    DECLARE_DESERIALIZATION_SUPPORT();
};

V8_CRDTP_BEGIN_DESERIALIZER(pauseOnAsyncCallParams)
    V8_CRDTP_DESERIALIZE_FIELD("parentStackTraceId", parentStackTraceId),
V8_CRDTP_END_DESERIALIZER()

}  // namespace

void DomainDispatcherImpl::pauseOnAsyncCall(const v8_crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.
    auto deserializer = v8_crdtp::DeferredMessage::FromSpan(dispatchable.Params())->MakeDeserializer();
    pauseOnAsyncCallParams params;
    if (!pauseOnAsyncCallParams::Deserialize(&deserializer, &params)) {
      ReportInvalidParams(dispatchable, deserializer);
      return;
    }

    std::unique_ptr<DomainDispatcher::WeakPtr> weak = weakPtr();
    DispatchResponse response = m_backend->pauseOnAsyncCall(std::move(params.parentStackTraceId));
    if (response.IsFallThrough()) {
        channel()->FallThrough(dispatchable.CallId(), v8_crdtp::SpanFrom("Debugger.pauseOnAsyncCall"), dispatchable.Serialized());
        return;
    }
    if (weak->get())
        weak->get()->sendResponse(dispatchable.CallId(), response);
    return;
}

namespace {

struct removeBreakpointParams : public v8_crdtp::DeserializableProtocolObject<removeBreakpointParams> {
    String breakpointId;
    DECLARE_DESERIALIZATION_SUPPORT();
};

V8_CRDTP_BEGIN_DESERIALIZER(removeBreakpointParams)
    V8_CRDTP_DESERIALIZE_FIELD("breakpointId", breakpointId),
V8_CRDTP_END_DESERIALIZER()

}  // namespace

void DomainDispatcherImpl::removeBreakpoint(const v8_crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.
    auto deserializer = v8_crdtp::DeferredMessage::FromSpan(dispatchable.Params())->MakeDeserializer();
    removeBreakpointParams params;
    if (!removeBreakpointParams::Deserialize(&deserializer, &params)) {
      ReportInvalidParams(dispatchable, deserializer);
      return;
    }

    std::unique_ptr<DomainDispatcher::WeakPtr> weak = weakPtr();
    DispatchResponse response = m_backend->removeBreakpoint(params.breakpointId);
    if (response.IsFallThrough()) {
        channel()->FallThrough(dispatchable.CallId(), v8_crdtp::SpanFrom("Debugger.removeBreakpoint"), dispatchable.Serialized());
        return;
    }
    if (weak->get())
        weak->get()->sendResponse(dispatchable.CallId(), response);
    return;
}

namespace {

struct restartFrameParams : public v8_crdtp::DeserializableProtocolObject<restartFrameParams> {
    String callFrameId;
    std::optional<String> mode;
    DECLARE_DESERIALIZATION_SUPPORT();
};

V8_CRDTP_BEGIN_DESERIALIZER(restartFrameParams)
    V8_CRDTP_DESERIALIZE_FIELD("callFrameId", callFrameId),
    V8_CRDTP_DESERIALIZE_FIELD_OPT("mode", mode),
V8_CRDTP_END_DESERIALIZER()

}  // namespace

void DomainDispatcherImpl::restartFrame(const v8_crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.
    auto deserializer = v8_crdtp::DeferredMessage::FromSpan(dispatchable.Params())->MakeDeserializer();
    restartFrameParams params;
    if (!restartFrameParams::Deserialize(&deserializer, &params)) {
      ReportInvalidParams(dispatchable, deserializer);
      return;
    }
    // Declare output parameters.
    std::unique_ptr<protocol::Array<protocol::Debugger::CallFrame>> out_callFrames;
    std::unique_ptr<protocol::Runtime::StackTrace> out_asyncStackTrace;
    std::unique_ptr<protocol::Runtime::StackTraceId> out_asyncStackTraceId;

    std::unique_ptr<DomainDispatcher::WeakPtr> weak = weakPtr();
    DispatchResponse response = m_backend->restartFrame(params.callFrameId, std::move(params.mode), &out_callFrames, &out_asyncStackTrace, &out_asyncStackTraceId);
    if (response.IsFallThrough()) {
        channel()->FallThrough(dispatchable.CallId(), v8_crdtp::SpanFrom("Debugger.restartFrame"), dispatchable.Serialized());
        return;
    }
      if (weak->get()) {
        std::unique_ptr<v8_crdtp::Serializable> result;
        if (response.IsSuccess()) {
          v8_crdtp::ObjectSerializer serializer;
          serializer.AddField(v8_crdtp::MakeSpan("callFrames"), out_callFrames);
          serializer.AddField(v8_crdtp::MakeSpan("asyncStackTrace"), out_asyncStackTrace);
          serializer.AddField(v8_crdtp::MakeSpan("asyncStackTraceId"), out_asyncStackTraceId);
          result = serializer.Finish();
        } else {
          result = Serializable::From({});
        }
        weak->get()->sendResponse(dispatchable.CallId(), response, std::move(result));
      }
    return;
}

namespace {

struct resumeParams : public v8_crdtp::DeserializableProtocolObject<resumeParams> {
    std::optional<bool> terminateOnResume;
    DECLARE_DESERIALIZATION_SUPPORT();
};

V8_CRDTP_BEGIN_DESERIALIZER(resumeParams)
    V8_CRDTP_DESERIALIZE_FIELD_OPT("terminateOnResume", terminateOnResume),
V8_CRDTP_END_DESERIALIZER()

}  // namespace

void DomainDispatcherImpl::resume(const v8_crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.
    auto deserializer = v8_crdtp::DeferredMessage::FromSpan(dispatchable.Params())->MakeDeserializer();
    resumeParams params;
    if (!resumeParams::Deserialize(&deserializer, &params)) {
      ReportInvalidParams(dispatchable, deserializer);
      return;
    }

    std::unique_ptr<DomainDispatcher::WeakPtr> weak = weakPtr();
    DispatchResponse response = m_backend->resume(std::move(params.terminateOnResume));
    if (response.IsFallThrough()) {
        channel()->FallThrough(dispatchable.CallId(), v8_crdtp::SpanFrom("Debugger.resume"), dispatchable.Serialized());
        return;
    }
    if (weak->get())
        weak->get()->sendResponse(dispatchable.CallId(), response);
    return;
}

namespace {

struct searchInContentParams : public v8_crdtp::DeserializableProtocolObject<searchInContentParams> {
    String scriptId;
    String query;
    std::optional<bool> caseSensitive;
    std::optional<bool> isRegex;
    DECLARE_DESERIALIZATION_SUPPORT();
};

V8_CRDTP_BEGIN_DESERIALIZER(searchInContentParams)
    V8_CRDTP_DESERIALIZE_FIELD_OPT("caseSensitive", caseSensitive),
    V8_CRDTP_DESERIALIZE_FIELD_OPT("isRegex", isRegex),
    V8_CRDTP_DESERIALIZE_FIELD("query", query),
    V8_CRDTP_DESERIALIZE_FIELD("scriptId", scriptId),
V8_CRDTP_END_DESERIALIZER()

}  // namespace

void DomainDispatcherImpl::searchInContent(const v8_crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.
    auto deserializer = v8_crdtp::DeferredMessage::FromSpan(dispatchable.Params())->MakeDeserializer();
    searchInContentParams params;
    if (!searchInContentParams::Deserialize(&deserializer, &params)) {
      ReportInvalidParams(dispatchable, deserializer);
      return;
    }
    // Declare output parameters.
    std::unique_ptr<protocol::Array<protocol::Debugger::SearchMatch>> out_result;

    std::unique_ptr<DomainDispatcher::WeakPtr> weak = weakPtr();
    DispatchResponse response = m_backend->searchInContent(params.scriptId, params.query, std::move(params.caseSensitive), std::move(params.isRegex), &out_result);
    if (response.IsFallThrough()) {
        channel()->FallThrough(dispatchable.CallId(), v8_crdtp::SpanFrom("Debugger.searchInContent"), dispatchable.Serialized());
        return;
    }
      if (weak->get()) {
        std::unique_ptr<v8_crdtp::Serializable> result;
        if (response.IsSuccess()) {
          v8_crdtp::ObjectSerializer serializer;
          serializer.AddField(v8_crdtp::MakeSpan("result"), out_result);
          result = serializer.Finish();
        } else {
          result = Serializable::From({});
        }
        weak->get()->sendResponse(dispatchable.CallId(), response, std::move(result));
      }
    return;
}

namespace {

struct setAsyncCallStackDepthParams : public v8_crdtp::DeserializableProtocolObject<setAsyncCallStackDepthParams> {
    int maxDepth;
    DECLARE_DESERIALIZATION_SUPPORT();
};

V8_CRDTP_BEGIN_DESERIALIZER(setAsyncCallStackDepthParams)
    V8_CRDTP_DESERIALIZE_FIELD("maxDepth", maxDepth),
V8_CRDTP_END_DESERIALIZER()

}  // namespace

void DomainDispatcherImpl::setAsyncCallStackDepth(const v8_crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.
    auto deserializer = v8_crdtp::DeferredMessage::FromSpan(dispatchable.Params())->MakeDeserializer();
    setAsyncCallStackDepthParams params;
    if (!setAsyncCallStackDepthParams::Deserialize(&deserializer, &params)) {
      ReportInvalidParams(dispatchable, deserializer);
      return;
    }

    std::unique_ptr<DomainDispatcher::WeakPtr> weak = weakPtr();
    DispatchResponse response = m_backend->setAsyncCallStackDepth(params.maxDepth);
    if (response.IsFallThrough()) {
        channel()->FallThrough(dispatchable.CallId(), v8_crdtp::SpanFrom("Debugger.setAsyncCallStackDepth"), dispatchable.Serialized());
        return;
    }
    if (weak->get())
        weak->get()->sendResponse(dispatchable.CallId(), response);
    return;
}

namespace {

struct setBlackboxExecutionContextsParams : public v8_crdtp::DeserializableProtocolObject<setBlackboxExecutionContextsParams> {
    std::unique_ptr<protocol::Array<String>> uniqueIds;
    DECLARE_DESERIALIZATION_SUPPORT();
};

V8_CRDTP_BEGIN_DESERIALIZER(setBlackboxExecutionContextsParams)
    V8_CRDTP_DESERIALIZE_FIELD("uniqueIds", uniqueIds),
V8_CRDTP_END_DESERIALIZER()

}  // namespace

void DomainDispatcherImpl::setBlackboxExecutionContexts(const v8_crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.
    auto deserializer = v8_crdtp::DeferredMessage::FromSpan(dispatchable.Params())->MakeDeserializer();
    setBlackboxExecutionContextsParams params;
    if (!setBlackboxExecutionContextsParams::Deserialize(&deserializer, &params)) {
      ReportInvalidParams(dispatchable, deserializer);
      return;
    }

    std::unique_ptr<DomainDispatcher::WeakPtr> weak = weakPtr();
    DispatchResponse response = m_backend->setBlackboxExecutionContexts(std::move(params.uniqueIds));
    if (response.IsFallThrough()) {
        channel()->FallThrough(dispatchable.CallId(), v8_crdtp::SpanFrom("Debugger.setBlackboxExecutionContexts"), dispatchable.Serialized());
        return;
    }
    if (weak->get())
        weak->get()->sendResponse(dispatchable.CallId(), response);
    return;
}

namespace {

struct setBlackboxPatternsParams : public v8_crdtp::DeserializableProtocolObject<setBlackboxPatternsParams> {
    std::unique_ptr<protocol::Array<String>> patterns;
    std::optional<bool> skipAnonymous;
    DECLARE_DESERIALIZATION_SUPPORT();
};

V8_CRDTP_BEGIN_DESERIALIZER(setBlackboxPatternsParams)
    V8_CRDTP_DESERIALIZE_FIELD("patterns", patterns),
    V8_CRDTP_DESERIALIZE_FIELD_OPT("skipAnonymous", skipAnonymous),
V8_CRDTP_END_DESERIALIZER()

}  // namespace

void DomainDispatcherImpl::setBlackboxPatterns(const v8_crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.
    auto deserializer = v8_crdtp::DeferredMessage::FromSpan(dispatchable.Params())->MakeDeserializer();
    setBlackboxPatternsParams params;
    if (!setBlackboxPatternsParams::Deserialize(&deserializer, &params)) {
      ReportInvalidParams(dispatchable, deserializer);
      return;
    }

    std::unique_ptr<DomainDispatcher::WeakPtr> weak = weakPtr();
    DispatchResponse response = m_backend->setBlackboxPatterns(std::move(params.patterns), std::move(params.skipAnonymous));
    if (response.IsFallThrough()) {
        channel()->FallThrough(dispatchable.CallId(), v8_crdtp::SpanFrom("Debugger.setBlackboxPatterns"), dispatchable.Serialized());
        return;
    }
    if (weak->get())
        weak->get()->sendResponse(dispatchable.CallId(), response);
    return;
}

namespace {

struct setBlackboxedRangesParams : public v8_crdtp::DeserializableProtocolObject<setBlackboxedRangesParams> {
    String scriptId;
    std::unique_ptr<protocol::Array<protocol::Debugger::ScriptPosition>> positions;
    DECLARE_DESERIALIZATION_SUPPORT();
};

V8_CRDTP_BEGIN_DESERIALIZER(setBlackboxedRangesParams)
    V8_CRDTP_DESERIALIZE_FIELD("positions", positions),
    V8_CRDTP_DESERIALIZE_FIELD("scriptId", scriptId),
V8_CRDTP_END_DESERIALIZER()

}  // namespace

void DomainDispatcherImpl::setBlackboxedRanges(const v8_crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.
    auto deserializer = v8_crdtp::DeferredMessage::FromSpan(dispatchable.Params())->MakeDeserializer();
    setBlackboxedRangesParams params;
    if (!setBlackboxedRangesParams::Deserialize(&deserializer, &params)) {
      ReportInvalidParams(dispatchable, deserializer);
      return;
    }

    std::unique_ptr<DomainDispatcher::WeakPtr> weak = weakPtr();
    DispatchResponse response = m_backend->setBlackboxedRanges(params.scriptId, std::move(params.positions));
    if (response.IsFallThrough()) {
        channel()->FallThrough(dispatchable.CallId(), v8_crdtp::SpanFrom("Debugger.setBlackboxedRanges"), dispatchable.Serialized());
        return;
    }
    if (weak->get())
        weak->get()->sendResponse(dispatchable.CallId(), response);
    return;
}

namespace {

struct setBreakpointParams : public v8_crdtp::DeserializableProtocolObject<setBreakpointParams> {
    std::unique_ptr<protocol::Debugger::Location> location;
    std::optional<String> condition;
    DECLARE_DESERIALIZATION_SUPPORT();
};

V8_CRDTP_BEGIN_DESERIALIZER(setBreakpointParams)
    V8_CRDTP_DESERIALIZE_FIELD_OPT("condition", condition),
    V8_CRDTP_DESERIALIZE_FIELD("location", location),
V8_CRDTP_END_DESERIALIZER()

}  // namespace

void DomainDispatcherImpl::setBreakpoint(const v8_crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.
    auto deserializer = v8_crdtp::DeferredMessage::FromSpan(dispatchable.Params())->MakeDeserializer();
    setBreakpointParams params;
    if (!setBreakpointParams::Deserialize(&deserializer, &params)) {
      ReportInvalidParams(dispatchable, deserializer);
      return;
    }
    // Declare output parameters.
    String out_breakpointId;
    std::unique_ptr<protocol::Debugger::Location> out_actualLocation;

    std::unique_ptr<DomainDispatcher::WeakPtr> weak = weakPtr();
    DispatchResponse response = m_backend->setBreakpoint(std::move(params.location), std::move(params.condition), &out_breakpointId, &out_actualLocation);
    if (response.IsFallThrough()) {
        channel()->FallThrough(dispatchable.CallId(), v8_crdtp::SpanFrom("Debugger.setBreakpoint"), dispatchable.Serialized());
        return;
    }
      if (weak->get()) {
        std::unique_ptr<v8_crdtp::Serializable> result;
        if (response.IsSuccess()) {
          v8_crdtp::ObjectSerializer serializer;
          serializer.AddField(v8_crdtp::MakeSpan("breakpointId"), out_breakpointId);
          serializer.AddField(v8_crdtp::MakeSpan("actualLocation"), out_actualLocation);
          result = serializer.Finish();
        } else {
          result = Serializable::From({});
        }
        weak->get()->sendResponse(dispatchable.CallId(), response, std::move(result));
      }
    return;
}

namespace {

struct setInstrumentationBreakpointParams : public v8_crdtp::DeserializableProtocolObject<setInstrumentationBreakpointParams> {
    String instrumentation;
    DECLARE_DESERIALIZATION_SUPPORT();
};

V8_CRDTP_BEGIN_DESERIALIZER(setInstrumentationBreakpointParams)
    V8_CRDTP_DESERIALIZE_FIELD("instrumentation", instrumentation),
V8_CRDTP_END_DESERIALIZER()

}  // namespace

void DomainDispatcherImpl::setInstrumentationBreakpoint(const v8_crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.
    auto deserializer = v8_crdtp::DeferredMessage::FromSpan(dispatchable.Params())->MakeDeserializer();
    setInstrumentationBreakpointParams params;
    if (!setInstrumentationBreakpointParams::Deserialize(&deserializer, &params)) {
      ReportInvalidParams(dispatchable, deserializer);
      return;
    }
    // Declare output parameters.
    String out_breakpointId;

    std::unique_ptr<DomainDispatcher::WeakPtr> weak = weakPtr();
    DispatchResponse response = m_backend->setInstrumentationBreakpoint(params.instrumentation, &out_breakpointId);
    if (response.IsFallThrough()) {
        channel()->FallThrough(dispatchable.CallId(), v8_crdtp::SpanFrom("Debugger.setInstrumentationBreakpoint"), dispatchable.Serialized());
        return;
    }
      if (weak->get()) {
        std::unique_ptr<v8_crdtp::Serializable> result;
        if (response.IsSuccess()) {
          v8_crdtp::ObjectSerializer serializer;
          serializer.AddField(v8_crdtp::MakeSpan("breakpointId"), out_breakpointId);
          result = serializer.Finish();
        } else {
          result = Serializable::From({});
        }
        weak->get()->sendResponse(dispatchable.CallId(), response, std::move(result));
      }
    return;
}

namespace {

struct setBreakpointByUrlParams : public v8_crdtp::DeserializableProtocolObject<setBreakpointByUrlParams> {
    int lineNumber;
    std::optional<String> url;
    std::optional<String> urlRegex;
    std::optional<String> scriptHash;
    std::optional<int> columnNumber;
    std::optional<String> condition;
    DECLARE_DESERIALIZATION_SUPPORT();
};

V8_CRDTP_BEGIN_DESERIALIZER(setBreakpointByUrlParams)
    V8_CRDTP_DESERIALIZE_FIELD_OPT("columnNumber", columnNumber),
    V8_CRDTP_DESERIALIZE_FIELD_OPT("condition", condition),
    V8_CRDTP_DESERIALIZE_FIELD("lineNumber", lineNumber),
    V8_CRDTP_DESERIALIZE_FIELD_OPT("scriptHash", scriptHash),
    V8_CRDTP_DESERIALIZE_FIELD_OPT("url", url),
    V8_CRDTP_DESERIALIZE_FIELD_OPT("urlRegex", urlRegex),
V8_CRDTP_END_DESERIALIZER()

}  // namespace

void DomainDispatcherImpl::setBreakpointByUrl(const v8_crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.
    auto deserializer = v8_crdtp::DeferredMessage::FromSpan(dispatchable.Params())->MakeDeserializer();
    setBreakpointByUrlParams params;
    if (!setBreakpointByUrlParams::Deserialize(&deserializer, &params)) {
      ReportInvalidParams(dispatchable, deserializer);
      return;
    }
    // Declare output parameters.
    String out_breakpointId;
    std::unique_ptr<protocol::Array<protocol::Debugger::Location>> out_locations;

    std::unique_ptr<DomainDispatcher::WeakPtr> weak = weakPtr();
    DispatchResponse response = m_backend->setBreakpointByUrl(params.lineNumber, std::move(params.url), std::move(params.urlRegex), std::move(params.scriptHash), std::move(params.columnNumber), std::move(params.condition), &out_breakpointId, &out_locations);
    if (response.IsFallThrough()) {
        channel()->FallThrough(dispatchable.CallId(), v8_crdtp::SpanFrom("Debugger.setBreakpointByUrl"), dispatchable.Serialized());
        return;
    }
      if (weak->get()) {
        std::unique_ptr<v8_crdtp::Serializable> result;
        if (response.IsSuccess()) {
          v8_crdtp::ObjectSerializer serializer;
          serializer.AddField(v8_crdtp::MakeSpan("breakpointId"), out_breakpointId);
          serializer.AddField(v8_crdtp::MakeSpan("locations"), out_locations);
          result = serializer.Finish();
        } else {
          result = Serializable::From({});
        }
        weak->get()->sendResponse(dispatchable.CallId(), response, std::move(result));
      }
    return;
}

namespace {

struct setBreakpointOnFunctionCallParams : public v8_crdtp::DeserializableProtocolObject<setBreakpointOnFunctionCallParams> {
    String objectId;
    std::optional<String> condition;
    DECLARE_DESERIALIZATION_SUPPORT();
};

V8_CRDTP_BEGIN_DESERIALIZER(setBreakpointOnFunctionCallParams)
    V8_CRDTP_DESERIALIZE_FIELD_OPT("condition", condition),
    V8_CRDTP_DESERIALIZE_FIELD("objectId", objectId),
V8_CRDTP_END_DESERIALIZER()

}  // namespace

void DomainDispatcherImpl::setBreakpointOnFunctionCall(const v8_crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.
    auto deserializer = v8_crdtp::DeferredMessage::FromSpan(dispatchable.Params())->MakeDeserializer();
    setBreakpointOnFunctionCallParams params;
    if (!setBreakpointOnFunctionCallParams::Deserialize(&deserializer, &params)) {
      ReportInvalidParams(dispatchable, deserializer);
      return;
    }
    // Declare output parameters.
    String out_breakpointId;

    std::unique_ptr<DomainDispatcher::WeakPtr> weak = weakPtr();
    DispatchResponse response = m_backend->setBreakpointOnFunctionCall(params.objectId, std::move(params.condition), &out_breakpointId);
    if (response.IsFallThrough()) {
        channel()->FallThrough(dispatchable.CallId(), v8_crdtp::SpanFrom("Debugger.setBreakpointOnFunctionCall"), dispatchable.Serialized());
        return;
    }
      if (weak->get()) {
        std::unique_ptr<v8_crdtp::Serializable> result;
        if (response.IsSuccess()) {
          v8_crdtp::ObjectSerializer serializer;
          serializer.AddField(v8_crdtp::MakeSpan("breakpointId"), out_breakpointId);
          result = serializer.Finish();
        } else {
          result = Serializable::From({});
        }
        weak->get()->sendResponse(dispatchable.CallId(), response, std::move(result));
      }
    return;
}

namespace {

struct setBreakpointsActiveParams : public v8_crdtp::DeserializableProtocolObject<setBreakpointsActiveParams> {
    bool active;
    DECLARE_DESERIALIZATION_SUPPORT();
};

V8_CRDTP_BEGIN_DESERIALIZER(setBreakpointsActiveParams)
    V8_CRDTP_DESERIALIZE_FIELD("active", active),
V8_CRDTP_END_DESERIALIZER()

}  // namespace

void DomainDispatcherImpl::setBreakpointsActive(const v8_crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.
    auto deserializer = v8_crdtp::DeferredMessage::FromSpan(dispatchable.Params())->MakeDeserializer();
    setBreakpointsActiveParams params;
    if (!setBreakpointsActiveParams::Deserialize(&deserializer, &params)) {
      ReportInvalidParams(dispatchable, deserializer);
      return;
    }

    std::unique_ptr<DomainDispatcher::WeakPtr> weak = weakPtr();
    DispatchResponse response = m_backend->setBreakpointsActive(params.active);
    if (response.IsFallThrough()) {
        channel()->FallThrough(dispatchable.CallId(), v8_crdtp::SpanFrom("Debugger.setBreakpointsActive"), dispatchable.Serialized());
        return;
    }
    if (weak->get())
        weak->get()->sendResponse(dispatchable.CallId(), response);
    return;
}

namespace {

struct setPauseOnExceptionsParams : public v8_crdtp::DeserializableProtocolObject<setPauseOnExceptionsParams> {
    String state;
    DECLARE_DESERIALIZATION_SUPPORT();
};

V8_CRDTP_BEGIN_DESERIALIZER(setPauseOnExceptionsParams)
    V8_CRDTP_DESERIALIZE_FIELD("state", state),
V8_CRDTP_END_DESERIALIZER()

}  // namespace

void DomainDispatcherImpl::setPauseOnExceptions(const v8_crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.
    auto deserializer = v8_crdtp::DeferredMessage::FromSpan(dispatchable.Params())->MakeDeserializer();
    setPauseOnExceptionsParams params;
    if (!setPauseOnExceptionsParams::Deserialize(&deserializer, &params)) {
      ReportInvalidParams(dispatchable, deserializer);
      return;
    }

    std::unique_ptr<DomainDispatcher::WeakPtr> weak = weakPtr();
    DispatchResponse response = m_backend->setPauseOnExceptions(params.state);
    if (response.IsFallThrough()) {
        channel()->FallThrough(dispatchable.CallId(), v8_crdtp::SpanFrom("Debugger.setPauseOnExceptions"), dispatchable.Serialized());
        return;
    }
    if (weak->get())
        weak->get()->sendResponse(dispatchable.CallId(), response);
    return;
}

namespace {

struct setReturnValueParams : public v8_crdtp::DeserializableProtocolObject<setReturnValueParams> {
    std::unique_ptr<protocol::Runtime::CallArgument> newValue;
    DECLARE_DESERIALIZATION_SUPPORT();
};

V8_CRDTP_BEGIN_DESERIALIZER(setReturnValueParams)
    V8_CRDTP_DESERIALIZE_FIELD("newValue", newValue),
V8_CRDTP_END_DESERIALIZER()

}  // namespace

void DomainDispatcherImpl::setReturnValue(const v8_crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.
    auto deserializer = v8_crdtp::DeferredMessage::FromSpan(dispatchable.Params())->MakeDeserializer();
    setReturnValueParams params;
    if (!setReturnValueParams::Deserialize(&deserializer, &params)) {
      ReportInvalidParams(dispatchable, deserializer);
      return;
    }

    std::unique_ptr<DomainDispatcher::WeakPtr> weak = weakPtr();
    DispatchResponse response = m_backend->setReturnValue(std::move(params.newValue));
    if (response.IsFallThrough()) {
        channel()->FallThrough(dispatchable.CallId(), v8_crdtp::SpanFrom("Debugger.setReturnValue"), dispatchable.Serialized());
        return;
    }
    if (weak->get())
        weak->get()->sendResponse(dispatchable.CallId(), response);
    return;
}

namespace {

struct setScriptSourceParams : public v8_crdtp::DeserializableProtocolObject<setScriptSourceParams> {
    String scriptId;
    String scriptSource;
    std::optional<bool> dryRun;
    std::optional<bool> allowTopFrameEditing;
    DECLARE_DESERIALIZATION_SUPPORT();
};

V8_CRDTP_BEGIN_DESERIALIZER(setScriptSourceParams)
    V8_CRDTP_DESERIALIZE_FIELD_OPT("allowTopFrameEditing", allowTopFrameEditing),
    V8_CRDTP_DESERIALIZE_FIELD_OPT("dryRun", dryRun),
    V8_CRDTP_DESERIALIZE_FIELD("scriptId", scriptId),
    V8_CRDTP_DESERIALIZE_FIELD("scriptSource", scriptSource),
V8_CRDTP_END_DESERIALIZER()

}  // namespace

void DomainDispatcherImpl::setScriptSource(const v8_crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.
    auto deserializer = v8_crdtp::DeferredMessage::FromSpan(dispatchable.Params())->MakeDeserializer();
    setScriptSourceParams params;
    if (!setScriptSourceParams::Deserialize(&deserializer, &params)) {
      ReportInvalidParams(dispatchable, deserializer);
      return;
    }
    // Declare output parameters.
    std::unique_ptr<protocol::Array<protocol::Debugger::CallFrame>> out_callFrames;
    std::optional<bool> out_stackChanged;
    std::unique_ptr<protocol::Runtime::StackTrace> out_asyncStackTrace;
    std::unique_ptr<protocol::Runtime::StackTraceId> out_asyncStackTraceId;
    String out_status;
    std::unique_ptr<protocol::Runtime::ExceptionDetails> out_exceptionDetails;

    std::unique_ptr<DomainDispatcher::WeakPtr> weak = weakPtr();
    DispatchResponse response = m_backend->setScriptSource(params.scriptId, params.scriptSource, std::move(params.dryRun), std::move(params.allowTopFrameEditing), &out_callFrames, &out_stackChanged, &out_asyncStackTrace, &out_asyncStackTraceId, &out_status, &out_exceptionDetails);
    if (response.IsFallThrough()) {
        channel()->FallThrough(dispatchable.CallId(), v8_crdtp::SpanFrom("Debugger.setScriptSource"), dispatchable.Serialized());
        return;
    }
      if (weak->get()) {
        std::unique_ptr<v8_crdtp::Serializable> result;
        if (response.IsSuccess()) {
          v8_crdtp::ObjectSerializer serializer;
          serializer.AddField(v8_crdtp::MakeSpan("callFrames"), out_callFrames);
          serializer.AddField(v8_crdtp::MakeSpan("stackChanged"), out_stackChanged);
          serializer.AddField(v8_crdtp::MakeSpan("asyncStackTrace"), out_asyncStackTrace);
          serializer.AddField(v8_crdtp::MakeSpan("asyncStackTraceId"), out_asyncStackTraceId);
          serializer.AddField(v8_crdtp::MakeSpan("status"), out_status);
          serializer.AddField(v8_crdtp::MakeSpan("exceptionDetails"), out_exceptionDetails);
          result = serializer.Finish();
        } else {
          result = Serializable::From({});
        }
        weak->get()->sendResponse(dispatchable.CallId(), response, std::move(result));
      }
    return;
}

namespace {

struct setSkipAllPausesParams : public v8_crdtp::DeserializableProtocolObject<setSkipAllPausesParams> {
    bool skip;
    DECLARE_DESERIALIZATION_SUPPORT();
};

V8_CRDTP_BEGIN_DESERIALIZER(setSkipAllPausesParams)
    V8_CRDTP_DESERIALIZE_FIELD("skip", skip),
V8_CRDTP_END_DESERIALIZER()

}  // namespace

void DomainDispatcherImpl::setSkipAllPauses(const v8_crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.
    auto deserializer = v8_crdtp::DeferredMessage::FromSpan(dispatchable.Params())->MakeDeserializer();
    setSkipAllPausesParams params;
    if (!setSkipAllPausesParams::Deserialize(&deserializer, &params)) {
      ReportInvalidParams(dispatchable, deserializer);
      return;
    }

    std::unique_ptr<DomainDispatcher::WeakPtr> weak = weakPtr();
    DispatchResponse response = m_backend->setSkipAllPauses(params.skip);
    if (response.IsFallThrough()) {
        channel()->FallThrough(dispatchable.CallId(), v8_crdtp::SpanFrom("Debugger.setSkipAllPauses"), dispatchable.Serialized());
        return;
    }
    if (weak->get())
        weak->get()->sendResponse(dispatchable.CallId(), response);
    return;
}

namespace {

struct setVariableValueParams : public v8_crdtp::DeserializableProtocolObject<setVariableValueParams> {
    int scopeNumber;
    String variableName;
    std::unique_ptr<protocol::Runtime::CallArgument> newValue;
    String callFrameId;
    DECLARE_DESERIALIZATION_SUPPORT();
};

V8_CRDTP_BEGIN_DESERIALIZER(setVariableValueParams)
    V8_CRDTP_DESERIALIZE_FIELD("callFrameId", callFrameId),
    V8_CRDTP_DESERIALIZE_FIELD("newValue", newValue),
    V8_CRDTP_DESERIALIZE_FIELD("scopeNumber", scopeNumber),
    V8_CRDTP_DESERIALIZE_FIELD("variableName", variableName),
V8_CRDTP_END_DESERIALIZER()

}  // namespace

void DomainDispatcherImpl::setVariableValue(const v8_crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.
    auto deserializer = v8_crdtp::DeferredMessage::FromSpan(dispatchable.Params())->MakeDeserializer();
    setVariableValueParams params;
    if (!setVariableValueParams::Deserialize(&deserializer, &params)) {
      ReportInvalidParams(dispatchable, deserializer);
      return;
    }

    std::unique_ptr<DomainDispatcher::WeakPtr> weak = weakPtr();
    DispatchResponse response = m_backend->setVariableValue(params.scopeNumber, params.variableName, std::move(params.newValue), params.callFrameId);
    if (response.IsFallThrough()) {
        channel()->FallThrough(dispatchable.CallId(), v8_crdtp::SpanFrom("Debugger.setVariableValue"), dispatchable.Serialized());
        return;
    }
    if (weak->get())
        weak->get()->sendResponse(dispatchable.CallId(), response);
    return;
}

namespace {

struct stepIntoParams : public v8_crdtp::DeserializableProtocolObject<stepIntoParams> {
    std::optional<bool> breakOnAsyncCall;
    std::unique_ptr<protocol::Array<protocol::Debugger::LocationRange>> skipList;
    DECLARE_DESERIALIZATION_SUPPORT();
};

V8_CRDTP_BEGIN_DESERIALIZER(stepIntoParams)
    V8_CRDTP_DESERIALIZE_FIELD_OPT("breakOnAsyncCall", breakOnAsyncCall),
    V8_CRDTP_DESERIALIZE_FIELD_OPT("skipList", skipList),
V8_CRDTP_END_DESERIALIZER()

}  // namespace

void DomainDispatcherImpl::stepInto(const v8_crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.
    auto deserializer = v8_crdtp::DeferredMessage::FromSpan(dispatchable.Params())->MakeDeserializer();
    stepIntoParams params;
    if (!stepIntoParams::Deserialize(&deserializer, &params)) {
      ReportInvalidParams(dispatchable, deserializer);
      return;
    }

    std::unique_ptr<DomainDispatcher::WeakPtr> weak = weakPtr();
    DispatchResponse response = m_backend->stepInto(std::move(params.breakOnAsyncCall), std::move(params.skipList));
    if (response.IsFallThrough()) {
        channel()->FallThrough(dispatchable.CallId(), v8_crdtp::SpanFrom("Debugger.stepInto"), dispatchable.Serialized());
        return;
    }
    if (weak->get())
        weak->get()->sendResponse(dispatchable.CallId(), response);
    return;
}

namespace {


}  // namespace

void DomainDispatcherImpl::stepOut(const v8_crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.

    std::unique_ptr<DomainDispatcher::WeakPtr> weak = weakPtr();
    DispatchResponse response = m_backend->stepOut();
    if (response.IsFallThrough()) {
        channel()->FallThrough(dispatchable.CallId(), v8_crdtp::SpanFrom("Debugger.stepOut"), dispatchable.Serialized());
        return;
    }
    if (weak->get())
        weak->get()->sendResponse(dispatchable.CallId(), response);
    return;
}

namespace {

struct stepOverParams : public v8_crdtp::DeserializableProtocolObject<stepOverParams> {
    std::unique_ptr<protocol::Array<protocol::Debugger::LocationRange>> skipList;
    DECLARE_DESERIALIZATION_SUPPORT();
};

V8_CRDTP_BEGIN_DESERIALIZER(stepOverParams)
    V8_CRDTP_DESERIALIZE_FIELD_OPT("skipList", skipList),
V8_CRDTP_END_DESERIALIZER()

}  // namespace

void DomainDispatcherImpl::stepOver(const v8_crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.
    auto deserializer = v8_crdtp::DeferredMessage::FromSpan(dispatchable.Params())->MakeDeserializer();
    stepOverParams params;
    if (!stepOverParams::Deserialize(&deserializer, &params)) {
      ReportInvalidParams(dispatchable, deserializer);
      return;
    }

    std::unique_ptr<DomainDispatcher::WeakPtr> weak = weakPtr();
    DispatchResponse response = m_backend->stepOver(std::move(params.skipList));
    if (response.IsFallThrough()) {
        channel()->FallThrough(dispatchable.CallId(), v8_crdtp::SpanFrom("Debugger.stepOver"), dispatchable.Serialized());
        return;
    }
    if (weak->get())
        weak->get()->sendResponse(dispatchable.CallId(), response);
    return;
}

namespace {
// This helper method (with a static map of redirects) is used from Dispatcher::wire
// immediately below.
const std::vector<std::pair<v8_crdtp::span<uint8_t>, v8_crdtp::span<uint8_t>>>& SortedRedirects() {
  static auto* redirects = [](){
    auto* redirects = new std::vector<std::pair<v8_crdtp::span<uint8_t>, v8_crdtp::span<uint8_t>>>{
    };
    return redirects;
  }();
  return *redirects;
}
}  // namespace

// static
void Dispatcher::wire(UberDispatcher* uber, Backend* backend)
{
    auto dispatcher = std::make_unique<DomainDispatcherImpl>(uber->channel(), backend);
    uber->WireBackend(v8_crdtp::SpanFrom("Debugger"), SortedRedirects(), std::move(dispatcher));
}

} // Debugger
} // namespace v8_inspector
} // namespace protocol
