/*
 SPDX-License-Identifier: GPL-3.0-or-later
 myMPD (c) 2018-2026 Juergen Mang <mail@jcgames.de>
 https://github.com/jcorporation/mympd
*/

/*! \file
 * \brief Search implementation
 */

#ifndef MYMPD_LIB_SEARCH_H
#define MYMPD_LIB_SEARCH_H

#include "src/lib/album.h"
#include "src/lib/fields.h"
#include "src/lib/mpdclient.h"
#include "src/lib/webradio.h"

#include <stdbool.h>

/**
 * Types of struct to search
 */
enum search_type {
    SEARCH_TYPE_SONG,
    SEARCH_TYPE_WEBRADIO
};

struct t_list *search_expression_parse(const char *expression, enum search_type type);
void search_expression_free(struct t_list *expr_list);
bool search_expression_song(const struct mpd_song *song, const struct t_list *expr_list, const struct t_mympd_mpd_tags *any_tag_types);
bool search_expression_album(const struct t_album *album, const struct t_list *expr_list, const struct t_mympd_mpd_tags *any_tag_types);
bool search_expression_webradio(const struct t_webradio_data *webradio, const struct t_list *expr_list, const struct t_webradio_tags *any_tag_types);

#endif
