/* This file is autogenerated by build-utils/gentokens.lua */

#include <glib.h>
#include "common/tokenize.h"

typedef struct {
    luakit_token_t tok;
    const gchar *name;
} token_map_t;

static token_map_t tokens_table[] = {
    { L_TK_ACCEPT_POLICY, "accept_policy" },
    { L_TK_ADD_EVENT_LISTENER, "add_event_listener" },
    { L_TK_ALIGN, "align" },
    { L_TK_ALLOW_CERTIFICATE, "allow_certificate" },
    { L_TK_ALLOW_FILE_ACCESS_FROM_FILE_URLS, "allow_file_access_from_file_urls" },
    { L_TK_ALLOW_MODAL_DIALOGS, "allow_modal_dialogs" },
    { L_TK_ALLOW_OVERWRITE, "allow_overwrite" },
    { L_TK_ALLOW_UNIVERSAL_ACCESS_FROM_FILE_URLS, "allow_universal_access_from_file_urls" },
    { L_TK_APPEND, "append" },
    { L_TK_ATTR, "attr" },
    { L_TK_AUTO_LOAD_IMAGES, "auto_load_images" },
    { L_TK_BASELINE, "baseline" },
    { L_TK_BG, "bg" },
    { L_TK_BODY, "body" },
    { L_TK_BOTTOM, "bottom" },
    { L_TK_CACHE_DIR, "cache_dir" },
    { L_TK_CAN_FOCUS, "can_focus" },
    { L_TK_CAN_GO_BACK, "can_go_back" },
    { L_TK_CAN_GO_FORWARD, "can_go_forward" },
    { L_TK_CENTER, "center" },
    { L_TK_CERTIFICATE, "certificate" },
    { L_TK_CHECKED, "checked" },
    { L_TK_CHILD, "child" },
    { L_TK_CHILDREN, "children" },
    { L_TK_CHILD_COUNT, "child_count" },
    { L_TK_CLEAR, "clear" },
    { L_TK_CLEAR_SEARCH, "clear_search" },
    { L_TK_CLICK, "click" },
    { L_TK_CLIENT_RECTS, "client_rects" },
    { L_TK_CLIPBOARD, "clipboard" },
    { L_TK_CLOSE_INSPECTOR, "close_inspector" },
    { L_TK_CONFIG_DIR, "config_dir" },
    { L_TK_CONFPATH, "confpath" },
    { L_TK_COOKIES_STORAGE, "cookies_storage" },
    { L_TK_COUNT, "count" },
    { L_TK_CRASH, "crash" },
    { L_TK_CREATE_ELEMENT, "create_element" },
    { L_TK_CSS, "css" },
    { L_TK_CURRENT, "current" },
    { L_TK_CURRENT_SIZE, "current_size" },
    { L_TK_CURSIVE_FONT_FAMILY, "cursive_font_family" },
    { L_TK_DATA_DIR, "data_dir" },
    { L_TK_DECORATED, "decorated" },
    { L_TK_DEFAULT_CHARSET, "default_charset" },
    { L_TK_DEFAULT_FONT_FAMILY, "default_font_family" },
    { L_TK_DEFAULT_FONT_SIZE, "default_font_size" },
    { L_TK_DEFAULT_MONOSPACE_FONT_SIZE, "default_monospace_font_size" },
    { L_TK_DESKTOP_DIR, "desktop_dir" },
    { L_TK_DESTINATION, "destination" },
    { L_TK_DESTROY, "destroy" },
    { L_TK_DEV_PATHS, "dev_paths" },
    { L_TK_DOCUMENT, "document" },
    { L_TK_DOCUMENTS_DIR, "documents_dir" },
    { L_TK_DOWNLOAD_DIR, "download_dir" },
    { L_TK_DRAWING_AREA, "drawing_area" },
    { L_TK_DRAW_COMPOSITING_INDICATORS, "draw_compositing_indicators" },
    { L_TK_EDITABLE, "editable" },
    { L_TK_ELAPSED_TIME, "elapsed_time" },
    { L_TK_ELEMENT_FROM_POINT, "element_from_point" },
    { L_TK_ENABLE_ACCELERATED_2D_CANVAS, "enable_accelerated_2d_canvas" },
    { L_TK_ENABLE_CARET_BROWSING, "enable_caret_browsing" },
    { L_TK_ENABLE_DEVELOPER_EXTRAS, "enable_developer_extras" },
    { L_TK_ENABLE_DNS_PREFETCHING, "enable_dns_prefetching" },
    { L_TK_ENABLE_FRAME_FLATTENING, "enable_frame_flattening" },
    { L_TK_ENABLE_FULLSCREEN, "enable_fullscreen" },
    { L_TK_ENABLE_HTML5_DATABASE, "enable_html5_database" },
    { L_TK_ENABLE_HTML5_LOCAL_STORAGE, "enable_html5_local_storage" },
    { L_TK_ENABLE_HYPERLINK_AUDITING, "enable_hyperlink_auditing" },
    { L_TK_ENABLE_JAVA, "enable_java" },
    { L_TK_ENABLE_JAVASCRIPT, "enable_javascript" },
    { L_TK_ENABLE_MEDIASOURCE, "enable_mediasource" },
    { L_TK_ENABLE_MEDIA_STREAM, "enable_media_stream" },
    { L_TK_ENABLE_PAGE_CACHE, "enable_page_cache" },
    { L_TK_ENABLE_PLUGINS, "enable_plugins" },
    { L_TK_ENABLE_RESIZABLE_TEXT_AREAS, "enable_resizable_text_areas" },
    { L_TK_ENABLE_SCRIPTS, "enable_scripts" },
    { L_TK_ENABLE_SITE_SPECIFIC_QUIRKS, "enable_site_specific_quirks" },
    { L_TK_ENABLE_SMOOTH_SCROLLING, "enable_smooth_scrolling" },
    { L_TK_ENABLE_SPATIAL_NAVIGATION, "enable_spatial_navigation" },
    { L_TK_ENABLE_SPELL_CHECKING, "enable_spell_checking" },
    { L_TK_ENABLE_TABS_TO_LINKS, "enable_tabs_to_links" },
    { L_TK_ENABLE_WEBAUDIO, "enable_webaudio" },
    { L_TK_ENABLE_WEBGL, "enable_webgl" },
    { L_TK_ENABLE_WRITE_CONSOLE_MESSAGES_TO_STDOUT, "enable_write_console_messages_to_stdout" },
    { L_TK_ENABLE_XSS_AUDITOR, "enable_xss_auditor" },
    { L_TK_END, "end" },
    { L_TK_ENTRY, "entry" },
    { L_TK_ERROR, "error" },
    { L_TK_EVAL_JS, "eval_js" },
    { L_TK_EVENTBOX, "eventbox" },
    { L_TK_EXECPATH, "execpath" },
    { L_TK_FANTASY_FONT_FAMILY, "fantasy_font_family" },
    { L_TK_FETCH, "fetch" },
    { L_TK_FG, "fg" },
    { L_TK_FILENAME, "filename" },
    { L_TK_FILL, "fill" },
    { L_TK_FINISHED, "finished" },
    { L_TK_FIRST_CHILD, "first_child" },
    { L_TK_FOCUS, "focus" },
    { L_TK_FOCUSED, "focused" },
    { L_TK_FONT, "font" },
    { L_TK_FULLSCREEN, "fullscreen" },
    { L_TK_GET_SOURCE, "get_source" },
    { L_TK_GET_TITLE, "get_title" },
    { L_TK_GO_BACK, "go_back" },
    { L_TK_GO_FORWARD, "go_forward" },
    { L_TK_HARDWARE_ACCELERATION_POLICY, "hardware_acceleration_policy" },
    { L_TK_HBOX, "hbox" },
    { L_TK_HEIGHT, "height" },
    { L_TK_HIDE, "hide" },
    { L_TK_HISTORY, "history" },
    { L_TK_HOMOGENEOUS, "homogeneous" },
    { L_TK_HOVERED_URI, "hovered_uri" },
    { L_TK_HPANED, "hpaned" },
    { L_TK_HREF, "href" },
    { L_TK_ICON, "icon" },
    { L_TK_ID, "id" },
    { L_TK_IMAGE, "image" },
    { L_TK_INDEXOF, "indexof" },
    { L_TK_INNER_HEIGHT, "inner_height" },
    { L_TK_INNER_HTML, "inner_html" },
    { L_TK_INNER_WIDTH, "inner_width" },
    { L_TK_INSERT, "insert" },
    { L_TK_INSPECTOR, "inspector" },
    { L_TK_INSTALL_PATH, "install_path" },
    { L_TK_INSTALL_PATHS, "install_paths" },
    { L_TK_INTERVAL, "interval" },
    { L_TK_INVALIDATE, "invalidate" },
    { L_TK_IS_ALIVE, "is_alive" },
    { L_TK_IS_LOADING, "is_loading" },
    { L_TK_IS_PLAYING_AUDIO, "is_playing_audio" },
    { L_TK_JAVASCRIPT_CAN_ACCESS_CLIPBOARD, "javascript_can_access_clipboard" },
    { L_TK_JAVASCRIPT_CAN_OPEN_WINDOWS_AUTOMATICALLY, "javascript_can_open_windows_automatically" },
    { L_TK_LABEL, "label" },
    { L_TK_LAST_CHILD, "last_child" },
    { L_TK_LEFT, "left" },
    { L_TK_LOADING, "loading" },
    { L_TK_LOAD_STRING, "load_string" },
    { L_TK_MARGIN, "margin" },
    { L_TK_MARGIN_BOTTOM, "margin_bottom" },
    { L_TK_MARGIN_LEFT, "margin_left" },
    { L_TK_MARGIN_RIGHT, "margin_right" },
    { L_TK_MARGIN_TOP, "margin_top" },
    { L_TK_MAXIMIZED, "maximized" },
    { L_TK_MEDIA_PLAYBACK_ALLOWS_INLINE, "media_playback_allows_inline" },
    { L_TK_MEDIA_PLAYBACK_REQUIRES_GESTURE, "media_playback_requires_gesture" },
    { L_TK_MIME_TYPE, "mime_type" },
    { L_TK_MINIMUM_FONT_SIZE, "minimum_font_size" },
    { L_TK_MIN_SIZE, "min_size" },
    { L_TK_MONOSPACE_FONT_FAMILY, "monospace_font_family" },
    { L_TK_MUSIC_DIR, "music_dir" },
    { L_TK_NAME, "name" },
    { L_TK_NEXT_SIBLING, "next_sibling" },
    { L_TK_NOTEBOOK, "notebook" },
    { L_TK_NOUNIQUE, "nounique" },
    { L_TK_OPTIONS, "options" },
    { L_TK_OVERLAY, "overlay" },
    { L_TK_OWNER_DOCUMENT, "owner_document" },
    { L_TK_PACK, "pack" },
    { L_TK_PACK1, "pack1" },
    { L_TK_PACK2, "pack2" },
    { L_TK_PARENT, "parent" },
    { L_TK_PATTERN, "pattern" },
    { L_TK_PICTOGRAPH_FONT_FAMILY, "pictograph_font_family" },
    { L_TK_PICTURES_DIR, "pictures_dir" },
    { L_TK_PLUGGED, "plugged" },
    { L_TK_POSITION, "position" },
    { L_TK_PREV_SIBLING, "prev_sibling" },
    { L_TK_PRIMARY, "primary" },
    { L_TK_PRINT_BACKGROUNDS, "print_backgrounds" },
    { L_TK_PRIVATE, "private" },
    { L_TK_PROCESS_LIMIT, "process_limit" },
    { L_TK_PROGRESS, "progress" },
    { L_TK_PROXY_URI, "proxy_uri" },
    { L_TK_PUBLIC_SHARE_DIR, "public_share_dir" },
    { L_TK_QUERY, "query" },
    { L_TK_RECT, "rect" },
    { L_TK_RELOAD, "reload" },
    { L_TK_RELOAD_BYPASS_CACHE, "reload_bypass_cache" },
    { L_TK_REMOVE, "remove" },
    { L_TK_REMOVE_EVENT_LISTENER, "remove_event_listener" },
    { L_TK_REORDER, "reorder" },
    { L_TK_REPLACE, "replace" },
    { L_TK_RESOURCE_PATH, "resource_path" },
    { L_TK_RIGHT, "right" },
    { L_TK_ROOT_WIN_XID, "root_win_xid" },
    { L_TK_SANS_SERIF_FONT_FAMILY, "sans_serif_font_family" },
    { L_TK_SAVE, "save" },
    { L_TK_SCALE, "scale" },
    { L_TK_SCREEN, "screen" },
    { L_TK_SCROLL, "scroll" },
    { L_TK_SCROLLBARS, "scrollbars" },
    { L_TK_SCROLLED, "scrolled" },
    { L_TK_SCROLL_X, "scroll_x" },
    { L_TK_SCROLL_Y, "scroll_y" },
    { L_TK_SEARCH, "search" },
    { L_TK_SEARCH_NEXT, "search_next" },
    { L_TK_SEARCH_PREVIOUS, "search_previous" },
    { L_TK_SECONDARY, "secondary" },
    { L_TK_SELECTABLE, "selectable" },
    { L_TK_SELECTION, "selection" },
    { L_TK_SELECT_REGION, "select_region" },
    { L_TK_SEND_KEY, "send_key" },
    { L_TK_SERIF_FONT_FAMILY, "serif_font_family" },
    { L_TK_SESSION_STATE, "session_state" },
    { L_TK_SET_DARK_MODE, "set_dark_mode" },
    { L_TK_SET_DEFAULT_SIZE, "set_default_size" },
    { L_TK_SET_FAVICON_FOR_URI, "set_favicon_for_uri" },
    { L_TK_SET_PDFJS, "set_pdfjs" },
    { L_TK_SET_TITLE, "set_title" },
    { L_TK_SHOW, "show" },
    { L_TK_SHOW_BORDER, "show_border" },
    { L_TK_SHOW_FRAME, "show_frame" },
    { L_TK_SHOW_INSPECTOR, "show_inspector" },
    { L_TK_SHOW_TABS, "show_tabs" },
    { L_TK_SOCKET, "socket" },
    { L_TK_SOURCE, "source" },
    { L_TK_SPACING, "spacing" },
    { L_TK_SPELL_CHECKING_LANGUAGES, "spell_checking_languages" },
    { L_TK_SPINNER, "spinner" },
    { L_TK_SRC, "src" },
    { L_TK_SSL_TRUSTED, "ssl_trusted" },
    { L_TK_STACK, "stack" },
    { L_TK_START, "start" },
    { L_TK_STARTED, "started" },
    { L_TK_STATUS, "status" },
    { L_TK_STOP, "stop" },
    { L_TK_STYLE, "style" },
    { L_TK_STYLESHEETS, "stylesheets" },
    { L_TK_SUBMIT, "submit" },
    { L_TK_SUGGESTED_FILENAME, "suggested_filename" },
    { L_TK_SWITCH, "switch" },
    { L_TK_SYSTEM_CONFIG_DIRS, "system_config_dirs" },
    { L_TK_SYSTEM_DATA_DIRS, "system_data_dirs" },
    { L_TK_TAG_NAME, "tag_name" },
    { L_TK_TEMPLATES_DIR, "templates_dir" },
    { L_TK_TEXT, "text" },
    { L_TK_TEXTWIDTH, "textwidth" },
    { L_TK_TEXT_CONTENT, "text_content" },
    { L_TK_TITLE, "title" },
    { L_TK_TOOLTIP, "tooltip" },
    { L_TK_TOP, "top" },
    { L_TK_TOTAL_SIZE, "total_size" },
    { L_TK_TYPE, "type" },
    { L_TK_URGENCY_HINT, "urgency_hint" },
    { L_TK_URI, "uri" },
    { L_TK_USER_AGENT, "user_agent" },
    { L_TK_VALUE, "value" },
    { L_TK_VBOX, "vbox" },
    { L_TK_VERBOSE, "verbose" },
    { L_TK_VERSION, "version" },
    { L_TK_VIDEOS_DIR, "videos_dir" },
    { L_TK_VISIBLE, "visible" },
    { L_TK_VISIBLE_CHILD, "visible_child" },
    { L_TK_VPANED, "vpaned" },
    { L_TK_WEBKIT2, "webkit2" },
    { L_TK_WEBKIT_USER_AGENT_VERSION, "webkit_user_agent_version" },
    { L_TK_WEBKIT_VERSION, "webkit_version" },
    { L_TK_WEBSITE_DATA, "website_data" },
    { L_TK_WEBVIEW, "webview" },
    { L_TK_WEB_PROCESS_ID, "web_process_id" },
    { L_TK_WIDTH, "width" },
    { L_TK_WINDOW, "window" },
    { L_TK_WINDOWS, "windows" },
    { L_TK_WIN_XID, "win_xid" },
    { L_TK_WRAP_JS, "wrap_js" },
    { L_TK_X, "x" },
    { L_TK_XMAX, "xmax" },
    { L_TK_XPAGE_SIZE, "xpage_size" },
    { L_TK_Y, "y" },
    { L_TK_YMAX, "ymax" },
    { L_TK_YPAGE_SIZE, "ypage_size" },
    { L_TK_ZOOM_LEVEL, "zoom_level" },
    { L_TK_ZOOM_TEXT_ONLY, "zoom_text_only" },
    { 0, NULL },
};

luakit_token_t
l_tokenize(const gchar *s)
{
    static GHashTable *tokens = NULL;

    if (!tokens) {
        tokens = g_hash_table_new(g_str_hash, g_str_equal);
        for (token_map_t *t = tokens_table; t->name; t++)
            g_hash_table_insert(tokens, (gpointer) t->name, (gpointer) t->tok);
    }

    return (luakit_token_t) g_hash_table_lookup(tokens, s);
}

const gchar *
token_tostring(luakit_token_t tok)
{
    if (tok == L_TK_UNKNOWN)
        return NULL;

    return tokens_table[((gint)tok) - 1].name;
}
