/***********************************************************************
 * This file was generated by /build/libuhd/src/uhd/host/lib/ic_reg_maps/gen_fbx_regs.py on Wed Dec 17 09:05:05 2025
 **********************************************************************/

#ifndef INCLUDED_FBX_REGS_HPP
#define INCLUDED_FBX_REGS_HPP

#include <uhd/config.hpp>
#include <uhd/exception.hpp>
#include <set>
#include <vector>
#include <stdint.h>

class fbx_regs_t{
public:
    uint32_t SCRATCH;
    enum DEVICE_ID_t{
        DEVICE_ID_RO = 0
    };
    DEVICE_ID_t DEVICE_ID;
    enum RF0_TDDS_t{
        RF0_TDDS_RF2 = 0,
        RF0_TDDS_RF1 = 1
    };
    std::vector<RF0_TDDS_t> RF0_TDDS;
    enum RF0_RX_RFS_t{
        RF0_RX_RFS_RF2 = 0,
        RF0_RX_RFS_RF1 = 1
    };
    std::vector<RF0_RX_RFS_t> RF0_RX_RFS;
    enum RF0_TX_RX_RFS_t{
        RF0_TX_RX_RFS_RF2 = 0,
        RF0_TX_RX_RFS_RF1 = 1
    };
    std::vector<RF0_TX_RX_RFS_t> RF0_TX_RX_RFS;
    enum RF1_TDDS_t{
        RF1_TDDS_RF2 = 0,
        RF1_TDDS_RF1 = 1
    };
    std::vector<RF1_TDDS_t> RF1_TDDS;
    enum RF1_RX_RFS_t{
        RF1_RX_RFS_RF2 = 0,
        RF1_RX_RFS_RF1 = 1
    };
    std::vector<RF1_RX_RFS_t> RF1_RX_RFS;
    enum RF1_TX_RX_RFS_t{
        RF1_TX_RX_RFS_RF2 = 0,
        RF1_TX_RX_RFS_RF1 = 1
    };
    std::vector<RF1_TX_RX_RFS_t> RF1_TX_RX_RFS;
    enum RF2_TDDS_t{
        RF2_TDDS_RF2 = 0,
        RF2_TDDS_RF1 = 1
    };
    std::vector<RF2_TDDS_t> RF2_TDDS;
    enum RF2_RX_RFS_t{
        RF2_RX_RFS_RF2 = 0,
        RF2_RX_RFS_RF1 = 1
    };
    std::vector<RF2_RX_RFS_t> RF2_RX_RFS;
    enum RF2_TX_RX_RFS_t{
        RF2_TX_RX_RFS_RF2 = 0,
        RF2_TX_RX_RFS_RF1 = 1
    };
    std::vector<RF2_TX_RX_RFS_t> RF2_TX_RX_RFS;
    enum RF3_TDDS_t{
        RF3_TDDS_RF2 = 0,
        RF3_TDDS_RF1 = 1
    };
    std::vector<RF3_TDDS_t> RF3_TDDS;
    enum RF3_RX_RFS_t{
        RF3_RX_RFS_RF2 = 0,
        RF3_RX_RFS_RF1 = 1
    };
    std::vector<RF3_RX_RFS_t> RF3_RX_RFS;
    enum RF3_TX_RX_RFS_t{
        RF3_TX_RX_RFS_RF2 = 0,
        RF3_TX_RX_RFS_RF1 = 1
    };
    std::vector<RF3_TX_RX_RFS_t> RF3_TX_RX_RFS;
    enum RF0_ATR_OPTION_t{
        RF0_ATR_OPTION_DB = 0,
        RF0_ATR_OPTION_CLASSIC = 1
    };
    RF0_ATR_OPTION_t RF0_ATR_OPTION;
    enum RF1_ATR_OPTION_t{
        RF1_ATR_OPTION_DB = 0,
        RF1_ATR_OPTION_CLASSIC = 1
    };
    RF1_ATR_OPTION_t RF1_ATR_OPTION;
    enum RF2_ATR_OPTION_t{
        RF2_ATR_OPTION_DB = 0,
        RF2_ATR_OPTION_CLASSIC = 1
    };
    RF2_ATR_OPTION_t RF2_ATR_OPTION;
    enum RF3_ATR_OPTION_t{
        RF3_ATR_OPTION_DB = 0,
        RF3_ATR_OPTION_CLASSIC = 1
    };
    RF3_ATR_OPTION_t RF3_ATR_OPTION;
    enum LED0_ATR_OPTION_t{
        LED0_ATR_OPTION_DB = 0,
        LED0_ATR_OPTION_CLASSIC = 1
    };
    LED0_ATR_OPTION_t LED0_ATR_OPTION;
    enum LED1_ATR_OPTION_t{
        LED1_ATR_OPTION_DB = 0,
        LED1_ATR_OPTION_CLASSIC = 1
    };
    LED1_ATR_OPTION_t LED1_ATR_OPTION;
    enum LED2_ATR_OPTION_t{
        LED2_ATR_OPTION_DB = 0,
        LED2_ATR_OPTION_CLASSIC = 1
    };
    LED2_ATR_OPTION_t LED2_ATR_OPTION;
    enum LED3_ATR_OPTION_t{
        LED3_ATR_OPTION_DB = 0,
        LED3_ATR_OPTION_CLASSIC = 1
    };
    LED3_ATR_OPTION_t LED3_ATR_OPTION;
    enum SYNC0_CTRL_t{
        SYNC0_CTRL_NONE = 0,
        SYNC0_CTRL_RF1 = 1,
        SYNC0_CTRL_RF2 = 2,
        SYNC0_CTRL_RF3 = 3,
        SYNC0_CTRL_RF4 = 4,
        SYNC0_CTRL_OFF = 5
    };
    SYNC0_CTRL_t SYNC0_CTRL;
    enum SYNC1_CTRL_t{
        SYNC1_CTRL_NONE = 0,
        SYNC1_CTRL_RF1 = 1,
        SYNC1_CTRL_RF2 = 2,
        SYNC1_CTRL_RF3 = 3,
        SYNC1_CTRL_RF4 = 4,
        SYNC1_CTRL_OFF = 5
    };
    SYNC1_CTRL_t SYNC1_CTRL;
    enum SYNC2_CTRL_t{
        SYNC2_CTRL_NONE = 0,
        SYNC2_CTRL_RF1 = 1,
        SYNC2_CTRL_RF2 = 2,
        SYNC2_CTRL_RF3 = 3,
        SYNC2_CTRL_RF4 = 4,
        SYNC2_CTRL_OFF = 5
    };
    SYNC2_CTRL_t SYNC2_CTRL;
    enum SYNC3_CTRL_t{
        SYNC3_CTRL_NONE = 0,
        SYNC3_CTRL_RF1 = 1,
        SYNC3_CTRL_RF2 = 2,
        SYNC3_CTRL_RF3 = 3,
        SYNC3_CTRL_RF4 = 4,
        SYNC3_CTRL_OFF = 5
    };
    SYNC3_CTRL_t SYNC3_CTRL;
    enum SYNC4_CTRL_t{
        SYNC4_CTRL_NONE = 0,
        SYNC4_CTRL_RF1 = 1,
        SYNC4_CTRL_RF2 = 2,
        SYNC4_CTRL_RF3 = 3,
        SYNC4_CTRL_RF4 = 4,
        SYNC4_CTRL_OFF = 5
    };
    SYNC4_CTRL_t SYNC4_CTRL;
    enum IO_EXP_SETUP_t{
        IO_EXP_SETUP_NONE = 0,
        IO_EXP_SETUP_INIT = 1
    };
    IO_EXP_SETUP_t IO_EXP_SETUP;
    enum IO_EXP_CONFIG_t{
        IO_EXP_CONFIG_NONE = 0,
        IO_EXP_CONFIG_CONFIG = 1
    };
    IO_EXP_CONFIG_t IO_EXP_CONFIG;
    enum CH3_TRX1_LED_GR_t{
        CH3_TRX1_LED_GR_DISABLE = 0,
        CH3_TRX1_LED_GR_ENABLE = 1
    };
    std::vector<CH3_TRX1_LED_GR_t> CH3_TRX1_LED_GR;
    enum CH3_TRX1_LED_RED_t{
        CH3_TRX1_LED_RED_DISABLE = 0,
        CH3_TRX1_LED_RED_ENABLE = 1
    };
    std::vector<CH3_TRX1_LED_RED_t> CH3_TRX1_LED_RED;
    enum CH3_RX2_LED_t{
        CH3_RX2_LED_DISABLE = 0,
        CH3_RX2_LED_ENABLE = 1
    };
    std::vector<CH3_RX2_LED_t> CH3_RX2_LED;
    enum CH2_TRX1_LED_GR_t{
        CH2_TRX1_LED_GR_DISABLE = 0,
        CH2_TRX1_LED_GR_ENABLE = 1
    };
    std::vector<CH2_TRX1_LED_GR_t> CH2_TRX1_LED_GR;
    enum CH2_TRX1_LED_RED_t{
        CH2_TRX1_LED_RED_DISABLE = 0,
        CH2_TRX1_LED_RED_ENABLE = 1
    };
    std::vector<CH2_TRX1_LED_RED_t> CH2_TRX1_LED_RED;
    enum CH2_RX2_LED_t{
        CH2_RX2_LED_DISABLE = 0,
        CH2_RX2_LED_ENABLE = 1
    };
    std::vector<CH2_RX2_LED_t> CH2_RX2_LED;
    enum CH1_TRX1_LED_GR_t{
        CH1_TRX1_LED_GR_DISABLE = 0,
        CH1_TRX1_LED_GR_ENABLE = 1
    };
    std::vector<CH1_TRX1_LED_GR_t> CH1_TRX1_LED_GR;
    enum CH1_TRX1_LED_RED_t{
        CH1_TRX1_LED_RED_DISABLE = 0,
        CH1_TRX1_LED_RED_ENABLE = 1
    };
    std::vector<CH1_TRX1_LED_RED_t> CH1_TRX1_LED_RED;
    enum CH1_RX2_LED_t{
        CH1_RX2_LED_DISABLE = 0,
        CH1_RX2_LED_ENABLE = 1
    };
    std::vector<CH1_RX2_LED_t> CH1_RX2_LED;
    enum CH0_TRX1_LED_GR_t{
        CH0_TRX1_LED_GR_DISABLE = 0,
        CH0_TRX1_LED_GR_ENABLE = 1
    };
    std::vector<CH0_TRX1_LED_GR_t> CH0_TRX1_LED_GR;
    enum CH0_TRX1_LED_RED_t{
        CH0_TRX1_LED_RED_DISABLE = 0,
        CH0_TRX1_LED_RED_ENABLE = 1
    };
    std::vector<CH0_TRX1_LED_RED_t> CH0_TRX1_LED_RED;
    enum CH0_RX2_LED_t{
        CH0_RX2_LED_DISABLE = 0,
        CH0_RX2_LED_ENABLE = 1
    };
    std::vector<CH0_RX2_LED_t> CH0_RX2_LED;
    enum SYNC_CLK_t{
        SYNC_CLK_DISABLE = 0,
        SYNC_CLK_ENABLE = 1
    };
    SYNC_CLK_t SYNC_CLK;

    fbx_regs_t(void){
        _state = NULL;
        SCRATCH = 0;
        DEVICE_ID = DEVICE_ID_RO;
        RF0_TDDS.resize(256, RF0_TDDS_RF2);
        RF0_RX_RFS.resize(256, RF0_RX_RFS_RF2);
        RF0_TX_RX_RFS.resize(256, RF0_TX_RX_RFS_RF2);
        RF1_TDDS.resize(256, RF1_TDDS_RF2);
        RF1_RX_RFS.resize(256, RF1_RX_RFS_RF2);
        RF1_TX_RX_RFS.resize(256, RF1_TX_RX_RFS_RF2);
        RF2_TDDS.resize(256, RF2_TDDS_RF2);
        RF2_RX_RFS.resize(256, RF2_RX_RFS_RF2);
        RF2_TX_RX_RFS.resize(256, RF2_TX_RX_RFS_RF2);
        RF3_TDDS.resize(256, RF3_TDDS_RF2);
        RF3_RX_RFS.resize(256, RF3_RX_RFS_RF2);
        RF3_TX_RX_RFS.resize(256, RF3_TX_RX_RFS_RF2);
        RF0_ATR_OPTION = RF0_ATR_OPTION_CLASSIC;
        RF1_ATR_OPTION = RF1_ATR_OPTION_CLASSIC;
        RF2_ATR_OPTION = RF2_ATR_OPTION_CLASSIC;
        RF3_ATR_OPTION = RF3_ATR_OPTION_CLASSIC;
        LED0_ATR_OPTION = LED0_ATR_OPTION_CLASSIC;
        LED1_ATR_OPTION = LED1_ATR_OPTION_CLASSIC;
        LED2_ATR_OPTION = LED2_ATR_OPTION_CLASSIC;
        LED3_ATR_OPTION = LED3_ATR_OPTION_CLASSIC;
        SYNC0_CTRL = SYNC0_CTRL_NONE;
        SYNC1_CTRL = SYNC1_CTRL_NONE;
        SYNC2_CTRL = SYNC2_CTRL_NONE;
        SYNC3_CTRL = SYNC3_CTRL_NONE;
        SYNC4_CTRL = SYNC4_CTRL_NONE;
        IO_EXP_SETUP = IO_EXP_SETUP_INIT;
        IO_EXP_CONFIG = IO_EXP_CONFIG_NONE;
        CH3_TRX1_LED_GR.resize(256, CH3_TRX1_LED_GR_DISABLE);
        CH3_TRX1_LED_RED.resize(256, CH3_TRX1_LED_RED_DISABLE);
        CH3_RX2_LED.resize(256, CH3_RX2_LED_DISABLE);
        CH2_TRX1_LED_GR.resize(256, CH2_TRX1_LED_GR_DISABLE);
        CH2_TRX1_LED_RED.resize(256, CH2_TRX1_LED_RED_DISABLE);
        CH2_RX2_LED.resize(256, CH2_RX2_LED_DISABLE);
        CH1_TRX1_LED_GR.resize(256, CH1_TRX1_LED_GR_DISABLE);
        CH1_TRX1_LED_RED.resize(256, CH1_TRX1_LED_RED_DISABLE);
        CH1_RX2_LED.resize(256, CH1_RX2_LED_DISABLE);
        CH0_TRX1_LED_GR.resize(256, CH0_TRX1_LED_GR_DISABLE);
        CH0_TRX1_LED_RED.resize(256, CH0_TRX1_LED_RED_DISABLE);
        CH0_RX2_LED.resize(256, CH0_RX2_LED_DISABLE);
        SYNC_CLK = SYNC_CLK_DISABLE;
    }

    ~fbx_regs_t(void){
        delete _state;
    }

    enum class fbx_reg_field_t {
        RF0_TDDS,
        RF0_RX_RFS,
        RF0_TX_RX_RFS,
        SCRATCH,
        DEVICE_ID,
        RF1_TDDS,
        RF1_RX_RFS,
        RF1_TX_RX_RFS,
        RF2_TDDS,
        RF2_RX_RFS,
        RF2_TX_RX_RFS,
        RF3_TDDS,
        RF3_RX_RFS,
        RF3_TX_RX_RFS,
        RF0_ATR_OPTION,
        RF1_ATR_OPTION,
        RF2_ATR_OPTION,
        RF3_ATR_OPTION,
        SYNC0_CTRL,
        SYNC1_CTRL,
        SYNC2_CTRL,
        SYNC3_CTRL,
        SYNC4_CTRL,
        IO_EXP_SETUP,
        IO_EXP_CONFIG,
        CH0_TRX1_LED_GR,
        CH0_TRX1_LED_RED,
        CH0_RX2_LED,
        CH1_TRX1_LED_GR,
        CH1_TRX1_LED_RED,
        CH1_RX2_LED,
        CH2_TRX1_LED_GR,
        CH2_TRX1_LED_RED,
        CH2_RX2_LED,
        CH3_TRX1_LED_GR,
        CH3_TRX1_LED_RED,
        CH3_RX2_LED,
        LED0_ATR_OPTION,
        LED1_ATR_OPTION,
        LED2_ATR_OPTION,
        LED3_ATR_OPTION,
        SYNC_CLK,
    };
    
    fbx_reg_field_t get_field_type(const std::string& field_name) {
        if (field_name == "RF0_TDDS") {
            return fbx_reg_field_t::RF0_TDDS;
        } else
        if (field_name == "RF0_RX_RFS") {
            return fbx_reg_field_t::RF0_RX_RFS;
        } else
        if (field_name == "RF0_TX_RX_RFS") {
            return fbx_reg_field_t::RF0_TX_RX_RFS;
        } else
        if (field_name == "SCRATCH") {
            return fbx_reg_field_t::SCRATCH;
        } else
        if (field_name == "DEVICE_ID") {
            return fbx_reg_field_t::DEVICE_ID;
        } else
        if (field_name == "RF1_TDDS") {
            return fbx_reg_field_t::RF1_TDDS;
        } else
        if (field_name == "RF1_RX_RFS") {
            return fbx_reg_field_t::RF1_RX_RFS;
        } else
        if (field_name == "RF1_TX_RX_RFS") {
            return fbx_reg_field_t::RF1_TX_RX_RFS;
        } else
        if (field_name == "RF2_TDDS") {
            return fbx_reg_field_t::RF2_TDDS;
        } else
        if (field_name == "RF2_RX_RFS") {
            return fbx_reg_field_t::RF2_RX_RFS;
        } else
        if (field_name == "RF2_TX_RX_RFS") {
            return fbx_reg_field_t::RF2_TX_RX_RFS;
        } else
        if (field_name == "RF3_TDDS") {
            return fbx_reg_field_t::RF3_TDDS;
        } else
        if (field_name == "RF3_RX_RFS") {
            return fbx_reg_field_t::RF3_RX_RFS;
        } else
        if (field_name == "RF3_TX_RX_RFS") {
            return fbx_reg_field_t::RF3_TX_RX_RFS;
        } else
        if (field_name == "RF0_ATR_OPTION") {
            return fbx_reg_field_t::RF0_ATR_OPTION;
        } else
        if (field_name == "RF1_ATR_OPTION") {
            return fbx_reg_field_t::RF1_ATR_OPTION;
        } else
        if (field_name == "RF2_ATR_OPTION") {
            return fbx_reg_field_t::RF2_ATR_OPTION;
        } else
        if (field_name == "RF3_ATR_OPTION") {
            return fbx_reg_field_t::RF3_ATR_OPTION;
        } else
        if (field_name == "SYNC0_CTRL") {
            return fbx_reg_field_t::SYNC0_CTRL;
        } else
        if (field_name == "SYNC1_CTRL") {
            return fbx_reg_field_t::SYNC1_CTRL;
        } else
        if (field_name == "SYNC2_CTRL") {
            return fbx_reg_field_t::SYNC2_CTRL;
        } else
        if (field_name == "SYNC3_CTRL") {
            return fbx_reg_field_t::SYNC3_CTRL;
        } else
        if (field_name == "SYNC4_CTRL") {
            return fbx_reg_field_t::SYNC4_CTRL;
        } else
        if (field_name == "IO_EXP_SETUP") {
            return fbx_reg_field_t::IO_EXP_SETUP;
        } else
        if (field_name == "IO_EXP_CONFIG") {
            return fbx_reg_field_t::IO_EXP_CONFIG;
        } else
        if (field_name == "CH0_TRX1_LED_GR") {
            return fbx_reg_field_t::CH0_TRX1_LED_GR;
        } else
        if (field_name == "CH0_TRX1_LED_RED") {
            return fbx_reg_field_t::CH0_TRX1_LED_RED;
        } else
        if (field_name == "CH0_RX2_LED") {
            return fbx_reg_field_t::CH0_RX2_LED;
        } else
        if (field_name == "CH1_TRX1_LED_GR") {
            return fbx_reg_field_t::CH1_TRX1_LED_GR;
        } else
        if (field_name == "CH1_TRX1_LED_RED") {
            return fbx_reg_field_t::CH1_TRX1_LED_RED;
        } else
        if (field_name == "CH1_RX2_LED") {
            return fbx_reg_field_t::CH1_RX2_LED;
        } else
        if (field_name == "CH2_TRX1_LED_GR") {
            return fbx_reg_field_t::CH2_TRX1_LED_GR;
        } else
        if (field_name == "CH2_TRX1_LED_RED") {
            return fbx_reg_field_t::CH2_TRX1_LED_RED;
        } else
        if (field_name == "CH2_RX2_LED") {
            return fbx_reg_field_t::CH2_RX2_LED;
        } else
        if (field_name == "CH3_TRX1_LED_GR") {
            return fbx_reg_field_t::CH3_TRX1_LED_GR;
        } else
        if (field_name == "CH3_TRX1_LED_RED") {
            return fbx_reg_field_t::CH3_TRX1_LED_RED;
        } else
        if (field_name == "CH3_RX2_LED") {
            return fbx_reg_field_t::CH3_RX2_LED;
        } else
        if (field_name == "LED0_ATR_OPTION") {
            return fbx_reg_field_t::LED0_ATR_OPTION;
        } else
        if (field_name == "LED1_ATR_OPTION") {
            return fbx_reg_field_t::LED1_ATR_OPTION;
        } else
        if (field_name == "LED2_ATR_OPTION") {
            return fbx_reg_field_t::LED2_ATR_OPTION;
        } else
        if (field_name == "LED3_ATR_OPTION") {
            return fbx_reg_field_t::LED3_ATR_OPTION;
        } else
        if (field_name == "SYNC_CLK") {
            return fbx_reg_field_t::SYNC_CLK;
        } else
        {
            UHD_ASSERT_THROW(false);
        }
    }
    
    uint32_t get_array_size(fbx_reg_field_t field) {
        switch(field) {
        case fbx_reg_field_t::RF0_TDDS:
            return uint32_t(RF0_TDDS.size());
        case fbx_reg_field_t::RF0_RX_RFS:
            return uint32_t(RF0_RX_RFS.size());
        case fbx_reg_field_t::RF0_TX_RX_RFS:
            return uint32_t(RF0_TX_RX_RFS.size());
        case fbx_reg_field_t::RF1_TDDS:
            return uint32_t(RF1_TDDS.size());
        case fbx_reg_field_t::RF1_RX_RFS:
            return uint32_t(RF1_RX_RFS.size());
        case fbx_reg_field_t::RF1_TX_RX_RFS:
            return uint32_t(RF1_TX_RX_RFS.size());
        case fbx_reg_field_t::RF2_TDDS:
            return uint32_t(RF2_TDDS.size());
        case fbx_reg_field_t::RF2_RX_RFS:
            return uint32_t(RF2_RX_RFS.size());
        case fbx_reg_field_t::RF2_TX_RX_RFS:
            return uint32_t(RF2_TX_RX_RFS.size());
        case fbx_reg_field_t::RF3_TDDS:
            return uint32_t(RF3_TDDS.size());
        case fbx_reg_field_t::RF3_RX_RFS:
            return uint32_t(RF3_RX_RFS.size());
        case fbx_reg_field_t::RF3_TX_RX_RFS:
            return uint32_t(RF3_TX_RX_RFS.size());
        case fbx_reg_field_t::CH0_TRX1_LED_GR:
            return uint32_t(CH0_TRX1_LED_GR.size());
        case fbx_reg_field_t::CH0_TRX1_LED_RED:
            return uint32_t(CH0_TRX1_LED_RED.size());
        case fbx_reg_field_t::CH0_RX2_LED:
            return uint32_t(CH0_RX2_LED.size());
        case fbx_reg_field_t::CH1_TRX1_LED_GR:
            return uint32_t(CH1_TRX1_LED_GR.size());
        case fbx_reg_field_t::CH1_TRX1_LED_RED:
            return uint32_t(CH1_TRX1_LED_RED.size());
        case fbx_reg_field_t::CH1_RX2_LED:
            return uint32_t(CH1_RX2_LED.size());
        case fbx_reg_field_t::CH2_TRX1_LED_GR:
            return uint32_t(CH2_TRX1_LED_GR.size());
        case fbx_reg_field_t::CH2_TRX1_LED_RED:
            return uint32_t(CH2_TRX1_LED_RED.size());
        case fbx_reg_field_t::CH2_RX2_LED:
            return uint32_t(CH2_RX2_LED.size());
        case fbx_reg_field_t::CH3_TRX1_LED_GR:
            return uint32_t(CH3_TRX1_LED_GR.size());
        case fbx_reg_field_t::CH3_TRX1_LED_RED:
            return uint32_t(CH3_TRX1_LED_RED.size());
        case fbx_reg_field_t::CH3_RX2_LED:
            return uint32_t(CH3_RX2_LED.size());
        default:
            UHD_ASSERT_THROW(false);
            return 0;
        }
    }
    
    uint32_t get_field(fbx_reg_field_t field) {
        switch(field) {
        case fbx_reg_field_t::SCRATCH:
            return uint32_t(SCRATCH);
        case fbx_reg_field_t::DEVICE_ID:
            return uint32_t(DEVICE_ID);
        case fbx_reg_field_t::RF0_ATR_OPTION:
            return uint32_t(RF0_ATR_OPTION);
        case fbx_reg_field_t::RF1_ATR_OPTION:
            return uint32_t(RF1_ATR_OPTION);
        case fbx_reg_field_t::RF2_ATR_OPTION:
            return uint32_t(RF2_ATR_OPTION);
        case fbx_reg_field_t::RF3_ATR_OPTION:
            return uint32_t(RF3_ATR_OPTION);
        case fbx_reg_field_t::SYNC0_CTRL:
            return uint32_t(SYNC0_CTRL);
        case fbx_reg_field_t::SYNC1_CTRL:
            return uint32_t(SYNC1_CTRL);
        case fbx_reg_field_t::SYNC2_CTRL:
            return uint32_t(SYNC2_CTRL);
        case fbx_reg_field_t::SYNC3_CTRL:
            return uint32_t(SYNC3_CTRL);
        case fbx_reg_field_t::SYNC4_CTRL:
            return uint32_t(SYNC4_CTRL);
        case fbx_reg_field_t::IO_EXP_SETUP:
            return uint32_t(IO_EXP_SETUP);
        case fbx_reg_field_t::IO_EXP_CONFIG:
            return uint32_t(IO_EXP_CONFIG);
        case fbx_reg_field_t::LED0_ATR_OPTION:
            return uint32_t(LED0_ATR_OPTION);
        case fbx_reg_field_t::LED1_ATR_OPTION:
            return uint32_t(LED1_ATR_OPTION);
        case fbx_reg_field_t::LED2_ATR_OPTION:
            return uint32_t(LED2_ATR_OPTION);
        case fbx_reg_field_t::LED3_ATR_OPTION:
            return uint32_t(LED3_ATR_OPTION);
        case fbx_reg_field_t::SYNC_CLK:
            return uint32_t(SYNC_CLK);
        default:
            UHD_ASSERT_THROW(false);
            return 0;
        }
    }
    
    uint32_t get_field(fbx_reg_field_t field, const size_t idx) {
        switch(field) {
        case fbx_reg_field_t::RF0_TDDS:
            return uint32_t(RF0_TDDS[idx]);
        case fbx_reg_field_t::RF0_RX_RFS:
            return uint32_t(RF0_RX_RFS[idx]);
        case fbx_reg_field_t::RF0_TX_RX_RFS:
            return uint32_t(RF0_TX_RX_RFS[idx]);
        case fbx_reg_field_t::RF1_TDDS:
            return uint32_t(RF1_TDDS[idx]);
        case fbx_reg_field_t::RF1_RX_RFS:
            return uint32_t(RF1_RX_RFS[idx]);
        case fbx_reg_field_t::RF1_TX_RX_RFS:
            return uint32_t(RF1_TX_RX_RFS[idx]);
        case fbx_reg_field_t::RF2_TDDS:
            return uint32_t(RF2_TDDS[idx]);
        case fbx_reg_field_t::RF2_RX_RFS:
            return uint32_t(RF2_RX_RFS[idx]);
        case fbx_reg_field_t::RF2_TX_RX_RFS:
            return uint32_t(RF2_TX_RX_RFS[idx]);
        case fbx_reg_field_t::RF3_TDDS:
            return uint32_t(RF3_TDDS[idx]);
        case fbx_reg_field_t::RF3_RX_RFS:
            return uint32_t(RF3_RX_RFS[idx]);
        case fbx_reg_field_t::RF3_TX_RX_RFS:
            return uint32_t(RF3_TX_RX_RFS[idx]);
        case fbx_reg_field_t::CH0_TRX1_LED_GR:
            return uint32_t(CH0_TRX1_LED_GR[idx]);
        case fbx_reg_field_t::CH0_TRX1_LED_RED:
            return uint32_t(CH0_TRX1_LED_RED[idx]);
        case fbx_reg_field_t::CH0_RX2_LED:
            return uint32_t(CH0_RX2_LED[idx]);
        case fbx_reg_field_t::CH1_TRX1_LED_GR:
            return uint32_t(CH1_TRX1_LED_GR[idx]);
        case fbx_reg_field_t::CH1_TRX1_LED_RED:
            return uint32_t(CH1_TRX1_LED_RED[idx]);
        case fbx_reg_field_t::CH1_RX2_LED:
            return uint32_t(CH1_RX2_LED[idx]);
        case fbx_reg_field_t::CH2_TRX1_LED_GR:
            return uint32_t(CH2_TRX1_LED_GR[idx]);
        case fbx_reg_field_t::CH2_TRX1_LED_RED:
            return uint32_t(CH2_TRX1_LED_RED[idx]);
        case fbx_reg_field_t::CH2_RX2_LED:
            return uint32_t(CH2_RX2_LED[idx]);
        case fbx_reg_field_t::CH3_TRX1_LED_GR:
            return uint32_t(CH3_TRX1_LED_GR[idx]);
        case fbx_reg_field_t::CH3_TRX1_LED_RED:
            return uint32_t(CH3_TRX1_LED_RED[idx]);
        case fbx_reg_field_t::CH3_RX2_LED:
            return uint32_t(CH3_RX2_LED[idx]);
        default:
            UHD_ASSERT_THROW(false);
            return 0;
        }
    }
    
    void set_field(fbx_reg_field_t field, uint32_t value) {
        switch(field) {
        case fbx_reg_field_t::SCRATCH:
            SCRATCH = static_cast<uint32_t>(value);
            break;
        case fbx_reg_field_t::RF0_ATR_OPTION:
            RF0_ATR_OPTION = static_cast<RF0_ATR_OPTION_t>(value);
            break;
        case fbx_reg_field_t::RF1_ATR_OPTION:
            RF1_ATR_OPTION = static_cast<RF1_ATR_OPTION_t>(value);
            break;
        case fbx_reg_field_t::RF2_ATR_OPTION:
            RF2_ATR_OPTION = static_cast<RF2_ATR_OPTION_t>(value);
            break;
        case fbx_reg_field_t::RF3_ATR_OPTION:
            RF3_ATR_OPTION = static_cast<RF3_ATR_OPTION_t>(value);
            break;
        case fbx_reg_field_t::SYNC0_CTRL:
            SYNC0_CTRL = static_cast<SYNC0_CTRL_t>(value);
            break;
        case fbx_reg_field_t::SYNC1_CTRL:
            SYNC1_CTRL = static_cast<SYNC1_CTRL_t>(value);
            break;
        case fbx_reg_field_t::SYNC2_CTRL:
            SYNC2_CTRL = static_cast<SYNC2_CTRL_t>(value);
            break;
        case fbx_reg_field_t::SYNC3_CTRL:
            SYNC3_CTRL = static_cast<SYNC3_CTRL_t>(value);
            break;
        case fbx_reg_field_t::SYNC4_CTRL:
            SYNC4_CTRL = static_cast<SYNC4_CTRL_t>(value);
            break;
        case fbx_reg_field_t::IO_EXP_SETUP:
            IO_EXP_SETUP = static_cast<IO_EXP_SETUP_t>(value);
            break;
        case fbx_reg_field_t::IO_EXP_CONFIG:
            IO_EXP_CONFIG = static_cast<IO_EXP_CONFIG_t>(value);
            break;
        case fbx_reg_field_t::LED0_ATR_OPTION:
            LED0_ATR_OPTION = static_cast<LED0_ATR_OPTION_t>(value);
            break;
        case fbx_reg_field_t::LED1_ATR_OPTION:
            LED1_ATR_OPTION = static_cast<LED1_ATR_OPTION_t>(value);
            break;
        case fbx_reg_field_t::LED2_ATR_OPTION:
            LED2_ATR_OPTION = static_cast<LED2_ATR_OPTION_t>(value);
            break;
        case fbx_reg_field_t::LED3_ATR_OPTION:
            LED3_ATR_OPTION = static_cast<LED3_ATR_OPTION_t>(value);
            break;
        case fbx_reg_field_t::SYNC_CLK:
            SYNC_CLK = static_cast<SYNC_CLK_t>(value);
            break;
        default:
            UHD_ASSERT_THROW(false);
        }
    }
    
    void set_field(fbx_reg_field_t field, uint32_t value, const size_t idx)
    {
        switch(field) {
        case fbx_reg_field_t::RF0_TDDS:
            RF0_TDDS[idx] = static_cast<RF0_TDDS_t>(value);
            break;
        case fbx_reg_field_t::RF0_RX_RFS:
            RF0_RX_RFS[idx] = static_cast<RF0_RX_RFS_t>(value);
            break;
        case fbx_reg_field_t::RF0_TX_RX_RFS:
            RF0_TX_RX_RFS[idx] = static_cast<RF0_TX_RX_RFS_t>(value);
            break;
        case fbx_reg_field_t::RF1_TDDS:
            RF1_TDDS[idx] = static_cast<RF1_TDDS_t>(value);
            break;
        case fbx_reg_field_t::RF1_RX_RFS:
            RF1_RX_RFS[idx] = static_cast<RF1_RX_RFS_t>(value);
            break;
        case fbx_reg_field_t::RF1_TX_RX_RFS:
            RF1_TX_RX_RFS[idx] = static_cast<RF1_TX_RX_RFS_t>(value);
            break;
        case fbx_reg_field_t::RF2_TDDS:
            RF2_TDDS[idx] = static_cast<RF2_TDDS_t>(value);
            break;
        case fbx_reg_field_t::RF2_RX_RFS:
            RF2_RX_RFS[idx] = static_cast<RF2_RX_RFS_t>(value);
            break;
        case fbx_reg_field_t::RF2_TX_RX_RFS:
            RF2_TX_RX_RFS[idx] = static_cast<RF2_TX_RX_RFS_t>(value);
            break;
        case fbx_reg_field_t::RF3_TDDS:
            RF3_TDDS[idx] = static_cast<RF3_TDDS_t>(value);
            break;
        case fbx_reg_field_t::RF3_RX_RFS:
            RF3_RX_RFS[idx] = static_cast<RF3_RX_RFS_t>(value);
            break;
        case fbx_reg_field_t::RF3_TX_RX_RFS:
            RF3_TX_RX_RFS[idx] = static_cast<RF3_TX_RX_RFS_t>(value);
            break;
        case fbx_reg_field_t::CH0_TRX1_LED_GR:
            CH0_TRX1_LED_GR[idx] = static_cast<CH0_TRX1_LED_GR_t>(value);
            break;
        case fbx_reg_field_t::CH0_TRX1_LED_RED:
            CH0_TRX1_LED_RED[idx] = static_cast<CH0_TRX1_LED_RED_t>(value);
            break;
        case fbx_reg_field_t::CH0_RX2_LED:
            CH0_RX2_LED[idx] = static_cast<CH0_RX2_LED_t>(value);
            break;
        case fbx_reg_field_t::CH1_TRX1_LED_GR:
            CH1_TRX1_LED_GR[idx] = static_cast<CH1_TRX1_LED_GR_t>(value);
            break;
        case fbx_reg_field_t::CH1_TRX1_LED_RED:
            CH1_TRX1_LED_RED[idx] = static_cast<CH1_TRX1_LED_RED_t>(value);
            break;
        case fbx_reg_field_t::CH1_RX2_LED:
            CH1_RX2_LED[idx] = static_cast<CH1_RX2_LED_t>(value);
            break;
        case fbx_reg_field_t::CH2_TRX1_LED_GR:
            CH2_TRX1_LED_GR[idx] = static_cast<CH2_TRX1_LED_GR_t>(value);
            break;
        case fbx_reg_field_t::CH2_TRX1_LED_RED:
            CH2_TRX1_LED_RED[idx] = static_cast<CH2_TRX1_LED_RED_t>(value);
            break;
        case fbx_reg_field_t::CH2_RX2_LED:
            CH2_RX2_LED[idx] = static_cast<CH2_RX2_LED_t>(value);
            break;
        case fbx_reg_field_t::CH3_TRX1_LED_GR:
            CH3_TRX1_LED_GR[idx] = static_cast<CH3_TRX1_LED_GR_t>(value);
            break;
        case fbx_reg_field_t::CH3_TRX1_LED_RED:
            CH3_TRX1_LED_RED[idx] = static_cast<CH3_TRX1_LED_RED_t>(value);
            break;
        case fbx_reg_field_t::CH3_RX2_LED:
            CH3_RX2_LED[idx] = static_cast<CH3_RX2_LED_t>(value);
            break;
        default:
            UHD_ASSERT_THROW(false);
        }
    }
    
    uint32_t get_reg(uint16_t addr)
    {
        uint32_t reg = 0;
        // First the regular registers
        switch(addr) {
        case 12:
            reg |= (uint32_t(SCRATCH) & 0xffffffff) << 0;
            break;
        case 16:
            reg |= (uint32_t(DEVICE_ID) & 0xffff) << 0;
            break;
        case 4096:
            reg |= (uint32_t(RF0_ATR_OPTION) & 0x1) << 0;
            reg |= (uint32_t(RF1_ATR_OPTION) & 0x1) << 1;
            reg |= (uint32_t(RF2_ATR_OPTION) & 0x1) << 2;
            reg |= (uint32_t(RF3_ATR_OPTION) & 0x1) << 3;
            break;
        case 8192:
            reg |= (uint32_t(SYNC0_CTRL) & 0x7) << 0;
            break;
        case 8196:
            reg |= (uint32_t(SYNC1_CTRL) & 0x7) << 0;
            break;
        case 8200:
            reg |= (uint32_t(SYNC2_CTRL) & 0x7) << 0;
            break;
        case 8204:
            reg |= (uint32_t(SYNC3_CTRL) & 0x7) << 0;
            break;
        case 8208:
            reg |= (uint32_t(SYNC4_CTRL) & 0x7) << 0;
            break;
        case 8216:
            reg |= (uint32_t(IO_EXP_SETUP) & 0x1) << 0;
            break;
        case 8220:
            reg |= (uint32_t(IO_EXP_CONFIG) & 0x1) << 0;
            break;
        case 20480:
            reg |= (uint32_t(LED0_ATR_OPTION) & 0x1) << 0;
            reg |= (uint32_t(LED1_ATR_OPTION) & 0x1) << 1;
            reg |= (uint32_t(LED2_ATR_OPTION) & 0x1) << 2;
            reg |= (uint32_t(LED3_ATR_OPTION) & 0x1) << 3;
            break;
        case 24576:
            reg |= (uint32_t(SYNC_CLK) & 0x1) << 0;
            break;
        default:
            break;
        }
        // Now the arrays
        // We can do this because all arrays have a base address that is a multiple
        // of 256 (0x100). In other words, this is a hack that only works if you
        // know exactly what you're doing, which is OK in this case, because it's in
        // this same file as the register map.
        const uint16_t array_offset = addr % 256;
        const uint16_t base_addr = addr - array_offset;
        const size_t index = array_offset / 4;
        switch(base_addr) {
        case 0:
            
            
            reg |= (uint32_t(RF0_TDDS[index]) & 0x1) << 2;
            
            
            reg |= (uint32_t(RF0_RX_RFS[index]) & 0x1) << 1;
            
            
            reg |= (uint32_t(RF0_TX_RX_RFS[index]) & 0x1) << 0;
            break;
        case 1024:
            
            
            reg |= (uint32_t(RF1_TDDS[index]) & 0x1) << 2;
            
            
            reg |= (uint32_t(RF1_RX_RFS[index]) & 0x1) << 1;
            
            
            reg |= (uint32_t(RF1_TX_RX_RFS[index]) & 0x1) << 0;
            break;
        case 2048:
            
            
            reg |= (uint32_t(RF2_TDDS[index]) & 0x1) << 2;
            
            
            reg |= (uint32_t(RF2_RX_RFS[index]) & 0x1) << 1;
            
            
            reg |= (uint32_t(RF2_TX_RX_RFS[index]) & 0x1) << 0;
            break;
        case 3072:
            
            
            reg |= (uint32_t(RF3_TDDS[index]) & 0x1) << 2;
            
            
            reg |= (uint32_t(RF3_RX_RFS[index]) & 0x1) << 1;
            
            
            reg |= (uint32_t(RF3_TX_RX_RFS[index]) & 0x1) << 0;
            break;
        case 16384:
            
            
            reg |= (uint32_t(CH0_TRX1_LED_GR[index]) & 0x1) << 2;
            
            
            reg |= (uint32_t(CH0_TRX1_LED_RED[index]) & 0x1) << 1;
            
            
            reg |= (uint32_t(CH0_RX2_LED[index]) & 0x1) << 0;
            break;
        case 17408:
            
            
            reg |= (uint32_t(CH1_TRX1_LED_GR[index]) & 0x1) << 2;
            
            
            reg |= (uint32_t(CH1_TRX1_LED_RED[index]) & 0x1) << 1;
            
            
            reg |= (uint32_t(CH1_RX2_LED[index]) & 0x1) << 0;
            break;
        case 18432:
            
            
            reg |= (uint32_t(CH2_TRX1_LED_GR[index]) & 0x1) << 2;
            
            
            reg |= (uint32_t(CH2_TRX1_LED_RED[index]) & 0x1) << 1;
            
            
            reg |= (uint32_t(CH2_RX2_LED[index]) & 0x1) << 0;
            break;
        case 19456:
            
            
            reg |= (uint32_t(CH3_TRX1_LED_GR[index]) & 0x1) << 2;
            
            
            reg |= (uint32_t(CH3_TRX1_LED_RED[index]) & 0x1) << 1;
            
            
            reg |= (uint32_t(CH3_RX2_LED[index]) & 0x1) << 0;
            break;
        default:
            break;
        }
        return reg;
    }
    
    void set_reg(uint16_t addr, uint32_t val)
    {
        switch(addr) {
        case 12:
                SCRATCH = static_cast<uint32_t>((val & (0xffffffff << 0)) >> 0);
            break;
        case 16:
                DEVICE_ID = static_cast<DEVICE_ID_t>((val & (0xffff << 0)) >> 0);
            break;
        case 4096:
                RF0_ATR_OPTION = static_cast<RF0_ATR_OPTION_t>((val & (0x1 << 0)) >> 0);
                RF1_ATR_OPTION = static_cast<RF1_ATR_OPTION_t>((val & (0x1 << 1)) >> 1);
                RF2_ATR_OPTION = static_cast<RF2_ATR_OPTION_t>((val & (0x1 << 2)) >> 2);
                RF3_ATR_OPTION = static_cast<RF3_ATR_OPTION_t>((val & (0x1 << 3)) >> 3);
            break;
        case 8192:
                SYNC0_CTRL = static_cast<SYNC0_CTRL_t>((val & (0x7 << 0)) >> 0);
            break;
        case 8196:
                SYNC1_CTRL = static_cast<SYNC1_CTRL_t>((val & (0x7 << 0)) >> 0);
            break;
        case 8200:
                SYNC2_CTRL = static_cast<SYNC2_CTRL_t>((val & (0x7 << 0)) >> 0);
            break;
        case 8204:
                SYNC3_CTRL = static_cast<SYNC3_CTRL_t>((val & (0x7 << 0)) >> 0);
            break;
        case 8208:
                SYNC4_CTRL = static_cast<SYNC4_CTRL_t>((val & (0x7 << 0)) >> 0);
            break;
        case 8216:
                IO_EXP_SETUP = static_cast<IO_EXP_SETUP_t>((val & (0x1 << 0)) >> 0);
            break;
        case 8220:
                IO_EXP_CONFIG = static_cast<IO_EXP_CONFIG_t>((val & (0x1 << 0)) >> 0);
            break;
        case 20480:
                LED0_ATR_OPTION = static_cast<LED0_ATR_OPTION_t>((val & (0x1 << 0)) >> 0);
                LED1_ATR_OPTION = static_cast<LED1_ATR_OPTION_t>((val & (0x1 << 1)) >> 1);
                LED2_ATR_OPTION = static_cast<LED2_ATR_OPTION_t>((val & (0x1 << 2)) >> 2);
                LED3_ATR_OPTION = static_cast<LED3_ATR_OPTION_t>((val & (0x1 << 3)) >> 3);
            break;
        case 24576:
                SYNC_CLK = static_cast<SYNC_CLK_t>((val & (0x1 << 0)) >> 0);
            break;
        default:
            break;
        }
        // Now the arrays
        // We can do this because all arrays have a base address that is a multiple
        // of 256 (0x100). In other words, this is a hack that only works if you
        // know exactly what you're doing, which is OK in this case, because it's in
        // this same file as the register map.
        const uint16_t array_offset = addr % 256;
        const uint16_t base_addr = addr - array_offset;
        const size_t index = array_offset / 4;
        switch(base_addr) {
            case 0:
                RF0_TDDS[index] = static_cast<RF0_TDDS_t>((val & (0x1 << 2)) >> 2);
                RF0_RX_RFS[index] = static_cast<RF0_RX_RFS_t>((val & (0x1 << 1)) >> 1);
                RF0_TX_RX_RFS[index] = static_cast<RF0_TX_RX_RFS_t>((val & (0x1 << 0)) >> 0);
            break;
            case 1024:
                RF1_TDDS[index] = static_cast<RF1_TDDS_t>((val & (0x1 << 2)) >> 2);
                RF1_RX_RFS[index] = static_cast<RF1_RX_RFS_t>((val & (0x1 << 1)) >> 1);
                RF1_TX_RX_RFS[index] = static_cast<RF1_TX_RX_RFS_t>((val & (0x1 << 0)) >> 0);
            break;
            case 2048:
                RF2_TDDS[index] = static_cast<RF2_TDDS_t>((val & (0x1 << 2)) >> 2);
                RF2_RX_RFS[index] = static_cast<RF2_RX_RFS_t>((val & (0x1 << 1)) >> 1);
                RF2_TX_RX_RFS[index] = static_cast<RF2_TX_RX_RFS_t>((val & (0x1 << 0)) >> 0);
            break;
            case 3072:
                RF3_TDDS[index] = static_cast<RF3_TDDS_t>((val & (0x1 << 2)) >> 2);
                RF3_RX_RFS[index] = static_cast<RF3_RX_RFS_t>((val & (0x1 << 1)) >> 1);
                RF3_TX_RX_RFS[index] = static_cast<RF3_TX_RX_RFS_t>((val & (0x1 << 0)) >> 0);
            break;
            case 16384:
                CH0_TRX1_LED_GR[index] = static_cast<CH0_TRX1_LED_GR_t>((val & (0x1 << 2)) >> 2);
                CH0_TRX1_LED_RED[index] = static_cast<CH0_TRX1_LED_RED_t>((val & (0x1 << 1)) >> 1);
                CH0_RX2_LED[index] = static_cast<CH0_RX2_LED_t>((val & (0x1 << 0)) >> 0);
            break;
            case 17408:
                CH1_TRX1_LED_GR[index] = static_cast<CH1_TRX1_LED_GR_t>((val & (0x1 << 2)) >> 2);
                CH1_TRX1_LED_RED[index] = static_cast<CH1_TRX1_LED_RED_t>((val & (0x1 << 1)) >> 1);
                CH1_RX2_LED[index] = static_cast<CH1_RX2_LED_t>((val & (0x1 << 0)) >> 0);
            break;
            case 18432:
                CH2_TRX1_LED_GR[index] = static_cast<CH2_TRX1_LED_GR_t>((val & (0x1 << 2)) >> 2);
                CH2_TRX1_LED_RED[index] = static_cast<CH2_TRX1_LED_RED_t>((val & (0x1 << 1)) >> 1);
                CH2_RX2_LED[index] = static_cast<CH2_RX2_LED_t>((val & (0x1 << 0)) >> 0);
            break;
            case 19456:
                CH3_TRX1_LED_GR[index] = static_cast<CH3_TRX1_LED_GR_t>((val & (0x1 << 2)) >> 2);
                CH3_TRX1_LED_RED[index] = static_cast<CH3_TRX1_LED_RED_t>((val & (0x1 << 1)) >> 1);
                CH3_RX2_LED[index] = static_cast<CH3_RX2_LED_t>((val & (0x1 << 0)) >> 0);
            break;
            default: break;
        }
    }
    
    
    
    template<typename T> std::set<T> get_all_addrs(bool include_ro = false)
    {
        std::set<T> addrs;
        if (include_ro) {
            addrs.insert(16);
        }
        addrs.insert(0);
        addrs.insert(4);
        addrs.insert(8);
        addrs.insert(12);
        addrs.insert(16);
        addrs.insert(20);
        addrs.insert(24);
        addrs.insert(28);
        addrs.insert(32);
        addrs.insert(36);
        addrs.insert(40);
        addrs.insert(44);
        addrs.insert(48);
        addrs.insert(52);
        addrs.insert(56);
        addrs.insert(60);
        addrs.insert(64);
        addrs.insert(68);
        addrs.insert(72);
        addrs.insert(76);
        addrs.insert(80);
        addrs.insert(84);
        addrs.insert(88);
        addrs.insert(92);
        addrs.insert(96);
        addrs.insert(100);
        addrs.insert(104);
        addrs.insert(108);
        addrs.insert(112);
        addrs.insert(116);
        addrs.insert(120);
        addrs.insert(124);
        addrs.insert(128);
        addrs.insert(132);
        addrs.insert(136);
        addrs.insert(140);
        addrs.insert(144);
        addrs.insert(148);
        addrs.insert(152);
        addrs.insert(156);
        addrs.insert(160);
        addrs.insert(164);
        addrs.insert(168);
        addrs.insert(172);
        addrs.insert(176);
        addrs.insert(180);
        addrs.insert(184);
        addrs.insert(188);
        addrs.insert(192);
        addrs.insert(196);
        addrs.insert(200);
        addrs.insert(204);
        addrs.insert(208);
        addrs.insert(212);
        addrs.insert(216);
        addrs.insert(220);
        addrs.insert(224);
        addrs.insert(228);
        addrs.insert(232);
        addrs.insert(236);
        addrs.insert(240);
        addrs.insert(244);
        addrs.insert(248);
        addrs.insert(252);
        addrs.insert(256);
        addrs.insert(260);
        addrs.insert(264);
        addrs.insert(268);
        addrs.insert(272);
        addrs.insert(276);
        addrs.insert(280);
        addrs.insert(284);
        addrs.insert(288);
        addrs.insert(292);
        addrs.insert(296);
        addrs.insert(300);
        addrs.insert(304);
        addrs.insert(308);
        addrs.insert(312);
        addrs.insert(316);
        addrs.insert(320);
        addrs.insert(324);
        addrs.insert(328);
        addrs.insert(332);
        addrs.insert(336);
        addrs.insert(340);
        addrs.insert(344);
        addrs.insert(348);
        addrs.insert(352);
        addrs.insert(356);
        addrs.insert(360);
        addrs.insert(364);
        addrs.insert(368);
        addrs.insert(372);
        addrs.insert(376);
        addrs.insert(380);
        addrs.insert(384);
        addrs.insert(388);
        addrs.insert(392);
        addrs.insert(396);
        addrs.insert(400);
        addrs.insert(404);
        addrs.insert(408);
        addrs.insert(412);
        addrs.insert(416);
        addrs.insert(420);
        addrs.insert(424);
        addrs.insert(428);
        addrs.insert(432);
        addrs.insert(436);
        addrs.insert(440);
        addrs.insert(444);
        addrs.insert(448);
        addrs.insert(452);
        addrs.insert(456);
        addrs.insert(460);
        addrs.insert(464);
        addrs.insert(468);
        addrs.insert(472);
        addrs.insert(476);
        addrs.insert(480);
        addrs.insert(484);
        addrs.insert(488);
        addrs.insert(492);
        addrs.insert(496);
        addrs.insert(500);
        addrs.insert(504);
        addrs.insert(508);
        addrs.insert(512);
        addrs.insert(516);
        addrs.insert(520);
        addrs.insert(524);
        addrs.insert(528);
        addrs.insert(532);
        addrs.insert(536);
        addrs.insert(540);
        addrs.insert(544);
        addrs.insert(548);
        addrs.insert(552);
        addrs.insert(556);
        addrs.insert(560);
        addrs.insert(564);
        addrs.insert(568);
        addrs.insert(572);
        addrs.insert(576);
        addrs.insert(580);
        addrs.insert(584);
        addrs.insert(588);
        addrs.insert(592);
        addrs.insert(596);
        addrs.insert(600);
        addrs.insert(604);
        addrs.insert(608);
        addrs.insert(612);
        addrs.insert(616);
        addrs.insert(620);
        addrs.insert(624);
        addrs.insert(628);
        addrs.insert(632);
        addrs.insert(636);
        addrs.insert(640);
        addrs.insert(644);
        addrs.insert(648);
        addrs.insert(652);
        addrs.insert(656);
        addrs.insert(660);
        addrs.insert(664);
        addrs.insert(668);
        addrs.insert(672);
        addrs.insert(676);
        addrs.insert(680);
        addrs.insert(684);
        addrs.insert(688);
        addrs.insert(692);
        addrs.insert(696);
        addrs.insert(700);
        addrs.insert(704);
        addrs.insert(708);
        addrs.insert(712);
        addrs.insert(716);
        addrs.insert(720);
        addrs.insert(724);
        addrs.insert(728);
        addrs.insert(732);
        addrs.insert(736);
        addrs.insert(740);
        addrs.insert(744);
        addrs.insert(748);
        addrs.insert(752);
        addrs.insert(756);
        addrs.insert(760);
        addrs.insert(764);
        addrs.insert(768);
        addrs.insert(772);
        addrs.insert(776);
        addrs.insert(780);
        addrs.insert(784);
        addrs.insert(788);
        addrs.insert(792);
        addrs.insert(796);
        addrs.insert(800);
        addrs.insert(804);
        addrs.insert(808);
        addrs.insert(812);
        addrs.insert(816);
        addrs.insert(820);
        addrs.insert(824);
        addrs.insert(828);
        addrs.insert(832);
        addrs.insert(836);
        addrs.insert(840);
        addrs.insert(844);
        addrs.insert(848);
        addrs.insert(852);
        addrs.insert(856);
        addrs.insert(860);
        addrs.insert(864);
        addrs.insert(868);
        addrs.insert(872);
        addrs.insert(876);
        addrs.insert(880);
        addrs.insert(884);
        addrs.insert(888);
        addrs.insert(892);
        addrs.insert(896);
        addrs.insert(900);
        addrs.insert(904);
        addrs.insert(908);
        addrs.insert(912);
        addrs.insert(916);
        addrs.insert(920);
        addrs.insert(924);
        addrs.insert(928);
        addrs.insert(932);
        addrs.insert(936);
        addrs.insert(940);
        addrs.insert(944);
        addrs.insert(948);
        addrs.insert(952);
        addrs.insert(956);
        addrs.insert(960);
        addrs.insert(964);
        addrs.insert(968);
        addrs.insert(972);
        addrs.insert(976);
        addrs.insert(980);
        addrs.insert(984);
        addrs.insert(988);
        addrs.insert(992);
        addrs.insert(996);
        addrs.insert(1000);
        addrs.insert(1004);
        addrs.insert(1008);
        addrs.insert(1012);
        addrs.insert(1016);
        addrs.insert(1020);
        addrs.insert(1024);
        addrs.insert(1028);
        addrs.insert(1032);
        addrs.insert(1036);
        addrs.insert(1040);
        addrs.insert(1044);
        addrs.insert(1048);
        addrs.insert(1052);
        addrs.insert(1056);
        addrs.insert(1060);
        addrs.insert(1064);
        addrs.insert(1068);
        addrs.insert(1072);
        addrs.insert(1076);
        addrs.insert(1080);
        addrs.insert(1084);
        addrs.insert(1088);
        addrs.insert(1092);
        addrs.insert(1096);
        addrs.insert(1100);
        addrs.insert(1104);
        addrs.insert(1108);
        addrs.insert(1112);
        addrs.insert(1116);
        addrs.insert(1120);
        addrs.insert(1124);
        addrs.insert(1128);
        addrs.insert(1132);
        addrs.insert(1136);
        addrs.insert(1140);
        addrs.insert(1144);
        addrs.insert(1148);
        addrs.insert(1152);
        addrs.insert(1156);
        addrs.insert(1160);
        addrs.insert(1164);
        addrs.insert(1168);
        addrs.insert(1172);
        addrs.insert(1176);
        addrs.insert(1180);
        addrs.insert(1184);
        addrs.insert(1188);
        addrs.insert(1192);
        addrs.insert(1196);
        addrs.insert(1200);
        addrs.insert(1204);
        addrs.insert(1208);
        addrs.insert(1212);
        addrs.insert(1216);
        addrs.insert(1220);
        addrs.insert(1224);
        addrs.insert(1228);
        addrs.insert(1232);
        addrs.insert(1236);
        addrs.insert(1240);
        addrs.insert(1244);
        addrs.insert(1248);
        addrs.insert(1252);
        addrs.insert(1256);
        addrs.insert(1260);
        addrs.insert(1264);
        addrs.insert(1268);
        addrs.insert(1272);
        addrs.insert(1276);
        addrs.insert(1280);
        addrs.insert(1284);
        addrs.insert(1288);
        addrs.insert(1292);
        addrs.insert(1296);
        addrs.insert(1300);
        addrs.insert(1304);
        addrs.insert(1308);
        addrs.insert(1312);
        addrs.insert(1316);
        addrs.insert(1320);
        addrs.insert(1324);
        addrs.insert(1328);
        addrs.insert(1332);
        addrs.insert(1336);
        addrs.insert(1340);
        addrs.insert(1344);
        addrs.insert(1348);
        addrs.insert(1352);
        addrs.insert(1356);
        addrs.insert(1360);
        addrs.insert(1364);
        addrs.insert(1368);
        addrs.insert(1372);
        addrs.insert(1376);
        addrs.insert(1380);
        addrs.insert(1384);
        addrs.insert(1388);
        addrs.insert(1392);
        addrs.insert(1396);
        addrs.insert(1400);
        addrs.insert(1404);
        addrs.insert(1408);
        addrs.insert(1412);
        addrs.insert(1416);
        addrs.insert(1420);
        addrs.insert(1424);
        addrs.insert(1428);
        addrs.insert(1432);
        addrs.insert(1436);
        addrs.insert(1440);
        addrs.insert(1444);
        addrs.insert(1448);
        addrs.insert(1452);
        addrs.insert(1456);
        addrs.insert(1460);
        addrs.insert(1464);
        addrs.insert(1468);
        addrs.insert(1472);
        addrs.insert(1476);
        addrs.insert(1480);
        addrs.insert(1484);
        addrs.insert(1488);
        addrs.insert(1492);
        addrs.insert(1496);
        addrs.insert(1500);
        addrs.insert(1504);
        addrs.insert(1508);
        addrs.insert(1512);
        addrs.insert(1516);
        addrs.insert(1520);
        addrs.insert(1524);
        addrs.insert(1528);
        addrs.insert(1532);
        addrs.insert(1536);
        addrs.insert(1540);
        addrs.insert(1544);
        addrs.insert(1548);
        addrs.insert(1552);
        addrs.insert(1556);
        addrs.insert(1560);
        addrs.insert(1564);
        addrs.insert(1568);
        addrs.insert(1572);
        addrs.insert(1576);
        addrs.insert(1580);
        addrs.insert(1584);
        addrs.insert(1588);
        addrs.insert(1592);
        addrs.insert(1596);
        addrs.insert(1600);
        addrs.insert(1604);
        addrs.insert(1608);
        addrs.insert(1612);
        addrs.insert(1616);
        addrs.insert(1620);
        addrs.insert(1624);
        addrs.insert(1628);
        addrs.insert(1632);
        addrs.insert(1636);
        addrs.insert(1640);
        addrs.insert(1644);
        addrs.insert(1648);
        addrs.insert(1652);
        addrs.insert(1656);
        addrs.insert(1660);
        addrs.insert(1664);
        addrs.insert(1668);
        addrs.insert(1672);
        addrs.insert(1676);
        addrs.insert(1680);
        addrs.insert(1684);
        addrs.insert(1688);
        addrs.insert(1692);
        addrs.insert(1696);
        addrs.insert(1700);
        addrs.insert(1704);
        addrs.insert(1708);
        addrs.insert(1712);
        addrs.insert(1716);
        addrs.insert(1720);
        addrs.insert(1724);
        addrs.insert(1728);
        addrs.insert(1732);
        addrs.insert(1736);
        addrs.insert(1740);
        addrs.insert(1744);
        addrs.insert(1748);
        addrs.insert(1752);
        addrs.insert(1756);
        addrs.insert(1760);
        addrs.insert(1764);
        addrs.insert(1768);
        addrs.insert(1772);
        addrs.insert(1776);
        addrs.insert(1780);
        addrs.insert(1784);
        addrs.insert(1788);
        addrs.insert(1792);
        addrs.insert(1796);
        addrs.insert(1800);
        addrs.insert(1804);
        addrs.insert(1808);
        addrs.insert(1812);
        addrs.insert(1816);
        addrs.insert(1820);
        addrs.insert(1824);
        addrs.insert(1828);
        addrs.insert(1832);
        addrs.insert(1836);
        addrs.insert(1840);
        addrs.insert(1844);
        addrs.insert(1848);
        addrs.insert(1852);
        addrs.insert(1856);
        addrs.insert(1860);
        addrs.insert(1864);
        addrs.insert(1868);
        addrs.insert(1872);
        addrs.insert(1876);
        addrs.insert(1880);
        addrs.insert(1884);
        addrs.insert(1888);
        addrs.insert(1892);
        addrs.insert(1896);
        addrs.insert(1900);
        addrs.insert(1904);
        addrs.insert(1908);
        addrs.insert(1912);
        addrs.insert(1916);
        addrs.insert(1920);
        addrs.insert(1924);
        addrs.insert(1928);
        addrs.insert(1932);
        addrs.insert(1936);
        addrs.insert(1940);
        addrs.insert(1944);
        addrs.insert(1948);
        addrs.insert(1952);
        addrs.insert(1956);
        addrs.insert(1960);
        addrs.insert(1964);
        addrs.insert(1968);
        addrs.insert(1972);
        addrs.insert(1976);
        addrs.insert(1980);
        addrs.insert(1984);
        addrs.insert(1988);
        addrs.insert(1992);
        addrs.insert(1996);
        addrs.insert(2000);
        addrs.insert(2004);
        addrs.insert(2008);
        addrs.insert(2012);
        addrs.insert(2016);
        addrs.insert(2020);
        addrs.insert(2024);
        addrs.insert(2028);
        addrs.insert(2032);
        addrs.insert(2036);
        addrs.insert(2040);
        addrs.insert(2044);
        addrs.insert(2048);
        addrs.insert(2052);
        addrs.insert(2056);
        addrs.insert(2060);
        addrs.insert(2064);
        addrs.insert(2068);
        addrs.insert(2072);
        addrs.insert(2076);
        addrs.insert(2080);
        addrs.insert(2084);
        addrs.insert(2088);
        addrs.insert(2092);
        addrs.insert(2096);
        addrs.insert(2100);
        addrs.insert(2104);
        addrs.insert(2108);
        addrs.insert(2112);
        addrs.insert(2116);
        addrs.insert(2120);
        addrs.insert(2124);
        addrs.insert(2128);
        addrs.insert(2132);
        addrs.insert(2136);
        addrs.insert(2140);
        addrs.insert(2144);
        addrs.insert(2148);
        addrs.insert(2152);
        addrs.insert(2156);
        addrs.insert(2160);
        addrs.insert(2164);
        addrs.insert(2168);
        addrs.insert(2172);
        addrs.insert(2176);
        addrs.insert(2180);
        addrs.insert(2184);
        addrs.insert(2188);
        addrs.insert(2192);
        addrs.insert(2196);
        addrs.insert(2200);
        addrs.insert(2204);
        addrs.insert(2208);
        addrs.insert(2212);
        addrs.insert(2216);
        addrs.insert(2220);
        addrs.insert(2224);
        addrs.insert(2228);
        addrs.insert(2232);
        addrs.insert(2236);
        addrs.insert(2240);
        addrs.insert(2244);
        addrs.insert(2248);
        addrs.insert(2252);
        addrs.insert(2256);
        addrs.insert(2260);
        addrs.insert(2264);
        addrs.insert(2268);
        addrs.insert(2272);
        addrs.insert(2276);
        addrs.insert(2280);
        addrs.insert(2284);
        addrs.insert(2288);
        addrs.insert(2292);
        addrs.insert(2296);
        addrs.insert(2300);
        addrs.insert(2304);
        addrs.insert(2308);
        addrs.insert(2312);
        addrs.insert(2316);
        addrs.insert(2320);
        addrs.insert(2324);
        addrs.insert(2328);
        addrs.insert(2332);
        addrs.insert(2336);
        addrs.insert(2340);
        addrs.insert(2344);
        addrs.insert(2348);
        addrs.insert(2352);
        addrs.insert(2356);
        addrs.insert(2360);
        addrs.insert(2364);
        addrs.insert(2368);
        addrs.insert(2372);
        addrs.insert(2376);
        addrs.insert(2380);
        addrs.insert(2384);
        addrs.insert(2388);
        addrs.insert(2392);
        addrs.insert(2396);
        addrs.insert(2400);
        addrs.insert(2404);
        addrs.insert(2408);
        addrs.insert(2412);
        addrs.insert(2416);
        addrs.insert(2420);
        addrs.insert(2424);
        addrs.insert(2428);
        addrs.insert(2432);
        addrs.insert(2436);
        addrs.insert(2440);
        addrs.insert(2444);
        addrs.insert(2448);
        addrs.insert(2452);
        addrs.insert(2456);
        addrs.insert(2460);
        addrs.insert(2464);
        addrs.insert(2468);
        addrs.insert(2472);
        addrs.insert(2476);
        addrs.insert(2480);
        addrs.insert(2484);
        addrs.insert(2488);
        addrs.insert(2492);
        addrs.insert(2496);
        addrs.insert(2500);
        addrs.insert(2504);
        addrs.insert(2508);
        addrs.insert(2512);
        addrs.insert(2516);
        addrs.insert(2520);
        addrs.insert(2524);
        addrs.insert(2528);
        addrs.insert(2532);
        addrs.insert(2536);
        addrs.insert(2540);
        addrs.insert(2544);
        addrs.insert(2548);
        addrs.insert(2552);
        addrs.insert(2556);
        addrs.insert(2560);
        addrs.insert(2564);
        addrs.insert(2568);
        addrs.insert(2572);
        addrs.insert(2576);
        addrs.insert(2580);
        addrs.insert(2584);
        addrs.insert(2588);
        addrs.insert(2592);
        addrs.insert(2596);
        addrs.insert(2600);
        addrs.insert(2604);
        addrs.insert(2608);
        addrs.insert(2612);
        addrs.insert(2616);
        addrs.insert(2620);
        addrs.insert(2624);
        addrs.insert(2628);
        addrs.insert(2632);
        addrs.insert(2636);
        addrs.insert(2640);
        addrs.insert(2644);
        addrs.insert(2648);
        addrs.insert(2652);
        addrs.insert(2656);
        addrs.insert(2660);
        addrs.insert(2664);
        addrs.insert(2668);
        addrs.insert(2672);
        addrs.insert(2676);
        addrs.insert(2680);
        addrs.insert(2684);
        addrs.insert(2688);
        addrs.insert(2692);
        addrs.insert(2696);
        addrs.insert(2700);
        addrs.insert(2704);
        addrs.insert(2708);
        addrs.insert(2712);
        addrs.insert(2716);
        addrs.insert(2720);
        addrs.insert(2724);
        addrs.insert(2728);
        addrs.insert(2732);
        addrs.insert(2736);
        addrs.insert(2740);
        addrs.insert(2744);
        addrs.insert(2748);
        addrs.insert(2752);
        addrs.insert(2756);
        addrs.insert(2760);
        addrs.insert(2764);
        addrs.insert(2768);
        addrs.insert(2772);
        addrs.insert(2776);
        addrs.insert(2780);
        addrs.insert(2784);
        addrs.insert(2788);
        addrs.insert(2792);
        addrs.insert(2796);
        addrs.insert(2800);
        addrs.insert(2804);
        addrs.insert(2808);
        addrs.insert(2812);
        addrs.insert(2816);
        addrs.insert(2820);
        addrs.insert(2824);
        addrs.insert(2828);
        addrs.insert(2832);
        addrs.insert(2836);
        addrs.insert(2840);
        addrs.insert(2844);
        addrs.insert(2848);
        addrs.insert(2852);
        addrs.insert(2856);
        addrs.insert(2860);
        addrs.insert(2864);
        addrs.insert(2868);
        addrs.insert(2872);
        addrs.insert(2876);
        addrs.insert(2880);
        addrs.insert(2884);
        addrs.insert(2888);
        addrs.insert(2892);
        addrs.insert(2896);
        addrs.insert(2900);
        addrs.insert(2904);
        addrs.insert(2908);
        addrs.insert(2912);
        addrs.insert(2916);
        addrs.insert(2920);
        addrs.insert(2924);
        addrs.insert(2928);
        addrs.insert(2932);
        addrs.insert(2936);
        addrs.insert(2940);
        addrs.insert(2944);
        addrs.insert(2948);
        addrs.insert(2952);
        addrs.insert(2956);
        addrs.insert(2960);
        addrs.insert(2964);
        addrs.insert(2968);
        addrs.insert(2972);
        addrs.insert(2976);
        addrs.insert(2980);
        addrs.insert(2984);
        addrs.insert(2988);
        addrs.insert(2992);
        addrs.insert(2996);
        addrs.insert(3000);
        addrs.insert(3004);
        addrs.insert(3008);
        addrs.insert(3012);
        addrs.insert(3016);
        addrs.insert(3020);
        addrs.insert(3024);
        addrs.insert(3028);
        addrs.insert(3032);
        addrs.insert(3036);
        addrs.insert(3040);
        addrs.insert(3044);
        addrs.insert(3048);
        addrs.insert(3052);
        addrs.insert(3056);
        addrs.insert(3060);
        addrs.insert(3064);
        addrs.insert(3068);
        addrs.insert(3072);
        addrs.insert(3076);
        addrs.insert(3080);
        addrs.insert(3084);
        addrs.insert(3088);
        addrs.insert(3092);
        addrs.insert(3096);
        addrs.insert(3100);
        addrs.insert(3104);
        addrs.insert(3108);
        addrs.insert(3112);
        addrs.insert(3116);
        addrs.insert(3120);
        addrs.insert(3124);
        addrs.insert(3128);
        addrs.insert(3132);
        addrs.insert(3136);
        addrs.insert(3140);
        addrs.insert(3144);
        addrs.insert(3148);
        addrs.insert(3152);
        addrs.insert(3156);
        addrs.insert(3160);
        addrs.insert(3164);
        addrs.insert(3168);
        addrs.insert(3172);
        addrs.insert(3176);
        addrs.insert(3180);
        addrs.insert(3184);
        addrs.insert(3188);
        addrs.insert(3192);
        addrs.insert(3196);
        addrs.insert(3200);
        addrs.insert(3204);
        addrs.insert(3208);
        addrs.insert(3212);
        addrs.insert(3216);
        addrs.insert(3220);
        addrs.insert(3224);
        addrs.insert(3228);
        addrs.insert(3232);
        addrs.insert(3236);
        addrs.insert(3240);
        addrs.insert(3244);
        addrs.insert(3248);
        addrs.insert(3252);
        addrs.insert(3256);
        addrs.insert(3260);
        addrs.insert(3264);
        addrs.insert(3268);
        addrs.insert(3272);
        addrs.insert(3276);
        addrs.insert(3280);
        addrs.insert(3284);
        addrs.insert(3288);
        addrs.insert(3292);
        addrs.insert(3296);
        addrs.insert(3300);
        addrs.insert(3304);
        addrs.insert(3308);
        addrs.insert(3312);
        addrs.insert(3316);
        addrs.insert(3320);
        addrs.insert(3324);
        addrs.insert(3328);
        addrs.insert(3332);
        addrs.insert(3336);
        addrs.insert(3340);
        addrs.insert(3344);
        addrs.insert(3348);
        addrs.insert(3352);
        addrs.insert(3356);
        addrs.insert(3360);
        addrs.insert(3364);
        addrs.insert(3368);
        addrs.insert(3372);
        addrs.insert(3376);
        addrs.insert(3380);
        addrs.insert(3384);
        addrs.insert(3388);
        addrs.insert(3392);
        addrs.insert(3396);
        addrs.insert(3400);
        addrs.insert(3404);
        addrs.insert(3408);
        addrs.insert(3412);
        addrs.insert(3416);
        addrs.insert(3420);
        addrs.insert(3424);
        addrs.insert(3428);
        addrs.insert(3432);
        addrs.insert(3436);
        addrs.insert(3440);
        addrs.insert(3444);
        addrs.insert(3448);
        addrs.insert(3452);
        addrs.insert(3456);
        addrs.insert(3460);
        addrs.insert(3464);
        addrs.insert(3468);
        addrs.insert(3472);
        addrs.insert(3476);
        addrs.insert(3480);
        addrs.insert(3484);
        addrs.insert(3488);
        addrs.insert(3492);
        addrs.insert(3496);
        addrs.insert(3500);
        addrs.insert(3504);
        addrs.insert(3508);
        addrs.insert(3512);
        addrs.insert(3516);
        addrs.insert(3520);
        addrs.insert(3524);
        addrs.insert(3528);
        addrs.insert(3532);
        addrs.insert(3536);
        addrs.insert(3540);
        addrs.insert(3544);
        addrs.insert(3548);
        addrs.insert(3552);
        addrs.insert(3556);
        addrs.insert(3560);
        addrs.insert(3564);
        addrs.insert(3568);
        addrs.insert(3572);
        addrs.insert(3576);
        addrs.insert(3580);
        addrs.insert(3584);
        addrs.insert(3588);
        addrs.insert(3592);
        addrs.insert(3596);
        addrs.insert(3600);
        addrs.insert(3604);
        addrs.insert(3608);
        addrs.insert(3612);
        addrs.insert(3616);
        addrs.insert(3620);
        addrs.insert(3624);
        addrs.insert(3628);
        addrs.insert(3632);
        addrs.insert(3636);
        addrs.insert(3640);
        addrs.insert(3644);
        addrs.insert(3648);
        addrs.insert(3652);
        addrs.insert(3656);
        addrs.insert(3660);
        addrs.insert(3664);
        addrs.insert(3668);
        addrs.insert(3672);
        addrs.insert(3676);
        addrs.insert(3680);
        addrs.insert(3684);
        addrs.insert(3688);
        addrs.insert(3692);
        addrs.insert(3696);
        addrs.insert(3700);
        addrs.insert(3704);
        addrs.insert(3708);
        addrs.insert(3712);
        addrs.insert(3716);
        addrs.insert(3720);
        addrs.insert(3724);
        addrs.insert(3728);
        addrs.insert(3732);
        addrs.insert(3736);
        addrs.insert(3740);
        addrs.insert(3744);
        addrs.insert(3748);
        addrs.insert(3752);
        addrs.insert(3756);
        addrs.insert(3760);
        addrs.insert(3764);
        addrs.insert(3768);
        addrs.insert(3772);
        addrs.insert(3776);
        addrs.insert(3780);
        addrs.insert(3784);
        addrs.insert(3788);
        addrs.insert(3792);
        addrs.insert(3796);
        addrs.insert(3800);
        addrs.insert(3804);
        addrs.insert(3808);
        addrs.insert(3812);
        addrs.insert(3816);
        addrs.insert(3820);
        addrs.insert(3824);
        addrs.insert(3828);
        addrs.insert(3832);
        addrs.insert(3836);
        addrs.insert(3840);
        addrs.insert(3844);
        addrs.insert(3848);
        addrs.insert(3852);
        addrs.insert(3856);
        addrs.insert(3860);
        addrs.insert(3864);
        addrs.insert(3868);
        addrs.insert(3872);
        addrs.insert(3876);
        addrs.insert(3880);
        addrs.insert(3884);
        addrs.insert(3888);
        addrs.insert(3892);
        addrs.insert(3896);
        addrs.insert(3900);
        addrs.insert(3904);
        addrs.insert(3908);
        addrs.insert(3912);
        addrs.insert(3916);
        addrs.insert(3920);
        addrs.insert(3924);
        addrs.insert(3928);
        addrs.insert(3932);
        addrs.insert(3936);
        addrs.insert(3940);
        addrs.insert(3944);
        addrs.insert(3948);
        addrs.insert(3952);
        addrs.insert(3956);
        addrs.insert(3960);
        addrs.insert(3964);
        addrs.insert(3968);
        addrs.insert(3972);
        addrs.insert(3976);
        addrs.insert(3980);
        addrs.insert(3984);
        addrs.insert(3988);
        addrs.insert(3992);
        addrs.insert(3996);
        addrs.insert(4000);
        addrs.insert(4004);
        addrs.insert(4008);
        addrs.insert(4012);
        addrs.insert(4016);
        addrs.insert(4020);
        addrs.insert(4024);
        addrs.insert(4028);
        addrs.insert(4032);
        addrs.insert(4036);
        addrs.insert(4040);
        addrs.insert(4044);
        addrs.insert(4048);
        addrs.insert(4052);
        addrs.insert(4056);
        addrs.insert(4060);
        addrs.insert(4064);
        addrs.insert(4068);
        addrs.insert(4072);
        addrs.insert(4076);
        addrs.insert(4080);
        addrs.insert(4084);
        addrs.insert(4088);
        addrs.insert(4092);
        addrs.insert(4096);
        addrs.insert(8192);
        addrs.insert(8196);
        addrs.insert(8200);
        addrs.insert(8204);
        addrs.insert(8208);
        addrs.insert(8216);
        addrs.insert(8220);
        addrs.insert(16384);
        addrs.insert(16388);
        addrs.insert(16392);
        addrs.insert(16396);
        addrs.insert(16400);
        addrs.insert(16404);
        addrs.insert(16408);
        addrs.insert(16412);
        addrs.insert(16416);
        addrs.insert(16420);
        addrs.insert(16424);
        addrs.insert(16428);
        addrs.insert(16432);
        addrs.insert(16436);
        addrs.insert(16440);
        addrs.insert(16444);
        addrs.insert(16448);
        addrs.insert(16452);
        addrs.insert(16456);
        addrs.insert(16460);
        addrs.insert(16464);
        addrs.insert(16468);
        addrs.insert(16472);
        addrs.insert(16476);
        addrs.insert(16480);
        addrs.insert(16484);
        addrs.insert(16488);
        addrs.insert(16492);
        addrs.insert(16496);
        addrs.insert(16500);
        addrs.insert(16504);
        addrs.insert(16508);
        addrs.insert(16512);
        addrs.insert(16516);
        addrs.insert(16520);
        addrs.insert(16524);
        addrs.insert(16528);
        addrs.insert(16532);
        addrs.insert(16536);
        addrs.insert(16540);
        addrs.insert(16544);
        addrs.insert(16548);
        addrs.insert(16552);
        addrs.insert(16556);
        addrs.insert(16560);
        addrs.insert(16564);
        addrs.insert(16568);
        addrs.insert(16572);
        addrs.insert(16576);
        addrs.insert(16580);
        addrs.insert(16584);
        addrs.insert(16588);
        addrs.insert(16592);
        addrs.insert(16596);
        addrs.insert(16600);
        addrs.insert(16604);
        addrs.insert(16608);
        addrs.insert(16612);
        addrs.insert(16616);
        addrs.insert(16620);
        addrs.insert(16624);
        addrs.insert(16628);
        addrs.insert(16632);
        addrs.insert(16636);
        addrs.insert(16640);
        addrs.insert(16644);
        addrs.insert(16648);
        addrs.insert(16652);
        addrs.insert(16656);
        addrs.insert(16660);
        addrs.insert(16664);
        addrs.insert(16668);
        addrs.insert(16672);
        addrs.insert(16676);
        addrs.insert(16680);
        addrs.insert(16684);
        addrs.insert(16688);
        addrs.insert(16692);
        addrs.insert(16696);
        addrs.insert(16700);
        addrs.insert(16704);
        addrs.insert(16708);
        addrs.insert(16712);
        addrs.insert(16716);
        addrs.insert(16720);
        addrs.insert(16724);
        addrs.insert(16728);
        addrs.insert(16732);
        addrs.insert(16736);
        addrs.insert(16740);
        addrs.insert(16744);
        addrs.insert(16748);
        addrs.insert(16752);
        addrs.insert(16756);
        addrs.insert(16760);
        addrs.insert(16764);
        addrs.insert(16768);
        addrs.insert(16772);
        addrs.insert(16776);
        addrs.insert(16780);
        addrs.insert(16784);
        addrs.insert(16788);
        addrs.insert(16792);
        addrs.insert(16796);
        addrs.insert(16800);
        addrs.insert(16804);
        addrs.insert(16808);
        addrs.insert(16812);
        addrs.insert(16816);
        addrs.insert(16820);
        addrs.insert(16824);
        addrs.insert(16828);
        addrs.insert(16832);
        addrs.insert(16836);
        addrs.insert(16840);
        addrs.insert(16844);
        addrs.insert(16848);
        addrs.insert(16852);
        addrs.insert(16856);
        addrs.insert(16860);
        addrs.insert(16864);
        addrs.insert(16868);
        addrs.insert(16872);
        addrs.insert(16876);
        addrs.insert(16880);
        addrs.insert(16884);
        addrs.insert(16888);
        addrs.insert(16892);
        addrs.insert(16896);
        addrs.insert(16900);
        addrs.insert(16904);
        addrs.insert(16908);
        addrs.insert(16912);
        addrs.insert(16916);
        addrs.insert(16920);
        addrs.insert(16924);
        addrs.insert(16928);
        addrs.insert(16932);
        addrs.insert(16936);
        addrs.insert(16940);
        addrs.insert(16944);
        addrs.insert(16948);
        addrs.insert(16952);
        addrs.insert(16956);
        addrs.insert(16960);
        addrs.insert(16964);
        addrs.insert(16968);
        addrs.insert(16972);
        addrs.insert(16976);
        addrs.insert(16980);
        addrs.insert(16984);
        addrs.insert(16988);
        addrs.insert(16992);
        addrs.insert(16996);
        addrs.insert(17000);
        addrs.insert(17004);
        addrs.insert(17008);
        addrs.insert(17012);
        addrs.insert(17016);
        addrs.insert(17020);
        addrs.insert(17024);
        addrs.insert(17028);
        addrs.insert(17032);
        addrs.insert(17036);
        addrs.insert(17040);
        addrs.insert(17044);
        addrs.insert(17048);
        addrs.insert(17052);
        addrs.insert(17056);
        addrs.insert(17060);
        addrs.insert(17064);
        addrs.insert(17068);
        addrs.insert(17072);
        addrs.insert(17076);
        addrs.insert(17080);
        addrs.insert(17084);
        addrs.insert(17088);
        addrs.insert(17092);
        addrs.insert(17096);
        addrs.insert(17100);
        addrs.insert(17104);
        addrs.insert(17108);
        addrs.insert(17112);
        addrs.insert(17116);
        addrs.insert(17120);
        addrs.insert(17124);
        addrs.insert(17128);
        addrs.insert(17132);
        addrs.insert(17136);
        addrs.insert(17140);
        addrs.insert(17144);
        addrs.insert(17148);
        addrs.insert(17152);
        addrs.insert(17156);
        addrs.insert(17160);
        addrs.insert(17164);
        addrs.insert(17168);
        addrs.insert(17172);
        addrs.insert(17176);
        addrs.insert(17180);
        addrs.insert(17184);
        addrs.insert(17188);
        addrs.insert(17192);
        addrs.insert(17196);
        addrs.insert(17200);
        addrs.insert(17204);
        addrs.insert(17208);
        addrs.insert(17212);
        addrs.insert(17216);
        addrs.insert(17220);
        addrs.insert(17224);
        addrs.insert(17228);
        addrs.insert(17232);
        addrs.insert(17236);
        addrs.insert(17240);
        addrs.insert(17244);
        addrs.insert(17248);
        addrs.insert(17252);
        addrs.insert(17256);
        addrs.insert(17260);
        addrs.insert(17264);
        addrs.insert(17268);
        addrs.insert(17272);
        addrs.insert(17276);
        addrs.insert(17280);
        addrs.insert(17284);
        addrs.insert(17288);
        addrs.insert(17292);
        addrs.insert(17296);
        addrs.insert(17300);
        addrs.insert(17304);
        addrs.insert(17308);
        addrs.insert(17312);
        addrs.insert(17316);
        addrs.insert(17320);
        addrs.insert(17324);
        addrs.insert(17328);
        addrs.insert(17332);
        addrs.insert(17336);
        addrs.insert(17340);
        addrs.insert(17344);
        addrs.insert(17348);
        addrs.insert(17352);
        addrs.insert(17356);
        addrs.insert(17360);
        addrs.insert(17364);
        addrs.insert(17368);
        addrs.insert(17372);
        addrs.insert(17376);
        addrs.insert(17380);
        addrs.insert(17384);
        addrs.insert(17388);
        addrs.insert(17392);
        addrs.insert(17396);
        addrs.insert(17400);
        addrs.insert(17404);
        addrs.insert(17408);
        addrs.insert(17412);
        addrs.insert(17416);
        addrs.insert(17420);
        addrs.insert(17424);
        addrs.insert(17428);
        addrs.insert(17432);
        addrs.insert(17436);
        addrs.insert(17440);
        addrs.insert(17444);
        addrs.insert(17448);
        addrs.insert(17452);
        addrs.insert(17456);
        addrs.insert(17460);
        addrs.insert(17464);
        addrs.insert(17468);
        addrs.insert(17472);
        addrs.insert(17476);
        addrs.insert(17480);
        addrs.insert(17484);
        addrs.insert(17488);
        addrs.insert(17492);
        addrs.insert(17496);
        addrs.insert(17500);
        addrs.insert(17504);
        addrs.insert(17508);
        addrs.insert(17512);
        addrs.insert(17516);
        addrs.insert(17520);
        addrs.insert(17524);
        addrs.insert(17528);
        addrs.insert(17532);
        addrs.insert(17536);
        addrs.insert(17540);
        addrs.insert(17544);
        addrs.insert(17548);
        addrs.insert(17552);
        addrs.insert(17556);
        addrs.insert(17560);
        addrs.insert(17564);
        addrs.insert(17568);
        addrs.insert(17572);
        addrs.insert(17576);
        addrs.insert(17580);
        addrs.insert(17584);
        addrs.insert(17588);
        addrs.insert(17592);
        addrs.insert(17596);
        addrs.insert(17600);
        addrs.insert(17604);
        addrs.insert(17608);
        addrs.insert(17612);
        addrs.insert(17616);
        addrs.insert(17620);
        addrs.insert(17624);
        addrs.insert(17628);
        addrs.insert(17632);
        addrs.insert(17636);
        addrs.insert(17640);
        addrs.insert(17644);
        addrs.insert(17648);
        addrs.insert(17652);
        addrs.insert(17656);
        addrs.insert(17660);
        addrs.insert(17664);
        addrs.insert(17668);
        addrs.insert(17672);
        addrs.insert(17676);
        addrs.insert(17680);
        addrs.insert(17684);
        addrs.insert(17688);
        addrs.insert(17692);
        addrs.insert(17696);
        addrs.insert(17700);
        addrs.insert(17704);
        addrs.insert(17708);
        addrs.insert(17712);
        addrs.insert(17716);
        addrs.insert(17720);
        addrs.insert(17724);
        addrs.insert(17728);
        addrs.insert(17732);
        addrs.insert(17736);
        addrs.insert(17740);
        addrs.insert(17744);
        addrs.insert(17748);
        addrs.insert(17752);
        addrs.insert(17756);
        addrs.insert(17760);
        addrs.insert(17764);
        addrs.insert(17768);
        addrs.insert(17772);
        addrs.insert(17776);
        addrs.insert(17780);
        addrs.insert(17784);
        addrs.insert(17788);
        addrs.insert(17792);
        addrs.insert(17796);
        addrs.insert(17800);
        addrs.insert(17804);
        addrs.insert(17808);
        addrs.insert(17812);
        addrs.insert(17816);
        addrs.insert(17820);
        addrs.insert(17824);
        addrs.insert(17828);
        addrs.insert(17832);
        addrs.insert(17836);
        addrs.insert(17840);
        addrs.insert(17844);
        addrs.insert(17848);
        addrs.insert(17852);
        addrs.insert(17856);
        addrs.insert(17860);
        addrs.insert(17864);
        addrs.insert(17868);
        addrs.insert(17872);
        addrs.insert(17876);
        addrs.insert(17880);
        addrs.insert(17884);
        addrs.insert(17888);
        addrs.insert(17892);
        addrs.insert(17896);
        addrs.insert(17900);
        addrs.insert(17904);
        addrs.insert(17908);
        addrs.insert(17912);
        addrs.insert(17916);
        addrs.insert(17920);
        addrs.insert(17924);
        addrs.insert(17928);
        addrs.insert(17932);
        addrs.insert(17936);
        addrs.insert(17940);
        addrs.insert(17944);
        addrs.insert(17948);
        addrs.insert(17952);
        addrs.insert(17956);
        addrs.insert(17960);
        addrs.insert(17964);
        addrs.insert(17968);
        addrs.insert(17972);
        addrs.insert(17976);
        addrs.insert(17980);
        addrs.insert(17984);
        addrs.insert(17988);
        addrs.insert(17992);
        addrs.insert(17996);
        addrs.insert(18000);
        addrs.insert(18004);
        addrs.insert(18008);
        addrs.insert(18012);
        addrs.insert(18016);
        addrs.insert(18020);
        addrs.insert(18024);
        addrs.insert(18028);
        addrs.insert(18032);
        addrs.insert(18036);
        addrs.insert(18040);
        addrs.insert(18044);
        addrs.insert(18048);
        addrs.insert(18052);
        addrs.insert(18056);
        addrs.insert(18060);
        addrs.insert(18064);
        addrs.insert(18068);
        addrs.insert(18072);
        addrs.insert(18076);
        addrs.insert(18080);
        addrs.insert(18084);
        addrs.insert(18088);
        addrs.insert(18092);
        addrs.insert(18096);
        addrs.insert(18100);
        addrs.insert(18104);
        addrs.insert(18108);
        addrs.insert(18112);
        addrs.insert(18116);
        addrs.insert(18120);
        addrs.insert(18124);
        addrs.insert(18128);
        addrs.insert(18132);
        addrs.insert(18136);
        addrs.insert(18140);
        addrs.insert(18144);
        addrs.insert(18148);
        addrs.insert(18152);
        addrs.insert(18156);
        addrs.insert(18160);
        addrs.insert(18164);
        addrs.insert(18168);
        addrs.insert(18172);
        addrs.insert(18176);
        addrs.insert(18180);
        addrs.insert(18184);
        addrs.insert(18188);
        addrs.insert(18192);
        addrs.insert(18196);
        addrs.insert(18200);
        addrs.insert(18204);
        addrs.insert(18208);
        addrs.insert(18212);
        addrs.insert(18216);
        addrs.insert(18220);
        addrs.insert(18224);
        addrs.insert(18228);
        addrs.insert(18232);
        addrs.insert(18236);
        addrs.insert(18240);
        addrs.insert(18244);
        addrs.insert(18248);
        addrs.insert(18252);
        addrs.insert(18256);
        addrs.insert(18260);
        addrs.insert(18264);
        addrs.insert(18268);
        addrs.insert(18272);
        addrs.insert(18276);
        addrs.insert(18280);
        addrs.insert(18284);
        addrs.insert(18288);
        addrs.insert(18292);
        addrs.insert(18296);
        addrs.insert(18300);
        addrs.insert(18304);
        addrs.insert(18308);
        addrs.insert(18312);
        addrs.insert(18316);
        addrs.insert(18320);
        addrs.insert(18324);
        addrs.insert(18328);
        addrs.insert(18332);
        addrs.insert(18336);
        addrs.insert(18340);
        addrs.insert(18344);
        addrs.insert(18348);
        addrs.insert(18352);
        addrs.insert(18356);
        addrs.insert(18360);
        addrs.insert(18364);
        addrs.insert(18368);
        addrs.insert(18372);
        addrs.insert(18376);
        addrs.insert(18380);
        addrs.insert(18384);
        addrs.insert(18388);
        addrs.insert(18392);
        addrs.insert(18396);
        addrs.insert(18400);
        addrs.insert(18404);
        addrs.insert(18408);
        addrs.insert(18412);
        addrs.insert(18416);
        addrs.insert(18420);
        addrs.insert(18424);
        addrs.insert(18428);
        addrs.insert(18432);
        addrs.insert(18436);
        addrs.insert(18440);
        addrs.insert(18444);
        addrs.insert(18448);
        addrs.insert(18452);
        addrs.insert(18456);
        addrs.insert(18460);
        addrs.insert(18464);
        addrs.insert(18468);
        addrs.insert(18472);
        addrs.insert(18476);
        addrs.insert(18480);
        addrs.insert(18484);
        addrs.insert(18488);
        addrs.insert(18492);
        addrs.insert(18496);
        addrs.insert(18500);
        addrs.insert(18504);
        addrs.insert(18508);
        addrs.insert(18512);
        addrs.insert(18516);
        addrs.insert(18520);
        addrs.insert(18524);
        addrs.insert(18528);
        addrs.insert(18532);
        addrs.insert(18536);
        addrs.insert(18540);
        addrs.insert(18544);
        addrs.insert(18548);
        addrs.insert(18552);
        addrs.insert(18556);
        addrs.insert(18560);
        addrs.insert(18564);
        addrs.insert(18568);
        addrs.insert(18572);
        addrs.insert(18576);
        addrs.insert(18580);
        addrs.insert(18584);
        addrs.insert(18588);
        addrs.insert(18592);
        addrs.insert(18596);
        addrs.insert(18600);
        addrs.insert(18604);
        addrs.insert(18608);
        addrs.insert(18612);
        addrs.insert(18616);
        addrs.insert(18620);
        addrs.insert(18624);
        addrs.insert(18628);
        addrs.insert(18632);
        addrs.insert(18636);
        addrs.insert(18640);
        addrs.insert(18644);
        addrs.insert(18648);
        addrs.insert(18652);
        addrs.insert(18656);
        addrs.insert(18660);
        addrs.insert(18664);
        addrs.insert(18668);
        addrs.insert(18672);
        addrs.insert(18676);
        addrs.insert(18680);
        addrs.insert(18684);
        addrs.insert(18688);
        addrs.insert(18692);
        addrs.insert(18696);
        addrs.insert(18700);
        addrs.insert(18704);
        addrs.insert(18708);
        addrs.insert(18712);
        addrs.insert(18716);
        addrs.insert(18720);
        addrs.insert(18724);
        addrs.insert(18728);
        addrs.insert(18732);
        addrs.insert(18736);
        addrs.insert(18740);
        addrs.insert(18744);
        addrs.insert(18748);
        addrs.insert(18752);
        addrs.insert(18756);
        addrs.insert(18760);
        addrs.insert(18764);
        addrs.insert(18768);
        addrs.insert(18772);
        addrs.insert(18776);
        addrs.insert(18780);
        addrs.insert(18784);
        addrs.insert(18788);
        addrs.insert(18792);
        addrs.insert(18796);
        addrs.insert(18800);
        addrs.insert(18804);
        addrs.insert(18808);
        addrs.insert(18812);
        addrs.insert(18816);
        addrs.insert(18820);
        addrs.insert(18824);
        addrs.insert(18828);
        addrs.insert(18832);
        addrs.insert(18836);
        addrs.insert(18840);
        addrs.insert(18844);
        addrs.insert(18848);
        addrs.insert(18852);
        addrs.insert(18856);
        addrs.insert(18860);
        addrs.insert(18864);
        addrs.insert(18868);
        addrs.insert(18872);
        addrs.insert(18876);
        addrs.insert(18880);
        addrs.insert(18884);
        addrs.insert(18888);
        addrs.insert(18892);
        addrs.insert(18896);
        addrs.insert(18900);
        addrs.insert(18904);
        addrs.insert(18908);
        addrs.insert(18912);
        addrs.insert(18916);
        addrs.insert(18920);
        addrs.insert(18924);
        addrs.insert(18928);
        addrs.insert(18932);
        addrs.insert(18936);
        addrs.insert(18940);
        addrs.insert(18944);
        addrs.insert(18948);
        addrs.insert(18952);
        addrs.insert(18956);
        addrs.insert(18960);
        addrs.insert(18964);
        addrs.insert(18968);
        addrs.insert(18972);
        addrs.insert(18976);
        addrs.insert(18980);
        addrs.insert(18984);
        addrs.insert(18988);
        addrs.insert(18992);
        addrs.insert(18996);
        addrs.insert(19000);
        addrs.insert(19004);
        addrs.insert(19008);
        addrs.insert(19012);
        addrs.insert(19016);
        addrs.insert(19020);
        addrs.insert(19024);
        addrs.insert(19028);
        addrs.insert(19032);
        addrs.insert(19036);
        addrs.insert(19040);
        addrs.insert(19044);
        addrs.insert(19048);
        addrs.insert(19052);
        addrs.insert(19056);
        addrs.insert(19060);
        addrs.insert(19064);
        addrs.insert(19068);
        addrs.insert(19072);
        addrs.insert(19076);
        addrs.insert(19080);
        addrs.insert(19084);
        addrs.insert(19088);
        addrs.insert(19092);
        addrs.insert(19096);
        addrs.insert(19100);
        addrs.insert(19104);
        addrs.insert(19108);
        addrs.insert(19112);
        addrs.insert(19116);
        addrs.insert(19120);
        addrs.insert(19124);
        addrs.insert(19128);
        addrs.insert(19132);
        addrs.insert(19136);
        addrs.insert(19140);
        addrs.insert(19144);
        addrs.insert(19148);
        addrs.insert(19152);
        addrs.insert(19156);
        addrs.insert(19160);
        addrs.insert(19164);
        addrs.insert(19168);
        addrs.insert(19172);
        addrs.insert(19176);
        addrs.insert(19180);
        addrs.insert(19184);
        addrs.insert(19188);
        addrs.insert(19192);
        addrs.insert(19196);
        addrs.insert(19200);
        addrs.insert(19204);
        addrs.insert(19208);
        addrs.insert(19212);
        addrs.insert(19216);
        addrs.insert(19220);
        addrs.insert(19224);
        addrs.insert(19228);
        addrs.insert(19232);
        addrs.insert(19236);
        addrs.insert(19240);
        addrs.insert(19244);
        addrs.insert(19248);
        addrs.insert(19252);
        addrs.insert(19256);
        addrs.insert(19260);
        addrs.insert(19264);
        addrs.insert(19268);
        addrs.insert(19272);
        addrs.insert(19276);
        addrs.insert(19280);
        addrs.insert(19284);
        addrs.insert(19288);
        addrs.insert(19292);
        addrs.insert(19296);
        addrs.insert(19300);
        addrs.insert(19304);
        addrs.insert(19308);
        addrs.insert(19312);
        addrs.insert(19316);
        addrs.insert(19320);
        addrs.insert(19324);
        addrs.insert(19328);
        addrs.insert(19332);
        addrs.insert(19336);
        addrs.insert(19340);
        addrs.insert(19344);
        addrs.insert(19348);
        addrs.insert(19352);
        addrs.insert(19356);
        addrs.insert(19360);
        addrs.insert(19364);
        addrs.insert(19368);
        addrs.insert(19372);
        addrs.insert(19376);
        addrs.insert(19380);
        addrs.insert(19384);
        addrs.insert(19388);
        addrs.insert(19392);
        addrs.insert(19396);
        addrs.insert(19400);
        addrs.insert(19404);
        addrs.insert(19408);
        addrs.insert(19412);
        addrs.insert(19416);
        addrs.insert(19420);
        addrs.insert(19424);
        addrs.insert(19428);
        addrs.insert(19432);
        addrs.insert(19436);
        addrs.insert(19440);
        addrs.insert(19444);
        addrs.insert(19448);
        addrs.insert(19452);
        addrs.insert(19456);
        addrs.insert(19460);
        addrs.insert(19464);
        addrs.insert(19468);
        addrs.insert(19472);
        addrs.insert(19476);
        addrs.insert(19480);
        addrs.insert(19484);
        addrs.insert(19488);
        addrs.insert(19492);
        addrs.insert(19496);
        addrs.insert(19500);
        addrs.insert(19504);
        addrs.insert(19508);
        addrs.insert(19512);
        addrs.insert(19516);
        addrs.insert(19520);
        addrs.insert(19524);
        addrs.insert(19528);
        addrs.insert(19532);
        addrs.insert(19536);
        addrs.insert(19540);
        addrs.insert(19544);
        addrs.insert(19548);
        addrs.insert(19552);
        addrs.insert(19556);
        addrs.insert(19560);
        addrs.insert(19564);
        addrs.insert(19568);
        addrs.insert(19572);
        addrs.insert(19576);
        addrs.insert(19580);
        addrs.insert(19584);
        addrs.insert(19588);
        addrs.insert(19592);
        addrs.insert(19596);
        addrs.insert(19600);
        addrs.insert(19604);
        addrs.insert(19608);
        addrs.insert(19612);
        addrs.insert(19616);
        addrs.insert(19620);
        addrs.insert(19624);
        addrs.insert(19628);
        addrs.insert(19632);
        addrs.insert(19636);
        addrs.insert(19640);
        addrs.insert(19644);
        addrs.insert(19648);
        addrs.insert(19652);
        addrs.insert(19656);
        addrs.insert(19660);
        addrs.insert(19664);
        addrs.insert(19668);
        addrs.insert(19672);
        addrs.insert(19676);
        addrs.insert(19680);
        addrs.insert(19684);
        addrs.insert(19688);
        addrs.insert(19692);
        addrs.insert(19696);
        addrs.insert(19700);
        addrs.insert(19704);
        addrs.insert(19708);
        addrs.insert(19712);
        addrs.insert(19716);
        addrs.insert(19720);
        addrs.insert(19724);
        addrs.insert(19728);
        addrs.insert(19732);
        addrs.insert(19736);
        addrs.insert(19740);
        addrs.insert(19744);
        addrs.insert(19748);
        addrs.insert(19752);
        addrs.insert(19756);
        addrs.insert(19760);
        addrs.insert(19764);
        addrs.insert(19768);
        addrs.insert(19772);
        addrs.insert(19776);
        addrs.insert(19780);
        addrs.insert(19784);
        addrs.insert(19788);
        addrs.insert(19792);
        addrs.insert(19796);
        addrs.insert(19800);
        addrs.insert(19804);
        addrs.insert(19808);
        addrs.insert(19812);
        addrs.insert(19816);
        addrs.insert(19820);
        addrs.insert(19824);
        addrs.insert(19828);
        addrs.insert(19832);
        addrs.insert(19836);
        addrs.insert(19840);
        addrs.insert(19844);
        addrs.insert(19848);
        addrs.insert(19852);
        addrs.insert(19856);
        addrs.insert(19860);
        addrs.insert(19864);
        addrs.insert(19868);
        addrs.insert(19872);
        addrs.insert(19876);
        addrs.insert(19880);
        addrs.insert(19884);
        addrs.insert(19888);
        addrs.insert(19892);
        addrs.insert(19896);
        addrs.insert(19900);
        addrs.insert(19904);
        addrs.insert(19908);
        addrs.insert(19912);
        addrs.insert(19916);
        addrs.insert(19920);
        addrs.insert(19924);
        addrs.insert(19928);
        addrs.insert(19932);
        addrs.insert(19936);
        addrs.insert(19940);
        addrs.insert(19944);
        addrs.insert(19948);
        addrs.insert(19952);
        addrs.insert(19956);
        addrs.insert(19960);
        addrs.insert(19964);
        addrs.insert(19968);
        addrs.insert(19972);
        addrs.insert(19976);
        addrs.insert(19980);
        addrs.insert(19984);
        addrs.insert(19988);
        addrs.insert(19992);
        addrs.insert(19996);
        addrs.insert(20000);
        addrs.insert(20004);
        addrs.insert(20008);
        addrs.insert(20012);
        addrs.insert(20016);
        addrs.insert(20020);
        addrs.insert(20024);
        addrs.insert(20028);
        addrs.insert(20032);
        addrs.insert(20036);
        addrs.insert(20040);
        addrs.insert(20044);
        addrs.insert(20048);
        addrs.insert(20052);
        addrs.insert(20056);
        addrs.insert(20060);
        addrs.insert(20064);
        addrs.insert(20068);
        addrs.insert(20072);
        addrs.insert(20076);
        addrs.insert(20080);
        addrs.insert(20084);
        addrs.insert(20088);
        addrs.insert(20092);
        addrs.insert(20096);
        addrs.insert(20100);
        addrs.insert(20104);
        addrs.insert(20108);
        addrs.insert(20112);
        addrs.insert(20116);
        addrs.insert(20120);
        addrs.insert(20124);
        addrs.insert(20128);
        addrs.insert(20132);
        addrs.insert(20136);
        addrs.insert(20140);
        addrs.insert(20144);
        addrs.insert(20148);
        addrs.insert(20152);
        addrs.insert(20156);
        addrs.insert(20160);
        addrs.insert(20164);
        addrs.insert(20168);
        addrs.insert(20172);
        addrs.insert(20176);
        addrs.insert(20180);
        addrs.insert(20184);
        addrs.insert(20188);
        addrs.insert(20192);
        addrs.insert(20196);
        addrs.insert(20200);
        addrs.insert(20204);
        addrs.insert(20208);
        addrs.insert(20212);
        addrs.insert(20216);
        addrs.insert(20220);
        addrs.insert(20224);
        addrs.insert(20228);
        addrs.insert(20232);
        addrs.insert(20236);
        addrs.insert(20240);
        addrs.insert(20244);
        addrs.insert(20248);
        addrs.insert(20252);
        addrs.insert(20256);
        addrs.insert(20260);
        addrs.insert(20264);
        addrs.insert(20268);
        addrs.insert(20272);
        addrs.insert(20276);
        addrs.insert(20280);
        addrs.insert(20284);
        addrs.insert(20288);
        addrs.insert(20292);
        addrs.insert(20296);
        addrs.insert(20300);
        addrs.insert(20304);
        addrs.insert(20308);
        addrs.insert(20312);
        addrs.insert(20316);
        addrs.insert(20320);
        addrs.insert(20324);
        addrs.insert(20328);
        addrs.insert(20332);
        addrs.insert(20336);
        addrs.insert(20340);
        addrs.insert(20344);
        addrs.insert(20348);
        addrs.insert(20352);
        addrs.insert(20356);
        addrs.insert(20360);
        addrs.insert(20364);
        addrs.insert(20368);
        addrs.insert(20372);
        addrs.insert(20376);
        addrs.insert(20380);
        addrs.insert(20384);
        addrs.insert(20388);
        addrs.insert(20392);
        addrs.insert(20396);
        addrs.insert(20400);
        addrs.insert(20404);
        addrs.insert(20408);
        addrs.insert(20412);
        addrs.insert(20416);
        addrs.insert(20420);
        addrs.insert(20424);
        addrs.insert(20428);
        addrs.insert(20432);
        addrs.insert(20436);
        addrs.insert(20440);
        addrs.insert(20444);
        addrs.insert(20448);
        addrs.insert(20452);
        addrs.insert(20456);
        addrs.insert(20460);
        addrs.insert(20464);
        addrs.insert(20468);
        addrs.insert(20472);
        addrs.insert(20476);
        addrs.insert(20480);
        addrs.insert(24576);
        return addrs;
    }
    
    uint16_t get_addr(fbx_reg_field_t field) {
        switch(field) {
        case fbx_reg_field_t::RF0_TDDS:
            return 0;
        case fbx_reg_field_t::RF0_RX_RFS:
            return 0;
        case fbx_reg_field_t::RF0_TX_RX_RFS:
            return 0;
        case fbx_reg_field_t::RF1_TDDS:
            return 1024;
        case fbx_reg_field_t::RF1_RX_RFS:
            return 1024;
        case fbx_reg_field_t::RF1_TX_RX_RFS:
            return 1024;
        case fbx_reg_field_t::RF2_TDDS:
            return 2048;
        case fbx_reg_field_t::RF2_RX_RFS:
            return 2048;
        case fbx_reg_field_t::RF2_TX_RX_RFS:
            return 2048;
        case fbx_reg_field_t::RF3_TDDS:
            return 3072;
        case fbx_reg_field_t::RF3_RX_RFS:
            return 3072;
        case fbx_reg_field_t::RF3_TX_RX_RFS:
            return 3072;
        case fbx_reg_field_t::CH0_TRX1_LED_GR:
            return 16384;
        case fbx_reg_field_t::CH0_TRX1_LED_RED:
            return 16384;
        case fbx_reg_field_t::CH0_RX2_LED:
            return 16384;
        case fbx_reg_field_t::CH1_TRX1_LED_GR:
            return 17408;
        case fbx_reg_field_t::CH1_TRX1_LED_RED:
            return 17408;
        case fbx_reg_field_t::CH1_RX2_LED:
            return 17408;
        case fbx_reg_field_t::CH2_TRX1_LED_GR:
            return 18432;
        case fbx_reg_field_t::CH2_TRX1_LED_RED:
            return 18432;
        case fbx_reg_field_t::CH2_RX2_LED:
            return 18432;
        case fbx_reg_field_t::CH3_TRX1_LED_GR:
            return 19456;
        case fbx_reg_field_t::CH3_TRX1_LED_RED:
            return 19456;
        case fbx_reg_field_t::CH3_RX2_LED:
            return 19456;
        default:
            UHD_ASSERT_THROW(false);
            return 0;
        }
    }
    
    uint16_t get_addr(const std::string& reg_name)
    {
        if ("SCRATCH" == reg_name) {
            return 12;
        }
        if ("DEVICE_ID" == reg_name) {
            return 16;
        }
        if ("RF0_TDDS" == reg_name) {
            return 0;
        }
        if ("RF0_RX_RFS" == reg_name) {
            return 0;
        }
        if ("RF0_TX_RX_RFS" == reg_name) {
            return 0;
        }
        if ("RF1_TDDS" == reg_name) {
            return 1024;
        }
        if ("RF1_RX_RFS" == reg_name) {
            return 1024;
        }
        if ("RF1_TX_RX_RFS" == reg_name) {
            return 1024;
        }
        if ("RF2_TDDS" == reg_name) {
            return 2048;
        }
        if ("RF2_RX_RFS" == reg_name) {
            return 2048;
        }
        if ("RF2_TX_RX_RFS" == reg_name) {
            return 2048;
        }
        if ("RF3_TDDS" == reg_name) {
            return 3072;
        }
        if ("RF3_RX_RFS" == reg_name) {
            return 3072;
        }
        if ("RF3_TX_RX_RFS" == reg_name) {
            return 3072;
        }
        if ("RF0_ATR_OPTION" == reg_name) {
            return 4096;
        }
        if ("RF1_ATR_OPTION" == reg_name) {
            return 4096;
        }
        if ("RF2_ATR_OPTION" == reg_name) {
            return 4096;
        }
        if ("RF3_ATR_OPTION" == reg_name) {
            return 4096;
        }
        if ("LED0_ATR_OPTION" == reg_name) {
            return 20480;
        }
        if ("LED1_ATR_OPTION" == reg_name) {
            return 20480;
        }
        if ("LED2_ATR_OPTION" == reg_name) {
            return 20480;
        }
        if ("LED3_ATR_OPTION" == reg_name) {
            return 20480;
        }
        if ("SYNC0_CTRL" == reg_name) {
            return 8192;
        }
        if ("SYNC1_CTRL" == reg_name) {
            return 8196;
        }
        if ("SYNC2_CTRL" == reg_name) {
            return 8200;
        }
        if ("SYNC3_CTRL" == reg_name) {
            return 8204;
        }
        if ("SYNC4_CTRL" == reg_name) {
            return 8208;
        }
        if ("IO_EXP_SETUP" == reg_name) {
            return 8216;
        }
        if ("IO_EXP_CONFIG" == reg_name) {
            return 8220;
        }
        if ("CH3_TRX1_LED_GR" == reg_name) {
            return 19456;
        }
        if ("CH3_TRX1_LED_RED" == reg_name) {
            return 19456;
        }
        if ("CH3_RX2_LED" == reg_name) {
            return 19456;
        }
        if ("CH2_TRX1_LED_GR" == reg_name) {
            return 18432;
        }
        if ("CH2_TRX1_LED_RED" == reg_name) {
            return 18432;
        }
        if ("CH2_RX2_LED" == reg_name) {
            return 18432;
        }
        if ("CH1_TRX1_LED_GR" == reg_name) {
            return 17408;
        }
        if ("CH1_TRX1_LED_RED" == reg_name) {
            return 17408;
        }
        if ("CH1_RX2_LED" == reg_name) {
            return 17408;
        }
        if ("CH0_TRX1_LED_GR" == reg_name) {
            return 16384;
        }
        if ("CH0_TRX1_LED_RED" == reg_name) {
            return 16384;
        }
        if ("CH0_RX2_LED" == reg_name) {
            return 16384;
        }
        if ("SYNC_CLK" == reg_name) {
            return 24576;
        }
        return 0;
    }

    void save_state(void){
        if (_state == NULL) _state = new fbx_regs_t();
        _state->SCRATCH = this->SCRATCH;
        _state->DEVICE_ID = this->DEVICE_ID;
        _state->RF0_TDDS = this->RF0_TDDS;
        _state->RF0_RX_RFS = this->RF0_RX_RFS;
        _state->RF0_TX_RX_RFS = this->RF0_TX_RX_RFS;
        _state->RF1_TDDS = this->RF1_TDDS;
        _state->RF1_RX_RFS = this->RF1_RX_RFS;
        _state->RF1_TX_RX_RFS = this->RF1_TX_RX_RFS;
        _state->RF2_TDDS = this->RF2_TDDS;
        _state->RF2_RX_RFS = this->RF2_RX_RFS;
        _state->RF2_TX_RX_RFS = this->RF2_TX_RX_RFS;
        _state->RF3_TDDS = this->RF3_TDDS;
        _state->RF3_RX_RFS = this->RF3_RX_RFS;
        _state->RF3_TX_RX_RFS = this->RF3_TX_RX_RFS;
        _state->RF0_ATR_OPTION = this->RF0_ATR_OPTION;
        _state->RF1_ATR_OPTION = this->RF1_ATR_OPTION;
        _state->RF2_ATR_OPTION = this->RF2_ATR_OPTION;
        _state->RF3_ATR_OPTION = this->RF3_ATR_OPTION;
        _state->LED0_ATR_OPTION = this->LED0_ATR_OPTION;
        _state->LED1_ATR_OPTION = this->LED1_ATR_OPTION;
        _state->LED2_ATR_OPTION = this->LED2_ATR_OPTION;
        _state->LED3_ATR_OPTION = this->LED3_ATR_OPTION;
        _state->SYNC0_CTRL = this->SYNC0_CTRL;
        _state->SYNC1_CTRL = this->SYNC1_CTRL;
        _state->SYNC2_CTRL = this->SYNC2_CTRL;
        _state->SYNC3_CTRL = this->SYNC3_CTRL;
        _state->SYNC4_CTRL = this->SYNC4_CTRL;
        _state->IO_EXP_SETUP = this->IO_EXP_SETUP;
        _state->IO_EXP_CONFIG = this->IO_EXP_CONFIG;
        _state->CH3_TRX1_LED_GR = this->CH3_TRX1_LED_GR;
        _state->CH3_TRX1_LED_RED = this->CH3_TRX1_LED_RED;
        _state->CH3_RX2_LED = this->CH3_RX2_LED;
        _state->CH2_TRX1_LED_GR = this->CH2_TRX1_LED_GR;
        _state->CH2_TRX1_LED_RED = this->CH2_TRX1_LED_RED;
        _state->CH2_RX2_LED = this->CH2_RX2_LED;
        _state->CH1_TRX1_LED_GR = this->CH1_TRX1_LED_GR;
        _state->CH1_TRX1_LED_RED = this->CH1_TRX1_LED_RED;
        _state->CH1_RX2_LED = this->CH1_RX2_LED;
        _state->CH0_TRX1_LED_GR = this->CH0_TRX1_LED_GR;
        _state->CH0_TRX1_LED_RED = this->CH0_TRX1_LED_RED;
        _state->CH0_RX2_LED = this->CH0_RX2_LED;
        _state->SYNC_CLK = this->SYNC_CLK;
    }

    uint32_t get_state_SCRATCH(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->SCRATCH;
    }

    DEVICE_ID_t get_state_DEVICE_ID(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->DEVICE_ID;
    }

    std::vector<RF0_TDDS_t> get_state_RF0_TDDS(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->RF0_TDDS;
    }

    std::vector<RF0_RX_RFS_t> get_state_RF0_RX_RFS(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->RF0_RX_RFS;
    }

    std::vector<RF0_TX_RX_RFS_t> get_state_RF0_TX_RX_RFS(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->RF0_TX_RX_RFS;
    }

    std::vector<RF1_TDDS_t> get_state_RF1_TDDS(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->RF1_TDDS;
    }

    std::vector<RF1_RX_RFS_t> get_state_RF1_RX_RFS(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->RF1_RX_RFS;
    }

    std::vector<RF1_TX_RX_RFS_t> get_state_RF1_TX_RX_RFS(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->RF1_TX_RX_RFS;
    }

    std::vector<RF2_TDDS_t> get_state_RF2_TDDS(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->RF2_TDDS;
    }

    std::vector<RF2_RX_RFS_t> get_state_RF2_RX_RFS(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->RF2_RX_RFS;
    }

    std::vector<RF2_TX_RX_RFS_t> get_state_RF2_TX_RX_RFS(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->RF2_TX_RX_RFS;
    }

    std::vector<RF3_TDDS_t> get_state_RF3_TDDS(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->RF3_TDDS;
    }

    std::vector<RF3_RX_RFS_t> get_state_RF3_RX_RFS(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->RF3_RX_RFS;
    }

    std::vector<RF3_TX_RX_RFS_t> get_state_RF3_TX_RX_RFS(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->RF3_TX_RX_RFS;
    }

    RF0_ATR_OPTION_t get_state_RF0_ATR_OPTION(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->RF0_ATR_OPTION;
    }

    RF1_ATR_OPTION_t get_state_RF1_ATR_OPTION(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->RF1_ATR_OPTION;
    }

    RF2_ATR_OPTION_t get_state_RF2_ATR_OPTION(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->RF2_ATR_OPTION;
    }

    RF3_ATR_OPTION_t get_state_RF3_ATR_OPTION(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->RF3_ATR_OPTION;
    }

    LED0_ATR_OPTION_t get_state_LED0_ATR_OPTION(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->LED0_ATR_OPTION;
    }

    LED1_ATR_OPTION_t get_state_LED1_ATR_OPTION(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->LED1_ATR_OPTION;
    }

    LED2_ATR_OPTION_t get_state_LED2_ATR_OPTION(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->LED2_ATR_OPTION;
    }

    LED3_ATR_OPTION_t get_state_LED3_ATR_OPTION(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->LED3_ATR_OPTION;
    }

    SYNC0_CTRL_t get_state_SYNC0_CTRL(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->SYNC0_CTRL;
    }

    SYNC1_CTRL_t get_state_SYNC1_CTRL(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->SYNC1_CTRL;
    }

    SYNC2_CTRL_t get_state_SYNC2_CTRL(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->SYNC2_CTRL;
    }

    SYNC3_CTRL_t get_state_SYNC3_CTRL(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->SYNC3_CTRL;
    }

    SYNC4_CTRL_t get_state_SYNC4_CTRL(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->SYNC4_CTRL;
    }

    IO_EXP_SETUP_t get_state_IO_EXP_SETUP(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->IO_EXP_SETUP;
    }

    IO_EXP_CONFIG_t get_state_IO_EXP_CONFIG(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->IO_EXP_CONFIG;
    }

    std::vector<CH3_TRX1_LED_GR_t> get_state_CH3_TRX1_LED_GR(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->CH3_TRX1_LED_GR;
    }

    std::vector<CH3_TRX1_LED_RED_t> get_state_CH3_TRX1_LED_RED(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->CH3_TRX1_LED_RED;
    }

    std::vector<CH3_RX2_LED_t> get_state_CH3_RX2_LED(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->CH3_RX2_LED;
    }

    std::vector<CH2_TRX1_LED_GR_t> get_state_CH2_TRX1_LED_GR(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->CH2_TRX1_LED_GR;
    }

    std::vector<CH2_TRX1_LED_RED_t> get_state_CH2_TRX1_LED_RED(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->CH2_TRX1_LED_RED;
    }

    std::vector<CH2_RX2_LED_t> get_state_CH2_RX2_LED(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->CH2_RX2_LED;
    }

    std::vector<CH1_TRX1_LED_GR_t> get_state_CH1_TRX1_LED_GR(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->CH1_TRX1_LED_GR;
    }

    std::vector<CH1_TRX1_LED_RED_t> get_state_CH1_TRX1_LED_RED(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->CH1_TRX1_LED_RED;
    }

    std::vector<CH1_RX2_LED_t> get_state_CH1_RX2_LED(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->CH1_RX2_LED;
    }

    std::vector<CH0_TRX1_LED_GR_t> get_state_CH0_TRX1_LED_GR(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->CH0_TRX1_LED_GR;
    }

    std::vector<CH0_TRX1_LED_RED_t> get_state_CH0_TRX1_LED_RED(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->CH0_TRX1_LED_RED;
    }

    std::vector<CH0_RX2_LED_t> get_state_CH0_RX2_LED(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->CH0_RX2_LED;
    }

    SYNC_CLK_t get_state_SYNC_CLK(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->SYNC_CLK;
    }


    template<typename T> std::set<T> get_changed_addrs(bool include_ro = false) {
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        //check each register for changes
        std::set<T> addrs;
        if (include_ro || !false) {
            if(_state->SCRATCH != this->SCRATCH) {
                addrs.insert(12);
            }
        }
        if (include_ro || !true) {
            if(_state->DEVICE_ID != this->DEVICE_ID) {
                addrs.insert(16);
            }
        }
        if (include_ro || !false) {
            for (size_t i = 0; i < 256; i++) {
                if(_state->RF0_TDDS[i] != this->RF0_TDDS[i]) {
                    addrs.insert(0 + i * 4);
                }
            }
        }
        if (include_ro || !false) {
            for (size_t i = 0; i < 256; i++) {
                if(_state->RF0_RX_RFS[i] != this->RF0_RX_RFS[i]) {
                    addrs.insert(0 + i * 4);
                }
            }
        }
        if (include_ro || !false) {
            for (size_t i = 0; i < 256; i++) {
                if(_state->RF0_TX_RX_RFS[i] != this->RF0_TX_RX_RFS[i]) {
                    addrs.insert(0 + i * 4);
                }
            }
        }
        if (include_ro || !false) {
            for (size_t i = 0; i < 256; i++) {
                if(_state->RF1_TDDS[i] != this->RF1_TDDS[i]) {
                    addrs.insert(1024 + i * 4);
                }
            }
        }
        if (include_ro || !false) {
            for (size_t i = 0; i < 256; i++) {
                if(_state->RF1_RX_RFS[i] != this->RF1_RX_RFS[i]) {
                    addrs.insert(1024 + i * 4);
                }
            }
        }
        if (include_ro || !false) {
            for (size_t i = 0; i < 256; i++) {
                if(_state->RF1_TX_RX_RFS[i] != this->RF1_TX_RX_RFS[i]) {
                    addrs.insert(1024 + i * 4);
                }
            }
        }
        if (include_ro || !false) {
            for (size_t i = 0; i < 256; i++) {
                if(_state->RF2_TDDS[i] != this->RF2_TDDS[i]) {
                    addrs.insert(2048 + i * 4);
                }
            }
        }
        if (include_ro || !false) {
            for (size_t i = 0; i < 256; i++) {
                if(_state->RF2_RX_RFS[i] != this->RF2_RX_RFS[i]) {
                    addrs.insert(2048 + i * 4);
                }
            }
        }
        if (include_ro || !false) {
            for (size_t i = 0; i < 256; i++) {
                if(_state->RF2_TX_RX_RFS[i] != this->RF2_TX_RX_RFS[i]) {
                    addrs.insert(2048 + i * 4);
                }
            }
        }
        if (include_ro || !false) {
            for (size_t i = 0; i < 256; i++) {
                if(_state->RF3_TDDS[i] != this->RF3_TDDS[i]) {
                    addrs.insert(3072 + i * 4);
                }
            }
        }
        if (include_ro || !false) {
            for (size_t i = 0; i < 256; i++) {
                if(_state->RF3_RX_RFS[i] != this->RF3_RX_RFS[i]) {
                    addrs.insert(3072 + i * 4);
                }
            }
        }
        if (include_ro || !false) {
            for (size_t i = 0; i < 256; i++) {
                if(_state->RF3_TX_RX_RFS[i] != this->RF3_TX_RX_RFS[i]) {
                    addrs.insert(3072 + i * 4);
                }
            }
        }
        if (include_ro || !false) {
            if(_state->RF0_ATR_OPTION != this->RF0_ATR_OPTION) {
                addrs.insert(4096);
            }
        }
        if (include_ro || !false) {
            if(_state->RF1_ATR_OPTION != this->RF1_ATR_OPTION) {
                addrs.insert(4096);
            }
        }
        if (include_ro || !false) {
            if(_state->RF2_ATR_OPTION != this->RF2_ATR_OPTION) {
                addrs.insert(4096);
            }
        }
        if (include_ro || !false) {
            if(_state->RF3_ATR_OPTION != this->RF3_ATR_OPTION) {
                addrs.insert(4096);
            }
        }
        if (include_ro || !false) {
            if(_state->LED0_ATR_OPTION != this->LED0_ATR_OPTION) {
                addrs.insert(20480);
            }
        }
        if (include_ro || !false) {
            if(_state->LED1_ATR_OPTION != this->LED1_ATR_OPTION) {
                addrs.insert(20480);
            }
        }
        if (include_ro || !false) {
            if(_state->LED2_ATR_OPTION != this->LED2_ATR_OPTION) {
                addrs.insert(20480);
            }
        }
        if (include_ro || !false) {
            if(_state->LED3_ATR_OPTION != this->LED3_ATR_OPTION) {
                addrs.insert(20480);
            }
        }
        if (include_ro || !false) {
            if(_state->SYNC0_CTRL != this->SYNC0_CTRL) {
                addrs.insert(8192);
            }
        }
        if (include_ro || !false) {
            if(_state->SYNC1_CTRL != this->SYNC1_CTRL) {
                addrs.insert(8196);
            }
        }
        if (include_ro || !false) {
            if(_state->SYNC2_CTRL != this->SYNC2_CTRL) {
                addrs.insert(8200);
            }
        }
        if (include_ro || !false) {
            if(_state->SYNC3_CTRL != this->SYNC3_CTRL) {
                addrs.insert(8204);
            }
        }
        if (include_ro || !false) {
            if(_state->SYNC4_CTRL != this->SYNC4_CTRL) {
                addrs.insert(8208);
            }
        }
        if (include_ro || !false) {
            if(_state->IO_EXP_SETUP != this->IO_EXP_SETUP) {
                addrs.insert(8216);
            }
        }
        if (include_ro || !false) {
            if(_state->IO_EXP_CONFIG != this->IO_EXP_CONFIG) {
                addrs.insert(8220);
            }
        }
        if (include_ro || !false) {
            for (size_t i = 0; i < 256; i++) {
                if(_state->CH3_TRX1_LED_GR[i] != this->CH3_TRX1_LED_GR[i]) {
                    addrs.insert(19456 + i * 4);
                }
            }
        }
        if (include_ro || !false) {
            for (size_t i = 0; i < 256; i++) {
                if(_state->CH3_TRX1_LED_RED[i] != this->CH3_TRX1_LED_RED[i]) {
                    addrs.insert(19456 + i * 4);
                }
            }
        }
        if (include_ro || !false) {
            for (size_t i = 0; i < 256; i++) {
                if(_state->CH3_RX2_LED[i] != this->CH3_RX2_LED[i]) {
                    addrs.insert(19456 + i * 4);
                }
            }
        }
        if (include_ro || !false) {
            for (size_t i = 0; i < 256; i++) {
                if(_state->CH2_TRX1_LED_GR[i] != this->CH2_TRX1_LED_GR[i]) {
                    addrs.insert(18432 + i * 4);
                }
            }
        }
        if (include_ro || !false) {
            for (size_t i = 0; i < 256; i++) {
                if(_state->CH2_TRX1_LED_RED[i] != this->CH2_TRX1_LED_RED[i]) {
                    addrs.insert(18432 + i * 4);
                }
            }
        }
        if (include_ro || !false) {
            for (size_t i = 0; i < 256; i++) {
                if(_state->CH2_RX2_LED[i] != this->CH2_RX2_LED[i]) {
                    addrs.insert(18432 + i * 4);
                }
            }
        }
        if (include_ro || !false) {
            for (size_t i = 0; i < 256; i++) {
                if(_state->CH1_TRX1_LED_GR[i] != this->CH1_TRX1_LED_GR[i]) {
                    addrs.insert(17408 + i * 4);
                }
            }
        }
        if (include_ro || !false) {
            for (size_t i = 0; i < 256; i++) {
                if(_state->CH1_TRX1_LED_RED[i] != this->CH1_TRX1_LED_RED[i]) {
                    addrs.insert(17408 + i * 4);
                }
            }
        }
        if (include_ro || !false) {
            for (size_t i = 0; i < 256; i++) {
                if(_state->CH1_RX2_LED[i] != this->CH1_RX2_LED[i]) {
                    addrs.insert(17408 + i * 4);
                }
            }
        }
        if (include_ro || !false) {
            for (size_t i = 0; i < 256; i++) {
                if(_state->CH0_TRX1_LED_GR[i] != this->CH0_TRX1_LED_GR[i]) {
                    addrs.insert(16384 + i * 4);
                }
            }
        }
        if (include_ro || !false) {
            for (size_t i = 0; i < 256; i++) {
                if(_state->CH0_TRX1_LED_RED[i] != this->CH0_TRX1_LED_RED[i]) {
                    addrs.insert(16384 + i * 4);
                }
            }
        }
        if (include_ro || !false) {
            for (size_t i = 0; i < 256; i++) {
                if(_state->CH0_RX2_LED[i] != this->CH0_RX2_LED[i]) {
                    addrs.insert(16384 + i * 4);
                }
            }
        }
        if (include_ro || !false) {
            if(_state->SYNC_CLK != this->SYNC_CLK) {
                addrs.insert(24576);
            }
        }
        return addrs;
    }

private:
    fbx_regs_t *_state;
};

#endif /* INCLUDED_FBX_REGS_HPP */
