// model-body.mustache

// licenseInfo.mustache

/**
 * Libre Graph API
 * Libre Graph is a free API for cloud collaboration inspired by the MS Graph API.
 *
 * The version of the OpenAPI document: v1.0.4
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

#include "OAITagUnassignment.h"

#include <QDebug>
#include <QJsonArray>
#include <QJsonDocument>
#include <QObject>

#include "OAIHelpers.h"

namespace OpenAPI {

class OAITagUnassignmentPrivate {
    friend class OAITagUnassignment;

     QString resource_id;
     bool resource_id_isSet;
     bool resource_id_isValid;

     QList<QString> tags;
     bool tags_isSet;
     bool tags_isValid;
};

OAITagUnassignment::OAITagUnassignment()
    : d_ptr()
{
}

OAITagUnassignment::OAITagUnassignment(const OAITagUnassignment& other)
    : d_ptr(other.d_ptr)
{
}

OAITagUnassignment::OAITagUnassignment(QString json)
    : d_ptr(nullptr)
{
    this->fromJson(json);
}

OAITagUnassignment::~OAITagUnassignment() = default;

void OAITagUnassignment::initializeModel() {
    if (d_ptr == nullptr) {
        d_ptr.reset(new OAITagUnassignmentPrivate{});

        Q_D(OAITagUnassignment);


        d->resource_id_isSet = false;
        d->resource_id_isValid = false;

        d->tags_isSet = false;
        d->tags_isValid = false;
    }
}

void OAITagUnassignment::fromJson(QString jsonString) {
    QByteArray array(jsonString.toUtf8());
    QJsonDocument doc = QJsonDocument::fromJson(array);
    QJsonObject jsonObject = doc.object();
    this->fromJsonObject(jsonObject);
}

void OAITagUnassignment::fromJsonObject(QJsonObject json) {
    initializeModel();

    Q_D(OAITagUnassignment);

    d->resource_id_isValid = ::OpenAPI::fromJsonValue(d->resource_id, json[QString("resourceId")]);
    d->resource_id_isSet = !json[QString("resourceId")].isNull() && d->resource_id_isValid;

    d->tags_isValid = ::OpenAPI::fromJsonValue(d->tags, json[QString("tags")]);
    d->tags_isSet = !json[QString("tags")].isNull() && d->tags_isValid;
}

QString OAITagUnassignment::asJson() const {
    QJsonObject obj = this->asJsonObject();
    QJsonDocument doc(obj);
    QByteArray bytes = doc.toJson();
    return QString(bytes);
}

QJsonObject OAITagUnassignment::asJsonObject() const {
    Q_D(const OAITagUnassignment);
    if(!d){
        return {};
    }
    QJsonObject obj;
    if (d->resource_id_isSet) {
        obj.insert(QString("resourceId"), ::OpenAPI::toJsonValue(d->resource_id));
    }
    if (d->tags.size() > 0) {
        obj.insert(QString("tags"), ::OpenAPI::toJsonValue(d->tags));
    }
    return obj;
}

QString OAITagUnassignment::getResourceId() const {
    Q_D(const OAITagUnassignment);
    if(!d){
        return {};
    }
    return d->resource_id;
}
void OAITagUnassignment::setResourceId(const QString &resource_id) {
    Q_D(OAITagUnassignment);
    Q_ASSERT(d);

    d->resource_id = resource_id;
    d->resource_id_isSet = true;
}

bool OAITagUnassignment::is_resource_id_Set() const{
    Q_D(const OAITagUnassignment);
    if(!d){
        return false;
    }

    return d->resource_id_isSet;
}

bool OAITagUnassignment::is_resource_id_Valid() const{
    Q_D(const OAITagUnassignment);
    if(!d){
        return false;
    }
    return d->resource_id_isValid;
}

QList<QString> OAITagUnassignment::getTags() const {
    Q_D(const OAITagUnassignment);
    if(!d){
        return {};
    }
    return d->tags;
}
void OAITagUnassignment::setTags(const QList<QString> &tags) {
    Q_D(OAITagUnassignment);
    Q_ASSERT(d);

    d->tags = tags;
    d->tags_isSet = true;
}

bool OAITagUnassignment::is_tags_Set() const{
    Q_D(const OAITagUnassignment);
    if(!d){
        return false;
    }

    return d->tags_isSet;
}

bool OAITagUnassignment::is_tags_Valid() const{
    Q_D(const OAITagUnassignment);
    if(!d){
        return false;
    }
    return d->tags_isValid;
}

bool OAITagUnassignment::isSet() const {
    Q_D(const OAITagUnassignment);
    if(!d){
        return false;
    }
    bool isObjectUpdated = false;
    do {
        if (d->resource_id_isSet) {
            isObjectUpdated = true;
            break;
        }

        if (d->tags.size() > 0) {
            isObjectUpdated = true;
            break;
        }
    } while (false);
    return isObjectUpdated;
}

bool OAITagUnassignment::isValid() const {
    Q_D(const OAITagUnassignment);
    if(!d){
        return false;
    }
    // only required properties are required for the object to be considered valid
    return d->resource_id_isValid && d->tags_isValid && true;
}

} // namespace OpenAPI
