/*
 * Copyright © 2022 Imagination Technologies Ltd.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice (including the next
 * paragraph) shall be included in all copies or substantial portions of the
 * Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

/* Enums, structures and pack functions for ROGUE.
 *
 * This file has been generated, do not hand edit.
 */

#ifndef KMD_STREAM_H
#define KMD_STREAM_H

#include "csbgen/pvr_packet_helpers.h"

#ifndef __OPENCL_VERSION__
#define __constant
#endif


#define ROGUE_KMD_STREAM_EXTHDR_DATA_MASK        268435455
#define ROGUE_KMD_STREAM_USC_CLEAR_REGISTER_COUNT 8

enum ROGUE_KMD_STREAM_EXTHDR_TYPE_COMPUTE {
    ROGUE_KMD_STREAM_EXTHDR_TYPE_COMPUTE_0 =      0,
};

static __constant const char *
ROGUE_KMD_STREAM_EXTHDR_TYPE_COMPUTE_to_str(const enum ROGUE_KMD_STREAM_EXTHDR_TYPE_COMPUTE value)
{
    switch (value) {
    case ROGUE_KMD_STREAM_EXTHDR_TYPE_COMPUTE_0: return "_0";
    default: return NULL;
    }
}

enum ROGUE_KMD_STREAM_EXTHDR_TYPE_FRAG {
    ROGUE_KMD_STREAM_EXTHDR_TYPE_FRAG_0  =      0,
};

static __constant const char *
ROGUE_KMD_STREAM_EXTHDR_TYPE_FRAG_to_str(const enum ROGUE_KMD_STREAM_EXTHDR_TYPE_FRAG value)
{
    switch (value) {
    case ROGUE_KMD_STREAM_EXTHDR_TYPE_FRAG_0: return "_0";
    default: return NULL;
    }
}

enum ROGUE_KMD_STREAM_EXTHDR_TYPE_GEOM {
    ROGUE_KMD_STREAM_EXTHDR_TYPE_GEOM_0  =      0,
};

static __constant const char *
ROGUE_KMD_STREAM_EXTHDR_TYPE_GEOM_to_str(const enum ROGUE_KMD_STREAM_EXTHDR_TYPE_GEOM value)
{
    switch (value) {
    case ROGUE_KMD_STREAM_EXTHDR_TYPE_GEOM_0: return "_0";
    default: return NULL;
    }
}

enum ROGUE_KMD_STREAM_PIXEL_PHANTOM_STATE {
    ROGUE_KMD_STREAM_PIXEL_PHANTOM_STATE_DISABLED =      0,
    ROGUE_KMD_STREAM_PIXEL_PHANTOM_STATE_ENABLED =     15,
};

static __constant const char *
ROGUE_KMD_STREAM_PIXEL_PHANTOM_STATE_to_str(const enum ROGUE_KMD_STREAM_PIXEL_PHANTOM_STATE value)
{
    switch (value) {
    case ROGUE_KMD_STREAM_PIXEL_PHANTOM_STATE_DISABLED: return "DISABLED";
    case ROGUE_KMD_STREAM_PIXEL_PHANTOM_STATE_ENABLED: return "ENABLED";
    default: return NULL;
    }
}

#define ROGUE_KMD_STREAM_EXTHDR_COMPUTE0_length      1
#define ROGUE_KMD_STREAM_EXTHDR_COMPUTE0_header \
    .type                                = ROGUE_KMD_STREAM_EXTHDR_TYPE_COMPUTE_0

struct ROGUE_KMD_STREAM_EXTHDR_COMPUTE0 {
    enum ROGUE_KMD_STREAM_EXTHDR_TYPE_COMPUTE type;
    bool                                 continuation;
    bool                                 has_brn49927;
};

static inline __attribute__((always_inline)) void
ROGUE_KMD_STREAM_EXTHDR_COMPUTE0_pack(__attribute__((unused)) void * restrict dst,
                                      __attribute__((unused)) const struct ROGUE_KMD_STREAM_EXTHDR_COMPUTE0 * restrict values)
{
    uint32_t * restrict dw = (uint32_t * restrict) dst;

    dw[0] =
      __pvr_uint(values->type, 29, 31) |
      __pvr_uint(values->continuation, 28, 28) |
      __pvr_uint(values->has_brn49927, 0, 0);
}

static inline __attribute__((always_inline)) void
ROGUE_KMD_STREAM_EXTHDR_COMPUTE0_unpack(__attribute__((unused)) const void * restrict src,
                                        __attribute__((unused)) struct ROGUE_KMD_STREAM_EXTHDR_COMPUTE0 * restrict values)
{
    const uint32_t * restrict dw = (const uint32_t * restrict) src;
    values->type = __pvr_uint_unpack(dw[0], 29, 31);
    values->continuation = __pvr_uint_unpack(dw[0], 28, 28);
    values->has_brn49927 = __pvr_uint_unpack(dw[0], 0, 0);
}

#define ROGUE_KMD_STREAM_EXTHDR_FRAG0_length      1
#define ROGUE_KMD_STREAM_EXTHDR_FRAG0_header    \
    .type                                = ROGUE_KMD_STREAM_EXTHDR_TYPE_FRAG_0

struct ROGUE_KMD_STREAM_EXTHDR_FRAG0 {
    enum ROGUE_KMD_STREAM_EXTHDR_TYPE_FRAG type;
    bool                                 continuation;
    bool                                 has_brn49927;
    bool                                 has_brn47217;
};

static inline __attribute__((always_inline)) void
ROGUE_KMD_STREAM_EXTHDR_FRAG0_pack(__attribute__((unused)) void * restrict dst,
                                   __attribute__((unused)) const struct ROGUE_KMD_STREAM_EXTHDR_FRAG0 * restrict values)
{
    uint32_t * restrict dw = (uint32_t * restrict) dst;

    dw[0] =
      __pvr_uint(values->type, 29, 31) |
      __pvr_uint(values->continuation, 28, 28) |
      __pvr_uint(values->has_brn49927, 1, 1) |
      __pvr_uint(values->has_brn47217, 0, 0);
}

static inline __attribute__((always_inline)) void
ROGUE_KMD_STREAM_EXTHDR_FRAG0_unpack(__attribute__((unused)) const void * restrict src,
                                     __attribute__((unused)) struct ROGUE_KMD_STREAM_EXTHDR_FRAG0 * restrict values)
{
    const uint32_t * restrict dw = (const uint32_t * restrict) src;
    values->type = __pvr_uint_unpack(dw[0], 29, 31);
    values->continuation = __pvr_uint_unpack(dw[0], 28, 28);
    values->has_brn49927 = __pvr_uint_unpack(dw[0], 1, 1);
    values->has_brn47217 = __pvr_uint_unpack(dw[0], 0, 0);
}

#define ROGUE_KMD_STREAM_EXTHDR_GEOM0_length      1
#define ROGUE_KMD_STREAM_EXTHDR_GEOM0_header    \
    .type                                = ROGUE_KMD_STREAM_EXTHDR_TYPE_GEOM_0

struct ROGUE_KMD_STREAM_EXTHDR_GEOM0 {
    enum ROGUE_KMD_STREAM_EXTHDR_TYPE_GEOM type;
    bool                                 continuation;
    bool                                 has_brn49927;
};

static inline __attribute__((always_inline)) void
ROGUE_KMD_STREAM_EXTHDR_GEOM0_pack(__attribute__((unused)) void * restrict dst,
                                   __attribute__((unused)) const struct ROGUE_KMD_STREAM_EXTHDR_GEOM0 * restrict values)
{
    uint32_t * restrict dw = (uint32_t * restrict) dst;

    dw[0] =
      __pvr_uint(values->type, 29, 31) |
      __pvr_uint(values->continuation, 28, 28) |
      __pvr_uint(values->has_brn49927, 0, 0);
}

static inline __attribute__((always_inline)) void
ROGUE_KMD_STREAM_EXTHDR_GEOM0_unpack(__attribute__((unused)) const void * restrict src,
                                     __attribute__((unused)) struct ROGUE_KMD_STREAM_EXTHDR_GEOM0 * restrict values)
{
    const uint32_t * restrict dw = (const uint32_t * restrict) src;
    values->type = __pvr_uint_unpack(dw[0], 29, 31);
    values->continuation = __pvr_uint_unpack(dw[0], 28, 28);
    values->has_brn49927 = __pvr_uint_unpack(dw[0], 0, 0);
}

#define ROGUE_KMD_STREAM_HDR_length            2
#define ROGUE_KMD_STREAM_HDR_header             \


struct ROGUE_KMD_STREAM_HDR {
    uint32_t                             length;
};

static inline __attribute__((always_inline)) void
ROGUE_KMD_STREAM_HDR_pack(__attribute__((unused)) void * restrict dst,
                          __attribute__((unused)) const struct ROGUE_KMD_STREAM_HDR * restrict values)
{
    uint32_t * restrict dw = (uint32_t * restrict) dst;

    dw[0] =
      __pvr_uint(values->length, 0, 31);

    dw[1] = 0;
}

static inline __attribute__((always_inline)) void
ROGUE_KMD_STREAM_HDR_unpack(__attribute__((unused)) const void * restrict src,
                            __attribute__((unused)) struct ROGUE_KMD_STREAM_HDR * restrict values)
{
    const uint32_t * restrict dw = (const uint32_t * restrict) src;
    values->length = __pvr_uint_unpack(dw[0], 0, 31);
}

#define ROGUE_KMD_STREAM_PIXEL_PHANTOM_length      1
#define ROGUE_KMD_STREAM_PIXEL_PHANTOM_header   \


struct ROGUE_KMD_STREAM_PIXEL_PHANTOM {
    enum ROGUE_KMD_STREAM_PIXEL_PHANTOM_STATE phantom_1;
    enum ROGUE_KMD_STREAM_PIXEL_PHANTOM_STATE phantom_0;
};

static inline __attribute__((always_inline)) void
ROGUE_KMD_STREAM_PIXEL_PHANTOM_pack(__attribute__((unused)) void * restrict dst,
                                    __attribute__((unused)) const struct ROGUE_KMD_STREAM_PIXEL_PHANTOM * restrict values)
{
    uint32_t * restrict dw = (uint32_t * restrict) dst;

    dw[0] =
      __pvr_uint(values->phantom_1, 4, 7) |
      __pvr_uint(values->phantom_0, 0, 3);
}

static inline __attribute__((always_inline)) void
ROGUE_KMD_STREAM_PIXEL_PHANTOM_unpack(__attribute__((unused)) const void * restrict src,
                                      __attribute__((unused)) struct ROGUE_KMD_STREAM_PIXEL_PHANTOM * restrict values)
{
    const uint32_t * restrict dw = (const uint32_t * restrict) src;
    values->phantom_1 = __pvr_uint_unpack(dw[0], 4, 7);
    values->phantom_0 = __pvr_uint_unpack(dw[0], 0, 3);
}

#define ROGUE_KMD_STREAM_VIEW_IDX_length       1
#define ROGUE_KMD_STREAM_VIEW_IDX_header        \


struct ROGUE_KMD_STREAM_VIEW_IDX {
    uint32_t                             idx;
};

static inline __attribute__((always_inline)) void
ROGUE_KMD_STREAM_VIEW_IDX_pack(__attribute__((unused)) void * restrict dst,
                               __attribute__((unused)) const struct ROGUE_KMD_STREAM_VIEW_IDX * restrict values)
{
    uint32_t * restrict dw = (uint32_t * restrict) dst;

    dw[0] =
      __pvr_uint(values->idx, 0, 7);
}

static inline __attribute__((always_inline)) void
ROGUE_KMD_STREAM_VIEW_IDX_unpack(__attribute__((unused)) const void * restrict src,
                                 __attribute__((unused)) struct ROGUE_KMD_STREAM_VIEW_IDX * restrict values)
{
    const uint32_t * restrict dw = (const uint32_t * restrict) src;
    values->idx = __pvr_uint_unpack(dw[0], 0, 7);
}

#endif /* KMD_STREAM_H */
