
// Workaround to access protected functions
#ifndef protected
#  define protected public
#endif

// default includes
#include <shiboken.h>
#include <sbkpep.h>
#include <sbkpepbuffer.h>

#define PYSIDE6_COMOPT_FULLNAME 1
#define PYSIDE6_COMOPT_COMPRESS 1
// TODO: #define PYSIDE6_COMOPT_FOLDING 1

#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QtCore/QDebug>
#include <pysideqobject.h>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <signalmanager.h>
#include <pysidemetafunction.h>
#include <pysideqenum.h>
#include <pysideqmetatype.h>
#include <pysideutils.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED


// module include
#include "kwidgetsaddons_python.h"

// main header
#include "ktimecombobox_wrapper.h"

// Wrappers providing overrides
#include "kxyselector_wrapper.h"
#include "ktimecombobox_wrapper.h"

// Argument includes
#include <QList>
#include <QString>
#include <qabstractitemmodel.h>
#include <qbytearray.h>
#include <qcoreevent.h>
#include <qdatetime.h>
#include <qevent.h>
#include <qlocale.h>
#include <qmetaobject.h>
#include <qnamespace.h>
#include <qobject.h>
#include <qobjectdefs.h>
#include <qpaintdevice.h>
#include <qpoint.h>
#include <qsize.h>
#include <qstyleoption.h>
#include <qvariant.h>
#include <qwidget.h>

#include <algorithm>
#include <cctype>
#include <cstring>
#include <iterator>
#include <set>
#include <type_traits>
#include <typeinfo>

extern "C" {
static PyTypeObject *_Sbk_KTimeComboBox_Type = nullptr;
static PyTypeObject *Sbk_KTimeComboBox_TypeF(void)
{
    return _Sbk_KTimeComboBox_Type;
}
} // extern "C"

// Native ---------------------------------------------------------

void KTimeComboBoxWrapper::resetPyMethodCache()
{
    std::fill(m_PyMethodCache.begin(), m_PyMethodCache.end(), nullptr);
}

KTimeComboBoxWrapper::KTimeComboBoxWrapper(::QWidget * parent) : KTimeComboBox(parent)
{
}

void KTimeComboBoxWrapper::actionEvent(::QActionEvent * event)
{
    static const char *funcName = "actionEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KTimeComboBox_TypeF(), gil, funcName, m_PyMethodCache[0], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::actionEvent(event);
    }
    KXYSelectorWrapper::sbk_o_actionEvent("KTimeComboBox", funcName, gil, pyOverride, event);
}

void KTimeComboBoxWrapper::assignTime(const ::QTime & time)
{
    static const char *funcName = "assignTime";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KTimeComboBox_TypeF(), gil, funcName, m_PyMethodCache[1], nameCache));
    if (pyOverride.isNull()) {
        return this->::KTimeComboBox::assignTime(time);
    }
    sbk_o_assignTime("KTimeComboBox", funcName, gil, pyOverride, time);
}

void KTimeComboBoxWrapper::sbk_o_assignTime(const char *ownerClassName, const char *funcName, Shiboken::GilState &gil, const Shiboken::AutoDecRef &pyOverride, const ::QTime & time)
{
    SBK_UNUSED(ownerClassName)
    SBK_UNUSED(funcName)
    SBK_UNUSED(gil)
    SBK_UNUSED(pyOverride)
#if !defined(PYPY_VERSION) && !defined(Py_LIMITED_API)
    PyObject *pyArgArray[1] = {
        Shiboken::Conversions::copyToPython(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QTime_IDX]), &time)
    };
#else
    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
        Shiboken::Conversions::copyToPython(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QTime_IDX]), &time)
    ));
#endif

#if !defined(PYPY_VERSION) && !defined(Py_LIMITED_API)
    Shiboken::AutoDecRef pyResult(PyObject_Vectorcall(pyOverride, pyArgArray, 1, nullptr));
    Py_DECREF(pyArgArray[0]);
#else
    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
#endif
    if (pyResult.isNull()) {
        // An error happened in python code!
        Shiboken::Errors::storePythonOverrideErrorOrPrint(ownerClassName, funcName);
        return;
    }
}

void KTimeComboBoxWrapper::changeEvent(::QEvent * e)
{
    static const char *funcName = "changeEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KTimeComboBox_TypeF(), gil, funcName, m_PyMethodCache[2], nameCache));
    if (pyOverride.isNull()) {
        return this->::QComboBox::changeEvent(e);
    }
    KXYSelectorWrapper::sbk_o_changeEvent("KTimeComboBox", funcName, gil, pyOverride, e);
}

void KTimeComboBoxWrapper::childEvent(::QChildEvent * event)
{
    static const char *funcName = "childEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KTimeComboBox_TypeF(), gil, funcName, m_PyMethodCache[3], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::childEvent(event);
    }
    KXYSelectorWrapper::sbk_o_childEvent("KTimeComboBox", funcName, gil, pyOverride, event);
}

void KTimeComboBoxWrapper::closeEvent(::QCloseEvent * event)
{
    static const char *funcName = "closeEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KTimeComboBox_TypeF(), gil, funcName, m_PyMethodCache[4], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::closeEvent(event);
    }
    KXYSelectorWrapper::sbk_o_closeEvent("KTimeComboBox", funcName, gil, pyOverride, event);
}

void KTimeComboBoxWrapper::connectNotify(const ::QMetaMethod & signal)
{
    static const char *funcName = "connectNotify";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KTimeComboBox_TypeF(), gil, funcName, m_PyMethodCache[5], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::connectNotify(signal);
    }
    KXYSelectorWrapper::sbk_o_connectNotify("KTimeComboBox", funcName, gil, pyOverride, signal);
}

void KTimeComboBoxWrapper::contextMenuEvent(::QContextMenuEvent * e)
{
    static const char *funcName = "contextMenuEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KTimeComboBox_TypeF(), gil, funcName, m_PyMethodCache[6], nameCache));
    if (pyOverride.isNull()) {
        return this->::QComboBox::contextMenuEvent(e);
    }
    KXYSelectorWrapper::sbk_o_contextMenuEvent("KTimeComboBox", funcName, gil, pyOverride, e);
}

void KTimeComboBoxWrapper::customEvent(::QEvent * event)
{
    static const char *funcName = "customEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KTimeComboBox_TypeF(), gil, funcName, m_PyMethodCache[7], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::customEvent(event);
    }
    KXYSelectorWrapper::sbk_o_customEvent("KTimeComboBox", funcName, gil, pyOverride, event);
}

int KTimeComboBoxWrapper::devType() const
{
    static const char *funcName = "devType";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KTimeComboBox_TypeF(), gil, funcName, m_PyMethodCache[8], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::devType();
    }
    return KXYSelectorWrapper::sbk_o_devType("KTimeComboBox", funcName, gil, pyOverride);
}

void KTimeComboBoxWrapper::disconnectNotify(const ::QMetaMethod & signal)
{
    static const char *funcName = "disconnectNotify";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KTimeComboBox_TypeF(), gil, funcName, m_PyMethodCache[9], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::disconnectNotify(signal);
    }
    KXYSelectorWrapper::sbk_o_connectNotify("KTimeComboBox", funcName, gil, pyOverride, signal);
}

void KTimeComboBoxWrapper::dragEnterEvent(::QDragEnterEvent * event)
{
    static const char *funcName = "dragEnterEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KTimeComboBox_TypeF(), gil, funcName, m_PyMethodCache[10], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::dragEnterEvent(event);
    }
    KXYSelectorWrapper::sbk_o_dragEnterEvent("KTimeComboBox", funcName, gil, pyOverride, event);
}

void KTimeComboBoxWrapper::dragLeaveEvent(::QDragLeaveEvent * event)
{
    static const char *funcName = "dragLeaveEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KTimeComboBox_TypeF(), gil, funcName, m_PyMethodCache[11], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::dragLeaveEvent(event);
    }
    KXYSelectorWrapper::sbk_o_dragLeaveEvent("KTimeComboBox", funcName, gil, pyOverride, event);
}

void KTimeComboBoxWrapper::dragMoveEvent(::QDragMoveEvent * event)
{
    static const char *funcName = "dragMoveEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KTimeComboBox_TypeF(), gil, funcName, m_PyMethodCache[12], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::dragMoveEvent(event);
    }
    KXYSelectorWrapper::sbk_o_dragMoveEvent("KTimeComboBox", funcName, gil, pyOverride, event);
}

void KTimeComboBoxWrapper::dropEvent(::QDropEvent * event)
{
    static const char *funcName = "dropEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KTimeComboBox_TypeF(), gil, funcName, m_PyMethodCache[13], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::dropEvent(event);
    }
    KXYSelectorWrapper::sbk_o_dropEvent("KTimeComboBox", funcName, gil, pyOverride, event);
}

void KTimeComboBoxWrapper::enterEvent(::QEnterEvent * event)
{
    static const char *funcName = "enterEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KTimeComboBox_TypeF(), gil, funcName, m_PyMethodCache[14], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::enterEvent(event);
    }
    KXYSelectorWrapper::sbk_o_enterEvent("KTimeComboBox", funcName, gil, pyOverride, event);
}

bool KTimeComboBoxWrapper::event(::QEvent * event)
{
    static const char *funcName = "event";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KTimeComboBox_TypeF(), gil, funcName, m_PyMethodCache[15], nameCache));
    if (pyOverride.isNull()) {
        return this->::QComboBox::event(event);
    }
    return KXYSelectorWrapper::sbk_o_event("KTimeComboBox", funcName, gil, pyOverride, event);
}

bool KTimeComboBoxWrapper::eventFilter(::QObject * object, ::QEvent * event)
{
    static const char *funcName = "eventFilter";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KTimeComboBox_TypeF(), gil, funcName, m_PyMethodCache[16], nameCache));
    if (pyOverride.isNull()) {
        return this->::KTimeComboBox::eventFilter(object, event);
    }
    return KXYSelectorWrapper::sbk_o_eventFilter("KTimeComboBox", funcName, gil, pyOverride, object, event);
}

void KTimeComboBoxWrapper::focusInEvent(::QFocusEvent * event)
{
    static const char *funcName = "focusInEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KTimeComboBox_TypeF(), gil, funcName, m_PyMethodCache[17], nameCache));
    if (pyOverride.isNull()) {
        return this->::KTimeComboBox::focusInEvent(event);
    }
    KXYSelectorWrapper::sbk_o_focusInEvent("KTimeComboBox", funcName, gil, pyOverride, event);
}

bool KTimeComboBoxWrapper::focusNextPrevChild(bool next)
{
    static const char *funcName = "focusNextPrevChild";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KTimeComboBox_TypeF(), gil, funcName, m_PyMethodCache[18], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::focusNextPrevChild(next);
    }
    return KXYSelectorWrapper::sbk_o_focusNextPrevChild("KTimeComboBox", funcName, gil, pyOverride, next);
}

void KTimeComboBoxWrapper::focusOutEvent(::QFocusEvent * event)
{
    static const char *funcName = "focusOutEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KTimeComboBox_TypeF(), gil, funcName, m_PyMethodCache[19], nameCache));
    if (pyOverride.isNull()) {
        return this->::KTimeComboBox::focusOutEvent(event);
    }
    KXYSelectorWrapper::sbk_o_focusOutEvent("KTimeComboBox", funcName, gil, pyOverride, event);
}

bool KTimeComboBoxWrapper::hasHeightForWidth() const
{
    static const char *funcName = "hasHeightForWidth";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KTimeComboBox_TypeF(), gil, funcName, m_PyMethodCache[20], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::hasHeightForWidth();
    }
    return KXYSelectorWrapper::sbk_o_hasHeightForWidth("KTimeComboBox", funcName, gil, pyOverride);
}

int KTimeComboBoxWrapper::heightForWidth(int arg__1) const
{
    static const char *funcName = "heightForWidth";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KTimeComboBox_TypeF(), gil, funcName, m_PyMethodCache[21], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::heightForWidth(arg__1);
    }
    return KXYSelectorWrapper::sbk_o_heightForWidth("KTimeComboBox", funcName, gil, pyOverride, arg__1);
}

void KTimeComboBoxWrapper::hideEvent(::QHideEvent * e)
{
    static const char *funcName = "hideEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KTimeComboBox_TypeF(), gil, funcName, m_PyMethodCache[22], nameCache));
    if (pyOverride.isNull()) {
        return this->::QComboBox::hideEvent(e);
    }
    KXYSelectorWrapper::sbk_o_hideEvent("KTimeComboBox", funcName, gil, pyOverride, e);
}

void KTimeComboBoxWrapper::hidePopup()
{
    static const char *funcName = "hidePopup";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KTimeComboBox_TypeF(), gil, funcName, m_PyMethodCache[23], nameCache));
    if (pyOverride.isNull()) {
        return this->::KTimeComboBox::hidePopup();
    }
    sbk_o_hidePopup("KTimeComboBox", funcName, gil, pyOverride);
}

void KTimeComboBoxWrapper::sbk_o_hidePopup(const char *ownerClassName, const char *funcName, Shiboken::GilState &gil, const Shiboken::AutoDecRef &pyOverride)
{
    SBK_UNUSED(ownerClassName)
    SBK_UNUSED(funcName)
    SBK_UNUSED(gil)
    SBK_UNUSED(pyOverride)
#if defined(PYPY_VERSION) || (defined(Py_LIMITED_API) && Py_LIMITED_API < 0x030A0000)
    Shiboken::AutoDecRef pyArgs(PyTuple_New(0));
#endif

#if !defined(PYPY_VERSION) && ((defined(Py_LIMITED_API) && Py_LIMITED_API >= 0x030A0000) || !defined(Py_LIMITED_API))
    Shiboken::AutoDecRef pyResult(PyObject_CallNoArgs(pyOverride));
#else
    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
#endif
    if (pyResult.isNull()) {
        // An error happened in python code!
        Shiboken::Errors::storePythonOverrideErrorOrPrint(ownerClassName, funcName);
        return;
    }
}

void KTimeComboBoxWrapper::initPainter(::QPainter * painter) const
{
    static const char *funcName = "initPainter";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KTimeComboBox_TypeF(), gil, funcName, m_PyMethodCache[24], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::initPainter(painter);
    }
    KXYSelectorWrapper::sbk_o_drawContents("KTimeComboBox", funcName, gil, pyOverride, painter);
}

void KTimeComboBoxWrapper::initStyleOption(::QStyleOptionComboBox * option) const
{
    static const char *funcName = "initStyleOption";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KTimeComboBox_TypeF(), gil, funcName, m_PyMethodCache[25], nameCache));
    if (pyOverride.isNull()) {
        return this->::QComboBox::initStyleOption(option);
    }
    sbk_o_initStyleOption("KTimeComboBox", funcName, gil, pyOverride, option);
}

void KTimeComboBoxWrapper::sbk_o_initStyleOption(const char *ownerClassName, const char *funcName, Shiboken::GilState &gil, const Shiboken::AutoDecRef &pyOverride, ::QStyleOptionComboBox * option)
{
    SBK_UNUSED(ownerClassName)
    SBK_UNUSED(funcName)
    SBK_UNUSED(gil)
    SBK_UNUSED(pyOverride)
#if !defined(PYPY_VERSION) && !defined(Py_LIMITED_API)
    PyObject *pyArgArray[1] = {
        Shiboken::Conversions::pointerToPython(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QStyleOptionComboBox_IDX]), option)
    };
#else
    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
        Shiboken::Conversions::pointerToPython(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QStyleOptionComboBox_IDX]), option)
    ));
#endif

#if !defined(PYPY_VERSION) && !defined(Py_LIMITED_API)
    Shiboken::AutoDecRef pyResult(PyObject_Vectorcall(pyOverride, pyArgArray, 1, nullptr));
    Py_DECREF(pyArgArray[0]);
#else
    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
#endif
    if (pyResult.isNull()) {
        // An error happened in python code!
        Shiboken::Errors::storePythonOverrideErrorOrPrint(ownerClassName, funcName);
        return;
    }
}

void KTimeComboBoxWrapper::inputMethodEvent(::QInputMethodEvent * arg__1)
{
    static const char *funcName = "inputMethodEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KTimeComboBox_TypeF(), gil, funcName, m_PyMethodCache[26], nameCache));
    if (pyOverride.isNull()) {
        return this->::QComboBox::inputMethodEvent(arg__1);
    }
    KXYSelectorWrapper::sbk_o_inputMethodEvent("KTimeComboBox", funcName, gil, pyOverride, arg__1);
}

::QVariant KTimeComboBoxWrapper::inputMethodQuery(::Qt::InputMethodQuery arg__1) const
{
    static const char *funcName = "inputMethodQuery";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KTimeComboBox_TypeF(), gil, funcName, m_PyMethodCache[27], nameCache));
    if (pyOverride.isNull()) {
        return this->::QComboBox::inputMethodQuery(arg__1);
    }
    return KXYSelectorWrapper::sbk_o_inputMethodQuery("KTimeComboBox", funcName, gil, pyOverride, arg__1);
}

void KTimeComboBoxWrapper::keyPressEvent(::QKeyEvent * event)
{
    static const char *funcName = "keyPressEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KTimeComboBox_TypeF(), gil, funcName, m_PyMethodCache[28], nameCache));
    if (pyOverride.isNull()) {
        return this->::KTimeComboBox::keyPressEvent(event);
    }
    KXYSelectorWrapper::sbk_o_keyPressEvent("KTimeComboBox", funcName, gil, pyOverride, event);
}

void KTimeComboBoxWrapper::keyReleaseEvent(::QKeyEvent * e)
{
    static const char *funcName = "keyReleaseEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KTimeComboBox_TypeF(), gil, funcName, m_PyMethodCache[29], nameCache));
    if (pyOverride.isNull()) {
        return this->::QComboBox::keyReleaseEvent(e);
    }
    KXYSelectorWrapper::sbk_o_keyReleaseEvent("KTimeComboBox", funcName, gil, pyOverride, e);
}

void KTimeComboBoxWrapper::leaveEvent(::QEvent * event)
{
    static const char *funcName = "leaveEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KTimeComboBox_TypeF(), gil, funcName, m_PyMethodCache[30], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::leaveEvent(event);
    }
    KXYSelectorWrapper::sbk_o_leaveEvent("KTimeComboBox", funcName, gil, pyOverride, event);
}

int KTimeComboBoxWrapper::metric(::QPaintDevice::PaintDeviceMetric arg__1) const
{
    static const char *funcName = "metric";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KTimeComboBox_TypeF(), gil, funcName, m_PyMethodCache[31], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::metric(arg__1);
    }
    return KXYSelectorWrapper::sbk_o_metric("KTimeComboBox", funcName, gil, pyOverride, arg__1);
}

::QSize KTimeComboBoxWrapper::minimumSizeHint() const
{
    static const char *funcName = "minimumSizeHint";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KTimeComboBox_TypeF(), gil, funcName, m_PyMethodCache[32], nameCache));
    if (pyOverride.isNull()) {
        return this->::QComboBox::minimumSizeHint();
    }
    return KXYSelectorWrapper::sbk_o_minimumSizeHint("KTimeComboBox", funcName, gil, pyOverride);
}

void KTimeComboBoxWrapper::mouseDoubleClickEvent(::QMouseEvent * event)
{
    static const char *funcName = "mouseDoubleClickEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KTimeComboBox_TypeF(), gil, funcName, m_PyMethodCache[33], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::mouseDoubleClickEvent(event);
    }
    KXYSelectorWrapper::sbk_o_mouseDoubleClickEvent("KTimeComboBox", funcName, gil, pyOverride, event);
}

void KTimeComboBoxWrapper::mouseMoveEvent(::QMouseEvent * event)
{
    static const char *funcName = "mouseMoveEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KTimeComboBox_TypeF(), gil, funcName, m_PyMethodCache[34], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::mouseMoveEvent(event);
    }
    KXYSelectorWrapper::sbk_o_mouseMoveEvent("KTimeComboBox", funcName, gil, pyOverride, event);
}

void KTimeComboBoxWrapper::mousePressEvent(::QMouseEvent * event)
{
    static const char *funcName = "mousePressEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KTimeComboBox_TypeF(), gil, funcName, m_PyMethodCache[35], nameCache));
    if (pyOverride.isNull()) {
        return this->::KTimeComboBox::mousePressEvent(event);
    }
    KXYSelectorWrapper::sbk_o_mousePressEvent("KTimeComboBox", funcName, gil, pyOverride, event);
}

void KTimeComboBoxWrapper::mouseReleaseEvent(::QMouseEvent * e)
{
    static const char *funcName = "mouseReleaseEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KTimeComboBox_TypeF(), gil, funcName, m_PyMethodCache[36], nameCache));
    if (pyOverride.isNull()) {
        return this->::QComboBox::mouseReleaseEvent(e);
    }
    KXYSelectorWrapper::sbk_o_mouseReleaseEvent("KTimeComboBox", funcName, gil, pyOverride, e);
}

void KTimeComboBoxWrapper::moveEvent(::QMoveEvent * event)
{
    static const char *funcName = "moveEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KTimeComboBox_TypeF(), gil, funcName, m_PyMethodCache[37], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::moveEvent(event);
    }
    KXYSelectorWrapper::sbk_o_moveEvent("KTimeComboBox", funcName, gil, pyOverride, event);
}

bool KTimeComboBoxWrapper::nativeEvent(const ::QByteArray & eventType, void * message, ::qintptr * result)
{
    static const char *funcName = "nativeEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KTimeComboBox_TypeF(), gil, funcName, m_PyMethodCache[38], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::nativeEvent(eventType, message, result);
    }
    return KXYSelectorWrapper::sbk_o_nativeEvent("KTimeComboBox", funcName, gil, pyOverride, eventType, message, result);
}

::QPaintEngine * KTimeComboBoxWrapper::paintEngine() const
{
    static const char *funcName = "paintEngine";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KTimeComboBox_TypeF(), gil, funcName, m_PyMethodCache[39], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::paintEngine();
    }
    return KXYSelectorWrapper::sbk_o_paintEngine("KTimeComboBox", funcName, gil, pyOverride);
}

void KTimeComboBoxWrapper::paintEvent(::QPaintEvent * e)
{
    static const char *funcName = "paintEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KTimeComboBox_TypeF(), gil, funcName, m_PyMethodCache[40], nameCache));
    if (pyOverride.isNull()) {
        return this->::QComboBox::paintEvent(e);
    }
    KXYSelectorWrapper::sbk_o_paintEvent("KTimeComboBox", funcName, gil, pyOverride, e);
}

::QPaintDevice * KTimeComboBoxWrapper::redirected(::QPoint * offset) const
{
    static const char *funcName = "redirected";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KTimeComboBox_TypeF(), gil, funcName, m_PyMethodCache[41], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::redirected(offset);
    }
    return KXYSelectorWrapper::sbk_o_redirected("KTimeComboBox", funcName, gil, pyOverride, offset);
}

void KTimeComboBoxWrapper::resizeEvent(::QResizeEvent * event)
{
    static const char *funcName = "resizeEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KTimeComboBox_TypeF(), gil, funcName, m_PyMethodCache[42], nameCache));
    if (pyOverride.isNull()) {
        return this->::KTimeComboBox::resizeEvent(event);
    }
    KXYSelectorWrapper::sbk_o_resizeEvent("KTimeComboBox", funcName, gil, pyOverride, event);
}

void KTimeComboBoxWrapper::setModel(::QAbstractItemModel * model)
{
    static const char *funcName = "setModel";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KTimeComboBox_TypeF(), gil, funcName, m_PyMethodCache[43], nameCache));
    if (pyOverride.isNull()) {
        return this->::QComboBox::setModel(model);
    }
    sbk_o_setModel("KTimeComboBox", funcName, gil, pyOverride, model);
}

void KTimeComboBoxWrapper::sbk_o_setModel(const char *ownerClassName, const char *funcName, Shiboken::GilState &gil, const Shiboken::AutoDecRef &pyOverride, ::QAbstractItemModel * model)
{
    SBK_UNUSED(ownerClassName)
    SBK_UNUSED(funcName)
    SBK_UNUSED(gil)
    SBK_UNUSED(pyOverride)
#if !defined(PYPY_VERSION) && !defined(Py_LIMITED_API)
    PyObject *pyArgArray[1] = {
        Shiboken::Conversions::pointerToPython(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QAbstractItemModel_IDX]), model)
    };
#else
    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
        Shiboken::Conversions::pointerToPython(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QAbstractItemModel_IDX]), model)
    ));
#endif

#if !defined(PYPY_VERSION) && !defined(Py_LIMITED_API)
    Shiboken::AutoDecRef pyResult(PyObject_Vectorcall(pyOverride, pyArgArray, 1, nullptr));
    Py_DECREF(pyArgArray[0]);
#else
    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
#endif
    if (pyResult.isNull()) {
        // An error happened in python code!
        Shiboken::Errors::storePythonOverrideErrorOrPrint(ownerClassName, funcName);
        return;
    }
}

void KTimeComboBoxWrapper::setVisible(bool visible)
{
    // This method belongs to a property.
    static const char *funcName = "2:setVisible";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KTimeComboBox_TypeF(), gil, funcName, m_PyMethodCache[44], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::setVisible(visible);
    }
    KXYSelectorWrapper::sbk_o_setVisible("KTimeComboBox", funcName, gil, pyOverride, visible);
}

::QPainter * KTimeComboBoxWrapper::sharedPainter() const
{
    static const char *funcName = "sharedPainter";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KTimeComboBox_TypeF(), gil, funcName, m_PyMethodCache[45], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::sharedPainter();
    }
    return KXYSelectorWrapper::sbk_o_sharedPainter("KTimeComboBox", funcName, gil, pyOverride);
}

void KTimeComboBoxWrapper::showEvent(::QShowEvent * e)
{
    static const char *funcName = "showEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KTimeComboBox_TypeF(), gil, funcName, m_PyMethodCache[46], nameCache));
    if (pyOverride.isNull()) {
        return this->::QComboBox::showEvent(e);
    }
    KXYSelectorWrapper::sbk_o_showEvent("KTimeComboBox", funcName, gil, pyOverride, e);
}

void KTimeComboBoxWrapper::showPopup()
{
    static const char *funcName = "showPopup";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KTimeComboBox_TypeF(), gil, funcName, m_PyMethodCache[47], nameCache));
    if (pyOverride.isNull()) {
        return this->::KTimeComboBox::showPopup();
    }
    KTimeComboBoxWrapper::sbk_o_hidePopup("KTimeComboBox", funcName, gil, pyOverride);
}

::QSize KTimeComboBoxWrapper::sizeHint() const
{
    static const char *funcName = "sizeHint";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KTimeComboBox_TypeF(), gil, funcName, m_PyMethodCache[48], nameCache));
    if (pyOverride.isNull()) {
        return this->::QComboBox::sizeHint();
    }
    return KXYSelectorWrapper::sbk_o_minimumSizeHint("KTimeComboBox", funcName, gil, pyOverride);
}

void KTimeComboBoxWrapper::tabletEvent(::QTabletEvent * event)
{
    static const char *funcName = "tabletEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KTimeComboBox_TypeF(), gil, funcName, m_PyMethodCache[49], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::tabletEvent(event);
    }
    KXYSelectorWrapper::sbk_o_tabletEvent("KTimeComboBox", funcName, gil, pyOverride, event);
}

void KTimeComboBoxWrapper::timerEvent(::QTimerEvent * event)
{
    static const char *funcName = "timerEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KTimeComboBox_TypeF(), gil, funcName, m_PyMethodCache[50], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::timerEvent(event);
    }
    KXYSelectorWrapper::sbk_o_timerEvent("KTimeComboBox", funcName, gil, pyOverride, event);
}

void KTimeComboBoxWrapper::wheelEvent(::QWheelEvent * event)
{
    static const char *funcName = "wheelEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KTimeComboBox_TypeF(), gil, funcName, m_PyMethodCache[51], nameCache));
    if (pyOverride.isNull()) {
        return this->::KTimeComboBox::wheelEvent(event);
    }
    KXYSelectorWrapper::sbk_o_wheelEvent("KTimeComboBox", funcName, gil, pyOverride, event);
}

const QMetaObject *KTimeComboBoxWrapper::metaObject() const
{
    if (QObject::d_ptr->metaObject != nullptr)
        return QObject::d_ptr->dynamicMetaObject();
    SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this);
    if (pySelf == nullptr)
        return KTimeComboBox::metaObject();
    return PySide::SignalManager::retrieveMetaObject(reinterpret_cast<PyObject *>(pySelf));
}

int KTimeComboBoxWrapper::qt_metacall(QMetaObject::Call call, int id, void **args)
{
    int result = KTimeComboBox::qt_metacall(call, id, args);
    return result < 0 ? result : PySide::SignalManager::qt_metacall(this, call, id, args);
}

void *KTimeComboBoxWrapper::qt_metacast(const char *_clname)
{
    if (_clname == nullptr)
        return {};
    if (SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this)) {
        auto *obSelf = reinterpret_cast<PyObject *>(pySelf);
        if (PySide::inherits(Py_TYPE(obSelf), _clname))
            return static_cast<void *>(const_cast< KTimeComboBoxWrapper *>(this));
    }
    return KTimeComboBox::qt_metacast(_clname);
}

KTimeComboBoxWrapper::~KTimeComboBoxWrapper()
{
    auto *wrapper = Shiboken::BindingManager::instance().retrieveWrapper(this, Sbk_KTimeComboBox_TypeF());
    Shiboken::Object::destroy(wrapper, this);
}

// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_KTimeComboBox_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SBK_UNUSED(kwds)
    auto *sbkSelf = reinterpret_cast<SbkObject *>(self);
    PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::KTimeComboBox >()))
        return -1;

    KTimeComboBoxWrapper *cptr{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[1];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr};

    // invalid argument lengths

    if (PyArg_ParseTuple(args, "|O:KTimeComboBox", &(pyArgs[0])) == 0)
        return -1;


    // Overloaded function decisor
    // 0: KTimeComboBox::KTimeComboBox(QWidget*=)
    if (numArgs == 0) {
        overloadId = 0; // KTimeComboBox(QWidget*)
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX]), (pyArgs[0])))) {
        overloadId = 0; // KTimeComboBox(QWidget*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KTimeComboBox_IDX]);


    // PyMI support
    bool usesPyMI = Shiboken::callInheritedInit(self, args, kwds, SbkKWidgetsAddonsTypeStructs[SBK_KTimeComboBox_IDX]);
    if (Shiboken::Errors::occurred() != nullptr)
        return -1;

    // Call function/method
    {
        if (kwds && PyDict_Size(kwds) > 0) {
            static const Shiboken::ArgumentNameIndexMapping mapping[1] = {{"parent", 0}};
            if (!Shiboken::parseConstructorKeywordArguments(kwds, mapping, 1, errInfo, pyArgs)
                || (pyArgs[0] != nullptr && !(pythonToCpp[0] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX]), (pyArgs[0]))))) {
                Py_XINCREF(errInfo.object());
                return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KTimeComboBox_IDX]);
            }
        }
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return -1;
        ::QWidget *cppArg0 = nullptr;
        if (pythonToCpp[0])
            pythonToCpp[0](pyArgs[0], &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // KTimeComboBox(QWidget*)
            void *addr = PySide::nextQObjectMemoryAddr();
            if (addr != nullptr) {
                cptr = new (addr) KTimeComboBoxWrapper(cppArg0);
                PySide::setNextQObjectMemoryAddr(nullptr);
            } else {
                cptr = new KTimeComboBoxWrapper(cppArg0);
            }

        }
    }

    if (Shiboken::Errors::occurred() != nullptr || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< KTimeComboBox >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (cptr == nullptr)
        return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KTimeComboBox_IDX]);

    Shiboken::Object::setValidCpp(sbkSelf, true);
    Shiboken::Object::setHasCppWrapper(sbkSelf, true);
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);

    // QObject setup
    PySide::Signal::updateSourceObject(self);
    const auto *metaObject = cptr->metaObject(); // <- init python qt properties
    if (!errInfo.isNull() && PyDict_Check(errInfo.object())) {
        if (!PySide::fillQtProperties(self, metaObject, errInfo, usesPyMI))
            return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KTimeComboBox_IDX]);
    };


    return 1;
}

static PyObject *Sbk_KTimeComboBoxFunc_assignTime(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KTimeComboBox *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KTimeComboBox_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KTimeComboBox::assignTime(QTime)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QTime_IDX]), (pyArg)))) {
        overloadId = 0; // assignTime(QTime)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "assignTime", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KTimeComboBox_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QTime cppArg0_local;
        ::QTime *cppArg0 = &cppArg0_local;
        if (pythonToCpp.isValue())
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (Shiboken::Errors::occurred() == nullptr) {
            // assignTime(QTime)
            Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::KTimeComboBox::assignTime(*cppArg0)
                : cppSelf->assignTime(*cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KTimeComboBoxFunc_displayFormat(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KTimeComboBox *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KTimeComboBox_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // displayFormat()const
        QLocale::FormatType cppResult = const_cast<const ::KTimeComboBox *>(cppSelf)->displayFormat();
        pyResult = Shiboken::Conversions::copyToPython(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QLocale_FormatType_IDX])))->converter, &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KTimeComboBoxFunc_eventFilter(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KTimeComboBox *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KTimeComboBox_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[2];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr};

    // invalid argument lengths

    if (PyArg_UnpackTuple(args, "eventFilter", 2, 2, &(pyArgs[0]), &(pyArgs[1])) == 0)
        return {};


    // Overloaded function decisor
    // 0: QObject::eventFilter(QObject*,QEvent*)->bool
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QObject_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QEvent_IDX]), (pyArgs[1])))) {
        overloadId = 0; // eventFilter(QObject*,QEvent*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "eventFilter", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KTimeComboBox_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::QObject *cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        if (!Shiboken::Object::isValid(pyArgs[1]))
            return {};
        ::QEvent *cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (Shiboken::Errors::occurred() == nullptr) {
            // eventFilter(QObject*,QEvent*)
            bool cppResult = Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::KTimeComboBox::eventFilter(cppArg0, cppArg1)
                : cppSelf->eventFilter(cppArg0, cppArg1);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KTimeComboBoxFunc_focusInEvent(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KTimeComboBox *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KTimeComboBox_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QWidget::focusInEvent(QFocusEvent*)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QFocusEvent_IDX]), (pyArg)))) {
        overloadId = 0; // focusInEvent(QFocusEvent*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "focusInEvent", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KTimeComboBox_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QFocusEvent *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // focusInEvent(QFocusEvent*)
            Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::KTimeComboBox::focusInEvent(cppArg0)
                : cppSelf->focusInEvent(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KTimeComboBoxFunc_focusOutEvent(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KTimeComboBox *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KTimeComboBox_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QWidget::focusOutEvent(QFocusEvent*)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QFocusEvent_IDX]), (pyArg)))) {
        overloadId = 0; // focusOutEvent(QFocusEvent*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "focusOutEvent", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KTimeComboBox_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QFocusEvent *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // focusOutEvent(QFocusEvent*)
            Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::KTimeComboBox::focusOutEvent(cppArg0)
                : cppSelf->focusOutEvent(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KTimeComboBoxFunc_hidePopup(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KTimeComboBox *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KTimeComboBox_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // hidePopup()
        Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
            ? cppSelf->::KTimeComboBox::hidePopup()
            : cppSelf->hidePopup();
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KTimeComboBoxFunc_isNull(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KTimeComboBox *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KTimeComboBox_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // isNull()const
        bool cppResult = const_cast<const ::KTimeComboBox *>(cppSelf)->isNull();
        pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KTimeComboBoxFunc_isValid(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KTimeComboBox *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KTimeComboBox_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // isValid()const
        bool cppResult = const_cast<const ::KTimeComboBox *>(cppSelf)->isValid();
        pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KTimeComboBoxFunc_keyPressEvent(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KTimeComboBox *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KTimeComboBox_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QWidget::keyPressEvent(QKeyEvent*)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QKeyEvent_IDX]), (pyArg)))) {
        overloadId = 0; // keyPressEvent(QKeyEvent*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "keyPressEvent", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KTimeComboBox_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QKeyEvent *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // keyPressEvent(QKeyEvent*)
            Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::KTimeComboBox::keyPressEvent(cppArg0)
                : cppSelf->keyPressEvent(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KTimeComboBoxFunc_maximumTime(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KTimeComboBox *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KTimeComboBox_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // maximumTime()const
        QTime cppResult = const_cast<const ::KTimeComboBox *>(cppSelf)->maximumTime();
        pyResult = Shiboken::Conversions::copyToPython(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QTime_IDX]), &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KTimeComboBoxFunc_minimumTime(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KTimeComboBox *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KTimeComboBox_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // minimumTime()const
        QTime cppResult = const_cast<const ::KTimeComboBox *>(cppSelf)->minimumTime();
        pyResult = Shiboken::Conversions::copyToPython(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QTime_IDX]), &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KTimeComboBoxFunc_mousePressEvent(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KTimeComboBox *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KTimeComboBox_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QWidget::mousePressEvent(QMouseEvent*)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QMouseEvent_IDX]), (pyArg)))) {
        overloadId = 0; // mousePressEvent(QMouseEvent*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "mousePressEvent", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KTimeComboBox_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QMouseEvent *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // mousePressEvent(QMouseEvent*)
            Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::KTimeComboBox::mousePressEvent(cppArg0)
                : cppSelf->mousePressEvent(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KTimeComboBoxFunc_options(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KTimeComboBox *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KTimeComboBox_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // options()const
        QFlags<KTimeComboBox::Option> cppResult = const_cast<const ::KTimeComboBox *>(cppSelf)->options();
        pyResult = Shiboken::Conversions::copyToPython(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_QFlags_KTimeComboBox_Option_IDX])))->flagsConverter, &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KTimeComboBoxFunc_resetMaximumTime(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KTimeComboBox *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KTimeComboBox_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // resetMaximumTime()
        cppSelf->resetMaximumTime();
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KTimeComboBoxFunc_resetMinimumTime(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KTimeComboBox *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KTimeComboBox_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // resetMinimumTime()
        cppSelf->resetMinimumTime();
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KTimeComboBoxFunc_resetTimeRange(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KTimeComboBox *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KTimeComboBox_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // resetTimeRange()
        cppSelf->resetTimeRange();
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KTimeComboBoxFunc_resizeEvent(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KTimeComboBox *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KTimeComboBox_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QWidget::resizeEvent(QResizeEvent*)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QResizeEvent_IDX]), (pyArg)))) {
        overloadId = 0; // resizeEvent(QResizeEvent*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "resizeEvent", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KTimeComboBox_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QResizeEvent *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // resizeEvent(QResizeEvent*)
            Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::KTimeComboBox::resizeEvent(cppArg0)
                : cppSelf->resizeEvent(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KTimeComboBoxFunc_setDisplayFormat(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KTimeComboBox *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KTimeComboBox_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KTimeComboBox::setDisplayFormat(QLocale::FormatType)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QLocale_FormatType_IDX])))->converter, (pyArg)))) {
        overloadId = 0; // setDisplayFormat(QLocale::FormatType)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setDisplayFormat", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KTimeComboBox_IDX]);

    // Call function/method
    {
        ::QLocale::FormatType cppArg0{QLocale::LongFormat};
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setDisplayFormat(QLocale::FormatType)
            cppSelf->setDisplayFormat(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KTimeComboBoxFunc_setMaximumTime(PyObject *self, PyObject *args, PyObject *kwds)
{
    SBK_UNUSED(kwds)
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KTimeComboBox *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KTimeComboBox_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[2];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr};

    // invalid argument lengths
    errInfo.reset(Shiboken::checkInvalidArgumentCount(numArgs, 1, 2));
    if (!errInfo.isNull())
        return Shiboken::returnWrongArguments(args, "setMaximumTime", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KTimeComboBox_IDX]);

    if (PyArg_ParseTuple(args, "|OO:setMaximumTime", &(pyArgs[0]), &(pyArgs[1])) == 0)
        return {};


    // Overloaded function decisor
    // 0: KTimeComboBox::setMaximumTime(QTime,const QString&=)
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QTime_IDX]), (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // setMaximumTime(QTime,QString)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[1])))) {
            overloadId = 0; // setMaximumTime(QTime,QString)
        }
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "setMaximumTime", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KTimeComboBox_IDX]);

    // Call function/method
    {
        if (kwds && PyDict_Size(kwds) > 0) {
            static const Shiboken::ArgumentNameIndexMapping mapping[1] = {{"maxWarnMsg", 1}};
            if (!Shiboken::parseKeywordArguments(kwds, mapping, 1, errInfo, pyArgs)
                || (pyArgs[1] != nullptr && !(pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[1]))))) {
                Py_XINCREF(errInfo.object());
                return Shiboken::returnWrongArguments(args, "setMaximumTime", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KTimeComboBox_IDX]);
            }
        }
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::QTime cppArg0_local;
        ::QTime *cppArg0 = &cppArg0_local;
        if (pythonToCpp[0].isValue())
            pythonToCpp[0](pyArgs[0], &cppArg0_local);
        else
            pythonToCpp[0](pyArgs[0], &cppArg0);

        ::QString cppArg1 = QString();
        if (pythonToCpp[1])
            pythonToCpp[1](pyArgs[1], &cppArg1);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setMaximumTime(QTime,QString)
            cppSelf->setMaximumTime(*cppArg0, cppArg1);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KTimeComboBoxFunc_setMinimumTime(PyObject *self, PyObject *args, PyObject *kwds)
{
    SBK_UNUSED(kwds)
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KTimeComboBox *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KTimeComboBox_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[2];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr};

    // invalid argument lengths
    errInfo.reset(Shiboken::checkInvalidArgumentCount(numArgs, 1, 2));
    if (!errInfo.isNull())
        return Shiboken::returnWrongArguments(args, "setMinimumTime", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KTimeComboBox_IDX]);

    if (PyArg_ParseTuple(args, "|OO:setMinimumTime", &(pyArgs[0]), &(pyArgs[1])) == 0)
        return {};


    // Overloaded function decisor
    // 0: KTimeComboBox::setMinimumTime(QTime,const QString&=)
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QTime_IDX]), (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // setMinimumTime(QTime,QString)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[1])))) {
            overloadId = 0; // setMinimumTime(QTime,QString)
        }
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "setMinimumTime", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KTimeComboBox_IDX]);

    // Call function/method
    {
        if (kwds && PyDict_Size(kwds) > 0) {
            static const Shiboken::ArgumentNameIndexMapping mapping[1] = {{"minWarnMsg", 1}};
            if (!Shiboken::parseKeywordArguments(kwds, mapping, 1, errInfo, pyArgs)
                || (pyArgs[1] != nullptr && !(pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[1]))))) {
                Py_XINCREF(errInfo.object());
                return Shiboken::returnWrongArguments(args, "setMinimumTime", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KTimeComboBox_IDX]);
            }
        }
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::QTime cppArg0_local;
        ::QTime *cppArg0 = &cppArg0_local;
        if (pythonToCpp[0].isValue())
            pythonToCpp[0](pyArgs[0], &cppArg0_local);
        else
            pythonToCpp[0](pyArgs[0], &cppArg0);

        ::QString cppArg1 = QString();
        if (pythonToCpp[1])
            pythonToCpp[1](pyArgs[1], &cppArg1);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setMinimumTime(QTime,QString)
            cppSelf->setMinimumTime(*cppArg0, cppArg1);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KTimeComboBoxFunc_setOptions(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KTimeComboBox *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KTimeComboBox_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KTimeComboBox::setOptions(QFlags<KTimeComboBox::Option>)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_QFlags_KTimeComboBox_Option_IDX])))->flagsConverter, (pyArg)))) {
        overloadId = 0; // setOptions(QFlags<KTimeComboBox::Option>)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setOptions", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KTimeComboBox_IDX]);

    // Call function/method
    {
        ::QFlags<KTimeComboBox::Option> cppArg0 = QFlags<KTimeComboBox::Option>(0);
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setOptions(QFlags<KTimeComboBox::Option>)
            cppSelf->setOptions(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KTimeComboBoxFunc_setTime(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KTimeComboBox *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KTimeComboBox_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KTimeComboBox::setTime(QTime)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QTime_IDX]), (pyArg)))) {
        overloadId = 0; // setTime(QTime)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setTime", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KTimeComboBox_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QTime cppArg0_local;
        ::QTime *cppArg0 = &cppArg0_local;
        if (pythonToCpp.isValue())
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (Shiboken::Errors::occurred() == nullptr) {
            // setTime(QTime)
            cppSelf->setTime(*cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KTimeComboBoxFunc_setTimeList(PyObject *self, PyObject *args, PyObject *kwds)
{
    SBK_UNUSED(kwds)
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KTimeComboBox *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KTimeComboBox_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[3];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr, nullptr};

    // invalid argument lengths
    errInfo.reset(Shiboken::checkInvalidArgumentCount(numArgs, 1, 3));
    if (!errInfo.isNull())
        return Shiboken::returnWrongArguments(args, "setTimeList", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KTimeComboBox_IDX]);

    if (PyArg_ParseTuple(args, "|OOO:setTimeList", &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])) == 0)
        return {};


    // Overloaded function decisor
    // 0: KTimeComboBox::setTimeList(QList<QTime>,const QString&=,const QString&=)
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppConversion(SbkKWidgetsAddonsTypeConverters[SBK_KWidgetsAddons_QList_QTime_IDX], (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // setTimeList(QList<QTime>,QString,QString)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[1])))) {
            if (numArgs == 2) {
                overloadId = 0; // setTimeList(QList<QTime>,QString,QString)
            } else if (numArgs >= 3
                && (pythonToCpp[2] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[2])))) {
                overloadId = 0; // setTimeList(QList<QTime>,QString,QString)
            }
        }
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "setTimeList", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KTimeComboBox_IDX]);

    // Call function/method
    {
        if (kwds && PyDict_Size(kwds) > 0) {
            static const Shiboken::ArgumentNameIndexMapping mapping[2] = {{"minWarnMsg", 1}, {"maxWarnMsg", 2}};
            if (!Shiboken::parseKeywordArguments(kwds, mapping, 2, errInfo, pyArgs)
                || (pyArgs[1] != nullptr && !(pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[1]))))
                || (pyArgs[2] != nullptr && !(pythonToCpp[2] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[2]))))) {
                Py_XINCREF(errInfo.object());
                return Shiboken::returnWrongArguments(args, "setTimeList", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KTimeComboBox_IDX]);
            }
        }
        ::QList<QTime> cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        ::QString cppArg1 = QString();
        if (pythonToCpp[1])
            pythonToCpp[1](pyArgs[1], &cppArg1);
        ::QString cppArg2 = QString();
        if (pythonToCpp[2])
            pythonToCpp[2](pyArgs[2], &cppArg2);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setTimeList(QList<QTime>,QString,QString)
            cppSelf->setTimeList(cppArg0, cppArg1, cppArg2);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KTimeComboBoxFunc_setTimeListInterval(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KTimeComboBox *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KTimeComboBox_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KTimeComboBox::setTimeListInterval(int)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // setTimeListInterval(int)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setTimeListInterval", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KTimeComboBox_IDX]);

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setTimeListInterval(int)
            cppSelf->setTimeListInterval(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KTimeComboBoxFunc_setTimeRange(PyObject *self, PyObject *args, PyObject *kwds)
{
    SBK_UNUSED(kwds)
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KTimeComboBox *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KTimeComboBox_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[4];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr, nullptr, nullptr};

    // invalid argument lengths
    errInfo.reset(Shiboken::checkInvalidArgumentCount(numArgs, 2, 4));
    if (!errInfo.isNull())
        return Shiboken::returnWrongArguments(args, "setTimeRange", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KTimeComboBox_IDX]);

    if (PyArg_ParseTuple(args, "|OOOO:setTimeRange", &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3])) == 0)
        return {};


    // Overloaded function decisor
    // 0: KTimeComboBox::setTimeRange(QTime,QTime,const QString&=,const QString&=)
    if (numArgs >= 2
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QTime_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QTime_IDX]), (pyArgs[1])))) {
        if (numArgs == 2) {
            overloadId = 0; // setTimeRange(QTime,QTime,QString,QString)
        } else if (numArgs >= 3
            && (pythonToCpp[2] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[2])))) {
            if (numArgs == 3) {
                overloadId = 0; // setTimeRange(QTime,QTime,QString,QString)
            } else if (numArgs >= 4
                && (pythonToCpp[3] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[3])))) {
                overloadId = 0; // setTimeRange(QTime,QTime,QString,QString)
            }
        }
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "setTimeRange", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KTimeComboBox_IDX]);

    // Call function/method
    {
        if (kwds && PyDict_Size(kwds) > 0) {
            static const Shiboken::ArgumentNameIndexMapping mapping[2] = {{"minWarnMsg", 2}, {"maxWarnMsg", 3}};
            if (!Shiboken::parseKeywordArguments(kwds, mapping, 2, errInfo, pyArgs)
                || (pyArgs[2] != nullptr && !(pythonToCpp[2] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[2]))))
                || (pyArgs[3] != nullptr && !(pythonToCpp[3] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[3]))))) {
                Py_XINCREF(errInfo.object());
                return Shiboken::returnWrongArguments(args, "setTimeRange", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KTimeComboBox_IDX]);
            }
        }
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::QTime cppArg0_local;
        ::QTime *cppArg0 = &cppArg0_local;
        if (pythonToCpp[0].isValue())
            pythonToCpp[0](pyArgs[0], &cppArg0_local);
        else
            pythonToCpp[0](pyArgs[0], &cppArg0);

        if (!Shiboken::Object::isValid(pyArgs[1]))
            return {};
        ::QTime cppArg1_local;
        ::QTime *cppArg1 = &cppArg1_local;
        if (pythonToCpp[1].isValue())
            pythonToCpp[1](pyArgs[1], &cppArg1_local);
        else
            pythonToCpp[1](pyArgs[1], &cppArg1);

        ::QString cppArg2 = QString();
        if (pythonToCpp[2])
            pythonToCpp[2](pyArgs[2], &cppArg2);
        ::QString cppArg3 = QString();
        if (pythonToCpp[3])
            pythonToCpp[3](pyArgs[3], &cppArg3);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setTimeRange(QTime,QTime,QString,QString)
            cppSelf->setTimeRange(*cppArg0, *cppArg1, cppArg2, cppArg3);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KTimeComboBoxFunc_showPopup(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KTimeComboBox *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KTimeComboBox_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // showPopup()
        Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
            ? cppSelf->::KTimeComboBox::showPopup()
            : cppSelf->showPopup();
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KTimeComboBoxFunc_time(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KTimeComboBox *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KTimeComboBox_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // time()const
        QTime cppResult = const_cast<const ::KTimeComboBox *>(cppSelf)->time();
        pyResult = Shiboken::Conversions::copyToPython(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QTime_IDX]), &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KTimeComboBoxFunc_timeList(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KTimeComboBox *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KTimeComboBox_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // timeList()const
        QList<QTime> cppResult = const_cast<const ::KTimeComboBox *>(cppSelf)->timeList();
        pyResult = Shiboken::Conversions::copyToPython(SbkKWidgetsAddonsTypeConverters[SBK_KWidgetsAddons_QList_QTime_IDX], &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KTimeComboBoxFunc_timeListInterval(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KTimeComboBox *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KTimeComboBox_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // timeListInterval()const
        int cppResult = const_cast<const ::KTimeComboBox *>(cppSelf)->timeListInterval();
        pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KTimeComboBoxFunc_wheelEvent(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KTimeComboBox *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KTimeComboBox_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QWidget::wheelEvent(QWheelEvent*)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QWheelEvent_IDX]), (pyArg)))) {
        overloadId = 0; // wheelEvent(QWheelEvent*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "wheelEvent", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KTimeComboBox_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QWheelEvent *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // wheelEvent(QWheelEvent*)
            Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::KTimeComboBox::wheelEvent(cppArg0)
                : cppSelf->wheelEvent(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}


static const char *Sbk_KTimeComboBox_PropertyStrings[] = {
    "maximumTime::",
    "minimumTime::",
    "options::",
    "time::",
    "timeListInterval::",
    nullptr // Sentinel
};

static const char *Sbk_KTimeComboBox_EnumFlagInfo[] = {
    "Option:IntFlag:Options",
    nullptr // Sentinel
};

static PyMethodDef Sbk_KTimeComboBox_methods[] = {
    {"assignTime", reinterpret_cast<PyCFunction>(Sbk_KTimeComboBoxFunc_assignTime), METH_O, nullptr},
    {"displayFormat", reinterpret_cast<PyCFunction>(Sbk_KTimeComboBoxFunc_displayFormat), METH_NOARGS, nullptr},
    {"eventFilter", reinterpret_cast<PyCFunction>(Sbk_KTimeComboBoxFunc_eventFilter), METH_VARARGS, nullptr},
    {"focusInEvent", reinterpret_cast<PyCFunction>(Sbk_KTimeComboBoxFunc_focusInEvent), METH_O, nullptr},
    {"focusOutEvent", reinterpret_cast<PyCFunction>(Sbk_KTimeComboBoxFunc_focusOutEvent), METH_O, nullptr},
    {"hidePopup", reinterpret_cast<PyCFunction>(Sbk_KTimeComboBoxFunc_hidePopup), METH_NOARGS, nullptr},
    {"isNull", reinterpret_cast<PyCFunction>(Sbk_KTimeComboBoxFunc_isNull), METH_NOARGS, nullptr},
    {"isValid", reinterpret_cast<PyCFunction>(Sbk_KTimeComboBoxFunc_isValid), METH_NOARGS, nullptr},
    {"keyPressEvent", reinterpret_cast<PyCFunction>(Sbk_KTimeComboBoxFunc_keyPressEvent), METH_O, nullptr},
    {"maximumTime", reinterpret_cast<PyCFunction>(Sbk_KTimeComboBoxFunc_maximumTime), METH_NOARGS, nullptr},
    {"minimumTime", reinterpret_cast<PyCFunction>(Sbk_KTimeComboBoxFunc_minimumTime), METH_NOARGS, nullptr},
    {"mousePressEvent", reinterpret_cast<PyCFunction>(Sbk_KTimeComboBoxFunc_mousePressEvent), METH_O, nullptr},
    {"options", reinterpret_cast<PyCFunction>(Sbk_KTimeComboBoxFunc_options), METH_NOARGS, nullptr},
    {"resetMaximumTime", reinterpret_cast<PyCFunction>(Sbk_KTimeComboBoxFunc_resetMaximumTime), METH_NOARGS, nullptr},
    {"resetMinimumTime", reinterpret_cast<PyCFunction>(Sbk_KTimeComboBoxFunc_resetMinimumTime), METH_NOARGS, nullptr},
    {"resetTimeRange", reinterpret_cast<PyCFunction>(Sbk_KTimeComboBoxFunc_resetTimeRange), METH_NOARGS, nullptr},
    {"resizeEvent", reinterpret_cast<PyCFunction>(Sbk_KTimeComboBoxFunc_resizeEvent), METH_O, nullptr},
    {"setDisplayFormat", reinterpret_cast<PyCFunction>(Sbk_KTimeComboBoxFunc_setDisplayFormat), METH_O, nullptr},
    {"setMaximumTime", reinterpret_cast<PyCFunction>(Sbk_KTimeComboBoxFunc_setMaximumTime), METH_VARARGS|METH_KEYWORDS, nullptr},
    {"setMinimumTime", reinterpret_cast<PyCFunction>(Sbk_KTimeComboBoxFunc_setMinimumTime), METH_VARARGS|METH_KEYWORDS, nullptr},
    {"setOptions", reinterpret_cast<PyCFunction>(Sbk_KTimeComboBoxFunc_setOptions), METH_O, nullptr},
    {"setTime", reinterpret_cast<PyCFunction>(Sbk_KTimeComboBoxFunc_setTime), METH_O, nullptr},
    {"setTimeList", reinterpret_cast<PyCFunction>(Sbk_KTimeComboBoxFunc_setTimeList), METH_VARARGS|METH_KEYWORDS, nullptr},
    {"setTimeListInterval", reinterpret_cast<PyCFunction>(Sbk_KTimeComboBoxFunc_setTimeListInterval), METH_O, nullptr},
    {"setTimeRange", reinterpret_cast<PyCFunction>(Sbk_KTimeComboBoxFunc_setTimeRange), METH_VARARGS|METH_KEYWORDS, nullptr},
    {"showPopup", reinterpret_cast<PyCFunction>(Sbk_KTimeComboBoxFunc_showPopup), METH_NOARGS, nullptr},
    {"time", reinterpret_cast<PyCFunction>(Sbk_KTimeComboBoxFunc_time), METH_NOARGS, nullptr},
    {"timeList", reinterpret_cast<PyCFunction>(Sbk_KTimeComboBoxFunc_timeList), METH_NOARGS, nullptr},
    {"timeListInterval", reinterpret_cast<PyCFunction>(Sbk_KTimeComboBoxFunc_timeListInterval), METH_NOARGS, nullptr},
    {"wheelEvent", reinterpret_cast<PyCFunction>(Sbk_KTimeComboBoxFunc_wheelEvent), METH_O, nullptr},
    {nullptr, nullptr, 0, nullptr} // Sentinel
};

static int Sbk_KTimeComboBox_setattro(PyObject *self, PyObject *name, PyObject *value)
{
    PySide::Feature::Select(self);
    if (value != nullptr && PyCallable_Check(value) != 0) {
        auto plain_inst = reinterpret_cast< ::KTimeComboBox *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KTimeComboBox_IDX]), reinterpret_cast<SbkObject *>(self)));
        auto *inst = dynamic_cast<KTimeComboBoxWrapper *>(plain_inst);
        if (inst != nullptr)
            inst->resetPyMethodCache();
    }
    Shiboken::AutoDecRef pp(reinterpret_cast<PyObject *>(PySide::Property::getObject(self, name)));
    if (!pp.isNull())
        return PySide::Property::setValue(reinterpret_cast<PySideProperty *>(pp.object()), self, value);
    return PyObject_GenericSetAttr(self, name, value);
}

} // extern "C"

static int Sbk_KTimeComboBox_traverse(PyObject *self, visitproc visit, void *arg)
{
    auto traverseProc = reinterpret_cast<traverseproc>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_traverse));
    ;
    return traverseProc(self, visit, arg);
}
static int Sbk_KTimeComboBox_clear(PyObject *self)
{
    auto clearProc = reinterpret_cast<inquiry>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_clear));
    ;
    return clearProc(self);
}
static void * Sbk_KTimeComboBoxSpecialCastFunction(void *obj, PyTypeObject *desiredType)
{
    auto me = reinterpret_cast< ::KTimeComboBox *>(obj);
    if (desiredType == Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QComboBox_IDX]))
        return static_cast< ::QComboBox *>(me);
    else if (desiredType == Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX]))
        return static_cast< ::QWidget *>(me);
    else if (desiredType == Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QObject_IDX]))
        return static_cast< ::QObject *>(me);
    else if (desiredType == Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QPaintDevice_IDX]))
        return static_cast< ::QPaintDevice *>(me);
    return me;
}



// Class Definition -----------------------------------------------
extern "C" {

static PyType_Slot Sbk_KTimeComboBox_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_setattro,    reinterpret_cast<void *>(Sbk_KTimeComboBox_setattro)},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_KTimeComboBox_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_KTimeComboBox_clear)},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_KTimeComboBox_methods)},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_KTimeComboBox_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObject_tp_new)},
    {0, nullptr}
};
static PyType_Spec Sbk_KTimeComboBox_spec = {
    "1:KWidgetsAddons.KTimeComboBox",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_HAVE_GC,
    Sbk_KTimeComboBox_slots
};

} //extern "C"

static void *Sbk_KTimeComboBox_typeDiscovery(void *cptr, PyTypeObject *instanceType)
{
    SBK_UNUSED(cptr)
    SBK_UNUSED(instanceType)
    if (instanceType == Shiboken::SbkType< ::QWidget >())
        return dynamic_cast< ::KTimeComboBox *>(reinterpret_cast< ::QWidget *>(cptr));
    if (instanceType == Shiboken::SbkType< ::QObject >())
        return dynamic_cast< ::KTimeComboBox *>(reinterpret_cast< ::QObject *>(cptr));
    if (instanceType == Shiboken::SbkType< ::QPaintDevice >())
        return dynamic_cast< ::KTimeComboBox *>(reinterpret_cast< ::QPaintDevice *>(cptr));
    return {};
}


// Type conversion functions.

// Python to C++ enum conversion.
static void Enum_PythonToCpp_KTimeComboBox_Option(PyObject *pyIn, void *cppOut)
{
    const auto value = static_cast<::KTimeComboBox::Option>(Shiboken::Enum::getValue(pyIn));
    *reinterpret_cast<::KTimeComboBox::Option *>(cppOut) = value;

}
static PythonToCppFunc is_Enum_PythonToCpp_KTimeComboBox_Option_Convertible(PyObject *pyIn)
{
    if (PyObject_TypeCheck(pyIn, Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KTimeComboBox_Option_IDX])))
        return Enum_PythonToCpp_KTimeComboBox_Option;
    return {};
}

static PyObject *KTimeComboBox_Option_CppToPython_Enum(PyTypeObject *pyType, const void *cppIn)
{
    using IntType = std::underlying_type_t<::KTimeComboBox::Option>;
    const auto castCppIn = IntType(*reinterpret_cast<const ::KTimeComboBox::Option *>(cppIn));
    return Shiboken::Enum::newItem(pyType, castCppIn);

}

static void Flag_PythonToCpp_KTimeComboBox_Option(PyObject *pyIn, void *cppOut)
{
    const auto value = QFlags<::KTimeComboBox::Option>::fromInt(Shiboken::Enum::getValue(pyIn));
    *reinterpret_cast<QFlags<::KTimeComboBox::Option> *>(cppOut) = value;

}

static PyObject *KTimeComboBox_Option_CppToPython_Flag(const void *cppIn)
{
    const auto flags = *reinterpret_cast<const QFlags<::KTimeComboBox::Option> *>(cppIn);
    return Shiboken::Enum::newItem(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KTimeComboBox_Option_IDX]), flags.toInt());

}

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void KTimeComboBox_PythonToCpp_KTimeComboBox_PTR(PyObject *pyIn, void *cppOut)
{
    Shiboken::Conversions::pythonToCppPointer(Sbk_KTimeComboBox_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_KTimeComboBox_PythonToCpp_KTimeComboBox_PTR_Convertible(PyObject *pyIn)
{
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, Sbk_KTimeComboBox_TypeF()))
        return KTimeComboBox_PythonToCpp_KTimeComboBox_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *KTimeComboBox_PTR_CppToPython_KTimeComboBox(const void *cppIn)
{
    return PySide::getWrapperForQObject(reinterpret_cast<::KTimeComboBox *>(const_cast<void *>(cppIn)), Sbk_KTimeComboBox_TypeF());

}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
#if PYSIDE6_COMOPT_COMPRESS == 0
static const char *KTimeComboBox_SignatureStrings[] = {
    "KWidgetsAddons.KTimeComboBox(self,parent:PySide6.QtWidgets.QWidget=nullptr,*:KeywordOnly=None,time:QTime=None,minimumTime:QTime=None,maximumTime:QTime=None,timeListInterval:int=None,options:KWidgetsAddons.KDateComboBox.Option=None)",
    "KWidgetsAddons.KTimeComboBox.assignTime(self,time:PySide6.QtCore.QTime)",
    "KWidgetsAddons.KTimeComboBox.displayFormat(self)->PySide6.QtCore.QLocale.FormatType",
    "KWidgetsAddons.KTimeComboBox.eventFilter(self,object:PySide6.QtCore.QObject,event:PySide6.QtCore.QEvent)->bool",
    "KWidgetsAddons.KTimeComboBox.focusInEvent(self,event:PySide6.QtGui.QFocusEvent)",
    "KWidgetsAddons.KTimeComboBox.focusOutEvent(self,event:PySide6.QtGui.QFocusEvent)",
    "KWidgetsAddons.KTimeComboBox.hidePopup(self)",
    "KWidgetsAddons.KTimeComboBox.isNull(self)->bool",
    "KWidgetsAddons.KTimeComboBox.isValid(self)->bool",
    "KWidgetsAddons.KTimeComboBox.keyPressEvent(self,event:PySide6.QtGui.QKeyEvent)",
    "KWidgetsAddons.KTimeComboBox.maximumTime(self)->PySide6.QtCore.QTime",
    "KWidgetsAddons.KTimeComboBox.minimumTime(self)->PySide6.QtCore.QTime",
    "KWidgetsAddons.KTimeComboBox.mousePressEvent(self,event:PySide6.QtGui.QMouseEvent)",
    "KWidgetsAddons.KTimeComboBox.options(self)->KWidgetsAddons.KTimeComboBox.Option",
    "KWidgetsAddons.KTimeComboBox.resetMaximumTime(self)",
    "KWidgetsAddons.KTimeComboBox.resetMinimumTime(self)",
    "KWidgetsAddons.KTimeComboBox.resetTimeRange(self)",
    "KWidgetsAddons.KTimeComboBox.resizeEvent(self,event:PySide6.QtGui.QResizeEvent)",
    "KWidgetsAddons.KTimeComboBox.setDisplayFormat(self,format:PySide6.QtCore.QLocale.FormatType)",
    "KWidgetsAddons.KTimeComboBox.setMaximumTime(self,maxTime:PySide6.QtCore.QTime,maxWarnMsg:QString=QString())",
    "KWidgetsAddons.KTimeComboBox.setMinimumTime(self,minTime:PySide6.QtCore.QTime,minWarnMsg:QString=QString())",
    "KWidgetsAddons.KTimeComboBox.setOptions(self,options:KWidgetsAddons.KTimeComboBox.Option)",
    "KWidgetsAddons.KTimeComboBox.setTime(self,time:PySide6.QtCore.QTime)",
    "KWidgetsAddons.KTimeComboBox.setTimeList(self,timeList:QList[PySide6.QtCore.QTime],minWarnMsg:QString=QString(),maxWarnMsg:QString=QString())",
    "KWidgetsAddons.KTimeComboBox.setTimeListInterval(self,minutes:int)",
    "KWidgetsAddons.KTimeComboBox.setTimeRange(self,minTime:PySide6.QtCore.QTime,maxTime:PySide6.QtCore.QTime,minWarnMsg:QString=QString(),maxWarnMsg:QString=QString())",
    "KWidgetsAddons.KTimeComboBox.showPopup(self)",
    "KWidgetsAddons.KTimeComboBox.time(self)->PySide6.QtCore.QTime",
    "KWidgetsAddons.KTimeComboBox.timeList(self)->QList[PySide6.QtCore.QTime]",
    "KWidgetsAddons.KTimeComboBox.timeListInterval(self)->int",
    "KWidgetsAddons.KTimeComboBox.wheelEvent(self,event:PySide6.QtGui.QWheelEvent)",
    nullptr}; // Sentinel
#else
static constexpr size_t KTimeComboBox_SignatureByteSize = 524;
static constexpr uint8_t KTimeComboBox_SignatureBytes[524] = {
    0x78, 0xda, 0xb5, 0x95, 0xc9, 0x6e, 0xdb, 0x30, 0x10, 0x40, 0xef, 0xf9, 0x92, 0xb8, 0x50, 0x75,
    0xcc, 0x41, 0x80, 0x0b, 0xb4, 0x49, 0x1d, 0x04, 0x8a, 0x23, 0x2b, 0x11, 0xea, 0x43, 0xd1, 0x03,
    0x6d, 0x8d, 0x65, 0xb6, 0x14, 0x29, 0x88, 0x54, 0x1c, 0xf5, 0xeb, 0xcb, 0xc5, 0xb1, 0x5c, 0xda,
    0x26, 0x09, 0xa8, 0xbd, 0x68, 0x19, 0xce, 0xbc, 0xd9, 0x48, 0x4e, 0xba, 0xc4, 0x65, 0x05, 0x82,
    0x7f, 0x2e, 0x4b, 0x46, 0x79, 0x9c, 0x16, 0xb8, 0x86, 0x5b, 0x56, 0xaf, 0xd8, 0x17, 0xf6, 0x76,
    0xcd, 0x81, 0x6c, 0xa2, 0x06, 0xb5, 0x40, 0x45, 0xb2, 0xe8, 0x5f, 0x70, 0x09, 0x37, 0x71, 0x2e,
    0xf6, 0x16, 0x71, 0x6e, 0x3e, 0xa6, 0xb4, 0x23, 0xa4, 0x11, 0x6d, 0xf4, 0x21, 0x49, 0xa1, 0xdf,
    0xb1, 0xb6, 0xcc, 0x28, 0xe9, 0xa7, 0x4f, 0x8c, 0x42, 0x24, 0x24, 0x2d, 0xc9, 0x15, 0xd3, 0xfc,
    0xd7, 0x98, 0xe2, 0xba, 0xab, 0x0b, 0x5b, 0x8c, 0xde, 0xce, 0x89, 0x95, 0xf5, 0x23, 0xe6, 0xe2,
    0x81, 0x0a, 0x68, 0x5f, 0x11, 0x49, 0x30, 0x15, 0x66, 0x85, 0x35, 0x02, 0xcb, 0x70, 0x93, 0xd4,
    0x8a, 0xfe, 0x0e, 0x89, 0x43, 0xf4, 0x71, 0xa6, 0x95, 0xb4, 0xc1, 0xe4, 0x2a, 0x75, 0xe4, 0x19,
    0x23, 0xce, 0x71, 0x45, 0x95, 0xc8, 0xa4, 0xac, 0xc3, 0x1e, 0x12, 0xbe, 0x65, 0x2d, 0xc4, 0x3a,
    0x2e, 0x0f, 0xa7, 0xc4, 0xbc, 0x21, 0xa8, 0x9f, 0xb1, 0xb6, 0x46, 0x42, 0xa3, 0x26, 0x1f, 0x3f,
    0xd9, 0x9c, 0x47, 0xb6, 0x46, 0x04, 0x62, 0xa3, 0x54, 0xf4, 0x0d, 0xb8, 0x99, 0xf0, 0x2a, 0xab,
    0x3f, 0xc3, 0x44, 0x96, 0xc0, 0x04, 0xc7, 0x56, 0x3f, 0x61, 0x2d, 0x4e, 0xc2, 0xcb, 0xb4, 0x38,
    0xd2, 0xea, 0x27, 0x8b, 0x5f, 0x95, 0x54, 0xc6, 0xb2, 0x62, 0x8c, 0xb8, 0xdd, 0x6d, 0xd8, 0xba,
    0xe3, 0x0f, 0x54, 0x1b, 0x18, 0x7f, 0x36, 0xf1, 0xbe, 0xc3, 0x71, 0x3e, 0x53, 0x6a, 0x86, 0x1a,
    0xc0, 0xcb, 0x3a, 0xf1, 0xcf, 0x80, 0x5b, 0x69, 0xb5, 0x60, 0x4d, 0xd7, 0x98, 0xfa, 0xba, 0x95,
    0x31, 0x7f, 0x92, 0x9b, 0xf3, 0xbd, 0x13, 0xfe, 0xec, 0x31, 0xff, 0x86, 0x08, 0x2e, 0xc3, 0x0d,
    0x7e, 0x41, 0xbf, 0x68, 0x81, 0x73, 0x5f, 0x7a, 0xf2, 0x64, 0x84, 0x24, 0x77, 0x74, 0x10, 0x2e,
    0x6d, 0x1f, 0xb5, 0xe6, 0x81, 0x0c, 0x87, 0x6c, 0x04, 0x84, 0x75, 0x1c, 0x82, 0x52, 0x9b, 0x2b,
    0xcd, 0x90, 0xe4, 0xf6, 0x87, 0xf6, 0x3d, 0x26, 0xa7, 0xae, 0x39, 0xbb, 0x6e, 0x9e, 0x0c, 0x0e,
    0xc4, 0xdc, 0xae, 0x58, 0x88, 0x8d, 0x5d, 0xa0, 0x00, 0x1b, 0x25, 0x79, 0x46, 0xb4, 0x0a, 0xb5,
    0xc0, 0xbf, 0xc1, 0x57, 0xb8, 0xe7, 0x41, 0xcb, 0xc3, 0x93, 0xfe, 0xef, 0x4e, 0xae, 0x96, 0x68,
    0xa3, 0xbf, 0x13, 0xef, 0xfd, 0xe2, 0x87, 0xdb, 0x45, 0x54, 0x17, 0x72, 0x71, 0xe9, 0x0e, 0x54,
    0x8b, 0x4b, 0xd4, 0xd2, 0x39, 0xaf, 0x92, 0xfc, 0x45, 0xb4, 0x98, 0x56, 0xd3, 0xfd, 0xfb, 0x7a,
    0x12, 0xe0, 0xcb, 0x2a, 0xbe, 0x9a, 0x09, 0x0e, 0x5f, 0x98, 0x8e, 0xf0, 0x95, 0x1d, 0xed, 0xb8,
    0x8b, 0x33, 0xe3, 0xcc, 0xbe, 0xf3, 0x93, 0xc7, 0xcf, 0x8a, 0x3d, 0x44, 0xcd, 0xb7, 0x01, 0xa4,
    0xfe, 0x92, 0x5c, 0x3d, 0xbf, 0x9f, 0x43, 0xfe, 0x70, 0xd6, 0x63, 0x64, 0x63, 0x0a, 0x6b, 0xda,
    0x1e, 0xba, 0xd3, 0x09, 0xe0, 0x6a, 0xf4, 0x86, 0x21, 0x86, 0x43, 0xe2, 0xe9, 0xac, 0x73, 0x8b,
    0xfd, 0xaf, 0x34, 0xb7, 0x6c, 0x17, 0x3c, 0x3c, 0xc4, 0xa8, 0x0b, 0x54, 0x1c, 0x37, 0x57, 0x12,
    0x1c, 0x5d, 0x0d, 0x03, 0xfd, 0xd5, 0x17, 0x09, 0x94, 0x1d, 0x71, 0x1b, 0xee, 0xb6, 0x00, 0xc4,
    0x77, 0x09, 0x2d, 0x0f, 0x4a, 0x93, 0xab, 0x3f, 0xad, 0x55, 0xad, 0xba
};
#endif

PyTypeObject *init_KTimeComboBox(PyObject *module)
{
    if (SbkKWidgetsAddonsTypeStructs[SBK_KTimeComboBox_IDX].type != nullptr)
        return SbkKWidgetsAddonsTypeStructs[SBK_KTimeComboBox_IDX].type;

    Shiboken::AutoDecRef Sbk_KTimeComboBox_Type_bases(PyTuple_Pack(1,
        reinterpret_cast<PyObject *>(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QComboBox_IDX]))));

    _Sbk_KTimeComboBox_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "KTimeComboBox",
        "KTimeComboBox*",
        &Sbk_KTimeComboBox_spec,
        &Shiboken::callCppDestructor< KTimeComboBox >,
        Sbk_KTimeComboBox_Type_bases.object(),
        Shiboken::ObjectType::WrapperFlags::DeleteInMainThread);
    auto *pyType = _Sbk_KTimeComboBox_Type; // references _Sbk_KTimeComboBox_Type
#if PYSIDE6_COMOPT_COMPRESS == 0
    InitSignatureStrings(pyType, KTimeComboBox_SignatureStrings);
#else
    InitSignatureBytes(pyType, KTimeComboBox_SignatureBytes, KTimeComboBox_SignatureByteSize);
#endif
    SbkObjectType_SetPropertyStrings(pyType, Sbk_KTimeComboBox_PropertyStrings);
    SbkKWidgetsAddonsTypeStructs[SBK_KTimeComboBox_IDX].type = pyType;

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(pyType,
        KTimeComboBox_PythonToCpp_KTimeComboBox_PTR,
        is_KTimeComboBox_PythonToCpp_KTimeComboBox_PTR_Convertible,
        KTimeComboBox_PTR_CppToPython_KTimeComboBox);

    Shiboken::Conversions::registerConverterName(converter, "KTimeComboBox");
    Shiboken::Conversions::registerConverterName(converter, "KTimeComboBox*");
    Shiboken::Conversions::registerConverterName(converter, "KTimeComboBox&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::KTimeComboBox).name());
    Shiboken::Conversions::registerConverterName(converter, typeid(KTimeComboBoxWrapper).name());

    MultipleInheritanceInitFunction func = Shiboken::ObjectType::getMultipleInheritanceFunction(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX]));
    Shiboken::ObjectType::setMultipleInheritanceFunction(Sbk_KTimeComboBox_TypeF(), func);
    Shiboken::ObjectType::setCastFunction(Sbk_KTimeComboBox_TypeF(), &Sbk_KTimeComboBoxSpecialCastFunction);
    Shiboken::ObjectType::setTypeDiscoveryFunctionV2(
        Sbk_KTimeComboBox_TypeF(), &Sbk_KTimeComboBox_typeDiscovery);

    // Pass the ..._EnumFlagInfo to the class.
    SbkObjectType_SetEnumFlagInfo(pyType, Sbk_KTimeComboBox_EnumFlagInfo);

    // Initialization of enums.
    Shiboken::AutoDecRef tpDict{};
    PyTypeObject *EType{};

    // Initialization of enum 'Option'.
    const char *Option_Initializer[] = {
        "EditTime",
        "SelectTime",
        "ForceTime",
        "WarnOnInvalid",
        nullptr};
    // "uint8_t" used instead of "unsigned int"
    constexpr uint8_t Option_InitializerValues[] = {
        uint8_t(KTimeComboBox::Option::EditTime),     //  0x01  1
        uint8_t(KTimeComboBox::Option::SelectTime),   //  0x02  2
        uint8_t(KTimeComboBox::Option::ForceTime),    //  0x04  4
        uint8_t(KTimeComboBox::Option::WarnOnInvalid) //  0x08  8
        };
    EType = Shiboken::Enum::createPythonEnum(Sbk_KTimeComboBox_TypeF(),
        "1:KWidgetsAddons.KTimeComboBox.Option",
        Option_Initializer, Option_InitializerValues);
    SbkKWidgetsAddonsTypeStructs[SBK_KTimeComboBox_Option_IDX].type = EType;
    // PYSIDE-1735: Mapping the flags class to the same enum class.
    SbkKWidgetsAddonsTypeStructs[SBK_QFlags_KTimeComboBox_Option_IDX].type =
        EType;
    // Register converter for enum 'KTimeComboBox::Option'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(EType,
            KTimeComboBox_Option_CppToPython_Enum);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            Enum_PythonToCpp_KTimeComboBox_Option,
            is_Enum_PythonToCpp_KTimeComboBox_Option_Convertible);
        Shiboken::Conversions::registerConverterName(converter, "KTimeComboBox::Option");
        Shiboken::Conversions::registerConverterAlias(converter, "Option");
        SbkConverter *flagsConverter = Shiboken::Conversions::createConverter(EType,
            KTimeComboBox_Option_CppToPython_Flag);
        Shiboken::Conversions::addPythonToCppValueConversion(flagsConverter,
            Flag_PythonToCpp_KTimeComboBox_Option,
            is_Enum_PythonToCpp_KTimeComboBox_Option_Convertible);
        // Register converter for flag 'QFlags<KTimeComboBox::Option>'.
        Shiboken::Conversions::registerConverterName(flagsConverter, "QFlags<KTimeComboBox::Option>");
        Shiboken::Conversions::registerConverterName(flagsConverter, "KTimeComboBox::Options");
        Shiboken::Enum::setTypeConverter(EType, converter, flagsConverter);
    }
    // End of 'Option' enum/flags.

    PySide::Signal::registerSignals(pyType, &::KTimeComboBox::staticMetaObject);
    qRegisterMetaType< ::KTimeComboBox::Option >("KTimeComboBox::Option");
    Shiboken::ObjectType::setSubTypeInitHook(pyType, &PySide::initQObjectSubType);
    PySide::initDynamicMetaObject(pyType, &::KTimeComboBox::staticMetaObject, sizeof(KTimeComboBoxWrapper));

    return pyType;
}
