/* BreakController.c generated by valac 0.56.17, the Vala compiler
 * generated from BreakController.vala, do not modify */

/* BreakController.vala
 *
 * Copyright 2020 Dylan McCall <dylan@dylanmccall.ca>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * SPDX-License-Identifier: GPL-3.0-or-later
 */

#include "daemon.h"
#include <glib-object.h>
#include <json-glib/json-glib.h>
#include <glib.h>
#include "common.h"

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	BREAK_TIMER_DAEMON_BREAK_BREAK_CONTROLLER_0_PROPERTY,
	BREAK_TIMER_DAEMON_BREAK_BREAK_CONTROLLER_STATE_PROPERTY,
	BREAK_TIMER_DAEMON_BREAK_BREAK_CONTROLLER_NUM_PROPERTIES
};
static GParamSpec* break_timer_daemon_break_break_controller_properties[BREAK_TIMER_DAEMON_BREAK_BREAK_CONTROLLER_NUM_PROPERTIES];
#define __vala_GValue_free0(var) ((var == NULL) ? NULL : (var = (_vala_GValue_free (var), NULL)))
enum  {
	BREAK_TIMER_DAEMON_BREAK_BREAK_CONTROLLER_ENABLED_SIGNAL,
	BREAK_TIMER_DAEMON_BREAK_BREAK_CONTROLLER_DISABLED_SIGNAL,
	BREAK_TIMER_DAEMON_BREAK_BREAK_CONTROLLER_WARNED_SIGNAL,
	BREAK_TIMER_DAEMON_BREAK_BREAK_CONTROLLER_UNWARNED_SIGNAL,
	BREAK_TIMER_DAEMON_BREAK_BREAK_CONTROLLER_ACTIVATED_SIGNAL,
	BREAK_TIMER_DAEMON_BREAK_BREAK_CONTROLLER_FINISHED_SIGNAL,
	BREAK_TIMER_DAEMON_BREAK_BREAK_CONTROLLER_ACTIVE_CHANGED_SIGNAL,
	BREAK_TIMER_DAEMON_BREAK_BREAK_CONTROLLER_NUM_SIGNALS
};
static guint break_timer_daemon_break_break_controller_signals[BREAK_TIMER_DAEMON_BREAK_BREAK_CONTROLLER_NUM_SIGNALS] = {0};

struct _BreakTimerDaemonBreakBreakControllerPrivate {
	BreakTimerDaemonBreakBreakControllerState _state;
	GValue* activate_timestamp;
};

static gint BreakTimerDaemonBreakBreakController_private_offset;
static gpointer break_timer_daemon_break_break_controller_parent_class = NULL;

static void _vala_GValue_free (GValue* self);
static void break_timer_daemon_break_break_controller_set_state (BreakTimerDaemonBreakBreakController* self,
                                                          BreakTimerDaemonBreakBreakControllerState value);
static JsonObject* break_timer_daemon_break_break_controller_real_serialize (BreakTimerDaemonBreakBreakController* self);
static void break_timer_daemon_break_break_controller_real_deserialize (BreakTimerDaemonBreakBreakController* self,
                                                                 JsonObject** json_root);
static void g_cclosure_user_marshal_VOID__ENUM_BOOLEAN (GClosure * closure,
                                                 GValue * return_value,
                                                 guint n_param_values,
                                                 const GValue * param_values,
                                                 gpointer invocation_hint,
                                                 gpointer marshal_data);
static void break_timer_daemon_break_break_controller_finalize (GObject * obj);
static GType break_timer_daemon_break_break_controller_get_type_once (void);
static void _vala_break_timer_daemon_break_break_controller_get_property (GObject * object,
                                                                   guint property_id,
                                                                   GValue * value,
                                                                   GParamSpec * pspec);
static void _vala_break_timer_daemon_break_break_controller_set_property (GObject * object,
                                                                   guint property_id,
                                                                   const GValue * value,
                                                                   GParamSpec * pspec);

static inline gpointer
break_timer_daemon_break_break_controller_get_instance_private (BreakTimerDaemonBreakBreakController* self)
{
	return G_STRUCT_MEMBER_P (self, BreakTimerDaemonBreakBreakController_private_offset);
}

/**
     * ''WAITING'':  The break has not started yet. For example, it may be
     *               monitoring user activity in the background, waiting
     *               until the user has been working for a particular
     *               time.
     * ''ACTIVE'':   The break has started. For example, when a break
     *               becomes active, it might show a "Take a break"
     *               screen. Once the break has been satisfied, it should
     *               return to the WAITING state.
     * ''DISABLED'': The break is not in use, and should not be monitoring
     *               activity. This state is usually set explicitly by
     *               BreakManager.
    */
static GType
break_timer_daemon_break_break_controller_state_get_type_once (void)
{
	static const GEnumValue values[] = {{BREAK_TIMER_DAEMON_BREAK_BREAK_CONTROLLER_STATE_WAITING, "BREAK_TIMER_DAEMON_BREAK_BREAK_CONTROLLER_STATE_WAITING", "waiting"}, {BREAK_TIMER_DAEMON_BREAK_BREAK_CONTROLLER_STATE_ACTIVE, "BREAK_TIMER_DAEMON_BREAK_BREAK_CONTROLLER_STATE_ACTIVE", "active"}, {BREAK_TIMER_DAEMON_BREAK_BREAK_CONTROLLER_STATE_DISABLED, "BREAK_TIMER_DAEMON_BREAK_BREAK_CONTROLLER_STATE_DISABLED", "disabled"}, {0, NULL, NULL}};
	GType break_timer_daemon_break_break_controller_state_type_id;
	break_timer_daemon_break_break_controller_state_type_id = g_enum_register_static ("BreakTimerDaemonBreakBreakControllerState", values);
	return break_timer_daemon_break_break_controller_state_type_id;
}

GType
break_timer_daemon_break_break_controller_state_get_type (void)
{
	static volatile gsize break_timer_daemon_break_break_controller_state_type_id__once = 0;
	if (g_once_init_enter (&break_timer_daemon_break_break_controller_state_type_id__once)) {
		GType break_timer_daemon_break_break_controller_state_type_id;
		break_timer_daemon_break_break_controller_state_type_id = break_timer_daemon_break_break_controller_state_get_type_once ();
		g_once_init_leave (&break_timer_daemon_break_break_controller_state_type_id__once, break_timer_daemon_break_break_controller_state_type_id);
	}
	return break_timer_daemon_break_break_controller_state_type_id__once;
}

static GType
break_timer_daemon_break_break_controller_finished_reason_get_type_once (void)
{
	static const GEnumValue values[] = {{BREAK_TIMER_DAEMON_BREAK_BREAK_CONTROLLER_FINISHED_REASON_DISABLED, "BREAK_TIMER_DAEMON_BREAK_BREAK_CONTROLLER_FINISHED_REASON_DISABLED", "disabled"}, {BREAK_TIMER_DAEMON_BREAK_BREAK_CONTROLLER_FINISHED_REASON_SKIPPED, "BREAK_TIMER_DAEMON_BREAK_BREAK_CONTROLLER_FINISHED_REASON_SKIPPED", "skipped"}, {BREAK_TIMER_DAEMON_BREAK_BREAK_CONTROLLER_FINISHED_REASON_SATISFIED, "BREAK_TIMER_DAEMON_BREAK_BREAK_CONTROLLER_FINISHED_REASON_SATISFIED", "satisfied"}, {0, NULL, NULL}};
	GType break_timer_daemon_break_break_controller_finished_reason_type_id;
	break_timer_daemon_break_break_controller_finished_reason_type_id = g_enum_register_static ("BreakTimerDaemonBreakBreakControllerFinishedReason", values);
	return break_timer_daemon_break_break_controller_finished_reason_type_id;
}

GType
break_timer_daemon_break_break_controller_finished_reason_get_type (void)
{
	static volatile gsize break_timer_daemon_break_break_controller_finished_reason_type_id__once = 0;
	if (g_once_init_enter (&break_timer_daemon_break_break_controller_finished_reason_type_id__once)) {
		GType break_timer_daemon_break_break_controller_finished_reason_type_id;
		break_timer_daemon_break_break_controller_finished_reason_type_id = break_timer_daemon_break_break_controller_finished_reason_get_type_once ();
		g_once_init_leave (&break_timer_daemon_break_break_controller_finished_reason_type_id__once, break_timer_daemon_break_break_controller_finished_reason_type_id);
	}
	return break_timer_daemon_break_break_controller_finished_reason_type_id__once;
}

static void
_vala_GValue_free (GValue* self)
{
	g_boxed_free (G_TYPE_VALUE, self);
}

BreakTimerDaemonBreakBreakController*
break_timer_daemon_break_break_controller_construct (GType object_type)
{
	BreakTimerDaemonBreakBreakController * self = NULL;
	self = (BreakTimerDaemonBreakBreakController*) g_object_new (object_type, NULL);
	break_timer_daemon_break_break_controller_set_state (self, BREAK_TIMER_DAEMON_BREAK_BREAK_CONTROLLER_STATE_DISABLED);
	__vala_GValue_free0 (self->priv->activate_timestamp);
	self->priv->activate_timestamp = NULL;
	return self;
}

static JsonObject*
break_timer_daemon_break_break_controller_real_serialize (BreakTimerDaemonBreakBreakController* self)
{
	JsonObject* json_root = NULL;
	JsonObject* _tmp0_;
	JsonObject* _tmp1_;
	BreakTimerDaemonBreakBreakControllerState _tmp2_;
	GValue* _tmp3_;
	JsonObject* result;
	_tmp0_ = json_object_new ();
	json_root = _tmp0_;
	_tmp1_ = json_root;
	_tmp2_ = self->priv->_state;
	json_object_set_int_member (_tmp1_, "state", (gint64) ((gint) _tmp2_));
	_tmp3_ = self->priv->activate_timestamp;
	if (((gpointer) _tmp3_) == NULL) {
		JsonObject* _tmp4_;
		_tmp4_ = json_root;
		json_object_set_null_member (_tmp4_, "activate_timestamp");
	} else {
		JsonObject* _tmp5_;
		GValue* _tmp6_;
		_tmp5_ = json_root;
		_tmp6_ = self->priv->activate_timestamp;
		json_object_set_int_member (_tmp5_, "activate_timestamp", g_value_get_int64 (_tmp6_));
	}
	result = json_root;
	return result;
}

JsonObject*
break_timer_daemon_break_break_controller_serialize (BreakTimerDaemonBreakBreakController* self)
{
	BreakTimerDaemonBreakBreakControllerClass* _klass_;
	g_return_val_if_fail (self != NULL, NULL);
	_klass_ = BREAK_TIMER_DAEMON_BREAK_BREAK_CONTROLLER_GET_CLASS (self);
	if (_klass_->serialize) {
		return _klass_->serialize (self);
	}
	return NULL;
}

static void
break_timer_daemon_break_break_controller_real_deserialize (BreakTimerDaemonBreakBreakController* self,
                                                            JsonObject** json_root)
{
	g_return_if_fail (*json_root != NULL);
	if (json_object_get_null_member (*json_root, "activate_timestamp")) {
		__vala_GValue_free0 (self->priv->activate_timestamp);
		self->priv->activate_timestamp = NULL;
	} else {
		GValue* _tmp0_ = NULL;
		_tmp0_ = g_new0 (GValue, 1);
		g_value_init (_tmp0_, G_TYPE_INT64);
		g_value_set_int64 (_tmp0_, json_object_get_int_member (*json_root, "activate_timestamp"));
		__vala_GValue_free0 (self->priv->activate_timestamp);
		self->priv->activate_timestamp = _tmp0_;
	}
}

void
break_timer_daemon_break_break_controller_deserialize (BreakTimerDaemonBreakBreakController* self,
                                                       JsonObject** json_root)
{
	BreakTimerDaemonBreakBreakControllerClass* _klass_;
	g_return_if_fail (self != NULL);
	_klass_ = BREAK_TIMER_DAEMON_BREAK_BREAK_CONTROLLER_GET_CLASS (self);
	if (_klass_->deserialize) {
		_klass_->deserialize (self, json_root);
	}
}

/**
     * Set whether the break is enabled or disabled. If it is enabled,
     * it will periodically update in the background, and if it is
     * disabled it will do nothing (and consume fewer resources).
     * This will also emit the enabled () or disabled () signal.
     * @param enable True to enable the break, false to disable it
     */
void
break_timer_daemon_break_break_controller_set_enabled (BreakTimerDaemonBreakBreakController* self,
                                                       gboolean enable)
{
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (self != NULL);
	if (enable) {
		_tmp0_ = !break_timer_daemon_break_break_controller_is_enabled (self);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		break_timer_daemon_break_break_controller_set_state (self, BREAK_TIMER_DAEMON_BREAK_BREAK_CONTROLLER_STATE_WAITING);
		g_signal_emit (self, break_timer_daemon_break_break_controller_signals[BREAK_TIMER_DAEMON_BREAK_BREAK_CONTROLLER_ENABLED_SIGNAL], 0);
	} else {
		gboolean _tmp1_ = FALSE;
		if (!enable) {
			_tmp1_ = break_timer_daemon_break_break_controller_is_enabled (self);
		} else {
			_tmp1_ = FALSE;
		}
		if (_tmp1_) {
			gboolean was_active = FALSE;
			BreakTimerDaemonBreakBreakControllerState _tmp2_;
			_tmp2_ = self->priv->_state;
			was_active = _tmp2_ == BREAK_TIMER_DAEMON_BREAK_BREAK_CONTROLLER_STATE_ACTIVE;
			break_timer_daemon_break_break_controller_set_state (self, BREAK_TIMER_DAEMON_BREAK_BREAK_CONTROLLER_STATE_DISABLED);
			g_signal_emit (self, break_timer_daemon_break_break_controller_signals[BREAK_TIMER_DAEMON_BREAK_BREAK_CONTROLLER_FINISHED_SIGNAL], 0, BREAK_TIMER_DAEMON_BREAK_BREAK_CONTROLLER_FINISHED_REASON_DISABLED, was_active);
			g_signal_emit (self, break_timer_daemon_break_break_controller_signals[BREAK_TIMER_DAEMON_BREAK_BREAK_CONTROLLER_DISABLED_SIGNAL], 0);
		}
	}
}

/**
     * @return True if the break is enabled and waiting to start automatically
     */
gboolean
break_timer_daemon_break_break_controller_is_enabled (BreakTimerDaemonBreakBreakController* self)
{
	BreakTimerDaemonBreakBreakControllerState _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_state;
	result = _tmp0_ != BREAK_TIMER_DAEMON_BREAK_BREAK_CONTROLLER_STATE_DISABLED;
	return result;
}

/**
     * @return True if the break has been activated, is in focus, and expects to be satisfied
     */
gboolean
break_timer_daemon_break_break_controller_is_active (BreakTimerDaemonBreakBreakController* self)
{
	BreakTimerDaemonBreakBreakControllerState _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_state;
	result = _tmp0_ == BREAK_TIMER_DAEMON_BREAK_BREAK_CONTROLLER_STATE_ACTIVE;
	return result;
}

/**
     * @return The real time, in seconds, since the break was activated.
     */
gint
break_timer_daemon_break_break_controller_get_seconds_since_start (BreakTimerDaemonBreakBreakController* self)
{
	GValue* _tmp0_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->activate_timestamp;
	if (((gpointer) _tmp0_) != NULL) {
		GValue* _tmp1_;
		_tmp1_ = self->priv->activate_timestamp;
		result = (gint) (break_timer_common_time_unit_get_real_time_seconds () - g_value_get_int64 (_tmp1_));
		return result;
	} else {
		result = 0;
		return result;
	}
}

/**
     * Start a break. This is usually triggered automatically by the break
     * controller itself, but it may be triggered externally as well.
     */
void
break_timer_daemon_break_break_controller_activate (BreakTimerDaemonBreakBreakController* self)
{
	BreakTimerDaemonBreakBreakControllerState _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_state;
	if (_tmp0_ < BREAK_TIMER_DAEMON_BREAK_BREAK_CONTROLLER_STATE_ACTIVE) {
		GValue* _tmp1_;
		_tmp1_ = self->priv->activate_timestamp;
		if (((gpointer) _tmp1_) == NULL) {
			GValue* _tmp2_ = NULL;
			_tmp2_ = g_new0 (GValue, 1);
			g_value_init (_tmp2_, G_TYPE_INT64);
			g_value_set_int64 (_tmp2_, (gint64) break_timer_common_time_unit_get_real_time_seconds ());
			__vala_GValue_free0 (self->priv->activate_timestamp);
			self->priv->activate_timestamp = _tmp2_;
		}
		break_timer_daemon_break_break_controller_set_state (self, BREAK_TIMER_DAEMON_BREAK_BREAK_CONTROLLER_STATE_ACTIVE);
		g_signal_emit (self, break_timer_daemon_break_break_controller_signals[BREAK_TIMER_DAEMON_BREAK_BREAK_CONTROLLER_ACTIVATED_SIGNAL], 0);
	}
}

/**
     * The break's requirements have been satisfied. Start counting from
     * the beginning again.
     */
void
break_timer_daemon_break_break_controller_finish (BreakTimerDaemonBreakBreakController* self)
{
	gboolean was_active = FALSE;
	g_return_if_fail (self != NULL);
	was_active = break_timer_daemon_break_break_controller_is_active (self);
	break_timer_daemon_break_break_controller_set_state (self, BREAK_TIMER_DAEMON_BREAK_BREAK_CONTROLLER_STATE_WAITING);
	__vala_GValue_free0 (self->priv->activate_timestamp);
	self->priv->activate_timestamp = NULL;
	g_signal_emit (self, break_timer_daemon_break_break_controller_signals[BREAK_TIMER_DAEMON_BREAK_BREAK_CONTROLLER_FINISHED_SIGNAL], 0, BREAK_TIMER_DAEMON_BREAK_BREAK_CONTROLLER_FINISHED_REASON_SATISFIED, was_active);
}

/**
     * We're skipping this break. The BreakController should act as if the
     * break has finished as usual, but we will send a different
     * FinishedReason to the "finished" signal. This way, its BreakView will
     * know to present this differently than if the break has actually been
     * satisfied.
     * @param forget_start true to reset the value returned by get_seconds_since_start
     */
void
break_timer_daemon_break_break_controller_skip (BreakTimerDaemonBreakBreakController* self,
                                                gboolean forget_start)
{
	BreakTimerDaemonBreakBreakControllerState _tmp0_;
	gboolean was_active = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_state;
	if (_tmp0_ == BREAK_TIMER_DAEMON_BREAK_BREAK_CONTROLLER_STATE_DISABLED) {
		return;
	}
	was_active = break_timer_daemon_break_break_controller_is_active (self);
	break_timer_daemon_break_break_controller_set_state (self, BREAK_TIMER_DAEMON_BREAK_BREAK_CONTROLLER_STATE_WAITING);
	if (forget_start) {
		__vala_GValue_free0 (self->priv->activate_timestamp);
		self->priv->activate_timestamp = NULL;
	}
	g_signal_emit (self, break_timer_daemon_break_break_controller_signals[BREAK_TIMER_DAEMON_BREAK_BREAK_CONTROLLER_FINISHED_SIGNAL], 0, BREAK_TIMER_DAEMON_BREAK_BREAK_CONTROLLER_FINISHED_REASON_SKIPPED, was_active);
}

BreakTimerDaemonBreakBreakControllerState
break_timer_daemon_break_break_controller_get_state (BreakTimerDaemonBreakBreakController* self)
{
	BreakTimerDaemonBreakBreakControllerState result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_state;
	return result;
}

static void
break_timer_daemon_break_break_controller_set_state (BreakTimerDaemonBreakBreakController* self,
                                                     BreakTimerDaemonBreakBreakControllerState value)
{
	BreakTimerDaemonBreakBreakControllerState old_value;
	g_return_if_fail (self != NULL);
	old_value = break_timer_daemon_break_break_controller_get_state (self);
	if (old_value != value) {
		self->priv->_state = value;
		g_object_notify_by_pspec ((GObject *) self, break_timer_daemon_break_break_controller_properties[BREAK_TIMER_DAEMON_BREAK_BREAK_CONTROLLER_STATE_PROPERTY]);
	}
}

static void
g_cclosure_user_marshal_VOID__ENUM_BOOLEAN (GClosure * closure,
                                            GValue * return_value,
                                            guint n_param_values,
                                            const GValue * param_values,
                                            gpointer invocation_hint,
                                            gpointer marshal_data)
{
	typedef void (*GMarshalFunc_VOID__ENUM_BOOLEAN) (gpointer data1, gint arg_1, gboolean arg_2, gpointer data2);
	register GMarshalFunc_VOID__ENUM_BOOLEAN callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 3);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__ENUM_BOOLEAN) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_enum (param_values + 1), g_value_get_boolean (param_values + 2), data2);
}

static void
break_timer_daemon_break_break_controller_class_init (BreakTimerDaemonBreakBreakControllerClass * klass,
                                                      gpointer klass_data)
{
	break_timer_daemon_break_break_controller_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &BreakTimerDaemonBreakBreakController_private_offset);
	((BreakTimerDaemonBreakBreakControllerClass *) klass)->serialize = (JsonObject* (*) (BreakTimerDaemonBreakBreakController*)) break_timer_daemon_break_break_controller_real_serialize;
	((BreakTimerDaemonBreakBreakControllerClass *) klass)->deserialize = (void (*) (BreakTimerDaemonBreakBreakController*, JsonObject**)) break_timer_daemon_break_break_controller_real_deserialize;
	G_OBJECT_CLASS (klass)->get_property = _vala_break_timer_daemon_break_break_controller_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_break_timer_daemon_break_break_controller_set_property;
	G_OBJECT_CLASS (klass)->finalize = break_timer_daemon_break_break_controller_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), BREAK_TIMER_DAEMON_BREAK_BREAK_CONTROLLER_STATE_PROPERTY, break_timer_daemon_break_break_controller_properties[BREAK_TIMER_DAEMON_BREAK_BREAK_CONTROLLER_STATE_PROPERTY] = g_param_spec_enum ("state", "state", "state", BREAK_TIMER_DAEMON_BREAK_BREAK_CONTROLLER_TYPE_STATE, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/** The break has been enabled. It will monitor user activity and emit activated () or finished () signals until it is disabled. */
	break_timer_daemon_break_break_controller_signals[BREAK_TIMER_DAEMON_BREAK_BREAK_CONTROLLER_ENABLED_SIGNAL] = g_signal_new ("enabled", BREAK_TIMER_DAEMON_BREAK_TYPE_BREAK_CONTROLLER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	/** The break has been disabled. Its timers have been stopped and it will not do anything until it is enabled again. */
	break_timer_daemon_break_break_controller_signals[BREAK_TIMER_DAEMON_BREAK_BREAK_CONTROLLER_DISABLED_SIGNAL] = g_signal_new ("disabled", BREAK_TIMER_DAEMON_BREAK_TYPE_BREAK_CONTROLLER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	/** The break is going to happen soon */
	break_timer_daemon_break_break_controller_signals[BREAK_TIMER_DAEMON_BREAK_BREAK_CONTROLLER_WARNED_SIGNAL] = g_signal_new ("warned", BREAK_TIMER_DAEMON_BREAK_TYPE_BREAK_CONTROLLER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	/** The break is no longer going to start soon */
	break_timer_daemon_break_break_controller_signals[BREAK_TIMER_DAEMON_BREAK_BREAK_CONTROLLER_UNWARNED_SIGNAL] = g_signal_new ("unwarned", BREAK_TIMER_DAEMON_BREAK_TYPE_BREAK_CONTROLLER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	/** The break has been activated and is now counting down aggressively until it is satisfied. */
	break_timer_daemon_break_break_controller_signals[BREAK_TIMER_DAEMON_BREAK_BREAK_CONTROLLER_ACTIVATED_SIGNAL] = g_signal_new ("activated", BREAK_TIMER_DAEMON_BREAK_TYPE_BREAK_CONTROLLER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	/** The break has been satisfied. This can happen at any time, including while the break is waiting or after it has been activiated. */
	break_timer_daemon_break_break_controller_signals[BREAK_TIMER_DAEMON_BREAK_BREAK_CONTROLLER_FINISHED_SIGNAL] = g_signal_new ("finished", BREAK_TIMER_DAEMON_BREAK_TYPE_BREAK_CONTROLLER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__ENUM_BOOLEAN, G_TYPE_NONE, 2, BREAK_TIMER_DAEMON_BREAK_BREAK_CONTROLLER_TYPE_FINISHED_REASON, G_TYPE_BOOLEAN);
	/** The break is active and it has progressed in some fashion (for example, remaining time has changed). */
	break_timer_daemon_break_break_controller_signals[BREAK_TIMER_DAEMON_BREAK_BREAK_CONTROLLER_ACTIVE_CHANGED_SIGNAL] = g_signal_new ("active-changed", BREAK_TIMER_DAEMON_BREAK_TYPE_BREAK_CONTROLLER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}

static void
break_timer_daemon_break_break_controller_instance_init (BreakTimerDaemonBreakBreakController * self,
                                                         gpointer klass)
{
	self->priv = break_timer_daemon_break_break_controller_get_instance_private (self);
}

static void
break_timer_daemon_break_break_controller_finalize (GObject * obj)
{
	BreakTimerDaemonBreakBreakController * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BREAK_TIMER_DAEMON_BREAK_TYPE_BREAK_CONTROLLER, BreakTimerDaemonBreakBreakController);
	__vala_GValue_free0 (self->priv->activate_timestamp);
	G_OBJECT_CLASS (break_timer_daemon_break_break_controller_parent_class)->finalize (obj);
}

/**
 * Base class for a break's activity tracking functionality.
 * A break can be started or stopped, and once started it will be activated
 * and finished either manually or autonomously based on user activity, or
 * some related metric. The mechanism for activating a break and for
 * satisfying it is unique to each implementation.
 * This class provides mechanisms for tracking and directly setting the
 * break's state, which can be either WAITING, ACTIVE, or DISABLED.
 */
static GType
break_timer_daemon_break_break_controller_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (BreakTimerDaemonBreakBreakControllerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) break_timer_daemon_break_break_controller_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BreakTimerDaemonBreakBreakController), 0, (GInstanceInitFunc) break_timer_daemon_break_break_controller_instance_init, NULL };
	GType break_timer_daemon_break_break_controller_type_id;
	break_timer_daemon_break_break_controller_type_id = g_type_register_static (G_TYPE_OBJECT, "BreakTimerDaemonBreakBreakController", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
	BreakTimerDaemonBreakBreakController_private_offset = g_type_add_instance_private (break_timer_daemon_break_break_controller_type_id, sizeof (BreakTimerDaemonBreakBreakControllerPrivate));
	return break_timer_daemon_break_break_controller_type_id;
}

GType
break_timer_daemon_break_break_controller_get_type (void)
{
	static volatile gsize break_timer_daemon_break_break_controller_type_id__once = 0;
	if (g_once_init_enter (&break_timer_daemon_break_break_controller_type_id__once)) {
		GType break_timer_daemon_break_break_controller_type_id;
		break_timer_daemon_break_break_controller_type_id = break_timer_daemon_break_break_controller_get_type_once ();
		g_once_init_leave (&break_timer_daemon_break_break_controller_type_id__once, break_timer_daemon_break_break_controller_type_id);
	}
	return break_timer_daemon_break_break_controller_type_id__once;
}

static void
_vala_break_timer_daemon_break_break_controller_get_property (GObject * object,
                                                              guint property_id,
                                                              GValue * value,
                                                              GParamSpec * pspec)
{
	BreakTimerDaemonBreakBreakController * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, BREAK_TIMER_DAEMON_BREAK_TYPE_BREAK_CONTROLLER, BreakTimerDaemonBreakBreakController);
	switch (property_id) {
		case BREAK_TIMER_DAEMON_BREAK_BREAK_CONTROLLER_STATE_PROPERTY:
		g_value_set_enum (value, break_timer_daemon_break_break_controller_get_state (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_break_timer_daemon_break_break_controller_set_property (GObject * object,
                                                              guint property_id,
                                                              const GValue * value,
                                                              GParamSpec * pspec)
{
	BreakTimerDaemonBreakBreakController * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, BREAK_TIMER_DAEMON_BREAK_TYPE_BREAK_CONTROLLER, BreakTimerDaemonBreakBreakController);
	switch (property_id) {
		case BREAK_TIMER_DAEMON_BREAK_BREAK_CONTROLLER_STATE_PROPERTY:
		break_timer_daemon_break_break_controller_set_state (self, g_value_get_enum (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

