/* MutterActivityMonitorBackend.c generated by valac 0.56.17, the Vala compiler
 * generated from MutterActivityMonitorBackend.vala, do not modify */

/* MutterActivityMonitorBackend.vala
 *
 * Copyright 2020 Dylan McCall <dylan@dylanmccall.ca>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * SPDX-License-Identifier: GPL-3.0-or-later
 */

#include "daemon.h"
#include <gio/gio.h>
#include "common.h"
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <glib-object.h>

#define BREAK_TIMER_DAEMON_ACTIVITY_MUTTER_ACTIVITY_MONITOR_BACKEND_IDLE_WATCH_INTERVAL_MS ((guint) (1 * BREAK_TIMER_COMMON_TIME_UNIT_MILLISECONDS_IN_SECONDS))
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	BREAK_TIMER_DAEMON_ACTIVITY_MUTTER_ACTIVITY_MONITOR_BACKEND_0_PROPERTY,
	BREAK_TIMER_DAEMON_ACTIVITY_MUTTER_ACTIVITY_MONITOR_BACKEND_NUM_PROPERTIES
};
static GParamSpec* break_timer_daemon_activity_mutter_activity_monitor_backend_properties[BREAK_TIMER_DAEMON_ACTIVITY_MUTTER_ACTIVITY_MONITOR_BACKEND_NUM_PROPERTIES];
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

struct _BreakTimerDaemonActivityMutterActivityMonitorBackendPrivate {
	GDBusConnection* dbus_connection;
	BreakTimerCommonIMutterIdleMonitor* mutter_idle_monitor;
	guint32 idle_watch_id;
	guint32 user_active_watch_id;
	guint64 last_idle_time_ms;
	gint64 last_idle_time_update_time_ms;
	gboolean user_is_active;
	guint active_idle_poll_source_id;
};

static gint BreakTimerDaemonActivityMutterActivityMonitorBackend_private_offset;
static gpointer break_timer_daemon_activity_mutter_activity_monitor_backend_parent_class = NULL;
static GInitableIface * break_timer_daemon_activity_mutter_activity_monitor_backend_g_initable_parent_iface = NULL;

static gboolean break_timer_daemon_activity_mutter_activity_monitor_backend_real_init (GInitable* base,
                                                                                GCancellable* cancellable,
                                                                                GError** error);
static void break_timer_daemon_activity_mutter_activity_monitor_backend_mutter_idle_monitor_appeared (BreakTimerDaemonActivityMutterActivityMonitorBackend* self);
static void _break_timer_daemon_activity_mutter_activity_monitor_backend_mutter_idle_monitor_appeared_gbus_name_appeared_callback (GDBusConnection* connection,
                                                                                                                            const gchar* name,
                                                                                                                            const gchar* name_owner,
                                                                                                                            gpointer self);
static void break_timer_daemon_activity_mutter_activity_monitor_backend_mutter_idle_monitor_disappeared (BreakTimerDaemonActivityMutterActivityMonitorBackend* self);
static void _break_timer_daemon_activity_mutter_activity_monitor_backend_mutter_idle_monitor_disappeared_gbus_name_vanished_callback (GDBusConnection* connection,
                                                                                                                               const gchar* name,
                                                                                                                               gpointer self);
static void break_timer_daemon_activity_mutter_activity_monitor_backend_mutter_idle_monitor_watch_fired_cb (BreakTimerDaemonActivityMutterActivityMonitorBackend* self,
                                                                                                     guint32 id);
static void _break_timer_daemon_activity_mutter_activity_monitor_backend_mutter_idle_monitor_watch_fired_cb_break_timer_common_imutter_idle_monitor_watch_fired (BreakTimerCommonIMutterIdleMonitor* _sender,
                                                                                                                                                          guint32 id,
                                                                                                                                                          gpointer self);
static void break_timer_daemon_activity_mutter_activity_monitor_backend_set_user_is_active (BreakTimerDaemonActivityMutterActivityMonitorBackend* self,
                                                                                     gboolean active);
static void break_timer_daemon_activity_mutter_activity_monitor_backend_idle_watch_cb (BreakTimerDaemonActivityMutterActivityMonitorBackend* self);
static void break_timer_daemon_activity_mutter_activity_monitor_backend_user_active_watch_cb (BreakTimerDaemonActivityMutterActivityMonitorBackend* self);
static void break_timer_daemon_activity_mutter_activity_monitor_backend_start_active_idle_poll (BreakTimerDaemonActivityMutterActivityMonitorBackend* self);
static gboolean break_timer_daemon_activity_mutter_activity_monitor_backend_active_idle_poll_cb (BreakTimerDaemonActivityMutterActivityMonitorBackend* self);
static gboolean _break_timer_daemon_activity_mutter_activity_monitor_backend_active_idle_poll_cb_gsource_func (gpointer self);
static void break_timer_daemon_activity_mutter_activity_monitor_backend_stop_active_idle_poll (BreakTimerDaemonActivityMutterActivityMonitorBackend* self);
static void break_timer_daemon_activity_mutter_activity_monitor_backend_poll_activity (BreakTimerDaemonActivityMutterActivityMonitorBackend* self);
static guint64 break_timer_daemon_activity_mutter_activity_monitor_backend_real_time_since_last_event_ms (BreakTimerDaemonActivityActivityMonitorBackend* base);
static void break_timer_daemon_activity_mutter_activity_monitor_backend_finalize (GObject * obj);
static GType break_timer_daemon_activity_mutter_activity_monitor_backend_get_type_once (void);

static inline gpointer
break_timer_daemon_activity_mutter_activity_monitor_backend_get_instance_private (BreakTimerDaemonActivityMutterActivityMonitorBackend* self)
{
	return G_STRUCT_MEMBER_P (self, BreakTimerDaemonActivityMutterActivityMonitorBackend_private_offset);
}

BreakTimerDaemonActivityMutterActivityMonitorBackend*
break_timer_daemon_activity_mutter_activity_monitor_backend_construct (GType object_type)
{
	BreakTimerDaemonActivityMutterActivityMonitorBackend * self = NULL;
	self = (BreakTimerDaemonActivityMutterActivityMonitorBackend*) break_timer_daemon_activity_activity_monitor_backend_construct (object_type);
	self->priv->user_is_active = FALSE;
	self->priv->last_idle_time_update_time_ms = (gint64) 0;
	self->priv->active_idle_poll_source_id = (guint) 0;
	return self;
}

BreakTimerDaemonActivityMutterActivityMonitorBackend*
break_timer_daemon_activity_mutter_activity_monitor_backend_new (void)
{
	return break_timer_daemon_activity_mutter_activity_monitor_backend_construct (BREAK_TIMER_DAEMON_ACTIVITY_TYPE_MUTTER_ACTIVITY_MONITOR_BACKEND);
}

static void
_break_timer_daemon_activity_mutter_activity_monitor_backend_mutter_idle_monitor_appeared_gbus_name_appeared_callback (GDBusConnection* connection,
                                                                                                                       const gchar* name,
                                                                                                                       const gchar* name_owner,
                                                                                                                       gpointer self)
{
	break_timer_daemon_activity_mutter_activity_monitor_backend_mutter_idle_monitor_appeared ((BreakTimerDaemonActivityMutterActivityMonitorBackend*) self);
}

static void
_break_timer_daemon_activity_mutter_activity_monitor_backend_mutter_idle_monitor_disappeared_gbus_name_vanished_callback (GDBusConnection* connection,
                                                                                                                          const gchar* name,
                                                                                                                          gpointer self)
{
	break_timer_daemon_activity_mutter_activity_monitor_backend_mutter_idle_monitor_disappeared ((BreakTimerDaemonActivityMutterActivityMonitorBackend*) self);
}

static gboolean
break_timer_daemon_activity_mutter_activity_monitor_backend_real_init (GInitable* base,
                                                                       GCancellable* cancellable,
                                                                       GError** error)
{
	BreakTimerDaemonActivityMutterActivityMonitorBackend * self;
	GDBusConnection* _tmp0_ = NULL;
	GDBusConnection* _tmp1_;
	GDBusConnection* _tmp3_;
	GDBusConnection* _tmp4_;
	GError* _inner_error0_ = NULL;
	gboolean result;
	self = (BreakTimerDaemonActivityMutterActivityMonitorBackend*) base;
	_tmp1_ = g_bus_get_sync (G_BUS_TYPE_SESSION, cancellable, &_inner_error0_);
	_tmp0_ = _tmp1_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp2_ = FALSE;
		g_propagate_error (error, _inner_error0_);
		return _tmp2_;
	}
	_tmp3_ = _tmp0_;
	_tmp0_ = NULL;
	_g_object_unref0 (self->priv->dbus_connection);
	self->priv->dbus_connection = _tmp3_;
	_tmp4_ = self->priv->dbus_connection;
	g_bus_watch_name_on_connection_with_closures (_tmp4_, "org.gnome.Mutter.IdleMonitor", G_BUS_NAME_WATCHER_FLAGS_NONE, (GClosure*) ((_break_timer_daemon_activity_mutter_activity_monitor_backend_mutter_idle_monitor_appeared_gbus_name_appeared_callback == NULL) ? NULL : g_cclosure_new ((GCallback) _break_timer_daemon_activity_mutter_activity_monitor_backend_mutter_idle_monitor_appeared_gbus_name_appeared_callback, g_object_ref (self), (GClosureNotify) g_object_unref)), (GClosure*) ((_break_timer_daemon_activity_mutter_activity_monitor_backend_mutter_idle_monitor_disappeared_gbus_name_vanished_callback == NULL) ? NULL : g_cclosure_new ((GCallback) _break_timer_daemon_activity_mutter_activity_monitor_backend_mutter_idle_monitor_disappeared_gbus_name_vanished_callback, g_object_ref (self), (GClosureNotify) g_object_unref)));
	result = TRUE;
	_g_object_unref0 (_tmp0_);
	return result;
}

static void
_break_timer_daemon_activity_mutter_activity_monitor_backend_mutter_idle_monitor_watch_fired_cb_break_timer_common_imutter_idle_monitor_watch_fired (BreakTimerCommonIMutterIdleMonitor* _sender,
                                                                                                                                                     guint32 id,
                                                                                                                                                     gpointer self)
{
	break_timer_daemon_activity_mutter_activity_monitor_backend_mutter_idle_monitor_watch_fired_cb ((BreakTimerDaemonActivityMutterActivityMonitorBackend*) self, id);
}

static void
break_timer_daemon_activity_mutter_activity_monitor_backend_mutter_idle_monitor_appeared (BreakTimerDaemonActivityMutterActivityMonitorBackend* self)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	{
		BreakTimerCommonIMutterIdleMonitor* _tmp0_ = NULL;
		BreakTimerCommonIMutterIdleMonitor* _tmp1_;
		BreakTimerCommonIMutterIdleMonitor* _tmp2_;
		BreakTimerCommonIMutterIdleMonitor* _tmp3_;
		guint32 _tmp4_ = 0U;
		BreakTimerCommonIMutterIdleMonitor* _tmp5_;
		_tmp1_ = (BreakTimerCommonIMutterIdleMonitor*) g_initable_new (BREAK_TIMER_COMMON_TYPE_IMUTTER_IDLE_MONITOR_PROXY, NULL, &_inner_error0_, "g-flags", 0, "g-name", "org.gnome.Mutter.IdleMonitor", "g-bus-type", G_BUS_TYPE_SESSION, "g-object-path", "/org/gnome/Mutter/IdleMonitor/Core", "g-interface-name", "org.gnome.Mutter.IdleMonitor", NULL);
		_tmp0_ = (BreakTimerCommonIMutterIdleMonitor*) _tmp1_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_IO_ERROR) {
				goto __catch0_g_io_error;
			}
			if (_inner_error0_->domain == G_DBUS_ERROR) {
				goto __catch0_g_dbus_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
		_tmp2_ = _tmp0_;
		_tmp0_ = NULL;
		_g_object_unref0 (self->priv->mutter_idle_monitor);
		self->priv->mutter_idle_monitor = _tmp2_;
		_tmp3_ = self->priv->mutter_idle_monitor;
		g_signal_connect_object (_tmp3_, "watch-fired", (GCallback) _break_timer_daemon_activity_mutter_activity_monitor_backend_mutter_idle_monitor_watch_fired_cb_break_timer_common_imutter_idle_monitor_watch_fired, self, 0);
		_tmp5_ = self->priv->mutter_idle_monitor;
		_tmp4_ = break_timer_common_imutter_idle_monitor_add_idle_watch (_tmp5_, (guint64) BREAK_TIMER_DAEMON_ACTIVITY_MUTTER_ACTIVITY_MONITOR_BACKEND_IDLE_WATCH_INTERVAL_MS, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (_tmp0_);
			if (_inner_error0_->domain == G_IO_ERROR) {
				goto __catch0_g_io_error;
			}
			if (_inner_error0_->domain == G_DBUS_ERROR) {
				goto __catch0_g_dbus_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
		self->priv->idle_watch_id = _tmp4_;
		break_timer_daemon_activity_mutter_activity_monitor_backend_set_user_is_active (self, FALSE);
		_g_object_unref0 (_tmp0_);
	}
	goto __finally0;
	__catch0_g_io_error:
	{
		GError* _error_ = NULL;
		GError* _tmp6_;
		const gchar* _tmp7_;
		_error_ = _inner_error0_;
		_inner_error0_ = NULL;
		_g_object_unref0 (self->priv->mutter_idle_monitor);
		self->priv->mutter_idle_monitor = NULL;
		_tmp6_ = _error_;
		_tmp7_ = _tmp6_->message;
		g_warning ("MutterActivityMonitorBackend.vala:82: Error connecting to mutter idle " \
"monitor service: %s", _tmp7_);
		_g_error_free0 (_error_);
	}
	goto __finally0;
	__catch0_g_dbus_error:
	{
		GError* _error_ = NULL;
		GError* _tmp8_;
		const gchar* _tmp9_;
		_error_ = _inner_error0_;
		_inner_error0_ = NULL;
		_g_object_unref0 (self->priv->mutter_idle_monitor);
		self->priv->mutter_idle_monitor = NULL;
		_tmp8_ = _error_;
		_tmp9_ = _tmp8_->message;
		g_warning ("MutterActivityMonitorBackend.vala:85: Error adding mutter idle watch: " \
"%s", _tmp9_);
		_g_error_free0 (_error_);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
break_timer_daemon_activity_mutter_activity_monitor_backend_mutter_idle_monitor_disappeared (BreakTimerDaemonActivityMutterActivityMonitorBackend* self)
{
	g_return_if_fail (self != NULL);
	g_warning ("MutterActivityMonitorBackend.vala:90: Mutter idle monitor disappeared");
	_g_object_unref0 (self->priv->mutter_idle_monitor);
	self->priv->mutter_idle_monitor = NULL;
	self->priv->idle_watch_id = (guint32) 0;
}

static void
break_timer_daemon_activity_mutter_activity_monitor_backend_mutter_idle_monitor_watch_fired_cb (BreakTimerDaemonActivityMutterActivityMonitorBackend* self,
                                                                                                guint32 id)
{
	g_return_if_fail (self != NULL);
	if (id == self->priv->idle_watch_id) {
		break_timer_daemon_activity_mutter_activity_monitor_backend_idle_watch_cb (self);
	} else {
		if (id == self->priv->user_active_watch_id) {
			break_timer_daemon_activity_mutter_activity_monitor_backend_user_active_watch_cb (self);
		}
	}
}

static gboolean
_break_timer_daemon_activity_mutter_activity_monitor_backend_active_idle_poll_cb_gsource_func (gpointer self)
{
	gboolean result;
	result = break_timer_daemon_activity_mutter_activity_monitor_backend_active_idle_poll_cb ((BreakTimerDaemonActivityMutterActivityMonitorBackend*) self);
	return result;
}

static void
break_timer_daemon_activity_mutter_activity_monitor_backend_start_active_idle_poll (BreakTimerDaemonActivityMutterActivityMonitorBackend* self)
{
	g_return_if_fail (self != NULL);
	if (self->priv->active_idle_poll_source_id == ((guint) 0)) {
		self->priv->active_idle_poll_source_id = g_timeout_add_seconds_full (G_PRIORITY_DEFAULT, BREAK_TIMER_DAEMON_ACTIVITY_MUTTER_ACTIVITY_MONITOR_BACKEND_IDLE_WATCH_INTERVAL_MS / BREAK_TIMER_COMMON_TIME_UNIT_MILLISECONDS_IN_SECONDS, _break_timer_daemon_activity_mutter_activity_monitor_backend_active_idle_poll_cb_gsource_func, g_object_ref (self), g_object_unref);
	}
}

static void
break_timer_daemon_activity_mutter_activity_monitor_backend_stop_active_idle_poll (BreakTimerDaemonActivityMutterActivityMonitorBackend* self)
{
	g_return_if_fail (self != NULL);
	if (self->priv->active_idle_poll_source_id != ((guint) 0)) {
		g_source_remove (self->priv->active_idle_poll_source_id);
		self->priv->active_idle_poll_source_id = (guint) 0;
	}
}

static void
break_timer_daemon_activity_mutter_activity_monitor_backend_idle_watch_cb (BreakTimerDaemonActivityMutterActivityMonitorBackend* self)
{
	g_return_if_fail (self != NULL);
	break_timer_daemon_activity_mutter_activity_monitor_backend_poll_activity (self);
	break_timer_daemon_activity_mutter_activity_monitor_backend_set_user_is_active (self, FALSE);
	break_timer_daemon_activity_mutter_activity_monitor_backend_stop_active_idle_poll (self);
}

static void
break_timer_daemon_activity_mutter_activity_monitor_backend_user_active_watch_cb (BreakTimerDaemonActivityMutterActivityMonitorBackend* self)
{
	g_return_if_fail (self != NULL);
	self->priv->user_active_watch_id = (guint32) 0;
	break_timer_daemon_activity_mutter_activity_monitor_backend_poll_activity (self);
	break_timer_daemon_activity_mutter_activity_monitor_backend_set_user_is_active (self, TRUE);
}

static gboolean
break_timer_daemon_activity_mutter_activity_monitor_backend_active_idle_poll_cb (BreakTimerDaemonActivityMutterActivityMonitorBackend* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	break_timer_daemon_activity_mutter_activity_monitor_backend_poll_activity (self);
	break_timer_daemon_activity_mutter_activity_monitor_backend_set_user_is_active (self, self->priv->last_idle_time_ms < ((guint64) BREAK_TIMER_DAEMON_ACTIVITY_MUTTER_ACTIVITY_MONITOR_BACKEND_IDLE_WATCH_INTERVAL_MS));
	result = G_SOURCE_CONTINUE;
	return result;
}

static void
break_timer_daemon_activity_mutter_activity_monitor_backend_poll_activity (BreakTimerDaemonActivityMutterActivityMonitorBackend* self)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	{
		guint64 _tmp0_ = 0ULL;
		BreakTimerCommonIMutterIdleMonitor* _tmp1_;
		_tmp1_ = self->priv->mutter_idle_monitor;
		_tmp0_ = break_timer_common_imutter_idle_monitor_get_idletime (_tmp1_, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_IO_ERROR) {
				goto __catch0_g_io_error;
			}
			if (_inner_error0_->domain == G_DBUS_ERROR) {
				goto __catch0_g_dbus_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
		self->priv->last_idle_time_ms = _tmp0_;
		self->priv->last_idle_time_update_time_ms = break_timer_common_time_unit_get_monotonic_time_ms ();
	}
	goto __finally0;
	__catch0_g_io_error:
	{
		GError* _error_ = NULL;
		GError* _tmp2_;
		const gchar* _tmp3_;
		_error_ = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp2_ = _error_;
		_tmp3_ = _tmp2_->message;
		g_warning ("MutterActivityMonitorBackend.vala:147: Error connecting to mutter idle" \
" monitor service: %s", _tmp3_);
		_g_error_free0 (_error_);
	}
	goto __finally0;
	__catch0_g_dbus_error:
	{
		GError* _error_ = NULL;
		GError* _tmp4_;
		const gchar* _tmp5_;
		_error_ = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp4_ = _error_;
		_tmp5_ = _tmp4_->message;
		g_warning ("MutterActivityMonitorBackend.vala:149: Error getting mutter idletime: " \
"%s", _tmp5_);
		_g_error_free0 (_error_);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
break_timer_daemon_activity_mutter_activity_monitor_backend_set_user_is_active (BreakTimerDaemonActivityMutterActivityMonitorBackend* self,
                                                                                gboolean active)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	if (active) {
		break_timer_daemon_activity_mutter_activity_monitor_backend_start_active_idle_poll (self);
	} else {
		{
			guint32 _tmp0_ = 0U;
			BreakTimerCommonIMutterIdleMonitor* _tmp1_;
			_tmp1_ = self->priv->mutter_idle_monitor;
			_tmp0_ = break_timer_common_imutter_idle_monitor_add_user_active_watch (_tmp1_, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				if (_inner_error0_->domain == G_IO_ERROR) {
					goto __catch0_g_io_error;
				}
				if (_inner_error0_->domain == G_DBUS_ERROR) {
					goto __catch0_g_dbus_error;
				}
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return;
			}
			self->priv->user_active_watch_id = _tmp0_;
		}
		goto __finally0;
		__catch0_g_io_error:
		{
			GError* _error_ = NULL;
			GError* _tmp2_;
			const gchar* _tmp3_;
			_error_ = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp2_ = _error_;
			_tmp3_ = _tmp2_->message;
			g_warning ("MutterActivityMonitorBackend.vala:160: Error connecting to mutter idle" \
" monitor service: %s", _tmp3_);
			_g_error_free0 (_error_);
		}
		goto __finally0;
		__catch0_g_dbus_error:
		{
			GError* _error_ = NULL;
			GError* _tmp4_;
			const gchar* _tmp5_;
			_error_ = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp4_ = _error_;
			_tmp5_ = _tmp4_->message;
			g_warning ("MutterActivityMonitorBackend.vala:162: Error adding mutter user active" \
" watch: %s", _tmp5_);
			_g_error_free0 (_error_);
		}
		__finally0:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	self->priv->user_is_active = active;
}

static guint64
break_timer_daemon_activity_mutter_activity_monitor_backend_real_time_since_last_event_ms (BreakTimerDaemonActivityActivityMonitorBackend* base)
{
	BreakTimerDaemonActivityMutterActivityMonitorBackend * self;
	guint64 result;
	self = (BreakTimerDaemonActivityMutterActivityMonitorBackend*) base;
	if (self->priv->user_is_active) {
		result = (guint64) 0;
		return result;
	} else {
		if (self->priv->last_idle_time_update_time_ms > ((gint64) 0)) {
			gint64 now = 0LL;
			gint64 time_since = 0LL;
			now = break_timer_common_time_unit_get_monotonic_time_ms ();
			time_since = now - self->priv->last_idle_time_update_time_ms;
			result = time_since + self->priv->last_idle_time_ms;
			return result;
		} else {
			result = (guint64) 0;
			return result;
		}
	}
}

static void
break_timer_daemon_activity_mutter_activity_monitor_backend_class_init (BreakTimerDaemonActivityMutterActivityMonitorBackendClass * klass,
                                                                        gpointer klass_data)
{
	break_timer_daemon_activity_mutter_activity_monitor_backend_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &BreakTimerDaemonActivityMutterActivityMonitorBackend_private_offset);
	((BreakTimerDaemonActivityActivityMonitorBackendClass *) klass)->init = (gboolean (*) (BreakTimerDaemonActivityActivityMonitorBackend*, GCancellable*, GError**)) break_timer_daemon_activity_mutter_activity_monitor_backend_real_init;
	((BreakTimerDaemonActivityActivityMonitorBackendClass *) klass)->time_since_last_event_ms = (guint64 (*) (BreakTimerDaemonActivityActivityMonitorBackend*)) break_timer_daemon_activity_mutter_activity_monitor_backend_real_time_since_last_event_ms;
	G_OBJECT_CLASS (klass)->finalize = break_timer_daemon_activity_mutter_activity_monitor_backend_finalize;
}

static void
break_timer_daemon_activity_mutter_activity_monitor_backend_g_initable_interface_init (GInitableIface * iface,
                                                                                       gpointer iface_data)
{
	break_timer_daemon_activity_mutter_activity_monitor_backend_g_initable_parent_iface = g_type_interface_peek_parent (iface);
	iface->init = (gboolean (*) (GInitable*, GCancellable*, GError**)) break_timer_daemon_activity_mutter_activity_monitor_backend_real_init;
}

static void
break_timer_daemon_activity_mutter_activity_monitor_backend_instance_init (BreakTimerDaemonActivityMutterActivityMonitorBackend * self,
                                                                           gpointer klass)
{
	self->priv = break_timer_daemon_activity_mutter_activity_monitor_backend_get_instance_private (self);
}

static void
break_timer_daemon_activity_mutter_activity_monitor_backend_finalize (GObject * obj)
{
	BreakTimerDaemonActivityMutterActivityMonitorBackend * self;
	gboolean _tmp0_ = FALSE;
	BreakTimerCommonIMutterIdleMonitor* _tmp1_;
	GError* _inner_error0_ = NULL;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BREAK_TIMER_DAEMON_ACTIVITY_TYPE_MUTTER_ACTIVITY_MONITOR_BACKEND, BreakTimerDaemonActivityMutterActivityMonitorBackend);
	_tmp1_ = self->priv->mutter_idle_monitor;
	if (_tmp1_ != NULL) {
		_tmp0_ = self->priv->idle_watch_id > ((guint32) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		{
			BreakTimerCommonIMutterIdleMonitor* _tmp2_;
			_tmp2_ = self->priv->mutter_idle_monitor;
			break_timer_common_imutter_idle_monitor_remove_watch (_tmp2_, self->priv->idle_watch_id, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				if (_inner_error0_->domain == G_IO_ERROR) {
					goto __catch0_g_io_error;
				}
				if (_inner_error0_->domain == G_DBUS_ERROR) {
					goto __catch0_g_dbus_error;
				}
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
			}
		}
		goto __finally0;
		__catch0_g_io_error:
		{
			GError* _error_ = NULL;
			GError* _tmp3_;
			const gchar* _tmp4_;
			_error_ = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp3_ = _error_;
			_tmp4_ = _tmp3_->message;
			g_warning ("MutterActivityMonitorBackend.vala:51: Error connecting to mutter idle " \
"monitor service: %s", _tmp4_);
			_g_error_free0 (_error_);
		}
		goto __finally0;
		__catch0_g_dbus_error:
		{
			GError* _error_ = NULL;
			GError* _tmp5_;
			const gchar* _tmp6_;
			_error_ = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp5_ = _error_;
			_tmp6_ = _tmp5_->message;
			g_warning ("MutterActivityMonitorBackend.vala:53: Error removing mutter idle watch" \
": %s", _tmp6_);
			_g_error_free0 (_error_);
		}
		__finally0:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
		}
	}
	_g_object_unref0 (self->priv->dbus_connection);
	_g_object_unref0 (self->priv->mutter_idle_monitor);
	G_OBJECT_CLASS (break_timer_daemon_activity_mutter_activity_monitor_backend_parent_class)->finalize (obj);
}

static GType
break_timer_daemon_activity_mutter_activity_monitor_backend_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (BreakTimerDaemonActivityMutterActivityMonitorBackendClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) break_timer_daemon_activity_mutter_activity_monitor_backend_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BreakTimerDaemonActivityMutterActivityMonitorBackend), 0, (GInstanceInitFunc) break_timer_daemon_activity_mutter_activity_monitor_backend_instance_init, NULL };
	static const GInterfaceInfo g_initable_info = { (GInterfaceInitFunc) break_timer_daemon_activity_mutter_activity_monitor_backend_g_initable_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType break_timer_daemon_activity_mutter_activity_monitor_backend_type_id;
	break_timer_daemon_activity_mutter_activity_monitor_backend_type_id = g_type_register_static (BREAK_TIMER_DAEMON_ACTIVITY_TYPE_ACTIVITY_MONITOR_BACKEND, "BreakTimerDaemonActivityMutterActivityMonitorBackend", &g_define_type_info, 0);
	g_type_add_interface_static (break_timer_daemon_activity_mutter_activity_monitor_backend_type_id, g_initable_get_type (), &g_initable_info);
	BreakTimerDaemonActivityMutterActivityMonitorBackend_private_offset = g_type_add_instance_private (break_timer_daemon_activity_mutter_activity_monitor_backend_type_id, sizeof (BreakTimerDaemonActivityMutterActivityMonitorBackendPrivate));
	return break_timer_daemon_activity_mutter_activity_monitor_backend_type_id;
}

GType
break_timer_daemon_activity_mutter_activity_monitor_backend_get_type (void)
{
	static volatile gsize break_timer_daemon_activity_mutter_activity_monitor_backend_type_id__once = 0;
	if (g_once_init_enter (&break_timer_daemon_activity_mutter_activity_monitor_backend_type_id__once)) {
		GType break_timer_daemon_activity_mutter_activity_monitor_backend_type_id;
		break_timer_daemon_activity_mutter_activity_monitor_backend_type_id = break_timer_daemon_activity_mutter_activity_monitor_backend_get_type_once ();
		g_once_init_leave (&break_timer_daemon_activity_mutter_activity_monitor_backend_type_id__once, break_timer_daemon_activity_mutter_activity_monitor_backend_type_id);
	}
	return break_timer_daemon_activity_mutter_activity_monitor_backend_type_id__once;
}

