/* gitg-ref-action-checkout.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from gitg-ref-action-checkout.vala, do not modify */

/*
 * This file is part of gitg
 *
 * Copyright (C) 2015 - Jesse van den Kieboom
 *
 * gitg is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * gitg is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with gitg. If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib-object.h>
#include "libgitg-ext.h"
#include "libgitg.h"
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include "config.h"
#include <gio/gio.h>
#include <gtk/gtk.h>
#include <glib/gi18n-lib.h>
#include <libgit2-glib/ggit.h>

#define GITG_REF_ACTION_CHECKOUT_version VERSION
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define GITG_TYPE_REF_ACTION_CHECKOUT (gitg_ref_action_checkout_get_type ())
#define GITG_REF_ACTION_CHECKOUT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GITG_TYPE_REF_ACTION_CHECKOUT, GitgRefActionCheckout))
#define GITG_REF_ACTION_CHECKOUT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GITG_TYPE_REF_ACTION_CHECKOUT, GitgRefActionCheckoutClass))
#define GITG_IS_REF_ACTION_CHECKOUT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GITG_TYPE_REF_ACTION_CHECKOUT))
#define GITG_IS_REF_ACTION_CHECKOUT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GITG_TYPE_REF_ACTION_CHECKOUT))
#define GITG_REF_ACTION_CHECKOUT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GITG_TYPE_REF_ACTION_CHECKOUT, GitgRefActionCheckoutClass))

typedef struct _GitgRefActionCheckout GitgRefActionCheckout;
typedef struct _GitgRefActionCheckoutClass GitgRefActionCheckoutClass;
typedef struct _GitgRefActionCheckoutPrivate GitgRefActionCheckoutPrivate;
enum  {
	GITG_REF_ACTION_CHECKOUT_0_PROPERTY,
	GITG_REF_ACTION_CHECKOUT_APPLICATION_PROPERTY,
	GITG_REF_ACTION_CHECKOUT_ACTION_INTERFACE_PROPERTY,
	GITG_REF_ACTION_CHECKOUT_REFERENCE_PROPERTY,
	GITG_REF_ACTION_CHECKOUT_ID_PROPERTY,
	GITG_REF_ACTION_CHECKOUT_DISPLAY_NAME_PROPERTY,
	GITG_REF_ACTION_CHECKOUT_DESCRIPTION_PROPERTY,
	GITG_REF_ACTION_CHECKOUT_ENABLED_PROPERTY,
	GITG_REF_ACTION_CHECKOUT_NUM_PROPERTIES
};
static GParamSpec* gitg_ref_action_checkout_properties[GITG_REF_ACTION_CHECKOUT_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define GITG_TYPE_SIMPLE_NOTIFICATION (gitg_simple_notification_get_type ())
#define GITG_SIMPLE_NOTIFICATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GITG_TYPE_SIMPLE_NOTIFICATION, GitgSimpleNotification))
#define GITG_SIMPLE_NOTIFICATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GITG_TYPE_SIMPLE_NOTIFICATION, GitgSimpleNotificationClass))
#define GITG_IS_SIMPLE_NOTIFICATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GITG_TYPE_SIMPLE_NOTIFICATION))
#define GITG_IS_SIMPLE_NOTIFICATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GITG_TYPE_SIMPLE_NOTIFICATION))
#define GITG_SIMPLE_NOTIFICATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GITG_TYPE_SIMPLE_NOTIFICATION, GitgSimpleNotificationClass))

typedef struct _GitgSimpleNotification GitgSimpleNotification;
typedef struct _GitgSimpleNotificationClass GitgSimpleNotificationClass;
typedef struct _Block7Data Block7Data;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _GitgRefActionCheckoutCheckoutData GitgRefActionCheckoutCheckoutData;

#define GITG_TYPE_CHECKOUT_REMOTE_BRANCH_DIALOG (gitg_checkout_remote_branch_dialog_get_type ())
#define GITG_CHECKOUT_REMOTE_BRANCH_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GITG_TYPE_CHECKOUT_REMOTE_BRANCH_DIALOG, GitgCheckoutRemoteBranchDialog))
#define GITG_CHECKOUT_REMOTE_BRANCH_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GITG_TYPE_CHECKOUT_REMOTE_BRANCH_DIALOG, GitgCheckoutRemoteBranchDialogClass))
#define GITG_IS_CHECKOUT_REMOTE_BRANCH_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GITG_TYPE_CHECKOUT_REMOTE_BRANCH_DIALOG))
#define GITG_IS_CHECKOUT_REMOTE_BRANCH_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GITG_TYPE_CHECKOUT_REMOTE_BRANCH_DIALOG))
#define GITG_CHECKOUT_REMOTE_BRANCH_DIALOG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GITG_TYPE_CHECKOUT_REMOTE_BRANCH_DIALOG, GitgCheckoutRemoteBranchDialogClass))

typedef struct _GitgCheckoutRemoteBranchDialog GitgCheckoutRemoteBranchDialog;
typedef struct _GitgCheckoutRemoteBranchDialogClass GitgCheckoutRemoteBranchDialogClass;
typedef struct _Block8Data Block8Data;
typedef struct _GitgRefActionCheckoutCreateBranchData GitgRefActionCheckoutCreateBranchData;

struct _GitgRefActionCheckout {
	GObject parent_instance;
	GitgRefActionCheckoutPrivate * priv;
};

struct _GitgRefActionCheckoutClass {
	GObjectClass parent_class;
};

struct _GitgRefActionCheckoutPrivate {
	GitgExtApplication* _application;
	GitgExtRefActionInterface* _action_interface;
	GitgRef* _reference;
};

struct _Block7Data {
	int _ref_count_;
	GitgRefActionCheckout* self;
	GitgRepository* repo;
	GitgSimpleNotification* notification;
	gboolean retval;
	gpointer _async_data_;
};

struct _GitgRefActionCheckoutCheckoutData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GitgRefActionCheckout* self;
	gboolean result;
	Block7Data* _data7_;
	GitgExtApplication* _tmp0_;
	GitgExtApplication* _tmp1_;
	GitgExtApplication* _tmp2_;
	GitgRepository* _tmp3_;
	GitgRepository* _tmp4_;
	GitgRepository* _tmp5_;
	GitgRef* _tmp6_;
	GitgRef* _tmp7_;
	GitgParsedRefName* _tmp8_;
	GitgParsedRefName* _tmp9_;
	GitgParsedRefName* _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
	gchar* _tmp15_;
	GitgSimpleNotification* _tmp16_;
	GitgSimpleNotification* _tmp17_;
	GitgExtApplication* _tmp18_;
	GitgExtApplication* _tmp19_;
	GitgExtApplication* _tmp20_;
	GitgExtNotifications* _tmp21_;
	GitgExtNotifications* _tmp22_;
	GitgExtNotifications* _tmp23_;
	GitgExtRefActionInterface* _tmp24_;
	GitgExtRefActionInterface* _tmp25_;
	GError* _inner_error0_;
};

struct _Block8Data {
	int _ref_count_;
	GitgRefActionCheckout* self;
	GitgCheckoutRemoteBranchDialog* dlg;
};

struct _GitgRefActionCheckoutCreateBranchData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GitgRefActionCheckout* self;
	GgitRef* reference;
	gchar* new_branch_name;
	gchar* remote_branch_name;
	GgitBranch* result;
	GgitBranch* branch;
	GitgRepository* repo;
	GitgExtApplication* _tmp0_;
	GitgExtApplication* _tmp1_;
	GitgExtApplication* _tmp2_;
	GitgRepository* _tmp3_;
	GitgRepository* _tmp4_;
	GitgRepository* _tmp5_;
	GgitObject* _tmp6_;
	GgitObject* _tmp7_;
	GitgCommit* commit;
	GitgCommit* _tmp8_;
	GitgBranch* _tmp9_;
	GitgRepository* _tmp10_;
	GitgCommit* _tmp11_;
	GitgBranch* _tmp12_;
	GitgBranch* _tmp13_;
	GError* e;
	GitgExtApplication* _tmp14_;
	GitgExtApplication* _tmp15_;
	GitgExtApplication* _tmp16_;
	GError* _tmp17_;
	const gchar* _tmp18_;
	GgitBranch* _tmp19_;
	GgitBranch* _tmp20_;
	GError* _vala1_e;
	GitgExtApplication* _tmp21_;
	GitgExtApplication* _tmp22_;
	GitgExtApplication* _tmp23_;
	gchar* _tmp24_;
	gchar* _tmp25_;
	GError* _tmp26_;
	const gchar* _tmp27_;
	GError* _inner_error0_;
};

static gint GitgRefActionCheckout_private_offset;
static gpointer gitg_ref_action_checkout_parent_class = NULL;
static GitgExtUIElementIface * gitg_ref_action_checkout_gitg_ext_ui_element_parent_iface = NULL;
static GitgExtActionIface * gitg_ref_action_checkout_gitg_ext_action_parent_iface = NULL;
static GitgExtRefActionIface * gitg_ref_action_checkout_gitg_ext_ref_action_parent_iface = NULL;

VALA_EXTERN GType gitg_ref_action_checkout_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GitgRefActionCheckout, g_object_unref)
VALA_EXTERN GitgRefActionCheckout* gitg_ref_action_checkout_new (GitgExtApplication* application,
                                                     GitgExtRefActionInterface* action_interface,
                                                     GitgRef* reference);
VALA_EXTERN GitgRefActionCheckout* gitg_ref_action_checkout_construct (GType object_type,
                                                           GitgExtApplication* application,
                                                           GitgExtRefActionInterface* action_interface,
                                                           GitgRef* reference);
static void gitg_ref_action_checkout_checkout_data_free (gpointer _data);
VALA_EXTERN void gitg_ref_action_checkout_checkout (GitgRefActionCheckout* self,
                                        GAsyncReadyCallback _callback_,
                                        gpointer _user_data_);
VALA_EXTERN gboolean gitg_ref_action_checkout_checkout_finish (GitgRefActionCheckout* self,
                                                   GAsyncResult* _res_);
static gboolean gitg_ref_action_checkout_checkout_co (GitgRefActionCheckoutCheckoutData* _data_);
VALA_EXTERN GType gitg_simple_notification_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GitgSimpleNotification, g_object_unref)
static Block7Data* block7_data_ref (Block7Data* _data7_);
static void block7_data_unref (void * _userdata_);
VALA_EXTERN GitgSimpleNotification* gitg_simple_notification_new (const gchar* title,
                                                      const gchar* message);
VALA_EXTERN GitgSimpleNotification* gitg_simple_notification_construct (GType object_type,
                                                            const gchar* title,
                                                            const gchar* message);
static void ___lambda12_ (Block7Data* _data7_,
                   GError** error);
VALA_EXTERN void gitg_simple_notification_error (GitgSimpleNotification* self,
                                     const gchar* message);
static void ____lambda12__gitg_async_thread_func (gpointer self,
                                           GError** error);
static void gitg_ref_action_checkout_checkout_ready (GObject* source_object,
                                              GAsyncResult* _res_,
                                              gpointer _user_data_);
VALA_EXTERN void gitg_simple_notification_success (GitgSimpleNotification* self,
                                       const gchar* message);
static void gitg_ref_action_checkout_real_activate (GitgExtUIElement* base);
VALA_EXTERN GType gitg_checkout_remote_branch_dialog_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GitgCheckoutRemoteBranchDialog, g_object_unref)
static Block8Data* block8_data_ref (Block8Data* _data8_);
static void block8_data_unref (void * _userdata_);
VALA_EXTERN GitgCheckoutRemoteBranchDialog* gitg_checkout_remote_branch_dialog_new (GtkWindow* parent,
                                                                        GitgRepository* repository,
                                                                        GitgRef* reference);
VALA_EXTERN GitgCheckoutRemoteBranchDialog* gitg_checkout_remote_branch_dialog_construct (GType object_type,
                                                                              GtkWindow* parent,
                                                                              GitgRepository* repository,
                                                                              GitgRef* reference);
static void ____lambda16_ (Block8Data* _data8_,
                    GtkDialog* d,
                    gint resp);
static void gitg_ref_action_checkout_on_checkout_remote_branch_dialog_response (GitgRefActionCheckout* self,
                                                                         GitgCheckoutRemoteBranchDialog* dialog,
                                                                         gint response_id);
static void _____lambda16__gtk_dialog_response (GtkDialog* _sender,
                                         gint response_id,
                                         gpointer self);
VALA_EXTERN gboolean gitg_checkout_remote_branch_dialog_get_track_remote (GitgCheckoutRemoteBranchDialog* self);
VALA_EXTERN gchar* gitg_checkout_remote_branch_dialog_get_remote_branch_name (GitgCheckoutRemoteBranchDialog* self);
static void gitg_ref_action_checkout_create_branch (GitgRefActionCheckout* self,
                                             GgitRef* reference,
                                             const gchar* new_branch_name,
                                             const gchar* remote_branch_name,
                                             GAsyncReadyCallback _callback_,
                                             gpointer _user_data_);
static GgitBranch* gitg_ref_action_checkout_create_branch_finish (GitgRefActionCheckout* self,
                                                           GAsyncResult* _res_);
VALA_EXTERN gchar* gitg_checkout_remote_branch_dialog_get_new_branch_name (GitgCheckoutRemoteBranchDialog* self);
static void ___lambda17_ (GitgRefActionCheckout* self,
                   GObject* obj,
                   GAsyncResult* res);
static void ____lambda17__gasync_ready_callback (GObject* source_object,
                                          GAsyncResult* res,
                                          gpointer self);
static void gitg_ref_action_checkout_create_branch_data_free (gpointer _data);
static gboolean gitg_ref_action_checkout_create_branch_co (GitgRefActionCheckoutCreateBranchData* _data_);
static void gitg_ref_action_checkout_finalize (GObject * obj);
static GType gitg_ref_action_checkout_get_type_once (void);
static void _vala_gitg_ref_action_checkout_get_property (GObject * object,
                                                  guint property_id,
                                                  GValue * value,
                                                  GParamSpec * pspec);
static void _vala_gitg_ref_action_checkout_set_property (GObject * object,
                                                  guint property_id,
                                                  const GValue * value,
                                                  GParamSpec * pspec);

static inline gpointer
gitg_ref_action_checkout_get_instance_private (GitgRefActionCheckout* self)
{
	return G_STRUCT_MEMBER_P (self, GitgRefActionCheckout_private_offset);
}

GitgRefActionCheckout*
gitg_ref_action_checkout_construct (GType object_type,
                                    GitgExtApplication* application,
                                    GitgExtRefActionInterface* action_interface,
                                    GitgRef* reference)
{
	GitgRefActionCheckout * self = NULL;
	g_return_val_if_fail (application != NULL, NULL);
	g_return_val_if_fail (action_interface != NULL, NULL);
	g_return_val_if_fail (reference != NULL, NULL);
	self = (GitgRefActionCheckout*) g_object_new (object_type, "application", application, "action-interface", action_interface, "reference", reference, NULL);
	return self;
}

GitgRefActionCheckout*
gitg_ref_action_checkout_new (GitgExtApplication* application,
                              GitgExtRefActionInterface* action_interface,
                              GitgRef* reference)
{
	return gitg_ref_action_checkout_construct (GITG_TYPE_REF_ACTION_CHECKOUT, application, action_interface, reference);
}

static void
gitg_ref_action_checkout_checkout_data_free (gpointer _data)
{
	GitgRefActionCheckoutCheckoutData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (GitgRefActionCheckoutCheckoutData, _data_);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

void
gitg_ref_action_checkout_checkout (GitgRefActionCheckout* self,
                                   GAsyncReadyCallback _callback_,
                                   gpointer _user_data_)
{
	GitgRefActionCheckoutCheckoutData* _data_;
	GitgRefActionCheckout* _tmp0_;
	g_return_if_fail (self != NULL);
	_data_ = g_slice_new0 (GitgRefActionCheckoutCheckoutData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, gitg_ref_action_checkout_checkout_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	gitg_ref_action_checkout_checkout_co (_data_);
}

gboolean
gitg_ref_action_checkout_checkout_finish (GitgRefActionCheckout* self,
                                          GAsyncResult* _res_)
{
	gboolean result;
	GitgRefActionCheckoutCheckoutData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
	result = _data_->result;
	return result;
}

static Block7Data*
block7_data_ref (Block7Data* _data7_)
{
	g_atomic_int_inc (&_data7_->_ref_count_);
	return _data7_;
}

static void
block7_data_unref (void * _userdata_)
{
	Block7Data* _data7_;
	_data7_ = (Block7Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data7_->_ref_count_)) {
		GitgRefActionCheckout* self;
		self = _data7_->self;
		_g_object_unref0 (_data7_->notification);
		_g_object_unref0 (_data7_->repo);
		_g_object_unref0 (self);
		g_slice_free (Block7Data, _data7_);
	}
}

static void
___lambda12_ (Block7Data* _data7_,
              GError** error)
{
	GitgRefActionCheckout* self;
	GitgCommit* commit = NULL;
	GError* _inner_error0_ = NULL;
	self = _data7_->self;
	{
		GgitRef* _tmp0_ = NULL;
		GitgRef* _tmp1_;
		GitgRef* _tmp2_;
		GgitRef* _tmp3_;
		GgitObject* _tmp4_ = NULL;
		GgitObject* _tmp5_;
		GitgCommit* _tmp6_;
		_tmp1_ = gitg_ext_ref_action_get_reference ((GitgExtRefAction*) self);
		_tmp2_ = _tmp1_;
		_tmp3_ = ggit_ref_resolve ((GgitRef*) _tmp2_, &_inner_error0_);
		_tmp0_ = _tmp3_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp5_ = ggit_ref_lookup (_tmp0_, &_inner_error0_);
		_tmp4_ = _tmp5_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (_tmp0_);
			goto __catch0_g_error;
		}
		_tmp6_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp4_, GITG_TYPE_COMMIT) ? ((GitgCommit*) _tmp4_) : NULL);
		_g_object_unref0 (commit);
		commit = _tmp6_;
		_g_object_unref0 (_tmp4_);
		_g_object_unref0 (_tmp0_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp7_;
		const gchar* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp7_ = e;
		_tmp8_ = _tmp7_->message;
		_tmp9_ = g_strdup_printf (_ ("Failed to lookup commit: %s"), _tmp8_);
		_tmp10_ = _tmp9_;
		gitg_simple_notification_error (_data7_->notification, _tmp10_);
		_g_free0 (_tmp10_);
		_g_error_free0 (e);
		_g_object_unref0 (commit);
		return;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (commit);
		return;
	}
	{
		GgitCheckoutOptions* opts = NULL;
		GgitCheckoutOptions* _tmp11_;
		GgitCheckoutOptions* _tmp12_;
		GitgCommit* _tmp13_;
		GgitTree* _tmp14_;
		GgitTree* _tmp15_;
		GgitCheckoutOptions* _tmp16_;
		_tmp11_ = ggit_checkout_options_new ();
		opts = _tmp11_;
		_tmp12_ = opts;
		ggit_checkout_options_set_strategy (_tmp12_, GGIT_CHECKOUT_SAFE);
		_tmp13_ = commit;
		_tmp14_ = ggit_commit_get_tree ((GgitCommit*) _tmp13_);
		_tmp15_ = _tmp14_;
		_tmp16_ = opts;
		ggit_repository_checkout_tree ((GgitRepository*) _data7_->repo, (GgitObject*) _tmp15_, _tmp16_, &_inner_error0_);
		_g_object_unref0 (_tmp15_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (opts);
			goto __catch1_g_error;
		}
		_g_object_unref0 (opts);
	}
	goto __finally1;
	__catch1_g_error:
	{
		GError* e = NULL;
		GError* _tmp17_;
		const gchar* _tmp18_;
		gchar* _tmp19_;
		gchar* _tmp20_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp17_ = e;
		_tmp18_ = _tmp17_->message;
		_tmp19_ = g_strdup_printf (_ ("Failed to checkout branch: %s"), _tmp18_);
		_tmp20_ = _tmp19_;
		gitg_simple_notification_error (_data7_->notification, _tmp20_);
		_g_free0 (_tmp20_);
		_g_error_free0 (e);
		_g_object_unref0 (commit);
		return;
	}
	__finally1:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (commit);
		return;
	}
	{
		GitgRef* _tmp21_;
		GitgRef* _tmp22_;
		const gchar* _tmp23_;
		_tmp21_ = gitg_ext_ref_action_get_reference ((GitgExtRefAction*) self);
		_tmp22_ = _tmp21_;
		_tmp23_ = ggit_ref_get_name ((GgitRef*) _tmp22_);
		ggit_repository_set_head ((GgitRepository*) _data7_->repo, _tmp23_, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch2_g_error;
		}
	}
	goto __finally2;
	__catch2_g_error:
	{
		GError* e = NULL;
		GError* _tmp24_;
		const gchar* _tmp25_;
		gchar* _tmp26_;
		gchar* _tmp27_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp24_ = e;
		_tmp25_ = _tmp24_->message;
		_tmp26_ = g_strdup_printf (_ ("Failed to update HEAD: %s"), _tmp25_);
		_tmp27_ = _tmp26_;
		gitg_simple_notification_error (_data7_->notification, _tmp27_);
		_g_free0 (_tmp27_);
		_g_error_free0 (e);
		_g_object_unref0 (commit);
		return;
	}
	__finally2:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (commit);
		return;
	}
	_data7_->retval = TRUE;
	_g_object_unref0 (commit);
}

static void
____lambda12__gitg_async_thread_func (gpointer self,
                                      GError** error)
{
	___lambda12_ (self, error);
}

static void
gitg_ref_action_checkout_checkout_ready (GObject* source_object,
                                         GAsyncResult* _res_,
                                         gpointer _user_data_)
{
	GitgRefActionCheckoutCheckoutData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	gitg_ref_action_checkout_checkout_co (_data_);
}

static gboolean
gitg_ref_action_checkout_checkout_co (GitgRefActionCheckoutCheckoutData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_data7_ = g_slice_new0 (Block7Data);
	_data_->_data7_->_ref_count_ = 1;
	_data_->_data7_->self = g_object_ref (_data_->self);
	_data_->_data7_->_async_data_ = _data_;
	_data_->_tmp0_ = gitg_ext_ui_element_get_application ((GitgExtUIElement*) _data_->self);
	_data_->_tmp1_ = _data_->_tmp0_;
	_data_->_tmp2_ = _data_->_tmp1_;
	_data_->_tmp3_ = gitg_ext_application_get_repository (_data_->_tmp2_);
	_data_->_tmp4_ = _data_->_tmp3_;
	_data_->_tmp5_ = _data_->_tmp4_;
	_g_object_unref0 (_data_->_tmp2_);
	_data_->_data7_->repo = _data_->_tmp5_;
	_data_->_tmp6_ = gitg_ext_ref_action_get_reference ((GitgExtRefAction*) _data_->self);
	_data_->_tmp7_ = _data_->_tmp6_;
	_data_->_tmp8_ = gitg_ref_get_parsed_name (_data_->_tmp7_);
	_data_->_tmp9_ = _data_->_tmp8_;
	_data_->_tmp10_ = _data_->_tmp9_;
	_data_->_tmp11_ = gitg_parsed_ref_name_get_shortname (_data_->_tmp10_);
	_data_->_tmp12_ = _data_->_tmp11_;
	_data_->_tmp13_ = _data_->_tmp12_;
	_data_->_tmp14_ = g_strdup_printf (_ ("Checkout “%s”"), _data_->_tmp13_);
	_data_->_tmp15_ = _data_->_tmp14_;
	_data_->_tmp16_ = gitg_simple_notification_new (_data_->_tmp15_, NULL);
	g_object_ref_sink (_data_->_tmp16_);
	_data_->_tmp17_ = _data_->_tmp16_;
	_g_free0 (_data_->_tmp15_);
	_g_free0 (_data_->_tmp13_);
	_g_object_unref0 (_data_->_tmp10_);
	_data_->_data7_->notification = _data_->_tmp17_;
	_data_->_data7_->retval = FALSE;
	_data_->_tmp18_ = gitg_ext_ui_element_get_application ((GitgExtUIElement*) _data_->self);
	_data_->_tmp19_ = _data_->_tmp18_;
	_data_->_tmp20_ = _data_->_tmp19_;
	_data_->_tmp21_ = gitg_ext_application_get_notifications (_data_->_tmp20_);
	_data_->_tmp22_ = _data_->_tmp21_;
	_data_->_tmp23_ = _data_->_tmp22_;
	gitg_ext_notifications_add (_data_->_tmp23_, (GitgExtNotification*) _data_->_data7_->notification);
	_g_object_unref0 (_data_->_tmp23_);
	_g_object_unref0 (_data_->_tmp20_);
	{
		_data_->_state_ = 1;
		gitg_async_thread (____lambda12__gitg_async_thread_func, _data_->_data7_, gitg_ref_action_checkout_checkout_ready, _data_);
		return FALSE;
		_state_1:
		gitg_async_thread_finish (_data_->_res_, &_data_->_inner_error0_);
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		g_clear_error (&_data_->_inner_error0_);
	}
	__finally0:
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		block7_data_unref (_data_->_data7_);
		_data_->_data7_ = NULL;
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
		g_clear_error (&_data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	if (_data_->_data7_->retval) {
		gitg_simple_notification_success (_data_->_data7_->notification, _ ("Successfully checked out branch to working directory"));
		_data_->_tmp24_ = gitg_ext_ref_action_get_action_interface ((GitgExtRefAction*) _data_->self);
		_data_->_tmp25_ = _data_->_tmp24_;
		gitg_ext_ref_action_interface_refresh (_data_->_tmp25_);
	}
	_data_->result = _data_->_data7_->retval;
	block7_data_unref (_data_->_data7_);
	_data_->_data7_ = NULL;
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static Block8Data*
block8_data_ref (Block8Data* _data8_)
{
	g_atomic_int_inc (&_data8_->_ref_count_);
	return _data8_;
}

static void
block8_data_unref (void * _userdata_)
{
	Block8Data* _data8_;
	_data8_ = (Block8Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data8_->_ref_count_)) {
		GitgRefActionCheckout* self;
		self = _data8_->self;
		_g_object_unref0 (_data8_->dlg);
		_g_object_unref0 (self);
		g_slice_free (Block8Data, _data8_);
	}
}

static void
____lambda16_ (Block8Data* _data8_,
               GtkDialog* d,
               gint resp)
{
	GitgRefActionCheckout* self;
	GitgCheckoutRemoteBranchDialog* _tmp0_;
	self = _data8_->self;
	g_return_if_fail (d != NULL);
	_tmp0_ = _data8_->dlg;
	gitg_ref_action_checkout_on_checkout_remote_branch_dialog_response (self, _tmp0_, resp);
}

static void
_____lambda16__gtk_dialog_response (GtkDialog* _sender,
                                    gint response_id,
                                    gpointer self)
{
	____lambda16_ (self, _sender, response_id);
}

static void
gitg_ref_action_checkout_real_activate (GitgExtUIElement* base)
{
	GitgRefActionCheckout * self;
	GitgRef* _tmp0_;
	GitgRef* _tmp1_;
	self = (GitgRefActionCheckout*) base;
	_tmp0_ = gitg_ext_ref_action_get_reference ((GitgExtRefAction*) self);
	_tmp1_ = _tmp0_;
	if (ggit_ref_is_branch ((GgitRef*) _tmp1_)) {
		gitg_ref_action_checkout_checkout (self, NULL, NULL);
	} else {
		GitgRef* _tmp2_;
		GitgRef* _tmp3_;
		_tmp2_ = gitg_ext_ref_action_get_reference ((GitgExtRefAction*) self);
		_tmp3_ = _tmp2_;
		if (ggit_ref_is_remote ((GgitRef*) _tmp3_)) {
			Block8Data* _data8_;
			GitgExtApplication* _tmp4_;
			GitgExtApplication* _tmp5_;
			GtkWindow* _tmp6_;
			GitgExtApplication* _tmp7_;
			GitgExtApplication* _tmp8_;
			GitgExtApplication* _tmp9_;
			GitgRepository* _tmp10_;
			GitgRepository* _tmp11_;
			GitgRepository* _tmp12_;
			GitgRef* _tmp13_;
			GitgRef* _tmp14_;
			GitgCheckoutRemoteBranchDialog* _tmp15_;
			GitgCheckoutRemoteBranchDialog* _tmp16_;
			GitgCheckoutRemoteBranchDialog* _tmp17_;
			GitgCheckoutRemoteBranchDialog* _tmp18_;
			_data8_ = g_slice_new0 (Block8Data);
			_data8_->_ref_count_ = 1;
			_data8_->self = g_object_ref (self);
			_tmp4_ = gitg_ext_ui_element_get_application ((GitgExtUIElement*) self);
			_tmp5_ = _tmp4_;
			_tmp6_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, gtk_window_get_type (), GtkWindow);
			_tmp7_ = gitg_ext_ui_element_get_application ((GitgExtUIElement*) self);
			_tmp8_ = _tmp7_;
			_tmp9_ = _tmp8_;
			_tmp10_ = gitg_ext_application_get_repository (_tmp9_);
			_tmp11_ = _tmp10_;
			_tmp12_ = _tmp11_;
			_tmp13_ = gitg_ext_ref_action_get_reference ((GitgExtRefAction*) self);
			_tmp14_ = _tmp13_;
			_tmp15_ = gitg_checkout_remote_branch_dialog_new (_tmp6_, _tmp12_, _tmp14_);
			g_object_ref_sink (_tmp15_);
			_tmp16_ = _tmp15_;
			_g_object_unref0 (_tmp12_);
			_g_object_unref0 (_tmp9_);
			_g_object_unref0 (_tmp6_);
			_data8_->dlg = _tmp16_;
			_tmp17_ = _data8_->dlg;
			g_signal_connect_data ((GtkDialog*) _tmp17_, "response", (GCallback) _____lambda16__gtk_dialog_response, block8_data_ref (_data8_), (GClosureNotify) block8_data_unref, 0);
			_tmp18_ = _data8_->dlg;
			gtk_widget_show ((GtkWidget*) _tmp18_);
			block8_data_unref (_data8_);
			_data8_ = NULL;
		}
	}
}

static void
___lambda17_ (GitgRefActionCheckout* self,
              GObject* obj,
              GAsyncResult* res)
{
	GitgRef* branch_ref = NULL;
	GgitBranch* _tmp0_;
	GitgRef* _tmp1_;
	GitgRef* _tmp2_;
	g_return_if_fail (res != NULL);
	_tmp0_ = gitg_ref_action_checkout_create_branch_finish (self, res);
	_tmp1_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, GITG_TYPE_REF) ? ((GitgRef*) _tmp0_) : NULL;
	if (_tmp1_ == NULL) {
		_g_object_unref0 (_tmp0_);
	}
	branch_ref = _tmp1_;
	_tmp2_ = branch_ref;
	if (_tmp2_ != NULL) {
		GitgExtRefActionInterface* _tmp3_;
		GitgExtRefActionInterface* _tmp4_;
		GitgRef* _tmp5_;
		GitgRef* _tmp6_;
		_tmp3_ = gitg_ext_ref_action_get_action_interface ((GitgExtRefAction*) self);
		_tmp4_ = _tmp3_;
		_tmp5_ = branch_ref;
		gitg_ext_ref_action_interface_add_ref (_tmp4_, _tmp5_);
		_tmp6_ = branch_ref;
		gitg_ext_ref_action_set_reference ((GitgExtRefAction*) self, _tmp6_);
		gitg_ref_action_checkout_checkout (self, NULL, NULL);
	}
	_g_object_unref0 (branch_ref);
}

static void
____lambda17__gasync_ready_callback (GObject* source_object,
                                     GAsyncResult* res,
                                     gpointer self)
{
	___lambda17_ ((GitgRefActionCheckout*) self, source_object, res);
	g_object_unref (self);
}

static void
gitg_ref_action_checkout_on_checkout_remote_branch_dialog_response (GitgRefActionCheckout* self,
                                                                    GitgCheckoutRemoteBranchDialog* dialog,
                                                                    gint response_id)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (dialog != NULL);
	if (response_id == ((gint) GTK_RESPONSE_OK)) {
		gchar* _tmp0_ = NULL;
		gboolean _tmp1_;
		gboolean _tmp2_;
		gchar* remote_branch_name = NULL;
		gchar* _tmp5_;
		GitgRef* _tmp6_;
		GitgRef* _tmp7_;
		gchar* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		const gchar* _tmp11_;
		_tmp1_ = gitg_checkout_remote_branch_dialog_get_track_remote (dialog);
		_tmp2_ = _tmp1_;
		if (_tmp2_) {
			gchar* _tmp3_;
			gchar* _tmp4_;
			_tmp3_ = gitg_checkout_remote_branch_dialog_get_remote_branch_name (dialog);
			_tmp4_ = _tmp3_;
			_g_free0 (_tmp0_);
			_tmp0_ = _tmp4_;
		} else {
			_g_free0 (_tmp0_);
			_tmp0_ = NULL;
		}
		_tmp5_ = g_strdup (_tmp0_);
		remote_branch_name = _tmp5_;
		_tmp6_ = gitg_ext_ref_action_get_reference ((GitgExtRefAction*) self);
		_tmp7_ = _tmp6_;
		_tmp8_ = gitg_checkout_remote_branch_dialog_get_new_branch_name (dialog);
		_tmp9_ = _tmp8_;
		_tmp10_ = _tmp9_;
		_tmp11_ = remote_branch_name;
		gitg_ref_action_checkout_create_branch (self, (GgitRef*) _tmp7_, _tmp10_, _tmp11_, ____lambda17__gasync_ready_callback, g_object_ref (self));
		_g_free0 (_tmp10_);
		_g_free0 (remote_branch_name);
		_g_free0 (_tmp0_);
	}
	gtk_widget_destroy ((GtkWidget*) dialog);
}

static void
gitg_ref_action_checkout_create_branch_data_free (gpointer _data)
{
	GitgRefActionCheckoutCreateBranchData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->reference);
	_g_free0 (_data_->new_branch_name);
	_g_free0 (_data_->remote_branch_name);
	_g_object_unref0 (_data_->result);
	_g_object_unref0 (_data_->self);
	g_slice_free (GitgRefActionCheckoutCreateBranchData, _data_);
}

static void
gitg_ref_action_checkout_create_branch (GitgRefActionCheckout* self,
                                        GgitRef* reference,
                                        const gchar* new_branch_name,
                                        const gchar* remote_branch_name,
                                        GAsyncReadyCallback _callback_,
                                        gpointer _user_data_)
{
	GitgRefActionCheckoutCreateBranchData* _data_;
	GitgRefActionCheckout* _tmp0_;
	GgitRef* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (reference != NULL);
	g_return_if_fail (new_branch_name != NULL);
	_data_ = g_slice_new0 (GitgRefActionCheckoutCreateBranchData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, gitg_ref_action_checkout_create_branch_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (reference);
	_g_object_unref0 (_data_->reference);
	_data_->reference = _tmp1_;
	_tmp2_ = g_strdup (new_branch_name);
	_g_free0 (_data_->new_branch_name);
	_data_->new_branch_name = _tmp2_;
	_tmp3_ = g_strdup (remote_branch_name);
	_g_free0 (_data_->remote_branch_name);
	_data_->remote_branch_name = _tmp3_;
	gitg_ref_action_checkout_create_branch_co (_data_);
}

static GgitBranch*
gitg_ref_action_checkout_create_branch_finish (GitgRefActionCheckout* self,
                                               GAsyncResult* _res_)
{
	GgitBranch* result;
	GitgRefActionCheckoutCreateBranchData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
	result = _data_->result;
	_data_->result = NULL;
	return result;
}

static gboolean
gitg_ref_action_checkout_create_branch_co (GitgRefActionCheckoutCreateBranchData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->branch = NULL;
	_data_->_tmp0_ = gitg_ext_ui_element_get_application ((GitgExtUIElement*) _data_->self);
	_data_->_tmp1_ = _data_->_tmp0_;
	_data_->_tmp2_ = _data_->_tmp1_;
	_data_->_tmp3_ = gitg_ext_application_get_repository (_data_->_tmp2_);
	_data_->_tmp4_ = _data_->_tmp3_;
	_data_->_tmp5_ = _data_->_tmp4_;
	_g_object_unref0 (_data_->_tmp2_);
	_data_->repo = _data_->_tmp5_;
	{
		_data_->_tmp7_ = ggit_ref_lookup (_data_->reference, &_data_->_inner_error0_);
		_data_->_tmp6_ = _data_->_tmp7_;
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_data_->_tmp8_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_data_->_tmp6_, GITG_TYPE_COMMIT) ? ((GitgCommit*) _data_->_tmp6_) : NULL);
		_data_->commit = _data_->_tmp8_;
		_data_->_tmp10_ = _data_->repo;
		_data_->_tmp11_ = _data_->commit;
		_data_->_tmp12_ = gitg_repository_create_branch (_data_->_tmp10_, _data_->new_branch_name, (GgitObject*) _data_->_tmp11_, GGIT_CREATE_NONE, &_data_->_inner_error0_);
		_data_->_tmp9_ = _data_->_tmp12_;
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			_g_object_unref0 (_data_->commit);
			_g_object_unref0 (_data_->_tmp6_);
			goto __catch0_g_error;
		}
		_data_->_tmp13_ = _data_->_tmp9_;
		_data_->_tmp9_ = NULL;
		_g_object_unref0 (_data_->branch);
		_data_->branch = (GgitBranch*) _data_->_tmp13_;
		_g_object_unref0 (_data_->_tmp9_);
		_g_object_unref0 (_data_->commit);
		_g_object_unref0 (_data_->_tmp6_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		_data_->e = _data_->_inner_error0_;
		_data_->_inner_error0_ = NULL;
		_data_->_tmp14_ = gitg_ext_ui_element_get_application ((GitgExtUIElement*) _data_->self);
		_data_->_tmp15_ = _data_->_tmp14_;
		_data_->_tmp16_ = _data_->_tmp15_;
		_data_->_tmp17_ = _data_->e;
		_data_->_tmp18_ = _data_->_tmp17_->message;
		gitg_ext_application_show_infobar (_data_->_tmp16_, _ ("Failed to create branch"), _data_->_tmp18_, GTK_MESSAGE_ERROR);
		_g_object_unref0 (_data_->_tmp16_);
		_g_error_free0 (_data_->e);
	}
	__finally0:
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		_g_object_unref0 (_data_->repo);
		_g_object_unref0 (_data_->branch);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
		g_clear_error (&_data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp19_ = _data_->branch;
	if (_data_->_tmp19_ != NULL) {
		if (_data_->remote_branch_name != NULL) {
			{
				_data_->_tmp20_ = _data_->branch;
				ggit_branch_set_upstream (_data_->_tmp20_, _data_->remote_branch_name, &_data_->_inner_error0_);
				if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
					goto __catch1_g_error;
				}
			}
			goto __finally1;
			__catch1_g_error:
			{
				_data_->_vala1_e = _data_->_inner_error0_;
				_data_->_inner_error0_ = NULL;
				_data_->_tmp21_ = gitg_ext_ui_element_get_application ((GitgExtUIElement*) _data_->self);
				_data_->_tmp22_ = _data_->_tmp21_;
				_data_->_tmp23_ = _data_->_tmp22_;
				_data_->_tmp24_ = g_strdup_printf (_ ("Failed to set the upstream branch %s for %s"), _data_->remote_branch_name, _data_->new_branch_name);
				_data_->_tmp25_ = _data_->_tmp24_;
				_data_->_tmp26_ = _data_->_vala1_e;
				_data_->_tmp27_ = _data_->_tmp26_->message;
				gitg_ext_application_show_infobar (_data_->_tmp23_, _data_->_tmp25_, _data_->_tmp27_, GTK_MESSAGE_ERROR);
				_g_free0 (_data_->_tmp25_);
				_g_object_unref0 (_data_->_tmp23_);
				_g_error_free0 (_data_->_vala1_e);
			}
			__finally1:
			if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
				_g_object_unref0 (_data_->repo);
				_g_object_unref0 (_data_->branch);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
				g_clear_error (&_data_->_inner_error0_);
				g_object_unref (_data_->_async_result);
				return FALSE;
			}
		}
	}
	_data_->result = _data_->branch;
	_g_object_unref0 (_data_->repo);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static GitgExtApplication*
gitg_ref_action_checkout_real_get_application (GitgExtUIElement* base)
{
	GitgExtApplication* result;
	GitgRefActionCheckout* self;
	GitgExtApplication* _tmp0_;
	GitgExtApplication* _tmp1_;
	self = (GitgRefActionCheckout*) base;
	_tmp0_ = self->priv->_application;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}

static void
gitg_ref_action_checkout_real_set_application (GitgExtUIElement* base,
                                               GitgExtApplication* value)
{
	GitgRefActionCheckout* self;
	GitgExtApplication* old_value;
	self = (GitgRefActionCheckout*) base;
	old_value = gitg_ref_action_checkout_real_get_application (base);
	if (old_value != value) {
		GitgExtApplication* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_application);
		self->priv->_application = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, gitg_ref_action_checkout_properties[GITG_REF_ACTION_CHECKOUT_APPLICATION_PROPERTY]);
	}
	_g_object_unref0 (old_value);
}

static GitgExtRefActionInterface*
gitg_ref_action_checkout_real_get_action_interface (GitgExtRefAction* base)
{
	GitgExtRefActionInterface* result;
	GitgRefActionCheckout* self;
	GitgExtRefActionInterface* _tmp0_;
	self = (GitgRefActionCheckout*) base;
	_tmp0_ = self->priv->_action_interface;
	result = _tmp0_;
	return result;
}

static void
gitg_ref_action_checkout_real_set_action_interface (GitgExtRefAction* base,
                                                    GitgExtRefActionInterface* value)
{
	GitgRefActionCheckout* self;
	GitgExtRefActionInterface* old_value;
	self = (GitgRefActionCheckout*) base;
	old_value = gitg_ref_action_checkout_real_get_action_interface (base);
	if (old_value != value) {
		GitgExtRefActionInterface* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_action_interface);
		self->priv->_action_interface = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, gitg_ref_action_checkout_properties[GITG_REF_ACTION_CHECKOUT_ACTION_INTERFACE_PROPERTY]);
	}
}

static GitgRef*
gitg_ref_action_checkout_real_get_reference (GitgExtRefAction* base)
{
	GitgRef* result;
	GitgRefActionCheckout* self;
	GitgRef* _tmp0_;
	self = (GitgRefActionCheckout*) base;
	_tmp0_ = self->priv->_reference;
	result = _tmp0_;
	return result;
}

static void
gitg_ref_action_checkout_real_set_reference (GitgExtRefAction* base,
                                             GitgRef* value)
{
	GitgRefActionCheckout* self;
	GitgRef* old_value;
	self = (GitgRefActionCheckout*) base;
	old_value = gitg_ref_action_checkout_real_get_reference (base);
	if (old_value != value) {
		GitgRef* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_reference);
		self->priv->_reference = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, gitg_ref_action_checkout_properties[GITG_REF_ACTION_CHECKOUT_REFERENCE_PROPERTY]);
	}
}

static gchar*
gitg_ref_action_checkout_real_get_id (GitgExtUIElement* base)
{
	gchar* result;
	GitgRefActionCheckout* self;
	gchar* _tmp0_;
	self = (GitgRefActionCheckout*) base;
	_tmp0_ = g_strdup ("/org/gnome/gitg/ref-actions/checkout");
	result = _tmp0_;
	return result;
}

static gchar*
gitg_ref_action_checkout_real_get_display_name (GitgExtUIElement* base)
{
	gchar* result;
	GitgRefActionCheckout* self;
	gchar* _tmp0_;
	self = (GitgRefActionCheckout*) base;
	_tmp0_ = g_strdup (_ ("Checkout"));
	result = _tmp0_;
	return result;
}

static gchar*
gitg_ref_action_checkout_real_get_description (GitgExtUIElement* base)
{
	gchar* result;
	GitgRefActionCheckout* self;
	gchar* _tmp0_;
	self = (GitgRefActionCheckout*) base;
	_tmp0_ = g_strdup (_ ("Checkout the selected reference"));
	result = _tmp0_;
	return result;
}

static gboolean
gitg_ref_action_checkout_real_get_enabled (GitgExtUIElement* base)
{
	gboolean result;
	GitgRefActionCheckout* self;
	GError* _inner_error0_ = NULL;
	self = (GitgRefActionCheckout*) base;
	{
		gboolean _tmp0_ = FALSE;
		gboolean _tmp1_ = FALSE;
		GitgRef* _tmp2_;
		GitgRef* _tmp3_;
		_tmp2_ = gitg_ext_ref_action_get_reference ((GitgExtRefAction*) self);
		_tmp3_ = _tmp2_;
		if (ggit_ref_is_branch ((GgitRef*) _tmp3_)) {
			gboolean _tmp4_ = FALSE;
			GitgRef* _tmp5_;
			GitgRef* _tmp6_;
			_tmp5_ = gitg_ext_ref_action_get_reference ((GitgExtRefAction*) self);
			_tmp6_ = _tmp5_;
			_tmp4_ = ggit_branch_is_head (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, ggit_branch_get_type (), GgitBranch), &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
			_tmp1_ = !_tmp4_;
		} else {
			_tmp1_ = FALSE;
		}
		if (_tmp1_) {
			_tmp0_ = TRUE;
		} else {
			GitgRef* _tmp7_;
			GitgRef* _tmp8_;
			_tmp7_ = gitg_ext_ref_action_get_reference ((GitgExtRefAction*) self);
			_tmp8_ = _tmp7_;
			_tmp0_ = ggit_ref_is_remote ((GgitRef*) _tmp8_);
		}
		result = _tmp0_;
		return result;
	}
	goto __finally0;
	__catch0_g_error:
	{
		g_clear_error (&_inner_error0_);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp9_ = FALSE;
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp9_;
	}
	result = FALSE;
	return result;
}

static void
gitg_ref_action_checkout_class_init (GitgRefActionCheckoutClass * klass,
                                     gpointer klass_data)
{
	gitg_ref_action_checkout_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GitgRefActionCheckout_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_gitg_ref_action_checkout_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_gitg_ref_action_checkout_set_property;
	G_OBJECT_CLASS (klass)->finalize = gitg_ref_action_checkout_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_REF_ACTION_CHECKOUT_APPLICATION_PROPERTY, gitg_ref_action_checkout_properties[GITG_REF_ACTION_CHECKOUT_APPLICATION_PROPERTY] = g_param_spec_object ("application", "application", "application", GITG_EXT_TYPE_APPLICATION, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_REF_ACTION_CHECKOUT_ACTION_INTERFACE_PROPERTY, gitg_ref_action_checkout_properties[GITG_REF_ACTION_CHECKOUT_ACTION_INTERFACE_PROPERTY] = g_param_spec_object ("action-interface", "action-interface", "action-interface", GITG_EXT_TYPE_REF_ACTION_INTERFACE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_REF_ACTION_CHECKOUT_REFERENCE_PROPERTY, gitg_ref_action_checkout_properties[GITG_REF_ACTION_CHECKOUT_REFERENCE_PROPERTY] = g_param_spec_object ("reference", "reference", "reference", GITG_TYPE_REF, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_REF_ACTION_CHECKOUT_ID_PROPERTY, gitg_ref_action_checkout_properties[GITG_REF_ACTION_CHECKOUT_ID_PROPERTY] = g_param_spec_string ("id", "id", "id", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_REF_ACTION_CHECKOUT_DISPLAY_NAME_PROPERTY, gitg_ref_action_checkout_properties[GITG_REF_ACTION_CHECKOUT_DISPLAY_NAME_PROPERTY] = g_param_spec_string ("display-name", "display-name", "display-name", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_REF_ACTION_CHECKOUT_DESCRIPTION_PROPERTY, gitg_ref_action_checkout_properties[GITG_REF_ACTION_CHECKOUT_DESCRIPTION_PROPERTY] = g_param_spec_string ("description", "description", "description", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_REF_ACTION_CHECKOUT_ENABLED_PROPERTY, gitg_ref_action_checkout_properties[GITG_REF_ACTION_CHECKOUT_ENABLED_PROPERTY] = g_param_spec_boolean ("enabled", "enabled", "enabled", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
}

static void
gitg_ref_action_checkout_gitg_ext_ui_element_interface_init (GitgExtUIElementIface * iface,
                                                             gpointer iface_data)
{
	gitg_ref_action_checkout_gitg_ext_ui_element_parent_iface = g_type_interface_peek_parent (iface);
	iface->activate = (void (*) (GitgExtUIElement*)) gitg_ref_action_checkout_real_activate;
	iface->get_application = gitg_ref_action_checkout_real_get_application;
	iface->set_application = gitg_ref_action_checkout_real_set_application;
	iface->get_id = gitg_ref_action_checkout_real_get_id;
	iface->get_display_name = gitg_ref_action_checkout_real_get_display_name;
	iface->get_description = gitg_ref_action_checkout_real_get_description;
	iface->get_enabled = gitg_ref_action_checkout_real_get_enabled;
}

static void
gitg_ref_action_checkout_gitg_ext_action_interface_init (GitgExtActionIface * iface,
                                                         gpointer iface_data)
{
	gitg_ref_action_checkout_gitg_ext_action_parent_iface = g_type_interface_peek_parent (iface);
}

static void
gitg_ref_action_checkout_gitg_ext_ref_action_interface_init (GitgExtRefActionIface * iface,
                                                             gpointer iface_data)
{
	gitg_ref_action_checkout_gitg_ext_ref_action_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_action_interface = gitg_ref_action_checkout_real_get_action_interface;
	iface->set_action_interface = gitg_ref_action_checkout_real_set_action_interface;
	iface->get_reference = gitg_ref_action_checkout_real_get_reference;
	iface->set_reference = gitg_ref_action_checkout_real_set_reference;
}

static void
gitg_ref_action_checkout_instance_init (GitgRefActionCheckout * self,
                                        gpointer klass)
{
	self->priv = gitg_ref_action_checkout_get_instance_private (self);
}

static void
gitg_ref_action_checkout_finalize (GObject * obj)
{
	GitgRefActionCheckout * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GITG_TYPE_REF_ACTION_CHECKOUT, GitgRefActionCheckout);
	_g_object_unref0 (self->priv->_application);
	_g_object_unref0 (self->priv->_action_interface);
	_g_object_unref0 (self->priv->_reference);
	G_OBJECT_CLASS (gitg_ref_action_checkout_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
gitg_ref_action_checkout_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GitgRefActionCheckoutClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gitg_ref_action_checkout_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GitgRefActionCheckout), 0, (GInstanceInitFunc) gitg_ref_action_checkout_instance_init, NULL };
	static const GInterfaceInfo gitg_ext_ui_element_info = { (GInterfaceInitFunc) gitg_ref_action_checkout_gitg_ext_ui_element_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	static const GInterfaceInfo gitg_ext_action_info = { (GInterfaceInitFunc) gitg_ref_action_checkout_gitg_ext_action_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	static const GInterfaceInfo gitg_ext_ref_action_info = { (GInterfaceInitFunc) gitg_ref_action_checkout_gitg_ext_ref_action_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType gitg_ref_action_checkout_type_id;
	gitg_ref_action_checkout_type_id = g_type_register_static (G_TYPE_OBJECT, "GitgRefActionCheckout", &g_define_type_info, 0);
	g_type_add_interface_static (gitg_ref_action_checkout_type_id, GITG_EXT_TYPE_UI_ELEMENT, &gitg_ext_ui_element_info);
	g_type_add_interface_static (gitg_ref_action_checkout_type_id, GITG_EXT_TYPE_ACTION, &gitg_ext_action_info);
	g_type_add_interface_static (gitg_ref_action_checkout_type_id, GITG_EXT_TYPE_REF_ACTION, &gitg_ext_ref_action_info);
	GitgRefActionCheckout_private_offset = g_type_add_instance_private (gitg_ref_action_checkout_type_id, sizeof (GitgRefActionCheckoutPrivate));
	return gitg_ref_action_checkout_type_id;
}

GType
gitg_ref_action_checkout_get_type (void)
{
	static gsize gitg_ref_action_checkout_type_id__once = 0;
	if (g_once_init_enter (&gitg_ref_action_checkout_type_id__once)) {
		GType gitg_ref_action_checkout_type_id;
		gitg_ref_action_checkout_type_id = gitg_ref_action_checkout_get_type_once ();
		g_once_init_leave (&gitg_ref_action_checkout_type_id__once, gitg_ref_action_checkout_type_id);
	}
	return gitg_ref_action_checkout_type_id__once;
}

static void
_vala_gitg_ref_action_checkout_get_property (GObject * object,
                                             guint property_id,
                                             GValue * value,
                                             GParamSpec * pspec)
{
	GitgRefActionCheckout * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GITG_TYPE_REF_ACTION_CHECKOUT, GitgRefActionCheckout);
	switch (property_id) {
		case GITG_REF_ACTION_CHECKOUT_APPLICATION_PROPERTY:
		g_value_take_object (value, gitg_ext_ui_element_get_application ((GitgExtUIElement*) self));
		break;
		case GITG_REF_ACTION_CHECKOUT_ACTION_INTERFACE_PROPERTY:
		g_value_set_object (value, gitg_ext_ref_action_get_action_interface ((GitgExtRefAction*) self));
		break;
		case GITG_REF_ACTION_CHECKOUT_REFERENCE_PROPERTY:
		g_value_set_object (value, gitg_ext_ref_action_get_reference ((GitgExtRefAction*) self));
		break;
		case GITG_REF_ACTION_CHECKOUT_ID_PROPERTY:
		g_value_take_string (value, gitg_ext_ui_element_get_id ((GitgExtUIElement*) self));
		break;
		case GITG_REF_ACTION_CHECKOUT_DISPLAY_NAME_PROPERTY:
		g_value_take_string (value, gitg_ext_ui_element_get_display_name ((GitgExtUIElement*) self));
		break;
		case GITG_REF_ACTION_CHECKOUT_DESCRIPTION_PROPERTY:
		g_value_take_string (value, gitg_ext_ui_element_get_description ((GitgExtUIElement*) self));
		break;
		case GITG_REF_ACTION_CHECKOUT_ENABLED_PROPERTY:
		g_value_set_boolean (value, gitg_ext_ui_element_get_enabled ((GitgExtUIElement*) self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_gitg_ref_action_checkout_set_property (GObject * object,
                                             guint property_id,
                                             const GValue * value,
                                             GParamSpec * pspec)
{
	GitgRefActionCheckout * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GITG_TYPE_REF_ACTION_CHECKOUT, GitgRefActionCheckout);
	switch (property_id) {
		case GITG_REF_ACTION_CHECKOUT_APPLICATION_PROPERTY:
		gitg_ext_ui_element_set_application ((GitgExtUIElement*) self, g_value_get_object (value));
		break;
		case GITG_REF_ACTION_CHECKOUT_ACTION_INTERFACE_PROPERTY:
		gitg_ext_ref_action_set_action_interface ((GitgExtRefAction*) self, g_value_get_object (value));
		break;
		case GITG_REF_ACTION_CHECKOUT_REFERENCE_PROPERTY:
		gitg_ext_ref_action_set_reference ((GitgExtRefAction*) self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

