// Copyright (C) 2018 The Android Open Source Project
// Copyright (C) 2018 Google Inc.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Autogenerated module goldfish_vk_dispatch
//
// (impl) generated by codegen/vulkan/vulkan-docs/scripts/genvk.py -registry
// codegen/vulkan/vulkan-docs/xml/vk.xml -registryGfxstream
// codegen/vulkan/vulkan-docs/xml/vk_gfxstream.xml cereal -o host/vulkan/cereal
//
// Please do not modify directly;
// re-run gfxstream-protocols/scripts/generate-vulkan-sources.sh,
// or directly from Python by defining:
// VULKAN_REGISTRY_XML_DIR : Directory containing vk.xml
// VULKAN_REGISTRY_SCRIPTS_DIR : Directory containing genvk.py
// CEREAL_OUTPUT_DIR: Where to put the generated sources.
//
// python3 $VULKAN_REGISTRY_SCRIPTS_DIR/genvk.py -registry $VULKAN_REGISTRY_XML_DIR/vk.xml cereal -o
// $CEREAL_OUTPUT_DIR
//

#include "goldfish_vk_dispatch.h"

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

namespace gfxstream {
namespace vk {

#ifdef VK_VERSION_1_0
#endif
#ifdef VK_VERSION_1_1
#endif
#ifdef VK_VERSION_1_2
#endif
#ifdef VK_VERSION_1_3
#endif
#ifdef VK_KHR_surface
#endif
#ifdef VK_KHR_swapchain
#endif
#ifdef VK_KHR_xcb_surface
#endif
#ifdef VK_KHR_android_surface
#endif
#ifdef VK_KHR_win32_surface
#endif
#ifdef VK_KHR_dynamic_rendering
#endif
#ifdef VK_KHR_get_physical_device_properties2
#endif
#ifdef VK_KHR_maintenance1
#endif
#ifdef VK_KHR_external_memory_capabilities
#endif
#ifdef VK_KHR_external_memory
#endif
#ifdef VK_KHR_external_memory_win32
#endif
#ifdef VK_KHR_external_memory_fd
#endif
#ifdef VK_KHR_external_semaphore_capabilities
#endif
#ifdef VK_KHR_external_semaphore
#endif
#ifdef VK_KHR_external_semaphore_win32
#endif
#ifdef VK_KHR_external_semaphore_fd
#endif
#ifdef VK_KHR_shader_float16_int8
#endif
#ifdef VK_KHR_incremental_present
#endif
#ifdef VK_KHR_descriptor_update_template
#endif
#ifdef VK_KHR_imageless_framebuffer
#endif
#ifdef VK_KHR_create_renderpass2
#endif
#ifdef VK_KHR_external_fence_capabilities
#endif
#ifdef VK_KHR_external_fence
#endif
#ifdef VK_KHR_external_fence_fd
#endif
#ifdef VK_KHR_maintenance2
#endif
#ifdef VK_KHR_dedicated_allocation
#endif
#ifdef VK_KHR_storage_buffer_storage_class
#endif
#ifdef VK_KHR_get_memory_requirements2
#endif
#ifdef VK_KHR_image_format_list
#endif
#ifdef VK_KHR_sampler_ycbcr_conversion
#endif
#ifdef VK_KHR_bind_memory2
#endif
#ifdef VK_KHR_maintenance3
#endif
#ifdef VK_KHR_shader_subgroup_extended_types
#endif
#ifdef VK_KHR_vulkan_memory_model
#endif
#ifdef VK_KHR_shader_terminate_invocation
#endif
#ifdef VK_KHR_buffer_device_address
#endif
#ifdef VK_KHR_pipeline_executable_properties
#endif
#ifdef VK_KHR_shader_integer_dot_product
#endif
#ifdef VK_KHR_shader_non_semantic_info
#endif
#ifdef VK_KHR_synchronization2
#endif
#ifdef VK_KHR_zero_initialize_workgroup_memory
#endif
#ifdef VK_KHR_copy_commands2
#endif
#ifdef VK_KHR_format_feature_flags2
#endif
#ifdef VK_KHR_maintenance4
#endif
#ifdef VK_ANDROID_native_buffer
#endif
#ifdef VK_EXT_transform_feedback
#endif
#ifdef VK_AMD_gpu_shader_half_float
#endif
#ifdef VK_EXT_texture_compression_astc_hdr
#endif
#ifdef VK_EXT_swapchain_colorspace
#endif
#ifdef VK_EXT_queue_family_foreign
#endif
#ifdef VK_EXT_debug_utils
#endif
#ifdef VK_ANDROID_external_memory_android_hardware_buffer
#endif
#ifdef VK_EXT_inline_uniform_block
#endif
#ifdef VK_EXT_shader_stencil_export
#endif
#ifdef VK_EXT_pipeline_creation_feedback
#endif
#ifdef VK_NV_shader_subgroup_partitioned
#endif
#ifdef VK_EXT_metal_surface
#endif
#ifdef VK_EXT_subgroup_size_control
#endif
#ifdef VK_EXT_tooling_info
#endif
#ifdef VK_EXT_provoking_vertex
#endif
#ifdef VK_EXT_line_rasterization
#endif
#ifdef VK_EXT_index_type_uint8
#endif
#ifdef VK_EXT_extended_dynamic_state
#endif
#ifdef VK_EXT_swapchain_maintenance1
#endif
#ifdef VK_EXT_shader_demote_to_helper_invocation
#endif
#ifdef VK_EXT_texel_buffer_alignment
#endif
#ifdef VK_EXT_device_memory_report
#endif
#ifdef VK_EXT_custom_border_color
#endif
#ifdef VK_EXT_private_data
#endif
#ifdef VK_EXT_pipeline_creation_cache_control
#endif
#ifdef VK_EXT_ycbcr_2plane_444_formats
#endif
#ifdef VK_EXT_image_robustness
#endif
#ifdef VK_EXT_image_compression_control
#endif
#ifdef VK_EXT_4444_formats
#endif
#ifdef VK_EXT_primitive_topology_list_restart
#endif
#ifdef VK_EXT_extended_dynamic_state2
#endif
#ifdef VK_GOOGLE_gfxstream
#endif
#ifdef VK_EXT_load_store_op_none
#endif
#ifdef VK_EXT_image_compression_control_swapchain
#endif

void init_vulkan_dispatch_from_system_loader(DlOpenFunc dlOpenFunc, DlSymFunc dlSymFunc,
                                             VulkanDispatch* out) {
    memset(out, 0x0, sizeof(VulkanDispatch));
    void* lib = dlOpenFunc();
    if (!lib) return;
#ifdef VK_VERSION_1_0
    out->vkDestroyInstance = (PFN_vkDestroyInstance)dlSymFunc(lib, "vkDestroyInstance");
    out->vkEnumeratePhysicalDevices =
        (PFN_vkEnumeratePhysicalDevices)dlSymFunc(lib, "vkEnumeratePhysicalDevices");
    out->vkGetPhysicalDeviceFeatures =
        (PFN_vkGetPhysicalDeviceFeatures)dlSymFunc(lib, "vkGetPhysicalDeviceFeatures");
    out->vkGetPhysicalDeviceFormatProperties = (PFN_vkGetPhysicalDeviceFormatProperties)dlSymFunc(
        lib, "vkGetPhysicalDeviceFormatProperties");
    out->vkGetPhysicalDeviceImageFormatProperties =
        (PFN_vkGetPhysicalDeviceImageFormatProperties)dlSymFunc(
            lib, "vkGetPhysicalDeviceImageFormatProperties");
    out->vkGetPhysicalDeviceProperties =
        (PFN_vkGetPhysicalDeviceProperties)dlSymFunc(lib, "vkGetPhysicalDeviceProperties");
    out->vkGetPhysicalDeviceQueueFamilyProperties =
        (PFN_vkGetPhysicalDeviceQueueFamilyProperties)dlSymFunc(
            lib, "vkGetPhysicalDeviceQueueFamilyProperties");
    out->vkGetPhysicalDeviceMemoryProperties = (PFN_vkGetPhysicalDeviceMemoryProperties)dlSymFunc(
        lib, "vkGetPhysicalDeviceMemoryProperties");
    out->vkGetInstanceProcAddr = (PFN_vkGetInstanceProcAddr)dlSymFunc(lib, "vkGetInstanceProcAddr");
    out->vkCreateDevice = (PFN_vkCreateDevice)dlSymFunc(lib, "vkCreateDevice");
    out->vkDestroyDevice = (PFN_vkDestroyDevice)dlSymFunc(lib, "vkDestroyDevice");
    out->vkEnumerateDeviceExtensionProperties = (PFN_vkEnumerateDeviceExtensionProperties)dlSymFunc(
        lib, "vkEnumerateDeviceExtensionProperties");
    out->vkEnumerateDeviceLayerProperties =
        (PFN_vkEnumerateDeviceLayerProperties)dlSymFunc(lib, "vkEnumerateDeviceLayerProperties");
    out->vkCreateInstance = (PFN_vkCreateInstance)dlSymFunc(lib, "vkCreateInstance");
    out->vkEnumerateInstanceExtensionProperties =
        (PFN_vkEnumerateInstanceExtensionProperties)dlSymFunc(
            lib, "vkEnumerateInstanceExtensionProperties");
    out->vkEnumerateInstanceLayerProperties = (PFN_vkEnumerateInstanceLayerProperties)dlSymFunc(
        lib, "vkEnumerateInstanceLayerProperties");
    out->vkGetDeviceProcAddr = (PFN_vkGetDeviceProcAddr)dlSymFunc(lib, "vkGetDeviceProcAddr");
    out->vkGetPhysicalDeviceSparseImageFormatProperties =
        (PFN_vkGetPhysicalDeviceSparseImageFormatProperties)dlSymFunc(
            lib, "vkGetPhysicalDeviceSparseImageFormatProperties");
#endif
#ifdef VK_VERSION_1_1
    out->vkEnumerateInstanceVersion =
        (PFN_vkEnumerateInstanceVersion)dlSymFunc(lib, "vkEnumerateInstanceVersion");
    out->vkEnumeratePhysicalDeviceGroups =
        (PFN_vkEnumeratePhysicalDeviceGroups)dlSymFunc(lib, "vkEnumeratePhysicalDeviceGroups");
    out->vkGetPhysicalDeviceFeatures2 =
        (PFN_vkGetPhysicalDeviceFeatures2)dlSymFunc(lib, "vkGetPhysicalDeviceFeatures2");
    out->vkGetPhysicalDeviceProperties2 =
        (PFN_vkGetPhysicalDeviceProperties2)dlSymFunc(lib, "vkGetPhysicalDeviceProperties2");
    out->vkGetPhysicalDeviceFormatProperties2 = (PFN_vkGetPhysicalDeviceFormatProperties2)dlSymFunc(
        lib, "vkGetPhysicalDeviceFormatProperties2");
    out->vkGetPhysicalDeviceImageFormatProperties2 =
        (PFN_vkGetPhysicalDeviceImageFormatProperties2)dlSymFunc(
            lib, "vkGetPhysicalDeviceImageFormatProperties2");
    out->vkGetPhysicalDeviceQueueFamilyProperties2 =
        (PFN_vkGetPhysicalDeviceQueueFamilyProperties2)dlSymFunc(
            lib, "vkGetPhysicalDeviceQueueFamilyProperties2");
    out->vkGetPhysicalDeviceMemoryProperties2 = (PFN_vkGetPhysicalDeviceMemoryProperties2)dlSymFunc(
        lib, "vkGetPhysicalDeviceMemoryProperties2");
    out->vkGetPhysicalDeviceSparseImageFormatProperties2 =
        (PFN_vkGetPhysicalDeviceSparseImageFormatProperties2)dlSymFunc(
            lib, "vkGetPhysicalDeviceSparseImageFormatProperties2");
    out->vkGetPhysicalDeviceExternalBufferProperties =
        (PFN_vkGetPhysicalDeviceExternalBufferProperties)dlSymFunc(
            lib, "vkGetPhysicalDeviceExternalBufferProperties");
    out->vkGetPhysicalDeviceExternalFenceProperties =
        (PFN_vkGetPhysicalDeviceExternalFenceProperties)dlSymFunc(
            lib, "vkGetPhysicalDeviceExternalFenceProperties");
    out->vkGetPhysicalDeviceExternalSemaphoreProperties =
        (PFN_vkGetPhysicalDeviceExternalSemaphoreProperties)dlSymFunc(
            lib, "vkGetPhysicalDeviceExternalSemaphoreProperties");
#endif
#ifdef VK_KHR_surface
    out->vkDestroySurfaceKHR = (PFN_vkDestroySurfaceKHR)dlSymFunc(lib, "vkDestroySurfaceKHR");
#endif
#ifdef VK_KHR_swapchain
    out->vkCreateSwapchainKHR = (PFN_vkCreateSwapchainKHR)dlSymFunc(lib, "vkCreateSwapchainKHR");
    out->vkDestroySwapchainKHR = (PFN_vkDestroySwapchainKHR)dlSymFunc(lib, "vkDestroySwapchainKHR");
    out->vkGetSwapchainImagesKHR =
        (PFN_vkGetSwapchainImagesKHR)dlSymFunc(lib, "vkGetSwapchainImagesKHR");
    out->vkAcquireNextImageKHR = (PFN_vkAcquireNextImageKHR)dlSymFunc(lib, "vkAcquireNextImageKHR");
    out->vkQueuePresentKHR = (PFN_vkQueuePresentKHR)dlSymFunc(lib, "vkQueuePresentKHR");
#endif
#ifdef VK_KHR_xcb_surface
    out->vkCreateXcbSurfaceKHR = (PFN_vkCreateXcbSurfaceKHR)dlSymFunc(lib, "vkCreateXcbSurfaceKHR");
    out->vkGetPhysicalDeviceXcbPresentationSupportKHR =
        (PFN_vkGetPhysicalDeviceXcbPresentationSupportKHR)dlSymFunc(
            lib, "vkGetPhysicalDeviceXcbPresentationSupportKHR");
#endif
#ifdef VK_KHR_win32_surface
    out->vkCreateWin32SurfaceKHR =
        (PFN_vkCreateWin32SurfaceKHR)dlSymFunc(lib, "vkCreateWin32SurfaceKHR");
    out->vkGetPhysicalDeviceWin32PresentationSupportKHR =
        (PFN_vkGetPhysicalDeviceWin32PresentationSupportKHR)dlSymFunc(
            lib, "vkGetPhysicalDeviceWin32PresentationSupportKHR");
#endif
#ifdef VK_EXT_debug_utils
    out->vkCreateDebugUtilsMessengerEXT =
        (PFN_vkCreateDebugUtilsMessengerEXT)dlSymFunc(lib, "vkCreateDebugUtilsMessengerEXT");
    out->vkDestroyDebugUtilsMessengerEXT =
        (PFN_vkDestroyDebugUtilsMessengerEXT)dlSymFunc(lib, "vkDestroyDebugUtilsMessengerEXT");
    out->vkSubmitDebugUtilsMessageEXT =
        (PFN_vkSubmitDebugUtilsMessageEXT)dlSymFunc(lib, "vkSubmitDebugUtilsMessageEXT");
#endif
#ifdef VK_EXT_metal_surface
    out->vkCreateMetalSurfaceEXT =
        (PFN_vkCreateMetalSurfaceEXT)dlSymFunc(lib, "vkCreateMetalSurfaceEXT");
#endif
#ifdef VK_VERSION_1_0
    out->vkGetDeviceQueue = (PFN_vkGetDeviceQueue)dlSymFunc(lib, "vkGetDeviceQueue");
    out->vkQueueSubmit = (PFN_vkQueueSubmit)dlSymFunc(lib, "vkQueueSubmit");
    out->vkQueueWaitIdle = (PFN_vkQueueWaitIdle)dlSymFunc(lib, "vkQueueWaitIdle");
    out->vkDeviceWaitIdle = (PFN_vkDeviceWaitIdle)dlSymFunc(lib, "vkDeviceWaitIdle");
    out->vkAllocateMemory = (PFN_vkAllocateMemory)dlSymFunc(lib, "vkAllocateMemory");
    out->vkFreeMemory = (PFN_vkFreeMemory)dlSymFunc(lib, "vkFreeMemory");
    out->vkMapMemory = (PFN_vkMapMemory)dlSymFunc(lib, "vkMapMemory");
    out->vkUnmapMemory = (PFN_vkUnmapMemory)dlSymFunc(lib, "vkUnmapMemory");
    out->vkFlushMappedMemoryRanges =
        (PFN_vkFlushMappedMemoryRanges)dlSymFunc(lib, "vkFlushMappedMemoryRanges");
    out->vkInvalidateMappedMemoryRanges =
        (PFN_vkInvalidateMappedMemoryRanges)dlSymFunc(lib, "vkInvalidateMappedMemoryRanges");
    out->vkGetDeviceMemoryCommitment =
        (PFN_vkGetDeviceMemoryCommitment)dlSymFunc(lib, "vkGetDeviceMemoryCommitment");
    out->vkBindBufferMemory = (PFN_vkBindBufferMemory)dlSymFunc(lib, "vkBindBufferMemory");
    out->vkBindImageMemory = (PFN_vkBindImageMemory)dlSymFunc(lib, "vkBindImageMemory");
    out->vkGetBufferMemoryRequirements =
        (PFN_vkGetBufferMemoryRequirements)dlSymFunc(lib, "vkGetBufferMemoryRequirements");
    out->vkGetImageMemoryRequirements =
        (PFN_vkGetImageMemoryRequirements)dlSymFunc(lib, "vkGetImageMemoryRequirements");
    out->vkGetImageSparseMemoryRequirements = (PFN_vkGetImageSparseMemoryRequirements)dlSymFunc(
        lib, "vkGetImageSparseMemoryRequirements");
    out->vkQueueBindSparse = (PFN_vkQueueBindSparse)dlSymFunc(lib, "vkQueueBindSparse");
    out->vkCreateFence = (PFN_vkCreateFence)dlSymFunc(lib, "vkCreateFence");
    out->vkDestroyFence = (PFN_vkDestroyFence)dlSymFunc(lib, "vkDestroyFence");
    out->vkResetFences = (PFN_vkResetFences)dlSymFunc(lib, "vkResetFences");
    out->vkGetFenceStatus = (PFN_vkGetFenceStatus)dlSymFunc(lib, "vkGetFenceStatus");
    out->vkWaitForFences = (PFN_vkWaitForFences)dlSymFunc(lib, "vkWaitForFences");
    out->vkCreateSemaphore = (PFN_vkCreateSemaphore)dlSymFunc(lib, "vkCreateSemaphore");
    out->vkDestroySemaphore = (PFN_vkDestroySemaphore)dlSymFunc(lib, "vkDestroySemaphore");
    out->vkCreateEvent = (PFN_vkCreateEvent)dlSymFunc(lib, "vkCreateEvent");
    out->vkDestroyEvent = (PFN_vkDestroyEvent)dlSymFunc(lib, "vkDestroyEvent");
    out->vkGetEventStatus = (PFN_vkGetEventStatus)dlSymFunc(lib, "vkGetEventStatus");
    out->vkSetEvent = (PFN_vkSetEvent)dlSymFunc(lib, "vkSetEvent");
    out->vkResetEvent = (PFN_vkResetEvent)dlSymFunc(lib, "vkResetEvent");
    out->vkCreateQueryPool = (PFN_vkCreateQueryPool)dlSymFunc(lib, "vkCreateQueryPool");
    out->vkDestroyQueryPool = (PFN_vkDestroyQueryPool)dlSymFunc(lib, "vkDestroyQueryPool");
    out->vkGetQueryPoolResults = (PFN_vkGetQueryPoolResults)dlSymFunc(lib, "vkGetQueryPoolResults");
    out->vkCreateBuffer = (PFN_vkCreateBuffer)dlSymFunc(lib, "vkCreateBuffer");
    out->vkDestroyBuffer = (PFN_vkDestroyBuffer)dlSymFunc(lib, "vkDestroyBuffer");
    out->vkCreateBufferView = (PFN_vkCreateBufferView)dlSymFunc(lib, "vkCreateBufferView");
    out->vkDestroyBufferView = (PFN_vkDestroyBufferView)dlSymFunc(lib, "vkDestroyBufferView");
    out->vkCreateImage = (PFN_vkCreateImage)dlSymFunc(lib, "vkCreateImage");
    out->vkDestroyImage = (PFN_vkDestroyImage)dlSymFunc(lib, "vkDestroyImage");
    out->vkGetImageSubresourceLayout =
        (PFN_vkGetImageSubresourceLayout)dlSymFunc(lib, "vkGetImageSubresourceLayout");
    out->vkCreateImageView = (PFN_vkCreateImageView)dlSymFunc(lib, "vkCreateImageView");
    out->vkDestroyImageView = (PFN_vkDestroyImageView)dlSymFunc(lib, "vkDestroyImageView");
    out->vkCreateShaderModule = (PFN_vkCreateShaderModule)dlSymFunc(lib, "vkCreateShaderModule");
    out->vkDestroyShaderModule = (PFN_vkDestroyShaderModule)dlSymFunc(lib, "vkDestroyShaderModule");
    out->vkCreatePipelineCache = (PFN_vkCreatePipelineCache)dlSymFunc(lib, "vkCreatePipelineCache");
    out->vkDestroyPipelineCache =
        (PFN_vkDestroyPipelineCache)dlSymFunc(lib, "vkDestroyPipelineCache");
    out->vkGetPipelineCacheData =
        (PFN_vkGetPipelineCacheData)dlSymFunc(lib, "vkGetPipelineCacheData");
    out->vkMergePipelineCaches = (PFN_vkMergePipelineCaches)dlSymFunc(lib, "vkMergePipelineCaches");
    out->vkCreateGraphicsPipelines =
        (PFN_vkCreateGraphicsPipelines)dlSymFunc(lib, "vkCreateGraphicsPipelines");
    out->vkCreateComputePipelines =
        (PFN_vkCreateComputePipelines)dlSymFunc(lib, "vkCreateComputePipelines");
    out->vkDestroyPipeline = (PFN_vkDestroyPipeline)dlSymFunc(lib, "vkDestroyPipeline");
    out->vkCreatePipelineLayout =
        (PFN_vkCreatePipelineLayout)dlSymFunc(lib, "vkCreatePipelineLayout");
    out->vkDestroyPipelineLayout =
        (PFN_vkDestroyPipelineLayout)dlSymFunc(lib, "vkDestroyPipelineLayout");
    out->vkCreateSampler = (PFN_vkCreateSampler)dlSymFunc(lib, "vkCreateSampler");
    out->vkDestroySampler = (PFN_vkDestroySampler)dlSymFunc(lib, "vkDestroySampler");
    out->vkCreateDescriptorSetLayout =
        (PFN_vkCreateDescriptorSetLayout)dlSymFunc(lib, "vkCreateDescriptorSetLayout");
    out->vkDestroyDescriptorSetLayout =
        (PFN_vkDestroyDescriptorSetLayout)dlSymFunc(lib, "vkDestroyDescriptorSetLayout");
    out->vkCreateDescriptorPool =
        (PFN_vkCreateDescriptorPool)dlSymFunc(lib, "vkCreateDescriptorPool");
    out->vkDestroyDescriptorPool =
        (PFN_vkDestroyDescriptorPool)dlSymFunc(lib, "vkDestroyDescriptorPool");
    out->vkResetDescriptorPool = (PFN_vkResetDescriptorPool)dlSymFunc(lib, "vkResetDescriptorPool");
    out->vkAllocateDescriptorSets =
        (PFN_vkAllocateDescriptorSets)dlSymFunc(lib, "vkAllocateDescriptorSets");
    out->vkFreeDescriptorSets = (PFN_vkFreeDescriptorSets)dlSymFunc(lib, "vkFreeDescriptorSets");
    out->vkUpdateDescriptorSets =
        (PFN_vkUpdateDescriptorSets)dlSymFunc(lib, "vkUpdateDescriptorSets");
    out->vkCreateFramebuffer = (PFN_vkCreateFramebuffer)dlSymFunc(lib, "vkCreateFramebuffer");
    out->vkDestroyFramebuffer = (PFN_vkDestroyFramebuffer)dlSymFunc(lib, "vkDestroyFramebuffer");
    out->vkCreateRenderPass = (PFN_vkCreateRenderPass)dlSymFunc(lib, "vkCreateRenderPass");
    out->vkDestroyRenderPass = (PFN_vkDestroyRenderPass)dlSymFunc(lib, "vkDestroyRenderPass");
    out->vkGetRenderAreaGranularity =
        (PFN_vkGetRenderAreaGranularity)dlSymFunc(lib, "vkGetRenderAreaGranularity");
    out->vkCreateCommandPool = (PFN_vkCreateCommandPool)dlSymFunc(lib, "vkCreateCommandPool");
    out->vkDestroyCommandPool = (PFN_vkDestroyCommandPool)dlSymFunc(lib, "vkDestroyCommandPool");
    out->vkResetCommandPool = (PFN_vkResetCommandPool)dlSymFunc(lib, "vkResetCommandPool");
    out->vkAllocateCommandBuffers =
        (PFN_vkAllocateCommandBuffers)dlSymFunc(lib, "vkAllocateCommandBuffers");
    out->vkFreeCommandBuffers = (PFN_vkFreeCommandBuffers)dlSymFunc(lib, "vkFreeCommandBuffers");
    out->vkBeginCommandBuffer = (PFN_vkBeginCommandBuffer)dlSymFunc(lib, "vkBeginCommandBuffer");
    out->vkEndCommandBuffer = (PFN_vkEndCommandBuffer)dlSymFunc(lib, "vkEndCommandBuffer");
    out->vkResetCommandBuffer = (PFN_vkResetCommandBuffer)dlSymFunc(lib, "vkResetCommandBuffer");
    out->vkCmdBindPipeline = (PFN_vkCmdBindPipeline)dlSymFunc(lib, "vkCmdBindPipeline");
    out->vkCmdSetViewport = (PFN_vkCmdSetViewport)dlSymFunc(lib, "vkCmdSetViewport");
    out->vkCmdSetScissor = (PFN_vkCmdSetScissor)dlSymFunc(lib, "vkCmdSetScissor");
    out->vkCmdSetLineWidth = (PFN_vkCmdSetLineWidth)dlSymFunc(lib, "vkCmdSetLineWidth");
    out->vkCmdSetDepthBias = (PFN_vkCmdSetDepthBias)dlSymFunc(lib, "vkCmdSetDepthBias");
    out->vkCmdSetBlendConstants =
        (PFN_vkCmdSetBlendConstants)dlSymFunc(lib, "vkCmdSetBlendConstants");
    out->vkCmdSetDepthBounds = (PFN_vkCmdSetDepthBounds)dlSymFunc(lib, "vkCmdSetDepthBounds");
    out->vkCmdSetStencilCompareMask =
        (PFN_vkCmdSetStencilCompareMask)dlSymFunc(lib, "vkCmdSetStencilCompareMask");
    out->vkCmdSetStencilWriteMask =
        (PFN_vkCmdSetStencilWriteMask)dlSymFunc(lib, "vkCmdSetStencilWriteMask");
    out->vkCmdSetStencilReference =
        (PFN_vkCmdSetStencilReference)dlSymFunc(lib, "vkCmdSetStencilReference");
    out->vkCmdBindDescriptorSets =
        (PFN_vkCmdBindDescriptorSets)dlSymFunc(lib, "vkCmdBindDescriptorSets");
    out->vkCmdBindIndexBuffer = (PFN_vkCmdBindIndexBuffer)dlSymFunc(lib, "vkCmdBindIndexBuffer");
    out->vkCmdBindVertexBuffers =
        (PFN_vkCmdBindVertexBuffers)dlSymFunc(lib, "vkCmdBindVertexBuffers");
    out->vkCmdDraw = (PFN_vkCmdDraw)dlSymFunc(lib, "vkCmdDraw");
    out->vkCmdDrawIndexed = (PFN_vkCmdDrawIndexed)dlSymFunc(lib, "vkCmdDrawIndexed");
    out->vkCmdDrawIndirect = (PFN_vkCmdDrawIndirect)dlSymFunc(lib, "vkCmdDrawIndirect");
    out->vkCmdDrawIndexedIndirect =
        (PFN_vkCmdDrawIndexedIndirect)dlSymFunc(lib, "vkCmdDrawIndexedIndirect");
    out->vkCmdDispatch = (PFN_vkCmdDispatch)dlSymFunc(lib, "vkCmdDispatch");
    out->vkCmdDispatchIndirect = (PFN_vkCmdDispatchIndirect)dlSymFunc(lib, "vkCmdDispatchIndirect");
    out->vkCmdCopyBuffer = (PFN_vkCmdCopyBuffer)dlSymFunc(lib, "vkCmdCopyBuffer");
    out->vkCmdCopyImage = (PFN_vkCmdCopyImage)dlSymFunc(lib, "vkCmdCopyImage");
    out->vkCmdBlitImage = (PFN_vkCmdBlitImage)dlSymFunc(lib, "vkCmdBlitImage");
    out->vkCmdCopyBufferToImage =
        (PFN_vkCmdCopyBufferToImage)dlSymFunc(lib, "vkCmdCopyBufferToImage");
    out->vkCmdCopyImageToBuffer =
        (PFN_vkCmdCopyImageToBuffer)dlSymFunc(lib, "vkCmdCopyImageToBuffer");
    out->vkCmdUpdateBuffer = (PFN_vkCmdUpdateBuffer)dlSymFunc(lib, "vkCmdUpdateBuffer");
    out->vkCmdFillBuffer = (PFN_vkCmdFillBuffer)dlSymFunc(lib, "vkCmdFillBuffer");
    out->vkCmdClearColorImage = (PFN_vkCmdClearColorImage)dlSymFunc(lib, "vkCmdClearColorImage");
    out->vkCmdClearDepthStencilImage =
        (PFN_vkCmdClearDepthStencilImage)dlSymFunc(lib, "vkCmdClearDepthStencilImage");
    out->vkCmdClearAttachments = (PFN_vkCmdClearAttachments)dlSymFunc(lib, "vkCmdClearAttachments");
    out->vkCmdResolveImage = (PFN_vkCmdResolveImage)dlSymFunc(lib, "vkCmdResolveImage");
    out->vkCmdSetEvent = (PFN_vkCmdSetEvent)dlSymFunc(lib, "vkCmdSetEvent");
    out->vkCmdResetEvent = (PFN_vkCmdResetEvent)dlSymFunc(lib, "vkCmdResetEvent");
    out->vkCmdWaitEvents = (PFN_vkCmdWaitEvents)dlSymFunc(lib, "vkCmdWaitEvents");
    out->vkCmdPipelineBarrier = (PFN_vkCmdPipelineBarrier)dlSymFunc(lib, "vkCmdPipelineBarrier");
    out->vkCmdBeginQuery = (PFN_vkCmdBeginQuery)dlSymFunc(lib, "vkCmdBeginQuery");
    out->vkCmdEndQuery = (PFN_vkCmdEndQuery)dlSymFunc(lib, "vkCmdEndQuery");
    out->vkCmdResetQueryPool = (PFN_vkCmdResetQueryPool)dlSymFunc(lib, "vkCmdResetQueryPool");
    out->vkCmdWriteTimestamp = (PFN_vkCmdWriteTimestamp)dlSymFunc(lib, "vkCmdWriteTimestamp");
    out->vkCmdCopyQueryPoolResults =
        (PFN_vkCmdCopyQueryPoolResults)dlSymFunc(lib, "vkCmdCopyQueryPoolResults");
    out->vkCmdPushConstants = (PFN_vkCmdPushConstants)dlSymFunc(lib, "vkCmdPushConstants");
    out->vkCmdBeginRenderPass = (PFN_vkCmdBeginRenderPass)dlSymFunc(lib, "vkCmdBeginRenderPass");
    out->vkCmdNextSubpass = (PFN_vkCmdNextSubpass)dlSymFunc(lib, "vkCmdNextSubpass");
    out->vkCmdEndRenderPass = (PFN_vkCmdEndRenderPass)dlSymFunc(lib, "vkCmdEndRenderPass");
    out->vkCmdExecuteCommands = (PFN_vkCmdExecuteCommands)dlSymFunc(lib, "vkCmdExecuteCommands");
#endif
#ifdef VK_VERSION_1_1
    out->vkBindBufferMemory2 = (PFN_vkBindBufferMemory2)dlSymFunc(lib, "vkBindBufferMemory2");
    out->vkBindImageMemory2 = (PFN_vkBindImageMemory2)dlSymFunc(lib, "vkBindImageMemory2");
    out->vkGetDeviceGroupPeerMemoryFeatures = (PFN_vkGetDeviceGroupPeerMemoryFeatures)dlSymFunc(
        lib, "vkGetDeviceGroupPeerMemoryFeatures");
    out->vkCmdSetDeviceMask = (PFN_vkCmdSetDeviceMask)dlSymFunc(lib, "vkCmdSetDeviceMask");
    out->vkCmdDispatchBase = (PFN_vkCmdDispatchBase)dlSymFunc(lib, "vkCmdDispatchBase");
    out->vkGetImageMemoryRequirements2 =
        (PFN_vkGetImageMemoryRequirements2)dlSymFunc(lib, "vkGetImageMemoryRequirements2");
    out->vkGetBufferMemoryRequirements2 =
        (PFN_vkGetBufferMemoryRequirements2)dlSymFunc(lib, "vkGetBufferMemoryRequirements2");
    out->vkGetImageSparseMemoryRequirements2 = (PFN_vkGetImageSparseMemoryRequirements2)dlSymFunc(
        lib, "vkGetImageSparseMemoryRequirements2");
    out->vkTrimCommandPool = (PFN_vkTrimCommandPool)dlSymFunc(lib, "vkTrimCommandPool");
    out->vkGetDeviceQueue2 = (PFN_vkGetDeviceQueue2)dlSymFunc(lib, "vkGetDeviceQueue2");
    out->vkCreateSamplerYcbcrConversion =
        (PFN_vkCreateSamplerYcbcrConversion)dlSymFunc(lib, "vkCreateSamplerYcbcrConversion");
    out->vkDestroySamplerYcbcrConversion =
        (PFN_vkDestroySamplerYcbcrConversion)dlSymFunc(lib, "vkDestroySamplerYcbcrConversion");
    out->vkCreateDescriptorUpdateTemplate =
        (PFN_vkCreateDescriptorUpdateTemplate)dlSymFunc(lib, "vkCreateDescriptorUpdateTemplate");
    out->vkDestroyDescriptorUpdateTemplate =
        (PFN_vkDestroyDescriptorUpdateTemplate)dlSymFunc(lib, "vkDestroyDescriptorUpdateTemplate");
    out->vkUpdateDescriptorSetWithTemplate =
        (PFN_vkUpdateDescriptorSetWithTemplate)dlSymFunc(lib, "vkUpdateDescriptorSetWithTemplate");
    out->vkGetDescriptorSetLayoutSupport =
        (PFN_vkGetDescriptorSetLayoutSupport)dlSymFunc(lib, "vkGetDescriptorSetLayoutSupport");
#endif
#ifdef VK_VERSION_1_2
    out->vkCmdDrawIndirectCount =
        (PFN_vkCmdDrawIndirectCount)dlSymFunc(lib, "vkCmdDrawIndirectCount");
    out->vkCmdDrawIndexedIndirectCount =
        (PFN_vkCmdDrawIndexedIndirectCount)dlSymFunc(lib, "vkCmdDrawIndexedIndirectCount");
    out->vkCreateRenderPass2 = (PFN_vkCreateRenderPass2)dlSymFunc(lib, "vkCreateRenderPass2");
    out->vkCmdBeginRenderPass2 = (PFN_vkCmdBeginRenderPass2)dlSymFunc(lib, "vkCmdBeginRenderPass2");
    out->vkCmdNextSubpass2 = (PFN_vkCmdNextSubpass2)dlSymFunc(lib, "vkCmdNextSubpass2");
    out->vkCmdEndRenderPass2 = (PFN_vkCmdEndRenderPass2)dlSymFunc(lib, "vkCmdEndRenderPass2");
    out->vkResetQueryPool = (PFN_vkResetQueryPool)dlSymFunc(lib, "vkResetQueryPool");
    out->vkGetSemaphoreCounterValue =
        (PFN_vkGetSemaphoreCounterValue)dlSymFunc(lib, "vkGetSemaphoreCounterValue");
    out->vkWaitSemaphores = (PFN_vkWaitSemaphores)dlSymFunc(lib, "vkWaitSemaphores");
    out->vkSignalSemaphore = (PFN_vkSignalSemaphore)dlSymFunc(lib, "vkSignalSemaphore");
    out->vkGetBufferDeviceAddress =
        (PFN_vkGetBufferDeviceAddress)dlSymFunc(lib, "vkGetBufferDeviceAddress");
    out->vkGetBufferOpaqueCaptureAddress =
        (PFN_vkGetBufferOpaqueCaptureAddress)dlSymFunc(lib, "vkGetBufferOpaqueCaptureAddress");
    out->vkGetDeviceMemoryOpaqueCaptureAddress =
        (PFN_vkGetDeviceMemoryOpaqueCaptureAddress)dlSymFunc(
            lib, "vkGetDeviceMemoryOpaqueCaptureAddress");
#endif
#ifdef VK_VERSION_1_3
    out->vkGetPhysicalDeviceToolProperties =
        (PFN_vkGetPhysicalDeviceToolProperties)dlSymFunc(lib, "vkGetPhysicalDeviceToolProperties");
    out->vkCreatePrivateDataSlot =
        (PFN_vkCreatePrivateDataSlot)dlSymFunc(lib, "vkCreatePrivateDataSlot");
    out->vkDestroyPrivateDataSlot =
        (PFN_vkDestroyPrivateDataSlot)dlSymFunc(lib, "vkDestroyPrivateDataSlot");
    out->vkSetPrivateData = (PFN_vkSetPrivateData)dlSymFunc(lib, "vkSetPrivateData");
    out->vkGetPrivateData = (PFN_vkGetPrivateData)dlSymFunc(lib, "vkGetPrivateData");
    out->vkCmdSetEvent2 = (PFN_vkCmdSetEvent2)dlSymFunc(lib, "vkCmdSetEvent2");
    out->vkCmdResetEvent2 = (PFN_vkCmdResetEvent2)dlSymFunc(lib, "vkCmdResetEvent2");
    out->vkCmdWaitEvents2 = (PFN_vkCmdWaitEvents2)dlSymFunc(lib, "vkCmdWaitEvents2");
    out->vkCmdPipelineBarrier2 = (PFN_vkCmdPipelineBarrier2)dlSymFunc(lib, "vkCmdPipelineBarrier2");
    out->vkCmdWriteTimestamp2 = (PFN_vkCmdWriteTimestamp2)dlSymFunc(lib, "vkCmdWriteTimestamp2");
    out->vkQueueSubmit2 = (PFN_vkQueueSubmit2)dlSymFunc(lib, "vkQueueSubmit2");
    out->vkCmdCopyBuffer2 = (PFN_vkCmdCopyBuffer2)dlSymFunc(lib, "vkCmdCopyBuffer2");
    out->vkCmdCopyImage2 = (PFN_vkCmdCopyImage2)dlSymFunc(lib, "vkCmdCopyImage2");
    out->vkCmdCopyBufferToImage2 =
        (PFN_vkCmdCopyBufferToImage2)dlSymFunc(lib, "vkCmdCopyBufferToImage2");
    out->vkCmdCopyImageToBuffer2 =
        (PFN_vkCmdCopyImageToBuffer2)dlSymFunc(lib, "vkCmdCopyImageToBuffer2");
    out->vkCmdBlitImage2 = (PFN_vkCmdBlitImage2)dlSymFunc(lib, "vkCmdBlitImage2");
    out->vkCmdResolveImage2 = (PFN_vkCmdResolveImage2)dlSymFunc(lib, "vkCmdResolveImage2");
    out->vkCmdBeginRendering = (PFN_vkCmdBeginRendering)dlSymFunc(lib, "vkCmdBeginRendering");
    out->vkCmdEndRendering = (PFN_vkCmdEndRendering)dlSymFunc(lib, "vkCmdEndRendering");
    out->vkCmdSetCullMode = (PFN_vkCmdSetCullMode)dlSymFunc(lib, "vkCmdSetCullMode");
    out->vkCmdSetFrontFace = (PFN_vkCmdSetFrontFace)dlSymFunc(lib, "vkCmdSetFrontFace");
    out->vkCmdSetPrimitiveTopology =
        (PFN_vkCmdSetPrimitiveTopology)dlSymFunc(lib, "vkCmdSetPrimitiveTopology");
    out->vkCmdSetViewportWithCount =
        (PFN_vkCmdSetViewportWithCount)dlSymFunc(lib, "vkCmdSetViewportWithCount");
    out->vkCmdSetScissorWithCount =
        (PFN_vkCmdSetScissorWithCount)dlSymFunc(lib, "vkCmdSetScissorWithCount");
    out->vkCmdBindVertexBuffers2 =
        (PFN_vkCmdBindVertexBuffers2)dlSymFunc(lib, "vkCmdBindVertexBuffers2");
    out->vkCmdSetDepthTestEnable =
        (PFN_vkCmdSetDepthTestEnable)dlSymFunc(lib, "vkCmdSetDepthTestEnable");
    out->vkCmdSetDepthWriteEnable =
        (PFN_vkCmdSetDepthWriteEnable)dlSymFunc(lib, "vkCmdSetDepthWriteEnable");
    out->vkCmdSetDepthCompareOp =
        (PFN_vkCmdSetDepthCompareOp)dlSymFunc(lib, "vkCmdSetDepthCompareOp");
    out->vkCmdSetDepthBoundsTestEnable =
        (PFN_vkCmdSetDepthBoundsTestEnable)dlSymFunc(lib, "vkCmdSetDepthBoundsTestEnable");
    out->vkCmdSetStencilTestEnable =
        (PFN_vkCmdSetStencilTestEnable)dlSymFunc(lib, "vkCmdSetStencilTestEnable");
    out->vkCmdSetStencilOp = (PFN_vkCmdSetStencilOp)dlSymFunc(lib, "vkCmdSetStencilOp");
    out->vkCmdSetRasterizerDiscardEnable =
        (PFN_vkCmdSetRasterizerDiscardEnable)dlSymFunc(lib, "vkCmdSetRasterizerDiscardEnable");
    out->vkCmdSetDepthBiasEnable =
        (PFN_vkCmdSetDepthBiasEnable)dlSymFunc(lib, "vkCmdSetDepthBiasEnable");
    out->vkCmdSetPrimitiveRestartEnable =
        (PFN_vkCmdSetPrimitiveRestartEnable)dlSymFunc(lib, "vkCmdSetPrimitiveRestartEnable");
    out->vkGetDeviceBufferMemoryRequirements = (PFN_vkGetDeviceBufferMemoryRequirements)dlSymFunc(
        lib, "vkGetDeviceBufferMemoryRequirements");
    out->vkGetDeviceImageMemoryRequirements = (PFN_vkGetDeviceImageMemoryRequirements)dlSymFunc(
        lib, "vkGetDeviceImageMemoryRequirements");
    out->vkGetDeviceImageSparseMemoryRequirements =
        (PFN_vkGetDeviceImageSparseMemoryRequirements)dlSymFunc(
            lib, "vkGetDeviceImageSparseMemoryRequirements");
#endif
#ifdef VK_KHR_surface
    out->vkGetPhysicalDeviceSurfaceSupportKHR = (PFN_vkGetPhysicalDeviceSurfaceSupportKHR)dlSymFunc(
        lib, "vkGetPhysicalDeviceSurfaceSupportKHR");
    out->vkGetPhysicalDeviceSurfaceCapabilitiesKHR =
        (PFN_vkGetPhysicalDeviceSurfaceCapabilitiesKHR)dlSymFunc(
            lib, "vkGetPhysicalDeviceSurfaceCapabilitiesKHR");
    out->vkGetPhysicalDeviceSurfaceFormatsKHR = (PFN_vkGetPhysicalDeviceSurfaceFormatsKHR)dlSymFunc(
        lib, "vkGetPhysicalDeviceSurfaceFormatsKHR");
    out->vkGetPhysicalDeviceSurfacePresentModesKHR =
        (PFN_vkGetPhysicalDeviceSurfacePresentModesKHR)dlSymFunc(
            lib, "vkGetPhysicalDeviceSurfacePresentModesKHR");
#endif
#ifdef VK_KHR_swapchain
    out->vkGetDeviceGroupPresentCapabilitiesKHR =
        (PFN_vkGetDeviceGroupPresentCapabilitiesKHR)dlSymFunc(
            lib, "vkGetDeviceGroupPresentCapabilitiesKHR");
    out->vkGetDeviceGroupSurfacePresentModesKHR =
        (PFN_vkGetDeviceGroupSurfacePresentModesKHR)dlSymFunc(
            lib, "vkGetDeviceGroupSurfacePresentModesKHR");
    out->vkGetPhysicalDevicePresentRectanglesKHR =
        (PFN_vkGetPhysicalDevicePresentRectanglesKHR)dlSymFunc(
            lib, "vkGetPhysicalDevicePresentRectanglesKHR");
    out->vkAcquireNextImage2KHR =
        (PFN_vkAcquireNextImage2KHR)dlSymFunc(lib, "vkAcquireNextImage2KHR");
#endif
#ifdef VK_KHR_dynamic_rendering
    out->vkCmdBeginRenderingKHR =
        (PFN_vkCmdBeginRenderingKHR)dlSymFunc(lib, "vkCmdBeginRenderingKHR");
    out->vkCmdEndRenderingKHR = (PFN_vkCmdEndRenderingKHR)dlSymFunc(lib, "vkCmdEndRenderingKHR");
#endif
#ifdef VK_KHR_get_physical_device_properties2
    out->vkGetPhysicalDeviceFeatures2KHR =
        (PFN_vkGetPhysicalDeviceFeatures2KHR)dlSymFunc(lib, "vkGetPhysicalDeviceFeatures2KHR");
    out->vkGetPhysicalDeviceProperties2KHR =
        (PFN_vkGetPhysicalDeviceProperties2KHR)dlSymFunc(lib, "vkGetPhysicalDeviceProperties2KHR");
    out->vkGetPhysicalDeviceFormatProperties2KHR =
        (PFN_vkGetPhysicalDeviceFormatProperties2KHR)dlSymFunc(
            lib, "vkGetPhysicalDeviceFormatProperties2KHR");
    out->vkGetPhysicalDeviceImageFormatProperties2KHR =
        (PFN_vkGetPhysicalDeviceImageFormatProperties2KHR)dlSymFunc(
            lib, "vkGetPhysicalDeviceImageFormatProperties2KHR");
    out->vkGetPhysicalDeviceQueueFamilyProperties2KHR =
        (PFN_vkGetPhysicalDeviceQueueFamilyProperties2KHR)dlSymFunc(
            lib, "vkGetPhysicalDeviceQueueFamilyProperties2KHR");
    out->vkGetPhysicalDeviceMemoryProperties2KHR =
        (PFN_vkGetPhysicalDeviceMemoryProperties2KHR)dlSymFunc(
            lib, "vkGetPhysicalDeviceMemoryProperties2KHR");
    out->vkGetPhysicalDeviceSparseImageFormatProperties2KHR =
        (PFN_vkGetPhysicalDeviceSparseImageFormatProperties2KHR)dlSymFunc(
            lib, "vkGetPhysicalDeviceSparseImageFormatProperties2KHR");
#endif
#ifdef VK_KHR_maintenance1
    out->vkTrimCommandPoolKHR = (PFN_vkTrimCommandPoolKHR)dlSymFunc(lib, "vkTrimCommandPoolKHR");
#endif
#ifdef VK_KHR_external_memory_capabilities
    out->vkGetPhysicalDeviceExternalBufferPropertiesKHR =
        (PFN_vkGetPhysicalDeviceExternalBufferPropertiesKHR)dlSymFunc(
            lib, "vkGetPhysicalDeviceExternalBufferPropertiesKHR");
#endif
#ifdef VK_KHR_external_memory_win32
    out->vkGetMemoryWin32HandleKHR =
        (PFN_vkGetMemoryWin32HandleKHR)dlSymFunc(lib, "vkGetMemoryWin32HandleKHR");
    out->vkGetMemoryWin32HandlePropertiesKHR = (PFN_vkGetMemoryWin32HandlePropertiesKHR)dlSymFunc(
        lib, "vkGetMemoryWin32HandlePropertiesKHR");
#endif
#ifdef VK_KHR_external_memory_fd
    out->vkGetMemoryFdKHR = (PFN_vkGetMemoryFdKHR)dlSymFunc(lib, "vkGetMemoryFdKHR");
    out->vkGetMemoryFdPropertiesKHR =
        (PFN_vkGetMemoryFdPropertiesKHR)dlSymFunc(lib, "vkGetMemoryFdPropertiesKHR");
#endif
#ifdef VK_KHR_external_semaphore_capabilities
    out->vkGetPhysicalDeviceExternalSemaphorePropertiesKHR =
        (PFN_vkGetPhysicalDeviceExternalSemaphorePropertiesKHR)dlSymFunc(
            lib, "vkGetPhysicalDeviceExternalSemaphorePropertiesKHR");
#endif
#ifdef VK_KHR_external_semaphore_win32
    out->vkImportSemaphoreWin32HandleKHR =
        (PFN_vkImportSemaphoreWin32HandleKHR)dlSymFunc(lib, "vkImportSemaphoreWin32HandleKHR");
    out->vkGetSemaphoreWin32HandleKHR =
        (PFN_vkGetSemaphoreWin32HandleKHR)dlSymFunc(lib, "vkGetSemaphoreWin32HandleKHR");
#endif
#ifdef VK_KHR_external_semaphore_fd
    out->vkImportSemaphoreFdKHR =
        (PFN_vkImportSemaphoreFdKHR)dlSymFunc(lib, "vkImportSemaphoreFdKHR");
    out->vkGetSemaphoreFdKHR = (PFN_vkGetSemaphoreFdKHR)dlSymFunc(lib, "vkGetSemaphoreFdKHR");
#endif
#ifdef VK_KHR_descriptor_update_template
    out->vkCreateDescriptorUpdateTemplateKHR = (PFN_vkCreateDescriptorUpdateTemplateKHR)dlSymFunc(
        lib, "vkCreateDescriptorUpdateTemplateKHR");
    out->vkDestroyDescriptorUpdateTemplateKHR = (PFN_vkDestroyDescriptorUpdateTemplateKHR)dlSymFunc(
        lib, "vkDestroyDescriptorUpdateTemplateKHR");
    out->vkUpdateDescriptorSetWithTemplateKHR = (PFN_vkUpdateDescriptorSetWithTemplateKHR)dlSymFunc(
        lib, "vkUpdateDescriptorSetWithTemplateKHR");
#endif
#ifdef VK_KHR_create_renderpass2
    out->vkCreateRenderPass2KHR =
        (PFN_vkCreateRenderPass2KHR)dlSymFunc(lib, "vkCreateRenderPass2KHR");
    out->vkCmdBeginRenderPass2KHR =
        (PFN_vkCmdBeginRenderPass2KHR)dlSymFunc(lib, "vkCmdBeginRenderPass2KHR");
    out->vkCmdNextSubpass2KHR = (PFN_vkCmdNextSubpass2KHR)dlSymFunc(lib, "vkCmdNextSubpass2KHR");
    out->vkCmdEndRenderPass2KHR =
        (PFN_vkCmdEndRenderPass2KHR)dlSymFunc(lib, "vkCmdEndRenderPass2KHR");
#endif
#ifdef VK_KHR_external_fence_capabilities
    out->vkGetPhysicalDeviceExternalFencePropertiesKHR =
        (PFN_vkGetPhysicalDeviceExternalFencePropertiesKHR)dlSymFunc(
            lib, "vkGetPhysicalDeviceExternalFencePropertiesKHR");
#endif
#ifdef VK_KHR_external_fence_fd
    out->vkImportFenceFdKHR = (PFN_vkImportFenceFdKHR)dlSymFunc(lib, "vkImportFenceFdKHR");
    out->vkGetFenceFdKHR = (PFN_vkGetFenceFdKHR)dlSymFunc(lib, "vkGetFenceFdKHR");
#endif
#ifdef VK_KHR_get_memory_requirements2
    out->vkGetImageMemoryRequirements2KHR =
        (PFN_vkGetImageMemoryRequirements2KHR)dlSymFunc(lib, "vkGetImageMemoryRequirements2KHR");
    out->vkGetBufferMemoryRequirements2KHR =
        (PFN_vkGetBufferMemoryRequirements2KHR)dlSymFunc(lib, "vkGetBufferMemoryRequirements2KHR");
    out->vkGetImageSparseMemoryRequirements2KHR =
        (PFN_vkGetImageSparseMemoryRequirements2KHR)dlSymFunc(
            lib, "vkGetImageSparseMemoryRequirements2KHR");
#endif
#ifdef VK_KHR_sampler_ycbcr_conversion
    out->vkCreateSamplerYcbcrConversionKHR =
        (PFN_vkCreateSamplerYcbcrConversionKHR)dlSymFunc(lib, "vkCreateSamplerYcbcrConversionKHR");
    out->vkDestroySamplerYcbcrConversionKHR = (PFN_vkDestroySamplerYcbcrConversionKHR)dlSymFunc(
        lib, "vkDestroySamplerYcbcrConversionKHR");
#endif
#ifdef VK_KHR_bind_memory2
    out->vkBindBufferMemory2KHR =
        (PFN_vkBindBufferMemory2KHR)dlSymFunc(lib, "vkBindBufferMemory2KHR");
    out->vkBindImageMemory2KHR = (PFN_vkBindImageMemory2KHR)dlSymFunc(lib, "vkBindImageMemory2KHR");
#endif
#ifdef VK_KHR_maintenance3
    out->vkGetDescriptorSetLayoutSupportKHR = (PFN_vkGetDescriptorSetLayoutSupportKHR)dlSymFunc(
        lib, "vkGetDescriptorSetLayoutSupportKHR");
#endif
#ifdef VK_KHR_buffer_device_address
    out->vkGetBufferDeviceAddressKHR =
        (PFN_vkGetBufferDeviceAddressKHR)dlSymFunc(lib, "vkGetBufferDeviceAddressKHR");
    out->vkGetBufferOpaqueCaptureAddressKHR = (PFN_vkGetBufferOpaqueCaptureAddressKHR)dlSymFunc(
        lib, "vkGetBufferOpaqueCaptureAddressKHR");
    out->vkGetDeviceMemoryOpaqueCaptureAddressKHR =
        (PFN_vkGetDeviceMemoryOpaqueCaptureAddressKHR)dlSymFunc(
            lib, "vkGetDeviceMemoryOpaqueCaptureAddressKHR");
#endif
#ifdef VK_KHR_pipeline_executable_properties
    out->vkGetPipelineExecutablePropertiesKHR = (PFN_vkGetPipelineExecutablePropertiesKHR)dlSymFunc(
        lib, "vkGetPipelineExecutablePropertiesKHR");
    out->vkGetPipelineExecutableStatisticsKHR = (PFN_vkGetPipelineExecutableStatisticsKHR)dlSymFunc(
        lib, "vkGetPipelineExecutableStatisticsKHR");
    out->vkGetPipelineExecutableInternalRepresentationsKHR =
        (PFN_vkGetPipelineExecutableInternalRepresentationsKHR)dlSymFunc(
            lib, "vkGetPipelineExecutableInternalRepresentationsKHR");
#endif
#ifdef VK_KHR_synchronization2
    out->vkCmdSetEvent2KHR = (PFN_vkCmdSetEvent2KHR)dlSymFunc(lib, "vkCmdSetEvent2KHR");
    out->vkCmdResetEvent2KHR = (PFN_vkCmdResetEvent2KHR)dlSymFunc(lib, "vkCmdResetEvent2KHR");
    out->vkCmdWaitEvents2KHR = (PFN_vkCmdWaitEvents2KHR)dlSymFunc(lib, "vkCmdWaitEvents2KHR");
    out->vkCmdPipelineBarrier2KHR =
        (PFN_vkCmdPipelineBarrier2KHR)dlSymFunc(lib, "vkCmdPipelineBarrier2KHR");
    out->vkCmdWriteTimestamp2KHR =
        (PFN_vkCmdWriteTimestamp2KHR)dlSymFunc(lib, "vkCmdWriteTimestamp2KHR");
    out->vkQueueSubmit2KHR = (PFN_vkQueueSubmit2KHR)dlSymFunc(lib, "vkQueueSubmit2KHR");
    out->vkCmdWriteBufferMarker2AMD =
        (PFN_vkCmdWriteBufferMarker2AMD)dlSymFunc(lib, "vkCmdWriteBufferMarker2AMD");
    out->vkGetQueueCheckpointData2NV =
        (PFN_vkGetQueueCheckpointData2NV)dlSymFunc(lib, "vkGetQueueCheckpointData2NV");
#endif
#ifdef VK_KHR_copy_commands2
    out->vkCmdCopyBuffer2KHR = (PFN_vkCmdCopyBuffer2KHR)dlSymFunc(lib, "vkCmdCopyBuffer2KHR");
    out->vkCmdCopyImage2KHR = (PFN_vkCmdCopyImage2KHR)dlSymFunc(lib, "vkCmdCopyImage2KHR");
    out->vkCmdCopyBufferToImage2KHR =
        (PFN_vkCmdCopyBufferToImage2KHR)dlSymFunc(lib, "vkCmdCopyBufferToImage2KHR");
    out->vkCmdCopyImageToBuffer2KHR =
        (PFN_vkCmdCopyImageToBuffer2KHR)dlSymFunc(lib, "vkCmdCopyImageToBuffer2KHR");
    out->vkCmdBlitImage2KHR = (PFN_vkCmdBlitImage2KHR)dlSymFunc(lib, "vkCmdBlitImage2KHR");
    out->vkCmdResolveImage2KHR = (PFN_vkCmdResolveImage2KHR)dlSymFunc(lib, "vkCmdResolveImage2KHR");
#endif
#ifdef VK_KHR_maintenance4
    out->vkGetDeviceBufferMemoryRequirementsKHR =
        (PFN_vkGetDeviceBufferMemoryRequirementsKHR)dlSymFunc(
            lib, "vkGetDeviceBufferMemoryRequirementsKHR");
    out->vkGetDeviceImageMemoryRequirementsKHR =
        (PFN_vkGetDeviceImageMemoryRequirementsKHR)dlSymFunc(
            lib, "vkGetDeviceImageMemoryRequirementsKHR");
    out->vkGetDeviceImageSparseMemoryRequirementsKHR =
        (PFN_vkGetDeviceImageSparseMemoryRequirementsKHR)dlSymFunc(
            lib, "vkGetDeviceImageSparseMemoryRequirementsKHR");
#endif
#ifdef VK_ANDROID_native_buffer
    out->vkGetSwapchainGrallocUsageANDROID =
        (PFN_vkGetSwapchainGrallocUsageANDROID)dlSymFunc(lib, "vkGetSwapchainGrallocUsageANDROID");
    out->vkAcquireImageANDROID = (PFN_vkAcquireImageANDROID)dlSymFunc(lib, "vkAcquireImageANDROID");
    out->vkQueueSignalReleaseImageANDROID =
        (PFN_vkQueueSignalReleaseImageANDROID)dlSymFunc(lib, "vkQueueSignalReleaseImageANDROID");
    out->vkGetSwapchainGrallocUsage2ANDROID = (PFN_vkGetSwapchainGrallocUsage2ANDROID)dlSymFunc(
        lib, "vkGetSwapchainGrallocUsage2ANDROID");
#endif
#ifdef VK_EXT_transform_feedback
    out->vkCmdBindTransformFeedbackBuffersEXT = (PFN_vkCmdBindTransformFeedbackBuffersEXT)dlSymFunc(
        lib, "vkCmdBindTransformFeedbackBuffersEXT");
    out->vkCmdBeginTransformFeedbackEXT =
        (PFN_vkCmdBeginTransformFeedbackEXT)dlSymFunc(lib, "vkCmdBeginTransformFeedbackEXT");
    out->vkCmdEndTransformFeedbackEXT =
        (PFN_vkCmdEndTransformFeedbackEXT)dlSymFunc(lib, "vkCmdEndTransformFeedbackEXT");
    out->vkCmdBeginQueryIndexedEXT =
        (PFN_vkCmdBeginQueryIndexedEXT)dlSymFunc(lib, "vkCmdBeginQueryIndexedEXT");
    out->vkCmdEndQueryIndexedEXT =
        (PFN_vkCmdEndQueryIndexedEXT)dlSymFunc(lib, "vkCmdEndQueryIndexedEXT");
    out->vkCmdDrawIndirectByteCountEXT =
        (PFN_vkCmdDrawIndirectByteCountEXT)dlSymFunc(lib, "vkCmdDrawIndirectByteCountEXT");
#endif
#ifdef VK_EXT_debug_utils
    out->vkSetDebugUtilsObjectNameEXT =
        (PFN_vkSetDebugUtilsObjectNameEXT)dlSymFunc(lib, "vkSetDebugUtilsObjectNameEXT");
    out->vkSetDebugUtilsObjectTagEXT =
        (PFN_vkSetDebugUtilsObjectTagEXT)dlSymFunc(lib, "vkSetDebugUtilsObjectTagEXT");
    out->vkQueueBeginDebugUtilsLabelEXT =
        (PFN_vkQueueBeginDebugUtilsLabelEXT)dlSymFunc(lib, "vkQueueBeginDebugUtilsLabelEXT");
    out->vkQueueEndDebugUtilsLabelEXT =
        (PFN_vkQueueEndDebugUtilsLabelEXT)dlSymFunc(lib, "vkQueueEndDebugUtilsLabelEXT");
    out->vkQueueInsertDebugUtilsLabelEXT =
        (PFN_vkQueueInsertDebugUtilsLabelEXT)dlSymFunc(lib, "vkQueueInsertDebugUtilsLabelEXT");
    out->vkCmdBeginDebugUtilsLabelEXT =
        (PFN_vkCmdBeginDebugUtilsLabelEXT)dlSymFunc(lib, "vkCmdBeginDebugUtilsLabelEXT");
    out->vkCmdEndDebugUtilsLabelEXT =
        (PFN_vkCmdEndDebugUtilsLabelEXT)dlSymFunc(lib, "vkCmdEndDebugUtilsLabelEXT");
    out->vkCmdInsertDebugUtilsLabelEXT =
        (PFN_vkCmdInsertDebugUtilsLabelEXT)dlSymFunc(lib, "vkCmdInsertDebugUtilsLabelEXT");
#endif
#ifdef VK_EXT_tooling_info
    out->vkGetPhysicalDeviceToolPropertiesEXT = (PFN_vkGetPhysicalDeviceToolPropertiesEXT)dlSymFunc(
        lib, "vkGetPhysicalDeviceToolPropertiesEXT");
#endif
#ifdef VK_EXT_line_rasterization
    out->vkCmdSetLineStippleEXT =
        (PFN_vkCmdSetLineStippleEXT)dlSymFunc(lib, "vkCmdSetLineStippleEXT");
#endif
#ifdef VK_EXT_extended_dynamic_state
    out->vkCmdSetCullModeEXT = (PFN_vkCmdSetCullModeEXT)dlSymFunc(lib, "vkCmdSetCullModeEXT");
    out->vkCmdSetFrontFaceEXT = (PFN_vkCmdSetFrontFaceEXT)dlSymFunc(lib, "vkCmdSetFrontFaceEXT");
    out->vkCmdSetPrimitiveTopologyEXT =
        (PFN_vkCmdSetPrimitiveTopologyEXT)dlSymFunc(lib, "vkCmdSetPrimitiveTopologyEXT");
    out->vkCmdSetViewportWithCountEXT =
        (PFN_vkCmdSetViewportWithCountEXT)dlSymFunc(lib, "vkCmdSetViewportWithCountEXT");
    out->vkCmdSetScissorWithCountEXT =
        (PFN_vkCmdSetScissorWithCountEXT)dlSymFunc(lib, "vkCmdSetScissorWithCountEXT");
    out->vkCmdBindVertexBuffers2EXT =
        (PFN_vkCmdBindVertexBuffers2EXT)dlSymFunc(lib, "vkCmdBindVertexBuffers2EXT");
    out->vkCmdSetDepthTestEnableEXT =
        (PFN_vkCmdSetDepthTestEnableEXT)dlSymFunc(lib, "vkCmdSetDepthTestEnableEXT");
    out->vkCmdSetDepthWriteEnableEXT =
        (PFN_vkCmdSetDepthWriteEnableEXT)dlSymFunc(lib, "vkCmdSetDepthWriteEnableEXT");
    out->vkCmdSetDepthCompareOpEXT =
        (PFN_vkCmdSetDepthCompareOpEXT)dlSymFunc(lib, "vkCmdSetDepthCompareOpEXT");
    out->vkCmdSetDepthBoundsTestEnableEXT =
        (PFN_vkCmdSetDepthBoundsTestEnableEXT)dlSymFunc(lib, "vkCmdSetDepthBoundsTestEnableEXT");
    out->vkCmdSetStencilTestEnableEXT =
        (PFN_vkCmdSetStencilTestEnableEXT)dlSymFunc(lib, "vkCmdSetStencilTestEnableEXT");
    out->vkCmdSetStencilOpEXT = (PFN_vkCmdSetStencilOpEXT)dlSymFunc(lib, "vkCmdSetStencilOpEXT");
#endif
#ifdef VK_EXT_swapchain_maintenance1
    out->vkReleaseSwapchainImagesEXT =
        (PFN_vkReleaseSwapchainImagesEXT)dlSymFunc(lib, "vkReleaseSwapchainImagesEXT");
#endif
#ifdef VK_EXT_private_data
    out->vkCreatePrivateDataSlotEXT =
        (PFN_vkCreatePrivateDataSlotEXT)dlSymFunc(lib, "vkCreatePrivateDataSlotEXT");
    out->vkDestroyPrivateDataSlotEXT =
        (PFN_vkDestroyPrivateDataSlotEXT)dlSymFunc(lib, "vkDestroyPrivateDataSlotEXT");
    out->vkSetPrivateDataEXT = (PFN_vkSetPrivateDataEXT)dlSymFunc(lib, "vkSetPrivateDataEXT");
    out->vkGetPrivateDataEXT = (PFN_vkGetPrivateDataEXT)dlSymFunc(lib, "vkGetPrivateDataEXT");
#endif
#ifdef VK_EXT_image_compression_control
    out->vkGetImageSubresourceLayout2EXT =
        (PFN_vkGetImageSubresourceLayout2EXT)dlSymFunc(lib, "vkGetImageSubresourceLayout2EXT");
#endif
#ifdef VK_EXT_extended_dynamic_state2
    out->vkCmdSetPatchControlPointsEXT =
        (PFN_vkCmdSetPatchControlPointsEXT)dlSymFunc(lib, "vkCmdSetPatchControlPointsEXT");
    out->vkCmdSetRasterizerDiscardEnableEXT = (PFN_vkCmdSetRasterizerDiscardEnableEXT)dlSymFunc(
        lib, "vkCmdSetRasterizerDiscardEnableEXT");
    out->vkCmdSetDepthBiasEnableEXT =
        (PFN_vkCmdSetDepthBiasEnableEXT)dlSymFunc(lib, "vkCmdSetDepthBiasEnableEXT");
    out->vkCmdSetLogicOpEXT = (PFN_vkCmdSetLogicOpEXT)dlSymFunc(lib, "vkCmdSetLogicOpEXT");
    out->vkCmdSetPrimitiveRestartEnableEXT =
        (PFN_vkCmdSetPrimitiveRestartEnableEXT)dlSymFunc(lib, "vkCmdSetPrimitiveRestartEnableEXT");
#endif
#ifdef VK_GOOGLE_gfxstream
    out->vkMapMemoryIntoAddressSpaceGOOGLE =
        (PFN_vkMapMemoryIntoAddressSpaceGOOGLE)dlSymFunc(lib, "vkMapMemoryIntoAddressSpaceGOOGLE");
    out->vkUpdateDescriptorSetWithTemplateSizedGOOGLE =
        (PFN_vkUpdateDescriptorSetWithTemplateSizedGOOGLE)dlSymFunc(
            lib, "vkUpdateDescriptorSetWithTemplateSizedGOOGLE");
    out->vkBeginCommandBufferAsyncGOOGLE =
        (PFN_vkBeginCommandBufferAsyncGOOGLE)dlSymFunc(lib, "vkBeginCommandBufferAsyncGOOGLE");
    out->vkEndCommandBufferAsyncGOOGLE =
        (PFN_vkEndCommandBufferAsyncGOOGLE)dlSymFunc(lib, "vkEndCommandBufferAsyncGOOGLE");
    out->vkResetCommandBufferAsyncGOOGLE =
        (PFN_vkResetCommandBufferAsyncGOOGLE)dlSymFunc(lib, "vkResetCommandBufferAsyncGOOGLE");
    out->vkCommandBufferHostSyncGOOGLE =
        (PFN_vkCommandBufferHostSyncGOOGLE)dlSymFunc(lib, "vkCommandBufferHostSyncGOOGLE");
    out->vkCreateImageWithRequirementsGOOGLE = (PFN_vkCreateImageWithRequirementsGOOGLE)dlSymFunc(
        lib, "vkCreateImageWithRequirementsGOOGLE");
    out->vkCreateBufferWithRequirementsGOOGLE = (PFN_vkCreateBufferWithRequirementsGOOGLE)dlSymFunc(
        lib, "vkCreateBufferWithRequirementsGOOGLE");
    out->vkGetMemoryHostAddressInfoGOOGLE =
        (PFN_vkGetMemoryHostAddressInfoGOOGLE)dlSymFunc(lib, "vkGetMemoryHostAddressInfoGOOGLE");
    out->vkFreeMemorySyncGOOGLE =
        (PFN_vkFreeMemorySyncGOOGLE)dlSymFunc(lib, "vkFreeMemorySyncGOOGLE");
    out->vkQueueHostSyncGOOGLE = (PFN_vkQueueHostSyncGOOGLE)dlSymFunc(lib, "vkQueueHostSyncGOOGLE");
    out->vkQueueSubmitAsyncGOOGLE =
        (PFN_vkQueueSubmitAsyncGOOGLE)dlSymFunc(lib, "vkQueueSubmitAsyncGOOGLE");
    out->vkQueueWaitIdleAsyncGOOGLE =
        (PFN_vkQueueWaitIdleAsyncGOOGLE)dlSymFunc(lib, "vkQueueWaitIdleAsyncGOOGLE");
    out->vkQueueBindSparseAsyncGOOGLE =
        (PFN_vkQueueBindSparseAsyncGOOGLE)dlSymFunc(lib, "vkQueueBindSparseAsyncGOOGLE");
    out->vkGetLinearImageLayoutGOOGLE =
        (PFN_vkGetLinearImageLayoutGOOGLE)dlSymFunc(lib, "vkGetLinearImageLayoutGOOGLE");
    out->vkGetLinearImageLayout2GOOGLE =
        (PFN_vkGetLinearImageLayout2GOOGLE)dlSymFunc(lib, "vkGetLinearImageLayout2GOOGLE");
    out->vkQueueFlushCommandsGOOGLE =
        (PFN_vkQueueFlushCommandsGOOGLE)dlSymFunc(lib, "vkQueueFlushCommandsGOOGLE");
    out->vkQueueCommitDescriptorSetUpdatesGOOGLE =
        (PFN_vkQueueCommitDescriptorSetUpdatesGOOGLE)dlSymFunc(
            lib, "vkQueueCommitDescriptorSetUpdatesGOOGLE");
    out->vkCollectDescriptorPoolIdsGOOGLE =
        (PFN_vkCollectDescriptorPoolIdsGOOGLE)dlSymFunc(lib, "vkCollectDescriptorPoolIdsGOOGLE");
    out->vkQueueSignalReleaseImageANDROIDAsyncGOOGLE =
        (PFN_vkQueueSignalReleaseImageANDROIDAsyncGOOGLE)dlSymFunc(
            lib, "vkQueueSignalReleaseImageANDROIDAsyncGOOGLE");
    out->vkQueueFlushCommandsFromAuxMemoryGOOGLE =
        (PFN_vkQueueFlushCommandsFromAuxMemoryGOOGLE)dlSymFunc(
            lib, "vkQueueFlushCommandsFromAuxMemoryGOOGLE");
    out->vkGetBlobGOOGLE = (PFN_vkGetBlobGOOGLE)dlSymFunc(lib, "vkGetBlobGOOGLE");
    out->vkUpdateDescriptorSetWithTemplateSized2GOOGLE =
        (PFN_vkUpdateDescriptorSetWithTemplateSized2GOOGLE)dlSymFunc(
            lib, "vkUpdateDescriptorSetWithTemplateSized2GOOGLE");
    out->vkQueueSubmitAsync2GOOGLE =
        (PFN_vkQueueSubmitAsync2GOOGLE)dlSymFunc(lib, "vkQueueSubmitAsync2GOOGLE");
#endif
}

void init_vulkan_dispatch_from_instance(VulkanDispatch* vk, VkInstance instance,
                                        VulkanDispatch* out) {
    memset(out, 0x0, sizeof(VulkanDispatch));
#ifdef VK_VERSION_1_0
    out->vkDestroyInstance =
        (PFN_vkDestroyInstance)vk->vkGetInstanceProcAddr(instance, "vkDestroyInstance");
    out->vkEnumeratePhysicalDevices = (PFN_vkEnumeratePhysicalDevices)vk->vkGetInstanceProcAddr(
        instance, "vkEnumeratePhysicalDevices");
    out->vkGetPhysicalDeviceFeatures = (PFN_vkGetPhysicalDeviceFeatures)vk->vkGetInstanceProcAddr(
        instance, "vkGetPhysicalDeviceFeatures");
    out->vkGetPhysicalDeviceFormatProperties =
        (PFN_vkGetPhysicalDeviceFormatProperties)vk->vkGetInstanceProcAddr(
            instance, "vkGetPhysicalDeviceFormatProperties");
    out->vkGetPhysicalDeviceImageFormatProperties =
        (PFN_vkGetPhysicalDeviceImageFormatProperties)vk->vkGetInstanceProcAddr(
            instance, "vkGetPhysicalDeviceImageFormatProperties");
    out->vkGetPhysicalDeviceProperties =
        (PFN_vkGetPhysicalDeviceProperties)vk->vkGetInstanceProcAddr(
            instance, "vkGetPhysicalDeviceProperties");
    out->vkGetPhysicalDeviceQueueFamilyProperties =
        (PFN_vkGetPhysicalDeviceQueueFamilyProperties)vk->vkGetInstanceProcAddr(
            instance, "vkGetPhysicalDeviceQueueFamilyProperties");
    out->vkGetPhysicalDeviceMemoryProperties =
        (PFN_vkGetPhysicalDeviceMemoryProperties)vk->vkGetInstanceProcAddr(
            instance, "vkGetPhysicalDeviceMemoryProperties");
    out->vkGetInstanceProcAddr =
        (PFN_vkGetInstanceProcAddr)vk->vkGetInstanceProcAddr(instance, "vkGetInstanceProcAddr");
    out->vkCreateDevice = (PFN_vkCreateDevice)vk->vkGetInstanceProcAddr(instance, "vkCreateDevice");
    out->vkDestroyDevice =
        (PFN_vkDestroyDevice)vk->vkGetInstanceProcAddr(instance, "vkDestroyDevice");
    out->vkEnumerateDeviceExtensionProperties =
        (PFN_vkEnumerateDeviceExtensionProperties)vk->vkGetInstanceProcAddr(
            instance, "vkEnumerateDeviceExtensionProperties");
    out->vkEnumerateDeviceLayerProperties =
        (PFN_vkEnumerateDeviceLayerProperties)vk->vkGetInstanceProcAddr(
            instance, "vkEnumerateDeviceLayerProperties");
    out->vkCreateInstance =
        (PFN_vkCreateInstance)vk->vkGetInstanceProcAddr(instance, "vkCreateInstance");
    out->vkEnumerateInstanceExtensionProperties =
        (PFN_vkEnumerateInstanceExtensionProperties)vk->vkGetInstanceProcAddr(
            instance, "vkEnumerateInstanceExtensionProperties");
    out->vkEnumerateInstanceLayerProperties =
        (PFN_vkEnumerateInstanceLayerProperties)vk->vkGetInstanceProcAddr(
            instance, "vkEnumerateInstanceLayerProperties");
    out->vkGetDeviceProcAddr =
        (PFN_vkGetDeviceProcAddr)vk->vkGetInstanceProcAddr(instance, "vkGetDeviceProcAddr");
    out->vkGetPhysicalDeviceSparseImageFormatProperties =
        (PFN_vkGetPhysicalDeviceSparseImageFormatProperties)vk->vkGetInstanceProcAddr(
            instance, "vkGetPhysicalDeviceSparseImageFormatProperties");
#endif
#ifdef VK_VERSION_1_1
    out->vkEnumerateInstanceVersion = (PFN_vkEnumerateInstanceVersion)vk->vkGetInstanceProcAddr(
        instance, "vkEnumerateInstanceVersion");
    out->vkEnumeratePhysicalDeviceGroups =
        (PFN_vkEnumeratePhysicalDeviceGroups)vk->vkGetInstanceProcAddr(
            instance, "vkEnumeratePhysicalDeviceGroups");
    out->vkGetPhysicalDeviceFeatures2 = (PFN_vkGetPhysicalDeviceFeatures2)vk->vkGetInstanceProcAddr(
        instance, "vkGetPhysicalDeviceFeatures2");
    out->vkGetPhysicalDeviceProperties2 =
        (PFN_vkGetPhysicalDeviceProperties2)vk->vkGetInstanceProcAddr(
            instance, "vkGetPhysicalDeviceProperties2");
    out->vkGetPhysicalDeviceFormatProperties2 =
        (PFN_vkGetPhysicalDeviceFormatProperties2)vk->vkGetInstanceProcAddr(
            instance, "vkGetPhysicalDeviceFormatProperties2");
    out->vkGetPhysicalDeviceImageFormatProperties2 =
        (PFN_vkGetPhysicalDeviceImageFormatProperties2)vk->vkGetInstanceProcAddr(
            instance, "vkGetPhysicalDeviceImageFormatProperties2");
    out->vkGetPhysicalDeviceQueueFamilyProperties2 =
        (PFN_vkGetPhysicalDeviceQueueFamilyProperties2)vk->vkGetInstanceProcAddr(
            instance, "vkGetPhysicalDeviceQueueFamilyProperties2");
    out->vkGetPhysicalDeviceMemoryProperties2 =
        (PFN_vkGetPhysicalDeviceMemoryProperties2)vk->vkGetInstanceProcAddr(
            instance, "vkGetPhysicalDeviceMemoryProperties2");
    out->vkGetPhysicalDeviceSparseImageFormatProperties2 =
        (PFN_vkGetPhysicalDeviceSparseImageFormatProperties2)vk->vkGetInstanceProcAddr(
            instance, "vkGetPhysicalDeviceSparseImageFormatProperties2");
    out->vkGetPhysicalDeviceExternalBufferProperties =
        (PFN_vkGetPhysicalDeviceExternalBufferProperties)vk->vkGetInstanceProcAddr(
            instance, "vkGetPhysicalDeviceExternalBufferProperties");
    out->vkGetPhysicalDeviceExternalFenceProperties =
        (PFN_vkGetPhysicalDeviceExternalFenceProperties)vk->vkGetInstanceProcAddr(
            instance, "vkGetPhysicalDeviceExternalFenceProperties");
    out->vkGetPhysicalDeviceExternalSemaphoreProperties =
        (PFN_vkGetPhysicalDeviceExternalSemaphoreProperties)vk->vkGetInstanceProcAddr(
            instance, "vkGetPhysicalDeviceExternalSemaphoreProperties");
#endif
#ifdef VK_KHR_surface
    out->vkDestroySurfaceKHR =
        (PFN_vkDestroySurfaceKHR)vk->vkGetInstanceProcAddr(instance, "vkDestroySurfaceKHR");
#endif
#ifdef VK_KHR_swapchain
    out->vkCreateSwapchainKHR =
        (PFN_vkCreateSwapchainKHR)vk->vkGetInstanceProcAddr(instance, "vkCreateSwapchainKHR");
    out->vkDestroySwapchainKHR =
        (PFN_vkDestroySwapchainKHR)vk->vkGetInstanceProcAddr(instance, "vkDestroySwapchainKHR");
    out->vkGetSwapchainImagesKHR =
        (PFN_vkGetSwapchainImagesKHR)vk->vkGetInstanceProcAddr(instance, "vkGetSwapchainImagesKHR");
    out->vkAcquireNextImageKHR =
        (PFN_vkAcquireNextImageKHR)vk->vkGetInstanceProcAddr(instance, "vkAcquireNextImageKHR");
    out->vkQueuePresentKHR =
        (PFN_vkQueuePresentKHR)vk->vkGetInstanceProcAddr(instance, "vkQueuePresentKHR");
#endif
#ifdef VK_KHR_xcb_surface
    out->vkCreateXcbSurfaceKHR =
        (PFN_vkCreateXcbSurfaceKHR)vk->vkGetInstanceProcAddr(instance, "vkCreateXcbSurfaceKHR");
    out->vkGetPhysicalDeviceXcbPresentationSupportKHR =
        (PFN_vkGetPhysicalDeviceXcbPresentationSupportKHR)vk->vkGetInstanceProcAddr(
            instance, "vkGetPhysicalDeviceXcbPresentationSupportKHR");
#endif
#ifdef VK_KHR_win32_surface
    out->vkCreateWin32SurfaceKHR =
        (PFN_vkCreateWin32SurfaceKHR)vk->vkGetInstanceProcAddr(instance, "vkCreateWin32SurfaceKHR");
    out->vkGetPhysicalDeviceWin32PresentationSupportKHR =
        (PFN_vkGetPhysicalDeviceWin32PresentationSupportKHR)vk->vkGetInstanceProcAddr(
            instance, "vkGetPhysicalDeviceWin32PresentationSupportKHR");
#endif
#ifdef VK_EXT_debug_utils
    out->vkCreateDebugUtilsMessengerEXT =
        (PFN_vkCreateDebugUtilsMessengerEXT)vk->vkGetInstanceProcAddr(
            instance, "vkCreateDebugUtilsMessengerEXT");
    out->vkDestroyDebugUtilsMessengerEXT =
        (PFN_vkDestroyDebugUtilsMessengerEXT)vk->vkGetInstanceProcAddr(
            instance, "vkDestroyDebugUtilsMessengerEXT");
    out->vkSubmitDebugUtilsMessageEXT = (PFN_vkSubmitDebugUtilsMessageEXT)vk->vkGetInstanceProcAddr(
        instance, "vkSubmitDebugUtilsMessageEXT");
#endif
#ifdef VK_EXT_metal_surface
    out->vkCreateMetalSurfaceEXT =
        (PFN_vkCreateMetalSurfaceEXT)vk->vkGetInstanceProcAddr(instance, "vkCreateMetalSurfaceEXT");
#endif
#ifdef VK_VERSION_1_0
    out->vkGetDeviceQueue =
        (PFN_vkGetDeviceQueue)vk->vkGetInstanceProcAddr(instance, "vkGetDeviceQueue");
    out->vkQueueSubmit = (PFN_vkQueueSubmit)vk->vkGetInstanceProcAddr(instance, "vkQueueSubmit");
    out->vkQueueWaitIdle =
        (PFN_vkQueueWaitIdle)vk->vkGetInstanceProcAddr(instance, "vkQueueWaitIdle");
    out->vkDeviceWaitIdle =
        (PFN_vkDeviceWaitIdle)vk->vkGetInstanceProcAddr(instance, "vkDeviceWaitIdle");
    out->vkAllocateMemory =
        (PFN_vkAllocateMemory)vk->vkGetInstanceProcAddr(instance, "vkAllocateMemory");
    out->vkFreeMemory = (PFN_vkFreeMemory)vk->vkGetInstanceProcAddr(instance, "vkFreeMemory");
    out->vkMapMemory = (PFN_vkMapMemory)vk->vkGetInstanceProcAddr(instance, "vkMapMemory");
    out->vkUnmapMemory = (PFN_vkUnmapMemory)vk->vkGetInstanceProcAddr(instance, "vkUnmapMemory");
    out->vkFlushMappedMemoryRanges = (PFN_vkFlushMappedMemoryRanges)vk->vkGetInstanceProcAddr(
        instance, "vkFlushMappedMemoryRanges");
    out->vkInvalidateMappedMemoryRanges =
        (PFN_vkInvalidateMappedMemoryRanges)vk->vkGetInstanceProcAddr(
            instance, "vkInvalidateMappedMemoryRanges");
    out->vkGetDeviceMemoryCommitment = (PFN_vkGetDeviceMemoryCommitment)vk->vkGetInstanceProcAddr(
        instance, "vkGetDeviceMemoryCommitment");
    out->vkBindBufferMemory =
        (PFN_vkBindBufferMemory)vk->vkGetInstanceProcAddr(instance, "vkBindBufferMemory");
    out->vkBindImageMemory =
        (PFN_vkBindImageMemory)vk->vkGetInstanceProcAddr(instance, "vkBindImageMemory");
    out->vkGetBufferMemoryRequirements =
        (PFN_vkGetBufferMemoryRequirements)vk->vkGetInstanceProcAddr(
            instance, "vkGetBufferMemoryRequirements");
    out->vkGetImageMemoryRequirements = (PFN_vkGetImageMemoryRequirements)vk->vkGetInstanceProcAddr(
        instance, "vkGetImageMemoryRequirements");
    out->vkGetImageSparseMemoryRequirements =
        (PFN_vkGetImageSparseMemoryRequirements)vk->vkGetInstanceProcAddr(
            instance, "vkGetImageSparseMemoryRequirements");
    out->vkQueueBindSparse =
        (PFN_vkQueueBindSparse)vk->vkGetInstanceProcAddr(instance, "vkQueueBindSparse");
    out->vkCreateFence = (PFN_vkCreateFence)vk->vkGetInstanceProcAddr(instance, "vkCreateFence");
    out->vkDestroyFence = (PFN_vkDestroyFence)vk->vkGetInstanceProcAddr(instance, "vkDestroyFence");
    out->vkResetFences = (PFN_vkResetFences)vk->vkGetInstanceProcAddr(instance, "vkResetFences");
    out->vkGetFenceStatus =
        (PFN_vkGetFenceStatus)vk->vkGetInstanceProcAddr(instance, "vkGetFenceStatus");
    out->vkWaitForFences =
        (PFN_vkWaitForFences)vk->vkGetInstanceProcAddr(instance, "vkWaitForFences");
    out->vkCreateSemaphore =
        (PFN_vkCreateSemaphore)vk->vkGetInstanceProcAddr(instance, "vkCreateSemaphore");
    out->vkDestroySemaphore =
        (PFN_vkDestroySemaphore)vk->vkGetInstanceProcAddr(instance, "vkDestroySemaphore");
    out->vkCreateEvent = (PFN_vkCreateEvent)vk->vkGetInstanceProcAddr(instance, "vkCreateEvent");
    out->vkDestroyEvent = (PFN_vkDestroyEvent)vk->vkGetInstanceProcAddr(instance, "vkDestroyEvent");
    out->vkGetEventStatus =
        (PFN_vkGetEventStatus)vk->vkGetInstanceProcAddr(instance, "vkGetEventStatus");
    out->vkSetEvent = (PFN_vkSetEvent)vk->vkGetInstanceProcAddr(instance, "vkSetEvent");
    out->vkResetEvent = (PFN_vkResetEvent)vk->vkGetInstanceProcAddr(instance, "vkResetEvent");
    out->vkCreateQueryPool =
        (PFN_vkCreateQueryPool)vk->vkGetInstanceProcAddr(instance, "vkCreateQueryPool");
    out->vkDestroyQueryPool =
        (PFN_vkDestroyQueryPool)vk->vkGetInstanceProcAddr(instance, "vkDestroyQueryPool");
    out->vkGetQueryPoolResults =
        (PFN_vkGetQueryPoolResults)vk->vkGetInstanceProcAddr(instance, "vkGetQueryPoolResults");
    out->vkCreateBuffer = (PFN_vkCreateBuffer)vk->vkGetInstanceProcAddr(instance, "vkCreateBuffer");
    out->vkDestroyBuffer =
        (PFN_vkDestroyBuffer)vk->vkGetInstanceProcAddr(instance, "vkDestroyBuffer");
    out->vkCreateBufferView =
        (PFN_vkCreateBufferView)vk->vkGetInstanceProcAddr(instance, "vkCreateBufferView");
    out->vkDestroyBufferView =
        (PFN_vkDestroyBufferView)vk->vkGetInstanceProcAddr(instance, "vkDestroyBufferView");
    out->vkCreateImage = (PFN_vkCreateImage)vk->vkGetInstanceProcAddr(instance, "vkCreateImage");
    out->vkDestroyImage = (PFN_vkDestroyImage)vk->vkGetInstanceProcAddr(instance, "vkDestroyImage");
    out->vkGetImageSubresourceLayout = (PFN_vkGetImageSubresourceLayout)vk->vkGetInstanceProcAddr(
        instance, "vkGetImageSubresourceLayout");
    out->vkCreateImageView =
        (PFN_vkCreateImageView)vk->vkGetInstanceProcAddr(instance, "vkCreateImageView");
    out->vkDestroyImageView =
        (PFN_vkDestroyImageView)vk->vkGetInstanceProcAddr(instance, "vkDestroyImageView");
    out->vkCreateShaderModule =
        (PFN_vkCreateShaderModule)vk->vkGetInstanceProcAddr(instance, "vkCreateShaderModule");
    out->vkDestroyShaderModule =
        (PFN_vkDestroyShaderModule)vk->vkGetInstanceProcAddr(instance, "vkDestroyShaderModule");
    out->vkCreatePipelineCache =
        (PFN_vkCreatePipelineCache)vk->vkGetInstanceProcAddr(instance, "vkCreatePipelineCache");
    out->vkDestroyPipelineCache =
        (PFN_vkDestroyPipelineCache)vk->vkGetInstanceProcAddr(instance, "vkDestroyPipelineCache");
    out->vkGetPipelineCacheData =
        (PFN_vkGetPipelineCacheData)vk->vkGetInstanceProcAddr(instance, "vkGetPipelineCacheData");
    out->vkMergePipelineCaches =
        (PFN_vkMergePipelineCaches)vk->vkGetInstanceProcAddr(instance, "vkMergePipelineCaches");
    out->vkCreateGraphicsPipelines = (PFN_vkCreateGraphicsPipelines)vk->vkGetInstanceProcAddr(
        instance, "vkCreateGraphicsPipelines");
    out->vkCreateComputePipelines = (PFN_vkCreateComputePipelines)vk->vkGetInstanceProcAddr(
        instance, "vkCreateComputePipelines");
    out->vkDestroyPipeline =
        (PFN_vkDestroyPipeline)vk->vkGetInstanceProcAddr(instance, "vkDestroyPipeline");
    out->vkCreatePipelineLayout =
        (PFN_vkCreatePipelineLayout)vk->vkGetInstanceProcAddr(instance, "vkCreatePipelineLayout");
    out->vkDestroyPipelineLayout =
        (PFN_vkDestroyPipelineLayout)vk->vkGetInstanceProcAddr(instance, "vkDestroyPipelineLayout");
    out->vkCreateSampler =
        (PFN_vkCreateSampler)vk->vkGetInstanceProcAddr(instance, "vkCreateSampler");
    out->vkDestroySampler =
        (PFN_vkDestroySampler)vk->vkGetInstanceProcAddr(instance, "vkDestroySampler");
    out->vkCreateDescriptorSetLayout = (PFN_vkCreateDescriptorSetLayout)vk->vkGetInstanceProcAddr(
        instance, "vkCreateDescriptorSetLayout");
    out->vkDestroyDescriptorSetLayout = (PFN_vkDestroyDescriptorSetLayout)vk->vkGetInstanceProcAddr(
        instance, "vkDestroyDescriptorSetLayout");
    out->vkCreateDescriptorPool =
        (PFN_vkCreateDescriptorPool)vk->vkGetInstanceProcAddr(instance, "vkCreateDescriptorPool");
    out->vkDestroyDescriptorPool =
        (PFN_vkDestroyDescriptorPool)vk->vkGetInstanceProcAddr(instance, "vkDestroyDescriptorPool");
    out->vkResetDescriptorPool =
        (PFN_vkResetDescriptorPool)vk->vkGetInstanceProcAddr(instance, "vkResetDescriptorPool");
    out->vkAllocateDescriptorSets = (PFN_vkAllocateDescriptorSets)vk->vkGetInstanceProcAddr(
        instance, "vkAllocateDescriptorSets");
    out->vkFreeDescriptorSets =
        (PFN_vkFreeDescriptorSets)vk->vkGetInstanceProcAddr(instance, "vkFreeDescriptorSets");
    out->vkUpdateDescriptorSets =
        (PFN_vkUpdateDescriptorSets)vk->vkGetInstanceProcAddr(instance, "vkUpdateDescriptorSets");
    out->vkCreateFramebuffer =
        (PFN_vkCreateFramebuffer)vk->vkGetInstanceProcAddr(instance, "vkCreateFramebuffer");
    out->vkDestroyFramebuffer =
        (PFN_vkDestroyFramebuffer)vk->vkGetInstanceProcAddr(instance, "vkDestroyFramebuffer");
    out->vkCreateRenderPass =
        (PFN_vkCreateRenderPass)vk->vkGetInstanceProcAddr(instance, "vkCreateRenderPass");
    out->vkDestroyRenderPass =
        (PFN_vkDestroyRenderPass)vk->vkGetInstanceProcAddr(instance, "vkDestroyRenderPass");
    out->vkGetRenderAreaGranularity = (PFN_vkGetRenderAreaGranularity)vk->vkGetInstanceProcAddr(
        instance, "vkGetRenderAreaGranularity");
    out->vkCreateCommandPool =
        (PFN_vkCreateCommandPool)vk->vkGetInstanceProcAddr(instance, "vkCreateCommandPool");
    out->vkDestroyCommandPool =
        (PFN_vkDestroyCommandPool)vk->vkGetInstanceProcAddr(instance, "vkDestroyCommandPool");
    out->vkResetCommandPool =
        (PFN_vkResetCommandPool)vk->vkGetInstanceProcAddr(instance, "vkResetCommandPool");
    out->vkAllocateCommandBuffers = (PFN_vkAllocateCommandBuffers)vk->vkGetInstanceProcAddr(
        instance, "vkAllocateCommandBuffers");
    out->vkFreeCommandBuffers =
        (PFN_vkFreeCommandBuffers)vk->vkGetInstanceProcAddr(instance, "vkFreeCommandBuffers");
    out->vkBeginCommandBuffer =
        (PFN_vkBeginCommandBuffer)vk->vkGetInstanceProcAddr(instance, "vkBeginCommandBuffer");
    out->vkEndCommandBuffer =
        (PFN_vkEndCommandBuffer)vk->vkGetInstanceProcAddr(instance, "vkEndCommandBuffer");
    out->vkResetCommandBuffer =
        (PFN_vkResetCommandBuffer)vk->vkGetInstanceProcAddr(instance, "vkResetCommandBuffer");
    out->vkCmdBindPipeline =
        (PFN_vkCmdBindPipeline)vk->vkGetInstanceProcAddr(instance, "vkCmdBindPipeline");
    out->vkCmdSetViewport =
        (PFN_vkCmdSetViewport)vk->vkGetInstanceProcAddr(instance, "vkCmdSetViewport");
    out->vkCmdSetScissor =
        (PFN_vkCmdSetScissor)vk->vkGetInstanceProcAddr(instance, "vkCmdSetScissor");
    out->vkCmdSetLineWidth =
        (PFN_vkCmdSetLineWidth)vk->vkGetInstanceProcAddr(instance, "vkCmdSetLineWidth");
    out->vkCmdSetDepthBias =
        (PFN_vkCmdSetDepthBias)vk->vkGetInstanceProcAddr(instance, "vkCmdSetDepthBias");
    out->vkCmdSetBlendConstants =
        (PFN_vkCmdSetBlendConstants)vk->vkGetInstanceProcAddr(instance, "vkCmdSetBlendConstants");
    out->vkCmdSetDepthBounds =
        (PFN_vkCmdSetDepthBounds)vk->vkGetInstanceProcAddr(instance, "vkCmdSetDepthBounds");
    out->vkCmdSetStencilCompareMask = (PFN_vkCmdSetStencilCompareMask)vk->vkGetInstanceProcAddr(
        instance, "vkCmdSetStencilCompareMask");
    out->vkCmdSetStencilWriteMask = (PFN_vkCmdSetStencilWriteMask)vk->vkGetInstanceProcAddr(
        instance, "vkCmdSetStencilWriteMask");
    out->vkCmdSetStencilReference = (PFN_vkCmdSetStencilReference)vk->vkGetInstanceProcAddr(
        instance, "vkCmdSetStencilReference");
    out->vkCmdBindDescriptorSets =
        (PFN_vkCmdBindDescriptorSets)vk->vkGetInstanceProcAddr(instance, "vkCmdBindDescriptorSets");
    out->vkCmdBindIndexBuffer =
        (PFN_vkCmdBindIndexBuffer)vk->vkGetInstanceProcAddr(instance, "vkCmdBindIndexBuffer");
    out->vkCmdBindVertexBuffers =
        (PFN_vkCmdBindVertexBuffers)vk->vkGetInstanceProcAddr(instance, "vkCmdBindVertexBuffers");
    out->vkCmdDraw = (PFN_vkCmdDraw)vk->vkGetInstanceProcAddr(instance, "vkCmdDraw");
    out->vkCmdDrawIndexed =
        (PFN_vkCmdDrawIndexed)vk->vkGetInstanceProcAddr(instance, "vkCmdDrawIndexed");
    out->vkCmdDrawIndirect =
        (PFN_vkCmdDrawIndirect)vk->vkGetInstanceProcAddr(instance, "vkCmdDrawIndirect");
    out->vkCmdDrawIndexedIndirect = (PFN_vkCmdDrawIndexedIndirect)vk->vkGetInstanceProcAddr(
        instance, "vkCmdDrawIndexedIndirect");
    out->vkCmdDispatch = (PFN_vkCmdDispatch)vk->vkGetInstanceProcAddr(instance, "vkCmdDispatch");
    out->vkCmdDispatchIndirect =
        (PFN_vkCmdDispatchIndirect)vk->vkGetInstanceProcAddr(instance, "vkCmdDispatchIndirect");
    out->vkCmdCopyBuffer =
        (PFN_vkCmdCopyBuffer)vk->vkGetInstanceProcAddr(instance, "vkCmdCopyBuffer");
    out->vkCmdCopyImage = (PFN_vkCmdCopyImage)vk->vkGetInstanceProcAddr(instance, "vkCmdCopyImage");
    out->vkCmdBlitImage = (PFN_vkCmdBlitImage)vk->vkGetInstanceProcAddr(instance, "vkCmdBlitImage");
    out->vkCmdCopyBufferToImage =
        (PFN_vkCmdCopyBufferToImage)vk->vkGetInstanceProcAddr(instance, "vkCmdCopyBufferToImage");
    out->vkCmdCopyImageToBuffer =
        (PFN_vkCmdCopyImageToBuffer)vk->vkGetInstanceProcAddr(instance, "vkCmdCopyImageToBuffer");
    out->vkCmdUpdateBuffer =
        (PFN_vkCmdUpdateBuffer)vk->vkGetInstanceProcAddr(instance, "vkCmdUpdateBuffer");
    out->vkCmdFillBuffer =
        (PFN_vkCmdFillBuffer)vk->vkGetInstanceProcAddr(instance, "vkCmdFillBuffer");
    out->vkCmdClearColorImage =
        (PFN_vkCmdClearColorImage)vk->vkGetInstanceProcAddr(instance, "vkCmdClearColorImage");
    out->vkCmdClearDepthStencilImage = (PFN_vkCmdClearDepthStencilImage)vk->vkGetInstanceProcAddr(
        instance, "vkCmdClearDepthStencilImage");
    out->vkCmdClearAttachments =
        (PFN_vkCmdClearAttachments)vk->vkGetInstanceProcAddr(instance, "vkCmdClearAttachments");
    out->vkCmdResolveImage =
        (PFN_vkCmdResolveImage)vk->vkGetInstanceProcAddr(instance, "vkCmdResolveImage");
    out->vkCmdSetEvent = (PFN_vkCmdSetEvent)vk->vkGetInstanceProcAddr(instance, "vkCmdSetEvent");
    out->vkCmdResetEvent =
        (PFN_vkCmdResetEvent)vk->vkGetInstanceProcAddr(instance, "vkCmdResetEvent");
    out->vkCmdWaitEvents =
        (PFN_vkCmdWaitEvents)vk->vkGetInstanceProcAddr(instance, "vkCmdWaitEvents");
    out->vkCmdPipelineBarrier =
        (PFN_vkCmdPipelineBarrier)vk->vkGetInstanceProcAddr(instance, "vkCmdPipelineBarrier");
    out->vkCmdBeginQuery =
        (PFN_vkCmdBeginQuery)vk->vkGetInstanceProcAddr(instance, "vkCmdBeginQuery");
    out->vkCmdEndQuery = (PFN_vkCmdEndQuery)vk->vkGetInstanceProcAddr(instance, "vkCmdEndQuery");
    out->vkCmdResetQueryPool =
        (PFN_vkCmdResetQueryPool)vk->vkGetInstanceProcAddr(instance, "vkCmdResetQueryPool");
    out->vkCmdWriteTimestamp =
        (PFN_vkCmdWriteTimestamp)vk->vkGetInstanceProcAddr(instance, "vkCmdWriteTimestamp");
    out->vkCmdCopyQueryPoolResults = (PFN_vkCmdCopyQueryPoolResults)vk->vkGetInstanceProcAddr(
        instance, "vkCmdCopyQueryPoolResults");
    out->vkCmdPushConstants =
        (PFN_vkCmdPushConstants)vk->vkGetInstanceProcAddr(instance, "vkCmdPushConstants");
    out->vkCmdBeginRenderPass =
        (PFN_vkCmdBeginRenderPass)vk->vkGetInstanceProcAddr(instance, "vkCmdBeginRenderPass");
    out->vkCmdNextSubpass =
        (PFN_vkCmdNextSubpass)vk->vkGetInstanceProcAddr(instance, "vkCmdNextSubpass");
    out->vkCmdEndRenderPass =
        (PFN_vkCmdEndRenderPass)vk->vkGetInstanceProcAddr(instance, "vkCmdEndRenderPass");
    out->vkCmdExecuteCommands =
        (PFN_vkCmdExecuteCommands)vk->vkGetInstanceProcAddr(instance, "vkCmdExecuteCommands");
#endif
#ifdef VK_VERSION_1_1
    out->vkBindBufferMemory2 =
        (PFN_vkBindBufferMemory2)vk->vkGetInstanceProcAddr(instance, "vkBindBufferMemory2");
    out->vkBindImageMemory2 =
        (PFN_vkBindImageMemory2)vk->vkGetInstanceProcAddr(instance, "vkBindImageMemory2");
    out->vkGetDeviceGroupPeerMemoryFeatures =
        (PFN_vkGetDeviceGroupPeerMemoryFeatures)vk->vkGetInstanceProcAddr(
            instance, "vkGetDeviceGroupPeerMemoryFeatures");
    out->vkCmdSetDeviceMask =
        (PFN_vkCmdSetDeviceMask)vk->vkGetInstanceProcAddr(instance, "vkCmdSetDeviceMask");
    out->vkCmdDispatchBase =
        (PFN_vkCmdDispatchBase)vk->vkGetInstanceProcAddr(instance, "vkCmdDispatchBase");
    out->vkGetImageMemoryRequirements2 =
        (PFN_vkGetImageMemoryRequirements2)vk->vkGetInstanceProcAddr(
            instance, "vkGetImageMemoryRequirements2");
    out->vkGetBufferMemoryRequirements2 =
        (PFN_vkGetBufferMemoryRequirements2)vk->vkGetInstanceProcAddr(
            instance, "vkGetBufferMemoryRequirements2");
    out->vkGetImageSparseMemoryRequirements2 =
        (PFN_vkGetImageSparseMemoryRequirements2)vk->vkGetInstanceProcAddr(
            instance, "vkGetImageSparseMemoryRequirements2");
    out->vkTrimCommandPool =
        (PFN_vkTrimCommandPool)vk->vkGetInstanceProcAddr(instance, "vkTrimCommandPool");
    out->vkGetDeviceQueue2 =
        (PFN_vkGetDeviceQueue2)vk->vkGetInstanceProcAddr(instance, "vkGetDeviceQueue2");
    out->vkCreateSamplerYcbcrConversion =
        (PFN_vkCreateSamplerYcbcrConversion)vk->vkGetInstanceProcAddr(
            instance, "vkCreateSamplerYcbcrConversion");
    out->vkDestroySamplerYcbcrConversion =
        (PFN_vkDestroySamplerYcbcrConversion)vk->vkGetInstanceProcAddr(
            instance, "vkDestroySamplerYcbcrConversion");
    out->vkCreateDescriptorUpdateTemplate =
        (PFN_vkCreateDescriptorUpdateTemplate)vk->vkGetInstanceProcAddr(
            instance, "vkCreateDescriptorUpdateTemplate");
    out->vkDestroyDescriptorUpdateTemplate =
        (PFN_vkDestroyDescriptorUpdateTemplate)vk->vkGetInstanceProcAddr(
            instance, "vkDestroyDescriptorUpdateTemplate");
    out->vkUpdateDescriptorSetWithTemplate =
        (PFN_vkUpdateDescriptorSetWithTemplate)vk->vkGetInstanceProcAddr(
            instance, "vkUpdateDescriptorSetWithTemplate");
    out->vkGetDescriptorSetLayoutSupport =
        (PFN_vkGetDescriptorSetLayoutSupport)vk->vkGetInstanceProcAddr(
            instance, "vkGetDescriptorSetLayoutSupport");
#endif
#ifdef VK_VERSION_1_2
    out->vkCmdDrawIndirectCount =
        (PFN_vkCmdDrawIndirectCount)vk->vkGetInstanceProcAddr(instance, "vkCmdDrawIndirectCount");
    out->vkCmdDrawIndexedIndirectCount =
        (PFN_vkCmdDrawIndexedIndirectCount)vk->vkGetInstanceProcAddr(
            instance, "vkCmdDrawIndexedIndirectCount");
    out->vkCreateRenderPass2 =
        (PFN_vkCreateRenderPass2)vk->vkGetInstanceProcAddr(instance, "vkCreateRenderPass2");
    out->vkCmdBeginRenderPass2 =
        (PFN_vkCmdBeginRenderPass2)vk->vkGetInstanceProcAddr(instance, "vkCmdBeginRenderPass2");
    out->vkCmdNextSubpass2 =
        (PFN_vkCmdNextSubpass2)vk->vkGetInstanceProcAddr(instance, "vkCmdNextSubpass2");
    out->vkCmdEndRenderPass2 =
        (PFN_vkCmdEndRenderPass2)vk->vkGetInstanceProcAddr(instance, "vkCmdEndRenderPass2");
    out->vkResetQueryPool =
        (PFN_vkResetQueryPool)vk->vkGetInstanceProcAddr(instance, "vkResetQueryPool");
    out->vkGetSemaphoreCounterValue = (PFN_vkGetSemaphoreCounterValue)vk->vkGetInstanceProcAddr(
        instance, "vkGetSemaphoreCounterValue");
    out->vkWaitSemaphores =
        (PFN_vkWaitSemaphores)vk->vkGetInstanceProcAddr(instance, "vkWaitSemaphores");
    out->vkSignalSemaphore =
        (PFN_vkSignalSemaphore)vk->vkGetInstanceProcAddr(instance, "vkSignalSemaphore");
    out->vkGetBufferDeviceAddress = (PFN_vkGetBufferDeviceAddress)vk->vkGetInstanceProcAddr(
        instance, "vkGetBufferDeviceAddress");
    out->vkGetBufferOpaqueCaptureAddress =
        (PFN_vkGetBufferOpaqueCaptureAddress)vk->vkGetInstanceProcAddr(
            instance, "vkGetBufferOpaqueCaptureAddress");
    out->vkGetDeviceMemoryOpaqueCaptureAddress =
        (PFN_vkGetDeviceMemoryOpaqueCaptureAddress)vk->vkGetInstanceProcAddr(
            instance, "vkGetDeviceMemoryOpaqueCaptureAddress");
#endif
#ifdef VK_VERSION_1_3
    out->vkGetPhysicalDeviceToolProperties =
        (PFN_vkGetPhysicalDeviceToolProperties)vk->vkGetInstanceProcAddr(
            instance, "vkGetPhysicalDeviceToolProperties");
    out->vkCreatePrivateDataSlot =
        (PFN_vkCreatePrivateDataSlot)vk->vkGetInstanceProcAddr(instance, "vkCreatePrivateDataSlot");
    out->vkDestroyPrivateDataSlot = (PFN_vkDestroyPrivateDataSlot)vk->vkGetInstanceProcAddr(
        instance, "vkDestroyPrivateDataSlot");
    out->vkSetPrivateData =
        (PFN_vkSetPrivateData)vk->vkGetInstanceProcAddr(instance, "vkSetPrivateData");
    out->vkGetPrivateData =
        (PFN_vkGetPrivateData)vk->vkGetInstanceProcAddr(instance, "vkGetPrivateData");
    out->vkCmdSetEvent2 = (PFN_vkCmdSetEvent2)vk->vkGetInstanceProcAddr(instance, "vkCmdSetEvent2");
    out->vkCmdResetEvent2 =
        (PFN_vkCmdResetEvent2)vk->vkGetInstanceProcAddr(instance, "vkCmdResetEvent2");
    out->vkCmdWaitEvents2 =
        (PFN_vkCmdWaitEvents2)vk->vkGetInstanceProcAddr(instance, "vkCmdWaitEvents2");
    out->vkCmdPipelineBarrier2 =
        (PFN_vkCmdPipelineBarrier2)vk->vkGetInstanceProcAddr(instance, "vkCmdPipelineBarrier2");
    out->vkCmdWriteTimestamp2 =
        (PFN_vkCmdWriteTimestamp2)vk->vkGetInstanceProcAddr(instance, "vkCmdWriteTimestamp2");
    out->vkQueueSubmit2 = (PFN_vkQueueSubmit2)vk->vkGetInstanceProcAddr(instance, "vkQueueSubmit2");
    out->vkCmdCopyBuffer2 =
        (PFN_vkCmdCopyBuffer2)vk->vkGetInstanceProcAddr(instance, "vkCmdCopyBuffer2");
    out->vkCmdCopyImage2 =
        (PFN_vkCmdCopyImage2)vk->vkGetInstanceProcAddr(instance, "vkCmdCopyImage2");
    out->vkCmdCopyBufferToImage2 =
        (PFN_vkCmdCopyBufferToImage2)vk->vkGetInstanceProcAddr(instance, "vkCmdCopyBufferToImage2");
    out->vkCmdCopyImageToBuffer2 =
        (PFN_vkCmdCopyImageToBuffer2)vk->vkGetInstanceProcAddr(instance, "vkCmdCopyImageToBuffer2");
    out->vkCmdBlitImage2 =
        (PFN_vkCmdBlitImage2)vk->vkGetInstanceProcAddr(instance, "vkCmdBlitImage2");
    out->vkCmdResolveImage2 =
        (PFN_vkCmdResolveImage2)vk->vkGetInstanceProcAddr(instance, "vkCmdResolveImage2");
    out->vkCmdBeginRendering =
        (PFN_vkCmdBeginRendering)vk->vkGetInstanceProcAddr(instance, "vkCmdBeginRendering");
    out->vkCmdEndRendering =
        (PFN_vkCmdEndRendering)vk->vkGetInstanceProcAddr(instance, "vkCmdEndRendering");
    out->vkCmdSetCullMode =
        (PFN_vkCmdSetCullMode)vk->vkGetInstanceProcAddr(instance, "vkCmdSetCullMode");
    out->vkCmdSetFrontFace =
        (PFN_vkCmdSetFrontFace)vk->vkGetInstanceProcAddr(instance, "vkCmdSetFrontFace");
    out->vkCmdSetPrimitiveTopology = (PFN_vkCmdSetPrimitiveTopology)vk->vkGetInstanceProcAddr(
        instance, "vkCmdSetPrimitiveTopology");
    out->vkCmdSetViewportWithCount = (PFN_vkCmdSetViewportWithCount)vk->vkGetInstanceProcAddr(
        instance, "vkCmdSetViewportWithCount");
    out->vkCmdSetScissorWithCount = (PFN_vkCmdSetScissorWithCount)vk->vkGetInstanceProcAddr(
        instance, "vkCmdSetScissorWithCount");
    out->vkCmdBindVertexBuffers2 =
        (PFN_vkCmdBindVertexBuffers2)vk->vkGetInstanceProcAddr(instance, "vkCmdBindVertexBuffers2");
    out->vkCmdSetDepthTestEnable =
        (PFN_vkCmdSetDepthTestEnable)vk->vkGetInstanceProcAddr(instance, "vkCmdSetDepthTestEnable");
    out->vkCmdSetDepthWriteEnable = (PFN_vkCmdSetDepthWriteEnable)vk->vkGetInstanceProcAddr(
        instance, "vkCmdSetDepthWriteEnable");
    out->vkCmdSetDepthCompareOp =
        (PFN_vkCmdSetDepthCompareOp)vk->vkGetInstanceProcAddr(instance, "vkCmdSetDepthCompareOp");
    out->vkCmdSetDepthBoundsTestEnable =
        (PFN_vkCmdSetDepthBoundsTestEnable)vk->vkGetInstanceProcAddr(
            instance, "vkCmdSetDepthBoundsTestEnable");
    out->vkCmdSetStencilTestEnable = (PFN_vkCmdSetStencilTestEnable)vk->vkGetInstanceProcAddr(
        instance, "vkCmdSetStencilTestEnable");
    out->vkCmdSetStencilOp =
        (PFN_vkCmdSetStencilOp)vk->vkGetInstanceProcAddr(instance, "vkCmdSetStencilOp");
    out->vkCmdSetRasterizerDiscardEnable =
        (PFN_vkCmdSetRasterizerDiscardEnable)vk->vkGetInstanceProcAddr(
            instance, "vkCmdSetRasterizerDiscardEnable");
    out->vkCmdSetDepthBiasEnable =
        (PFN_vkCmdSetDepthBiasEnable)vk->vkGetInstanceProcAddr(instance, "vkCmdSetDepthBiasEnable");
    out->vkCmdSetPrimitiveRestartEnable =
        (PFN_vkCmdSetPrimitiveRestartEnable)vk->vkGetInstanceProcAddr(
            instance, "vkCmdSetPrimitiveRestartEnable");
    out->vkGetDeviceBufferMemoryRequirements =
        (PFN_vkGetDeviceBufferMemoryRequirements)vk->vkGetInstanceProcAddr(
            instance, "vkGetDeviceBufferMemoryRequirements");
    out->vkGetDeviceImageMemoryRequirements =
        (PFN_vkGetDeviceImageMemoryRequirements)vk->vkGetInstanceProcAddr(
            instance, "vkGetDeviceImageMemoryRequirements");
    out->vkGetDeviceImageSparseMemoryRequirements =
        (PFN_vkGetDeviceImageSparseMemoryRequirements)vk->vkGetInstanceProcAddr(
            instance, "vkGetDeviceImageSparseMemoryRequirements");
#endif
#ifdef VK_KHR_surface
    out->vkGetPhysicalDeviceSurfaceSupportKHR =
        (PFN_vkGetPhysicalDeviceSurfaceSupportKHR)vk->vkGetInstanceProcAddr(
            instance, "vkGetPhysicalDeviceSurfaceSupportKHR");
    out->vkGetPhysicalDeviceSurfaceCapabilitiesKHR =
        (PFN_vkGetPhysicalDeviceSurfaceCapabilitiesKHR)vk->vkGetInstanceProcAddr(
            instance, "vkGetPhysicalDeviceSurfaceCapabilitiesKHR");
    out->vkGetPhysicalDeviceSurfaceFormatsKHR =
        (PFN_vkGetPhysicalDeviceSurfaceFormatsKHR)vk->vkGetInstanceProcAddr(
            instance, "vkGetPhysicalDeviceSurfaceFormatsKHR");
    out->vkGetPhysicalDeviceSurfacePresentModesKHR =
        (PFN_vkGetPhysicalDeviceSurfacePresentModesKHR)vk->vkGetInstanceProcAddr(
            instance, "vkGetPhysicalDeviceSurfacePresentModesKHR");
#endif
#ifdef VK_KHR_swapchain
    out->vkGetDeviceGroupPresentCapabilitiesKHR =
        (PFN_vkGetDeviceGroupPresentCapabilitiesKHR)vk->vkGetInstanceProcAddr(
            instance, "vkGetDeviceGroupPresentCapabilitiesKHR");
    out->vkGetDeviceGroupSurfacePresentModesKHR =
        (PFN_vkGetDeviceGroupSurfacePresentModesKHR)vk->vkGetInstanceProcAddr(
            instance, "vkGetDeviceGroupSurfacePresentModesKHR");
    out->vkGetPhysicalDevicePresentRectanglesKHR =
        (PFN_vkGetPhysicalDevicePresentRectanglesKHR)vk->vkGetInstanceProcAddr(
            instance, "vkGetPhysicalDevicePresentRectanglesKHR");
    out->vkAcquireNextImage2KHR =
        (PFN_vkAcquireNextImage2KHR)vk->vkGetInstanceProcAddr(instance, "vkAcquireNextImage2KHR");
#endif
#ifdef VK_KHR_dynamic_rendering
    out->vkCmdBeginRenderingKHR =
        (PFN_vkCmdBeginRenderingKHR)vk->vkGetInstanceProcAddr(instance, "vkCmdBeginRenderingKHR");
    out->vkCmdEndRenderingKHR =
        (PFN_vkCmdEndRenderingKHR)vk->vkGetInstanceProcAddr(instance, "vkCmdEndRenderingKHR");
#endif
#ifdef VK_KHR_get_physical_device_properties2
    out->vkGetPhysicalDeviceFeatures2KHR =
        (PFN_vkGetPhysicalDeviceFeatures2KHR)vk->vkGetInstanceProcAddr(
            instance, "vkGetPhysicalDeviceFeatures2KHR");
    out->vkGetPhysicalDeviceProperties2KHR =
        (PFN_vkGetPhysicalDeviceProperties2KHR)vk->vkGetInstanceProcAddr(
            instance, "vkGetPhysicalDeviceProperties2KHR");
    out->vkGetPhysicalDeviceFormatProperties2KHR =
        (PFN_vkGetPhysicalDeviceFormatProperties2KHR)vk->vkGetInstanceProcAddr(
            instance, "vkGetPhysicalDeviceFormatProperties2KHR");
    out->vkGetPhysicalDeviceImageFormatProperties2KHR =
        (PFN_vkGetPhysicalDeviceImageFormatProperties2KHR)vk->vkGetInstanceProcAddr(
            instance, "vkGetPhysicalDeviceImageFormatProperties2KHR");
    out->vkGetPhysicalDeviceQueueFamilyProperties2KHR =
        (PFN_vkGetPhysicalDeviceQueueFamilyProperties2KHR)vk->vkGetInstanceProcAddr(
            instance, "vkGetPhysicalDeviceQueueFamilyProperties2KHR");
    out->vkGetPhysicalDeviceMemoryProperties2KHR =
        (PFN_vkGetPhysicalDeviceMemoryProperties2KHR)vk->vkGetInstanceProcAddr(
            instance, "vkGetPhysicalDeviceMemoryProperties2KHR");
    out->vkGetPhysicalDeviceSparseImageFormatProperties2KHR =
        (PFN_vkGetPhysicalDeviceSparseImageFormatProperties2KHR)vk->vkGetInstanceProcAddr(
            instance, "vkGetPhysicalDeviceSparseImageFormatProperties2KHR");
#endif
#ifdef VK_KHR_maintenance1
    out->vkTrimCommandPoolKHR =
        (PFN_vkTrimCommandPoolKHR)vk->vkGetInstanceProcAddr(instance, "vkTrimCommandPoolKHR");
#endif
#ifdef VK_KHR_external_memory_capabilities
    out->vkGetPhysicalDeviceExternalBufferPropertiesKHR =
        (PFN_vkGetPhysicalDeviceExternalBufferPropertiesKHR)vk->vkGetInstanceProcAddr(
            instance, "vkGetPhysicalDeviceExternalBufferPropertiesKHR");
#endif
#ifdef VK_KHR_external_memory_win32
    out->vkGetMemoryWin32HandleKHR = (PFN_vkGetMemoryWin32HandleKHR)vk->vkGetInstanceProcAddr(
        instance, "vkGetMemoryWin32HandleKHR");
    out->vkGetMemoryWin32HandlePropertiesKHR =
        (PFN_vkGetMemoryWin32HandlePropertiesKHR)vk->vkGetInstanceProcAddr(
            instance, "vkGetMemoryWin32HandlePropertiesKHR");
#endif
#ifdef VK_KHR_external_memory_fd
    out->vkGetMemoryFdKHR =
        (PFN_vkGetMemoryFdKHR)vk->vkGetInstanceProcAddr(instance, "vkGetMemoryFdKHR");
    out->vkGetMemoryFdPropertiesKHR = (PFN_vkGetMemoryFdPropertiesKHR)vk->vkGetInstanceProcAddr(
        instance, "vkGetMemoryFdPropertiesKHR");
#endif
#ifdef VK_KHR_external_semaphore_capabilities
    out->vkGetPhysicalDeviceExternalSemaphorePropertiesKHR =
        (PFN_vkGetPhysicalDeviceExternalSemaphorePropertiesKHR)vk->vkGetInstanceProcAddr(
            instance, "vkGetPhysicalDeviceExternalSemaphorePropertiesKHR");
#endif
#ifdef VK_KHR_external_semaphore_win32
    out->vkImportSemaphoreWin32HandleKHR =
        (PFN_vkImportSemaphoreWin32HandleKHR)vk->vkGetInstanceProcAddr(
            instance, "vkImportSemaphoreWin32HandleKHR");
    out->vkGetSemaphoreWin32HandleKHR = (PFN_vkGetSemaphoreWin32HandleKHR)vk->vkGetInstanceProcAddr(
        instance, "vkGetSemaphoreWin32HandleKHR");
#endif
#ifdef VK_KHR_external_semaphore_fd
    out->vkImportSemaphoreFdKHR =
        (PFN_vkImportSemaphoreFdKHR)vk->vkGetInstanceProcAddr(instance, "vkImportSemaphoreFdKHR");
    out->vkGetSemaphoreFdKHR =
        (PFN_vkGetSemaphoreFdKHR)vk->vkGetInstanceProcAddr(instance, "vkGetSemaphoreFdKHR");
#endif
#ifdef VK_KHR_descriptor_update_template
    out->vkCreateDescriptorUpdateTemplateKHR =
        (PFN_vkCreateDescriptorUpdateTemplateKHR)vk->vkGetInstanceProcAddr(
            instance, "vkCreateDescriptorUpdateTemplateKHR");
    out->vkDestroyDescriptorUpdateTemplateKHR =
        (PFN_vkDestroyDescriptorUpdateTemplateKHR)vk->vkGetInstanceProcAddr(
            instance, "vkDestroyDescriptorUpdateTemplateKHR");
    out->vkUpdateDescriptorSetWithTemplateKHR =
        (PFN_vkUpdateDescriptorSetWithTemplateKHR)vk->vkGetInstanceProcAddr(
            instance, "vkUpdateDescriptorSetWithTemplateKHR");
#endif
#ifdef VK_KHR_create_renderpass2
    out->vkCreateRenderPass2KHR =
        (PFN_vkCreateRenderPass2KHR)vk->vkGetInstanceProcAddr(instance, "vkCreateRenderPass2KHR");
    out->vkCmdBeginRenderPass2KHR = (PFN_vkCmdBeginRenderPass2KHR)vk->vkGetInstanceProcAddr(
        instance, "vkCmdBeginRenderPass2KHR");
    out->vkCmdNextSubpass2KHR =
        (PFN_vkCmdNextSubpass2KHR)vk->vkGetInstanceProcAddr(instance, "vkCmdNextSubpass2KHR");
    out->vkCmdEndRenderPass2KHR =
        (PFN_vkCmdEndRenderPass2KHR)vk->vkGetInstanceProcAddr(instance, "vkCmdEndRenderPass2KHR");
#endif
#ifdef VK_KHR_external_fence_capabilities
    out->vkGetPhysicalDeviceExternalFencePropertiesKHR =
        (PFN_vkGetPhysicalDeviceExternalFencePropertiesKHR)vk->vkGetInstanceProcAddr(
            instance, "vkGetPhysicalDeviceExternalFencePropertiesKHR");
#endif
#ifdef VK_KHR_external_fence_fd
    out->vkImportFenceFdKHR =
        (PFN_vkImportFenceFdKHR)vk->vkGetInstanceProcAddr(instance, "vkImportFenceFdKHR");
    out->vkGetFenceFdKHR =
        (PFN_vkGetFenceFdKHR)vk->vkGetInstanceProcAddr(instance, "vkGetFenceFdKHR");
#endif
#ifdef VK_KHR_get_memory_requirements2
    out->vkGetImageMemoryRequirements2KHR =
        (PFN_vkGetImageMemoryRequirements2KHR)vk->vkGetInstanceProcAddr(
            instance, "vkGetImageMemoryRequirements2KHR");
    out->vkGetBufferMemoryRequirements2KHR =
        (PFN_vkGetBufferMemoryRequirements2KHR)vk->vkGetInstanceProcAddr(
            instance, "vkGetBufferMemoryRequirements2KHR");
    out->vkGetImageSparseMemoryRequirements2KHR =
        (PFN_vkGetImageSparseMemoryRequirements2KHR)vk->vkGetInstanceProcAddr(
            instance, "vkGetImageSparseMemoryRequirements2KHR");
#endif
#ifdef VK_KHR_sampler_ycbcr_conversion
    out->vkCreateSamplerYcbcrConversionKHR =
        (PFN_vkCreateSamplerYcbcrConversionKHR)vk->vkGetInstanceProcAddr(
            instance, "vkCreateSamplerYcbcrConversionKHR");
    out->vkDestroySamplerYcbcrConversionKHR =
        (PFN_vkDestroySamplerYcbcrConversionKHR)vk->vkGetInstanceProcAddr(
            instance, "vkDestroySamplerYcbcrConversionKHR");
#endif
#ifdef VK_KHR_bind_memory2
    out->vkBindBufferMemory2KHR =
        (PFN_vkBindBufferMemory2KHR)vk->vkGetInstanceProcAddr(instance, "vkBindBufferMemory2KHR");
    out->vkBindImageMemory2KHR =
        (PFN_vkBindImageMemory2KHR)vk->vkGetInstanceProcAddr(instance, "vkBindImageMemory2KHR");
#endif
#ifdef VK_KHR_maintenance3
    out->vkGetDescriptorSetLayoutSupportKHR =
        (PFN_vkGetDescriptorSetLayoutSupportKHR)vk->vkGetInstanceProcAddr(
            instance, "vkGetDescriptorSetLayoutSupportKHR");
#endif
#ifdef VK_KHR_buffer_device_address
    out->vkGetBufferDeviceAddressKHR = (PFN_vkGetBufferDeviceAddressKHR)vk->vkGetInstanceProcAddr(
        instance, "vkGetBufferDeviceAddressKHR");
    out->vkGetBufferOpaqueCaptureAddressKHR =
        (PFN_vkGetBufferOpaqueCaptureAddressKHR)vk->vkGetInstanceProcAddr(
            instance, "vkGetBufferOpaqueCaptureAddressKHR");
    out->vkGetDeviceMemoryOpaqueCaptureAddressKHR =
        (PFN_vkGetDeviceMemoryOpaqueCaptureAddressKHR)vk->vkGetInstanceProcAddr(
            instance, "vkGetDeviceMemoryOpaqueCaptureAddressKHR");
#endif
#ifdef VK_KHR_pipeline_executable_properties
    out->vkGetPipelineExecutablePropertiesKHR =
        (PFN_vkGetPipelineExecutablePropertiesKHR)vk->vkGetInstanceProcAddr(
            instance, "vkGetPipelineExecutablePropertiesKHR");
    out->vkGetPipelineExecutableStatisticsKHR =
        (PFN_vkGetPipelineExecutableStatisticsKHR)vk->vkGetInstanceProcAddr(
            instance, "vkGetPipelineExecutableStatisticsKHR");
    out->vkGetPipelineExecutableInternalRepresentationsKHR =
        (PFN_vkGetPipelineExecutableInternalRepresentationsKHR)vk->vkGetInstanceProcAddr(
            instance, "vkGetPipelineExecutableInternalRepresentationsKHR");
#endif
#ifdef VK_KHR_synchronization2
    out->vkCmdSetEvent2KHR =
        (PFN_vkCmdSetEvent2KHR)vk->vkGetInstanceProcAddr(instance, "vkCmdSetEvent2KHR");
    out->vkCmdResetEvent2KHR =
        (PFN_vkCmdResetEvent2KHR)vk->vkGetInstanceProcAddr(instance, "vkCmdResetEvent2KHR");
    out->vkCmdWaitEvents2KHR =
        (PFN_vkCmdWaitEvents2KHR)vk->vkGetInstanceProcAddr(instance, "vkCmdWaitEvents2KHR");
    out->vkCmdPipelineBarrier2KHR = (PFN_vkCmdPipelineBarrier2KHR)vk->vkGetInstanceProcAddr(
        instance, "vkCmdPipelineBarrier2KHR");
    out->vkCmdWriteTimestamp2KHR =
        (PFN_vkCmdWriteTimestamp2KHR)vk->vkGetInstanceProcAddr(instance, "vkCmdWriteTimestamp2KHR");
    out->vkQueueSubmit2KHR =
        (PFN_vkQueueSubmit2KHR)vk->vkGetInstanceProcAddr(instance, "vkQueueSubmit2KHR");
    out->vkCmdWriteBufferMarker2AMD = (PFN_vkCmdWriteBufferMarker2AMD)vk->vkGetInstanceProcAddr(
        instance, "vkCmdWriteBufferMarker2AMD");
    out->vkGetQueueCheckpointData2NV = (PFN_vkGetQueueCheckpointData2NV)vk->vkGetInstanceProcAddr(
        instance, "vkGetQueueCheckpointData2NV");
#endif
#ifdef VK_KHR_copy_commands2
    out->vkCmdCopyBuffer2KHR =
        (PFN_vkCmdCopyBuffer2KHR)vk->vkGetInstanceProcAddr(instance, "vkCmdCopyBuffer2KHR");
    out->vkCmdCopyImage2KHR =
        (PFN_vkCmdCopyImage2KHR)vk->vkGetInstanceProcAddr(instance, "vkCmdCopyImage2KHR");
    out->vkCmdCopyBufferToImage2KHR = (PFN_vkCmdCopyBufferToImage2KHR)vk->vkGetInstanceProcAddr(
        instance, "vkCmdCopyBufferToImage2KHR");
    out->vkCmdCopyImageToBuffer2KHR = (PFN_vkCmdCopyImageToBuffer2KHR)vk->vkGetInstanceProcAddr(
        instance, "vkCmdCopyImageToBuffer2KHR");
    out->vkCmdBlitImage2KHR =
        (PFN_vkCmdBlitImage2KHR)vk->vkGetInstanceProcAddr(instance, "vkCmdBlitImage2KHR");
    out->vkCmdResolveImage2KHR =
        (PFN_vkCmdResolveImage2KHR)vk->vkGetInstanceProcAddr(instance, "vkCmdResolveImage2KHR");
#endif
#ifdef VK_KHR_maintenance4
    out->vkGetDeviceBufferMemoryRequirementsKHR =
        (PFN_vkGetDeviceBufferMemoryRequirementsKHR)vk->vkGetInstanceProcAddr(
            instance, "vkGetDeviceBufferMemoryRequirementsKHR");
    out->vkGetDeviceImageMemoryRequirementsKHR =
        (PFN_vkGetDeviceImageMemoryRequirementsKHR)vk->vkGetInstanceProcAddr(
            instance, "vkGetDeviceImageMemoryRequirementsKHR");
    out->vkGetDeviceImageSparseMemoryRequirementsKHR =
        (PFN_vkGetDeviceImageSparseMemoryRequirementsKHR)vk->vkGetInstanceProcAddr(
            instance, "vkGetDeviceImageSparseMemoryRequirementsKHR");
#endif
#ifdef VK_ANDROID_native_buffer
    out->vkGetSwapchainGrallocUsageANDROID =
        (PFN_vkGetSwapchainGrallocUsageANDROID)vk->vkGetInstanceProcAddr(
            instance, "vkGetSwapchainGrallocUsageANDROID");
    out->vkAcquireImageANDROID =
        (PFN_vkAcquireImageANDROID)vk->vkGetInstanceProcAddr(instance, "vkAcquireImageANDROID");
    out->vkQueueSignalReleaseImageANDROID =
        (PFN_vkQueueSignalReleaseImageANDROID)vk->vkGetInstanceProcAddr(
            instance, "vkQueueSignalReleaseImageANDROID");
    out->vkGetSwapchainGrallocUsage2ANDROID =
        (PFN_vkGetSwapchainGrallocUsage2ANDROID)vk->vkGetInstanceProcAddr(
            instance, "vkGetSwapchainGrallocUsage2ANDROID");
#endif
#ifdef VK_EXT_transform_feedback
    out->vkCmdBindTransformFeedbackBuffersEXT =
        (PFN_vkCmdBindTransformFeedbackBuffersEXT)vk->vkGetInstanceProcAddr(
            instance, "vkCmdBindTransformFeedbackBuffersEXT");
    out->vkCmdBeginTransformFeedbackEXT =
        (PFN_vkCmdBeginTransformFeedbackEXT)vk->vkGetInstanceProcAddr(
            instance, "vkCmdBeginTransformFeedbackEXT");
    out->vkCmdEndTransformFeedbackEXT = (PFN_vkCmdEndTransformFeedbackEXT)vk->vkGetInstanceProcAddr(
        instance, "vkCmdEndTransformFeedbackEXT");
    out->vkCmdBeginQueryIndexedEXT = (PFN_vkCmdBeginQueryIndexedEXT)vk->vkGetInstanceProcAddr(
        instance, "vkCmdBeginQueryIndexedEXT");
    out->vkCmdEndQueryIndexedEXT =
        (PFN_vkCmdEndQueryIndexedEXT)vk->vkGetInstanceProcAddr(instance, "vkCmdEndQueryIndexedEXT");
    out->vkCmdDrawIndirectByteCountEXT =
        (PFN_vkCmdDrawIndirectByteCountEXT)vk->vkGetInstanceProcAddr(
            instance, "vkCmdDrawIndirectByteCountEXT");
#endif
#ifdef VK_EXT_debug_utils
    out->vkSetDebugUtilsObjectNameEXT = (PFN_vkSetDebugUtilsObjectNameEXT)vk->vkGetInstanceProcAddr(
        instance, "vkSetDebugUtilsObjectNameEXT");
    out->vkSetDebugUtilsObjectTagEXT = (PFN_vkSetDebugUtilsObjectTagEXT)vk->vkGetInstanceProcAddr(
        instance, "vkSetDebugUtilsObjectTagEXT");
    out->vkQueueBeginDebugUtilsLabelEXT =
        (PFN_vkQueueBeginDebugUtilsLabelEXT)vk->vkGetInstanceProcAddr(
            instance, "vkQueueBeginDebugUtilsLabelEXT");
    out->vkQueueEndDebugUtilsLabelEXT = (PFN_vkQueueEndDebugUtilsLabelEXT)vk->vkGetInstanceProcAddr(
        instance, "vkQueueEndDebugUtilsLabelEXT");
    out->vkQueueInsertDebugUtilsLabelEXT =
        (PFN_vkQueueInsertDebugUtilsLabelEXT)vk->vkGetInstanceProcAddr(
            instance, "vkQueueInsertDebugUtilsLabelEXT");
    out->vkCmdBeginDebugUtilsLabelEXT = (PFN_vkCmdBeginDebugUtilsLabelEXT)vk->vkGetInstanceProcAddr(
        instance, "vkCmdBeginDebugUtilsLabelEXT");
    out->vkCmdEndDebugUtilsLabelEXT = (PFN_vkCmdEndDebugUtilsLabelEXT)vk->vkGetInstanceProcAddr(
        instance, "vkCmdEndDebugUtilsLabelEXT");
    out->vkCmdInsertDebugUtilsLabelEXT =
        (PFN_vkCmdInsertDebugUtilsLabelEXT)vk->vkGetInstanceProcAddr(
            instance, "vkCmdInsertDebugUtilsLabelEXT");
#endif
#ifdef VK_EXT_tooling_info
    out->vkGetPhysicalDeviceToolPropertiesEXT =
        (PFN_vkGetPhysicalDeviceToolPropertiesEXT)vk->vkGetInstanceProcAddr(
            instance, "vkGetPhysicalDeviceToolPropertiesEXT");
#endif
#ifdef VK_EXT_line_rasterization
    out->vkCmdSetLineStippleEXT =
        (PFN_vkCmdSetLineStippleEXT)vk->vkGetInstanceProcAddr(instance, "vkCmdSetLineStippleEXT");
#endif
#ifdef VK_EXT_extended_dynamic_state
    out->vkCmdSetCullModeEXT =
        (PFN_vkCmdSetCullModeEXT)vk->vkGetInstanceProcAddr(instance, "vkCmdSetCullModeEXT");
    out->vkCmdSetFrontFaceEXT =
        (PFN_vkCmdSetFrontFaceEXT)vk->vkGetInstanceProcAddr(instance, "vkCmdSetFrontFaceEXT");
    out->vkCmdSetPrimitiveTopologyEXT = (PFN_vkCmdSetPrimitiveTopologyEXT)vk->vkGetInstanceProcAddr(
        instance, "vkCmdSetPrimitiveTopologyEXT");
    out->vkCmdSetViewportWithCountEXT = (PFN_vkCmdSetViewportWithCountEXT)vk->vkGetInstanceProcAddr(
        instance, "vkCmdSetViewportWithCountEXT");
    out->vkCmdSetScissorWithCountEXT = (PFN_vkCmdSetScissorWithCountEXT)vk->vkGetInstanceProcAddr(
        instance, "vkCmdSetScissorWithCountEXT");
    out->vkCmdBindVertexBuffers2EXT = (PFN_vkCmdBindVertexBuffers2EXT)vk->vkGetInstanceProcAddr(
        instance, "vkCmdBindVertexBuffers2EXT");
    out->vkCmdSetDepthTestEnableEXT = (PFN_vkCmdSetDepthTestEnableEXT)vk->vkGetInstanceProcAddr(
        instance, "vkCmdSetDepthTestEnableEXT");
    out->vkCmdSetDepthWriteEnableEXT = (PFN_vkCmdSetDepthWriteEnableEXT)vk->vkGetInstanceProcAddr(
        instance, "vkCmdSetDepthWriteEnableEXT");
    out->vkCmdSetDepthCompareOpEXT = (PFN_vkCmdSetDepthCompareOpEXT)vk->vkGetInstanceProcAddr(
        instance, "vkCmdSetDepthCompareOpEXT");
    out->vkCmdSetDepthBoundsTestEnableEXT =
        (PFN_vkCmdSetDepthBoundsTestEnableEXT)vk->vkGetInstanceProcAddr(
            instance, "vkCmdSetDepthBoundsTestEnableEXT");
    out->vkCmdSetStencilTestEnableEXT = (PFN_vkCmdSetStencilTestEnableEXT)vk->vkGetInstanceProcAddr(
        instance, "vkCmdSetStencilTestEnableEXT");
    out->vkCmdSetStencilOpEXT =
        (PFN_vkCmdSetStencilOpEXT)vk->vkGetInstanceProcAddr(instance, "vkCmdSetStencilOpEXT");
#endif
#ifdef VK_EXT_swapchain_maintenance1
    out->vkReleaseSwapchainImagesEXT = (PFN_vkReleaseSwapchainImagesEXT)vk->vkGetInstanceProcAddr(
        instance, "vkReleaseSwapchainImagesEXT");
#endif
#ifdef VK_EXT_private_data
    out->vkCreatePrivateDataSlotEXT = (PFN_vkCreatePrivateDataSlotEXT)vk->vkGetInstanceProcAddr(
        instance, "vkCreatePrivateDataSlotEXT");
    out->vkDestroyPrivateDataSlotEXT = (PFN_vkDestroyPrivateDataSlotEXT)vk->vkGetInstanceProcAddr(
        instance, "vkDestroyPrivateDataSlotEXT");
    out->vkSetPrivateDataEXT =
        (PFN_vkSetPrivateDataEXT)vk->vkGetInstanceProcAddr(instance, "vkSetPrivateDataEXT");
    out->vkGetPrivateDataEXT =
        (PFN_vkGetPrivateDataEXT)vk->vkGetInstanceProcAddr(instance, "vkGetPrivateDataEXT");
#endif
#ifdef VK_EXT_image_compression_control
    out->vkGetImageSubresourceLayout2EXT =
        (PFN_vkGetImageSubresourceLayout2EXT)vk->vkGetInstanceProcAddr(
            instance, "vkGetImageSubresourceLayout2EXT");
#endif
#ifdef VK_EXT_extended_dynamic_state2
    out->vkCmdSetPatchControlPointsEXT =
        (PFN_vkCmdSetPatchControlPointsEXT)vk->vkGetInstanceProcAddr(
            instance, "vkCmdSetPatchControlPointsEXT");
    out->vkCmdSetRasterizerDiscardEnableEXT =
        (PFN_vkCmdSetRasterizerDiscardEnableEXT)vk->vkGetInstanceProcAddr(
            instance, "vkCmdSetRasterizerDiscardEnableEXT");
    out->vkCmdSetDepthBiasEnableEXT = (PFN_vkCmdSetDepthBiasEnableEXT)vk->vkGetInstanceProcAddr(
        instance, "vkCmdSetDepthBiasEnableEXT");
    out->vkCmdSetLogicOpEXT =
        (PFN_vkCmdSetLogicOpEXT)vk->vkGetInstanceProcAddr(instance, "vkCmdSetLogicOpEXT");
    out->vkCmdSetPrimitiveRestartEnableEXT =
        (PFN_vkCmdSetPrimitiveRestartEnableEXT)vk->vkGetInstanceProcAddr(
            instance, "vkCmdSetPrimitiveRestartEnableEXT");
#endif
#ifdef VK_GOOGLE_gfxstream
    out->vkMapMemoryIntoAddressSpaceGOOGLE =
        (PFN_vkMapMemoryIntoAddressSpaceGOOGLE)vk->vkGetInstanceProcAddr(
            instance, "vkMapMemoryIntoAddressSpaceGOOGLE");
    out->vkUpdateDescriptorSetWithTemplateSizedGOOGLE =
        (PFN_vkUpdateDescriptorSetWithTemplateSizedGOOGLE)vk->vkGetInstanceProcAddr(
            instance, "vkUpdateDescriptorSetWithTemplateSizedGOOGLE");
    out->vkBeginCommandBufferAsyncGOOGLE =
        (PFN_vkBeginCommandBufferAsyncGOOGLE)vk->vkGetInstanceProcAddr(
            instance, "vkBeginCommandBufferAsyncGOOGLE");
    out->vkEndCommandBufferAsyncGOOGLE =
        (PFN_vkEndCommandBufferAsyncGOOGLE)vk->vkGetInstanceProcAddr(
            instance, "vkEndCommandBufferAsyncGOOGLE");
    out->vkResetCommandBufferAsyncGOOGLE =
        (PFN_vkResetCommandBufferAsyncGOOGLE)vk->vkGetInstanceProcAddr(
            instance, "vkResetCommandBufferAsyncGOOGLE");
    out->vkCommandBufferHostSyncGOOGLE =
        (PFN_vkCommandBufferHostSyncGOOGLE)vk->vkGetInstanceProcAddr(
            instance, "vkCommandBufferHostSyncGOOGLE");
    out->vkCreateImageWithRequirementsGOOGLE =
        (PFN_vkCreateImageWithRequirementsGOOGLE)vk->vkGetInstanceProcAddr(
            instance, "vkCreateImageWithRequirementsGOOGLE");
    out->vkCreateBufferWithRequirementsGOOGLE =
        (PFN_vkCreateBufferWithRequirementsGOOGLE)vk->vkGetInstanceProcAddr(
            instance, "vkCreateBufferWithRequirementsGOOGLE");
    out->vkGetMemoryHostAddressInfoGOOGLE =
        (PFN_vkGetMemoryHostAddressInfoGOOGLE)vk->vkGetInstanceProcAddr(
            instance, "vkGetMemoryHostAddressInfoGOOGLE");
    out->vkFreeMemorySyncGOOGLE =
        (PFN_vkFreeMemorySyncGOOGLE)vk->vkGetInstanceProcAddr(instance, "vkFreeMemorySyncGOOGLE");
    out->vkQueueHostSyncGOOGLE =
        (PFN_vkQueueHostSyncGOOGLE)vk->vkGetInstanceProcAddr(instance, "vkQueueHostSyncGOOGLE");
    out->vkQueueSubmitAsyncGOOGLE = (PFN_vkQueueSubmitAsyncGOOGLE)vk->vkGetInstanceProcAddr(
        instance, "vkQueueSubmitAsyncGOOGLE");
    out->vkQueueWaitIdleAsyncGOOGLE = (PFN_vkQueueWaitIdleAsyncGOOGLE)vk->vkGetInstanceProcAddr(
        instance, "vkQueueWaitIdleAsyncGOOGLE");
    out->vkQueueBindSparseAsyncGOOGLE = (PFN_vkQueueBindSparseAsyncGOOGLE)vk->vkGetInstanceProcAddr(
        instance, "vkQueueBindSparseAsyncGOOGLE");
    out->vkGetLinearImageLayoutGOOGLE = (PFN_vkGetLinearImageLayoutGOOGLE)vk->vkGetInstanceProcAddr(
        instance, "vkGetLinearImageLayoutGOOGLE");
    out->vkGetLinearImageLayout2GOOGLE =
        (PFN_vkGetLinearImageLayout2GOOGLE)vk->vkGetInstanceProcAddr(
            instance, "vkGetLinearImageLayout2GOOGLE");
    out->vkQueueFlushCommandsGOOGLE = (PFN_vkQueueFlushCommandsGOOGLE)vk->vkGetInstanceProcAddr(
        instance, "vkQueueFlushCommandsGOOGLE");
    out->vkQueueCommitDescriptorSetUpdatesGOOGLE =
        (PFN_vkQueueCommitDescriptorSetUpdatesGOOGLE)vk->vkGetInstanceProcAddr(
            instance, "vkQueueCommitDescriptorSetUpdatesGOOGLE");
    out->vkCollectDescriptorPoolIdsGOOGLE =
        (PFN_vkCollectDescriptorPoolIdsGOOGLE)vk->vkGetInstanceProcAddr(
            instance, "vkCollectDescriptorPoolIdsGOOGLE");
    out->vkQueueSignalReleaseImageANDROIDAsyncGOOGLE =
        (PFN_vkQueueSignalReleaseImageANDROIDAsyncGOOGLE)vk->vkGetInstanceProcAddr(
            instance, "vkQueueSignalReleaseImageANDROIDAsyncGOOGLE");
    out->vkQueueFlushCommandsFromAuxMemoryGOOGLE =
        (PFN_vkQueueFlushCommandsFromAuxMemoryGOOGLE)vk->vkGetInstanceProcAddr(
            instance, "vkQueueFlushCommandsFromAuxMemoryGOOGLE");
    out->vkGetBlobGOOGLE =
        (PFN_vkGetBlobGOOGLE)vk->vkGetInstanceProcAddr(instance, "vkGetBlobGOOGLE");
    out->vkUpdateDescriptorSetWithTemplateSized2GOOGLE =
        (PFN_vkUpdateDescriptorSetWithTemplateSized2GOOGLE)vk->vkGetInstanceProcAddr(
            instance, "vkUpdateDescriptorSetWithTemplateSized2GOOGLE");
    out->vkQueueSubmitAsync2GOOGLE = (PFN_vkQueueSubmitAsync2GOOGLE)vk->vkGetInstanceProcAddr(
        instance, "vkQueueSubmitAsync2GOOGLE");
#endif
}

void init_vulkan_dispatch_from_device(VulkanDispatch* vk, VkDevice device, VulkanDispatch* out) {
    memset(out, 0x0, sizeof(VulkanDispatch));
#ifdef VK_VERSION_1_0
    out->vkDestroyInstance =
        (PFN_vkDestroyInstance)vk->vkGetDeviceProcAddr(device, "vkDestroyInstance");
    out->vkEnumeratePhysicalDevices = (PFN_vkEnumeratePhysicalDevices)vk->vkGetDeviceProcAddr(
        device, "vkEnumeratePhysicalDevices");
    out->vkGetPhysicalDeviceFeatures = (PFN_vkGetPhysicalDeviceFeatures)vk->vkGetDeviceProcAddr(
        device, "vkGetPhysicalDeviceFeatures");
    out->vkGetPhysicalDeviceFormatProperties =
        (PFN_vkGetPhysicalDeviceFormatProperties)vk->vkGetDeviceProcAddr(
            device, "vkGetPhysicalDeviceFormatProperties");
    out->vkGetPhysicalDeviceImageFormatProperties =
        (PFN_vkGetPhysicalDeviceImageFormatProperties)vk->vkGetDeviceProcAddr(
            device, "vkGetPhysicalDeviceImageFormatProperties");
    out->vkGetPhysicalDeviceProperties = (PFN_vkGetPhysicalDeviceProperties)vk->vkGetDeviceProcAddr(
        device, "vkGetPhysicalDeviceProperties");
    out->vkGetPhysicalDeviceQueueFamilyProperties =
        (PFN_vkGetPhysicalDeviceQueueFamilyProperties)vk->vkGetDeviceProcAddr(
            device, "vkGetPhysicalDeviceQueueFamilyProperties");
    out->vkGetPhysicalDeviceMemoryProperties =
        (PFN_vkGetPhysicalDeviceMemoryProperties)vk->vkGetDeviceProcAddr(
            device, "vkGetPhysicalDeviceMemoryProperties");
    out->vkGetInstanceProcAddr =
        (PFN_vkGetInstanceProcAddr)vk->vkGetDeviceProcAddr(device, "vkGetInstanceProcAddr");
    out->vkCreateDevice = (PFN_vkCreateDevice)vk->vkGetDeviceProcAddr(device, "vkCreateDevice");
    out->vkDestroyDevice = (PFN_vkDestroyDevice)vk->vkGetDeviceProcAddr(device, "vkDestroyDevice");
    out->vkEnumerateDeviceExtensionProperties =
        (PFN_vkEnumerateDeviceExtensionProperties)vk->vkGetDeviceProcAddr(
            device, "vkEnumerateDeviceExtensionProperties");
    out->vkEnumerateDeviceLayerProperties =
        (PFN_vkEnumerateDeviceLayerProperties)vk->vkGetDeviceProcAddr(
            device, "vkEnumerateDeviceLayerProperties");
    out->vkCreateInstance =
        (PFN_vkCreateInstance)vk->vkGetDeviceProcAddr(device, "vkCreateInstance");
    out->vkEnumerateInstanceExtensionProperties =
        (PFN_vkEnumerateInstanceExtensionProperties)vk->vkGetDeviceProcAddr(
            device, "vkEnumerateInstanceExtensionProperties");
    out->vkEnumerateInstanceLayerProperties =
        (PFN_vkEnumerateInstanceLayerProperties)vk->vkGetDeviceProcAddr(
            device, "vkEnumerateInstanceLayerProperties");
    out->vkGetDeviceProcAddr =
        (PFN_vkGetDeviceProcAddr)vk->vkGetDeviceProcAddr(device, "vkGetDeviceProcAddr");
    out->vkGetPhysicalDeviceSparseImageFormatProperties =
        (PFN_vkGetPhysicalDeviceSparseImageFormatProperties)vk->vkGetDeviceProcAddr(
            device, "vkGetPhysicalDeviceSparseImageFormatProperties");
#endif
#ifdef VK_VERSION_1_1
    out->vkEnumerateInstanceVersion = (PFN_vkEnumerateInstanceVersion)vk->vkGetDeviceProcAddr(
        device, "vkEnumerateInstanceVersion");
    out->vkEnumeratePhysicalDeviceGroups =
        (PFN_vkEnumeratePhysicalDeviceGroups)vk->vkGetDeviceProcAddr(
            device, "vkEnumeratePhysicalDeviceGroups");
    out->vkGetPhysicalDeviceFeatures2 = (PFN_vkGetPhysicalDeviceFeatures2)vk->vkGetDeviceProcAddr(
        device, "vkGetPhysicalDeviceFeatures2");
    out->vkGetPhysicalDeviceProperties2 =
        (PFN_vkGetPhysicalDeviceProperties2)vk->vkGetDeviceProcAddr(
            device, "vkGetPhysicalDeviceProperties2");
    out->vkGetPhysicalDeviceFormatProperties2 =
        (PFN_vkGetPhysicalDeviceFormatProperties2)vk->vkGetDeviceProcAddr(
            device, "vkGetPhysicalDeviceFormatProperties2");
    out->vkGetPhysicalDeviceImageFormatProperties2 =
        (PFN_vkGetPhysicalDeviceImageFormatProperties2)vk->vkGetDeviceProcAddr(
            device, "vkGetPhysicalDeviceImageFormatProperties2");
    out->vkGetPhysicalDeviceQueueFamilyProperties2 =
        (PFN_vkGetPhysicalDeviceQueueFamilyProperties2)vk->vkGetDeviceProcAddr(
            device, "vkGetPhysicalDeviceQueueFamilyProperties2");
    out->vkGetPhysicalDeviceMemoryProperties2 =
        (PFN_vkGetPhysicalDeviceMemoryProperties2)vk->vkGetDeviceProcAddr(
            device, "vkGetPhysicalDeviceMemoryProperties2");
    out->vkGetPhysicalDeviceSparseImageFormatProperties2 =
        (PFN_vkGetPhysicalDeviceSparseImageFormatProperties2)vk->vkGetDeviceProcAddr(
            device, "vkGetPhysicalDeviceSparseImageFormatProperties2");
    out->vkGetPhysicalDeviceExternalBufferProperties =
        (PFN_vkGetPhysicalDeviceExternalBufferProperties)vk->vkGetDeviceProcAddr(
            device, "vkGetPhysicalDeviceExternalBufferProperties");
    out->vkGetPhysicalDeviceExternalFenceProperties =
        (PFN_vkGetPhysicalDeviceExternalFenceProperties)vk->vkGetDeviceProcAddr(
            device, "vkGetPhysicalDeviceExternalFenceProperties");
    out->vkGetPhysicalDeviceExternalSemaphoreProperties =
        (PFN_vkGetPhysicalDeviceExternalSemaphoreProperties)vk->vkGetDeviceProcAddr(
            device, "vkGetPhysicalDeviceExternalSemaphoreProperties");
#endif
#ifdef VK_KHR_surface
    out->vkDestroySurfaceKHR =
        (PFN_vkDestroySurfaceKHR)vk->vkGetDeviceProcAddr(device, "vkDestroySurfaceKHR");
#endif
#ifdef VK_KHR_swapchain
    out->vkCreateSwapchainKHR =
        (PFN_vkCreateSwapchainKHR)vk->vkGetDeviceProcAddr(device, "vkCreateSwapchainKHR");
    out->vkDestroySwapchainKHR =
        (PFN_vkDestroySwapchainKHR)vk->vkGetDeviceProcAddr(device, "vkDestroySwapchainKHR");
    out->vkGetSwapchainImagesKHR =
        (PFN_vkGetSwapchainImagesKHR)vk->vkGetDeviceProcAddr(device, "vkGetSwapchainImagesKHR");
    out->vkAcquireNextImageKHR =
        (PFN_vkAcquireNextImageKHR)vk->vkGetDeviceProcAddr(device, "vkAcquireNextImageKHR");
    out->vkQueuePresentKHR =
        (PFN_vkQueuePresentKHR)vk->vkGetDeviceProcAddr(device, "vkQueuePresentKHR");
#endif
#ifdef VK_KHR_xcb_surface
    out->vkCreateXcbSurfaceKHR =
        (PFN_vkCreateXcbSurfaceKHR)vk->vkGetDeviceProcAddr(device, "vkCreateXcbSurfaceKHR");
    out->vkGetPhysicalDeviceXcbPresentationSupportKHR =
        (PFN_vkGetPhysicalDeviceXcbPresentationSupportKHR)vk->vkGetDeviceProcAddr(
            device, "vkGetPhysicalDeviceXcbPresentationSupportKHR");
#endif
#ifdef VK_KHR_win32_surface
    out->vkCreateWin32SurfaceKHR =
        (PFN_vkCreateWin32SurfaceKHR)vk->vkGetDeviceProcAddr(device, "vkCreateWin32SurfaceKHR");
    out->vkGetPhysicalDeviceWin32PresentationSupportKHR =
        (PFN_vkGetPhysicalDeviceWin32PresentationSupportKHR)vk->vkGetDeviceProcAddr(
            device, "vkGetPhysicalDeviceWin32PresentationSupportKHR");
#endif
#ifdef VK_EXT_debug_utils
    out->vkCreateDebugUtilsMessengerEXT =
        (PFN_vkCreateDebugUtilsMessengerEXT)vk->vkGetDeviceProcAddr(
            device, "vkCreateDebugUtilsMessengerEXT");
    out->vkDestroyDebugUtilsMessengerEXT =
        (PFN_vkDestroyDebugUtilsMessengerEXT)vk->vkGetDeviceProcAddr(
            device, "vkDestroyDebugUtilsMessengerEXT");
    out->vkSubmitDebugUtilsMessageEXT = (PFN_vkSubmitDebugUtilsMessageEXT)vk->vkGetDeviceProcAddr(
        device, "vkSubmitDebugUtilsMessageEXT");
#endif
#ifdef VK_EXT_metal_surface
    out->vkCreateMetalSurfaceEXT =
        (PFN_vkCreateMetalSurfaceEXT)vk->vkGetDeviceProcAddr(device, "vkCreateMetalSurfaceEXT");
#endif
#ifdef VK_VERSION_1_0
    out->vkGetDeviceQueue =
        (PFN_vkGetDeviceQueue)vk->vkGetDeviceProcAddr(device, "vkGetDeviceQueue");
    out->vkQueueSubmit = (PFN_vkQueueSubmit)vk->vkGetDeviceProcAddr(device, "vkQueueSubmit");
    out->vkQueueWaitIdle = (PFN_vkQueueWaitIdle)vk->vkGetDeviceProcAddr(device, "vkQueueWaitIdle");
    out->vkDeviceWaitIdle =
        (PFN_vkDeviceWaitIdle)vk->vkGetDeviceProcAddr(device, "vkDeviceWaitIdle");
    out->vkAllocateMemory =
        (PFN_vkAllocateMemory)vk->vkGetDeviceProcAddr(device, "vkAllocateMemory");
    out->vkFreeMemory = (PFN_vkFreeMemory)vk->vkGetDeviceProcAddr(device, "vkFreeMemory");
    out->vkMapMemory = (PFN_vkMapMemory)vk->vkGetDeviceProcAddr(device, "vkMapMemory");
    out->vkUnmapMemory = (PFN_vkUnmapMemory)vk->vkGetDeviceProcAddr(device, "vkUnmapMemory");
    out->vkFlushMappedMemoryRanges =
        (PFN_vkFlushMappedMemoryRanges)vk->vkGetDeviceProcAddr(device, "vkFlushMappedMemoryRanges");
    out->vkInvalidateMappedMemoryRanges =
        (PFN_vkInvalidateMappedMemoryRanges)vk->vkGetDeviceProcAddr(
            device, "vkInvalidateMappedMemoryRanges");
    out->vkGetDeviceMemoryCommitment = (PFN_vkGetDeviceMemoryCommitment)vk->vkGetDeviceProcAddr(
        device, "vkGetDeviceMemoryCommitment");
    out->vkBindBufferMemory =
        (PFN_vkBindBufferMemory)vk->vkGetDeviceProcAddr(device, "vkBindBufferMemory");
    out->vkBindImageMemory =
        (PFN_vkBindImageMemory)vk->vkGetDeviceProcAddr(device, "vkBindImageMemory");
    out->vkGetBufferMemoryRequirements = (PFN_vkGetBufferMemoryRequirements)vk->vkGetDeviceProcAddr(
        device, "vkGetBufferMemoryRequirements");
    out->vkGetImageMemoryRequirements = (PFN_vkGetImageMemoryRequirements)vk->vkGetDeviceProcAddr(
        device, "vkGetImageMemoryRequirements");
    out->vkGetImageSparseMemoryRequirements =
        (PFN_vkGetImageSparseMemoryRequirements)vk->vkGetDeviceProcAddr(
            device, "vkGetImageSparseMemoryRequirements");
    out->vkQueueBindSparse =
        (PFN_vkQueueBindSparse)vk->vkGetDeviceProcAddr(device, "vkQueueBindSparse");
    out->vkCreateFence = (PFN_vkCreateFence)vk->vkGetDeviceProcAddr(device, "vkCreateFence");
    out->vkDestroyFence = (PFN_vkDestroyFence)vk->vkGetDeviceProcAddr(device, "vkDestroyFence");
    out->vkResetFences = (PFN_vkResetFences)vk->vkGetDeviceProcAddr(device, "vkResetFences");
    out->vkGetFenceStatus =
        (PFN_vkGetFenceStatus)vk->vkGetDeviceProcAddr(device, "vkGetFenceStatus");
    out->vkWaitForFences = (PFN_vkWaitForFences)vk->vkGetDeviceProcAddr(device, "vkWaitForFences");
    out->vkCreateSemaphore =
        (PFN_vkCreateSemaphore)vk->vkGetDeviceProcAddr(device, "vkCreateSemaphore");
    out->vkDestroySemaphore =
        (PFN_vkDestroySemaphore)vk->vkGetDeviceProcAddr(device, "vkDestroySemaphore");
    out->vkCreateEvent = (PFN_vkCreateEvent)vk->vkGetDeviceProcAddr(device, "vkCreateEvent");
    out->vkDestroyEvent = (PFN_vkDestroyEvent)vk->vkGetDeviceProcAddr(device, "vkDestroyEvent");
    out->vkGetEventStatus =
        (PFN_vkGetEventStatus)vk->vkGetDeviceProcAddr(device, "vkGetEventStatus");
    out->vkSetEvent = (PFN_vkSetEvent)vk->vkGetDeviceProcAddr(device, "vkSetEvent");
    out->vkResetEvent = (PFN_vkResetEvent)vk->vkGetDeviceProcAddr(device, "vkResetEvent");
    out->vkCreateQueryPool =
        (PFN_vkCreateQueryPool)vk->vkGetDeviceProcAddr(device, "vkCreateQueryPool");
    out->vkDestroyQueryPool =
        (PFN_vkDestroyQueryPool)vk->vkGetDeviceProcAddr(device, "vkDestroyQueryPool");
    out->vkGetQueryPoolResults =
        (PFN_vkGetQueryPoolResults)vk->vkGetDeviceProcAddr(device, "vkGetQueryPoolResults");
    out->vkCreateBuffer = (PFN_vkCreateBuffer)vk->vkGetDeviceProcAddr(device, "vkCreateBuffer");
    out->vkDestroyBuffer = (PFN_vkDestroyBuffer)vk->vkGetDeviceProcAddr(device, "vkDestroyBuffer");
    out->vkCreateBufferView =
        (PFN_vkCreateBufferView)vk->vkGetDeviceProcAddr(device, "vkCreateBufferView");
    out->vkDestroyBufferView =
        (PFN_vkDestroyBufferView)vk->vkGetDeviceProcAddr(device, "vkDestroyBufferView");
    out->vkCreateImage = (PFN_vkCreateImage)vk->vkGetDeviceProcAddr(device, "vkCreateImage");
    out->vkDestroyImage = (PFN_vkDestroyImage)vk->vkGetDeviceProcAddr(device, "vkDestroyImage");
    out->vkGetImageSubresourceLayout = (PFN_vkGetImageSubresourceLayout)vk->vkGetDeviceProcAddr(
        device, "vkGetImageSubresourceLayout");
    out->vkCreateImageView =
        (PFN_vkCreateImageView)vk->vkGetDeviceProcAddr(device, "vkCreateImageView");
    out->vkDestroyImageView =
        (PFN_vkDestroyImageView)vk->vkGetDeviceProcAddr(device, "vkDestroyImageView");
    out->vkCreateShaderModule =
        (PFN_vkCreateShaderModule)vk->vkGetDeviceProcAddr(device, "vkCreateShaderModule");
    out->vkDestroyShaderModule =
        (PFN_vkDestroyShaderModule)vk->vkGetDeviceProcAddr(device, "vkDestroyShaderModule");
    out->vkCreatePipelineCache =
        (PFN_vkCreatePipelineCache)vk->vkGetDeviceProcAddr(device, "vkCreatePipelineCache");
    out->vkDestroyPipelineCache =
        (PFN_vkDestroyPipelineCache)vk->vkGetDeviceProcAddr(device, "vkDestroyPipelineCache");
    out->vkGetPipelineCacheData =
        (PFN_vkGetPipelineCacheData)vk->vkGetDeviceProcAddr(device, "vkGetPipelineCacheData");
    out->vkMergePipelineCaches =
        (PFN_vkMergePipelineCaches)vk->vkGetDeviceProcAddr(device, "vkMergePipelineCaches");
    out->vkCreateGraphicsPipelines =
        (PFN_vkCreateGraphicsPipelines)vk->vkGetDeviceProcAddr(device, "vkCreateGraphicsPipelines");
    out->vkCreateComputePipelines =
        (PFN_vkCreateComputePipelines)vk->vkGetDeviceProcAddr(device, "vkCreateComputePipelines");
    out->vkDestroyPipeline =
        (PFN_vkDestroyPipeline)vk->vkGetDeviceProcAddr(device, "vkDestroyPipeline");
    out->vkCreatePipelineLayout =
        (PFN_vkCreatePipelineLayout)vk->vkGetDeviceProcAddr(device, "vkCreatePipelineLayout");
    out->vkDestroyPipelineLayout =
        (PFN_vkDestroyPipelineLayout)vk->vkGetDeviceProcAddr(device, "vkDestroyPipelineLayout");
    out->vkCreateSampler = (PFN_vkCreateSampler)vk->vkGetDeviceProcAddr(device, "vkCreateSampler");
    out->vkDestroySampler =
        (PFN_vkDestroySampler)vk->vkGetDeviceProcAddr(device, "vkDestroySampler");
    out->vkCreateDescriptorSetLayout = (PFN_vkCreateDescriptorSetLayout)vk->vkGetDeviceProcAddr(
        device, "vkCreateDescriptorSetLayout");
    out->vkDestroyDescriptorSetLayout = (PFN_vkDestroyDescriptorSetLayout)vk->vkGetDeviceProcAddr(
        device, "vkDestroyDescriptorSetLayout");
    out->vkCreateDescriptorPool =
        (PFN_vkCreateDescriptorPool)vk->vkGetDeviceProcAddr(device, "vkCreateDescriptorPool");
    out->vkDestroyDescriptorPool =
        (PFN_vkDestroyDescriptorPool)vk->vkGetDeviceProcAddr(device, "vkDestroyDescriptorPool");
    out->vkResetDescriptorPool =
        (PFN_vkResetDescriptorPool)vk->vkGetDeviceProcAddr(device, "vkResetDescriptorPool");
    out->vkAllocateDescriptorSets =
        (PFN_vkAllocateDescriptorSets)vk->vkGetDeviceProcAddr(device, "vkAllocateDescriptorSets");
    out->vkFreeDescriptorSets =
        (PFN_vkFreeDescriptorSets)vk->vkGetDeviceProcAddr(device, "vkFreeDescriptorSets");
    out->vkUpdateDescriptorSets =
        (PFN_vkUpdateDescriptorSets)vk->vkGetDeviceProcAddr(device, "vkUpdateDescriptorSets");
    out->vkCreateFramebuffer =
        (PFN_vkCreateFramebuffer)vk->vkGetDeviceProcAddr(device, "vkCreateFramebuffer");
    out->vkDestroyFramebuffer =
        (PFN_vkDestroyFramebuffer)vk->vkGetDeviceProcAddr(device, "vkDestroyFramebuffer");
    out->vkCreateRenderPass =
        (PFN_vkCreateRenderPass)vk->vkGetDeviceProcAddr(device, "vkCreateRenderPass");
    out->vkDestroyRenderPass =
        (PFN_vkDestroyRenderPass)vk->vkGetDeviceProcAddr(device, "vkDestroyRenderPass");
    out->vkGetRenderAreaGranularity = (PFN_vkGetRenderAreaGranularity)vk->vkGetDeviceProcAddr(
        device, "vkGetRenderAreaGranularity");
    out->vkCreateCommandPool =
        (PFN_vkCreateCommandPool)vk->vkGetDeviceProcAddr(device, "vkCreateCommandPool");
    out->vkDestroyCommandPool =
        (PFN_vkDestroyCommandPool)vk->vkGetDeviceProcAddr(device, "vkDestroyCommandPool");
    out->vkResetCommandPool =
        (PFN_vkResetCommandPool)vk->vkGetDeviceProcAddr(device, "vkResetCommandPool");
    out->vkAllocateCommandBuffers =
        (PFN_vkAllocateCommandBuffers)vk->vkGetDeviceProcAddr(device, "vkAllocateCommandBuffers");
    out->vkFreeCommandBuffers =
        (PFN_vkFreeCommandBuffers)vk->vkGetDeviceProcAddr(device, "vkFreeCommandBuffers");
    out->vkBeginCommandBuffer =
        (PFN_vkBeginCommandBuffer)vk->vkGetDeviceProcAddr(device, "vkBeginCommandBuffer");
    out->vkEndCommandBuffer =
        (PFN_vkEndCommandBuffer)vk->vkGetDeviceProcAddr(device, "vkEndCommandBuffer");
    out->vkResetCommandBuffer =
        (PFN_vkResetCommandBuffer)vk->vkGetDeviceProcAddr(device, "vkResetCommandBuffer");
    out->vkCmdBindPipeline =
        (PFN_vkCmdBindPipeline)vk->vkGetDeviceProcAddr(device, "vkCmdBindPipeline");
    out->vkCmdSetViewport =
        (PFN_vkCmdSetViewport)vk->vkGetDeviceProcAddr(device, "vkCmdSetViewport");
    out->vkCmdSetScissor = (PFN_vkCmdSetScissor)vk->vkGetDeviceProcAddr(device, "vkCmdSetScissor");
    out->vkCmdSetLineWidth =
        (PFN_vkCmdSetLineWidth)vk->vkGetDeviceProcAddr(device, "vkCmdSetLineWidth");
    out->vkCmdSetDepthBias =
        (PFN_vkCmdSetDepthBias)vk->vkGetDeviceProcAddr(device, "vkCmdSetDepthBias");
    out->vkCmdSetBlendConstants =
        (PFN_vkCmdSetBlendConstants)vk->vkGetDeviceProcAddr(device, "vkCmdSetBlendConstants");
    out->vkCmdSetDepthBounds =
        (PFN_vkCmdSetDepthBounds)vk->vkGetDeviceProcAddr(device, "vkCmdSetDepthBounds");
    out->vkCmdSetStencilCompareMask = (PFN_vkCmdSetStencilCompareMask)vk->vkGetDeviceProcAddr(
        device, "vkCmdSetStencilCompareMask");
    out->vkCmdSetStencilWriteMask =
        (PFN_vkCmdSetStencilWriteMask)vk->vkGetDeviceProcAddr(device, "vkCmdSetStencilWriteMask");
    out->vkCmdSetStencilReference =
        (PFN_vkCmdSetStencilReference)vk->vkGetDeviceProcAddr(device, "vkCmdSetStencilReference");
    out->vkCmdBindDescriptorSets =
        (PFN_vkCmdBindDescriptorSets)vk->vkGetDeviceProcAddr(device, "vkCmdBindDescriptorSets");
    out->vkCmdBindIndexBuffer =
        (PFN_vkCmdBindIndexBuffer)vk->vkGetDeviceProcAddr(device, "vkCmdBindIndexBuffer");
    out->vkCmdBindVertexBuffers =
        (PFN_vkCmdBindVertexBuffers)vk->vkGetDeviceProcAddr(device, "vkCmdBindVertexBuffers");
    out->vkCmdDraw = (PFN_vkCmdDraw)vk->vkGetDeviceProcAddr(device, "vkCmdDraw");
    out->vkCmdDrawIndexed =
        (PFN_vkCmdDrawIndexed)vk->vkGetDeviceProcAddr(device, "vkCmdDrawIndexed");
    out->vkCmdDrawIndirect =
        (PFN_vkCmdDrawIndirect)vk->vkGetDeviceProcAddr(device, "vkCmdDrawIndirect");
    out->vkCmdDrawIndexedIndirect =
        (PFN_vkCmdDrawIndexedIndirect)vk->vkGetDeviceProcAddr(device, "vkCmdDrawIndexedIndirect");
    out->vkCmdDispatch = (PFN_vkCmdDispatch)vk->vkGetDeviceProcAddr(device, "vkCmdDispatch");
    out->vkCmdDispatchIndirect =
        (PFN_vkCmdDispatchIndirect)vk->vkGetDeviceProcAddr(device, "vkCmdDispatchIndirect");
    out->vkCmdCopyBuffer = (PFN_vkCmdCopyBuffer)vk->vkGetDeviceProcAddr(device, "vkCmdCopyBuffer");
    out->vkCmdCopyImage = (PFN_vkCmdCopyImage)vk->vkGetDeviceProcAddr(device, "vkCmdCopyImage");
    out->vkCmdBlitImage = (PFN_vkCmdBlitImage)vk->vkGetDeviceProcAddr(device, "vkCmdBlitImage");
    out->vkCmdCopyBufferToImage =
        (PFN_vkCmdCopyBufferToImage)vk->vkGetDeviceProcAddr(device, "vkCmdCopyBufferToImage");
    out->vkCmdCopyImageToBuffer =
        (PFN_vkCmdCopyImageToBuffer)vk->vkGetDeviceProcAddr(device, "vkCmdCopyImageToBuffer");
    out->vkCmdUpdateBuffer =
        (PFN_vkCmdUpdateBuffer)vk->vkGetDeviceProcAddr(device, "vkCmdUpdateBuffer");
    out->vkCmdFillBuffer = (PFN_vkCmdFillBuffer)vk->vkGetDeviceProcAddr(device, "vkCmdFillBuffer");
    out->vkCmdClearColorImage =
        (PFN_vkCmdClearColorImage)vk->vkGetDeviceProcAddr(device, "vkCmdClearColorImage");
    out->vkCmdClearDepthStencilImage = (PFN_vkCmdClearDepthStencilImage)vk->vkGetDeviceProcAddr(
        device, "vkCmdClearDepthStencilImage");
    out->vkCmdClearAttachments =
        (PFN_vkCmdClearAttachments)vk->vkGetDeviceProcAddr(device, "vkCmdClearAttachments");
    out->vkCmdResolveImage =
        (PFN_vkCmdResolveImage)vk->vkGetDeviceProcAddr(device, "vkCmdResolveImage");
    out->vkCmdSetEvent = (PFN_vkCmdSetEvent)vk->vkGetDeviceProcAddr(device, "vkCmdSetEvent");
    out->vkCmdResetEvent = (PFN_vkCmdResetEvent)vk->vkGetDeviceProcAddr(device, "vkCmdResetEvent");
    out->vkCmdWaitEvents = (PFN_vkCmdWaitEvents)vk->vkGetDeviceProcAddr(device, "vkCmdWaitEvents");
    out->vkCmdPipelineBarrier =
        (PFN_vkCmdPipelineBarrier)vk->vkGetDeviceProcAddr(device, "vkCmdPipelineBarrier");
    out->vkCmdBeginQuery = (PFN_vkCmdBeginQuery)vk->vkGetDeviceProcAddr(device, "vkCmdBeginQuery");
    out->vkCmdEndQuery = (PFN_vkCmdEndQuery)vk->vkGetDeviceProcAddr(device, "vkCmdEndQuery");
    out->vkCmdResetQueryPool =
        (PFN_vkCmdResetQueryPool)vk->vkGetDeviceProcAddr(device, "vkCmdResetQueryPool");
    out->vkCmdWriteTimestamp =
        (PFN_vkCmdWriteTimestamp)vk->vkGetDeviceProcAddr(device, "vkCmdWriteTimestamp");
    out->vkCmdCopyQueryPoolResults =
        (PFN_vkCmdCopyQueryPoolResults)vk->vkGetDeviceProcAddr(device, "vkCmdCopyQueryPoolResults");
    out->vkCmdPushConstants =
        (PFN_vkCmdPushConstants)vk->vkGetDeviceProcAddr(device, "vkCmdPushConstants");
    out->vkCmdBeginRenderPass =
        (PFN_vkCmdBeginRenderPass)vk->vkGetDeviceProcAddr(device, "vkCmdBeginRenderPass");
    out->vkCmdNextSubpass =
        (PFN_vkCmdNextSubpass)vk->vkGetDeviceProcAddr(device, "vkCmdNextSubpass");
    out->vkCmdEndRenderPass =
        (PFN_vkCmdEndRenderPass)vk->vkGetDeviceProcAddr(device, "vkCmdEndRenderPass");
    out->vkCmdExecuteCommands =
        (PFN_vkCmdExecuteCommands)vk->vkGetDeviceProcAddr(device, "vkCmdExecuteCommands");
#endif
#ifdef VK_VERSION_1_1
    out->vkBindBufferMemory2 =
        (PFN_vkBindBufferMemory2)vk->vkGetDeviceProcAddr(device, "vkBindBufferMemory2");
    out->vkBindImageMemory2 =
        (PFN_vkBindImageMemory2)vk->vkGetDeviceProcAddr(device, "vkBindImageMemory2");
    out->vkGetDeviceGroupPeerMemoryFeatures =
        (PFN_vkGetDeviceGroupPeerMemoryFeatures)vk->vkGetDeviceProcAddr(
            device, "vkGetDeviceGroupPeerMemoryFeatures");
    out->vkCmdSetDeviceMask =
        (PFN_vkCmdSetDeviceMask)vk->vkGetDeviceProcAddr(device, "vkCmdSetDeviceMask");
    out->vkCmdDispatchBase =
        (PFN_vkCmdDispatchBase)vk->vkGetDeviceProcAddr(device, "vkCmdDispatchBase");
    out->vkGetImageMemoryRequirements2 = (PFN_vkGetImageMemoryRequirements2)vk->vkGetDeviceProcAddr(
        device, "vkGetImageMemoryRequirements2");
    out->vkGetBufferMemoryRequirements2 =
        (PFN_vkGetBufferMemoryRequirements2)vk->vkGetDeviceProcAddr(
            device, "vkGetBufferMemoryRequirements2");
    out->vkGetImageSparseMemoryRequirements2 =
        (PFN_vkGetImageSparseMemoryRequirements2)vk->vkGetDeviceProcAddr(
            device, "vkGetImageSparseMemoryRequirements2");
    out->vkTrimCommandPool =
        (PFN_vkTrimCommandPool)vk->vkGetDeviceProcAddr(device, "vkTrimCommandPool");
    out->vkGetDeviceQueue2 =
        (PFN_vkGetDeviceQueue2)vk->vkGetDeviceProcAddr(device, "vkGetDeviceQueue2");
    out->vkCreateSamplerYcbcrConversion =
        (PFN_vkCreateSamplerYcbcrConversion)vk->vkGetDeviceProcAddr(
            device, "vkCreateSamplerYcbcrConversion");
    out->vkDestroySamplerYcbcrConversion =
        (PFN_vkDestroySamplerYcbcrConversion)vk->vkGetDeviceProcAddr(
            device, "vkDestroySamplerYcbcrConversion");
    out->vkCreateDescriptorUpdateTemplate =
        (PFN_vkCreateDescriptorUpdateTemplate)vk->vkGetDeviceProcAddr(
            device, "vkCreateDescriptorUpdateTemplate");
    out->vkDestroyDescriptorUpdateTemplate =
        (PFN_vkDestroyDescriptorUpdateTemplate)vk->vkGetDeviceProcAddr(
            device, "vkDestroyDescriptorUpdateTemplate");
    out->vkUpdateDescriptorSetWithTemplate =
        (PFN_vkUpdateDescriptorSetWithTemplate)vk->vkGetDeviceProcAddr(
            device, "vkUpdateDescriptorSetWithTemplate");
    out->vkGetDescriptorSetLayoutSupport =
        (PFN_vkGetDescriptorSetLayoutSupport)vk->vkGetDeviceProcAddr(
            device, "vkGetDescriptorSetLayoutSupport");
#endif
#ifdef VK_VERSION_1_2
    out->vkCmdDrawIndirectCount =
        (PFN_vkCmdDrawIndirectCount)vk->vkGetDeviceProcAddr(device, "vkCmdDrawIndirectCount");
    out->vkCmdDrawIndexedIndirectCount = (PFN_vkCmdDrawIndexedIndirectCount)vk->vkGetDeviceProcAddr(
        device, "vkCmdDrawIndexedIndirectCount");
    out->vkCreateRenderPass2 =
        (PFN_vkCreateRenderPass2)vk->vkGetDeviceProcAddr(device, "vkCreateRenderPass2");
    out->vkCmdBeginRenderPass2 =
        (PFN_vkCmdBeginRenderPass2)vk->vkGetDeviceProcAddr(device, "vkCmdBeginRenderPass2");
    out->vkCmdNextSubpass2 =
        (PFN_vkCmdNextSubpass2)vk->vkGetDeviceProcAddr(device, "vkCmdNextSubpass2");
    out->vkCmdEndRenderPass2 =
        (PFN_vkCmdEndRenderPass2)vk->vkGetDeviceProcAddr(device, "vkCmdEndRenderPass2");
    out->vkResetQueryPool =
        (PFN_vkResetQueryPool)vk->vkGetDeviceProcAddr(device, "vkResetQueryPool");
    out->vkGetSemaphoreCounterValue = (PFN_vkGetSemaphoreCounterValue)vk->vkGetDeviceProcAddr(
        device, "vkGetSemaphoreCounterValue");
    out->vkWaitSemaphores =
        (PFN_vkWaitSemaphores)vk->vkGetDeviceProcAddr(device, "vkWaitSemaphores");
    out->vkSignalSemaphore =
        (PFN_vkSignalSemaphore)vk->vkGetDeviceProcAddr(device, "vkSignalSemaphore");
    out->vkGetBufferDeviceAddress =
        (PFN_vkGetBufferDeviceAddress)vk->vkGetDeviceProcAddr(device, "vkGetBufferDeviceAddress");
    out->vkGetBufferOpaqueCaptureAddress =
        (PFN_vkGetBufferOpaqueCaptureAddress)vk->vkGetDeviceProcAddr(
            device, "vkGetBufferOpaqueCaptureAddress");
    out->vkGetDeviceMemoryOpaqueCaptureAddress =
        (PFN_vkGetDeviceMemoryOpaqueCaptureAddress)vk->vkGetDeviceProcAddr(
            device, "vkGetDeviceMemoryOpaqueCaptureAddress");
#endif
#ifdef VK_VERSION_1_3
    out->vkGetPhysicalDeviceToolProperties =
        (PFN_vkGetPhysicalDeviceToolProperties)vk->vkGetDeviceProcAddr(
            device, "vkGetPhysicalDeviceToolProperties");
    out->vkCreatePrivateDataSlot =
        (PFN_vkCreatePrivateDataSlot)vk->vkGetDeviceProcAddr(device, "vkCreatePrivateDataSlot");
    out->vkDestroyPrivateDataSlot =
        (PFN_vkDestroyPrivateDataSlot)vk->vkGetDeviceProcAddr(device, "vkDestroyPrivateDataSlot");
    out->vkSetPrivateData =
        (PFN_vkSetPrivateData)vk->vkGetDeviceProcAddr(device, "vkSetPrivateData");
    out->vkGetPrivateData =
        (PFN_vkGetPrivateData)vk->vkGetDeviceProcAddr(device, "vkGetPrivateData");
    out->vkCmdSetEvent2 = (PFN_vkCmdSetEvent2)vk->vkGetDeviceProcAddr(device, "vkCmdSetEvent2");
    out->vkCmdResetEvent2 =
        (PFN_vkCmdResetEvent2)vk->vkGetDeviceProcAddr(device, "vkCmdResetEvent2");
    out->vkCmdWaitEvents2 =
        (PFN_vkCmdWaitEvents2)vk->vkGetDeviceProcAddr(device, "vkCmdWaitEvents2");
    out->vkCmdPipelineBarrier2 =
        (PFN_vkCmdPipelineBarrier2)vk->vkGetDeviceProcAddr(device, "vkCmdPipelineBarrier2");
    out->vkCmdWriteTimestamp2 =
        (PFN_vkCmdWriteTimestamp2)vk->vkGetDeviceProcAddr(device, "vkCmdWriteTimestamp2");
    out->vkQueueSubmit2 = (PFN_vkQueueSubmit2)vk->vkGetDeviceProcAddr(device, "vkQueueSubmit2");
    out->vkCmdCopyBuffer2 =
        (PFN_vkCmdCopyBuffer2)vk->vkGetDeviceProcAddr(device, "vkCmdCopyBuffer2");
    out->vkCmdCopyImage2 = (PFN_vkCmdCopyImage2)vk->vkGetDeviceProcAddr(device, "vkCmdCopyImage2");
    out->vkCmdCopyBufferToImage2 =
        (PFN_vkCmdCopyBufferToImage2)vk->vkGetDeviceProcAddr(device, "vkCmdCopyBufferToImage2");
    out->vkCmdCopyImageToBuffer2 =
        (PFN_vkCmdCopyImageToBuffer2)vk->vkGetDeviceProcAddr(device, "vkCmdCopyImageToBuffer2");
    out->vkCmdBlitImage2 = (PFN_vkCmdBlitImage2)vk->vkGetDeviceProcAddr(device, "vkCmdBlitImage2");
    out->vkCmdResolveImage2 =
        (PFN_vkCmdResolveImage2)vk->vkGetDeviceProcAddr(device, "vkCmdResolveImage2");
    out->vkCmdBeginRendering =
        (PFN_vkCmdBeginRendering)vk->vkGetDeviceProcAddr(device, "vkCmdBeginRendering");
    out->vkCmdEndRendering =
        (PFN_vkCmdEndRendering)vk->vkGetDeviceProcAddr(device, "vkCmdEndRendering");
    out->vkCmdSetCullMode =
        (PFN_vkCmdSetCullMode)vk->vkGetDeviceProcAddr(device, "vkCmdSetCullMode");
    out->vkCmdSetFrontFace =
        (PFN_vkCmdSetFrontFace)vk->vkGetDeviceProcAddr(device, "vkCmdSetFrontFace");
    out->vkCmdSetPrimitiveTopology =
        (PFN_vkCmdSetPrimitiveTopology)vk->vkGetDeviceProcAddr(device, "vkCmdSetPrimitiveTopology");
    out->vkCmdSetViewportWithCount =
        (PFN_vkCmdSetViewportWithCount)vk->vkGetDeviceProcAddr(device, "vkCmdSetViewportWithCount");
    out->vkCmdSetScissorWithCount =
        (PFN_vkCmdSetScissorWithCount)vk->vkGetDeviceProcAddr(device, "vkCmdSetScissorWithCount");
    out->vkCmdBindVertexBuffers2 =
        (PFN_vkCmdBindVertexBuffers2)vk->vkGetDeviceProcAddr(device, "vkCmdBindVertexBuffers2");
    out->vkCmdSetDepthTestEnable =
        (PFN_vkCmdSetDepthTestEnable)vk->vkGetDeviceProcAddr(device, "vkCmdSetDepthTestEnable");
    out->vkCmdSetDepthWriteEnable =
        (PFN_vkCmdSetDepthWriteEnable)vk->vkGetDeviceProcAddr(device, "vkCmdSetDepthWriteEnable");
    out->vkCmdSetDepthCompareOp =
        (PFN_vkCmdSetDepthCompareOp)vk->vkGetDeviceProcAddr(device, "vkCmdSetDepthCompareOp");
    out->vkCmdSetDepthBoundsTestEnable = (PFN_vkCmdSetDepthBoundsTestEnable)vk->vkGetDeviceProcAddr(
        device, "vkCmdSetDepthBoundsTestEnable");
    out->vkCmdSetStencilTestEnable =
        (PFN_vkCmdSetStencilTestEnable)vk->vkGetDeviceProcAddr(device, "vkCmdSetStencilTestEnable");
    out->vkCmdSetStencilOp =
        (PFN_vkCmdSetStencilOp)vk->vkGetDeviceProcAddr(device, "vkCmdSetStencilOp");
    out->vkCmdSetRasterizerDiscardEnable =
        (PFN_vkCmdSetRasterizerDiscardEnable)vk->vkGetDeviceProcAddr(
            device, "vkCmdSetRasterizerDiscardEnable");
    out->vkCmdSetDepthBiasEnable =
        (PFN_vkCmdSetDepthBiasEnable)vk->vkGetDeviceProcAddr(device, "vkCmdSetDepthBiasEnable");
    out->vkCmdSetPrimitiveRestartEnable =
        (PFN_vkCmdSetPrimitiveRestartEnable)vk->vkGetDeviceProcAddr(
            device, "vkCmdSetPrimitiveRestartEnable");
    out->vkGetDeviceBufferMemoryRequirements =
        (PFN_vkGetDeviceBufferMemoryRequirements)vk->vkGetDeviceProcAddr(
            device, "vkGetDeviceBufferMemoryRequirements");
    out->vkGetDeviceImageMemoryRequirements =
        (PFN_vkGetDeviceImageMemoryRequirements)vk->vkGetDeviceProcAddr(
            device, "vkGetDeviceImageMemoryRequirements");
    out->vkGetDeviceImageSparseMemoryRequirements =
        (PFN_vkGetDeviceImageSparseMemoryRequirements)vk->vkGetDeviceProcAddr(
            device, "vkGetDeviceImageSparseMemoryRequirements");
#endif
#ifdef VK_KHR_surface
    out->vkGetPhysicalDeviceSurfaceSupportKHR =
        (PFN_vkGetPhysicalDeviceSurfaceSupportKHR)vk->vkGetDeviceProcAddr(
            device, "vkGetPhysicalDeviceSurfaceSupportKHR");
    out->vkGetPhysicalDeviceSurfaceCapabilitiesKHR =
        (PFN_vkGetPhysicalDeviceSurfaceCapabilitiesKHR)vk->vkGetDeviceProcAddr(
            device, "vkGetPhysicalDeviceSurfaceCapabilitiesKHR");
    out->vkGetPhysicalDeviceSurfaceFormatsKHR =
        (PFN_vkGetPhysicalDeviceSurfaceFormatsKHR)vk->vkGetDeviceProcAddr(
            device, "vkGetPhysicalDeviceSurfaceFormatsKHR");
    out->vkGetPhysicalDeviceSurfacePresentModesKHR =
        (PFN_vkGetPhysicalDeviceSurfacePresentModesKHR)vk->vkGetDeviceProcAddr(
            device, "vkGetPhysicalDeviceSurfacePresentModesKHR");
#endif
#ifdef VK_KHR_swapchain
    out->vkGetDeviceGroupPresentCapabilitiesKHR =
        (PFN_vkGetDeviceGroupPresentCapabilitiesKHR)vk->vkGetDeviceProcAddr(
            device, "vkGetDeviceGroupPresentCapabilitiesKHR");
    out->vkGetDeviceGroupSurfacePresentModesKHR =
        (PFN_vkGetDeviceGroupSurfacePresentModesKHR)vk->vkGetDeviceProcAddr(
            device, "vkGetDeviceGroupSurfacePresentModesKHR");
    out->vkGetPhysicalDevicePresentRectanglesKHR =
        (PFN_vkGetPhysicalDevicePresentRectanglesKHR)vk->vkGetDeviceProcAddr(
            device, "vkGetPhysicalDevicePresentRectanglesKHR");
    out->vkAcquireNextImage2KHR =
        (PFN_vkAcquireNextImage2KHR)vk->vkGetDeviceProcAddr(device, "vkAcquireNextImage2KHR");
#endif
#ifdef VK_KHR_dynamic_rendering
    out->vkCmdBeginRenderingKHR =
        (PFN_vkCmdBeginRenderingKHR)vk->vkGetDeviceProcAddr(device, "vkCmdBeginRenderingKHR");
    out->vkCmdEndRenderingKHR =
        (PFN_vkCmdEndRenderingKHR)vk->vkGetDeviceProcAddr(device, "vkCmdEndRenderingKHR");
#endif
#ifdef VK_KHR_get_physical_device_properties2
    out->vkGetPhysicalDeviceFeatures2KHR =
        (PFN_vkGetPhysicalDeviceFeatures2KHR)vk->vkGetDeviceProcAddr(
            device, "vkGetPhysicalDeviceFeatures2KHR");
    out->vkGetPhysicalDeviceProperties2KHR =
        (PFN_vkGetPhysicalDeviceProperties2KHR)vk->vkGetDeviceProcAddr(
            device, "vkGetPhysicalDeviceProperties2KHR");
    out->vkGetPhysicalDeviceFormatProperties2KHR =
        (PFN_vkGetPhysicalDeviceFormatProperties2KHR)vk->vkGetDeviceProcAddr(
            device, "vkGetPhysicalDeviceFormatProperties2KHR");
    out->vkGetPhysicalDeviceImageFormatProperties2KHR =
        (PFN_vkGetPhysicalDeviceImageFormatProperties2KHR)vk->vkGetDeviceProcAddr(
            device, "vkGetPhysicalDeviceImageFormatProperties2KHR");
    out->vkGetPhysicalDeviceQueueFamilyProperties2KHR =
        (PFN_vkGetPhysicalDeviceQueueFamilyProperties2KHR)vk->vkGetDeviceProcAddr(
            device, "vkGetPhysicalDeviceQueueFamilyProperties2KHR");
    out->vkGetPhysicalDeviceMemoryProperties2KHR =
        (PFN_vkGetPhysicalDeviceMemoryProperties2KHR)vk->vkGetDeviceProcAddr(
            device, "vkGetPhysicalDeviceMemoryProperties2KHR");
    out->vkGetPhysicalDeviceSparseImageFormatProperties2KHR =
        (PFN_vkGetPhysicalDeviceSparseImageFormatProperties2KHR)vk->vkGetDeviceProcAddr(
            device, "vkGetPhysicalDeviceSparseImageFormatProperties2KHR");
#endif
#ifdef VK_KHR_maintenance1
    out->vkTrimCommandPoolKHR =
        (PFN_vkTrimCommandPoolKHR)vk->vkGetDeviceProcAddr(device, "vkTrimCommandPoolKHR");
#endif
#ifdef VK_KHR_external_memory_capabilities
    out->vkGetPhysicalDeviceExternalBufferPropertiesKHR =
        (PFN_vkGetPhysicalDeviceExternalBufferPropertiesKHR)vk->vkGetDeviceProcAddr(
            device, "vkGetPhysicalDeviceExternalBufferPropertiesKHR");
#endif
#ifdef VK_KHR_external_memory_win32
    out->vkGetMemoryWin32HandleKHR =
        (PFN_vkGetMemoryWin32HandleKHR)vk->vkGetDeviceProcAddr(device, "vkGetMemoryWin32HandleKHR");
    out->vkGetMemoryWin32HandlePropertiesKHR =
        (PFN_vkGetMemoryWin32HandlePropertiesKHR)vk->vkGetDeviceProcAddr(
            device, "vkGetMemoryWin32HandlePropertiesKHR");
#endif
#ifdef VK_KHR_external_memory_fd
    out->vkGetMemoryFdKHR =
        (PFN_vkGetMemoryFdKHR)vk->vkGetDeviceProcAddr(device, "vkGetMemoryFdKHR");
    out->vkGetMemoryFdPropertiesKHR = (PFN_vkGetMemoryFdPropertiesKHR)vk->vkGetDeviceProcAddr(
        device, "vkGetMemoryFdPropertiesKHR");
#endif
#ifdef VK_KHR_external_semaphore_capabilities
    out->vkGetPhysicalDeviceExternalSemaphorePropertiesKHR =
        (PFN_vkGetPhysicalDeviceExternalSemaphorePropertiesKHR)vk->vkGetDeviceProcAddr(
            device, "vkGetPhysicalDeviceExternalSemaphorePropertiesKHR");
#endif
#ifdef VK_KHR_external_semaphore_win32
    out->vkImportSemaphoreWin32HandleKHR =
        (PFN_vkImportSemaphoreWin32HandleKHR)vk->vkGetDeviceProcAddr(
            device, "vkImportSemaphoreWin32HandleKHR");
    out->vkGetSemaphoreWin32HandleKHR = (PFN_vkGetSemaphoreWin32HandleKHR)vk->vkGetDeviceProcAddr(
        device, "vkGetSemaphoreWin32HandleKHR");
#endif
#ifdef VK_KHR_external_semaphore_fd
    out->vkImportSemaphoreFdKHR =
        (PFN_vkImportSemaphoreFdKHR)vk->vkGetDeviceProcAddr(device, "vkImportSemaphoreFdKHR");
    out->vkGetSemaphoreFdKHR =
        (PFN_vkGetSemaphoreFdKHR)vk->vkGetDeviceProcAddr(device, "vkGetSemaphoreFdKHR");
#endif
#ifdef VK_KHR_descriptor_update_template
    out->vkCreateDescriptorUpdateTemplateKHR =
        (PFN_vkCreateDescriptorUpdateTemplateKHR)vk->vkGetDeviceProcAddr(
            device, "vkCreateDescriptorUpdateTemplateKHR");
    out->vkDestroyDescriptorUpdateTemplateKHR =
        (PFN_vkDestroyDescriptorUpdateTemplateKHR)vk->vkGetDeviceProcAddr(
            device, "vkDestroyDescriptorUpdateTemplateKHR");
    out->vkUpdateDescriptorSetWithTemplateKHR =
        (PFN_vkUpdateDescriptorSetWithTemplateKHR)vk->vkGetDeviceProcAddr(
            device, "vkUpdateDescriptorSetWithTemplateKHR");
#endif
#ifdef VK_KHR_create_renderpass2
    out->vkCreateRenderPass2KHR =
        (PFN_vkCreateRenderPass2KHR)vk->vkGetDeviceProcAddr(device, "vkCreateRenderPass2KHR");
    out->vkCmdBeginRenderPass2KHR =
        (PFN_vkCmdBeginRenderPass2KHR)vk->vkGetDeviceProcAddr(device, "vkCmdBeginRenderPass2KHR");
    out->vkCmdNextSubpass2KHR =
        (PFN_vkCmdNextSubpass2KHR)vk->vkGetDeviceProcAddr(device, "vkCmdNextSubpass2KHR");
    out->vkCmdEndRenderPass2KHR =
        (PFN_vkCmdEndRenderPass2KHR)vk->vkGetDeviceProcAddr(device, "vkCmdEndRenderPass2KHR");
#endif
#ifdef VK_KHR_external_fence_capabilities
    out->vkGetPhysicalDeviceExternalFencePropertiesKHR =
        (PFN_vkGetPhysicalDeviceExternalFencePropertiesKHR)vk->vkGetDeviceProcAddr(
            device, "vkGetPhysicalDeviceExternalFencePropertiesKHR");
#endif
#ifdef VK_KHR_external_fence_fd
    out->vkImportFenceFdKHR =
        (PFN_vkImportFenceFdKHR)vk->vkGetDeviceProcAddr(device, "vkImportFenceFdKHR");
    out->vkGetFenceFdKHR = (PFN_vkGetFenceFdKHR)vk->vkGetDeviceProcAddr(device, "vkGetFenceFdKHR");
#endif
#ifdef VK_KHR_get_memory_requirements2
    out->vkGetImageMemoryRequirements2KHR =
        (PFN_vkGetImageMemoryRequirements2KHR)vk->vkGetDeviceProcAddr(
            device, "vkGetImageMemoryRequirements2KHR");
    out->vkGetBufferMemoryRequirements2KHR =
        (PFN_vkGetBufferMemoryRequirements2KHR)vk->vkGetDeviceProcAddr(
            device, "vkGetBufferMemoryRequirements2KHR");
    out->vkGetImageSparseMemoryRequirements2KHR =
        (PFN_vkGetImageSparseMemoryRequirements2KHR)vk->vkGetDeviceProcAddr(
            device, "vkGetImageSparseMemoryRequirements2KHR");
#endif
#ifdef VK_KHR_sampler_ycbcr_conversion
    out->vkCreateSamplerYcbcrConversionKHR =
        (PFN_vkCreateSamplerYcbcrConversionKHR)vk->vkGetDeviceProcAddr(
            device, "vkCreateSamplerYcbcrConversionKHR");
    out->vkDestroySamplerYcbcrConversionKHR =
        (PFN_vkDestroySamplerYcbcrConversionKHR)vk->vkGetDeviceProcAddr(
            device, "vkDestroySamplerYcbcrConversionKHR");
#endif
#ifdef VK_KHR_bind_memory2
    out->vkBindBufferMemory2KHR =
        (PFN_vkBindBufferMemory2KHR)vk->vkGetDeviceProcAddr(device, "vkBindBufferMemory2KHR");
    out->vkBindImageMemory2KHR =
        (PFN_vkBindImageMemory2KHR)vk->vkGetDeviceProcAddr(device, "vkBindImageMemory2KHR");
#endif
#ifdef VK_KHR_maintenance3
    out->vkGetDescriptorSetLayoutSupportKHR =
        (PFN_vkGetDescriptorSetLayoutSupportKHR)vk->vkGetDeviceProcAddr(
            device, "vkGetDescriptorSetLayoutSupportKHR");
#endif
#ifdef VK_KHR_buffer_device_address
    out->vkGetBufferDeviceAddressKHR = (PFN_vkGetBufferDeviceAddressKHR)vk->vkGetDeviceProcAddr(
        device, "vkGetBufferDeviceAddressKHR");
    out->vkGetBufferOpaqueCaptureAddressKHR =
        (PFN_vkGetBufferOpaqueCaptureAddressKHR)vk->vkGetDeviceProcAddr(
            device, "vkGetBufferOpaqueCaptureAddressKHR");
    out->vkGetDeviceMemoryOpaqueCaptureAddressKHR =
        (PFN_vkGetDeviceMemoryOpaqueCaptureAddressKHR)vk->vkGetDeviceProcAddr(
            device, "vkGetDeviceMemoryOpaqueCaptureAddressKHR");
#endif
#ifdef VK_KHR_pipeline_executable_properties
    out->vkGetPipelineExecutablePropertiesKHR =
        (PFN_vkGetPipelineExecutablePropertiesKHR)vk->vkGetDeviceProcAddr(
            device, "vkGetPipelineExecutablePropertiesKHR");
    out->vkGetPipelineExecutableStatisticsKHR =
        (PFN_vkGetPipelineExecutableStatisticsKHR)vk->vkGetDeviceProcAddr(
            device, "vkGetPipelineExecutableStatisticsKHR");
    out->vkGetPipelineExecutableInternalRepresentationsKHR =
        (PFN_vkGetPipelineExecutableInternalRepresentationsKHR)vk->vkGetDeviceProcAddr(
            device, "vkGetPipelineExecutableInternalRepresentationsKHR");
#endif
#ifdef VK_KHR_synchronization2
    out->vkCmdSetEvent2KHR =
        (PFN_vkCmdSetEvent2KHR)vk->vkGetDeviceProcAddr(device, "vkCmdSetEvent2KHR");
    out->vkCmdResetEvent2KHR =
        (PFN_vkCmdResetEvent2KHR)vk->vkGetDeviceProcAddr(device, "vkCmdResetEvent2KHR");
    out->vkCmdWaitEvents2KHR =
        (PFN_vkCmdWaitEvents2KHR)vk->vkGetDeviceProcAddr(device, "vkCmdWaitEvents2KHR");
    out->vkCmdPipelineBarrier2KHR =
        (PFN_vkCmdPipelineBarrier2KHR)vk->vkGetDeviceProcAddr(device, "vkCmdPipelineBarrier2KHR");
    out->vkCmdWriteTimestamp2KHR =
        (PFN_vkCmdWriteTimestamp2KHR)vk->vkGetDeviceProcAddr(device, "vkCmdWriteTimestamp2KHR");
    out->vkQueueSubmit2KHR =
        (PFN_vkQueueSubmit2KHR)vk->vkGetDeviceProcAddr(device, "vkQueueSubmit2KHR");
    out->vkCmdWriteBufferMarker2AMD = (PFN_vkCmdWriteBufferMarker2AMD)vk->vkGetDeviceProcAddr(
        device, "vkCmdWriteBufferMarker2AMD");
    out->vkGetQueueCheckpointData2NV = (PFN_vkGetQueueCheckpointData2NV)vk->vkGetDeviceProcAddr(
        device, "vkGetQueueCheckpointData2NV");
#endif
#ifdef VK_KHR_copy_commands2
    out->vkCmdCopyBuffer2KHR =
        (PFN_vkCmdCopyBuffer2KHR)vk->vkGetDeviceProcAddr(device, "vkCmdCopyBuffer2KHR");
    out->vkCmdCopyImage2KHR =
        (PFN_vkCmdCopyImage2KHR)vk->vkGetDeviceProcAddr(device, "vkCmdCopyImage2KHR");
    out->vkCmdCopyBufferToImage2KHR = (PFN_vkCmdCopyBufferToImage2KHR)vk->vkGetDeviceProcAddr(
        device, "vkCmdCopyBufferToImage2KHR");
    out->vkCmdCopyImageToBuffer2KHR = (PFN_vkCmdCopyImageToBuffer2KHR)vk->vkGetDeviceProcAddr(
        device, "vkCmdCopyImageToBuffer2KHR");
    out->vkCmdBlitImage2KHR =
        (PFN_vkCmdBlitImage2KHR)vk->vkGetDeviceProcAddr(device, "vkCmdBlitImage2KHR");
    out->vkCmdResolveImage2KHR =
        (PFN_vkCmdResolveImage2KHR)vk->vkGetDeviceProcAddr(device, "vkCmdResolveImage2KHR");
#endif
#ifdef VK_KHR_maintenance4
    out->vkGetDeviceBufferMemoryRequirementsKHR =
        (PFN_vkGetDeviceBufferMemoryRequirementsKHR)vk->vkGetDeviceProcAddr(
            device, "vkGetDeviceBufferMemoryRequirementsKHR");
    out->vkGetDeviceImageMemoryRequirementsKHR =
        (PFN_vkGetDeviceImageMemoryRequirementsKHR)vk->vkGetDeviceProcAddr(
            device, "vkGetDeviceImageMemoryRequirementsKHR");
    out->vkGetDeviceImageSparseMemoryRequirementsKHR =
        (PFN_vkGetDeviceImageSparseMemoryRequirementsKHR)vk->vkGetDeviceProcAddr(
            device, "vkGetDeviceImageSparseMemoryRequirementsKHR");
#endif
#ifdef VK_ANDROID_native_buffer
    out->vkGetSwapchainGrallocUsageANDROID =
        (PFN_vkGetSwapchainGrallocUsageANDROID)vk->vkGetDeviceProcAddr(
            device, "vkGetSwapchainGrallocUsageANDROID");
    out->vkAcquireImageANDROID =
        (PFN_vkAcquireImageANDROID)vk->vkGetDeviceProcAddr(device, "vkAcquireImageANDROID");
    out->vkQueueSignalReleaseImageANDROID =
        (PFN_vkQueueSignalReleaseImageANDROID)vk->vkGetDeviceProcAddr(
            device, "vkQueueSignalReleaseImageANDROID");
    out->vkGetSwapchainGrallocUsage2ANDROID =
        (PFN_vkGetSwapchainGrallocUsage2ANDROID)vk->vkGetDeviceProcAddr(
            device, "vkGetSwapchainGrallocUsage2ANDROID");
#endif
#ifdef VK_EXT_transform_feedback
    out->vkCmdBindTransformFeedbackBuffersEXT =
        (PFN_vkCmdBindTransformFeedbackBuffersEXT)vk->vkGetDeviceProcAddr(
            device, "vkCmdBindTransformFeedbackBuffersEXT");
    out->vkCmdBeginTransformFeedbackEXT =
        (PFN_vkCmdBeginTransformFeedbackEXT)vk->vkGetDeviceProcAddr(
            device, "vkCmdBeginTransformFeedbackEXT");
    out->vkCmdEndTransformFeedbackEXT = (PFN_vkCmdEndTransformFeedbackEXT)vk->vkGetDeviceProcAddr(
        device, "vkCmdEndTransformFeedbackEXT");
    out->vkCmdBeginQueryIndexedEXT =
        (PFN_vkCmdBeginQueryIndexedEXT)vk->vkGetDeviceProcAddr(device, "vkCmdBeginQueryIndexedEXT");
    out->vkCmdEndQueryIndexedEXT =
        (PFN_vkCmdEndQueryIndexedEXT)vk->vkGetDeviceProcAddr(device, "vkCmdEndQueryIndexedEXT");
    out->vkCmdDrawIndirectByteCountEXT = (PFN_vkCmdDrawIndirectByteCountEXT)vk->vkGetDeviceProcAddr(
        device, "vkCmdDrawIndirectByteCountEXT");
#endif
#ifdef VK_EXT_debug_utils
    out->vkSetDebugUtilsObjectNameEXT = (PFN_vkSetDebugUtilsObjectNameEXT)vk->vkGetDeviceProcAddr(
        device, "vkSetDebugUtilsObjectNameEXT");
    out->vkSetDebugUtilsObjectTagEXT = (PFN_vkSetDebugUtilsObjectTagEXT)vk->vkGetDeviceProcAddr(
        device, "vkSetDebugUtilsObjectTagEXT");
    out->vkQueueBeginDebugUtilsLabelEXT =
        (PFN_vkQueueBeginDebugUtilsLabelEXT)vk->vkGetDeviceProcAddr(
            device, "vkQueueBeginDebugUtilsLabelEXT");
    out->vkQueueEndDebugUtilsLabelEXT = (PFN_vkQueueEndDebugUtilsLabelEXT)vk->vkGetDeviceProcAddr(
        device, "vkQueueEndDebugUtilsLabelEXT");
    out->vkQueueInsertDebugUtilsLabelEXT =
        (PFN_vkQueueInsertDebugUtilsLabelEXT)vk->vkGetDeviceProcAddr(
            device, "vkQueueInsertDebugUtilsLabelEXT");
    out->vkCmdBeginDebugUtilsLabelEXT = (PFN_vkCmdBeginDebugUtilsLabelEXT)vk->vkGetDeviceProcAddr(
        device, "vkCmdBeginDebugUtilsLabelEXT");
    out->vkCmdEndDebugUtilsLabelEXT = (PFN_vkCmdEndDebugUtilsLabelEXT)vk->vkGetDeviceProcAddr(
        device, "vkCmdEndDebugUtilsLabelEXT");
    out->vkCmdInsertDebugUtilsLabelEXT = (PFN_vkCmdInsertDebugUtilsLabelEXT)vk->vkGetDeviceProcAddr(
        device, "vkCmdInsertDebugUtilsLabelEXT");
#endif
#ifdef VK_EXT_tooling_info
    out->vkGetPhysicalDeviceToolPropertiesEXT =
        (PFN_vkGetPhysicalDeviceToolPropertiesEXT)vk->vkGetDeviceProcAddr(
            device, "vkGetPhysicalDeviceToolPropertiesEXT");
#endif
#ifdef VK_EXT_line_rasterization
    out->vkCmdSetLineStippleEXT =
        (PFN_vkCmdSetLineStippleEXT)vk->vkGetDeviceProcAddr(device, "vkCmdSetLineStippleEXT");
#endif
#ifdef VK_EXT_extended_dynamic_state
    out->vkCmdSetCullModeEXT =
        (PFN_vkCmdSetCullModeEXT)vk->vkGetDeviceProcAddr(device, "vkCmdSetCullModeEXT");
    out->vkCmdSetFrontFaceEXT =
        (PFN_vkCmdSetFrontFaceEXT)vk->vkGetDeviceProcAddr(device, "vkCmdSetFrontFaceEXT");
    out->vkCmdSetPrimitiveTopologyEXT = (PFN_vkCmdSetPrimitiveTopologyEXT)vk->vkGetDeviceProcAddr(
        device, "vkCmdSetPrimitiveTopologyEXT");
    out->vkCmdSetViewportWithCountEXT = (PFN_vkCmdSetViewportWithCountEXT)vk->vkGetDeviceProcAddr(
        device, "vkCmdSetViewportWithCountEXT");
    out->vkCmdSetScissorWithCountEXT = (PFN_vkCmdSetScissorWithCountEXT)vk->vkGetDeviceProcAddr(
        device, "vkCmdSetScissorWithCountEXT");
    out->vkCmdBindVertexBuffers2EXT = (PFN_vkCmdBindVertexBuffers2EXT)vk->vkGetDeviceProcAddr(
        device, "vkCmdBindVertexBuffers2EXT");
    out->vkCmdSetDepthTestEnableEXT = (PFN_vkCmdSetDepthTestEnableEXT)vk->vkGetDeviceProcAddr(
        device, "vkCmdSetDepthTestEnableEXT");
    out->vkCmdSetDepthWriteEnableEXT = (PFN_vkCmdSetDepthWriteEnableEXT)vk->vkGetDeviceProcAddr(
        device, "vkCmdSetDepthWriteEnableEXT");
    out->vkCmdSetDepthCompareOpEXT =
        (PFN_vkCmdSetDepthCompareOpEXT)vk->vkGetDeviceProcAddr(device, "vkCmdSetDepthCompareOpEXT");
    out->vkCmdSetDepthBoundsTestEnableEXT =
        (PFN_vkCmdSetDepthBoundsTestEnableEXT)vk->vkGetDeviceProcAddr(
            device, "vkCmdSetDepthBoundsTestEnableEXT");
    out->vkCmdSetStencilTestEnableEXT = (PFN_vkCmdSetStencilTestEnableEXT)vk->vkGetDeviceProcAddr(
        device, "vkCmdSetStencilTestEnableEXT");
    out->vkCmdSetStencilOpEXT =
        (PFN_vkCmdSetStencilOpEXT)vk->vkGetDeviceProcAddr(device, "vkCmdSetStencilOpEXT");
#endif
#ifdef VK_EXT_swapchain_maintenance1
    out->vkReleaseSwapchainImagesEXT = (PFN_vkReleaseSwapchainImagesEXT)vk->vkGetDeviceProcAddr(
        device, "vkReleaseSwapchainImagesEXT");
#endif
#ifdef VK_EXT_private_data
    out->vkCreatePrivateDataSlotEXT = (PFN_vkCreatePrivateDataSlotEXT)vk->vkGetDeviceProcAddr(
        device, "vkCreatePrivateDataSlotEXT");
    out->vkDestroyPrivateDataSlotEXT = (PFN_vkDestroyPrivateDataSlotEXT)vk->vkGetDeviceProcAddr(
        device, "vkDestroyPrivateDataSlotEXT");
    out->vkSetPrivateDataEXT =
        (PFN_vkSetPrivateDataEXT)vk->vkGetDeviceProcAddr(device, "vkSetPrivateDataEXT");
    out->vkGetPrivateDataEXT =
        (PFN_vkGetPrivateDataEXT)vk->vkGetDeviceProcAddr(device, "vkGetPrivateDataEXT");
#endif
#ifdef VK_EXT_image_compression_control
    out->vkGetImageSubresourceLayout2EXT =
        (PFN_vkGetImageSubresourceLayout2EXT)vk->vkGetDeviceProcAddr(
            device, "vkGetImageSubresourceLayout2EXT");
#endif
#ifdef VK_EXT_extended_dynamic_state2
    out->vkCmdSetPatchControlPointsEXT = (PFN_vkCmdSetPatchControlPointsEXT)vk->vkGetDeviceProcAddr(
        device, "vkCmdSetPatchControlPointsEXT");
    out->vkCmdSetRasterizerDiscardEnableEXT =
        (PFN_vkCmdSetRasterizerDiscardEnableEXT)vk->vkGetDeviceProcAddr(
            device, "vkCmdSetRasterizerDiscardEnableEXT");
    out->vkCmdSetDepthBiasEnableEXT = (PFN_vkCmdSetDepthBiasEnableEXT)vk->vkGetDeviceProcAddr(
        device, "vkCmdSetDepthBiasEnableEXT");
    out->vkCmdSetLogicOpEXT =
        (PFN_vkCmdSetLogicOpEXT)vk->vkGetDeviceProcAddr(device, "vkCmdSetLogicOpEXT");
    out->vkCmdSetPrimitiveRestartEnableEXT =
        (PFN_vkCmdSetPrimitiveRestartEnableEXT)vk->vkGetDeviceProcAddr(
            device, "vkCmdSetPrimitiveRestartEnableEXT");
#endif
#ifdef VK_GOOGLE_gfxstream
    out->vkMapMemoryIntoAddressSpaceGOOGLE =
        (PFN_vkMapMemoryIntoAddressSpaceGOOGLE)vk->vkGetDeviceProcAddr(
            device, "vkMapMemoryIntoAddressSpaceGOOGLE");
    out->vkUpdateDescriptorSetWithTemplateSizedGOOGLE =
        (PFN_vkUpdateDescriptorSetWithTemplateSizedGOOGLE)vk->vkGetDeviceProcAddr(
            device, "vkUpdateDescriptorSetWithTemplateSizedGOOGLE");
    out->vkBeginCommandBufferAsyncGOOGLE =
        (PFN_vkBeginCommandBufferAsyncGOOGLE)vk->vkGetDeviceProcAddr(
            device, "vkBeginCommandBufferAsyncGOOGLE");
    out->vkEndCommandBufferAsyncGOOGLE = (PFN_vkEndCommandBufferAsyncGOOGLE)vk->vkGetDeviceProcAddr(
        device, "vkEndCommandBufferAsyncGOOGLE");
    out->vkResetCommandBufferAsyncGOOGLE =
        (PFN_vkResetCommandBufferAsyncGOOGLE)vk->vkGetDeviceProcAddr(
            device, "vkResetCommandBufferAsyncGOOGLE");
    out->vkCommandBufferHostSyncGOOGLE = (PFN_vkCommandBufferHostSyncGOOGLE)vk->vkGetDeviceProcAddr(
        device, "vkCommandBufferHostSyncGOOGLE");
    out->vkCreateImageWithRequirementsGOOGLE =
        (PFN_vkCreateImageWithRequirementsGOOGLE)vk->vkGetDeviceProcAddr(
            device, "vkCreateImageWithRequirementsGOOGLE");
    out->vkCreateBufferWithRequirementsGOOGLE =
        (PFN_vkCreateBufferWithRequirementsGOOGLE)vk->vkGetDeviceProcAddr(
            device, "vkCreateBufferWithRequirementsGOOGLE");
    out->vkGetMemoryHostAddressInfoGOOGLE =
        (PFN_vkGetMemoryHostAddressInfoGOOGLE)vk->vkGetDeviceProcAddr(
            device, "vkGetMemoryHostAddressInfoGOOGLE");
    out->vkFreeMemorySyncGOOGLE =
        (PFN_vkFreeMemorySyncGOOGLE)vk->vkGetDeviceProcAddr(device, "vkFreeMemorySyncGOOGLE");
    out->vkQueueHostSyncGOOGLE =
        (PFN_vkQueueHostSyncGOOGLE)vk->vkGetDeviceProcAddr(device, "vkQueueHostSyncGOOGLE");
    out->vkQueueSubmitAsyncGOOGLE =
        (PFN_vkQueueSubmitAsyncGOOGLE)vk->vkGetDeviceProcAddr(device, "vkQueueSubmitAsyncGOOGLE");
    out->vkQueueWaitIdleAsyncGOOGLE = (PFN_vkQueueWaitIdleAsyncGOOGLE)vk->vkGetDeviceProcAddr(
        device, "vkQueueWaitIdleAsyncGOOGLE");
    out->vkQueueBindSparseAsyncGOOGLE = (PFN_vkQueueBindSparseAsyncGOOGLE)vk->vkGetDeviceProcAddr(
        device, "vkQueueBindSparseAsyncGOOGLE");
    out->vkGetLinearImageLayoutGOOGLE = (PFN_vkGetLinearImageLayoutGOOGLE)vk->vkGetDeviceProcAddr(
        device, "vkGetLinearImageLayoutGOOGLE");
    out->vkGetLinearImageLayout2GOOGLE = (PFN_vkGetLinearImageLayout2GOOGLE)vk->vkGetDeviceProcAddr(
        device, "vkGetLinearImageLayout2GOOGLE");
    out->vkQueueFlushCommandsGOOGLE = (PFN_vkQueueFlushCommandsGOOGLE)vk->vkGetDeviceProcAddr(
        device, "vkQueueFlushCommandsGOOGLE");
    out->vkQueueCommitDescriptorSetUpdatesGOOGLE =
        (PFN_vkQueueCommitDescriptorSetUpdatesGOOGLE)vk->vkGetDeviceProcAddr(
            device, "vkQueueCommitDescriptorSetUpdatesGOOGLE");
    out->vkCollectDescriptorPoolIdsGOOGLE =
        (PFN_vkCollectDescriptorPoolIdsGOOGLE)vk->vkGetDeviceProcAddr(
            device, "vkCollectDescriptorPoolIdsGOOGLE");
    out->vkQueueSignalReleaseImageANDROIDAsyncGOOGLE =
        (PFN_vkQueueSignalReleaseImageANDROIDAsyncGOOGLE)vk->vkGetDeviceProcAddr(
            device, "vkQueueSignalReleaseImageANDROIDAsyncGOOGLE");
    out->vkQueueFlushCommandsFromAuxMemoryGOOGLE =
        (PFN_vkQueueFlushCommandsFromAuxMemoryGOOGLE)vk->vkGetDeviceProcAddr(
            device, "vkQueueFlushCommandsFromAuxMemoryGOOGLE");
    out->vkGetBlobGOOGLE = (PFN_vkGetBlobGOOGLE)vk->vkGetDeviceProcAddr(device, "vkGetBlobGOOGLE");
    out->vkUpdateDescriptorSetWithTemplateSized2GOOGLE =
        (PFN_vkUpdateDescriptorSetWithTemplateSized2GOOGLE)vk->vkGetDeviceProcAddr(
            device, "vkUpdateDescriptorSetWithTemplateSized2GOOGLE");
    out->vkQueueSubmitAsync2GOOGLE =
        (PFN_vkQueueSubmitAsync2GOOGLE)vk->vkGetDeviceProcAddr(device, "vkQueueSubmitAsync2GOOGLE");
#endif
}

bool vulkan_dispatch_check_instance_VK_VERSION_1_0(const VulkanDispatch* vk)

{
    bool good = true;
    if (!vk->vkCreateInstance) {
        fprintf(stderr, "VK_VERSION_1_0 check failed: vkCreateInstance not found\n");
        good = false;
    }
    if (!vk->vkEnumerateInstanceExtensionProperties) {
        fprintf(stderr,
                "VK_VERSION_1_0 check failed: vkEnumerateInstanceExtensionProperties not found\n");
        good = false;
    }
    if (!vk->vkEnumerateInstanceLayerProperties) {
        fprintf(stderr,
                "VK_VERSION_1_0 check failed: vkEnumerateInstanceLayerProperties not found\n");
        good = false;
    }
    if (!vk->vkGetDeviceProcAddr) {
        fprintf(stderr, "VK_VERSION_1_0 check failed: vkGetDeviceProcAddr not found\n");
        good = false;
    }
    if (!vk->vkGetPhysicalDeviceSparseImageFormatProperties) {
        fprintf(stderr,
                "VK_VERSION_1_0 check failed: vkGetPhysicalDeviceSparseImageFormatProperties not "
                "found\n");
        good = false;
    }
    return good;
}

bool vulkan_dispatch_check_instance_VK_VERSION_1_1(const VulkanDispatch* vk)

{
    bool good = true;
    if (!vk->vkEnumerateInstanceVersion) {
        fprintf(stderr, "VK_VERSION_1_1 check failed: vkEnumerateInstanceVersion not found\n");
        good = false;
    }
    if (!vk->vkEnumeratePhysicalDeviceGroups) {
        fprintf(stderr, "VK_VERSION_1_1 check failed: vkEnumeratePhysicalDeviceGroups not found\n");
        good = false;
    }
    if (!vk->vkGetPhysicalDeviceFeatures2) {
        fprintf(stderr, "VK_VERSION_1_1 check failed: vkGetPhysicalDeviceFeatures2 not found\n");
        good = false;
    }
    if (!vk->vkGetPhysicalDeviceProperties2) {
        fprintf(stderr, "VK_VERSION_1_1 check failed: vkGetPhysicalDeviceProperties2 not found\n");
        good = false;
    }
    if (!vk->vkGetPhysicalDeviceFormatProperties2) {
        fprintf(stderr,
                "VK_VERSION_1_1 check failed: vkGetPhysicalDeviceFormatProperties2 not found\n");
        good = false;
    }
    if (!vk->vkGetPhysicalDeviceImageFormatProperties2) {
        fprintf(
            stderr,
            "VK_VERSION_1_1 check failed: vkGetPhysicalDeviceImageFormatProperties2 not found\n");
        good = false;
    }
    if (!vk->vkGetPhysicalDeviceQueueFamilyProperties2) {
        fprintf(
            stderr,
            "VK_VERSION_1_1 check failed: vkGetPhysicalDeviceQueueFamilyProperties2 not found\n");
        good = false;
    }
    if (!vk->vkGetPhysicalDeviceMemoryProperties2) {
        fprintf(stderr,
                "VK_VERSION_1_1 check failed: vkGetPhysicalDeviceMemoryProperties2 not found\n");
        good = false;
    }
    if (!vk->vkGetPhysicalDeviceSparseImageFormatProperties2) {
        fprintf(stderr,
                "VK_VERSION_1_1 check failed: vkGetPhysicalDeviceSparseImageFormatProperties2 not "
                "found\n");
        good = false;
    }
    if (!vk->vkGetPhysicalDeviceExternalBufferProperties) {
        fprintf(
            stderr,
            "VK_VERSION_1_1 check failed: vkGetPhysicalDeviceExternalBufferProperties not found\n");
        good = false;
    }
    if (!vk->vkGetPhysicalDeviceExternalFenceProperties) {
        fprintf(
            stderr,
            "VK_VERSION_1_1 check failed: vkGetPhysicalDeviceExternalFenceProperties not found\n");
        good = false;
    }
    if (!vk->vkGetPhysicalDeviceExternalSemaphoreProperties) {
        fprintf(stderr,
                "VK_VERSION_1_1 check failed: vkGetPhysicalDeviceExternalSemaphoreProperties not "
                "found\n");
        good = false;
    }
    return good;
}

bool vulkan_dispatch_check_device_VK_VERSION_1_0(const VulkanDispatch* vk)

{
    bool good = true;
    if (!vk->vkGetDeviceQueue) {
        fprintf(stderr, "VK_VERSION_1_0 check failed: vkGetDeviceQueue not found\n");
        good = false;
    }
    if (!vk->vkQueueSubmit) {
        fprintf(stderr, "VK_VERSION_1_0 check failed: vkQueueSubmit not found\n");
        good = false;
    }
    if (!vk->vkQueueWaitIdle) {
        fprintf(stderr, "VK_VERSION_1_0 check failed: vkQueueWaitIdle not found\n");
        good = false;
    }
    if (!vk->vkDeviceWaitIdle) {
        fprintf(stderr, "VK_VERSION_1_0 check failed: vkDeviceWaitIdle not found\n");
        good = false;
    }
    if (!vk->vkAllocateMemory) {
        fprintf(stderr, "VK_VERSION_1_0 check failed: vkAllocateMemory not found\n");
        good = false;
    }
    if (!vk->vkFreeMemory) {
        fprintf(stderr, "VK_VERSION_1_0 check failed: vkFreeMemory not found\n");
        good = false;
    }
    if (!vk->vkMapMemory) {
        fprintf(stderr, "VK_VERSION_1_0 check failed: vkMapMemory not found\n");
        good = false;
    }
    if (!vk->vkUnmapMemory) {
        fprintf(stderr, "VK_VERSION_1_0 check failed: vkUnmapMemory not found\n");
        good = false;
    }
    if (!vk->vkFlushMappedMemoryRanges) {
        fprintf(stderr, "VK_VERSION_1_0 check failed: vkFlushMappedMemoryRanges not found\n");
        good = false;
    }
    if (!vk->vkInvalidateMappedMemoryRanges) {
        fprintf(stderr, "VK_VERSION_1_0 check failed: vkInvalidateMappedMemoryRanges not found\n");
        good = false;
    }
    if (!vk->vkGetDeviceMemoryCommitment) {
        fprintf(stderr, "VK_VERSION_1_0 check failed: vkGetDeviceMemoryCommitment not found\n");
        good = false;
    }
    if (!vk->vkBindBufferMemory) {
        fprintf(stderr, "VK_VERSION_1_0 check failed: vkBindBufferMemory not found\n");
        good = false;
    }
    if (!vk->vkBindImageMemory) {
        fprintf(stderr, "VK_VERSION_1_0 check failed: vkBindImageMemory not found\n");
        good = false;
    }
    if (!vk->vkGetBufferMemoryRequirements) {
        fprintf(stderr, "VK_VERSION_1_0 check failed: vkGetBufferMemoryRequirements not found\n");
        good = false;
    }
    if (!vk->vkGetImageMemoryRequirements) {
        fprintf(stderr, "VK_VERSION_1_0 check failed: vkGetImageMemoryRequirements not found\n");
        good = false;
    }
    if (!vk->vkGetImageSparseMemoryRequirements) {
        fprintf(stderr,
                "VK_VERSION_1_0 check failed: vkGetImageSparseMemoryRequirements not found\n");
        good = false;
    }
    if (!vk->vkQueueBindSparse) {
        fprintf(stderr, "VK_VERSION_1_0 check failed: vkQueueBindSparse not found\n");
        good = false;
    }
    if (!vk->vkCreateFence) {
        fprintf(stderr, "VK_VERSION_1_0 check failed: vkCreateFence not found\n");
        good = false;
    }
    if (!vk->vkDestroyFence) {
        fprintf(stderr, "VK_VERSION_1_0 check failed: vkDestroyFence not found\n");
        good = false;
    }
    if (!vk->vkResetFences) {
        fprintf(stderr, "VK_VERSION_1_0 check failed: vkResetFences not found\n");
        good = false;
    }
    if (!vk->vkGetFenceStatus) {
        fprintf(stderr, "VK_VERSION_1_0 check failed: vkGetFenceStatus not found\n");
        good = false;
    }
    if (!vk->vkWaitForFences) {
        fprintf(stderr, "VK_VERSION_1_0 check failed: vkWaitForFences not found\n");
        good = false;
    }
    if (!vk->vkCreateSemaphore) {
        fprintf(stderr, "VK_VERSION_1_0 check failed: vkCreateSemaphore not found\n");
        good = false;
    }
    if (!vk->vkDestroySemaphore) {
        fprintf(stderr, "VK_VERSION_1_0 check failed: vkDestroySemaphore not found\n");
        good = false;
    }
    if (!vk->vkCreateEvent) {
        fprintf(stderr, "VK_VERSION_1_0 check failed: vkCreateEvent not found\n");
        good = false;
    }
    if (!vk->vkDestroyEvent) {
        fprintf(stderr, "VK_VERSION_1_0 check failed: vkDestroyEvent not found\n");
        good = false;
    }
    if (!vk->vkGetEventStatus) {
        fprintf(stderr, "VK_VERSION_1_0 check failed: vkGetEventStatus not found\n");
        good = false;
    }
    if (!vk->vkSetEvent) {
        fprintf(stderr, "VK_VERSION_1_0 check failed: vkSetEvent not found\n");
        good = false;
    }
    if (!vk->vkResetEvent) {
        fprintf(stderr, "VK_VERSION_1_0 check failed: vkResetEvent not found\n");
        good = false;
    }
    if (!vk->vkCreateQueryPool) {
        fprintf(stderr, "VK_VERSION_1_0 check failed: vkCreateQueryPool not found\n");
        good = false;
    }
    if (!vk->vkDestroyQueryPool) {
        fprintf(stderr, "VK_VERSION_1_0 check failed: vkDestroyQueryPool not found\n");
        good = false;
    }
    if (!vk->vkGetQueryPoolResults) {
        fprintf(stderr, "VK_VERSION_1_0 check failed: vkGetQueryPoolResults not found\n");
        good = false;
    }
    if (!vk->vkCreateBuffer) {
        fprintf(stderr, "VK_VERSION_1_0 check failed: vkCreateBuffer not found\n");
        good = false;
    }
    if (!vk->vkDestroyBuffer) {
        fprintf(stderr, "VK_VERSION_1_0 check failed: vkDestroyBuffer not found\n");
        good = false;
    }
    if (!vk->vkCreateBufferView) {
        fprintf(stderr, "VK_VERSION_1_0 check failed: vkCreateBufferView not found\n");
        good = false;
    }
    if (!vk->vkDestroyBufferView) {
        fprintf(stderr, "VK_VERSION_1_0 check failed: vkDestroyBufferView not found\n");
        good = false;
    }
    if (!vk->vkCreateImage) {
        fprintf(stderr, "VK_VERSION_1_0 check failed: vkCreateImage not found\n");
        good = false;
    }
    if (!vk->vkDestroyImage) {
        fprintf(stderr, "VK_VERSION_1_0 check failed: vkDestroyImage not found\n");
        good = false;
    }
    if (!vk->vkGetImageSubresourceLayout) {
        fprintf(stderr, "VK_VERSION_1_0 check failed: vkGetImageSubresourceLayout not found\n");
        good = false;
    }
    if (!vk->vkCreateImageView) {
        fprintf(stderr, "VK_VERSION_1_0 check failed: vkCreateImageView not found\n");
        good = false;
    }
    if (!vk->vkDestroyImageView) {
        fprintf(stderr, "VK_VERSION_1_0 check failed: vkDestroyImageView not found\n");
        good = false;
    }
    if (!vk->vkCreateShaderModule) {
        fprintf(stderr, "VK_VERSION_1_0 check failed: vkCreateShaderModule not found\n");
        good = false;
    }
    if (!vk->vkDestroyShaderModule) {
        fprintf(stderr, "VK_VERSION_1_0 check failed: vkDestroyShaderModule not found\n");
        good = false;
    }
    if (!vk->vkCreatePipelineCache) {
        fprintf(stderr, "VK_VERSION_1_0 check failed: vkCreatePipelineCache not found\n");
        good = false;
    }
    if (!vk->vkDestroyPipelineCache) {
        fprintf(stderr, "VK_VERSION_1_0 check failed: vkDestroyPipelineCache not found\n");
        good = false;
    }
    if (!vk->vkGetPipelineCacheData) {
        fprintf(stderr, "VK_VERSION_1_0 check failed: vkGetPipelineCacheData not found\n");
        good = false;
    }
    if (!vk->vkMergePipelineCaches) {
        fprintf(stderr, "VK_VERSION_1_0 check failed: vkMergePipelineCaches not found\n");
        good = false;
    }
    if (!vk->vkCreateGraphicsPipelines) {
        fprintf(stderr, "VK_VERSION_1_0 check failed: vkCreateGraphicsPipelines not found\n");
        good = false;
    }
    if (!vk->vkCreateComputePipelines) {
        fprintf(stderr, "VK_VERSION_1_0 check failed: vkCreateComputePipelines not found\n");
        good = false;
    }
    if (!vk->vkDestroyPipeline) {
        fprintf(stderr, "VK_VERSION_1_0 check failed: vkDestroyPipeline not found\n");
        good = false;
    }
    if (!vk->vkCreatePipelineLayout) {
        fprintf(stderr, "VK_VERSION_1_0 check failed: vkCreatePipelineLayout not found\n");
        good = false;
    }
    if (!vk->vkDestroyPipelineLayout) {
        fprintf(stderr, "VK_VERSION_1_0 check failed: vkDestroyPipelineLayout not found\n");
        good = false;
    }
    if (!vk->vkCreateSampler) {
        fprintf(stderr, "VK_VERSION_1_0 check failed: vkCreateSampler not found\n");
        good = false;
    }
    if (!vk->vkDestroySampler) {
        fprintf(stderr, "VK_VERSION_1_0 check failed: vkDestroySampler not found\n");
        good = false;
    }
    if (!vk->vkCreateDescriptorSetLayout) {
        fprintf(stderr, "VK_VERSION_1_0 check failed: vkCreateDescriptorSetLayout not found\n");
        good = false;
    }
    if (!vk->vkDestroyDescriptorSetLayout) {
        fprintf(stderr, "VK_VERSION_1_0 check failed: vkDestroyDescriptorSetLayout not found\n");
        good = false;
    }
    if (!vk->vkCreateDescriptorPool) {
        fprintf(stderr, "VK_VERSION_1_0 check failed: vkCreateDescriptorPool not found\n");
        good = false;
    }
    if (!vk->vkDestroyDescriptorPool) {
        fprintf(stderr, "VK_VERSION_1_0 check failed: vkDestroyDescriptorPool not found\n");
        good = false;
    }
    if (!vk->vkResetDescriptorPool) {
        fprintf(stderr, "VK_VERSION_1_0 check failed: vkResetDescriptorPool not found\n");
        good = false;
    }
    if (!vk->vkAllocateDescriptorSets) {
        fprintf(stderr, "VK_VERSION_1_0 check failed: vkAllocateDescriptorSets not found\n");
        good = false;
    }
    if (!vk->vkFreeDescriptorSets) {
        fprintf(stderr, "VK_VERSION_1_0 check failed: vkFreeDescriptorSets not found\n");
        good = false;
    }
    if (!vk->vkUpdateDescriptorSets) {
        fprintf(stderr, "VK_VERSION_1_0 check failed: vkUpdateDescriptorSets not found\n");
        good = false;
    }
    if (!vk->vkCreateFramebuffer) {
        fprintf(stderr, "VK_VERSION_1_0 check failed: vkCreateFramebuffer not found\n");
        good = false;
    }
    if (!vk->vkDestroyFramebuffer) {
        fprintf(stderr, "VK_VERSION_1_0 check failed: vkDestroyFramebuffer not found\n");
        good = false;
    }
    if (!vk->vkCreateRenderPass) {
        fprintf(stderr, "VK_VERSION_1_0 check failed: vkCreateRenderPass not found\n");
        good = false;
    }
    if (!vk->vkDestroyRenderPass) {
        fprintf(stderr, "VK_VERSION_1_0 check failed: vkDestroyRenderPass not found\n");
        good = false;
    }
    if (!vk->vkGetRenderAreaGranularity) {
        fprintf(stderr, "VK_VERSION_1_0 check failed: vkGetRenderAreaGranularity not found\n");
        good = false;
    }
    if (!vk->vkCreateCommandPool) {
        fprintf(stderr, "VK_VERSION_1_0 check failed: vkCreateCommandPool not found\n");
        good = false;
    }
    if (!vk->vkDestroyCommandPool) {
        fprintf(stderr, "VK_VERSION_1_0 check failed: vkDestroyCommandPool not found\n");
        good = false;
    }
    if (!vk->vkResetCommandPool) {
        fprintf(stderr, "VK_VERSION_1_0 check failed: vkResetCommandPool not found\n");
        good = false;
    }
    if (!vk->vkAllocateCommandBuffers) {
        fprintf(stderr, "VK_VERSION_1_0 check failed: vkAllocateCommandBuffers not found\n");
        good = false;
    }
    if (!vk->vkFreeCommandBuffers) {
        fprintf(stderr, "VK_VERSION_1_0 check failed: vkFreeCommandBuffers not found\n");
        good = false;
    }
    if (!vk->vkBeginCommandBuffer) {
        fprintf(stderr, "VK_VERSION_1_0 check failed: vkBeginCommandBuffer not found\n");
        good = false;
    }
    if (!vk->vkEndCommandBuffer) {
        fprintf(stderr, "VK_VERSION_1_0 check failed: vkEndCommandBuffer not found\n");
        good = false;
    }
    if (!vk->vkResetCommandBuffer) {
        fprintf(stderr, "VK_VERSION_1_0 check failed: vkResetCommandBuffer not found\n");
        good = false;
    }
    if (!vk->vkCmdBindPipeline) {
        fprintf(stderr, "VK_VERSION_1_0 check failed: vkCmdBindPipeline not found\n");
        good = false;
    }
    if (!vk->vkCmdSetViewport) {
        fprintf(stderr, "VK_VERSION_1_0 check failed: vkCmdSetViewport not found\n");
        good = false;
    }
    if (!vk->vkCmdSetScissor) {
        fprintf(stderr, "VK_VERSION_1_0 check failed: vkCmdSetScissor not found\n");
        good = false;
    }
    if (!vk->vkCmdSetLineWidth) {
        fprintf(stderr, "VK_VERSION_1_0 check failed: vkCmdSetLineWidth not found\n");
        good = false;
    }
    if (!vk->vkCmdSetDepthBias) {
        fprintf(stderr, "VK_VERSION_1_0 check failed: vkCmdSetDepthBias not found\n");
        good = false;
    }
    if (!vk->vkCmdSetBlendConstants) {
        fprintf(stderr, "VK_VERSION_1_0 check failed: vkCmdSetBlendConstants not found\n");
        good = false;
    }
    if (!vk->vkCmdSetDepthBounds) {
        fprintf(stderr, "VK_VERSION_1_0 check failed: vkCmdSetDepthBounds not found\n");
        good = false;
    }
    if (!vk->vkCmdSetStencilCompareMask) {
        fprintf(stderr, "VK_VERSION_1_0 check failed: vkCmdSetStencilCompareMask not found\n");
        good = false;
    }
    if (!vk->vkCmdSetStencilWriteMask) {
        fprintf(stderr, "VK_VERSION_1_0 check failed: vkCmdSetStencilWriteMask not found\n");
        good = false;
    }
    if (!vk->vkCmdSetStencilReference) {
        fprintf(stderr, "VK_VERSION_1_0 check failed: vkCmdSetStencilReference not found\n");
        good = false;
    }
    if (!vk->vkCmdBindDescriptorSets) {
        fprintf(stderr, "VK_VERSION_1_0 check failed: vkCmdBindDescriptorSets not found\n");
        good = false;
    }
    if (!vk->vkCmdBindIndexBuffer) {
        fprintf(stderr, "VK_VERSION_1_0 check failed: vkCmdBindIndexBuffer not found\n");
        good = false;
    }
    if (!vk->vkCmdBindVertexBuffers) {
        fprintf(stderr, "VK_VERSION_1_0 check failed: vkCmdBindVertexBuffers not found\n");
        good = false;
    }
    if (!vk->vkCmdDraw) {
        fprintf(stderr, "VK_VERSION_1_0 check failed: vkCmdDraw not found\n");
        good = false;
    }
    if (!vk->vkCmdDrawIndexed) {
        fprintf(stderr, "VK_VERSION_1_0 check failed: vkCmdDrawIndexed not found\n");
        good = false;
    }
    if (!vk->vkCmdDrawIndirect) {
        fprintf(stderr, "VK_VERSION_1_0 check failed: vkCmdDrawIndirect not found\n");
        good = false;
    }
    if (!vk->vkCmdDrawIndexedIndirect) {
        fprintf(stderr, "VK_VERSION_1_0 check failed: vkCmdDrawIndexedIndirect not found\n");
        good = false;
    }
    if (!vk->vkCmdDispatch) {
        fprintf(stderr, "VK_VERSION_1_0 check failed: vkCmdDispatch not found\n");
        good = false;
    }
    if (!vk->vkCmdDispatchIndirect) {
        fprintf(stderr, "VK_VERSION_1_0 check failed: vkCmdDispatchIndirect not found\n");
        good = false;
    }
    if (!vk->vkCmdCopyBuffer) {
        fprintf(stderr, "VK_VERSION_1_0 check failed: vkCmdCopyBuffer not found\n");
        good = false;
    }
    if (!vk->vkCmdCopyImage) {
        fprintf(stderr, "VK_VERSION_1_0 check failed: vkCmdCopyImage not found\n");
        good = false;
    }
    if (!vk->vkCmdBlitImage) {
        fprintf(stderr, "VK_VERSION_1_0 check failed: vkCmdBlitImage not found\n");
        good = false;
    }
    if (!vk->vkCmdCopyBufferToImage) {
        fprintf(stderr, "VK_VERSION_1_0 check failed: vkCmdCopyBufferToImage not found\n");
        good = false;
    }
    if (!vk->vkCmdCopyImageToBuffer) {
        fprintf(stderr, "VK_VERSION_1_0 check failed: vkCmdCopyImageToBuffer not found\n");
        good = false;
    }
    if (!vk->vkCmdUpdateBuffer) {
        fprintf(stderr, "VK_VERSION_1_0 check failed: vkCmdUpdateBuffer not found\n");
        good = false;
    }
    if (!vk->vkCmdFillBuffer) {
        fprintf(stderr, "VK_VERSION_1_0 check failed: vkCmdFillBuffer not found\n");
        good = false;
    }
    if (!vk->vkCmdClearColorImage) {
        fprintf(stderr, "VK_VERSION_1_0 check failed: vkCmdClearColorImage not found\n");
        good = false;
    }
    if (!vk->vkCmdClearDepthStencilImage) {
        fprintf(stderr, "VK_VERSION_1_0 check failed: vkCmdClearDepthStencilImage not found\n");
        good = false;
    }
    if (!vk->vkCmdClearAttachments) {
        fprintf(stderr, "VK_VERSION_1_0 check failed: vkCmdClearAttachments not found\n");
        good = false;
    }
    if (!vk->vkCmdResolveImage) {
        fprintf(stderr, "VK_VERSION_1_0 check failed: vkCmdResolveImage not found\n");
        good = false;
    }
    if (!vk->vkCmdSetEvent) {
        fprintf(stderr, "VK_VERSION_1_0 check failed: vkCmdSetEvent not found\n");
        good = false;
    }
    if (!vk->vkCmdResetEvent) {
        fprintf(stderr, "VK_VERSION_1_0 check failed: vkCmdResetEvent not found\n");
        good = false;
    }
    if (!vk->vkCmdWaitEvents) {
        fprintf(stderr, "VK_VERSION_1_0 check failed: vkCmdWaitEvents not found\n");
        good = false;
    }
    if (!vk->vkCmdPipelineBarrier) {
        fprintf(stderr, "VK_VERSION_1_0 check failed: vkCmdPipelineBarrier not found\n");
        good = false;
    }
    if (!vk->vkCmdBeginQuery) {
        fprintf(stderr, "VK_VERSION_1_0 check failed: vkCmdBeginQuery not found\n");
        good = false;
    }
    if (!vk->vkCmdEndQuery) {
        fprintf(stderr, "VK_VERSION_1_0 check failed: vkCmdEndQuery not found\n");
        good = false;
    }
    if (!vk->vkCmdResetQueryPool) {
        fprintf(stderr, "VK_VERSION_1_0 check failed: vkCmdResetQueryPool not found\n");
        good = false;
    }
    if (!vk->vkCmdWriteTimestamp) {
        fprintf(stderr, "VK_VERSION_1_0 check failed: vkCmdWriteTimestamp not found\n");
        good = false;
    }
    if (!vk->vkCmdCopyQueryPoolResults) {
        fprintf(stderr, "VK_VERSION_1_0 check failed: vkCmdCopyQueryPoolResults not found\n");
        good = false;
    }
    if (!vk->vkCmdPushConstants) {
        fprintf(stderr, "VK_VERSION_1_0 check failed: vkCmdPushConstants not found\n");
        good = false;
    }
    if (!vk->vkCmdBeginRenderPass) {
        fprintf(stderr, "VK_VERSION_1_0 check failed: vkCmdBeginRenderPass not found\n");
        good = false;
    }
    if (!vk->vkCmdNextSubpass) {
        fprintf(stderr, "VK_VERSION_1_0 check failed: vkCmdNextSubpass not found\n");
        good = false;
    }
    if (!vk->vkCmdEndRenderPass) {
        fprintf(stderr, "VK_VERSION_1_0 check failed: vkCmdEndRenderPass not found\n");
        good = false;
    }
    if (!vk->vkCmdExecuteCommands) {
        fprintf(stderr, "VK_VERSION_1_0 check failed: vkCmdExecuteCommands not found\n");
        good = false;
    }
    return good;
}

bool vulkan_dispatch_check_device_VK_VERSION_1_1(const VulkanDispatch* vk)

{
    bool good = true;
    if (!vk->vkBindBufferMemory2) {
        fprintf(stderr, "VK_VERSION_1_1 check failed: vkBindBufferMemory2 not found\n");
        good = false;
    }
    if (!vk->vkBindImageMemory2) {
        fprintf(stderr, "VK_VERSION_1_1 check failed: vkBindImageMemory2 not found\n");
        good = false;
    }
    if (!vk->vkGetDeviceGroupPeerMemoryFeatures) {
        fprintf(stderr,
                "VK_VERSION_1_1 check failed: vkGetDeviceGroupPeerMemoryFeatures not found\n");
        good = false;
    }
    if (!vk->vkCmdSetDeviceMask) {
        fprintf(stderr, "VK_VERSION_1_1 check failed: vkCmdSetDeviceMask not found\n");
        good = false;
    }
    if (!vk->vkCmdDispatchBase) {
        fprintf(stderr, "VK_VERSION_1_1 check failed: vkCmdDispatchBase not found\n");
        good = false;
    }
    if (!vk->vkGetImageMemoryRequirements2) {
        fprintf(stderr, "VK_VERSION_1_1 check failed: vkGetImageMemoryRequirements2 not found\n");
        good = false;
    }
    if (!vk->vkGetBufferMemoryRequirements2) {
        fprintf(stderr, "VK_VERSION_1_1 check failed: vkGetBufferMemoryRequirements2 not found\n");
        good = false;
    }
    if (!vk->vkGetImageSparseMemoryRequirements2) {
        fprintf(stderr,
                "VK_VERSION_1_1 check failed: vkGetImageSparseMemoryRequirements2 not found\n");
        good = false;
    }
    if (!vk->vkTrimCommandPool) {
        fprintf(stderr, "VK_VERSION_1_1 check failed: vkTrimCommandPool not found\n");
        good = false;
    }
    if (!vk->vkGetDeviceQueue2) {
        fprintf(stderr, "VK_VERSION_1_1 check failed: vkGetDeviceQueue2 not found\n");
        good = false;
    }
    if (!vk->vkCreateSamplerYcbcrConversion) {
        fprintf(stderr, "VK_VERSION_1_1 check failed: vkCreateSamplerYcbcrConversion not found\n");
        good = false;
    }
    if (!vk->vkDestroySamplerYcbcrConversion) {
        fprintf(stderr, "VK_VERSION_1_1 check failed: vkDestroySamplerYcbcrConversion not found\n");
        good = false;
    }
    if (!vk->vkCreateDescriptorUpdateTemplate) {
        fprintf(stderr,
                "VK_VERSION_1_1 check failed: vkCreateDescriptorUpdateTemplate not found\n");
        good = false;
    }
    if (!vk->vkDestroyDescriptorUpdateTemplate) {
        fprintf(stderr,
                "VK_VERSION_1_1 check failed: vkDestroyDescriptorUpdateTemplate not found\n");
        good = false;
    }
    if (!vk->vkUpdateDescriptorSetWithTemplate) {
        fprintf(stderr,
                "VK_VERSION_1_1 check failed: vkUpdateDescriptorSetWithTemplate not found\n");
        good = false;
    }
    if (!vk->vkGetDescriptorSetLayoutSupport) {
        fprintf(stderr, "VK_VERSION_1_1 check failed: vkGetDescriptorSetLayoutSupport not found\n");
        good = false;
    }
    return good;
}

}  // namespace vk
}  // namespace gfxstream
