/* auto-generated, do not modify */
#include "config.h"

#include <glib.h>

#include "fu-uefi-struct.h"
#include "fu-byte-array.h"
#include "fu-mem-private.h"
#include "fu-string.h"
#include "fu-efi-struct.h"

#ifdef G_LOG_DOMAIN
  #undef G_LOG_DOMAIN
#endif
#define G_LOG_DOMAIN "FuStruct"

/**
 * fu_uefi_update_info_status_to_string:
 * @val: value, e.g. %FU_UEFI_UPDATE_INFO_STATUS_ATTEMPT_UPDATE
 *
 * Converts an enumerated value to a string.
 *
 * Returns: identifier string
 **/
const gchar *
fu_uefi_update_info_status_to_string(FuUefiUpdateInfoStatus val)
{
    if (val == FU_UEFI_UPDATE_INFO_STATUS_ATTEMPT_UPDATE)
        return "attempt-update";
    if (val == FU_UEFI_UPDATE_INFO_STATUS_ATTEMPTED)
        return "attempted";
    return NULL;
}
/**
 * fu_uefi_update_info_status_from_string:
 * @val: (nullable): a string, e.g. `attempt-update`
 *
 * Converts a string to an enumerated value.
 *
 * Returns: enumerated value
 **/
FuUefiUpdateInfoStatus
fu_uefi_update_info_status_from_string(const gchar *val)
{
    if (g_strcmp0(val, "attempt-update") == 0)
        return FU_UEFI_UPDATE_INFO_STATUS_ATTEMPT_UPDATE;
    if (g_strcmp0(val, "attempted") == 0)
        return FU_UEFI_UPDATE_INFO_STATUS_ATTEMPTED;
    return FU_UEFI_UPDATE_INFO_STATUS_UNKNOWN;
}

/**
 * fu_uefi_capsule_device_kind_to_string:
 * @val: value, e.g. %FU_UEFI_CAPSULE_DEVICE_KIND_SYSTEM_FIRMWARE
 *
 * Converts an enumerated value to a string.
 *
 * Returns: identifier string
 **/
const gchar *
fu_uefi_capsule_device_kind_to_string(FuUefiCapsuleDeviceKind val)
{
    if (val == FU_UEFI_CAPSULE_DEVICE_KIND_SYSTEM_FIRMWARE)
        return "system-firmware";
    if (val == FU_UEFI_CAPSULE_DEVICE_KIND_DEVICE_FIRMWARE)
        return "device-firmware";
    if (val == FU_UEFI_CAPSULE_DEVICE_KIND_UEFI_DRIVER)
        return "uefi-driver";
    if (val == FU_UEFI_CAPSULE_DEVICE_KIND_FMP)
        return "fmp";
    if (val == FU_UEFI_CAPSULE_DEVICE_KIND_DELL_TPM_FIRMWARE)
        return "dell-tpm-firmware";
    return NULL;
}
/**
 * fu_uefi_capsule_device_kind_from_string:
 * @val: (nullable): a string, e.g. `system-firmware`
 *
 * Converts a string to an enumerated value.
 *
 * Returns: enumerated value
 **/
FuUefiCapsuleDeviceKind
fu_uefi_capsule_device_kind_from_string(const gchar *val)
{
    if (g_strcmp0(val, "system-firmware") == 0)
        return FU_UEFI_CAPSULE_DEVICE_KIND_SYSTEM_FIRMWARE;
    if (g_strcmp0(val, "device-firmware") == 0)
        return FU_UEFI_CAPSULE_DEVICE_KIND_DEVICE_FIRMWARE;
    if (g_strcmp0(val, "uefi-driver") == 0)
        return FU_UEFI_CAPSULE_DEVICE_KIND_UEFI_DRIVER;
    if (g_strcmp0(val, "fmp") == 0)
        return FU_UEFI_CAPSULE_DEVICE_KIND_FMP;
    if (g_strcmp0(val, "dell-tpm-firmware") == 0)
        return FU_UEFI_CAPSULE_DEVICE_KIND_DELL_TPM_FIRMWARE;
    return FU_UEFI_CAPSULE_DEVICE_KIND_UNKNOWN;
}

/**
 * fu_uefi_capsule_device_status_to_string:
 * @val: value, e.g. %FU_UEFI_CAPSULE_DEVICE_STATUS_ERROR_UNSUCCESSFUL
 *
 * Converts an enumerated value to a string.
 *
 * Returns: identifier string
 **/
const gchar *
fu_uefi_capsule_device_status_to_string(FuUefiCapsuleDeviceStatus val)
{
    if (val == FU_UEFI_CAPSULE_DEVICE_STATUS_SUCCESS)
        return "success";
    if (val == FU_UEFI_CAPSULE_DEVICE_STATUS_ERROR_UNSUCCESSFUL)
        return "error-unsuccessful";
    if (val == FU_UEFI_CAPSULE_DEVICE_STATUS_ERROR_INSUFFICIENT_RESOURCES)
        return "error-insufficient-resources";
    if (val == FU_UEFI_CAPSULE_DEVICE_STATUS_ERROR_INCORRECT_VERSION)
        return "error-incorrect-version";
    if (val == FU_UEFI_CAPSULE_DEVICE_STATUS_ERROR_INVALID_FORMAT)
        return "error-invalid-format";
    if (val == FU_UEFI_CAPSULE_DEVICE_STATUS_ERROR_AUTH_ERROR)
        return "error-auth-error";
    if (val == FU_UEFI_CAPSULE_DEVICE_STATUS_ERROR_PWR_EVT_AC)
        return "error-pwr-evt-ac";
    if (val == FU_UEFI_CAPSULE_DEVICE_STATUS_ERROR_PWR_EVT_BATT)
        return "error-pwr-evt-batt";
    return NULL;
}
/**
 * fu_struct_efi_ux_capsule_header_ref: (skip):
 **/
FuStructEfiUxCapsuleHeader *
fu_struct_efi_ux_capsule_header_ref(FuStructEfiUxCapsuleHeader *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    st->refcount++;
    return st;
}
/**
 * fu_struct_efi_ux_capsule_header_unref: (skip):
 **/
void
fu_struct_efi_ux_capsule_header_unref(FuStructEfiUxCapsuleHeader *st)
{
    g_return_if_fail(st != NULL);
    if (st->refcount == 0) {
        g_critical("FuStructEfiUxCapsuleHeader refcount already zero");
        return;
    }
    if (--st->refcount > 0)
        return;
    if (st->buf != NULL)
        g_byte_array_unref(st->buf);
    g_free(st);
}
/**
 * fu_struct_efi_ux_capsule_header_new_internal: (skip):
 **/
static FuStructEfiUxCapsuleHeader *
fu_struct_efi_ux_capsule_header_new_internal(void)
{
    FuStructEfiUxCapsuleHeader *st = g_new0(FuStructEfiUxCapsuleHeader, 1);
    st->refcount = 1;
    return st;
}

/* getters */
/**
 * fu_struct_efi_ux_capsule_header_get_checksum: (skip):
 **/
guint8
fu_struct_efi_ux_capsule_header_get_checksum(const FuStructEfiUxCapsuleHeader *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[1];
}
/**
 * fu_struct_efi_ux_capsule_header_get_image_type: (skip):
 **/
guint8
fu_struct_efi_ux_capsule_header_get_image_type(const FuStructEfiUxCapsuleHeader *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[2];
}
/**
 * fu_struct_efi_ux_capsule_header_get_mode: (skip):
 **/
guint32
fu_struct_efi_ux_capsule_header_get_mode(const FuStructEfiUxCapsuleHeader *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->buf->data + 4, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_efi_ux_capsule_header_get_x_offset: (skip):
 **/
guint32
fu_struct_efi_ux_capsule_header_get_x_offset(const FuStructEfiUxCapsuleHeader *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->buf->data + 8, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_efi_ux_capsule_header_get_y_offset: (skip):
 **/
guint32
fu_struct_efi_ux_capsule_header_get_y_offset(const FuStructEfiUxCapsuleHeader *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->buf->data + 12, G_LITTLE_ENDIAN);
}

/* setters */
/**
 * fu_struct_efi_ux_capsule_header_set_version: (skip):
 **/
static void
fu_struct_efi_ux_capsule_header_set_version(FuStructEfiUxCapsuleHeader *st, guint8 value)
{
    g_return_if_fail(st != NULL);
    st->buf->data[0] = value;
}
/**
 * fu_struct_efi_ux_capsule_header_set_checksum: (skip):
 **/
void
fu_struct_efi_ux_capsule_header_set_checksum(FuStructEfiUxCapsuleHeader *st, guint8 value)
{
    g_return_if_fail(st != NULL);
    st->buf->data[1] = value;
}
/**
 * fu_struct_efi_ux_capsule_header_set_image_type: (skip):
 **/
void
fu_struct_efi_ux_capsule_header_set_image_type(FuStructEfiUxCapsuleHeader *st, guint8 value)
{
    g_return_if_fail(st != NULL);
    st->buf->data[2] = value;
}
/**
 * fu_struct_efi_ux_capsule_header_set_mode: (skip):
 **/
void
fu_struct_efi_ux_capsule_header_set_mode(FuStructEfiUxCapsuleHeader *st, guint32 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint32(st->buf->data + 4, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_efi_ux_capsule_header_set_x_offset: (skip):
 **/
void
fu_struct_efi_ux_capsule_header_set_x_offset(FuStructEfiUxCapsuleHeader *st, guint32 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint32(st->buf->data + 8, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_efi_ux_capsule_header_set_y_offset: (skip):
 **/
void
fu_struct_efi_ux_capsule_header_set_y_offset(FuStructEfiUxCapsuleHeader *st, guint32 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint32(st->buf->data + 12, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_efi_ux_capsule_header_new: (skip):
 **/
FuStructEfiUxCapsuleHeader *
fu_struct_efi_ux_capsule_header_new(void)
{
    FuStructEfiUxCapsuleHeader *st = fu_struct_efi_ux_capsule_header_new_internal();
    st->buf = g_byte_array_sized_new(16);
    fu_byte_array_set_size(st->buf, 16, 0x0);
    fu_struct_efi_ux_capsule_header_set_version(st, 0x01);
    return st;
}
/**
 * fu_struct_efi_capsule_header_ref: (skip):
 **/
FuStructEfiCapsuleHeader *
fu_struct_efi_capsule_header_ref(FuStructEfiCapsuleHeader *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    st->refcount++;
    return st;
}
/**
 * fu_struct_efi_capsule_header_unref: (skip):
 **/
void
fu_struct_efi_capsule_header_unref(FuStructEfiCapsuleHeader *st)
{
    g_return_if_fail(st != NULL);
    if (st->refcount == 0) {
        g_critical("FuStructEfiCapsuleHeader refcount already zero");
        return;
    }
    if (--st->refcount > 0)
        return;
    if (st->buf != NULL)
        g_byte_array_unref(st->buf);
    g_free(st);
}
/**
 * fu_struct_efi_capsule_header_new_internal: (skip):
 **/
static FuStructEfiCapsuleHeader *
fu_struct_efi_capsule_header_new_internal(void)
{
    FuStructEfiCapsuleHeader *st = g_new0(FuStructEfiCapsuleHeader, 1);
    st->refcount = 1;
    return st;
}

/* getters */
/**
 * fu_struct_efi_capsule_header_get_guid: (skip):
 **/
const fwupd_guid_t *
fu_struct_efi_capsule_header_get_guid(const FuStructEfiCapsuleHeader *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    return (const fwupd_guid_t *) (st->buf->data + 0);
}
/**
 * fu_struct_efi_capsule_header_get_header_size: (skip):
 **/
guint32
fu_struct_efi_capsule_header_get_header_size(const FuStructEfiCapsuleHeader *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->buf->data + 16, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_efi_capsule_header_get_flags: (skip):
 **/
guint32
fu_struct_efi_capsule_header_get_flags(const FuStructEfiCapsuleHeader *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->buf->data + 20, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_efi_capsule_header_get_image_size: (skip):
 **/
guint32
fu_struct_efi_capsule_header_get_image_size(const FuStructEfiCapsuleHeader *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->buf->data + 24, G_LITTLE_ENDIAN);
}

/* setters */
/**
 * fu_struct_efi_capsule_header_set_guid: (skip):
 **/
void
fu_struct_efi_capsule_header_set_guid(FuStructEfiCapsuleHeader *st, const fwupd_guid_t *value)
{
    g_return_if_fail(st != NULL);
    g_return_if_fail(value != NULL);
    memcpy(st->buf->data + 0, value, sizeof(*value)); /* nocheck:blocked */
}
/**
 * fu_struct_efi_capsule_header_set_header_size: (skip):
 **/
void
fu_struct_efi_capsule_header_set_header_size(FuStructEfiCapsuleHeader *st, guint32 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint32(st->buf->data + 16, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_efi_capsule_header_set_flags: (skip):
 **/
void
fu_struct_efi_capsule_header_set_flags(FuStructEfiCapsuleHeader *st, guint32 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint32(st->buf->data + 20, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_efi_capsule_header_set_image_size: (skip):
 **/
void
fu_struct_efi_capsule_header_set_image_size(FuStructEfiCapsuleHeader *st, guint32 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint32(st->buf->data + 24, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_efi_capsule_header_new: (skip):
 **/
FuStructEfiCapsuleHeader *
fu_struct_efi_capsule_header_new(void)
{
    FuStructEfiCapsuleHeader *st = fu_struct_efi_capsule_header_new_internal();
    st->buf = g_byte_array_sized_new(28);
    fu_byte_array_set_size(st->buf, 28, 0x0);
    fu_struct_efi_capsule_header_set_header_size(st, 28);
    return st;
}
/**
 * fu_struct_efi_capsule_header_to_bytes: (skip):
 **/
GBytes *
fu_struct_efi_capsule_header_to_bytes(const FuStructEfiCapsuleHeader *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    return g_bytes_new(st->buf->data, st->buf->len);
}
/**
 * fu_struct_efi_update_info_ref: (skip):
 **/
FuStructEfiUpdateInfo *
fu_struct_efi_update_info_ref(FuStructEfiUpdateInfo *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    st->refcount++;
    return st;
}
/**
 * fu_struct_efi_update_info_unref: (skip):
 **/
void
fu_struct_efi_update_info_unref(FuStructEfiUpdateInfo *st)
{
    g_return_if_fail(st != NULL);
    if (st->refcount == 0) {
        g_critical("FuStructEfiUpdateInfo refcount already zero");
        return;
    }
    if (--st->refcount > 0)
        return;
    if (st->buf != NULL)
        g_byte_array_unref(st->buf);
    g_free(st);
}
/**
 * fu_struct_efi_update_info_new_internal: (skip):
 **/
static FuStructEfiUpdateInfo *
fu_struct_efi_update_info_new_internal(void)
{
    FuStructEfiUpdateInfo *st = g_new0(FuStructEfiUpdateInfo, 1);
    st->refcount = 1;
    return st;
}

/* getters */
/**
 * fu_struct_efi_update_info_get_version: (skip):
 **/
guint32
fu_struct_efi_update_info_get_version(const FuStructEfiUpdateInfo *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->buf->data + 0, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_efi_update_info_get_guid: (skip):
 **/
const fwupd_guid_t *
fu_struct_efi_update_info_get_guid(const FuStructEfiUpdateInfo *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    return (const fwupd_guid_t *) (st->buf->data + 4);
}
/**
 * fu_struct_efi_update_info_get_flags: (skip):
 **/
guint32
fu_struct_efi_update_info_get_flags(const FuStructEfiUpdateInfo *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->buf->data + 20, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_efi_update_info_get_hw_inst: (skip):
 **/
guint64
fu_struct_efi_update_info_get_hw_inst(const FuStructEfiUpdateInfo *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint64(st->buf->data + 24, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_efi_update_info_get_time_attempted: (skip):
 **/
FuStructEfiTime *
fu_struct_efi_update_info_get_time_attempted(const FuStructEfiUpdateInfo *st)
{
    g_autoptr(FuStructEfiTime) st_tmp = fu_struct_efi_time_new_internal();
    g_return_val_if_fail(st != NULL, NULL);
    st_tmp->buf = g_byte_array_new();
    g_byte_array_append(st_tmp->buf, st->buf->data + FU_STRUCT_EFI_UPDATE_INFO_OFFSET_TIME_ATTEMPTED, 16);
    return g_steal_pointer(&st_tmp);
}
/**
 * fu_struct_efi_update_info_get_status: (skip):
 **/
FuUefiUpdateInfoStatus
fu_struct_efi_update_info_get_status(const FuStructEfiUpdateInfo *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->buf->data + 48, G_LITTLE_ENDIAN);
}

/* setters */
/**
 * fu_struct_efi_update_info_set_version: (skip):
 **/
void
fu_struct_efi_update_info_set_version(FuStructEfiUpdateInfo *st, guint32 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint32(st->buf->data + 0, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_efi_update_info_set_guid: (skip):
 **/
void
fu_struct_efi_update_info_set_guid(FuStructEfiUpdateInfo *st, const fwupd_guid_t *value)
{
    g_return_if_fail(st != NULL);
    g_return_if_fail(value != NULL);
    memcpy(st->buf->data + 4, value, sizeof(*value)); /* nocheck:blocked */
}
/**
 * fu_struct_efi_update_info_set_flags: (skip):
 **/
void
fu_struct_efi_update_info_set_flags(FuStructEfiUpdateInfo *st, guint32 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint32(st->buf->data + 20, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_efi_update_info_set_hw_inst: (skip):
 **/
void
fu_struct_efi_update_info_set_hw_inst(FuStructEfiUpdateInfo *st, guint64 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint64(st->buf->data + 24, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_efi_update_info_set_time_attempted: (skip):
 **/
gboolean
fu_struct_efi_update_info_set_time_attempted(FuStructEfiUpdateInfo *st, const FuStructEfiTime *st_donor, GError **error)
{
    g_return_val_if_fail(st != NULL, FALSE);
    g_return_val_if_fail(st_donor != NULL, FALSE);
    g_return_val_if_fail(error == NULL || *error == NULL, FALSE);

    if (st_donor->buf->len > FU_STRUCT_EFI_TIME_SIZE) {
        g_set_error(error,
                    FWUPD_ERROR,
                    FWUPD_ERROR_INVALID_DATA,
                    "donor 'FuStructEfiTime' (0x%x bytes) does not fit in "
                    "FuStructEfiUpdateInfo.time_attempted (0x%x bytes)",
                    (guint) st_donor->buf->len,
                    (guint) FU_STRUCT_EFI_TIME_SIZE);
        return FALSE;
    }
    memcpy(st->buf->data + FU_STRUCT_EFI_UPDATE_INFO_OFFSET_TIME_ATTEMPTED, st_donor->buf->data, st_donor->buf->len);
    return TRUE;
}
/**
 * fu_struct_efi_update_info_set_status: (skip):
 **/
void
fu_struct_efi_update_info_set_status(FuStructEfiUpdateInfo *st, FuUefiUpdateInfoStatus value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint32(st->buf->data + 48, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_efi_update_info_new: (skip):
 **/
FuStructEfiUpdateInfo *
fu_struct_efi_update_info_new(void)
{
    FuStructEfiUpdateInfo *st = fu_struct_efi_update_info_new_internal();
    st->buf = g_byte_array_sized_new(52);
    fu_byte_array_set_size(st->buf, 52, 0x0);
    {
        g_autoptr(FuStructEfiTime) st_donor = fu_struct_efi_time_new();
        memcpy(st->buf->data + 0x20, st_donor->buf->data, st_donor->buf->len); /* nocheck:blocked */
    }
    fu_struct_efi_update_info_set_version(st, 0x7);
    return st;
}
/**
 * fu_struct_efi_update_info_to_string: (skip):
 **/
static gchar *
fu_struct_efi_update_info_to_string(const FuStructEfiUpdateInfo *st)
{
    g_autoptr(GString) str = g_string_new("FuStructEfiUpdateInfo:\n");
    g_return_val_if_fail(st != NULL, NULL);
    g_string_append_printf(str, "  version: 0x%x\n",
                           (guint) fu_struct_efi_update_info_get_version(st));
    {
        g_autofree gchar *tmp = fwupd_guid_to_string(fu_struct_efi_update_info_get_guid(st), FWUPD_GUID_FLAG_MIXED_ENDIAN);
        g_string_append_printf(str, "  guid: %s\n", tmp);
    }
    g_string_append_printf(str, "  flags: 0x%x\n",
                           (guint) fu_struct_efi_update_info_get_flags(st));
    g_string_append_printf(str, "  hw_inst: 0x%x\n",
                           (guint) fu_struct_efi_update_info_get_hw_inst(st));
    {
        g_autoptr(FuStructEfiTime) st_tmp = fu_struct_efi_update_info_get_time_attempted(st);
        g_autofree gchar *tmp = fu_struct_efi_time_to_string(st_tmp);
        g_string_append_printf(str, "  time_attempted: %s\n", tmp);
    }
    {
        const gchar *tmp = fu_uefi_update_info_status_to_string(fu_struct_efi_update_info_get_status(st));
        if (tmp != NULL) {
            g_string_append_printf(str, "  status: 0x%x [%s]\n", (guint) fu_struct_efi_update_info_get_status(st), tmp);
        } else {
            g_string_append_printf(str, "  status: 0x%x\n", (guint) fu_struct_efi_update_info_get_status(st));
        }
    }
    if (str->len > 0)
        g_string_set_size(str, str->len - 1);
    return g_string_free(g_steal_pointer(&str), FALSE);
}
static gboolean
fu_struct_efi_update_info_validate_internal(FuStructEfiUpdateInfo *st, GError **error)
{
    g_return_val_if_fail(st != NULL, FALSE);
    {
        GByteArray buf_tmp = {
            .data = (guint8*) st->buf->data + 0x20,
            .len = 16,
        };
        FuStructEfiTime st_tmp = { .buf = &buf_tmp };
        if (!fu_struct_efi_time_validate_internal(&st_tmp, error))
            return FALSE;
    }
    return TRUE;
}
static gboolean
fu_struct_efi_update_info_parse_internal(FuStructEfiUpdateInfo *st, GError **error)
{
    if (g_getenv("FWUPD_VERBOSE") != NULL) {
        g_autofree gchar *str = fu_struct_efi_update_info_to_string(st);
        g_debug("%s", str);
    }
    if (!fu_struct_efi_update_info_validate_internal(st, error))
        return FALSE;
    return TRUE;
}

/**
 * fu_struct_efi_update_info_parse: (skip):
 **/
FuStructEfiUpdateInfo *
fu_struct_efi_update_info_parse(const guint8 *buf, gsize bufsz, gsize offset, GError **error)
{
    g_autoptr(FuStructEfiUpdateInfo) st = fu_struct_efi_update_info_new_internal();
    g_return_val_if_fail(buf != NULL, NULL);
    g_return_val_if_fail(error == NULL || *error == NULL, NULL);
    if (!fu_memchk_read(bufsz, offset, 52, error)) {
        g_prefix_error_literal(error, "invalid struct FuStructEfiUpdateInfo: ");
        return NULL;
    }
    st->buf = g_byte_array_new();
    g_byte_array_append(st->buf, buf + offset, 52);
    if (!fu_struct_efi_update_info_parse_internal(st, error))
        return NULL;
    return g_steal_pointer(&st);
}
/**
 * fu_struct_efi_update_info_parse_stream: (skip):
 **/
FuStructEfiUpdateInfo *
fu_struct_efi_update_info_parse_stream(GInputStream *stream, gsize offset, GError **error)
{
    g_autoptr(FuStructEfiUpdateInfo) st = fu_struct_efi_update_info_new_internal();
    st->buf = fu_input_stream_read_byte_array(stream, offset, 52, NULL, error);
    if (st->buf == NULL) {
        g_prefix_error(error, "FuStructEfiUpdateInfo failed read of 0x%x: ", (guint) 52);
        return NULL;
    }
    if (st->buf->len != 52) {
        g_set_error(error,
                    FWUPD_ERROR,
                    FWUPD_ERROR_INVALID_DATA,
                    "FuStructEfiUpdateInfo requested 0x%x and got 0x%x",
                    (guint) 52,
                    (guint) st->buf->len);
        return NULL;
    }
    if (!fu_struct_efi_update_info_parse_internal(st, error))
        return NULL;
    return g_steal_pointer(&st);
}
/**
 * fu_struct_efi_capsule_result_variable_header_ref: (skip):
 **/
FuStructEfiCapsuleResultVariableHeader *
fu_struct_efi_capsule_result_variable_header_ref(FuStructEfiCapsuleResultVariableHeader *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    st->refcount++;
    return st;
}
/**
 * fu_struct_efi_capsule_result_variable_header_unref: (skip):
 **/
void
fu_struct_efi_capsule_result_variable_header_unref(FuStructEfiCapsuleResultVariableHeader *st)
{
    g_return_if_fail(st != NULL);
    if (st->refcount == 0) {
        g_critical("FuStructEfiCapsuleResultVariableHeader refcount already zero");
        return;
    }
    if (--st->refcount > 0)
        return;
    if (st->buf != NULL)
        g_byte_array_unref(st->buf);
    g_free(st);
}
/**
 * fu_struct_efi_capsule_result_variable_header_new_internal: (skip):
 **/
static FuStructEfiCapsuleResultVariableHeader *
fu_struct_efi_capsule_result_variable_header_new_internal(void)
{
    FuStructEfiCapsuleResultVariableHeader *st = g_new0(FuStructEfiCapsuleResultVariableHeader, 1);
    st->refcount = 1;
    return st;
}

/* getters */
/**
 * fu_struct_efi_capsule_result_variable_header_get_total_size: (skip):
 **/
guint32
fu_struct_efi_capsule_result_variable_header_get_total_size(const FuStructEfiCapsuleResultVariableHeader *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->buf->data + 0, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_efi_capsule_result_variable_header_get_guid: (skip):
 **/
const fwupd_guid_t *
fu_struct_efi_capsule_result_variable_header_get_guid(const FuStructEfiCapsuleResultVariableHeader *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    return (const fwupd_guid_t *) (st->buf->data + 8);
}
/**
 * fu_struct_efi_capsule_result_variable_header_get_processed: (skip):
 **/
FuStructEfiTime *
fu_struct_efi_capsule_result_variable_header_get_processed(const FuStructEfiCapsuleResultVariableHeader *st)
{
    g_autoptr(FuStructEfiTime) st_tmp = fu_struct_efi_time_new_internal();
    g_return_val_if_fail(st != NULL, NULL);
    st_tmp->buf = g_byte_array_new();
    g_byte_array_append(st_tmp->buf, st->buf->data + FU_STRUCT_EFI_CAPSULE_RESULT_VARIABLE_HEADER_OFFSET_PROCESSED, 16);
    return g_steal_pointer(&st_tmp);
}
/**
 * fu_struct_efi_capsule_result_variable_header_get_status: (skip):
 **/
FuEfiStatus
fu_struct_efi_capsule_result_variable_header_get_status(const FuStructEfiCapsuleResultVariableHeader *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint64(st->buf->data + 40, G_LITTLE_ENDIAN);
}

/* setters */
/**
 * fu_struct_efi_capsule_result_variable_header_set_total_size: (skip):
 **/
void
fu_struct_efi_capsule_result_variable_header_set_total_size(FuStructEfiCapsuleResultVariableHeader *st, guint32 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint32(st->buf->data + 0, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_efi_capsule_result_variable_header_set_guid: (skip):
 **/
void
fu_struct_efi_capsule_result_variable_header_set_guid(FuStructEfiCapsuleResultVariableHeader *st, const fwupd_guid_t *value)
{
    g_return_if_fail(st != NULL);
    g_return_if_fail(value != NULL);
    memcpy(st->buf->data + 8, value, sizeof(*value)); /* nocheck:blocked */
}
/**
 * fu_struct_efi_capsule_result_variable_header_set_processed: (skip):
 **/
gboolean
fu_struct_efi_capsule_result_variable_header_set_processed(FuStructEfiCapsuleResultVariableHeader *st, const FuStructEfiTime *st_donor, GError **error)
{
    g_return_val_if_fail(st != NULL, FALSE);
    g_return_val_if_fail(st_donor != NULL, FALSE);
    g_return_val_if_fail(error == NULL || *error == NULL, FALSE);

    if (st_donor->buf->len > FU_STRUCT_EFI_TIME_SIZE) {
        g_set_error(error,
                    FWUPD_ERROR,
                    FWUPD_ERROR_INVALID_DATA,
                    "donor 'FuStructEfiTime' (0x%x bytes) does not fit in "
                    "FuStructEfiCapsuleResultVariableHeader.processed (0x%x bytes)",
                    (guint) st_donor->buf->len,
                    (guint) FU_STRUCT_EFI_TIME_SIZE);
        return FALSE;
    }
    memcpy(st->buf->data + FU_STRUCT_EFI_CAPSULE_RESULT_VARIABLE_HEADER_OFFSET_PROCESSED, st_donor->buf->data, st_donor->buf->len);
    return TRUE;
}
/**
 * fu_struct_efi_capsule_result_variable_header_set_status: (skip):
 **/
void
fu_struct_efi_capsule_result_variable_header_set_status(FuStructEfiCapsuleResultVariableHeader *st, FuEfiStatus value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint64(st->buf->data + 40, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_efi_capsule_result_variable_header_new: (skip):
 **/
FuStructEfiCapsuleResultVariableHeader *
fu_struct_efi_capsule_result_variable_header_new(void)
{
    FuStructEfiCapsuleResultVariableHeader *st = fu_struct_efi_capsule_result_variable_header_new_internal();
    st->buf = g_byte_array_sized_new(48);
    fu_byte_array_set_size(st->buf, 48, 0x0);
    {
        g_autoptr(FuStructEfiTime) st_donor = fu_struct_efi_time_new();
        memcpy(st->buf->data + 0x18, st_donor->buf->data, st_donor->buf->len); /* nocheck:blocked */
    }
    return st;
}
/**
 * fu_struct_efi_capsule_result_variable_header_to_string: (skip):
 **/
static gchar *
fu_struct_efi_capsule_result_variable_header_to_string(const FuStructEfiCapsuleResultVariableHeader *st)
{
    g_autoptr(GString) str = g_string_new("FuStructEfiCapsuleResultVariableHeader:\n");
    g_return_val_if_fail(st != NULL, NULL);
    g_string_append_printf(str, "  total_size: 0x%x\n",
                           (guint) fu_struct_efi_capsule_result_variable_header_get_total_size(st));
    {
        g_autofree gchar *tmp = fwupd_guid_to_string(fu_struct_efi_capsule_result_variable_header_get_guid(st), FWUPD_GUID_FLAG_MIXED_ENDIAN);
        g_string_append_printf(str, "  guid: %s\n", tmp);
    }
    {
        g_autoptr(FuStructEfiTime) st_tmp = fu_struct_efi_capsule_result_variable_header_get_processed(st);
        g_autofree gchar *tmp = fu_struct_efi_time_to_string(st_tmp);
        g_string_append_printf(str, "  processed: %s\n", tmp);
    }
    {
        const gchar *tmp = fu_efi_status_to_string(fu_struct_efi_capsule_result_variable_header_get_status(st));
        if (tmp != NULL) {
            g_string_append_printf(str, "  status: 0x%x [%s]\n", (guint) fu_struct_efi_capsule_result_variable_header_get_status(st), tmp);
        } else {
            g_string_append_printf(str, "  status: 0x%x\n", (guint) fu_struct_efi_capsule_result_variable_header_get_status(st));
        }
    }
    if (str->len > 0)
        g_string_set_size(str, str->len - 1);
    return g_string_free(g_steal_pointer(&str), FALSE);
}
/**
 * fu_struct_efi_capsule_result_variable_header_to_bytes: (skip):
 **/
GBytes *
fu_struct_efi_capsule_result_variable_header_to_bytes(const FuStructEfiCapsuleResultVariableHeader *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    return g_bytes_new(st->buf->data, st->buf->len);
}
static gboolean
fu_struct_efi_capsule_result_variable_header_validate_internal(FuStructEfiCapsuleResultVariableHeader *st, GError **error)
{
    g_return_val_if_fail(st != NULL, FALSE);
    {
        GByteArray buf_tmp = {
            .data = (guint8*) st->buf->data + 0x18,
            .len = 16,
        };
        FuStructEfiTime st_tmp = { .buf = &buf_tmp };
        if (!fu_struct_efi_time_validate_internal(&st_tmp, error))
            return FALSE;
    }
    return TRUE;
}
static gboolean
fu_struct_efi_capsule_result_variable_header_parse_internal(FuStructEfiCapsuleResultVariableHeader *st, GError **error)
{
    if (g_getenv("FWUPD_VERBOSE") != NULL) {
        g_autofree gchar *str = fu_struct_efi_capsule_result_variable_header_to_string(st);
        g_debug("%s", str);
    }
    if (!fu_struct_efi_capsule_result_variable_header_validate_internal(st, error))
        return FALSE;
    return TRUE;
}

/**
 * fu_struct_efi_capsule_result_variable_header_parse: (skip):
 **/
static FuStructEfiCapsuleResultVariableHeader *
fu_struct_efi_capsule_result_variable_header_parse(const guint8 *buf, gsize bufsz, gsize offset, GError **error)
{
    g_autoptr(FuStructEfiCapsuleResultVariableHeader) st = fu_struct_efi_capsule_result_variable_header_new_internal();
    g_return_val_if_fail(buf != NULL, NULL);
    g_return_val_if_fail(error == NULL || *error == NULL, NULL);
    if (!fu_memchk_read(bufsz, offset, 48, error)) {
        g_prefix_error_literal(error, "invalid struct FuStructEfiCapsuleResultVariableHeader: ");
        return NULL;
    }
    st->buf = g_byte_array_new();
    g_byte_array_append(st->buf, buf + offset, 48);
    if (!fu_struct_efi_capsule_result_variable_header_parse_internal(st, error))
        return NULL;
    return g_steal_pointer(&st);
}
/**
 * fu_struct_efi_capsule_result_variable_header_parse_bytes: (skip):
 **/
FuStructEfiCapsuleResultVariableHeader *
fu_struct_efi_capsule_result_variable_header_parse_bytes(GBytes *blob, gsize offset, GError **error)
{
    gsize bufsz = 0;
    const guint8 *buf = g_bytes_get_data(blob, &bufsz);
    return fu_struct_efi_capsule_result_variable_header_parse(buf, bufsz, offset, error);
}
/**
 * fu_struct_acpi_insyde_quirk_ref: (skip):
 **/
FuStructAcpiInsydeQuirk *
fu_struct_acpi_insyde_quirk_ref(FuStructAcpiInsydeQuirk *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    st->refcount++;
    return st;
}
/**
 * fu_struct_acpi_insyde_quirk_unref: (skip):
 **/
void
fu_struct_acpi_insyde_quirk_unref(FuStructAcpiInsydeQuirk *st)
{
    g_return_if_fail(st != NULL);
    if (st->refcount == 0) {
        g_critical("FuStructAcpiInsydeQuirk refcount already zero");
        return;
    }
    if (--st->refcount > 0)
        return;
    if (st->buf != NULL)
        g_byte_array_unref(st->buf);
    g_free(st);
}
/**
 * fu_struct_acpi_insyde_quirk_new_internal: (skip):
 **/
static FuStructAcpiInsydeQuirk *
fu_struct_acpi_insyde_quirk_new_internal(void)
{
    FuStructAcpiInsydeQuirk *st = g_new0(FuStructAcpiInsydeQuirk, 1);
    st->refcount = 1;
    return st;
}

/* getters */
/**
 * fu_struct_acpi_insyde_quirk_get_signature: (skip):
 **/
gchar *
fu_struct_acpi_insyde_quirk_get_signature(const FuStructAcpiInsydeQuirk *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    return fu_memstrsafe(st->buf->data, st->buf->len, 0, 6, NULL);
}
/**
 * fu_struct_acpi_insyde_quirk_get_size: (skip):
 **/
guint32
fu_struct_acpi_insyde_quirk_get_size(const FuStructAcpiInsydeQuirk *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->buf->data + 6, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_acpi_insyde_quirk_get_flags: (skip):
 **/
guint32
fu_struct_acpi_insyde_quirk_get_flags(const FuStructAcpiInsydeQuirk *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->buf->data + 10, G_LITTLE_ENDIAN);
}

/* setters */
/**
 * fu_struct_acpi_insyde_quirk_to_string: (skip):
 **/
static gchar *
fu_struct_acpi_insyde_quirk_to_string(const FuStructAcpiInsydeQuirk *st)
{
    g_autoptr(GString) str = g_string_new("FuStructAcpiInsydeQuirk:\n");
    g_return_val_if_fail(st != NULL, NULL);
    {
        g_autofree gchar *tmp = fu_struct_acpi_insyde_quirk_get_signature(st);
        if (tmp != NULL)
            g_string_append_printf(str, "  signature: %s\n", tmp);
    }
    g_string_append_printf(str, "  size: 0x%x\n",
                           (guint) fu_struct_acpi_insyde_quirk_get_size(st));
    g_string_append_printf(str, "  flags: 0x%x\n",
                           (guint) fu_struct_acpi_insyde_quirk_get_flags(st));
    if (str->len > 0)
        g_string_set_size(str, str->len - 1);
    return g_string_free(g_steal_pointer(&str), FALSE);
}
static gboolean
fu_struct_acpi_insyde_quirk_validate_internal(FuStructAcpiInsydeQuirk *st, GError **error)
{
    g_return_val_if_fail(st != NULL, FALSE);
    return TRUE;
}
static gboolean
fu_struct_acpi_insyde_quirk_parse_internal(FuStructAcpiInsydeQuirk *st, GError **error)
{
    if (g_getenv("FWUPD_VERBOSE") != NULL) {
        g_autofree gchar *str = fu_struct_acpi_insyde_quirk_to_string(st);
        g_debug("%s", str);
    }
    if (!fu_struct_acpi_insyde_quirk_validate_internal(st, error))
        return FALSE;
    return TRUE;
}
/**
 * fu_struct_acpi_insyde_quirk_parse_stream: (skip):
 **/
FuStructAcpiInsydeQuirk *
fu_struct_acpi_insyde_quirk_parse_stream(GInputStream *stream, gsize offset, GError **error)
{
    g_autoptr(FuStructAcpiInsydeQuirk) st = fu_struct_acpi_insyde_quirk_new_internal();
    st->buf = fu_input_stream_read_byte_array(stream, offset, 14, NULL, error);
    if (st->buf == NULL) {
        g_prefix_error(error, "FuStructAcpiInsydeQuirk failed read of 0x%x: ", (guint) 14);
        return NULL;
    }
    if (st->buf->len != 14) {
        g_set_error(error,
                    FWUPD_ERROR,
                    FWUPD_ERROR_INVALID_DATA,
                    "FuStructAcpiInsydeQuirk requested 0x%x and got 0x%x",
                    (guint) 14,
                    (guint) st->buf->len);
        return NULL;
    }
    if (!fu_struct_acpi_insyde_quirk_parse_internal(st, error))
        return NULL;
    return g_steal_pointer(&st);
}
/**
 * fu_struct_bitmap_file_header_ref: (skip):
 **/
FuStructBitmapFileHeader *
fu_struct_bitmap_file_header_ref(FuStructBitmapFileHeader *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    st->refcount++;
    return st;
}
/**
 * fu_struct_bitmap_file_header_unref: (skip):
 **/
void
fu_struct_bitmap_file_header_unref(FuStructBitmapFileHeader *st)
{
    g_return_if_fail(st != NULL);
    if (st->refcount == 0) {
        g_critical("FuStructBitmapFileHeader refcount already zero");
        return;
    }
    if (--st->refcount > 0)
        return;
    if (st->buf != NULL)
        g_byte_array_unref(st->buf);
    g_free(st);
}
/**
 * fu_struct_bitmap_file_header_new_internal: (skip):
 **/
static FuStructBitmapFileHeader *
fu_struct_bitmap_file_header_new_internal(void)
{
    FuStructBitmapFileHeader *st = g_new0(FuStructBitmapFileHeader, 1);
    st->refcount = 1;
    return st;
}

/* getters */
/**
 * fu_struct_bitmap_file_header_get_signature: (skip):
 **/
static gchar *
fu_struct_bitmap_file_header_get_signature(const FuStructBitmapFileHeader *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    return fu_memstrsafe(st->buf->data, st->buf->len, 0, 2, NULL);
}
/**
 * fu_struct_bitmap_file_header_get_size: (skip):
 **/
guint32
fu_struct_bitmap_file_header_get_size(const FuStructBitmapFileHeader *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->buf->data + 2, G_LITTLE_ENDIAN);
}

/* setters */
/**
 * fu_struct_bitmap_file_header_to_string: (skip):
 **/
static gchar *
fu_struct_bitmap_file_header_to_string(const FuStructBitmapFileHeader *st)
{
    g_autoptr(GString) str = g_string_new("FuStructBitmapFileHeader:\n");
    g_return_val_if_fail(st != NULL, NULL);
    g_string_append_printf(str, "  size: 0x%x\n",
                           (guint) fu_struct_bitmap_file_header_get_size(st));
    if (str->len > 0)
        g_string_set_size(str, str->len - 1);
    return g_string_free(g_steal_pointer(&str), FALSE);
}
static gboolean
fu_struct_bitmap_file_header_validate_internal(FuStructBitmapFileHeader *st, GError **error)
{
    g_return_val_if_fail(st != NULL, FALSE);
    if (strncmp((const gchar *) (st->buf->data + 0), "BM", 2) != 0) {
        g_autofree gchar *str = fu_struct_bitmap_file_header_get_signature(st);
        g_set_error(error,
                    FWUPD_ERROR,
                    FWUPD_ERROR_INVALID_DATA,
                    "constant FuStructBitmapFileHeader.signature was not valid, "
                    "expected 'BM' and got '%s'",
                    str);
        return FALSE;
    }
    return TRUE;
}
static gboolean
fu_struct_bitmap_file_header_parse_internal(FuStructBitmapFileHeader *st, GError **error)
{
    if (g_getenv("FWUPD_VERBOSE") != NULL) {
        g_autofree gchar *str = fu_struct_bitmap_file_header_to_string(st);
        g_debug("%s", str);
    }
    if (!fu_struct_bitmap_file_header_validate_internal(st, error))
        return FALSE;
    return TRUE;
}
/**
 * fu_struct_bitmap_file_header_parse_stream: (skip):
 **/
FuStructBitmapFileHeader *
fu_struct_bitmap_file_header_parse_stream(GInputStream *stream, gsize offset, GError **error)
{
    g_autoptr(FuStructBitmapFileHeader) st = fu_struct_bitmap_file_header_new_internal();
    st->buf = fu_input_stream_read_byte_array(stream, offset, 14, NULL, error);
    if (st->buf == NULL) {
        g_prefix_error(error, "FuStructBitmapFileHeader failed read of 0x%x: ", (guint) 14);
        return NULL;
    }
    if (st->buf->len != 14) {
        g_set_error(error,
                    FWUPD_ERROR,
                    FWUPD_ERROR_INVALID_DATA,
                    "FuStructBitmapFileHeader requested 0x%x and got 0x%x",
                    (guint) 14,
                    (guint) st->buf->len);
        return NULL;
    }
    if (!fu_struct_bitmap_file_header_parse_internal(st, error))
        return NULL;
    return g_steal_pointer(&st);
}
/**
 * fu_struct_bitmap_info_header_ref: (skip):
 **/
FuStructBitmapInfoHeader *
fu_struct_bitmap_info_header_ref(FuStructBitmapInfoHeader *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    st->refcount++;
    return st;
}
/**
 * fu_struct_bitmap_info_header_unref: (skip):
 **/
void
fu_struct_bitmap_info_header_unref(FuStructBitmapInfoHeader *st)
{
    g_return_if_fail(st != NULL);
    if (st->refcount == 0) {
        g_critical("FuStructBitmapInfoHeader refcount already zero");
        return;
    }
    if (--st->refcount > 0)
        return;
    if (st->buf != NULL)
        g_byte_array_unref(st->buf);
    g_free(st);
}
/**
 * fu_struct_bitmap_info_header_new_internal: (skip):
 **/
static FuStructBitmapInfoHeader *
fu_struct_bitmap_info_header_new_internal(void)
{
    FuStructBitmapInfoHeader *st = g_new0(FuStructBitmapInfoHeader, 1);
    st->refcount = 1;
    return st;
}

/* getters */
/**
 * fu_struct_bitmap_info_header_get_width: (skip):
 **/
guint32
fu_struct_bitmap_info_header_get_width(const FuStructBitmapInfoHeader *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->buf->data + 4, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_bitmap_info_header_get_height: (skip):
 **/
guint32
fu_struct_bitmap_info_header_get_height(const FuStructBitmapInfoHeader *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->buf->data + 8, G_LITTLE_ENDIAN);
}

/* setters */
/**
 * fu_struct_bitmap_info_header_to_string: (skip):
 **/
static gchar *
fu_struct_bitmap_info_header_to_string(const FuStructBitmapInfoHeader *st)
{
    g_autoptr(GString) str = g_string_new("FuStructBitmapInfoHeader:\n");
    g_return_val_if_fail(st != NULL, NULL);
    g_string_append_printf(str, "  width: 0x%x\n",
                           (guint) fu_struct_bitmap_info_header_get_width(st));
    g_string_append_printf(str, "  height: 0x%x\n",
                           (guint) fu_struct_bitmap_info_header_get_height(st));
    if (str->len > 0)
        g_string_set_size(str, str->len - 1);
    return g_string_free(g_steal_pointer(&str), FALSE);
}
static gboolean
fu_struct_bitmap_info_header_validate_internal(FuStructBitmapInfoHeader *st, GError **error)
{
    g_return_val_if_fail(st != NULL, FALSE);
    return TRUE;
}
static gboolean
fu_struct_bitmap_info_header_parse_internal(FuStructBitmapInfoHeader *st, GError **error)
{
    if (g_getenv("FWUPD_VERBOSE") != NULL) {
        g_autofree gchar *str = fu_struct_bitmap_info_header_to_string(st);
        g_debug("%s", str);
    }
    if (!fu_struct_bitmap_info_header_validate_internal(st, error))
        return FALSE;
    return TRUE;
}
/**
 * fu_struct_bitmap_info_header_parse_stream: (skip):
 **/
FuStructBitmapInfoHeader *
fu_struct_bitmap_info_header_parse_stream(GInputStream *stream, gsize offset, GError **error)
{
    g_autoptr(FuStructBitmapInfoHeader) st = fu_struct_bitmap_info_header_new_internal();
    st->buf = fu_input_stream_read_byte_array(stream, offset, 12, NULL, error);
    if (st->buf == NULL) {
        g_prefix_error(error, "FuStructBitmapInfoHeader failed read of 0x%x: ", (guint) 12);
        return NULL;
    }
    if (st->buf->len != 12) {
        g_set_error(error,
                    FWUPD_ERROR,
                    FWUPD_ERROR_INVALID_DATA,
                    "FuStructBitmapInfoHeader requested 0x%x and got 0x%x",
                    (guint) 12,
                    (guint) st->buf->len);
        return NULL;
    }
    if (!fu_struct_bitmap_info_header_parse_internal(st, error))
        return NULL;
    return g_steal_pointer(&st);
}
