/* auto-generated, do not modify */
#include "config.h"

#include <glib.h>

#include "fu-qc-s5gen2-hid-struct.h"
#include "fu-byte-array.h"
#include "fu-mem-private.h"
#include "fu-string.h"

#ifdef G_LOG_DOMAIN
  #undef G_LOG_DOMAIN
#endif
#define G_LOG_DOMAIN "FuStruct"

/**
 * fu_qc_report_id_to_string:
 * @val: value, e.g. %FU_QC_REPORT_ID_DATA_TRANSFER
 *
 * Converts an enumerated value to a string.
 *
 * Returns: identifier string
 **/
static const gchar *
fu_qc_report_id_to_string(FuQcReportId val)
{
    if (val == FU_QC_REPORT_ID_COMMAND)
        return "command";
    if (val == FU_QC_REPORT_ID_DATA_TRANSFER)
        return "data-transfer";
    if (val == FU_QC_REPORT_ID_RESPONSE)
        return "response";
    return NULL;
}
/**
 * fu_struct_qc_hid_command_ref: (skip):
 **/
FuStructQcHidCommand *
fu_struct_qc_hid_command_ref(FuStructQcHidCommand *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    st->refcount++;
    return st;
}
/**
 * fu_struct_qc_hid_command_unref: (skip):
 **/
void
fu_struct_qc_hid_command_unref(FuStructQcHidCommand *st)
{
    g_return_if_fail(st != NULL);
    if (st->refcount == 0) {
        g_critical("FuStructQcHidCommand refcount already zero");
        return;
    }
    if (--st->refcount > 0)
        return;
    if (st->buf != NULL)
        g_byte_array_unref(st->buf);
    g_free(st);
}
/**
 * fu_struct_qc_hid_command_new_internal: (skip):
 **/
static FuStructQcHidCommand *
fu_struct_qc_hid_command_new_internal(void)
{
    FuStructQcHidCommand *st = g_new0(FuStructQcHidCommand, 1);
    st->refcount = 1;
    return st;
}

/* getters */

/* setters */
/**
 * fu_struct_qc_hid_command_set_report_id: (skip):
 **/
static void
fu_struct_qc_hid_command_set_report_id(FuStructQcHidCommand *st, FuQcReportId value)
{
    g_return_if_fail(st != NULL);
    st->buf->data[0] = value;
}
/**
 * fu_struct_qc_hid_command_set_payload_len: (skip):
 **/
void
fu_struct_qc_hid_command_set_payload_len(FuStructQcHidCommand *st, guint8 value)
{
    g_return_if_fail(st != NULL);
    st->buf->data[1] = value;
}
/**
 * fu_struct_qc_hid_command_set_payload: (skip):
 **/
gboolean
fu_struct_qc_hid_command_set_payload(FuStructQcHidCommand *st, const guint8 *buf, gsize bufsz, GError **error)
{
    g_return_val_if_fail(st != NULL, FALSE);
    g_return_val_if_fail(buf != NULL, FALSE);
    g_return_val_if_fail(error == NULL || *error == NULL, FALSE);
    return fu_memcpy_safe(st->buf->data, st->buf->len, 2, buf, bufsz, 0x0, bufsz, error);
}
/**
 * fu_struct_qc_hid_command_new: (skip):
 **/
FuStructQcHidCommand *
fu_struct_qc_hid_command_new(void)
{
    FuStructQcHidCommand *st = fu_struct_qc_hid_command_new_internal();
    st->buf = g_byte_array_sized_new(63);
    fu_byte_array_set_size(st->buf, 63, 0x0);
    fu_struct_qc_hid_command_set_report_id(st, FU_QC_REPORT_ID_COMMAND);
    return st;
}
/**
 * fu_struct_qc_hid_response_ref: (skip):
 **/
FuStructQcHidResponse *
fu_struct_qc_hid_response_ref(FuStructQcHidResponse *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    st->refcount++;
    return st;
}
/**
 * fu_struct_qc_hid_response_unref: (skip):
 **/
void
fu_struct_qc_hid_response_unref(FuStructQcHidResponse *st)
{
    g_return_if_fail(st != NULL);
    if (st->refcount == 0) {
        g_critical("FuStructQcHidResponse refcount already zero");
        return;
    }
    if (--st->refcount > 0)
        return;
    if (st->buf != NULL)
        g_byte_array_unref(st->buf);
    g_free(st);
}
/**
 * fu_struct_qc_hid_response_new_internal: (skip):
 **/
static FuStructQcHidResponse *
fu_struct_qc_hid_response_new_internal(void)
{
    FuStructQcHidResponse *st = g_new0(FuStructQcHidResponse, 1);
    st->refcount = 1;
    return st;
}

/* getters */
/**
 * fu_struct_qc_hid_response_get_report_id: (skip):
 **/
static FuQcReportId
fu_struct_qc_hid_response_get_report_id(const FuStructQcHidResponse *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[0];
}
/**
 * fu_struct_qc_hid_response_get_payload_len: (skip):
 **/
guint8
fu_struct_qc_hid_response_get_payload_len(const FuStructQcHidResponse *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[1];
}
/**
 * fu_struct_qc_hid_response_get_payload: (skip):
 **/
const guint8 *
fu_struct_qc_hid_response_get_payload(const FuStructQcHidResponse *st, gsize *bufsz)
{
    g_return_val_if_fail(st != NULL, NULL);
    if (bufsz != NULL)
        *bufsz = 11;
    return st->buf->data + 2;
}

/* setters */
/**
 * fu_struct_qc_hid_response_to_string: (skip):
 **/
static gchar *
fu_struct_qc_hid_response_to_string(const FuStructQcHidResponse *st)
{
    g_autoptr(GString) str = g_string_new("FuStructQcHidResponse:\n");
    g_return_val_if_fail(st != NULL, NULL);
    g_string_append_printf(str, "  payload_len: 0x%x\n",
                           (guint) fu_struct_qc_hid_response_get_payload_len(st));
    {
        gsize bufsz = 0;
        const guint8 *buf = fu_struct_qc_hid_response_get_payload(st, &bufsz);
        g_autoptr(GString) tmp = g_string_new(NULL);
        for (gsize i = 0; i < bufsz; i++)
            g_string_append_printf(tmp, "%02X", buf[i]);
        g_string_append_printf(str, "  payload: 0x%s\n", tmp->str);
    }
    if (str->len > 0)
        g_string_set_size(str, str->len - 1);
    return g_string_free(g_steal_pointer(&str), FALSE);
}
static gboolean
fu_struct_qc_hid_response_validate_internal(FuStructQcHidResponse *st, GError **error)
{
    g_return_val_if_fail(st != NULL, FALSE);
    if (fu_struct_qc_hid_response_get_report_id(st) != FU_QC_REPORT_ID_RESPONSE) {
        g_set_error(error,
                    FWUPD_ERROR,
                    FWUPD_ERROR_INVALID_DATA,
                    "constant FuStructQcHidResponse.report_id was not valid, "
                    "expected 'FuQcReportId' and got '%s'",
                    fu_qc_report_id_to_string(fu_struct_qc_hid_response_get_report_id(st)));
        return FALSE;
    }
    return TRUE;
}
static gboolean
fu_struct_qc_hid_response_parse_internal(FuStructQcHidResponse *st, GError **error)
{
    if (g_getenv("FWUPD_VERBOSE") != NULL) {
        g_autofree gchar *str = fu_struct_qc_hid_response_to_string(st);
        g_debug("%s", str);
    }
    if (!fu_struct_qc_hid_response_validate_internal(st, error))
        return FALSE;
    return TRUE;
}

/**
 * fu_struct_qc_hid_response_parse: (skip):
 **/
FuStructQcHidResponse *
fu_struct_qc_hid_response_parse(const guint8 *buf, gsize bufsz, gsize offset, GError **error)
{
    g_autoptr(FuStructQcHidResponse) st = fu_struct_qc_hid_response_new_internal();
    g_return_val_if_fail(buf != NULL, NULL);
    g_return_val_if_fail(error == NULL || *error == NULL, NULL);
    if (!fu_memchk_read(bufsz, offset, 13, error)) {
        g_prefix_error_literal(error, "invalid struct FuStructQcHidResponse: ");
        return NULL;
    }
    st->buf = g_byte_array_new();
    g_byte_array_append(st->buf, buf + offset, 13);
    if (!fu_struct_qc_hid_response_parse_internal(st, error))
        return NULL;
    return g_steal_pointer(&st);
}
/**
 * fu_struct_qc_hid_data_transfer_ref: (skip):
 **/
FuStructQcHidDataTransfer *
fu_struct_qc_hid_data_transfer_ref(FuStructQcHidDataTransfer *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    st->refcount++;
    return st;
}
/**
 * fu_struct_qc_hid_data_transfer_unref: (skip):
 **/
void
fu_struct_qc_hid_data_transfer_unref(FuStructQcHidDataTransfer *st)
{
    g_return_if_fail(st != NULL);
    if (st->refcount == 0) {
        g_critical("FuStructQcHidDataTransfer refcount already zero");
        return;
    }
    if (--st->refcount > 0)
        return;
    if (st->buf != NULL)
        g_byte_array_unref(st->buf);
    g_free(st);
}
/**
 * fu_struct_qc_hid_data_transfer_new_internal: (skip):
 **/
static FuStructQcHidDataTransfer *
fu_struct_qc_hid_data_transfer_new_internal(void)
{
    FuStructQcHidDataTransfer *st = g_new0(FuStructQcHidDataTransfer, 1);
    st->refcount = 1;
    return st;
}

/* getters */

/* setters */
/**
 * fu_struct_qc_hid_data_transfer_set_report_id: (skip):
 **/
static void
fu_struct_qc_hid_data_transfer_set_report_id(FuStructQcHidDataTransfer *st, FuQcReportId value)
{
    g_return_if_fail(st != NULL);
    st->buf->data[0] = value;
}
/**
 * fu_struct_qc_hid_data_transfer_set_payload_len: (skip):
 **/
void
fu_struct_qc_hid_data_transfer_set_payload_len(FuStructQcHidDataTransfer *st, guint8 value)
{
    g_return_if_fail(st != NULL);
    st->buf->data[1] = value;
}
/**
 * fu_struct_qc_hid_data_transfer_set_payload: (skip):
 **/
gboolean
fu_struct_qc_hid_data_transfer_set_payload(FuStructQcHidDataTransfer *st, const guint8 *buf, gsize bufsz, GError **error)
{
    g_return_val_if_fail(st != NULL, FALSE);
    g_return_val_if_fail(buf != NULL, FALSE);
    g_return_val_if_fail(error == NULL || *error == NULL, FALSE);
    return fu_memcpy_safe(st->buf->data, st->buf->len, 2, buf, bufsz, 0x0, bufsz, error);
}
/**
 * fu_struct_qc_hid_data_transfer_new: (skip):
 **/
FuStructQcHidDataTransfer *
fu_struct_qc_hid_data_transfer_new(void)
{
    FuStructQcHidDataTransfer *st = fu_struct_qc_hid_data_transfer_new_internal();
    st->buf = g_byte_array_sized_new(255);
    fu_byte_array_set_size(st->buf, 255, 0x0);
    fu_struct_qc_hid_data_transfer_set_report_id(st, FU_QC_REPORT_ID_DATA_TRANSFER);
    return st;
}
