/* auto-generated, do not modify */
#include "config.h"

#include <glib.h>

#include "fu-elan-kbd-struct.h"
#include "fu-byte-array.h"
#include "fu-mem-private.h"
#include "fu-string.h"

#ifdef G_LOG_DOMAIN
  #undef G_LOG_DOMAIN
#endif
#define G_LOG_DOMAIN "FuStruct"




/**
 * fu_elan_kbd_dev_status_to_string:
 * @val: value, e.g. %FU_ELAN_KBD_DEV_STATUS_IDLE
 *
 * Converts an enumerated value to a string.
 *
 * Returns: identifier string
 **/
const gchar *
fu_elan_kbd_dev_status_to_string(FuElanKbdDevStatus val)
{
    if (val == FU_ELAN_KBD_DEV_STATUS_IDLE)
        return "idle";
    if (val == FU_ELAN_KBD_DEV_STATUS_IAP)
        return "iap";
    if (val == FU_ELAN_KBD_DEV_STATUS_WRITE_ROM)
        return "write-rom";
    if (val == FU_ELAN_KBD_DEV_STATUS_WRITE_OPT)
        return "write-opt";
    if (val == FU_ELAN_KBD_DEV_STATUS_WRITE_CSUM)
        return "write-csum";
    if (val == FU_ELAN_KBD_DEV_STATUS_READ_ROM)
        return "read-rom";
    if (val == FU_ELAN_KBD_DEV_STATUS_READ_OPT)
        return "read-opt";
    return NULL;
}

/**
 * fu_elan_kbd_status_to_string:
 * @val: value, e.g. %FU_ELAN_KBD_STATUS_READY
 *
 * Converts an enumerated value to a string.
 *
 * Returns: identifier string
 **/
static const gchar *
fu_elan_kbd_status_to_string(FuElanKbdStatus val)
{
    if (val == FU_ELAN_KBD_STATUS_READY)
        return "ready";
    if (val == FU_ELAN_KBD_STATUS_BUSY)
        return "busy";
    if (val == FU_ELAN_KBD_STATUS_SUCCESS)
        return "success";
    if (val == FU_ELAN_KBD_STATUS_FAIL)
        return "fail";
    if (val == FU_ELAN_KBD_STATUS_ERROR)
        return "error";
    return NULL;
}

/**
 * fu_elan_kbd_error_to_string:
 * @val: value, e.g. %FU_ELAN_KBD_ERROR_UNKNOWN_COMMAND
 *
 * Converts an enumerated value to a string.
 *
 * Returns: identifier string
 **/
const gchar *
fu_elan_kbd_error_to_string(FuElanKbdError val)
{
    if (val == FU_ELAN_KBD_ERROR_UNKNOWN_COMMAND)
        return "unknown-command";
    if (val == FU_ELAN_KBD_ERROR_COMMAND_STAGE)
        return "command-stage";
    if (val == FU_ELAN_KBD_ERROR_DATA_STAGE)
        return "data-stage";
    if (val == FU_ELAN_KBD_ERROR_ROM_ADDRESS_INVALID)
        return "rom-address-invalid";
    if (val == FU_ELAN_KBD_ERROR_AUTHORITY_KEY_INCORRECT)
        return "authority-key-incorrect";
    if (val == FU_ELAN_KBD_ERROR_WRITE_ROM_NOT_FINISHED)
        return "write-rom-not-finished";
    if (val == FU_ELAN_KBD_ERROR_WRITE_OPTION_NOT_FINISHED)
        return "write-option-not-finished";
    if (val == FU_ELAN_KBD_ERROR_LENGTH_TOO_BIG)
        return "length-too-big";
    if (val == FU_ELAN_KBD_ERROR_LENGTH_TOO_SMALL)
        return "length-too-small";
    if (val == FU_ELAN_KBD_ERROR_CHECKSUM_INCORRECT)
        return "checksum-incorrect";
    if (val == FU_ELAN_KBD_ERROR_WRITE_FLASH_ABNORMAL)
        return "write-flash-abnormal";
    if (val == FU_ELAN_KBD_ERROR_OVER_ROM_AREA)
        return "over-rom-area";
    if (val == FU_ELAN_KBD_ERROR_ROM_PAGE_INVALID)
        return "rom-page-invalid";
    if (val == FU_ELAN_KBD_ERROR_FLASH_KEY_INVALID)
        return "flash-key-invalid";
    if (val == FU_ELAN_KBD_ERROR_OPTION_ROM_ADDRESS_INVALID)
        return "option-rom-address-invalid";
    return NULL;
}

/**
 * fu_elan_kbd_boot_cond1_to_string:
 * @val: value, e.g. %FU_ELAN_KBD_BOOT_COND1_P80_ENTRY
 *
 * Converts an enumerated value to a string.
 *
 * Returns: identifier string
 **/
const gchar *
fu_elan_kbd_boot_cond1_to_string(FuElanKbdBootCond1 val)
{
    if (val == FU_ELAN_KBD_BOOT_COND1_P80_ENTRY)
        return "p80-entry";
    if (val == FU_ELAN_KBD_BOOT_COND1_NO_APP_ENTRY)
        return "no-app-entry";
    if (val == FU_ELAN_KBD_BOOT_COND1_APP_JUMP_ENTRY)
        return "app-jump-entry";
    return NULL;
}

/**
 * fu_struct_elan_kbd_firmware_ref: (skip):
 **/
FuStructElanKbdFirmware *
fu_struct_elan_kbd_firmware_ref(FuStructElanKbdFirmware *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    st->refcount++;
    return st;
}
/**
 * fu_struct_elan_kbd_firmware_unref: (skip):
 **/
void
fu_struct_elan_kbd_firmware_unref(FuStructElanKbdFirmware *st)
{
    g_return_if_fail(st != NULL);
    if (st->refcount == 0) {
        g_critical("FuStructElanKbdFirmware refcount already zero");
        return;
    }
    if (--st->refcount > 0)
        return;
    if (st->buf != NULL)
        g_byte_array_unref(st->buf);
    g_free(st);
}
/**
 * fu_struct_elan_kbd_firmware_new_internal: (skip):
 **/
static FuStructElanKbdFirmware *
fu_struct_elan_kbd_firmware_new_internal(void)
{
    FuStructElanKbdFirmware *st = g_new0(FuStructElanKbdFirmware, 1);
    st->refcount = 1;
    return st;
}

/* getters */
/**
 * fu_struct_elan_kbd_firmware_get_reset_vector: (skip):
 **/
static guint32
fu_struct_elan_kbd_firmware_get_reset_vector(const FuStructElanKbdFirmware *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->buf->data + 0, G_BIG_ENDIAN);
}

/* setters */
static gboolean
fu_struct_elan_kbd_firmware_validate_internal(FuStructElanKbdFirmware *st, GError **error)
{
    g_return_val_if_fail(st != NULL, FALSE);
    if (fu_struct_elan_kbd_firmware_get_reset_vector(st) != 0x21FAFF02) {
        g_set_error(error,
                    FWUPD_ERROR,
                    FWUPD_ERROR_INVALID_DATA,
                    "constant FuStructElanKbdFirmware.reset_vector was not valid, "
                    "expected 0x%x and got 0x%x",
                    (guint) 0x21FAFF02,
                    (guint) fu_struct_elan_kbd_firmware_get_reset_vector(st));
        return FALSE;
    }
    return TRUE;
}
/**
 * fu_struct_elan_kbd_firmware_validate_stream: (skip):
 **/
gboolean
fu_struct_elan_kbd_firmware_validate_stream(GInputStream *stream, gsize offset, GError **error)
{
    g_autoptr(FuStructElanKbdFirmware) st = fu_struct_elan_kbd_firmware_new_internal();
    g_return_val_if_fail(G_IS_INPUT_STREAM(stream), FALSE);
    g_return_val_if_fail(error == NULL || *error == NULL, FALSE);
    st->buf = fu_input_stream_read_byte_array(stream, offset, 4, NULL, error);
    if (st->buf == NULL) {
        g_prefix_error(error, "FuStructElanKbdFirmware failed read of 0x%x: ", (guint) 4);
        return FALSE;
    }
    if (st->buf->len != 4) {
        g_set_error(error,
                    FWUPD_ERROR,
                    FWUPD_ERROR_INVALID_DATA,
                    "FuStructElanKbdFirmware requested 0x%x and got 0x%x",
                    (guint) 4,
                    (guint) st->buf->len);
        return FALSE;
    }
    return fu_struct_elan_kbd_firmware_validate_internal(st, error);
}
/**
 * fu_struct_elan_kbd_get_ver_spec_req_ref: (skip):
 **/
FuStructElanKbdGetVerSpecReq *
fu_struct_elan_kbd_get_ver_spec_req_ref(FuStructElanKbdGetVerSpecReq *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    st->refcount++;
    return st;
}
/**
 * fu_struct_elan_kbd_get_ver_spec_req_unref: (skip):
 **/
void
fu_struct_elan_kbd_get_ver_spec_req_unref(FuStructElanKbdGetVerSpecReq *st)
{
    g_return_if_fail(st != NULL);
    if (st->refcount == 0) {
        g_critical("FuStructElanKbdGetVerSpecReq refcount already zero");
        return;
    }
    if (--st->refcount > 0)
        return;
    if (st->buf != NULL)
        g_byte_array_unref(st->buf);
    g_free(st);
}
/**
 * fu_struct_elan_kbd_get_ver_spec_req_new_internal: (skip):
 **/
static FuStructElanKbdGetVerSpecReq *
fu_struct_elan_kbd_get_ver_spec_req_new_internal(void)
{
    FuStructElanKbdGetVerSpecReq *st = g_new0(FuStructElanKbdGetVerSpecReq, 1);
    st->refcount = 1;
    return st;
}

/* getters */

/* setters */
/**
 * fu_struct_elan_kbd_get_ver_spec_req_set_tag: (skip):
 **/
static void
fu_struct_elan_kbd_get_ver_spec_req_set_tag(FuStructElanKbdGetVerSpecReq *st, guint8 value)
{
    g_return_if_fail(st != NULL);
    st->buf->data[0] = value;
}
/**
 * fu_struct_elan_kbd_get_ver_spec_req_set_cmd: (skip):
 **/
static void
fu_struct_elan_kbd_get_ver_spec_req_set_cmd(FuStructElanKbdGetVerSpecReq *st, FuElanKbdCmd value)
{
    g_return_if_fail(st != NULL);
    st->buf->data[1] = value;
}
/**
 * fu_struct_elan_kbd_get_ver_spec_req_new: (skip):
 **/
FuStructElanKbdGetVerSpecReq *
fu_struct_elan_kbd_get_ver_spec_req_new(void)
{
    FuStructElanKbdGetVerSpecReq *st = fu_struct_elan_kbd_get_ver_spec_req_new_internal();
    st->buf = g_byte_array_sized_new(8);
    fu_byte_array_set_size(st->buf, 8, 0x0);
    fu_struct_elan_kbd_get_ver_spec_req_set_tag(st, 0xC1);
    fu_struct_elan_kbd_get_ver_spec_req_set_cmd(st, FU_ELAN_KBD_CMD_GET_VER_SPEC);
    return st;
}
/**
 * fu_struct_elan_kbd_get_ver_spec_res_ref: (skip):
 **/
FuStructElanKbdGetVerSpecRes *
fu_struct_elan_kbd_get_ver_spec_res_ref(FuStructElanKbdGetVerSpecRes *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    st->refcount++;
    return st;
}
/**
 * fu_struct_elan_kbd_get_ver_spec_res_unref: (skip):
 **/
void
fu_struct_elan_kbd_get_ver_spec_res_unref(FuStructElanKbdGetVerSpecRes *st)
{
    g_return_if_fail(st != NULL);
    if (st->refcount == 0) {
        g_critical("FuStructElanKbdGetVerSpecRes refcount already zero");
        return;
    }
    if (--st->refcount > 0)
        return;
    if (st->buf != NULL)
        g_byte_array_unref(st->buf);
    g_free(st);
}
/**
 * fu_struct_elan_kbd_get_ver_spec_res_new_internal: (skip):
 **/
static FuStructElanKbdGetVerSpecRes *
fu_struct_elan_kbd_get_ver_spec_res_new_internal(void)
{
    FuStructElanKbdGetVerSpecRes *st = g_new0(FuStructElanKbdGetVerSpecRes, 1);
    st->refcount = 1;
    return st;
}

/* getters */
/**
 * fu_struct_elan_kbd_get_ver_spec_res_get_value: (skip):
 **/
guint16
fu_struct_elan_kbd_get_ver_spec_res_get_value(const FuStructElanKbdGetVerSpecRes *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->buf->data + 0, G_BIG_ENDIAN);
}

/* setters */
/**
 * fu_struct_elan_kbd_get_ver_spec_res_to_string: (skip):
 **/
static gchar *
fu_struct_elan_kbd_get_ver_spec_res_to_string(const FuStructElanKbdGetVerSpecRes *st)
{
    g_autoptr(GString) str = g_string_new("FuStructElanKbdGetVerSpecRes:\n");
    g_return_val_if_fail(st != NULL, NULL);
    g_string_append_printf(str, "  value: 0x%x\n",
                           (guint) fu_struct_elan_kbd_get_ver_spec_res_get_value(st));
    if (str->len > 0)
        g_string_set_size(str, str->len - 1);
    return g_string_free(g_steal_pointer(&str), FALSE);
}
static gboolean
fu_struct_elan_kbd_get_ver_spec_res_validate_internal(FuStructElanKbdGetVerSpecRes *st, GError **error)
{
    g_return_val_if_fail(st != NULL, FALSE);
    return TRUE;
}
static gboolean
fu_struct_elan_kbd_get_ver_spec_res_parse_internal(FuStructElanKbdGetVerSpecRes *st, GError **error)
{
    if (g_getenv("FWUPD_VERBOSE") != NULL) {
        g_autofree gchar *str = fu_struct_elan_kbd_get_ver_spec_res_to_string(st);
        g_debug("%s", str);
    }
    if (!fu_struct_elan_kbd_get_ver_spec_res_validate_internal(st, error))
        return FALSE;
    return TRUE;
}

/**
 * fu_struct_elan_kbd_get_ver_spec_res_parse: (skip):
 **/
FuStructElanKbdGetVerSpecRes *
fu_struct_elan_kbd_get_ver_spec_res_parse(const guint8 *buf, gsize bufsz, gsize offset, GError **error)
{
    g_autoptr(FuStructElanKbdGetVerSpecRes) st = fu_struct_elan_kbd_get_ver_spec_res_new_internal();
    g_return_val_if_fail(buf != NULL, NULL);
    g_return_val_if_fail(error == NULL || *error == NULL, NULL);
    if (!fu_memchk_read(bufsz, offset, 2, error)) {
        g_prefix_error_literal(error, "invalid struct FuStructElanKbdGetVerSpecRes: ");
        return NULL;
    }
    st->buf = g_byte_array_new();
    g_byte_array_append(st->buf, buf + offset, 2);
    if (!fu_struct_elan_kbd_get_ver_spec_res_parse_internal(st, error))
        return NULL;
    return g_steal_pointer(&st);
}
/**
 * fu_struct_elan_kbd_get_ver_fw_req_ref: (skip):
 **/
FuStructElanKbdGetVerFwReq *
fu_struct_elan_kbd_get_ver_fw_req_ref(FuStructElanKbdGetVerFwReq *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    st->refcount++;
    return st;
}
/**
 * fu_struct_elan_kbd_get_ver_fw_req_unref: (skip):
 **/
void
fu_struct_elan_kbd_get_ver_fw_req_unref(FuStructElanKbdGetVerFwReq *st)
{
    g_return_if_fail(st != NULL);
    if (st->refcount == 0) {
        g_critical("FuStructElanKbdGetVerFwReq refcount already zero");
        return;
    }
    if (--st->refcount > 0)
        return;
    if (st->buf != NULL)
        g_byte_array_unref(st->buf);
    g_free(st);
}
/**
 * fu_struct_elan_kbd_get_ver_fw_req_new_internal: (skip):
 **/
static FuStructElanKbdGetVerFwReq *
fu_struct_elan_kbd_get_ver_fw_req_new_internal(void)
{
    FuStructElanKbdGetVerFwReq *st = g_new0(FuStructElanKbdGetVerFwReq, 1);
    st->refcount = 1;
    return st;
}

/* getters */

/* setters */
/**
 * fu_struct_elan_kbd_get_ver_fw_req_set_tag: (skip):
 **/
static void
fu_struct_elan_kbd_get_ver_fw_req_set_tag(FuStructElanKbdGetVerFwReq *st, guint8 value)
{
    g_return_if_fail(st != NULL);
    st->buf->data[0] = value;
}
/**
 * fu_struct_elan_kbd_get_ver_fw_req_set_cmd: (skip):
 **/
static void
fu_struct_elan_kbd_get_ver_fw_req_set_cmd(FuStructElanKbdGetVerFwReq *st, FuElanKbdCmd value)
{
    g_return_if_fail(st != NULL);
    st->buf->data[1] = value;
}
/**
 * fu_struct_elan_kbd_get_ver_fw_req_new: (skip):
 **/
FuStructElanKbdGetVerFwReq *
fu_struct_elan_kbd_get_ver_fw_req_new(void)
{
    FuStructElanKbdGetVerFwReq *st = fu_struct_elan_kbd_get_ver_fw_req_new_internal();
    st->buf = g_byte_array_sized_new(8);
    fu_byte_array_set_size(st->buf, 8, 0x0);
    fu_struct_elan_kbd_get_ver_fw_req_set_tag(st, 0xC1);
    fu_struct_elan_kbd_get_ver_fw_req_set_cmd(st, FU_ELAN_KBD_CMD_GET_VER_FW);
    return st;
}
/**
 * fu_struct_elan_kbd_get_ver_fw_res_ref: (skip):
 **/
FuStructElanKbdGetVerFwRes *
fu_struct_elan_kbd_get_ver_fw_res_ref(FuStructElanKbdGetVerFwRes *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    st->refcount++;
    return st;
}
/**
 * fu_struct_elan_kbd_get_ver_fw_res_unref: (skip):
 **/
void
fu_struct_elan_kbd_get_ver_fw_res_unref(FuStructElanKbdGetVerFwRes *st)
{
    g_return_if_fail(st != NULL);
    if (st->refcount == 0) {
        g_critical("FuStructElanKbdGetVerFwRes refcount already zero");
        return;
    }
    if (--st->refcount > 0)
        return;
    if (st->buf != NULL)
        g_byte_array_unref(st->buf);
    g_free(st);
}
/**
 * fu_struct_elan_kbd_get_ver_fw_res_new_internal: (skip):
 **/
static FuStructElanKbdGetVerFwRes *
fu_struct_elan_kbd_get_ver_fw_res_new_internal(void)
{
    FuStructElanKbdGetVerFwRes *st = g_new0(FuStructElanKbdGetVerFwRes, 1);
    st->refcount = 1;
    return st;
}

/* getters */
/**
 * fu_struct_elan_kbd_get_ver_fw_res_get_value: (skip):
 **/
guint16
fu_struct_elan_kbd_get_ver_fw_res_get_value(const FuStructElanKbdGetVerFwRes *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->buf->data + 0, G_BIG_ENDIAN);
}

/* setters */
/**
 * fu_struct_elan_kbd_get_ver_fw_res_to_string: (skip):
 **/
static gchar *
fu_struct_elan_kbd_get_ver_fw_res_to_string(const FuStructElanKbdGetVerFwRes *st)
{
    g_autoptr(GString) str = g_string_new("FuStructElanKbdGetVerFwRes:\n");
    g_return_val_if_fail(st != NULL, NULL);
    g_string_append_printf(str, "  value: 0x%x\n",
                           (guint) fu_struct_elan_kbd_get_ver_fw_res_get_value(st));
    if (str->len > 0)
        g_string_set_size(str, str->len - 1);
    return g_string_free(g_steal_pointer(&str), FALSE);
}
static gboolean
fu_struct_elan_kbd_get_ver_fw_res_validate_internal(FuStructElanKbdGetVerFwRes *st, GError **error)
{
    g_return_val_if_fail(st != NULL, FALSE);
    return TRUE;
}
static gboolean
fu_struct_elan_kbd_get_ver_fw_res_parse_internal(FuStructElanKbdGetVerFwRes *st, GError **error)
{
    if (g_getenv("FWUPD_VERBOSE") != NULL) {
        g_autofree gchar *str = fu_struct_elan_kbd_get_ver_fw_res_to_string(st);
        g_debug("%s", str);
    }
    if (!fu_struct_elan_kbd_get_ver_fw_res_validate_internal(st, error))
        return FALSE;
    return TRUE;
}

/**
 * fu_struct_elan_kbd_get_ver_fw_res_parse: (skip):
 **/
FuStructElanKbdGetVerFwRes *
fu_struct_elan_kbd_get_ver_fw_res_parse(const guint8 *buf, gsize bufsz, gsize offset, GError **error)
{
    g_autoptr(FuStructElanKbdGetVerFwRes) st = fu_struct_elan_kbd_get_ver_fw_res_new_internal();
    g_return_val_if_fail(buf != NULL, NULL);
    g_return_val_if_fail(error == NULL || *error == NULL, NULL);
    if (!fu_memchk_read(bufsz, offset, 2, error)) {
        g_prefix_error_literal(error, "invalid struct FuStructElanKbdGetVerFwRes: ");
        return NULL;
    }
    st->buf = g_byte_array_new();
    g_byte_array_append(st->buf, buf + offset, 2);
    if (!fu_struct_elan_kbd_get_ver_fw_res_parse_internal(st, error))
        return NULL;
    return g_steal_pointer(&st);
}
/**
 * fu_struct_elan_kbd_get_status_req_ref: (skip):
 **/
FuStructElanKbdGetStatusReq *
fu_struct_elan_kbd_get_status_req_ref(FuStructElanKbdGetStatusReq *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    st->refcount++;
    return st;
}
/**
 * fu_struct_elan_kbd_get_status_req_unref: (skip):
 **/
void
fu_struct_elan_kbd_get_status_req_unref(FuStructElanKbdGetStatusReq *st)
{
    g_return_if_fail(st != NULL);
    if (st->refcount == 0) {
        g_critical("FuStructElanKbdGetStatusReq refcount already zero");
        return;
    }
    if (--st->refcount > 0)
        return;
    if (st->buf != NULL)
        g_byte_array_unref(st->buf);
    g_free(st);
}
/**
 * fu_struct_elan_kbd_get_status_req_new_internal: (skip):
 **/
static FuStructElanKbdGetStatusReq *
fu_struct_elan_kbd_get_status_req_new_internal(void)
{
    FuStructElanKbdGetStatusReq *st = g_new0(FuStructElanKbdGetStatusReq, 1);
    st->refcount = 1;
    return st;
}

/* getters */

/* setters */
/**
 * fu_struct_elan_kbd_get_status_req_set_tag: (skip):
 **/
static void
fu_struct_elan_kbd_get_status_req_set_tag(FuStructElanKbdGetStatusReq *st, guint8 value)
{
    g_return_if_fail(st != NULL);
    st->buf->data[0] = value;
}
/**
 * fu_struct_elan_kbd_get_status_req_set_cmd: (skip):
 **/
static void
fu_struct_elan_kbd_get_status_req_set_cmd(FuStructElanKbdGetStatusReq *st, FuElanKbdCmd value)
{
    g_return_if_fail(st != NULL);
    st->buf->data[1] = value;
}
/**
 * fu_struct_elan_kbd_get_status_req_new: (skip):
 **/
FuStructElanKbdGetStatusReq *
fu_struct_elan_kbd_get_status_req_new(void)
{
    FuStructElanKbdGetStatusReq *st = fu_struct_elan_kbd_get_status_req_new_internal();
    st->buf = g_byte_array_sized_new(8);
    fu_byte_array_set_size(st->buf, 8, 0x0);
    fu_struct_elan_kbd_get_status_req_set_tag(st, 0xC1);
    fu_struct_elan_kbd_get_status_req_set_cmd(st, FU_ELAN_KBD_CMD_GET_STATUS);
    return st;
}
/**
 * fu_struct_elan_kbd_get_status_res_ref: (skip):
 **/
FuStructElanKbdGetStatusRes *
fu_struct_elan_kbd_get_status_res_ref(FuStructElanKbdGetStatusRes *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    st->refcount++;
    return st;
}
/**
 * fu_struct_elan_kbd_get_status_res_unref: (skip):
 **/
void
fu_struct_elan_kbd_get_status_res_unref(FuStructElanKbdGetStatusRes *st)
{
    g_return_if_fail(st != NULL);
    if (st->refcount == 0) {
        g_critical("FuStructElanKbdGetStatusRes refcount already zero");
        return;
    }
    if (--st->refcount > 0)
        return;
    if (st->buf != NULL)
        g_byte_array_unref(st->buf);
    g_free(st);
}
/**
 * fu_struct_elan_kbd_get_status_res_new_internal: (skip):
 **/
static FuStructElanKbdGetStatusRes *
fu_struct_elan_kbd_get_status_res_new_internal(void)
{
    FuStructElanKbdGetStatusRes *st = g_new0(FuStructElanKbdGetStatusRes, 1);
    st->refcount = 1;
    return st;
}

/* getters */
/**
 * fu_struct_elan_kbd_get_status_res_get_value: (skip):
 **/
FuElanKbdDevStatus
fu_struct_elan_kbd_get_status_res_get_value(const FuStructElanKbdGetStatusRes *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[2];
}

/* setters */
/**
 * fu_struct_elan_kbd_get_status_res_to_string: (skip):
 **/
static gchar *
fu_struct_elan_kbd_get_status_res_to_string(const FuStructElanKbdGetStatusRes *st)
{
    g_autoptr(GString) str = g_string_new("FuStructElanKbdGetStatusRes:\n");
    g_return_val_if_fail(st != NULL, NULL);
    {
        const gchar *tmp = fu_elan_kbd_dev_status_to_string(fu_struct_elan_kbd_get_status_res_get_value(st));
        if (tmp != NULL) {
            g_string_append_printf(str, "  value: 0x%x [%s]\n", (guint) fu_struct_elan_kbd_get_status_res_get_value(st), tmp);
        } else {
            g_string_append_printf(str, "  value: 0x%x\n", (guint) fu_struct_elan_kbd_get_status_res_get_value(st));
        }
    }
    if (str->len > 0)
        g_string_set_size(str, str->len - 1);
    return g_string_free(g_steal_pointer(&str), FALSE);
}
static gboolean
fu_struct_elan_kbd_get_status_res_validate_internal(FuStructElanKbdGetStatusRes *st, GError **error)
{
    g_return_val_if_fail(st != NULL, FALSE);
    return TRUE;
}
static gboolean
fu_struct_elan_kbd_get_status_res_parse_internal(FuStructElanKbdGetStatusRes *st, GError **error)
{
    if (g_getenv("FWUPD_VERBOSE") != NULL) {
        g_autofree gchar *str = fu_struct_elan_kbd_get_status_res_to_string(st);
        g_debug("%s", str);
    }
    if (!fu_struct_elan_kbd_get_status_res_validate_internal(st, error))
        return FALSE;
    return TRUE;
}

/**
 * fu_struct_elan_kbd_get_status_res_parse: (skip):
 **/
FuStructElanKbdGetStatusRes *
fu_struct_elan_kbd_get_status_res_parse(const guint8 *buf, gsize bufsz, gsize offset, GError **error)
{
    g_autoptr(FuStructElanKbdGetStatusRes) st = fu_struct_elan_kbd_get_status_res_new_internal();
    g_return_val_if_fail(buf != NULL, NULL);
    g_return_val_if_fail(error == NULL || *error == NULL, NULL);
    if (!fu_memchk_read(bufsz, offset, 3, error)) {
        g_prefix_error_literal(error, "invalid struct FuStructElanKbdGetStatusRes: ");
        return NULL;
    }
    st->buf = g_byte_array_new();
    g_byte_array_append(st->buf, buf + offset, 3);
    if (!fu_struct_elan_kbd_get_status_res_parse_internal(st, error))
        return NULL;
    return g_steal_pointer(&st);
}
/**
 * fu_struct_elan_kbd_boot_condition_req_ref: (skip):
 **/
FuStructElanKbdBootConditionReq *
fu_struct_elan_kbd_boot_condition_req_ref(FuStructElanKbdBootConditionReq *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    st->refcount++;
    return st;
}
/**
 * fu_struct_elan_kbd_boot_condition_req_unref: (skip):
 **/
void
fu_struct_elan_kbd_boot_condition_req_unref(FuStructElanKbdBootConditionReq *st)
{
    g_return_if_fail(st != NULL);
    if (st->refcount == 0) {
        g_critical("FuStructElanKbdBootConditionReq refcount already zero");
        return;
    }
    if (--st->refcount > 0)
        return;
    if (st->buf != NULL)
        g_byte_array_unref(st->buf);
    g_free(st);
}
/**
 * fu_struct_elan_kbd_boot_condition_req_new_internal: (skip):
 **/
static FuStructElanKbdBootConditionReq *
fu_struct_elan_kbd_boot_condition_req_new_internal(void)
{
    FuStructElanKbdBootConditionReq *st = g_new0(FuStructElanKbdBootConditionReq, 1);
    st->refcount = 1;
    return st;
}

/* getters */

/* setters */
/**
 * fu_struct_elan_kbd_boot_condition_req_set_tag: (skip):
 **/
static void
fu_struct_elan_kbd_boot_condition_req_set_tag(FuStructElanKbdBootConditionReq *st, guint8 value)
{
    g_return_if_fail(st != NULL);
    st->buf->data[0] = value;
}
/**
 * fu_struct_elan_kbd_boot_condition_req_set_cmd: (skip):
 **/
static void
fu_struct_elan_kbd_boot_condition_req_set_cmd(FuStructElanKbdBootConditionReq *st, FuElanKbdCmd value)
{
    g_return_if_fail(st != NULL);
    st->buf->data[1] = value;
}
/**
 * fu_struct_elan_kbd_boot_condition_req_new: (skip):
 **/
FuStructElanKbdBootConditionReq *
fu_struct_elan_kbd_boot_condition_req_new(void)
{
    FuStructElanKbdBootConditionReq *st = fu_struct_elan_kbd_boot_condition_req_new_internal();
    st->buf = g_byte_array_sized_new(8);
    fu_byte_array_set_size(st->buf, 8, 0x0);
    fu_struct_elan_kbd_boot_condition_req_set_tag(st, 0xC1);
    fu_struct_elan_kbd_boot_condition_req_set_cmd(st, FU_ELAN_KBD_CMD_BOOT_CONDITION);
    return st;
}
/**
 * fu_struct_elan_kbd_boot_condition_res_ref: (skip):
 **/
FuStructElanKbdBootConditionRes *
fu_struct_elan_kbd_boot_condition_res_ref(FuStructElanKbdBootConditionRes *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    st->refcount++;
    return st;
}
/**
 * fu_struct_elan_kbd_boot_condition_res_unref: (skip):
 **/
void
fu_struct_elan_kbd_boot_condition_res_unref(FuStructElanKbdBootConditionRes *st)
{
    g_return_if_fail(st != NULL);
    if (st->refcount == 0) {
        g_critical("FuStructElanKbdBootConditionRes refcount already zero");
        return;
    }
    if (--st->refcount > 0)
        return;
    if (st->buf != NULL)
        g_byte_array_unref(st->buf);
    g_free(st);
}
/**
 * fu_struct_elan_kbd_boot_condition_res_new_internal: (skip):
 **/
static FuStructElanKbdBootConditionRes *
fu_struct_elan_kbd_boot_condition_res_new_internal(void)
{
    FuStructElanKbdBootConditionRes *st = g_new0(FuStructElanKbdBootConditionRes, 1);
    st->refcount = 1;
    return st;
}

/* getters */
/**
 * fu_struct_elan_kbd_boot_condition_res_get_value: (skip):
 **/
FuElanKbdBootCond1
fu_struct_elan_kbd_boot_condition_res_get_value(const FuStructElanKbdBootConditionRes *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[2];
}

/* setters */
/**
 * fu_struct_elan_kbd_boot_condition_res_to_string: (skip):
 **/
static gchar *
fu_struct_elan_kbd_boot_condition_res_to_string(const FuStructElanKbdBootConditionRes *st)
{
    g_autoptr(GString) str = g_string_new("FuStructElanKbdBootConditionRes:\n");
    g_return_val_if_fail(st != NULL, NULL);
    {
        const gchar *tmp = fu_elan_kbd_boot_cond1_to_string(fu_struct_elan_kbd_boot_condition_res_get_value(st));
        if (tmp != NULL) {
            g_string_append_printf(str, "  value: 0x%x [%s]\n", (guint) fu_struct_elan_kbd_boot_condition_res_get_value(st), tmp);
        } else {
            g_string_append_printf(str, "  value: 0x%x\n", (guint) fu_struct_elan_kbd_boot_condition_res_get_value(st));
        }
    }
    if (str->len > 0)
        g_string_set_size(str, str->len - 1);
    return g_string_free(g_steal_pointer(&str), FALSE);
}
static gboolean
fu_struct_elan_kbd_boot_condition_res_validate_internal(FuStructElanKbdBootConditionRes *st, GError **error)
{
    g_return_val_if_fail(st != NULL, FALSE);
    return TRUE;
}
static gboolean
fu_struct_elan_kbd_boot_condition_res_parse_internal(FuStructElanKbdBootConditionRes *st, GError **error)
{
    if (g_getenv("FWUPD_VERBOSE") != NULL) {
        g_autofree gchar *str = fu_struct_elan_kbd_boot_condition_res_to_string(st);
        g_debug("%s", str);
    }
    if (!fu_struct_elan_kbd_boot_condition_res_validate_internal(st, error))
        return FALSE;
    return TRUE;
}

/**
 * fu_struct_elan_kbd_boot_condition_res_parse: (skip):
 **/
FuStructElanKbdBootConditionRes *
fu_struct_elan_kbd_boot_condition_res_parse(const guint8 *buf, gsize bufsz, gsize offset, GError **error)
{
    g_autoptr(FuStructElanKbdBootConditionRes) st = fu_struct_elan_kbd_boot_condition_res_new_internal();
    g_return_val_if_fail(buf != NULL, NULL);
    g_return_val_if_fail(error == NULL || *error == NULL, NULL);
    if (!fu_memchk_read(bufsz, offset, 3, error)) {
        g_prefix_error_literal(error, "invalid struct FuStructElanKbdBootConditionRes: ");
        return NULL;
    }
    st->buf = g_byte_array_new();
    g_byte_array_append(st->buf, buf + offset, 3);
    if (!fu_struct_elan_kbd_boot_condition_res_parse_internal(st, error))
        return NULL;
    return g_steal_pointer(&st);
}
/**
 * fu_struct_elan_kbd_cmd_status_res_ref: (skip):
 **/
FuStructElanKbdCmdStatusRes *
fu_struct_elan_kbd_cmd_status_res_ref(FuStructElanKbdCmdStatusRes *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    st->refcount++;
    return st;
}
/**
 * fu_struct_elan_kbd_cmd_status_res_unref: (skip):
 **/
void
fu_struct_elan_kbd_cmd_status_res_unref(FuStructElanKbdCmdStatusRes *st)
{
    g_return_if_fail(st != NULL);
    if (st->refcount == 0) {
        g_critical("FuStructElanKbdCmdStatusRes refcount already zero");
        return;
    }
    if (--st->refcount > 0)
        return;
    if (st->buf != NULL)
        g_byte_array_unref(st->buf);
    g_free(st);
}
/**
 * fu_struct_elan_kbd_cmd_status_res_new_internal: (skip):
 **/
static FuStructElanKbdCmdStatusRes *
fu_struct_elan_kbd_cmd_status_res_new_internal(void)
{
    FuStructElanKbdCmdStatusRes *st = g_new0(FuStructElanKbdCmdStatusRes, 1);
    st->refcount = 1;
    return st;
}

/* getters */
/**
 * fu_struct_elan_kbd_cmd_status_res_get_value: (skip):
 **/
FuElanKbdStatus
fu_struct_elan_kbd_cmd_status_res_get_value(const FuStructElanKbdCmdStatusRes *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->buf->data + 0, G_BIG_ENDIAN);
}
/**
 * fu_struct_elan_kbd_cmd_status_res_get_error: (skip):
 **/
FuElanKbdError
fu_struct_elan_kbd_cmd_status_res_get_error(const FuStructElanKbdCmdStatusRes *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[2];
}

/* setters */
/**
 * fu_struct_elan_kbd_cmd_status_res_to_string: (skip):
 **/
static gchar *
fu_struct_elan_kbd_cmd_status_res_to_string(const FuStructElanKbdCmdStatusRes *st)
{
    g_autoptr(GString) str = g_string_new("FuStructElanKbdCmdStatusRes:\n");
    g_return_val_if_fail(st != NULL, NULL);
    {
        const gchar *tmp = fu_elan_kbd_status_to_string(fu_struct_elan_kbd_cmd_status_res_get_value(st));
        if (tmp != NULL) {
            g_string_append_printf(str, "  value: 0x%x [%s]\n", (guint) fu_struct_elan_kbd_cmd_status_res_get_value(st), tmp);
        } else {
            g_string_append_printf(str, "  value: 0x%x\n", (guint) fu_struct_elan_kbd_cmd_status_res_get_value(st));
        }
    }
    {
        const gchar *tmp = fu_elan_kbd_error_to_string(fu_struct_elan_kbd_cmd_status_res_get_error(st));
        if (tmp != NULL) {
            g_string_append_printf(str, "  error: 0x%x [%s]\n", (guint) fu_struct_elan_kbd_cmd_status_res_get_error(st), tmp);
        } else {
            g_string_append_printf(str, "  error: 0x%x\n", (guint) fu_struct_elan_kbd_cmd_status_res_get_error(st));
        }
    }
    if (str->len > 0)
        g_string_set_size(str, str->len - 1);
    return g_string_free(g_steal_pointer(&str), FALSE);
}
static gboolean
fu_struct_elan_kbd_cmd_status_res_validate_internal(FuStructElanKbdCmdStatusRes *st, GError **error)
{
    g_return_val_if_fail(st != NULL, FALSE);
    return TRUE;
}
static gboolean
fu_struct_elan_kbd_cmd_status_res_parse_internal(FuStructElanKbdCmdStatusRes *st, GError **error)
{
    if (g_getenv("FWUPD_VERBOSE") != NULL) {
        g_autofree gchar *str = fu_struct_elan_kbd_cmd_status_res_to_string(st);
        g_debug("%s", str);
    }
    if (!fu_struct_elan_kbd_cmd_status_res_validate_internal(st, error))
        return FALSE;
    return TRUE;
}

/**
 * fu_struct_elan_kbd_cmd_status_res_parse: (skip):
 **/
FuStructElanKbdCmdStatusRes *
fu_struct_elan_kbd_cmd_status_res_parse(const guint8 *buf, gsize bufsz, gsize offset, GError **error)
{
    g_autoptr(FuStructElanKbdCmdStatusRes) st = fu_struct_elan_kbd_cmd_status_res_new_internal();
    g_return_val_if_fail(buf != NULL, NULL);
    g_return_val_if_fail(error == NULL || *error == NULL, NULL);
    if (!fu_memchk_read(bufsz, offset, 3, error)) {
        g_prefix_error_literal(error, "invalid struct FuStructElanKbdCmdStatusRes: ");
        return NULL;
    }
    st->buf = g_byte_array_new();
    g_byte_array_append(st->buf, buf + offset, 3);
    if (!fu_struct_elan_kbd_cmd_status_res_parse_internal(st, error))
        return NULL;
    return g_steal_pointer(&st);
}
/**
 * fu_struct_elan_kbd_abort_req_ref: (skip):
 **/
FuStructElanKbdAbortReq *
fu_struct_elan_kbd_abort_req_ref(FuStructElanKbdAbortReq *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    st->refcount++;
    return st;
}
/**
 * fu_struct_elan_kbd_abort_req_unref: (skip):
 **/
void
fu_struct_elan_kbd_abort_req_unref(FuStructElanKbdAbortReq *st)
{
    g_return_if_fail(st != NULL);
    if (st->refcount == 0) {
        g_critical("FuStructElanKbdAbortReq refcount already zero");
        return;
    }
    if (--st->refcount > 0)
        return;
    if (st->buf != NULL)
        g_byte_array_unref(st->buf);
    g_free(st);
}
/**
 * fu_struct_elan_kbd_abort_req_new_internal: (skip):
 **/
static FuStructElanKbdAbortReq *
fu_struct_elan_kbd_abort_req_new_internal(void)
{
    FuStructElanKbdAbortReq *st = g_new0(FuStructElanKbdAbortReq, 1);
    st->refcount = 1;
    return st;
}

/* getters */

/* setters */
/**
 * fu_struct_elan_kbd_abort_req_set_tag: (skip):
 **/
static void
fu_struct_elan_kbd_abort_req_set_tag(FuStructElanKbdAbortReq *st, guint8 value)
{
    g_return_if_fail(st != NULL);
    st->buf->data[0] = value;
}
/**
 * fu_struct_elan_kbd_abort_req_set_cmd: (skip):
 **/
static void
fu_struct_elan_kbd_abort_req_set_cmd(FuStructElanKbdAbortReq *st, FuElanKbdCmd value)
{
    g_return_if_fail(st != NULL);
    st->buf->data[1] = value;
}
/**
 * fu_struct_elan_kbd_abort_req_new: (skip):
 **/
FuStructElanKbdAbortReq *
fu_struct_elan_kbd_abort_req_new(void)
{
    FuStructElanKbdAbortReq *st = fu_struct_elan_kbd_abort_req_new_internal();
    st->buf = g_byte_array_sized_new(8);
    fu_byte_array_set_size(st->buf, 8, 0x0);
    fu_struct_elan_kbd_abort_req_set_tag(st, 0xC1);
    fu_struct_elan_kbd_abort_req_set_cmd(st, FU_ELAN_KBD_CMD_ABORT);
    return st;
}
/**
 * fu_struct_elan_kbd_software_reset_req_ref: (skip):
 **/
FuStructElanKbdSoftwareResetReq *
fu_struct_elan_kbd_software_reset_req_ref(FuStructElanKbdSoftwareResetReq *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    st->refcount++;
    return st;
}
/**
 * fu_struct_elan_kbd_software_reset_req_unref: (skip):
 **/
void
fu_struct_elan_kbd_software_reset_req_unref(FuStructElanKbdSoftwareResetReq *st)
{
    g_return_if_fail(st != NULL);
    if (st->refcount == 0) {
        g_critical("FuStructElanKbdSoftwareResetReq refcount already zero");
        return;
    }
    if (--st->refcount > 0)
        return;
    if (st->buf != NULL)
        g_byte_array_unref(st->buf);
    g_free(st);
}
/**
 * fu_struct_elan_kbd_software_reset_req_new_internal: (skip):
 **/
static FuStructElanKbdSoftwareResetReq *
fu_struct_elan_kbd_software_reset_req_new_internal(void)
{
    FuStructElanKbdSoftwareResetReq *st = g_new0(FuStructElanKbdSoftwareResetReq, 1);
    st->refcount = 1;
    return st;
}

/* getters */

/* setters */
/**
 * fu_struct_elan_kbd_software_reset_req_set_tag: (skip):
 **/
static void
fu_struct_elan_kbd_software_reset_req_set_tag(FuStructElanKbdSoftwareResetReq *st, guint8 value)
{
    g_return_if_fail(st != NULL);
    st->buf->data[0] = value;
}
/**
 * fu_struct_elan_kbd_software_reset_req_set_cmd: (skip):
 **/
static void
fu_struct_elan_kbd_software_reset_req_set_cmd(FuStructElanKbdSoftwareResetReq *st, FuElanKbdCmd value)
{
    g_return_if_fail(st != NULL);
    st->buf->data[1] = value;
}
/**
 * fu_struct_elan_kbd_software_reset_req_new: (skip):
 **/
FuStructElanKbdSoftwareResetReq *
fu_struct_elan_kbd_software_reset_req_new(void)
{
    FuStructElanKbdSoftwareResetReq *st = fu_struct_elan_kbd_software_reset_req_new_internal();
    st->buf = g_byte_array_sized_new(8);
    fu_byte_array_set_size(st->buf, 8, 0x0);
    fu_struct_elan_kbd_software_reset_req_set_tag(st, 0xC1);
    fu_struct_elan_kbd_software_reset_req_set_cmd(st, FU_ELAN_KBD_CMD_SOFTWARE_RESET);
    return st;
}
/**
 * fu_struct_elan_kbd_read_rom_req_ref: (skip):
 **/
FuStructElanKbdReadRomReq *
fu_struct_elan_kbd_read_rom_req_ref(FuStructElanKbdReadRomReq *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    st->refcount++;
    return st;
}
/**
 * fu_struct_elan_kbd_read_rom_req_unref: (skip):
 **/
void
fu_struct_elan_kbd_read_rom_req_unref(FuStructElanKbdReadRomReq *st)
{
    g_return_if_fail(st != NULL);
    if (st->refcount == 0) {
        g_critical("FuStructElanKbdReadRomReq refcount already zero");
        return;
    }
    if (--st->refcount > 0)
        return;
    if (st->buf != NULL)
        g_byte_array_unref(st->buf);
    g_free(st);
}
/**
 * fu_struct_elan_kbd_read_rom_req_new_internal: (skip):
 **/
static FuStructElanKbdReadRomReq *
fu_struct_elan_kbd_read_rom_req_new_internal(void)
{
    FuStructElanKbdReadRomReq *st = g_new0(FuStructElanKbdReadRomReq, 1);
    st->refcount = 1;
    return st;
}

/* getters */

/* setters */
/**
 * fu_struct_elan_kbd_read_rom_req_set_tag: (skip):
 **/
static void
fu_struct_elan_kbd_read_rom_req_set_tag(FuStructElanKbdReadRomReq *st, guint8 value)
{
    g_return_if_fail(st != NULL);
    st->buf->data[0] = value;
}
/**
 * fu_struct_elan_kbd_read_rom_req_set_cmd: (skip):
 **/
static void
fu_struct_elan_kbd_read_rom_req_set_cmd(FuStructElanKbdReadRomReq *st, FuElanKbdCmd value)
{
    g_return_if_fail(st != NULL);
    st->buf->data[1] = value;
}
/**
 * fu_struct_elan_kbd_read_rom_req_set_addr: (skip):
 **/
void
fu_struct_elan_kbd_read_rom_req_set_addr(FuStructElanKbdReadRomReq *st, guint16 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint16(st->buf->data + 2, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_elan_kbd_read_rom_req_set_len: (skip):
 **/
void
fu_struct_elan_kbd_read_rom_req_set_len(FuStructElanKbdReadRomReq *st, guint16 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint16(st->buf->data + 4, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_elan_kbd_read_rom_req_new: (skip):
 **/
FuStructElanKbdReadRomReq *
fu_struct_elan_kbd_read_rom_req_new(void)
{
    FuStructElanKbdReadRomReq *st = fu_struct_elan_kbd_read_rom_req_new_internal();
    st->buf = g_byte_array_sized_new(8);
    fu_byte_array_set_size(st->buf, 8, 0x0);
    fu_struct_elan_kbd_read_rom_req_set_tag(st, 0xC1);
    fu_struct_elan_kbd_read_rom_req_set_cmd(st, FU_ELAN_KBD_CMD_READ_ROM);
    return st;
}
/**
 * fu_struct_elan_kbd_read_rom_finished_req_ref: (skip):
 **/
FuStructElanKbdReadRomFinishedReq *
fu_struct_elan_kbd_read_rom_finished_req_ref(FuStructElanKbdReadRomFinishedReq *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    st->refcount++;
    return st;
}
/**
 * fu_struct_elan_kbd_read_rom_finished_req_unref: (skip):
 **/
void
fu_struct_elan_kbd_read_rom_finished_req_unref(FuStructElanKbdReadRomFinishedReq *st)
{
    g_return_if_fail(st != NULL);
    if (st->refcount == 0) {
        g_critical("FuStructElanKbdReadRomFinishedReq refcount already zero");
        return;
    }
    if (--st->refcount > 0)
        return;
    if (st->buf != NULL)
        g_byte_array_unref(st->buf);
    g_free(st);
}
/**
 * fu_struct_elan_kbd_read_rom_finished_req_new_internal: (skip):
 **/
static FuStructElanKbdReadRomFinishedReq *
fu_struct_elan_kbd_read_rom_finished_req_new_internal(void)
{
    FuStructElanKbdReadRomFinishedReq *st = g_new0(FuStructElanKbdReadRomFinishedReq, 1);
    st->refcount = 1;
    return st;
}

/* getters */

/* setters */
/**
 * fu_struct_elan_kbd_read_rom_finished_req_set_tag: (skip):
 **/
static void
fu_struct_elan_kbd_read_rom_finished_req_set_tag(FuStructElanKbdReadRomFinishedReq *st, guint8 value)
{
    g_return_if_fail(st != NULL);
    st->buf->data[0] = value;
}
/**
 * fu_struct_elan_kbd_read_rom_finished_req_set_cmd: (skip):
 **/
static void
fu_struct_elan_kbd_read_rom_finished_req_set_cmd(FuStructElanKbdReadRomFinishedReq *st, FuElanKbdCmd value)
{
    g_return_if_fail(st != NULL);
    st->buf->data[1] = value;
}
/**
 * fu_struct_elan_kbd_read_rom_finished_req_set_csum: (skip):
 **/
void
fu_struct_elan_kbd_read_rom_finished_req_set_csum(FuStructElanKbdReadRomFinishedReq *st, guint8 value)
{
    g_return_if_fail(st != NULL);
    st->buf->data[2] = value;
}
/**
 * fu_struct_elan_kbd_read_rom_finished_req_new: (skip):
 **/
FuStructElanKbdReadRomFinishedReq *
fu_struct_elan_kbd_read_rom_finished_req_new(void)
{
    FuStructElanKbdReadRomFinishedReq *st = fu_struct_elan_kbd_read_rom_finished_req_new_internal();
    st->buf = g_byte_array_sized_new(8);
    fu_byte_array_set_size(st->buf, 8, 0x0);
    fu_struct_elan_kbd_read_rom_finished_req_set_tag(st, 0xC1);
    fu_struct_elan_kbd_read_rom_finished_req_set_cmd(st, FU_ELAN_KBD_CMD_READ_ROM_FINISH);
    return st;
}
/**
 * fu_struct_elan_kbd_read_option_req_ref: (skip):
 **/
FuStructElanKbdReadOptionReq *
fu_struct_elan_kbd_read_option_req_ref(FuStructElanKbdReadOptionReq *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    st->refcount++;
    return st;
}
/**
 * fu_struct_elan_kbd_read_option_req_unref: (skip):
 **/
void
fu_struct_elan_kbd_read_option_req_unref(FuStructElanKbdReadOptionReq *st)
{
    g_return_if_fail(st != NULL);
    if (st->refcount == 0) {
        g_critical("FuStructElanKbdReadOptionReq refcount already zero");
        return;
    }
    if (--st->refcount > 0)
        return;
    if (st->buf != NULL)
        g_byte_array_unref(st->buf);
    g_free(st);
}
/**
 * fu_struct_elan_kbd_read_option_req_new_internal: (skip):
 **/
static FuStructElanKbdReadOptionReq *
fu_struct_elan_kbd_read_option_req_new_internal(void)
{
    FuStructElanKbdReadOptionReq *st = g_new0(FuStructElanKbdReadOptionReq, 1);
    st->refcount = 1;
    return st;
}

/* getters */

/* setters */
/**
 * fu_struct_elan_kbd_read_option_req_set_tag: (skip):
 **/
static void
fu_struct_elan_kbd_read_option_req_set_tag(FuStructElanKbdReadOptionReq *st, guint8 value)
{
    g_return_if_fail(st != NULL);
    st->buf->data[0] = value;
}
/**
 * fu_struct_elan_kbd_read_option_req_set_cmd: (skip):
 **/
static void
fu_struct_elan_kbd_read_option_req_set_cmd(FuStructElanKbdReadOptionReq *st, FuElanKbdCmd value)
{
    g_return_if_fail(st != NULL);
    st->buf->data[1] = value;
}
/**
 * fu_struct_elan_kbd_read_option_req_set_addr: (skip):
 **/
static void
fu_struct_elan_kbd_read_option_req_set_addr(FuStructElanKbdReadOptionReq *st, guint16 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint16(st->buf->data + 2, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_elan_kbd_read_option_req_set_len: (skip):
 **/
static void
fu_struct_elan_kbd_read_option_req_set_len(FuStructElanKbdReadOptionReq *st, guint16 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint16(st->buf->data + 4, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_elan_kbd_read_option_req_new: (skip):
 **/
FuStructElanKbdReadOptionReq *
fu_struct_elan_kbd_read_option_req_new(void)
{
    FuStructElanKbdReadOptionReq *st = fu_struct_elan_kbd_read_option_req_new_internal();
    st->buf = g_byte_array_sized_new(8);
    fu_byte_array_set_size(st->buf, 8, 0x0);
    fu_struct_elan_kbd_read_option_req_set_tag(st, 0xC1);
    fu_struct_elan_kbd_read_option_req_set_cmd(st, FU_ELAN_KBD_CMD_READ_OPTION);
    fu_struct_elan_kbd_read_option_req_set_addr(st, 128);
    fu_struct_elan_kbd_read_option_req_set_len(st, 128);
    return st;
}
/**
 * fu_struct_elan_kbd_read_option_finished_req_ref: (skip):
 **/
FuStructElanKbdReadOptionFinishedReq *
fu_struct_elan_kbd_read_option_finished_req_ref(FuStructElanKbdReadOptionFinishedReq *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    st->refcount++;
    return st;
}
/**
 * fu_struct_elan_kbd_read_option_finished_req_unref: (skip):
 **/
void
fu_struct_elan_kbd_read_option_finished_req_unref(FuStructElanKbdReadOptionFinishedReq *st)
{
    g_return_if_fail(st != NULL);
    if (st->refcount == 0) {
        g_critical("FuStructElanKbdReadOptionFinishedReq refcount already zero");
        return;
    }
    if (--st->refcount > 0)
        return;
    if (st->buf != NULL)
        g_byte_array_unref(st->buf);
    g_free(st);
}
/**
 * fu_struct_elan_kbd_read_option_finished_req_new_internal: (skip):
 **/
static FuStructElanKbdReadOptionFinishedReq *
fu_struct_elan_kbd_read_option_finished_req_new_internal(void)
{
    FuStructElanKbdReadOptionFinishedReq *st = g_new0(FuStructElanKbdReadOptionFinishedReq, 1);
    st->refcount = 1;
    return st;
}

/* getters */

/* setters */
/**
 * fu_struct_elan_kbd_read_option_finished_req_set_tag: (skip):
 **/
static void
fu_struct_elan_kbd_read_option_finished_req_set_tag(FuStructElanKbdReadOptionFinishedReq *st, guint8 value)
{
    g_return_if_fail(st != NULL);
    st->buf->data[0] = value;
}
/**
 * fu_struct_elan_kbd_read_option_finished_req_set_cmd: (skip):
 **/
static void
fu_struct_elan_kbd_read_option_finished_req_set_cmd(FuStructElanKbdReadOptionFinishedReq *st, FuElanKbdCmd value)
{
    g_return_if_fail(st != NULL);
    st->buf->data[1] = value;
}
/**
 * fu_struct_elan_kbd_read_option_finished_req_set_csum: (skip):
 **/
void
fu_struct_elan_kbd_read_option_finished_req_set_csum(FuStructElanKbdReadOptionFinishedReq *st, guint8 value)
{
    g_return_if_fail(st != NULL);
    st->buf->data[2] = value;
}
/**
 * fu_struct_elan_kbd_read_option_finished_req_new: (skip):
 **/
FuStructElanKbdReadOptionFinishedReq *
fu_struct_elan_kbd_read_option_finished_req_new(void)
{
    FuStructElanKbdReadOptionFinishedReq *st = fu_struct_elan_kbd_read_option_finished_req_new_internal();
    st->buf = g_byte_array_sized_new(8);
    fu_byte_array_set_size(st->buf, 8, 0x0);
    fu_struct_elan_kbd_read_option_finished_req_set_tag(st, 0xC1);
    fu_struct_elan_kbd_read_option_finished_req_set_cmd(st, FU_ELAN_KBD_CMD_READ_OPTION_FINISH);
    return st;
}
/**
 * fu_struct_elan_kbd_get_auth_lock_req_ref: (skip):
 **/
FuStructElanKbdGetAuthLockReq *
fu_struct_elan_kbd_get_auth_lock_req_ref(FuStructElanKbdGetAuthLockReq *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    st->refcount++;
    return st;
}
/**
 * fu_struct_elan_kbd_get_auth_lock_req_unref: (skip):
 **/
void
fu_struct_elan_kbd_get_auth_lock_req_unref(FuStructElanKbdGetAuthLockReq *st)
{
    g_return_if_fail(st != NULL);
    if (st->refcount == 0) {
        g_critical("FuStructElanKbdGetAuthLockReq refcount already zero");
        return;
    }
    if (--st->refcount > 0)
        return;
    if (st->buf != NULL)
        g_byte_array_unref(st->buf);
    g_free(st);
}
/**
 * fu_struct_elan_kbd_get_auth_lock_req_new_internal: (skip):
 **/
static FuStructElanKbdGetAuthLockReq *
fu_struct_elan_kbd_get_auth_lock_req_new_internal(void)
{
    FuStructElanKbdGetAuthLockReq *st = g_new0(FuStructElanKbdGetAuthLockReq, 1);
    st->refcount = 1;
    return st;
}

/* getters */

/* setters */
/**
 * fu_struct_elan_kbd_get_auth_lock_req_set_tag: (skip):
 **/
static void
fu_struct_elan_kbd_get_auth_lock_req_set_tag(FuStructElanKbdGetAuthLockReq *st, guint8 value)
{
    g_return_if_fail(st != NULL);
    st->buf->data[0] = value;
}
/**
 * fu_struct_elan_kbd_get_auth_lock_req_set_cmd: (skip):
 **/
static void
fu_struct_elan_kbd_get_auth_lock_req_set_cmd(FuStructElanKbdGetAuthLockReq *st, FuElanKbdCmd value)
{
    g_return_if_fail(st != NULL);
    st->buf->data[1] = value;
}
/**
 * fu_struct_elan_kbd_get_auth_lock_req_new: (skip):
 **/
FuStructElanKbdGetAuthLockReq *
fu_struct_elan_kbd_get_auth_lock_req_new(void)
{
    FuStructElanKbdGetAuthLockReq *st = fu_struct_elan_kbd_get_auth_lock_req_new_internal();
    st->buf = g_byte_array_sized_new(8);
    fu_byte_array_set_size(st->buf, 8, 0x0);
    fu_struct_elan_kbd_get_auth_lock_req_set_tag(st, 0xC1);
    fu_struct_elan_kbd_get_auth_lock_req_set_cmd(st, FU_ELAN_KBD_CMD_GET_AUTH_LOCK);
    return st;
}
/**
 * fu_struct_elan_kbd_get_auth_lock_res_ref: (skip):
 **/
FuStructElanKbdGetAuthLockRes *
fu_struct_elan_kbd_get_auth_lock_res_ref(FuStructElanKbdGetAuthLockRes *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    st->refcount++;
    return st;
}
/**
 * fu_struct_elan_kbd_get_auth_lock_res_unref: (skip):
 **/
void
fu_struct_elan_kbd_get_auth_lock_res_unref(FuStructElanKbdGetAuthLockRes *st)
{
    g_return_if_fail(st != NULL);
    if (st->refcount == 0) {
        g_critical("FuStructElanKbdGetAuthLockRes refcount already zero");
        return;
    }
    if (--st->refcount > 0)
        return;
    if (st->buf != NULL)
        g_byte_array_unref(st->buf);
    g_free(st);
}
/**
 * fu_struct_elan_kbd_get_auth_lock_res_new_internal: (skip):
 **/
static FuStructElanKbdGetAuthLockRes *
fu_struct_elan_kbd_get_auth_lock_res_new_internal(void)
{
    FuStructElanKbdGetAuthLockRes *st = g_new0(FuStructElanKbdGetAuthLockRes, 1);
    st->refcount = 1;
    return st;
}

/* getters */
/**
 * fu_struct_elan_kbd_get_auth_lock_res_get_key: (skip):
 **/
guint8
fu_struct_elan_kbd_get_auth_lock_res_get_key(const FuStructElanKbdGetAuthLockRes *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[0];
}

/* setters */
/**
 * fu_struct_elan_kbd_get_auth_lock_res_to_string: (skip):
 **/
static gchar *
fu_struct_elan_kbd_get_auth_lock_res_to_string(const FuStructElanKbdGetAuthLockRes *st)
{
    g_autoptr(GString) str = g_string_new("FuStructElanKbdGetAuthLockRes:\n");
    g_return_val_if_fail(st != NULL, NULL);
    g_string_append_printf(str, "  key: 0x%x\n",
                           (guint) fu_struct_elan_kbd_get_auth_lock_res_get_key(st));
    if (str->len > 0)
        g_string_set_size(str, str->len - 1);
    return g_string_free(g_steal_pointer(&str), FALSE);
}
static gboolean
fu_struct_elan_kbd_get_auth_lock_res_validate_internal(FuStructElanKbdGetAuthLockRes *st, GError **error)
{
    g_return_val_if_fail(st != NULL, FALSE);
    return TRUE;
}
static gboolean
fu_struct_elan_kbd_get_auth_lock_res_parse_internal(FuStructElanKbdGetAuthLockRes *st, GError **error)
{
    if (g_getenv("FWUPD_VERBOSE") != NULL) {
        g_autofree gchar *str = fu_struct_elan_kbd_get_auth_lock_res_to_string(st);
        g_debug("%s", str);
    }
    if (!fu_struct_elan_kbd_get_auth_lock_res_validate_internal(st, error))
        return FALSE;
    return TRUE;
}

/**
 * fu_struct_elan_kbd_get_auth_lock_res_parse: (skip):
 **/
FuStructElanKbdGetAuthLockRes *
fu_struct_elan_kbd_get_auth_lock_res_parse(const guint8 *buf, gsize bufsz, gsize offset, GError **error)
{
    g_autoptr(FuStructElanKbdGetAuthLockRes) st = fu_struct_elan_kbd_get_auth_lock_res_new_internal();
    g_return_val_if_fail(buf != NULL, NULL);
    g_return_val_if_fail(error == NULL || *error == NULL, NULL);
    if (!fu_memchk_read(bufsz, offset, 1, error)) {
        g_prefix_error_literal(error, "invalid struct FuStructElanKbdGetAuthLockRes: ");
        return NULL;
    }
    st->buf = g_byte_array_new();
    g_byte_array_append(st->buf, buf + offset, 1);
    if (!fu_struct_elan_kbd_get_auth_lock_res_parse_internal(st, error))
        return NULL;
    return g_steal_pointer(&st);
}
/**
 * fu_struct_elan_kbd_set_auth_lock_req_ref: (skip):
 **/
FuStructElanKbdSetAuthLockReq *
fu_struct_elan_kbd_set_auth_lock_req_ref(FuStructElanKbdSetAuthLockReq *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    st->refcount++;
    return st;
}
/**
 * fu_struct_elan_kbd_set_auth_lock_req_unref: (skip):
 **/
void
fu_struct_elan_kbd_set_auth_lock_req_unref(FuStructElanKbdSetAuthLockReq *st)
{
    g_return_if_fail(st != NULL);
    if (st->refcount == 0) {
        g_critical("FuStructElanKbdSetAuthLockReq refcount already zero");
        return;
    }
    if (--st->refcount > 0)
        return;
    if (st->buf != NULL)
        g_byte_array_unref(st->buf);
    g_free(st);
}
/**
 * fu_struct_elan_kbd_set_auth_lock_req_new_internal: (skip):
 **/
static FuStructElanKbdSetAuthLockReq *
fu_struct_elan_kbd_set_auth_lock_req_new_internal(void)
{
    FuStructElanKbdSetAuthLockReq *st = g_new0(FuStructElanKbdSetAuthLockReq, 1);
    st->refcount = 1;
    return st;
}

/* getters */

/* setters */
/**
 * fu_struct_elan_kbd_set_auth_lock_req_set_tag: (skip):
 **/
static void
fu_struct_elan_kbd_set_auth_lock_req_set_tag(FuStructElanKbdSetAuthLockReq *st, guint8 value)
{
    g_return_if_fail(st != NULL);
    st->buf->data[0] = value;
}
/**
 * fu_struct_elan_kbd_set_auth_lock_req_set_cmd: (skip):
 **/
static void
fu_struct_elan_kbd_set_auth_lock_req_set_cmd(FuStructElanKbdSetAuthLockReq *st, FuElanKbdCmd value)
{
    g_return_if_fail(st != NULL);
    st->buf->data[1] = value;
}
/**
 * fu_struct_elan_kbd_set_auth_lock_req_set_key: (skip):
 **/
void
fu_struct_elan_kbd_set_auth_lock_req_set_key(FuStructElanKbdSetAuthLockReq *st, guint8 value)
{
    g_return_if_fail(st != NULL);
    st->buf->data[2] = value;
}
/**
 * fu_struct_elan_kbd_set_auth_lock_req_new: (skip):
 **/
FuStructElanKbdSetAuthLockReq *
fu_struct_elan_kbd_set_auth_lock_req_new(void)
{
    FuStructElanKbdSetAuthLockReq *st = fu_struct_elan_kbd_set_auth_lock_req_new_internal();
    st->buf = g_byte_array_sized_new(8);
    fu_byte_array_set_size(st->buf, 8, 0x0);
    fu_struct_elan_kbd_set_auth_lock_req_set_tag(st, 0xC1);
    fu_struct_elan_kbd_set_auth_lock_req_set_cmd(st, FU_ELAN_KBD_CMD_SET_AUTH_LOCK);
    return st;
}
/**
 * fu_struct_elan_kbd_entry_iap_req_ref: (skip):
 **/
FuStructElanKbdEntryIapReq *
fu_struct_elan_kbd_entry_iap_req_ref(FuStructElanKbdEntryIapReq *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    st->refcount++;
    return st;
}
/**
 * fu_struct_elan_kbd_entry_iap_req_unref: (skip):
 **/
void
fu_struct_elan_kbd_entry_iap_req_unref(FuStructElanKbdEntryIapReq *st)
{
    g_return_if_fail(st != NULL);
    if (st->refcount == 0) {
        g_critical("FuStructElanKbdEntryIapReq refcount already zero");
        return;
    }
    if (--st->refcount > 0)
        return;
    if (st->buf != NULL)
        g_byte_array_unref(st->buf);
    g_free(st);
}
/**
 * fu_struct_elan_kbd_entry_iap_req_new_internal: (skip):
 **/
static FuStructElanKbdEntryIapReq *
fu_struct_elan_kbd_entry_iap_req_new_internal(void)
{
    FuStructElanKbdEntryIapReq *st = g_new0(FuStructElanKbdEntryIapReq, 1);
    st->refcount = 1;
    return st;
}

/* getters */

/* setters */
/**
 * fu_struct_elan_kbd_entry_iap_req_set_tag: (skip):
 **/
static void
fu_struct_elan_kbd_entry_iap_req_set_tag(FuStructElanKbdEntryIapReq *st, guint8 value)
{
    g_return_if_fail(st != NULL);
    st->buf->data[0] = value;
}
/**
 * fu_struct_elan_kbd_entry_iap_req_set_cmd: (skip):
 **/
static void
fu_struct_elan_kbd_entry_iap_req_set_cmd(FuStructElanKbdEntryIapReq *st, FuElanKbdCmd value)
{
    g_return_if_fail(st != NULL);
    st->buf->data[1] = value;
}
/**
 * fu_struct_elan_kbd_entry_iap_req_set_key: (skip):
 **/
static void
fu_struct_elan_kbd_entry_iap_req_set_key(FuStructElanKbdEntryIapReq *st, guint16 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint16(st->buf->data + 6, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_elan_kbd_entry_iap_req_new: (skip):
 **/
FuStructElanKbdEntryIapReq *
fu_struct_elan_kbd_entry_iap_req_new(void)
{
    FuStructElanKbdEntryIapReq *st = fu_struct_elan_kbd_entry_iap_req_new_internal();
    st->buf = g_byte_array_sized_new(8);
    fu_byte_array_set_size(st->buf, 8, 0x0);
    fu_struct_elan_kbd_entry_iap_req_set_tag(st, 0xC1);
    fu_struct_elan_kbd_entry_iap_req_set_cmd(st, FU_ELAN_KBD_CMD_ENTRY_IAP);
    fu_struct_elan_kbd_entry_iap_req_set_key(st, 0x7FA9);
    return st;
}
/**
 * fu_struct_elan_kbd_finished_iap_req_ref: (skip):
 **/
FuStructElanKbdFinishedIapReq *
fu_struct_elan_kbd_finished_iap_req_ref(FuStructElanKbdFinishedIapReq *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    st->refcount++;
    return st;
}
/**
 * fu_struct_elan_kbd_finished_iap_req_unref: (skip):
 **/
void
fu_struct_elan_kbd_finished_iap_req_unref(FuStructElanKbdFinishedIapReq *st)
{
    g_return_if_fail(st != NULL);
    if (st->refcount == 0) {
        g_critical("FuStructElanKbdFinishedIapReq refcount already zero");
        return;
    }
    if (--st->refcount > 0)
        return;
    if (st->buf != NULL)
        g_byte_array_unref(st->buf);
    g_free(st);
}
/**
 * fu_struct_elan_kbd_finished_iap_req_new_internal: (skip):
 **/
static FuStructElanKbdFinishedIapReq *
fu_struct_elan_kbd_finished_iap_req_new_internal(void)
{
    FuStructElanKbdFinishedIapReq *st = g_new0(FuStructElanKbdFinishedIapReq, 1);
    st->refcount = 1;
    return st;
}

/* getters */

/* setters */
/**
 * fu_struct_elan_kbd_finished_iap_req_set_tag: (skip):
 **/
static void
fu_struct_elan_kbd_finished_iap_req_set_tag(FuStructElanKbdFinishedIapReq *st, guint8 value)
{
    g_return_if_fail(st != NULL);
    st->buf->data[0] = value;
}
/**
 * fu_struct_elan_kbd_finished_iap_req_set_cmd: (skip):
 **/
static void
fu_struct_elan_kbd_finished_iap_req_set_cmd(FuStructElanKbdFinishedIapReq *st, FuElanKbdCmd value)
{
    g_return_if_fail(st != NULL);
    st->buf->data[1] = value;
}
/**
 * fu_struct_elan_kbd_finished_iap_req_set_key: (skip):
 **/
static void
fu_struct_elan_kbd_finished_iap_req_set_key(FuStructElanKbdFinishedIapReq *st, guint16 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint16(st->buf->data + 6, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_elan_kbd_finished_iap_req_new: (skip):
 **/
FuStructElanKbdFinishedIapReq *
fu_struct_elan_kbd_finished_iap_req_new(void)
{
    FuStructElanKbdFinishedIapReq *st = fu_struct_elan_kbd_finished_iap_req_new_internal();
    st->buf = g_byte_array_sized_new(8);
    fu_byte_array_set_size(st->buf, 8, 0x0);
    fu_struct_elan_kbd_finished_iap_req_set_tag(st, 0xC1);
    fu_struct_elan_kbd_finished_iap_req_set_cmd(st, FU_ELAN_KBD_CMD_FINISHED_IAP);
    fu_struct_elan_kbd_finished_iap_req_set_key(st, 0x7FA9);
    return st;
}
/**
 * fu_struct_elan_kbd_write_rom_req_ref: (skip):
 **/
FuStructElanKbdWriteRomReq *
fu_struct_elan_kbd_write_rom_req_ref(FuStructElanKbdWriteRomReq *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    st->refcount++;
    return st;
}
/**
 * fu_struct_elan_kbd_write_rom_req_unref: (skip):
 **/
void
fu_struct_elan_kbd_write_rom_req_unref(FuStructElanKbdWriteRomReq *st)
{
    g_return_if_fail(st != NULL);
    if (st->refcount == 0) {
        g_critical("FuStructElanKbdWriteRomReq refcount already zero");
        return;
    }
    if (--st->refcount > 0)
        return;
    if (st->buf != NULL)
        g_byte_array_unref(st->buf);
    g_free(st);
}
/**
 * fu_struct_elan_kbd_write_rom_req_new_internal: (skip):
 **/
static FuStructElanKbdWriteRomReq *
fu_struct_elan_kbd_write_rom_req_new_internal(void)
{
    FuStructElanKbdWriteRomReq *st = g_new0(FuStructElanKbdWriteRomReq, 1);
    st->refcount = 1;
    return st;
}

/* getters */

/* setters */
/**
 * fu_struct_elan_kbd_write_rom_req_set_tag: (skip):
 **/
static void
fu_struct_elan_kbd_write_rom_req_set_tag(FuStructElanKbdWriteRomReq *st, guint8 value)
{
    g_return_if_fail(st != NULL);
    st->buf->data[0] = value;
}
/**
 * fu_struct_elan_kbd_write_rom_req_set_cmd: (skip):
 **/
static void
fu_struct_elan_kbd_write_rom_req_set_cmd(FuStructElanKbdWriteRomReq *st, FuElanKbdCmd value)
{
    g_return_if_fail(st != NULL);
    st->buf->data[1] = value;
}
/**
 * fu_struct_elan_kbd_write_rom_req_set_addr: (skip):
 **/
void
fu_struct_elan_kbd_write_rom_req_set_addr(FuStructElanKbdWriteRomReq *st, guint16 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint16(st->buf->data + 2, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_elan_kbd_write_rom_req_set_len: (skip):
 **/
void
fu_struct_elan_kbd_write_rom_req_set_len(FuStructElanKbdWriteRomReq *st, guint16 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint16(st->buf->data + 4, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_elan_kbd_write_rom_req_set_key: (skip):
 **/
static void
fu_struct_elan_kbd_write_rom_req_set_key(FuStructElanKbdWriteRomReq *st, guint16 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint16(st->buf->data + 6, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_elan_kbd_write_rom_req_new: (skip):
 **/
FuStructElanKbdWriteRomReq *
fu_struct_elan_kbd_write_rom_req_new(void)
{
    FuStructElanKbdWriteRomReq *st = fu_struct_elan_kbd_write_rom_req_new_internal();
    st->buf = g_byte_array_sized_new(8);
    fu_byte_array_set_size(st->buf, 8, 0x0);
    fu_struct_elan_kbd_write_rom_req_set_tag(st, 0xC1);
    fu_struct_elan_kbd_write_rom_req_set_cmd(st, FU_ELAN_KBD_CMD_WRITE_ROM);
    fu_struct_elan_kbd_write_rom_req_set_key(st, 0x7FA9);
    return st;
}
/**
 * fu_struct_elan_kbd_write_rom_finished_req_ref: (skip):
 **/
FuStructElanKbdWriteRomFinishedReq *
fu_struct_elan_kbd_write_rom_finished_req_ref(FuStructElanKbdWriteRomFinishedReq *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    st->refcount++;
    return st;
}
/**
 * fu_struct_elan_kbd_write_rom_finished_req_unref: (skip):
 **/
void
fu_struct_elan_kbd_write_rom_finished_req_unref(FuStructElanKbdWriteRomFinishedReq *st)
{
    g_return_if_fail(st != NULL);
    if (st->refcount == 0) {
        g_critical("FuStructElanKbdWriteRomFinishedReq refcount already zero");
        return;
    }
    if (--st->refcount > 0)
        return;
    if (st->buf != NULL)
        g_byte_array_unref(st->buf);
    g_free(st);
}
/**
 * fu_struct_elan_kbd_write_rom_finished_req_new_internal: (skip):
 **/
static FuStructElanKbdWriteRomFinishedReq *
fu_struct_elan_kbd_write_rom_finished_req_new_internal(void)
{
    FuStructElanKbdWriteRomFinishedReq *st = g_new0(FuStructElanKbdWriteRomFinishedReq, 1);
    st->refcount = 1;
    return st;
}

/* getters */

/* setters */
/**
 * fu_struct_elan_kbd_write_rom_finished_req_set_tag: (skip):
 **/
static void
fu_struct_elan_kbd_write_rom_finished_req_set_tag(FuStructElanKbdWriteRomFinishedReq *st, guint8 value)
{
    g_return_if_fail(st != NULL);
    st->buf->data[0] = value;
}
/**
 * fu_struct_elan_kbd_write_rom_finished_req_set_cmd: (skip):
 **/
static void
fu_struct_elan_kbd_write_rom_finished_req_set_cmd(FuStructElanKbdWriteRomFinishedReq *st, FuElanKbdCmd value)
{
    g_return_if_fail(st != NULL);
    st->buf->data[1] = value;
}
/**
 * fu_struct_elan_kbd_write_rom_finished_req_set_csum: (skip):
 **/
void
fu_struct_elan_kbd_write_rom_finished_req_set_csum(FuStructElanKbdWriteRomFinishedReq *st, guint8 value)
{
    g_return_if_fail(st != NULL);
    st->buf->data[2] = value;
}
/**
 * fu_struct_elan_kbd_write_rom_finished_req_new: (skip):
 **/
FuStructElanKbdWriteRomFinishedReq *
fu_struct_elan_kbd_write_rom_finished_req_new(void)
{
    FuStructElanKbdWriteRomFinishedReq *st = fu_struct_elan_kbd_write_rom_finished_req_new_internal();
    st->buf = g_byte_array_sized_new(8);
    fu_byte_array_set_size(st->buf, 8, 0x0);
    fu_struct_elan_kbd_write_rom_finished_req_set_tag(st, 0xC1);
    fu_struct_elan_kbd_write_rom_finished_req_set_cmd(st, FU_ELAN_KBD_CMD_WRITE_ROM_FINISH);
    return st;
}
