/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/. */

/* Generated with cbindgen:0.29.2 */

/* DO NOT MODIFY THIS MANUALLY! This file was generated using cbindgen. See RunCbindgen.py */
#ifndef mozilla_intl_locale_MozLocaleBindings_h
#error "Don't include this file directly, instead include MozLocaleBindings.h"
#endif


#include <cstdarg>
#include <cstdint>
#include <cstdlib>
#include <ostream>
#include <new>

namespace mozilla {
namespace intl {
namespace ffi {

extern "C" {

/// The unicode ellipsis char "…", or "...", depending on the locale.
void locale_service_ellipsis(const nsACString *name, nsAString *out);

/// If true, accesskeys should always be appended for the locale.
bool locale_service_always_append_accesskeys(const nsACString *name);

/// If false, accesskeys should not be separated from the label.
bool locale_service_insert_separator_before_accesskeys(const nsACString *name);

/// A comma-separated list of valid BCP 47 language tags.
///
/// The default value is either
///
///     $lang, en-US, en
///
/// or
///
///     $lang-$region, $lang, en-US, en
///
/// if the current locale includes a region subtag.
///
/// If customizing this, begin with the language tag of your locale.
/// Next, include language tags for other languages that you expect most users of your locale to be able to speak,
/// so that their browsing experience degrades gracefully if content is not available in their primary language.
///
/// By default, "en-US, en" is appended to the end of the list, providing locales of last resort.
/// If you know that users of your locale would prefer a different variety of English,
/// or if they are not likely to understand English at all,
/// you may opt to include a different English language tag,
/// or to exclude English altogether.
void locale_service_default_accept_languages(const nsACString *name,
                                             nsACString *out);

/// The initial setting of the language drop-down menu
/// in the Fonts and Colors > Advanced preference panel.
///
/// Takes one of the values of the menuitems in the "selectLangs" menulist in
/// https://searchfox.org/firefox-main/source/browser/components/preferences/dialogs/fonts.xhtml
void locale_service_default_font_language_group(const nsACString *name, nsACString *out);

}  // extern "C"

}  // namespace ffi
}  // namespace intl
}  // namespace mozilla
