// Code generated by smithy-go-codegen DO NOT EDIT.

package ec2

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/ec2/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Delegates ownership of the Amazon EBS root volume for an Apple silicon Mac
// instance to an administrative user.
func (c *Client) CreateDelegateMacVolumeOwnershipTask(ctx context.Context, params *CreateDelegateMacVolumeOwnershipTaskInput, optFns ...func(*Options)) (*CreateDelegateMacVolumeOwnershipTaskOutput, error) {
	if params == nil {
		params = &CreateDelegateMacVolumeOwnershipTaskInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "CreateDelegateMacVolumeOwnershipTask", params, optFns, c.addOperationCreateDelegateMacVolumeOwnershipTaskMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*CreateDelegateMacVolumeOwnershipTaskOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type CreateDelegateMacVolumeOwnershipTaskInput struct {

	// The ID of the Amazon EC2 Mac instance.
	//
	// This member is required.
	InstanceId *string

	// Specifies the following credentials:
	//
	//   - Internal disk administrative user
	//
	//   - Username - Only the default administrative user ( aws-managed-user ) is
	//   supported and it is used by default. You can't specify a different
	//   administrative user.
	//
	//   - Password - If you did not change the default password for aws-managed-user ,
	//   specify the default password, which is blank. Otherwise, specify your password.
	//
	//   - Amazon EBS root volume administrative user
	//
	//   - Username - If you did not change the default administrative user, specify
	//   ec2-user . Otherwise, specify the username for your administrative user.
	//
	//   - Password - Specify the password for the administrative user.
	//
	// The credentials must be specified in the following JSON format:
	//
	//     { "internalDiskPassword":"internal-disk-admin_password",
	//     "rootVolumeUsername":"root-volume-admin_username",
	//     "rootVolumepassword":"root-volume-admin_password" }
	//
	// This member is required.
	MacCredentials *string

	// Unique, case-sensitive identifier that you provide to ensure the idempotency of
	// the request. For more information, see [Ensuring Idempotency].
	//
	// [Ensuring Idempotency]: https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html
	ClientToken *string

	// Checks whether you have the required permissions for the action, without
	// actually making the request, and provides an error response. If you have the
	// required permissions, the error response is DryRunOperation . Otherwise, it is
	// UnauthorizedOperation .
	DryRun *bool

	// The tags to assign to the volume ownership delegation task.
	TagSpecifications []types.TagSpecification

	noSmithyDocumentSerde
}

type CreateDelegateMacVolumeOwnershipTaskOutput struct {

	// Information about the volume ownership delegation task.
	MacModificationTask *types.MacModificationTask

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationCreateDelegateMacVolumeOwnershipTaskMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsEc2query_serializeOpCreateDelegateMacVolumeOwnershipTask{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsEc2query_deserializeOpCreateDelegateMacVolumeOwnershipTask{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "CreateDelegateMacVolumeOwnershipTask"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addIdempotencyToken_opCreateDelegateMacVolumeOwnershipTaskMiddleware(stack, options); err != nil {
		return err
	}
	if err = addOpCreateDelegateMacVolumeOwnershipTaskValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opCreateDelegateMacVolumeOwnershipTask(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

type idempotencyToken_initializeOpCreateDelegateMacVolumeOwnershipTask struct {
	tokenProvider IdempotencyTokenProvider
}

func (*idempotencyToken_initializeOpCreateDelegateMacVolumeOwnershipTask) ID() string {
	return "OperationIdempotencyTokenAutoFill"
}

func (m *idempotencyToken_initializeOpCreateDelegateMacVolumeOwnershipTask) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	if m.tokenProvider == nil {
		return next.HandleInitialize(ctx, in)
	}

	input, ok := in.Parameters.(*CreateDelegateMacVolumeOwnershipTaskInput)
	if !ok {
		return out, metadata, fmt.Errorf("expected middleware input to be of type *CreateDelegateMacVolumeOwnershipTaskInput ")
	}

	if input.ClientToken == nil {
		t, err := m.tokenProvider.GetIdempotencyToken()
		if err != nil {
			return out, metadata, err
		}
		input.ClientToken = &t
	}
	return next.HandleInitialize(ctx, in)
}
func addIdempotencyToken_opCreateDelegateMacVolumeOwnershipTaskMiddleware(stack *middleware.Stack, cfg Options) error {
	return stack.Initialize.Add(&idempotencyToken_initializeOpCreateDelegateMacVolumeOwnershipTask{tokenProvider: cfg.IdempotencyTokenProvider}, middleware.Before)
}

func newServiceMetadataMiddleware_opCreateDelegateMacVolumeOwnershipTask(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "CreateDelegateMacVolumeOwnershipTask",
	}
}
