/*********************                                                        */
/*! \file module_template.cpp
 ** \verbatim
 ** Top contributors (to current version):
 **   Mathias Preiner
 ** This file is part of the CVC4 project.
 ** Copyright (c) 2009-2020 by the authors listed in the file AUTHORS
 ** in the top-level source directory) and their institutional affiliations.
 ** All rights reserved.  See the file COPYING in the top-level source
 ** directory for licensing information.\endverbatim
 **
 ** \brief Option template for option modules.
 **
 ** For each <module>_options.toml configuration file, mkoptions.py
 ** expands this template and generates a <module>_options.cpp file.
 **/

#include "options/options_holder.h"
#include "base/check.h"

namespace CVC4 {

template <> void Options::set(
    options::assignFunctionValues__option_t,
    const options::assignFunctionValues__option_t::type& x)
{
  d_holder->assignFunctionValues = x;
}
template <> const options::assignFunctionValues__option_t::type& Options::operator[](
    options::assignFunctionValues__option_t) const
{
  return d_holder->assignFunctionValues;
}
template <> bool Options::wasSetByUser(options::assignFunctionValues__option_t) const
{
  return d_holder->assignFunctionValues__setByUser__;
}
template <> const options::condenseFunctionValues__option_t::type& Options::operator[](
    options::condenseFunctionValues__option_t) const
{
  return d_holder->condenseFunctionValues;
}
template <> bool Options::wasSetByUser(options::condenseFunctionValues__option_t) const
{
  return d_holder->condenseFunctionValues__setByUser__;
}
template <> void Options::set(
    options::theoryOfMode__option_t,
    const options::theoryOfMode__option_t::type& x)
{
  d_holder->theoryOfMode = x;
}
template <> const options::theoryOfMode__option_t::type& Options::operator[](
    options::theoryOfMode__option_t) const
{
  return d_holder->theoryOfMode;
}
template <> bool Options::wasSetByUser(options::theoryOfMode__option_t) const
{
  return d_holder->theoryOfMode__setByUser__;
}


namespace options {

struct assignFunctionValues__option_t assignFunctionValues;
struct condenseFunctionValues__option_t condenseFunctionValues;
struct theoryOfMode__option_t theoryOfMode;


std::ostream&
operator<<(std::ostream& os, TheoryOfMode mode)
{
  os << "TheoryOfMode::";
  switch(mode) {
    case TheoryOfMode::THEORY_OF_TYPE_BASED:
      os << "THEORY_OF_TYPE_BASED";
      break;
    case TheoryOfMode::THEORY_OF_TERM_BASED:
      os << "THEORY_OF_TERM_BASED";
      break;
    default:
        Unreachable();
  }
  return os;
}

TheoryOfMode
stringToTheoryOfMode(const std::string& option, const std::string& optarg)
{
  if (optarg == "type")
  {
    return TheoryOfMode::THEORY_OF_TYPE_BASED;
  }
  else if (optarg == "term")
  {
    return TheoryOfMode::THEORY_OF_TERM_BASED;
  }
  else if (optarg == "help")
  {
    puts("Defines how we associate theories with terms.\n"
         "Available modes for --theoryof-mode are:\n"
         "+ type (default)\n"
         "  Type variables, constants and equalities by type.\n"
         "+ term\n"
         "  Type variables as uninterpreted, type constants by theory, equalities by the\n"
         "  parametric theory.\n");
    exit(1);
  }
  else
  {
    throw OptionException(std::string("unknown option for --theoryof-mode: `") +
                          optarg + "'.  Try --theoryof-mode=help.");
  }
}


}  // namespace options
}  // namespace CVC4
