/*********************                                                        */
/*! \file module_template.h
 ** \verbatim
 ** Top contributors (to current version):
 **   Mathias Preiner
 ** This file is part of the CVC4 project.
 ** Copyright (c) 2009-2020 by the authors listed in the file AUTHORS
 ** in the top-level source directory) and their institutional affiliations.
 ** All rights reserved.  See the file COPYING in the top-level source
 ** directory for licensing information.\endverbatim
 **
 ** \brief Contains code for handling command-line options.
 **
 ** For each <module>_options.toml configuration file, mkoptions.py
 ** expands this template and generates a <module>_options.h file.
 **/

#include "cvc4_private.h"

#ifndef CVC4__OPTIONS__STRINGS_H
#define CVC4__OPTIONS__STRINGS_H

#include "options/options.h"




#define CVC4_OPTIONS__STRINGS__FOR_OPTION_HOLDER \
  regExpElim__option_t::type regExpElim;\
  bool regExpElim__setByUser__; \
  regExpElimAgg__option_t::type regExpElimAgg;\
  bool regExpElimAgg__setByUser__; \
  stringRegExpInterMode__option_t::type stringRegExpInterMode;\
  bool stringRegExpInterMode__setByUser__; \
  stringCheckEntailLen__option_t::type stringCheckEntailLen;\
  bool stringCheckEntailLen__setByUser__; \
  stringEager__option_t::type stringEager;\
  bool stringEager__setByUser__; \
  stringEagerLen__option_t::type stringEagerLen;\
  bool stringEagerLen__setByUser__; \
  stringExp__option_t::type stringExp;\
  bool stringExp__setByUser__; \
  stringFlatForms__option_t::type stringFlatForms;\
  bool stringFlatForms__setByUser__; \
  stringFMF__option_t::type stringFMF;\
  bool stringFMF__setByUser__; \
  stringGuessModel__option_t::type stringGuessModel;\
  bool stringGuessModel__setByUser__; \
  stringInferAsLemmas__option_t::type stringInferAsLemmas;\
  bool stringInferAsLemmas__setByUser__; \
  stringInferSym__option_t::type stringInferSym;\
  bool stringInferSym__setByUser__; \
  stringIgnNegMembership__option_t::type stringIgnNegMembership;\
  bool stringIgnNegMembership__setByUser__; \
  stringLazyPreproc__option_t::type stringLazyPreproc;\
  bool stringLazyPreproc__setByUser__; \
  stringLenNorm__option_t::type stringLenNorm;\
  bool stringLenNorm__setByUser__; \
  stringLenPropCsp__option_t::type stringLenPropCsp;\
  bool stringLenPropCsp__setByUser__; \
  stringMinPrefixExplain__option_t::type stringMinPrefixExplain;\
  bool stringMinPrefixExplain__setByUser__; \
  stdPrintASCII__option_t::type stdPrintASCII;\
  bool stdPrintASCII__setByUser__; \
  stringProcessLoopMode__option_t::type stringProcessLoopMode;\
  bool stringProcessLoopMode__setByUser__; \
  stringRExplainLemmas__option_t::type stringRExplainLemmas;\
  bool stringRExplainLemmas__setByUser__;


namespace CVC4 {

namespace options {


enum class RegExpInterMode
{
  ALL,
  CONSTANT,
  ONE_CONSTANT,
  NONE
};
std::ostream&
operator<<(std::ostream& os, RegExpInterMode mode) CVC4_PUBLIC;
RegExpInterMode
stringToRegExpInterMode(const std::string& option, const std::string& optarg);
enum class ProcessLoopMode
{
  FULL,
  SIMPLE,
  SIMPLE_ABORT,
  NONE,
  ABORT
};
std::ostream&
operator<<(std::ostream& os, ProcessLoopMode mode) CVC4_PUBLIC;
ProcessLoopMode
stringToProcessLoopMode(const std::string& option, const std::string& optarg);

extern struct CVC4_PUBLIC regExpElim__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
  void set(const type& v);
} regExpElim CVC4_PUBLIC;
extern struct CVC4_PUBLIC regExpElimAgg__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
  void set(const type& v);
} regExpElimAgg CVC4_PUBLIC;
extern struct CVC4_PUBLIC stringRegExpInterMode__option_t
{
  typedef RegExpInterMode type;
  type operator()() const;
  bool wasSetByUser() const;
  void set(const type& v);
} stringRegExpInterMode CVC4_PUBLIC;
extern struct CVC4_PUBLIC stringCheckEntailLen__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
} stringCheckEntailLen CVC4_PUBLIC;
extern struct CVC4_PUBLIC stringEager__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
} stringEager CVC4_PUBLIC;
extern struct CVC4_PUBLIC stringEagerLen__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
} stringEagerLen CVC4_PUBLIC;
extern struct CVC4_PUBLIC stringExp__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
  void set(const type& v);
} stringExp CVC4_PUBLIC;
extern struct CVC4_PUBLIC stringFlatForms__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
} stringFlatForms CVC4_PUBLIC;
extern struct CVC4_PUBLIC stringFMF__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
  void set(const type& v);
} stringFMF CVC4_PUBLIC;
extern struct CVC4_PUBLIC stringGuessModel__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
} stringGuessModel CVC4_PUBLIC;
extern struct CVC4_PUBLIC stringInferAsLemmas__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
} stringInferAsLemmas CVC4_PUBLIC;
extern struct CVC4_PUBLIC stringInferSym__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
} stringInferSym CVC4_PUBLIC;
extern struct CVC4_PUBLIC stringIgnNegMembership__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
} stringIgnNegMembership CVC4_PUBLIC;
extern struct CVC4_PUBLIC stringLazyPreproc__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
} stringLazyPreproc CVC4_PUBLIC;
extern struct CVC4_PUBLIC stringLenNorm__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
} stringLenNorm CVC4_PUBLIC;
extern struct CVC4_PUBLIC stringLenPropCsp__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
} stringLenPropCsp CVC4_PUBLIC;
extern struct CVC4_PUBLIC stringMinPrefixExplain__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
} stringMinPrefixExplain CVC4_PUBLIC;
extern struct CVC4_PUBLIC stdPrintASCII__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
} stdPrintASCII CVC4_PUBLIC;
extern struct CVC4_PUBLIC stringProcessLoopMode__option_t
{
  typedef ProcessLoopMode type;
  type operator()() const;
  bool wasSetByUser() const;
  void set(const type& v);
} stringProcessLoopMode CVC4_PUBLIC;
extern struct CVC4_PUBLIC stringRExplainLemmas__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
} stringRExplainLemmas CVC4_PUBLIC;

}  // namespace options

template <> void Options::set(
    options::regExpElim__option_t,
    const options::regExpElim__option_t::type& x);
template <> const options::regExpElim__option_t::type& Options::operator[](
    options::regExpElim__option_t) const;
template <> bool Options::wasSetByUser(options::regExpElim__option_t) const;
template <> void Options::assignBool(
    options::regExpElim__option_t,
    std::string option,
    bool value);
template <> void Options::set(
    options::regExpElimAgg__option_t,
    const options::regExpElimAgg__option_t::type& x);
template <> const options::regExpElimAgg__option_t::type& Options::operator[](
    options::regExpElimAgg__option_t) const;
template <> bool Options::wasSetByUser(options::regExpElimAgg__option_t) const;
template <> void Options::assignBool(
    options::regExpElimAgg__option_t,
    std::string option,
    bool value);
template <> void Options::set(
    options::stringRegExpInterMode__option_t,
    const options::stringRegExpInterMode__option_t::type& x);
template <> const options::stringRegExpInterMode__option_t::type& Options::operator[](
    options::stringRegExpInterMode__option_t) const;
template <> bool Options::wasSetByUser(options::stringRegExpInterMode__option_t) const;
template <> void Options::assign(
    options::stringRegExpInterMode__option_t,
    std::string option,
    std::string value);
template <> const options::stringCheckEntailLen__option_t::type& Options::operator[](
    options::stringCheckEntailLen__option_t) const;
template <> bool Options::wasSetByUser(options::stringCheckEntailLen__option_t) const;
template <> void Options::assignBool(
    options::stringCheckEntailLen__option_t,
    std::string option,
    bool value);
template <> const options::stringEager__option_t::type& Options::operator[](
    options::stringEager__option_t) const;
template <> bool Options::wasSetByUser(options::stringEager__option_t) const;
template <> void Options::assignBool(
    options::stringEager__option_t,
    std::string option,
    bool value);
template <> const options::stringEagerLen__option_t::type& Options::operator[](
    options::stringEagerLen__option_t) const;
template <> bool Options::wasSetByUser(options::stringEagerLen__option_t) const;
template <> void Options::assignBool(
    options::stringEagerLen__option_t,
    std::string option,
    bool value);
template <> void Options::set(
    options::stringExp__option_t,
    const options::stringExp__option_t::type& x);
template <> const options::stringExp__option_t::type& Options::operator[](
    options::stringExp__option_t) const;
template <> bool Options::wasSetByUser(options::stringExp__option_t) const;
template <> void Options::assignBool(
    options::stringExp__option_t,
    std::string option,
    bool value);
template <> const options::stringFlatForms__option_t::type& Options::operator[](
    options::stringFlatForms__option_t) const;
template <> bool Options::wasSetByUser(options::stringFlatForms__option_t) const;
template <> void Options::assignBool(
    options::stringFlatForms__option_t,
    std::string option,
    bool value);
template <> void Options::set(
    options::stringFMF__option_t,
    const options::stringFMF__option_t::type& x);
template <> const options::stringFMF__option_t::type& Options::operator[](
    options::stringFMF__option_t) const;
template <> bool Options::wasSetByUser(options::stringFMF__option_t) const;
template <> void Options::assignBool(
    options::stringFMF__option_t,
    std::string option,
    bool value);
template <> const options::stringGuessModel__option_t::type& Options::operator[](
    options::stringGuessModel__option_t) const;
template <> bool Options::wasSetByUser(options::stringGuessModel__option_t) const;
template <> void Options::assignBool(
    options::stringGuessModel__option_t,
    std::string option,
    bool value);
template <> const options::stringInferAsLemmas__option_t::type& Options::operator[](
    options::stringInferAsLemmas__option_t) const;
template <> bool Options::wasSetByUser(options::stringInferAsLemmas__option_t) const;
template <> void Options::assignBool(
    options::stringInferAsLemmas__option_t,
    std::string option,
    bool value);
template <> const options::stringInferSym__option_t::type& Options::operator[](
    options::stringInferSym__option_t) const;
template <> bool Options::wasSetByUser(options::stringInferSym__option_t) const;
template <> void Options::assignBool(
    options::stringInferSym__option_t,
    std::string option,
    bool value);
template <> const options::stringIgnNegMembership__option_t::type& Options::operator[](
    options::stringIgnNegMembership__option_t) const;
template <> bool Options::wasSetByUser(options::stringIgnNegMembership__option_t) const;
template <> void Options::assignBool(
    options::stringIgnNegMembership__option_t,
    std::string option,
    bool value);
template <> const options::stringLazyPreproc__option_t::type& Options::operator[](
    options::stringLazyPreproc__option_t) const;
template <> bool Options::wasSetByUser(options::stringLazyPreproc__option_t) const;
template <> void Options::assignBool(
    options::stringLazyPreproc__option_t,
    std::string option,
    bool value);
template <> const options::stringLenNorm__option_t::type& Options::operator[](
    options::stringLenNorm__option_t) const;
template <> bool Options::wasSetByUser(options::stringLenNorm__option_t) const;
template <> void Options::assignBool(
    options::stringLenNorm__option_t,
    std::string option,
    bool value);
template <> const options::stringLenPropCsp__option_t::type& Options::operator[](
    options::stringLenPropCsp__option_t) const;
template <> bool Options::wasSetByUser(options::stringLenPropCsp__option_t) const;
template <> void Options::assignBool(
    options::stringLenPropCsp__option_t,
    std::string option,
    bool value);
template <> const options::stringMinPrefixExplain__option_t::type& Options::operator[](
    options::stringMinPrefixExplain__option_t) const;
template <> bool Options::wasSetByUser(options::stringMinPrefixExplain__option_t) const;
template <> void Options::assignBool(
    options::stringMinPrefixExplain__option_t,
    std::string option,
    bool value);
template <> const options::stdPrintASCII__option_t::type& Options::operator[](
    options::stdPrintASCII__option_t) const;
template <> bool Options::wasSetByUser(options::stdPrintASCII__option_t) const;
template <> void Options::assignBool(
    options::stdPrintASCII__option_t,
    std::string option,
    bool value);
template <> void Options::set(
    options::stringProcessLoopMode__option_t,
    const options::stringProcessLoopMode__option_t::type& x);
template <> const options::stringProcessLoopMode__option_t::type& Options::operator[](
    options::stringProcessLoopMode__option_t) const;
template <> bool Options::wasSetByUser(options::stringProcessLoopMode__option_t) const;
template <> void Options::assign(
    options::stringProcessLoopMode__option_t,
    std::string option,
    std::string value);
template <> const options::stringRExplainLemmas__option_t::type& Options::operator[](
    options::stringRExplainLemmas__option_t) const;
template <> bool Options::wasSetByUser(options::stringRExplainLemmas__option_t) const;
template <> void Options::assignBool(
    options::stringRExplainLemmas__option_t,
    std::string option,
    bool value);


namespace options {

inline regExpElim__option_t::type regExpElim__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool regExpElim__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline void regExpElim__option_t::set(const regExpElim__option_t::type& v)
{
  Options::current()->set(*this, v);
}
inline regExpElimAgg__option_t::type regExpElimAgg__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool regExpElimAgg__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline void regExpElimAgg__option_t::set(const regExpElimAgg__option_t::type& v)
{
  Options::current()->set(*this, v);
}
inline stringRegExpInterMode__option_t::type stringRegExpInterMode__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool stringRegExpInterMode__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline void stringRegExpInterMode__option_t::set(const stringRegExpInterMode__option_t::type& v)
{
  Options::current()->set(*this, v);
}
inline stringCheckEntailLen__option_t::type stringCheckEntailLen__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool stringCheckEntailLen__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline stringEager__option_t::type stringEager__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool stringEager__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline stringEagerLen__option_t::type stringEagerLen__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool stringEagerLen__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline stringExp__option_t::type stringExp__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool stringExp__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline void stringExp__option_t::set(const stringExp__option_t::type& v)
{
  Options::current()->set(*this, v);
}
inline stringFlatForms__option_t::type stringFlatForms__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool stringFlatForms__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline stringFMF__option_t::type stringFMF__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool stringFMF__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline void stringFMF__option_t::set(const stringFMF__option_t::type& v)
{
  Options::current()->set(*this, v);
}
inline stringGuessModel__option_t::type stringGuessModel__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool stringGuessModel__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline stringInferAsLemmas__option_t::type stringInferAsLemmas__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool stringInferAsLemmas__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline stringInferSym__option_t::type stringInferSym__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool stringInferSym__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline stringIgnNegMembership__option_t::type stringIgnNegMembership__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool stringIgnNegMembership__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline stringLazyPreproc__option_t::type stringLazyPreproc__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool stringLazyPreproc__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline stringLenNorm__option_t::type stringLenNorm__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool stringLenNorm__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline stringLenPropCsp__option_t::type stringLenPropCsp__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool stringLenPropCsp__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline stringMinPrefixExplain__option_t::type stringMinPrefixExplain__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool stringMinPrefixExplain__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline stdPrintASCII__option_t::type stdPrintASCII__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool stdPrintASCII__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline stringProcessLoopMode__option_t::type stringProcessLoopMode__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool stringProcessLoopMode__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline void stringProcessLoopMode__option_t::set(const stringProcessLoopMode__option_t::type& v)
{
  Options::current()->set(*this, v);
}
inline stringRExplainLemmas__option_t::type stringRExplainLemmas__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool stringRExplainLemmas__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}

}  // namespace options
}  // namespace CVC4

#endif /* CVC4__OPTIONS__STRINGS_H */
