/*********************                                                        */
/*! \file module_template.cpp
 ** \verbatim
 ** Top contributors (to current version):
 **   Mathias Preiner
 ** This file is part of the CVC4 project.
 ** Copyright (c) 2009-2020 by the authors listed in the file AUTHORS
 ** in the top-level source directory) and their institutional affiliations.
 ** All rights reserved.  See the file COPYING in the top-level source
 ** directory for licensing information.\endverbatim
 **
 ** \brief Option template for option modules.
 **
 ** For each <module>_options.toml configuration file, mkoptions.py
 ** expands this template and generates a <module>_options.cpp file.
 **/

#include "options/options_holder.h"
#include "base/check.h"

namespace CVC4 {

template <> const options::decisionRandomWeight__option_t::type& Options::operator[](
    options::decisionRandomWeight__option_t) const
{
  return d_holder->decisionRandomWeight;
}
template <> bool Options::wasSetByUser(options::decisionRandomWeight__option_t) const
{
  return d_holder->decisionRandomWeight__setByUser__;
}
template <> const options::decisionThreshold__option_t::type& Options::operator[](
    options::decisionThreshold__option_t) const
{
  return d_holder->decisionThreshold;
}
template <> bool Options::wasSetByUser(options::decisionThreshold__option_t) const
{
  return d_holder->decisionThreshold__setByUser__;
}
template <> const options::decisionUseWeight__option_t::type& Options::operator[](
    options::decisionUseWeight__option_t) const
{
  return d_holder->decisionUseWeight;
}
template <> bool Options::wasSetByUser(options::decisionUseWeight__option_t) const
{
  return d_holder->decisionUseWeight__setByUser__;
}
template <> const options::decisionWeightInternal__option_t::type& Options::operator[](
    options::decisionWeightInternal__option_t) const
{
  return d_holder->decisionWeightInternal;
}
template <> bool Options::wasSetByUser(options::decisionWeightInternal__option_t) const
{
  return d_holder->decisionWeightInternal__setByUser__;
}
template <> void Options::set(
    options::decisionMode__option_t,
    const options::decisionMode__option_t::type& x)
{
  d_holder->decisionMode = x;
}
template <> const options::decisionMode__option_t::type& Options::operator[](
    options::decisionMode__option_t) const
{
  return d_holder->decisionMode;
}
template <> bool Options::wasSetByUser(options::decisionMode__option_t) const
{
  return d_holder->decisionMode__setByUser__;
}
template <> void Options::set(
    options::decisionStopOnly__option_t,
    const options::decisionStopOnly__option_t::type& x)
{
  d_holder->decisionStopOnly = x;
}
template <> const options::decisionStopOnly__option_t::type& Options::operator[](
    options::decisionStopOnly__option_t) const
{
  return d_holder->decisionStopOnly;
}
template <> bool Options::wasSetByUser(options::decisionStopOnly__option_t) const
{
  return d_holder->decisionStopOnly__setByUser__;
}


namespace options {

struct decisionRandomWeight__option_t decisionRandomWeight;
struct decisionThreshold__option_t decisionThreshold;
struct decisionUseWeight__option_t decisionUseWeight;
struct decisionWeightInternal__option_t decisionWeightInternal;
struct decisionMode__option_t decisionMode;
struct decisionStopOnly__option_t decisionStopOnly;


std::ostream&
operator<<(std::ostream& os, DecisionWeightInternal mode)
{
  os << "DecisionWeightInternal::";
  switch(mode) {
    case DecisionWeightInternal::OFF:
      os << "OFF";
      break;
    case DecisionWeightInternal::MAX:
      os << "MAX";
      break;
    case DecisionWeightInternal::SUM:
      os << "SUM";
      break;
    case DecisionWeightInternal::USR1:
      os << "USR1";
      break;
    default:
        Unreachable();
  }
  return os;
}

DecisionWeightInternal
stringToDecisionWeightInternal(const std::string& option, const std::string& optarg)
{
  if (optarg == "off")
  {
    return DecisionWeightInternal::OFF;
  }
  else if (optarg == "max")
  {
    return DecisionWeightInternal::MAX;
  }
  else if (optarg == "sum")
  {
    return DecisionWeightInternal::SUM;
  }
  else if (optarg == "usr1")
  {
    return DecisionWeightInternal::USR1;
  }
  else if (optarg == "help")
  {
    puts("Decision weight internal mode.\n"
         "Available modes for --decision-weight-internal are:\n"
         "+ off (default)\n"
         "+ max\n"
         "+ sum\n"
         "+ usr1\n");
    exit(1);
  }
  else
  {
    throw OptionException(std::string("unknown option for --decision-weight-internal: `") +
                          optarg + "'.  Try --decision-weight-internal=help.");
  }
}

std::ostream&
operator<<(std::ostream& os, DecisionMode mode)
{
  os << "DecisionMode::";
  switch(mode) {
    case DecisionMode::INTERNAL:
      os << "INTERNAL";
      break;
    case DecisionMode::JUSTIFICATION:
      os << "JUSTIFICATION";
      break;
    case DecisionMode::RELEVANCY:
      os << "RELEVANCY";
      break;
    default:
        Unreachable();
  }
  return os;
}

DecisionMode
stringToDecisionMode(const std::string& option, const std::string& optarg)
{
  if (optarg == "internal")
  {
    return DecisionMode::INTERNAL;
  }
  else if (optarg == "justification")
  {
    return DecisionMode::JUSTIFICATION;
  }
  else if (optarg == "justification-stoponly")
  {
    return DecisionMode::RELEVANCY;
  }
  else if (optarg == "help")
  {
    puts("Decision modes.\n"
         "Available modes for --decision are:\n"
         "+ internal (default)\n"
         "  Use the internal decision heuristics of the SAT solver.\n"
         "+ justification\n"
         "  An ATGP-inspired justification heuristic.\n"
         "+ justification-stoponly\n"
         "  Use the justification heuristic only to stop early, not for decisions.\n");
    exit(1);
  }
  else
  {
    throw OptionException(std::string("unknown option for --decision: `") +
                          optarg + "'.  Try --decision=help.");
  }
}


}  // namespace options
}  // namespace CVC4
