/* help-page.c generated by valac 0.56.18, the Vala compiler
 * generated from help-page.vala, do not modify */

/* help-page.vala
 *
 * Copyright 2022 Vojtěch Perník
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <adwaita.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <glib/gi18n-lib.h>
#include <gtk/gtk.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define WG_TYPE_HELP_PAGE (wg_help_page_get_type ())
#define WG_HELP_PAGE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), WG_TYPE_HELP_PAGE, WGHelpPage))
#define WG_HELP_PAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), WG_TYPE_HELP_PAGE, WGHelpPageClass))
#define WG_IS_HELP_PAGE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), WG_TYPE_HELP_PAGE))
#define WG_IS_HELP_PAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), WG_TYPE_HELP_PAGE))
#define WG_HELP_PAGE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), WG_TYPE_HELP_PAGE, WGHelpPageClass))

typedef struct _WGHelpPage WGHelpPage;
typedef struct _WGHelpPageClass WGHelpPageClass;
typedef struct _WGHelpPagePrivate WGHelpPagePrivate;
enum  {
	WG_HELP_PAGE_0_PROPERTY,
	WG_HELP_PAGE_NUM_PROPERTIES
};
static GParamSpec* wg_help_page_properties[WG_HELP_PAGE_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
typedef enum  {
	WG_CELL_STATE_CORRECT,
	WG_CELL_STATE_WRONG,
	WG_CELL_STATE_WRONG_POSITION,
	WG_CELL_STATE_UNKNOWN,
	WG_CELL_STATE_NONE
} WGCellState;

#define WG_TYPE_CELL_STATE (wg_cell_state_get_type ())
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define WG_TYPE_CELL (wg_cell_get_type ())
#define WG_CELL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), WG_TYPE_CELL, WGCell))
#define WG_CELL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), WG_TYPE_CELL, WGCellClass))
#define WG_IS_CELL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), WG_TYPE_CELL))
#define WG_IS_CELL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), WG_TYPE_CELL))
#define WG_CELL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), WG_TYPE_CELL, WGCellClass))

typedef struct _WGCell WGCell;
typedef struct _WGCellClass WGCellClass;
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
enum  {
	WG_HELP_PAGE_BACK_SIGNAL,
	WG_HELP_PAGE_NUM_SIGNALS
};
static guint wg_help_page_signals[WG_HELP_PAGE_NUM_SIGNALS] = {0};

struct _WGHelpPage {
	AdwBin parent_instance;
	WGHelpPagePrivate * priv;
};

struct _WGHelpPageClass {
	AdwBinClass parent_class;
};

struct _WGHelpPagePrivate {
	gchar* title;
	gchar* body;
	gchar* correct_word;
	gchar* correct_word_desc;
	gchar* position_word;
	gchar* position_word_desc;
	gchar* wrong_word;
	gchar* wrong_word_desc;
};

static gint WGHelpPage_private_offset;
static gpointer wg_help_page_parent_class = NULL;

VALA_EXTERN GType wg_help_page_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (WGHelpPage, g_object_unref)
VALA_EXTERN GType wg_cell_state_get_type (void) G_GNUC_CONST ;
static GtkWidget* wg_help_page_get_state_preview (WGHelpPage* self,
                                           const gchar* word,
                                           const gchar* desc,
                                           WGCellState state);
static GtkWidget* wg_help_page_get_cells_for_word (WGHelpPage* self,
                                            const gchar* word,
                                            WGCellState state);
VALA_EXTERN GType wg_cell_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (WGCell, g_object_unref)
VALA_EXTERN WGCell* wg_cell_new (void);
VALA_EXTERN WGCell* wg_cell_construct (GType object_type);
VALA_EXTERN void wg_cell_set_state (WGCell* self,
                        WGCellState value);
VALA_EXTERN void wg_cell_set_content (WGCell* self,
                          const gchar* value);
VALA_EXTERN WGHelpPage* wg_help_page_new (void);
VALA_EXTERN WGHelpPage* wg_help_page_construct (GType object_type);
static GObject * wg_help_page_constructor (GType type,
                                    guint n_construct_properties,
                                    GObjectConstructParam * construct_properties);
static gboolean _wg_help_page___lambda17_ (WGHelpPage* self);
static gboolean __wg_help_page___lambda17__gtk_shortcut_func (GtkWidget* widget,
                                                       GVariant* args,
                                                       gpointer self);
static void wg_help_page_finalize (GObject * obj);
static GType wg_help_page_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);

static inline gpointer
wg_help_page_get_instance_private (WGHelpPage* self)
{
	return G_STRUCT_MEMBER_P (self, WGHelpPage_private_offset);
}

/**
     * returns the whole preview widget with the cells and the explanation
     */
static GtkWidget*
wg_help_page_get_state_preview (WGHelpPage* self,
                                const gchar* word,
                                const gchar* desc,
                                WGCellState state)
{
	GtkBox* box = NULL;
	GtkBox* _tmp0_;
	GtkWidget* cells = NULL;
	GtkWidget* _tmp1_;
	GtkLabel* label = NULL;
	GtkLabel* _tmp2_;
	GtkWidget* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (word != NULL, NULL);
	g_return_val_if_fail (desc != NULL, NULL);
	_tmp0_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 12);
	g_object_ref_sink (_tmp0_);
	box = _tmp0_;
	_tmp1_ = wg_help_page_get_cells_for_word (self, word, state);
	cells = _tmp1_;
	gtk_box_append (box, cells);
	gtk_widget_set_halign (cells, GTK_ALIGN_CENTER);
	_tmp2_ = (GtkLabel*) gtk_label_new (desc);
	g_object_ref_sink (_tmp2_);
	label = _tmp2_;
	gtk_box_append (box, (GtkWidget*) label);
	gtk_widget_set_halign ((GtkWidget*) label, GTK_ALIGN_CENTER);
	gtk_label_set_use_markup (label, TRUE);
	result = (GtkWidget*) box;
	_g_object_unref0 (label);
	_g_object_unref0 (cells);
	return result;
}

/**
     * returns widget with the cells for the given word
     */
static gchar*
string_strip (const gchar* self)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	g_strstrip (_result_);
	result = _result_;
	return result;
}

static gchar*
string_replace (const gchar* self,
                const gchar* old,
                const gchar* replacement)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	if ((*((gchar*) self)) == '\0') {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = (*((gchar*) old)) == '\0';
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = g_strcmp0 (old, replacement) == 0;
	}
	if (_tmp0_) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup (self);
		result = _tmp2_;
		return result;
	}
	{
		GRegex* regex = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_;
		GRegex* _tmp5_;
		GRegex* _tmp6_;
		gchar* _tmp7_ = NULL;
		GRegex* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp3_ = g_regex_escape_string (old, -1);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_regex_new (_tmp4_, 0, 0, &_inner_error0_);
		_tmp6_ = _tmp5_;
		_g_free0 (_tmp4_);
		regex = _tmp6_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp8_ = regex;
		_tmp9_ = g_regex_replace_literal (_tmp8_, self, (gssize) -1, 0, replacement, 0, &_inner_error0_);
		_tmp7_ = _tmp9_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_regex_unref0 (regex);
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp10_ = _tmp7_;
		_tmp7_ = NULL;
		result = _tmp10_;
		_g_free0 (_tmp7_);
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally0;
	__catch0_g_regex_error:
	{
		g_clear_error (&_inner_error0_);
		g_assert_not_reached ();
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return NULL;
}

static GtkWidget*
wg_help_page_get_cells_for_word (WGHelpPage* self,
                                 const gchar* word,
                                 WGCellState state)
{
	GtkBox* box = NULL;
	GtkBox* _tmp0_;
	gchar** _word = NULL;
	gchar** _tmp1_;
	gchar** _tmp2_;
	gint _word_length1;
	gint __word_size_;
	gchar** _tmp3_;
	gint _tmp3__length1;
	GtkWidget* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (word != NULL, NULL);
	_tmp0_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 6);
	g_object_ref_sink (_tmp0_);
	box = _tmp0_;
	_tmp2_ = _tmp1_ = g_strsplit (word, "/", 0);
	_word = _tmp2_;
	_word_length1 = _vala_array_length (_tmp1_);
	__word_size_ = _word_length1;
	_tmp3_ = _word;
	_tmp3__length1 = _word_length1;
	{
		gchar** _cell_collection = NULL;
		gint _cell_collection_length1 = 0;
		gint __cell_collection_size_ = 0;
		gint _cell_it = 0;
		_cell_collection = _tmp3_;
		_cell_collection_length1 = _tmp3__length1;
		for (_cell_it = 0; _cell_it < _cell_collection_length1; _cell_it = _cell_it + 1) {
			gchar* _tmp4_;
			gchar* _cell = NULL;
			_tmp4_ = g_strdup (_cell_collection[_cell_it]);
			_cell = _tmp4_;
			{
				const gchar* _tmp5_;
				gchar* _tmp6_;
				WGCell* cell = NULL;
				WGCell* _tmp7_;
				const gchar* _tmp8_;
				WGCell* _tmp14_;
				const gchar* _tmp15_;
				gchar* _tmp16_;
				gchar* _tmp17_;
				GtkBox* _tmp18_;
				WGCell* _tmp19_;
				_tmp5_ = _cell;
				_tmp6_ = string_strip (_tmp5_);
				_g_free0 (_cell);
				_cell = _tmp6_;
				_tmp7_ = wg_cell_new ();
				g_object_ref_sink (_tmp7_);
				cell = _tmp7_;
				_tmp8_ = _cell;
				if (g_str_has_prefix (_tmp8_, "!")) {
					WGCell* _tmp9_;
					const gchar* _tmp10_;
					gchar* _tmp11_;
					gchar* _tmp12_;
					gchar* _tmp13_;
					_tmp9_ = cell;
					wg_cell_set_state (_tmp9_, state);
					_tmp10_ = _cell;
					_tmp11_ = string_replace (_tmp10_, "!", "");
					_tmp12_ = _tmp11_;
					_tmp13_ = string_strip (_tmp12_);
					_g_free0 (_cell);
					_cell = _tmp13_;
					_g_free0 (_tmp12_);
				}
				_tmp14_ = cell;
				_tmp15_ = _cell;
				_tmp16_ = g_utf8_strup (_tmp15_, (gssize) -1);
				_tmp17_ = _tmp16_;
				wg_cell_set_content (_tmp14_, _tmp17_);
				_g_free0 (_tmp17_);
				_tmp18_ = box;
				_tmp19_ = cell;
				gtk_box_append (_tmp18_, (GtkWidget*) _tmp19_);
				_g_object_unref0 (cell);
				_g_free0 (_cell);
			}
		}
	}
	result = (GtkWidget*) box;
	_word = (_vala_array_free (_word, _word_length1, (GDestroyNotify) g_free), NULL);
	return result;
}

WGHelpPage*
wg_help_page_construct (GType object_type)
{
	WGHelpPage * self = NULL;
	self = (WGHelpPage*) g_object_new (object_type, NULL);
	return self;
}

WGHelpPage*
wg_help_page_new (void)
{
	return wg_help_page_construct (WG_TYPE_HELP_PAGE);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static gboolean
_wg_help_page___lambda17_ (WGHelpPage* self)
{
	g_signal_emit (self, wg_help_page_signals[WG_HELP_PAGE_BACK_SIGNAL], 0);
}

static gboolean
__wg_help_page___lambda17__gtk_shortcut_func (GtkWidget* widget,
                                              GVariant* args,
                                              gpointer self)
{
	gboolean result;
	result = _wg_help_page___lambda17_ ((WGHelpPage*) self);
	return result;
}

static GObject *
wg_help_page_constructor (GType type,
                          guint n_construct_properties,
                          GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	WGHelpPage * self;
	GtkShortcutController* shortcut_controller = NULL;
	GtkShortcutController* _tmp0_;
	GtkShortcutController* _tmp1_;
	GtkEventController* _tmp2_;
	GtkShortcutController* _tmp3_;
	GtkShortcutController* _tmp4_;
	GtkShortcutTrigger* _tmp5_;
	GtkCallbackAction* _tmp6_;
	GtkShortcut* _tmp7_;
	GtkScrolledWindow* scrolled_window = NULL;
	GtkScrolledWindow* _tmp8_;
	GtkScrolledWindow* _tmp9_;
	GtkViewport* viewport = NULL;
	GtkViewport* _tmp10_;
	GtkScrolledWindow* _tmp11_;
	GtkViewport* _tmp12_;
	AdwClamp* clamp = NULL;
	AdwClamp* _tmp13_;
	GtkViewport* _tmp14_;
	AdwClamp* _tmp15_;
	AdwClamp* _tmp16_;
	AdwClamp* _tmp17_;
	AdwClamp* _tmp18_;
	GtkBox* main_box = NULL;
	GtkBox* _tmp19_;
	AdwClamp* _tmp20_;
	GtkBox* _tmp21_;
	GtkBox* _tmp22_;
	GtkLabel* title_label = NULL;
	const gchar* _tmp23_;
	GtkLabel* _tmp24_;
	GtkBox* _tmp25_;
	GtkLabel* _tmp26_;
	GtkLabel* _tmp27_;
	GtkLabel* _tmp28_;
	GtkLabel* body_label = NULL;
	const gchar* _tmp29_;
	GtkLabel* _tmp30_;
	GtkBox* _tmp31_;
	GtkLabel* _tmp32_;
	GtkLabel* _tmp33_;
	GtkLabel* _tmp34_;
	GtkLabel* _tmp35_;
	GtkLabel* _tmp36_;
	GtkBox* _tmp37_;
	const gchar* _tmp38_;
	const gchar* _tmp39_;
	GtkWidget* _tmp40_;
	GtkWidget* _tmp41_;
	GtkBox* _tmp42_;
	const gchar* _tmp43_;
	const gchar* _tmp44_;
	GtkWidget* _tmp45_;
	GtkWidget* _tmp46_;
	GtkBox* _tmp47_;
	const gchar* _tmp48_;
	const gchar* _tmp49_;
	GtkWidget* _tmp50_;
	GtkWidget* _tmp51_;
	parent_class = G_OBJECT_CLASS (wg_help_page_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, WG_TYPE_HELP_PAGE, WGHelpPage);
	_tmp0_ = (GtkShortcutController*) gtk_shortcut_controller_new ();
	shortcut_controller = _tmp0_;
	_tmp1_ = shortcut_controller;
	_tmp2_ = _g_object_ref0 ((GtkEventController*) _tmp1_);
	gtk_widget_add_controller ((GtkWidget*) self, _tmp2_);
	_tmp3_ = shortcut_controller;
	gtk_shortcut_controller_set_scope (_tmp3_, GTK_SHORTCUT_SCOPE_GLOBAL);
	_tmp4_ = shortcut_controller;
	_tmp5_ = gtk_shortcut_trigger_parse_string ("Escape");
	_tmp6_ = (GtkCallbackAction*) gtk_callback_action_new (__wg_help_page___lambda17__gtk_shortcut_func, g_object_ref (self), g_object_unref);
	_tmp7_ = gtk_shortcut_new (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, gtk_shortcut_trigger_get_type (), GtkShortcutTrigger), (GtkShortcutAction*) _tmp6_);
	gtk_shortcut_controller_add_shortcut (_tmp4_, _tmp7_);
	gtk_widget_set_vexpand ((GtkWidget*) self, TRUE);
	_tmp8_ = (GtkScrolledWindow*) gtk_scrolled_window_new ();
	g_object_ref_sink (_tmp8_);
	scrolled_window = _tmp8_;
	_tmp9_ = scrolled_window;
	adw_bin_set_child ((AdwBin*) self, (GtkWidget*) _tmp9_);
	_tmp10_ = (GtkViewport*) gtk_viewport_new (NULL, NULL);
	g_object_ref_sink (_tmp10_);
	viewport = _tmp10_;
	_tmp11_ = scrolled_window;
	_tmp12_ = viewport;
	gtk_scrolled_window_set_child (_tmp11_, (GtkWidget*) _tmp12_);
	_tmp13_ = (AdwClamp*) adw_clamp_new ();
	g_object_ref_sink (_tmp13_);
	clamp = _tmp13_;
	_tmp14_ = viewport;
	_tmp15_ = clamp;
	gtk_viewport_set_child (_tmp14_, (GtkWidget*) _tmp15_);
	_tmp16_ = clamp;
	adw_clamp_set_tightening_threshold (_tmp16_, 400);
	_tmp17_ = clamp;
	adw_clamp_set_maximum_size (_tmp17_, 600);
	_tmp18_ = clamp;
	gtk_widget_add_css_class ((GtkWidget*) _tmp18_, "container");
	_tmp19_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 32);
	g_object_ref_sink (_tmp19_);
	main_box = _tmp19_;
	_tmp20_ = clamp;
	_tmp21_ = main_box;
	adw_clamp_set_child (_tmp20_, (GtkWidget*) _tmp21_);
	_tmp22_ = main_box;
	gtk_widget_set_valign ((GtkWidget*) _tmp22_, GTK_ALIGN_CENTER);
	_tmp23_ = self->priv->title;
	_tmp24_ = (GtkLabel*) gtk_label_new (_tmp23_);
	g_object_ref_sink (_tmp24_);
	title_label = _tmp24_;
	_tmp25_ = main_box;
	_tmp26_ = title_label;
	gtk_box_append (_tmp25_, (GtkWidget*) _tmp26_);
	_tmp27_ = title_label;
	gtk_widget_set_halign ((GtkWidget*) _tmp27_, GTK_ALIGN_CENTER);
	_tmp28_ = title_label;
	gtk_widget_add_css_class ((GtkWidget*) _tmp28_, "title-1");
	_tmp29_ = self->priv->body;
	_tmp30_ = (GtkLabel*) gtk_label_new (_tmp29_);
	g_object_ref_sink (_tmp30_);
	body_label = _tmp30_;
	_tmp31_ = main_box;
	_tmp32_ = body_label;
	gtk_box_append (_tmp31_, (GtkWidget*) _tmp32_);
	_tmp33_ = body_label;
	gtk_widget_set_halign ((GtkWidget*) _tmp33_, GTK_ALIGN_CENTER);
	_tmp34_ = body_label;
	gtk_label_set_wrap (_tmp34_, TRUE);
	_tmp35_ = body_label;
	gtk_label_set_use_markup (_tmp35_, TRUE);
	_tmp36_ = body_label;
	gtk_label_set_justify (_tmp36_, GTK_JUSTIFY_CENTER);
	_tmp37_ = main_box;
	_tmp38_ = self->priv->correct_word;
	_tmp39_ = self->priv->correct_word_desc;
	_tmp40_ = wg_help_page_get_state_preview (self, _tmp38_, _tmp39_, WG_CELL_STATE_CORRECT);
	_tmp41_ = _tmp40_;
	gtk_box_append (_tmp37_, _tmp41_);
	_g_object_unref0 (_tmp41_);
	_tmp42_ = main_box;
	_tmp43_ = self->priv->position_word;
	_tmp44_ = self->priv->position_word_desc;
	_tmp45_ = wg_help_page_get_state_preview (self, _tmp43_, _tmp44_, WG_CELL_STATE_WRONG_POSITION);
	_tmp46_ = _tmp45_;
	gtk_box_append (_tmp42_, _tmp46_);
	_g_object_unref0 (_tmp46_);
	_tmp47_ = main_box;
	_tmp48_ = self->priv->wrong_word;
	_tmp49_ = self->priv->wrong_word_desc;
	_tmp50_ = wg_help_page_get_state_preview (self, _tmp48_, _tmp49_, WG_CELL_STATE_WRONG);
	_tmp51_ = _tmp50_;
	gtk_box_append (_tmp47_, _tmp51_);
	_g_object_unref0 (_tmp51_);
	_g_object_unref0 (body_label);
	_g_object_unref0 (title_label);
	_g_object_unref0 (main_box);
	_g_object_unref0 (clamp);
	_g_object_unref0 (viewport);
	_g_object_unref0 (scrolled_window);
	_g_object_unref0 (shortcut_controller);
	return obj;
}

static void
wg_help_page_class_init (WGHelpPageClass * klass,
                         gpointer klass_data)
{
	wg_help_page_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &WGHelpPage_private_offset);
	G_OBJECT_CLASS (klass)->constructor = wg_help_page_constructor;
	G_OBJECT_CLASS (klass)->finalize = wg_help_page_finalize;
	wg_help_page_signals[WG_HELP_PAGE_BACK_SIGNAL] = g_signal_new ("back", WG_TYPE_HELP_PAGE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}

static void
wg_help_page_instance_init (WGHelpPage * self,
                            gpointer klass)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	self->priv = wg_help_page_get_instance_private (self);
	_tmp0_ = g_strdup (_ ("Help"));
	self->priv->title = _tmp0_;
	_tmp1_ = g_strdup (_ ("The game consists of <b>guessing words</b> five characters long. " "You try to enter your guesses one by one, pressing Enter after each " "one.\n\n" "After confirmation, the cell <b>color changes</b> to indicate how " "close you are to the word you are looking for with your guess:"));
	self->priv->body = _tmp1_;
	_tmp2_ = g_strdup (C_ ("Preview of the word cells", "!w/e/a/r/y"));
	self->priv->correct_word = _tmp2_;
	_tmp3_ = g_strdup (_ ("<b>W</b> is in the word and in the correct spot."));
	self->priv->correct_word_desc = _tmp3_;
	_tmp4_ = g_strdup (C_ ("Preview of the word cells", "p/!i/l/l/s"));
	self->priv->position_word = _tmp4_;
	_tmp5_ = g_strdup (_ ("<b>I</b> is in the word but in the wrong spot."));
	self->priv->position_word_desc = _tmp5_;
	_tmp6_ = g_strdup (C_ ("Preview of the word cells", "v/a/g/!u/e"));
	self->priv->wrong_word = _tmp6_;
	_tmp7_ = g_strdup (_ ("<b>U</b> is not in the word in any spot."));
	self->priv->wrong_word_desc = _tmp7_;
}

static void
wg_help_page_finalize (GObject * obj)
{
	WGHelpPage * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, WG_TYPE_HELP_PAGE, WGHelpPage);
	_g_free0 (self->priv->title);
	_g_free0 (self->priv->body);
	_g_free0 (self->priv->correct_word);
	_g_free0 (self->priv->correct_word_desc);
	_g_free0 (self->priv->position_word);
	_g_free0 (self->priv->position_word_desc);
	_g_free0 (self->priv->wrong_word);
	_g_free0 (self->priv->wrong_word_desc);
	G_OBJECT_CLASS (wg_help_page_parent_class)->finalize (obj);
}

static GType
wg_help_page_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (WGHelpPageClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) wg_help_page_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (WGHelpPage), 0, (GInstanceInitFunc) wg_help_page_instance_init, NULL };
	GType wg_help_page_type_id;
	wg_help_page_type_id = g_type_register_static (adw_bin_get_type (), "WGHelpPage", &g_define_type_info, 0);
	WGHelpPage_private_offset = g_type_add_instance_private (wg_help_page_type_id, sizeof (WGHelpPagePrivate));
	return wg_help_page_type_id;
}

GType
wg_help_page_get_type (void)
{
	static volatile gsize wg_help_page_type_id__once = 0;
	if (g_once_init_enter (&wg_help_page_type_id__once)) {
		GType wg_help_page_type_id;
		wg_help_page_type_id = wg_help_page_get_type_once ();
		g_once_init_leave (&wg_help_page_type_id__once, wg_help_page_type_id);
	}
	return wg_help_page_type_id__once;
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

