/* SPDX-License-Identifier: (LGPL-2.1 OR BSD-2-Clause) */

/* THIS FILE IS AUTOGENERATED BY BPFTOOL! */
#ifndef __SYNCSNOOP_BPF_SKEL_H__
#define __SYNCSNOOP_BPF_SKEL_H__

#include <errno.h>
#include <stdlib.h>
#include <bpf/libbpf.h>

#define BPF_SKEL_SUPPORTS_MAP_AUTO_ATTACH 1

struct syncsnoop_bpf {
	struct bpf_object_skeleton *skeleton;
	struct bpf_object *obj;
	struct {
		struct bpf_map *events;
	} maps;
	struct {
		struct bpf_program *tracepoint__syscalls__sys_enter_sync;
		struct bpf_program *tracepoint__syscalls__sys_enter_fsync;
		struct bpf_program *tracepoint__syscalls__sys_enter_fdatasync;
		struct bpf_program *tracepoint__syscalls__sys_enter_msync;
		struct bpf_program *tracepoint__syscalls__sys_enter_sync_file_range;
		struct bpf_program *tracepoint__syscalls__sys_enter_sync_file_range2;
		struct bpf_program *tracepoint__syscalls__sys_enter_arm_sync_file_range;
		struct bpf_program *tracepoint__syscalls__sys_enter_syncfs;
	} progs;
	struct {
		struct bpf_link *tracepoint__syscalls__sys_enter_sync;
		struct bpf_link *tracepoint__syscalls__sys_enter_fsync;
		struct bpf_link *tracepoint__syscalls__sys_enter_fdatasync;
		struct bpf_link *tracepoint__syscalls__sys_enter_msync;
		struct bpf_link *tracepoint__syscalls__sys_enter_sync_file_range;
		struct bpf_link *tracepoint__syscalls__sys_enter_sync_file_range2;
		struct bpf_link *tracepoint__syscalls__sys_enter_arm_sync_file_range;
		struct bpf_link *tracepoint__syscalls__sys_enter_syncfs;
	} links;

#ifdef __cplusplus
	static inline struct syncsnoop_bpf *open(const struct bpf_object_open_opts *opts = nullptr);
	static inline struct syncsnoop_bpf *open_and_load();
	static inline int load(struct syncsnoop_bpf *skel);
	static inline int attach(struct syncsnoop_bpf *skel);
	static inline void detach(struct syncsnoop_bpf *skel);
	static inline void destroy(struct syncsnoop_bpf *skel);
	static inline const void *elf_bytes(size_t *sz);
#endif /* __cplusplus */
};

static void
syncsnoop_bpf__destroy(struct syncsnoop_bpf *obj)
{
	if (!obj)
		return;
	if (obj->skeleton)
		bpf_object__destroy_skeleton(obj->skeleton);
	free(obj);
}

static inline int
syncsnoop_bpf__create_skeleton(struct syncsnoop_bpf *obj);

static inline struct syncsnoop_bpf *
syncsnoop_bpf__open_opts(const struct bpf_object_open_opts *opts)
{
	struct syncsnoop_bpf *obj;
	int err;

	obj = (struct syncsnoop_bpf *)calloc(1, sizeof(*obj));
	if (!obj) {
		errno = ENOMEM;
		return NULL;
	}

	err = syncsnoop_bpf__create_skeleton(obj);
	if (err)
		goto err_out;

	err = bpf_object__open_skeleton(obj->skeleton, opts);
	if (err)
		goto err_out;

	return obj;
err_out:
	syncsnoop_bpf__destroy(obj);
	errno = -err;
	return NULL;
}

static inline struct syncsnoop_bpf *
syncsnoop_bpf__open(void)
{
	return syncsnoop_bpf__open_opts(NULL);
}

static inline int
syncsnoop_bpf__load(struct syncsnoop_bpf *obj)
{
	return bpf_object__load_skeleton(obj->skeleton);
}

static inline struct syncsnoop_bpf *
syncsnoop_bpf__open_and_load(void)
{
	struct syncsnoop_bpf *obj;
	int err;

	obj = syncsnoop_bpf__open();
	if (!obj)
		return NULL;
	err = syncsnoop_bpf__load(obj);
	if (err) {
		syncsnoop_bpf__destroy(obj);
		errno = -err;
		return NULL;
	}
	return obj;
}

static inline int
syncsnoop_bpf__attach(struct syncsnoop_bpf *obj)
{
	return bpf_object__attach_skeleton(obj->skeleton);
}

static inline void
syncsnoop_bpf__detach(struct syncsnoop_bpf *obj)
{
	bpf_object__detach_skeleton(obj->skeleton);
}

static inline const void *syncsnoop_bpf__elf_bytes(size_t *sz);

static inline int
syncsnoop_bpf__create_skeleton(struct syncsnoop_bpf *obj)
{
	struct bpf_object_skeleton *s;
	struct bpf_map_skeleton *map __attribute__((unused));
	int err;

	s = (struct bpf_object_skeleton *)calloc(1, sizeof(*s));
	if (!s)	{
		err = -ENOMEM;
		goto err;
	}

	s->sz = sizeof(*s);
	s->name = "syncsnoop_bpf";
	s->obj = &obj->obj;

	/* maps */
	s->map_cnt = 1;
	s->map_skel_sz = 24;
	s->maps = (struct bpf_map_skeleton *)calloc(s->map_cnt,
			sizeof(*s->maps) > 24 ? sizeof(*s->maps) : 24);
	if (!s->maps) {
		err = -ENOMEM;
		goto err;
	}

	map = (struct bpf_map_skeleton *)((char *)s->maps + 0 * s->map_skel_sz);
	map->name = "events";
	map->map = &obj->maps.events;

	/* programs */
	s->prog_cnt = 8;
	s->prog_skel_sz = sizeof(*s->progs);
	s->progs = (struct bpf_prog_skeleton *)calloc(s->prog_cnt, s->prog_skel_sz);
	if (!s->progs) {
		err = -ENOMEM;
		goto err;
	}

	s->progs[0].name = "tracepoint__syscalls__sys_enter_sync";
	s->progs[0].prog = &obj->progs.tracepoint__syscalls__sys_enter_sync;
	s->progs[0].link = &obj->links.tracepoint__syscalls__sys_enter_sync;

	s->progs[1].name = "tracepoint__syscalls__sys_enter_fsync";
	s->progs[1].prog = &obj->progs.tracepoint__syscalls__sys_enter_fsync;
	s->progs[1].link = &obj->links.tracepoint__syscalls__sys_enter_fsync;

	s->progs[2].name = "tracepoint__syscalls__sys_enter_fdatasync";
	s->progs[2].prog = &obj->progs.tracepoint__syscalls__sys_enter_fdatasync;
	s->progs[2].link = &obj->links.tracepoint__syscalls__sys_enter_fdatasync;

	s->progs[3].name = "tracepoint__syscalls__sys_enter_msync";
	s->progs[3].prog = &obj->progs.tracepoint__syscalls__sys_enter_msync;
	s->progs[3].link = &obj->links.tracepoint__syscalls__sys_enter_msync;

	s->progs[4].name = "tracepoint__syscalls__sys_enter_sync_file_range";
	s->progs[4].prog = &obj->progs.tracepoint__syscalls__sys_enter_sync_file_range;
	s->progs[4].link = &obj->links.tracepoint__syscalls__sys_enter_sync_file_range;

	s->progs[5].name = "tracepoint__syscalls__sys_enter_sync_file_range2";
	s->progs[5].prog = &obj->progs.tracepoint__syscalls__sys_enter_sync_file_range2;
	s->progs[5].link = &obj->links.tracepoint__syscalls__sys_enter_sync_file_range2;

	s->progs[6].name = "tracepoint__syscalls__sys_enter_arm_sync_file_range";
	s->progs[6].prog = &obj->progs.tracepoint__syscalls__sys_enter_arm_sync_file_range;
	s->progs[6].link = &obj->links.tracepoint__syscalls__sys_enter_arm_sync_file_range;

	s->progs[7].name = "tracepoint__syscalls__sys_enter_syncfs";
	s->progs[7].prog = &obj->progs.tracepoint__syscalls__sys_enter_syncfs;
	s->progs[7].link = &obj->links.tracepoint__syscalls__sys_enter_syncfs;

	s->data = syncsnoop_bpf__elf_bytes(&s->data_sz);

	obj->skeleton = s;
	return 0;
err:
	bpf_object__destroy_skeleton(s);
	return err;
}

static inline const void *syncsnoop_bpf__elf_bytes(size_t *sz)
{
	static const char data[] __attribute__((__aligned__(8))) = "\
\x7f\x45\x4c\x46\x02\x01\x01\0\0\0\0\0\0\0\0\0\x01\0\xf7\0\x01\0\0\0\0\0\0\0\0\
\0\0\0\0\0\0\0\0\0\0\0\xc8\x20\0\0\0\0\0\0\0\0\0\0\x40\0\0\0\0\0\x40\0\x1b\0\
\x01\0\xbf\x16\0\0\0\0\0\0\xb7\x01\0\0\0\0\0\0\x7b\x1a\xf8\xff\0\0\0\0\x7b\x1a\
\xf0\xff\0\0\0\0\x7b\x1a\xe8\xff\0\0\0\0\x7b\x1a\xe0\xff\0\0\0\0\xbf\xa7\0\0\0\
\0\0\0\x07\x07\0\0\xe0\xff\xff\xff\xbf\x71\0\0\0\0\0\0\xb4\x02\0\0\x10\0\0\0\
\x85\0\0\0\x10\0\0\0\x85\0\0\0\x05\0\0\0\xb4\x01\0\0\x01\0\0\0\x63\x1a\xf8\xff\
\0\0\0\0\x37\0\0\0\xe8\x03\0\0\x7b\x0a\xf0\xff\0\0\0\0\xbf\x61\0\0\0\0\0\0\x18\
\x02\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x18\x03\0\0\xff\xff\xff\xff\0\0\0\0\0\0\0\0\
\xbf\x74\0\0\0\0\0\0\xb7\x05\0\0\x20\0\0\0\x85\0\0\0\x19\0\0\0\x95\0\0\0\0\0\0\
\0\xbf\x16\0\0\0\0\0\0\xb7\x01\0\0\0\0\0\0\x7b\x1a\xf8\xff\0\0\0\0\x7b\x1a\xf0\
\xff\0\0\0\0\x7b\x1a\xe8\xff\0\0\0\0\x7b\x1a\xe0\xff\0\0\0\0\xbf\xa7\0\0\0\0\0\
\0\x07\x07\0\0\xe0\xff\xff\xff\xbf\x71\0\0\0\0\0\0\xb4\x02\0\0\x10\0\0\0\x85\0\
\0\0\x10\0\0\0\x85\0\0\0\x05\0\0\0\xb4\x01\0\0\x02\0\0\0\x63\x1a\xf8\xff\0\0\0\
\0\x37\0\0\0\xe8\x03\0\0\x7b\x0a\xf0\xff\0\0\0\0\xbf\x61\0\0\0\0\0\0\x18\x02\0\
\0\0\0\0\0\0\0\0\0\0\0\0\0\x18\x03\0\0\xff\xff\xff\xff\0\0\0\0\0\0\0\0\xbf\x74\
\0\0\0\0\0\0\xb7\x05\0\0\x20\0\0\0\x85\0\0\0\x19\0\0\0\x95\0\0\0\0\0\0\0\xbf\
\x16\0\0\0\0\0\0\xb7\x01\0\0\0\0\0\0\x7b\x1a\xf8\xff\0\0\0\0\x7b\x1a\xf0\xff\0\
\0\0\0\x7b\x1a\xe8\xff\0\0\0\0\x7b\x1a\xe0\xff\0\0\0\0\xbf\xa7\0\0\0\0\0\0\x07\
\x07\0\0\xe0\xff\xff\xff\xbf\x71\0\0\0\0\0\0\xb4\x02\0\0\x10\0\0\0\x85\0\0\0\
\x10\0\0\0\x85\0\0\0\x05\0\0\0\xb4\x01\0\0\x03\0\0\0\x63\x1a\xf8\xff\0\0\0\0\
\x37\0\0\0\xe8\x03\0\0\x7b\x0a\xf0\xff\0\0\0\0\xbf\x61\0\0\0\0\0\0\x18\x02\0\0\
\0\0\0\0\0\0\0\0\0\0\0\0\x18\x03\0\0\xff\xff\xff\xff\0\0\0\0\0\0\0\0\xbf\x74\0\
\0\0\0\0\0\xb7\x05\0\0\x20\0\0\0\x85\0\0\0\x19\0\0\0\x95\0\0\0\0\0\0\0\xbf\x16\
\0\0\0\0\0\0\xb7\x01\0\0\0\0\0\0\x7b\x1a\xf8\xff\0\0\0\0\x7b\x1a\xf0\xff\0\0\0\
\0\x7b\x1a\xe8\xff\0\0\0\0\x7b\x1a\xe0\xff\0\0\0\0\xbf\xa7\0\0\0\0\0\0\x07\x07\
\0\0\xe0\xff\xff\xff\xbf\x71\0\0\0\0\0\0\xb4\x02\0\0\x10\0\0\0\x85\0\0\0\x10\0\
\0\0\x85\0\0\0\x05\0\0\0\xb4\x01\0\0\x04\0\0\0\x63\x1a\xf8\xff\0\0\0\0\x37\0\0\
\0\xe8\x03\0\0\x7b\x0a\xf0\xff\0\0\0\0\xbf\x61\0\0\0\0\0\0\x18\x02\0\0\0\0\0\0\
\0\0\0\0\0\0\0\0\x18\x03\0\0\xff\xff\xff\xff\0\0\0\0\0\0\0\0\xbf\x74\0\0\0\0\0\
\0\xb7\x05\0\0\x20\0\0\0\x85\0\0\0\x19\0\0\0\x95\0\0\0\0\0\0\0\xbf\x16\0\0\0\0\
\0\0\xb7\x01\0\0\0\0\0\0\x7b\x1a\xf8\xff\0\0\0\0\x7b\x1a\xf0\xff\0\0\0\0\x7b\
\x1a\xe8\xff\0\0\0\0\x7b\x1a\xe0\xff\0\0\0\0\xbf\xa7\0\0\0\0\0\0\x07\x07\0\0\
\xe0\xff\xff\xff\xbf\x71\0\0\0\0\0\0\xb4\x02\0\0\x10\0\0\0\x85\0\0\0\x10\0\0\0\
\x85\0\0\0\x05\0\0\0\xb4\x01\0\0\x05\0\0\0\x63\x1a\xf8\xff\0\0\0\0\x37\0\0\0\
\xe8\x03\0\0\x7b\x0a\xf0\xff\0\0\0\0\xbf\x61\0\0\0\0\0\0\x18\x02\0\0\0\0\0\0\0\
\0\0\0\0\0\0\0\x18\x03\0\0\xff\xff\xff\xff\0\0\0\0\0\0\0\0\xbf\x74\0\0\0\0\0\0\
\xb7\x05\0\0\x20\0\0\0\x85\0\0\0\x19\0\0\0\x95\0\0\0\0\0\0\0\xbf\x16\0\0\0\0\0\
\0\xb7\x01\0\0\0\0\0\0\x7b\x1a\xf8\xff\0\0\0\0\x7b\x1a\xf0\xff\0\0\0\0\x7b\x1a\
\xe8\xff\0\0\0\0\x7b\x1a\xe0\xff\0\0\0\0\xbf\xa7\0\0\0\0\0\0\x07\x07\0\0\xe0\
\xff\xff\xff\xbf\x71\0\0\0\0\0\0\xb4\x02\0\0\x10\0\0\0\x85\0\0\0\x10\0\0\0\x85\
\0\0\0\x05\0\0\0\xb4\x01\0\0\x06\0\0\0\x63\x1a\xf8\xff\0\0\0\0\x37\0\0\0\xe8\
\x03\0\0\x7b\x0a\xf0\xff\0\0\0\0\xbf\x61\0\0\0\0\0\0\x18\x02\0\0\0\0\0\0\0\0\0\
\0\0\0\0\0\x18\x03\0\0\xff\xff\xff\xff\0\0\0\0\0\0\0\0\xbf\x74\0\0\0\0\0\0\xb7\
\x05\0\0\x20\0\0\0\x85\0\0\0\x19\0\0\0\x95\0\0\0\0\0\0\0\xbf\x16\0\0\0\0\0\0\
\xb7\x01\0\0\0\0\0\0\x7b\x1a\xf8\xff\0\0\0\0\x7b\x1a\xf0\xff\0\0\0\0\x7b\x1a\
\xe8\xff\0\0\0\0\x7b\x1a\xe0\xff\0\0\0\0\xbf\xa7\0\0\0\0\0\0\x07\x07\0\0\xe0\
\xff\xff\xff\xbf\x71\0\0\0\0\0\0\xb4\x02\0\0\x10\0\0\0\x85\0\0\0\x10\0\0\0\x85\
\0\0\0\x05\0\0\0\xb4\x01\0\0\x07\0\0\0\x63\x1a\xf8\xff\0\0\0\0\x37\0\0\0\xe8\
\x03\0\0\x7b\x0a\xf0\xff\0\0\0\0\xbf\x61\0\0\0\0\0\0\x18\x02\0\0\0\0\0\0\0\0\0\
\0\0\0\0\0\x18\x03\0\0\xff\xff\xff\xff\0\0\0\0\0\0\0\0\xbf\x74\0\0\0\0\0\0\xb7\
\x05\0\0\x20\0\0\0\x85\0\0\0\x19\0\0\0\x95\0\0\0\0\0\0\0\xbf\x16\0\0\0\0\0\0\
\xb7\x01\0\0\0\0\0\0\x7b\x1a\xf8\xff\0\0\0\0\x7b\x1a\xf0\xff\0\0\0\0\x7b\x1a\
\xe8\xff\0\0\0\0\x7b\x1a\xe0\xff\0\0\0\0\xbf\xa7\0\0\0\0\0\0\x07\x07\0\0\xe0\
\xff\xff\xff\xbf\x71\0\0\0\0\0\0\xb4\x02\0\0\x10\0\0\0\x85\0\0\0\x10\0\0\0\x85\
\0\0\0\x05\0\0\0\xb4\x01\0\0\x08\0\0\0\x63\x1a\xf8\xff\0\0\0\0\x37\0\0\0\xe8\
\x03\0\0\x7b\x0a\xf0\xff\0\0\0\0\xbf\x61\0\0\0\0\0\0\x18\x02\0\0\0\0\0\0\0\0\0\
\0\0\0\0\0\x18\x03\0\0\xff\xff\xff\xff\0\0\0\0\0\0\0\0\xbf\x74\0\0\0\0\0\0\xb7\
\x05\0\0\x20\0\0\0\x85\0\0\0\x19\0\0\0\x95\0\0\0\0\0\0\0\x47\x50\x4c\0\0\0\0\0\
\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x9f\xeb\x01\0\x18\0\0\0\0\0\0\
\0\xe0\x02\0\0\xe0\x02\0\0\x3d\x07\0\0\0\0\0\0\0\0\0\x02\x03\0\0\0\x01\0\0\0\0\
\0\0\x01\x04\0\0\0\x20\0\0\x01\0\0\0\0\0\0\0\x03\0\0\0\0\x02\0\0\0\x04\0\0\0\
\x04\0\0\0\x05\0\0\0\0\0\0\x01\x04\0\0\0\x20\0\0\0\0\0\0\0\x03\0\0\x04\x18\0\0\
\0\x19\0\0\0\x01\0\0\0\0\0\0\0\x1e\0\0\0\x01\0\0\0\x40\0\0\0\x27\0\0\0\x01\0\0\
\0\x80\0\0\0\x32\0\0\0\0\0\0\x0e\x05\0\0\0\x01\0\0\0\0\0\0\0\0\0\0\x02\x08\0\0\
\0\x39\0\0\0\x04\0\0\x04\x40\0\0\0\x53\0\0\0\x09\0\0\0\0\0\0\0\x57\0\0\0\x0c\0\
\0\0\x40\0\0\0\x5a\0\0\0\x0e\0\0\0\x80\0\0\0\x5f\0\0\0\x10\0\0\0\0\x02\0\0\x66\
\0\0\0\x04\0\0\x04\x08\0\0\0\x19\0\0\0\x0a\0\0\0\0\0\0\0\x72\0\0\0\x0b\0\0\0\
\x10\0\0\0\x78\0\0\0\x0b\0\0\0\x18\0\0\0\x86\0\0\0\x02\0\0\0\x20\0\0\0\x8a\0\0\
\0\0\0\0\x01\x02\0\0\0\x10\0\0\0\x99\0\0\0\0\0\0\x01\x01\0\0\0\x08\0\0\0\xa7\0\
\0\0\0\0\0\x01\x08\0\0\0\x40\0\0\x01\xac\0\0\0\0\0\0\x01\x08\0\0\0\x40\0\0\0\0\
\0\0\0\0\0\0\x03\0\0\0\0\x0d\0\0\0\x04\0\0\0\x06\0\0\0\xba\0\0\0\0\0\0\x01\x01\
\0\0\0\x08\0\0\x01\0\0\0\0\0\0\0\x03\0\0\0\0\x0f\0\0\0\x04\0\0\0\0\0\0\0\0\0\0\
\0\x01\0\0\x0d\0\0\0\0\xbf\0\0\0\x07\0\0\0\xc3\0\0\0\x01\0\0\x0c\x11\0\0\0\0\0\
\0\0\x01\0\0\x0d\0\0\0\0\xbf\0\0\0\x07\0\0\0\x6b\x02\0\0\x01\0\0\x0c\x13\0\0\0\
\0\0\0\0\x01\0\0\x0d\0\0\0\0\xbf\0\0\0\x07\0\0\0\x07\x03\0\0\x01\0\0\x0c\x15\0\
\0\0\0\0\0\0\x01\0\0\x0d\0\0\0\0\xbf\0\0\0\x07\0\0\0\xaf\x03\0\0\x01\0\0\x0c\
\x17\0\0\0\0\0\0\0\x01\0\0\x0d\0\0\0\0\xbf\0\0\0\x07\0\0\0\x4b\x04\0\0\x01\0\0\
\x0c\x19\0\0\0\0\0\0\0\x01\0\0\x0d\0\0\0\0\xbf\0\0\0\x07\0\0\0\x05\x05\0\0\x01\
\0\0\x0c\x1b\0\0\0\0\0\0\0\x01\0\0\x0d\0\0\0\0\xbf\0\0\0\x07\0\0\0\xc2\x05\0\0\
\x01\0\0\x0c\x1d\0\0\0\0\0\0\0\x01\0\0\x0d\0\0\0\0\xbf\0\0\0\x07\0\0\0\x88\x06\
\0\0\x01\0\0\x0c\x1f\0\0\0\0\0\0\0\0\0\0\x03\0\0\0\0\x0f\0\0\0\x04\0\0\0\x04\0\
\0\0\x27\x07\0\0\0\0\0\x0e\x21\0\0\0\x01\0\0\0\x2f\x07\0\0\x01\0\0\x0f\0\0\0\0\
\x06\0\0\0\0\0\0\0\x18\0\0\0\x35\x07\0\0\x01\0\0\x0f\0\0\0\0\x22\0\0\0\0\0\0\0\
\x04\0\0\0\0\x69\x6e\x74\0\x5f\x5f\x41\x52\x52\x41\x59\x5f\x53\x49\x5a\x45\x5f\
\x54\x59\x50\x45\x5f\x5f\0\x74\x79\x70\x65\0\x6b\x65\x79\x5f\x73\x69\x7a\x65\0\
\x76\x61\x6c\x75\x65\x5f\x73\x69\x7a\x65\0\x65\x76\x65\x6e\x74\x73\0\x74\x72\
\x61\x63\x65\x5f\x65\x76\x65\x6e\x74\x5f\x72\x61\x77\x5f\x73\x79\x73\x5f\x65\
\x6e\x74\x65\x72\0\x65\x6e\x74\0\x69\x64\0\x61\x72\x67\x73\0\x5f\x5f\x64\x61\
\x74\x61\0\x74\x72\x61\x63\x65\x5f\x65\x6e\x74\x72\x79\0\x66\x6c\x61\x67\x73\0\
\x70\x72\x65\x65\x6d\x70\x74\x5f\x63\x6f\x75\x6e\x74\0\x70\x69\x64\0\x75\x6e\
\x73\x69\x67\x6e\x65\x64\x20\x73\x68\x6f\x72\x74\0\x75\x6e\x73\x69\x67\x6e\x65\
\x64\x20\x63\x68\x61\x72\0\x6c\x6f\x6e\x67\0\x75\x6e\x73\x69\x67\x6e\x65\x64\
\x20\x6c\x6f\x6e\x67\0\x63\x68\x61\x72\0\x63\x74\x78\0\x74\x72\x61\x63\x65\x70\
\x6f\x69\x6e\x74\x5f\x5f\x73\x79\x73\x63\x61\x6c\x6c\x73\x5f\x5f\x73\x79\x73\
\x5f\x65\x6e\x74\x65\x72\x5f\x73\x79\x6e\x63\0\x74\x72\x61\x63\x65\x70\x6f\x69\
\x6e\x74\x2f\x73\x79\x73\x63\x61\x6c\x6c\x73\x2f\x73\x79\x73\x5f\x65\x6e\x74\
\x65\x72\x5f\x73\x79\x6e\x63\0\x2f\x62\x75\x69\x6c\x64\x2f\x62\x63\x63\x2f\x73\
\x72\x63\x2f\x62\x63\x63\x2f\x6c\x69\x62\x62\x70\x66\x2d\x74\x6f\x6f\x6c\x73\
\x2f\x73\x79\x6e\x63\x73\x6e\x6f\x6f\x70\x2e\x62\x70\x66\x2e\x63\0\x76\x6f\x69\
\x64\x20\x74\x72\x61\x63\x65\x70\x6f\x69\x6e\x74\x5f\x5f\x73\x79\x73\x63\x61\
\x6c\x6c\x73\x5f\x5f\x73\x79\x73\x5f\x65\x6e\x74\x65\x72\x5f\x73\x79\x6e\x63\
\x28\x73\x74\x72\x75\x63\x74\x20\x74\x72\x61\x63\x65\x5f\x65\x76\x65\x6e\x74\
\x5f\x72\x61\x77\x5f\x73\x79\x73\x5f\x65\x6e\x74\x65\x72\x20\x2a\x63\x74\x78\
\x29\0\x09\x73\x74\x72\x75\x63\x74\x20\x65\x76\x65\x6e\x74\x20\x65\x76\x65\x6e\
\x74\x20\x3d\x20\x7b\x7d\x3b\0\x09\x62\x70\x66\x5f\x67\x65\x74\x5f\x63\x75\x72\
\x72\x65\x6e\x74\x5f\x63\x6f\x6d\x6d\x28\x65\x76\x65\x6e\x74\x2e\x63\x6f\x6d\
\x6d\x2c\x20\x73\x69\x7a\x65\x6f\x66\x28\x65\x76\x65\x6e\x74\x2e\x63\x6f\x6d\
\x6d\x29\x29\x3b\0\x09\x65\x76\x65\x6e\x74\x2e\x74\x73\x5f\x75\x73\x20\x3d\x20\
\x62\x70\x66\x5f\x6b\x74\x69\x6d\x65\x5f\x67\x65\x74\x5f\x6e\x73\x28\x29\x20\
\x2f\x20\x31\x30\x30\x30\x3b\0\x09\x65\x76\x65\x6e\x74\x2e\x73\x79\x73\x20\x3d\
\x20\x73\x79\x73\x3b\0\x09\x62\x70\x66\x5f\x70\x65\x72\x66\x5f\x65\x76\x65\x6e\
\x74\x5f\x6f\x75\x74\x70\x75\x74\x28\x63\x74\x78\x2c\x20\x26\x65\x76\x65\x6e\
\x74\x73\x2c\x20\x42\x50\x46\x5f\x46\x5f\x43\x55\x52\x52\x45\x4e\x54\x5f\x43\
\x50\x55\x2c\x20\x26\x65\x76\x65\x6e\x74\x2c\x20\x73\x69\x7a\x65\x6f\x66\x28\
\x65\x76\x65\x6e\x74\x29\x29\x3b\0\x7d\0\x74\x72\x61\x63\x65\x70\x6f\x69\x6e\
\x74\x5f\x5f\x73\x79\x73\x63\x61\x6c\x6c\x73\x5f\x5f\x73\x79\x73\x5f\x65\x6e\
\x74\x65\x72\x5f\x66\x73\x79\x6e\x63\0\x74\x72\x61\x63\x65\x70\x6f\x69\x6e\x74\
\x2f\x73\x79\x73\x63\x61\x6c\x6c\x73\x2f\x73\x79\x73\x5f\x65\x6e\x74\x65\x72\
\x5f\x66\x73\x79\x6e\x63\0\x76\x6f\x69\x64\x20\x74\x72\x61\x63\x65\x70\x6f\x69\
\x6e\x74\x5f\x5f\x73\x79\x73\x63\x61\x6c\x6c\x73\x5f\x5f\x73\x79\x73\x5f\x65\
\x6e\x74\x65\x72\x5f\x66\x73\x79\x6e\x63\x28\x73\x74\x72\x75\x63\x74\x20\x74\
\x72\x61\x63\x65\x5f\x65\x76\x65\x6e\x74\x5f\x72\x61\x77\x5f\x73\x79\x73\x5f\
\x65\x6e\x74\x65\x72\x20\x2a\x63\x74\x78\x29\0\x74\x72\x61\x63\x65\x70\x6f\x69\
\x6e\x74\x5f\x5f\x73\x79\x73\x63\x61\x6c\x6c\x73\x5f\x5f\x73\x79\x73\x5f\x65\
\x6e\x74\x65\x72\x5f\x66\x64\x61\x74\x61\x73\x79\x6e\x63\0\x74\x72\x61\x63\x65\
\x70\x6f\x69\x6e\x74\x2f\x73\x79\x73\x63\x61\x6c\x6c\x73\x2f\x73\x79\x73\x5f\
\x65\x6e\x74\x65\x72\x5f\x66\x64\x61\x74\x61\x73\x79\x6e\x63\0\x76\x6f\x69\x64\
\x20\x74\x72\x61\x63\x65\x70\x6f\x69\x6e\x74\x5f\x5f\x73\x79\x73\x63\x61\x6c\
\x6c\x73\x5f\x5f\x73\x79\x73\x5f\x65\x6e\x74\x65\x72\x5f\x66\x64\x61\x74\x61\
\x73\x79\x6e\x63\x28\x73\x74\x72\x75\x63\x74\x20\x74\x72\x61\x63\x65\x5f\x65\
\x76\x65\x6e\x74\x5f\x72\x61\x77\x5f\x73\x79\x73\x5f\x65\x6e\x74\x65\x72\x20\
\x2a\x63\x74\x78\x29\0\x74\x72\x61\x63\x65\x70\x6f\x69\x6e\x74\x5f\x5f\x73\x79\
\x73\x63\x61\x6c\x6c\x73\x5f\x5f\x73\x79\x73\x5f\x65\x6e\x74\x65\x72\x5f\x6d\
\x73\x79\x6e\x63\0\x74\x72\x61\x63\x65\x70\x6f\x69\x6e\x74\x2f\x73\x79\x73\x63\
\x61\x6c\x6c\x73\x2f\x73\x79\x73\x5f\x65\x6e\x74\x65\x72\x5f\x6d\x73\x79\x6e\
\x63\0\x76\x6f\x69\x64\x20\x74\x72\x61\x63\x65\x70\x6f\x69\x6e\x74\x5f\x5f\x73\
\x79\x73\x63\x61\x6c\x6c\x73\x5f\x5f\x73\x79\x73\x5f\x65\x6e\x74\x65\x72\x5f\
\x6d\x73\x79\x6e\x63\x28\x73\x74\x72\x75\x63\x74\x20\x74\x72\x61\x63\x65\x5f\
\x65\x76\x65\x6e\x74\x5f\x72\x61\x77\x5f\x73\x79\x73\x5f\x65\x6e\x74\x65\x72\
\x20\x2a\x63\x74\x78\x29\0\x74\x72\x61\x63\x65\x70\x6f\x69\x6e\x74\x5f\x5f\x73\
\x79\x73\x63\x61\x6c\x6c\x73\x5f\x5f\x73\x79\x73\x5f\x65\x6e\x74\x65\x72\x5f\
\x73\x79\x6e\x63\x5f\x66\x69\x6c\x65\x5f\x72\x61\x6e\x67\x65\0\x74\x72\x61\x63\
\x65\x70\x6f\x69\x6e\x74\x2f\x73\x79\x73\x63\x61\x6c\x6c\x73\x2f\x73\x79\x73\
\x5f\x65\x6e\x74\x65\x72\x5f\x73\x79\x6e\x63\x5f\x66\x69\x6c\x65\x5f\x72\x61\
\x6e\x67\x65\0\x76\x6f\x69\x64\x20\x74\x72\x61\x63\x65\x70\x6f\x69\x6e\x74\x5f\
\x5f\x73\x79\x73\x63\x61\x6c\x6c\x73\x5f\x5f\x73\x79\x73\x5f\x65\x6e\x74\x65\
\x72\x5f\x73\x79\x6e\x63\x5f\x66\x69\x6c\x65\x5f\x72\x61\x6e\x67\x65\x28\x73\
\x74\x72\x75\x63\x74\x20\x74\x72\x61\x63\x65\x5f\x65\x76\x65\x6e\x74\x5f\x72\
\x61\x77\x5f\x73\x79\x73\x5f\x65\x6e\x74\x65\x72\x20\x2a\x63\x74\x78\x29\0\x74\
\x72\x61\x63\x65\x70\x6f\x69\x6e\x74\x5f\x5f\x73\x79\x73\x63\x61\x6c\x6c\x73\
\x5f\x5f\x73\x79\x73\x5f\x65\x6e\x74\x65\x72\x5f\x73\x79\x6e\x63\x5f\x66\x69\
\x6c\x65\x5f\x72\x61\x6e\x67\x65\x32\0\x74\x72\x61\x63\x65\x70\x6f\x69\x6e\x74\
\x2f\x73\x79\x73\x63\x61\x6c\x6c\x73\x2f\x73\x79\x73\x5f\x65\x6e\x74\x65\x72\
\x5f\x73\x79\x6e\x63\x5f\x66\x69\x6c\x65\x5f\x72\x61\x6e\x67\x65\x32\0\x76\x6f\
\x69\x64\x20\x74\x72\x61\x63\x65\x70\x6f\x69\x6e\x74\x5f\x5f\x73\x79\x73\x63\
\x61\x6c\x6c\x73\x5f\x5f\x73\x79\x73\x5f\x65\x6e\x74\x65\x72\x5f\x73\x79\x6e\
\x63\x5f\x66\x69\x6c\x65\x5f\x72\x61\x6e\x67\x65\x32\x28\x73\x74\x72\x75\x63\
\x74\x20\x74\x72\x61\x63\x65\x5f\x65\x76\x65\x6e\x74\x5f\x72\x61\x77\x5f\x73\
\x79\x73\x5f\x65\x6e\x74\x65\x72\x20\x2a\x63\x74\x78\x29\0\x74\x72\x61\x63\x65\
\x70\x6f\x69\x6e\x74\x5f\x5f\x73\x79\x73\x63\x61\x6c\x6c\x73\x5f\x5f\x73\x79\
\x73\x5f\x65\x6e\x74\x65\x72\x5f\x61\x72\x6d\x5f\x73\x79\x6e\x63\x5f\x66\x69\
\x6c\x65\x5f\x72\x61\x6e\x67\x65\0\x74\x72\x61\x63\x65\x70\x6f\x69\x6e\x74\x2f\
\x73\x79\x73\x63\x61\x6c\x6c\x73\x2f\x73\x79\x73\x5f\x65\x6e\x74\x65\x72\x5f\
\x61\x72\x6d\x5f\x73\x79\x6e\x63\x5f\x66\x69\x6c\x65\x5f\x72\x61\x6e\x67\x65\0\
\x76\x6f\x69\x64\x20\x74\x72\x61\x63\x65\x70\x6f\x69\x6e\x74\x5f\x5f\x73\x79\
\x73\x63\x61\x6c\x6c\x73\x5f\x5f\x73\x79\x73\x5f\x65\x6e\x74\x65\x72\x5f\x61\
\x72\x6d\x5f\x73\x79\x6e\x63\x5f\x66\x69\x6c\x65\x5f\x72\x61\x6e\x67\x65\x28\
\x73\x74\x72\x75\x63\x74\x20\x74\x72\x61\x63\x65\x5f\x65\x76\x65\x6e\x74\x5f\
\x72\x61\x77\x5f\x73\x79\x73\x5f\x65\x6e\x74\x65\x72\x20\x2a\x63\x74\x78\x29\0\
\x74\x72\x61\x63\x65\x70\x6f\x69\x6e\x74\x5f\x5f\x73\x79\x73\x63\x61\x6c\x6c\
\x73\x5f\x5f\x73\x79\x73\x5f\x65\x6e\x74\x65\x72\x5f\x73\x79\x6e\x63\x66\x73\0\
\x74\x72\x61\x63\x65\x70\x6f\x69\x6e\x74\x2f\x73\x79\x73\x63\x61\x6c\x6c\x73\
\x2f\x73\x79\x73\x5f\x65\x6e\x74\x65\x72\x5f\x73\x79\x6e\x63\x66\x73\0\x76\x6f\
\x69\x64\x20\x74\x72\x61\x63\x65\x70\x6f\x69\x6e\x74\x5f\x5f\x73\x79\x73\x63\
\x61\x6c\x6c\x73\x5f\x5f\x73\x79\x73\x5f\x65\x6e\x74\x65\x72\x5f\x73\x79\x6e\
\x63\x66\x73\x28\x73\x74\x72\x75\x63\x74\x20\x74\x72\x61\x63\x65\x5f\x65\x76\
\x65\x6e\x74\x5f\x72\x61\x77\x5f\x73\x79\x73\x5f\x65\x6e\x74\x65\x72\x20\x2a\
\x63\x74\x78\x29\0\x4c\x49\x43\x45\x4e\x53\x45\0\x2e\x6d\x61\x70\x73\0\x6c\x69\
\x63\x65\x6e\x73\x65\0\0\0\0\x9f\xeb\x01\0\x20\0\0\0\0\0\0\0\x84\0\0\0\x84\0\0\
\0\xc4\x04\0\0\x48\x05\0\0\0\0\0\0\x08\0\0\0\xe8\0\0\0\x01\0\0\0\0\0\0\0\x12\0\
\0\0\x91\x02\0\0\x01\0\0\0\0\0\0\0\x14\0\0\0\x31\x03\0\0\x01\0\0\0\0\0\0\0\x16\
\0\0\0\xd5\x03\0\0\x01\0\0\0\0\0\0\0\x18\0\0\0\x7b\x04\0\0\x01\0\0\0\0\0\0\0\
\x1a\0\0\0\x36\x05\0\0\x01\0\0\0\0\0\0\0\x1c\0\0\0\xf6\x05\0\0\x01\0\0\0\0\0\0\
\0\x1e\0\0\0\xaf\x06\0\0\x01\0\0\0\0\0\0\0\x20\0\0\0\x10\0\0\0\xe8\0\0\0\x09\0\
\0\0\0\0\0\0\x0b\x01\0\0\x3b\x01\0\0\0\x68\0\0\x10\0\0\0\x0b\x01\0\0\x8c\x01\0\
\0\x0f\x44\0\0\x40\0\0\0\x0b\x01\0\0\xa6\x01\0\0\x02\x4c\0\0\x58\0\0\0\x0b\x01\
\0\0\xdd\x01\0\0\x10\x50\0\0\x68\0\0\0\x0b\x01\0\0\x07\x02\0\0\x0c\x54\0\0\x70\
\0\0\0\x0b\x01\0\0\xdd\x01\0\0\x23\x50\0\0\x78\0\0\0\x0b\x01\0\0\xdd\x01\0\0\
\x0e\x50\0\0\x80\0\0\0\x0b\x01\0\0\x19\x02\0\0\x02\x58\0\0\xc0\0\0\0\x0b\x01\0\
\0\x69\x02\0\0\x01\x74\0\0\x91\x02\0\0\x09\0\0\0\0\0\0\0\x0b\x01\0\0\xb5\x02\0\
\0\0\x80\0\0\x10\0\0\0\x0b\x01\0\0\x8c\x01\0\0\x0f\x44\0\0\x40\0\0\0\x0b\x01\0\
\0\xa6\x01\0\0\x02\x4c\0\0\x58\0\0\0\x0b\x01\0\0\xdd\x01\0\0\x10\x50\0\0\x68\0\
\0\0\x0b\x01\0\0\x07\x02\0\0\x0c\x54\0\0\x70\0\0\0\x0b\x01\0\0\xdd\x01\0\0\x23\
\x50\0\0\x78\0\0\0\x0b\x01\0\0\xdd\x01\0\0\x0e\x50\0\0\x80\0\0\0\x0b\x01\0\0\
\x19\x02\0\0\x02\x58\0\0\xc0\0\0\0\x0b\x01\0\0\x69\x02\0\0\x01\x8c\0\0\x31\x03\
\0\0\x09\0\0\0\0\0\0\0\x0b\x01\0\0\x59\x03\0\0\0\x98\0\0\x10\0\0\0\x0b\x01\0\0\
\x8c\x01\0\0\x0f\x44\0\0\x40\0\0\0\x0b\x01\0\0\xa6\x01\0\0\x02\x4c\0\0\x58\0\0\
\0\x0b\x01\0\0\xdd\x01\0\0\x10\x50\0\0\x68\0\0\0\x0b\x01\0\0\x07\x02\0\0\x0c\
\x54\0\0\x70\0\0\0\x0b\x01\0\0\xdd\x01\0\0\x23\x50\0\0\x78\0\0\0\x0b\x01\0\0\
\xdd\x01\0\0\x0e\x50\0\0\x80\0\0\0\x0b\x01\0\0\x19\x02\0\0\x02\x58\0\0\xc0\0\0\
\0\x0b\x01\0\0\x69\x02\0\0\x01\xa4\0\0\xd5\x03\0\0\x09\0\0\0\0\0\0\0\x0b\x01\0\
\0\xf9\x03\0\0\0\xb0\0\0\x10\0\0\0\x0b\x01\0\0\x8c\x01\0\0\x0f\x44\0\0\x40\0\0\
\0\x0b\x01\0\0\xa6\x01\0\0\x02\x4c\0\0\x58\0\0\0\x0b\x01\0\0\xdd\x01\0\0\x10\
\x50\0\0\x68\0\0\0\x0b\x01\0\0\x07\x02\0\0\x0c\x54\0\0\x70\0\0\0\x0b\x01\0\0\
\xdd\x01\0\0\x23\x50\0\0\x78\0\0\0\x0b\x01\0\0\xdd\x01\0\0\x0e\x50\0\0\x80\0\0\
\0\x0b\x01\0\0\x19\x02\0\0\x02\x58\0\0\xc0\0\0\0\x0b\x01\0\0\x69\x02\0\0\x01\
\xbc\0\0\x7b\x04\0\0\x09\0\0\0\0\0\0\0\x0b\x01\0\0\xa9\x04\0\0\0\xc8\0\0\x10\0\
\0\0\x0b\x01\0\0\x8c\x01\0\0\x0f\x44\0\0\x40\0\0\0\x0b\x01\0\0\xa6\x01\0\0\x02\
\x4c\0\0\x58\0\0\0\x0b\x01\0\0\xdd\x01\0\0\x10\x50\0\0\x68\0\0\0\x0b\x01\0\0\
\x07\x02\0\0\x0c\x54\0\0\x70\0\0\0\x0b\x01\0\0\xdd\x01\0\0\x23\x50\0\0\x78\0\0\
\0\x0b\x01\0\0\xdd\x01\0\0\x0e\x50\0\0\x80\0\0\0\x0b\x01\0\0\x19\x02\0\0\x02\
\x58\0\0\xc0\0\0\0\x0b\x01\0\0\x69\x02\0\0\x01\xd4\0\0\x36\x05\0\0\x09\0\0\0\0\
\0\0\0\x0b\x01\0\0\x65\x05\0\0\0\xe0\0\0\x10\0\0\0\x0b\x01\0\0\x8c\x01\0\0\x0f\
\x44\0\0\x40\0\0\0\x0b\x01\0\0\xa6\x01\0\0\x02\x4c\0\0\x58\0\0\0\x0b\x01\0\0\
\xdd\x01\0\0\x10\x50\0\0\x68\0\0\0\x0b\x01\0\0\x07\x02\0\0\x0c\x54\0\0\x70\0\0\
\0\x0b\x01\0\0\xdd\x01\0\0\x23\x50\0\0\x78\0\0\0\x0b\x01\0\0\xdd\x01\0\0\x0e\
\x50\0\0\x80\0\0\0\x0b\x01\0\0\x19\x02\0\0\x02\x58\0\0\xc0\0\0\0\x0b\x01\0\0\
\x69\x02\0\0\x01\xec\0\0\xf6\x05\0\0\x09\0\0\0\0\0\0\0\x0b\x01\0\0\x28\x06\0\0\
\0\xf8\0\0\x10\0\0\0\x0b\x01\0\0\x8c\x01\0\0\x0f\x44\0\0\x40\0\0\0\x0b\x01\0\0\
\xa6\x01\0\0\x02\x4c\0\0\x58\0\0\0\x0b\x01\0\0\xdd\x01\0\0\x10\x50\0\0\x68\0\0\
\0\x0b\x01\0\0\x07\x02\0\0\x0c\x54\0\0\x70\0\0\0\x0b\x01\0\0\xdd\x01\0\0\x23\
\x50\0\0\x78\0\0\0\x0b\x01\0\0\xdd\x01\0\0\x0e\x50\0\0\x80\0\0\0\x0b\x01\0\0\
\x19\x02\0\0\x02\x58\0\0\xc0\0\0\0\x0b\x01\0\0\x69\x02\0\0\x01\x04\x01\0\xaf\
\x06\0\0\x09\0\0\0\0\0\0\0\x0b\x01\0\0\xd4\x06\0\0\0\x10\x01\0\x10\0\0\0\x0b\
\x01\0\0\x8c\x01\0\0\x0f\x44\0\0\x40\0\0\0\x0b\x01\0\0\xa6\x01\0\0\x02\x4c\0\0\
\x58\0\0\0\x0b\x01\0\0\xdd\x01\0\0\x10\x50\0\0\x68\0\0\0\x0b\x01\0\0\x07\x02\0\
\0\x0c\x54\0\0\x70\0\0\0\x0b\x01\0\0\xdd\x01\0\0\x23\x50\0\0\x78\0\0\0\x0b\x01\
\0\0\xdd\x01\0\0\x0e\x50\0\0\x80\0\0\0\x0b\x01\0\0\x19\x02\0\0\x02\x58\0\0\xc0\
\0\0\0\x0b\x01\0\0\x69\x02\0\0\x01\x1c\x01\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\
\0\0\0\0\0\0\0\0\0\0\0\x03\0\x03\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x03\
\0\x05\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x03\0\x07\0\0\0\0\0\0\0\0\0\0\
\0\0\0\0\0\0\0\0\0\0\0\x03\0\x09\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x03\
\0\x0b\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x03\0\x0d\0\0\0\0\0\0\0\0\0\0\
\0\0\0\0\0\0\0\0\0\0\0\x03\0\x0f\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x03\
\0\x11\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x45\x02\0\0\x12\0\x03\0\0\0\0\0\0\0\0\
\0\xc8\0\0\0\0\0\0\0\x14\0\0\0\x11\0\x14\0\0\0\0\0\0\0\0\0\x18\0\0\0\0\0\0\0\
\xa1\x01\0\0\x12\0\x05\0\0\0\0\0\0\0\0\0\xc8\0\0\0\0\0\0\0\xef\x01\0\0\x12\0\
\x07\0\0\0\0\0\0\0\0\0\xc8\0\0\0\0\0\0\0\x53\x01\0\0\x12\0\x09\0\0\0\0\0\0\0\0\
\0\xc8\0\0\0\0\0\0\0\x87\0\0\0\x12\0\x0b\0\0\0\0\0\0\0\0\0\xc8\0\0\0\0\0\0\0\
\xb2\x02\0\0\x12\0\x0d\0\0\0\0\0\0\0\0\0\xc8\0\0\0\0\0\0\0\xe9\0\0\0\x12\0\x0f\
\0\0\0\0\0\0\0\0\0\xc8\0\0\0\0\0\0\0\x21\0\0\0\x12\0\x11\0\0\0\0\0\0\0\0\0\xc8\
\0\0\0\0\0\0\0\xaa\x02\0\0\x11\0\x13\0\0\0\0\0\0\0\0\0\x04\0\0\0\0\0\0\0\x88\0\
\0\0\0\0\0\0\x01\0\0\0\x0a\0\0\0\x88\0\0\0\0\0\0\0\x01\0\0\0\x0a\0\0\0\x88\0\0\
\0\0\0\0\0\x01\0\0\0\x0a\0\0\0\x88\0\0\0\0\0\0\0\x01\0\0\0\x0a\0\0\0\x88\0\0\0\
\0\0\0\0\x01\0\0\0\x0a\0\0\0\x88\0\0\0\0\0\0\0\x01\0\0\0\x0a\0\0\0\x88\0\0\0\0\
\0\0\0\x01\0\0\0\x0a\0\0\0\x88\0\0\0\0\0\0\0\x01\0\0\0\x0a\0\0\0\xd8\x02\0\0\0\
\0\0\0\x04\0\0\0\x0a\0\0\0\xf0\x02\0\0\0\0\0\0\x04\0\0\0\x12\0\0\0\x2c\0\0\0\0\
\0\0\0\x04\0\0\0\x01\0\0\0\x3c\0\0\0\0\0\0\0\x04\0\0\0\x02\0\0\0\x4c\0\0\0\0\0\
\0\0\x04\0\0\0\x03\0\0\0\x5c\0\0\0\0\0\0\0\x04\0\0\0\x04\0\0\0\x6c\0\0\0\0\0\0\
\0\x04\0\0\0\x05\0\0\0\x7c\0\0\0\0\0\0\0\x04\0\0\0\x06\0\0\0\x8c\0\0\0\0\0\0\0\
\x04\0\0\0\x07\0\0\0\x9c\0\0\0\0\0\0\0\x04\0\0\0\x08\0\0\0\xb0\0\0\0\0\0\0\0\
\x04\0\0\0\x01\0\0\0\xc0\0\0\0\0\0\0\0\x04\0\0\0\x01\0\0\0\xd0\0\0\0\0\0\0\0\
\x04\0\0\0\x01\0\0\0\xe0\0\0\0\0\0\0\0\x04\0\0\0\x01\0\0\0\xf0\0\0\0\0\0\0\0\
\x04\0\0\0\x01\0\0\0\0\x01\0\0\0\0\0\0\x04\0\0\0\x01\0\0\0\x10\x01\0\0\0\0\0\0\
\x04\0\0\0\x01\0\0\0\x20\x01\0\0\0\0\0\0\x04\0\0\0\x01\0\0\0\x30\x01\0\0\0\0\0\
\0\x04\0\0\0\x01\0\0\0\x48\x01\0\0\0\0\0\0\x04\0\0\0\x02\0\0\0\x58\x01\0\0\0\0\
\0\0\x04\0\0\0\x02\0\0\0\x68\x01\0\0\0\0\0\0\x04\0\0\0\x02\0\0\0\x78\x01\0\0\0\
\0\0\0\x04\0\0\0\x02\0\0\0\x88\x01\0\0\0\0\0\0\x04\0\0\0\x02\0\0\0\x98\x01\0\0\
\0\0\0\0\x04\0\0\0\x02\0\0\0\xa8\x01\0\0\0\0\0\0\x04\0\0\0\x02\0\0\0\xb8\x01\0\
\0\0\0\0\0\x04\0\0\0\x02\0\0\0\xc8\x01\0\0\0\0\0\0\x04\0\0\0\x02\0\0\0\xe0\x01\
\0\0\0\0\0\0\x04\0\0\0\x03\0\0\0\xf0\x01\0\0\0\0\0\0\x04\0\0\0\x03\0\0\0\0\x02\
\0\0\0\0\0\0\x04\0\0\0\x03\0\0\0\x10\x02\0\0\0\0\0\0\x04\0\0\0\x03\0\0\0\x20\
\x02\0\0\0\0\0\0\x04\0\0\0\x03\0\0\0\x30\x02\0\0\0\0\0\0\x04\0\0\0\x03\0\0\0\
\x40\x02\0\0\0\0\0\0\x04\0\0\0\x03\0\0\0\x50\x02\0\0\0\0\0\0\x04\0\0\0\x03\0\0\
\0\x60\x02\0\0\0\0\0\0\x04\0\0\0\x03\0\0\0\x78\x02\0\0\0\0\0\0\x04\0\0\0\x04\0\
\0\0\x88\x02\0\0\0\0\0\0\x04\0\0\0\x04\0\0\0\x98\x02\0\0\0\0\0\0\x04\0\0\0\x04\
\0\0\0\xa8\x02\0\0\0\0\0\0\x04\0\0\0\x04\0\0\0\xb8\x02\0\0\0\0\0\0\x04\0\0\0\
\x04\0\0\0\xc8\x02\0\0\0\0\0\0\x04\0\0\0\x04\0\0\0\xd8\x02\0\0\0\0\0\0\x04\0\0\
\0\x04\0\0\0\xe8\x02\0\0\0\0\0\0\x04\0\0\0\x04\0\0\0\xf8\x02\0\0\0\0\0\0\x04\0\
\0\0\x04\0\0\0\x10\x03\0\0\0\0\0\0\x04\0\0\0\x05\0\0\0\x20\x03\0\0\0\0\0\0\x04\
\0\0\0\x05\0\0\0\x30\x03\0\0\0\0\0\0\x04\0\0\0\x05\0\0\0\x40\x03\0\0\0\0\0\0\
\x04\0\0\0\x05\0\0\0\x50\x03\0\0\0\0\0\0\x04\0\0\0\x05\0\0\0\x60\x03\0\0\0\0\0\
\0\x04\0\0\0\x05\0\0\0\x70\x03\0\0\0\0\0\0\x04\0\0\0\x05\0\0\0\x80\x03\0\0\0\0\
\0\0\x04\0\0\0\x05\0\0\0\x90\x03\0\0\0\0\0\0\x04\0\0\0\x05\0\0\0\xa8\x03\0\0\0\
\0\0\0\x04\0\0\0\x06\0\0\0\xb8\x03\0\0\0\0\0\0\x04\0\0\0\x06\0\0\0\xc8\x03\0\0\
\0\0\0\0\x04\0\0\0\x06\0\0\0\xd8\x03\0\0\0\0\0\0\x04\0\0\0\x06\0\0\0\xe8\x03\0\
\0\0\0\0\0\x04\0\0\0\x06\0\0\0\xf8\x03\0\0\0\0\0\0\x04\0\0\0\x06\0\0\0\x08\x04\
\0\0\0\0\0\0\x04\0\0\0\x06\0\0\0\x18\x04\0\0\0\0\0\0\x04\0\0\0\x06\0\0\0\x28\
\x04\0\0\0\0\0\0\x04\0\0\0\x06\0\0\0\x40\x04\0\0\0\0\0\0\x04\0\0\0\x07\0\0\0\
\x50\x04\0\0\0\0\0\0\x04\0\0\0\x07\0\0\0\x60\x04\0\0\0\0\0\0\x04\0\0\0\x07\0\0\
\0\x70\x04\0\0\0\0\0\0\x04\0\0\0\x07\0\0\0\x80\x04\0\0\0\0\0\0\x04\0\0\0\x07\0\
\0\0\x90\x04\0\0\0\0\0\0\x04\0\0\0\x07\0\0\0\xa0\x04\0\0\0\0\0\0\x04\0\0\0\x07\
\0\0\0\xb0\x04\0\0\0\0\0\0\x04\0\0\0\x07\0\0\0\xc0\x04\0\0\0\0\0\0\x04\0\0\0\
\x07\0\0\0\xd8\x04\0\0\0\0\0\0\x04\0\0\0\x08\0\0\0\xe8\x04\0\0\0\0\0\0\x04\0\0\
\0\x08\0\0\0\xf8\x04\0\0\0\0\0\0\x04\0\0\0\x08\0\0\0\x08\x05\0\0\0\0\0\0\x04\0\
\0\0\x08\0\0\0\x18\x05\0\0\0\0\0\0\x04\0\0\0\x08\0\0\0\x28\x05\0\0\0\0\0\0\x04\
\0\0\0\x08\0\0\0\x38\x05\0\0\0\0\0\0\x04\0\0\0\x08\0\0\0\x48\x05\0\0\0\0\0\0\
\x04\0\0\0\x08\0\0\0\x58\x05\0\0\0\0\0\0\x04\0\0\0\x08\0\0\0\x13\x15\x16\x17\
\x18\x19\x1a\x1b\x1c\x14\0\x2e\x74\x65\x78\x74\0\x2e\x72\x65\x6c\x2e\x42\x54\
\x46\x2e\x65\x78\x74\0\x65\x76\x65\x6e\x74\x73\0\x2e\x6d\x61\x70\x73\0\x74\x72\
\x61\x63\x65\x70\x6f\x69\x6e\x74\x5f\x5f\x73\x79\x73\x63\x61\x6c\x6c\x73\x5f\
\x5f\x73\x79\x73\x5f\x65\x6e\x74\x65\x72\x5f\x73\x79\x6e\x63\x66\x73\0\x2e\x72\
\x65\x6c\x74\x72\x61\x63\x65\x70\x6f\x69\x6e\x74\x2f\x73\x79\x73\x63\x61\x6c\
\x6c\x73\x2f\x73\x79\x73\x5f\x65\x6e\x74\x65\x72\x5f\x73\x79\x6e\x63\x66\x73\0\
\x2e\x6c\x6c\x76\x6d\x5f\x61\x64\x64\x72\x73\x69\x67\0\x6c\x69\x63\x65\x6e\x73\
\x65\0\x74\x72\x61\x63\x65\x70\x6f\x69\x6e\x74\x5f\x5f\x73\x79\x73\x63\x61\x6c\
\x6c\x73\x5f\x5f\x73\x79\x73\x5f\x65\x6e\x74\x65\x72\x5f\x73\x79\x6e\x63\x5f\
\x66\x69\x6c\x65\x5f\x72\x61\x6e\x67\x65\0\x2e\x72\x65\x6c\x74\x72\x61\x63\x65\
\x70\x6f\x69\x6e\x74\x2f\x73\x79\x73\x63\x61\x6c\x6c\x73\x2f\x73\x79\x73\x5f\
\x65\x6e\x74\x65\x72\x5f\x73\x79\x6e\x63\x5f\x66\x69\x6c\x65\x5f\x72\x61\x6e\
\x67\x65\0\x74\x72\x61\x63\x65\x70\x6f\x69\x6e\x74\x5f\x5f\x73\x79\x73\x63\x61\
\x6c\x6c\x73\x5f\x5f\x73\x79\x73\x5f\x65\x6e\x74\x65\x72\x5f\x61\x72\x6d\x5f\
\x73\x79\x6e\x63\x5f\x66\x69\x6c\x65\x5f\x72\x61\x6e\x67\x65\0\x2e\x72\x65\x6c\
\x74\x72\x61\x63\x65\x70\x6f\x69\x6e\x74\x2f\x73\x79\x73\x63\x61\x6c\x6c\x73\
\x2f\x73\x79\x73\x5f\x65\x6e\x74\x65\x72\x5f\x61\x72\x6d\x5f\x73\x79\x6e\x63\
\x5f\x66\x69\x6c\x65\x5f\x72\x61\x6e\x67\x65\0\x74\x72\x61\x63\x65\x70\x6f\x69\
\x6e\x74\x5f\x5f\x73\x79\x73\x63\x61\x6c\x6c\x73\x5f\x5f\x73\x79\x73\x5f\x65\
\x6e\x74\x65\x72\x5f\x6d\x73\x79\x6e\x63\0\x2e\x72\x65\x6c\x74\x72\x61\x63\x65\
\x70\x6f\x69\x6e\x74\x2f\x73\x79\x73\x63\x61\x6c\x6c\x73\x2f\x73\x79\x73\x5f\
\x65\x6e\x74\x65\x72\x5f\x6d\x73\x79\x6e\x63\0\x74\x72\x61\x63\x65\x70\x6f\x69\
\x6e\x74\x5f\x5f\x73\x79\x73\x63\x61\x6c\x6c\x73\x5f\x5f\x73\x79\x73\x5f\x65\
\x6e\x74\x65\x72\x5f\x66\x73\x79\x6e\x63\0\x2e\x72\x65\x6c\x74\x72\x61\x63\x65\
\x70\x6f\x69\x6e\x74\x2f\x73\x79\x73\x63\x61\x6c\x6c\x73\x2f\x73\x79\x73\x5f\
\x65\x6e\x74\x65\x72\x5f\x66\x73\x79\x6e\x63\0\x74\x72\x61\x63\x65\x70\x6f\x69\
\x6e\x74\x5f\x5f\x73\x79\x73\x63\x61\x6c\x6c\x73\x5f\x5f\x73\x79\x73\x5f\x65\
\x6e\x74\x65\x72\x5f\x66\x64\x61\x74\x61\x73\x79\x6e\x63\0\x2e\x72\x65\x6c\x74\
\x72\x61\x63\x65\x70\x6f\x69\x6e\x74\x2f\x73\x79\x73\x63\x61\x6c\x6c\x73\x2f\
\x73\x79\x73\x5f\x65\x6e\x74\x65\x72\x5f\x66\x64\x61\x74\x61\x73\x79\x6e\x63\0\
\x74\x72\x61\x63\x65\x70\x6f\x69\x6e\x74\x5f\x5f\x73\x79\x73\x63\x61\x6c\x6c\
\x73\x5f\x5f\x73\x79\x73\x5f\x65\x6e\x74\x65\x72\x5f\x73\x79\x6e\x63\0\x2e\x72\
\x65\x6c\x74\x72\x61\x63\x65\x70\x6f\x69\x6e\x74\x2f\x73\x79\x73\x63\x61\x6c\
\x6c\x73\x2f\x73\x79\x73\x5f\x65\x6e\x74\x65\x72\x5f\x73\x79\x6e\x63\0\x2e\x73\
\x74\x72\x74\x61\x62\0\x2e\x73\x79\x6d\x74\x61\x62\0\x2e\x72\x65\x6c\x2e\x42\
\x54\x46\0\x4c\x49\x43\x45\x4e\x53\x45\0\x74\x72\x61\x63\x65\x70\x6f\x69\x6e\
\x74\x5f\x5f\x73\x79\x73\x63\x61\x6c\x6c\x73\x5f\x5f\x73\x79\x73\x5f\x65\x6e\
\x74\x65\x72\x5f\x73\x79\x6e\x63\x5f\x66\x69\x6c\x65\x5f\x72\x61\x6e\x67\x65\
\x32\0\x2e\x72\x65\x6c\x74\x72\x61\x63\x65\x70\x6f\x69\x6e\x74\x2f\x73\x79\x73\
\x63\x61\x6c\x6c\x73\x2f\x73\x79\x73\x5f\x65\x6e\x74\x65\x72\x5f\x73\x79\x6e\
\x63\x5f\x66\x69\x6c\x65\x5f\x72\x61\x6e\x67\x65\x32\0\0\0\0\0\0\0\0\0\0\0\0\0\
\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\
\0\0\0\0\0\0\0\0\0\0\0\0\0\x91\x02\0\0\x03\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\
\0\xb2\x1d\0\0\0\0\0\0\x16\x03\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x01\0\0\0\0\0\0\0\0\
\0\0\0\0\0\0\0\x01\0\0\0\x01\0\0\0\x06\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x40\0\0\0\
\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x04\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x6e\
\x02\0\0\x01\0\0\0\x06\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x40\0\0\0\0\0\0\0\xc8\0\0\
\0\0\0\0\0\0\0\0\0\0\0\0\0\x08\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x6a\x02\0\0\x09\0\
\0\0\x40\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x08\x18\0\0\0\0\0\0\x10\0\0\0\0\0\0\0\
\x1a\0\0\0\x03\0\0\0\x08\0\0\0\0\0\0\0\x10\0\0\0\0\0\0\0\xcb\x01\0\0\x01\0\0\0\
\x06\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x08\x01\0\0\0\0\0\0\xc8\0\0\0\0\0\0\0\0\0\0\
\0\0\0\0\0\x08\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\xc7\x01\0\0\x09\0\0\0\x40\0\0\0\0\
\0\0\0\0\0\0\0\0\0\0\0\x18\x18\0\0\0\0\0\0\x10\0\0\0\0\0\0\0\x1a\0\0\0\x05\0\0\
\0\x08\0\0\0\0\0\0\0\x10\0\0\0\0\0\0\0\x1d\x02\0\0\x01\0\0\0\x06\0\0\0\0\0\0\0\
\0\0\0\0\0\0\0\0\xd0\x01\0\0\0\0\0\0\xc8\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x08\0\0\
\0\0\0\0\0\0\0\0\0\0\0\0\0\x19\x02\0\0\x09\0\0\0\x40\0\0\0\0\0\0\0\0\0\0\0\0\0\
\0\0\x28\x18\0\0\0\0\0\0\x10\0\0\0\0\0\0\0\x1a\0\0\0\x07\0\0\0\x08\0\0\0\0\0\0\
\0\x10\0\0\0\0\0\0\0\x7d\x01\0\0\x01\0\0\0\x06\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\
\x98\x02\0\0\0\0\0\0\xc8\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x08\0\0\0\0\0\0\0\0\0\0\
\0\0\0\0\0\x79\x01\0\0\x09\0\0\0\x40\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x38\x18\0\0\
\0\0\0\0\x10\0\0\0\0\0\0\0\x1a\0\0\0\x09\0\0\0\x08\0\0\0\0\0\0\0\x10\0\0\0\0\0\
\0\0\xbb\0\0\0\x01\0\0\0\x06\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x60\x03\0\0\0\0\0\0\
\xc8\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x08\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\xb7\0\0\0\
\x09\0\0\0\x40\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x48\x18\0\0\0\0\0\0\x10\0\0\0\0\0\
\0\0\x1a\0\0\0\x0b\0\0\0\x08\0\0\0\0\0\0\0\x10\0\0\0\0\0\0\0\xe7\x02\0\0\x01\0\
\0\0\x06\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x28\x04\0\0\0\0\0\0\xc8\0\0\0\0\0\0\0\0\
\0\0\0\0\0\0\0\x08\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\xe3\x02\0\0\x09\0\0\0\x40\0\0\
\0\0\0\0\0\0\0\0\0\0\0\0\0\x58\x18\0\0\0\0\0\0\x10\0\0\0\0\0\0\0\x1a\0\0\0\x0d\
\0\0\0\x08\0\0\0\0\0\0\0\x10\0\0\0\0\0\0\0\x21\x01\0\0\x01\0\0\0\x06\0\0\0\0\0\
\0\0\0\0\0\0\0\0\0\0\xf0\x04\0\0\0\0\0\0\xc8\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x08\
\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x1d\x01\0\0\x09\0\0\0\x40\0\0\0\0\0\0\0\0\0\0\0\
\0\0\0\0\x68\x18\0\0\0\0\0\0\x10\0\0\0\0\0\0\0\x1a\0\0\0\x0f\0\0\0\x08\0\0\0\0\
\0\0\0\x10\0\0\0\0\0\0\0\x4c\0\0\0\x01\0\0\0\x06\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\
\xb8\x05\0\0\0\0\0\0\xc8\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x08\0\0\0\0\0\0\0\0\0\0\
\0\0\0\0\0\x48\0\0\0\x09\0\0\0\x40\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x78\x18\0\0\0\
\0\0\0\x10\0\0\0\0\0\0\0\x1a\0\0\0\x11\0\0\0\x08\0\0\0\0\0\0\0\x10\0\0\0\0\0\0\
\0\x7f\0\0\0\x01\0\0\0\x03\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x80\x06\0\0\0\0\0\0\
\x04\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x01\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x1b\0\0\0\
\x01\0\0\0\x03\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x88\x06\0\0\0\0\0\0\x18\0\0\0\0\0\
\0\0\0\0\0\0\0\0\0\0\x08\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\xa5\x02\0\0\x01\0\0\0\0\
\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\xa0\x06\0\0\0\0\0\0\x35\x0a\0\0\0\0\0\0\0\0\0\0\
\0\0\0\0\x04\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\xa1\x02\0\0\x09\0\0\0\x40\0\0\0\0\0\
\0\0\0\0\0\0\0\0\0\0\x88\x18\0\0\0\0\0\0\x20\0\0\0\0\0\0\0\x1a\0\0\0\x15\0\0\0\
\x08\0\0\0\0\0\0\0\x10\0\0\0\0\0\0\0\x0b\0\0\0\x01\0\0\0\0\0\0\0\0\0\0\0\0\0\0\
\0\0\0\0\0\xd8\x10\0\0\0\0\0\0\x68\x05\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x04\0\0\0\0\
\0\0\0\0\0\0\0\0\0\0\0\x07\0\0\0\x09\0\0\0\x40\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\
\xa8\x18\0\0\0\0\0\0\0\x05\0\0\0\0\0\0\x1a\0\0\0\x17\0\0\0\x08\0\0\0\0\0\0\0\
\x10\0\0\0\0\0\0\0\x71\0\0\0\x03\x4c\xff\x6f\0\0\0\x80\0\0\0\0\0\0\0\0\0\0\0\0\
\xa8\x1d\0\0\0\0\0\0\x0a\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x01\0\0\0\0\0\0\0\0\0\0\
\0\0\0\0\0\x99\x02\0\0\x02\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x40\x16\0\0\0\
\0\0\0\xc8\x01\0\0\0\0\0\0\x01\0\0\0\x09\0\0\0\x08\0\0\0\0\0\0\0\x18\0\0\0\0\0\
\0\0";

	*sz = sizeof(data) - 1;
	return (const void *)data;
}

#ifdef __cplusplus
struct syncsnoop_bpf *syncsnoop_bpf::open(const struct bpf_object_open_opts *opts) { return syncsnoop_bpf__open_opts(opts); }
struct syncsnoop_bpf *syncsnoop_bpf::open_and_load() { return syncsnoop_bpf__open_and_load(); }
int syncsnoop_bpf::load(struct syncsnoop_bpf *skel) { return syncsnoop_bpf__load(skel); }
int syncsnoop_bpf::attach(struct syncsnoop_bpf *skel) { return syncsnoop_bpf__attach(skel); }
void syncsnoop_bpf::detach(struct syncsnoop_bpf *skel) { syncsnoop_bpf__detach(skel); }
void syncsnoop_bpf::destroy(struct syncsnoop_bpf *skel) { syncsnoop_bpf__destroy(skel); }
const void *syncsnoop_bpf::elf_bytes(size_t *sz) { return syncsnoop_bpf__elf_bytes(sz); }
#endif /* __cplusplus */

__attribute__((unused)) static void
syncsnoop_bpf__assert(struct syncsnoop_bpf *s __attribute__((unused)))
{
#ifdef __cplusplus
#define _Static_assert static_assert
#endif
#ifdef __cplusplus
#undef _Static_assert
#endif
}

#endif /* __SYNCSNOOP_BPF_SKEL_H__ */
