

-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Gdk.Callbacks
    ( 

 -- * Signals


-- ** ContentDeserializeFunc #signal:ContentDeserializeFunc#

    C_ContentDeserializeFunc                ,
    ContentDeserializeFunc                  ,
    dynamic_ContentDeserializeFunc          ,
    genClosure_ContentDeserializeFunc       ,
    mk_ContentDeserializeFunc               ,
    noContentDeserializeFunc                ,
    wrap_ContentDeserializeFunc             ,


-- ** ContentSerializeFunc #signal:ContentSerializeFunc#

    C_ContentSerializeFunc                  ,
    ContentSerializeFunc                    ,
    dynamic_ContentSerializeFunc            ,
    genClosure_ContentSerializeFunc         ,
    mk_ContentSerializeFunc                 ,
    noContentSerializeFunc                  ,
    wrap_ContentSerializeFunc               ,


-- ** CursorGetTextureCallback #signal:CursorGetTextureCallback#

    C_CursorGetTextureCallback              ,
    CursorGetTextureCallback                ,
    dynamic_CursorGetTextureCallback        ,
    genClosure_CursorGetTextureCallback     ,
    mk_CursorGetTextureCallback             ,
    noCursorGetTextureCallback              ,
    wrap_CursorGetTextureCallback           ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import qualified GI.GLib.Callbacks as GLib.Callbacks
import qualified GI.GLib.Structs.Bytes as GLib.Bytes
import qualified GI.GObject.Objects.Object as GObject.Object
import {-# SOURCE #-} qualified GI.Gdk.Enums as Gdk.Enums
import {-# SOURCE #-} qualified GI.Gdk.Flags as Gdk.Flags
import {-# SOURCE #-} qualified GI.Gdk.Interfaces.Paintable as Gdk.Paintable
import {-# SOURCE #-} qualified GI.Gdk.Objects.CicpParams as Gdk.CicpParams
import {-# SOURCE #-} qualified GI.Gdk.Objects.ContentDeserializer as Gdk.ContentDeserializer
import {-# SOURCE #-} qualified GI.Gdk.Objects.ContentSerializer as Gdk.ContentSerializer
import {-# SOURCE #-} qualified GI.Gdk.Objects.Cursor as Gdk.Cursor
import {-# SOURCE #-} qualified GI.Gdk.Objects.Snapshot as Gdk.Snapshot
import {-# SOURCE #-} qualified GI.Gdk.Objects.Texture as Gdk.Texture
import {-# SOURCE #-} qualified GI.Gdk.Structs.ColorState as Gdk.ColorState
import qualified GI.GdkPixbuf.Objects.Pixbuf as GdkPixbuf.Pixbuf
import qualified GI.Gio.Interfaces.AsyncResult as Gio.AsyncResult
import qualified GI.Gio.Interfaces.File as Gio.File
import qualified GI.Gio.Interfaces.Icon as Gio.Icon
import qualified GI.Gio.Interfaces.LoadableIcon as Gio.LoadableIcon
import qualified GI.Gio.Objects.Cancellable as Gio.Cancellable
import qualified GI.Gio.Objects.InputStream as Gio.InputStream
import qualified GI.Gio.Objects.OutputStream as Gio.OutputStream

#else
import {-# SOURCE #-} qualified GI.Gdk.Objects.ContentDeserializer as Gdk.ContentDeserializer
import {-# SOURCE #-} qualified GI.Gdk.Objects.ContentSerializer as Gdk.ContentSerializer
import {-# SOURCE #-} qualified GI.Gdk.Objects.Cursor as Gdk.Cursor
import {-# SOURCE #-} qualified GI.Gdk.Objects.Texture as Gdk.Texture

#endif

-- callback CursorGetTextureCallback
{- Callable
  { returnType =
      Just (TInterface Name { namespace = "Gdk" , name = "Texture" })
  , returnMayBeNull = True
  , returnTransfer = TransferEverything
  , returnDocumentation =
      Documentation
        { rawDocText =
            Just "the cursor image, or\n  `NULL` if none could be produced."
        , sinceVersion = Nothing
        }
  , args =
      [ Arg
          { argCName = "cursor"
          , argType = TInterface Name { namespace = "Gdk" , name = "Cursor" }
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "the `GdkCursor`" , sinceVersion = Nothing }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "cursor_size"
          , argType = TBasicType TInt
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText =
                    Just "the nominal cursor size, in application pixels"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "scale"
          , argType = TBasicType TDouble
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "the device scale" , sinceVersion = Nothing }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "width"
          , argType = TBasicType TInt
          , direction = DirectionOut
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText =
                    Just
                      "return location for the actual cursor width,\n  in application pixels"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferEverything
          }
      , Arg
          { argCName = "height"
          , argType = TBasicType TInt
          , direction = DirectionOut
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText =
                    Just
                      "return location for the actual cursor height,\n  in application pixels"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferEverything
          }
      , Arg
          { argCName = "hotspot_x"
          , argType = TBasicType TInt
          , direction = DirectionOut
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText =
                    Just
                      "return location for the hotspot X position,\n  in application pixels"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferEverything
          }
      , Arg
          { argCName = "hotspot_y"
          , argType = TBasicType TInt
          , direction = DirectionOut
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText =
                    Just
                      "return location for the hotspot Y position,\n  in application pixels"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferEverything
          }
      , Arg
          { argCName = "data"
          , argType = TBasicType TPtr
          , direction = DirectionIn
          , mayBeNull = True
          , argDoc =
              Documentation
                { rawDocText = Just "User data for the callback"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      ]
  , skipReturn = False
  , callableThrows = False
  , callableDeprecated = Nothing
  , callableDocumentation =
      Documentation
        { rawDocText =
            Just
              "The type of callback used by a dynamic `GdkCursor` to generate\na texture for the cursor image at the given @cursor_size\nand @scale.\n\nThe actual cursor size in application pixels may be different\nfrom @cursor_size x @cursor_size, and will be returned in\n@width, @height. The returned texture should have a size that\ncorresponds to the actual cursor size, in device pixels (i.e.\napplication pixels, multiplied by @scale).\n\nThis function may fail and return `NULL`, in which case\nthe fallback cursor will be used."
        , sinceVersion = Nothing
        }
  , callableResolvable = Nothing
  }
-}
-- | Type for the callback on the (unwrapped) C side.
type C_CursorGetTextureCallback =
    Ptr Gdk.Cursor.Cursor ->
    Int32 ->
    CDouble ->
    Ptr Int32 ->
    Ptr Int32 ->
    Ptr Int32 ->
    Ptr Int32 ->
    Ptr () ->
    IO (Ptr Gdk.Texture.Texture)

-- Args: [ Arg
--           { argCName = "cursor"
--           , argType = TInterface Name { namespace = "Gdk" , name = "Cursor" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the `GdkCursor`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "cursor_size"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "the nominal cursor size, in application pixels"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "scale"
--           , argType = TBasicType TDouble
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the device scale" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "width"
--           , argType = TBasicType TInt
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "return location for the actual cursor width,\n  in application pixels"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferEverything
--           }
--       , Arg
--           { argCName = "height"
--           , argType = TBasicType TInt
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "return location for the actual cursor height,\n  in application pixels"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferEverything
--           }
--       , Arg
--           { argCName = "hotspot_x"
--           , argType = TBasicType TInt
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "return location for the hotspot X position,\n  in application pixels"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferEverything
--           }
--       , Arg
--           { argCName = "hotspot_y"
--           , argType = TBasicType TInt
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "return location for the hotspot Y position,\n  in application pixels"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferEverything
--           }
--       , Arg
--           { argCName = "data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "User data for the callback"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gdk" , name = "Texture" })
-- throws : False
-- Skip return : False

foreign import ccall "dynamic" __dynamic_C_CursorGetTextureCallback :: FunPtr C_CursorGetTextureCallback -> C_CursorGetTextureCallback

-- | Given a pointer to a foreign C function, wrap it into a function callable from Haskell.
dynamic_CursorGetTextureCallback ::
    (B.CallStack.HasCallStack, MonadIO m, Gdk.Cursor.IsCursor a) =>
    FunPtr C_CursorGetTextureCallback
    -> a
    -- ^ /@cursor@/: the @GdkCursor@
    -> Int32
    -- ^ /@cursorSize@/: the nominal cursor size, in application pixels
    -> Double
    -- ^ /@scale@/: the device scale
    -> Ptr ()
    -- ^ /@data@/: User data for the callback
    -> m ((Maybe Gdk.Texture.Texture, Int32, Int32, Int32, Int32))
    -- ^ __Returns:__ the cursor image, or
    --   @NULL@ if none could be produced.
dynamic_CursorGetTextureCallback __funPtr cursor cursorSize scale data_ = liftIO $ do
    cursor' <- unsafeManagedPtrCastPtr cursor
    let scale' = realToFrac scale
    width <- allocMem :: IO (Ptr Int32)
    height <- allocMem :: IO (Ptr Int32)
    hotspotX <- allocMem :: IO (Ptr Int32)
    hotspotY <- allocMem :: IO (Ptr Int32)
    result <- (__dynamic_C_CursorGetTextureCallback __funPtr) cursor' cursorSize scale' width height hotspotX hotspotY data_
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- (wrapObject Gdk.Texture.Texture) result'
        return result''
    width' <- peek width
    height' <- peek height
    hotspotX' <- peek hotspotX
    hotspotY' <- peek hotspotY
    touchManagedPtr cursor
    freeMem width
    freeMem height
    freeMem hotspotX
    freeMem hotspotY
    return (maybeResult, width', height', hotspotX', hotspotY')

-- | Generate a function pointer callable from C code, from a `C_CursorGetTextureCallback`.
foreign import ccall "wrapper"
    mk_CursorGetTextureCallback :: C_CursorGetTextureCallback -> IO (FunPtr C_CursorGetTextureCallback)

-- | The type of callback used by a dynamic @GdkCursor@ to generate
-- a texture for the cursor image at the given /@cursorSize@/
-- and /@scale@/.
-- 
-- The actual cursor size in application pixels may be different
-- from /@cursorSize@/ x /@cursorSize@/, and will be returned in
-- /@width@/, /@height@/. The returned texture should have a size that
-- corresponds to the actual cursor size, in device pixels (i.e.
-- application pixels, multiplied by /@scale@/).
-- 
-- This function may fail and return @NULL@, in which case
-- the fallback cursor will be used.
type CursorGetTextureCallback =
    Gdk.Cursor.Cursor
    -- ^ /@cursor@/: the @GdkCursor@
    -> Int32
    -- ^ /@cursorSize@/: the nominal cursor size, in application pixels
    -> Double
    -- ^ /@scale@/: the device scale
    -> Ptr ()
    -- ^ /@data@/: User data for the callback
    -> IO ((Maybe Gdk.Texture.Texture, Int32, Int32, Int32, Int32))
    -- ^ __Returns:__ the cursor image, or
    --   @NULL@ if none could be produced.

-- | A convenience synonym for @`Nothing` :: `Maybe` `CursorGetTextureCallback`@.
noCursorGetTextureCallback :: Maybe CursorGetTextureCallback
noCursorGetTextureCallback = Nothing

-- | Wrap the callback into a `GClosure`.
genClosure_CursorGetTextureCallback :: MonadIO m => CursorGetTextureCallback -> m (GClosure C_CursorGetTextureCallback)
genClosure_CursorGetTextureCallback cb = liftIO $ do
    let cb' = wrap_CursorGetTextureCallback Nothing cb
    mk_CursorGetTextureCallback cb' >>= B.GClosure.newGClosure


-- | Wrap a `CursorGetTextureCallback` into a `C_CursorGetTextureCallback`.
wrap_CursorGetTextureCallback :: 
    Maybe (Ptr (FunPtr C_CursorGetTextureCallback)) ->
    CursorGetTextureCallback ->
    C_CursorGetTextureCallback
wrap_CursorGetTextureCallback gi'funptrptr gi'cb cursor cursorSize scale width height hotspotX hotspotY data_ = do
    cursor' <- (newObject Gdk.Cursor.Cursor) cursor
    let scale' = realToFrac scale
    (result, outwidth, outheight, outhotspotX, outhotspotY) <- gi'cb  cursor' cursorSize scale' data_
    poke width outwidth
    poke height outheight
    poke hotspotX outhotspotX
    poke hotspotY outhotspotY
    maybeReleaseFunPtr gi'funptrptr
    maybeM FP.nullPtr result $ \result' -> do
        result'' <- B.ManagedPtr.disownObject result'
        return result''


-- callback ContentSerializeFunc
{- Callable
  { returnType = Nothing
  , returnMayBeNull = False
  , returnTransfer = TransferNothing
  , returnDocumentation =
      Documentation { rawDocText = Nothing , sinceVersion = Nothing }
  , args =
      [ Arg
          { argCName = "serializer"
          , argType =
              TInterface Name { namespace = "Gdk" , name = "ContentSerializer" }
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "a `GdkContentSerializer`"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      ]
  , skipReturn = False
  , callableThrows = False
  , callableDeprecated = Nothing
  , callableDocumentation =
      Documentation
        { rawDocText =
            Just
              "The type of a function that can be registered with gdk_content_register_serializer().\n\nWhen the function gets called to operate on content, it can call functions on the\n@serializer object to obtain the mime type, output stream, user data, etc. for its\noperation."
        , sinceVersion = Nothing
        }
  , callableResolvable = Nothing
  }
-}
-- | Type for the callback on the (unwrapped) C side.
type C_ContentSerializeFunc =
    Ptr Gdk.ContentSerializer.ContentSerializer ->
    IO ()

-- Args: [ Arg
--           { argCName = "serializer"
--           , argType =
--               TInterface Name { namespace = "Gdk" , name = "ContentSerializer" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GdkContentSerializer`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "dynamic" __dynamic_C_ContentSerializeFunc :: FunPtr C_ContentSerializeFunc -> C_ContentSerializeFunc

-- | Given a pointer to a foreign C function, wrap it into a function callable from Haskell.
dynamic_ContentSerializeFunc ::
    (B.CallStack.HasCallStack, MonadIO m, Gdk.ContentSerializer.IsContentSerializer a) =>
    FunPtr C_ContentSerializeFunc
    -> a
    -- ^ /@serializer@/: a @GdkContentSerializer@
    -> m ()
dynamic_ContentSerializeFunc __funPtr serializer = liftIO $ do
    serializer' <- unsafeManagedPtrCastPtr serializer
    (__dynamic_C_ContentSerializeFunc __funPtr) serializer'
    touchManagedPtr serializer
    return ()

-- | Generate a function pointer callable from C code, from a `C_ContentSerializeFunc`.
foreign import ccall "wrapper"
    mk_ContentSerializeFunc :: C_ContentSerializeFunc -> IO (FunPtr C_ContentSerializeFunc)

-- | The type of a function that can be registered with 'GI.Gdk.Functions.contentRegisterSerializer'.
-- 
-- When the function gets called to operate on content, it can call functions on the
-- /@serializer@/ object to obtain the mime type, output stream, user data, etc. for its
-- operation.
type ContentSerializeFunc =
    Gdk.ContentSerializer.ContentSerializer
    -- ^ /@serializer@/: a @GdkContentSerializer@
    -> IO ()

-- | A convenience synonym for @`Nothing` :: `Maybe` `ContentSerializeFunc`@.
noContentSerializeFunc :: Maybe ContentSerializeFunc
noContentSerializeFunc = Nothing

-- | Wrap the callback into a `GClosure`.
genClosure_ContentSerializeFunc :: MonadIO m => ContentSerializeFunc -> m (GClosure C_ContentSerializeFunc)
genClosure_ContentSerializeFunc cb = liftIO $ do
    let cb' = wrap_ContentSerializeFunc Nothing cb
    mk_ContentSerializeFunc cb' >>= B.GClosure.newGClosure


-- | Wrap a `ContentSerializeFunc` into a `C_ContentSerializeFunc`.
wrap_ContentSerializeFunc :: 
    Maybe (Ptr (FunPtr C_ContentSerializeFunc)) ->
    ContentSerializeFunc ->
    C_ContentSerializeFunc
wrap_ContentSerializeFunc gi'funptrptr gi'cb serializer = do
    serializer' <- (newObject Gdk.ContentSerializer.ContentSerializer) serializer
    gi'cb  serializer'
    maybeReleaseFunPtr gi'funptrptr


-- callback ContentDeserializeFunc
{- Callable
  { returnType = Nothing
  , returnMayBeNull = False
  , returnTransfer = TransferNothing
  , returnDocumentation =
      Documentation { rawDocText = Nothing , sinceVersion = Nothing }
  , args =
      [ Arg
          { argCName = "deserializer"
          , argType =
              TInterface
                Name { namespace = "Gdk" , name = "ContentDeserializer" }
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "a `GdkContentDeserializer`"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      ]
  , skipReturn = False
  , callableThrows = False
  , callableDeprecated = Nothing
  , callableDocumentation =
      Documentation
        { rawDocText =
            Just
              "The type of a function that can be registered with gdk_content_register_deserializer().\n\nWhen the function gets called to operate on content, it can call functions on the\n@deserializer object to obtain the mime type, input stream, user data, etc. for its\noperation."
        , sinceVersion = Nothing
        }
  , callableResolvable = Nothing
  }
-}
-- | Type for the callback on the (unwrapped) C side.
type C_ContentDeserializeFunc =
    Ptr Gdk.ContentDeserializer.ContentDeserializer ->
    IO ()

-- Args: [ Arg
--           { argCName = "deserializer"
--           , argType =
--               TInterface
--                 Name { namespace = "Gdk" , name = "ContentDeserializer" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GdkContentDeserializer`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "dynamic" __dynamic_C_ContentDeserializeFunc :: FunPtr C_ContentDeserializeFunc -> C_ContentDeserializeFunc

-- | Given a pointer to a foreign C function, wrap it into a function callable from Haskell.
dynamic_ContentDeserializeFunc ::
    (B.CallStack.HasCallStack, MonadIO m, Gdk.ContentDeserializer.IsContentDeserializer a) =>
    FunPtr C_ContentDeserializeFunc
    -> a
    -- ^ /@deserializer@/: a @GdkContentDeserializer@
    -> m ()
dynamic_ContentDeserializeFunc __funPtr deserializer = liftIO $ do
    deserializer' <- unsafeManagedPtrCastPtr deserializer
    (__dynamic_C_ContentDeserializeFunc __funPtr) deserializer'
    touchManagedPtr deserializer
    return ()

-- | Generate a function pointer callable from C code, from a `C_ContentDeserializeFunc`.
foreign import ccall "wrapper"
    mk_ContentDeserializeFunc :: C_ContentDeserializeFunc -> IO (FunPtr C_ContentDeserializeFunc)

-- | The type of a function that can be registered with 'GI.Gdk.Functions.contentRegisterDeserializer'.
-- 
-- When the function gets called to operate on content, it can call functions on the
-- /@deserializer@/ object to obtain the mime type, input stream, user data, etc. for its
-- operation.
type ContentDeserializeFunc =
    Gdk.ContentDeserializer.ContentDeserializer
    -- ^ /@deserializer@/: a @GdkContentDeserializer@
    -> IO ()

-- | A convenience synonym for @`Nothing` :: `Maybe` `ContentDeserializeFunc`@.
noContentDeserializeFunc :: Maybe ContentDeserializeFunc
noContentDeserializeFunc = Nothing

-- | Wrap the callback into a `GClosure`.
genClosure_ContentDeserializeFunc :: MonadIO m => ContentDeserializeFunc -> m (GClosure C_ContentDeserializeFunc)
genClosure_ContentDeserializeFunc cb = liftIO $ do
    let cb' = wrap_ContentDeserializeFunc Nothing cb
    mk_ContentDeserializeFunc cb' >>= B.GClosure.newGClosure


-- | Wrap a `ContentDeserializeFunc` into a `C_ContentDeserializeFunc`.
wrap_ContentDeserializeFunc :: 
    Maybe (Ptr (FunPtr C_ContentDeserializeFunc)) ->
    ContentDeserializeFunc ->
    C_ContentDeserializeFunc
wrap_ContentDeserializeFunc gi'funptrptr gi'cb deserializer = do
    deserializer' <- (newObject Gdk.ContentDeserializer.ContentDeserializer) deserializer
    gi'cb  deserializer'
    maybeReleaseFunPtr gi'funptrptr



