/*
 * This file is generated by gdbus-codegen, do not modify it.
 *
 * The license of this code is the same as for the D-Bus interface description
 * it was derived from. Note that it links to GLib, so must comply with the
 * LGPL linking clauses.
 */

#ifdef HAVE_CONFIG_H
#  include "config.h"
#endif

#include "dbus-interface.h"

#include <string.h>
#ifdef G_OS_UNIX
#  include <gio/gunixfdlist.h>
#endif

#ifdef G_ENABLE_DEBUG
#define g_marshal_value_peek_boolean(v)  g_value_get_boolean (v)
#define g_marshal_value_peek_char(v)     g_value_get_schar (v)
#define g_marshal_value_peek_uchar(v)    g_value_get_uchar (v)
#define g_marshal_value_peek_int(v)      g_value_get_int (v)
#define g_marshal_value_peek_uint(v)     g_value_get_uint (v)
#define g_marshal_value_peek_long(v)     g_value_get_long (v)
#define g_marshal_value_peek_ulong(v)    g_value_get_ulong (v)
#define g_marshal_value_peek_int64(v)    g_value_get_int64 (v)
#define g_marshal_value_peek_uint64(v)   g_value_get_uint64 (v)
#define g_marshal_value_peek_enum(v)     g_value_get_enum (v)
#define g_marshal_value_peek_flags(v)    g_value_get_flags (v)
#define g_marshal_value_peek_float(v)    g_value_get_float (v)
#define g_marshal_value_peek_double(v)   g_value_get_double (v)
#define g_marshal_value_peek_string(v)   (char*) g_value_get_string (v)
#define g_marshal_value_peek_param(v)    g_value_get_param (v)
#define g_marshal_value_peek_boxed(v)    g_value_get_boxed (v)
#define g_marshal_value_peek_pointer(v)  g_value_get_pointer (v)
#define g_marshal_value_peek_object(v)   g_value_get_object (v)
#define g_marshal_value_peek_variant(v)  g_value_get_variant (v)
#else /* !G_ENABLE_DEBUG */
/* WARNING: This code accesses GValues directly, which is UNSUPPORTED API.
 *          Do not access GValues directly in your code. Instead, use the
 *          g_value_get_*() functions
 */
#define g_marshal_value_peek_boolean(v)  (v)->data[0].v_int
#define g_marshal_value_peek_char(v)     (v)->data[0].v_int
#define g_marshal_value_peek_uchar(v)    (v)->data[0].v_uint
#define g_marshal_value_peek_int(v)      (v)->data[0].v_int
#define g_marshal_value_peek_uint(v)     (v)->data[0].v_uint
#define g_marshal_value_peek_long(v)     (v)->data[0].v_long
#define g_marshal_value_peek_ulong(v)    (v)->data[0].v_ulong
#define g_marshal_value_peek_int64(v)    (v)->data[0].v_int64
#define g_marshal_value_peek_uint64(v)   (v)->data[0].v_uint64
#define g_marshal_value_peek_enum(v)     (v)->data[0].v_long
#define g_marshal_value_peek_flags(v)    (v)->data[0].v_ulong
#define g_marshal_value_peek_float(v)    (v)->data[0].v_float
#define g_marshal_value_peek_double(v)   (v)->data[0].v_double
#define g_marshal_value_peek_string(v)   (v)->data[0].v_pointer
#define g_marshal_value_peek_param(v)    (v)->data[0].v_pointer
#define g_marshal_value_peek_boxed(v)    (v)->data[0].v_pointer
#define g_marshal_value_peek_pointer(v)  (v)->data[0].v_pointer
#define g_marshal_value_peek_object(v)   (v)->data[0].v_pointer
#define g_marshal_value_peek_variant(v)  (v)->data[0].v_pointer
#endif /* !G_ENABLE_DEBUG */

typedef struct
{
  GDBusArgInfo parent_struct;
  gboolean use_gvariant;
} _ExtendedGDBusArgInfo;

typedef struct
{
  GDBusMethodInfo parent_struct;
  const gchar *signal_name;
  gboolean pass_fdlist;
} _ExtendedGDBusMethodInfo;

typedef struct
{
  GDBusSignalInfo parent_struct;
  const gchar *signal_name;
} _ExtendedGDBusSignalInfo;

typedef struct
{
  GDBusPropertyInfo parent_struct;
  const gchar *hyphen_name;
  guint use_gvariant : 1;
  guint emits_changed_signal : 1;
} _ExtendedGDBusPropertyInfo;

typedef struct
{
  GDBusInterfaceInfo parent_struct;
  const gchar *hyphen_name;
} _ExtendedGDBusInterfaceInfo;

typedef struct
{
  const _ExtendedGDBusPropertyInfo *info;
  guint prop_id;
  GValue orig_value; /* the value before the change */
} ChangedProperty;

static void
_changed_property_free (ChangedProperty *data)
{
  g_value_unset (&data->orig_value);
  g_free (data);
}

static gboolean
_g_strv_equal0 (gchar **a, gchar **b)
{
  gboolean ret = FALSE;
  guint n;
  if (a == NULL && b == NULL)
    {
      ret = TRUE;
      goto out;
    }
  if (a == NULL || b == NULL)
    goto out;
  if (g_strv_length (a) != g_strv_length (b))
    goto out;
  for (n = 0; a[n] != NULL; n++)
    if (g_strcmp0 (a[n], b[n]) != 0)
      goto out;
  ret = TRUE;
out:
  return ret;
}

static gboolean
_g_variant_equal0 (GVariant *a, GVariant *b)
{
  gboolean ret = FALSE;
  if (a == NULL && b == NULL)
    {
      ret = TRUE;
      goto out;
    }
  if (a == NULL || b == NULL)
    goto out;
  ret = g_variant_equal (a, b);
out:
  return ret;
}

G_GNUC_UNUSED static gboolean
_g_value_equal (const GValue *a, const GValue *b)
{
  gboolean ret = FALSE;
  g_assert (G_VALUE_TYPE (a) == G_VALUE_TYPE (b));
  switch (G_VALUE_TYPE (a))
    {
      case G_TYPE_BOOLEAN:
        ret = (g_value_get_boolean (a) == g_value_get_boolean (b));
        break;
      case G_TYPE_UCHAR:
        ret = (g_value_get_uchar (a) == g_value_get_uchar (b));
        break;
      case G_TYPE_INT:
        ret = (g_value_get_int (a) == g_value_get_int (b));
        break;
      case G_TYPE_UINT:
        ret = (g_value_get_uint (a) == g_value_get_uint (b));
        break;
      case G_TYPE_INT64:
        ret = (g_value_get_int64 (a) == g_value_get_int64 (b));
        break;
      case G_TYPE_UINT64:
        ret = (g_value_get_uint64 (a) == g_value_get_uint64 (b));
        break;
      case G_TYPE_DOUBLE:
        {
          /* Avoid -Wfloat-equal warnings by doing a direct bit compare */
          gdouble da = g_value_get_double (a);
          gdouble db = g_value_get_double (b);
          ret = memcmp (&da, &db, sizeof (gdouble)) == 0;
        }
        break;
      case G_TYPE_STRING:
        ret = (g_strcmp0 (g_value_get_string (a), g_value_get_string (b)) == 0);
        break;
      case G_TYPE_VARIANT:
        ret = _g_variant_equal0 (g_value_get_variant (a), g_value_get_variant (b));
        break;
      default:
        if (G_VALUE_TYPE (a) == G_TYPE_STRV)
          ret = _g_strv_equal0 (g_value_get_boxed (a), g_value_get_boxed (b));
        else
          g_critical ("_g_value_equal() does not handle type %s", g_type_name (G_VALUE_TYPE (a)));
        break;
    }
  return ret;
}

static void
_g_dbus_codegen_marshal_BOOLEAN__OBJECT (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint G_GNUC_UNUSED,
    void         *marshal_data)
{
  typedef gboolean (*_GDbusCodegenMarshalBoolean_ObjectFunc)
       (void *data1,
        GDBusMethodInvocation *arg_method_invocation,
        void *data2);
  _GDbusCodegenMarshalBoolean_ObjectFunc callback;
  GCClosure *cc = (GCClosure*) closure;
  void *data1, *data2;
  gboolean v_return;

  g_return_if_fail (return_value != NULL);
  g_return_if_fail (n_param_values == 2);

  if (G_CCLOSURE_SWAP_DATA (closure))
    {
      data1 = closure->data;
      data2 = g_value_peek_pointer (param_values + 0);
    }
  else
    {
      data1 = g_value_peek_pointer (param_values + 0);
      data2 = closure->data;
    }

  callback = (_GDbusCodegenMarshalBoolean_ObjectFunc)
    (marshal_data ? marshal_data : cc->callback);

  v_return =
    callback (data1,
              g_marshal_value_peek_object (param_values + 1),
              data2);

  g_value_set_boolean (return_value, v_return);
}

static void
_g_dbus_codegen_marshal_BOOLEAN__OBJECT_STRING (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint G_GNUC_UNUSED,
    void         *marshal_data)
{
  typedef gboolean (*_GDbusCodegenMarshalBoolean_ObjectStringFunc)
       (void *data1,
        GDBusMethodInvocation *arg_method_invocation,
        const gchar *arg_command,
        void *data2);
  _GDbusCodegenMarshalBoolean_ObjectStringFunc callback;
  GCClosure *cc = (GCClosure*) closure;
  void *data1, *data2;
  gboolean v_return;

  g_return_if_fail (return_value != NULL);
  g_return_if_fail (n_param_values == 3);

  if (G_CCLOSURE_SWAP_DATA (closure))
    {
      data1 = closure->data;
      data2 = g_value_peek_pointer (param_values + 0);
    }
  else
    {
      data1 = g_value_peek_pointer (param_values + 0);
      data2 = closure->data;
    }

  callback = (_GDbusCodegenMarshalBoolean_ObjectStringFunc)
    (marshal_data ? marshal_data : cc->callback);

  v_return =
    callback (data1,
              g_marshal_value_peek_object (param_values + 1),
              g_marshal_value_peek_string (param_values + 2),
              data2);

  g_value_set_boolean (return_value, v_return);
}

static void
_g_dbus_codegen_marshal_BOOLEAN__OBJECT_DOUBLE (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint G_GNUC_UNUSED,
    void         *marshal_data)
{
  typedef gboolean (*_GDbusCodegenMarshalBoolean_ObjectDoubleFunc)
       (void *data1,
        GDBusMethodInvocation *arg_method_invocation,
        gdouble arg_seconds,
        void *data2);
  _GDbusCodegenMarshalBoolean_ObjectDoubleFunc callback;
  GCClosure *cc = (GCClosure*) closure;
  void *data1, *data2;
  gboolean v_return;

  g_return_if_fail (return_value != NULL);
  g_return_if_fail (n_param_values == 3);

  if (G_CCLOSURE_SWAP_DATA (closure))
    {
      data1 = closure->data;
      data2 = g_value_peek_pointer (param_values + 0);
    }
  else
    {
      data1 = g_value_peek_pointer (param_values + 0);
      data2 = closure->data;
    }

  callback = (_GDbusCodegenMarshalBoolean_ObjectDoubleFunc)
    (marshal_data ? marshal_data : cc->callback);

  v_return =
    callback (data1,
              g_marshal_value_peek_object (param_values + 1),
              g_marshal_value_peek_double (param_values + 2),
              data2);

  g_value_set_boolean (return_value, v_return);
}

static void
_g_dbus_codegen_marshal_BOOLEAN__OBJECT_INT (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint G_GNUC_UNUSED,
    void         *marshal_data)
{
  typedef gboolean (*_GDbusCodegenMarshalBoolean_ObjectIntFunc)
       (void *data1,
        GDBusMethodInvocation *arg_method_invocation,
        gint arg_volume,
        void *data2);
  _GDbusCodegenMarshalBoolean_ObjectIntFunc callback;
  GCClosure *cc = (GCClosure*) closure;
  void *data1, *data2;
  gboolean v_return;

  g_return_if_fail (return_value != NULL);
  g_return_if_fail (n_param_values == 3);

  if (G_CCLOSURE_SWAP_DATA (closure))
    {
      data1 = closure->data;
      data2 = g_value_peek_pointer (param_values + 0);
    }
  else
    {
      data1 = g_value_peek_pointer (param_values + 0);
      data2 = closure->data;
    }

  callback = (_GDbusCodegenMarshalBoolean_ObjectIntFunc)
    (marshal_data ? marshal_data : cc->callback);

  v_return =
    callback (data1,
              g_marshal_value_peek_object (param_values + 1),
              g_marshal_value_peek_int (param_values + 2),
              data2);

  g_value_set_boolean (return_value, v_return);
}

/* ------------------------------------------------------------------------
 * Code for interface org.gnome.ShairportSync
 * ------------------------------------------------------------------------
 */

/**
 * SECTION:ShairportSync
 * @title: ShairportSync
 * @short_description: Generated C code for the org.gnome.ShairportSync D-Bus interface
 *
 * This section contains code for working with the <link linkend="gdbus-interface-org-gnome-ShairportSync.top_of_page">org.gnome.ShairportSync</link> D-Bus interface in C.
 */

/* ---- Introspection data for org.gnome.ShairportSync ---- */

static const _ExtendedGDBusMethodInfo _shairport_sync_method_info_quit =
{
  {
    -1,
    (gchar *) "Quit",
    NULL,
    NULL,
    NULL
  },
  "handle-quit",
  FALSE
};

static const _ExtendedGDBusMethodInfo _shairport_sync_method_info_drop_session =
{
  {
    -1,
    (gchar *) "DropSession",
    NULL,
    NULL,
    NULL
  },
  "handle-drop-session",
  FALSE
};

static const _ExtendedGDBusArgInfo _shairport_sync_method_info_remote_command_IN_ARG_command =
{
  {
    -1,
    (gchar *) "command",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _shairport_sync_method_info_remote_command_IN_ARG_pointers[] =
{
  &_shairport_sync_method_info_remote_command_IN_ARG_command.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _shairport_sync_method_info_remote_command_OUT_ARG_reply =
{
  {
    -1,
    (gchar *) "reply",
    (gchar *) "i",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _shairport_sync_method_info_remote_command_OUT_ARG_response =
{
  {
    -1,
    (gchar *) "response",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _shairport_sync_method_info_remote_command_OUT_ARG_pointers[] =
{
  &_shairport_sync_method_info_remote_command_OUT_ARG_reply.parent_struct,
  &_shairport_sync_method_info_remote_command_OUT_ARG_response.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _shairport_sync_method_info_remote_command =
{
  {
    -1,
    (gchar *) "RemoteCommand",
    (GDBusArgInfo **) &_shairport_sync_method_info_remote_command_IN_ARG_pointers,
    (GDBusArgInfo **) &_shairport_sync_method_info_remote_command_OUT_ARG_pointers,
    NULL
  },
  "handle-remote-command",
  FALSE
};

static const _ExtendedGDBusArgInfo _shairport_sync_method_info_set_frame_position_update_interval_IN_ARG_seconds =
{
  {
    -1,
    (gchar *) "seconds",
    (gchar *) "d",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _shairport_sync_method_info_set_frame_position_update_interval_IN_ARG_pointers[] =
{
  &_shairport_sync_method_info_set_frame_position_update_interval_IN_ARG_seconds.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _shairport_sync_method_info_set_frame_position_update_interval =
{
  {
    -1,
    (gchar *) "SetFramePositionUpdateInterval",
    (GDBusArgInfo **) &_shairport_sync_method_info_set_frame_position_update_interval_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-set-frame-position-update-interval",
  FALSE
};

static const GDBusMethodInfo * const _shairport_sync_method_info_pointers[] =
{
  &_shairport_sync_method_info_quit.parent_struct,
  &_shairport_sync_method_info_drop_session.parent_struct,
  &_shairport_sync_method_info_remote_command.parent_struct,
  &_shairport_sync_method_info_set_frame_position_update_interval.parent_struct,
  NULL
};

static const _ExtendedGDBusPropertyInfo _shairport_sync_property_info_active =
{
  {
    -1,
    (gchar *) "Active",
    (gchar *) "b",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "active",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _shairport_sync_property_info_disable_standby =
{
  {
    -1,
    (gchar *) "DisableStandby",
    (gchar *) "b",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE | G_DBUS_PROPERTY_INFO_FLAGS_WRITABLE,
    NULL
  },
  "disable-standby",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _shairport_sync_property_info_disable_standby_mode =
{
  {
    -1,
    (gchar *) "DisableStandbyMode",
    (gchar *) "s",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE | G_DBUS_PROPERTY_INFO_FLAGS_WRITABLE,
    NULL
  },
  "disable-standby-mode",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _shairport_sync_property_info_loudness =
{
  {
    -1,
    (gchar *) "Loudness",
    (gchar *) "b",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE | G_DBUS_PROPERTY_INFO_FLAGS_WRITABLE,
    NULL
  },
  "loudness",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _shairport_sync_property_info_loudness_threshold =
{
  {
    -1,
    (gchar *) "LoudnessThreshold",
    (gchar *) "d",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE | G_DBUS_PROPERTY_INFO_FLAGS_WRITABLE,
    NULL
  },
  "loudness-threshold",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _shairport_sync_property_info_convolution =
{
  {
    -1,
    (gchar *) "Convolution",
    (gchar *) "b",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE | G_DBUS_PROPERTY_INFO_FLAGS_WRITABLE,
    NULL
  },
  "convolution",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _shairport_sync_property_info_convolution_gain =
{
  {
    -1,
    (gchar *) "ConvolutionGain",
    (gchar *) "d",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE | G_DBUS_PROPERTY_INFO_FLAGS_WRITABLE,
    NULL
  },
  "convolution-gain",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _shairport_sync_property_info_convolution_impulse_response_file =
{
  {
    -1,
    (gchar *) "ConvolutionImpulseResponseFile",
    (gchar *) "s",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE | G_DBUS_PROPERTY_INFO_FLAGS_WRITABLE,
    NULL
  },
  "convolution-impulse-response-file",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _shairport_sync_property_info_drift_tolerance =
{
  {
    -1,
    (gchar *) "DriftTolerance",
    (gchar *) "d",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE | G_DBUS_PROPERTY_INFO_FLAGS_WRITABLE,
    NULL
  },
  "drift-tolerance",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _shairport_sync_property_info_volume =
{
  {
    -1,
    (gchar *) "Volume",
    (gchar *) "d",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE | G_DBUS_PROPERTY_INFO_FLAGS_WRITABLE,
    NULL
  },
  "volume",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _shairport_sync_property_info_volume_control_profile =
{
  {
    -1,
    (gchar *) "VolumeControlProfile",
    (gchar *) "s",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE | G_DBUS_PROPERTY_INFO_FLAGS_WRITABLE,
    NULL
  },
  "volume-control-profile",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _shairport_sync_property_info_interpolation =
{
  {
    -1,
    (gchar *) "Interpolation",
    (gchar *) "s",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE | G_DBUS_PROPERTY_INFO_FLAGS_WRITABLE,
    NULL
  },
  "interpolation",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _shairport_sync_property_info_alacdecoder =
{
  {
    -1,
    (gchar *) "ALACDecoder",
    (gchar *) "s",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE | G_DBUS_PROPERTY_INFO_FLAGS_WRITABLE,
    NULL
  },
  "alacdecoder",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _shairport_sync_property_info_version =
{
  {
    -1,
    (gchar *) "Version",
    (gchar *) "s",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "version",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _shairport_sync_property_info_version_string =
{
  {
    -1,
    (gchar *) "VersionString",
    (gchar *) "s",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "version-string",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _shairport_sync_property_info_protocol =
{
  {
    -1,
    (gchar *) "Protocol",
    (gchar *) "s",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "protocol",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _shairport_sync_property_info_service_name =
{
  {
    -1,
    (gchar *) "ServiceName",
    (gchar *) "s",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "service-name",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _shairport_sync_property_info_output_format =
{
  {
    -1,
    (gchar *) "OutputFormat",
    (gchar *) "s",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "output-format",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _shairport_sync_property_info_output_rate =
{
  {
    -1,
    (gchar *) "OutputRate",
    (gchar *) "i",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "output-rate",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _shairport_sync_property_info_first_frame_position =
{
  {
    -1,
    (gchar *) "FirstFramePosition",
    (gchar *) "s",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "first-frame-position",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _shairport_sync_property_info_frame_position =
{
  {
    -1,
    (gchar *) "FramePosition",
    (gchar *) "s",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "frame-position",
  FALSE,
  TRUE
};

static const GDBusPropertyInfo * const _shairport_sync_property_info_pointers[] =
{
  &_shairport_sync_property_info_active.parent_struct,
  &_shairport_sync_property_info_disable_standby.parent_struct,
  &_shairport_sync_property_info_disable_standby_mode.parent_struct,
  &_shairport_sync_property_info_loudness.parent_struct,
  &_shairport_sync_property_info_loudness_threshold.parent_struct,
  &_shairport_sync_property_info_convolution.parent_struct,
  &_shairport_sync_property_info_convolution_gain.parent_struct,
  &_shairport_sync_property_info_convolution_impulse_response_file.parent_struct,
  &_shairport_sync_property_info_drift_tolerance.parent_struct,
  &_shairport_sync_property_info_volume.parent_struct,
  &_shairport_sync_property_info_volume_control_profile.parent_struct,
  &_shairport_sync_property_info_interpolation.parent_struct,
  &_shairport_sync_property_info_alacdecoder.parent_struct,
  &_shairport_sync_property_info_version.parent_struct,
  &_shairport_sync_property_info_version_string.parent_struct,
  &_shairport_sync_property_info_protocol.parent_struct,
  &_shairport_sync_property_info_service_name.parent_struct,
  &_shairport_sync_property_info_output_format.parent_struct,
  &_shairport_sync_property_info_output_rate.parent_struct,
  &_shairport_sync_property_info_first_frame_position.parent_struct,
  &_shairport_sync_property_info_frame_position.parent_struct,
  NULL
};

static const _ExtendedGDBusInterfaceInfo _shairport_sync_interface_info =
{
  {
    -1,
    (gchar *) "org.gnome.ShairportSync",
    (GDBusMethodInfo **) &_shairport_sync_method_info_pointers,
    NULL,
    (GDBusPropertyInfo **) &_shairport_sync_property_info_pointers,
    NULL
  },
  "shairport-sync",
};


/**
 * shairport_sync_interface_info:
 *
 * Gets a machine-readable description of the <link linkend="gdbus-interface-org-gnome-ShairportSync.top_of_page">org.gnome.ShairportSync</link> D-Bus interface.
 *
 * Returns: (transfer none): A #GDBusInterfaceInfo. Do not free.
 */
GDBusInterfaceInfo *
shairport_sync_interface_info (void)
{
  return (GDBusInterfaceInfo *) &_shairport_sync_interface_info.parent_struct;
}

/**
 * shairport_sync_override_properties:
 * @klass: The class structure for a #GObject derived class.
 * @property_id_begin: The property id to assign to the first overridden property.
 *
 * Overrides all #GObject properties in the #ShairportSync interface for a concrete class.
 * The properties are overridden in the order they are defined.
 *
 * Returns: The last property id.
 */
guint
shairport_sync_override_properties (GObjectClass *klass, guint property_id_begin)
{
  g_object_class_override_property (klass, property_id_begin++, "active");
  g_object_class_override_property (klass, property_id_begin++, "disable-standby");
  g_object_class_override_property (klass, property_id_begin++, "disable-standby-mode");
  g_object_class_override_property (klass, property_id_begin++, "loudness");
  g_object_class_override_property (klass, property_id_begin++, "loudness-threshold");
  g_object_class_override_property (klass, property_id_begin++, "convolution");
  g_object_class_override_property (klass, property_id_begin++, "convolution-gain");
  g_object_class_override_property (klass, property_id_begin++, "convolution-impulse-response-file");
  g_object_class_override_property (klass, property_id_begin++, "drift-tolerance");
  g_object_class_override_property (klass, property_id_begin++, "volume");
  g_object_class_override_property (klass, property_id_begin++, "volume-control-profile");
  g_object_class_override_property (klass, property_id_begin++, "interpolation");
  g_object_class_override_property (klass, property_id_begin++, "alacdecoder");
  g_object_class_override_property (klass, property_id_begin++, "version");
  g_object_class_override_property (klass, property_id_begin++, "version-string");
  g_object_class_override_property (klass, property_id_begin++, "protocol");
  g_object_class_override_property (klass, property_id_begin++, "service-name");
  g_object_class_override_property (klass, property_id_begin++, "output-format");
  g_object_class_override_property (klass, property_id_begin++, "output-rate");
  g_object_class_override_property (klass, property_id_begin++, "first-frame-position");
  g_object_class_override_property (klass, property_id_begin++, "frame-position");
  return property_id_begin - 1;
}


inline static void
shairport_sync_method_marshal_quit (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
shairport_sync_method_marshal_drop_session (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
shairport_sync_method_marshal_remote_command (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT_STRING (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
shairport_sync_method_marshal_set_frame_position_update_interval (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT_DOUBLE (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}


/**
 * ShairportSync:
 *
 * Abstract interface type for the D-Bus interface <link linkend="gdbus-interface-org-gnome-ShairportSync.top_of_page">org.gnome.ShairportSync</link>.
 */

/**
 * ShairportSyncIface:
 * @parent_iface: The parent interface.
 * @handle_drop_session: Handler for the #ShairportSync::handle-drop-session signal.
 * @handle_quit: Handler for the #ShairportSync::handle-quit signal.
 * @handle_remote_command: Handler for the #ShairportSync::handle-remote-command signal.
 * @handle_set_frame_position_update_interval: Handler for the #ShairportSync::handle-set-frame-position-update-interval signal.
 * @get_active: Getter for the #ShairportSync:active property.
 * @get_alacdecoder: Getter for the #ShairportSync:alacdecoder property.
 * @get_convolution: Getter for the #ShairportSync:convolution property.
 * @get_convolution_gain: Getter for the #ShairportSync:convolution-gain property.
 * @get_convolution_impulse_response_file: Getter for the #ShairportSync:convolution-impulse-response-file property.
 * @get_disable_standby: Getter for the #ShairportSync:disable-standby property.
 * @get_disable_standby_mode: Getter for the #ShairportSync:disable-standby-mode property.
 * @get_drift_tolerance: Getter for the #ShairportSync:drift-tolerance property.
 * @get_first_frame_position: Getter for the #ShairportSync:first-frame-position property.
 * @get_frame_position: Getter for the #ShairportSync:frame-position property.
 * @get_interpolation: Getter for the #ShairportSync:interpolation property.
 * @get_loudness: Getter for the #ShairportSync:loudness property.
 * @get_loudness_threshold: Getter for the #ShairportSync:loudness-threshold property.
 * @get_output_format: Getter for the #ShairportSync:output-format property.
 * @get_output_rate: Getter for the #ShairportSync:output-rate property.
 * @get_protocol: Getter for the #ShairportSync:protocol property.
 * @get_service_name: Getter for the #ShairportSync:service-name property.
 * @get_version: Getter for the #ShairportSync:version property.
 * @get_version_string: Getter for the #ShairportSync:version-string property.
 * @get_volume: Getter for the #ShairportSync:volume property.
 * @get_volume_control_profile: Getter for the #ShairportSync:volume-control-profile property.
 *
 * Virtual table for the D-Bus interface <link linkend="gdbus-interface-org-gnome-ShairportSync.top_of_page">org.gnome.ShairportSync</link>.
 */

typedef ShairportSyncIface ShairportSyncInterface;
G_DEFINE_INTERFACE (ShairportSync, shairport_sync, G_TYPE_OBJECT)

static void
shairport_sync_default_init (ShairportSyncIface *iface)
{
  /* GObject signals for incoming D-Bus method calls: */
  /**
   * ShairportSync::handle-quit:
   * @object: A #ShairportSync.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-gnome-ShairportSync.Quit">Quit()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call shairport_sync_complete_quit() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-quit",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (ShairportSyncIface, handle_quit),
    g_signal_accumulator_true_handled,
    NULL,
      shairport_sync_method_marshal_quit,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

  /**
   * ShairportSync::handle-drop-session:
   * @object: A #ShairportSync.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-gnome-ShairportSync.DropSession">DropSession()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call shairport_sync_complete_drop_session() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-drop-session",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (ShairportSyncIface, handle_drop_session),
    g_signal_accumulator_true_handled,
    NULL,
      shairport_sync_method_marshal_drop_session,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

  /**
   * ShairportSync::handle-remote-command:
   * @object: A #ShairportSync.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_command: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-gnome-ShairportSync.RemoteCommand">RemoteCommand()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call shairport_sync_complete_remote_command() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-remote-command",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (ShairportSyncIface, handle_remote_command),
    g_signal_accumulator_true_handled,
    NULL,
      shairport_sync_method_marshal_remote_command,
    G_TYPE_BOOLEAN,
    2,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING);

  /**
   * ShairportSync::handle-set-frame-position-update-interval:
   * @object: A #ShairportSync.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_seconds: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-gnome-ShairportSync.SetFramePositionUpdateInterval">SetFramePositionUpdateInterval()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call shairport_sync_complete_set_frame_position_update_interval() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-set-frame-position-update-interval",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (ShairportSyncIface, handle_set_frame_position_update_interval),
    g_signal_accumulator_true_handled,
    NULL,
      shairport_sync_method_marshal_set_frame_position_update_interval,
    G_TYPE_BOOLEAN,
    2,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_DOUBLE);

  /* GObject properties for D-Bus properties: */
  /**
   * ShairportSync:active:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-gnome-ShairportSync.Active">"Active"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_boolean ("active", "Active", "Active", FALSE, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * ShairportSync:disable-standby:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-gnome-ShairportSync.DisableStandby">"DisableStandby"</link>.
   *
   * Since the D-Bus property for this #GObject property is both readable and writable, it is meaningful to both read from it and write to it on both the service- and client-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_boolean ("disable-standby", "DisableStandby", "DisableStandby", FALSE, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * ShairportSync:disable-standby-mode:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-gnome-ShairportSync.DisableStandbyMode">"DisableStandbyMode"</link>.
   *
   * Since the D-Bus property for this #GObject property is both readable and writable, it is meaningful to both read from it and write to it on both the service- and client-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_string ("disable-standby-mode", "DisableStandbyMode", "DisableStandbyMode", NULL, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * ShairportSync:loudness:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-gnome-ShairportSync.Loudness">"Loudness"</link>.
   *
   * Since the D-Bus property for this #GObject property is both readable and writable, it is meaningful to both read from it and write to it on both the service- and client-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_boolean ("loudness", "Loudness", "Loudness", FALSE, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * ShairportSync:loudness-threshold:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-gnome-ShairportSync.LoudnessThreshold">"LoudnessThreshold"</link>.
   *
   * Since the D-Bus property for this #GObject property is both readable and writable, it is meaningful to both read from it and write to it on both the service- and client-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_double ("loudness-threshold", "LoudnessThreshold", "LoudnessThreshold", -G_MAXDOUBLE, G_MAXDOUBLE, 0.0, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * ShairportSync:convolution:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-gnome-ShairportSync.Convolution">"Convolution"</link>.
   *
   * Since the D-Bus property for this #GObject property is both readable and writable, it is meaningful to both read from it and write to it on both the service- and client-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_boolean ("convolution", "Convolution", "Convolution", FALSE, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * ShairportSync:convolution-gain:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-gnome-ShairportSync.ConvolutionGain">"ConvolutionGain"</link>.
   *
   * Since the D-Bus property for this #GObject property is both readable and writable, it is meaningful to both read from it and write to it on both the service- and client-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_double ("convolution-gain", "ConvolutionGain", "ConvolutionGain", -G_MAXDOUBLE, G_MAXDOUBLE, 0.0, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * ShairportSync:convolution-impulse-response-file:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-gnome-ShairportSync.ConvolutionImpulseResponseFile">"ConvolutionImpulseResponseFile"</link>.
   *
   * Since the D-Bus property for this #GObject property is both readable and writable, it is meaningful to both read from it and write to it on both the service- and client-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_string ("convolution-impulse-response-file", "ConvolutionImpulseResponseFile", "ConvolutionImpulseResponseFile", NULL, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * ShairportSync:drift-tolerance:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-gnome-ShairportSync.DriftTolerance">"DriftTolerance"</link>.
   *
   * Since the D-Bus property for this #GObject property is both readable and writable, it is meaningful to both read from it and write to it on both the service- and client-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_double ("drift-tolerance", "DriftTolerance", "DriftTolerance", -G_MAXDOUBLE, G_MAXDOUBLE, 0.0, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * ShairportSync:volume:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-gnome-ShairportSync.Volume">"Volume"</link>.
   *
   * Since the D-Bus property for this #GObject property is both readable and writable, it is meaningful to both read from it and write to it on both the service- and client-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_double ("volume", "Volume", "Volume", -G_MAXDOUBLE, G_MAXDOUBLE, 0.0, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * ShairportSync:volume-control-profile:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-gnome-ShairportSync.VolumeControlProfile">"VolumeControlProfile"</link>.
   *
   * Since the D-Bus property for this #GObject property is both readable and writable, it is meaningful to both read from it and write to it on both the service- and client-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_string ("volume-control-profile", "VolumeControlProfile", "VolumeControlProfile", NULL, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * ShairportSync:interpolation:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-gnome-ShairportSync.Interpolation">"Interpolation"</link>.
   *
   * Since the D-Bus property for this #GObject property is both readable and writable, it is meaningful to both read from it and write to it on both the service- and client-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_string ("interpolation", "Interpolation", "Interpolation", NULL, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * ShairportSync:alacdecoder:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-gnome-ShairportSync.ALACDecoder">"ALACDecoder"</link>.
   *
   * Since the D-Bus property for this #GObject property is both readable and writable, it is meaningful to both read from it and write to it on both the service- and client-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_string ("alacdecoder", "ALACDecoder", "ALACDecoder", NULL, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * ShairportSync:version:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-gnome-ShairportSync.Version">"Version"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_string ("version", "Version", "Version", NULL, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * ShairportSync:version-string:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-gnome-ShairportSync.VersionString">"VersionString"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_string ("version-string", "VersionString", "VersionString", NULL, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * ShairportSync:protocol:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-gnome-ShairportSync.Protocol">"Protocol"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_string ("protocol", "Protocol", "Protocol", NULL, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * ShairportSync:service-name:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-gnome-ShairportSync.ServiceName">"ServiceName"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_string ("service-name", "ServiceName", "ServiceName", NULL, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * ShairportSync:output-format:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-gnome-ShairportSync.OutputFormat">"OutputFormat"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_string ("output-format", "OutputFormat", "OutputFormat", NULL, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * ShairportSync:output-rate:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-gnome-ShairportSync.OutputRate">"OutputRate"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_int ("output-rate", "OutputRate", "OutputRate", G_MININT32, G_MAXINT32, 0, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * ShairportSync:first-frame-position:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-gnome-ShairportSync.FirstFramePosition">"FirstFramePosition"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_string ("first-frame-position", "FirstFramePosition", "FirstFramePosition", NULL, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * ShairportSync:frame-position:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-gnome-ShairportSync.FramePosition">"FramePosition"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_string ("frame-position", "FramePosition", "FramePosition", NULL, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
}

/**
 * shairport_sync_get_active: (skip)
 * @object: A #ShairportSync.
 *
 * Gets the value of the <link linkend="gdbus-property-org-gnome-ShairportSync.Active">"Active"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
gboolean 
shairport_sync_get_active (ShairportSync *object)
{
  g_return_val_if_fail (IS_SHAIRPORT_SYNC (object), FALSE);

  return SHAIRPORT_SYNC_GET_IFACE (object)->get_active (object);
}

/**
 * shairport_sync_set_active: (skip)
 * @object: A #ShairportSync.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-gnome-ShairportSync.Active">"Active"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
shairport_sync_set_active (ShairportSync *object, gboolean value)
{
  g_object_set (G_OBJECT (object), "active", value, NULL);
}

/**
 * shairport_sync_get_disable_standby: (skip)
 * @object: A #ShairportSync.
 *
 * Gets the value of the <link linkend="gdbus-property-org-gnome-ShairportSync.DisableStandby">"DisableStandby"</link> D-Bus property.
 *
 * Since this D-Bus property is both readable and writable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
gboolean 
shairport_sync_get_disable_standby (ShairportSync *object)
{
  g_return_val_if_fail (IS_SHAIRPORT_SYNC (object), FALSE);

  return SHAIRPORT_SYNC_GET_IFACE (object)->get_disable_standby (object);
}

/**
 * shairport_sync_set_disable_standby: (skip)
 * @object: A #ShairportSync.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-gnome-ShairportSync.DisableStandby">"DisableStandby"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is both readable and writable, it is meaningful to use this function on both the client- and service-side.
 */
void
shairport_sync_set_disable_standby (ShairportSync *object, gboolean value)
{
  g_object_set (G_OBJECT (object), "disable-standby", value, NULL);
}

/**
 * shairport_sync_get_disable_standby_mode: (skip)
 * @object: A #ShairportSync.
 *
 * Gets the value of the <link linkend="gdbus-property-org-gnome-ShairportSync.DisableStandbyMode">"DisableStandbyMode"</link> D-Bus property.
 *
 * Since this D-Bus property is both readable and writable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use shairport_sync_dup_disable_standby_mode() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
const gchar *
shairport_sync_get_disable_standby_mode (ShairportSync *object)
{
  g_return_val_if_fail (IS_SHAIRPORT_SYNC (object), NULL);

  return SHAIRPORT_SYNC_GET_IFACE (object)->get_disable_standby_mode (object);
}

/**
 * shairport_sync_dup_disable_standby_mode: (skip)
 * @object: A #ShairportSync.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-gnome-ShairportSync.DisableStandbyMode">"DisableStandbyMode"</link> D-Bus property.
 *
 * Since this D-Bus property is both readable and writable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_free().
 */
gchar *
shairport_sync_dup_disable_standby_mode (ShairportSync *object)
{
  gchar *value;
  g_object_get (G_OBJECT (object), "disable-standby-mode", &value, NULL);
  return value;
}

/**
 * shairport_sync_set_disable_standby_mode: (skip)
 * @object: A #ShairportSync.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-gnome-ShairportSync.DisableStandbyMode">"DisableStandbyMode"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is both readable and writable, it is meaningful to use this function on both the client- and service-side.
 */
void
shairport_sync_set_disable_standby_mode (ShairportSync *object, const gchar *value)
{
  g_object_set (G_OBJECT (object), "disable-standby-mode", value, NULL);
}

/**
 * shairport_sync_get_loudness: (skip)
 * @object: A #ShairportSync.
 *
 * Gets the value of the <link linkend="gdbus-property-org-gnome-ShairportSync.Loudness">"Loudness"</link> D-Bus property.
 *
 * Since this D-Bus property is both readable and writable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
gboolean 
shairport_sync_get_loudness (ShairportSync *object)
{
  g_return_val_if_fail (IS_SHAIRPORT_SYNC (object), FALSE);

  return SHAIRPORT_SYNC_GET_IFACE (object)->get_loudness (object);
}

/**
 * shairport_sync_set_loudness: (skip)
 * @object: A #ShairportSync.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-gnome-ShairportSync.Loudness">"Loudness"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is both readable and writable, it is meaningful to use this function on both the client- and service-side.
 */
void
shairport_sync_set_loudness (ShairportSync *object, gboolean value)
{
  g_object_set (G_OBJECT (object), "loudness", value, NULL);
}

/**
 * shairport_sync_get_loudness_threshold: (skip)
 * @object: A #ShairportSync.
 *
 * Gets the value of the <link linkend="gdbus-property-org-gnome-ShairportSync.LoudnessThreshold">"LoudnessThreshold"</link> D-Bus property.
 *
 * Since this D-Bus property is both readable and writable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
gdouble 
shairport_sync_get_loudness_threshold (ShairportSync *object)
{
  g_return_val_if_fail (IS_SHAIRPORT_SYNC (object), 0.0);

  return SHAIRPORT_SYNC_GET_IFACE (object)->get_loudness_threshold (object);
}

/**
 * shairport_sync_set_loudness_threshold: (skip)
 * @object: A #ShairportSync.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-gnome-ShairportSync.LoudnessThreshold">"LoudnessThreshold"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is both readable and writable, it is meaningful to use this function on both the client- and service-side.
 */
void
shairport_sync_set_loudness_threshold (ShairportSync *object, gdouble value)
{
  g_object_set (G_OBJECT (object), "loudness-threshold", value, NULL);
}

/**
 * shairport_sync_get_convolution: (skip)
 * @object: A #ShairportSync.
 *
 * Gets the value of the <link linkend="gdbus-property-org-gnome-ShairportSync.Convolution">"Convolution"</link> D-Bus property.
 *
 * Since this D-Bus property is both readable and writable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
gboolean 
shairport_sync_get_convolution (ShairportSync *object)
{
  g_return_val_if_fail (IS_SHAIRPORT_SYNC (object), FALSE);

  return SHAIRPORT_SYNC_GET_IFACE (object)->get_convolution (object);
}

/**
 * shairport_sync_set_convolution: (skip)
 * @object: A #ShairportSync.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-gnome-ShairportSync.Convolution">"Convolution"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is both readable and writable, it is meaningful to use this function on both the client- and service-side.
 */
void
shairport_sync_set_convolution (ShairportSync *object, gboolean value)
{
  g_object_set (G_OBJECT (object), "convolution", value, NULL);
}

/**
 * shairport_sync_get_convolution_gain: (skip)
 * @object: A #ShairportSync.
 *
 * Gets the value of the <link linkend="gdbus-property-org-gnome-ShairportSync.ConvolutionGain">"ConvolutionGain"</link> D-Bus property.
 *
 * Since this D-Bus property is both readable and writable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
gdouble 
shairport_sync_get_convolution_gain (ShairportSync *object)
{
  g_return_val_if_fail (IS_SHAIRPORT_SYNC (object), 0.0);

  return SHAIRPORT_SYNC_GET_IFACE (object)->get_convolution_gain (object);
}

/**
 * shairport_sync_set_convolution_gain: (skip)
 * @object: A #ShairportSync.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-gnome-ShairportSync.ConvolutionGain">"ConvolutionGain"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is both readable and writable, it is meaningful to use this function on both the client- and service-side.
 */
void
shairport_sync_set_convolution_gain (ShairportSync *object, gdouble value)
{
  g_object_set (G_OBJECT (object), "convolution-gain", value, NULL);
}

/**
 * shairport_sync_get_convolution_impulse_response_file: (skip)
 * @object: A #ShairportSync.
 *
 * Gets the value of the <link linkend="gdbus-property-org-gnome-ShairportSync.ConvolutionImpulseResponseFile">"ConvolutionImpulseResponseFile"</link> D-Bus property.
 *
 * Since this D-Bus property is both readable and writable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use shairport_sync_dup_convolution_impulse_response_file() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
const gchar *
shairport_sync_get_convolution_impulse_response_file (ShairportSync *object)
{
  g_return_val_if_fail (IS_SHAIRPORT_SYNC (object), NULL);

  return SHAIRPORT_SYNC_GET_IFACE (object)->get_convolution_impulse_response_file (object);
}

/**
 * shairport_sync_dup_convolution_impulse_response_file: (skip)
 * @object: A #ShairportSync.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-gnome-ShairportSync.ConvolutionImpulseResponseFile">"ConvolutionImpulseResponseFile"</link> D-Bus property.
 *
 * Since this D-Bus property is both readable and writable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_free().
 */
gchar *
shairport_sync_dup_convolution_impulse_response_file (ShairportSync *object)
{
  gchar *value;
  g_object_get (G_OBJECT (object), "convolution-impulse-response-file", &value, NULL);
  return value;
}

/**
 * shairport_sync_set_convolution_impulse_response_file: (skip)
 * @object: A #ShairportSync.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-gnome-ShairportSync.ConvolutionImpulseResponseFile">"ConvolutionImpulseResponseFile"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is both readable and writable, it is meaningful to use this function on both the client- and service-side.
 */
void
shairport_sync_set_convolution_impulse_response_file (ShairportSync *object, const gchar *value)
{
  g_object_set (G_OBJECT (object), "convolution-impulse-response-file", value, NULL);
}

/**
 * shairport_sync_get_drift_tolerance: (skip)
 * @object: A #ShairportSync.
 *
 * Gets the value of the <link linkend="gdbus-property-org-gnome-ShairportSync.DriftTolerance">"DriftTolerance"</link> D-Bus property.
 *
 * Since this D-Bus property is both readable and writable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
gdouble 
shairport_sync_get_drift_tolerance (ShairportSync *object)
{
  g_return_val_if_fail (IS_SHAIRPORT_SYNC (object), 0.0);

  return SHAIRPORT_SYNC_GET_IFACE (object)->get_drift_tolerance (object);
}

/**
 * shairport_sync_set_drift_tolerance: (skip)
 * @object: A #ShairportSync.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-gnome-ShairportSync.DriftTolerance">"DriftTolerance"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is both readable and writable, it is meaningful to use this function on both the client- and service-side.
 */
void
shairport_sync_set_drift_tolerance (ShairportSync *object, gdouble value)
{
  g_object_set (G_OBJECT (object), "drift-tolerance", value, NULL);
}

/**
 * shairport_sync_get_volume: (skip)
 * @object: A #ShairportSync.
 *
 * Gets the value of the <link linkend="gdbus-property-org-gnome-ShairportSync.Volume">"Volume"</link> D-Bus property.
 *
 * Since this D-Bus property is both readable and writable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
gdouble 
shairport_sync_get_volume (ShairportSync *object)
{
  g_return_val_if_fail (IS_SHAIRPORT_SYNC (object), 0.0);

  return SHAIRPORT_SYNC_GET_IFACE (object)->get_volume (object);
}

/**
 * shairport_sync_set_volume: (skip)
 * @object: A #ShairportSync.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-gnome-ShairportSync.Volume">"Volume"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is both readable and writable, it is meaningful to use this function on both the client- and service-side.
 */
void
shairport_sync_set_volume (ShairportSync *object, gdouble value)
{
  g_object_set (G_OBJECT (object), "volume", value, NULL);
}

/**
 * shairport_sync_get_volume_control_profile: (skip)
 * @object: A #ShairportSync.
 *
 * Gets the value of the <link linkend="gdbus-property-org-gnome-ShairportSync.VolumeControlProfile">"VolumeControlProfile"</link> D-Bus property.
 *
 * Since this D-Bus property is both readable and writable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use shairport_sync_dup_volume_control_profile() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
const gchar *
shairport_sync_get_volume_control_profile (ShairportSync *object)
{
  g_return_val_if_fail (IS_SHAIRPORT_SYNC (object), NULL);

  return SHAIRPORT_SYNC_GET_IFACE (object)->get_volume_control_profile (object);
}

/**
 * shairport_sync_dup_volume_control_profile: (skip)
 * @object: A #ShairportSync.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-gnome-ShairportSync.VolumeControlProfile">"VolumeControlProfile"</link> D-Bus property.
 *
 * Since this D-Bus property is both readable and writable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_free().
 */
gchar *
shairport_sync_dup_volume_control_profile (ShairportSync *object)
{
  gchar *value;
  g_object_get (G_OBJECT (object), "volume-control-profile", &value, NULL);
  return value;
}

/**
 * shairport_sync_set_volume_control_profile: (skip)
 * @object: A #ShairportSync.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-gnome-ShairportSync.VolumeControlProfile">"VolumeControlProfile"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is both readable and writable, it is meaningful to use this function on both the client- and service-side.
 */
void
shairport_sync_set_volume_control_profile (ShairportSync *object, const gchar *value)
{
  g_object_set (G_OBJECT (object), "volume-control-profile", value, NULL);
}

/**
 * shairport_sync_get_interpolation: (skip)
 * @object: A #ShairportSync.
 *
 * Gets the value of the <link linkend="gdbus-property-org-gnome-ShairportSync.Interpolation">"Interpolation"</link> D-Bus property.
 *
 * Since this D-Bus property is both readable and writable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use shairport_sync_dup_interpolation() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
const gchar *
shairport_sync_get_interpolation (ShairportSync *object)
{
  g_return_val_if_fail (IS_SHAIRPORT_SYNC (object), NULL);

  return SHAIRPORT_SYNC_GET_IFACE (object)->get_interpolation (object);
}

/**
 * shairport_sync_dup_interpolation: (skip)
 * @object: A #ShairportSync.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-gnome-ShairportSync.Interpolation">"Interpolation"</link> D-Bus property.
 *
 * Since this D-Bus property is both readable and writable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_free().
 */
gchar *
shairport_sync_dup_interpolation (ShairportSync *object)
{
  gchar *value;
  g_object_get (G_OBJECT (object), "interpolation", &value, NULL);
  return value;
}

/**
 * shairport_sync_set_interpolation: (skip)
 * @object: A #ShairportSync.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-gnome-ShairportSync.Interpolation">"Interpolation"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is both readable and writable, it is meaningful to use this function on both the client- and service-side.
 */
void
shairport_sync_set_interpolation (ShairportSync *object, const gchar *value)
{
  g_object_set (G_OBJECT (object), "interpolation", value, NULL);
}

/**
 * shairport_sync_get_alacdecoder: (skip)
 * @object: A #ShairportSync.
 *
 * Gets the value of the <link linkend="gdbus-property-org-gnome-ShairportSync.ALACDecoder">"ALACDecoder"</link> D-Bus property.
 *
 * Since this D-Bus property is both readable and writable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use shairport_sync_dup_alacdecoder() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
const gchar *
shairport_sync_get_alacdecoder (ShairportSync *object)
{
  g_return_val_if_fail (IS_SHAIRPORT_SYNC (object), NULL);

  return SHAIRPORT_SYNC_GET_IFACE (object)->get_alacdecoder (object);
}

/**
 * shairport_sync_dup_alacdecoder: (skip)
 * @object: A #ShairportSync.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-gnome-ShairportSync.ALACDecoder">"ALACDecoder"</link> D-Bus property.
 *
 * Since this D-Bus property is both readable and writable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_free().
 */
gchar *
shairport_sync_dup_alacdecoder (ShairportSync *object)
{
  gchar *value;
  g_object_get (G_OBJECT (object), "alacdecoder", &value, NULL);
  return value;
}

/**
 * shairport_sync_set_alacdecoder: (skip)
 * @object: A #ShairportSync.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-gnome-ShairportSync.ALACDecoder">"ALACDecoder"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is both readable and writable, it is meaningful to use this function on both the client- and service-side.
 */
void
shairport_sync_set_alacdecoder (ShairportSync *object, const gchar *value)
{
  g_object_set (G_OBJECT (object), "alacdecoder", value, NULL);
}

/**
 * shairport_sync_get_version: (skip)
 * @object: A #ShairportSync.
 *
 * Gets the value of the <link linkend="gdbus-property-org-gnome-ShairportSync.Version">"Version"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use shairport_sync_dup_version() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
const gchar *
shairport_sync_get_version (ShairportSync *object)
{
  g_return_val_if_fail (IS_SHAIRPORT_SYNC (object), NULL);

  return SHAIRPORT_SYNC_GET_IFACE (object)->get_version (object);
}

/**
 * shairport_sync_dup_version: (skip)
 * @object: A #ShairportSync.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-gnome-ShairportSync.Version">"Version"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_free().
 */
gchar *
shairport_sync_dup_version (ShairportSync *object)
{
  gchar *value;
  g_object_get (G_OBJECT (object), "version", &value, NULL);
  return value;
}

/**
 * shairport_sync_set_version: (skip)
 * @object: A #ShairportSync.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-gnome-ShairportSync.Version">"Version"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
shairport_sync_set_version (ShairportSync *object, const gchar *value)
{
  g_object_set (G_OBJECT (object), "version", value, NULL);
}

/**
 * shairport_sync_get_version_string: (skip)
 * @object: A #ShairportSync.
 *
 * Gets the value of the <link linkend="gdbus-property-org-gnome-ShairportSync.VersionString">"VersionString"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use shairport_sync_dup_version_string() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
const gchar *
shairport_sync_get_version_string (ShairportSync *object)
{
  g_return_val_if_fail (IS_SHAIRPORT_SYNC (object), NULL);

  return SHAIRPORT_SYNC_GET_IFACE (object)->get_version_string (object);
}

/**
 * shairport_sync_dup_version_string: (skip)
 * @object: A #ShairportSync.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-gnome-ShairportSync.VersionString">"VersionString"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_free().
 */
gchar *
shairport_sync_dup_version_string (ShairportSync *object)
{
  gchar *value;
  g_object_get (G_OBJECT (object), "version-string", &value, NULL);
  return value;
}

/**
 * shairport_sync_set_version_string: (skip)
 * @object: A #ShairportSync.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-gnome-ShairportSync.VersionString">"VersionString"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
shairport_sync_set_version_string (ShairportSync *object, const gchar *value)
{
  g_object_set (G_OBJECT (object), "version-string", value, NULL);
}

/**
 * shairport_sync_get_protocol: (skip)
 * @object: A #ShairportSync.
 *
 * Gets the value of the <link linkend="gdbus-property-org-gnome-ShairportSync.Protocol">"Protocol"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use shairport_sync_dup_protocol() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
const gchar *
shairport_sync_get_protocol (ShairportSync *object)
{
  g_return_val_if_fail (IS_SHAIRPORT_SYNC (object), NULL);

  return SHAIRPORT_SYNC_GET_IFACE (object)->get_protocol (object);
}

/**
 * shairport_sync_dup_protocol: (skip)
 * @object: A #ShairportSync.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-gnome-ShairportSync.Protocol">"Protocol"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_free().
 */
gchar *
shairport_sync_dup_protocol (ShairportSync *object)
{
  gchar *value;
  g_object_get (G_OBJECT (object), "protocol", &value, NULL);
  return value;
}

/**
 * shairport_sync_set_protocol: (skip)
 * @object: A #ShairportSync.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-gnome-ShairportSync.Protocol">"Protocol"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
shairport_sync_set_protocol (ShairportSync *object, const gchar *value)
{
  g_object_set (G_OBJECT (object), "protocol", value, NULL);
}

/**
 * shairport_sync_get_service_name: (skip)
 * @object: A #ShairportSync.
 *
 * Gets the value of the <link linkend="gdbus-property-org-gnome-ShairportSync.ServiceName">"ServiceName"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use shairport_sync_dup_service_name() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
const gchar *
shairport_sync_get_service_name (ShairportSync *object)
{
  g_return_val_if_fail (IS_SHAIRPORT_SYNC (object), NULL);

  return SHAIRPORT_SYNC_GET_IFACE (object)->get_service_name (object);
}

/**
 * shairport_sync_dup_service_name: (skip)
 * @object: A #ShairportSync.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-gnome-ShairportSync.ServiceName">"ServiceName"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_free().
 */
gchar *
shairport_sync_dup_service_name (ShairportSync *object)
{
  gchar *value;
  g_object_get (G_OBJECT (object), "service-name", &value, NULL);
  return value;
}

/**
 * shairport_sync_set_service_name: (skip)
 * @object: A #ShairportSync.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-gnome-ShairportSync.ServiceName">"ServiceName"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
shairport_sync_set_service_name (ShairportSync *object, const gchar *value)
{
  g_object_set (G_OBJECT (object), "service-name", value, NULL);
}

/**
 * shairport_sync_get_output_format: (skip)
 * @object: A #ShairportSync.
 *
 * Gets the value of the <link linkend="gdbus-property-org-gnome-ShairportSync.OutputFormat">"OutputFormat"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use shairport_sync_dup_output_format() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
const gchar *
shairport_sync_get_output_format (ShairportSync *object)
{
  g_return_val_if_fail (IS_SHAIRPORT_SYNC (object), NULL);

  return SHAIRPORT_SYNC_GET_IFACE (object)->get_output_format (object);
}

/**
 * shairport_sync_dup_output_format: (skip)
 * @object: A #ShairportSync.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-gnome-ShairportSync.OutputFormat">"OutputFormat"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_free().
 */
gchar *
shairport_sync_dup_output_format (ShairportSync *object)
{
  gchar *value;
  g_object_get (G_OBJECT (object), "output-format", &value, NULL);
  return value;
}

/**
 * shairport_sync_set_output_format: (skip)
 * @object: A #ShairportSync.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-gnome-ShairportSync.OutputFormat">"OutputFormat"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
shairport_sync_set_output_format (ShairportSync *object, const gchar *value)
{
  g_object_set (G_OBJECT (object), "output-format", value, NULL);
}

/**
 * shairport_sync_get_output_rate: (skip)
 * @object: A #ShairportSync.
 *
 * Gets the value of the <link linkend="gdbus-property-org-gnome-ShairportSync.OutputRate">"OutputRate"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
gint 
shairport_sync_get_output_rate (ShairportSync *object)
{
  g_return_val_if_fail (IS_SHAIRPORT_SYNC (object), 0);

  return SHAIRPORT_SYNC_GET_IFACE (object)->get_output_rate (object);
}

/**
 * shairport_sync_set_output_rate: (skip)
 * @object: A #ShairportSync.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-gnome-ShairportSync.OutputRate">"OutputRate"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
shairport_sync_set_output_rate (ShairportSync *object, gint value)
{
  g_object_set (G_OBJECT (object), "output-rate", value, NULL);
}

/**
 * shairport_sync_get_first_frame_position: (skip)
 * @object: A #ShairportSync.
 *
 * Gets the value of the <link linkend="gdbus-property-org-gnome-ShairportSync.FirstFramePosition">"FirstFramePosition"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use shairport_sync_dup_first_frame_position() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
const gchar *
shairport_sync_get_first_frame_position (ShairportSync *object)
{
  g_return_val_if_fail (IS_SHAIRPORT_SYNC (object), NULL);

  return SHAIRPORT_SYNC_GET_IFACE (object)->get_first_frame_position (object);
}

/**
 * shairport_sync_dup_first_frame_position: (skip)
 * @object: A #ShairportSync.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-gnome-ShairportSync.FirstFramePosition">"FirstFramePosition"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_free().
 */
gchar *
shairport_sync_dup_first_frame_position (ShairportSync *object)
{
  gchar *value;
  g_object_get (G_OBJECT (object), "first-frame-position", &value, NULL);
  return value;
}

/**
 * shairport_sync_set_first_frame_position: (skip)
 * @object: A #ShairportSync.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-gnome-ShairportSync.FirstFramePosition">"FirstFramePosition"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
shairport_sync_set_first_frame_position (ShairportSync *object, const gchar *value)
{
  g_object_set (G_OBJECT (object), "first-frame-position", value, NULL);
}

/**
 * shairport_sync_get_frame_position: (skip)
 * @object: A #ShairportSync.
 *
 * Gets the value of the <link linkend="gdbus-property-org-gnome-ShairportSync.FramePosition">"FramePosition"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use shairport_sync_dup_frame_position() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
const gchar *
shairport_sync_get_frame_position (ShairportSync *object)
{
  g_return_val_if_fail (IS_SHAIRPORT_SYNC (object), NULL);

  return SHAIRPORT_SYNC_GET_IFACE (object)->get_frame_position (object);
}

/**
 * shairport_sync_dup_frame_position: (skip)
 * @object: A #ShairportSync.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-gnome-ShairportSync.FramePosition">"FramePosition"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_free().
 */
gchar *
shairport_sync_dup_frame_position (ShairportSync *object)
{
  gchar *value;
  g_object_get (G_OBJECT (object), "frame-position", &value, NULL);
  return value;
}

/**
 * shairport_sync_set_frame_position: (skip)
 * @object: A #ShairportSync.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-gnome-ShairportSync.FramePosition">"FramePosition"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
shairport_sync_set_frame_position (ShairportSync *object, const gchar *value)
{
  g_object_set (G_OBJECT (object), "frame-position", value, NULL);
}

/**
 * shairport_sync_call_quit:
 * @proxy: A #ShairportSyncProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-gnome-ShairportSync.Quit">Quit()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call shairport_sync_call_quit_finish() to get the result of the operation.
 *
 * See shairport_sync_call_quit_sync() for the synchronous, blocking version of this method.
 */
void
shairport_sync_call_quit (
    ShairportSync *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "Quit",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * shairport_sync_call_quit_finish:
 * @proxy: A #ShairportSyncProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to shairport_sync_call_quit().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with shairport_sync_call_quit().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
shairport_sync_call_quit_finish (
    ShairportSync *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * shairport_sync_call_quit_sync:
 * @proxy: A #ShairportSyncProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-gnome-ShairportSync.Quit">Quit()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See shairport_sync_call_quit() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
shairport_sync_call_quit_sync (
    ShairportSync *proxy,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "Quit",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * shairport_sync_call_drop_session:
 * @proxy: A #ShairportSyncProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-gnome-ShairportSync.DropSession">DropSession()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call shairport_sync_call_drop_session_finish() to get the result of the operation.
 *
 * See shairport_sync_call_drop_session_sync() for the synchronous, blocking version of this method.
 */
void
shairport_sync_call_drop_session (
    ShairportSync *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "DropSession",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * shairport_sync_call_drop_session_finish:
 * @proxy: A #ShairportSyncProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to shairport_sync_call_drop_session().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with shairport_sync_call_drop_session().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
shairport_sync_call_drop_session_finish (
    ShairportSync *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * shairport_sync_call_drop_session_sync:
 * @proxy: A #ShairportSyncProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-gnome-ShairportSync.DropSession">DropSession()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See shairport_sync_call_drop_session() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
shairport_sync_call_drop_session_sync (
    ShairportSync *proxy,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "DropSession",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * shairport_sync_call_remote_command:
 * @proxy: A #ShairportSyncProxy.
 * @arg_command: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-gnome-ShairportSync.RemoteCommand">RemoteCommand()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call shairport_sync_call_remote_command_finish() to get the result of the operation.
 *
 * See shairport_sync_call_remote_command_sync() for the synchronous, blocking version of this method.
 */
void
shairport_sync_call_remote_command (
    ShairportSync *proxy,
    const gchar *arg_command,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "RemoteCommand",
    g_variant_new ("(s)",
                   arg_command),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * shairport_sync_call_remote_command_finish:
 * @proxy: A #ShairportSyncProxy.
 * @out_reply: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @out_response: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to shairport_sync_call_remote_command().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with shairport_sync_call_remote_command().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
shairport_sync_call_remote_command_finish (
    ShairportSync *proxy,
    gint *out_reply,
    gchar **out_response,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(is)",
                 out_reply,
                 out_response);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * shairport_sync_call_remote_command_sync:
 * @proxy: A #ShairportSyncProxy.
 * @arg_command: Argument to pass with the method invocation.
 * @out_reply: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @out_response: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-gnome-ShairportSync.RemoteCommand">RemoteCommand()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See shairport_sync_call_remote_command() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
shairport_sync_call_remote_command_sync (
    ShairportSync *proxy,
    const gchar *arg_command,
    gint *out_reply,
    gchar **out_response,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "RemoteCommand",
    g_variant_new ("(s)",
                   arg_command),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(is)",
                 out_reply,
                 out_response);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * shairport_sync_call_set_frame_position_update_interval:
 * @proxy: A #ShairportSyncProxy.
 * @arg_seconds: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-gnome-ShairportSync.SetFramePositionUpdateInterval">SetFramePositionUpdateInterval()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call shairport_sync_call_set_frame_position_update_interval_finish() to get the result of the operation.
 *
 * See shairport_sync_call_set_frame_position_update_interval_sync() for the synchronous, blocking version of this method.
 */
void
shairport_sync_call_set_frame_position_update_interval (
    ShairportSync *proxy,
    gdouble arg_seconds,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "SetFramePositionUpdateInterval",
    g_variant_new ("(d)",
                   arg_seconds),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * shairport_sync_call_set_frame_position_update_interval_finish:
 * @proxy: A #ShairportSyncProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to shairport_sync_call_set_frame_position_update_interval().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with shairport_sync_call_set_frame_position_update_interval().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
shairport_sync_call_set_frame_position_update_interval_finish (
    ShairportSync *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * shairport_sync_call_set_frame_position_update_interval_sync:
 * @proxy: A #ShairportSyncProxy.
 * @arg_seconds: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-gnome-ShairportSync.SetFramePositionUpdateInterval">SetFramePositionUpdateInterval()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See shairport_sync_call_set_frame_position_update_interval() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
shairport_sync_call_set_frame_position_update_interval_sync (
    ShairportSync *proxy,
    gdouble arg_seconds,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "SetFramePositionUpdateInterval",
    g_variant_new ("(d)",
                   arg_seconds),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * shairport_sync_complete_quit:
 * @object: A #ShairportSync.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-gnome-ShairportSync.Quit">Quit()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
shairport_sync_complete_quit (
    ShairportSync *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * shairport_sync_complete_drop_session:
 * @object: A #ShairportSync.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-gnome-ShairportSync.DropSession">DropSession()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
shairport_sync_complete_drop_session (
    ShairportSync *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * shairport_sync_complete_remote_command:
 * @object: A #ShairportSync.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @reply: Parameter to return.
 * @response: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-gnome-ShairportSync.RemoteCommand">RemoteCommand()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
shairport_sync_complete_remote_command (
    ShairportSync *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    gint reply,
    const gchar *response)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(is)",
                   reply,
                   response));
}

/**
 * shairport_sync_complete_set_frame_position_update_interval:
 * @object: A #ShairportSync.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-gnome-ShairportSync.SetFramePositionUpdateInterval">SetFramePositionUpdateInterval()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
shairport_sync_complete_set_frame_position_update_interval (
    ShairportSync *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/* ------------------------------------------------------------------------ */

/**
 * ShairportSyncProxy:
 *
 * The #ShairportSyncProxy structure contains only private data and should only be accessed using the provided API.
 */

/**
 * ShairportSyncProxyClass:
 * @parent_class: The parent class.
 *
 * Class structure for #ShairportSyncProxy.
 */

struct _ShairportSyncProxyPrivate
{
  GData *qdata;
};

static void shairport_sync_proxy_iface_init (ShairportSyncIface *iface);

#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (ShairportSyncProxy, shairport_sync_proxy, G_TYPE_DBUS_PROXY,
                         G_ADD_PRIVATE (ShairportSyncProxy)
                         G_IMPLEMENT_INTERFACE (TYPE_SHAIRPORT_SYNC, shairport_sync_proxy_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (ShairportSyncProxy, shairport_sync_proxy, G_TYPE_DBUS_PROXY,
                         G_IMPLEMENT_INTERFACE (TYPE_SHAIRPORT_SYNC, shairport_sync_proxy_iface_init))

#endif
static void
shairport_sync_proxy_finalize (GObject *object)
{
  ShairportSyncProxy *proxy = SHAIRPORT_SYNC_PROXY (object);
  g_datalist_clear (&proxy->priv->qdata);
  G_OBJECT_CLASS (shairport_sync_proxy_parent_class)->finalize (object);
}

static void
shairport_sync_proxy_get_property (GObject      *object,
  guint         prop_id,
  GValue       *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  const _ExtendedGDBusPropertyInfo *info;
  GVariant *variant;
  g_assert (prop_id != 0 && prop_id - 1 < 21);
  info = (const _ExtendedGDBusPropertyInfo *) _shairport_sync_property_info_pointers[prop_id - 1];
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (object), info->parent_struct.name);
  if (info->use_gvariant)
    {
      g_value_set_variant (value, variant);
    }
  else
    {
      if (variant != NULL)
        g_dbus_gvariant_to_gvalue (variant, value);
    }
  if (variant != NULL)
    g_variant_unref (variant);
}

static void
shairport_sync_proxy_set_property_cb (GDBusProxy *proxy,
  GAsyncResult *res,
  gpointer      user_data)
{
  const _ExtendedGDBusPropertyInfo *info = user_data;
  GError *error;
  GVariant *_ret;
  error = NULL;
  _ret = g_dbus_proxy_call_finish (proxy, res, &error);
  if (!_ret)
    {
      g_warning ("Error setting property '%s' on interface org.gnome.ShairportSync: %s (%s, %d)",
                 info->parent_struct.name, 
                 error->message, g_quark_to_string (error->domain), error->code);
      g_error_free (error);
    }
  else
    {
      g_variant_unref (_ret);
    }
}

static void
shairport_sync_proxy_set_property (GObject      *object,
  guint         prop_id,
  const GValue *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  const _ExtendedGDBusPropertyInfo *info;
  GVariant *variant;
  g_assert (prop_id != 0 && prop_id - 1 < 21);
  info = (const _ExtendedGDBusPropertyInfo *) _shairport_sync_property_info_pointers[prop_id - 1];
  variant = g_dbus_gvalue_to_gvariant (value, G_VARIANT_TYPE (info->parent_struct.signature));
  g_dbus_proxy_call (G_DBUS_PROXY (object),
    "org.freedesktop.DBus.Properties.Set",
    g_variant_new ("(ssv)", "org.gnome.ShairportSync", info->parent_struct.name, variant),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    NULL, (GAsyncReadyCallback) shairport_sync_proxy_set_property_cb, (GDBusPropertyInfo *) &info->parent_struct);
  g_variant_unref (variant);
}

static void
shairport_sync_proxy_g_signal (GDBusProxy *proxy,
  const gchar *sender_name G_GNUC_UNUSED,
  const gchar *signal_name,
  GVariant *parameters)
{
  _ExtendedGDBusSignalInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  gsize n;
  guint signal_id;
  info = (_ExtendedGDBusSignalInfo *) g_dbus_interface_info_lookup_signal ((GDBusInterfaceInfo *) &_shairport_sync_interface_info.parent_struct, signal_name);
  if (info == NULL)
    return;
  num_params = g_variant_n_children (parameters);
  paramv = g_new0 (GValue, num_params + 1);
  g_value_init (&paramv[0], TYPE_SHAIRPORT_SYNC);
  g_value_set_object (&paramv[0], proxy);
  g_variant_iter_init (&iter, parameters);
  n = 1;
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.args[n - 1];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, TYPE_SHAIRPORT_SYNC);
  g_signal_emitv (paramv, signal_id, 0, NULL);
  for (n = 0; n < num_params + 1; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static void
shairport_sync_proxy_g_properties_changed (GDBusProxy *_proxy,
  GVariant *changed_properties,
  const gchar *const *invalidated_properties)
{
  ShairportSyncProxy *proxy = SHAIRPORT_SYNC_PROXY (_proxy);
  guint n;
  const gchar *key;
  GVariantIter *iter;
  _ExtendedGDBusPropertyInfo *info;
  g_variant_get (changed_properties, "a{sv}", &iter);
  while (g_variant_iter_next (iter, "{&sv}", &key, NULL))
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_shairport_sync_interface_info.parent_struct, key);
      g_datalist_remove_data (&proxy->priv->qdata, key);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
  g_variant_iter_free (iter);
  for (n = 0; invalidated_properties[n] != NULL; n++)
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_shairport_sync_interface_info.parent_struct, invalidated_properties[n]);
      g_datalist_remove_data (&proxy->priv->qdata, invalidated_properties[n]);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
}

static gboolean 
shairport_sync_proxy_get_active (ShairportSync *object)
{
  ShairportSyncProxy *proxy = SHAIRPORT_SYNC_PROXY (object);
  GVariant *variant;
  gboolean value = FALSE;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "Active");
  if (variant != NULL)
    {
      value = g_variant_get_boolean (variant);
      g_variant_unref (variant);
    }
  return value;
}

static gboolean 
shairport_sync_proxy_get_disable_standby (ShairportSync *object)
{
  ShairportSyncProxy *proxy = SHAIRPORT_SYNC_PROXY (object);
  GVariant *variant;
  gboolean value = FALSE;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "DisableStandby");
  if (variant != NULL)
    {
      value = g_variant_get_boolean (variant);
      g_variant_unref (variant);
    }
  return value;
}

static const gchar *
shairport_sync_proxy_get_disable_standby_mode (ShairportSync *object)
{
  ShairportSyncProxy *proxy = SHAIRPORT_SYNC_PROXY (object);
  GVariant *variant;
  const gchar *value = NULL;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "DisableStandbyMode");
  if (variant != NULL)
    {
      value = g_variant_get_string (variant, NULL);
      g_variant_unref (variant);
    }
  return value;
}

static gboolean 
shairport_sync_proxy_get_loudness (ShairportSync *object)
{
  ShairportSyncProxy *proxy = SHAIRPORT_SYNC_PROXY (object);
  GVariant *variant;
  gboolean value = FALSE;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "Loudness");
  if (variant != NULL)
    {
      value = g_variant_get_boolean (variant);
      g_variant_unref (variant);
    }
  return value;
}

static gdouble 
shairport_sync_proxy_get_loudness_threshold (ShairportSync *object)
{
  ShairportSyncProxy *proxy = SHAIRPORT_SYNC_PROXY (object);
  GVariant *variant;
  gdouble value = 0.0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "LoudnessThreshold");
  if (variant != NULL)
    {
      value = g_variant_get_double (variant);
      g_variant_unref (variant);
    }
  return value;
}

static gboolean 
shairport_sync_proxy_get_convolution (ShairportSync *object)
{
  ShairportSyncProxy *proxy = SHAIRPORT_SYNC_PROXY (object);
  GVariant *variant;
  gboolean value = FALSE;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "Convolution");
  if (variant != NULL)
    {
      value = g_variant_get_boolean (variant);
      g_variant_unref (variant);
    }
  return value;
}

static gdouble 
shairport_sync_proxy_get_convolution_gain (ShairportSync *object)
{
  ShairportSyncProxy *proxy = SHAIRPORT_SYNC_PROXY (object);
  GVariant *variant;
  gdouble value = 0.0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "ConvolutionGain");
  if (variant != NULL)
    {
      value = g_variant_get_double (variant);
      g_variant_unref (variant);
    }
  return value;
}

static const gchar *
shairport_sync_proxy_get_convolution_impulse_response_file (ShairportSync *object)
{
  ShairportSyncProxy *proxy = SHAIRPORT_SYNC_PROXY (object);
  GVariant *variant;
  const gchar *value = NULL;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "ConvolutionImpulseResponseFile");
  if (variant != NULL)
    {
      value = g_variant_get_string (variant, NULL);
      g_variant_unref (variant);
    }
  return value;
}

static gdouble 
shairport_sync_proxy_get_drift_tolerance (ShairportSync *object)
{
  ShairportSyncProxy *proxy = SHAIRPORT_SYNC_PROXY (object);
  GVariant *variant;
  gdouble value = 0.0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "DriftTolerance");
  if (variant != NULL)
    {
      value = g_variant_get_double (variant);
      g_variant_unref (variant);
    }
  return value;
}

static gdouble 
shairport_sync_proxy_get_volume (ShairportSync *object)
{
  ShairportSyncProxy *proxy = SHAIRPORT_SYNC_PROXY (object);
  GVariant *variant;
  gdouble value = 0.0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "Volume");
  if (variant != NULL)
    {
      value = g_variant_get_double (variant);
      g_variant_unref (variant);
    }
  return value;
}

static const gchar *
shairport_sync_proxy_get_volume_control_profile (ShairportSync *object)
{
  ShairportSyncProxy *proxy = SHAIRPORT_SYNC_PROXY (object);
  GVariant *variant;
  const gchar *value = NULL;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "VolumeControlProfile");
  if (variant != NULL)
    {
      value = g_variant_get_string (variant, NULL);
      g_variant_unref (variant);
    }
  return value;
}

static const gchar *
shairport_sync_proxy_get_interpolation (ShairportSync *object)
{
  ShairportSyncProxy *proxy = SHAIRPORT_SYNC_PROXY (object);
  GVariant *variant;
  const gchar *value = NULL;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "Interpolation");
  if (variant != NULL)
    {
      value = g_variant_get_string (variant, NULL);
      g_variant_unref (variant);
    }
  return value;
}

static const gchar *
shairport_sync_proxy_get_alacdecoder (ShairportSync *object)
{
  ShairportSyncProxy *proxy = SHAIRPORT_SYNC_PROXY (object);
  GVariant *variant;
  const gchar *value = NULL;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "ALACDecoder");
  if (variant != NULL)
    {
      value = g_variant_get_string (variant, NULL);
      g_variant_unref (variant);
    }
  return value;
}

static const gchar *
shairport_sync_proxy_get_version (ShairportSync *object)
{
  ShairportSyncProxy *proxy = SHAIRPORT_SYNC_PROXY (object);
  GVariant *variant;
  const gchar *value = NULL;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "Version");
  if (variant != NULL)
    {
      value = g_variant_get_string (variant, NULL);
      g_variant_unref (variant);
    }
  return value;
}

static const gchar *
shairport_sync_proxy_get_version_string (ShairportSync *object)
{
  ShairportSyncProxy *proxy = SHAIRPORT_SYNC_PROXY (object);
  GVariant *variant;
  const gchar *value = NULL;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "VersionString");
  if (variant != NULL)
    {
      value = g_variant_get_string (variant, NULL);
      g_variant_unref (variant);
    }
  return value;
}

static const gchar *
shairport_sync_proxy_get_protocol (ShairportSync *object)
{
  ShairportSyncProxy *proxy = SHAIRPORT_SYNC_PROXY (object);
  GVariant *variant;
  const gchar *value = NULL;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "Protocol");
  if (variant != NULL)
    {
      value = g_variant_get_string (variant, NULL);
      g_variant_unref (variant);
    }
  return value;
}

static const gchar *
shairport_sync_proxy_get_service_name (ShairportSync *object)
{
  ShairportSyncProxy *proxy = SHAIRPORT_SYNC_PROXY (object);
  GVariant *variant;
  const gchar *value = NULL;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "ServiceName");
  if (variant != NULL)
    {
      value = g_variant_get_string (variant, NULL);
      g_variant_unref (variant);
    }
  return value;
}

static const gchar *
shairport_sync_proxy_get_output_format (ShairportSync *object)
{
  ShairportSyncProxy *proxy = SHAIRPORT_SYNC_PROXY (object);
  GVariant *variant;
  const gchar *value = NULL;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "OutputFormat");
  if (variant != NULL)
    {
      value = g_variant_get_string (variant, NULL);
      g_variant_unref (variant);
    }
  return value;
}

static gint 
shairport_sync_proxy_get_output_rate (ShairportSync *object)
{
  ShairportSyncProxy *proxy = SHAIRPORT_SYNC_PROXY (object);
  GVariant *variant;
  gint value = 0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "OutputRate");
  if (variant != NULL)
    {
      value = g_variant_get_int32 (variant);
      g_variant_unref (variant);
    }
  return value;
}

static const gchar *
shairport_sync_proxy_get_first_frame_position (ShairportSync *object)
{
  ShairportSyncProxy *proxy = SHAIRPORT_SYNC_PROXY (object);
  GVariant *variant;
  const gchar *value = NULL;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "FirstFramePosition");
  if (variant != NULL)
    {
      value = g_variant_get_string (variant, NULL);
      g_variant_unref (variant);
    }
  return value;
}

static const gchar *
shairport_sync_proxy_get_frame_position (ShairportSync *object)
{
  ShairportSyncProxy *proxy = SHAIRPORT_SYNC_PROXY (object);
  GVariant *variant;
  const gchar *value = NULL;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "FramePosition");
  if (variant != NULL)
    {
      value = g_variant_get_string (variant, NULL);
      g_variant_unref (variant);
    }
  return value;
}

static void
shairport_sync_proxy_init (ShairportSyncProxy *proxy)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  proxy->priv = shairport_sync_proxy_get_instance_private (proxy);
#else
  proxy->priv = G_TYPE_INSTANCE_GET_PRIVATE (proxy, TYPE_SHAIRPORT_SYNC_PROXY, ShairportSyncProxyPrivate);
#endif

  g_dbus_proxy_set_interface_info (G_DBUS_PROXY (proxy), shairport_sync_interface_info ());
}

static void
shairport_sync_proxy_class_init (ShairportSyncProxyClass *klass)
{
  GObjectClass *gobject_class;
  GDBusProxyClass *proxy_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize     = shairport_sync_proxy_finalize;
  gobject_class->get_property = shairport_sync_proxy_get_property;
  gobject_class->set_property = shairport_sync_proxy_set_property;

  proxy_class = G_DBUS_PROXY_CLASS (klass);
  proxy_class->g_signal = shairport_sync_proxy_g_signal;
  proxy_class->g_properties_changed = shairport_sync_proxy_g_properties_changed;

  shairport_sync_override_properties (gobject_class, 1);

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (ShairportSyncProxyPrivate));
#endif
}

static void
shairport_sync_proxy_iface_init (ShairportSyncIface *iface)
{
  iface->get_active = shairport_sync_proxy_get_active;
  iface->get_disable_standby = shairport_sync_proxy_get_disable_standby;
  iface->get_disable_standby_mode = shairport_sync_proxy_get_disable_standby_mode;
  iface->get_loudness = shairport_sync_proxy_get_loudness;
  iface->get_loudness_threshold = shairport_sync_proxy_get_loudness_threshold;
  iface->get_convolution = shairport_sync_proxy_get_convolution;
  iface->get_convolution_gain = shairport_sync_proxy_get_convolution_gain;
  iface->get_convolution_impulse_response_file = shairport_sync_proxy_get_convolution_impulse_response_file;
  iface->get_drift_tolerance = shairport_sync_proxy_get_drift_tolerance;
  iface->get_volume = shairport_sync_proxy_get_volume;
  iface->get_volume_control_profile = shairport_sync_proxy_get_volume_control_profile;
  iface->get_interpolation = shairport_sync_proxy_get_interpolation;
  iface->get_alacdecoder = shairport_sync_proxy_get_alacdecoder;
  iface->get_version = shairport_sync_proxy_get_version;
  iface->get_version_string = shairport_sync_proxy_get_version_string;
  iface->get_protocol = shairport_sync_proxy_get_protocol;
  iface->get_service_name = shairport_sync_proxy_get_service_name;
  iface->get_output_format = shairport_sync_proxy_get_output_format;
  iface->get_output_rate = shairport_sync_proxy_get_output_rate;
  iface->get_first_frame_position = shairport_sync_proxy_get_first_frame_position;
  iface->get_frame_position = shairport_sync_proxy_get_frame_position;
}

/**
 * shairport_sync_proxy_new:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-gnome-ShairportSync.top_of_page">org.gnome.ShairportSync</link>. See g_dbus_proxy_new() for more details.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call shairport_sync_proxy_new_finish() to get the result of the operation.
 *
 * See shairport_sync_proxy_new_sync() for the synchronous, blocking version of this constructor.
 */
void
shairport_sync_proxy_new (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (TYPE_SHAIRPORT_SYNC_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.gnome.ShairportSync", NULL);
}

/**
 * shairport_sync_proxy_new_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to shairport_sync_proxy_new().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with shairport_sync_proxy_new().
 *
 * Returns: (transfer full) (type ShairportSyncProxy): The constructed proxy object or %NULL if @error is set.
 */
ShairportSync *
shairport_sync_proxy_new_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return SHAIRPORT_SYNC (ret);
  else
    return NULL;
}

/**
 * shairport_sync_proxy_new_sync:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Synchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-gnome-ShairportSync.top_of_page">org.gnome.ShairportSync</link>. See g_dbus_proxy_new_sync() for more details.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See shairport_sync_proxy_new() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type ShairportSyncProxy): The constructed proxy object or %NULL if @error is set.
 */
ShairportSync *
shairport_sync_proxy_new_sync (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (TYPE_SHAIRPORT_SYNC_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.gnome.ShairportSync", NULL);
  if (ret != NULL)
    return SHAIRPORT_SYNC (ret);
  else
    return NULL;
}


/**
 * shairport_sync_proxy_new_for_bus:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Like shairport_sync_proxy_new() but takes a #GBusType instead of a #GDBusConnection.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call shairport_sync_proxy_new_for_bus_finish() to get the result of the operation.
 *
 * See shairport_sync_proxy_new_for_bus_sync() for the synchronous, blocking version of this constructor.
 */
void
shairport_sync_proxy_new_for_bus (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (TYPE_SHAIRPORT_SYNC_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.gnome.ShairportSync", NULL);
}

/**
 * shairport_sync_proxy_new_for_bus_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to shairport_sync_proxy_new_for_bus().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with shairport_sync_proxy_new_for_bus().
 *
 * Returns: (transfer full) (type ShairportSyncProxy): The constructed proxy object or %NULL if @error is set.
 */
ShairportSync *
shairport_sync_proxy_new_for_bus_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return SHAIRPORT_SYNC (ret);
  else
    return NULL;
}

/**
 * shairport_sync_proxy_new_for_bus_sync:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Like shairport_sync_proxy_new_sync() but takes a #GBusType instead of a #GDBusConnection.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See shairport_sync_proxy_new_for_bus() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type ShairportSyncProxy): The constructed proxy object or %NULL if @error is set.
 */
ShairportSync *
shairport_sync_proxy_new_for_bus_sync (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (TYPE_SHAIRPORT_SYNC_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.gnome.ShairportSync", NULL);
  if (ret != NULL)
    return SHAIRPORT_SYNC (ret);
  else
    return NULL;
}


/* ------------------------------------------------------------------------ */

/**
 * ShairportSyncSkeleton:
 *
 * The #ShairportSyncSkeleton structure contains only private data and should only be accessed using the provided API.
 */

/**
 * ShairportSyncSkeletonClass:
 * @parent_class: The parent class.
 *
 * Class structure for #ShairportSyncSkeleton.
 */

struct _ShairportSyncSkeletonPrivate
{
  GValue *properties;
  GList *changed_properties;
  GSource *changed_properties_idle_source;
  GMainContext *context;
  GMutex lock;
};

static void
_shairport_sync_skeleton_handle_method_call (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name,
  const gchar *method_name,
  GVariant *parameters,
  GDBusMethodInvocation *invocation,
  gpointer user_data)
{
  ShairportSyncSkeleton *skeleton = SHAIRPORT_SYNC_SKELETON (user_data);
  _ExtendedGDBusMethodInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  guint num_extra;
  gsize n;
  guint signal_id;
  GValue return_value = G_VALUE_INIT;
  info = (_ExtendedGDBusMethodInfo *) g_dbus_method_invocation_get_method_info (invocation);
  g_assert (info != NULL);
  num_params = g_variant_n_children (parameters);
  num_extra = info->pass_fdlist ? 3 : 2;  paramv = g_new0 (GValue, num_params + num_extra);
  n = 0;
  g_value_init (&paramv[n], TYPE_SHAIRPORT_SYNC);
  g_value_set_object (&paramv[n++], skeleton);
  g_value_init (&paramv[n], G_TYPE_DBUS_METHOD_INVOCATION);
  g_value_set_object (&paramv[n++], invocation);
  if (info->pass_fdlist)
    {
#ifdef G_OS_UNIX
      g_value_init (&paramv[n], G_TYPE_UNIX_FD_LIST);
      g_value_set_object (&paramv[n++], g_dbus_message_get_unix_fd_list (g_dbus_method_invocation_get_message (invocation)));
#else
      g_assert_not_reached ();
#endif
    }
  g_variant_iter_init (&iter, parameters);
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.in_args[n - num_extra];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, TYPE_SHAIRPORT_SYNC);
  g_value_init (&return_value, G_TYPE_BOOLEAN);
  g_signal_emitv (paramv, signal_id, 0, &return_value);
  if (!g_value_get_boolean (&return_value))
    g_dbus_method_invocation_return_error (invocation, G_DBUS_ERROR, G_DBUS_ERROR_UNKNOWN_METHOD, "Method %s is not implemented on interface %s", method_name, interface_name);
  g_value_unset (&return_value);
  for (n = 0; n < num_params + num_extra; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static GVariant *
_shairport_sync_skeleton_handle_get_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GError **error,
  gpointer user_data)
{
  ShairportSyncSkeleton *skeleton = SHAIRPORT_SYNC_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  GVariant *ret;
  ret = NULL;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_shairport_sync_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      g_value_init (&value, pspec->value_type);
      g_object_get_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      ret = g_dbus_gvalue_to_gvariant (&value, G_VARIANT_TYPE (info->parent_struct.signature));
      g_value_unset (&value);
    }
  return ret;
}

static gboolean
_shairport_sync_skeleton_handle_set_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GVariant *variant,
  GError **error,
  gpointer user_data)
{
  ShairportSyncSkeleton *skeleton = SHAIRPORT_SYNC_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  gboolean ret;
  ret = FALSE;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_shairport_sync_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      if (info->use_gvariant)
        g_value_set_variant (&value, variant);
      else
        g_dbus_gvariant_to_gvalue (variant, &value);
      g_object_set_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      g_value_unset (&value);
      ret = TRUE;
    }
  return ret;
}

static const GDBusInterfaceVTable _shairport_sync_skeleton_vtable =
{
  _shairport_sync_skeleton_handle_method_call,
  _shairport_sync_skeleton_handle_get_property,
  _shairport_sync_skeleton_handle_set_property,
  {NULL}
};

static GDBusInterfaceInfo *
shairport_sync_skeleton_dbus_interface_get_info (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return shairport_sync_interface_info ();
}

static GDBusInterfaceVTable *
shairport_sync_skeleton_dbus_interface_get_vtable (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return (GDBusInterfaceVTable *) &_shairport_sync_skeleton_vtable;
}

static GVariant *
shairport_sync_skeleton_dbus_interface_get_properties (GDBusInterfaceSkeleton *_skeleton)
{
  ShairportSyncSkeleton *skeleton = SHAIRPORT_SYNC_SKELETON (_skeleton);

  GVariantBuilder builder;
  guint n;
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_84
  g_variant_builder_init_static (&builder, G_VARIANT_TYPE ("a{sv}"));
#else
  g_variant_builder_init(&builder, G_VARIANT_TYPE ("a{sv}"));
#endif
  if (_shairport_sync_interface_info.parent_struct.properties == NULL)
    goto out;
  for (n = 0; _shairport_sync_interface_info.parent_struct.properties[n] != NULL; n++)
    {
      GDBusPropertyInfo *info = _shairport_sync_interface_info.parent_struct.properties[n];
      if (info->flags & G_DBUS_PROPERTY_INFO_FLAGS_READABLE)
        {
          GVariant *value;
          value = _shairport_sync_skeleton_handle_get_property (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)), NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.gnome.ShairportSync", info->name, NULL, skeleton);
          if (value != NULL)
            {
              g_variant_take_ref (value);
              g_variant_builder_add (&builder, "{sv}", info->name, value);
              g_variant_unref (value);
            }
        }
    }
out:
  return g_variant_builder_end (&builder);
}

static gboolean _shairport_sync_emit_changed (gpointer user_data);

static void
shairport_sync_skeleton_dbus_interface_flush (GDBusInterfaceSkeleton *_skeleton)
{
  ShairportSyncSkeleton *skeleton = SHAIRPORT_SYNC_SKELETON (_skeleton);
  gboolean emit_changed = FALSE;

  g_mutex_lock (&skeleton->priv->lock);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    {
      g_source_destroy (skeleton->priv->changed_properties_idle_source);
      skeleton->priv->changed_properties_idle_source = NULL;
      emit_changed = TRUE;
    }
  g_mutex_unlock (&skeleton->priv->lock);

  if (emit_changed)
    _shairport_sync_emit_changed (skeleton);
}

static void shairport_sync_skeleton_iface_init (ShairportSyncIface *iface);
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (ShairportSyncSkeleton, shairport_sync_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_ADD_PRIVATE (ShairportSyncSkeleton)
                         G_IMPLEMENT_INTERFACE (TYPE_SHAIRPORT_SYNC, shairport_sync_skeleton_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (ShairportSyncSkeleton, shairport_sync_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_IMPLEMENT_INTERFACE (TYPE_SHAIRPORT_SYNC, shairport_sync_skeleton_iface_init))

#endif
static void
shairport_sync_skeleton_finalize (GObject *object)
{
  ShairportSyncSkeleton *skeleton = SHAIRPORT_SYNC_SKELETON (object);
  guint n;
  for (n = 0; n < 21; n++)
    g_value_unset (&skeleton->priv->properties[n]);
  g_free (skeleton->priv->properties);
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    g_source_destroy (skeleton->priv->changed_properties_idle_source);
  g_main_context_unref (skeleton->priv->context);
  g_mutex_clear (&skeleton->priv->lock);
  G_OBJECT_CLASS (shairport_sync_skeleton_parent_class)->finalize (object);
}

static void
shairport_sync_skeleton_get_property (GObject      *object,
  guint         prop_id,
  GValue       *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  ShairportSyncSkeleton *skeleton = SHAIRPORT_SYNC_SKELETON (object);
  g_assert (prop_id != 0 && prop_id - 1 < 21);
  g_mutex_lock (&skeleton->priv->lock);
  g_value_copy (&skeleton->priv->properties[prop_id - 1], value);
  g_mutex_unlock (&skeleton->priv->lock);
}

static gboolean
_shairport_sync_emit_changed (gpointer user_data)
{
  ShairportSyncSkeleton *skeleton = SHAIRPORT_SYNC_SKELETON (user_data);
  GList *l;
  GVariantBuilder builder;
  GVariantBuilder invalidated_builder;
  guint num_changes;

  g_mutex_lock (&skeleton->priv->lock);
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_84
  g_variant_builder_init_static (&builder, G_VARIANT_TYPE ("a{sv}"));
  g_variant_builder_init_static (&invalidated_builder, G_VARIANT_TYPE ("as"));
#else
  g_variant_builder_init (&builder, G_VARIANT_TYPE ("a{sv}"));
  g_variant_builder_init (&invalidated_builder, G_VARIANT_TYPE ("as"));
#endif
  for (l = skeleton->priv->changed_properties, num_changes = 0; l != NULL; l = l->next)
    {
      ChangedProperty *cp = l->data;
      GVariant *variant;
      const GValue *cur_value;

      cur_value = &skeleton->priv->properties[cp->prop_id - 1];
      if (!_g_value_equal (cur_value, &cp->orig_value))
        {
          variant = g_dbus_gvalue_to_gvariant (cur_value, G_VARIANT_TYPE (cp->info->parent_struct.signature));
          g_variant_builder_add (&builder, "{sv}", cp->info->parent_struct.name, variant);
          g_variant_unref (variant);
          num_changes++;
        }
    }
  if (num_changes > 0)
    {
      GList *connections, *ll;
      GVariant *signal_variant;
      signal_variant = g_variant_ref_sink (g_variant_new ("(sa{sv}as)", "org.gnome.ShairportSync",
                                           &builder, &invalidated_builder));
      connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));
      for (ll = connections; ll != NULL; ll = ll->next)
        {
          GDBusConnection *connection = ll->data;

          g_dbus_connection_emit_signal (connection,
                                         NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)),
                                         "org.freedesktop.DBus.Properties",
                                         "PropertiesChanged",
                                         signal_variant,
                                         NULL);
        }
      g_variant_unref (signal_variant);
      g_list_free_full (connections, g_object_unref);
    }
  else
    {
      g_variant_builder_clear (&builder);
      g_variant_builder_clear (&invalidated_builder);
    }
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  skeleton->priv->changed_properties = NULL;
  skeleton->priv->changed_properties_idle_source = NULL;
  g_mutex_unlock (&skeleton->priv->lock);
  return FALSE;
}

static void
_shairport_sync_schedule_emit_changed (ShairportSyncSkeleton *skeleton, const _ExtendedGDBusPropertyInfo *info, guint prop_id, const GValue *orig_value)
{
  ChangedProperty *cp;
  GList *l;
  cp = NULL;
  for (l = skeleton->priv->changed_properties; l != NULL; l = l->next)
    {
      ChangedProperty *i_cp = l->data;
      if (i_cp->info == info)
        {
          cp = i_cp;
          break;
        }
    }
  if (cp == NULL)
    {
      cp = g_new0 (ChangedProperty, 1);
      cp->prop_id = prop_id;
      cp->info = info;
      skeleton->priv->changed_properties = g_list_prepend (skeleton->priv->changed_properties, cp);
      g_value_init (&cp->orig_value, G_VALUE_TYPE (orig_value));
      g_value_copy (orig_value, &cp->orig_value);
    }
}

static void
shairport_sync_skeleton_notify (GObject      *object,
  GParamSpec *pspec G_GNUC_UNUSED)
{
  ShairportSyncSkeleton *skeleton = SHAIRPORT_SYNC_SKELETON (object);
  g_mutex_lock (&skeleton->priv->lock);
  if (skeleton->priv->changed_properties != NULL &&
      skeleton->priv->changed_properties_idle_source == NULL)
    {
      skeleton->priv->changed_properties_idle_source = g_idle_source_new ();
      g_source_set_priority (skeleton->priv->changed_properties_idle_source, G_PRIORITY_DEFAULT);
      g_source_set_callback (skeleton->priv->changed_properties_idle_source, _shairport_sync_emit_changed, g_object_ref (skeleton), (GDestroyNotify) g_object_unref);
      g_source_set_name (skeleton->priv->changed_properties_idle_source, "[generated] _shairport_sync_emit_changed");
      g_source_attach (skeleton->priv->changed_properties_idle_source, skeleton->priv->context);
      g_source_unref (skeleton->priv->changed_properties_idle_source);
    }
  g_mutex_unlock (&skeleton->priv->lock);
}

static void
shairport_sync_skeleton_set_property (GObject      *object,
  guint         prop_id,
  const GValue *value,
  GParamSpec   *pspec)
{
  const _ExtendedGDBusPropertyInfo *info;
  ShairportSyncSkeleton *skeleton = SHAIRPORT_SYNC_SKELETON (object);
  g_assert (prop_id != 0 && prop_id - 1 < 21);
  info = (const _ExtendedGDBusPropertyInfo *) _shairport_sync_property_info_pointers[prop_id - 1];
  g_mutex_lock (&skeleton->priv->lock);
  g_object_freeze_notify (object);
  if (!_g_value_equal (value, &skeleton->priv->properties[prop_id - 1]))
    {
      if (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)) != NULL &&
          info->emits_changed_signal)
        _shairport_sync_schedule_emit_changed (skeleton, info, prop_id, &skeleton->priv->properties[prop_id - 1]);
      g_value_copy (value, &skeleton->priv->properties[prop_id - 1]);
      g_object_notify_by_pspec (object, pspec);
    }
  g_mutex_unlock (&skeleton->priv->lock);
  g_object_thaw_notify (object);
}

static void
shairport_sync_skeleton_init (ShairportSyncSkeleton *skeleton)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  skeleton->priv = shairport_sync_skeleton_get_instance_private (skeleton);
#else
  skeleton->priv = G_TYPE_INSTANCE_GET_PRIVATE (skeleton, TYPE_SHAIRPORT_SYNC_SKELETON, ShairportSyncSkeletonPrivate);
#endif

  g_mutex_init (&skeleton->priv->lock);
  skeleton->priv->context = g_main_context_ref_thread_default ();
  skeleton->priv->properties = g_new0 (GValue, 21);
  g_value_init (&skeleton->priv->properties[0], G_TYPE_BOOLEAN);
  g_value_init (&skeleton->priv->properties[1], G_TYPE_BOOLEAN);
  g_value_init (&skeleton->priv->properties[2], G_TYPE_STRING);
  g_value_init (&skeleton->priv->properties[3], G_TYPE_BOOLEAN);
  g_value_init (&skeleton->priv->properties[4], G_TYPE_DOUBLE);
  g_value_init (&skeleton->priv->properties[5], G_TYPE_BOOLEAN);
  g_value_init (&skeleton->priv->properties[6], G_TYPE_DOUBLE);
  g_value_init (&skeleton->priv->properties[7], G_TYPE_STRING);
  g_value_init (&skeleton->priv->properties[8], G_TYPE_DOUBLE);
  g_value_init (&skeleton->priv->properties[9], G_TYPE_DOUBLE);
  g_value_init (&skeleton->priv->properties[10], G_TYPE_STRING);
  g_value_init (&skeleton->priv->properties[11], G_TYPE_STRING);
  g_value_init (&skeleton->priv->properties[12], G_TYPE_STRING);
  g_value_init (&skeleton->priv->properties[13], G_TYPE_STRING);
  g_value_init (&skeleton->priv->properties[14], G_TYPE_STRING);
  g_value_init (&skeleton->priv->properties[15], G_TYPE_STRING);
  g_value_init (&skeleton->priv->properties[16], G_TYPE_STRING);
  g_value_init (&skeleton->priv->properties[17], G_TYPE_STRING);
  g_value_init (&skeleton->priv->properties[18], G_TYPE_INT);
  g_value_init (&skeleton->priv->properties[19], G_TYPE_STRING);
  g_value_init (&skeleton->priv->properties[20], G_TYPE_STRING);
}

static gboolean 
shairport_sync_skeleton_get_active (ShairportSync *object)
{
  ShairportSyncSkeleton *skeleton = SHAIRPORT_SYNC_SKELETON (object);
  gboolean value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_marshal_value_peek_boolean (&(skeleton->priv->properties[0]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static gboolean 
shairport_sync_skeleton_get_disable_standby (ShairportSync *object)
{
  ShairportSyncSkeleton *skeleton = SHAIRPORT_SYNC_SKELETON (object);
  gboolean value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_marshal_value_peek_boolean (&(skeleton->priv->properties[1]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static const gchar *
shairport_sync_skeleton_get_disable_standby_mode (ShairportSync *object)
{
  ShairportSyncSkeleton *skeleton = SHAIRPORT_SYNC_SKELETON (object);
  const gchar *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_marshal_value_peek_string (&(skeleton->priv->properties[2]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static gboolean 
shairport_sync_skeleton_get_loudness (ShairportSync *object)
{
  ShairportSyncSkeleton *skeleton = SHAIRPORT_SYNC_SKELETON (object);
  gboolean value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_marshal_value_peek_boolean (&(skeleton->priv->properties[3]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static gdouble 
shairport_sync_skeleton_get_loudness_threshold (ShairportSync *object)
{
  ShairportSyncSkeleton *skeleton = SHAIRPORT_SYNC_SKELETON (object);
  gdouble value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_marshal_value_peek_double (&(skeleton->priv->properties[4]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static gboolean 
shairport_sync_skeleton_get_convolution (ShairportSync *object)
{
  ShairportSyncSkeleton *skeleton = SHAIRPORT_SYNC_SKELETON (object);
  gboolean value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_marshal_value_peek_boolean (&(skeleton->priv->properties[5]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static gdouble 
shairport_sync_skeleton_get_convolution_gain (ShairportSync *object)
{
  ShairportSyncSkeleton *skeleton = SHAIRPORT_SYNC_SKELETON (object);
  gdouble value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_marshal_value_peek_double (&(skeleton->priv->properties[6]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static const gchar *
shairport_sync_skeleton_get_convolution_impulse_response_file (ShairportSync *object)
{
  ShairportSyncSkeleton *skeleton = SHAIRPORT_SYNC_SKELETON (object);
  const gchar *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_marshal_value_peek_string (&(skeleton->priv->properties[7]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static gdouble 
shairport_sync_skeleton_get_drift_tolerance (ShairportSync *object)
{
  ShairportSyncSkeleton *skeleton = SHAIRPORT_SYNC_SKELETON (object);
  gdouble value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_marshal_value_peek_double (&(skeleton->priv->properties[8]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static gdouble 
shairport_sync_skeleton_get_volume (ShairportSync *object)
{
  ShairportSyncSkeleton *skeleton = SHAIRPORT_SYNC_SKELETON (object);
  gdouble value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_marshal_value_peek_double (&(skeleton->priv->properties[9]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static const gchar *
shairport_sync_skeleton_get_volume_control_profile (ShairportSync *object)
{
  ShairportSyncSkeleton *skeleton = SHAIRPORT_SYNC_SKELETON (object);
  const gchar *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_marshal_value_peek_string (&(skeleton->priv->properties[10]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static const gchar *
shairport_sync_skeleton_get_interpolation (ShairportSync *object)
{
  ShairportSyncSkeleton *skeleton = SHAIRPORT_SYNC_SKELETON (object);
  const gchar *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_marshal_value_peek_string (&(skeleton->priv->properties[11]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static const gchar *
shairport_sync_skeleton_get_alacdecoder (ShairportSync *object)
{
  ShairportSyncSkeleton *skeleton = SHAIRPORT_SYNC_SKELETON (object);
  const gchar *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_marshal_value_peek_string (&(skeleton->priv->properties[12]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static const gchar *
shairport_sync_skeleton_get_version (ShairportSync *object)
{
  ShairportSyncSkeleton *skeleton = SHAIRPORT_SYNC_SKELETON (object);
  const gchar *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_marshal_value_peek_string (&(skeleton->priv->properties[13]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static const gchar *
shairport_sync_skeleton_get_version_string (ShairportSync *object)
{
  ShairportSyncSkeleton *skeleton = SHAIRPORT_SYNC_SKELETON (object);
  const gchar *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_marshal_value_peek_string (&(skeleton->priv->properties[14]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static const gchar *
shairport_sync_skeleton_get_protocol (ShairportSync *object)
{
  ShairportSyncSkeleton *skeleton = SHAIRPORT_SYNC_SKELETON (object);
  const gchar *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_marshal_value_peek_string (&(skeleton->priv->properties[15]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static const gchar *
shairport_sync_skeleton_get_service_name (ShairportSync *object)
{
  ShairportSyncSkeleton *skeleton = SHAIRPORT_SYNC_SKELETON (object);
  const gchar *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_marshal_value_peek_string (&(skeleton->priv->properties[16]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static const gchar *
shairport_sync_skeleton_get_output_format (ShairportSync *object)
{
  ShairportSyncSkeleton *skeleton = SHAIRPORT_SYNC_SKELETON (object);
  const gchar *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_marshal_value_peek_string (&(skeleton->priv->properties[17]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static gint 
shairport_sync_skeleton_get_output_rate (ShairportSync *object)
{
  ShairportSyncSkeleton *skeleton = SHAIRPORT_SYNC_SKELETON (object);
  gint value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_marshal_value_peek_int (&(skeleton->priv->properties[18]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static const gchar *
shairport_sync_skeleton_get_first_frame_position (ShairportSync *object)
{
  ShairportSyncSkeleton *skeleton = SHAIRPORT_SYNC_SKELETON (object);
  const gchar *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_marshal_value_peek_string (&(skeleton->priv->properties[19]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static const gchar *
shairport_sync_skeleton_get_frame_position (ShairportSync *object)
{
  ShairportSyncSkeleton *skeleton = SHAIRPORT_SYNC_SKELETON (object);
  const gchar *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_marshal_value_peek_string (&(skeleton->priv->properties[20]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static void
shairport_sync_skeleton_class_init (ShairportSyncSkeletonClass *klass)
{
  GObjectClass *gobject_class;
  GDBusInterfaceSkeletonClass *skeleton_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize = shairport_sync_skeleton_finalize;
  gobject_class->get_property = shairport_sync_skeleton_get_property;
  gobject_class->set_property = shairport_sync_skeleton_set_property;
  gobject_class->notify       = shairport_sync_skeleton_notify;


  shairport_sync_override_properties (gobject_class, 1);

  skeleton_class = G_DBUS_INTERFACE_SKELETON_CLASS (klass);
  skeleton_class->get_info = shairport_sync_skeleton_dbus_interface_get_info;
  skeleton_class->get_properties = shairport_sync_skeleton_dbus_interface_get_properties;
  skeleton_class->flush = shairport_sync_skeleton_dbus_interface_flush;
  skeleton_class->get_vtable = shairport_sync_skeleton_dbus_interface_get_vtable;

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (ShairportSyncSkeletonPrivate));
#endif
}

static void
shairport_sync_skeleton_iface_init (ShairportSyncIface *iface)
{
  iface->get_active = shairport_sync_skeleton_get_active;
  iface->get_disable_standby = shairport_sync_skeleton_get_disable_standby;
  iface->get_disable_standby_mode = shairport_sync_skeleton_get_disable_standby_mode;
  iface->get_loudness = shairport_sync_skeleton_get_loudness;
  iface->get_loudness_threshold = shairport_sync_skeleton_get_loudness_threshold;
  iface->get_convolution = shairport_sync_skeleton_get_convolution;
  iface->get_convolution_gain = shairport_sync_skeleton_get_convolution_gain;
  iface->get_convolution_impulse_response_file = shairport_sync_skeleton_get_convolution_impulse_response_file;
  iface->get_drift_tolerance = shairport_sync_skeleton_get_drift_tolerance;
  iface->get_volume = shairport_sync_skeleton_get_volume;
  iface->get_volume_control_profile = shairport_sync_skeleton_get_volume_control_profile;
  iface->get_interpolation = shairport_sync_skeleton_get_interpolation;
  iface->get_alacdecoder = shairport_sync_skeleton_get_alacdecoder;
  iface->get_version = shairport_sync_skeleton_get_version;
  iface->get_version_string = shairport_sync_skeleton_get_version_string;
  iface->get_protocol = shairport_sync_skeleton_get_protocol;
  iface->get_service_name = shairport_sync_skeleton_get_service_name;
  iface->get_output_format = shairport_sync_skeleton_get_output_format;
  iface->get_output_rate = shairport_sync_skeleton_get_output_rate;
  iface->get_first_frame_position = shairport_sync_skeleton_get_first_frame_position;
  iface->get_frame_position = shairport_sync_skeleton_get_frame_position;
}

/**
 * shairport_sync_skeleton_new:
 *
 * Creates a skeleton object for the D-Bus interface <link linkend="gdbus-interface-org-gnome-ShairportSync.top_of_page">org.gnome.ShairportSync</link>.
 *
 * Returns: (transfer full) (type ShairportSyncSkeleton): The skeleton object.
 */
ShairportSync *
shairport_sync_skeleton_new (void)
{
  return SHAIRPORT_SYNC (g_object_new (TYPE_SHAIRPORT_SYNC_SKELETON, NULL));
}

/* ------------------------------------------------------------------------
 * Code for interface org.gnome.ShairportSync.Diagnostics
 * ------------------------------------------------------------------------
 */

/**
 * SECTION:ShairportSyncDiagnostics
 * @title: ShairportSyncDiagnostics
 * @short_description: Generated C code for the org.gnome.ShairportSync.Diagnostics D-Bus interface
 *
 * This section contains code for working with the <link linkend="gdbus-interface-org-gnome-ShairportSync-Diagnostics.top_of_page">org.gnome.ShairportSync.Diagnostics</link> D-Bus interface in C.
 */

/* ---- Introspection data for org.gnome.ShairportSync.Diagnostics ---- */

static const _ExtendedGDBusPropertyInfo _shairport_sync_diagnostics_property_info_verbosity =
{
  {
    -1,
    (gchar *) "Verbosity",
    (gchar *) "i",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE | G_DBUS_PROPERTY_INFO_FLAGS_WRITABLE,
    NULL
  },
  "verbosity",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _shairport_sync_diagnostics_property_info_statistics =
{
  {
    -1,
    (gchar *) "Statistics",
    (gchar *) "b",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE | G_DBUS_PROPERTY_INFO_FLAGS_WRITABLE,
    NULL
  },
  "statistics",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _shairport_sync_diagnostics_property_info_elapsed_time =
{
  {
    -1,
    (gchar *) "ElapsedTime",
    (gchar *) "b",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE | G_DBUS_PROPERTY_INFO_FLAGS_WRITABLE,
    NULL
  },
  "elapsed-time",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _shairport_sync_diagnostics_property_info_delta_time =
{
  {
    -1,
    (gchar *) "DeltaTime",
    (gchar *) "b",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE | G_DBUS_PROPERTY_INFO_FLAGS_WRITABLE,
    NULL
  },
  "delta-time",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _shairport_sync_diagnostics_property_info_file_and_line =
{
  {
    -1,
    (gchar *) "FileAndLine",
    (gchar *) "b",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE | G_DBUS_PROPERTY_INFO_FLAGS_WRITABLE,
    NULL
  },
  "file-and-line",
  FALSE,
  TRUE
};

static const GDBusPropertyInfo * const _shairport_sync_diagnostics_property_info_pointers[] =
{
  &_shairport_sync_diagnostics_property_info_verbosity.parent_struct,
  &_shairport_sync_diagnostics_property_info_statistics.parent_struct,
  &_shairport_sync_diagnostics_property_info_elapsed_time.parent_struct,
  &_shairport_sync_diagnostics_property_info_delta_time.parent_struct,
  &_shairport_sync_diagnostics_property_info_file_and_line.parent_struct,
  NULL
};

static const _ExtendedGDBusInterfaceInfo _shairport_sync_diagnostics_interface_info =
{
  {
    -1,
    (gchar *) "org.gnome.ShairportSync.Diagnostics",
    NULL,
    NULL,
    (GDBusPropertyInfo **) &_shairport_sync_diagnostics_property_info_pointers,
    NULL
  },
  "shairport-sync-diagnostics",
};


/**
 * shairport_sync_diagnostics_interface_info:
 *
 * Gets a machine-readable description of the <link linkend="gdbus-interface-org-gnome-ShairportSync-Diagnostics.top_of_page">org.gnome.ShairportSync.Diagnostics</link> D-Bus interface.
 *
 * Returns: (transfer none): A #GDBusInterfaceInfo. Do not free.
 */
GDBusInterfaceInfo *
shairport_sync_diagnostics_interface_info (void)
{
  return (GDBusInterfaceInfo *) &_shairport_sync_diagnostics_interface_info.parent_struct;
}

/**
 * shairport_sync_diagnostics_override_properties:
 * @klass: The class structure for a #GObject derived class.
 * @property_id_begin: The property id to assign to the first overridden property.
 *
 * Overrides all #GObject properties in the #ShairportSyncDiagnostics interface for a concrete class.
 * The properties are overridden in the order they are defined.
 *
 * Returns: The last property id.
 */
guint
shairport_sync_diagnostics_override_properties (GObjectClass *klass, guint property_id_begin)
{
  g_object_class_override_property (klass, property_id_begin++, "verbosity");
  g_object_class_override_property (klass, property_id_begin++, "statistics");
  g_object_class_override_property (klass, property_id_begin++, "elapsed-time");
  g_object_class_override_property (klass, property_id_begin++, "delta-time");
  g_object_class_override_property (klass, property_id_begin++, "file-and-line");
  return property_id_begin - 1;
}



/**
 * ShairportSyncDiagnostics:
 *
 * Abstract interface type for the D-Bus interface <link linkend="gdbus-interface-org-gnome-ShairportSync-Diagnostics.top_of_page">org.gnome.ShairportSync.Diagnostics</link>.
 */

/**
 * ShairportSyncDiagnosticsIface:
 * @parent_iface: The parent interface.
 * @get_delta_time: Getter for the #ShairportSyncDiagnostics:delta-time property.
 * @get_elapsed_time: Getter for the #ShairportSyncDiagnostics:elapsed-time property.
 * @get_file_and_line: Getter for the #ShairportSyncDiagnostics:file-and-line property.
 * @get_statistics: Getter for the #ShairportSyncDiagnostics:statistics property.
 * @get_verbosity: Getter for the #ShairportSyncDiagnostics:verbosity property.
 *
 * Virtual table for the D-Bus interface <link linkend="gdbus-interface-org-gnome-ShairportSync-Diagnostics.top_of_page">org.gnome.ShairportSync.Diagnostics</link>.
 */

typedef ShairportSyncDiagnosticsIface ShairportSyncDiagnosticsInterface;
G_DEFINE_INTERFACE (ShairportSyncDiagnostics, shairport_sync_diagnostics, G_TYPE_OBJECT)

static void
shairport_sync_diagnostics_default_init (ShairportSyncDiagnosticsIface *iface)
{
  /* GObject properties for D-Bus properties: */
  /**
   * ShairportSyncDiagnostics:verbosity:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-gnome-ShairportSync-Diagnostics.Verbosity">"Verbosity"</link>.
   *
   * Since the D-Bus property for this #GObject property is both readable and writable, it is meaningful to both read from it and write to it on both the service- and client-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_int ("verbosity", "Verbosity", "Verbosity", G_MININT32, G_MAXINT32, 0, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * ShairportSyncDiagnostics:statistics:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-gnome-ShairportSync-Diagnostics.Statistics">"Statistics"</link>.
   *
   * Since the D-Bus property for this #GObject property is both readable and writable, it is meaningful to both read from it and write to it on both the service- and client-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_boolean ("statistics", "Statistics", "Statistics", FALSE, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * ShairportSyncDiagnostics:elapsed-time:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-gnome-ShairportSync-Diagnostics.ElapsedTime">"ElapsedTime"</link>.
   *
   * Since the D-Bus property for this #GObject property is both readable and writable, it is meaningful to both read from it and write to it on both the service- and client-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_boolean ("elapsed-time", "ElapsedTime", "ElapsedTime", FALSE, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * ShairportSyncDiagnostics:delta-time:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-gnome-ShairportSync-Diagnostics.DeltaTime">"DeltaTime"</link>.
   *
   * Since the D-Bus property for this #GObject property is both readable and writable, it is meaningful to both read from it and write to it on both the service- and client-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_boolean ("delta-time", "DeltaTime", "DeltaTime", FALSE, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * ShairportSyncDiagnostics:file-and-line:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-gnome-ShairportSync-Diagnostics.FileAndLine">"FileAndLine"</link>.
   *
   * Since the D-Bus property for this #GObject property is both readable and writable, it is meaningful to both read from it and write to it on both the service- and client-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_boolean ("file-and-line", "FileAndLine", "FileAndLine", FALSE, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
}

/**
 * shairport_sync_diagnostics_get_verbosity: (skip)
 * @object: A #ShairportSyncDiagnostics.
 *
 * Gets the value of the <link linkend="gdbus-property-org-gnome-ShairportSync-Diagnostics.Verbosity">"Verbosity"</link> D-Bus property.
 *
 * Since this D-Bus property is both readable and writable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
gint 
shairport_sync_diagnostics_get_verbosity (ShairportSyncDiagnostics *object)
{
  g_return_val_if_fail (IS_SHAIRPORT_SYNC_DIAGNOSTICS (object), 0);

  return SHAIRPORT_SYNC_DIAGNOSTICS_GET_IFACE (object)->get_verbosity (object);
}

/**
 * shairport_sync_diagnostics_set_verbosity: (skip)
 * @object: A #ShairportSyncDiagnostics.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-gnome-ShairportSync-Diagnostics.Verbosity">"Verbosity"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is both readable and writable, it is meaningful to use this function on both the client- and service-side.
 */
void
shairport_sync_diagnostics_set_verbosity (ShairportSyncDiagnostics *object, gint value)
{
  g_object_set (G_OBJECT (object), "verbosity", value, NULL);
}

/**
 * shairport_sync_diagnostics_get_statistics: (skip)
 * @object: A #ShairportSyncDiagnostics.
 *
 * Gets the value of the <link linkend="gdbus-property-org-gnome-ShairportSync-Diagnostics.Statistics">"Statistics"</link> D-Bus property.
 *
 * Since this D-Bus property is both readable and writable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
gboolean 
shairport_sync_diagnostics_get_statistics (ShairportSyncDiagnostics *object)
{
  g_return_val_if_fail (IS_SHAIRPORT_SYNC_DIAGNOSTICS (object), FALSE);

  return SHAIRPORT_SYNC_DIAGNOSTICS_GET_IFACE (object)->get_statistics (object);
}

/**
 * shairport_sync_diagnostics_set_statistics: (skip)
 * @object: A #ShairportSyncDiagnostics.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-gnome-ShairportSync-Diagnostics.Statistics">"Statistics"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is both readable and writable, it is meaningful to use this function on both the client- and service-side.
 */
void
shairport_sync_diagnostics_set_statistics (ShairportSyncDiagnostics *object, gboolean value)
{
  g_object_set (G_OBJECT (object), "statistics", value, NULL);
}

/**
 * shairport_sync_diagnostics_get_elapsed_time: (skip)
 * @object: A #ShairportSyncDiagnostics.
 *
 * Gets the value of the <link linkend="gdbus-property-org-gnome-ShairportSync-Diagnostics.ElapsedTime">"ElapsedTime"</link> D-Bus property.
 *
 * Since this D-Bus property is both readable and writable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
gboolean 
shairport_sync_diagnostics_get_elapsed_time (ShairportSyncDiagnostics *object)
{
  g_return_val_if_fail (IS_SHAIRPORT_SYNC_DIAGNOSTICS (object), FALSE);

  return SHAIRPORT_SYNC_DIAGNOSTICS_GET_IFACE (object)->get_elapsed_time (object);
}

/**
 * shairport_sync_diagnostics_set_elapsed_time: (skip)
 * @object: A #ShairportSyncDiagnostics.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-gnome-ShairportSync-Diagnostics.ElapsedTime">"ElapsedTime"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is both readable and writable, it is meaningful to use this function on both the client- and service-side.
 */
void
shairport_sync_diagnostics_set_elapsed_time (ShairportSyncDiagnostics *object, gboolean value)
{
  g_object_set (G_OBJECT (object), "elapsed-time", value, NULL);
}

/**
 * shairport_sync_diagnostics_get_delta_time: (skip)
 * @object: A #ShairportSyncDiagnostics.
 *
 * Gets the value of the <link linkend="gdbus-property-org-gnome-ShairportSync-Diagnostics.DeltaTime">"DeltaTime"</link> D-Bus property.
 *
 * Since this D-Bus property is both readable and writable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
gboolean 
shairport_sync_diagnostics_get_delta_time (ShairportSyncDiagnostics *object)
{
  g_return_val_if_fail (IS_SHAIRPORT_SYNC_DIAGNOSTICS (object), FALSE);

  return SHAIRPORT_SYNC_DIAGNOSTICS_GET_IFACE (object)->get_delta_time (object);
}

/**
 * shairport_sync_diagnostics_set_delta_time: (skip)
 * @object: A #ShairportSyncDiagnostics.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-gnome-ShairportSync-Diagnostics.DeltaTime">"DeltaTime"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is both readable and writable, it is meaningful to use this function on both the client- and service-side.
 */
void
shairport_sync_diagnostics_set_delta_time (ShairportSyncDiagnostics *object, gboolean value)
{
  g_object_set (G_OBJECT (object), "delta-time", value, NULL);
}

/**
 * shairport_sync_diagnostics_get_file_and_line: (skip)
 * @object: A #ShairportSyncDiagnostics.
 *
 * Gets the value of the <link linkend="gdbus-property-org-gnome-ShairportSync-Diagnostics.FileAndLine">"FileAndLine"</link> D-Bus property.
 *
 * Since this D-Bus property is both readable and writable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
gboolean 
shairport_sync_diagnostics_get_file_and_line (ShairportSyncDiagnostics *object)
{
  g_return_val_if_fail (IS_SHAIRPORT_SYNC_DIAGNOSTICS (object), FALSE);

  return SHAIRPORT_SYNC_DIAGNOSTICS_GET_IFACE (object)->get_file_and_line (object);
}

/**
 * shairport_sync_diagnostics_set_file_and_line: (skip)
 * @object: A #ShairportSyncDiagnostics.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-gnome-ShairportSync-Diagnostics.FileAndLine">"FileAndLine"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is both readable and writable, it is meaningful to use this function on both the client- and service-side.
 */
void
shairport_sync_diagnostics_set_file_and_line (ShairportSyncDiagnostics *object, gboolean value)
{
  g_object_set (G_OBJECT (object), "file-and-line", value, NULL);
}

/* ------------------------------------------------------------------------ */

/**
 * ShairportSyncDiagnosticsProxy:
 *
 * The #ShairportSyncDiagnosticsProxy structure contains only private data and should only be accessed using the provided API.
 */

/**
 * ShairportSyncDiagnosticsProxyClass:
 * @parent_class: The parent class.
 *
 * Class structure for #ShairportSyncDiagnosticsProxy.
 */

struct _ShairportSyncDiagnosticsProxyPrivate
{
  GData *qdata;
};

static void shairport_sync_diagnostics_proxy_iface_init (ShairportSyncDiagnosticsIface *iface);

#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (ShairportSyncDiagnosticsProxy, shairport_sync_diagnostics_proxy, G_TYPE_DBUS_PROXY,
                         G_ADD_PRIVATE (ShairportSyncDiagnosticsProxy)
                         G_IMPLEMENT_INTERFACE (TYPE_SHAIRPORT_SYNC_DIAGNOSTICS, shairport_sync_diagnostics_proxy_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (ShairportSyncDiagnosticsProxy, shairport_sync_diagnostics_proxy, G_TYPE_DBUS_PROXY,
                         G_IMPLEMENT_INTERFACE (TYPE_SHAIRPORT_SYNC_DIAGNOSTICS, shairport_sync_diagnostics_proxy_iface_init))

#endif
static void
shairport_sync_diagnostics_proxy_finalize (GObject *object)
{
  ShairportSyncDiagnosticsProxy *proxy = SHAIRPORT_SYNC_DIAGNOSTICS_PROXY (object);
  g_datalist_clear (&proxy->priv->qdata);
  G_OBJECT_CLASS (shairport_sync_diagnostics_proxy_parent_class)->finalize (object);
}

static void
shairport_sync_diagnostics_proxy_get_property (GObject      *object,
  guint         prop_id,
  GValue       *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  const _ExtendedGDBusPropertyInfo *info;
  GVariant *variant;
  g_assert (prop_id != 0 && prop_id - 1 < 5);
  info = (const _ExtendedGDBusPropertyInfo *) _shairport_sync_diagnostics_property_info_pointers[prop_id - 1];
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (object), info->parent_struct.name);
  if (info->use_gvariant)
    {
      g_value_set_variant (value, variant);
    }
  else
    {
      if (variant != NULL)
        g_dbus_gvariant_to_gvalue (variant, value);
    }
  if (variant != NULL)
    g_variant_unref (variant);
}

static void
shairport_sync_diagnostics_proxy_set_property_cb (GDBusProxy *proxy,
  GAsyncResult *res,
  gpointer      user_data)
{
  const _ExtendedGDBusPropertyInfo *info = user_data;
  GError *error;
  GVariant *_ret;
  error = NULL;
  _ret = g_dbus_proxy_call_finish (proxy, res, &error);
  if (!_ret)
    {
      g_warning ("Error setting property '%s' on interface org.gnome.ShairportSync.Diagnostics: %s (%s, %d)",
                 info->parent_struct.name, 
                 error->message, g_quark_to_string (error->domain), error->code);
      g_error_free (error);
    }
  else
    {
      g_variant_unref (_ret);
    }
}

static void
shairport_sync_diagnostics_proxy_set_property (GObject      *object,
  guint         prop_id,
  const GValue *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  const _ExtendedGDBusPropertyInfo *info;
  GVariant *variant;
  g_assert (prop_id != 0 && prop_id - 1 < 5);
  info = (const _ExtendedGDBusPropertyInfo *) _shairport_sync_diagnostics_property_info_pointers[prop_id - 1];
  variant = g_dbus_gvalue_to_gvariant (value, G_VARIANT_TYPE (info->parent_struct.signature));
  g_dbus_proxy_call (G_DBUS_PROXY (object),
    "org.freedesktop.DBus.Properties.Set",
    g_variant_new ("(ssv)", "org.gnome.ShairportSync.Diagnostics", info->parent_struct.name, variant),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    NULL, (GAsyncReadyCallback) shairport_sync_diagnostics_proxy_set_property_cb, (GDBusPropertyInfo *) &info->parent_struct);
  g_variant_unref (variant);
}

static void
shairport_sync_diagnostics_proxy_g_signal (GDBusProxy *proxy,
  const gchar *sender_name G_GNUC_UNUSED,
  const gchar *signal_name,
  GVariant *parameters)
{
  _ExtendedGDBusSignalInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  gsize n;
  guint signal_id;
  info = (_ExtendedGDBusSignalInfo *) g_dbus_interface_info_lookup_signal ((GDBusInterfaceInfo *) &_shairport_sync_diagnostics_interface_info.parent_struct, signal_name);
  if (info == NULL)
    return;
  num_params = g_variant_n_children (parameters);
  paramv = g_new0 (GValue, num_params + 1);
  g_value_init (&paramv[0], TYPE_SHAIRPORT_SYNC_DIAGNOSTICS);
  g_value_set_object (&paramv[0], proxy);
  g_variant_iter_init (&iter, parameters);
  n = 1;
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.args[n - 1];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, TYPE_SHAIRPORT_SYNC_DIAGNOSTICS);
  g_signal_emitv (paramv, signal_id, 0, NULL);
  for (n = 0; n < num_params + 1; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static void
shairport_sync_diagnostics_proxy_g_properties_changed (GDBusProxy *_proxy,
  GVariant *changed_properties,
  const gchar *const *invalidated_properties)
{
  ShairportSyncDiagnosticsProxy *proxy = SHAIRPORT_SYNC_DIAGNOSTICS_PROXY (_proxy);
  guint n;
  const gchar *key;
  GVariantIter *iter;
  _ExtendedGDBusPropertyInfo *info;
  g_variant_get (changed_properties, "a{sv}", &iter);
  while (g_variant_iter_next (iter, "{&sv}", &key, NULL))
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_shairport_sync_diagnostics_interface_info.parent_struct, key);
      g_datalist_remove_data (&proxy->priv->qdata, key);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
  g_variant_iter_free (iter);
  for (n = 0; invalidated_properties[n] != NULL; n++)
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_shairport_sync_diagnostics_interface_info.parent_struct, invalidated_properties[n]);
      g_datalist_remove_data (&proxy->priv->qdata, invalidated_properties[n]);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
}

static gint 
shairport_sync_diagnostics_proxy_get_verbosity (ShairportSyncDiagnostics *object)
{
  ShairportSyncDiagnosticsProxy *proxy = SHAIRPORT_SYNC_DIAGNOSTICS_PROXY (object);
  GVariant *variant;
  gint value = 0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "Verbosity");
  if (variant != NULL)
    {
      value = g_variant_get_int32 (variant);
      g_variant_unref (variant);
    }
  return value;
}

static gboolean 
shairport_sync_diagnostics_proxy_get_statistics (ShairportSyncDiagnostics *object)
{
  ShairportSyncDiagnosticsProxy *proxy = SHAIRPORT_SYNC_DIAGNOSTICS_PROXY (object);
  GVariant *variant;
  gboolean value = FALSE;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "Statistics");
  if (variant != NULL)
    {
      value = g_variant_get_boolean (variant);
      g_variant_unref (variant);
    }
  return value;
}

static gboolean 
shairport_sync_diagnostics_proxy_get_elapsed_time (ShairportSyncDiagnostics *object)
{
  ShairportSyncDiagnosticsProxy *proxy = SHAIRPORT_SYNC_DIAGNOSTICS_PROXY (object);
  GVariant *variant;
  gboolean value = FALSE;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "ElapsedTime");
  if (variant != NULL)
    {
      value = g_variant_get_boolean (variant);
      g_variant_unref (variant);
    }
  return value;
}

static gboolean 
shairport_sync_diagnostics_proxy_get_delta_time (ShairportSyncDiagnostics *object)
{
  ShairportSyncDiagnosticsProxy *proxy = SHAIRPORT_SYNC_DIAGNOSTICS_PROXY (object);
  GVariant *variant;
  gboolean value = FALSE;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "DeltaTime");
  if (variant != NULL)
    {
      value = g_variant_get_boolean (variant);
      g_variant_unref (variant);
    }
  return value;
}

static gboolean 
shairport_sync_diagnostics_proxy_get_file_and_line (ShairportSyncDiagnostics *object)
{
  ShairportSyncDiagnosticsProxy *proxy = SHAIRPORT_SYNC_DIAGNOSTICS_PROXY (object);
  GVariant *variant;
  gboolean value = FALSE;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "FileAndLine");
  if (variant != NULL)
    {
      value = g_variant_get_boolean (variant);
      g_variant_unref (variant);
    }
  return value;
}

static void
shairport_sync_diagnostics_proxy_init (ShairportSyncDiagnosticsProxy *proxy)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  proxy->priv = shairport_sync_diagnostics_proxy_get_instance_private (proxy);
#else
  proxy->priv = G_TYPE_INSTANCE_GET_PRIVATE (proxy, TYPE_SHAIRPORT_SYNC_DIAGNOSTICS_PROXY, ShairportSyncDiagnosticsProxyPrivate);
#endif

  g_dbus_proxy_set_interface_info (G_DBUS_PROXY (proxy), shairport_sync_diagnostics_interface_info ());
}

static void
shairport_sync_diagnostics_proxy_class_init (ShairportSyncDiagnosticsProxyClass *klass)
{
  GObjectClass *gobject_class;
  GDBusProxyClass *proxy_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize     = shairport_sync_diagnostics_proxy_finalize;
  gobject_class->get_property = shairport_sync_diagnostics_proxy_get_property;
  gobject_class->set_property = shairport_sync_diagnostics_proxy_set_property;

  proxy_class = G_DBUS_PROXY_CLASS (klass);
  proxy_class->g_signal = shairport_sync_diagnostics_proxy_g_signal;
  proxy_class->g_properties_changed = shairport_sync_diagnostics_proxy_g_properties_changed;

  shairport_sync_diagnostics_override_properties (gobject_class, 1);

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (ShairportSyncDiagnosticsProxyPrivate));
#endif
}

static void
shairport_sync_diagnostics_proxy_iface_init (ShairportSyncDiagnosticsIface *iface)
{
  iface->get_verbosity = shairport_sync_diagnostics_proxy_get_verbosity;
  iface->get_statistics = shairport_sync_diagnostics_proxy_get_statistics;
  iface->get_elapsed_time = shairport_sync_diagnostics_proxy_get_elapsed_time;
  iface->get_delta_time = shairport_sync_diagnostics_proxy_get_delta_time;
  iface->get_file_and_line = shairport_sync_diagnostics_proxy_get_file_and_line;
}

/**
 * shairport_sync_diagnostics_proxy_new:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-gnome-ShairportSync-Diagnostics.top_of_page">org.gnome.ShairportSync.Diagnostics</link>. See g_dbus_proxy_new() for more details.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call shairport_sync_diagnostics_proxy_new_finish() to get the result of the operation.
 *
 * See shairport_sync_diagnostics_proxy_new_sync() for the synchronous, blocking version of this constructor.
 */
void
shairport_sync_diagnostics_proxy_new (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (TYPE_SHAIRPORT_SYNC_DIAGNOSTICS_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.gnome.ShairportSync.Diagnostics", NULL);
}

/**
 * shairport_sync_diagnostics_proxy_new_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to shairport_sync_diagnostics_proxy_new().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with shairport_sync_diagnostics_proxy_new().
 *
 * Returns: (transfer full) (type ShairportSyncDiagnosticsProxy): The constructed proxy object or %NULL if @error is set.
 */
ShairportSyncDiagnostics *
shairport_sync_diagnostics_proxy_new_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return SHAIRPORT_SYNC_DIAGNOSTICS (ret);
  else
    return NULL;
}

/**
 * shairport_sync_diagnostics_proxy_new_sync:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Synchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-gnome-ShairportSync-Diagnostics.top_of_page">org.gnome.ShairportSync.Diagnostics</link>. See g_dbus_proxy_new_sync() for more details.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See shairport_sync_diagnostics_proxy_new() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type ShairportSyncDiagnosticsProxy): The constructed proxy object or %NULL if @error is set.
 */
ShairportSyncDiagnostics *
shairport_sync_diagnostics_proxy_new_sync (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (TYPE_SHAIRPORT_SYNC_DIAGNOSTICS_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.gnome.ShairportSync.Diagnostics", NULL);
  if (ret != NULL)
    return SHAIRPORT_SYNC_DIAGNOSTICS (ret);
  else
    return NULL;
}


/**
 * shairport_sync_diagnostics_proxy_new_for_bus:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Like shairport_sync_diagnostics_proxy_new() but takes a #GBusType instead of a #GDBusConnection.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call shairport_sync_diagnostics_proxy_new_for_bus_finish() to get the result of the operation.
 *
 * See shairport_sync_diagnostics_proxy_new_for_bus_sync() for the synchronous, blocking version of this constructor.
 */
void
shairport_sync_diagnostics_proxy_new_for_bus (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (TYPE_SHAIRPORT_SYNC_DIAGNOSTICS_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.gnome.ShairportSync.Diagnostics", NULL);
}

/**
 * shairport_sync_diagnostics_proxy_new_for_bus_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to shairport_sync_diagnostics_proxy_new_for_bus().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with shairport_sync_diagnostics_proxy_new_for_bus().
 *
 * Returns: (transfer full) (type ShairportSyncDiagnosticsProxy): The constructed proxy object or %NULL if @error is set.
 */
ShairportSyncDiagnostics *
shairport_sync_diagnostics_proxy_new_for_bus_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return SHAIRPORT_SYNC_DIAGNOSTICS (ret);
  else
    return NULL;
}

/**
 * shairport_sync_diagnostics_proxy_new_for_bus_sync:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Like shairport_sync_diagnostics_proxy_new_sync() but takes a #GBusType instead of a #GDBusConnection.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See shairport_sync_diagnostics_proxy_new_for_bus() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type ShairportSyncDiagnosticsProxy): The constructed proxy object or %NULL if @error is set.
 */
ShairportSyncDiagnostics *
shairport_sync_diagnostics_proxy_new_for_bus_sync (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (TYPE_SHAIRPORT_SYNC_DIAGNOSTICS_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.gnome.ShairportSync.Diagnostics", NULL);
  if (ret != NULL)
    return SHAIRPORT_SYNC_DIAGNOSTICS (ret);
  else
    return NULL;
}


/* ------------------------------------------------------------------------ */

/**
 * ShairportSyncDiagnosticsSkeleton:
 *
 * The #ShairportSyncDiagnosticsSkeleton structure contains only private data and should only be accessed using the provided API.
 */

/**
 * ShairportSyncDiagnosticsSkeletonClass:
 * @parent_class: The parent class.
 *
 * Class structure for #ShairportSyncDiagnosticsSkeleton.
 */

struct _ShairportSyncDiagnosticsSkeletonPrivate
{
  GValue *properties;
  GList *changed_properties;
  GSource *changed_properties_idle_source;
  GMainContext *context;
  GMutex lock;
};

static void
_shairport_sync_diagnostics_skeleton_handle_method_call (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name,
  const gchar *method_name,
  GVariant *parameters,
  GDBusMethodInvocation *invocation,
  gpointer user_data)
{
  ShairportSyncDiagnosticsSkeleton *skeleton = SHAIRPORT_SYNC_DIAGNOSTICS_SKELETON (user_data);
  _ExtendedGDBusMethodInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  guint num_extra;
  gsize n;
  guint signal_id;
  GValue return_value = G_VALUE_INIT;
  info = (_ExtendedGDBusMethodInfo *) g_dbus_method_invocation_get_method_info (invocation);
  g_assert (info != NULL);
  num_params = g_variant_n_children (parameters);
  num_extra = info->pass_fdlist ? 3 : 2;  paramv = g_new0 (GValue, num_params + num_extra);
  n = 0;
  g_value_init (&paramv[n], TYPE_SHAIRPORT_SYNC_DIAGNOSTICS);
  g_value_set_object (&paramv[n++], skeleton);
  g_value_init (&paramv[n], G_TYPE_DBUS_METHOD_INVOCATION);
  g_value_set_object (&paramv[n++], invocation);
  if (info->pass_fdlist)
    {
#ifdef G_OS_UNIX
      g_value_init (&paramv[n], G_TYPE_UNIX_FD_LIST);
      g_value_set_object (&paramv[n++], g_dbus_message_get_unix_fd_list (g_dbus_method_invocation_get_message (invocation)));
#else
      g_assert_not_reached ();
#endif
    }
  g_variant_iter_init (&iter, parameters);
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.in_args[n - num_extra];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, TYPE_SHAIRPORT_SYNC_DIAGNOSTICS);
  g_value_init (&return_value, G_TYPE_BOOLEAN);
  g_signal_emitv (paramv, signal_id, 0, &return_value);
  if (!g_value_get_boolean (&return_value))
    g_dbus_method_invocation_return_error (invocation, G_DBUS_ERROR, G_DBUS_ERROR_UNKNOWN_METHOD, "Method %s is not implemented on interface %s", method_name, interface_name);
  g_value_unset (&return_value);
  for (n = 0; n < num_params + num_extra; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static GVariant *
_shairport_sync_diagnostics_skeleton_handle_get_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GError **error,
  gpointer user_data)
{
  ShairportSyncDiagnosticsSkeleton *skeleton = SHAIRPORT_SYNC_DIAGNOSTICS_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  GVariant *ret;
  ret = NULL;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_shairport_sync_diagnostics_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      g_value_init (&value, pspec->value_type);
      g_object_get_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      ret = g_dbus_gvalue_to_gvariant (&value, G_VARIANT_TYPE (info->parent_struct.signature));
      g_value_unset (&value);
    }
  return ret;
}

static gboolean
_shairport_sync_diagnostics_skeleton_handle_set_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GVariant *variant,
  GError **error,
  gpointer user_data)
{
  ShairportSyncDiagnosticsSkeleton *skeleton = SHAIRPORT_SYNC_DIAGNOSTICS_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  gboolean ret;
  ret = FALSE;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_shairport_sync_diagnostics_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      if (info->use_gvariant)
        g_value_set_variant (&value, variant);
      else
        g_dbus_gvariant_to_gvalue (variant, &value);
      g_object_set_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      g_value_unset (&value);
      ret = TRUE;
    }
  return ret;
}

static const GDBusInterfaceVTable _shairport_sync_diagnostics_skeleton_vtable =
{
  _shairport_sync_diagnostics_skeleton_handle_method_call,
  _shairport_sync_diagnostics_skeleton_handle_get_property,
  _shairport_sync_diagnostics_skeleton_handle_set_property,
  {NULL}
};

static GDBusInterfaceInfo *
shairport_sync_diagnostics_skeleton_dbus_interface_get_info (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return shairport_sync_diagnostics_interface_info ();
}

static GDBusInterfaceVTable *
shairport_sync_diagnostics_skeleton_dbus_interface_get_vtable (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return (GDBusInterfaceVTable *) &_shairport_sync_diagnostics_skeleton_vtable;
}

static GVariant *
shairport_sync_diagnostics_skeleton_dbus_interface_get_properties (GDBusInterfaceSkeleton *_skeleton)
{
  ShairportSyncDiagnosticsSkeleton *skeleton = SHAIRPORT_SYNC_DIAGNOSTICS_SKELETON (_skeleton);

  GVariantBuilder builder;
  guint n;
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_84
  g_variant_builder_init_static (&builder, G_VARIANT_TYPE ("a{sv}"));
#else
  g_variant_builder_init(&builder, G_VARIANT_TYPE ("a{sv}"));
#endif
  if (_shairport_sync_diagnostics_interface_info.parent_struct.properties == NULL)
    goto out;
  for (n = 0; _shairport_sync_diagnostics_interface_info.parent_struct.properties[n] != NULL; n++)
    {
      GDBusPropertyInfo *info = _shairport_sync_diagnostics_interface_info.parent_struct.properties[n];
      if (info->flags & G_DBUS_PROPERTY_INFO_FLAGS_READABLE)
        {
          GVariant *value;
          value = _shairport_sync_diagnostics_skeleton_handle_get_property (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)), NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.gnome.ShairportSync.Diagnostics", info->name, NULL, skeleton);
          if (value != NULL)
            {
              g_variant_take_ref (value);
              g_variant_builder_add (&builder, "{sv}", info->name, value);
              g_variant_unref (value);
            }
        }
    }
out:
  return g_variant_builder_end (&builder);
}

static gboolean _shairport_sync_diagnostics_emit_changed (gpointer user_data);

static void
shairport_sync_diagnostics_skeleton_dbus_interface_flush (GDBusInterfaceSkeleton *_skeleton)
{
  ShairportSyncDiagnosticsSkeleton *skeleton = SHAIRPORT_SYNC_DIAGNOSTICS_SKELETON (_skeleton);
  gboolean emit_changed = FALSE;

  g_mutex_lock (&skeleton->priv->lock);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    {
      g_source_destroy (skeleton->priv->changed_properties_idle_source);
      skeleton->priv->changed_properties_idle_source = NULL;
      emit_changed = TRUE;
    }
  g_mutex_unlock (&skeleton->priv->lock);

  if (emit_changed)
    _shairport_sync_diagnostics_emit_changed (skeleton);
}

static void shairport_sync_diagnostics_skeleton_iface_init (ShairportSyncDiagnosticsIface *iface);
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (ShairportSyncDiagnosticsSkeleton, shairport_sync_diagnostics_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_ADD_PRIVATE (ShairportSyncDiagnosticsSkeleton)
                         G_IMPLEMENT_INTERFACE (TYPE_SHAIRPORT_SYNC_DIAGNOSTICS, shairport_sync_diagnostics_skeleton_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (ShairportSyncDiagnosticsSkeleton, shairport_sync_diagnostics_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_IMPLEMENT_INTERFACE (TYPE_SHAIRPORT_SYNC_DIAGNOSTICS, shairport_sync_diagnostics_skeleton_iface_init))

#endif
static void
shairport_sync_diagnostics_skeleton_finalize (GObject *object)
{
  ShairportSyncDiagnosticsSkeleton *skeleton = SHAIRPORT_SYNC_DIAGNOSTICS_SKELETON (object);
  guint n;
  for (n = 0; n < 5; n++)
    g_value_unset (&skeleton->priv->properties[n]);
  g_free (skeleton->priv->properties);
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    g_source_destroy (skeleton->priv->changed_properties_idle_source);
  g_main_context_unref (skeleton->priv->context);
  g_mutex_clear (&skeleton->priv->lock);
  G_OBJECT_CLASS (shairport_sync_diagnostics_skeleton_parent_class)->finalize (object);
}

static void
shairport_sync_diagnostics_skeleton_get_property (GObject      *object,
  guint         prop_id,
  GValue       *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  ShairportSyncDiagnosticsSkeleton *skeleton = SHAIRPORT_SYNC_DIAGNOSTICS_SKELETON (object);
  g_assert (prop_id != 0 && prop_id - 1 < 5);
  g_mutex_lock (&skeleton->priv->lock);
  g_value_copy (&skeleton->priv->properties[prop_id - 1], value);
  g_mutex_unlock (&skeleton->priv->lock);
}

static gboolean
_shairport_sync_diagnostics_emit_changed (gpointer user_data)
{
  ShairportSyncDiagnosticsSkeleton *skeleton = SHAIRPORT_SYNC_DIAGNOSTICS_SKELETON (user_data);
  GList *l;
  GVariantBuilder builder;
  GVariantBuilder invalidated_builder;
  guint num_changes;

  g_mutex_lock (&skeleton->priv->lock);
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_84
  g_variant_builder_init_static (&builder, G_VARIANT_TYPE ("a{sv}"));
  g_variant_builder_init_static (&invalidated_builder, G_VARIANT_TYPE ("as"));
#else
  g_variant_builder_init (&builder, G_VARIANT_TYPE ("a{sv}"));
  g_variant_builder_init (&invalidated_builder, G_VARIANT_TYPE ("as"));
#endif
  for (l = skeleton->priv->changed_properties, num_changes = 0; l != NULL; l = l->next)
    {
      ChangedProperty *cp = l->data;
      GVariant *variant;
      const GValue *cur_value;

      cur_value = &skeleton->priv->properties[cp->prop_id - 1];
      if (!_g_value_equal (cur_value, &cp->orig_value))
        {
          variant = g_dbus_gvalue_to_gvariant (cur_value, G_VARIANT_TYPE (cp->info->parent_struct.signature));
          g_variant_builder_add (&builder, "{sv}", cp->info->parent_struct.name, variant);
          g_variant_unref (variant);
          num_changes++;
        }
    }
  if (num_changes > 0)
    {
      GList *connections, *ll;
      GVariant *signal_variant;
      signal_variant = g_variant_ref_sink (g_variant_new ("(sa{sv}as)", "org.gnome.ShairportSync.Diagnostics",
                                           &builder, &invalidated_builder));
      connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));
      for (ll = connections; ll != NULL; ll = ll->next)
        {
          GDBusConnection *connection = ll->data;

          g_dbus_connection_emit_signal (connection,
                                         NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)),
                                         "org.freedesktop.DBus.Properties",
                                         "PropertiesChanged",
                                         signal_variant,
                                         NULL);
        }
      g_variant_unref (signal_variant);
      g_list_free_full (connections, g_object_unref);
    }
  else
    {
      g_variant_builder_clear (&builder);
      g_variant_builder_clear (&invalidated_builder);
    }
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  skeleton->priv->changed_properties = NULL;
  skeleton->priv->changed_properties_idle_source = NULL;
  g_mutex_unlock (&skeleton->priv->lock);
  return FALSE;
}

static void
_shairport_sync_diagnostics_schedule_emit_changed (ShairportSyncDiagnosticsSkeleton *skeleton, const _ExtendedGDBusPropertyInfo *info, guint prop_id, const GValue *orig_value)
{
  ChangedProperty *cp;
  GList *l;
  cp = NULL;
  for (l = skeleton->priv->changed_properties; l != NULL; l = l->next)
    {
      ChangedProperty *i_cp = l->data;
      if (i_cp->info == info)
        {
          cp = i_cp;
          break;
        }
    }
  if (cp == NULL)
    {
      cp = g_new0 (ChangedProperty, 1);
      cp->prop_id = prop_id;
      cp->info = info;
      skeleton->priv->changed_properties = g_list_prepend (skeleton->priv->changed_properties, cp);
      g_value_init (&cp->orig_value, G_VALUE_TYPE (orig_value));
      g_value_copy (orig_value, &cp->orig_value);
    }
}

static void
shairport_sync_diagnostics_skeleton_notify (GObject      *object,
  GParamSpec *pspec G_GNUC_UNUSED)
{
  ShairportSyncDiagnosticsSkeleton *skeleton = SHAIRPORT_SYNC_DIAGNOSTICS_SKELETON (object);
  g_mutex_lock (&skeleton->priv->lock);
  if (skeleton->priv->changed_properties != NULL &&
      skeleton->priv->changed_properties_idle_source == NULL)
    {
      skeleton->priv->changed_properties_idle_source = g_idle_source_new ();
      g_source_set_priority (skeleton->priv->changed_properties_idle_source, G_PRIORITY_DEFAULT);
      g_source_set_callback (skeleton->priv->changed_properties_idle_source, _shairport_sync_diagnostics_emit_changed, g_object_ref (skeleton), (GDestroyNotify) g_object_unref);
      g_source_set_name (skeleton->priv->changed_properties_idle_source, "[generated] _shairport_sync_diagnostics_emit_changed");
      g_source_attach (skeleton->priv->changed_properties_idle_source, skeleton->priv->context);
      g_source_unref (skeleton->priv->changed_properties_idle_source);
    }
  g_mutex_unlock (&skeleton->priv->lock);
}

static void
shairport_sync_diagnostics_skeleton_set_property (GObject      *object,
  guint         prop_id,
  const GValue *value,
  GParamSpec   *pspec)
{
  const _ExtendedGDBusPropertyInfo *info;
  ShairportSyncDiagnosticsSkeleton *skeleton = SHAIRPORT_SYNC_DIAGNOSTICS_SKELETON (object);
  g_assert (prop_id != 0 && prop_id - 1 < 5);
  info = (const _ExtendedGDBusPropertyInfo *) _shairport_sync_diagnostics_property_info_pointers[prop_id - 1];
  g_mutex_lock (&skeleton->priv->lock);
  g_object_freeze_notify (object);
  if (!_g_value_equal (value, &skeleton->priv->properties[prop_id - 1]))
    {
      if (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)) != NULL &&
          info->emits_changed_signal)
        _shairport_sync_diagnostics_schedule_emit_changed (skeleton, info, prop_id, &skeleton->priv->properties[prop_id - 1]);
      g_value_copy (value, &skeleton->priv->properties[prop_id - 1]);
      g_object_notify_by_pspec (object, pspec);
    }
  g_mutex_unlock (&skeleton->priv->lock);
  g_object_thaw_notify (object);
}

static void
shairport_sync_diagnostics_skeleton_init (ShairportSyncDiagnosticsSkeleton *skeleton)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  skeleton->priv = shairport_sync_diagnostics_skeleton_get_instance_private (skeleton);
#else
  skeleton->priv = G_TYPE_INSTANCE_GET_PRIVATE (skeleton, TYPE_SHAIRPORT_SYNC_DIAGNOSTICS_SKELETON, ShairportSyncDiagnosticsSkeletonPrivate);
#endif

  g_mutex_init (&skeleton->priv->lock);
  skeleton->priv->context = g_main_context_ref_thread_default ();
  skeleton->priv->properties = g_new0 (GValue, 5);
  g_value_init (&skeleton->priv->properties[0], G_TYPE_INT);
  g_value_init (&skeleton->priv->properties[1], G_TYPE_BOOLEAN);
  g_value_init (&skeleton->priv->properties[2], G_TYPE_BOOLEAN);
  g_value_init (&skeleton->priv->properties[3], G_TYPE_BOOLEAN);
  g_value_init (&skeleton->priv->properties[4], G_TYPE_BOOLEAN);
}

static gint 
shairport_sync_diagnostics_skeleton_get_verbosity (ShairportSyncDiagnostics *object)
{
  ShairportSyncDiagnosticsSkeleton *skeleton = SHAIRPORT_SYNC_DIAGNOSTICS_SKELETON (object);
  gint value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_marshal_value_peek_int (&(skeleton->priv->properties[0]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static gboolean 
shairport_sync_diagnostics_skeleton_get_statistics (ShairportSyncDiagnostics *object)
{
  ShairportSyncDiagnosticsSkeleton *skeleton = SHAIRPORT_SYNC_DIAGNOSTICS_SKELETON (object);
  gboolean value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_marshal_value_peek_boolean (&(skeleton->priv->properties[1]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static gboolean 
shairport_sync_diagnostics_skeleton_get_elapsed_time (ShairportSyncDiagnostics *object)
{
  ShairportSyncDiagnosticsSkeleton *skeleton = SHAIRPORT_SYNC_DIAGNOSTICS_SKELETON (object);
  gboolean value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_marshal_value_peek_boolean (&(skeleton->priv->properties[2]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static gboolean 
shairport_sync_diagnostics_skeleton_get_delta_time (ShairportSyncDiagnostics *object)
{
  ShairportSyncDiagnosticsSkeleton *skeleton = SHAIRPORT_SYNC_DIAGNOSTICS_SKELETON (object);
  gboolean value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_marshal_value_peek_boolean (&(skeleton->priv->properties[3]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static gboolean 
shairport_sync_diagnostics_skeleton_get_file_and_line (ShairportSyncDiagnostics *object)
{
  ShairportSyncDiagnosticsSkeleton *skeleton = SHAIRPORT_SYNC_DIAGNOSTICS_SKELETON (object);
  gboolean value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_marshal_value_peek_boolean (&(skeleton->priv->properties[4]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static void
shairport_sync_diagnostics_skeleton_class_init (ShairportSyncDiagnosticsSkeletonClass *klass)
{
  GObjectClass *gobject_class;
  GDBusInterfaceSkeletonClass *skeleton_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize = shairport_sync_diagnostics_skeleton_finalize;
  gobject_class->get_property = shairport_sync_diagnostics_skeleton_get_property;
  gobject_class->set_property = shairport_sync_diagnostics_skeleton_set_property;
  gobject_class->notify       = shairport_sync_diagnostics_skeleton_notify;


  shairport_sync_diagnostics_override_properties (gobject_class, 1);

  skeleton_class = G_DBUS_INTERFACE_SKELETON_CLASS (klass);
  skeleton_class->get_info = shairport_sync_diagnostics_skeleton_dbus_interface_get_info;
  skeleton_class->get_properties = shairport_sync_diagnostics_skeleton_dbus_interface_get_properties;
  skeleton_class->flush = shairport_sync_diagnostics_skeleton_dbus_interface_flush;
  skeleton_class->get_vtable = shairport_sync_diagnostics_skeleton_dbus_interface_get_vtable;

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (ShairportSyncDiagnosticsSkeletonPrivate));
#endif
}

static void
shairport_sync_diagnostics_skeleton_iface_init (ShairportSyncDiagnosticsIface *iface)
{
  iface->get_verbosity = shairport_sync_diagnostics_skeleton_get_verbosity;
  iface->get_statistics = shairport_sync_diagnostics_skeleton_get_statistics;
  iface->get_elapsed_time = shairport_sync_diagnostics_skeleton_get_elapsed_time;
  iface->get_delta_time = shairport_sync_diagnostics_skeleton_get_delta_time;
  iface->get_file_and_line = shairport_sync_diagnostics_skeleton_get_file_and_line;
}

/**
 * shairport_sync_diagnostics_skeleton_new:
 *
 * Creates a skeleton object for the D-Bus interface <link linkend="gdbus-interface-org-gnome-ShairportSync-Diagnostics.top_of_page">org.gnome.ShairportSync.Diagnostics</link>.
 *
 * Returns: (transfer full) (type ShairportSyncDiagnosticsSkeleton): The skeleton object.
 */
ShairportSyncDiagnostics *
shairport_sync_diagnostics_skeleton_new (void)
{
  return SHAIRPORT_SYNC_DIAGNOSTICS (g_object_new (TYPE_SHAIRPORT_SYNC_DIAGNOSTICS_SKELETON, NULL));
}

/* ------------------------------------------------------------------------
 * Code for interface org.gnome.ShairportSync.RemoteControl
 * ------------------------------------------------------------------------
 */

/**
 * SECTION:ShairportSyncRemoteControl
 * @title: ShairportSyncRemoteControl
 * @short_description: Generated C code for the org.gnome.ShairportSync.RemoteControl D-Bus interface
 *
 * This section contains code for working with the <link linkend="gdbus-interface-org-gnome-ShairportSync-RemoteControl.top_of_page">org.gnome.ShairportSync.RemoteControl</link> D-Bus interface in C.
 */

/* ---- Introspection data for org.gnome.ShairportSync.RemoteControl ---- */

static const _ExtendedGDBusMethodInfo _shairport_sync_remote_control_method_info_fast_forward =
{
  {
    -1,
    (gchar *) "FastForward",
    NULL,
    NULL,
    NULL
  },
  "handle-fast-forward",
  FALSE
};

static const _ExtendedGDBusMethodInfo _shairport_sync_remote_control_method_info_rewind =
{
  {
    -1,
    (gchar *) "Rewind",
    NULL,
    NULL,
    NULL
  },
  "handle-rewind",
  FALSE
};

static const _ExtendedGDBusMethodInfo _shairport_sync_remote_control_method_info_toggle_mute =
{
  {
    -1,
    (gchar *) "ToggleMute",
    NULL,
    NULL,
    NULL
  },
  "handle-toggle-mute",
  FALSE
};

static const _ExtendedGDBusMethodInfo _shairport_sync_remote_control_method_info_next =
{
  {
    -1,
    (gchar *) "Next",
    NULL,
    NULL,
    NULL
  },
  "handle-next",
  FALSE
};

static const _ExtendedGDBusMethodInfo _shairport_sync_remote_control_method_info_previous =
{
  {
    -1,
    (gchar *) "Previous",
    NULL,
    NULL,
    NULL
  },
  "handle-previous",
  FALSE
};

static const _ExtendedGDBusMethodInfo _shairport_sync_remote_control_method_info_pause =
{
  {
    -1,
    (gchar *) "Pause",
    NULL,
    NULL,
    NULL
  },
  "handle-pause",
  FALSE
};

static const _ExtendedGDBusMethodInfo _shairport_sync_remote_control_method_info_play_pause =
{
  {
    -1,
    (gchar *) "PlayPause",
    NULL,
    NULL,
    NULL
  },
  "handle-play-pause",
  FALSE
};

static const _ExtendedGDBusMethodInfo _shairport_sync_remote_control_method_info_play =
{
  {
    -1,
    (gchar *) "Play",
    NULL,
    NULL,
    NULL
  },
  "handle-play",
  FALSE
};

static const _ExtendedGDBusMethodInfo _shairport_sync_remote_control_method_info_stop =
{
  {
    -1,
    (gchar *) "Stop",
    NULL,
    NULL,
    NULL
  },
  "handle-stop",
  FALSE
};

static const _ExtendedGDBusMethodInfo _shairport_sync_remote_control_method_info_resume =
{
  {
    -1,
    (gchar *) "Resume",
    NULL,
    NULL,
    NULL
  },
  "handle-resume",
  FALSE
};

static const _ExtendedGDBusMethodInfo _shairport_sync_remote_control_method_info_shuffle_songs =
{
  {
    -1,
    (gchar *) "ShuffleSongs",
    NULL,
    NULL,
    NULL
  },
  "handle-shuffle-songs",
  FALSE
};

static const _ExtendedGDBusMethodInfo _shairport_sync_remote_control_method_info_volume_up =
{
  {
    -1,
    (gchar *) "VolumeUp",
    NULL,
    NULL,
    NULL
  },
  "handle-volume-up",
  FALSE
};

static const _ExtendedGDBusMethodInfo _shairport_sync_remote_control_method_info_volume_down =
{
  {
    -1,
    (gchar *) "VolumeDown",
    NULL,
    NULL,
    NULL
  },
  "handle-volume-down",
  FALSE
};

static const _ExtendedGDBusArgInfo _shairport_sync_remote_control_method_info_set_airplay_volume_IN_ARG_volume =
{
  {
    -1,
    (gchar *) "volume",
    (gchar *) "d",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _shairport_sync_remote_control_method_info_set_airplay_volume_IN_ARG_pointers[] =
{
  &_shairport_sync_remote_control_method_info_set_airplay_volume_IN_ARG_volume.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _shairport_sync_remote_control_method_info_set_airplay_volume =
{
  {
    -1,
    (gchar *) "SetAirplayVolume",
    (GDBusArgInfo **) &_shairport_sync_remote_control_method_info_set_airplay_volume_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-set-airplay-volume",
  FALSE
};

static const GDBusMethodInfo * const _shairport_sync_remote_control_method_info_pointers[] =
{
  &_shairport_sync_remote_control_method_info_fast_forward.parent_struct,
  &_shairport_sync_remote_control_method_info_rewind.parent_struct,
  &_shairport_sync_remote_control_method_info_toggle_mute.parent_struct,
  &_shairport_sync_remote_control_method_info_next.parent_struct,
  &_shairport_sync_remote_control_method_info_previous.parent_struct,
  &_shairport_sync_remote_control_method_info_pause.parent_struct,
  &_shairport_sync_remote_control_method_info_play_pause.parent_struct,
  &_shairport_sync_remote_control_method_info_play.parent_struct,
  &_shairport_sync_remote_control_method_info_stop.parent_struct,
  &_shairport_sync_remote_control_method_info_resume.parent_struct,
  &_shairport_sync_remote_control_method_info_shuffle_songs.parent_struct,
  &_shairport_sync_remote_control_method_info_volume_up.parent_struct,
  &_shairport_sync_remote_control_method_info_volume_down.parent_struct,
  &_shairport_sync_remote_control_method_info_set_airplay_volume.parent_struct,
  NULL
};

static const _ExtendedGDBusPropertyInfo _shairport_sync_remote_control_property_info_player_state =
{
  {
    -1,
    (gchar *) "PlayerState",
    (gchar *) "s",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "player-state",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _shairport_sync_remote_control_property_info_progress_string =
{
  {
    -1,
    (gchar *) "ProgressString",
    (gchar *) "s",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "progress-string",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _shairport_sync_remote_control_property_info_client =
{
  {
    -1,
    (gchar *) "Client",
    (gchar *) "s",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "client",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _shairport_sync_remote_control_property_info_client_name =
{
  {
    -1,
    (gchar *) "ClientName",
    (gchar *) "s",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "client-name",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _shairport_sync_remote_control_property_info_stream_type =
{
  {
    -1,
    (gchar *) "StreamType",
    (gchar *) "s",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "stream-type",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _shairport_sync_remote_control_property_info_airplay_volume =
{
  {
    -1,
    (gchar *) "AirplayVolume",
    (gchar *) "d",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "airplay-volume",
  FALSE,
  TRUE
};

static const GDBusAnnotationInfo _shairport_sync_remote_control_property_metadata_annotation_info_0 =
{
  -1,
  (gchar *) "org.qtproject.QtDBus.QtTypeName",
  (gchar *) "QVariantMap",
  NULL
};

static const GDBusAnnotationInfo * const _shairport_sync_remote_control_property_metadata_annotation_info_pointers[] =
{
  &_shairport_sync_remote_control_property_metadata_annotation_info_0,
  NULL
};

static const _ExtendedGDBusPropertyInfo _shairport_sync_remote_control_property_info_metadata =
{
  {
    -1,
    (gchar *) "Metadata",
    (gchar *) "a{sv}",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    (GDBusAnnotationInfo **) &_shairport_sync_remote_control_property_metadata_annotation_info_pointers
  },
  "metadata",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _shairport_sync_remote_control_property_info_available =
{
  {
    -1,
    (gchar *) "Available",
    (gchar *) "b",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "available",
  FALSE,
  TRUE
};

static const GDBusPropertyInfo * const _shairport_sync_remote_control_property_info_pointers[] =
{
  &_shairport_sync_remote_control_property_info_player_state.parent_struct,
  &_shairport_sync_remote_control_property_info_progress_string.parent_struct,
  &_shairport_sync_remote_control_property_info_client.parent_struct,
  &_shairport_sync_remote_control_property_info_client_name.parent_struct,
  &_shairport_sync_remote_control_property_info_stream_type.parent_struct,
  &_shairport_sync_remote_control_property_info_airplay_volume.parent_struct,
  &_shairport_sync_remote_control_property_info_metadata.parent_struct,
  &_shairport_sync_remote_control_property_info_available.parent_struct,
  NULL
};

static const _ExtendedGDBusInterfaceInfo _shairport_sync_remote_control_interface_info =
{
  {
    -1,
    (gchar *) "org.gnome.ShairportSync.RemoteControl",
    (GDBusMethodInfo **) &_shairport_sync_remote_control_method_info_pointers,
    NULL,
    (GDBusPropertyInfo **) &_shairport_sync_remote_control_property_info_pointers,
    NULL
  },
  "shairport-sync-remote-control",
};


/**
 * shairport_sync_remote_control_interface_info:
 *
 * Gets a machine-readable description of the <link linkend="gdbus-interface-org-gnome-ShairportSync-RemoteControl.top_of_page">org.gnome.ShairportSync.RemoteControl</link> D-Bus interface.
 *
 * Returns: (transfer none): A #GDBusInterfaceInfo. Do not free.
 */
GDBusInterfaceInfo *
shairport_sync_remote_control_interface_info (void)
{
  return (GDBusInterfaceInfo *) &_shairport_sync_remote_control_interface_info.parent_struct;
}

/**
 * shairport_sync_remote_control_override_properties:
 * @klass: The class structure for a #GObject derived class.
 * @property_id_begin: The property id to assign to the first overridden property.
 *
 * Overrides all #GObject properties in the #ShairportSyncRemoteControl interface for a concrete class.
 * The properties are overridden in the order they are defined.
 *
 * Returns: The last property id.
 */
guint
shairport_sync_remote_control_override_properties (GObjectClass *klass, guint property_id_begin)
{
  g_object_class_override_property (klass, property_id_begin++, "player-state");
  g_object_class_override_property (klass, property_id_begin++, "progress-string");
  g_object_class_override_property (klass, property_id_begin++, "client");
  g_object_class_override_property (klass, property_id_begin++, "client-name");
  g_object_class_override_property (klass, property_id_begin++, "stream-type");
  g_object_class_override_property (klass, property_id_begin++, "airplay-volume");
  g_object_class_override_property (klass, property_id_begin++, "metadata");
  g_object_class_override_property (klass, property_id_begin++, "available");
  return property_id_begin - 1;
}


inline static void
shairport_sync_remote_control_method_marshal_fast_forward (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
shairport_sync_remote_control_method_marshal_rewind (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
shairport_sync_remote_control_method_marshal_toggle_mute (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
shairport_sync_remote_control_method_marshal_next (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
shairport_sync_remote_control_method_marshal_previous (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
shairport_sync_remote_control_method_marshal_pause (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
shairport_sync_remote_control_method_marshal_play_pause (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
shairport_sync_remote_control_method_marshal_play (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
shairport_sync_remote_control_method_marshal_stop (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
shairport_sync_remote_control_method_marshal_resume (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
shairport_sync_remote_control_method_marshal_shuffle_songs (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
shairport_sync_remote_control_method_marshal_volume_up (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
shairport_sync_remote_control_method_marshal_volume_down (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
shairport_sync_remote_control_method_marshal_set_airplay_volume (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT_DOUBLE (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}


/**
 * ShairportSyncRemoteControl:
 *
 * Abstract interface type for the D-Bus interface <link linkend="gdbus-interface-org-gnome-ShairportSync-RemoteControl.top_of_page">org.gnome.ShairportSync.RemoteControl</link>.
 */

/**
 * ShairportSyncRemoteControlIface:
 * @parent_iface: The parent interface.
 * @handle_fast_forward: Handler for the #ShairportSyncRemoteControl::handle-fast-forward signal.
 * @handle_next: Handler for the #ShairportSyncRemoteControl::handle-next signal.
 * @handle_pause: Handler for the #ShairportSyncRemoteControl::handle-pause signal.
 * @handle_play: Handler for the #ShairportSyncRemoteControl::handle-play signal.
 * @handle_play_pause: Handler for the #ShairportSyncRemoteControl::handle-play-pause signal.
 * @handle_previous: Handler for the #ShairportSyncRemoteControl::handle-previous signal.
 * @handle_resume: Handler for the #ShairportSyncRemoteControl::handle-resume signal.
 * @handle_rewind: Handler for the #ShairportSyncRemoteControl::handle-rewind signal.
 * @handle_set_airplay_volume: Handler for the #ShairportSyncRemoteControl::handle-set-airplay-volume signal.
 * @handle_shuffle_songs: Handler for the #ShairportSyncRemoteControl::handle-shuffle-songs signal.
 * @handle_stop: Handler for the #ShairportSyncRemoteControl::handle-stop signal.
 * @handle_toggle_mute: Handler for the #ShairportSyncRemoteControl::handle-toggle-mute signal.
 * @handle_volume_down: Handler for the #ShairportSyncRemoteControl::handle-volume-down signal.
 * @handle_volume_up: Handler for the #ShairportSyncRemoteControl::handle-volume-up signal.
 * @get_airplay_volume: Getter for the #ShairportSyncRemoteControl:airplay-volume property.
 * @get_available: Getter for the #ShairportSyncRemoteControl:available property.
 * @get_client: Getter for the #ShairportSyncRemoteControl:client property.
 * @get_client_name: Getter for the #ShairportSyncRemoteControl:client-name property.
 * @get_metadata: Getter for the #ShairportSyncRemoteControl:metadata property.
 * @get_player_state: Getter for the #ShairportSyncRemoteControl:player-state property.
 * @get_progress_string: Getter for the #ShairportSyncRemoteControl:progress-string property.
 * @get_stream_type: Getter for the #ShairportSyncRemoteControl:stream-type property.
 *
 * Virtual table for the D-Bus interface <link linkend="gdbus-interface-org-gnome-ShairportSync-RemoteControl.top_of_page">org.gnome.ShairportSync.RemoteControl</link>.
 */

typedef ShairportSyncRemoteControlIface ShairportSyncRemoteControlInterface;
G_DEFINE_INTERFACE (ShairportSyncRemoteControl, shairport_sync_remote_control, G_TYPE_OBJECT)

static void
shairport_sync_remote_control_default_init (ShairportSyncRemoteControlIface *iface)
{
  /* GObject signals for incoming D-Bus method calls: */
  /**
   * ShairportSyncRemoteControl::handle-fast-forward:
   * @object: A #ShairportSyncRemoteControl.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-gnome-ShairportSync-RemoteControl.FastForward">FastForward()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call shairport_sync_remote_control_complete_fast_forward() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-fast-forward",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (ShairportSyncRemoteControlIface, handle_fast_forward),
    g_signal_accumulator_true_handled,
    NULL,
      shairport_sync_remote_control_method_marshal_fast_forward,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

  /**
   * ShairportSyncRemoteControl::handle-rewind:
   * @object: A #ShairportSyncRemoteControl.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-gnome-ShairportSync-RemoteControl.Rewind">Rewind()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call shairport_sync_remote_control_complete_rewind() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-rewind",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (ShairportSyncRemoteControlIface, handle_rewind),
    g_signal_accumulator_true_handled,
    NULL,
      shairport_sync_remote_control_method_marshal_rewind,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

  /**
   * ShairportSyncRemoteControl::handle-toggle-mute:
   * @object: A #ShairportSyncRemoteControl.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-gnome-ShairportSync-RemoteControl.ToggleMute">ToggleMute()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call shairport_sync_remote_control_complete_toggle_mute() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-toggle-mute",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (ShairportSyncRemoteControlIface, handle_toggle_mute),
    g_signal_accumulator_true_handled,
    NULL,
      shairport_sync_remote_control_method_marshal_toggle_mute,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

  /**
   * ShairportSyncRemoteControl::handle-next:
   * @object: A #ShairportSyncRemoteControl.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-gnome-ShairportSync-RemoteControl.Next">Next()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call shairport_sync_remote_control_complete_next() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-next",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (ShairportSyncRemoteControlIface, handle_next),
    g_signal_accumulator_true_handled,
    NULL,
      shairport_sync_remote_control_method_marshal_next,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

  /**
   * ShairportSyncRemoteControl::handle-previous:
   * @object: A #ShairportSyncRemoteControl.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-gnome-ShairportSync-RemoteControl.Previous">Previous()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call shairport_sync_remote_control_complete_previous() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-previous",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (ShairportSyncRemoteControlIface, handle_previous),
    g_signal_accumulator_true_handled,
    NULL,
      shairport_sync_remote_control_method_marshal_previous,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

  /**
   * ShairportSyncRemoteControl::handle-pause:
   * @object: A #ShairportSyncRemoteControl.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-gnome-ShairportSync-RemoteControl.Pause">Pause()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call shairport_sync_remote_control_complete_pause() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-pause",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (ShairportSyncRemoteControlIface, handle_pause),
    g_signal_accumulator_true_handled,
    NULL,
      shairport_sync_remote_control_method_marshal_pause,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

  /**
   * ShairportSyncRemoteControl::handle-play-pause:
   * @object: A #ShairportSyncRemoteControl.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-gnome-ShairportSync-RemoteControl.PlayPause">PlayPause()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call shairport_sync_remote_control_complete_play_pause() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-play-pause",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (ShairportSyncRemoteControlIface, handle_play_pause),
    g_signal_accumulator_true_handled,
    NULL,
      shairport_sync_remote_control_method_marshal_play_pause,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

  /**
   * ShairportSyncRemoteControl::handle-play:
   * @object: A #ShairportSyncRemoteControl.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-gnome-ShairportSync-RemoteControl.Play">Play()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call shairport_sync_remote_control_complete_play() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-play",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (ShairportSyncRemoteControlIface, handle_play),
    g_signal_accumulator_true_handled,
    NULL,
      shairport_sync_remote_control_method_marshal_play,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

  /**
   * ShairportSyncRemoteControl::handle-stop:
   * @object: A #ShairportSyncRemoteControl.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-gnome-ShairportSync-RemoteControl.Stop">Stop()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call shairport_sync_remote_control_complete_stop() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-stop",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (ShairportSyncRemoteControlIface, handle_stop),
    g_signal_accumulator_true_handled,
    NULL,
      shairport_sync_remote_control_method_marshal_stop,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

  /**
   * ShairportSyncRemoteControl::handle-resume:
   * @object: A #ShairportSyncRemoteControl.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-gnome-ShairportSync-RemoteControl.Resume">Resume()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call shairport_sync_remote_control_complete_resume() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-resume",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (ShairportSyncRemoteControlIface, handle_resume),
    g_signal_accumulator_true_handled,
    NULL,
      shairport_sync_remote_control_method_marshal_resume,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

  /**
   * ShairportSyncRemoteControl::handle-shuffle-songs:
   * @object: A #ShairportSyncRemoteControl.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-gnome-ShairportSync-RemoteControl.ShuffleSongs">ShuffleSongs()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call shairport_sync_remote_control_complete_shuffle_songs() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-shuffle-songs",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (ShairportSyncRemoteControlIface, handle_shuffle_songs),
    g_signal_accumulator_true_handled,
    NULL,
      shairport_sync_remote_control_method_marshal_shuffle_songs,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

  /**
   * ShairportSyncRemoteControl::handle-volume-up:
   * @object: A #ShairportSyncRemoteControl.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-gnome-ShairportSync-RemoteControl.VolumeUp">VolumeUp()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call shairport_sync_remote_control_complete_volume_up() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-volume-up",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (ShairportSyncRemoteControlIface, handle_volume_up),
    g_signal_accumulator_true_handled,
    NULL,
      shairport_sync_remote_control_method_marshal_volume_up,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

  /**
   * ShairportSyncRemoteControl::handle-volume-down:
   * @object: A #ShairportSyncRemoteControl.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-gnome-ShairportSync-RemoteControl.VolumeDown">VolumeDown()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call shairport_sync_remote_control_complete_volume_down() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-volume-down",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (ShairportSyncRemoteControlIface, handle_volume_down),
    g_signal_accumulator_true_handled,
    NULL,
      shairport_sync_remote_control_method_marshal_volume_down,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

  /**
   * ShairportSyncRemoteControl::handle-set-airplay-volume:
   * @object: A #ShairportSyncRemoteControl.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_volume: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-gnome-ShairportSync-RemoteControl.SetAirplayVolume">SetAirplayVolume()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call shairport_sync_remote_control_complete_set_airplay_volume() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-set-airplay-volume",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (ShairportSyncRemoteControlIface, handle_set_airplay_volume),
    g_signal_accumulator_true_handled,
    NULL,
      shairport_sync_remote_control_method_marshal_set_airplay_volume,
    G_TYPE_BOOLEAN,
    2,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_DOUBLE);

  /* GObject properties for D-Bus properties: */
  /**
   * ShairportSyncRemoteControl:player-state:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-gnome-ShairportSync-RemoteControl.PlayerState">"PlayerState"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_string ("player-state", "PlayerState", "PlayerState", NULL, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * ShairportSyncRemoteControl:progress-string:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-gnome-ShairportSync-RemoteControl.ProgressString">"ProgressString"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_string ("progress-string", "ProgressString", "ProgressString", NULL, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * ShairportSyncRemoteControl:client:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-gnome-ShairportSync-RemoteControl.Client">"Client"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_string ("client", "Client", "Client", NULL, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * ShairportSyncRemoteControl:client-name:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-gnome-ShairportSync-RemoteControl.ClientName">"ClientName"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_string ("client-name", "ClientName", "ClientName", NULL, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * ShairportSyncRemoteControl:stream-type:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-gnome-ShairportSync-RemoteControl.StreamType">"StreamType"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_string ("stream-type", "StreamType", "StreamType", NULL, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * ShairportSyncRemoteControl:airplay-volume:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-gnome-ShairportSync-RemoteControl.AirplayVolume">"AirplayVolume"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_double ("airplay-volume", "AirplayVolume", "AirplayVolume", -G_MAXDOUBLE, G_MAXDOUBLE, 0.0, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * ShairportSyncRemoteControl:metadata:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-gnome-ShairportSync-RemoteControl.Metadata">"Metadata"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_variant ("metadata", "Metadata", "Metadata", G_VARIANT_TYPE ("a{sv}"), NULL, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * ShairportSyncRemoteControl:available:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-gnome-ShairportSync-RemoteControl.Available">"Available"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_boolean ("available", "Available", "Available", FALSE, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
}

/**
 * shairport_sync_remote_control_get_player_state: (skip)
 * @object: A #ShairportSyncRemoteControl.
 *
 * Gets the value of the <link linkend="gdbus-property-org-gnome-ShairportSync-RemoteControl.PlayerState">"PlayerState"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use shairport_sync_remote_control_dup_player_state() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
const gchar *
shairport_sync_remote_control_get_player_state (ShairportSyncRemoteControl *object)
{
  g_return_val_if_fail (IS_SHAIRPORT_SYNC_REMOTE_CONTROL (object), NULL);

  return SHAIRPORT_SYNC_REMOTE_CONTROL_GET_IFACE (object)->get_player_state (object);
}

/**
 * shairport_sync_remote_control_dup_player_state: (skip)
 * @object: A #ShairportSyncRemoteControl.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-gnome-ShairportSync-RemoteControl.PlayerState">"PlayerState"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_free().
 */
gchar *
shairport_sync_remote_control_dup_player_state (ShairportSyncRemoteControl *object)
{
  gchar *value;
  g_object_get (G_OBJECT (object), "player-state", &value, NULL);
  return value;
}

/**
 * shairport_sync_remote_control_set_player_state: (skip)
 * @object: A #ShairportSyncRemoteControl.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-gnome-ShairportSync-RemoteControl.PlayerState">"PlayerState"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
shairport_sync_remote_control_set_player_state (ShairportSyncRemoteControl *object, const gchar *value)
{
  g_object_set (G_OBJECT (object), "player-state", value, NULL);
}

/**
 * shairport_sync_remote_control_get_progress_string: (skip)
 * @object: A #ShairportSyncRemoteControl.
 *
 * Gets the value of the <link linkend="gdbus-property-org-gnome-ShairportSync-RemoteControl.ProgressString">"ProgressString"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use shairport_sync_remote_control_dup_progress_string() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
const gchar *
shairport_sync_remote_control_get_progress_string (ShairportSyncRemoteControl *object)
{
  g_return_val_if_fail (IS_SHAIRPORT_SYNC_REMOTE_CONTROL (object), NULL);

  return SHAIRPORT_SYNC_REMOTE_CONTROL_GET_IFACE (object)->get_progress_string (object);
}

/**
 * shairport_sync_remote_control_dup_progress_string: (skip)
 * @object: A #ShairportSyncRemoteControl.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-gnome-ShairportSync-RemoteControl.ProgressString">"ProgressString"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_free().
 */
gchar *
shairport_sync_remote_control_dup_progress_string (ShairportSyncRemoteControl *object)
{
  gchar *value;
  g_object_get (G_OBJECT (object), "progress-string", &value, NULL);
  return value;
}

/**
 * shairport_sync_remote_control_set_progress_string: (skip)
 * @object: A #ShairportSyncRemoteControl.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-gnome-ShairportSync-RemoteControl.ProgressString">"ProgressString"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
shairport_sync_remote_control_set_progress_string (ShairportSyncRemoteControl *object, const gchar *value)
{
  g_object_set (G_OBJECT (object), "progress-string", value, NULL);
}

/**
 * shairport_sync_remote_control_get_client: (skip)
 * @object: A #ShairportSyncRemoteControl.
 *
 * Gets the value of the <link linkend="gdbus-property-org-gnome-ShairportSync-RemoteControl.Client">"Client"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use shairport_sync_remote_control_dup_client() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
const gchar *
shairport_sync_remote_control_get_client (ShairportSyncRemoteControl *object)
{
  g_return_val_if_fail (IS_SHAIRPORT_SYNC_REMOTE_CONTROL (object), NULL);

  return SHAIRPORT_SYNC_REMOTE_CONTROL_GET_IFACE (object)->get_client (object);
}

/**
 * shairport_sync_remote_control_dup_client: (skip)
 * @object: A #ShairportSyncRemoteControl.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-gnome-ShairportSync-RemoteControl.Client">"Client"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_free().
 */
gchar *
shairport_sync_remote_control_dup_client (ShairportSyncRemoteControl *object)
{
  gchar *value;
  g_object_get (G_OBJECT (object), "client", &value, NULL);
  return value;
}

/**
 * shairport_sync_remote_control_set_client: (skip)
 * @object: A #ShairportSyncRemoteControl.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-gnome-ShairportSync-RemoteControl.Client">"Client"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
shairport_sync_remote_control_set_client (ShairportSyncRemoteControl *object, const gchar *value)
{
  g_object_set (G_OBJECT (object), "client", value, NULL);
}

/**
 * shairport_sync_remote_control_get_client_name: (skip)
 * @object: A #ShairportSyncRemoteControl.
 *
 * Gets the value of the <link linkend="gdbus-property-org-gnome-ShairportSync-RemoteControl.ClientName">"ClientName"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use shairport_sync_remote_control_dup_client_name() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
const gchar *
shairport_sync_remote_control_get_client_name (ShairportSyncRemoteControl *object)
{
  g_return_val_if_fail (IS_SHAIRPORT_SYNC_REMOTE_CONTROL (object), NULL);

  return SHAIRPORT_SYNC_REMOTE_CONTROL_GET_IFACE (object)->get_client_name (object);
}

/**
 * shairport_sync_remote_control_dup_client_name: (skip)
 * @object: A #ShairportSyncRemoteControl.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-gnome-ShairportSync-RemoteControl.ClientName">"ClientName"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_free().
 */
gchar *
shairport_sync_remote_control_dup_client_name (ShairportSyncRemoteControl *object)
{
  gchar *value;
  g_object_get (G_OBJECT (object), "client-name", &value, NULL);
  return value;
}

/**
 * shairport_sync_remote_control_set_client_name: (skip)
 * @object: A #ShairportSyncRemoteControl.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-gnome-ShairportSync-RemoteControl.ClientName">"ClientName"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
shairport_sync_remote_control_set_client_name (ShairportSyncRemoteControl *object, const gchar *value)
{
  g_object_set (G_OBJECT (object), "client-name", value, NULL);
}

/**
 * shairport_sync_remote_control_get_stream_type: (skip)
 * @object: A #ShairportSyncRemoteControl.
 *
 * Gets the value of the <link linkend="gdbus-property-org-gnome-ShairportSync-RemoteControl.StreamType">"StreamType"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use shairport_sync_remote_control_dup_stream_type() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
const gchar *
shairport_sync_remote_control_get_stream_type (ShairportSyncRemoteControl *object)
{
  g_return_val_if_fail (IS_SHAIRPORT_SYNC_REMOTE_CONTROL (object), NULL);

  return SHAIRPORT_SYNC_REMOTE_CONTROL_GET_IFACE (object)->get_stream_type (object);
}

/**
 * shairport_sync_remote_control_dup_stream_type: (skip)
 * @object: A #ShairportSyncRemoteControl.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-gnome-ShairportSync-RemoteControl.StreamType">"StreamType"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_free().
 */
gchar *
shairport_sync_remote_control_dup_stream_type (ShairportSyncRemoteControl *object)
{
  gchar *value;
  g_object_get (G_OBJECT (object), "stream-type", &value, NULL);
  return value;
}

/**
 * shairport_sync_remote_control_set_stream_type: (skip)
 * @object: A #ShairportSyncRemoteControl.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-gnome-ShairportSync-RemoteControl.StreamType">"StreamType"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
shairport_sync_remote_control_set_stream_type (ShairportSyncRemoteControl *object, const gchar *value)
{
  g_object_set (G_OBJECT (object), "stream-type", value, NULL);
}

/**
 * shairport_sync_remote_control_get_airplay_volume: (skip)
 * @object: A #ShairportSyncRemoteControl.
 *
 * Gets the value of the <link linkend="gdbus-property-org-gnome-ShairportSync-RemoteControl.AirplayVolume">"AirplayVolume"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
gdouble 
shairport_sync_remote_control_get_airplay_volume (ShairportSyncRemoteControl *object)
{
  g_return_val_if_fail (IS_SHAIRPORT_SYNC_REMOTE_CONTROL (object), 0.0);

  return SHAIRPORT_SYNC_REMOTE_CONTROL_GET_IFACE (object)->get_airplay_volume (object);
}

/**
 * shairport_sync_remote_control_set_airplay_volume: (skip)
 * @object: A #ShairportSyncRemoteControl.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-gnome-ShairportSync-RemoteControl.AirplayVolume">"AirplayVolume"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
shairport_sync_remote_control_set_airplay_volume (ShairportSyncRemoteControl *object, gdouble value)
{
  g_object_set (G_OBJECT (object), "airplay-volume", value, NULL);
}

/**
 * shairport_sync_remote_control_get_metadata: (skip)
 * @object: A #ShairportSyncRemoteControl.
 *
 * Gets the value of the <link linkend="gdbus-property-org-gnome-ShairportSync-RemoteControl.Metadata">"Metadata"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use shairport_sync_remote_control_dup_metadata() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
GVariant *
shairport_sync_remote_control_get_metadata (ShairportSyncRemoteControl *object)
{
  g_return_val_if_fail (IS_SHAIRPORT_SYNC_REMOTE_CONTROL (object), NULL);

  return SHAIRPORT_SYNC_REMOTE_CONTROL_GET_IFACE (object)->get_metadata (object);
}

/**
 * shairport_sync_remote_control_dup_metadata: (skip)
 * @object: A #ShairportSyncRemoteControl.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-gnome-ShairportSync-RemoteControl.Metadata">"Metadata"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_variant_unref().
 */
GVariant *
shairport_sync_remote_control_dup_metadata (ShairportSyncRemoteControl *object)
{
  GVariant *value;
  g_object_get (G_OBJECT (object), "metadata", &value, NULL);
  return value;
}

/**
 * shairport_sync_remote_control_set_metadata: (skip)
 * @object: A #ShairportSyncRemoteControl.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-gnome-ShairportSync-RemoteControl.Metadata">"Metadata"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
shairport_sync_remote_control_set_metadata (ShairportSyncRemoteControl *object, GVariant *value)
{
  g_object_set (G_OBJECT (object), "metadata", value, NULL);
}

/**
 * shairport_sync_remote_control_get_available: (skip)
 * @object: A #ShairportSyncRemoteControl.
 *
 * Gets the value of the <link linkend="gdbus-property-org-gnome-ShairportSync-RemoteControl.Available">"Available"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
gboolean 
shairport_sync_remote_control_get_available (ShairportSyncRemoteControl *object)
{
  g_return_val_if_fail (IS_SHAIRPORT_SYNC_REMOTE_CONTROL (object), FALSE);

  return SHAIRPORT_SYNC_REMOTE_CONTROL_GET_IFACE (object)->get_available (object);
}

/**
 * shairport_sync_remote_control_set_available: (skip)
 * @object: A #ShairportSyncRemoteControl.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-gnome-ShairportSync-RemoteControl.Available">"Available"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
shairport_sync_remote_control_set_available (ShairportSyncRemoteControl *object, gboolean value)
{
  g_object_set (G_OBJECT (object), "available", value, NULL);
}

/**
 * shairport_sync_remote_control_call_fast_forward:
 * @proxy: A #ShairportSyncRemoteControlProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-gnome-ShairportSync-RemoteControl.FastForward">FastForward()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call shairport_sync_remote_control_call_fast_forward_finish() to get the result of the operation.
 *
 * See shairport_sync_remote_control_call_fast_forward_sync() for the synchronous, blocking version of this method.
 */
void
shairport_sync_remote_control_call_fast_forward (
    ShairportSyncRemoteControl *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "FastForward",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * shairport_sync_remote_control_call_fast_forward_finish:
 * @proxy: A #ShairportSyncRemoteControlProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to shairport_sync_remote_control_call_fast_forward().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with shairport_sync_remote_control_call_fast_forward().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
shairport_sync_remote_control_call_fast_forward_finish (
    ShairportSyncRemoteControl *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * shairport_sync_remote_control_call_fast_forward_sync:
 * @proxy: A #ShairportSyncRemoteControlProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-gnome-ShairportSync-RemoteControl.FastForward">FastForward()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See shairport_sync_remote_control_call_fast_forward() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
shairport_sync_remote_control_call_fast_forward_sync (
    ShairportSyncRemoteControl *proxy,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "FastForward",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * shairport_sync_remote_control_call_rewind:
 * @proxy: A #ShairportSyncRemoteControlProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-gnome-ShairportSync-RemoteControl.Rewind">Rewind()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call shairport_sync_remote_control_call_rewind_finish() to get the result of the operation.
 *
 * See shairport_sync_remote_control_call_rewind_sync() for the synchronous, blocking version of this method.
 */
void
shairport_sync_remote_control_call_rewind (
    ShairportSyncRemoteControl *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "Rewind",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * shairport_sync_remote_control_call_rewind_finish:
 * @proxy: A #ShairportSyncRemoteControlProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to shairport_sync_remote_control_call_rewind().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with shairport_sync_remote_control_call_rewind().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
shairport_sync_remote_control_call_rewind_finish (
    ShairportSyncRemoteControl *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * shairport_sync_remote_control_call_rewind_sync:
 * @proxy: A #ShairportSyncRemoteControlProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-gnome-ShairportSync-RemoteControl.Rewind">Rewind()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See shairport_sync_remote_control_call_rewind() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
shairport_sync_remote_control_call_rewind_sync (
    ShairportSyncRemoteControl *proxy,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "Rewind",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * shairport_sync_remote_control_call_toggle_mute:
 * @proxy: A #ShairportSyncRemoteControlProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-gnome-ShairportSync-RemoteControl.ToggleMute">ToggleMute()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call shairport_sync_remote_control_call_toggle_mute_finish() to get the result of the operation.
 *
 * See shairport_sync_remote_control_call_toggle_mute_sync() for the synchronous, blocking version of this method.
 */
void
shairport_sync_remote_control_call_toggle_mute (
    ShairportSyncRemoteControl *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "ToggleMute",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * shairport_sync_remote_control_call_toggle_mute_finish:
 * @proxy: A #ShairportSyncRemoteControlProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to shairport_sync_remote_control_call_toggle_mute().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with shairport_sync_remote_control_call_toggle_mute().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
shairport_sync_remote_control_call_toggle_mute_finish (
    ShairportSyncRemoteControl *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * shairport_sync_remote_control_call_toggle_mute_sync:
 * @proxy: A #ShairportSyncRemoteControlProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-gnome-ShairportSync-RemoteControl.ToggleMute">ToggleMute()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See shairport_sync_remote_control_call_toggle_mute() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
shairport_sync_remote_control_call_toggle_mute_sync (
    ShairportSyncRemoteControl *proxy,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "ToggleMute",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * shairport_sync_remote_control_call_next:
 * @proxy: A #ShairportSyncRemoteControlProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-gnome-ShairportSync-RemoteControl.Next">Next()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call shairport_sync_remote_control_call_next_finish() to get the result of the operation.
 *
 * See shairport_sync_remote_control_call_next_sync() for the synchronous, blocking version of this method.
 */
void
shairport_sync_remote_control_call_next (
    ShairportSyncRemoteControl *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "Next",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * shairport_sync_remote_control_call_next_finish:
 * @proxy: A #ShairportSyncRemoteControlProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to shairport_sync_remote_control_call_next().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with shairport_sync_remote_control_call_next().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
shairport_sync_remote_control_call_next_finish (
    ShairportSyncRemoteControl *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * shairport_sync_remote_control_call_next_sync:
 * @proxy: A #ShairportSyncRemoteControlProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-gnome-ShairportSync-RemoteControl.Next">Next()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See shairport_sync_remote_control_call_next() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
shairport_sync_remote_control_call_next_sync (
    ShairportSyncRemoteControl *proxy,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "Next",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * shairport_sync_remote_control_call_previous:
 * @proxy: A #ShairportSyncRemoteControlProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-gnome-ShairportSync-RemoteControl.Previous">Previous()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call shairport_sync_remote_control_call_previous_finish() to get the result of the operation.
 *
 * See shairport_sync_remote_control_call_previous_sync() for the synchronous, blocking version of this method.
 */
void
shairport_sync_remote_control_call_previous (
    ShairportSyncRemoteControl *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "Previous",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * shairport_sync_remote_control_call_previous_finish:
 * @proxy: A #ShairportSyncRemoteControlProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to shairport_sync_remote_control_call_previous().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with shairport_sync_remote_control_call_previous().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
shairport_sync_remote_control_call_previous_finish (
    ShairportSyncRemoteControl *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * shairport_sync_remote_control_call_previous_sync:
 * @proxy: A #ShairportSyncRemoteControlProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-gnome-ShairportSync-RemoteControl.Previous">Previous()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See shairport_sync_remote_control_call_previous() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
shairport_sync_remote_control_call_previous_sync (
    ShairportSyncRemoteControl *proxy,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "Previous",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * shairport_sync_remote_control_call_pause:
 * @proxy: A #ShairportSyncRemoteControlProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-gnome-ShairportSync-RemoteControl.Pause">Pause()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call shairport_sync_remote_control_call_pause_finish() to get the result of the operation.
 *
 * See shairport_sync_remote_control_call_pause_sync() for the synchronous, blocking version of this method.
 */
void
shairport_sync_remote_control_call_pause (
    ShairportSyncRemoteControl *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "Pause",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * shairport_sync_remote_control_call_pause_finish:
 * @proxy: A #ShairportSyncRemoteControlProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to shairport_sync_remote_control_call_pause().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with shairport_sync_remote_control_call_pause().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
shairport_sync_remote_control_call_pause_finish (
    ShairportSyncRemoteControl *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * shairport_sync_remote_control_call_pause_sync:
 * @proxy: A #ShairportSyncRemoteControlProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-gnome-ShairportSync-RemoteControl.Pause">Pause()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See shairport_sync_remote_control_call_pause() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
shairport_sync_remote_control_call_pause_sync (
    ShairportSyncRemoteControl *proxy,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "Pause",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * shairport_sync_remote_control_call_play_pause:
 * @proxy: A #ShairportSyncRemoteControlProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-gnome-ShairportSync-RemoteControl.PlayPause">PlayPause()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call shairport_sync_remote_control_call_play_pause_finish() to get the result of the operation.
 *
 * See shairport_sync_remote_control_call_play_pause_sync() for the synchronous, blocking version of this method.
 */
void
shairport_sync_remote_control_call_play_pause (
    ShairportSyncRemoteControl *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "PlayPause",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * shairport_sync_remote_control_call_play_pause_finish:
 * @proxy: A #ShairportSyncRemoteControlProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to shairport_sync_remote_control_call_play_pause().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with shairport_sync_remote_control_call_play_pause().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
shairport_sync_remote_control_call_play_pause_finish (
    ShairportSyncRemoteControl *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * shairport_sync_remote_control_call_play_pause_sync:
 * @proxy: A #ShairportSyncRemoteControlProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-gnome-ShairportSync-RemoteControl.PlayPause">PlayPause()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See shairport_sync_remote_control_call_play_pause() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
shairport_sync_remote_control_call_play_pause_sync (
    ShairportSyncRemoteControl *proxy,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "PlayPause",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * shairport_sync_remote_control_call_play:
 * @proxy: A #ShairportSyncRemoteControlProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-gnome-ShairportSync-RemoteControl.Play">Play()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call shairport_sync_remote_control_call_play_finish() to get the result of the operation.
 *
 * See shairport_sync_remote_control_call_play_sync() for the synchronous, blocking version of this method.
 */
void
shairport_sync_remote_control_call_play (
    ShairportSyncRemoteControl *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "Play",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * shairport_sync_remote_control_call_play_finish:
 * @proxy: A #ShairportSyncRemoteControlProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to shairport_sync_remote_control_call_play().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with shairport_sync_remote_control_call_play().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
shairport_sync_remote_control_call_play_finish (
    ShairportSyncRemoteControl *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * shairport_sync_remote_control_call_play_sync:
 * @proxy: A #ShairportSyncRemoteControlProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-gnome-ShairportSync-RemoteControl.Play">Play()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See shairport_sync_remote_control_call_play() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
shairport_sync_remote_control_call_play_sync (
    ShairportSyncRemoteControl *proxy,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "Play",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * shairport_sync_remote_control_call_stop:
 * @proxy: A #ShairportSyncRemoteControlProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-gnome-ShairportSync-RemoteControl.Stop">Stop()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call shairport_sync_remote_control_call_stop_finish() to get the result of the operation.
 *
 * See shairport_sync_remote_control_call_stop_sync() for the synchronous, blocking version of this method.
 */
void
shairport_sync_remote_control_call_stop (
    ShairportSyncRemoteControl *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "Stop",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * shairport_sync_remote_control_call_stop_finish:
 * @proxy: A #ShairportSyncRemoteControlProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to shairport_sync_remote_control_call_stop().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with shairport_sync_remote_control_call_stop().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
shairport_sync_remote_control_call_stop_finish (
    ShairportSyncRemoteControl *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * shairport_sync_remote_control_call_stop_sync:
 * @proxy: A #ShairportSyncRemoteControlProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-gnome-ShairportSync-RemoteControl.Stop">Stop()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See shairport_sync_remote_control_call_stop() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
shairport_sync_remote_control_call_stop_sync (
    ShairportSyncRemoteControl *proxy,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "Stop",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * shairport_sync_remote_control_call_resume:
 * @proxy: A #ShairportSyncRemoteControlProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-gnome-ShairportSync-RemoteControl.Resume">Resume()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call shairport_sync_remote_control_call_resume_finish() to get the result of the operation.
 *
 * See shairport_sync_remote_control_call_resume_sync() for the synchronous, blocking version of this method.
 */
void
shairport_sync_remote_control_call_resume (
    ShairportSyncRemoteControl *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "Resume",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * shairport_sync_remote_control_call_resume_finish:
 * @proxy: A #ShairportSyncRemoteControlProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to shairport_sync_remote_control_call_resume().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with shairport_sync_remote_control_call_resume().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
shairport_sync_remote_control_call_resume_finish (
    ShairportSyncRemoteControl *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * shairport_sync_remote_control_call_resume_sync:
 * @proxy: A #ShairportSyncRemoteControlProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-gnome-ShairportSync-RemoteControl.Resume">Resume()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See shairport_sync_remote_control_call_resume() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
shairport_sync_remote_control_call_resume_sync (
    ShairportSyncRemoteControl *proxy,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "Resume",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * shairport_sync_remote_control_call_shuffle_songs:
 * @proxy: A #ShairportSyncRemoteControlProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-gnome-ShairportSync-RemoteControl.ShuffleSongs">ShuffleSongs()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call shairport_sync_remote_control_call_shuffle_songs_finish() to get the result of the operation.
 *
 * See shairport_sync_remote_control_call_shuffle_songs_sync() for the synchronous, blocking version of this method.
 */
void
shairport_sync_remote_control_call_shuffle_songs (
    ShairportSyncRemoteControl *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "ShuffleSongs",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * shairport_sync_remote_control_call_shuffle_songs_finish:
 * @proxy: A #ShairportSyncRemoteControlProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to shairport_sync_remote_control_call_shuffle_songs().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with shairport_sync_remote_control_call_shuffle_songs().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
shairport_sync_remote_control_call_shuffle_songs_finish (
    ShairportSyncRemoteControl *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * shairport_sync_remote_control_call_shuffle_songs_sync:
 * @proxy: A #ShairportSyncRemoteControlProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-gnome-ShairportSync-RemoteControl.ShuffleSongs">ShuffleSongs()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See shairport_sync_remote_control_call_shuffle_songs() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
shairport_sync_remote_control_call_shuffle_songs_sync (
    ShairportSyncRemoteControl *proxy,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "ShuffleSongs",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * shairport_sync_remote_control_call_volume_up:
 * @proxy: A #ShairportSyncRemoteControlProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-gnome-ShairportSync-RemoteControl.VolumeUp">VolumeUp()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call shairport_sync_remote_control_call_volume_up_finish() to get the result of the operation.
 *
 * See shairport_sync_remote_control_call_volume_up_sync() for the synchronous, blocking version of this method.
 */
void
shairport_sync_remote_control_call_volume_up (
    ShairportSyncRemoteControl *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "VolumeUp",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * shairport_sync_remote_control_call_volume_up_finish:
 * @proxy: A #ShairportSyncRemoteControlProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to shairport_sync_remote_control_call_volume_up().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with shairport_sync_remote_control_call_volume_up().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
shairport_sync_remote_control_call_volume_up_finish (
    ShairportSyncRemoteControl *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * shairport_sync_remote_control_call_volume_up_sync:
 * @proxy: A #ShairportSyncRemoteControlProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-gnome-ShairportSync-RemoteControl.VolumeUp">VolumeUp()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See shairport_sync_remote_control_call_volume_up() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
shairport_sync_remote_control_call_volume_up_sync (
    ShairportSyncRemoteControl *proxy,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "VolumeUp",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * shairport_sync_remote_control_call_volume_down:
 * @proxy: A #ShairportSyncRemoteControlProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-gnome-ShairportSync-RemoteControl.VolumeDown">VolumeDown()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call shairport_sync_remote_control_call_volume_down_finish() to get the result of the operation.
 *
 * See shairport_sync_remote_control_call_volume_down_sync() for the synchronous, blocking version of this method.
 */
void
shairport_sync_remote_control_call_volume_down (
    ShairportSyncRemoteControl *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "VolumeDown",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * shairport_sync_remote_control_call_volume_down_finish:
 * @proxy: A #ShairportSyncRemoteControlProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to shairport_sync_remote_control_call_volume_down().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with shairport_sync_remote_control_call_volume_down().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
shairport_sync_remote_control_call_volume_down_finish (
    ShairportSyncRemoteControl *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * shairport_sync_remote_control_call_volume_down_sync:
 * @proxy: A #ShairportSyncRemoteControlProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-gnome-ShairportSync-RemoteControl.VolumeDown">VolumeDown()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See shairport_sync_remote_control_call_volume_down() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
shairport_sync_remote_control_call_volume_down_sync (
    ShairportSyncRemoteControl *proxy,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "VolumeDown",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * shairport_sync_remote_control_call_set_airplay_volume:
 * @proxy: A #ShairportSyncRemoteControlProxy.
 * @arg_volume: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-gnome-ShairportSync-RemoteControl.SetAirplayVolume">SetAirplayVolume()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call shairport_sync_remote_control_call_set_airplay_volume_finish() to get the result of the operation.
 *
 * See shairport_sync_remote_control_call_set_airplay_volume_sync() for the synchronous, blocking version of this method.
 */
void
shairport_sync_remote_control_call_set_airplay_volume (
    ShairportSyncRemoteControl *proxy,
    gdouble arg_volume,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "SetAirplayVolume",
    g_variant_new ("(d)",
                   arg_volume),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * shairport_sync_remote_control_call_set_airplay_volume_finish:
 * @proxy: A #ShairportSyncRemoteControlProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to shairport_sync_remote_control_call_set_airplay_volume().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with shairport_sync_remote_control_call_set_airplay_volume().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
shairport_sync_remote_control_call_set_airplay_volume_finish (
    ShairportSyncRemoteControl *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * shairport_sync_remote_control_call_set_airplay_volume_sync:
 * @proxy: A #ShairportSyncRemoteControlProxy.
 * @arg_volume: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-gnome-ShairportSync-RemoteControl.SetAirplayVolume">SetAirplayVolume()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See shairport_sync_remote_control_call_set_airplay_volume() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
shairport_sync_remote_control_call_set_airplay_volume_sync (
    ShairportSyncRemoteControl *proxy,
    gdouble arg_volume,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "SetAirplayVolume",
    g_variant_new ("(d)",
                   arg_volume),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * shairport_sync_remote_control_complete_fast_forward:
 * @object: A #ShairportSyncRemoteControl.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-gnome-ShairportSync-RemoteControl.FastForward">FastForward()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
shairport_sync_remote_control_complete_fast_forward (
    ShairportSyncRemoteControl *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * shairport_sync_remote_control_complete_rewind:
 * @object: A #ShairportSyncRemoteControl.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-gnome-ShairportSync-RemoteControl.Rewind">Rewind()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
shairport_sync_remote_control_complete_rewind (
    ShairportSyncRemoteControl *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * shairport_sync_remote_control_complete_toggle_mute:
 * @object: A #ShairportSyncRemoteControl.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-gnome-ShairportSync-RemoteControl.ToggleMute">ToggleMute()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
shairport_sync_remote_control_complete_toggle_mute (
    ShairportSyncRemoteControl *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * shairport_sync_remote_control_complete_next:
 * @object: A #ShairportSyncRemoteControl.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-gnome-ShairportSync-RemoteControl.Next">Next()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
shairport_sync_remote_control_complete_next (
    ShairportSyncRemoteControl *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * shairport_sync_remote_control_complete_previous:
 * @object: A #ShairportSyncRemoteControl.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-gnome-ShairportSync-RemoteControl.Previous">Previous()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
shairport_sync_remote_control_complete_previous (
    ShairportSyncRemoteControl *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * shairport_sync_remote_control_complete_pause:
 * @object: A #ShairportSyncRemoteControl.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-gnome-ShairportSync-RemoteControl.Pause">Pause()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
shairport_sync_remote_control_complete_pause (
    ShairportSyncRemoteControl *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * shairport_sync_remote_control_complete_play_pause:
 * @object: A #ShairportSyncRemoteControl.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-gnome-ShairportSync-RemoteControl.PlayPause">PlayPause()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
shairport_sync_remote_control_complete_play_pause (
    ShairportSyncRemoteControl *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * shairport_sync_remote_control_complete_play:
 * @object: A #ShairportSyncRemoteControl.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-gnome-ShairportSync-RemoteControl.Play">Play()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
shairport_sync_remote_control_complete_play (
    ShairportSyncRemoteControl *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * shairport_sync_remote_control_complete_stop:
 * @object: A #ShairportSyncRemoteControl.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-gnome-ShairportSync-RemoteControl.Stop">Stop()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
shairport_sync_remote_control_complete_stop (
    ShairportSyncRemoteControl *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * shairport_sync_remote_control_complete_resume:
 * @object: A #ShairportSyncRemoteControl.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-gnome-ShairportSync-RemoteControl.Resume">Resume()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
shairport_sync_remote_control_complete_resume (
    ShairportSyncRemoteControl *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * shairport_sync_remote_control_complete_shuffle_songs:
 * @object: A #ShairportSyncRemoteControl.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-gnome-ShairportSync-RemoteControl.ShuffleSongs">ShuffleSongs()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
shairport_sync_remote_control_complete_shuffle_songs (
    ShairportSyncRemoteControl *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * shairport_sync_remote_control_complete_volume_up:
 * @object: A #ShairportSyncRemoteControl.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-gnome-ShairportSync-RemoteControl.VolumeUp">VolumeUp()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
shairport_sync_remote_control_complete_volume_up (
    ShairportSyncRemoteControl *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * shairport_sync_remote_control_complete_volume_down:
 * @object: A #ShairportSyncRemoteControl.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-gnome-ShairportSync-RemoteControl.VolumeDown">VolumeDown()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
shairport_sync_remote_control_complete_volume_down (
    ShairportSyncRemoteControl *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * shairport_sync_remote_control_complete_set_airplay_volume:
 * @object: A #ShairportSyncRemoteControl.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-gnome-ShairportSync-RemoteControl.SetAirplayVolume">SetAirplayVolume()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
shairport_sync_remote_control_complete_set_airplay_volume (
    ShairportSyncRemoteControl *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/* ------------------------------------------------------------------------ */

/**
 * ShairportSyncRemoteControlProxy:
 *
 * The #ShairportSyncRemoteControlProxy structure contains only private data and should only be accessed using the provided API.
 */

/**
 * ShairportSyncRemoteControlProxyClass:
 * @parent_class: The parent class.
 *
 * Class structure for #ShairportSyncRemoteControlProxy.
 */

struct _ShairportSyncRemoteControlProxyPrivate
{
  GData *qdata;
};

static void shairport_sync_remote_control_proxy_iface_init (ShairportSyncRemoteControlIface *iface);

#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (ShairportSyncRemoteControlProxy, shairport_sync_remote_control_proxy, G_TYPE_DBUS_PROXY,
                         G_ADD_PRIVATE (ShairportSyncRemoteControlProxy)
                         G_IMPLEMENT_INTERFACE (TYPE_SHAIRPORT_SYNC_REMOTE_CONTROL, shairport_sync_remote_control_proxy_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (ShairportSyncRemoteControlProxy, shairport_sync_remote_control_proxy, G_TYPE_DBUS_PROXY,
                         G_IMPLEMENT_INTERFACE (TYPE_SHAIRPORT_SYNC_REMOTE_CONTROL, shairport_sync_remote_control_proxy_iface_init))

#endif
static void
shairport_sync_remote_control_proxy_finalize (GObject *object)
{
  ShairportSyncRemoteControlProxy *proxy = SHAIRPORT_SYNC_REMOTE_CONTROL_PROXY (object);
  g_datalist_clear (&proxy->priv->qdata);
  G_OBJECT_CLASS (shairport_sync_remote_control_proxy_parent_class)->finalize (object);
}

static void
shairport_sync_remote_control_proxy_get_property (GObject      *object,
  guint         prop_id,
  GValue       *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  const _ExtendedGDBusPropertyInfo *info;
  GVariant *variant;
  g_assert (prop_id != 0 && prop_id - 1 < 8);
  info = (const _ExtendedGDBusPropertyInfo *) _shairport_sync_remote_control_property_info_pointers[prop_id - 1];
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (object), info->parent_struct.name);
  if (info->use_gvariant)
    {
      g_value_set_variant (value, variant);
    }
  else
    {
      if (variant != NULL)
        g_dbus_gvariant_to_gvalue (variant, value);
    }
  if (variant != NULL)
    g_variant_unref (variant);
}

static void
shairport_sync_remote_control_proxy_set_property_cb (GDBusProxy *proxy,
  GAsyncResult *res,
  gpointer      user_data)
{
  const _ExtendedGDBusPropertyInfo *info = user_data;
  GError *error;
  GVariant *_ret;
  error = NULL;
  _ret = g_dbus_proxy_call_finish (proxy, res, &error);
  if (!_ret)
    {
      g_warning ("Error setting property '%s' on interface org.gnome.ShairportSync.RemoteControl: %s (%s, %d)",
                 info->parent_struct.name, 
                 error->message, g_quark_to_string (error->domain), error->code);
      g_error_free (error);
    }
  else
    {
      g_variant_unref (_ret);
    }
}

static void
shairport_sync_remote_control_proxy_set_property (GObject      *object,
  guint         prop_id,
  const GValue *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  const _ExtendedGDBusPropertyInfo *info;
  GVariant *variant;
  g_assert (prop_id != 0 && prop_id - 1 < 8);
  info = (const _ExtendedGDBusPropertyInfo *) _shairport_sync_remote_control_property_info_pointers[prop_id - 1];
  variant = g_dbus_gvalue_to_gvariant (value, G_VARIANT_TYPE (info->parent_struct.signature));
  g_dbus_proxy_call (G_DBUS_PROXY (object),
    "org.freedesktop.DBus.Properties.Set",
    g_variant_new ("(ssv)", "org.gnome.ShairportSync.RemoteControl", info->parent_struct.name, variant),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    NULL, (GAsyncReadyCallback) shairport_sync_remote_control_proxy_set_property_cb, (GDBusPropertyInfo *) &info->parent_struct);
  g_variant_unref (variant);
}

static void
shairport_sync_remote_control_proxy_g_signal (GDBusProxy *proxy,
  const gchar *sender_name G_GNUC_UNUSED,
  const gchar *signal_name,
  GVariant *parameters)
{
  _ExtendedGDBusSignalInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  gsize n;
  guint signal_id;
  info = (_ExtendedGDBusSignalInfo *) g_dbus_interface_info_lookup_signal ((GDBusInterfaceInfo *) &_shairport_sync_remote_control_interface_info.parent_struct, signal_name);
  if (info == NULL)
    return;
  num_params = g_variant_n_children (parameters);
  paramv = g_new0 (GValue, num_params + 1);
  g_value_init (&paramv[0], TYPE_SHAIRPORT_SYNC_REMOTE_CONTROL);
  g_value_set_object (&paramv[0], proxy);
  g_variant_iter_init (&iter, parameters);
  n = 1;
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.args[n - 1];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, TYPE_SHAIRPORT_SYNC_REMOTE_CONTROL);
  g_signal_emitv (paramv, signal_id, 0, NULL);
  for (n = 0; n < num_params + 1; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static void
shairport_sync_remote_control_proxy_g_properties_changed (GDBusProxy *_proxy,
  GVariant *changed_properties,
  const gchar *const *invalidated_properties)
{
  ShairportSyncRemoteControlProxy *proxy = SHAIRPORT_SYNC_REMOTE_CONTROL_PROXY (_proxy);
  guint n;
  const gchar *key;
  GVariantIter *iter;
  _ExtendedGDBusPropertyInfo *info;
  g_variant_get (changed_properties, "a{sv}", &iter);
  while (g_variant_iter_next (iter, "{&sv}", &key, NULL))
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_shairport_sync_remote_control_interface_info.parent_struct, key);
      g_datalist_remove_data (&proxy->priv->qdata, key);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
  g_variant_iter_free (iter);
  for (n = 0; invalidated_properties[n] != NULL; n++)
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_shairport_sync_remote_control_interface_info.parent_struct, invalidated_properties[n]);
      g_datalist_remove_data (&proxy->priv->qdata, invalidated_properties[n]);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
}

static const gchar *
shairport_sync_remote_control_proxy_get_player_state (ShairportSyncRemoteControl *object)
{
  ShairportSyncRemoteControlProxy *proxy = SHAIRPORT_SYNC_REMOTE_CONTROL_PROXY (object);
  GVariant *variant;
  const gchar *value = NULL;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "PlayerState");
  if (variant != NULL)
    {
      value = g_variant_get_string (variant, NULL);
      g_variant_unref (variant);
    }
  return value;
}

static const gchar *
shairport_sync_remote_control_proxy_get_progress_string (ShairportSyncRemoteControl *object)
{
  ShairportSyncRemoteControlProxy *proxy = SHAIRPORT_SYNC_REMOTE_CONTROL_PROXY (object);
  GVariant *variant;
  const gchar *value = NULL;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "ProgressString");
  if (variant != NULL)
    {
      value = g_variant_get_string (variant, NULL);
      g_variant_unref (variant);
    }
  return value;
}

static const gchar *
shairport_sync_remote_control_proxy_get_client (ShairportSyncRemoteControl *object)
{
  ShairportSyncRemoteControlProxy *proxy = SHAIRPORT_SYNC_REMOTE_CONTROL_PROXY (object);
  GVariant *variant;
  const gchar *value = NULL;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "Client");
  if (variant != NULL)
    {
      value = g_variant_get_string (variant, NULL);
      g_variant_unref (variant);
    }
  return value;
}

static const gchar *
shairport_sync_remote_control_proxy_get_client_name (ShairportSyncRemoteControl *object)
{
  ShairportSyncRemoteControlProxy *proxy = SHAIRPORT_SYNC_REMOTE_CONTROL_PROXY (object);
  GVariant *variant;
  const gchar *value = NULL;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "ClientName");
  if (variant != NULL)
    {
      value = g_variant_get_string (variant, NULL);
      g_variant_unref (variant);
    }
  return value;
}

static const gchar *
shairport_sync_remote_control_proxy_get_stream_type (ShairportSyncRemoteControl *object)
{
  ShairportSyncRemoteControlProxy *proxy = SHAIRPORT_SYNC_REMOTE_CONTROL_PROXY (object);
  GVariant *variant;
  const gchar *value = NULL;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "StreamType");
  if (variant != NULL)
    {
      value = g_variant_get_string (variant, NULL);
      g_variant_unref (variant);
    }
  return value;
}

static gdouble 
shairport_sync_remote_control_proxy_get_airplay_volume (ShairportSyncRemoteControl *object)
{
  ShairportSyncRemoteControlProxy *proxy = SHAIRPORT_SYNC_REMOTE_CONTROL_PROXY (object);
  GVariant *variant;
  gdouble value = 0.0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "AirplayVolume");
  if (variant != NULL)
    {
      value = g_variant_get_double (variant);
      g_variant_unref (variant);
    }
  return value;
}

static GVariant *
shairport_sync_remote_control_proxy_get_metadata (ShairportSyncRemoteControl *object)
{
  ShairportSyncRemoteControlProxy *proxy = SHAIRPORT_SYNC_REMOTE_CONTROL_PROXY (object);
  GVariant *variant;
  GVariant *value = NULL;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "Metadata");
  value = variant;
  if (variant != NULL)
    g_variant_unref (variant);
  return value;
}

static gboolean 
shairport_sync_remote_control_proxy_get_available (ShairportSyncRemoteControl *object)
{
  ShairportSyncRemoteControlProxy *proxy = SHAIRPORT_SYNC_REMOTE_CONTROL_PROXY (object);
  GVariant *variant;
  gboolean value = FALSE;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "Available");
  if (variant != NULL)
    {
      value = g_variant_get_boolean (variant);
      g_variant_unref (variant);
    }
  return value;
}

static void
shairport_sync_remote_control_proxy_init (ShairportSyncRemoteControlProxy *proxy)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  proxy->priv = shairport_sync_remote_control_proxy_get_instance_private (proxy);
#else
  proxy->priv = G_TYPE_INSTANCE_GET_PRIVATE (proxy, TYPE_SHAIRPORT_SYNC_REMOTE_CONTROL_PROXY, ShairportSyncRemoteControlProxyPrivate);
#endif

  g_dbus_proxy_set_interface_info (G_DBUS_PROXY (proxy), shairport_sync_remote_control_interface_info ());
}

static void
shairport_sync_remote_control_proxy_class_init (ShairportSyncRemoteControlProxyClass *klass)
{
  GObjectClass *gobject_class;
  GDBusProxyClass *proxy_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize     = shairport_sync_remote_control_proxy_finalize;
  gobject_class->get_property = shairport_sync_remote_control_proxy_get_property;
  gobject_class->set_property = shairport_sync_remote_control_proxy_set_property;

  proxy_class = G_DBUS_PROXY_CLASS (klass);
  proxy_class->g_signal = shairport_sync_remote_control_proxy_g_signal;
  proxy_class->g_properties_changed = shairport_sync_remote_control_proxy_g_properties_changed;

  shairport_sync_remote_control_override_properties (gobject_class, 1);

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (ShairportSyncRemoteControlProxyPrivate));
#endif
}

static void
shairport_sync_remote_control_proxy_iface_init (ShairportSyncRemoteControlIface *iface)
{
  iface->get_player_state = shairport_sync_remote_control_proxy_get_player_state;
  iface->get_progress_string = shairport_sync_remote_control_proxy_get_progress_string;
  iface->get_client = shairport_sync_remote_control_proxy_get_client;
  iface->get_client_name = shairport_sync_remote_control_proxy_get_client_name;
  iface->get_stream_type = shairport_sync_remote_control_proxy_get_stream_type;
  iface->get_airplay_volume = shairport_sync_remote_control_proxy_get_airplay_volume;
  iface->get_metadata = shairport_sync_remote_control_proxy_get_metadata;
  iface->get_available = shairport_sync_remote_control_proxy_get_available;
}

/**
 * shairport_sync_remote_control_proxy_new:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-gnome-ShairportSync-RemoteControl.top_of_page">org.gnome.ShairportSync.RemoteControl</link>. See g_dbus_proxy_new() for more details.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call shairport_sync_remote_control_proxy_new_finish() to get the result of the operation.
 *
 * See shairport_sync_remote_control_proxy_new_sync() for the synchronous, blocking version of this constructor.
 */
void
shairport_sync_remote_control_proxy_new (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (TYPE_SHAIRPORT_SYNC_REMOTE_CONTROL_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.gnome.ShairportSync.RemoteControl", NULL);
}

/**
 * shairport_sync_remote_control_proxy_new_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to shairport_sync_remote_control_proxy_new().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with shairport_sync_remote_control_proxy_new().
 *
 * Returns: (transfer full) (type ShairportSyncRemoteControlProxy): The constructed proxy object or %NULL if @error is set.
 */
ShairportSyncRemoteControl *
shairport_sync_remote_control_proxy_new_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return SHAIRPORT_SYNC_REMOTE_CONTROL (ret);
  else
    return NULL;
}

/**
 * shairport_sync_remote_control_proxy_new_sync:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Synchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-gnome-ShairportSync-RemoteControl.top_of_page">org.gnome.ShairportSync.RemoteControl</link>. See g_dbus_proxy_new_sync() for more details.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See shairport_sync_remote_control_proxy_new() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type ShairportSyncRemoteControlProxy): The constructed proxy object or %NULL if @error is set.
 */
ShairportSyncRemoteControl *
shairport_sync_remote_control_proxy_new_sync (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (TYPE_SHAIRPORT_SYNC_REMOTE_CONTROL_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.gnome.ShairportSync.RemoteControl", NULL);
  if (ret != NULL)
    return SHAIRPORT_SYNC_REMOTE_CONTROL (ret);
  else
    return NULL;
}


/**
 * shairport_sync_remote_control_proxy_new_for_bus:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Like shairport_sync_remote_control_proxy_new() but takes a #GBusType instead of a #GDBusConnection.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call shairport_sync_remote_control_proxy_new_for_bus_finish() to get the result of the operation.
 *
 * See shairport_sync_remote_control_proxy_new_for_bus_sync() for the synchronous, blocking version of this constructor.
 */
void
shairport_sync_remote_control_proxy_new_for_bus (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (TYPE_SHAIRPORT_SYNC_REMOTE_CONTROL_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.gnome.ShairportSync.RemoteControl", NULL);
}

/**
 * shairport_sync_remote_control_proxy_new_for_bus_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to shairport_sync_remote_control_proxy_new_for_bus().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with shairport_sync_remote_control_proxy_new_for_bus().
 *
 * Returns: (transfer full) (type ShairportSyncRemoteControlProxy): The constructed proxy object or %NULL if @error is set.
 */
ShairportSyncRemoteControl *
shairport_sync_remote_control_proxy_new_for_bus_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return SHAIRPORT_SYNC_REMOTE_CONTROL (ret);
  else
    return NULL;
}

/**
 * shairport_sync_remote_control_proxy_new_for_bus_sync:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Like shairport_sync_remote_control_proxy_new_sync() but takes a #GBusType instead of a #GDBusConnection.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See shairport_sync_remote_control_proxy_new_for_bus() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type ShairportSyncRemoteControlProxy): The constructed proxy object or %NULL if @error is set.
 */
ShairportSyncRemoteControl *
shairport_sync_remote_control_proxy_new_for_bus_sync (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (TYPE_SHAIRPORT_SYNC_REMOTE_CONTROL_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.gnome.ShairportSync.RemoteControl", NULL);
  if (ret != NULL)
    return SHAIRPORT_SYNC_REMOTE_CONTROL (ret);
  else
    return NULL;
}


/* ------------------------------------------------------------------------ */

/**
 * ShairportSyncRemoteControlSkeleton:
 *
 * The #ShairportSyncRemoteControlSkeleton structure contains only private data and should only be accessed using the provided API.
 */

/**
 * ShairportSyncRemoteControlSkeletonClass:
 * @parent_class: The parent class.
 *
 * Class structure for #ShairportSyncRemoteControlSkeleton.
 */

struct _ShairportSyncRemoteControlSkeletonPrivate
{
  GValue *properties;
  GList *changed_properties;
  GSource *changed_properties_idle_source;
  GMainContext *context;
  GMutex lock;
};

static void
_shairport_sync_remote_control_skeleton_handle_method_call (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name,
  const gchar *method_name,
  GVariant *parameters,
  GDBusMethodInvocation *invocation,
  gpointer user_data)
{
  ShairportSyncRemoteControlSkeleton *skeleton = SHAIRPORT_SYNC_REMOTE_CONTROL_SKELETON (user_data);
  _ExtendedGDBusMethodInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  guint num_extra;
  gsize n;
  guint signal_id;
  GValue return_value = G_VALUE_INIT;
  info = (_ExtendedGDBusMethodInfo *) g_dbus_method_invocation_get_method_info (invocation);
  g_assert (info != NULL);
  num_params = g_variant_n_children (parameters);
  num_extra = info->pass_fdlist ? 3 : 2;  paramv = g_new0 (GValue, num_params + num_extra);
  n = 0;
  g_value_init (&paramv[n], TYPE_SHAIRPORT_SYNC_REMOTE_CONTROL);
  g_value_set_object (&paramv[n++], skeleton);
  g_value_init (&paramv[n], G_TYPE_DBUS_METHOD_INVOCATION);
  g_value_set_object (&paramv[n++], invocation);
  if (info->pass_fdlist)
    {
#ifdef G_OS_UNIX
      g_value_init (&paramv[n], G_TYPE_UNIX_FD_LIST);
      g_value_set_object (&paramv[n++], g_dbus_message_get_unix_fd_list (g_dbus_method_invocation_get_message (invocation)));
#else
      g_assert_not_reached ();
#endif
    }
  g_variant_iter_init (&iter, parameters);
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.in_args[n - num_extra];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, TYPE_SHAIRPORT_SYNC_REMOTE_CONTROL);
  g_value_init (&return_value, G_TYPE_BOOLEAN);
  g_signal_emitv (paramv, signal_id, 0, &return_value);
  if (!g_value_get_boolean (&return_value))
    g_dbus_method_invocation_return_error (invocation, G_DBUS_ERROR, G_DBUS_ERROR_UNKNOWN_METHOD, "Method %s is not implemented on interface %s", method_name, interface_name);
  g_value_unset (&return_value);
  for (n = 0; n < num_params + num_extra; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static GVariant *
_shairport_sync_remote_control_skeleton_handle_get_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GError **error,
  gpointer user_data)
{
  ShairportSyncRemoteControlSkeleton *skeleton = SHAIRPORT_SYNC_REMOTE_CONTROL_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  GVariant *ret;
  ret = NULL;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_shairport_sync_remote_control_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      g_value_init (&value, pspec->value_type);
      g_object_get_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      ret = g_dbus_gvalue_to_gvariant (&value, G_VARIANT_TYPE (info->parent_struct.signature));
      g_value_unset (&value);
    }
  return ret;
}

static gboolean
_shairport_sync_remote_control_skeleton_handle_set_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GVariant *variant,
  GError **error,
  gpointer user_data)
{
  ShairportSyncRemoteControlSkeleton *skeleton = SHAIRPORT_SYNC_REMOTE_CONTROL_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  gboolean ret;
  ret = FALSE;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_shairport_sync_remote_control_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      if (info->use_gvariant)
        g_value_set_variant (&value, variant);
      else
        g_dbus_gvariant_to_gvalue (variant, &value);
      g_object_set_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      g_value_unset (&value);
      ret = TRUE;
    }
  return ret;
}

static const GDBusInterfaceVTable _shairport_sync_remote_control_skeleton_vtable =
{
  _shairport_sync_remote_control_skeleton_handle_method_call,
  _shairport_sync_remote_control_skeleton_handle_get_property,
  _shairport_sync_remote_control_skeleton_handle_set_property,
  {NULL}
};

static GDBusInterfaceInfo *
shairport_sync_remote_control_skeleton_dbus_interface_get_info (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return shairport_sync_remote_control_interface_info ();
}

static GDBusInterfaceVTable *
shairport_sync_remote_control_skeleton_dbus_interface_get_vtable (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return (GDBusInterfaceVTable *) &_shairport_sync_remote_control_skeleton_vtable;
}

static GVariant *
shairport_sync_remote_control_skeleton_dbus_interface_get_properties (GDBusInterfaceSkeleton *_skeleton)
{
  ShairportSyncRemoteControlSkeleton *skeleton = SHAIRPORT_SYNC_REMOTE_CONTROL_SKELETON (_skeleton);

  GVariantBuilder builder;
  guint n;
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_84
  g_variant_builder_init_static (&builder, G_VARIANT_TYPE ("a{sv}"));
#else
  g_variant_builder_init(&builder, G_VARIANT_TYPE ("a{sv}"));
#endif
  if (_shairport_sync_remote_control_interface_info.parent_struct.properties == NULL)
    goto out;
  for (n = 0; _shairport_sync_remote_control_interface_info.parent_struct.properties[n] != NULL; n++)
    {
      GDBusPropertyInfo *info = _shairport_sync_remote_control_interface_info.parent_struct.properties[n];
      if (info->flags & G_DBUS_PROPERTY_INFO_FLAGS_READABLE)
        {
          GVariant *value;
          value = _shairport_sync_remote_control_skeleton_handle_get_property (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)), NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.gnome.ShairportSync.RemoteControl", info->name, NULL, skeleton);
          if (value != NULL)
            {
              g_variant_take_ref (value);
              g_variant_builder_add (&builder, "{sv}", info->name, value);
              g_variant_unref (value);
            }
        }
    }
out:
  return g_variant_builder_end (&builder);
}

static gboolean _shairport_sync_remote_control_emit_changed (gpointer user_data);

static void
shairport_sync_remote_control_skeleton_dbus_interface_flush (GDBusInterfaceSkeleton *_skeleton)
{
  ShairportSyncRemoteControlSkeleton *skeleton = SHAIRPORT_SYNC_REMOTE_CONTROL_SKELETON (_skeleton);
  gboolean emit_changed = FALSE;

  g_mutex_lock (&skeleton->priv->lock);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    {
      g_source_destroy (skeleton->priv->changed_properties_idle_source);
      skeleton->priv->changed_properties_idle_source = NULL;
      emit_changed = TRUE;
    }
  g_mutex_unlock (&skeleton->priv->lock);

  if (emit_changed)
    _shairport_sync_remote_control_emit_changed (skeleton);
}

static void shairport_sync_remote_control_skeleton_iface_init (ShairportSyncRemoteControlIface *iface);
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (ShairportSyncRemoteControlSkeleton, shairport_sync_remote_control_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_ADD_PRIVATE (ShairportSyncRemoteControlSkeleton)
                         G_IMPLEMENT_INTERFACE (TYPE_SHAIRPORT_SYNC_REMOTE_CONTROL, shairport_sync_remote_control_skeleton_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (ShairportSyncRemoteControlSkeleton, shairport_sync_remote_control_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_IMPLEMENT_INTERFACE (TYPE_SHAIRPORT_SYNC_REMOTE_CONTROL, shairport_sync_remote_control_skeleton_iface_init))

#endif
static void
shairport_sync_remote_control_skeleton_finalize (GObject *object)
{
  ShairportSyncRemoteControlSkeleton *skeleton = SHAIRPORT_SYNC_REMOTE_CONTROL_SKELETON (object);
  guint n;
  for (n = 0; n < 8; n++)
    g_value_unset (&skeleton->priv->properties[n]);
  g_free (skeleton->priv->properties);
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    g_source_destroy (skeleton->priv->changed_properties_idle_source);
  g_main_context_unref (skeleton->priv->context);
  g_mutex_clear (&skeleton->priv->lock);
  G_OBJECT_CLASS (shairport_sync_remote_control_skeleton_parent_class)->finalize (object);
}

static void
shairport_sync_remote_control_skeleton_get_property (GObject      *object,
  guint         prop_id,
  GValue       *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  ShairportSyncRemoteControlSkeleton *skeleton = SHAIRPORT_SYNC_REMOTE_CONTROL_SKELETON (object);
  g_assert (prop_id != 0 && prop_id - 1 < 8);
  g_mutex_lock (&skeleton->priv->lock);
  g_value_copy (&skeleton->priv->properties[prop_id - 1], value);
  g_mutex_unlock (&skeleton->priv->lock);
}

static gboolean
_shairport_sync_remote_control_emit_changed (gpointer user_data)
{
  ShairportSyncRemoteControlSkeleton *skeleton = SHAIRPORT_SYNC_REMOTE_CONTROL_SKELETON (user_data);
  GList *l;
  GVariantBuilder builder;
  GVariantBuilder invalidated_builder;
  guint num_changes;

  g_mutex_lock (&skeleton->priv->lock);
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_84
  g_variant_builder_init_static (&builder, G_VARIANT_TYPE ("a{sv}"));
  g_variant_builder_init_static (&invalidated_builder, G_VARIANT_TYPE ("as"));
#else
  g_variant_builder_init (&builder, G_VARIANT_TYPE ("a{sv}"));
  g_variant_builder_init (&invalidated_builder, G_VARIANT_TYPE ("as"));
#endif
  for (l = skeleton->priv->changed_properties, num_changes = 0; l != NULL; l = l->next)
    {
      ChangedProperty *cp = l->data;
      GVariant *variant;
      const GValue *cur_value;

      cur_value = &skeleton->priv->properties[cp->prop_id - 1];
      if (!_g_value_equal (cur_value, &cp->orig_value))
        {
          variant = g_dbus_gvalue_to_gvariant (cur_value, G_VARIANT_TYPE (cp->info->parent_struct.signature));
          g_variant_builder_add (&builder, "{sv}", cp->info->parent_struct.name, variant);
          g_variant_unref (variant);
          num_changes++;
        }
    }
  if (num_changes > 0)
    {
      GList *connections, *ll;
      GVariant *signal_variant;
      signal_variant = g_variant_ref_sink (g_variant_new ("(sa{sv}as)", "org.gnome.ShairportSync.RemoteControl",
                                           &builder, &invalidated_builder));
      connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));
      for (ll = connections; ll != NULL; ll = ll->next)
        {
          GDBusConnection *connection = ll->data;

          g_dbus_connection_emit_signal (connection,
                                         NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)),
                                         "org.freedesktop.DBus.Properties",
                                         "PropertiesChanged",
                                         signal_variant,
                                         NULL);
        }
      g_variant_unref (signal_variant);
      g_list_free_full (connections, g_object_unref);
    }
  else
    {
      g_variant_builder_clear (&builder);
      g_variant_builder_clear (&invalidated_builder);
    }
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  skeleton->priv->changed_properties = NULL;
  skeleton->priv->changed_properties_idle_source = NULL;
  g_mutex_unlock (&skeleton->priv->lock);
  return FALSE;
}

static void
_shairport_sync_remote_control_schedule_emit_changed (ShairportSyncRemoteControlSkeleton *skeleton, const _ExtendedGDBusPropertyInfo *info, guint prop_id, const GValue *orig_value)
{
  ChangedProperty *cp;
  GList *l;
  cp = NULL;
  for (l = skeleton->priv->changed_properties; l != NULL; l = l->next)
    {
      ChangedProperty *i_cp = l->data;
      if (i_cp->info == info)
        {
          cp = i_cp;
          break;
        }
    }
  if (cp == NULL)
    {
      cp = g_new0 (ChangedProperty, 1);
      cp->prop_id = prop_id;
      cp->info = info;
      skeleton->priv->changed_properties = g_list_prepend (skeleton->priv->changed_properties, cp);
      g_value_init (&cp->orig_value, G_VALUE_TYPE (orig_value));
      g_value_copy (orig_value, &cp->orig_value);
    }
}

static void
shairport_sync_remote_control_skeleton_notify (GObject      *object,
  GParamSpec *pspec G_GNUC_UNUSED)
{
  ShairportSyncRemoteControlSkeleton *skeleton = SHAIRPORT_SYNC_REMOTE_CONTROL_SKELETON (object);
  g_mutex_lock (&skeleton->priv->lock);
  if (skeleton->priv->changed_properties != NULL &&
      skeleton->priv->changed_properties_idle_source == NULL)
    {
      skeleton->priv->changed_properties_idle_source = g_idle_source_new ();
      g_source_set_priority (skeleton->priv->changed_properties_idle_source, G_PRIORITY_DEFAULT);
      g_source_set_callback (skeleton->priv->changed_properties_idle_source, _shairport_sync_remote_control_emit_changed, g_object_ref (skeleton), (GDestroyNotify) g_object_unref);
      g_source_set_name (skeleton->priv->changed_properties_idle_source, "[generated] _shairport_sync_remote_control_emit_changed");
      g_source_attach (skeleton->priv->changed_properties_idle_source, skeleton->priv->context);
      g_source_unref (skeleton->priv->changed_properties_idle_source);
    }
  g_mutex_unlock (&skeleton->priv->lock);
}

static void
shairport_sync_remote_control_skeleton_set_property (GObject      *object,
  guint         prop_id,
  const GValue *value,
  GParamSpec   *pspec)
{
  const _ExtendedGDBusPropertyInfo *info;
  ShairportSyncRemoteControlSkeleton *skeleton = SHAIRPORT_SYNC_REMOTE_CONTROL_SKELETON (object);
  g_assert (prop_id != 0 && prop_id - 1 < 8);
  info = (const _ExtendedGDBusPropertyInfo *) _shairport_sync_remote_control_property_info_pointers[prop_id - 1];
  g_mutex_lock (&skeleton->priv->lock);
  g_object_freeze_notify (object);
  if (!_g_value_equal (value, &skeleton->priv->properties[prop_id - 1]))
    {
      if (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)) != NULL &&
          info->emits_changed_signal)
        _shairport_sync_remote_control_schedule_emit_changed (skeleton, info, prop_id, &skeleton->priv->properties[prop_id - 1]);
      g_value_copy (value, &skeleton->priv->properties[prop_id - 1]);
      g_object_notify_by_pspec (object, pspec);
    }
  g_mutex_unlock (&skeleton->priv->lock);
  g_object_thaw_notify (object);
}

static void
shairport_sync_remote_control_skeleton_init (ShairportSyncRemoteControlSkeleton *skeleton)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  skeleton->priv = shairport_sync_remote_control_skeleton_get_instance_private (skeleton);
#else
  skeleton->priv = G_TYPE_INSTANCE_GET_PRIVATE (skeleton, TYPE_SHAIRPORT_SYNC_REMOTE_CONTROL_SKELETON, ShairportSyncRemoteControlSkeletonPrivate);
#endif

  g_mutex_init (&skeleton->priv->lock);
  skeleton->priv->context = g_main_context_ref_thread_default ();
  skeleton->priv->properties = g_new0 (GValue, 8);
  g_value_init (&skeleton->priv->properties[0], G_TYPE_STRING);
  g_value_init (&skeleton->priv->properties[1], G_TYPE_STRING);
  g_value_init (&skeleton->priv->properties[2], G_TYPE_STRING);
  g_value_init (&skeleton->priv->properties[3], G_TYPE_STRING);
  g_value_init (&skeleton->priv->properties[4], G_TYPE_STRING);
  g_value_init (&skeleton->priv->properties[5], G_TYPE_DOUBLE);
  g_value_init (&skeleton->priv->properties[6], G_TYPE_VARIANT);
  g_value_init (&skeleton->priv->properties[7], G_TYPE_BOOLEAN);
}

static const gchar *
shairport_sync_remote_control_skeleton_get_player_state (ShairportSyncRemoteControl *object)
{
  ShairportSyncRemoteControlSkeleton *skeleton = SHAIRPORT_SYNC_REMOTE_CONTROL_SKELETON (object);
  const gchar *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_marshal_value_peek_string (&(skeleton->priv->properties[0]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static const gchar *
shairport_sync_remote_control_skeleton_get_progress_string (ShairportSyncRemoteControl *object)
{
  ShairportSyncRemoteControlSkeleton *skeleton = SHAIRPORT_SYNC_REMOTE_CONTROL_SKELETON (object);
  const gchar *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_marshal_value_peek_string (&(skeleton->priv->properties[1]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static const gchar *
shairport_sync_remote_control_skeleton_get_client (ShairportSyncRemoteControl *object)
{
  ShairportSyncRemoteControlSkeleton *skeleton = SHAIRPORT_SYNC_REMOTE_CONTROL_SKELETON (object);
  const gchar *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_marshal_value_peek_string (&(skeleton->priv->properties[2]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static const gchar *
shairport_sync_remote_control_skeleton_get_client_name (ShairportSyncRemoteControl *object)
{
  ShairportSyncRemoteControlSkeleton *skeleton = SHAIRPORT_SYNC_REMOTE_CONTROL_SKELETON (object);
  const gchar *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_marshal_value_peek_string (&(skeleton->priv->properties[3]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static const gchar *
shairport_sync_remote_control_skeleton_get_stream_type (ShairportSyncRemoteControl *object)
{
  ShairportSyncRemoteControlSkeleton *skeleton = SHAIRPORT_SYNC_REMOTE_CONTROL_SKELETON (object);
  const gchar *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_marshal_value_peek_string (&(skeleton->priv->properties[4]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static gdouble 
shairport_sync_remote_control_skeleton_get_airplay_volume (ShairportSyncRemoteControl *object)
{
  ShairportSyncRemoteControlSkeleton *skeleton = SHAIRPORT_SYNC_REMOTE_CONTROL_SKELETON (object);
  gdouble value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_marshal_value_peek_double (&(skeleton->priv->properties[5]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static GVariant *
shairport_sync_remote_control_skeleton_get_metadata (ShairportSyncRemoteControl *object)
{
  ShairportSyncRemoteControlSkeleton *skeleton = SHAIRPORT_SYNC_REMOTE_CONTROL_SKELETON (object);
  GVariant *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_marshal_value_peek_variant (&(skeleton->priv->properties[6]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static gboolean 
shairport_sync_remote_control_skeleton_get_available (ShairportSyncRemoteControl *object)
{
  ShairportSyncRemoteControlSkeleton *skeleton = SHAIRPORT_SYNC_REMOTE_CONTROL_SKELETON (object);
  gboolean value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_marshal_value_peek_boolean (&(skeleton->priv->properties[7]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static void
shairport_sync_remote_control_skeleton_class_init (ShairportSyncRemoteControlSkeletonClass *klass)
{
  GObjectClass *gobject_class;
  GDBusInterfaceSkeletonClass *skeleton_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize = shairport_sync_remote_control_skeleton_finalize;
  gobject_class->get_property = shairport_sync_remote_control_skeleton_get_property;
  gobject_class->set_property = shairport_sync_remote_control_skeleton_set_property;
  gobject_class->notify       = shairport_sync_remote_control_skeleton_notify;


  shairport_sync_remote_control_override_properties (gobject_class, 1);

  skeleton_class = G_DBUS_INTERFACE_SKELETON_CLASS (klass);
  skeleton_class->get_info = shairport_sync_remote_control_skeleton_dbus_interface_get_info;
  skeleton_class->get_properties = shairport_sync_remote_control_skeleton_dbus_interface_get_properties;
  skeleton_class->flush = shairport_sync_remote_control_skeleton_dbus_interface_flush;
  skeleton_class->get_vtable = shairport_sync_remote_control_skeleton_dbus_interface_get_vtable;

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (ShairportSyncRemoteControlSkeletonPrivate));
#endif
}

static void
shairport_sync_remote_control_skeleton_iface_init (ShairportSyncRemoteControlIface *iface)
{
  iface->get_player_state = shairport_sync_remote_control_skeleton_get_player_state;
  iface->get_progress_string = shairport_sync_remote_control_skeleton_get_progress_string;
  iface->get_client = shairport_sync_remote_control_skeleton_get_client;
  iface->get_client_name = shairport_sync_remote_control_skeleton_get_client_name;
  iface->get_stream_type = shairport_sync_remote_control_skeleton_get_stream_type;
  iface->get_airplay_volume = shairport_sync_remote_control_skeleton_get_airplay_volume;
  iface->get_metadata = shairport_sync_remote_control_skeleton_get_metadata;
  iface->get_available = shairport_sync_remote_control_skeleton_get_available;
}

/**
 * shairport_sync_remote_control_skeleton_new:
 *
 * Creates a skeleton object for the D-Bus interface <link linkend="gdbus-interface-org-gnome-ShairportSync-RemoteControl.top_of_page">org.gnome.ShairportSync.RemoteControl</link>.
 *
 * Returns: (transfer full) (type ShairportSyncRemoteControlSkeleton): The skeleton object.
 */
ShairportSyncRemoteControl *
shairport_sync_remote_control_skeleton_new (void)
{
  return SHAIRPORT_SYNC_REMOTE_CONTROL (g_object_new (TYPE_SHAIRPORT_SYNC_REMOTE_CONTROL_SKELETON, NULL));
}

/* ------------------------------------------------------------------------
 * Code for interface org.gnome.ShairportSync.AdvancedRemoteControl
 * ------------------------------------------------------------------------
 */

/**
 * SECTION:ShairportSyncAdvancedRemoteControl
 * @title: ShairportSyncAdvancedRemoteControl
 * @short_description: Generated C code for the org.gnome.ShairportSync.AdvancedRemoteControl D-Bus interface
 *
 * This section contains code for working with the <link linkend="gdbus-interface-org-gnome-ShairportSync-AdvancedRemoteControl.top_of_page">org.gnome.ShairportSync.AdvancedRemoteControl</link> D-Bus interface in C.
 */

/* ---- Introspection data for org.gnome.ShairportSync.AdvancedRemoteControl ---- */

static const _ExtendedGDBusArgInfo _shairport_sync_advanced_remote_control_method_info_set_volume_IN_ARG_volume =
{
  {
    -1,
    (gchar *) "volume",
    (gchar *) "i",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _shairport_sync_advanced_remote_control_method_info_set_volume_IN_ARG_pointers[] =
{
  &_shairport_sync_advanced_remote_control_method_info_set_volume_IN_ARG_volume.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _shairport_sync_advanced_remote_control_method_info_set_volume =
{
  {
    -1,
    (gchar *) "SetVolume",
    (GDBusArgInfo **) &_shairport_sync_advanced_remote_control_method_info_set_volume_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-set-volume",
  FALSE
};

static const GDBusMethodInfo * const _shairport_sync_advanced_remote_control_method_info_pointers[] =
{
  &_shairport_sync_advanced_remote_control_method_info_set_volume.parent_struct,
  NULL
};

static const _ExtendedGDBusPropertyInfo _shairport_sync_advanced_remote_control_property_info_available =
{
  {
    -1,
    (gchar *) "Available",
    (gchar *) "b",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "available",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _shairport_sync_advanced_remote_control_property_info_playback_status =
{
  {
    -1,
    (gchar *) "PlaybackStatus",
    (gchar *) "s",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "playback-status",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _shairport_sync_advanced_remote_control_property_info_shuffle =
{
  {
    -1,
    (gchar *) "Shuffle",
    (gchar *) "b",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE | G_DBUS_PROPERTY_INFO_FLAGS_WRITABLE,
    NULL
  },
  "shuffle",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _shairport_sync_advanced_remote_control_property_info_loop_status =
{
  {
    -1,
    (gchar *) "LoopStatus",
    (gchar *) "s",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE | G_DBUS_PROPERTY_INFO_FLAGS_WRITABLE,
    NULL
  },
  "loop-status",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _shairport_sync_advanced_remote_control_property_info_volume =
{
  {
    -1,
    (gchar *) "Volume",
    (gchar *) "i",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "volume",
  FALSE,
  TRUE
};

static const GDBusPropertyInfo * const _shairport_sync_advanced_remote_control_property_info_pointers[] =
{
  &_shairport_sync_advanced_remote_control_property_info_available.parent_struct,
  &_shairport_sync_advanced_remote_control_property_info_playback_status.parent_struct,
  &_shairport_sync_advanced_remote_control_property_info_shuffle.parent_struct,
  &_shairport_sync_advanced_remote_control_property_info_loop_status.parent_struct,
  &_shairport_sync_advanced_remote_control_property_info_volume.parent_struct,
  NULL
};

static const _ExtendedGDBusInterfaceInfo _shairport_sync_advanced_remote_control_interface_info =
{
  {
    -1,
    (gchar *) "org.gnome.ShairportSync.AdvancedRemoteControl",
    (GDBusMethodInfo **) &_shairport_sync_advanced_remote_control_method_info_pointers,
    NULL,
    (GDBusPropertyInfo **) &_shairport_sync_advanced_remote_control_property_info_pointers,
    NULL
  },
  "shairport-sync-advanced-remote-control",
};


/**
 * shairport_sync_advanced_remote_control_interface_info:
 *
 * Gets a machine-readable description of the <link linkend="gdbus-interface-org-gnome-ShairportSync-AdvancedRemoteControl.top_of_page">org.gnome.ShairportSync.AdvancedRemoteControl</link> D-Bus interface.
 *
 * Returns: (transfer none): A #GDBusInterfaceInfo. Do not free.
 */
GDBusInterfaceInfo *
shairport_sync_advanced_remote_control_interface_info (void)
{
  return (GDBusInterfaceInfo *) &_shairport_sync_advanced_remote_control_interface_info.parent_struct;
}

/**
 * shairport_sync_advanced_remote_control_override_properties:
 * @klass: The class structure for a #GObject derived class.
 * @property_id_begin: The property id to assign to the first overridden property.
 *
 * Overrides all #GObject properties in the #ShairportSyncAdvancedRemoteControl interface for a concrete class.
 * The properties are overridden in the order they are defined.
 *
 * Returns: The last property id.
 */
guint
shairport_sync_advanced_remote_control_override_properties (GObjectClass *klass, guint property_id_begin)
{
  g_object_class_override_property (klass, property_id_begin++, "available");
  g_object_class_override_property (klass, property_id_begin++, "playback-status");
  g_object_class_override_property (klass, property_id_begin++, "shuffle");
  g_object_class_override_property (klass, property_id_begin++, "loop-status");
  g_object_class_override_property (klass, property_id_begin++, "volume");
  return property_id_begin - 1;
}


inline static void
shairport_sync_advanced_remote_control_method_marshal_set_volume (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT_INT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}


/**
 * ShairportSyncAdvancedRemoteControl:
 *
 * Abstract interface type for the D-Bus interface <link linkend="gdbus-interface-org-gnome-ShairportSync-AdvancedRemoteControl.top_of_page">org.gnome.ShairportSync.AdvancedRemoteControl</link>.
 */

/**
 * ShairportSyncAdvancedRemoteControlIface:
 * @parent_iface: The parent interface.
 * @handle_set_volume: Handler for the #ShairportSyncAdvancedRemoteControl::handle-set-volume signal.
 * @get_available: Getter for the #ShairportSyncAdvancedRemoteControl:available property.
 * @get_loop_status: Getter for the #ShairportSyncAdvancedRemoteControl:loop-status property.
 * @get_playback_status: Getter for the #ShairportSyncAdvancedRemoteControl:playback-status property.
 * @get_shuffle: Getter for the #ShairportSyncAdvancedRemoteControl:shuffle property.
 * @get_volume: Getter for the #ShairportSyncAdvancedRemoteControl:volume property.
 *
 * Virtual table for the D-Bus interface <link linkend="gdbus-interface-org-gnome-ShairportSync-AdvancedRemoteControl.top_of_page">org.gnome.ShairportSync.AdvancedRemoteControl</link>.
 */

typedef ShairportSyncAdvancedRemoteControlIface ShairportSyncAdvancedRemoteControlInterface;
G_DEFINE_INTERFACE (ShairportSyncAdvancedRemoteControl, shairport_sync_advanced_remote_control, G_TYPE_OBJECT)

static void
shairport_sync_advanced_remote_control_default_init (ShairportSyncAdvancedRemoteControlIface *iface)
{
  /* GObject signals for incoming D-Bus method calls: */
  /**
   * ShairportSyncAdvancedRemoteControl::handle-set-volume:
   * @object: A #ShairportSyncAdvancedRemoteControl.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_volume: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-gnome-ShairportSync-AdvancedRemoteControl.SetVolume">SetVolume()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call shairport_sync_advanced_remote_control_complete_set_volume() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-set-volume",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (ShairportSyncAdvancedRemoteControlIface, handle_set_volume),
    g_signal_accumulator_true_handled,
    NULL,
      shairport_sync_advanced_remote_control_method_marshal_set_volume,
    G_TYPE_BOOLEAN,
    2,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_INT);

  /* GObject properties for D-Bus properties: */
  /**
   * ShairportSyncAdvancedRemoteControl:available:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-gnome-ShairportSync-AdvancedRemoteControl.Available">"Available"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_boolean ("available", "Available", "Available", FALSE, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * ShairportSyncAdvancedRemoteControl:playback-status:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-gnome-ShairportSync-AdvancedRemoteControl.PlaybackStatus">"PlaybackStatus"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_string ("playback-status", "PlaybackStatus", "PlaybackStatus", NULL, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * ShairportSyncAdvancedRemoteControl:shuffle:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-gnome-ShairportSync-AdvancedRemoteControl.Shuffle">"Shuffle"</link>.
   *
   * Since the D-Bus property for this #GObject property is both readable and writable, it is meaningful to both read from it and write to it on both the service- and client-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_boolean ("shuffle", "Shuffle", "Shuffle", FALSE, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * ShairportSyncAdvancedRemoteControl:loop-status:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-gnome-ShairportSync-AdvancedRemoteControl.LoopStatus">"LoopStatus"</link>.
   *
   * Since the D-Bus property for this #GObject property is both readable and writable, it is meaningful to both read from it and write to it on both the service- and client-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_string ("loop-status", "LoopStatus", "LoopStatus", NULL, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * ShairportSyncAdvancedRemoteControl:volume:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-gnome-ShairportSync-AdvancedRemoteControl.Volume">"Volume"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_int ("volume", "Volume", "Volume", G_MININT32, G_MAXINT32, 0, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
}

/**
 * shairport_sync_advanced_remote_control_get_available: (skip)
 * @object: A #ShairportSyncAdvancedRemoteControl.
 *
 * Gets the value of the <link linkend="gdbus-property-org-gnome-ShairportSync-AdvancedRemoteControl.Available">"Available"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
gboolean 
shairport_sync_advanced_remote_control_get_available (ShairportSyncAdvancedRemoteControl *object)
{
  g_return_val_if_fail (IS_SHAIRPORT_SYNC_ADVANCED_REMOTE_CONTROL (object), FALSE);

  return SHAIRPORT_SYNC_ADVANCED_REMOTE_CONTROL_GET_IFACE (object)->get_available (object);
}

/**
 * shairport_sync_advanced_remote_control_set_available: (skip)
 * @object: A #ShairportSyncAdvancedRemoteControl.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-gnome-ShairportSync-AdvancedRemoteControl.Available">"Available"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
shairport_sync_advanced_remote_control_set_available (ShairportSyncAdvancedRemoteControl *object, gboolean value)
{
  g_object_set (G_OBJECT (object), "available", value, NULL);
}

/**
 * shairport_sync_advanced_remote_control_get_playback_status: (skip)
 * @object: A #ShairportSyncAdvancedRemoteControl.
 *
 * Gets the value of the <link linkend="gdbus-property-org-gnome-ShairportSync-AdvancedRemoteControl.PlaybackStatus">"PlaybackStatus"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use shairport_sync_advanced_remote_control_dup_playback_status() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
const gchar *
shairport_sync_advanced_remote_control_get_playback_status (ShairportSyncAdvancedRemoteControl *object)
{
  g_return_val_if_fail (IS_SHAIRPORT_SYNC_ADVANCED_REMOTE_CONTROL (object), NULL);

  return SHAIRPORT_SYNC_ADVANCED_REMOTE_CONTROL_GET_IFACE (object)->get_playback_status (object);
}

/**
 * shairport_sync_advanced_remote_control_dup_playback_status: (skip)
 * @object: A #ShairportSyncAdvancedRemoteControl.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-gnome-ShairportSync-AdvancedRemoteControl.PlaybackStatus">"PlaybackStatus"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_free().
 */
gchar *
shairport_sync_advanced_remote_control_dup_playback_status (ShairportSyncAdvancedRemoteControl *object)
{
  gchar *value;
  g_object_get (G_OBJECT (object), "playback-status", &value, NULL);
  return value;
}

/**
 * shairport_sync_advanced_remote_control_set_playback_status: (skip)
 * @object: A #ShairportSyncAdvancedRemoteControl.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-gnome-ShairportSync-AdvancedRemoteControl.PlaybackStatus">"PlaybackStatus"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
shairport_sync_advanced_remote_control_set_playback_status (ShairportSyncAdvancedRemoteControl *object, const gchar *value)
{
  g_object_set (G_OBJECT (object), "playback-status", value, NULL);
}

/**
 * shairport_sync_advanced_remote_control_get_shuffle: (skip)
 * @object: A #ShairportSyncAdvancedRemoteControl.
 *
 * Gets the value of the <link linkend="gdbus-property-org-gnome-ShairportSync-AdvancedRemoteControl.Shuffle">"Shuffle"</link> D-Bus property.
 *
 * Since this D-Bus property is both readable and writable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
gboolean 
shairport_sync_advanced_remote_control_get_shuffle (ShairportSyncAdvancedRemoteControl *object)
{
  g_return_val_if_fail (IS_SHAIRPORT_SYNC_ADVANCED_REMOTE_CONTROL (object), FALSE);

  return SHAIRPORT_SYNC_ADVANCED_REMOTE_CONTROL_GET_IFACE (object)->get_shuffle (object);
}

/**
 * shairport_sync_advanced_remote_control_set_shuffle: (skip)
 * @object: A #ShairportSyncAdvancedRemoteControl.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-gnome-ShairportSync-AdvancedRemoteControl.Shuffle">"Shuffle"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is both readable and writable, it is meaningful to use this function on both the client- and service-side.
 */
void
shairport_sync_advanced_remote_control_set_shuffle (ShairportSyncAdvancedRemoteControl *object, gboolean value)
{
  g_object_set (G_OBJECT (object), "shuffle", value, NULL);
}

/**
 * shairport_sync_advanced_remote_control_get_loop_status: (skip)
 * @object: A #ShairportSyncAdvancedRemoteControl.
 *
 * Gets the value of the <link linkend="gdbus-property-org-gnome-ShairportSync-AdvancedRemoteControl.LoopStatus">"LoopStatus"</link> D-Bus property.
 *
 * Since this D-Bus property is both readable and writable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use shairport_sync_advanced_remote_control_dup_loop_status() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
const gchar *
shairport_sync_advanced_remote_control_get_loop_status (ShairportSyncAdvancedRemoteControl *object)
{
  g_return_val_if_fail (IS_SHAIRPORT_SYNC_ADVANCED_REMOTE_CONTROL (object), NULL);

  return SHAIRPORT_SYNC_ADVANCED_REMOTE_CONTROL_GET_IFACE (object)->get_loop_status (object);
}

/**
 * shairport_sync_advanced_remote_control_dup_loop_status: (skip)
 * @object: A #ShairportSyncAdvancedRemoteControl.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-gnome-ShairportSync-AdvancedRemoteControl.LoopStatus">"LoopStatus"</link> D-Bus property.
 *
 * Since this D-Bus property is both readable and writable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_free().
 */
gchar *
shairport_sync_advanced_remote_control_dup_loop_status (ShairportSyncAdvancedRemoteControl *object)
{
  gchar *value;
  g_object_get (G_OBJECT (object), "loop-status", &value, NULL);
  return value;
}

/**
 * shairport_sync_advanced_remote_control_set_loop_status: (skip)
 * @object: A #ShairportSyncAdvancedRemoteControl.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-gnome-ShairportSync-AdvancedRemoteControl.LoopStatus">"LoopStatus"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is both readable and writable, it is meaningful to use this function on both the client- and service-side.
 */
void
shairport_sync_advanced_remote_control_set_loop_status (ShairportSyncAdvancedRemoteControl *object, const gchar *value)
{
  g_object_set (G_OBJECT (object), "loop-status", value, NULL);
}

/**
 * shairport_sync_advanced_remote_control_get_volume: (skip)
 * @object: A #ShairportSyncAdvancedRemoteControl.
 *
 * Gets the value of the <link linkend="gdbus-property-org-gnome-ShairportSync-AdvancedRemoteControl.Volume">"Volume"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
gint 
shairport_sync_advanced_remote_control_get_volume (ShairportSyncAdvancedRemoteControl *object)
{
  g_return_val_if_fail (IS_SHAIRPORT_SYNC_ADVANCED_REMOTE_CONTROL (object), 0);

  return SHAIRPORT_SYNC_ADVANCED_REMOTE_CONTROL_GET_IFACE (object)->get_volume (object);
}

/**
 * shairport_sync_advanced_remote_control_set_volume: (skip)
 * @object: A #ShairportSyncAdvancedRemoteControl.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-gnome-ShairportSync-AdvancedRemoteControl.Volume">"Volume"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
shairport_sync_advanced_remote_control_set_volume (ShairportSyncAdvancedRemoteControl *object, gint value)
{
  g_object_set (G_OBJECT (object), "volume", value, NULL);
}

/**
 * shairport_sync_advanced_remote_control_call_set_volume:
 * @proxy: A #ShairportSyncAdvancedRemoteControlProxy.
 * @arg_volume: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-gnome-ShairportSync-AdvancedRemoteControl.SetVolume">SetVolume()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call shairport_sync_advanced_remote_control_call_set_volume_finish() to get the result of the operation.
 *
 * See shairport_sync_advanced_remote_control_call_set_volume_sync() for the synchronous, blocking version of this method.
 */
void
shairport_sync_advanced_remote_control_call_set_volume (
    ShairportSyncAdvancedRemoteControl *proxy,
    gint arg_volume,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "SetVolume",
    g_variant_new ("(i)",
                   arg_volume),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * shairport_sync_advanced_remote_control_call_set_volume_finish:
 * @proxy: A #ShairportSyncAdvancedRemoteControlProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to shairport_sync_advanced_remote_control_call_set_volume().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with shairport_sync_advanced_remote_control_call_set_volume().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
shairport_sync_advanced_remote_control_call_set_volume_finish (
    ShairportSyncAdvancedRemoteControl *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * shairport_sync_advanced_remote_control_call_set_volume_sync:
 * @proxy: A #ShairportSyncAdvancedRemoteControlProxy.
 * @arg_volume: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-gnome-ShairportSync-AdvancedRemoteControl.SetVolume">SetVolume()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See shairport_sync_advanced_remote_control_call_set_volume() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
shairport_sync_advanced_remote_control_call_set_volume_sync (
    ShairportSyncAdvancedRemoteControl *proxy,
    gint arg_volume,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "SetVolume",
    g_variant_new ("(i)",
                   arg_volume),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * shairport_sync_advanced_remote_control_complete_set_volume:
 * @object: A #ShairportSyncAdvancedRemoteControl.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-gnome-ShairportSync-AdvancedRemoteControl.SetVolume">SetVolume()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
shairport_sync_advanced_remote_control_complete_set_volume (
    ShairportSyncAdvancedRemoteControl *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/* ------------------------------------------------------------------------ */

/**
 * ShairportSyncAdvancedRemoteControlProxy:
 *
 * The #ShairportSyncAdvancedRemoteControlProxy structure contains only private data and should only be accessed using the provided API.
 */

/**
 * ShairportSyncAdvancedRemoteControlProxyClass:
 * @parent_class: The parent class.
 *
 * Class structure for #ShairportSyncAdvancedRemoteControlProxy.
 */

struct _ShairportSyncAdvancedRemoteControlProxyPrivate
{
  GData *qdata;
};

static void shairport_sync_advanced_remote_control_proxy_iface_init (ShairportSyncAdvancedRemoteControlIface *iface);

#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (ShairportSyncAdvancedRemoteControlProxy, shairport_sync_advanced_remote_control_proxy, G_TYPE_DBUS_PROXY,
                         G_ADD_PRIVATE (ShairportSyncAdvancedRemoteControlProxy)
                         G_IMPLEMENT_INTERFACE (TYPE_SHAIRPORT_SYNC_ADVANCED_REMOTE_CONTROL, shairport_sync_advanced_remote_control_proxy_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (ShairportSyncAdvancedRemoteControlProxy, shairport_sync_advanced_remote_control_proxy, G_TYPE_DBUS_PROXY,
                         G_IMPLEMENT_INTERFACE (TYPE_SHAIRPORT_SYNC_ADVANCED_REMOTE_CONTROL, shairport_sync_advanced_remote_control_proxy_iface_init))

#endif
static void
shairport_sync_advanced_remote_control_proxy_finalize (GObject *object)
{
  ShairportSyncAdvancedRemoteControlProxy *proxy = SHAIRPORT_SYNC_ADVANCED_REMOTE_CONTROL_PROXY (object);
  g_datalist_clear (&proxy->priv->qdata);
  G_OBJECT_CLASS (shairport_sync_advanced_remote_control_proxy_parent_class)->finalize (object);
}

static void
shairport_sync_advanced_remote_control_proxy_get_property (GObject      *object,
  guint         prop_id,
  GValue       *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  const _ExtendedGDBusPropertyInfo *info;
  GVariant *variant;
  g_assert (prop_id != 0 && prop_id - 1 < 5);
  info = (const _ExtendedGDBusPropertyInfo *) _shairport_sync_advanced_remote_control_property_info_pointers[prop_id - 1];
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (object), info->parent_struct.name);
  if (info->use_gvariant)
    {
      g_value_set_variant (value, variant);
    }
  else
    {
      if (variant != NULL)
        g_dbus_gvariant_to_gvalue (variant, value);
    }
  if (variant != NULL)
    g_variant_unref (variant);
}

static void
shairport_sync_advanced_remote_control_proxy_set_property_cb (GDBusProxy *proxy,
  GAsyncResult *res,
  gpointer      user_data)
{
  const _ExtendedGDBusPropertyInfo *info = user_data;
  GError *error;
  GVariant *_ret;
  error = NULL;
  _ret = g_dbus_proxy_call_finish (proxy, res, &error);
  if (!_ret)
    {
      g_warning ("Error setting property '%s' on interface org.gnome.ShairportSync.AdvancedRemoteControl: %s (%s, %d)",
                 info->parent_struct.name, 
                 error->message, g_quark_to_string (error->domain), error->code);
      g_error_free (error);
    }
  else
    {
      g_variant_unref (_ret);
    }
}

static void
shairport_sync_advanced_remote_control_proxy_set_property (GObject      *object,
  guint         prop_id,
  const GValue *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  const _ExtendedGDBusPropertyInfo *info;
  GVariant *variant;
  g_assert (prop_id != 0 && prop_id - 1 < 5);
  info = (const _ExtendedGDBusPropertyInfo *) _shairport_sync_advanced_remote_control_property_info_pointers[prop_id - 1];
  variant = g_dbus_gvalue_to_gvariant (value, G_VARIANT_TYPE (info->parent_struct.signature));
  g_dbus_proxy_call (G_DBUS_PROXY (object),
    "org.freedesktop.DBus.Properties.Set",
    g_variant_new ("(ssv)", "org.gnome.ShairportSync.AdvancedRemoteControl", info->parent_struct.name, variant),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    NULL, (GAsyncReadyCallback) shairport_sync_advanced_remote_control_proxy_set_property_cb, (GDBusPropertyInfo *) &info->parent_struct);
  g_variant_unref (variant);
}

static void
shairport_sync_advanced_remote_control_proxy_g_signal (GDBusProxy *proxy,
  const gchar *sender_name G_GNUC_UNUSED,
  const gchar *signal_name,
  GVariant *parameters)
{
  _ExtendedGDBusSignalInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  gsize n;
  guint signal_id;
  info = (_ExtendedGDBusSignalInfo *) g_dbus_interface_info_lookup_signal ((GDBusInterfaceInfo *) &_shairport_sync_advanced_remote_control_interface_info.parent_struct, signal_name);
  if (info == NULL)
    return;
  num_params = g_variant_n_children (parameters);
  paramv = g_new0 (GValue, num_params + 1);
  g_value_init (&paramv[0], TYPE_SHAIRPORT_SYNC_ADVANCED_REMOTE_CONTROL);
  g_value_set_object (&paramv[0], proxy);
  g_variant_iter_init (&iter, parameters);
  n = 1;
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.args[n - 1];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, TYPE_SHAIRPORT_SYNC_ADVANCED_REMOTE_CONTROL);
  g_signal_emitv (paramv, signal_id, 0, NULL);
  for (n = 0; n < num_params + 1; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static void
shairport_sync_advanced_remote_control_proxy_g_properties_changed (GDBusProxy *_proxy,
  GVariant *changed_properties,
  const gchar *const *invalidated_properties)
{
  ShairportSyncAdvancedRemoteControlProxy *proxy = SHAIRPORT_SYNC_ADVANCED_REMOTE_CONTROL_PROXY (_proxy);
  guint n;
  const gchar *key;
  GVariantIter *iter;
  _ExtendedGDBusPropertyInfo *info;
  g_variant_get (changed_properties, "a{sv}", &iter);
  while (g_variant_iter_next (iter, "{&sv}", &key, NULL))
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_shairport_sync_advanced_remote_control_interface_info.parent_struct, key);
      g_datalist_remove_data (&proxy->priv->qdata, key);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
  g_variant_iter_free (iter);
  for (n = 0; invalidated_properties[n] != NULL; n++)
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_shairport_sync_advanced_remote_control_interface_info.parent_struct, invalidated_properties[n]);
      g_datalist_remove_data (&proxy->priv->qdata, invalidated_properties[n]);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
}

static gboolean 
shairport_sync_advanced_remote_control_proxy_get_available (ShairportSyncAdvancedRemoteControl *object)
{
  ShairportSyncAdvancedRemoteControlProxy *proxy = SHAIRPORT_SYNC_ADVANCED_REMOTE_CONTROL_PROXY (object);
  GVariant *variant;
  gboolean value = FALSE;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "Available");
  if (variant != NULL)
    {
      value = g_variant_get_boolean (variant);
      g_variant_unref (variant);
    }
  return value;
}

static const gchar *
shairport_sync_advanced_remote_control_proxy_get_playback_status (ShairportSyncAdvancedRemoteControl *object)
{
  ShairportSyncAdvancedRemoteControlProxy *proxy = SHAIRPORT_SYNC_ADVANCED_REMOTE_CONTROL_PROXY (object);
  GVariant *variant;
  const gchar *value = NULL;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "PlaybackStatus");
  if (variant != NULL)
    {
      value = g_variant_get_string (variant, NULL);
      g_variant_unref (variant);
    }
  return value;
}

static gboolean 
shairport_sync_advanced_remote_control_proxy_get_shuffle (ShairportSyncAdvancedRemoteControl *object)
{
  ShairportSyncAdvancedRemoteControlProxy *proxy = SHAIRPORT_SYNC_ADVANCED_REMOTE_CONTROL_PROXY (object);
  GVariant *variant;
  gboolean value = FALSE;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "Shuffle");
  if (variant != NULL)
    {
      value = g_variant_get_boolean (variant);
      g_variant_unref (variant);
    }
  return value;
}

static const gchar *
shairport_sync_advanced_remote_control_proxy_get_loop_status (ShairportSyncAdvancedRemoteControl *object)
{
  ShairportSyncAdvancedRemoteControlProxy *proxy = SHAIRPORT_SYNC_ADVANCED_REMOTE_CONTROL_PROXY (object);
  GVariant *variant;
  const gchar *value = NULL;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "LoopStatus");
  if (variant != NULL)
    {
      value = g_variant_get_string (variant, NULL);
      g_variant_unref (variant);
    }
  return value;
}

static gint 
shairport_sync_advanced_remote_control_proxy_get_volume (ShairportSyncAdvancedRemoteControl *object)
{
  ShairportSyncAdvancedRemoteControlProxy *proxy = SHAIRPORT_SYNC_ADVANCED_REMOTE_CONTROL_PROXY (object);
  GVariant *variant;
  gint value = 0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "Volume");
  if (variant != NULL)
    {
      value = g_variant_get_int32 (variant);
      g_variant_unref (variant);
    }
  return value;
}

static void
shairport_sync_advanced_remote_control_proxy_init (ShairportSyncAdvancedRemoteControlProxy *proxy)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  proxy->priv = shairport_sync_advanced_remote_control_proxy_get_instance_private (proxy);
#else
  proxy->priv = G_TYPE_INSTANCE_GET_PRIVATE (proxy, TYPE_SHAIRPORT_SYNC_ADVANCED_REMOTE_CONTROL_PROXY, ShairportSyncAdvancedRemoteControlProxyPrivate);
#endif

  g_dbus_proxy_set_interface_info (G_DBUS_PROXY (proxy), shairport_sync_advanced_remote_control_interface_info ());
}

static void
shairport_sync_advanced_remote_control_proxy_class_init (ShairportSyncAdvancedRemoteControlProxyClass *klass)
{
  GObjectClass *gobject_class;
  GDBusProxyClass *proxy_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize     = shairport_sync_advanced_remote_control_proxy_finalize;
  gobject_class->get_property = shairport_sync_advanced_remote_control_proxy_get_property;
  gobject_class->set_property = shairport_sync_advanced_remote_control_proxy_set_property;

  proxy_class = G_DBUS_PROXY_CLASS (klass);
  proxy_class->g_signal = shairport_sync_advanced_remote_control_proxy_g_signal;
  proxy_class->g_properties_changed = shairport_sync_advanced_remote_control_proxy_g_properties_changed;

  shairport_sync_advanced_remote_control_override_properties (gobject_class, 1);

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (ShairportSyncAdvancedRemoteControlProxyPrivate));
#endif
}

static void
shairport_sync_advanced_remote_control_proxy_iface_init (ShairportSyncAdvancedRemoteControlIface *iface)
{
  iface->get_available = shairport_sync_advanced_remote_control_proxy_get_available;
  iface->get_playback_status = shairport_sync_advanced_remote_control_proxy_get_playback_status;
  iface->get_shuffle = shairport_sync_advanced_remote_control_proxy_get_shuffle;
  iface->get_loop_status = shairport_sync_advanced_remote_control_proxy_get_loop_status;
  iface->get_volume = shairport_sync_advanced_remote_control_proxy_get_volume;
}

/**
 * shairport_sync_advanced_remote_control_proxy_new:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-gnome-ShairportSync-AdvancedRemoteControl.top_of_page">org.gnome.ShairportSync.AdvancedRemoteControl</link>. See g_dbus_proxy_new() for more details.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call shairport_sync_advanced_remote_control_proxy_new_finish() to get the result of the operation.
 *
 * See shairport_sync_advanced_remote_control_proxy_new_sync() for the synchronous, blocking version of this constructor.
 */
void
shairport_sync_advanced_remote_control_proxy_new (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (TYPE_SHAIRPORT_SYNC_ADVANCED_REMOTE_CONTROL_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.gnome.ShairportSync.AdvancedRemoteControl", NULL);
}

/**
 * shairport_sync_advanced_remote_control_proxy_new_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to shairport_sync_advanced_remote_control_proxy_new().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with shairport_sync_advanced_remote_control_proxy_new().
 *
 * Returns: (transfer full) (type ShairportSyncAdvancedRemoteControlProxy): The constructed proxy object or %NULL if @error is set.
 */
ShairportSyncAdvancedRemoteControl *
shairport_sync_advanced_remote_control_proxy_new_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return SHAIRPORT_SYNC_ADVANCED_REMOTE_CONTROL (ret);
  else
    return NULL;
}

/**
 * shairport_sync_advanced_remote_control_proxy_new_sync:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Synchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-gnome-ShairportSync-AdvancedRemoteControl.top_of_page">org.gnome.ShairportSync.AdvancedRemoteControl</link>. See g_dbus_proxy_new_sync() for more details.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See shairport_sync_advanced_remote_control_proxy_new() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type ShairportSyncAdvancedRemoteControlProxy): The constructed proxy object or %NULL if @error is set.
 */
ShairportSyncAdvancedRemoteControl *
shairport_sync_advanced_remote_control_proxy_new_sync (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (TYPE_SHAIRPORT_SYNC_ADVANCED_REMOTE_CONTROL_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.gnome.ShairportSync.AdvancedRemoteControl", NULL);
  if (ret != NULL)
    return SHAIRPORT_SYNC_ADVANCED_REMOTE_CONTROL (ret);
  else
    return NULL;
}


/**
 * shairport_sync_advanced_remote_control_proxy_new_for_bus:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Like shairport_sync_advanced_remote_control_proxy_new() but takes a #GBusType instead of a #GDBusConnection.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call shairport_sync_advanced_remote_control_proxy_new_for_bus_finish() to get the result of the operation.
 *
 * See shairport_sync_advanced_remote_control_proxy_new_for_bus_sync() for the synchronous, blocking version of this constructor.
 */
void
shairport_sync_advanced_remote_control_proxy_new_for_bus (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (TYPE_SHAIRPORT_SYNC_ADVANCED_REMOTE_CONTROL_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.gnome.ShairportSync.AdvancedRemoteControl", NULL);
}

/**
 * shairport_sync_advanced_remote_control_proxy_new_for_bus_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to shairport_sync_advanced_remote_control_proxy_new_for_bus().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with shairport_sync_advanced_remote_control_proxy_new_for_bus().
 *
 * Returns: (transfer full) (type ShairportSyncAdvancedRemoteControlProxy): The constructed proxy object or %NULL if @error is set.
 */
ShairportSyncAdvancedRemoteControl *
shairport_sync_advanced_remote_control_proxy_new_for_bus_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return SHAIRPORT_SYNC_ADVANCED_REMOTE_CONTROL (ret);
  else
    return NULL;
}

/**
 * shairport_sync_advanced_remote_control_proxy_new_for_bus_sync:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Like shairport_sync_advanced_remote_control_proxy_new_sync() but takes a #GBusType instead of a #GDBusConnection.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See shairport_sync_advanced_remote_control_proxy_new_for_bus() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type ShairportSyncAdvancedRemoteControlProxy): The constructed proxy object or %NULL if @error is set.
 */
ShairportSyncAdvancedRemoteControl *
shairport_sync_advanced_remote_control_proxy_new_for_bus_sync (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (TYPE_SHAIRPORT_SYNC_ADVANCED_REMOTE_CONTROL_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.gnome.ShairportSync.AdvancedRemoteControl", NULL);
  if (ret != NULL)
    return SHAIRPORT_SYNC_ADVANCED_REMOTE_CONTROL (ret);
  else
    return NULL;
}


/* ------------------------------------------------------------------------ */

/**
 * ShairportSyncAdvancedRemoteControlSkeleton:
 *
 * The #ShairportSyncAdvancedRemoteControlSkeleton structure contains only private data and should only be accessed using the provided API.
 */

/**
 * ShairportSyncAdvancedRemoteControlSkeletonClass:
 * @parent_class: The parent class.
 *
 * Class structure for #ShairportSyncAdvancedRemoteControlSkeleton.
 */

struct _ShairportSyncAdvancedRemoteControlSkeletonPrivate
{
  GValue *properties;
  GList *changed_properties;
  GSource *changed_properties_idle_source;
  GMainContext *context;
  GMutex lock;
};

static void
_shairport_sync_advanced_remote_control_skeleton_handle_method_call (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name,
  const gchar *method_name,
  GVariant *parameters,
  GDBusMethodInvocation *invocation,
  gpointer user_data)
{
  ShairportSyncAdvancedRemoteControlSkeleton *skeleton = SHAIRPORT_SYNC_ADVANCED_REMOTE_CONTROL_SKELETON (user_data);
  _ExtendedGDBusMethodInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  guint num_extra;
  gsize n;
  guint signal_id;
  GValue return_value = G_VALUE_INIT;
  info = (_ExtendedGDBusMethodInfo *) g_dbus_method_invocation_get_method_info (invocation);
  g_assert (info != NULL);
  num_params = g_variant_n_children (parameters);
  num_extra = info->pass_fdlist ? 3 : 2;  paramv = g_new0 (GValue, num_params + num_extra);
  n = 0;
  g_value_init (&paramv[n], TYPE_SHAIRPORT_SYNC_ADVANCED_REMOTE_CONTROL);
  g_value_set_object (&paramv[n++], skeleton);
  g_value_init (&paramv[n], G_TYPE_DBUS_METHOD_INVOCATION);
  g_value_set_object (&paramv[n++], invocation);
  if (info->pass_fdlist)
    {
#ifdef G_OS_UNIX
      g_value_init (&paramv[n], G_TYPE_UNIX_FD_LIST);
      g_value_set_object (&paramv[n++], g_dbus_message_get_unix_fd_list (g_dbus_method_invocation_get_message (invocation)));
#else
      g_assert_not_reached ();
#endif
    }
  g_variant_iter_init (&iter, parameters);
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.in_args[n - num_extra];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, TYPE_SHAIRPORT_SYNC_ADVANCED_REMOTE_CONTROL);
  g_value_init (&return_value, G_TYPE_BOOLEAN);
  g_signal_emitv (paramv, signal_id, 0, &return_value);
  if (!g_value_get_boolean (&return_value))
    g_dbus_method_invocation_return_error (invocation, G_DBUS_ERROR, G_DBUS_ERROR_UNKNOWN_METHOD, "Method %s is not implemented on interface %s", method_name, interface_name);
  g_value_unset (&return_value);
  for (n = 0; n < num_params + num_extra; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static GVariant *
_shairport_sync_advanced_remote_control_skeleton_handle_get_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GError **error,
  gpointer user_data)
{
  ShairportSyncAdvancedRemoteControlSkeleton *skeleton = SHAIRPORT_SYNC_ADVANCED_REMOTE_CONTROL_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  GVariant *ret;
  ret = NULL;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_shairport_sync_advanced_remote_control_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      g_value_init (&value, pspec->value_type);
      g_object_get_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      ret = g_dbus_gvalue_to_gvariant (&value, G_VARIANT_TYPE (info->parent_struct.signature));
      g_value_unset (&value);
    }
  return ret;
}

static gboolean
_shairport_sync_advanced_remote_control_skeleton_handle_set_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GVariant *variant,
  GError **error,
  gpointer user_data)
{
  ShairportSyncAdvancedRemoteControlSkeleton *skeleton = SHAIRPORT_SYNC_ADVANCED_REMOTE_CONTROL_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  gboolean ret;
  ret = FALSE;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_shairport_sync_advanced_remote_control_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      if (info->use_gvariant)
        g_value_set_variant (&value, variant);
      else
        g_dbus_gvariant_to_gvalue (variant, &value);
      g_object_set_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      g_value_unset (&value);
      ret = TRUE;
    }
  return ret;
}

static const GDBusInterfaceVTable _shairport_sync_advanced_remote_control_skeleton_vtable =
{
  _shairport_sync_advanced_remote_control_skeleton_handle_method_call,
  _shairport_sync_advanced_remote_control_skeleton_handle_get_property,
  _shairport_sync_advanced_remote_control_skeleton_handle_set_property,
  {NULL}
};

static GDBusInterfaceInfo *
shairport_sync_advanced_remote_control_skeleton_dbus_interface_get_info (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return shairport_sync_advanced_remote_control_interface_info ();
}

static GDBusInterfaceVTable *
shairport_sync_advanced_remote_control_skeleton_dbus_interface_get_vtable (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return (GDBusInterfaceVTable *) &_shairport_sync_advanced_remote_control_skeleton_vtable;
}

static GVariant *
shairport_sync_advanced_remote_control_skeleton_dbus_interface_get_properties (GDBusInterfaceSkeleton *_skeleton)
{
  ShairportSyncAdvancedRemoteControlSkeleton *skeleton = SHAIRPORT_SYNC_ADVANCED_REMOTE_CONTROL_SKELETON (_skeleton);

  GVariantBuilder builder;
  guint n;
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_84
  g_variant_builder_init_static (&builder, G_VARIANT_TYPE ("a{sv}"));
#else
  g_variant_builder_init(&builder, G_VARIANT_TYPE ("a{sv}"));
#endif
  if (_shairport_sync_advanced_remote_control_interface_info.parent_struct.properties == NULL)
    goto out;
  for (n = 0; _shairport_sync_advanced_remote_control_interface_info.parent_struct.properties[n] != NULL; n++)
    {
      GDBusPropertyInfo *info = _shairport_sync_advanced_remote_control_interface_info.parent_struct.properties[n];
      if (info->flags & G_DBUS_PROPERTY_INFO_FLAGS_READABLE)
        {
          GVariant *value;
          value = _shairport_sync_advanced_remote_control_skeleton_handle_get_property (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)), NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.gnome.ShairportSync.AdvancedRemoteControl", info->name, NULL, skeleton);
          if (value != NULL)
            {
              g_variant_take_ref (value);
              g_variant_builder_add (&builder, "{sv}", info->name, value);
              g_variant_unref (value);
            }
        }
    }
out:
  return g_variant_builder_end (&builder);
}

static gboolean _shairport_sync_advanced_remote_control_emit_changed (gpointer user_data);

static void
shairport_sync_advanced_remote_control_skeleton_dbus_interface_flush (GDBusInterfaceSkeleton *_skeleton)
{
  ShairportSyncAdvancedRemoteControlSkeleton *skeleton = SHAIRPORT_SYNC_ADVANCED_REMOTE_CONTROL_SKELETON (_skeleton);
  gboolean emit_changed = FALSE;

  g_mutex_lock (&skeleton->priv->lock);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    {
      g_source_destroy (skeleton->priv->changed_properties_idle_source);
      skeleton->priv->changed_properties_idle_source = NULL;
      emit_changed = TRUE;
    }
  g_mutex_unlock (&skeleton->priv->lock);

  if (emit_changed)
    _shairport_sync_advanced_remote_control_emit_changed (skeleton);
}

static void shairport_sync_advanced_remote_control_skeleton_iface_init (ShairportSyncAdvancedRemoteControlIface *iface);
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (ShairportSyncAdvancedRemoteControlSkeleton, shairport_sync_advanced_remote_control_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_ADD_PRIVATE (ShairportSyncAdvancedRemoteControlSkeleton)
                         G_IMPLEMENT_INTERFACE (TYPE_SHAIRPORT_SYNC_ADVANCED_REMOTE_CONTROL, shairport_sync_advanced_remote_control_skeleton_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (ShairportSyncAdvancedRemoteControlSkeleton, shairport_sync_advanced_remote_control_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_IMPLEMENT_INTERFACE (TYPE_SHAIRPORT_SYNC_ADVANCED_REMOTE_CONTROL, shairport_sync_advanced_remote_control_skeleton_iface_init))

#endif
static void
shairport_sync_advanced_remote_control_skeleton_finalize (GObject *object)
{
  ShairportSyncAdvancedRemoteControlSkeleton *skeleton = SHAIRPORT_SYNC_ADVANCED_REMOTE_CONTROL_SKELETON (object);
  guint n;
  for (n = 0; n < 5; n++)
    g_value_unset (&skeleton->priv->properties[n]);
  g_free (skeleton->priv->properties);
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    g_source_destroy (skeleton->priv->changed_properties_idle_source);
  g_main_context_unref (skeleton->priv->context);
  g_mutex_clear (&skeleton->priv->lock);
  G_OBJECT_CLASS (shairport_sync_advanced_remote_control_skeleton_parent_class)->finalize (object);
}

static void
shairport_sync_advanced_remote_control_skeleton_get_property (GObject      *object,
  guint         prop_id,
  GValue       *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  ShairportSyncAdvancedRemoteControlSkeleton *skeleton = SHAIRPORT_SYNC_ADVANCED_REMOTE_CONTROL_SKELETON (object);
  g_assert (prop_id != 0 && prop_id - 1 < 5);
  g_mutex_lock (&skeleton->priv->lock);
  g_value_copy (&skeleton->priv->properties[prop_id - 1], value);
  g_mutex_unlock (&skeleton->priv->lock);
}

static gboolean
_shairport_sync_advanced_remote_control_emit_changed (gpointer user_data)
{
  ShairportSyncAdvancedRemoteControlSkeleton *skeleton = SHAIRPORT_SYNC_ADVANCED_REMOTE_CONTROL_SKELETON (user_data);
  GList *l;
  GVariantBuilder builder;
  GVariantBuilder invalidated_builder;
  guint num_changes;

  g_mutex_lock (&skeleton->priv->lock);
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_84
  g_variant_builder_init_static (&builder, G_VARIANT_TYPE ("a{sv}"));
  g_variant_builder_init_static (&invalidated_builder, G_VARIANT_TYPE ("as"));
#else
  g_variant_builder_init (&builder, G_VARIANT_TYPE ("a{sv}"));
  g_variant_builder_init (&invalidated_builder, G_VARIANT_TYPE ("as"));
#endif
  for (l = skeleton->priv->changed_properties, num_changes = 0; l != NULL; l = l->next)
    {
      ChangedProperty *cp = l->data;
      GVariant *variant;
      const GValue *cur_value;

      cur_value = &skeleton->priv->properties[cp->prop_id - 1];
      if (!_g_value_equal (cur_value, &cp->orig_value))
        {
          variant = g_dbus_gvalue_to_gvariant (cur_value, G_VARIANT_TYPE (cp->info->parent_struct.signature));
          g_variant_builder_add (&builder, "{sv}", cp->info->parent_struct.name, variant);
          g_variant_unref (variant);
          num_changes++;
        }
    }
  if (num_changes > 0)
    {
      GList *connections, *ll;
      GVariant *signal_variant;
      signal_variant = g_variant_ref_sink (g_variant_new ("(sa{sv}as)", "org.gnome.ShairportSync.AdvancedRemoteControl",
                                           &builder, &invalidated_builder));
      connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));
      for (ll = connections; ll != NULL; ll = ll->next)
        {
          GDBusConnection *connection = ll->data;

          g_dbus_connection_emit_signal (connection,
                                         NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)),
                                         "org.freedesktop.DBus.Properties",
                                         "PropertiesChanged",
                                         signal_variant,
                                         NULL);
        }
      g_variant_unref (signal_variant);
      g_list_free_full (connections, g_object_unref);
    }
  else
    {
      g_variant_builder_clear (&builder);
      g_variant_builder_clear (&invalidated_builder);
    }
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  skeleton->priv->changed_properties = NULL;
  skeleton->priv->changed_properties_idle_source = NULL;
  g_mutex_unlock (&skeleton->priv->lock);
  return FALSE;
}

static void
_shairport_sync_advanced_remote_control_schedule_emit_changed (ShairportSyncAdvancedRemoteControlSkeleton *skeleton, const _ExtendedGDBusPropertyInfo *info, guint prop_id, const GValue *orig_value)
{
  ChangedProperty *cp;
  GList *l;
  cp = NULL;
  for (l = skeleton->priv->changed_properties; l != NULL; l = l->next)
    {
      ChangedProperty *i_cp = l->data;
      if (i_cp->info == info)
        {
          cp = i_cp;
          break;
        }
    }
  if (cp == NULL)
    {
      cp = g_new0 (ChangedProperty, 1);
      cp->prop_id = prop_id;
      cp->info = info;
      skeleton->priv->changed_properties = g_list_prepend (skeleton->priv->changed_properties, cp);
      g_value_init (&cp->orig_value, G_VALUE_TYPE (orig_value));
      g_value_copy (orig_value, &cp->orig_value);
    }
}

static void
shairport_sync_advanced_remote_control_skeleton_notify (GObject      *object,
  GParamSpec *pspec G_GNUC_UNUSED)
{
  ShairportSyncAdvancedRemoteControlSkeleton *skeleton = SHAIRPORT_SYNC_ADVANCED_REMOTE_CONTROL_SKELETON (object);
  g_mutex_lock (&skeleton->priv->lock);
  if (skeleton->priv->changed_properties != NULL &&
      skeleton->priv->changed_properties_idle_source == NULL)
    {
      skeleton->priv->changed_properties_idle_source = g_idle_source_new ();
      g_source_set_priority (skeleton->priv->changed_properties_idle_source, G_PRIORITY_DEFAULT);
      g_source_set_callback (skeleton->priv->changed_properties_idle_source, _shairport_sync_advanced_remote_control_emit_changed, g_object_ref (skeleton), (GDestroyNotify) g_object_unref);
      g_source_set_name (skeleton->priv->changed_properties_idle_source, "[generated] _shairport_sync_advanced_remote_control_emit_changed");
      g_source_attach (skeleton->priv->changed_properties_idle_source, skeleton->priv->context);
      g_source_unref (skeleton->priv->changed_properties_idle_source);
    }
  g_mutex_unlock (&skeleton->priv->lock);
}

static void
shairport_sync_advanced_remote_control_skeleton_set_property (GObject      *object,
  guint         prop_id,
  const GValue *value,
  GParamSpec   *pspec)
{
  const _ExtendedGDBusPropertyInfo *info;
  ShairportSyncAdvancedRemoteControlSkeleton *skeleton = SHAIRPORT_SYNC_ADVANCED_REMOTE_CONTROL_SKELETON (object);
  g_assert (prop_id != 0 && prop_id - 1 < 5);
  info = (const _ExtendedGDBusPropertyInfo *) _shairport_sync_advanced_remote_control_property_info_pointers[prop_id - 1];
  g_mutex_lock (&skeleton->priv->lock);
  g_object_freeze_notify (object);
  if (!_g_value_equal (value, &skeleton->priv->properties[prop_id - 1]))
    {
      if (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)) != NULL &&
          info->emits_changed_signal)
        _shairport_sync_advanced_remote_control_schedule_emit_changed (skeleton, info, prop_id, &skeleton->priv->properties[prop_id - 1]);
      g_value_copy (value, &skeleton->priv->properties[prop_id - 1]);
      g_object_notify_by_pspec (object, pspec);
    }
  g_mutex_unlock (&skeleton->priv->lock);
  g_object_thaw_notify (object);
}

static void
shairport_sync_advanced_remote_control_skeleton_init (ShairportSyncAdvancedRemoteControlSkeleton *skeleton)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  skeleton->priv = shairport_sync_advanced_remote_control_skeleton_get_instance_private (skeleton);
#else
  skeleton->priv = G_TYPE_INSTANCE_GET_PRIVATE (skeleton, TYPE_SHAIRPORT_SYNC_ADVANCED_REMOTE_CONTROL_SKELETON, ShairportSyncAdvancedRemoteControlSkeletonPrivate);
#endif

  g_mutex_init (&skeleton->priv->lock);
  skeleton->priv->context = g_main_context_ref_thread_default ();
  skeleton->priv->properties = g_new0 (GValue, 5);
  g_value_init (&skeleton->priv->properties[0], G_TYPE_BOOLEAN);
  g_value_init (&skeleton->priv->properties[1], G_TYPE_STRING);
  g_value_init (&skeleton->priv->properties[2], G_TYPE_BOOLEAN);
  g_value_init (&skeleton->priv->properties[3], G_TYPE_STRING);
  g_value_init (&skeleton->priv->properties[4], G_TYPE_INT);
}

static gboolean 
shairport_sync_advanced_remote_control_skeleton_get_available (ShairportSyncAdvancedRemoteControl *object)
{
  ShairportSyncAdvancedRemoteControlSkeleton *skeleton = SHAIRPORT_SYNC_ADVANCED_REMOTE_CONTROL_SKELETON (object);
  gboolean value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_marshal_value_peek_boolean (&(skeleton->priv->properties[0]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static const gchar *
shairport_sync_advanced_remote_control_skeleton_get_playback_status (ShairportSyncAdvancedRemoteControl *object)
{
  ShairportSyncAdvancedRemoteControlSkeleton *skeleton = SHAIRPORT_SYNC_ADVANCED_REMOTE_CONTROL_SKELETON (object);
  const gchar *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_marshal_value_peek_string (&(skeleton->priv->properties[1]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static gboolean 
shairport_sync_advanced_remote_control_skeleton_get_shuffle (ShairportSyncAdvancedRemoteControl *object)
{
  ShairportSyncAdvancedRemoteControlSkeleton *skeleton = SHAIRPORT_SYNC_ADVANCED_REMOTE_CONTROL_SKELETON (object);
  gboolean value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_marshal_value_peek_boolean (&(skeleton->priv->properties[2]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static const gchar *
shairport_sync_advanced_remote_control_skeleton_get_loop_status (ShairportSyncAdvancedRemoteControl *object)
{
  ShairportSyncAdvancedRemoteControlSkeleton *skeleton = SHAIRPORT_SYNC_ADVANCED_REMOTE_CONTROL_SKELETON (object);
  const gchar *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_marshal_value_peek_string (&(skeleton->priv->properties[3]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static gint 
shairport_sync_advanced_remote_control_skeleton_get_volume (ShairportSyncAdvancedRemoteControl *object)
{
  ShairportSyncAdvancedRemoteControlSkeleton *skeleton = SHAIRPORT_SYNC_ADVANCED_REMOTE_CONTROL_SKELETON (object);
  gint value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_marshal_value_peek_int (&(skeleton->priv->properties[4]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static void
shairport_sync_advanced_remote_control_skeleton_class_init (ShairportSyncAdvancedRemoteControlSkeletonClass *klass)
{
  GObjectClass *gobject_class;
  GDBusInterfaceSkeletonClass *skeleton_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize = shairport_sync_advanced_remote_control_skeleton_finalize;
  gobject_class->get_property = shairport_sync_advanced_remote_control_skeleton_get_property;
  gobject_class->set_property = shairport_sync_advanced_remote_control_skeleton_set_property;
  gobject_class->notify       = shairport_sync_advanced_remote_control_skeleton_notify;


  shairport_sync_advanced_remote_control_override_properties (gobject_class, 1);

  skeleton_class = G_DBUS_INTERFACE_SKELETON_CLASS (klass);
  skeleton_class->get_info = shairport_sync_advanced_remote_control_skeleton_dbus_interface_get_info;
  skeleton_class->get_properties = shairport_sync_advanced_remote_control_skeleton_dbus_interface_get_properties;
  skeleton_class->flush = shairport_sync_advanced_remote_control_skeleton_dbus_interface_flush;
  skeleton_class->get_vtable = shairport_sync_advanced_remote_control_skeleton_dbus_interface_get_vtable;

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (ShairportSyncAdvancedRemoteControlSkeletonPrivate));
#endif
}

static void
shairport_sync_advanced_remote_control_skeleton_iface_init (ShairportSyncAdvancedRemoteControlIface *iface)
{
  iface->get_available = shairport_sync_advanced_remote_control_skeleton_get_available;
  iface->get_playback_status = shairport_sync_advanced_remote_control_skeleton_get_playback_status;
  iface->get_shuffle = shairport_sync_advanced_remote_control_skeleton_get_shuffle;
  iface->get_loop_status = shairport_sync_advanced_remote_control_skeleton_get_loop_status;
  iface->get_volume = shairport_sync_advanced_remote_control_skeleton_get_volume;
}

/**
 * shairport_sync_advanced_remote_control_skeleton_new:
 *
 * Creates a skeleton object for the D-Bus interface <link linkend="gdbus-interface-org-gnome-ShairportSync-AdvancedRemoteControl.top_of_page">org.gnome.ShairportSync.AdvancedRemoteControl</link>.
 *
 * Returns: (transfer full) (type ShairportSyncAdvancedRemoteControlSkeleton): The skeleton object.
 */
ShairportSyncAdvancedRemoteControl *
shairport_sync_advanced_remote_control_skeleton_new (void)
{
  return SHAIRPORT_SYNC_ADVANCED_REMOTE_CONTROL (g_object_new (TYPE_SHAIRPORT_SYNC_ADVANCED_REMOTE_CONTROL_SKELETON, NULL));
}

