// ----------------------------------------------------------------------------
//
//  Copyright (C) 2013-2019 Fons Adriaensen <fons@linuxaudio.org>
//    
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 3 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program.  If not, see <http://www.gnu.org/licenses/>.
//
// ----------------------------------------------------------------------------


#ifndef __LR4FILTER_H
#define __LR4FILTER_H


// State variable version of 4th order HP or LP filters.
// The 'f' parameter is the corner frequency divided by
// the sample rate. The 's' parameter defines the filter
// shape, s = -6 for Linkwitz-Riley, s = -3 for Butterworth.
// For s == -6, HP and LP outputs are exactly in phase and
// gains sum to unity magnitude.


class Lr4filter
{
public:
    
    Lr4filter (void);
    ~Lr4filter (void);
    
    void reset (void);
    void setpars (float f, float s);
    void process_lopass (int nsamp, const float *inp, float *out);
    void process_hipass (int nsamp, const float *inp, float *out);
    
private:

    float _c1, _c2;            // First stage coefficients.
    float _c3, _c4;            // Second stage coefficients.
    float _g;                  // Higpass gain factor.
    float _z1, _z2, _z3, _z4;  // filter state 
};


#endif
