// ----------------------------------------------------------------------------
//
//  Copyright (C) 2012-2021 Fons Adriaensen <fons@linuxaudio.org>
//    
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 3 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program.  If not, see <http://www.gnu.org/licenses/>.
//
// ----------------------------------------------------------------------------


#ifndef __JAMBROT_H
#define __JAMBROT_H


#include <zita-jclient.h>
#include "ambrot8.h"


class Jambrot : public Jclient
{
public:

    enum
    {
        MAXDEGR = Ambrot8::MAXDEGR, 
        MAXHARM = Ambrot8::MAXHARM
    };

    Jambrot (const char *client_name, const char *server_name, int degree);
    virtual ~Jambrot (void);

    void set_rotation (float a, float x, float y, float z, float t);
    void set_quaternion (float w, float x, float y, float z, float t);
    
private:

    int  jack_process (int nframes);

    Ambrot8  *_ambrot;
};


#endif
