/* Worker.c generated by valac 0.56.17, the Vala compiler
 * generated from Worker.vala, do not modify */

/**/
/*  Copyright (C) 2015 Rico Tzschichholz*/
/**/
/*  This file is part of Plank.*/
/**/
/*  Plank is free software: you can redistribute it and/or modify*/
/*  it under the terms of the GNU General Public License as published by*/
/*  the Free Software Foundation, either version 3 of the License, or*/
/*  (at your option) any later version.*/
/**/
/*  Plank is distributed in the hope that it will be useful,*/
/*  but WITHOUT ANY WARRANTY; without even the implied warranty of*/
/*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the*/
/*  GNU General Public License for more details.*/
/**/
/*  You should have received a copy of the GNU General Public License*/
/*  along with this program.  If not, see <http://www.gnu.org/licenses/>.*/
/**/

#include "plank.h"
#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

typedef struct _PlankTask PlankTask;
enum  {
	PLANK_WORKER_0_PROPERTY,
	PLANK_WORKER_NUM_PROPERTIES
};
static GParamSpec* plank_worker_properties[PLANK_WORKER_NUM_PROPERTIES];
#define _g_thread_pool_free0(var) ((var == NULL) ? NULL : (var = (g_thread_pool_free (var, FALSE, TRUE), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _Block17Data Block17Data;
typedef struct _PlankWorkerAddTaskWithResultData PlankWorkerAddTaskWithResultData;
#define _plank_task_free0(var) ((var == NULL) ? NULL : (var = (plank_task_free (var), NULL)))

struct _PlankTask {
	GThreadFunc func;
	gpointer func_target;
	PlankTaskPriority priority;
};

struct _PlankWorkerPrivate {
	GThreadPool* pool;
};

struct _Block17Data {
	int _ref_count_;
	PlankWorker* self;
	GType g_type;
	GBoxedCopyFunc g_dup_func;
	GDestroyNotify g_destroy_func;
	GSourceFunc resume;
	gpointer resume_target;
	GDestroyNotify resume_target_destroy_notify;
	GError* err;
	gpointer _result_;
	PlankTaskFunc func;
	gpointer func_target;
	GDestroyNotify func_target_destroy_notify;
	gpointer _async_data_;
};

struct _PlankWorkerAddTaskWithResultData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	PlankWorker* self;
	PlankTaskFunc func;
	gpointer func_target;
	GDestroyNotify func_target_destroy_notify;
	PlankTaskPriority priority;
	GType g_type;
	GBoxedCopyFunc g_dup_func;
	GDestroyNotify g_destroy_func;
	gpointer result;
	Block17Data* _data17_;
	GThreadFunc tfunc;
	gpointer tfunc_target;
	GThreadPool* _tmp0_;
	GThreadFunc _tmp1_;
	gpointer _tmp1__target;
	PlankTask* _tmp2_;
	GError* e;
	GError* _tmp3_;
	const gchar* _tmp4_;
	GError* _tmp5_;
	GError* _tmp6_;
	GError* _tmp7_;
	gconstpointer _tmp8_;
	gpointer _tmp9_;
	GError* _inner_error0_;
};

static gint PlankWorker_private_offset;
static gpointer plank_worker_parent_class = NULL;
static PlankWorker* plank_worker_worker;
static PlankWorker* plank_worker_worker = NULL;

VALA_EXTERN void plank_task_free (PlankTask * self);
static void plank_task_instance_init (PlankTask * self);
VALA_EXTERN PlankTask* plank_task_new (GThreadFunc _func,
                           gpointer _func_target,
                           PlankTaskPriority _priority);
VALA_EXTERN void* plank_task_run (PlankTask* self);
static PlankWorker* plank_worker_new (void);
static PlankWorker* plank_worker_construct (GType object_type);
static gint plank_worker_compare_task_priority (PlankTask* t1,
                                         PlankTask* t2);
static void plank_worker_add_task_with_result_data_free (gpointer _data);
static gboolean plank_worker_add_task_with_result_co (PlankWorkerAddTaskWithResultData* _data_);
static Block17Data* block17_data_ref (Block17Data* _data17_);
static void block17_data_unref (void * _userdata_);
static gboolean _plank_worker_add_task_with_result_co_gsource_func (gpointer self);
static gpointer ___lambda65_ (Block17Data* _data17_);
static gpointer ____lambda65__gthread_func (gpointer self);
static GObject * plank_worker_constructor (GType type,
                                    guint n_construct_properties,
                                    GObjectConstructParam * construct_properties);
static void _plank_worker____lambda66_ (PlankWorker* self,
                                 PlankTask* task);
static void __plank_worker____lambda66__gfunc (gpointer data,
                                        gpointer self);
static void plank_worker_finalize (GObject * obj);
static GType plank_worker_get_type_once (void);

static GType
plank_task_priority_get_type_once (void)
{
	static const GEnumValue values[] = {{PLANK_TASK_PRIORITY_LOW, "PLANK_TASK_PRIORITY_LOW", "low"}, {PLANK_TASK_PRIORITY_DEFAULT, "PLANK_TASK_PRIORITY_DEFAULT", "default"}, {PLANK_TASK_PRIORITY_HIGH, "PLANK_TASK_PRIORITY_HIGH", "high"}, {0, NULL, NULL}};
	GType plank_task_priority_type_id;
	plank_task_priority_type_id = g_enum_register_static ("PlankTaskPriority", values);
	return plank_task_priority_type_id;
}

GType
plank_task_priority_get_type (void)
{
	static volatile gsize plank_task_priority_type_id__once = 0;
	if (g_once_init_enter (&plank_task_priority_type_id__once)) {
		GType plank_task_priority_type_id;
		plank_task_priority_type_id = plank_task_priority_get_type_once ();
		g_once_init_leave (&plank_task_priority_type_id__once, plank_task_priority_type_id);
	}
	return plank_task_priority_type_id__once;
}

PlankTask*
plank_task_new (GThreadFunc _func,
                gpointer _func_target,
                PlankTaskPriority _priority)
{
	PlankTask* self;
	self = g_slice_new0 (PlankTask);
	plank_task_instance_init (self);
	self->func = _func;
	self->func_target = _func_target;
	self->priority = _priority;
	return self;
}

void*
plank_task_run (PlankTask* self)
{
	GThreadFunc _tmp0_;
	gpointer _tmp0__target;
	gpointer _tmp1_;
	void* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->func;
	_tmp0__target = self->func_target;
	_tmp1_ = _tmp0_ (_tmp0__target);
	result = _tmp1_;
	return result;
}

static void
plank_task_instance_init (PlankTask * self)
{
}

void
plank_task_free (PlankTask * self)
{
	g_slice_free (PlankTask, self);
}

static inline gpointer
plank_worker_get_instance_private (PlankWorker* self)
{
	return G_STRUCT_MEMBER_P (self, PlankWorker_private_offset);
}

PlankWorker*
plank_worker_get_default (void)
{
	PlankWorker* _tmp0_;
	PlankWorker* _tmp2_;
	PlankWorker* result;
	_tmp0_ = plank_worker_worker;
	if (_tmp0_ == NULL) {
		PlankWorker* _tmp1_;
		_tmp1_ = plank_worker_new ();
		_g_object_unref0 (plank_worker_worker);
		plank_worker_worker = _tmp1_;
	}
	_tmp2_ = plank_worker_worker;
	result = _tmp2_;
	return result;
}

static PlankWorker*
plank_worker_construct (GType object_type)
{
	PlankWorker * self = NULL;
	self = (PlankWorker*) g_object_new (object_type, NULL);
	return self;
}

static PlankWorker*
plank_worker_new (void)
{
	return plank_worker_construct (PLANK_TYPE_WORKER);
}

static gint
plank_worker_compare_task_priority (PlankTask* t1,
                                    PlankTask* t2)
{
	gint p1 = 0;
	gint p2 = 0;
	gint _tmp0_ = 0;
	gint result;
	g_return_val_if_fail (t1 != NULL, 0);
	g_return_val_if_fail (t2 != NULL, 0);
	p1 = (gint) t1->priority;
	p2 = (gint) t2->priority;
	if (p1 < p2) {
		_tmp0_ = -1;
	} else {
		_tmp0_ = (gint) (p1 > p2);
	}
	result = _tmp0_;
	return result;
}

/**
 * Schedule given function to be run in our ThreadPool
 * The given priority influences execution-time of the task 
 * depending on the currently scheduled amount of tasks.
 *
 * @param func function to be executed
 * @param priority priority of the given function
 */
void
plank_worker_add_task (PlankWorker* self,
                       GThreadFunc func,
                       gpointer func_target,
                       PlankTaskPriority priority)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	{
		GThreadPool* _tmp0_;
		PlankTask* _tmp1_;
		_tmp0_ = self->priv->pool;
		_tmp1_ = plank_task_new (func, func_target, priority);
		g_thread_pool_push (_tmp0_, _tmp1_, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_THREAD_ERROR) {
				goto __catch0_g_thread_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	goto __finally0;
	__catch0_g_thread_error:
	{
		GError* e = NULL;
		GError* _tmp2_;
		const gchar* _tmp3_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp2_ = e;
		_tmp3_ = _tmp2_->message;
		g_warning ("Worker.vala:102: %s", _tmp3_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
plank_worker_add_task_with_result_data_free (gpointer _data)
{
	PlankWorkerAddTaskWithResultData* _data_;
	_data_ = _data;
	((_data_->result == NULL) || (_data_->g_destroy_func == NULL)) ? NULL : (_data_->result = (_data_->g_destroy_func (_data_->result), NULL));
	_g_object_unref0 (_data_->self);
	g_slice_free (PlankWorkerAddTaskWithResultData, _data_);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

void
plank_worker_add_task_with_result (PlankWorker* self,
                                   GType g_type,
                                   GBoxedCopyFunc g_dup_func,
                                   GDestroyNotify g_destroy_func,
                                   PlankTaskFunc func,
                                   gpointer func_target,
                                   GDestroyNotify func_target_destroy_notify,
                                   PlankTaskPriority priority,
                                   GAsyncReadyCallback _callback_,
                                   gpointer _user_data_)
{
	PlankWorkerAddTaskWithResultData* _data_;
	PlankWorker* _tmp0_;
	g_return_if_fail (self != NULL);
	_data_ = g_slice_new0 (PlankWorkerAddTaskWithResultData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, plank_worker_add_task_with_result_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	(_data_->func_target_destroy_notify == NULL) ? NULL : (_data_->func_target_destroy_notify (_data_->func_target), NULL);
	_data_->func = NULL;
	_data_->func_target = NULL;
	_data_->func_target_destroy_notify = NULL;
	_data_->func = func;
	_data_->func_target = func_target;
	_data_->func_target_destroy_notify = func_target_destroy_notify;
	_data_->priority = priority;
	_data_->g_type = g_type;
	_data_->g_dup_func = g_dup_func;
	_data_->g_destroy_func = g_destroy_func;
	plank_worker_add_task_with_result_co (_data_);
}

gpointer
plank_worker_add_task_with_result_finish (PlankWorker* self,
                                          GAsyncResult* _res_,
                                          GError** error)
{
	gpointer result;
	PlankWorkerAddTaskWithResultData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return NULL;
	}
	result = _data_->result;
	_data_->result = NULL;
	return result;
}

/**
 * Schedule given function to be run in our ThreadPool
 * The given priority influences execution-time of the task 
 * depending on the currently scheduled amount of tasks.
 *
 * AsyncReadyCallback will be executed on the main-thread through an idle
 * with GLib.Priority.HIGH_IDLE.
 *
 * @param func the function to be executed returning a typed result
 * @param priority priority of the given function
 * @return the typed result
 */
static Block17Data*
block17_data_ref (Block17Data* _data17_)
{
	g_atomic_int_inc (&_data17_->_ref_count_);
	return _data17_;
}

static void
block17_data_unref (void * _userdata_)
{
	Block17Data* _data17_;
	_data17_ = (Block17Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data17_->_ref_count_)) {
		PlankWorker* self;
		GType g_type;
		GBoxedCopyFunc g_dup_func;
		GDestroyNotify g_destroy_func;
		self = _data17_->self;
		g_type = _data17_->g_type;
		g_dup_func = _data17_->g_dup_func;
		g_destroy_func = _data17_->g_destroy_func;
		((_data17_->_result_ == NULL) || (g_destroy_func == NULL)) ? NULL : (_data17_->_result_ = (g_destroy_func (_data17_->_result_), NULL));
		_g_error_free0 (_data17_->err);
		(_data17_->resume_target_destroy_notify == NULL) ? NULL : (_data17_->resume_target_destroy_notify (_data17_->resume_target), NULL);
		_data17_->resume = NULL;
		_data17_->resume_target = NULL;
		_data17_->resume_target_destroy_notify = NULL;
		(_data17_->func_target_destroy_notify == NULL) ? NULL : (_data17_->func_target_destroy_notify (_data17_->func_target), NULL);
		_data17_->func = NULL;
		_data17_->func_target = NULL;
		_data17_->func_target_destroy_notify = NULL;
		_g_object_unref0 (self);
		g_slice_free (Block17Data, _data17_);
	}
}

static gboolean
_plank_worker_add_task_with_result_co_gsource_func (gpointer self)
{
	gboolean result;
	result = plank_worker_add_task_with_result_co (self);
	return result;
}

static gpointer
_g_error_copy0 (gpointer self)
{
	return self ? g_error_copy (self) : NULL;
}

static gpointer
___lambda65_ (Block17Data* _data17_)
{
	PlankWorker* self;
	GType g_type;
	GBoxedCopyFunc g_dup_func;
	GDestroyNotify g_destroy_func;
	GSourceFunc _tmp5_;
	gpointer _tmp5__target;
	GDestroyNotify _tmp5__target_destroy_notify;
	GError* _inner_error0_ = NULL;
	gpointer result;
	self = _data17_->self;
	g_type = _data17_->g_type;
	g_dup_func = _data17_->g_dup_func;
	g_destroy_func = _data17_->g_destroy_func;
	{
		gpointer _tmp0_ = NULL;
		gpointer _tmp1_;
		gpointer _tmp2_;
		_tmp1_ = _data17_->func (_data17_->func_target, &_inner_error0_);
		_tmp0_ = _tmp1_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp2_ = _tmp0_;
		_tmp0_ = NULL;
		((_data17_->_result_ == NULL) || (g_destroy_func == NULL)) ? NULL : (_data17_->_result_ = (g_destroy_func (_data17_->_result_), NULL));
		_data17_->_result_ = _tmp2_;
		((_tmp0_ == NULL) || (g_destroy_func == NULL)) ? NULL : (_tmp0_ = (g_destroy_func (_tmp0_), NULL));
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp3_;
		GError* _tmp4_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp3_ = e;
		_tmp4_ = _g_error_copy0 (_tmp3_);
		_g_error_free0 (_data17_->err);
		_data17_->err = _tmp4_;
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
	_tmp5_ = _data17_->resume;
	_tmp5__target = _data17_->resume_target;
	_tmp5__target_destroy_notify = _data17_->resume_target_destroy_notify;
	_data17_->resume = NULL;
	_data17_->resume_target = NULL;
	_data17_->resume_target_destroy_notify = NULL;
	g_idle_add_full (G_PRIORITY_HIGH_IDLE, _tmp5_, _tmp5__target, _tmp5__target_destroy_notify);
	result = NULL;
	return result;
}

static gpointer
____lambda65__gthread_func (gpointer self)
{
	gpointer result;
	result = ___lambda65_ (self);
	block17_data_unref (self);
	return result;
}

static gboolean
plank_worker_add_task_with_result_co (PlankWorkerAddTaskWithResultData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_data17_ = g_slice_new0 (Block17Data);
	_data_->_data17_->_ref_count_ = 1;
	_data_->_data17_->self = g_object_ref (_data_->self);
	_data_->_data17_->g_type = _data_->g_type;
	_data_->_data17_->g_dup_func = _data_->g_dup_func;
	_data_->_data17_->g_destroy_func = _data_->g_destroy_func;
	(_data_->_data17_->func_target_destroy_notify == NULL) ? NULL : (_data_->_data17_->func_target_destroy_notify (_data_->_data17_->func_target), NULL);
	_data_->_data17_->func = NULL;
	_data_->_data17_->func_target = NULL;
	_data_->_data17_->func_target_destroy_notify = NULL;
	_data_->_data17_->func = _data_->func;
	_data_->_data17_->func_target = _data_->func_target;
	_data_->_data17_->func_target_destroy_notify = _data_->func_target_destroy_notify;
	_data_->_data17_->_async_data_ = _data_;
	_data_->_data17_->resume = _plank_worker_add_task_with_result_co_gsource_func;
	_data_->_data17_->resume_target = _data_;
	_data_->_data17_->resume_target_destroy_notify = NULL;
	_data_->_data17_->err = NULL;
	_data_->_data17_->_result_ = NULL;
	{
		_data_->tfunc = ____lambda65__gthread_func;
		_data_->tfunc_target = block17_data_ref (_data_->_data17_);
		_data_->_tmp0_ = _data_->self->priv->pool;
		_data_->_tmp1_ = _data_->tfunc;
		_data_->_tmp1__target = _data_->tfunc_target;
		_data_->_tmp2_ = plank_task_new (_data_->_tmp1_, _data_->_tmp1__target, _data_->priority);
		g_thread_pool_push (_data_->_tmp0_, _data_->_tmp2_, &_data_->_inner_error0_);
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			if (_data_->_inner_error0_->domain == G_THREAD_ERROR) {
				goto __catch0_g_thread_error;
			}
			block17_data_unref (_data_->_data17_);
			_data_->_data17_ = NULL;
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
			g_clear_error (&_data_->_inner_error0_);
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
	}
	goto __finally0;
	__catch0_g_thread_error:
	{
		_data_->e = _data_->_inner_error0_;
		_data_->_inner_error0_ = NULL;
		_data_->_tmp3_ = _data_->e;
		_data_->_tmp4_ = _data_->_tmp3_->message;
		g_warning ("Worker.vala:137: %s", _data_->_tmp4_);
		_g_error_free0 (_data_->e);
	}
	__finally0:
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		block17_data_unref (_data_->_data17_);
		_data_->_data17_ = NULL;
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_state_ = 1;
	return FALSE;
	_state_1:
	;
	_data_->_tmp5_ = _data_->_data17_->err;
	if (_data_->_tmp5_ != NULL) {
		_data_->_tmp6_ = _data_->_data17_->err;
		_data_->_tmp7_ = _g_error_copy0 (_data_->_tmp6_);
		_data_->_inner_error0_ = _data_->_tmp7_;
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		block17_data_unref (_data_->_data17_);
		_data_->_data17_ = NULL;
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp8_ = _data_->_data17_->_result_;
	_data_->_tmp9_ = ((_data_->_tmp8_ != NULL) && (_data_->g_dup_func != NULL)) ? _data_->g_dup_func ((gpointer) _data_->_tmp8_) : ((gpointer) _data_->_tmp8_);
	_data_->result = _data_->_tmp9_;
	block17_data_unref (_data_->_data17_);
	_data_->_data17_ = NULL;
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
_plank_worker____lambda66_ (PlankWorker* self,
                            PlankTask* task)
{
	g_return_if_fail (task != NULL);
	plank_task_run (task);
	_plank_task_free0 (task);
}

static void
__plank_worker____lambda66__gfunc (gpointer data,
                                   gpointer self)
{
	_plank_worker____lambda66_ ((PlankWorker*) self, (PlankTask*) data);
}

static GObject *
plank_worker_constructor (GType type,
                          guint n_construct_properties,
                          GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	PlankWorker * self;
	GError* _inner_error0_ = NULL;
	parent_class = G_OBJECT_CLASS (plank_worker_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, PLANK_TYPE_WORKER, PlankWorker);
	{
		gint thread_count = 0;
		GThreadPool* _tmp0_ = NULL;
		GThreadPool* _tmp1_;
		GThreadPool* _tmp2_;
		GThreadPool* _tmp3_;
		g_thread_pool_set_max_unused_threads (0);
		thread_count = (gint) g_get_num_processors ();
		g_message ("Worker.vala:71: Using up to %i threads.", thread_count);
		_tmp1_ = g_thread_pool_new (__plank_worker____lambda66__gfunc, self, thread_count, FALSE, &_inner_error0_);
		_tmp0_ = _tmp1_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_THREAD_ERROR) {
				goto __catch0_g_thread_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
		}
		_tmp2_ = _tmp0_;
		_tmp0_ = NULL;
		_g_thread_pool_free0 (self->priv->pool);
		self->priv->pool = _tmp2_;
		_tmp3_ = self->priv->pool;
		g_thread_pool_set_sort_function (_tmp3_, (GCompareDataFunc) plank_worker_compare_task_priority, NULL);
		_g_thread_pool_free0 (_tmp0_);
	}
	goto __finally0;
	__catch0_g_thread_error:
	{
		GError* e = NULL;
		GError* _tmp4_;
		const gchar* _tmp5_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp4_ = e;
		_tmp5_ = _tmp4_->message;
		g_error ("Worker.vala:79: Creating ThreadPool failed! (%s)", _tmp5_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
	}
	return obj;
}

static void
plank_worker_class_init (PlankWorkerClass * klass,
                         gpointer klass_data)
{
	plank_worker_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &PlankWorker_private_offset);
	G_OBJECT_CLASS (klass)->constructor = plank_worker_constructor;
	G_OBJECT_CLASS (klass)->finalize = plank_worker_finalize;
}

static void
plank_worker_instance_init (PlankWorker * self,
                            gpointer klass)
{
	self->priv = plank_worker_get_instance_private (self);
}

static void
plank_worker_finalize (GObject * obj)
{
	PlankWorker * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, PLANK_TYPE_WORKER, PlankWorker);
	_g_thread_pool_free0 (self->priv->pool);
	G_OBJECT_CLASS (plank_worker_parent_class)->finalize (obj);
}

static GType
plank_worker_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (PlankWorkerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) plank_worker_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PlankWorker), 0, (GInstanceInitFunc) plank_worker_instance_init, NULL };
	GType plank_worker_type_id;
	plank_worker_type_id = g_type_register_static (G_TYPE_OBJECT, "PlankWorker", &g_define_type_info, 0);
	PlankWorker_private_offset = g_type_add_instance_private (plank_worker_type_id, sizeof (PlankWorkerPrivate));
	return plank_worker_type_id;
}

GType
plank_worker_get_type (void)
{
	static volatile gsize plank_worker_type_id__once = 0;
	if (g_once_init_enter (&plank_worker_type_id__once)) {
		GType plank_worker_type_id;
		plank_worker_type_id = plank_worker_get_type_once ();
		g_once_init_leave (&plank_worker_type_id__once, plank_worker_type_id);
	}
	return plank_worker_type_id__once;
}

