/* AbstractMain.c generated by valac 0.56.17, the Vala compiler
 * generated from AbstractMain.vala, do not modify */

/**/
/*  Copyright (C) 2011-2012 Robert Dyer, Rico Tzschichholz*/
/**/
/*  This file is part of Plank.*/
/**/
/*  Plank is free software: you can redistribute it and/or modify*/
/*  it under the terms of the GNU General Public License as published by*/
/*  the Free Software Foundation, either version 3 of the License, or*/
/*  (at your option) any later version.*/
/**/
/*  Plank is distributed in the hope that it will be useful,*/
/*  but WITHOUT ANY WARRANTY; without even the implied warranty of*/
/*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the*/
/*  GNU General Public License for more details.*/
/**/
/*  You should have received a copy of the GNU General Public License*/
/*  along with this program.  If not, see <http://www.gnu.org/licenses/>.*/
/**/

#define _GNU_SOURCE

#include "plank.h"
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gtk/gtk.h>
#include <gee.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <sys/utsname.h>
#include <libwnck/libwnck.h>
#include <cairo-gobject.h>
#include <pango/pango.h>
#include "plank-internal.h"
#include <gdk/gdk.h>
#include <glib/gi18n-lib.h>
#include "sys/prctl.h"
#include "config.h"
#include <signal.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	PLANK_ABSTRACT_MAIN_0_PROPERTY,
	PLANK_ABSTRACT_MAIN_BUILD_DATA_DIR_PROPERTY,
	PLANK_ABSTRACT_MAIN_BUILD_PKG_DATA_DIR_PROPERTY,
	PLANK_ABSTRACT_MAIN_BUILD_RELEASE_NAME_PROPERTY,
	PLANK_ABSTRACT_MAIN_BUILD_VERSION_PROPERTY,
	PLANK_ABSTRACT_MAIN_BUILD_VERSION_INFO_PROPERTY,
	PLANK_ABSTRACT_MAIN_PROGRAM_NAME_PROPERTY,
	PLANK_ABSTRACT_MAIN_EXEC_NAME_PROPERTY,
	PLANK_ABSTRACT_MAIN_APP_COPYRIGHT_PROPERTY,
	PLANK_ABSTRACT_MAIN_APP_DBUS_PROPERTY,
	PLANK_ABSTRACT_MAIN_APP_ICON_PROPERTY,
	PLANK_ABSTRACT_MAIN_APP_LAUNCHER_PROPERTY,
	PLANK_ABSTRACT_MAIN_MAIN_URL_PROPERTY,
	PLANK_ABSTRACT_MAIN_HELP_URL_PROPERTY,
	PLANK_ABSTRACT_MAIN_TRANSLATE_URL_PROPERTY,
	PLANK_ABSTRACT_MAIN_ABOUT_AUTHORS_PROPERTY,
	PLANK_ABSTRACT_MAIN_ABOUT_DOCUMENTERS_PROPERTY,
	PLANK_ABSTRACT_MAIN_ABOUT_ARTISTS_PROPERTY,
	PLANK_ABSTRACT_MAIN_ABOUT_TRANSLATORS_PROPERTY,
	PLANK_ABSTRACT_MAIN_ABOUT_LICENSE_TYPE_PROPERTY,
	PLANK_ABSTRACT_MAIN_NUM_PROPERTIES
};
static GParamSpec* plank_abstract_main_properties[PLANK_ABSTRACT_MAIN_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_variant_dict_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_dict_unref (var), NULL)))
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _PlankAbstractMainPrivate {
	gchar* _build_data_dir;
	gchar* _build_pkg_data_dir;
	gchar* _build_release_name;
	gchar* _build_version;
	gchar* _build_version_info;
	gchar* _program_name;
	gchar* _exec_name;
	gchar* _app_copyright;
	gchar* _app_dbus;
	gchar* _app_icon;
	gchar* _app_launcher;
	gchar* _main_url;
	gchar* _help_url;
	gchar* _translate_url;
	gchar** _about_authors;
	gint _about_authors_length1;
	gint __about_authors_size_;
	gchar** _about_documenters;
	gint _about_documenters_length1;
	gint __about_documenters_size_;
	gchar** _about_artists;
	gint _about_artists_length1;
	gint __about_artists_size_;
	gchar* _about_translators;
	GtkLicense _about_license_type;
	gchar* dock_name;
	GtkAboutDialog* about_dlg;
	PlankPreferencesWindow* preferences_dlg;
	PlankDockController* primary_dock;
	GeeArrayList* docks;
};

static gint PlankAbstractMain_private_offset;
static gpointer plank_abstract_main_parent_class = NULL;

static void plank_abstract_main_sig_handler (gint sig);
static void plank_abstract_main_real_activate (GApplication* base);
static gint plank_abstract_main_real_handle_local_options (GApplication* base,
                                                    GVariantDict* options);
static gint plank_abstract_main_real_command_line (GApplication* base,
                                            GApplicationCommandLine* command_line);
static void plank_abstract_main_real_startup (GApplication* base);
static void plank_abstract_main_real_initialize (PlankAbstractMain* self);
static void plank_abstract_main_real_create_docks (PlankAbstractMain* self);
static void plank_abstract_main_add_dock (PlankAbstractMain* self,
                                   PlankDockController* dock);
static PlankDockController* plank_abstract_main_create_dock (PlankAbstractMain* self,
                                                      const gchar* dock_name);
static gchar** _vala_array_dup2 (gchar** self,
                          gssize length);
static void plank_abstract_main_remove_dock (PlankAbstractMain* self,
                                      PlankDockController* dock);
static void plank_abstract_main_real_create_actions (PlankAbstractMain* self);
static void __lambda30_ (PlankAbstractMain* self);
static void ___lambda30__g_simple_action_activate (GSimpleAction* _sender,
                                            GVariant* parameter,
                                            gpointer self);
static void __lambda31_ (PlankAbstractMain* self);
static void ___lambda31__g_simple_action_activate (GSimpleAction* _sender,
                                            GVariant* parameter,
                                            gpointer self);
static void __lambda32_ (PlankAbstractMain* self);
static void plank_abstract_main_show_preferences (PlankAbstractMain* self,
                                           PlankDockController* controller);
static void ___lambda32__g_simple_action_activate (GSimpleAction* _sender,
                                            GVariant* parameter,
                                            gpointer self);
static void __lambda35_ (PlankAbstractMain* self);
static void plank_abstract_main_show_about (PlankAbstractMain* self);
static void ___lambda35__g_simple_action_activate (GSimpleAction* _sender,
                                            GVariant* parameter,
                                            gpointer self);
static void __lambda38_ (PlankAbstractMain* self);
static void ___lambda38__g_simple_action_activate (GSimpleAction* _sender,
                                            GVariant* parameter,
                                            gpointer self);
static void __lambda36_ (PlankAbstractMain* self);
static void ___lambda36__gtk_dialog_response (GtkDialog* _sender,
                                       gint response_id,
                                       gpointer self);
static void __lambda37_ (PlankAbstractMain* self);
static void ___lambda37__gtk_widget_hide (GtkWidget* _sender,
                                   gpointer self);
static void __lambda33_ (PlankAbstractMain* self);
static void ___lambda33__gtk_widget_destroy (GtkWidget* _sender,
                                      gpointer self);
static void __lambda34_ (PlankAbstractMain* self);
static void ___lambda34__gtk_widget_hide (GtkWidget* _sender,
                                   gpointer self);
static gchar** _vala_array_dup3 (gchar** self,
                          gssize length);
static gchar** _vala_array_dup4 (gchar** self,
                          gssize length);
static gchar** _vala_array_dup5 (gchar** self,
                          gssize length);
static GObject * plank_abstract_main_constructor (GType type,
                                           guint n_construct_properties,
                                           GObjectConstructParam * construct_properties);
static void _plank_abstract_main_sig_handler_sighandler_t (gint signal);
static void plank_abstract_main_finalize (GObject * obj);
static GType plank_abstract_main_get_type_once (void);
static void _vala_plank_abstract_main_get_property (GObject * object,
                                             guint property_id,
                                             GValue * value,
                                             GParamSpec * pspec);
static void _vala_plank_abstract_main_set_property (GObject * object,
                                             guint property_id,
                                             const GValue * value,
                                             GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);

static const GOptionEntry PLANK_ABSTRACT_MAIN_options[6] = {{"debug", 'd', (gint) 0, G_OPTION_ARG_NONE, NULL, "Enable debug logging", NULL}, {"verbose", 'v', (gint) 0, G_OPTION_ARG_NONE, NULL, "Enable verbose logging", NULL}, {"name", 'n', (gint) 0, G_OPTION_ARG_STRING, NULL, "The name of this dock. Defaults to \"dock1\".", NULL}, {"preferences", (gchar) 0, (gint) 0, G_OPTION_ARG_NONE, NULL, "Show preferences dialog of the just started or already running instanc" \
"e", NULL}, {"version", 'V', (gint) 0, G_OPTION_ARG_NONE, NULL, "Show the application's version", NULL}, {NULL}};

static inline gpointer
plank_abstract_main_get_instance_private (PlankAbstractMain* self)
{
	return G_STRUCT_MEMBER_P (self, PlankAbstractMain_private_offset);
}

static void
plank_abstract_main_sig_handler (gint sig)
{
	GApplication* _tmp0_;
	g_warning ("AbstractMain.vala:42: Caught signal (%d), exiting", sig);
	_tmp0_ = g_application_get_default ();
	g_application_quit (_tmp0_);
}

/**
 * {@inheritDoc}
 */
static void
plank_abstract_main_real_activate (GApplication* base)
{
	PlankAbstractMain * self;
	self = (PlankAbstractMain*) base;
}

/**
 * {@inheritDoc}
 */
static gint
plank_abstract_main_real_handle_local_options (GApplication* base,
                                               GVariantDict* options)
{
	PlankAbstractMain * self;
	const gchar* _tmp1_;
	gchar* _tmp2_ = NULL;
	gboolean _tmp3_;
	gint result;
	self = (PlankAbstractMain*) base;
	g_return_val_if_fail (options != NULL, 0);
	if (g_variant_dict_contains (options, "version")) {
		const gchar* _tmp0_;
		_tmp0_ = self->priv->_build_version;
		g_print ("%s\n", _tmp0_);
		result = 0;
		return result;
	}
	_tmp1_ = self->priv->_program_name;
	plank_logger_initialize (_tmp1_);
	if (g_variant_dict_contains (options, "verbose")) {
		plank_logger_set_DisplayLevel (PLANK_LOG_LEVEL_VERBOSE);
	} else {
		if (g_variant_dict_contains (options, "debug")) {
			plank_logger_set_DisplayLevel (PLANK_LOG_LEVEL_DEBUG);
		} else {
			plank_logger_set_DisplayLevel (PLANK_LOG_LEVEL_WARN);
		}
	}
	_tmp3_ = g_variant_dict_lookup (options, "name", "&s", &_tmp2_, NULL);
	_g_free0 (self->priv->dock_name);
	self->priv->dock_name = _tmp2_;
	if (_tmp3_) {
		const gchar* _tmp4_;
		const gchar* _tmp5_;
		gchar* _tmp6_;
		gchar* _tmp7_;
		_tmp4_ = self->priv->_app_dbus;
		_tmp5_ = self->priv->dock_name;
		_tmp6_ = g_strdup_printf ("%s.%s", _tmp4_, _tmp5_);
		_tmp7_ = _tmp6_;
		g_application_set_application_id ((GApplication*) self, _tmp7_);
		_g_free0 (_tmp7_);
	} else {
		gchar* _tmp8_;
		const gchar* _tmp9_;
		_tmp8_ = g_strdup ("");
		_g_free0 (self->priv->dock_name);
		self->priv->dock_name = _tmp8_;
		_tmp9_ = self->priv->_app_dbus;
		g_application_set_application_id ((GApplication*) self, _tmp9_);
	}
	result = -1;
	return result;
}

/**
 * {@inheritDoc}
 */
static gpointer
_g_variant_dict_ref0 (gpointer self)
{
	return self ? g_variant_dict_ref (self) : NULL;
}

static gint
plank_abstract_main_real_command_line (GApplication* base,
                                       GApplicationCommandLine* command_line)
{
	PlankAbstractMain * self;
	GVariantDict* options = NULL;
	GVariantDict* _tmp0_;
	GVariantDict* _tmp1_;
	GVariantDict* _tmp2_;
	gint result;
	self = (PlankAbstractMain*) base;
	g_return_val_if_fail (command_line != NULL, 0);
	_tmp0_ = g_application_command_line_get_options_dict (command_line);
	_tmp1_ = _g_variant_dict_ref0 (_tmp0_);
	options = _tmp1_;
	_tmp2_ = options;
	if (g_variant_dict_contains (_tmp2_, "preferences")) {
		g_action_group_activate_action ((GActionGroup*) self, "preferences", NULL);
	}
	result = 0;
	_g_variant_dict_unref0 (options);
	return result;
}

/**
 * {@inheritDoc}
 */
static void
plank_abstract_main_real_startup (GApplication* base)
{
	PlankAbstractMain * self;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
	const gchar* _tmp6_;
	const gchar* _tmp7_;
	const gchar* _tmp8_;
	const gchar* _tmp9_;
	struct utsname _tmp10_ = {0};
	const gchar* _tmp11_;
	const gchar* _tmp12_;
	const gchar* _tmp13_;
	const gchar* _tmp14_;
	const gchar* _tmp15_;
	PlankDockletManager* _tmp16_;
	self = (PlankAbstractMain*) base;
	_tmp0_ = self->priv->_build_data_dir;
	_vala_assert (_tmp0_ != NULL, "build_data_dir != null");
	_tmp1_ = self->priv->_build_pkg_data_dir;
	_vala_assert (_tmp1_ != NULL, "build_pkg_data_dir != null");
	_tmp2_ = self->priv->_build_release_name;
	_vala_assert (_tmp2_ != NULL, "build_release_name != null");
	_tmp3_ = self->priv->_build_version;
	_vala_assert (_tmp3_ != NULL, "build_version != null");
	_tmp4_ = self->priv->_build_version_info;
	_vala_assert (_tmp4_ != NULL, "build_version_info != null");
	_tmp5_ = self->priv->_program_name;
	_vala_assert (_tmp5_ != NULL, "program_name != null");
	_tmp6_ = self->priv->_exec_name;
	_vala_assert (_tmp6_ != NULL, "exec_name != null");
	_tmp7_ = self->priv->_app_dbus;
	_vala_assert (_tmp7_ != NULL, "app_dbus != null");
	G_APPLICATION_CLASS (plank_abstract_main_parent_class)->startup ((GApplication*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_application_get_type (), GtkApplication));
	if (!g_thread_supported ()) {
		g_critical ("AbstractMain.vala:227: Problem initializing thread support.");
	}
	_tmp8_ = self->priv->_program_name;
	_tmp9_ = self->priv->_build_version;
	g_message ("AbstractMain.vala:229: %s version: %s", _tmp8_, _tmp9_);
	uname (&_tmp10_);
	_tmp11_ = _tmp10_.release;
	g_message ("AbstractMain.vala:230: Kernel version: %s", _tmp11_);
	g_message ("AbstractMain.vala:231: GLib version: %u.%u.%u (%u.%u.%u)", glib_major_version, glib_minor_version, glib_micro_version, GLIB_MAJOR_VERSION, GLIB_MINOR_VERSION, GLIB_MICRO_VERSION);
	g_message ("AbstractMain.vala:234: GTK+ version: %u.%u.%u (%i.%i.%i)", gtk_get_major_version (), gtk_get_minor_version (), gtk_get_micro_version (), GTK_MAJOR_VERSION, GTK_MINOR_VERSION, GTK_MICRO_VERSION);
	g_message ("AbstractMain.vala:237: Wnck version: %d.%d.%d", WNCK_MAJOR_VERSION, WNCK_MINOR_VERSION, WNCK_MICRO_VERSION);
	_tmp12_ = cairo_version_string ();
	g_message ("AbstractMain.vala:238: Cairo version: %s", _tmp12_);
	_tmp13_ = pango_version_string ();
	g_message ("AbstractMain.vala:239: Pango version: %s", _tmp13_);
	g_message ("AbstractMain.vala:240: + Cairo/Gtk+ HiDPI support enabled");
	g_message ("AbstractMain.vala:245: + XInput Barriers support enabled");
	if (gtk_widget_get_default_direction () == GTK_TEXT_DIR_RTL) {
		g_message ("AbstractMain.vala:248: + RTL support enabled");
	}
	plank_internal_quarks_initialize ();
	plank_environment_initialize ();
	if (!plank_environment_is_session_type (PLANK_XDG_SESSION_TYPE_X11)) {
		g_critical ("AbstractMain.vala:255: Only X11 environments are supported.");
		g_application_quit ((GApplication*) self);
		return;
	}
	_tmp14_ = self->priv->_exec_name;
	_tmp15_ = self->priv->_build_pkg_data_dir;
	plank_paths_initialize (_tmp14_, _tmp15_);
	plank_window_control_initialize ();
	_tmp16_ = plank_docklet_manager_get_default ();
	plank_docklet_manager_load_docklets (_tmp16_);
	plank_abstract_main_initialize (self);
	plank_abstract_main_create_docks (self);
	plank_abstract_main_create_actions (self);
}

/**
 * Additional initializations before the dock is created.
 */
static void
plank_abstract_main_real_initialize (PlankAbstractMain* self)
{
}

void
plank_abstract_main_initialize (PlankAbstractMain* self)
{
	PlankAbstractMainClass* _klass_;
	g_return_if_fail (self != NULL);
	_klass_ = PLANK_ABSTRACT_MAIN_GET_CLASS (self);
	if (_klass_->initialize) {
		_klass_->initialize (self);
	}
}

/**
 * Creates the docks.
 */
static gchar**
_vala_array_dup2 (gchar** self,
                  gssize length)
{
	if (length >= 0) {
		gchar** result;
		gssize i;
		result = g_new0 (gchar*, length + 1);
		for (i = 0; i < length; i++) {
			gchar* _tmp0_;
			_tmp0_ = g_strdup (self[i]);
			result[i] = _tmp0_;
		}
		return result;
	}
	return NULL;
}

static gchar*
_vala_g_strjoinv (const gchar* separator,
                  gchar** str_array,
                  gint str_array_length1)
{
	gboolean _tmp0_ = FALSE;
	gchar* result;
	if (separator == NULL) {
		separator = "";
	}
	if (str_array != NULL) {
		gboolean _tmp1_ = FALSE;
		if (str_array_length1 > 0) {
			_tmp1_ = TRUE;
		} else {
			gboolean _tmp2_ = FALSE;
			if (str_array_length1 == -1) {
				const gchar* _tmp3_;
				_tmp3_ = str_array[0];
				_tmp2_ = _tmp3_ != NULL;
			} else {
				_tmp2_ = FALSE;
			}
			_tmp1_ = _tmp2_;
		}
		_tmp0_ = _tmp1_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		gint i = 0;
		gsize len = 0UL;
		gint _tmp16_;
		gint _tmp17_;
		const gchar* res = NULL;
		void* _tmp18_;
		const gchar* _tmp19_ = NULL;
		const gchar* _tmp20_;
		void* ptr = NULL;
		const gchar* _tmp22_;
		void* _tmp23_;
		const gchar* _tmp33_;
		len = (gsize) 1;
		{
			gboolean _tmp4_ = FALSE;
			i = 0;
			_tmp4_ = TRUE;
			while (TRUE) {
				gboolean _tmp6_ = FALSE;
				gboolean _tmp7_ = FALSE;
				gint _tmp10_ = 0;
				const gchar* _tmp11_;
				if (!_tmp4_) {
					gint _tmp5_;
					_tmp5_ = i;
					i = _tmp5_ + 1;
				}
				_tmp4_ = FALSE;
				if (str_array_length1 != -1) {
					_tmp7_ = i < str_array_length1;
				} else {
					_tmp7_ = FALSE;
				}
				if (_tmp7_) {
					_tmp6_ = TRUE;
				} else {
					gboolean _tmp8_ = FALSE;
					if (str_array_length1 == -1) {
						const gchar* _tmp9_;
						_tmp9_ = str_array[i];
						_tmp8_ = _tmp9_ != NULL;
					} else {
						_tmp8_ = FALSE;
					}
					_tmp6_ = _tmp8_;
				}
				if (!_tmp6_) {
					break;
				}
				_tmp11_ = str_array[i];
				if (_tmp11_ != NULL) {
					const gchar* _tmp12_;
					gint _tmp13_;
					gint _tmp14_;
					_tmp12_ = str_array[i];
					_tmp13_ = strlen ((const gchar*) _tmp12_);
					_tmp14_ = _tmp13_;
					_tmp10_ = _tmp14_;
				} else {
					_tmp10_ = 0;
				}
				len += (gsize) _tmp10_;
			}
		}
		if (i == 0) {
			gchar* _tmp15_;
			_tmp15_ = g_strdup ("");
			result = _tmp15_;
			return result;
		}
		str_array_length1 = i;
		_tmp16_ = strlen ((const gchar*) separator);
		_tmp17_ = _tmp16_;
		len += (gsize) (_tmp17_ * (i - 1));
		_tmp18_ = g_malloc (len);
		res = _tmp18_;
		_tmp20_ = str_array[0];
		if (_tmp20_ != NULL) {
			const gchar* _tmp21_;
			_tmp21_ = str_array[0];
			_tmp19_ = (const gchar*) _tmp21_;
		} else {
			_tmp19_ = "";
		}
		_tmp22_ = res;
		_tmp23_ = g_stpcpy ((void*) _tmp22_, _tmp19_);
		ptr = _tmp23_;
		{
			gboolean _tmp24_ = FALSE;
			i = 1;
			_tmp24_ = TRUE;
			while (TRUE) {
				void* _tmp26_;
				void* _tmp27_;
				const gchar* _tmp28_ = NULL;
				const gchar* _tmp29_;
				void* _tmp31_;
				void* _tmp32_;
				if (!_tmp24_) {
					gint _tmp25_;
					_tmp25_ = i;
					i = _tmp25_ + 1;
				}
				_tmp24_ = FALSE;
				if (!(i < str_array_length1)) {
					break;
				}
				_tmp26_ = ptr;
				_tmp27_ = g_stpcpy (_tmp26_, (const gchar*) separator);
				ptr = _tmp27_;
				_tmp29_ = str_array[i];
				if (_tmp29_ != NULL) {
					const gchar* _tmp30_;
					_tmp30_ = str_array[i];
					_tmp28_ = (const gchar*) _tmp30_;
				} else {
					_tmp28_ = "";
				}
				_tmp31_ = ptr;
				_tmp32_ = g_stpcpy (_tmp31_, _tmp28_);
				ptr = _tmp32_;
			}
		}
		_tmp33_ = res;
		res = NULL;
		result = (gchar*) _tmp33_;
		return result;
	} else {
		gchar* _tmp34_;
		_tmp34_ = g_strdup ("");
		result = _tmp34_;
		return result;
	}
}

static void
plank_abstract_main_real_create_docks (PlankAbstractMain* self)
{
	gboolean _tmp0_ = FALSE;
	const gchar* _tmp1_;
	GSettings* settings = NULL;
	GSettings* _tmp7_;
	gchar** enabled_docks = NULL;
	GSettings* _tmp8_;
	gchar** _tmp9_;
	gchar** _tmp10_;
	gint enabled_docks_length1;
	gint _enabled_docks_size_;
	gchar** _tmp11_;
	gint _tmp11__length1;
	gchar** _tmp21_;
	gint _tmp21__length1;
	gchar** _tmp22_;
	gint _tmp22__length1;
	gchar* _tmp23_;
	gchar* _tmp24_;
	gchar** _tmp25_;
	gint _tmp25__length1;
	_tmp1_ = self->priv->dock_name;
	if (_tmp1_ != NULL) {
		const gchar* _tmp2_;
		_tmp2_ = self->priv->dock_name;
		_tmp0_ = g_strcmp0 (_tmp2_, "") != 0;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		const gchar* _tmp3_;
		const gchar* _tmp4_;
		PlankDockController* _tmp5_;
		PlankDockController* _tmp6_;
		_tmp3_ = self->priv->dock_name;
		g_message ("AbstractMain.vala:282: Running with 1 dock ('%s')", _tmp3_);
		_tmp4_ = self->priv->dock_name;
		_tmp5_ = plank_abstract_main_create_dock (self, _tmp4_);
		_tmp6_ = _tmp5_;
		plank_abstract_main_add_dock (self, _tmp6_);
		_g_object_unref0 (_tmp6_);
		return;
	}
	_tmp7_ = plank_create_settings ("net.launchpad.plank", NULL);
	settings = _tmp7_;
	_tmp8_ = settings;
	_tmp10_ = _tmp9_ = g_settings_get_strv (_tmp8_, "enabled-docks");
	enabled_docks = _tmp10_;
	enabled_docks_length1 = _vala_array_length (_tmp9_);
	_enabled_docks_size_ = enabled_docks_length1;
	_tmp11_ = enabled_docks;
	_tmp11__length1 = enabled_docks_length1;
	if (_tmp11__length1 <= 0) {
		gchar* _tmp12_;
		gchar** _tmp13_;
		GSettings* _tmp14_;
		gchar** _tmp15_;
		gint _tmp15__length1;
		_tmp12_ = g_strdup ("dock1");
		_tmp13_ = g_new0 (gchar*, 1 + 1);
		_tmp13_[0] = _tmp12_;
		enabled_docks = (_vala_array_free (enabled_docks, enabled_docks_length1, (GDestroyNotify) g_free), NULL);
		enabled_docks = _tmp13_;
		enabled_docks_length1 = 1;
		_enabled_docks_size_ = enabled_docks_length1;
		_tmp14_ = settings;
		_tmp15_ = enabled_docks;
		_tmp15__length1 = enabled_docks_length1;
		g_settings_set_strv (_tmp14_, "enabled-docks", _tmp15_);
	} else {
		gchar** _tmp16_;
		gint _tmp16__length1;
		_tmp16_ = enabled_docks;
		_tmp16__length1 = enabled_docks_length1;
		if (_tmp16__length1 > 8) {
			gchar** _tmp17_;
			gint _tmp17__length1;
			gchar** _tmp18_;
			gint _tmp18__length1;
			GSettings* _tmp19_;
			gchar** _tmp20_;
			gint _tmp20__length1;
			_tmp17_ = enabled_docks;
			_tmp17__length1 = enabled_docks_length1;
			_tmp18_ = (_tmp17_ != NULL) ? _vala_array_dup2 (_tmp17_ + 0, 8 - 0) : _tmp17_;
			_tmp18__length1 = 8 - 0;
			enabled_docks = (_vala_array_free (enabled_docks, enabled_docks_length1, (GDestroyNotify) g_free), NULL);
			enabled_docks = _tmp18_;
			enabled_docks_length1 = _tmp18__length1;
			_enabled_docks_size_ = enabled_docks_length1;
			_tmp19_ = settings;
			_tmp20_ = enabled_docks;
			_tmp20__length1 = enabled_docks_length1;
			g_settings_set_strv (_tmp19_, "enabled-docks", _tmp20_);
		}
	}
	_tmp21_ = enabled_docks;
	_tmp21__length1 = enabled_docks_length1;
	_tmp22_ = enabled_docks;
	_tmp22__length1 = enabled_docks_length1;
	_tmp23_ = _vala_g_strjoinv ("', '", _tmp22_, (gint) _tmp22__length1);
	_tmp24_ = _tmp23_;
	g_message ("AbstractMain.vala:299: Running with %i docks ('%s')", _tmp21__length1, _tmp24_);
	_g_free0 (_tmp24_);
	_tmp25_ = enabled_docks;
	_tmp25__length1 = enabled_docks_length1;
	{
		gchar** dock_name_collection = NULL;
		gint dock_name_collection_length1 = 0;
		gint _dock_name_collection_size_ = 0;
		gint dock_name_it = 0;
		dock_name_collection = _tmp25_;
		dock_name_collection_length1 = _tmp25__length1;
		for (dock_name_it = 0; dock_name_it < dock_name_collection_length1; dock_name_it = dock_name_it + 1) {
			const gchar* dock_name = NULL;
			dock_name = dock_name_collection[dock_name_it];
			{
				const gchar* _tmp26_;
				PlankDockController* _tmp27_;
				PlankDockController* _tmp28_;
				_tmp26_ = dock_name;
				_tmp27_ = plank_abstract_main_create_dock (self, _tmp26_);
				_tmp28_ = _tmp27_;
				plank_abstract_main_add_dock (self, _tmp28_);
				_g_object_unref0 (_tmp28_);
			}
		}
	}
	enabled_docks = (_vala_array_free (enabled_docks, enabled_docks_length1, (GDestroyNotify) g_free), NULL);
	_g_object_unref0 (settings);
}

void
plank_abstract_main_create_docks (PlankAbstractMain* self)
{
	PlankAbstractMainClass* _klass_;
	g_return_if_fail (self != NULL);
	_klass_ = PLANK_ABSTRACT_MAIN_GET_CLASS (self);
	if (_klass_->create_docks) {
		_klass_->create_docks (self);
	}
}

static PlankDockController*
plank_abstract_main_create_dock (PlankAbstractMain* self,
                                 const gchar* dock_name)
{
	GFile* config_folder = NULL;
	GFile* _tmp0_;
	GFile* _tmp1_;
	GFile* _tmp2_;
	PlankDockController* dock = NULL;
	PlankDockController* _tmp3_;
	PlankDockController* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (dock_name != NULL, NULL);
	_tmp0_ = plank_paths_get_AppConfigFolder ();
	_tmp1_ = _tmp0_;
	_tmp2_ = g_file_get_child (_tmp1_, dock_name);
	config_folder = _tmp2_;
	plank_paths_ensure_directory_exists (config_folder);
	_tmp3_ = plank_dock_controller_new (dock_name, config_folder);
	dock = _tmp3_;
	plank_dock_controller_initialize (dock);
	result = dock;
	_g_object_unref0 (config_folder);
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
plank_abstract_main_add_dock (PlankAbstractMain* self,
                              PlankDockController* dock)
{
	gboolean _tmp0_ = FALSE;
	PlankDockController* _tmp1_;
	GeeArrayList* _tmp13_;
	PlankDockWindow* _tmp14_;
	PlankDockWindow* _tmp15_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (dock != NULL);
	_tmp1_ = self->priv->primary_dock;
	if (_tmp1_ == NULL) {
		_tmp0_ = TRUE;
	} else {
		gboolean _tmp2_ = FALSE;
		PlankDockController* _tmp3_;
		PlankDockPreferences* _tmp4_;
		PlankDockPreferences* _tmp5_;
		gboolean _tmp6_;
		gboolean _tmp7_;
		_tmp3_ = self->priv->primary_dock;
		_tmp4_ = plank_dock_controller_get_prefs (_tmp3_);
		_tmp5_ = _tmp4_;
		_tmp6_ = plank_dock_preferences_get_PinnedOnly (_tmp5_);
		_tmp7_ = _tmp6_;
		if (_tmp7_) {
			PlankDockPreferences* _tmp8_;
			PlankDockPreferences* _tmp9_;
			gboolean _tmp10_;
			gboolean _tmp11_;
			_tmp8_ = plank_dock_controller_get_prefs (dock);
			_tmp9_ = _tmp8_;
			_tmp10_ = plank_dock_preferences_get_PinnedOnly (_tmp9_);
			_tmp11_ = _tmp10_;
			_tmp2_ = !_tmp11_;
		} else {
			_tmp2_ = FALSE;
		}
		_tmp0_ = _tmp2_;
	}
	if (_tmp0_) {
		PlankDockController* _tmp12_;
		_tmp12_ = _g_object_ref0 (dock);
		_g_object_unref0 (self->priv->primary_dock);
		self->priv->primary_dock = _tmp12_;
	}
	_tmp13_ = self->priv->docks;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp13_, dock);
	_tmp14_ = plank_dock_controller_get_window (dock);
	_tmp15_ = _tmp14_;
	gtk_application_add_window ((GtkApplication*) self, (GtkWindow*) _tmp15_);
}

static void
plank_abstract_main_remove_dock (PlankAbstractMain* self,
                                 PlankDockController* dock)
{
	GeeArrayList* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	PlankDockWindow* _tmp3_;
	PlankDockWindow* _tmp4_;
	GeeArrayList* _tmp5_;
	PlankDockController* _tmp6_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (dock != NULL);
	_tmp0_ = self->priv->docks;
	_tmp1_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_ == 1) {
		return;
	}
	_tmp3_ = plank_dock_controller_get_window (dock);
	_tmp4_ = _tmp3_;
	gtk_application_remove_window ((GtkApplication*) self, (GtkWindow*) _tmp4_);
	_tmp5_ = self->priv->docks;
	gee_abstract_collection_remove ((GeeAbstractCollection*) _tmp5_, dock);
	_tmp6_ = self->priv->primary_dock;
	if (_tmp6_ == dock) {
		GeeArrayList* _tmp7_;
		gpointer _tmp8_;
		_tmp7_ = self->priv->docks;
		_tmp8_ = gee_abstract_list_get ((GeeAbstractList*) _tmp7_, 0);
		_g_object_unref0 (self->priv->primary_dock);
		self->priv->primary_dock = (PlankDockController*) _tmp8_;
	}
}

/**
 * Creates the actions and adds them to this {@link GLib.Application}.
 */
static void
__lambda30_ (PlankAbstractMain* self)
{
	PlankSystem* _tmp0_;
	const gchar* _tmp1_;
	_tmp0_ = plank_system_get_default ();
	_tmp1_ = self->priv->_help_url;
	plank_system_open_uri (_tmp0_, _tmp1_);
}

static void
___lambda30__g_simple_action_activate (GSimpleAction* _sender,
                                       GVariant* parameter,
                                       gpointer self)
{
	__lambda30_ ((PlankAbstractMain*) self);
}

static void
__lambda31_ (PlankAbstractMain* self)
{
	PlankSystem* _tmp0_;
	const gchar* _tmp1_;
	_tmp0_ = plank_system_get_default ();
	_tmp1_ = self->priv->_translate_url;
	plank_system_open_uri (_tmp0_, _tmp1_);
}

static void
___lambda31__g_simple_action_activate (GSimpleAction* _sender,
                                       GVariant* parameter,
                                       gpointer self)
{
	__lambda31_ ((PlankAbstractMain*) self);
}

static void
__lambda32_ (PlankAbstractMain* self)
{
	PlankDockController* _tmp0_;
	_tmp0_ = self->priv->primary_dock;
	plank_abstract_main_show_preferences (self, _tmp0_);
}

static void
___lambda32__g_simple_action_activate (GSimpleAction* _sender,
                                       GVariant* parameter,
                                       gpointer self)
{
	__lambda32_ ((PlankAbstractMain*) self);
}

static void
__lambda35_ (PlankAbstractMain* self)
{
	plank_abstract_main_show_about (self);
}

static void
___lambda35__g_simple_action_activate (GSimpleAction* _sender,
                                       GVariant* parameter,
                                       gpointer self)
{
	__lambda35_ ((PlankAbstractMain*) self);
}

static void
__lambda38_ (PlankAbstractMain* self)
{
	g_application_quit ((GApplication*) self);
}

static void
___lambda38__g_simple_action_activate (GSimpleAction* _sender,
                                       GVariant* parameter,
                                       gpointer self)
{
	__lambda38_ ((PlankAbstractMain*) self);
}

static void
plank_abstract_main_real_create_actions (PlankAbstractMain* self)
{
	GSimpleAction* action = NULL;
	GSimpleAction* _tmp0_;
	GSimpleAction* _tmp1_;
	GSimpleAction* _tmp2_;
	GSimpleAction* _tmp3_;
	GSimpleAction* _tmp4_;
	GSimpleAction* _tmp5_;
	GSimpleAction* _tmp6_;
	GSimpleAction* _tmp7_;
	GSimpleAction* _tmp8_;
	GSimpleAction* _tmp9_;
	GSimpleAction* _tmp10_;
	GSimpleAction* _tmp11_;
	GSimpleAction* _tmp12_;
	GSimpleAction* _tmp13_;
	GSimpleAction* _tmp14_;
	_tmp0_ = g_simple_action_new ("help", NULL);
	_g_object_unref0 (action);
	action = _tmp0_;
	_tmp1_ = action;
	g_signal_connect_object (_tmp1_, "activate", (GCallback) ___lambda30__g_simple_action_activate, self, 0);
	_tmp2_ = action;
	g_action_map_add_action ((GActionMap*) self, (GAction*) _tmp2_);
	_tmp3_ = g_simple_action_new ("translate", NULL);
	_g_object_unref0 (action);
	action = _tmp3_;
	_tmp4_ = action;
	g_signal_connect_object (_tmp4_, "activate", (GCallback) ___lambda31__g_simple_action_activate, self, 0);
	_tmp5_ = action;
	g_action_map_add_action ((GActionMap*) self, (GAction*) _tmp5_);
	_tmp6_ = g_simple_action_new ("preferences", NULL);
	_g_object_unref0 (action);
	action = _tmp6_;
	_tmp7_ = action;
	g_signal_connect_object (_tmp7_, "activate", (GCallback) ___lambda32__g_simple_action_activate, self, 0);
	_tmp8_ = action;
	g_action_map_add_action ((GActionMap*) self, (GAction*) _tmp8_);
	_tmp9_ = g_simple_action_new ("about", NULL);
	_g_object_unref0 (action);
	action = _tmp9_;
	_tmp10_ = action;
	g_signal_connect_object (_tmp10_, "activate", (GCallback) ___lambda35__g_simple_action_activate, self, 0);
	_tmp11_ = action;
	g_action_map_add_action ((GActionMap*) self, (GAction*) _tmp11_);
	_tmp12_ = g_simple_action_new ("quit", NULL);
	_g_object_unref0 (action);
	action = _tmp12_;
	_tmp13_ = action;
	g_signal_connect_object (_tmp13_, "activate", (GCallback) ___lambda38__g_simple_action_activate, self, 0);
	_tmp14_ = action;
	g_action_map_add_action ((GActionMap*) self, (GAction*) _tmp14_);
	_g_object_unref0 (action);
}

void
plank_abstract_main_create_actions (PlankAbstractMain* self)
{
	PlankAbstractMainClass* _klass_;
	g_return_if_fail (self != NULL);
	_klass_ = PLANK_ABSTRACT_MAIN_GET_CLASS (self);
	if (_klass_->create_actions) {
		_klass_->create_actions (self);
	}
}

/**
 * Is true if the launcher given is the launcher for this dock.
 *
 * @param launcher the launcher to test
 */
gboolean
plank_abstract_main_is_launcher_for_dock (PlankAbstractMain* self,
                                          const gchar* launcher)
{
	const gchar* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (launcher != NULL, FALSE);
	_tmp0_ = self->priv->_app_launcher;
	result = g_str_has_suffix (launcher, _tmp0_);
	return result;
}

/**
 * Displays the about dialog.
 */
static void
__lambda36_ (PlankAbstractMain* self)
{
	GtkAboutDialog* _tmp0_;
	_tmp0_ = self->priv->about_dlg;
	gtk_widget_hide ((GtkWidget*) _tmp0_);
}

static void
___lambda36__gtk_dialog_response (GtkDialog* _sender,
                                  gint response_id,
                                  gpointer self)
{
	__lambda36_ ((PlankAbstractMain*) self);
}

static void
__lambda37_ (PlankAbstractMain* self)
{
	GtkAboutDialog* _tmp0_;
	_tmp0_ = self->priv->about_dlg;
	gtk_widget_destroy ((GtkWidget*) _tmp0_);
	_g_object_unref0 (self->priv->about_dlg);
	self->priv->about_dlg = NULL;
}

static void
___lambda37__gtk_widget_hide (GtkWidget* _sender,
                              gpointer self)
{
	__lambda37_ ((PlankAbstractMain*) self);
}

static void
plank_abstract_main_show_about (PlankAbstractMain* self)
{
	GtkAboutDialog* _tmp0_;
	GtkAboutDialog* _tmp2_;
	GtkAboutDialog* _tmp3_;
	GtkAboutDialog* _tmp4_;
	GtkAboutDialog* _tmp5_;
	PlankDockController* _tmp6_;
	PlankDockWindow* _tmp7_;
	PlankDockWindow* _tmp8_;
	GtkAboutDialog* _tmp9_;
	const gchar* _tmp10_;
	GtkAboutDialog* _tmp11_;
	const gchar* _tmp12_;
	const gchar* _tmp13_;
	gchar* _tmp14_;
	gchar* _tmp15_;
	GtkAboutDialog* _tmp16_;
	const gchar* _tmp17_;
	GtkAboutDialog* _tmp18_;
	const gchar* _tmp19_;
	const gchar* _tmp20_;
	gchar* _tmp21_;
	gchar* _tmp22_;
	GtkAboutDialog* _tmp23_;
	const gchar* _tmp24_;
	const gchar* _tmp25_;
	gchar* _tmp26_;
	gchar* _tmp27_;
	GtkAboutDialog* _tmp28_;
	const gchar* _tmp29_;
	GtkAboutDialog* _tmp30_;
	gboolean _tmp31_ = FALSE;
	gchar** _tmp32_;
	gint _tmp32__length1;
	gint _tmp33_ = 0;
	gchar** _tmp34_;
	gint _tmp34__length1;
	gboolean _tmp42_ = FALSE;
	gchar** _tmp43_;
	gint _tmp43__length1;
	gint _tmp44_ = 0;
	gchar** _tmp45_;
	gint _tmp45__length1;
	gboolean _tmp53_ = FALSE;
	gchar** _tmp54_;
	gint _tmp54__length1;
	gint _tmp55_ = 0;
	gchar** _tmp56_;
	gint _tmp56__length1;
	gboolean _tmp64_ = FALSE;
	const gchar* _tmp65_;
	GtkAboutDialog* _tmp70_;
	GtkLicense _tmp71_;
	GtkAboutDialog* _tmp72_;
	GtkAboutDialog* _tmp73_;
	GtkAboutDialog* _tmp74_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->about_dlg;
	if (_tmp0_ != NULL) {
		GtkAboutDialog* _tmp1_;
		_tmp1_ = self->priv->about_dlg;
		gtk_widget_show_all ((GtkWidget*) _tmp1_);
		return;
	}
	_tmp2_ = (GtkAboutDialog*) gtk_about_dialog_new ();
	g_object_ref_sink (_tmp2_);
	_g_object_unref0 (self->priv->about_dlg);
	self->priv->about_dlg = _tmp2_;
	_tmp3_ = self->priv->about_dlg;
	g_object_set ((GtkWindow*) _tmp3_, "window-position", GTK_WIN_POS_CENTER, NULL);
	_tmp4_ = self->priv->about_dlg;
	gtk_window_set_gravity ((GtkWindow*) _tmp4_, GDK_GRAVITY_CENTER);
	_tmp5_ = self->priv->about_dlg;
	_tmp6_ = self->priv->primary_dock;
	_tmp7_ = plank_dock_controller_get_window (_tmp6_);
	_tmp8_ = _tmp7_;
	gtk_window_set_transient_for ((GtkWindow*) _tmp5_, (GtkWindow*) _tmp8_);
	_tmp9_ = self->priv->about_dlg;
	_tmp10_ = self->priv->_exec_name;
	gtk_about_dialog_set_program_name (_tmp9_, _tmp10_);
	_tmp11_ = self->priv->about_dlg;
	_tmp12_ = self->priv->_build_version;
	_tmp13_ = self->priv->_build_version_info;
	_tmp14_ = g_strdup_printf ("%s\n%s", _tmp12_, _tmp13_);
	_tmp15_ = _tmp14_;
	gtk_about_dialog_set_version (_tmp11_, _tmp15_);
	_g_free0 (_tmp15_);
	_tmp16_ = self->priv->about_dlg;
	_tmp17_ = self->priv->_app_icon;
	gtk_about_dialog_set_logo_icon_name (_tmp16_, _tmp17_);
	_tmp18_ = self->priv->about_dlg;
	_tmp19_ = self->priv->_program_name;
	_tmp20_ = self->priv->_build_release_name;
	_tmp21_ = g_strdup_printf ("%s. %s", _tmp19_, _tmp20_);
	_tmp22_ = _tmp21_;
	gtk_about_dialog_set_comments (_tmp18_, _tmp22_);
	_g_free0 (_tmp22_);
	_tmp23_ = self->priv->about_dlg;
	_tmp24_ = self->priv->_app_copyright;
	_tmp25_ = self->priv->_program_name;
	_tmp26_ = g_strdup_printf ("Copyright © %s %s Developers", _tmp24_, _tmp25_);
	_tmp27_ = _tmp26_;
	gtk_about_dialog_set_copyright (_tmp23_, _tmp27_);
	_g_free0 (_tmp27_);
	_tmp28_ = self->priv->about_dlg;
	_tmp29_ = self->priv->_main_url;
	gtk_about_dialog_set_website (_tmp28_, _tmp29_);
	_tmp30_ = self->priv->about_dlg;
	gtk_about_dialog_set_website_label (_tmp30_, "Website");
	_tmp32_ = plank_abstract_main_get_about_authors (self, &_tmp33_);
	_tmp32__length1 = _tmp33_;
	_tmp34_ = _tmp32_;
	_tmp34__length1 = _tmp32__length1;
	if (_tmp34_ != NULL) {
		gchar** _tmp35_;
		gint _tmp35__length1;
		gint _tmp36_ = 0;
		gchar** _tmp37_;
		gint _tmp37__length1;
		_tmp35_ = plank_abstract_main_get_about_authors (self, &_tmp36_);
		_tmp35__length1 = _tmp36_;
		_tmp37_ = _tmp35_;
		_tmp37__length1 = _tmp35__length1;
		_tmp31_ = _tmp37__length1 > 0;
	} else {
		_tmp31_ = FALSE;
	}
	if (_tmp31_) {
		GtkAboutDialog* _tmp38_;
		gchar** _tmp39_;
		gint _tmp39__length1;
		gint _tmp40_ = 0;
		gchar** _tmp41_;
		gint _tmp41__length1;
		_tmp38_ = self->priv->about_dlg;
		_tmp39_ = plank_abstract_main_get_about_authors (self, &_tmp40_);
		_tmp39__length1 = _tmp40_;
		_tmp41_ = _tmp39_;
		_tmp41__length1 = _tmp39__length1;
		gtk_about_dialog_set_authors (_tmp38_, _tmp41_);
	}
	_tmp43_ = plank_abstract_main_get_about_documenters (self, &_tmp44_);
	_tmp43__length1 = _tmp44_;
	_tmp45_ = _tmp43_;
	_tmp45__length1 = _tmp43__length1;
	if (_tmp45_ != NULL) {
		gchar** _tmp46_;
		gint _tmp46__length1;
		gint _tmp47_ = 0;
		gchar** _tmp48_;
		gint _tmp48__length1;
		_tmp46_ = plank_abstract_main_get_about_documenters (self, &_tmp47_);
		_tmp46__length1 = _tmp47_;
		_tmp48_ = _tmp46_;
		_tmp48__length1 = _tmp46__length1;
		_tmp42_ = _tmp48__length1 > 0;
	} else {
		_tmp42_ = FALSE;
	}
	if (_tmp42_) {
		GtkAboutDialog* _tmp49_;
		gchar** _tmp50_;
		gint _tmp50__length1;
		gint _tmp51_ = 0;
		gchar** _tmp52_;
		gint _tmp52__length1;
		_tmp49_ = self->priv->about_dlg;
		_tmp50_ = plank_abstract_main_get_about_documenters (self, &_tmp51_);
		_tmp50__length1 = _tmp51_;
		_tmp52_ = _tmp50_;
		_tmp52__length1 = _tmp50__length1;
		gtk_about_dialog_set_documenters (_tmp49_, _tmp52_);
	}
	_tmp54_ = plank_abstract_main_get_about_artists (self, &_tmp55_);
	_tmp54__length1 = _tmp55_;
	_tmp56_ = _tmp54_;
	_tmp56__length1 = _tmp54__length1;
	if (_tmp56_ != NULL) {
		gchar** _tmp57_;
		gint _tmp57__length1;
		gint _tmp58_ = 0;
		gchar** _tmp59_;
		gint _tmp59__length1;
		_tmp57_ = plank_abstract_main_get_about_artists (self, &_tmp58_);
		_tmp57__length1 = _tmp58_;
		_tmp59_ = _tmp57_;
		_tmp59__length1 = _tmp57__length1;
		_tmp53_ = _tmp59__length1 > 0;
	} else {
		_tmp53_ = FALSE;
	}
	if (_tmp53_) {
		GtkAboutDialog* _tmp60_;
		gchar** _tmp61_;
		gint _tmp61__length1;
		gint _tmp62_ = 0;
		gchar** _tmp63_;
		gint _tmp63__length1;
		_tmp60_ = self->priv->about_dlg;
		_tmp61_ = plank_abstract_main_get_about_artists (self, &_tmp62_);
		_tmp61__length1 = _tmp62_;
		_tmp63_ = _tmp61_;
		_tmp63__length1 = _tmp61__length1;
		gtk_about_dialog_set_artists (_tmp60_, _tmp63_);
	}
	_tmp65_ = self->priv->_about_translators;
	if (_tmp65_ != NULL) {
		const gchar* _tmp66_;
		_tmp66_ = self->priv->_about_translators;
		_tmp64_ = g_strcmp0 (_tmp66_, "") != 0;
	} else {
		_tmp64_ = FALSE;
	}
	if (_tmp64_) {
		GtkAboutDialog* _tmp67_;
		const gchar* _tmp68_;
		_tmp67_ = self->priv->about_dlg;
		_tmp68_ = self->priv->_about_translators;
		gtk_about_dialog_set_translator_credits (_tmp67_, _tmp68_);
	} else {
		GtkAboutDialog* _tmp69_;
		_tmp69_ = self->priv->about_dlg;
		gtk_about_dialog_set_translator_credits (_tmp69_, _ ("translator-credits"));
	}
	_tmp70_ = self->priv->about_dlg;
	_tmp71_ = self->priv->_about_license_type;
	gtk_about_dialog_set_license_type (_tmp70_, _tmp71_);
	_tmp72_ = self->priv->about_dlg;
	g_signal_connect_object ((GtkDialog*) _tmp72_, "response", (GCallback) ___lambda36__gtk_dialog_response, self, 0);
	_tmp73_ = self->priv->about_dlg;
	g_signal_connect_object ((GtkWidget*) _tmp73_, "hide", (GCallback) ___lambda37__gtk_widget_hide, self, 0);
	_tmp74_ = self->priv->about_dlg;
	gtk_widget_show_all ((GtkWidget*) _tmp74_);
}

/**
 * Displays the preferences dialog.
 *
 * @param controller the dock to show preferences for
 */
static void
__lambda33_ (PlankAbstractMain* self)
{
	_g_object_unref0 (self->priv->preferences_dlg);
	self->priv->preferences_dlg = NULL;
}

static void
___lambda33__gtk_widget_destroy (GtkWidget* _sender,
                                 gpointer self)
{
	__lambda33_ ((PlankAbstractMain*) self);
}

static void
__lambda34_ (PlankAbstractMain* self)
{
	PlankPreferencesWindow* _tmp0_;
	_tmp0_ = self->priv->preferences_dlg;
	gtk_widget_destroy ((GtkWidget*) _tmp0_);
	_g_object_unref0 (self->priv->preferences_dlg);
	self->priv->preferences_dlg = NULL;
}

static void
___lambda34__gtk_widget_hide (GtkWidget* _sender,
                              gpointer self)
{
	__lambda34_ ((PlankAbstractMain*) self);
}

static void
plank_abstract_main_show_preferences (PlankAbstractMain* self,
                                      PlankDockController* controller)
{
	PlankPreferencesWindow* _tmp0_;
	PlankPreferencesWindow* _tmp6_;
	PlankPreferencesWindow* _tmp7_;
	PlankDockWindow* _tmp8_;
	PlankDockWindow* _tmp9_;
	PlankPreferencesWindow* _tmp10_;
	PlankPreferencesWindow* _tmp11_;
	PlankPreferencesWindow* _tmp12_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (controller != NULL);
	_tmp0_ = self->priv->preferences_dlg;
	if (_tmp0_ != NULL) {
		PlankPreferencesWindow* _tmp1_;
		PlankPreferencesWindow* _tmp2_;
		PlankDockWindow* _tmp3_;
		PlankDockWindow* _tmp4_;
		PlankPreferencesWindow* _tmp5_;
		_tmp1_ = self->priv->preferences_dlg;
		plank_preferences_window_set_controller (_tmp1_, controller);
		_tmp2_ = self->priv->preferences_dlg;
		_tmp3_ = plank_dock_controller_get_window (controller);
		_tmp4_ = _tmp3_;
		gtk_window_set_transient_for ((GtkWindow*) _tmp2_, (GtkWindow*) _tmp4_);
		_tmp5_ = self->priv->preferences_dlg;
		gtk_widget_show ((GtkWidget*) _tmp5_);
		return;
	}
	_tmp6_ = plank_preferences_window_new (controller);
	g_object_ref_sink (_tmp6_);
	_g_object_unref0 (self->priv->preferences_dlg);
	self->priv->preferences_dlg = _tmp6_;
	_tmp7_ = self->priv->preferences_dlg;
	_tmp8_ = plank_dock_controller_get_window (controller);
	_tmp9_ = _tmp8_;
	gtk_window_set_transient_for ((GtkWindow*) _tmp7_, (GtkWindow*) _tmp9_);
	_tmp10_ = self->priv->preferences_dlg;
	g_signal_connect_object ((GtkWidget*) _tmp10_, "destroy", (GCallback) ___lambda33__gtk_widget_destroy, self, 0);
	_tmp11_ = self->priv->preferences_dlg;
	g_signal_connect_object ((GtkWidget*) _tmp11_, "hide", (GCallback) ___lambda34__gtk_widget_hide, self, 0);
	_tmp12_ = self->priv->preferences_dlg;
	gtk_widget_show ((GtkWidget*) _tmp12_);
}

PlankAbstractMain*
plank_abstract_main_construct (GType object_type)
{
	PlankAbstractMain * self = NULL;
	self = (PlankAbstractMain*) g_object_new (object_type, NULL);
	return self;
}

const gchar*
plank_abstract_main_get_build_data_dir (PlankAbstractMain* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_build_data_dir;
	result = _tmp0_;
	return result;
}

static void
plank_abstract_main_set_build_data_dir (PlankAbstractMain* self,
                                        const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = plank_abstract_main_get_build_data_dir (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_build_data_dir);
		self->priv->_build_data_dir = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, plank_abstract_main_properties[PLANK_ABSTRACT_MAIN_BUILD_DATA_DIR_PROPERTY]);
	}
}

const gchar*
plank_abstract_main_get_build_pkg_data_dir (PlankAbstractMain* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_build_pkg_data_dir;
	result = _tmp0_;
	return result;
}

static void
plank_abstract_main_set_build_pkg_data_dir (PlankAbstractMain* self,
                                            const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = plank_abstract_main_get_build_pkg_data_dir (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_build_pkg_data_dir);
		self->priv->_build_pkg_data_dir = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, plank_abstract_main_properties[PLANK_ABSTRACT_MAIN_BUILD_PKG_DATA_DIR_PROPERTY]);
	}
}

const gchar*
plank_abstract_main_get_build_release_name (PlankAbstractMain* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_build_release_name;
	result = _tmp0_;
	return result;
}

static void
plank_abstract_main_set_build_release_name (PlankAbstractMain* self,
                                            const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = plank_abstract_main_get_build_release_name (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_build_release_name);
		self->priv->_build_release_name = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, plank_abstract_main_properties[PLANK_ABSTRACT_MAIN_BUILD_RELEASE_NAME_PROPERTY]);
	}
}

const gchar*
plank_abstract_main_get_build_version (PlankAbstractMain* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_build_version;
	result = _tmp0_;
	return result;
}

static void
plank_abstract_main_set_build_version (PlankAbstractMain* self,
                                       const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = plank_abstract_main_get_build_version (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_build_version);
		self->priv->_build_version = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, plank_abstract_main_properties[PLANK_ABSTRACT_MAIN_BUILD_VERSION_PROPERTY]);
	}
}

const gchar*
plank_abstract_main_get_build_version_info (PlankAbstractMain* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_build_version_info;
	result = _tmp0_;
	return result;
}

static void
plank_abstract_main_set_build_version_info (PlankAbstractMain* self,
                                            const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = plank_abstract_main_get_build_version_info (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_build_version_info);
		self->priv->_build_version_info = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, plank_abstract_main_properties[PLANK_ABSTRACT_MAIN_BUILD_VERSION_INFO_PROPERTY]);
	}
}

const gchar*
plank_abstract_main_get_program_name (PlankAbstractMain* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_program_name;
	result = _tmp0_;
	return result;
}

static void
plank_abstract_main_set_program_name (PlankAbstractMain* self,
                                      const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = plank_abstract_main_get_program_name (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_program_name);
		self->priv->_program_name = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, plank_abstract_main_properties[PLANK_ABSTRACT_MAIN_PROGRAM_NAME_PROPERTY]);
	}
}

const gchar*
plank_abstract_main_get_exec_name (PlankAbstractMain* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_exec_name;
	result = _tmp0_;
	return result;
}

static void
plank_abstract_main_set_exec_name (PlankAbstractMain* self,
                                   const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = plank_abstract_main_get_exec_name (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_exec_name);
		self->priv->_exec_name = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, plank_abstract_main_properties[PLANK_ABSTRACT_MAIN_EXEC_NAME_PROPERTY]);
	}
}

const gchar*
plank_abstract_main_get_app_copyright (PlankAbstractMain* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_app_copyright;
	result = _tmp0_;
	return result;
}

static void
plank_abstract_main_set_app_copyright (PlankAbstractMain* self,
                                       const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = plank_abstract_main_get_app_copyright (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_app_copyright);
		self->priv->_app_copyright = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, plank_abstract_main_properties[PLANK_ABSTRACT_MAIN_APP_COPYRIGHT_PROPERTY]);
	}
}

const gchar*
plank_abstract_main_get_app_dbus (PlankAbstractMain* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_app_dbus;
	result = _tmp0_;
	return result;
}

static void
plank_abstract_main_set_app_dbus (PlankAbstractMain* self,
                                  const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = plank_abstract_main_get_app_dbus (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_app_dbus);
		self->priv->_app_dbus = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, plank_abstract_main_properties[PLANK_ABSTRACT_MAIN_APP_DBUS_PROPERTY]);
	}
}

const gchar*
plank_abstract_main_get_app_icon (PlankAbstractMain* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_app_icon;
	result = _tmp0_;
	return result;
}

static void
plank_abstract_main_set_app_icon (PlankAbstractMain* self,
                                  const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = plank_abstract_main_get_app_icon (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_app_icon);
		self->priv->_app_icon = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, plank_abstract_main_properties[PLANK_ABSTRACT_MAIN_APP_ICON_PROPERTY]);
	}
}

const gchar*
plank_abstract_main_get_app_launcher (PlankAbstractMain* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_app_launcher;
	result = _tmp0_;
	return result;
}

static void
plank_abstract_main_set_app_launcher (PlankAbstractMain* self,
                                      const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = plank_abstract_main_get_app_launcher (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_app_launcher);
		self->priv->_app_launcher = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, plank_abstract_main_properties[PLANK_ABSTRACT_MAIN_APP_LAUNCHER_PROPERTY]);
	}
}

const gchar*
plank_abstract_main_get_main_url (PlankAbstractMain* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_main_url;
	result = _tmp0_;
	return result;
}

void
plank_abstract_main_set_main_url (PlankAbstractMain* self,
                                  const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = plank_abstract_main_get_main_url (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_main_url);
		self->priv->_main_url = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, plank_abstract_main_properties[PLANK_ABSTRACT_MAIN_MAIN_URL_PROPERTY]);
	}
}

const gchar*
plank_abstract_main_get_help_url (PlankAbstractMain* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_help_url;
	result = _tmp0_;
	return result;
}

void
plank_abstract_main_set_help_url (PlankAbstractMain* self,
                                  const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = plank_abstract_main_get_help_url (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_help_url);
		self->priv->_help_url = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, plank_abstract_main_properties[PLANK_ABSTRACT_MAIN_HELP_URL_PROPERTY]);
	}
}

const gchar*
plank_abstract_main_get_translate_url (PlankAbstractMain* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_translate_url;
	result = _tmp0_;
	return result;
}

void
plank_abstract_main_set_translate_url (PlankAbstractMain* self,
                                       const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = plank_abstract_main_get_translate_url (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_translate_url);
		self->priv->_translate_url = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, plank_abstract_main_properties[PLANK_ABSTRACT_MAIN_TRANSLATE_URL_PROPERTY]);
	}
}

gchar**
plank_abstract_main_get_about_authors (PlankAbstractMain* self,
                                       gint* result_length1)
{
	gchar** result;
	gchar** _tmp0_;
	gint _tmp0__length1;
	gchar** _tmp1_;
	gint _tmp1__length1;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_about_authors;
	_tmp0__length1 = self->priv->_about_authors_length1;
	_tmp1_ = _tmp0_;
	_tmp1__length1 = _tmp0__length1;
	if (result_length1) {
		*result_length1 = _tmp1__length1;
	}
	result = _tmp1_;
	return result;
}

static gchar**
_vala_array_dup3 (gchar** self,
                  gssize length)
{
	if (length >= 0) {
		gchar** result;
		gssize i;
		result = g_new0 (gchar*, length + 1);
		for (i = 0; i < length; i++) {
			gchar* _tmp0_;
			_tmp0_ = g_strdup (self[i]);
			result[i] = _tmp0_;
		}
		return result;
	}
	return NULL;
}

void
plank_abstract_main_set_about_authors (PlankAbstractMain* self,
                                       gchar** value,
                                       gint value_length1)
{
	gchar** old_value;
	gint old_value_length;
	g_return_if_fail (self != NULL);
	old_value = plank_abstract_main_get_about_authors (self, &old_value_length);
	if (old_value != value) {
		gchar** _tmp0_;
		gint _tmp0__length1;
		_tmp0_ = (value != NULL) ? _vala_array_dup3 (value, value_length1) : value;
		_tmp0__length1 = value_length1;
		self->priv->_about_authors = (_vala_array_free (self->priv->_about_authors, self->priv->_about_authors_length1, (GDestroyNotify) g_free), NULL);
		self->priv->_about_authors = _tmp0_;
		self->priv->_about_authors_length1 = _tmp0__length1;
		self->priv->__about_authors_size_ = self->priv->_about_authors_length1;
		g_object_notify_by_pspec ((GObject *) self, plank_abstract_main_properties[PLANK_ABSTRACT_MAIN_ABOUT_AUTHORS_PROPERTY]);
	}
}

gchar**
plank_abstract_main_get_about_documenters (PlankAbstractMain* self,
                                           gint* result_length1)
{
	gchar** result;
	gchar** _tmp0_;
	gint _tmp0__length1;
	gchar** _tmp1_;
	gint _tmp1__length1;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_about_documenters;
	_tmp0__length1 = self->priv->_about_documenters_length1;
	_tmp1_ = _tmp0_;
	_tmp1__length1 = _tmp0__length1;
	if (result_length1) {
		*result_length1 = _tmp1__length1;
	}
	result = _tmp1_;
	return result;
}

static gchar**
_vala_array_dup4 (gchar** self,
                  gssize length)
{
	if (length >= 0) {
		gchar** result;
		gssize i;
		result = g_new0 (gchar*, length + 1);
		for (i = 0; i < length; i++) {
			gchar* _tmp0_;
			_tmp0_ = g_strdup (self[i]);
			result[i] = _tmp0_;
		}
		return result;
	}
	return NULL;
}

void
plank_abstract_main_set_about_documenters (PlankAbstractMain* self,
                                           gchar** value,
                                           gint value_length1)
{
	gchar** old_value;
	gint old_value_length;
	g_return_if_fail (self != NULL);
	old_value = plank_abstract_main_get_about_documenters (self, &old_value_length);
	if (old_value != value) {
		gchar** _tmp0_;
		gint _tmp0__length1;
		_tmp0_ = (value != NULL) ? _vala_array_dup4 (value, value_length1) : value;
		_tmp0__length1 = value_length1;
		self->priv->_about_documenters = (_vala_array_free (self->priv->_about_documenters, self->priv->_about_documenters_length1, (GDestroyNotify) g_free), NULL);
		self->priv->_about_documenters = _tmp0_;
		self->priv->_about_documenters_length1 = _tmp0__length1;
		self->priv->__about_documenters_size_ = self->priv->_about_documenters_length1;
		g_object_notify_by_pspec ((GObject *) self, plank_abstract_main_properties[PLANK_ABSTRACT_MAIN_ABOUT_DOCUMENTERS_PROPERTY]);
	}
}

gchar**
plank_abstract_main_get_about_artists (PlankAbstractMain* self,
                                       gint* result_length1)
{
	gchar** result;
	gchar** _tmp0_;
	gint _tmp0__length1;
	gchar** _tmp1_;
	gint _tmp1__length1;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_about_artists;
	_tmp0__length1 = self->priv->_about_artists_length1;
	_tmp1_ = _tmp0_;
	_tmp1__length1 = _tmp0__length1;
	if (result_length1) {
		*result_length1 = _tmp1__length1;
	}
	result = _tmp1_;
	return result;
}

static gchar**
_vala_array_dup5 (gchar** self,
                  gssize length)
{
	if (length >= 0) {
		gchar** result;
		gssize i;
		result = g_new0 (gchar*, length + 1);
		for (i = 0; i < length; i++) {
			gchar* _tmp0_;
			_tmp0_ = g_strdup (self[i]);
			result[i] = _tmp0_;
		}
		return result;
	}
	return NULL;
}

void
plank_abstract_main_set_about_artists (PlankAbstractMain* self,
                                       gchar** value,
                                       gint value_length1)
{
	gchar** old_value;
	gint old_value_length;
	g_return_if_fail (self != NULL);
	old_value = plank_abstract_main_get_about_artists (self, &old_value_length);
	if (old_value != value) {
		gchar** _tmp0_;
		gint _tmp0__length1;
		_tmp0_ = (value != NULL) ? _vala_array_dup5 (value, value_length1) : value;
		_tmp0__length1 = value_length1;
		self->priv->_about_artists = (_vala_array_free (self->priv->_about_artists, self->priv->_about_artists_length1, (GDestroyNotify) g_free), NULL);
		self->priv->_about_artists = _tmp0_;
		self->priv->_about_artists_length1 = _tmp0__length1;
		self->priv->__about_artists_size_ = self->priv->_about_artists_length1;
		g_object_notify_by_pspec ((GObject *) self, plank_abstract_main_properties[PLANK_ABSTRACT_MAIN_ABOUT_ARTISTS_PROPERTY]);
	}
}

const gchar*
plank_abstract_main_get_about_translators (PlankAbstractMain* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_about_translators;
	result = _tmp0_;
	return result;
}

void
plank_abstract_main_set_about_translators (PlankAbstractMain* self,
                                           const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = plank_abstract_main_get_about_translators (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_about_translators);
		self->priv->_about_translators = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, plank_abstract_main_properties[PLANK_ABSTRACT_MAIN_ABOUT_TRANSLATORS_PROPERTY]);
	}
}

GtkLicense
plank_abstract_main_get_about_license_type (PlankAbstractMain* self)
{
	GtkLicense result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_about_license_type;
	return result;
}

void
plank_abstract_main_set_about_license_type (PlankAbstractMain* self,
                                            GtkLicense value)
{
	GtkLicense old_value;
	g_return_if_fail (self != NULL);
	old_value = plank_abstract_main_get_about_license_type (self);
	if (old_value != value) {
		self->priv->_about_license_type = value;
		g_object_notify_by_pspec ((GObject *) self, plank_abstract_main_properties[PLANK_ABSTRACT_MAIN_ABOUT_LICENSE_TYPE_PROPERTY]);
	}
}

static GObject *
plank_abstract_main_constructor (GType type,
                                 guint n_construct_properties,
                                 GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	PlankAbstractMain * self;
	GeeArrayList* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	parent_class = G_OBJECT_CLASS (plank_abstract_main_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, PLANK_TYPE_ABSTRACT_MAIN, PlankAbstractMain);
	g_application_set_flags ((GApplication*) self, G_APPLICATION_HANDLES_COMMAND_LINE);
	_tmp0_ = gee_array_list_new (PLANK_TYPE_DOCK_CONTROLLER, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->docks);
	self->priv->docks = _tmp0_;
	_tmp1_ = self->priv->_exec_name;
	prctl (15, _tmp1_);
	_tmp2_ = self->priv->_exec_name;
	g_set_prgname (_tmp2_);
	bindtextdomain (GETTEXT_PACKAGE, DATADIR "/locale");
	bind_textdomain_codeset (GETTEXT_PACKAGE, "UTF-8");
	g_application_add_main_option_entries ((GApplication*) self, PLANK_ABSTRACT_MAIN_options);
	return obj;
}

static void
_plank_abstract_main_sig_handler_sighandler_t (gint signal)
{
	plank_abstract_main_sig_handler (signal);
}

static void
plank_abstract_main_class_init (PlankAbstractMainClass * klass,
                                gpointer klass_data)
{
	plank_abstract_main_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &PlankAbstractMain_private_offset);
	((GApplicationClass *) klass)->activate = (void (*) (GApplication*)) plank_abstract_main_real_activate;
	((GApplicationClass *) klass)->handle_local_options = (gint (*) (GApplication*, GVariantDict*)) plank_abstract_main_real_handle_local_options;
	((GApplicationClass *) klass)->command_line = (gint (*) (GApplication*, GApplicationCommandLine*)) plank_abstract_main_real_command_line;
	((GApplicationClass *) klass)->startup = (void (*) (GApplication*)) plank_abstract_main_real_startup;
	((PlankAbstractMainClass *) klass)->initialize = (void (*) (PlankAbstractMain*)) plank_abstract_main_real_initialize;
	((PlankAbstractMainClass *) klass)->create_docks = (void (*) (PlankAbstractMain*)) plank_abstract_main_real_create_docks;
	((PlankAbstractMainClass *) klass)->create_actions = (void (*) (PlankAbstractMain*)) plank_abstract_main_real_create_actions;
	G_OBJECT_CLASS (klass)->get_property = _vala_plank_abstract_main_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_plank_abstract_main_set_property;
	G_OBJECT_CLASS (klass)->constructor = plank_abstract_main_constructor;
	G_OBJECT_CLASS (klass)->finalize = plank_abstract_main_finalize;
	/**
	 * Should be Build.DATADIR
	 */
	g_object_class_install_property (G_OBJECT_CLASS (klass), PLANK_ABSTRACT_MAIN_BUILD_DATA_DIR_PROPERTY, plank_abstract_main_properties[PLANK_ABSTRACT_MAIN_BUILD_DATA_DIR_PROPERTY] = g_param_spec_string ("build-data-dir", "build-data-dir", "build-data-dir", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	/**
	 * Should be Build.PKGDATADIR
	 */
	g_object_class_install_property (G_OBJECT_CLASS (klass), PLANK_ABSTRACT_MAIN_BUILD_PKG_DATA_DIR_PROPERTY, plank_abstract_main_properties[PLANK_ABSTRACT_MAIN_BUILD_PKG_DATA_DIR_PROPERTY] = g_param_spec_string ("build-pkg-data-dir", "build-pkg-data-dir", "build-pkg-data-dir", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	/**
	 * Should be Build.RELEASE_NAME
	 */
	g_object_class_install_property (G_OBJECT_CLASS (klass), PLANK_ABSTRACT_MAIN_BUILD_RELEASE_NAME_PROPERTY, plank_abstract_main_properties[PLANK_ABSTRACT_MAIN_BUILD_RELEASE_NAME_PROPERTY] = g_param_spec_string ("build-release-name", "build-release-name", "build-release-name", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	/**
	 * Should be Build.VERSION
	 */
	g_object_class_install_property (G_OBJECT_CLASS (klass), PLANK_ABSTRACT_MAIN_BUILD_VERSION_PROPERTY, plank_abstract_main_properties[PLANK_ABSTRACT_MAIN_BUILD_VERSION_PROPERTY] = g_param_spec_string ("build-version", "build-version", "build-version", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	/**
	 * Should be Build.VERSION_INFO
	 */
	g_object_class_install_property (G_OBJECT_CLASS (klass), PLANK_ABSTRACT_MAIN_BUILD_VERSION_INFO_PROPERTY, plank_abstract_main_properties[PLANK_ABSTRACT_MAIN_BUILD_VERSION_INFO_PROPERTY] = g_param_spec_string ("build-version-info", "build-version-info", "build-version-info", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	/**
	 * The displayed name of the program.
	 */
	g_object_class_install_property (G_OBJECT_CLASS (klass), PLANK_ABSTRACT_MAIN_PROGRAM_NAME_PROPERTY, plank_abstract_main_properties[PLANK_ABSTRACT_MAIN_PROGRAM_NAME_PROPERTY] = g_param_spec_string ("program-name", "program-name", "program-name", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	/**
	 * The executable name of the program.
	 */
	g_object_class_install_property (G_OBJECT_CLASS (klass), PLANK_ABSTRACT_MAIN_EXEC_NAME_PROPERTY, plank_abstract_main_properties[PLANK_ABSTRACT_MAIN_EXEC_NAME_PROPERTY] = g_param_spec_string ("exec-name", "exec-name", "exec-name", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	/**
	 * The copyright year(s).
	 */
	g_object_class_install_property (G_OBJECT_CLASS (klass), PLANK_ABSTRACT_MAIN_APP_COPYRIGHT_PROPERTY, plank_abstract_main_properties[PLANK_ABSTRACT_MAIN_APP_COPYRIGHT_PROPERTY] = g_param_spec_string ("app-copyright", "app-copyright", "app-copyright", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	/**
	 * The (unique) dbus path for this program.
	 */
	g_object_class_install_property (G_OBJECT_CLASS (klass), PLANK_ABSTRACT_MAIN_APP_DBUS_PROPERTY, plank_abstract_main_properties[PLANK_ABSTRACT_MAIN_APP_DBUS_PROPERTY] = g_param_spec_string ("app-dbus", "app-dbus", "app-dbus", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	/**
	 * The name of this program's icon.
	 */
	g_object_class_install_property (G_OBJECT_CLASS (klass), PLANK_ABSTRACT_MAIN_APP_ICON_PROPERTY, plank_abstract_main_properties[PLANK_ABSTRACT_MAIN_APP_ICON_PROPERTY] = g_param_spec_string ("app-icon", "app-icon", "app-icon", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	/**
	 * The name of the launcher (.desktop file) for this program.
	 */
	g_object_class_install_property (G_OBJECT_CLASS (klass), PLANK_ABSTRACT_MAIN_APP_LAUNCHER_PROPERTY, plank_abstract_main_properties[PLANK_ABSTRACT_MAIN_APP_LAUNCHER_PROPERTY] = g_param_spec_string ("app-launcher", "app-launcher", "app-launcher", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	/**
	 * The URL for this program's website.
	 */
	g_object_class_install_property (G_OBJECT_CLASS (klass), PLANK_ABSTRACT_MAIN_MAIN_URL_PROPERTY, plank_abstract_main_properties[PLANK_ABSTRACT_MAIN_MAIN_URL_PROPERTY] = g_param_spec_string ("main-url", "main-url", "main-url", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	/**
	 * The URL for this program's help.
	 */
	g_object_class_install_property (G_OBJECT_CLASS (klass), PLANK_ABSTRACT_MAIN_HELP_URL_PROPERTY, plank_abstract_main_properties[PLANK_ABSTRACT_MAIN_HELP_URL_PROPERTY] = g_param_spec_string ("help-url", "help-url", "help-url", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	/**
	 * The URL for translating this program.
	 */
	g_object_class_install_property (G_OBJECT_CLASS (klass), PLANK_ABSTRACT_MAIN_TRANSLATE_URL_PROPERTY, plank_abstract_main_properties[PLANK_ABSTRACT_MAIN_TRANSLATE_URL_PROPERTY] = g_param_spec_string ("translate-url", "translate-url", "translate-url", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	/**
	 * The list of authors (to show in about dialog).
	 */
	g_object_class_install_property (G_OBJECT_CLASS (klass), PLANK_ABSTRACT_MAIN_ABOUT_AUTHORS_PROPERTY, plank_abstract_main_properties[PLANK_ABSTRACT_MAIN_ABOUT_AUTHORS_PROPERTY] = g_param_spec_boxed ("about-authors", "about-authors", "about-authors", G_TYPE_STRV, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	/**
	 * The list of documenters (to show in about dialog).
	 */
	g_object_class_install_property (G_OBJECT_CLASS (klass), PLANK_ABSTRACT_MAIN_ABOUT_DOCUMENTERS_PROPERTY, plank_abstract_main_properties[PLANK_ABSTRACT_MAIN_ABOUT_DOCUMENTERS_PROPERTY] = g_param_spec_boxed ("about-documenters", "about-documenters", "about-documenters", G_TYPE_STRV, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	/**
	 * The list of artists (to show in about dialog).
	 */
	g_object_class_install_property (G_OBJECT_CLASS (klass), PLANK_ABSTRACT_MAIN_ABOUT_ARTISTS_PROPERTY, plank_abstract_main_properties[PLANK_ABSTRACT_MAIN_ABOUT_ARTISTS_PROPERTY] = g_param_spec_boxed ("about-artists", "about-artists", "about-artists", G_TYPE_STRV, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	/**
	 * The list of translators (to show in about dialog).
	 */
	g_object_class_install_property (G_OBJECT_CLASS (klass), PLANK_ABSTRACT_MAIN_ABOUT_TRANSLATORS_PROPERTY, plank_abstract_main_properties[PLANK_ABSTRACT_MAIN_ABOUT_TRANSLATORS_PROPERTY] = g_param_spec_string ("about-translators", "about-translators", "about-translators", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	/**
	 * The license of this program (to show in about dialog).
	 */
	g_object_class_install_property (G_OBJECT_CLASS (klass), PLANK_ABSTRACT_MAIN_ABOUT_LICENSE_TYPE_PROPERTY, plank_abstract_main_properties[PLANK_ABSTRACT_MAIN_ABOUT_LICENSE_TYPE_PROPERTY] = g_param_spec_enum ("about-license-type", "about-license-type", "about-license-type", gtk_license_get_type (), GTK_LICENSE_UNKNOWN, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	signal (SIGINT, _plank_abstract_main_sig_handler_sighandler_t);
	signal (SIGTERM, _plank_abstract_main_sig_handler_sighandler_t);
}

static void
plank_abstract_main_instance_init (PlankAbstractMain * self,
                                   gpointer klass)
{
	gchar* _tmp0_;
	self->priv = plank_abstract_main_get_instance_private (self);
	self->priv->_about_license_type = GTK_LICENSE_UNKNOWN;
	_tmp0_ = g_strdup ("");
	self->priv->dock_name = _tmp0_;
}

static void
plank_abstract_main_finalize (GObject * obj)
{
	PlankAbstractMain * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, PLANK_TYPE_ABSTRACT_MAIN, PlankAbstractMain);
	_g_free0 (self->priv->_build_data_dir);
	_g_free0 (self->priv->_build_pkg_data_dir);
	_g_free0 (self->priv->_build_release_name);
	_g_free0 (self->priv->_build_version);
	_g_free0 (self->priv->_build_version_info);
	_g_free0 (self->priv->_program_name);
	_g_free0 (self->priv->_exec_name);
	_g_free0 (self->priv->_app_copyright);
	_g_free0 (self->priv->_app_dbus);
	_g_free0 (self->priv->_app_icon);
	_g_free0 (self->priv->_app_launcher);
	_g_free0 (self->priv->_main_url);
	_g_free0 (self->priv->_help_url);
	_g_free0 (self->priv->_translate_url);
	self->priv->_about_authors = (_vala_array_free (self->priv->_about_authors, self->priv->_about_authors_length1, (GDestroyNotify) g_free), NULL);
	self->priv->_about_documenters = (_vala_array_free (self->priv->_about_documenters, self->priv->_about_documenters_length1, (GDestroyNotify) g_free), NULL);
	self->priv->_about_artists = (_vala_array_free (self->priv->_about_artists, self->priv->_about_artists_length1, (GDestroyNotify) g_free), NULL);
	_g_free0 (self->priv->_about_translators);
	_g_free0 (self->priv->dock_name);
	_g_object_unref0 (self->priv->about_dlg);
	_g_object_unref0 (self->priv->preferences_dlg);
	_g_object_unref0 (self->priv->primary_dock);
	_g_object_unref0 (self->priv->docks);
	G_OBJECT_CLASS (plank_abstract_main_parent_class)->finalize (obj);
}

/**
 * The main class for all dock applications.  All docks should extend this class.
 * In the constructor, the string fields should be initialized to customize the dock.
 */
static GType
plank_abstract_main_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (PlankAbstractMainClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) plank_abstract_main_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PlankAbstractMain), 0, (GInstanceInitFunc) plank_abstract_main_instance_init, NULL };
	GType plank_abstract_main_type_id;
	plank_abstract_main_type_id = g_type_register_static (gtk_application_get_type (), "PlankAbstractMain", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
	PlankAbstractMain_private_offset = g_type_add_instance_private (plank_abstract_main_type_id, sizeof (PlankAbstractMainPrivate));
	return plank_abstract_main_type_id;
}

GType
plank_abstract_main_get_type (void)
{
	static volatile gsize plank_abstract_main_type_id__once = 0;
	if (g_once_init_enter (&plank_abstract_main_type_id__once)) {
		GType plank_abstract_main_type_id;
		plank_abstract_main_type_id = plank_abstract_main_get_type_once ();
		g_once_init_leave (&plank_abstract_main_type_id__once, plank_abstract_main_type_id);
	}
	return plank_abstract_main_type_id__once;
}

static void
_vala_plank_abstract_main_get_property (GObject * object,
                                        guint property_id,
                                        GValue * value,
                                        GParamSpec * pspec)
{
	PlankAbstractMain * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, PLANK_TYPE_ABSTRACT_MAIN, PlankAbstractMain);
	switch (property_id) {
		case PLANK_ABSTRACT_MAIN_BUILD_DATA_DIR_PROPERTY:
		g_value_set_string (value, plank_abstract_main_get_build_data_dir (self));
		break;
		case PLANK_ABSTRACT_MAIN_BUILD_PKG_DATA_DIR_PROPERTY:
		g_value_set_string (value, plank_abstract_main_get_build_pkg_data_dir (self));
		break;
		case PLANK_ABSTRACT_MAIN_BUILD_RELEASE_NAME_PROPERTY:
		g_value_set_string (value, plank_abstract_main_get_build_release_name (self));
		break;
		case PLANK_ABSTRACT_MAIN_BUILD_VERSION_PROPERTY:
		g_value_set_string (value, plank_abstract_main_get_build_version (self));
		break;
		case PLANK_ABSTRACT_MAIN_BUILD_VERSION_INFO_PROPERTY:
		g_value_set_string (value, plank_abstract_main_get_build_version_info (self));
		break;
		case PLANK_ABSTRACT_MAIN_PROGRAM_NAME_PROPERTY:
		g_value_set_string (value, plank_abstract_main_get_program_name (self));
		break;
		case PLANK_ABSTRACT_MAIN_EXEC_NAME_PROPERTY:
		g_value_set_string (value, plank_abstract_main_get_exec_name (self));
		break;
		case PLANK_ABSTRACT_MAIN_APP_COPYRIGHT_PROPERTY:
		g_value_set_string (value, plank_abstract_main_get_app_copyright (self));
		break;
		case PLANK_ABSTRACT_MAIN_APP_DBUS_PROPERTY:
		g_value_set_string (value, plank_abstract_main_get_app_dbus (self));
		break;
		case PLANK_ABSTRACT_MAIN_APP_ICON_PROPERTY:
		g_value_set_string (value, plank_abstract_main_get_app_icon (self));
		break;
		case PLANK_ABSTRACT_MAIN_APP_LAUNCHER_PROPERTY:
		g_value_set_string (value, plank_abstract_main_get_app_launcher (self));
		break;
		case PLANK_ABSTRACT_MAIN_MAIN_URL_PROPERTY:
		g_value_set_string (value, plank_abstract_main_get_main_url (self));
		break;
		case PLANK_ABSTRACT_MAIN_HELP_URL_PROPERTY:
		g_value_set_string (value, plank_abstract_main_get_help_url (self));
		break;
		case PLANK_ABSTRACT_MAIN_TRANSLATE_URL_PROPERTY:
		g_value_set_string (value, plank_abstract_main_get_translate_url (self));
		break;
		case PLANK_ABSTRACT_MAIN_ABOUT_AUTHORS_PROPERTY:
		{
			int length;
			g_value_set_boxed (value, plank_abstract_main_get_about_authors (self, &length));
		}
		break;
		case PLANK_ABSTRACT_MAIN_ABOUT_DOCUMENTERS_PROPERTY:
		{
			int length;
			g_value_set_boxed (value, plank_abstract_main_get_about_documenters (self, &length));
		}
		break;
		case PLANK_ABSTRACT_MAIN_ABOUT_ARTISTS_PROPERTY:
		{
			int length;
			g_value_set_boxed (value, plank_abstract_main_get_about_artists (self, &length));
		}
		break;
		case PLANK_ABSTRACT_MAIN_ABOUT_TRANSLATORS_PROPERTY:
		g_value_set_string (value, plank_abstract_main_get_about_translators (self));
		break;
		case PLANK_ABSTRACT_MAIN_ABOUT_LICENSE_TYPE_PROPERTY:
		g_value_set_enum (value, plank_abstract_main_get_about_license_type (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_plank_abstract_main_set_property (GObject * object,
                                        guint property_id,
                                        const GValue * value,
                                        GParamSpec * pspec)
{
	PlankAbstractMain * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, PLANK_TYPE_ABSTRACT_MAIN, PlankAbstractMain);
	switch (property_id) {
		case PLANK_ABSTRACT_MAIN_BUILD_DATA_DIR_PROPERTY:
		plank_abstract_main_set_build_data_dir (self, g_value_get_string (value));
		break;
		case PLANK_ABSTRACT_MAIN_BUILD_PKG_DATA_DIR_PROPERTY:
		plank_abstract_main_set_build_pkg_data_dir (self, g_value_get_string (value));
		break;
		case PLANK_ABSTRACT_MAIN_BUILD_RELEASE_NAME_PROPERTY:
		plank_abstract_main_set_build_release_name (self, g_value_get_string (value));
		break;
		case PLANK_ABSTRACT_MAIN_BUILD_VERSION_PROPERTY:
		plank_abstract_main_set_build_version (self, g_value_get_string (value));
		break;
		case PLANK_ABSTRACT_MAIN_BUILD_VERSION_INFO_PROPERTY:
		plank_abstract_main_set_build_version_info (self, g_value_get_string (value));
		break;
		case PLANK_ABSTRACT_MAIN_PROGRAM_NAME_PROPERTY:
		plank_abstract_main_set_program_name (self, g_value_get_string (value));
		break;
		case PLANK_ABSTRACT_MAIN_EXEC_NAME_PROPERTY:
		plank_abstract_main_set_exec_name (self, g_value_get_string (value));
		break;
		case PLANK_ABSTRACT_MAIN_APP_COPYRIGHT_PROPERTY:
		plank_abstract_main_set_app_copyright (self, g_value_get_string (value));
		break;
		case PLANK_ABSTRACT_MAIN_APP_DBUS_PROPERTY:
		plank_abstract_main_set_app_dbus (self, g_value_get_string (value));
		break;
		case PLANK_ABSTRACT_MAIN_APP_ICON_PROPERTY:
		plank_abstract_main_set_app_icon (self, g_value_get_string (value));
		break;
		case PLANK_ABSTRACT_MAIN_APP_LAUNCHER_PROPERTY:
		plank_abstract_main_set_app_launcher (self, g_value_get_string (value));
		break;
		case PLANK_ABSTRACT_MAIN_MAIN_URL_PROPERTY:
		plank_abstract_main_set_main_url (self, g_value_get_string (value));
		break;
		case PLANK_ABSTRACT_MAIN_HELP_URL_PROPERTY:
		plank_abstract_main_set_help_url (self, g_value_get_string (value));
		break;
		case PLANK_ABSTRACT_MAIN_TRANSLATE_URL_PROPERTY:
		plank_abstract_main_set_translate_url (self, g_value_get_string (value));
		break;
		case PLANK_ABSTRACT_MAIN_ABOUT_AUTHORS_PROPERTY:
		{
			gpointer boxed;
			boxed = g_value_get_boxed (value);
			plank_abstract_main_set_about_authors (self, boxed, (boxed == NULL) ? 0 : g_strv_length (boxed));
		}
		break;
		case PLANK_ABSTRACT_MAIN_ABOUT_DOCUMENTERS_PROPERTY:
		{
			gpointer boxed;
			boxed = g_value_get_boxed (value);
			plank_abstract_main_set_about_documenters (self, boxed, (boxed == NULL) ? 0 : g_strv_length (boxed));
		}
		break;
		case PLANK_ABSTRACT_MAIN_ABOUT_ARTISTS_PROPERTY:
		{
			gpointer boxed;
			boxed = g_value_get_boxed (value);
			plank_abstract_main_set_about_artists (self, boxed, (boxed == NULL) ? 0 : g_strv_length (boxed));
		}
		break;
		case PLANK_ABSTRACT_MAIN_ABOUT_TRANSLATORS_PROPERTY:
		plank_abstract_main_set_about_translators (self, g_value_get_string (value));
		break;
		case PLANK_ABSTRACT_MAIN_ABOUT_LICENSE_TYPE_PROPERTY:
		plank_abstract_main_set_about_license_type (self, g_value_get_enum (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

