/* PixbufCache.c generated by valac 0.56.18, the Vala compiler
 * generated from PixbufCache.vala, do not modify */

/*
* Copyright (c) 2009-2013 Yorba Foundation
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU Lesser General Public
* License as published by the Free Software Foundation; either
* version 2.1 of the License, or (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
* General Public License for more details.
*
* You should have received a copy of the GNU General Public
* License along with this program; if not, write to the
* Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
* Boston, MA 02110-1301 USA
*/

#include "io.elementary.photos.h"
#include <glib.h>
#include <gee.h>
#include <glib-object.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

#define PIXBUF_CACHE_TYPE_FETCH_JOB (pixbuf_cache_fetch_job_get_type ())
#define PIXBUF_CACHE_FETCH_JOB(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), PIXBUF_CACHE_TYPE_FETCH_JOB, PixbufCacheFetchJob))
#define PIXBUF_CACHE_FETCH_JOB_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), PIXBUF_CACHE_TYPE_FETCH_JOB, PixbufCacheFetchJobClass))
#define PIXBUF_CACHE_IS_FETCH_JOB(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), PIXBUF_CACHE_TYPE_FETCH_JOB))
#define PIXBUF_CACHE_IS_FETCH_JOB_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), PIXBUF_CACHE_TYPE_FETCH_JOB))
#define PIXBUF_CACHE_FETCH_JOB_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), PIXBUF_CACHE_TYPE_FETCH_JOB, PixbufCacheFetchJobClass))

typedef struct _PixbufCacheFetchJob PixbufCacheFetchJob;
typedef struct _PixbufCacheFetchJobClass PixbufCacheFetchJobClass;
enum  {
	PIXBUF_CACHE_0_PROPERTY,
	PIXBUF_CACHE_NUM_PROPERTIES
};
static GParamSpec* pixbuf_cache_properties[PIXBUF_CACHE_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _background_job_unref0(var) ((var == NULL) ? NULL : (var = (background_job_unref (var), NULL)))
#define _data_collection_unref0(var) ((var == NULL) ? NULL : (var = (data_collection_unref (var), NULL)))
#define _workers_unref0(var) ((var == NULL) ? NULL : (var = (workers_unref (var), NULL)))
typedef struct _PixbufCacheFetchJobPrivate PixbufCacheFetchJobPrivate;

#define PIXBUF_CACHE_TYPE_BASELINE_FETCH_JOB (pixbuf_cache_baseline_fetch_job_get_type ())
#define PIXBUF_CACHE_BASELINE_FETCH_JOB(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), PIXBUF_CACHE_TYPE_BASELINE_FETCH_JOB, PixbufCacheBaselineFetchJob))
#define PIXBUF_CACHE_BASELINE_FETCH_JOB_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), PIXBUF_CACHE_TYPE_BASELINE_FETCH_JOB, PixbufCacheBaselineFetchJobClass))
#define PIXBUF_CACHE_IS_BASELINE_FETCH_JOB(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), PIXBUF_CACHE_TYPE_BASELINE_FETCH_JOB))
#define PIXBUF_CACHE_IS_BASELINE_FETCH_JOB_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), PIXBUF_CACHE_TYPE_BASELINE_FETCH_JOB))
#define PIXBUF_CACHE_BASELINE_FETCH_JOB_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), PIXBUF_CACHE_TYPE_BASELINE_FETCH_JOB, PixbufCacheBaselineFetchJobClass))

typedef struct _PixbufCacheBaselineFetchJob PixbufCacheBaselineFetchJob;
typedef struct _PixbufCacheBaselineFetchJobClass PixbufCacheBaselineFetchJobClass;

#define PIXBUF_CACHE_TYPE_MASTER_FETCH_JOB (pixbuf_cache_master_fetch_job_get_type ())
#define PIXBUF_CACHE_MASTER_FETCH_JOB(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), PIXBUF_CACHE_TYPE_MASTER_FETCH_JOB, PixbufCacheMasterFetchJob))
#define PIXBUF_CACHE_MASTER_FETCH_JOB_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), PIXBUF_CACHE_TYPE_MASTER_FETCH_JOB, PixbufCacheMasterFetchJobClass))
#define PIXBUF_CACHE_IS_MASTER_FETCH_JOB(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), PIXBUF_CACHE_TYPE_MASTER_FETCH_JOB))
#define PIXBUF_CACHE_IS_MASTER_FETCH_JOB_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), PIXBUF_CACHE_TYPE_MASTER_FETCH_JOB))
#define PIXBUF_CACHE_MASTER_FETCH_JOB_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), PIXBUF_CACHE_TYPE_MASTER_FETCH_JOB, PixbufCacheMasterFetchJobClass))

typedef struct _PixbufCacheMasterFetchJob PixbufCacheMasterFetchJob;
typedef struct _PixbufCacheMasterFetchJobClass PixbufCacheMasterFetchJobClass;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _alteration_unref0(var) ((var == NULL) ? NULL : (var = (alteration_unref (var), NULL)))
enum  {
	PIXBUF_CACHE_PIXBUF_CACHE_BATCH_0_PROPERTY,
	PIXBUF_CACHE_PIXBUF_CACHE_BATCH_NUM_PROPERTIES
};
static GParamSpec* pixbuf_cache_pixbuf_cache_batch_properties[PIXBUF_CACHE_PIXBUF_CACHE_BATCH_NUM_PROPERTIES];
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _abstract_semaphore_unref0(var) ((var == NULL) ? NULL : (var = (abstract_semaphore_unref (var), NULL)))
typedef struct _PixbufCacheBaselineFetchJobPrivate PixbufCacheBaselineFetchJobPrivate;
typedef struct _PixbufCacheMasterFetchJobPrivate PixbufCacheMasterFetchJobPrivate;
enum  {
	PIXBUF_CACHE_FETCHED_SIGNAL,
	PIXBUF_CACHE_NUM_SIGNALS
};
static guint pixbuf_cache_signals[PIXBUF_CACHE_NUM_SIGNALS] = {0};
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _PixbufCachePrivate {
	SourceCollection* sources;
	PixbufCachePhotoType type;
	gint max_count;
	Scaling scaling;
	PixbufCacheCacheFilter filter;
	gpointer filter_target;
	GeeHashMap* cache;
	GeeArrayList* lru;
	GeeHashMap* in_progress;
};

struct _PixbufCacheFetchJob {
	BackgroundJob parent_instance;
	PixbufCacheFetchJobPrivate * priv;
	BackgroundJobJobPriority priority;
	Photo* photo;
	Scaling scaling;
	GdkPixbuf* pixbuf;
	GError* err;
};

struct _PixbufCacheFetchJobClass {
	BackgroundJobClass parent_class;
};

struct _PixbufCacheBaselineFetchJob {
	PixbufCacheFetchJob parent_instance;
	PixbufCacheBaselineFetchJobPrivate * priv;
};

struct _PixbufCacheBaselineFetchJobClass {
	PixbufCacheFetchJobClass parent_class;
};

struct _PixbufCacheMasterFetchJob {
	PixbufCacheFetchJob parent_instance;
	PixbufCacheMasterFetchJobPrivate * priv;
};

struct _PixbufCacheMasterFetchJobClass {
	PixbufCacheFetchJobClass parent_class;
};

static gint PixbufCache_private_offset;
static gpointer pixbuf_cache_parent_class = NULL;
static Workers* pixbuf_cache_background_workers;
static Workers* pixbuf_cache_background_workers = NULL;
static gpointer pixbuf_cache_pixbuf_cache_batch_parent_class = NULL;
static gpointer pixbuf_cache_fetch_job_parent_class = NULL;
static gpointer pixbuf_cache_baseline_fetch_job_parent_class = NULL;
static gpointer pixbuf_cache_master_fetch_job_parent_class = NULL;

static GType pixbuf_cache_fetch_job_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
static void pixbuf_cache_on_sources_altered (PixbufCache* self,
                                      GeeMap* map);
static void _pixbuf_cache_on_sources_altered_data_collection_items_altered (DataCollection* _sender,
                                                                     GeeMap* items,
                                                                     gpointer self);
static void pixbuf_cache_on_sources_removed (PixbufCache* self,
                                      GeeIterable* removed);
static void _pixbuf_cache_on_sources_removed_data_collection_items_removed (DataCollection* _sender,
                                                                     GeeIterable* removed,
                                                                     gpointer self);
static GdkPixbuf* pixbuf_cache_get_cached (PixbufCache* self,
                                    Photo* photo);
static void pixbuf_cache_decache (PixbufCache* self,
                           Photo* photo);
static void pixbuf_cache_encache (PixbufCache* self,
                           Photo* photo,
                           GdkPixbuf* pixbuf);
static void pixbuf_cache_prioritize (PixbufCache* self,
                              Photo* photo);
static void pixbuf_cache_on_fetched (PixbufCache* self,
                              BackgroundJob* j);
static void _pixbuf_cache_on_fetched_completion_callback (BackgroundJob* job,
                                                   gpointer self);
static PixbufCacheBaselineFetchJob* pixbuf_cache_baseline_fetch_job_new (PixbufCache* owner,
                                                                  BackgroundJobJobPriority priority,
                                                                  Photo* photo,
                                                                  Scaling* scaling,
                                                                  CompletionCallback callback,
                                                                  gpointer callback_target);
static PixbufCacheBaselineFetchJob* pixbuf_cache_baseline_fetch_job_construct (GType object_type,
                                                                        PixbufCache* owner,
                                                                        BackgroundJobJobPriority priority,
                                                                        Photo* photo,
                                                                        Scaling* scaling,
                                                                        CompletionCallback callback,
                                                                        gpointer callback_target);
static GType pixbuf_cache_baseline_fetch_job_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
static PixbufCacheMasterFetchJob* pixbuf_cache_master_fetch_job_new (PixbufCache* owner,
                                                              BackgroundJobJobPriority priority,
                                                              Photo* photo,
                                                              Scaling* scaling,
                                                              CompletionCallback callback,
                                                              gpointer callback_target);
static PixbufCacheMasterFetchJob* pixbuf_cache_master_fetch_job_construct (GType object_type,
                                                                    PixbufCache* owner,
                                                                    BackgroundJobJobPriority priority,
                                                                    Photo* photo,
                                                                    Scaling* scaling,
                                                                    CompletionCallback callback,
                                                                    gpointer callback_target);
static GType pixbuf_cache_master_fetch_job_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
static void g_cclosure_user_marshal_VOID__OBJECT_OBJECT_BOXED (GClosure * closure,
                                                        GValue * return_value,
                                                        guint n_param_values,
                                                        const GValue * param_values,
                                                        gpointer invocation_hint,
                                                        gpointer marshal_data);
static gint _background_job_job_priority_compare_func_gcompare_data_func (gconstpointer a,
                                                                   gconstpointer b,
                                                                   gpointer self);
static GType pixbuf_cache_pixbuf_cache_batch_get_type_once (void);
static PixbufCacheFetchJob* pixbuf_cache_fetch_job_construct (GType object_type,
                                                       PixbufCache* owner,
                                                       BackgroundJobJobPriority priority,
                                                       Photo* photo,
                                                       Scaling* scaling,
                                                       CompletionCallback callback,
                                                       gpointer callback_target);
static BackgroundJobJobPriority pixbuf_cache_fetch_job_real_get_priority (BackgroundJob* base);
static void pixbuf_cache_fetch_job_finalize (BackgroundJob * obj);
static GType pixbuf_cache_fetch_job_get_type_once (void);
static void pixbuf_cache_baseline_fetch_job_real_execute (BackgroundJob* base);
static GType pixbuf_cache_baseline_fetch_job_get_type_once (void);
static void pixbuf_cache_master_fetch_job_real_execute (BackgroundJob* base);
static GType pixbuf_cache_master_fetch_job_get_type_once (void);
static void pixbuf_cache_finalize (GObject * obj);
static GType pixbuf_cache_get_type_once (void);

static inline gpointer
pixbuf_cache_get_instance_private (PixbufCache* self)
{
	return G_STRUCT_MEMBER_P (self, PixbufCache_private_offset);
}

static void
_pixbuf_cache_on_sources_altered_data_collection_items_altered (DataCollection* _sender,
                                                                GeeMap* items,
                                                                gpointer self)
{
	pixbuf_cache_on_sources_altered ((PixbufCache*) self, items);
}

static void
_pixbuf_cache_on_sources_removed_data_collection_items_removed (DataCollection* _sender,
                                                                GeeIterable* removed,
                                                                gpointer self)
{
	pixbuf_cache_on_sources_removed ((PixbufCache*) self, removed);
}

static GType
pixbuf_cache_photo_type_get_type_once (void)
{
	static const GEnumValue values[] = {{PIXBUF_CACHE_PHOTO_TYPE_BASELINE, "PIXBUF_CACHE_PHOTO_TYPE_BASELINE", "baseline"}, {PIXBUF_CACHE_PHOTO_TYPE_MASTER, "PIXBUF_CACHE_PHOTO_TYPE_MASTER", "master"}, {0, NULL, NULL}};
	GType pixbuf_cache_photo_type_type_id;
	pixbuf_cache_photo_type_type_id = g_enum_register_static ("PixbufCachePhotoType", values);
	return pixbuf_cache_photo_type_type_id;
}

GType
pixbuf_cache_photo_type_get_type (void)
{
	static volatile gsize pixbuf_cache_photo_type_type_id__once = 0;
	if (g_once_init_enter (&pixbuf_cache_photo_type_type_id__once)) {
		GType pixbuf_cache_photo_type_type_id;
		pixbuf_cache_photo_type_type_id = pixbuf_cache_photo_type_get_type_once ();
		g_once_init_leave (&pixbuf_cache_photo_type_type_id__once, pixbuf_cache_photo_type_type_id);
	}
	return pixbuf_cache_photo_type_type_id__once;
}

static gpointer
_data_collection_ref0 (gpointer self)
{
	return self ? data_collection_ref (self) : NULL;
}

PixbufCache*
pixbuf_cache_construct (GType object_type,
                        SourceCollection* sources,
                        PixbufCachePhotoType type,
                        Scaling* scaling,
                        gint max_count,
                        PixbufCacheCacheFilter filter,
                        gpointer filter_target)
{
	PixbufCache * self = NULL;
	SourceCollection* _tmp0_;
	Scaling _tmp1_;
	Workers* _tmp2_;
	g_return_val_if_fail (sources != NULL, NULL);
	g_return_val_if_fail (scaling != NULL, NULL);
	self = (PixbufCache*) g_object_new (object_type, NULL);
	_tmp0_ = _data_collection_ref0 (sources);
	_data_collection_unref0 (self->priv->sources);
	self->priv->sources = _tmp0_;
	self->priv->type = type;
	_tmp1_ = *scaling;
	self->priv->scaling = _tmp1_;
	self->priv->max_count = max_count;
	self->priv->filter = filter;
	self->priv->filter_target = filter_target;
	_vala_assert (max_count > 0, "max_count > 0");
	_tmp2_ = pixbuf_cache_background_workers;
	if (_tmp2_ == NULL) {
		Workers* _tmp3_;
		_tmp3_ = workers_new (workers_thread_per_cpu_minus_one (), FALSE);
		_workers_unref0 (pixbuf_cache_background_workers);
		pixbuf_cache_background_workers = _tmp3_;
	}
	if (type != PIXBUF_CACHE_PHOTO_TYPE_MASTER) {
		g_signal_connect_object ((DataCollection*) sources, "items-altered", (GCallback) _pixbuf_cache_on_sources_altered_data_collection_items_altered, self, 0);
	}
	g_signal_connect_object ((DataCollection*) sources, "items-removed", (GCallback) _pixbuf_cache_on_sources_removed_data_collection_items_removed, self, 0);
	return self;
}

PixbufCache*
pixbuf_cache_new (SourceCollection* sources,
                  PixbufCachePhotoType type,
                  Scaling* scaling,
                  gint max_count,
                  PixbufCacheCacheFilter filter,
                  gpointer filter_target)
{
	return pixbuf_cache_construct (TYPE_PIXBUF_CACHE, sources, type, scaling, max_count, filter, filter_target);
}

void
pixbuf_cache_get_scaling (PixbufCache* self,
                          Scaling* result)
{
	Scaling _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->scaling;
	*result = _tmp0_;
	return;
}

GdkPixbuf*
pixbuf_cache_get_ready_pixbuf (PixbufCache* self,
                               Photo* photo)
{
	GdkPixbuf* _tmp0_;
	GdkPixbuf* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (photo != NULL, NULL);
	_tmp0_ = pixbuf_cache_get_cached (self, photo);
	result = _tmp0_;
	return result;
}

static gpointer
_g_error_copy0 (gpointer self)
{
	return self ? g_error_copy (self) : NULL;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

GdkPixbuf*
pixbuf_cache_fetch (PixbufCache* self,
                    Photo* photo,
                    GError** error)
{
	GFile* _tmp0_;
	GFile* _tmp1_;
	gboolean _tmp2_;
	GdkPixbuf* pixbuf = NULL;
	GdkPixbuf* _tmp3_;
	GdkPixbuf* _tmp4_;
	PixbufCacheFetchJob* job = NULL;
	GeeHashMap* _tmp5_;
	gpointer _tmp6_;
	PixbufCacheFetchJob* _tmp7_;
	GdkPixbuf* _tmp17_ = NULL;
	Scaling _tmp18_;
	GdkPixbuf* _tmp19_;
	GdkPixbuf* _tmp20_;
	GdkPixbuf* _tmp21_;
	GError* _inner_error0_ = NULL;
	GdkPixbuf* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (photo != NULL, NULL);
	_tmp0_ = photo_get_actual_file (photo);
	_tmp1_ = _tmp0_;
	_tmp2_ = !g_file_query_exists (_tmp1_, NULL);
	_g_object_unref0 (_tmp1_);
	if (_tmp2_) {
		pixbuf_cache_decache (self, photo);
	}
	_tmp3_ = pixbuf_cache_get_cached (self, photo);
	pixbuf = _tmp3_;
	_tmp4_ = pixbuf;
	if (_tmp4_ != NULL) {
		result = pixbuf;
		return result;
	}
	_tmp5_ = self->priv->in_progress;
	_tmp6_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp5_, photo);
	job = (PixbufCacheFetchJob*) _tmp6_;
	_tmp7_ = job;
	if (_tmp7_ != NULL) {
		PixbufCacheFetchJob* _tmp8_;
		PixbufCacheFetchJob* _tmp9_;
		GError* _tmp10_;
		PixbufCacheFetchJob* _tmp14_;
		GdkPixbuf* _tmp15_;
		GdkPixbuf* _tmp16_;
		_tmp8_ = job;
		background_job_wait_for_completion ((BackgroundJob*) _tmp8_);
		_tmp9_ = job;
		_tmp10_ = _tmp9_->err;
		if (_tmp10_ != NULL) {
			PixbufCacheFetchJob* _tmp11_;
			GError* _tmp12_;
			GError* _tmp13_;
			_tmp11_ = job;
			_tmp12_ = _tmp11_->err;
			_tmp13_ = _g_error_copy0 (_tmp12_);
			_inner_error0_ = _tmp13_;
			g_propagate_error (error, _inner_error0_);
			_background_job_unref0 (job);
			_g_object_unref0 (pixbuf);
			return NULL;
		}
		_tmp14_ = job;
		_tmp15_ = _tmp14_->pixbuf;
		_tmp16_ = _g_object_ref0 (_tmp15_);
		result = _tmp16_;
		_background_job_unref0 (job);
		_g_object_unref0 (pixbuf);
		return result;
	}
	_tmp18_ = self->priv->scaling;
	_tmp19_ = photo_source_get_pixbuf ((PhotoSource*) photo, &_tmp18_, &_inner_error0_);
	_tmp17_ = _tmp19_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_background_job_unref0 (job);
		_g_object_unref0 (pixbuf);
		return NULL;
	}
	_tmp20_ = _tmp17_;
	_tmp17_ = NULL;
	_g_object_unref0 (pixbuf);
	pixbuf = _tmp20_;
	_tmp21_ = pixbuf;
	pixbuf_cache_encache (self, photo, _tmp21_);
	result = pixbuf;
	_g_object_unref0 (_tmp17_);
	_background_job_unref0 (job);
	return result;
}

void
pixbuf_cache_drop (PixbufCache* self,
                   Photo* photo)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (photo != NULL);
	pixbuf_cache_cancel_prefetch (self, photo);
	pixbuf_cache_decache (self, photo);
}

static void
_pixbuf_cache_on_fetched_completion_callback (BackgroundJob* job,
                                              gpointer self)
{
	pixbuf_cache_on_fetched ((PixbufCache*) self, job);
}

void
pixbuf_cache_prefetch (PixbufCache* self,
                       Photo* photo,
                       BackgroundJobJobPriority priority,
                       gboolean force)
{
	GFile* _tmp0_;
	GFile* _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_ = FALSE;
	GeeHashMap* _tmp5_;
	gboolean _tmp6_ = FALSE;
	PixbufCacheCacheFilter _tmp7_;
	gpointer _tmp7__target;
	PixbufCacheFetchJob* job = NULL;
	GeeHashMap* _tmp13_;
	PixbufCacheFetchJob* _tmp14_;
	Workers* _tmp15_;
	PixbufCacheFetchJob* _tmp16_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (photo != NULL);
	_tmp0_ = photo_get_actual_file (photo);
	_tmp1_ = _tmp0_;
	_tmp2_ = !g_file_query_exists (_tmp1_, NULL);
	_g_object_unref0 (_tmp1_);
	if (_tmp2_) {
		pixbuf_cache_decache (self, photo);
	}
	if (!force) {
		GeeHashMap* _tmp4_;
		_tmp4_ = self->priv->cache;
		_tmp3_ = gee_abstract_map_has_key ((GeeAbstractMap*) _tmp4_, photo);
	} else {
		_tmp3_ = FALSE;
	}
	if (_tmp3_) {
		pixbuf_cache_prioritize (self, photo);
		return;
	}
	_tmp5_ = self->priv->in_progress;
	if (gee_abstract_map_has_key ((GeeAbstractMap*) _tmp5_, photo)) {
		return;
	}
	_tmp7_ = self->priv->filter;
	_tmp7__target = self->priv->filter_target;
	if (_tmp7_ != NULL) {
		PixbufCacheCacheFilter _tmp8_;
		gpointer _tmp8__target;
		_tmp8_ = self->priv->filter;
		_tmp8__target = self->priv->filter_target;
		_tmp6_ = !_tmp8_ (photo, _tmp8__target);
	} else {
		_tmp6_ = FALSE;
	}
	if (_tmp6_) {
		return;
	}
	job = NULL;
	switch (self->priv->type) {
		case PIXBUF_CACHE_PHOTO_TYPE_BASELINE:
		{
			Scaling _tmp9_;
			PixbufCacheBaselineFetchJob* _tmp10_;
			_tmp9_ = self->priv->scaling;
			_tmp10_ = pixbuf_cache_baseline_fetch_job_new (self, priority, photo, &_tmp9_, _pixbuf_cache_on_fetched_completion_callback, self);
			_background_job_unref0 (job);
			job = (PixbufCacheFetchJob*) _tmp10_;
			break;
		}
		case PIXBUF_CACHE_PHOTO_TYPE_MASTER:
		{
			Scaling _tmp11_;
			PixbufCacheMasterFetchJob* _tmp12_;
			_tmp11_ = self->priv->scaling;
			_tmp12_ = pixbuf_cache_master_fetch_job_new (self, priority, photo, &_tmp11_, _pixbuf_cache_on_fetched_completion_callback, self);
			_background_job_unref0 (job);
			job = (PixbufCacheFetchJob*) _tmp12_;
			break;
		}
		default:
		{
			g_error ("PixbufCache.vala:213: Unknown photo type: %d", (gint) self->priv->type);
		}
	}
	_tmp13_ = self->priv->in_progress;
	_tmp14_ = job;
	gee_abstract_map_set ((GeeAbstractMap*) _tmp13_, photo, _tmp14_);
	_tmp15_ = pixbuf_cache_background_workers;
	_tmp16_ = job;
	workers_enqueue (_tmp15_, (BackgroundJob*) _tmp16_);
	_background_job_unref0 (job);
}

void
pixbuf_cache_prefetch_many (PixbufCache* self,
                            GeeCollection* photos,
                            BackgroundJobJobPriority priority,
                            gboolean force)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (photos != NULL);
	{
		GeeIterator* _photo_it = NULL;
		GeeIterator* _tmp0_;
		_tmp0_ = gee_iterable_iterator ((GeeIterable*) photos);
		_photo_it = _tmp0_;
		while (TRUE) {
			GeeIterator* _tmp1_;
			Photo* photo = NULL;
			GeeIterator* _tmp2_;
			gpointer _tmp3_;
			Photo* _tmp4_;
			_tmp1_ = _photo_it;
			if (!gee_iterator_next (_tmp1_)) {
				break;
			}
			_tmp2_ = _photo_it;
			_tmp3_ = gee_iterator_get (_tmp2_);
			photo = (Photo*) _tmp3_;
			_tmp4_ = photo;
			pixbuf_cache_prefetch (self, _tmp4_, priority, force);
			_g_object_unref0 (photo);
		}
		_g_object_unref0 (_photo_it);
	}
}

void
pixbuf_cache_prefetch_batch (PixbufCache* self,
                             PixbufCachePixbufCacheBatch* batch,
                             gboolean force)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (batch != NULL);
	{
		GeeIterator* _priority_it = NULL;
		GeeSet* _tmp0_;
		GeeSet* _tmp1_;
		GeeIterator* _tmp2_;
		GeeIterator* _tmp3_;
		_tmp0_ = gee_multi_map_get_keys ((GeeMultiMap*) batch);
		_tmp1_ = _tmp0_;
		_tmp2_ = gee_iterable_iterator ((GeeIterable*) _tmp1_);
		_tmp3_ = _tmp2_;
		_g_object_unref0 (_tmp1_);
		_priority_it = _tmp3_;
		while (TRUE) {
			GeeIterator* _tmp4_;
			BackgroundJobJobPriority priority = 0;
			GeeIterator* _tmp5_;
			gpointer _tmp6_;
			_tmp4_ = _priority_it;
			if (!gee_iterator_next (_tmp4_)) {
				break;
			}
			_tmp5_ = _priority_it;
			_tmp6_ = gee_iterator_get (_tmp5_);
			priority = (BackgroundJobJobPriority) ((gintptr) _tmp6_);
			{
				GeeIterator* _photo_it = NULL;
				GeeCollection* _tmp7_;
				GeeCollection* _tmp8_;
				GeeIterator* _tmp9_;
				GeeIterator* _tmp10_;
				_tmp7_ = gee_multi_map_get ((GeeMultiMap*) batch, (gpointer) ((gintptr) priority));
				_tmp8_ = _tmp7_;
				_tmp9_ = gee_iterable_iterator ((GeeIterable*) _tmp8_);
				_tmp10_ = _tmp9_;
				_g_object_unref0 (_tmp8_);
				_photo_it = _tmp10_;
				while (TRUE) {
					GeeIterator* _tmp11_;
					Photo* photo = NULL;
					GeeIterator* _tmp12_;
					gpointer _tmp13_;
					Photo* _tmp14_;
					_tmp11_ = _photo_it;
					if (!gee_iterator_next (_tmp11_)) {
						break;
					}
					_tmp12_ = _photo_it;
					_tmp13_ = gee_iterator_get (_tmp12_);
					photo = (Photo*) _tmp13_;
					_tmp14_ = photo;
					pixbuf_cache_prefetch (self, _tmp14_, priority, force);
					_g_object_unref0 (photo);
				}
				_g_object_unref0 (_photo_it);
			}
		}
		_g_object_unref0 (_priority_it);
	}
}

gboolean
pixbuf_cache_cancel_prefetch (PixbufCache* self,
                              Photo* photo)
{
	PixbufCacheFetchJob* job = NULL;
	GeeHashMap* _tmp0_;
	gpointer _tmp1_;
	PixbufCacheFetchJob* _tmp2_;
	gboolean removed = FALSE;
	GeeHashMap* _tmp3_;
	PixbufCacheFetchJob* _tmp4_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (photo != NULL, FALSE);
	_tmp0_ = self->priv->in_progress;
	_tmp1_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp0_, photo);
	job = (PixbufCacheFetchJob*) _tmp1_;
	_tmp2_ = job;
	if (_tmp2_ == NULL) {
		result = FALSE;
		_background_job_unref0 (job);
		return result;
	}
	_tmp3_ = self->priv->in_progress;
	removed = gee_abstract_map_unset ((GeeAbstractMap*) _tmp3_, photo, NULL);
	_vala_assert (removed, "removed");
	_tmp4_ = job;
	background_job_cancel ((BackgroundJob*) _tmp4_);
	result = TRUE;
	_background_job_unref0 (job);
	return result;
}

void
pixbuf_cache_cancel_all (PixbufCache* self)
{
	GeeHashMap* _tmp10_;
	g_return_if_fail (self != NULL);
	{
		GeeIterator* _job_it = NULL;
		GeeHashMap* _tmp0_;
		GeeCollection* _tmp1_;
		GeeCollection* _tmp2_;
		GeeCollection* _tmp3_;
		GeeIterator* _tmp4_;
		GeeIterator* _tmp5_;
		_tmp0_ = self->priv->in_progress;
		_tmp1_ = gee_abstract_map_get_values ((GeeAbstractMap*) _tmp0_);
		_tmp2_ = _tmp1_;
		_tmp3_ = _tmp2_;
		_tmp4_ = gee_iterable_iterator ((GeeIterable*) _tmp3_);
		_tmp5_ = _tmp4_;
		_g_object_unref0 (_tmp3_);
		_job_it = _tmp5_;
		while (TRUE) {
			GeeIterator* _tmp6_;
			PixbufCacheFetchJob* job = NULL;
			GeeIterator* _tmp7_;
			gpointer _tmp8_;
			PixbufCacheFetchJob* _tmp9_;
			_tmp6_ = _job_it;
			if (!gee_iterator_next (_tmp6_)) {
				break;
			}
			_tmp7_ = _job_it;
			_tmp8_ = gee_iterator_get (_tmp7_);
			job = (PixbufCacheFetchJob*) _tmp8_;
			_tmp9_ = job;
			background_job_cancel ((BackgroundJob*) _tmp9_);
			_background_job_unref0 (job);
		}
		_g_object_unref0 (_job_it);
	}
	_tmp10_ = self->priv->in_progress;
	gee_abstract_map_clear ((GeeAbstractMap*) _tmp10_);
}

static gpointer
_background_job_ref0 (gpointer self)
{
	return self ? background_job_ref (self) : NULL;
}

static void
pixbuf_cache_on_fetched (PixbufCache* self,
                         BackgroundJob* j)
{
	PixbufCacheFetchJob* job = NULL;
	PixbufCacheFetchJob* _tmp0_;
	GeeHashMap* _tmp1_;
	PixbufCacheFetchJob* _tmp2_;
	Photo* _tmp3_;
	PixbufCacheFetchJob* _tmp4_;
	GError* _tmp5_;
	PixbufCacheFetchJob* _tmp19_;
	Photo* _tmp20_;
	PixbufCacheFetchJob* _tmp21_;
	GdkPixbuf* _tmp22_;
	PixbufCacheFetchJob* _tmp23_;
	Photo* _tmp24_;
	PixbufCacheFetchJob* _tmp25_;
	GdkPixbuf* _tmp26_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (j != NULL);
	_tmp0_ = _background_job_ref0 (G_TYPE_CHECK_INSTANCE_CAST (j, PIXBUF_CACHE_TYPE_FETCH_JOB, PixbufCacheFetchJob));
	job = _tmp0_;
	_tmp1_ = self->priv->in_progress;
	_tmp2_ = job;
	_tmp3_ = _tmp2_->photo;
	gee_abstract_map_unset ((GeeAbstractMap*) _tmp1_, _tmp3_, NULL);
	_tmp4_ = job;
	_tmp5_ = _tmp4_->err;
	if (_tmp5_ != NULL) {
		PixbufCacheFetchJob* _tmp6_;
		GdkPixbuf* _tmp7_;
		PixbufCacheFetchJob* _tmp8_;
		Photo* _tmp9_;
		gchar* _tmp10_;
		gchar* _tmp11_;
		PixbufCacheFetchJob* _tmp12_;
		GError* _tmp13_;
		const gchar* _tmp14_;
		PixbufCacheFetchJob* _tmp15_;
		Photo* _tmp16_;
		PixbufCacheFetchJob* _tmp17_;
		GError* _tmp18_;
		_tmp6_ = job;
		_tmp7_ = _tmp6_->pixbuf;
		_vala_assert (_tmp7_ == NULL, "job.pixbuf == null");
		_tmp8_ = job;
		_tmp9_ = _tmp8_->photo;
		_tmp10_ = data_object_to_string ((DataObject*) _tmp9_);
		_tmp11_ = _tmp10_;
		_tmp12_ = job;
		_tmp13_ = _tmp12_->err;
		_tmp14_ = _tmp13_->message;
		g_critical ("PixbufCache.vala:275: Unable to readahead %s: %s", _tmp11_, _tmp14_);
		_g_free0 (_tmp11_);
		_tmp15_ = job;
		_tmp16_ = _tmp15_->photo;
		_tmp17_ = job;
		_tmp18_ = _tmp17_->err;
		g_signal_emit (self, pixbuf_cache_signals[PIXBUF_CACHE_FETCHED_SIGNAL], 0, _tmp16_, NULL, _tmp18_);
		_background_job_unref0 (job);
		return;
	}
	_tmp19_ = job;
	_tmp20_ = _tmp19_->photo;
	_tmp21_ = job;
	_tmp22_ = _tmp21_->pixbuf;
	pixbuf_cache_encache (self, _tmp20_, _tmp22_);
	_tmp23_ = job;
	_tmp24_ = _tmp23_->photo;
	_tmp25_ = job;
	_tmp26_ = _tmp25_->pixbuf;
	g_signal_emit (self, pixbuf_cache_signals[PIXBUF_CACHE_FETCHED_SIGNAL], 0, _tmp24_, _tmp26_, NULL);
	_background_job_unref0 (job);
}

static void
pixbuf_cache_on_sources_altered (PixbufCache* self,
                                 GeeMap* map)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (map != NULL);
	{
		GeeIterator* _object_it = NULL;
		GeeSet* _tmp0_;
		GeeSet* _tmp1_;
		GeeSet* _tmp2_;
		GeeIterator* _tmp3_;
		GeeIterator* _tmp4_;
		_tmp0_ = gee_map_get_keys (map);
		_tmp1_ = _tmp0_;
		_tmp2_ = _tmp1_;
		_tmp3_ = gee_iterable_iterator ((GeeIterable*) _tmp2_);
		_tmp4_ = _tmp3_;
		_g_object_unref0 (_tmp2_);
		_object_it = _tmp4_;
		while (TRUE) {
			GeeIterator* _tmp5_;
			DataObject* object = NULL;
			GeeIterator* _tmp6_;
			gpointer _tmp7_;
			DataObject* _tmp8_;
			gpointer _tmp9_;
			Alteration* _tmp10_;
			gboolean _tmp11_;
			Photo* photo = NULL;
			DataObject* _tmp12_;
			Photo* _tmp13_;
			GeeHashMap* _tmp14_;
			Photo* _tmp15_;
			GeeHashMap* _tmp22_;
			Photo* _tmp23_;
			Photo* _tmp24_;
			Photo* _tmp25_;
			_tmp5_ = _object_it;
			if (!gee_iterator_next (_tmp5_)) {
				break;
			}
			_tmp6_ = _object_it;
			_tmp7_ = gee_iterator_get (_tmp6_);
			object = (DataObject*) _tmp7_;
			_tmp8_ = object;
			_tmp9_ = gee_map_get (map, _tmp8_);
			_tmp10_ = (Alteration*) _tmp9_;
			_tmp11_ = !alteration_has_subject (_tmp10_, "image");
			_alteration_unref0 (_tmp10_);
			if (_tmp11_) {
				_g_object_unref0 (object);
				continue;
			}
			_tmp12_ = object;
			_tmp13_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp12_, TYPE_PHOTO, Photo));
			photo = _tmp13_;
			_tmp14_ = self->priv->in_progress;
			_tmp15_ = photo;
			if (gee_abstract_map_has_key ((GeeAbstractMap*) _tmp14_, _tmp15_)) {
				GeeHashMap* _tmp16_;
				Photo* _tmp17_;
				gpointer _tmp18_;
				PixbufCacheFetchJob* _tmp19_;
				GeeHashMap* _tmp20_;
				Photo* _tmp21_;
				_tmp16_ = self->priv->in_progress;
				_tmp17_ = photo;
				_tmp18_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp16_, _tmp17_);
				_tmp19_ = (PixbufCacheFetchJob*) _tmp18_;
				background_job_cancel ((BackgroundJob*) _tmp19_);
				_background_job_unref0 (_tmp19_);
				_tmp20_ = self->priv->in_progress;
				_tmp21_ = photo;
				gee_abstract_map_unset ((GeeAbstractMap*) _tmp20_, _tmp21_, NULL);
				_g_object_unref0 (photo);
				_g_object_unref0 (object);
				continue;
			}
			_tmp22_ = self->priv->cache;
			_tmp23_ = photo;
			if (!gee_abstract_map_has_key ((GeeAbstractMap*) _tmp22_, _tmp23_)) {
				_g_object_unref0 (photo);
				_g_object_unref0 (object);
				continue;
			}
			_tmp24_ = photo;
			pixbuf_cache_decache (self, _tmp24_);
			_tmp25_ = photo;
			pixbuf_cache_prefetch (self, _tmp25_, BACKGROUND_JOB_JOB_PRIORITY_HIGH, FALSE);
			_g_object_unref0 (photo);
			_g_object_unref0 (object);
		}
		_g_object_unref0 (_object_it);
	}
}

static void
pixbuf_cache_on_sources_removed (PixbufCache* self,
                                 GeeIterable* removed)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (removed != NULL);
	{
		GeeIterator* _object_it = NULL;
		GeeIterator* _tmp0_;
		_tmp0_ = gee_iterable_iterator (removed);
		_object_it = _tmp0_;
		while (TRUE) {
			GeeIterator* _tmp1_;
			DataObject* object = NULL;
			GeeIterator* _tmp2_;
			gpointer _tmp3_;
			Photo* photo = NULL;
			DataObject* _tmp4_;
			Photo* _tmp5_;
			Photo* _tmp6_;
			Photo* _tmp7_;
			_tmp1_ = _object_it;
			if (!gee_iterator_next (_tmp1_)) {
				break;
			}
			_tmp2_ = _object_it;
			_tmp3_ = gee_iterator_get (_tmp2_);
			object = (DataObject*) _tmp3_;
			_tmp4_ = object;
			_tmp5_ = _g_object_ref0 (IS_PHOTO (_tmp4_) ? ((Photo*) _tmp4_) : NULL);
			photo = _tmp5_;
			_tmp6_ = photo;
			_vala_assert (_tmp6_ != NULL, "photo != null");
			_tmp7_ = photo;
			pixbuf_cache_decache (self, _tmp7_);
			_g_object_unref0 (photo);
			_g_object_unref0 (object);
		}
		_g_object_unref0 (_object_it);
	}
}

static GdkPixbuf*
pixbuf_cache_get_cached (PixbufCache* self,
                         Photo* photo)
{
	GdkPixbuf* pixbuf = NULL;
	GeeHashMap* _tmp0_;
	gpointer _tmp1_;
	GdkPixbuf* _tmp2_;
	GdkPixbuf* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (photo != NULL, NULL);
	_tmp0_ = self->priv->cache;
	_tmp1_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp0_, photo);
	pixbuf = (GdkPixbuf*) _tmp1_;
	_tmp2_ = pixbuf;
	if (_tmp2_ != NULL) {
		pixbuf_cache_prioritize (self, photo);
	}
	result = pixbuf;
	return result;
}

static void
pixbuf_cache_prioritize (PixbufCache* self,
                         Photo* photo)
{
	gint index = 0;
	GeeArrayList* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (photo != NULL);
	_tmp0_ = self->priv->lru;
	index = gee_abstract_list_index_of ((GeeAbstractList*) _tmp0_, photo);
	_vala_assert (index >= 0, "index >= 0");
	if (index > 0) {
		GeeArrayList* _tmp1_;
		gpointer _tmp2_;
		Photo* _tmp3_;
		GeeArrayList* _tmp4_;
		_tmp1_ = self->priv->lru;
		_tmp2_ = gee_abstract_list_remove_at ((GeeAbstractList*) _tmp1_, index);
		_tmp3_ = (Photo*) _tmp2_;
		_g_object_unref0 (_tmp3_);
		_tmp4_ = self->priv->lru;
		gee_abstract_list_insert ((GeeAbstractList*) _tmp4_, 0, photo);
	}
}

static void
pixbuf_cache_encache (PixbufCache* self,
                      Photo* photo,
                      GdkPixbuf* pixbuf)
{
	GeeHashMap* _tmp0_;
	GeeArrayList* _tmp1_;
	GeeArrayList* _tmp13_;
	gint _tmp14_;
	gint _tmp15_;
	GeeHashMap* _tmp16_;
	gint _tmp17_;
	gint _tmp18_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (photo != NULL);
	g_return_if_fail (pixbuf != NULL);
	pixbuf_cache_decache (self, photo);
	_tmp0_ = self->priv->cache;
	gee_abstract_map_set ((GeeAbstractMap*) _tmp0_, photo, pixbuf);
	_tmp1_ = self->priv->lru;
	gee_abstract_list_insert ((GeeAbstractList*) _tmp1_, 0, photo);
	while (TRUE) {
		GeeArrayList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		Photo* cached_photo = NULL;
		GeeArrayList* _tmp5_;
		GeeArrayList* _tmp6_;
		gint _tmp7_;
		gint _tmp8_;
		gpointer _tmp9_;
		Photo* _tmp10_;
		gboolean removed = FALSE;
		GeeHashMap* _tmp11_;
		Photo* _tmp12_;
		_tmp2_ = self->priv->lru;
		_tmp3_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		if (!(_tmp4_ > self->priv->max_count)) {
			break;
		}
		_tmp5_ = self->priv->lru;
		_tmp6_ = self->priv->lru;
		_tmp7_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp6_);
		_tmp8_ = _tmp7_;
		_tmp9_ = gee_abstract_list_remove_at ((GeeAbstractList*) _tmp5_, _tmp8_ - 1);
		cached_photo = (Photo*) _tmp9_;
		_tmp10_ = cached_photo;
		_vala_assert (_tmp10_ != NULL, "cached_photo != null");
		_tmp11_ = self->priv->cache;
		_tmp12_ = cached_photo;
		removed = gee_abstract_map_unset ((GeeAbstractMap*) _tmp11_, _tmp12_, NULL);
		_vala_assert (removed, "removed");
		_g_object_unref0 (cached_photo);
	}
	_tmp13_ = self->priv->lru;
	_tmp14_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp13_);
	_tmp15_ = _tmp14_;
	_tmp16_ = self->priv->cache;
	_tmp17_ = gee_abstract_map_get_size ((GeeAbstractMap*) _tmp16_);
	_tmp18_ = _tmp17_;
	_vala_assert (_tmp15_ == _tmp18_, "lru.size == cache.size");
}

static void
pixbuf_cache_decache (PixbufCache* self,
                      Photo* photo)
{
	GeeHashMap* _tmp0_;
	gboolean removed = FALSE;
	GeeArrayList* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (photo != NULL);
	_tmp0_ = self->priv->cache;
	if (!gee_abstract_map_unset ((GeeAbstractMap*) _tmp0_, photo, NULL)) {
		GeeArrayList* _tmp1_;
		_tmp1_ = self->priv->lru;
		_vala_assert (!gee_abstract_collection_contains ((GeeAbstractCollection*) _tmp1_, photo), "!lru.contains (photo)");
		return;
	}
	_tmp2_ = self->priv->lru;
	removed = gee_abstract_collection_remove ((GeeAbstractCollection*) _tmp2_, photo);
	_vala_assert (removed, "removed");
}

static void
g_cclosure_user_marshal_VOID__OBJECT_OBJECT_BOXED (GClosure * closure,
                                                   GValue * return_value,
                                                   guint n_param_values,
                                                   const GValue * param_values,
                                                   gpointer invocation_hint,
                                                   gpointer marshal_data)
{
	typedef void (*GMarshalFunc_VOID__OBJECT_OBJECT_BOXED) (gpointer data1, gpointer arg_1, gpointer arg_2, gpointer arg_3, gpointer data2);
	register GMarshalFunc_VOID__OBJECT_OBJECT_BOXED callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 4);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__OBJECT_OBJECT_BOXED) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_object (param_values + 1), g_value_get_object (param_values + 2), g_value_get_boxed (param_values + 3), data2);
}

static gint
_background_job_job_priority_compare_func_gcompare_data_func (gconstpointer a,
                                                              gconstpointer b,
                                                              gpointer self)
{
	gint result;
	result = background_job_job_priority_compare_func (a, b);
	return result;
}

PixbufCachePixbufCacheBatch*
pixbuf_cache_pixbuf_cache_batch_construct (GType object_type)
{
	PixbufCachePixbufCacheBatch * self = NULL;
	self = (PixbufCachePixbufCacheBatch*) gee_tree_multi_map_construct (object_type, BACKGROUND_JOB_TYPE_JOB_PRIORITY, NULL, NULL, TYPE_PHOTO, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, _background_job_job_priority_compare_func_gcompare_data_func, NULL, NULL, NULL, NULL, NULL);
	return self;
}

PixbufCachePixbufCacheBatch*
pixbuf_cache_pixbuf_cache_batch_new (void)
{
	return pixbuf_cache_pixbuf_cache_batch_construct (PIXBUF_CACHE_TYPE_PIXBUF_CACHE_BATCH);
}

static void
pixbuf_cache_pixbuf_cache_batch_class_init (PixbufCachePixbufCacheBatchClass * klass,
                                            gpointer klass_data)
{
	pixbuf_cache_pixbuf_cache_batch_parent_class = g_type_class_peek_parent (klass);
}

static void
pixbuf_cache_pixbuf_cache_batch_instance_init (PixbufCachePixbufCacheBatch * self,
                                               gpointer klass)
{
}

static GType
pixbuf_cache_pixbuf_cache_batch_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (PixbufCachePixbufCacheBatchClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) pixbuf_cache_pixbuf_cache_batch_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PixbufCachePixbufCacheBatch), 0, (GInstanceInitFunc) pixbuf_cache_pixbuf_cache_batch_instance_init, NULL };
	GType pixbuf_cache_pixbuf_cache_batch_type_id;
	pixbuf_cache_pixbuf_cache_batch_type_id = g_type_register_static (GEE_TYPE_TREE_MULTI_MAP, "PixbufCachePixbufCacheBatch", &g_define_type_info, 0);
	return pixbuf_cache_pixbuf_cache_batch_type_id;
}

GType
pixbuf_cache_pixbuf_cache_batch_get_type (void)
{
	static volatile gsize pixbuf_cache_pixbuf_cache_batch_type_id__once = 0;
	if (g_once_init_enter (&pixbuf_cache_pixbuf_cache_batch_type_id__once)) {
		GType pixbuf_cache_pixbuf_cache_batch_type_id;
		pixbuf_cache_pixbuf_cache_batch_type_id = pixbuf_cache_pixbuf_cache_batch_get_type_once ();
		g_once_init_leave (&pixbuf_cache_pixbuf_cache_batch_type_id__once, pixbuf_cache_pixbuf_cache_batch_type_id);
	}
	return pixbuf_cache_pixbuf_cache_batch_type_id__once;
}

static PixbufCacheFetchJob*
pixbuf_cache_fetch_job_construct (GType object_type,
                                  PixbufCache* owner,
                                  BackgroundJobJobPriority priority,
                                  Photo* photo,
                                  Scaling* scaling,
                                  CompletionCallback callback,
                                  gpointer callback_target)
{
	PixbufCacheFetchJob* self = NULL;
	GCancellable* _tmp0_;
	GCancellable* _tmp1_;
	Semaphore* _tmp2_;
	Semaphore* _tmp3_;
	Photo* _tmp4_;
	Scaling _tmp5_;
	g_return_val_if_fail (owner != NULL, NULL);
	g_return_val_if_fail (photo != NULL, NULL);
	g_return_val_if_fail (scaling != NULL, NULL);
	_tmp0_ = g_cancellable_new ();
	_tmp1_ = _tmp0_;
	_tmp2_ = semaphore_new ();
	_tmp3_ = _tmp2_;
	self = (PixbufCacheFetchJob*) background_job_construct (object_type, (GObject*) owner, callback, callback_target, _tmp1_, NULL, NULL, (AbstractSemaphore*) _tmp3_);
	_abstract_semaphore_unref0 (_tmp3_);
	_g_object_unref0 (_tmp1_);
	self->priority = priority;
	_tmp4_ = _g_object_ref0 (photo);
	_g_object_unref0 (self->photo);
	self->photo = _tmp4_;
	_tmp5_ = *scaling;
	self->scaling = _tmp5_;
	return self;
}

static BackgroundJobJobPriority
pixbuf_cache_fetch_job_real_get_priority (BackgroundJob* base)
{
	PixbufCacheFetchJob * self;
	BackgroundJobJobPriority result;
	self = (PixbufCacheFetchJob*) base;
	result = self->priority;
	return result;
}

static void
pixbuf_cache_fetch_job_class_init (PixbufCacheFetchJobClass * klass,
                                   gpointer klass_data)
{
	pixbuf_cache_fetch_job_parent_class = g_type_class_peek_parent (klass);
	((BackgroundJobClass *) klass)->finalize = pixbuf_cache_fetch_job_finalize;
	((BackgroundJobClass *) klass)->get_priority = (BackgroundJobJobPriority (*) (BackgroundJob*)) pixbuf_cache_fetch_job_real_get_priority;
}

static void
pixbuf_cache_fetch_job_instance_init (PixbufCacheFetchJob * self,
                                      gpointer klass)
{
	self->pixbuf = NULL;
	self->err = NULL;
}

static void
pixbuf_cache_fetch_job_finalize (BackgroundJob * obj)
{
	PixbufCacheFetchJob * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, PIXBUF_CACHE_TYPE_FETCH_JOB, PixbufCacheFetchJob);
	_g_object_unref0 (self->photo);
	_g_object_unref0 (self->pixbuf);
	_g_error_free0 (self->err);
	BACKGROUND_JOB_CLASS (pixbuf_cache_fetch_job_parent_class)->finalize (obj);
}

static GType
pixbuf_cache_fetch_job_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (PixbufCacheFetchJobClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) pixbuf_cache_fetch_job_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PixbufCacheFetchJob), 0, (GInstanceInitFunc) pixbuf_cache_fetch_job_instance_init, NULL };
	GType pixbuf_cache_fetch_job_type_id;
	pixbuf_cache_fetch_job_type_id = g_type_register_static (TYPE_BACKGROUND_JOB, "PixbufCacheFetchJob", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
	return pixbuf_cache_fetch_job_type_id;
}

static GType
pixbuf_cache_fetch_job_get_type (void)
{
	static volatile gsize pixbuf_cache_fetch_job_type_id__once = 0;
	if (g_once_init_enter (&pixbuf_cache_fetch_job_type_id__once)) {
		GType pixbuf_cache_fetch_job_type_id;
		pixbuf_cache_fetch_job_type_id = pixbuf_cache_fetch_job_get_type_once ();
		g_once_init_leave (&pixbuf_cache_fetch_job_type_id__once, pixbuf_cache_fetch_job_type_id);
	}
	return pixbuf_cache_fetch_job_type_id__once;
}

static PixbufCacheBaselineFetchJob*
pixbuf_cache_baseline_fetch_job_construct (GType object_type,
                                           PixbufCache* owner,
                                           BackgroundJobJobPriority priority,
                                           Photo* photo,
                                           Scaling* scaling,
                                           CompletionCallback callback,
                                           gpointer callback_target)
{
	PixbufCacheBaselineFetchJob* self = NULL;
	Scaling _tmp0_;
	g_return_val_if_fail (owner != NULL, NULL);
	g_return_val_if_fail (photo != NULL, NULL);
	g_return_val_if_fail (scaling != NULL, NULL);
	_tmp0_ = *scaling;
	self = (PixbufCacheBaselineFetchJob*) pixbuf_cache_fetch_job_construct (object_type, owner, priority, photo, &_tmp0_, callback, callback_target);
	return self;
}

static PixbufCacheBaselineFetchJob*
pixbuf_cache_baseline_fetch_job_new (PixbufCache* owner,
                                     BackgroundJobJobPriority priority,
                                     Photo* photo,
                                     Scaling* scaling,
                                     CompletionCallback callback,
                                     gpointer callback_target)
{
	return pixbuf_cache_baseline_fetch_job_construct (PIXBUF_CACHE_TYPE_BASELINE_FETCH_JOB, owner, priority, photo, scaling, callback, callback_target);
}

static void
pixbuf_cache_baseline_fetch_job_real_execute (BackgroundJob* base)
{
	PixbufCacheBaselineFetchJob * self;
	GError* _inner_error0_ = NULL;
	self = (PixbufCacheBaselineFetchJob*) base;
	{
		GdkPixbuf* _tmp0_ = NULL;
		Photo* _tmp1_;
		Scaling _tmp2_;
		GdkPixbuf* _tmp3_;
		GdkPixbuf* _tmp4_;
		_tmp1_ = ((PixbufCacheFetchJob*) self)->photo;
		_tmp2_ = ((PixbufCacheFetchJob*) self)->scaling;
		_tmp3_ = photo_source_get_pixbuf ((PhotoSource*) _tmp1_, &_tmp2_, &_inner_error0_);
		_tmp0_ = _tmp3_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp4_ = _tmp0_;
		_tmp0_ = NULL;
		_g_object_unref0 (((PixbufCacheFetchJob*) self)->pixbuf);
		((PixbufCacheFetchJob*) self)->pixbuf = _tmp4_;
		_g_object_unref0 (_tmp0_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* err = NULL;
		GError* _tmp5_;
		GError* _tmp6_;
		err = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp5_ = err;
		_tmp6_ = _g_error_copy0 (_tmp5_);
		_g_error_free0 (((PixbufCacheFetchJob*) self)->err);
		((PixbufCacheFetchJob*) self)->err = _tmp6_;
		_g_error_free0 (err);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
pixbuf_cache_baseline_fetch_job_class_init (PixbufCacheBaselineFetchJobClass * klass,
                                            gpointer klass_data)
{
	pixbuf_cache_baseline_fetch_job_parent_class = g_type_class_peek_parent (klass);
	((BackgroundJobClass *) klass)->execute = (void (*) (BackgroundJob*)) pixbuf_cache_baseline_fetch_job_real_execute;
}

static void
pixbuf_cache_baseline_fetch_job_instance_init (PixbufCacheBaselineFetchJob * self,
                                               gpointer klass)
{
}

static GType
pixbuf_cache_baseline_fetch_job_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (PixbufCacheBaselineFetchJobClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) pixbuf_cache_baseline_fetch_job_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PixbufCacheBaselineFetchJob), 0, (GInstanceInitFunc) pixbuf_cache_baseline_fetch_job_instance_init, NULL };
	GType pixbuf_cache_baseline_fetch_job_type_id;
	pixbuf_cache_baseline_fetch_job_type_id = g_type_register_static (PIXBUF_CACHE_TYPE_FETCH_JOB, "PixbufCacheBaselineFetchJob", &g_define_type_info, 0);
	return pixbuf_cache_baseline_fetch_job_type_id;
}

static GType
pixbuf_cache_baseline_fetch_job_get_type (void)
{
	static volatile gsize pixbuf_cache_baseline_fetch_job_type_id__once = 0;
	if (g_once_init_enter (&pixbuf_cache_baseline_fetch_job_type_id__once)) {
		GType pixbuf_cache_baseline_fetch_job_type_id;
		pixbuf_cache_baseline_fetch_job_type_id = pixbuf_cache_baseline_fetch_job_get_type_once ();
		g_once_init_leave (&pixbuf_cache_baseline_fetch_job_type_id__once, pixbuf_cache_baseline_fetch_job_type_id);
	}
	return pixbuf_cache_baseline_fetch_job_type_id__once;
}

static PixbufCacheMasterFetchJob*
pixbuf_cache_master_fetch_job_construct (GType object_type,
                                         PixbufCache* owner,
                                         BackgroundJobJobPriority priority,
                                         Photo* photo,
                                         Scaling* scaling,
                                         CompletionCallback callback,
                                         gpointer callback_target)
{
	PixbufCacheMasterFetchJob* self = NULL;
	Scaling _tmp0_;
	g_return_val_if_fail (owner != NULL, NULL);
	g_return_val_if_fail (photo != NULL, NULL);
	g_return_val_if_fail (scaling != NULL, NULL);
	_tmp0_ = *scaling;
	self = (PixbufCacheMasterFetchJob*) pixbuf_cache_fetch_job_construct (object_type, owner, priority, photo, &_tmp0_, callback, callback_target);
	return self;
}

static PixbufCacheMasterFetchJob*
pixbuf_cache_master_fetch_job_new (PixbufCache* owner,
                                   BackgroundJobJobPriority priority,
                                   Photo* photo,
                                   Scaling* scaling,
                                   CompletionCallback callback,
                                   gpointer callback_target)
{
	return pixbuf_cache_master_fetch_job_construct (PIXBUF_CACHE_TYPE_MASTER_FETCH_JOB, owner, priority, photo, scaling, callback, callback_target);
}

static void
pixbuf_cache_master_fetch_job_real_execute (BackgroundJob* base)
{
	PixbufCacheMasterFetchJob * self;
	GError* _inner_error0_ = NULL;
	self = (PixbufCacheMasterFetchJob*) base;
	{
		GdkPixbuf* _tmp0_ = NULL;
		Photo* _tmp1_;
		Scaling _tmp2_;
		GdkPixbuf* _tmp3_;
		GdkPixbuf* _tmp4_;
		_tmp1_ = ((PixbufCacheFetchJob*) self)->photo;
		_tmp2_ = ((PixbufCacheFetchJob*) self)->scaling;
		_tmp3_ = photo_get_master_pixbuf (_tmp1_, &_tmp2_, TRUE, &_inner_error0_);
		_tmp0_ = _tmp3_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp4_ = _tmp0_;
		_tmp0_ = NULL;
		_g_object_unref0 (((PixbufCacheFetchJob*) self)->pixbuf);
		((PixbufCacheFetchJob*) self)->pixbuf = _tmp4_;
		_g_object_unref0 (_tmp0_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* err = NULL;
		GError* _tmp5_;
		GError* _tmp6_;
		err = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp5_ = err;
		_tmp6_ = _g_error_copy0 (_tmp5_);
		_g_error_free0 (((PixbufCacheFetchJob*) self)->err);
		((PixbufCacheFetchJob*) self)->err = _tmp6_;
		_g_error_free0 (err);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
pixbuf_cache_master_fetch_job_class_init (PixbufCacheMasterFetchJobClass * klass,
                                          gpointer klass_data)
{
	pixbuf_cache_master_fetch_job_parent_class = g_type_class_peek_parent (klass);
	((BackgroundJobClass *) klass)->execute = (void (*) (BackgroundJob*)) pixbuf_cache_master_fetch_job_real_execute;
}

static void
pixbuf_cache_master_fetch_job_instance_init (PixbufCacheMasterFetchJob * self,
                                             gpointer klass)
{
}

static GType
pixbuf_cache_master_fetch_job_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (PixbufCacheMasterFetchJobClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) pixbuf_cache_master_fetch_job_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PixbufCacheMasterFetchJob), 0, (GInstanceInitFunc) pixbuf_cache_master_fetch_job_instance_init, NULL };
	GType pixbuf_cache_master_fetch_job_type_id;
	pixbuf_cache_master_fetch_job_type_id = g_type_register_static (PIXBUF_CACHE_TYPE_FETCH_JOB, "PixbufCacheMasterFetchJob", &g_define_type_info, 0);
	return pixbuf_cache_master_fetch_job_type_id;
}

static GType
pixbuf_cache_master_fetch_job_get_type (void)
{
	static volatile gsize pixbuf_cache_master_fetch_job_type_id__once = 0;
	if (g_once_init_enter (&pixbuf_cache_master_fetch_job_type_id__once)) {
		GType pixbuf_cache_master_fetch_job_type_id;
		pixbuf_cache_master_fetch_job_type_id = pixbuf_cache_master_fetch_job_get_type_once ();
		g_once_init_leave (&pixbuf_cache_master_fetch_job_type_id__once, pixbuf_cache_master_fetch_job_type_id);
	}
	return pixbuf_cache_master_fetch_job_type_id__once;
}

static void
pixbuf_cache_class_init (PixbufCacheClass * klass,
                         gpointer klass_data)
{
	pixbuf_cache_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &PixbufCache_private_offset);
	G_OBJECT_CLASS (klass)->finalize = pixbuf_cache_finalize;
	pixbuf_cache_signals[PIXBUF_CACHE_FETCHED_SIGNAL] = g_signal_new ("fetched", TYPE_PIXBUF_CACHE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__OBJECT_OBJECT_BOXED, G_TYPE_NONE, 3, TYPE_PHOTO, gdk_pixbuf_get_type (), G_TYPE_ERROR);
}

static void
pixbuf_cache_instance_init (PixbufCache * self,
                            gpointer klass)
{
	GeeHashMap* _tmp0_;
	GeeArrayList* _tmp1_;
	GeeHashMap* _tmp2_;
	self->priv = pixbuf_cache_get_instance_private (self);
	_tmp0_ = gee_hash_map_new (TYPE_PHOTO, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, gdk_pixbuf_get_type (), (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	self->priv->cache = _tmp0_;
	_tmp1_ = gee_array_list_new (TYPE_PHOTO, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	self->priv->lru = _tmp1_;
	_tmp2_ = gee_hash_map_new (TYPE_PHOTO, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, PIXBUF_CACHE_TYPE_FETCH_JOB, (GBoxedCopyFunc) background_job_ref, (GDestroyNotify) background_job_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	self->priv->in_progress = _tmp2_;
}

static void
pixbuf_cache_finalize (GObject * obj)
{
	PixbufCache * self;
	SourceCollection* _tmp2_;
	guint _tmp3_;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_PIXBUF_CACHE, PixbufCache);
	if (self->priv->type != PIXBUF_CACHE_PHOTO_TYPE_MASTER) {
		SourceCollection* _tmp0_;
		guint _tmp1_;
		_tmp0_ = self->priv->sources;
		g_signal_parse_name ("items-altered", TYPE_DATA_COLLECTION, &_tmp1_, NULL, FALSE);
		g_signal_handlers_disconnect_matched ((DataCollection*) _tmp0_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp1_, 0, NULL, (GCallback) _pixbuf_cache_on_sources_altered_data_collection_items_altered, self);
	}
	_tmp2_ = self->priv->sources;
	g_signal_parse_name ("items-removed", TYPE_DATA_COLLECTION, &_tmp3_, NULL, FALSE);
	g_signal_handlers_disconnect_matched ((DataCollection*) _tmp2_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp3_, 0, NULL, (GCallback) _pixbuf_cache_on_sources_removed_data_collection_items_removed, self);
	{
		GeeIterator* _job_it = NULL;
		GeeHashMap* _tmp4_;
		GeeCollection* _tmp5_;
		GeeCollection* _tmp6_;
		GeeCollection* _tmp7_;
		GeeIterator* _tmp8_;
		GeeIterator* _tmp9_;
		_tmp4_ = self->priv->in_progress;
		_tmp5_ = gee_abstract_map_get_values ((GeeAbstractMap*) _tmp4_);
		_tmp6_ = _tmp5_;
		_tmp7_ = _tmp6_;
		_tmp8_ = gee_iterable_iterator ((GeeIterable*) _tmp7_);
		_tmp9_ = _tmp8_;
		_g_object_unref0 (_tmp7_);
		_job_it = _tmp9_;
		while (TRUE) {
			GeeIterator* _tmp10_;
			PixbufCacheFetchJob* job = NULL;
			GeeIterator* _tmp11_;
			gpointer _tmp12_;
			PixbufCacheFetchJob* _tmp13_;
			_tmp10_ = _job_it;
			if (!gee_iterator_next (_tmp10_)) {
				break;
			}
			_tmp11_ = _job_it;
			_tmp12_ = gee_iterator_get (_tmp11_);
			job = (PixbufCacheFetchJob*) _tmp12_;
			_tmp13_ = job;
			background_job_cancel ((BackgroundJob*) _tmp13_);
			_background_job_unref0 (job);
		}
		_g_object_unref0 (_job_it);
	}
	_data_collection_unref0 (self->priv->sources);
	_g_object_unref0 (self->priv->cache);
	_g_object_unref0 (self->priv->lru);
	_g_object_unref0 (self->priv->in_progress);
	G_OBJECT_CLASS (pixbuf_cache_parent_class)->finalize (obj);
}

static GType
pixbuf_cache_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (PixbufCacheClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) pixbuf_cache_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PixbufCache), 0, (GInstanceInitFunc) pixbuf_cache_instance_init, NULL };
	GType pixbuf_cache_type_id;
	pixbuf_cache_type_id = g_type_register_static (G_TYPE_OBJECT, "PixbufCache", &g_define_type_info, 0);
	PixbufCache_private_offset = g_type_add_instance_private (pixbuf_cache_type_id, sizeof (PixbufCachePrivate));
	return pixbuf_cache_type_id;
}

GType
pixbuf_cache_get_type (void)
{
	static volatile gsize pixbuf_cache_type_id__once = 0;
	if (g_once_init_enter (&pixbuf_cache_type_id__once)) {
		GType pixbuf_cache_type_id;
		pixbuf_cache_type_id = pixbuf_cache_get_type_once ();
		g_once_init_leave (&pixbuf_cache_type_id__once, pixbuf_cache_type_id);
	}
	return pixbuf_cache_type_id__once;
}

