/* PreferencesDialog.c generated by valac 0.56.18, the Vala compiler
 * generated from PreferencesDialog.vala, do not modify */

/*
* Copyright (c) 2009-2013 Yorba Foundation
*               2017 elementary  LLC. (https://github.com/elementary/photos)
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU Lesser General Public
* License as published by the Free Software Foundation; either
* version 2.1 of the License, or (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
* General Public License for more details.
*
* You should have received a copy of the GNU General Public
* License along with this program; if not, write to the
* Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
* Boston, MA 02110-1301 USA
*/

#include "io.elementary.photos.h"
#include <granite.h>
#include <gtk/gtk.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gio/gio.h>
#include <glib-object.h>
#include <gdk/gdk.h>
#include <glib/gi18n-lib.h>
#include <gobject/gvaluecollector.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _preferences_dialog_unref0(var) ((var == NULL) ? NULL : (var = (preferences_dialog_unref (var), NULL)))

#define PREFERENCES_DIALOG_TYPE_PATH_FORMAT (preferences_dialog_path_format_get_type ())
#define PREFERENCES_DIALOG_PATH_FORMAT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), PREFERENCES_DIALOG_TYPE_PATH_FORMAT, PreferencesDialogPathFormat))
#define PREFERENCES_DIALOG_PATH_FORMAT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), PREFERENCES_DIALOG_TYPE_PATH_FORMAT, PreferencesDialogPathFormatClass))
#define PREFERENCES_DIALOG_IS_PATH_FORMAT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), PREFERENCES_DIALOG_TYPE_PATH_FORMAT))
#define PREFERENCES_DIALOG_IS_PATH_FORMAT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), PREFERENCES_DIALOG_TYPE_PATH_FORMAT))
#define PREFERENCES_DIALOG_PATH_FORMAT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), PREFERENCES_DIALOG_TYPE_PATH_FORMAT, PreferencesDialogPathFormatClass))

typedef struct _PreferencesDialogPathFormat PreferencesDialogPathFormat;
typedef struct _PreferencesDialogPathFormatClass PreferencesDialogPathFormatClass;
typedef struct _PreferencesDialogPathFormatPrivate PreferencesDialogPathFormatPrivate;
typedef struct _PreferencesDialogParamSpecPathFormat PreferencesDialogParamSpecPathFormat;
typedef struct _ParamSpecPreferencesDialog ParamSpecPreferencesDialog;

struct _PreferencesDialogPrivate {
	GraniteDialog* dialog;
	GtkFileChooserButton* library_dir_button;
	gchar* lib_dir;
	GtkComboBoxText* default_raw_developer_combo;
	GSettings* file_settings;
};

struct _PreferencesDialogPathFormat {
	GTypeInstance parent_instance;
	volatile int ref_count;
	PreferencesDialogPathFormatPrivate * priv;
	gchar* name;
	gchar* pattern;
};

struct _PreferencesDialogPathFormatClass {
	GTypeClass parent_class;
	void (*finalize) (PreferencesDialogPathFormat *self);
};

struct _PreferencesDialogParamSpecPathFormat {
	GParamSpec parent_instance;
};

struct _ParamSpecPreferencesDialog {
	GParamSpec parent_instance;
};

static gint PreferencesDialog_private_offset;
static gpointer preferences_dialog_parent_class = NULL;
static PreferencesDialog* preferences_dialog_preferences_dialog;
static PreferencesDialog* preferences_dialog_preferences_dialog = NULL;
static gpointer preferences_dialog_path_format_parent_class = NULL;

static PreferencesDialog* preferences_dialog_new (void);
static PreferencesDialog* preferences_dialog_construct (GType object_type);
static gboolean preferences_dialog_on_delete (PreferencesDialog* self);
static gboolean _preferences_dialog_on_delete_gtk_widget_delete_event (GtkWidget* _sender,
                                                                GdkEventAny* event,
                                                                gpointer self);
static gboolean preferences_dialog_map_event_handler (PreferencesDialog* self);
static gboolean _preferences_dialog_map_event_handler_gtk_widget_map_event (GtkWidget* _sender,
                                                                     GdkEventAny* event,
                                                                     gpointer self);
static void preferences_dialog_set_raw_developer_combo (PreferencesDialog* self,
                                                 RawDeveloper d);
static void preferences_dialog_on_default_raw_developer_changed (PreferencesDialog* self);
static void _preferences_dialog_on_default_raw_developer_changed_gtk_combo_box_changed (GtkComboBox* _sender,
                                                                                 gpointer self);
static void preferences_dialog_on_close (PreferencesDialog* self);
static void _preferences_dialog_on_close_gtk_button_clicked (GtkButton* _sender,
                                                      gpointer self);
VALA_EXTERN GFile* app_dirs_get_import_dir (void);
static void preferences_dialog_commit_on_close (PreferencesDialog* self);
VALA_EXTERN void app_dirs_set_import_dir (const gchar* path);
static RawDeveloper preferences_dialog_raw_developer_from_combo (PreferencesDialog* self);
static void preferences_dialog_on_current_folder_changed (PreferencesDialog* self);
static void _preferences_dialog_on_current_folder_changed_gtk_file_chooser_current_folder_changed (GtkFileChooser* _sender,
                                                                                            gpointer self);
static gpointer preferences_dialog_path_format_ref (gpointer instance);
static void preferences_dialog_path_format_unref (gpointer instance);
static GParamSpec* preferences_dialog_param_spec_path_format (const gchar* name,
                                                       const gchar* nick,
                                                       const gchar* blurb,
                                                       GType object_type,
                                                       GParamFlags flags) G_GNUC_UNUSED ;
static void preferences_dialog_value_set_path_format (GValue* value,
                                               gpointer v_object) G_GNUC_UNUSED ;
static void preferences_dialog_value_take_path_format (GValue* value,
                                                gpointer v_object) G_GNUC_UNUSED ;
static gpointer preferences_dialog_value_get_path_format (const GValue* value) G_GNUC_UNUSED ;
static GType preferences_dialog_path_format_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
static PreferencesDialogPathFormat* preferences_dialog_path_format_new (const gchar* name,
                                                                 const gchar* pattern);
static PreferencesDialogPathFormat* preferences_dialog_path_format_construct (GType object_type,
                                                                       const gchar* name,
                                                                       const gchar* pattern);
static void preferences_dialog_path_format_finalize (PreferencesDialogPathFormat * obj);
static GType preferences_dialog_path_format_get_type_once (void);
static void preferences_dialog_finalize (PreferencesDialog * obj);
static GType preferences_dialog_get_type_once (void);

static inline gpointer
preferences_dialog_get_instance_private (PreferencesDialog* self)
{
	return G_STRUCT_MEMBER_P (self, PreferencesDialog_private_offset);
}

static gboolean
_preferences_dialog_on_delete_gtk_widget_delete_event (GtkWidget* _sender,
                                                       GdkEventAny* event,
                                                       gpointer self)
{
	gboolean result;
	result = preferences_dialog_on_delete ((PreferencesDialog*) self);
	return result;
}

static gboolean
_preferences_dialog_map_event_handler_gtk_widget_map_event (GtkWidget* _sender,
                                                            GdkEventAny* event,
                                                            gpointer self)
{
	gboolean result;
	result = preferences_dialog_map_event_handler ((PreferencesDialog*) self);
	return result;
}

static void
_preferences_dialog_on_default_raw_developer_changed_gtk_combo_box_changed (GtkComboBox* _sender,
                                                                            gpointer self)
{
	preferences_dialog_on_default_raw_developer_changed ((PreferencesDialog*) self);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
_preferences_dialog_on_close_gtk_button_clicked (GtkButton* _sender,
                                                 gpointer self)
{
	preferences_dialog_on_close ((PreferencesDialog*) self);
}

static PreferencesDialog*
preferences_dialog_construct (GType object_type)
{
	PreferencesDialog* self = NULL;
	GSettings* _tmp0_;
	GraniteDialog* _tmp1_;
	GraniteDialog* _tmp2_;
	GraniteDialog* _tmp3_;
	GraniteDialog* _tmp4_;
	GraniteDialog* _tmp5_;
	GraniteDialog* _tmp6_;
	GraniteDialog* _tmp7_;
	AppWindow* _tmp8_;
	AppWindow* _tmp9_;
	GdkWindow* _tmp10_;
	GraniteHeaderLabel* library_header = NULL;
	GraniteHeaderLabel* _tmp11_;
	GtkFileChooserButton* _tmp12_;
	GtkLabel* library_dir_label = NULL;
	GtkLabel* _tmp13_;
	GtkFileChooserButton* _tmp14_;
	GtkLabel* auto_import_label = NULL;
	GtkLabel* _tmp15_;
	GtkSwitch* auto_import_switch = NULL;
	GtkSwitch* _tmp16_;
	GtkSwitch* lowercase_switch = NULL;
	GtkSwitch* _tmp17_;
	GtkLabel* lowercase_label = NULL;
	GtkLabel* _tmp18_;
	GtkSwitch* commit_metadata_switch = NULL;
	GtkSwitch* _tmp19_;
	GtkLabel* commit_metadata_label = NULL;
	GtkLabel* _tmp20_;
	GraniteHeaderLabel* raw_header = NULL;
	GraniteHeaderLabel* _tmp21_;
	GtkComboBoxText* _tmp22_;
	GtkComboBoxText* _tmp23_;
	gchar* _tmp24_;
	gchar* _tmp25_;
	GtkComboBoxText* _tmp26_;
	gchar* _tmp27_;
	gchar* _tmp28_;
	GSettings* _tmp29_;
	gchar* _tmp30_;
	gchar* _tmp31_;
	GtkComboBoxText* _tmp32_;
	GtkLabel* default_raw_developer_label = NULL;
	GtkLabel* _tmp33_;
	GtkComboBoxText* _tmp34_;
	GtkGrid* library_grid = NULL;
	GtkGrid* _tmp35_;
	GtkFileChooserButton* _tmp36_;
	GtkComboBoxText* _tmp37_;
	PluginsManifestWidget* manifest_widget = NULL;
	PluginsManifestWidget* _tmp38_;
	GtkStack* stack = NULL;
	GtkStack* _tmp39_;
	GtkStackSwitcher* switcher = NULL;
	GtkStackSwitcher* _tmp40_;
	GtkBox* content = NULL;
	GraniteDialog* _tmp41_;
	GtkBox* _tmp42_;
	GtkBox* _tmp43_;
	GtkWidget* close_button = NULL;
	GraniteDialog* _tmp44_;
	GtkWidget* _tmp45_;
	GtkWidget* _tmp46_;
	GSettings* file_settings = NULL;
	GSettings* _tmp47_;
	self = (PreferencesDialog*) g_type_create_instance (object_type);
	_tmp0_ = g_settings_new (GSETTINGS_CONFIGURATION_ENGINE_FILES_PREFS_SCHEMA_NAME);
	_g_object_unref0 (self->priv->file_settings);
	self->priv->file_settings = _tmp0_;
	_tmp1_ = granite_dialog_new ();
	g_object_ref_sink (_tmp1_);
	_g_object_unref0 (self->priv->dialog);
	self->priv->dialog = _tmp1_;
	_tmp2_ = self->priv->dialog;
	g_object_set ((GtkWidget*) _tmp2_, "width-request", 450, NULL);
	_tmp3_ = self->priv->dialog;
	gtk_window_set_resizable ((GtkWindow*) _tmp3_, FALSE);
	_tmp4_ = self->priv->dialog;
	gtk_window_set_deletable ((GtkWindow*) _tmp4_, FALSE);
	_tmp5_ = self->priv->dialog;
	g_signal_connect ((GtkWidget*) _tmp5_, "delete-event", (GCallback) _preferences_dialog_on_delete_gtk_widget_delete_event, self);
	_tmp6_ = self->priv->dialog;
	g_signal_connect ((GtkWidget*) _tmp6_, "map-event", (GCallback) _preferences_dialog_map_event_handler_gtk_widget_map_event, self);
	_tmp7_ = self->priv->dialog;
	_tmp8_ = app_window_get_instance ();
	_tmp9_ = _tmp8_;
	_tmp10_ = gtk_widget_get_parent_window ((GtkWidget*) _tmp9_);
	gtk_widget_set_parent_window ((GtkWidget*) _tmp7_, _tmp10_);
	_g_object_unref0 (_tmp9_);
	_tmp11_ = granite_header_label_new (_ ("Library"));
	g_object_ref_sink (_tmp11_);
	library_header = _tmp11_;
	_tmp12_ = (GtkFileChooserButton*) gtk_file_chooser_button_new ("", GTK_FILE_CHOOSER_ACTION_SELECT_FOLDER);
	g_object_ref_sink (_tmp12_);
	_g_object_unref0 (self->priv->library_dir_button);
	self->priv->library_dir_button = _tmp12_;
	_tmp13_ = (GtkLabel*) gtk_label_new_with_mnemonic (_ ("_Import photos to:"));
	g_object_ref_sink (_tmp13_);
	library_dir_label = _tmp13_;
	gtk_widget_set_halign ((GtkWidget*) library_dir_label, GTK_ALIGN_END);
	_tmp14_ = self->priv->library_dir_button;
	gtk_label_set_mnemonic_widget (library_dir_label, (GtkWidget*) _tmp14_);
	_tmp15_ = (GtkLabel*) gtk_label_new (_ ("Watch library for new files:"));
	g_object_ref_sink (_tmp15_);
	auto_import_label = _tmp15_;
	gtk_widget_set_halign ((GtkWidget*) auto_import_label, GTK_ALIGN_END);
	_tmp16_ = (GtkSwitch*) gtk_switch_new ();
	g_object_ref_sink (_tmp16_);
	auto_import_switch = _tmp16_;
	gtk_widget_set_halign ((GtkWidget*) auto_import_switch, GTK_ALIGN_START);
	_tmp17_ = (GtkSwitch*) gtk_switch_new ();
	g_object_ref_sink (_tmp17_);
	lowercase_switch = _tmp17_;
	gtk_widget_set_halign ((GtkWidget*) lowercase_switch, GTK_ALIGN_START);
	_tmp18_ = (GtkLabel*) gtk_label_new_with_mnemonic (_ ("R_ename imported files to lowercase:"));
	g_object_ref_sink (_tmp18_);
	lowercase_label = _tmp18_;
	gtk_widget_set_halign ((GtkWidget*) lowercase_label, GTK_ALIGN_END);
	gtk_label_set_mnemonic_widget (lowercase_label, (GtkWidget*) lowercase_switch);
	_tmp19_ = (GtkSwitch*) gtk_switch_new ();
	g_object_ref_sink (_tmp19_);
	commit_metadata_switch = _tmp19_;
	gtk_widget_set_halign ((GtkWidget*) commit_metadata_switch, GTK_ALIGN_START);
	_tmp20_ = (GtkLabel*) gtk_label_new_with_mnemonic (_ ("Write _metadata to files:"));
	g_object_ref_sink (_tmp20_);
	commit_metadata_label = _tmp20_;
	gtk_widget_set_halign ((GtkWidget*) commit_metadata_label, GTK_ALIGN_END);
	gtk_label_set_mnemonic_widget (commit_metadata_label, (GtkWidget*) commit_metadata_switch);
	_tmp21_ = granite_header_label_new (_ ("RAW Developer"));
	g_object_ref_sink (_tmp21_);
	raw_header = _tmp21_;
	_tmp22_ = (GtkComboBoxText*) gtk_combo_box_text_new ();
	g_object_ref_sink (_tmp22_);
	_g_object_unref0 (self->priv->default_raw_developer_combo);
	self->priv->default_raw_developer_combo = _tmp22_;
	_tmp23_ = self->priv->default_raw_developer_combo;
	_tmp24_ = raw_developer_get_label (RAW_DEVELOPER_CAMERA);
	_tmp25_ = _tmp24_;
	gtk_combo_box_text_append_text (_tmp23_, _tmp25_);
	_g_free0 (_tmp25_);
	_tmp26_ = self->priv->default_raw_developer_combo;
	_tmp27_ = raw_developer_get_label (RAW_DEVELOPER_SHOTWELL);
	_tmp28_ = _tmp27_;
	gtk_combo_box_text_append_text (_tmp26_, _tmp28_);
	_g_free0 (_tmp28_);
	_tmp29_ = self->priv->file_settings;
	_tmp30_ = g_settings_get_string (_tmp29_, "raw-developer-default");
	_tmp31_ = _tmp30_;
	preferences_dialog_set_raw_developer_combo (self, raw_developer_from_string (_tmp31_));
	_g_free0 (_tmp31_);
	_tmp32_ = self->priv->default_raw_developer_combo;
	g_signal_connect ((GtkComboBox*) _tmp32_, "changed", (GCallback) _preferences_dialog_on_default_raw_developer_changed_gtk_combo_box_changed, self);
	_tmp33_ = (GtkLabel*) gtk_label_new_with_mnemonic (_ ("De_fault:"));
	g_object_ref_sink (_tmp33_);
	default_raw_developer_label = _tmp33_;
	gtk_widget_set_halign ((GtkWidget*) default_raw_developer_label, GTK_ALIGN_END);
	_tmp34_ = self->priv->default_raw_developer_combo;
	gtk_label_set_mnemonic_widget (default_raw_developer_label, (GtkWidget*) _tmp34_);
	_tmp35_ = (GtkGrid*) gtk_grid_new ();
	g_object_ref_sink (_tmp35_);
	library_grid = _tmp35_;
	gtk_grid_set_column_spacing (library_grid, 12);
	gtk_grid_set_row_spacing (library_grid, 6);
	gtk_grid_attach (library_grid, (GtkWidget*) library_header, 0, 0, 2, 1);
	gtk_grid_attach (library_grid, (GtkWidget*) library_dir_label, 0, 1, 1, 1);
	_tmp36_ = self->priv->library_dir_button;
	gtk_grid_attach (library_grid, (GtkWidget*) _tmp36_, 1, 1, 1, 1);
	gtk_grid_attach (library_grid, (GtkWidget*) auto_import_label, 0, 2, 1, 1);
	gtk_grid_attach (library_grid, (GtkWidget*) auto_import_switch, 1, 2, 1, 1);
	gtk_grid_attach (library_grid, (GtkWidget*) lowercase_label, 0, 3, 1, 1);
	gtk_grid_attach (library_grid, (GtkWidget*) lowercase_switch, 1, 3, 1, 1);
	gtk_grid_attach (library_grid, (GtkWidget*) commit_metadata_label, 0, 4, 1, 1);
	gtk_grid_attach (library_grid, (GtkWidget*) commit_metadata_switch, 1, 4, 1, 1);
	gtk_grid_attach (library_grid, (GtkWidget*) raw_header, 0, 5, 2, 1);
	gtk_grid_attach (library_grid, (GtkWidget*) default_raw_developer_label, 0, 6, 1, 1);
	_tmp37_ = self->priv->default_raw_developer_combo;
	gtk_grid_attach (library_grid, (GtkWidget*) _tmp37_, 1, 6, 1, 1);
	_tmp38_ = plugins_manifest_widget_new ();
	g_object_ref_sink (_tmp38_);
	manifest_widget = _tmp38_;
	_tmp39_ = (GtkStack*) gtk_stack_new ();
	g_object_ref_sink (_tmp39_);
	stack = _tmp39_;
	g_object_set ((GtkWidget*) stack, "expand", TRUE, NULL);
	g_object_set ((GtkWidget*) stack, "margin", 6, NULL);
	gtk_stack_add_titled (stack, (GtkWidget*) library_grid, "library", _ ("Library"));
	gtk_stack_add_titled (stack, (GtkWidget*) manifest_widget, "plugins", _ ("Plugins"));
	_tmp40_ = (GtkStackSwitcher*) gtk_stack_switcher_new ();
	g_object_ref_sink (_tmp40_);
	switcher = _tmp40_;
	gtk_widget_set_halign ((GtkWidget*) switcher, GTK_ALIGN_CENTER);
	gtk_box_set_homogeneous ((GtkBox*) switcher, TRUE);
	g_object_set ((GtkWidget*) switcher, "expand", TRUE, NULL);
	gtk_widget_set_margin_bottom ((GtkWidget*) switcher, 6);
	gtk_stack_switcher_set_stack (switcher, stack);
	_tmp41_ = self->priv->dialog;
	_tmp42_ = gtk_dialog_get_content_area ((GtkDialog*) _tmp41_);
	_tmp43_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp42_, gtk_box_get_type ()) ? ((GtkBox*) _tmp42_) : NULL);
	content = _tmp43_;
	g_object_set ((GtkWidget*) content, "margin", 6, NULL);
	gtk_widget_set_margin_top ((GtkWidget*) content, 0);
	gtk_container_add ((GtkContainer*) content, (GtkWidget*) switcher);
	gtk_container_add ((GtkContainer*) content, (GtkWidget*) stack);
	_tmp44_ = self->priv->dialog;
	_tmp45_ = gtk_dialog_add_button ((GtkDialog*) _tmp44_, _ ("_Close"), (gint) GTK_RESPONSE_CLOSE);
	_tmp46_ = _g_object_ref0 (_tmp45_);
	close_button = _tmp46_;
	g_signal_connect (G_TYPE_CHECK_INSTANCE_CAST (close_button, gtk_button_get_type (), GtkButton), "clicked", (GCallback) _preferences_dialog_on_close_gtk_button_clicked, self);
	_tmp47_ = g_settings_new ("io.elementary.photos.preferences.files");
	file_settings = _tmp47_;
	g_settings_bind (file_settings, "auto-import", (GObject*) auto_import_switch, "active", G_SETTINGS_BIND_DEFAULT);
	g_settings_bind (file_settings, "commit-metadata", (GObject*) commit_metadata_switch, "active", G_SETTINGS_BIND_DEFAULT);
	g_settings_bind (file_settings, "use-lowercase-filenames", (GObject*) lowercase_switch, "active", G_SETTINGS_BIND_DEFAULT);
	_g_object_unref0 (file_settings);
	_g_object_unref0 (close_button);
	_g_object_unref0 (content);
	_g_object_unref0 (switcher);
	_g_object_unref0 (stack);
	_g_object_unref0 (manifest_widget);
	_g_object_unref0 (library_grid);
	_g_object_unref0 (default_raw_developer_label);
	_g_object_unref0 (raw_header);
	_g_object_unref0 (commit_metadata_label);
	_g_object_unref0 (commit_metadata_switch);
	_g_object_unref0 (lowercase_label);
	_g_object_unref0 (lowercase_switch);
	_g_object_unref0 (auto_import_switch);
	_g_object_unref0 (auto_import_label);
	_g_object_unref0 (library_dir_label);
	_g_object_unref0 (library_header);
	return self;
}

static PreferencesDialog*
preferences_dialog_new (void)
{
	return preferences_dialog_construct (TYPE_PREFERENCES_DIALOG);
}

void
preferences_dialog_show (void)
{
	PreferencesDialog* _tmp0_;
	PreferencesDialog* _tmp2_;
	GraniteDialog* _tmp3_;
	PreferencesDialog* _tmp4_;
	GtkFileChooserButton* _tmp5_;
	GFile* _tmp6_;
	GFile* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	PreferencesDialog* _tmp10_;
	GraniteDialog* _tmp11_;
	_tmp0_ = preferences_dialog_preferences_dialog;
	if (_tmp0_ == NULL) {
		PreferencesDialog* _tmp1_;
		_tmp1_ = preferences_dialog_new ();
		_preferences_dialog_unref0 (preferences_dialog_preferences_dialog);
		preferences_dialog_preferences_dialog = _tmp1_;
	}
	_tmp2_ = preferences_dialog_preferences_dialog;
	_tmp3_ = _tmp2_->priv->dialog;
	gtk_widget_show_all ((GtkWidget*) _tmp3_);
	_tmp4_ = preferences_dialog_preferences_dialog;
	_tmp5_ = _tmp4_->priv->library_dir_button;
	_tmp6_ = app_dirs_get_import_dir ();
	_tmp7_ = _tmp6_;
	_tmp8_ = g_file_get_path (_tmp7_);
	_tmp9_ = _tmp8_;
	gtk_file_chooser_set_current_folder ((GtkFileChooser*) _tmp5_, _tmp9_);
	_g_free0 (_tmp9_);
	_g_object_unref0 (_tmp7_);
	_tmp10_ = preferences_dialog_preferences_dialog;
	_tmp11_ = _tmp10_->priv->dialog;
	gtk_window_present ((GtkWindow*) _tmp11_);
}

static void
preferences_dialog_commit_on_close (PreferencesDialog* self)
{
	const gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->lib_dir;
	if (_tmp0_ != NULL) {
		const gchar* _tmp1_;
		_tmp1_ = self->priv->lib_dir;
		app_dirs_set_import_dir (_tmp1_);
	}
}

static gboolean
preferences_dialog_on_delete (PreferencesDialog* self)
{
	GraniteDialog* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	preferences_dialog_commit_on_close (self);
	_tmp0_ = self->priv->dialog;
	result = gtk_widget_hide_on_delete ((GtkWidget*) _tmp0_);
	return result;
}

static void
preferences_dialog_on_close (PreferencesDialog* self)
{
	GraniteDialog* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->dialog;
	gtk_widget_hide ((GtkWidget*) _tmp0_);
	preferences_dialog_commit_on_close (self);
}

static RawDeveloper
preferences_dialog_raw_developer_from_combo (PreferencesDialog* self)
{
	GtkComboBoxText* _tmp0_;
	RawDeveloper result;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->default_raw_developer_combo;
	if (gtk_combo_box_get_active ((GtkComboBox*) _tmp0_) == 0) {
		result = RAW_DEVELOPER_CAMERA;
		return result;
	}
	result = RAW_DEVELOPER_SHOTWELL;
	return result;
}

static void
preferences_dialog_set_raw_developer_combo (PreferencesDialog* self,
                                            RawDeveloper d)
{
	g_return_if_fail (self != NULL);
	if (d == RAW_DEVELOPER_CAMERA) {
		GtkComboBoxText* _tmp0_;
		_tmp0_ = self->priv->default_raw_developer_combo;
		gtk_combo_box_set_active ((GtkComboBox*) _tmp0_, 0);
	} else {
		GtkComboBoxText* _tmp1_;
		_tmp1_ = self->priv->default_raw_developer_combo;
		gtk_combo_box_set_active ((GtkComboBox*) _tmp1_, 1);
	}
}

static void
preferences_dialog_on_default_raw_developer_changed (PreferencesDialog* self)
{
	GSettings* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->file_settings;
	_tmp1_ = raw_developer_to_string (preferences_dialog_raw_developer_from_combo (self));
	_tmp2_ = _tmp1_;
	g_settings_set_string (_tmp0_, "raw-developer-default", _tmp2_);
	_g_free0 (_tmp2_);
}

static void
preferences_dialog_on_current_folder_changed (PreferencesDialog* self)
{
	GtkFileChooserButton* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->library_dir_button;
	_tmp1_ = gtk_file_chooser_get_filename ((GtkFileChooser*) _tmp0_);
	_g_free0 (self->priv->lib_dir);
	self->priv->lib_dir = _tmp1_;
}

static void
_preferences_dialog_on_current_folder_changed_gtk_file_chooser_current_folder_changed (GtkFileChooser* _sender,
                                                                                       gpointer self)
{
	preferences_dialog_on_current_folder_changed ((PreferencesDialog*) self);
}

static gboolean
preferences_dialog_map_event_handler (PreferencesDialog* self)
{
	GtkFileChooserButton* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->library_dir_button;
	g_signal_connect ((GtkFileChooser*) _tmp0_, "current-folder-changed", (GCallback) _preferences_dialog_on_current_folder_changed_gtk_file_chooser_current_folder_changed, self);
	result = TRUE;
	return result;
}

static PreferencesDialogPathFormat*
preferences_dialog_path_format_construct (GType object_type,
                                          const gchar* name,
                                          const gchar* pattern)
{
	PreferencesDialogPathFormat* self = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_val_if_fail (name != NULL, NULL);
	self = (PreferencesDialogPathFormat*) g_type_create_instance (object_type);
	_tmp0_ = g_strdup (name);
	_g_free0 (self->name);
	self->name = _tmp0_;
	_tmp1_ = g_strdup (pattern);
	_g_free0 (self->pattern);
	self->pattern = _tmp1_;
	return self;
}

static PreferencesDialogPathFormat*
preferences_dialog_path_format_new (const gchar* name,
                                    const gchar* pattern)
{
	return preferences_dialog_path_format_construct (PREFERENCES_DIALOG_TYPE_PATH_FORMAT, name, pattern);
}

static void
preferences_dialog_value_path_format_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
preferences_dialog_value_path_format_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		preferences_dialog_path_format_unref (value->data[0].v_pointer);
	}
}

static void
preferences_dialog_value_path_format_copy_value (const GValue* src_value,
                                                 GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = preferences_dialog_path_format_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
preferences_dialog_value_path_format_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
preferences_dialog_value_path_format_collect_value (GValue* value,
                                                    guint n_collect_values,
                                                    GTypeCValue* collect_values,
                                                    guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		PreferencesDialogPathFormat * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = preferences_dialog_path_format_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
preferences_dialog_value_path_format_lcopy_value (const GValue* value,
                                                  guint n_collect_values,
                                                  GTypeCValue* collect_values,
                                                  guint collect_flags)
{
	PreferencesDialogPathFormat ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = preferences_dialog_path_format_ref (value->data[0].v_pointer);
	}
	return NULL;
}

static GParamSpec*
preferences_dialog_param_spec_path_format (const gchar* name,
                                           const gchar* nick,
                                           const gchar* blurb,
                                           GType object_type,
                                           GParamFlags flags)
{
	PreferencesDialogParamSpecPathFormat* spec;
	g_return_val_if_fail (g_type_is_a (object_type, PREFERENCES_DIALOG_TYPE_PATH_FORMAT), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

static gpointer
preferences_dialog_value_get_path_format (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, PREFERENCES_DIALOG_TYPE_PATH_FORMAT), NULL);
	return value->data[0].v_pointer;
}

static void
preferences_dialog_value_set_path_format (GValue* value,
                                          gpointer v_object)
{
	PreferencesDialogPathFormat * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, PREFERENCES_DIALOG_TYPE_PATH_FORMAT));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, PREFERENCES_DIALOG_TYPE_PATH_FORMAT));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		preferences_dialog_path_format_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		preferences_dialog_path_format_unref (old);
	}
}

static void
preferences_dialog_value_take_path_format (GValue* value,
                                           gpointer v_object)
{
	PreferencesDialogPathFormat * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, PREFERENCES_DIALOG_TYPE_PATH_FORMAT));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, PREFERENCES_DIALOG_TYPE_PATH_FORMAT));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		preferences_dialog_path_format_unref (old);
	}
}

static void
preferences_dialog_path_format_class_init (PreferencesDialogPathFormatClass * klass,
                                           gpointer klass_data)
{
	preferences_dialog_path_format_parent_class = g_type_class_peek_parent (klass);
	((PreferencesDialogPathFormatClass *) klass)->finalize = preferences_dialog_path_format_finalize;
}

static void
preferences_dialog_path_format_instance_init (PreferencesDialogPathFormat * self,
                                              gpointer klass)
{
	self->ref_count = 1;
}

static void
preferences_dialog_path_format_finalize (PreferencesDialogPathFormat * obj)
{
	PreferencesDialogPathFormat * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, PREFERENCES_DIALOG_TYPE_PATH_FORMAT, PreferencesDialogPathFormat);
	g_signal_handlers_destroy (self);
	_g_free0 (self->name);
	_g_free0 (self->pattern);
}

static GType
preferences_dialog_path_format_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { preferences_dialog_value_path_format_init, preferences_dialog_value_path_format_free_value, preferences_dialog_value_path_format_copy_value, preferences_dialog_value_path_format_peek_pointer, "p", preferences_dialog_value_path_format_collect_value, "p", preferences_dialog_value_path_format_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (PreferencesDialogPathFormatClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) preferences_dialog_path_format_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PreferencesDialogPathFormat), 0, (GInstanceInitFunc) preferences_dialog_path_format_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType preferences_dialog_path_format_type_id;
	preferences_dialog_path_format_type_id = g_type_register_fundamental (g_type_fundamental_next (), "PreferencesDialogPathFormat", &g_define_type_info, &g_define_type_fundamental_info, 0);
	return preferences_dialog_path_format_type_id;
}

static GType
preferences_dialog_path_format_get_type (void)
{
	static volatile gsize preferences_dialog_path_format_type_id__once = 0;
	if (g_once_init_enter (&preferences_dialog_path_format_type_id__once)) {
		GType preferences_dialog_path_format_type_id;
		preferences_dialog_path_format_type_id = preferences_dialog_path_format_get_type_once ();
		g_once_init_leave (&preferences_dialog_path_format_type_id__once, preferences_dialog_path_format_type_id);
	}
	return preferences_dialog_path_format_type_id__once;
}

static gpointer
preferences_dialog_path_format_ref (gpointer instance)
{
	PreferencesDialogPathFormat * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

static void
preferences_dialog_path_format_unref (gpointer instance)
{
	PreferencesDialogPathFormat * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		PREFERENCES_DIALOG_PATH_FORMAT_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

static void
value_preferences_dialog_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
value_preferences_dialog_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		preferences_dialog_unref (value->data[0].v_pointer);
	}
}

static void
value_preferences_dialog_copy_value (const GValue* src_value,
                                     GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = preferences_dialog_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
value_preferences_dialog_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
value_preferences_dialog_collect_value (GValue* value,
                                        guint n_collect_values,
                                        GTypeCValue* collect_values,
                                        guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		PreferencesDialog * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = preferences_dialog_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
value_preferences_dialog_lcopy_value (const GValue* value,
                                      guint n_collect_values,
                                      GTypeCValue* collect_values,
                                      guint collect_flags)
{
	PreferencesDialog ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = preferences_dialog_ref (value->data[0].v_pointer);
	}
	return NULL;
}

GParamSpec*
param_spec_preferences_dialog (const gchar* name,
                               const gchar* nick,
                               const gchar* blurb,
                               GType object_type,
                               GParamFlags flags)
{
	ParamSpecPreferencesDialog* spec;
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_PREFERENCES_DIALOG), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

gpointer
value_get_preferences_dialog (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_PREFERENCES_DIALOG), NULL);
	return value->data[0].v_pointer;
}

void
value_set_preferences_dialog (GValue* value,
                              gpointer v_object)
{
	PreferencesDialog * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_PREFERENCES_DIALOG));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_PREFERENCES_DIALOG));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		preferences_dialog_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		preferences_dialog_unref (old);
	}
}

void
value_take_preferences_dialog (GValue* value,
                               gpointer v_object)
{
	PreferencesDialog * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_PREFERENCES_DIALOG));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_PREFERENCES_DIALOG));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		preferences_dialog_unref (old);
	}
}

static void
preferences_dialog_class_init (PreferencesDialogClass * klass,
                               gpointer klass_data)
{
	preferences_dialog_parent_class = g_type_class_peek_parent (klass);
	((PreferencesDialogClass *) klass)->finalize = preferences_dialog_finalize;
	g_type_class_adjust_private_offset (klass, &PreferencesDialog_private_offset);
}

static void
preferences_dialog_instance_init (PreferencesDialog * self,
                                  gpointer klass)
{
	self->priv = preferences_dialog_get_instance_private (self);
	self->priv->lib_dir = NULL;
	self->ref_count = 1;
}

static void
preferences_dialog_finalize (PreferencesDialog * obj)
{
	PreferencesDialog * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_PREFERENCES_DIALOG, PreferencesDialog);
	g_signal_handlers_destroy (self);
	_g_object_unref0 (self->priv->dialog);
	_g_object_unref0 (self->priv->library_dir_button);
	_g_free0 (self->priv->lib_dir);
	_g_object_unref0 (self->priv->default_raw_developer_combo);
	_g_object_unref0 (self->priv->file_settings);
}

static GType
preferences_dialog_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { value_preferences_dialog_init, value_preferences_dialog_free_value, value_preferences_dialog_copy_value, value_preferences_dialog_peek_pointer, "p", value_preferences_dialog_collect_value, "p", value_preferences_dialog_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (PreferencesDialogClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) preferences_dialog_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PreferencesDialog), 0, (GInstanceInitFunc) preferences_dialog_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType preferences_dialog_type_id;
	preferences_dialog_type_id = g_type_register_fundamental (g_type_fundamental_next (), "PreferencesDialog", &g_define_type_info, &g_define_type_fundamental_info, 0);
	PreferencesDialog_private_offset = g_type_add_instance_private (preferences_dialog_type_id, sizeof (PreferencesDialogPrivate));
	return preferences_dialog_type_id;
}

GType
preferences_dialog_get_type (void)
{
	static volatile gsize preferences_dialog_type_id__once = 0;
	if (g_once_init_enter (&preferences_dialog_type_id__once)) {
		GType preferences_dialog_type_id;
		preferences_dialog_type_id = preferences_dialog_get_type_once ();
		g_once_init_leave (&preferences_dialog_type_id__once, preferences_dialog_type_id);
	}
	return preferences_dialog_type_id__once;
}

gpointer
preferences_dialog_ref (gpointer instance)
{
	PreferencesDialog * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

void
preferences_dialog_unref (gpointer instance)
{
	PreferencesDialog * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		PREFERENCES_DIALOG_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

