/*
 * Copyright (C) 2022 - OpenSIPS Solutions
 *
 * This file is part of opensips, a free SIP server.
 *
 * opensips is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version
 *
 * opensips is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
 *
 */

#include "msrp_handler.h"
#include "msrp_signaling.h"
#include "msrp_api.h"


void load_msrp( struct msrp_binds *binds)
{
	binds->register_msrp_handler = register_msrp_handler;
	binds->send_reply = msrp_send_reply;
	binds->send_reply_on_cell = msrp_send_reply_on_cell;
	binds->send_report = msrp_send_report;
	binds->forward_request = msrp_fwd_request;
	binds->forward_reply = msrp_fwd_reply;
	binds->send_request = msrp_send_request;
}
