/* skkserv.c generated by valac 0.56.17, the Vala compiler
 * generated from skkserv.vala, do not modify */

/*
 * Copyright (C) 2011-2018 Daiki Ueno <ueno@gnu.org>
 * Copyright (C) 2011-2018 Red Hat, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include "libskk/libskk.h"
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

#define SKK_TYPE_SKK_SERV_ERROR (skk_skk_serv_error_get_type ())

#define SKK_TYPE_ENCODING_CONVERTER (skk_encoding_converter_get_type ())
#define SKK_ENCODING_CONVERTER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SKK_TYPE_ENCODING_CONVERTER, SkkEncodingConverter))
#define SKK_ENCODING_CONVERTER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SKK_TYPE_ENCODING_CONVERTER, SkkEncodingConverterClass))
#define SKK_IS_ENCODING_CONVERTER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SKK_TYPE_ENCODING_CONVERTER))
#define SKK_IS_ENCODING_CONVERTER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SKK_TYPE_ENCODING_CONVERTER))
#define SKK_ENCODING_CONVERTER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SKK_TYPE_ENCODING_CONVERTER, SkkEncodingConverterClass))

typedef struct _SkkEncodingConverter SkkEncodingConverter;
typedef struct _SkkEncodingConverterClass SkkEncodingConverterClass;
enum  {
	SKK_SKK_SERV_0_PROPERTY,
	SKK_SKK_SERV_READ_ONLY_PROPERTY,
	SKK_SKK_SERV_NUM_PROPERTIES
};
static GParamSpec* skk_skk_serv_properties[SKK_SKK_SERV_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))

typedef enum  {
	SKK_SKK_SERV_ERROR_NOT_READABLE,
	SKK_SKK_SERV_ERROR_INVALID_RESPONSE
} SkkSkkServError;
#define SKK_SKK_SERV_ERROR skk_skk_serv_error_quark ()

struct _SkkSkkServPrivate {
	GSocketConnection* connection;
	guint8 buffer[4096];
	gchar* host;
	guint16 port;
	SkkEncodingConverter* converter;
};

static gint SkkSkkServ_private_offset;
static gpointer skk_skk_serv_parent_class = NULL;

VALA_EXTERN GQuark skk_skk_serv_error_quark (void);
VALA_EXTERN GType skk_skk_serv_error_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType skk_encoding_converter_get_type (void) G_GNUC_CONST ;
static void skk_skk_serv_close_connection (SkkSkkServ* self);
static void skk_skk_serv_real_reload (SkkDict* base,
                               GError** error);
static gchar* skk_skk_serv_read_response (SkkSkkServ* self,
                                   GError** error);
static SkkCandidate** skk_skk_serv_real_lookup (SkkDict* base,
                                         const gchar* midasi,
                                         gboolean okuri,
                                         gint* result_length1);
VALA_EXTERN gchar* skk_encoding_converter_encode (SkkEncodingConverter* self,
                                      const gchar* internal_str,
                                      GError** error);
VALA_EXTERN gchar* skk_encoding_converter_decode (SkkEncodingConverter* self,
                                      const gchar* external_str,
                                      GError** error);
static gchar** skk_skk_serv_real_complete (SkkDict* base,
                                    const gchar* midasi,
                                    gint* result_length1);
VALA_EXTERN SkkEncodingConverter* skk_encoding_converter_new (const gchar* encoding,
                                                  GError** error);
VALA_EXTERN SkkEncodingConverter* skk_encoding_converter_construct (GType object_type,
                                                        const gchar* encoding,
                                                        GError** error);
static void skk_skk_serv_finalize (GObject * obj);
static GType skk_skk_serv_get_type_once (void);
static void _vala_skk_skk_serv_get_property (GObject * object,
                                      guint property_id,
                                      GValue * value,
                                      GParamSpec * pspec);
static gssize _vala_array_length (gpointer array);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

GQuark
skk_skk_serv_error_quark (void)
{
	return g_quark_from_static_string ("skk-skk-serv-error-quark");
}

static GType
skk_skk_serv_error_get_type_once (void)
{
	static const GEnumValue values[] = {{SKK_SKK_SERV_ERROR_NOT_READABLE, "SKK_SKK_SERV_ERROR_NOT_READABLE", "not-readable"}, {SKK_SKK_SERV_ERROR_INVALID_RESPONSE, "SKK_SKK_SERV_ERROR_INVALID_RESPONSE", "invalid-response"}, {0, NULL, NULL}};
	GType skk_skk_serv_error_type_id;
	skk_skk_serv_error_type_id = g_enum_register_static ("SkkSkkServError", values);
	return skk_skk_serv_error_type_id;
}

GType
skk_skk_serv_error_get_type (void)
{
	static volatile gsize skk_skk_serv_error_type_id__once = 0;
	if (g_once_init_enter (&skk_skk_serv_error_type_id__once)) {
		GType skk_skk_serv_error_type_id;
		skk_skk_serv_error_type_id = skk_skk_serv_error_get_type_once ();
		g_once_init_leave (&skk_skk_serv_error_type_id__once, skk_skk_serv_error_type_id);
	}
	return skk_skk_serv_error_type_id__once;
}

static inline gpointer
skk_skk_serv_get_instance_private (SkkSkkServ* self)
{
	return G_STRUCT_MEMBER_P (self, SkkSkkServ_private_offset);
}

static void
skk_skk_serv_close_connection (SkkSkkServ* self)
{
	GSocketConnection* _tmp0_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->connection;
	if (_tmp0_ != NULL) {
		{
			gsize bytes_written = 0UL;
			GSocketConnection* _tmp1_;
			GOutputStream* _tmp2_;
			GOutputStream* _tmp3_;
			gsize _tmp4_ = 0UL;
			GSocketConnection* _tmp5_;
			GOutputStream* _tmp6_;
			GOutputStream* _tmp7_;
			GSocketConnection* _tmp8_;
			self->priv->buffer[0] = (guint8) '0';
			_tmp1_ = self->priv->connection;
			_tmp2_ = g_io_stream_get_output_stream ((GIOStream*) _tmp1_);
			_tmp3_ = _tmp2_;
			g_output_stream_write_all (_tmp3_, self->priv->buffer + 0, (gsize) (1 - 0), &_tmp4_, NULL, &_inner_error0_);
			bytes_written = _tmp4_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
			_tmp5_ = self->priv->connection;
			_tmp6_ = g_io_stream_get_output_stream ((GIOStream*) _tmp5_);
			_tmp7_ = _tmp6_;
			g_output_stream_flush (_tmp7_, NULL, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
			_tmp8_ = self->priv->connection;
			g_io_stream_close ((GIOStream*) _tmp8_, NULL, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
		}
		goto __finally0;
		__catch0_g_error:
		{
			GError* e = NULL;
			GError* _tmp9_;
			const gchar* _tmp10_;
			e = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp9_ = e;
			_tmp10_ = _tmp9_->message;
			g_warning ("skkserv.vala:43: can't close skkserv: %s", _tmp10_);
			_g_error_free0 (e);
		}
		__finally0:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
		_g_object_unref0 (self->priv->connection);
		self->priv->connection = NULL;
	}
}

/**
         * {@inheritDoc}
         */
static void
skk_skk_serv_real_reload (SkkDict* base,
                          GError** error)
{
	SkkSkkServ * self;
	GError* _inner_error0_ = NULL;
	self = (SkkSkkServ*) base;
	skk_skk_serv_close_connection (self);
	{
		GSocketClient* client = NULL;
		GSocketClient* _tmp0_;
		GSocketConnection* _tmp1_ = NULL;
		GSocketClient* _tmp2_;
		const gchar* _tmp3_;
		GSocketConnection* _tmp4_;
		GSocketConnection* _tmp5_;
		gsize bytes_written = 0UL;
		GSocketConnection* _tmp6_;
		GOutputStream* _tmp7_;
		GOutputStream* _tmp8_;
		gsize _tmp9_ = 0UL;
		GSocketConnection* _tmp10_;
		GOutputStream* _tmp11_;
		GOutputStream* _tmp12_;
		gssize len = 0L;
		GSocketConnection* _tmp13_;
		GInputStream* _tmp14_;
		GInputStream* _tmp15_;
		_tmp0_ = g_socket_client_new ();
		client = _tmp0_;
		_tmp2_ = client;
		_tmp3_ = self->priv->host;
		_tmp4_ = g_socket_client_connect_to_host (_tmp2_, _tmp3_, self->priv->port, NULL, &_inner_error0_);
		_tmp1_ = _tmp4_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (client);
			goto __catch0_g_error;
		}
		_tmp5_ = _tmp1_;
		_tmp1_ = NULL;
		_g_object_unref0 (self->priv->connection);
		self->priv->connection = _tmp5_;
		self->priv->buffer[0] = (guint8) '2';
		_tmp6_ = self->priv->connection;
		_tmp7_ = g_io_stream_get_output_stream ((GIOStream*) _tmp6_);
		_tmp8_ = _tmp7_;
		g_output_stream_write_all (_tmp8_, self->priv->buffer + 0, (gsize) (1 - 0), &_tmp9_, NULL, &_inner_error0_);
		bytes_written = _tmp9_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (_tmp1_);
			_g_object_unref0 (client);
			goto __catch0_g_error;
		}
		_tmp10_ = self->priv->connection;
		_tmp11_ = g_io_stream_get_output_stream ((GIOStream*) _tmp10_);
		_tmp12_ = _tmp11_;
		g_output_stream_flush (_tmp12_, NULL, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (_tmp1_);
			_g_object_unref0 (client);
			goto __catch0_g_error;
		}
		_tmp13_ = self->priv->connection;
		_tmp14_ = g_io_stream_get_input_stream ((GIOStream*) _tmp13_);
		_tmp15_ = _tmp14_;
		len = g_input_stream_read (_tmp15_, self->priv->buffer, (gsize) 4096, NULL, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (_tmp1_);
			_g_object_unref0 (client);
			goto __catch0_g_error;
		}
		if (len <= ((gssize) 0)) {
			skk_skk_serv_close_connection (self);
		}
		_g_object_unref0 (_tmp1_);
		_g_object_unref0 (client);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		const gchar* _tmp16_;
		GError* _tmp17_;
		const gchar* _tmp18_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp16_ = self->priv->host;
		_tmp17_ = e;
		_tmp18_ = _tmp17_->message;
		g_warning ("skkserv.vala:67: can't open skkserv at %s:%u: %s", _tmp16_, (guint) self->priv->port, _tmp18_);
		skk_skk_serv_close_connection (self);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static gint
string_index_of_char (const gchar* self,
                      gunichar c,
                      gint start_index)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = g_utf8_strchr (((gchar*) self) + start_index, (gssize) -1, c);
	_result_ = _tmp0_;
	_tmp1_ = _result_;
	if (_tmp1_ != NULL) {
		gchar* _tmp2_;
		_tmp2_ = _result_;
		result = (gint) (_tmp2_ - ((gchar*) self));
		return result;
	} else {
		result = -1;
		return result;
	}
}

static gchar*
string_slice (const gchar* self,
              glong start,
              glong end)
{
	glong string_length = 0L;
	gint _tmp0_;
	gint _tmp1_;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	gchar* _tmp4_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	string_length = (glong) _tmp1_;
	if (start < ((glong) 0)) {
		start = string_length + start;
	}
	if (end < ((glong) 0)) {
		end = string_length + end;
	}
	if (start >= ((glong) 0)) {
		_tmp2_ = start <= string_length;
	} else {
		_tmp2_ = FALSE;
	}
	g_return_val_if_fail (_tmp2_, NULL);
	if (end >= ((glong) 0)) {
		_tmp3_ = end <= string_length;
	} else {
		_tmp3_ = FALSE;
	}
	g_return_val_if_fail (_tmp3_, NULL);
	g_return_val_if_fail (start <= end, NULL);
	_tmp4_ = g_strndup (((gchar*) self) + start, (gsize) (end - start));
	result = _tmp4_;
	return result;
}

static gchar*
skk_skk_serv_read_response (SkkSkkServ* self,
                            GError** error)
{
	GString* builder = NULL;
	GString* _tmp0_;
	gint index = 0;
	GString* _tmp14_;
	const gchar* _tmp15_;
	GString* _tmp17_;
	const gchar* _tmp18_;
	gchar* _tmp19_;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_string_new ("");
	builder = _tmp0_;
	while (TRUE) {
		GString* _tmp1_;
		const gchar* _tmp2_;
		gssize len = 0L;
		GSocketConnection* _tmp3_;
		GInputStream* _tmp4_;
		GInputStream* _tmp5_;
		_tmp1_ = builder;
		_tmp2_ = _tmp1_->str;
		if (!(string_index_of_char (_tmp2_, (gunichar) '\n', 0) < 0)) {
			break;
		}
		_tmp3_ = self->priv->connection;
		_tmp4_ = g_io_stream_get_input_stream ((GIOStream*) _tmp3_);
		_tmp5_ = _tmp4_;
		len = g_input_stream_read (_tmp5_, self->priv->buffer, (gsize) 4096, NULL, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if ((_inner_error0_->domain == SKK_SKK_SERV_ERROR) || (_inner_error0_->domain == G_IO_ERROR)) {
				g_propagate_error (error, _inner_error0_);
				_g_string_free0 (builder);
				return NULL;
			} else {
				_g_string_free0 (builder);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return NULL;
			}
		}
		if (len < ((gssize) 0)) {
			GError* _tmp6_;
			_tmp6_ = g_error_new_literal (SKK_SKK_SERV_ERROR, SKK_SKK_SERV_ERROR_NOT_READABLE, "read error");
			_inner_error0_ = _tmp6_;
			if ((_inner_error0_->domain == SKK_SKK_SERV_ERROR) || (_inner_error0_->domain == G_IO_ERROR)) {
				g_propagate_error (error, _inner_error0_);
				_g_string_free0 (builder);
				return NULL;
			} else {
				_g_string_free0 (builder);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return NULL;
			}
		} else {
			if (len == ((gssize) 0)) {
				break;
			} else {
				if (len > ((gssize) 0)) {
					guint8 _tmp7_;
					gchar* data = NULL;
					gchar* _tmp9_;
					gint data_length1;
					gint _data_size_;
					gchar* _tmp10_;
					gint _tmp10__length1;
					gint _tmp11_;
					GString* _tmp12_;
					gchar* _tmp13_;
					gint _tmp13__length1;
					_tmp7_ = self->priv->buffer[0];
					if (_tmp7_ != ((guint8) '1')) {
						GError* _tmp8_;
						_tmp8_ = g_error_new_literal (SKK_SKK_SERV_ERROR, SKK_SKK_SERV_ERROR_INVALID_RESPONSE, "invalid response code");
						_inner_error0_ = _tmp8_;
						if ((_inner_error0_->domain == SKK_SKK_SERV_ERROR) || (_inner_error0_->domain == G_IO_ERROR)) {
							g_propagate_error (error, _inner_error0_);
							_g_string_free0 (builder);
							return NULL;
						} else {
							_g_string_free0 (builder);
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
							g_clear_error (&_inner_error0_);
							return NULL;
						}
					}
					_tmp9_ = g_new0 (gchar, len + 1);
					data = _tmp9_;
					data_length1 = len + 1;
					_data_size_ = data_length1;
					_tmp10_ = data;
					_tmp10__length1 = data_length1;
					memcpy (_tmp10_, self->priv->buffer, (gsize) len);
					_tmp11_ = data_length1;
					data_length1 = _tmp11_ - 1;
					_tmp12_ = builder;
					_tmp13_ = data;
					_tmp13__length1 = data_length1;
					g_string_append (_tmp12_, (const gchar*) _tmp13_);
					data = (g_free (data), NULL);
				}
			}
		}
	}
	_tmp14_ = builder;
	_tmp15_ = _tmp14_->str;
	index = string_index_of_char (_tmp15_, (gunichar) '\n', 0);
	if (index < 0) {
		GError* _tmp16_;
		_tmp16_ = g_error_new_literal (SKK_SKK_SERV_ERROR, SKK_SKK_SERV_ERROR_INVALID_RESPONSE, "missing newline");
		_inner_error0_ = _tmp16_;
		if ((_inner_error0_->domain == SKK_SKK_SERV_ERROR) || (_inner_error0_->domain == G_IO_ERROR)) {
			g_propagate_error (error, _inner_error0_);
			_g_string_free0 (builder);
			return NULL;
		} else {
			_g_string_free0 (builder);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_tmp17_ = builder;
	_tmp18_ = _tmp17_->str;
	_tmp19_ = string_slice (_tmp18_, (glong) 0, (glong) index);
	result = _tmp19_;
	_g_string_free0 (builder);
	return result;
}

/**
         * {@inheritDoc}
         */
static guint8*
string_get_data (const gchar* self,
                 gint* result_length1)
{
	guint8* result;
	guint8* res = NULL;
	gint res_length1;
	gint _res_size_;
	gint _tmp0_;
	gint _tmp1_;
	guint8* _tmp2_;
	gint _tmp2__length1;
	g_return_val_if_fail (self != NULL, NULL);
	res = (guint8*) self;
	res_length1 = -1;
	_res_size_ = res_length1;
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	res_length1 = (gint) _tmp1_;
	_tmp2_ = res;
	_tmp2__length1 = res_length1;
	if (result_length1) {
		*result_length1 = _tmp2__length1;
	}
	result = _tmp2_;
	return result;
}

static SkkCandidate**
skk_skk_serv_real_lookup (SkkDict* base,
                          const gchar* midasi,
                          gboolean okuri,
                          gint* result_length1)
{
	SkkSkkServ * self;
	GSocketConnection* _tmp0_;
	gchar* _midasi = NULL;
	GError* _inner_error0_ = NULL;
	SkkCandidate** result;
	self = (SkkSkkServ*) base;
	g_return_val_if_fail (midasi != NULL, NULL);
	_tmp0_ = self->priv->connection;
	if (_tmp0_ == NULL) {
		SkkCandidate** _tmp1_;
		SkkCandidate** _tmp2_;
		gint _tmp2__length1;
		_tmp1_ = g_new0 (SkkCandidate*, 0 + 1);
		_tmp2_ = _tmp1_;
		_tmp2__length1 = 0;
		if (result_length1) {
			*result_length1 = _tmp2__length1;
		}
		result = _tmp2_;
		return result;
	}
	{
		gchar* _tmp3_ = NULL;
		SkkEncodingConverter* _tmp4_;
		gchar* _tmp5_;
		gchar* _tmp6_;
		_tmp4_ = self->priv->converter;
		_tmp5_ = skk_encoding_converter_encode (_tmp4_, midasi, &_inner_error0_);
		_tmp3_ = _tmp5_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp6_ = _tmp3_;
		_tmp3_ = NULL;
		_g_free0 (_midasi);
		_midasi = _tmp6_;
		_g_free0 (_tmp3_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		SkkCandidate** _tmp7_;
		SkkCandidate** _tmp8_;
		gint _tmp8__length1;
		g_clear_error (&_inner_error0_);
		_tmp7_ = g_new0 (SkkCandidate*, 0 + 1);
		_tmp8_ = _tmp7_;
		_tmp8__length1 = 0;
		if (result_length1) {
			*result_length1 = _tmp8__length1;
		}
		result = _tmp8_;
		_g_free0 (_midasi);
		return result;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_free0 (_midasi);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
	{
		gsize bytes_written = 0UL;
		GSocketConnection* _tmp9_;
		GOutputStream* _tmp10_;
		GOutputStream* _tmp11_;
		const gchar* _tmp12_;
		gchar* _tmp13_;
		gchar* _tmp14_;
		guint8* _tmp15_;
		gint _tmp15__length1;
		gint _tmp16_ = 0;
		guint8* _tmp17_;
		gint _tmp17__length1;
		gsize _tmp18_ = 0UL;
		GSocketConnection* _tmp19_;
		GOutputStream* _tmp20_;
		GOutputStream* _tmp21_;
		gchar* response = NULL;
		gchar* _tmp22_;
		const gchar* _tmp23_;
		gint _tmp24_;
		gint _tmp25_;
		gchar* _tmp28_ = NULL;
		SkkEncodingConverter* _tmp29_;
		const gchar* _tmp30_;
		const gchar* _tmp31_;
		gint _tmp32_;
		gint _tmp33_;
		gchar* _tmp34_;
		gchar* _tmp35_;
		gchar* _tmp36_;
		gchar* _tmp37_;
		gint _tmp38_ = 0;
		SkkCandidate** _tmp39_;
		SkkCandidate** _tmp40_;
		gint _tmp40__length1;
		_tmp9_ = self->priv->connection;
		_tmp10_ = g_io_stream_get_output_stream ((GIOStream*) _tmp9_);
		_tmp11_ = _tmp10_;
		_tmp12_ = _midasi;
		_tmp13_ = g_strdup_printf ("1%s ", _tmp12_);
		_tmp14_ = _tmp13_;
		_tmp15_ = string_get_data (_tmp14_, &_tmp16_);
		_tmp15__length1 = _tmp16_;
		_tmp17_ = _tmp15_;
		_tmp17__length1 = _tmp15__length1;
		g_output_stream_write_all (_tmp11_, _tmp17_, (gsize) _tmp17__length1, &_tmp18_, NULL, &_inner_error0_);
		bytes_written = _tmp18_;
		_g_free0 (_tmp14_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == SKK_SKK_SERV_ERROR) {
				goto __catch1_skk_skk_serv_error;
			}
			goto __catch1_g_error;
		}
		_tmp19_ = self->priv->connection;
		_tmp20_ = g_io_stream_get_output_stream ((GIOStream*) _tmp19_);
		_tmp21_ = _tmp20_;
		g_output_stream_flush (_tmp21_, NULL, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == SKK_SKK_SERV_ERROR) {
				goto __catch1_skk_skk_serv_error;
			}
			goto __catch1_g_error;
		}
		_tmp22_ = skk_skk_serv_read_response (self, &_inner_error0_);
		response = _tmp22_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == SKK_SKK_SERV_ERROR) {
				goto __catch1_skk_skk_serv_error;
			}
			goto __catch1_g_error;
		}
		_tmp23_ = response;
		_tmp24_ = strlen (_tmp23_);
		_tmp25_ = _tmp24_;
		if (_tmp25_ == 0) {
			SkkCandidate** _tmp26_;
			SkkCandidate** _tmp27_;
			gint _tmp27__length1;
			_tmp26_ = g_new0 (SkkCandidate*, 0 + 1);
			_tmp27_ = _tmp26_;
			_tmp27__length1 = 0;
			if (result_length1) {
				*result_length1 = _tmp27__length1;
			}
			result = _tmp27_;
			_g_free0 (response);
			_g_free0 (_midasi);
			return result;
		}
		_tmp29_ = self->priv->converter;
		_tmp30_ = response;
		_tmp31_ = response;
		_tmp32_ = strlen (_tmp31_);
		_tmp33_ = _tmp32_;
		_tmp34_ = string_slice (_tmp30_, (glong) 1, (glong) _tmp33_);
		_tmp35_ = _tmp34_;
		_tmp36_ = skk_encoding_converter_decode (_tmp29_, _tmp35_, &_inner_error0_);
		_tmp37_ = _tmp36_;
		_g_free0 (_tmp35_);
		_tmp28_ = _tmp37_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_free0 (response);
			if (_inner_error0_->domain == SKK_SKK_SERV_ERROR) {
				goto __catch1_skk_skk_serv_error;
			}
			goto __catch1_g_error;
		}
		_tmp39_ = skk_dict_split_candidates ((SkkDict*) self, midasi, okuri, _tmp28_, &_tmp38_);
		_tmp40_ = _tmp39_;
		_tmp40__length1 = _tmp38_;
		if (result_length1) {
			*result_length1 = _tmp40__length1;
		}
		result = _tmp40_;
		_g_free0 (_tmp28_);
		_g_free0 (response);
		_g_free0 (_midasi);
		return result;
	}
	goto __finally1;
	__catch1_skk_skk_serv_error:
	{
		SkkCandidate** _tmp41_;
		SkkCandidate** _tmp42_;
		gint _tmp42__length1;
		g_clear_error (&_inner_error0_);
		_tmp41_ = g_new0 (SkkCandidate*, 0 + 1);
		_tmp42_ = _tmp41_;
		_tmp42__length1 = 0;
		if (result_length1) {
			*result_length1 = _tmp42__length1;
		}
		result = _tmp42_;
		_g_free0 (_midasi);
		return result;
	}
	goto __finally1;
	__catch1_g_error:
	{
		SkkCandidate** _tmp43_;
		SkkCandidate** _tmp44_;
		gint _tmp44__length1;
		g_clear_error (&_inner_error0_);
		_tmp43_ = g_new0 (SkkCandidate*, 0 + 1);
		_tmp44_ = _tmp43_;
		_tmp44__length1 = 0;
		if (result_length1) {
			*result_length1 = _tmp44__length1;
		}
		result = _tmp44_;
		_g_free0 (_midasi);
		return result;
	}
	__finally1:
	_g_free0 (_midasi);
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return NULL;
}

/**
         * {@inheritDoc}
         */
static gchar**
skk_skk_serv_real_complete (SkkDict* base,
                            const gchar* midasi,
                            gint* result_length1)
{
	SkkSkkServ * self;
	GSocketConnection* _tmp0_;
	gchar* _midasi = NULL;
	GError* _inner_error0_ = NULL;
	gchar** result;
	self = (SkkSkkServ*) base;
	g_return_val_if_fail (midasi != NULL, NULL);
	_tmp0_ = self->priv->connection;
	if (_tmp0_ == NULL) {
		gchar** _tmp1_;
		gchar** _tmp2_;
		gint _tmp2__length1;
		_tmp1_ = g_new0 (gchar*, 0 + 1);
		_tmp2_ = _tmp1_;
		_tmp2__length1 = 0;
		if (result_length1) {
			*result_length1 = _tmp2__length1;
		}
		result = _tmp2_;
		return result;
	}
	{
		gchar* _tmp3_ = NULL;
		SkkEncodingConverter* _tmp4_;
		gchar* _tmp5_;
		gchar* _tmp6_;
		_tmp4_ = self->priv->converter;
		_tmp5_ = skk_encoding_converter_encode (_tmp4_, midasi, &_inner_error0_);
		_tmp3_ = _tmp5_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp6_ = _tmp3_;
		_tmp3_ = NULL;
		_g_free0 (_midasi);
		_midasi = _tmp6_;
		_g_free0 (_tmp3_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		gchar** _tmp7_;
		gchar** _tmp8_;
		gint _tmp8__length1;
		g_clear_error (&_inner_error0_);
		_tmp7_ = g_new0 (gchar*, 0 + 1);
		_tmp8_ = _tmp7_;
		_tmp8__length1 = 0;
		if (result_length1) {
			*result_length1 = _tmp8__length1;
		}
		result = _tmp8_;
		_g_free0 (_midasi);
		return result;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_free0 (_midasi);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
	{
		gsize bytes_written = 0UL;
		GSocketConnection* _tmp9_;
		GOutputStream* _tmp10_;
		GOutputStream* _tmp11_;
		const gchar* _tmp12_;
		gchar* _tmp13_;
		gchar* _tmp14_;
		guint8* _tmp15_;
		gint _tmp15__length1;
		gint _tmp16_ = 0;
		guint8* _tmp17_;
		gint _tmp17__length1;
		gsize _tmp18_ = 0UL;
		GSocketConnection* _tmp19_;
		GOutputStream* _tmp20_;
		GOutputStream* _tmp21_;
		gchar* response = NULL;
		gchar* _tmp22_;
		const gchar* _tmp23_;
		gint _tmp24_;
		gint _tmp25_;
		gchar* _tmp28_ = NULL;
		SkkEncodingConverter* _tmp29_;
		const gchar* _tmp30_;
		gchar* _tmp31_;
		gchar* _tmp32_;
		gchar* _tmp33_;
		gchar* _tmp34_;
		gchar** _tmp35_;
		gchar** _tmp36_;
		gchar** _tmp37_;
		gint _tmp37__length1;
		_tmp9_ = self->priv->connection;
		_tmp10_ = g_io_stream_get_output_stream ((GIOStream*) _tmp9_);
		_tmp11_ = _tmp10_;
		_tmp12_ = _midasi;
		_tmp13_ = g_strdup_printf ("4%s ", _tmp12_);
		_tmp14_ = _tmp13_;
		_tmp15_ = string_get_data (_tmp14_, &_tmp16_);
		_tmp15__length1 = _tmp16_;
		_tmp17_ = _tmp15_;
		_tmp17__length1 = _tmp15__length1;
		g_output_stream_write_all (_tmp11_, _tmp17_, (gsize) _tmp17__length1, &_tmp18_, NULL, &_inner_error0_);
		bytes_written = _tmp18_;
		_g_free0 (_tmp14_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == SKK_SKK_SERV_ERROR) {
				goto __catch1_skk_skk_serv_error;
			}
			goto __catch1_g_error;
		}
		_tmp19_ = self->priv->connection;
		_tmp20_ = g_io_stream_get_output_stream ((GIOStream*) _tmp19_);
		_tmp21_ = _tmp20_;
		g_output_stream_flush (_tmp21_, NULL, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == SKK_SKK_SERV_ERROR) {
				goto __catch1_skk_skk_serv_error;
			}
			goto __catch1_g_error;
		}
		_tmp22_ = skk_skk_serv_read_response (self, &_inner_error0_);
		response = _tmp22_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == SKK_SKK_SERV_ERROR) {
				goto __catch1_skk_skk_serv_error;
			}
			goto __catch1_g_error;
		}
		_tmp23_ = response;
		_tmp24_ = strlen (_tmp23_);
		_tmp25_ = _tmp24_;
		if (_tmp25_ < 2) {
			gchar** _tmp26_;
			gchar** _tmp27_;
			gint _tmp27__length1;
			_tmp26_ = g_new0 (gchar*, 0 + 1);
			_tmp27_ = _tmp26_;
			_tmp27__length1 = 0;
			if (result_length1) {
				*result_length1 = _tmp27__length1;
			}
			result = _tmp27_;
			_g_free0 (response);
			_g_free0 (_midasi);
			return result;
		}
		_tmp29_ = self->priv->converter;
		_tmp30_ = response;
		_tmp31_ = string_slice (_tmp30_, (glong) 2, (glong) -1);
		_tmp32_ = _tmp31_;
		_tmp33_ = skk_encoding_converter_decode (_tmp29_, _tmp32_, &_inner_error0_);
		_tmp34_ = _tmp33_;
		_g_free0 (_tmp32_);
		_tmp28_ = _tmp34_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_free0 (response);
			if (_inner_error0_->domain == SKK_SKK_SERV_ERROR) {
				goto __catch1_skk_skk_serv_error;
			}
			goto __catch1_g_error;
		}
		_tmp36_ = _tmp35_ = g_strsplit (_tmp28_, "/", 0);
		_tmp37_ = _tmp36_;
		_tmp37__length1 = _vala_array_length (_tmp35_);
		if (result_length1) {
			*result_length1 = _tmp37__length1;
		}
		result = _tmp37_;
		_g_free0 (_tmp28_);
		_g_free0 (response);
		_g_free0 (_midasi);
		return result;
	}
	goto __finally1;
	__catch1_skk_skk_serv_error:
	{
		GError* e = NULL;
		GError* _tmp38_;
		const gchar* _tmp39_;
		gchar** _tmp40_;
		gchar** _tmp41_;
		gint _tmp41__length1;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp38_ = e;
		_tmp39_ = _tmp38_->message;
		g_warning ("skkserv.vala:158: server completion failed %s", _tmp39_);
		_tmp40_ = g_new0 (gchar*, 0 + 1);
		_tmp41_ = _tmp40_;
		_tmp41__length1 = 0;
		if (result_length1) {
			*result_length1 = _tmp41__length1;
		}
		result = _tmp41_;
		_g_error_free0 (e);
		_g_free0 (_midasi);
		return result;
	}
	goto __finally1;
	__catch1_g_error:
	{
		GError* e = NULL;
		GError* _tmp42_;
		const gchar* _tmp43_;
		gchar** _tmp44_;
		gchar** _tmp45_;
		gint _tmp45__length1;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp42_ = e;
		_tmp43_ = _tmp42_->message;
		g_warning ("skkserv.vala:161: server completion failed %s", _tmp43_);
		_tmp44_ = g_new0 (gchar*, 0 + 1);
		_tmp45_ = _tmp44_;
		_tmp45__length1 = 0;
		if (result_length1) {
			*result_length1 = _tmp45__length1;
		}
		result = _tmp45_;
		_g_error_free0 (e);
		_g_free0 (_midasi);
		return result;
	}
	__finally1:
	_g_free0 (_midasi);
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return NULL;
}

/**
         * Create a new SkkServ.
         *
         * @param host host to connect
         * @param port port at the host
         * @param encoding encoding to convert text over network traffic
         *
         * @return a new SkkServ.
         * @throws GLib.Error if opening a connection is failed
         */
SkkSkkServ*
skk_skk_serv_construct (GType object_type,
                        const gchar* host,
                        guint16 port,
                        const gchar* encoding,
                        GError** error)
{
	SkkSkkServ * self = NULL;
	gchar* _tmp0_;
	SkkEncodingConverter* _tmp1_ = NULL;
	SkkEncodingConverter* _tmp2_;
	SkkEncodingConverter* _tmp3_;
	GError* _inner_error0_ = NULL;
	g_return_val_if_fail (host != NULL, NULL);
	g_return_val_if_fail (encoding != NULL, NULL);
	self = (SkkSkkServ*) skk_dict_construct (object_type);
	_tmp0_ = g_strdup (host);
	_g_free0 (self->priv->host);
	self->priv->host = _tmp0_;
	self->priv->port = port;
	_tmp2_ = skk_encoding_converter_new (encoding, &_inner_error0_);
	_tmp1_ = _tmp2_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (self);
		return NULL;
	}
	_tmp3_ = _tmp1_;
	_tmp1_ = NULL;
	_g_object_unref0 (self->priv->converter);
	self->priv->converter = _tmp3_;
	skk_dict_reload ((SkkDict*) self, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (_tmp1_);
		_g_object_unref0 (self);
		return NULL;
	}
	_g_object_unref0 (_tmp1_);
	return self;
}

SkkSkkServ*
skk_skk_serv_new (const gchar* host,
                  guint16 port,
                  const gchar* encoding,
                  GError** error)
{
	return skk_skk_serv_construct (SKK_TYPE_SKK_SERV, host, port, encoding, error);
}

static gboolean
skk_skk_serv_real_get_read_only (SkkDict* base)
{
	gboolean result;
	SkkSkkServ* self;
	self = (SkkSkkServ*) base;
	result = TRUE;
	return result;
}

static void
skk_skk_serv_class_init (SkkSkkServClass * klass,
                         gpointer klass_data)
{
	skk_skk_serv_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &SkkSkkServ_private_offset);
	((SkkDictClass *) klass)->reload = (void (*) (SkkDict*, GError**)) skk_skk_serv_real_reload;
	((SkkDictClass *) klass)->lookup = (SkkCandidate** (*) (SkkDict*, const gchar*, gboolean, gint*)) skk_skk_serv_real_lookup;
	((SkkDictClass *) klass)->complete = (gchar** (*) (SkkDict*, const gchar*, gint*)) skk_skk_serv_real_complete;
	SKK_DICT_CLASS (klass)->get_read_only = (gboolean (*) (SkkDict*)) skk_skk_serv_real_get_read_only;
	G_OBJECT_CLASS (klass)->get_property = _vala_skk_skk_serv_get_property;
	G_OBJECT_CLASS (klass)->finalize = skk_skk_serv_finalize;
	/**
	         * {@inheritDoc}
	         */
	g_object_class_install_property (G_OBJECT_CLASS (klass), SKK_SKK_SERV_READ_ONLY_PROPERTY, skk_skk_serv_properties[SKK_SKK_SERV_READ_ONLY_PROPERTY] = g_param_spec_boolean ("read-only", "read-only", "read-only", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
}

static void
skk_skk_serv_instance_init (SkkSkkServ * self,
                            gpointer klass)
{
	self->priv = skk_skk_serv_get_instance_private (self);
}

static void
skk_skk_serv_finalize (GObject * obj)
{
	SkkSkkServ * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SKK_TYPE_SKK_SERV, SkkSkkServ);
	skk_skk_serv_close_connection (self);
	_g_object_unref0 (self->priv->connection);
	_g_free0 (self->priv->host);
	_g_object_unref0 (self->priv->converter);
	G_OBJECT_CLASS (skk_skk_serv_parent_class)->finalize (obj);
}

/**
     * Network based Implementation of Dict.
     */
static GType
skk_skk_serv_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SkkSkkServClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) skk_skk_serv_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SkkSkkServ), 0, (GInstanceInitFunc) skk_skk_serv_instance_init, NULL };
	GType skk_skk_serv_type_id;
	skk_skk_serv_type_id = g_type_register_static (SKK_TYPE_DICT, "SkkSkkServ", &g_define_type_info, 0);
	SkkSkkServ_private_offset = g_type_add_instance_private (skk_skk_serv_type_id, sizeof (SkkSkkServPrivate));
	return skk_skk_serv_type_id;
}

GType
skk_skk_serv_get_type (void)
{
	static volatile gsize skk_skk_serv_type_id__once = 0;
	if (g_once_init_enter (&skk_skk_serv_type_id__once)) {
		GType skk_skk_serv_type_id;
		skk_skk_serv_type_id = skk_skk_serv_get_type_once ();
		g_once_init_leave (&skk_skk_serv_type_id__once, skk_skk_serv_type_id);
	}
	return skk_skk_serv_type_id__once;
}

static void
_vala_skk_skk_serv_get_property (GObject * object,
                                 guint property_id,
                                 GValue * value,
                                 GParamSpec * pspec)
{
	SkkSkkServ * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SKK_TYPE_SKK_SERV, SkkSkkServ);
	switch (property_id) {
		case SKK_SKK_SERV_READ_ONLY_PROPERTY:
		g_value_set_boolean (value, skk_dict_get_read_only ((SkkDict*) self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

