
// Workaround to access protected functions
#ifndef protected
#  define protected public
#endif

// default includes
#include <shiboken.h>
#include <sbkpep.h>
#include <sbkpepbuffer.h>

#define PYSIDE6_COMOPT_FULLNAME 1
#define PYSIDE6_COMOPT_COMPRESS 1
// TODO: #define PYSIDE6_COMOPT_FOLDING 1

#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QtCore/QDebug>
#include <pysideqobject.h>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <signalmanager.h>
#include <pysidemetafunction.h>
#include <pysideqenum.h>
#include <pysideqmetatype.h>
#include <pysideutils.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED


// module include
#include "kwidgetsaddons_python.h"

// main header
#include "kmultitabbarbutton_wrapper.h"

// Wrappers providing overrides
#include "ksplittercollapserbutton_wrapper.h"
#include "kxyselector_wrapper.h"
#include "ktimecombobox_wrapper.h"

// Argument includes
#include <QString>
#include <qbytearray.h>
#include <qcoreevent.h>
#include <qevent.h>
#include <qicon.h>
#include <qmetaobject.h>
#include <qnamespace.h>
#include <qobject.h>
#include <qobjectdefs.h>
#include <qpaintdevice.h>
#include <qpoint.h>
#include <qsize.h>
#include <qstyleoption.h>
#include <qvariant.h>
#include <qwidget.h>

#include <algorithm>
#include <cctype>
#include <cstring>
#include <iterator>
#include <set>
#include <type_traits>
#include <typeinfo>

extern "C" {
static PyTypeObject *_Sbk_KMultiTabBarButton_Type = nullptr;
static PyTypeObject *Sbk_KMultiTabBarButton_TypeF(void)
{
    return _Sbk_KMultiTabBarButton_Type;
}
} // extern "C"

// Native ---------------------------------------------------------

void KMultiTabBarButtonWrapper::resetPyMethodCache()
{
    std::fill(m_PyMethodCache.begin(), m_PyMethodCache.end(), nullptr);
}

KMultiTabBarButtonWrapper::KMultiTabBarButtonWrapper(const ::QIcon & icon, const ::QString & arg__2, int id, ::QWidget * parent) : KMultiTabBarButton(icon, arg__2, id, parent)
{
}

void KMultiTabBarButtonWrapper::actionEvent(::QActionEvent * event)
{
    static const char *funcName = "actionEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KMultiTabBarButton_TypeF(), gil, funcName, m_PyMethodCache[0], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::actionEvent(event);
    }
    KXYSelectorWrapper::sbk_o_actionEvent("KMultiTabBarButton", funcName, gil, pyOverride, event);
}

void KMultiTabBarButtonWrapper::changeEvent(::QEvent * e)
{
    static const char *funcName = "changeEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KMultiTabBarButton_TypeF(), gil, funcName, m_PyMethodCache[1], nameCache));
    if (pyOverride.isNull()) {
        return this->::QAbstractButton::changeEvent(e);
    }
    KXYSelectorWrapper::sbk_o_changeEvent("KMultiTabBarButton", funcName, gil, pyOverride, e);
}

void KMultiTabBarButtonWrapper::checkStateSet()
{
    static const char *funcName = "checkStateSet";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KMultiTabBarButton_TypeF(), gil, funcName, m_PyMethodCache[2], nameCache));
    if (pyOverride.isNull()) {
        return this->::QAbstractButton::checkStateSet();
    }
    KTimeComboBoxWrapper::sbk_o_hidePopup("KMultiTabBarButton", funcName, gil, pyOverride);
}

void KMultiTabBarButtonWrapper::childEvent(::QChildEvent * event)
{
    static const char *funcName = "childEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KMultiTabBarButton_TypeF(), gil, funcName, m_PyMethodCache[3], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::childEvent(event);
    }
    KXYSelectorWrapper::sbk_o_childEvent("KMultiTabBarButton", funcName, gil, pyOverride, event);
}

void KMultiTabBarButtonWrapper::closeEvent(::QCloseEvent * event)
{
    static const char *funcName = "closeEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KMultiTabBarButton_TypeF(), gil, funcName, m_PyMethodCache[4], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::closeEvent(event);
    }
    KXYSelectorWrapper::sbk_o_closeEvent("KMultiTabBarButton", funcName, gil, pyOverride, event);
}

void KMultiTabBarButtonWrapper::connectNotify(const ::QMetaMethod & signal)
{
    static const char *funcName = "connectNotify";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KMultiTabBarButton_TypeF(), gil, funcName, m_PyMethodCache[5], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::connectNotify(signal);
    }
    KXYSelectorWrapper::sbk_o_connectNotify("KMultiTabBarButton", funcName, gil, pyOverride, signal);
}

void KMultiTabBarButtonWrapper::contextMenuEvent(::QContextMenuEvent * event)
{
    static const char *funcName = "contextMenuEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KMultiTabBarButton_TypeF(), gil, funcName, m_PyMethodCache[6], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::contextMenuEvent(event);
    }
    KXYSelectorWrapper::sbk_o_contextMenuEvent("KMultiTabBarButton", funcName, gil, pyOverride, event);
}

void KMultiTabBarButtonWrapper::customEvent(::QEvent * event)
{
    static const char *funcName = "customEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KMultiTabBarButton_TypeF(), gil, funcName, m_PyMethodCache[7], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::customEvent(event);
    }
    KXYSelectorWrapper::sbk_o_customEvent("KMultiTabBarButton", funcName, gil, pyOverride, event);
}

int KMultiTabBarButtonWrapper::devType() const
{
    static const char *funcName = "devType";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KMultiTabBarButton_TypeF(), gil, funcName, m_PyMethodCache[8], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::devType();
    }
    return KXYSelectorWrapper::sbk_o_devType("KMultiTabBarButton", funcName, gil, pyOverride);
}

void KMultiTabBarButtonWrapper::disconnectNotify(const ::QMetaMethod & signal)
{
    static const char *funcName = "disconnectNotify";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KMultiTabBarButton_TypeF(), gil, funcName, m_PyMethodCache[9], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::disconnectNotify(signal);
    }
    KXYSelectorWrapper::sbk_o_connectNotify("KMultiTabBarButton", funcName, gil, pyOverride, signal);
}

void KMultiTabBarButtonWrapper::dragEnterEvent(::QDragEnterEvent * event)
{
    static const char *funcName = "dragEnterEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KMultiTabBarButton_TypeF(), gil, funcName, m_PyMethodCache[10], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::dragEnterEvent(event);
    }
    KXYSelectorWrapper::sbk_o_dragEnterEvent("KMultiTabBarButton", funcName, gil, pyOverride, event);
}

void KMultiTabBarButtonWrapper::dragLeaveEvent(::QDragLeaveEvent * event)
{
    static const char *funcName = "dragLeaveEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KMultiTabBarButton_TypeF(), gil, funcName, m_PyMethodCache[11], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::dragLeaveEvent(event);
    }
    KXYSelectorWrapper::sbk_o_dragLeaveEvent("KMultiTabBarButton", funcName, gil, pyOverride, event);
}

void KMultiTabBarButtonWrapper::dragMoveEvent(::QDragMoveEvent * event)
{
    static const char *funcName = "dragMoveEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KMultiTabBarButton_TypeF(), gil, funcName, m_PyMethodCache[12], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::dragMoveEvent(event);
    }
    KXYSelectorWrapper::sbk_o_dragMoveEvent("KMultiTabBarButton", funcName, gil, pyOverride, event);
}

void KMultiTabBarButtonWrapper::dropEvent(::QDropEvent * event)
{
    static const char *funcName = "dropEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KMultiTabBarButton_TypeF(), gil, funcName, m_PyMethodCache[13], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::dropEvent(event);
    }
    KXYSelectorWrapper::sbk_o_dropEvent("KMultiTabBarButton", funcName, gil, pyOverride, event);
}

void KMultiTabBarButtonWrapper::enterEvent(::QEnterEvent * event)
{
    static const char *funcName = "enterEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KMultiTabBarButton_TypeF(), gil, funcName, m_PyMethodCache[14], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::enterEvent(event);
    }
    KXYSelectorWrapper::sbk_o_enterEvent("KMultiTabBarButton", funcName, gil, pyOverride, event);
}

bool KMultiTabBarButtonWrapper::event(::QEvent * e)
{
    static const char *funcName = "event";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KMultiTabBarButton_TypeF(), gil, funcName, m_PyMethodCache[15], nameCache));
    if (pyOverride.isNull()) {
        return this->::QPushButton::event(e);
    }
    return KXYSelectorWrapper::sbk_o_event("KMultiTabBarButton", funcName, gil, pyOverride, e);
}

bool KMultiTabBarButtonWrapper::eventFilter(::QObject * watched, ::QEvent * event)
{
    static const char *funcName = "eventFilter";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KMultiTabBarButton_TypeF(), gil, funcName, m_PyMethodCache[16], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::eventFilter(watched, event);
    }
    return KXYSelectorWrapper::sbk_o_eventFilter("KMultiTabBarButton", funcName, gil, pyOverride, watched, event);
}

void KMultiTabBarButtonWrapper::focusInEvent(::QFocusEvent * arg__1)
{
    static const char *funcName = "focusInEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KMultiTabBarButton_TypeF(), gil, funcName, m_PyMethodCache[17], nameCache));
    if (pyOverride.isNull()) {
        return this->::QPushButton::focusInEvent(arg__1);
    }
    KXYSelectorWrapper::sbk_o_focusInEvent("KMultiTabBarButton", funcName, gil, pyOverride, arg__1);
}

bool KMultiTabBarButtonWrapper::focusNextPrevChild(bool next)
{
    static const char *funcName = "focusNextPrevChild";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KMultiTabBarButton_TypeF(), gil, funcName, m_PyMethodCache[18], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::focusNextPrevChild(next);
    }
    return KXYSelectorWrapper::sbk_o_focusNextPrevChild("KMultiTabBarButton", funcName, gil, pyOverride, next);
}

void KMultiTabBarButtonWrapper::focusOutEvent(::QFocusEvent * arg__1)
{
    static const char *funcName = "focusOutEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KMultiTabBarButton_TypeF(), gil, funcName, m_PyMethodCache[19], nameCache));
    if (pyOverride.isNull()) {
        return this->::QPushButton::focusOutEvent(arg__1);
    }
    KXYSelectorWrapper::sbk_o_focusOutEvent("KMultiTabBarButton", funcName, gil, pyOverride, arg__1);
}

bool KMultiTabBarButtonWrapper::hasHeightForWidth() const
{
    static const char *funcName = "hasHeightForWidth";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KMultiTabBarButton_TypeF(), gil, funcName, m_PyMethodCache[20], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::hasHeightForWidth();
    }
    return KXYSelectorWrapper::sbk_o_hasHeightForWidth("KMultiTabBarButton", funcName, gil, pyOverride);
}

int KMultiTabBarButtonWrapper::heightForWidth(int arg__1) const
{
    static const char *funcName = "heightForWidth";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KMultiTabBarButton_TypeF(), gil, funcName, m_PyMethodCache[21], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::heightForWidth(arg__1);
    }
    return KXYSelectorWrapper::sbk_o_heightForWidth("KMultiTabBarButton", funcName, gil, pyOverride, arg__1);
}

void KMultiTabBarButtonWrapper::hideEvent(::QHideEvent * arg__1)
{
    static const char *funcName = "hideEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KMultiTabBarButton_TypeF(), gil, funcName, m_PyMethodCache[22], nameCache));
    if (pyOverride.isNull()) {
        return this->::KMultiTabBarButton::hideEvent(arg__1);
    }
    KXYSelectorWrapper::sbk_o_hideEvent("KMultiTabBarButton", funcName, gil, pyOverride, arg__1);
}

bool KMultiTabBarButtonWrapper::hitButton(const ::QPoint & pos) const
{
    static const char *funcName = "hitButton";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KMultiTabBarButton_TypeF(), gil, funcName, m_PyMethodCache[23], nameCache));
    if (pyOverride.isNull()) {
        return this->::QPushButton::hitButton(pos);
    }
    return KSplitterCollapserButtonWrapper::sbk_o_hitButton("KMultiTabBarButton", funcName, gil, pyOverride, pos);
}

void KMultiTabBarButtonWrapper::initPainter(::QPainter * painter) const
{
    static const char *funcName = "initPainter";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KMultiTabBarButton_TypeF(), gil, funcName, m_PyMethodCache[24], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::initPainter(painter);
    }
    KXYSelectorWrapper::sbk_o_drawContents("KMultiTabBarButton", funcName, gil, pyOverride, painter);
}

void KMultiTabBarButtonWrapper::initStyleOption(::QStyleOptionButton * option) const
{
    static const char *funcName = "initStyleOption";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KMultiTabBarButton_TypeF(), gil, funcName, m_PyMethodCache[25], nameCache));
    if (pyOverride.isNull()) {
        return this->::QPushButton::initStyleOption(option);
    }
    sbk_o_initStyleOption("KMultiTabBarButton", funcName, gil, pyOverride, option);
}

void KMultiTabBarButtonWrapper::sbk_o_initStyleOption(const char *ownerClassName, const char *funcName, Shiboken::GilState &gil, const Shiboken::AutoDecRef &pyOverride, ::QStyleOptionButton * option)
{
    SBK_UNUSED(ownerClassName)
    SBK_UNUSED(funcName)
    SBK_UNUSED(gil)
    SBK_UNUSED(pyOverride)
#if !defined(PYPY_VERSION) && !defined(Py_LIMITED_API)
    PyObject *pyArgArray[1] = {
        Shiboken::Conversions::pointerToPython(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QStyleOptionButton_IDX]), option)
    };
#else
    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
        Shiboken::Conversions::pointerToPython(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QStyleOptionButton_IDX]), option)
    ));
#endif

#if !defined(PYPY_VERSION) && !defined(Py_LIMITED_API)
    Shiboken::AutoDecRef pyResult(PyObject_Vectorcall(pyOverride, pyArgArray, 1, nullptr));
    Py_DECREF(pyArgArray[0]);
#else
    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
#endif
    if (pyResult.isNull()) {
        // An error happened in python code!
        Shiboken::Errors::storePythonOverrideErrorOrPrint(ownerClassName, funcName);
        return;
    }
}

void KMultiTabBarButtonWrapper::inputMethodEvent(::QInputMethodEvent * event)
{
    static const char *funcName = "inputMethodEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KMultiTabBarButton_TypeF(), gil, funcName, m_PyMethodCache[26], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::inputMethodEvent(event);
    }
    KXYSelectorWrapper::sbk_o_inputMethodEvent("KMultiTabBarButton", funcName, gil, pyOverride, event);
}

::QVariant KMultiTabBarButtonWrapper::inputMethodQuery(::Qt::InputMethodQuery arg__1) const
{
    static const char *funcName = "inputMethodQuery";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KMultiTabBarButton_TypeF(), gil, funcName, m_PyMethodCache[27], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::inputMethodQuery(arg__1);
    }
    return KXYSelectorWrapper::sbk_o_inputMethodQuery("KMultiTabBarButton", funcName, gil, pyOverride, arg__1);
}

void KMultiTabBarButtonWrapper::keyPressEvent(::QKeyEvent * arg__1)
{
    static const char *funcName = "keyPressEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KMultiTabBarButton_TypeF(), gil, funcName, m_PyMethodCache[28], nameCache));
    if (pyOverride.isNull()) {
        return this->::QPushButton::keyPressEvent(arg__1);
    }
    KXYSelectorWrapper::sbk_o_keyPressEvent("KMultiTabBarButton", funcName, gil, pyOverride, arg__1);
}

void KMultiTabBarButtonWrapper::keyReleaseEvent(::QKeyEvent * e)
{
    static const char *funcName = "keyReleaseEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KMultiTabBarButton_TypeF(), gil, funcName, m_PyMethodCache[29], nameCache));
    if (pyOverride.isNull()) {
        return this->::QAbstractButton::keyReleaseEvent(e);
    }
    KXYSelectorWrapper::sbk_o_keyReleaseEvent("KMultiTabBarButton", funcName, gil, pyOverride, e);
}

void KMultiTabBarButtonWrapper::leaveEvent(::QEvent * event)
{
    static const char *funcName = "leaveEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KMultiTabBarButton_TypeF(), gil, funcName, m_PyMethodCache[30], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::leaveEvent(event);
    }
    KXYSelectorWrapper::sbk_o_leaveEvent("KMultiTabBarButton", funcName, gil, pyOverride, event);
}

int KMultiTabBarButtonWrapper::metric(::QPaintDevice::PaintDeviceMetric arg__1) const
{
    static const char *funcName = "metric";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KMultiTabBarButton_TypeF(), gil, funcName, m_PyMethodCache[31], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::metric(arg__1);
    }
    return KXYSelectorWrapper::sbk_o_metric("KMultiTabBarButton", funcName, gil, pyOverride, arg__1);
}

::QSize KMultiTabBarButtonWrapper::minimumSizeHint() const
{
    static const char *funcName = "minimumSizeHint";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KMultiTabBarButton_TypeF(), gil, funcName, m_PyMethodCache[32], nameCache));
    if (pyOverride.isNull()) {
        return this->::QPushButton::minimumSizeHint();
    }
    return KXYSelectorWrapper::sbk_o_minimumSizeHint("KMultiTabBarButton", funcName, gil, pyOverride);
}

void KMultiTabBarButtonWrapper::mouseDoubleClickEvent(::QMouseEvent * event)
{
    static const char *funcName = "mouseDoubleClickEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KMultiTabBarButton_TypeF(), gil, funcName, m_PyMethodCache[33], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::mouseDoubleClickEvent(event);
    }
    KXYSelectorWrapper::sbk_o_mouseDoubleClickEvent("KMultiTabBarButton", funcName, gil, pyOverride, event);
}

void KMultiTabBarButtonWrapper::mouseMoveEvent(::QMouseEvent * arg__1)
{
    static const char *funcName = "mouseMoveEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KMultiTabBarButton_TypeF(), gil, funcName, m_PyMethodCache[34], nameCache));
    if (pyOverride.isNull()) {
        return this->::QPushButton::mouseMoveEvent(arg__1);
    }
    KXYSelectorWrapper::sbk_o_mouseMoveEvent("KMultiTabBarButton", funcName, gil, pyOverride, arg__1);
}

void KMultiTabBarButtonWrapper::mousePressEvent(::QMouseEvent * e)
{
    static const char *funcName = "mousePressEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KMultiTabBarButton_TypeF(), gil, funcName, m_PyMethodCache[35], nameCache));
    if (pyOverride.isNull()) {
        return this->::QAbstractButton::mousePressEvent(e);
    }
    KXYSelectorWrapper::sbk_o_mousePressEvent("KMultiTabBarButton", funcName, gil, pyOverride, e);
}

void KMultiTabBarButtonWrapper::mouseReleaseEvent(::QMouseEvent * e)
{
    static const char *funcName = "mouseReleaseEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KMultiTabBarButton_TypeF(), gil, funcName, m_PyMethodCache[36], nameCache));
    if (pyOverride.isNull()) {
        return this->::QAbstractButton::mouseReleaseEvent(e);
    }
    KXYSelectorWrapper::sbk_o_mouseReleaseEvent("KMultiTabBarButton", funcName, gil, pyOverride, e);
}

void KMultiTabBarButtonWrapper::moveEvent(::QMoveEvent * event)
{
    static const char *funcName = "moveEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KMultiTabBarButton_TypeF(), gil, funcName, m_PyMethodCache[37], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::moveEvent(event);
    }
    KXYSelectorWrapper::sbk_o_moveEvent("KMultiTabBarButton", funcName, gil, pyOverride, event);
}

bool KMultiTabBarButtonWrapper::nativeEvent(const ::QByteArray & eventType, void * message, ::qintptr * result)
{
    static const char *funcName = "nativeEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KMultiTabBarButton_TypeF(), gil, funcName, m_PyMethodCache[38], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::nativeEvent(eventType, message, result);
    }
    return KXYSelectorWrapper::sbk_o_nativeEvent("KMultiTabBarButton", funcName, gil, pyOverride, eventType, message, result);
}

void KMultiTabBarButtonWrapper::nextCheckState()
{
    static const char *funcName = "nextCheckState";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KMultiTabBarButton_TypeF(), gil, funcName, m_PyMethodCache[39], nameCache));
    if (pyOverride.isNull()) {
        return this->::QAbstractButton::nextCheckState();
    }
    KTimeComboBoxWrapper::sbk_o_hidePopup("KMultiTabBarButton", funcName, gil, pyOverride);
}

::QPaintEngine * KMultiTabBarButtonWrapper::paintEngine() const
{
    static const char *funcName = "paintEngine";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KMultiTabBarButton_TypeF(), gil, funcName, m_PyMethodCache[40], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::paintEngine();
    }
    return KXYSelectorWrapper::sbk_o_paintEngine("KMultiTabBarButton", funcName, gil, pyOverride);
}

void KMultiTabBarButtonWrapper::paintEvent(::QPaintEvent * arg__1)
{
    static const char *funcName = "paintEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KMultiTabBarButton_TypeF(), gil, funcName, m_PyMethodCache[41], nameCache));
    if (pyOverride.isNull()) {
        return this->::KMultiTabBarButton::paintEvent(arg__1);
    }
    KXYSelectorWrapper::sbk_o_paintEvent("KMultiTabBarButton", funcName, gil, pyOverride, arg__1);
}

::QPaintDevice * KMultiTabBarButtonWrapper::redirected(::QPoint * offset) const
{
    static const char *funcName = "redirected";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KMultiTabBarButton_TypeF(), gil, funcName, m_PyMethodCache[42], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::redirected(offset);
    }
    return KXYSelectorWrapper::sbk_o_redirected("KMultiTabBarButton", funcName, gil, pyOverride, offset);
}

void KMultiTabBarButtonWrapper::resizeEvent(::QResizeEvent * event)
{
    static const char *funcName = "resizeEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KMultiTabBarButton_TypeF(), gil, funcName, m_PyMethodCache[43], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::resizeEvent(event);
    }
    KXYSelectorWrapper::sbk_o_resizeEvent("KMultiTabBarButton", funcName, gil, pyOverride, event);
}

void KMultiTabBarButtonWrapper::setVisible(bool visible)
{
    // This method belongs to a property.
    static const char *funcName = "2:setVisible";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KMultiTabBarButton_TypeF(), gil, funcName, m_PyMethodCache[44], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::setVisible(visible);
    }
    KXYSelectorWrapper::sbk_o_setVisible("KMultiTabBarButton", funcName, gil, pyOverride, visible);
}

::QPainter * KMultiTabBarButtonWrapper::sharedPainter() const
{
    static const char *funcName = "sharedPainter";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KMultiTabBarButton_TypeF(), gil, funcName, m_PyMethodCache[45], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::sharedPainter();
    }
    return KXYSelectorWrapper::sbk_o_sharedPainter("KMultiTabBarButton", funcName, gil, pyOverride);
}

void KMultiTabBarButtonWrapper::showEvent(::QShowEvent * arg__1)
{
    static const char *funcName = "showEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KMultiTabBarButton_TypeF(), gil, funcName, m_PyMethodCache[46], nameCache));
    if (pyOverride.isNull()) {
        return this->::KMultiTabBarButton::showEvent(arg__1);
    }
    KXYSelectorWrapper::sbk_o_showEvent("KMultiTabBarButton", funcName, gil, pyOverride, arg__1);
}

::QSize KMultiTabBarButtonWrapper::sizeHint() const
{
    static const char *funcName = "sizeHint";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KMultiTabBarButton_TypeF(), gil, funcName, m_PyMethodCache[47], nameCache));
    if (pyOverride.isNull()) {
        return this->::QPushButton::sizeHint();
    }
    return KXYSelectorWrapper::sbk_o_minimumSizeHint("KMultiTabBarButton", funcName, gil, pyOverride);
}

void KMultiTabBarButtonWrapper::slotClicked()
{
    static const char *funcName = "slotClicked";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KMultiTabBarButton_TypeF(), gil, funcName, m_PyMethodCache[48], nameCache));
    if (pyOverride.isNull()) {
        return this->::KMultiTabBarButton::slotClicked();
    }
    KTimeComboBoxWrapper::sbk_o_hidePopup("KMultiTabBarButton", funcName, gil, pyOverride);
}

void KMultiTabBarButtonWrapper::tabletEvent(::QTabletEvent * event)
{
    static const char *funcName = "tabletEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KMultiTabBarButton_TypeF(), gil, funcName, m_PyMethodCache[49], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::tabletEvent(event);
    }
    KXYSelectorWrapper::sbk_o_tabletEvent("KMultiTabBarButton", funcName, gil, pyOverride, event);
}

void KMultiTabBarButtonWrapper::timerEvent(::QTimerEvent * e)
{
    static const char *funcName = "timerEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KMultiTabBarButton_TypeF(), gil, funcName, m_PyMethodCache[50], nameCache));
    if (pyOverride.isNull()) {
        return this->::QAbstractButton::timerEvent(e);
    }
    KXYSelectorWrapper::sbk_o_timerEvent("KMultiTabBarButton", funcName, gil, pyOverride, e);
}

void KMultiTabBarButtonWrapper::wheelEvent(::QWheelEvent * event)
{
    static const char *funcName = "wheelEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KMultiTabBarButton_TypeF(), gil, funcName, m_PyMethodCache[51], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::wheelEvent(event);
    }
    KXYSelectorWrapper::sbk_o_wheelEvent("KMultiTabBarButton", funcName, gil, pyOverride, event);
}

const QMetaObject *KMultiTabBarButtonWrapper::metaObject() const
{
    if (QObject::d_ptr->metaObject != nullptr)
        return QObject::d_ptr->dynamicMetaObject();
    SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this);
    if (pySelf == nullptr)
        return KMultiTabBarButton::metaObject();
    return PySide::SignalManager::retrieveMetaObject(reinterpret_cast<PyObject *>(pySelf));
}

int KMultiTabBarButtonWrapper::qt_metacall(QMetaObject::Call call, int id, void **args)
{
    int result = KMultiTabBarButton::qt_metacall(call, id, args);
    return result < 0 ? result : PySide::SignalManager::qt_metacall(this, call, id, args);
}

void *KMultiTabBarButtonWrapper::qt_metacast(const char *_clname)
{
    if (_clname == nullptr)
        return {};
    if (SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this)) {
        auto *obSelf = reinterpret_cast<PyObject *>(pySelf);
        if (PySide::inherits(Py_TYPE(obSelf), _clname))
            return static_cast<void *>(const_cast< KMultiTabBarButtonWrapper *>(this));
    }
    return KMultiTabBarButton::qt_metacast(_clname);
}

KMultiTabBarButtonWrapper::~KMultiTabBarButtonWrapper()
{
    auto *wrapper = Shiboken::BindingManager::instance().retrieveWrapper(this, Sbk_KMultiTabBarButton_TypeF());
    Shiboken::Object::destroy(wrapper, this);
}

// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_KMultiTabBarButton_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SBK_UNUSED(kwds)
    auto *sbkSelf = reinterpret_cast<SbkObject *>(self);
    PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::KMultiTabBarButton >()))
        return -1;

    KMultiTabBarButtonWrapper *cptr{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[4];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr, nullptr, nullptr};

    // invalid argument lengths

    if (PyArg_UnpackTuple(args, "KMultiTabBarButton", 4, 4, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3])) == 0)
        return -1;


    // Overloaded function decisor
    // 0: KMultiTabBarButton::KMultiTabBarButton(QIcon,QString,int,QWidget*)
    if (numArgs == 4
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QIcon_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[2])))
        && (pythonToCpp[3] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX]), (pyArgs[3])))) {
        overloadId = 0; // KMultiTabBarButton(QIcon,QString,int,QWidget*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KMultiTabBarButton_IDX]);


    // PyMI support
    bool usesPyMI = Shiboken::callInheritedInit(self, args, kwds, SbkKWidgetsAddonsTypeStructs[SBK_KMultiTabBarButton_IDX]);
    if (Shiboken::Errors::occurred() != nullptr)
        return -1;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return -1;
        ::QIcon cppArg0_local;
        ::QIcon *cppArg0 = &cppArg0_local;
        if (pythonToCpp[0].isValue())
            pythonToCpp[0](pyArgs[0], &cppArg0_local);
        else
            pythonToCpp[0](pyArgs[0], &cppArg0);

        ::QString cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        int cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        if (!Shiboken::Object::isValid(pyArgs[3]))
            return -1;
        ::QWidget *cppArg3;
        pythonToCpp[3](pyArgs[3], &cppArg3);

        if (Shiboken::Errors::occurred() == nullptr) {
            // KMultiTabBarButton(QIcon,QString,int,QWidget*)
            void *addr = PySide::nextQObjectMemoryAddr();
            if (addr != nullptr) {
                cptr = new (addr) KMultiTabBarButtonWrapper(*cppArg0, cppArg1, cppArg2, cppArg3);
                PySide::setNextQObjectMemoryAddr(nullptr);
            } else {
                cptr = new KMultiTabBarButtonWrapper(*cppArg0, cppArg1, cppArg2, cppArg3);
            }

        }
    }

    if (Shiboken::Errors::occurred() != nullptr || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< KMultiTabBarButton >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (cptr == nullptr)
        return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KMultiTabBarButton_IDX]);

    Shiboken::Object::setValidCpp(sbkSelf, true);
    Shiboken::Object::setHasCppWrapper(sbkSelf, true);
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);

    // QObject setup
    PySide::Signal::updateSourceObject(self);
    const auto *metaObject = cptr->metaObject(); // <- init python qt properties
    if (!errInfo.isNull() && PyDict_Check(errInfo.object())) {
        if (!PySide::fillQtProperties(self, metaObject, errInfo, usesPyMI))
            return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KMultiTabBarButton_IDX]);
    };


    return 1;
}

static PyObject *Sbk_KMultiTabBarButtonFunc_hideEvent(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KMultiTabBarButton *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KMultiTabBarButton_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QWidget::hideEvent(QHideEvent*)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QHideEvent_IDX]), (pyArg)))) {
        overloadId = 0; // hideEvent(QHideEvent*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "hideEvent", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KMultiTabBarButton_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QHideEvent *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // hideEvent(QHideEvent*)
            Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::KMultiTabBarButton::hideEvent(cppArg0)
                : cppSelf->hideEvent(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KMultiTabBarButtonFunc_id(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KMultiTabBarButton *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KMultiTabBarButton_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // id()const
        int cppResult = const_cast<const ::KMultiTabBarButton *>(cppSelf)->id();
        pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KMultiTabBarButtonFunc_paintEvent(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KMultiTabBarButton *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KMultiTabBarButton_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QWidget::paintEvent(QPaintEvent*)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QPaintEvent_IDX]), (pyArg)))) {
        overloadId = 0; // paintEvent(QPaintEvent*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "paintEvent", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KMultiTabBarButton_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QPaintEvent *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // paintEvent(QPaintEvent*)
            Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::KMultiTabBarButton::paintEvent(cppArg0)
                : cppSelf->paintEvent(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KMultiTabBarButtonFunc_setText(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KMultiTabBarButton *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KMultiTabBarButton_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KMultiTabBarButton::setText(QString)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArg)))) {
        overloadId = 0; // setText(QString)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setText", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KMultiTabBarButton_IDX]);

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setText(QString)
            cppSelf->setText(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KMultiTabBarButtonFunc_showEvent(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KMultiTabBarButton *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KMultiTabBarButton_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QWidget::showEvent(QShowEvent*)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QShowEvent_IDX]), (pyArg)))) {
        overloadId = 0; // showEvent(QShowEvent*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "showEvent", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KMultiTabBarButton_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QShowEvent *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // showEvent(QShowEvent*)
            Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::KMultiTabBarButton::showEvent(cppArg0)
                : cppSelf->showEvent(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KMultiTabBarButtonFunc_slotClicked(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KMultiTabBarButton *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KMultiTabBarButton_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // slotClicked()
        Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
            ? cppSelf->::KMultiTabBarButton::slotClicked()
            : cppSelf->slotClicked();
    }

     return Sbk_ReturnFromPython_None();
}


static const char *Sbk_KMultiTabBarButton_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_KMultiTabBarButton_methods[] = {
    {"hideEvent", reinterpret_cast<PyCFunction>(Sbk_KMultiTabBarButtonFunc_hideEvent), METH_O, nullptr},
    {"id", reinterpret_cast<PyCFunction>(Sbk_KMultiTabBarButtonFunc_id), METH_NOARGS, nullptr},
    {"paintEvent", reinterpret_cast<PyCFunction>(Sbk_KMultiTabBarButtonFunc_paintEvent), METH_O, nullptr},
    {"setText", reinterpret_cast<PyCFunction>(Sbk_KMultiTabBarButtonFunc_setText), METH_O, nullptr},
    {"showEvent", reinterpret_cast<PyCFunction>(Sbk_KMultiTabBarButtonFunc_showEvent), METH_O, nullptr},
    {"slotClicked", reinterpret_cast<PyCFunction>(Sbk_KMultiTabBarButtonFunc_slotClicked), METH_NOARGS, nullptr},
    {nullptr, nullptr, 0, nullptr} // Sentinel
};

static int Sbk_KMultiTabBarButton_setattro(PyObject *self, PyObject *name, PyObject *value)
{
    PySide::Feature::Select(self);
    if (value != nullptr && PyCallable_Check(value) != 0) {
        auto plain_inst = reinterpret_cast< ::KMultiTabBarButton *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KMultiTabBarButton_IDX]), reinterpret_cast<SbkObject *>(self)));
        auto *inst = dynamic_cast<KMultiTabBarButtonWrapper *>(plain_inst);
        if (inst != nullptr)
            inst->resetPyMethodCache();
    }
    Shiboken::AutoDecRef pp(reinterpret_cast<PyObject *>(PySide::Property::getObject(self, name)));
    if (!pp.isNull())
        return PySide::Property::setValue(reinterpret_cast<PySideProperty *>(pp.object()), self, value);
    return PyObject_GenericSetAttr(self, name, value);
}

} // extern "C"

static int Sbk_KMultiTabBarButton_traverse(PyObject *self, visitproc visit, void *arg)
{
    auto traverseProc = reinterpret_cast<traverseproc>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_traverse));
    ;
    return traverseProc(self, visit, arg);
}
static int Sbk_KMultiTabBarButton_clear(PyObject *self)
{
    auto clearProc = reinterpret_cast<inquiry>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_clear));
    ;
    return clearProc(self);
}
static void * Sbk_KMultiTabBarButtonSpecialCastFunction(void *obj, PyTypeObject *desiredType)
{
    auto me = reinterpret_cast< ::KMultiTabBarButton *>(obj);
    if (desiredType == Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QPushButton_IDX]))
        return static_cast< ::QPushButton *>(me);
    else if (desiredType == Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QAbstractButton_IDX]))
        return static_cast< ::QAbstractButton *>(me);
    else if (desiredType == Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX]))
        return static_cast< ::QWidget *>(me);
    else if (desiredType == Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QObject_IDX]))
        return static_cast< ::QObject *>(me);
    else if (desiredType == Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QPaintDevice_IDX]))
        return static_cast< ::QPaintDevice *>(me);
    return me;
}



// Class Definition -----------------------------------------------
extern "C" {

static PyType_Slot Sbk_KMultiTabBarButton_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_setattro,    reinterpret_cast<void *>(Sbk_KMultiTabBarButton_setattro)},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_KMultiTabBarButton_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_KMultiTabBarButton_clear)},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_KMultiTabBarButton_methods)},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_KMultiTabBarButton_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObject_tp_new)},
    {0, nullptr}
};
static PyType_Spec Sbk_KMultiTabBarButton_spec = {
    "1:KWidgetsAddons.KMultiTabBarButton",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_HAVE_GC,
    Sbk_KMultiTabBarButton_slots
};

} //extern "C"

static void *Sbk_KMultiTabBarButton_typeDiscovery(void *cptr, PyTypeObject *instanceType)
{
    SBK_UNUSED(cptr)
    SBK_UNUSED(instanceType)
    if (instanceType == Shiboken::SbkType< ::QWidget >())
        return dynamic_cast< ::KMultiTabBarButton *>(reinterpret_cast< ::QWidget *>(cptr));
    if (instanceType == Shiboken::SbkType< ::QObject >())
        return dynamic_cast< ::KMultiTabBarButton *>(reinterpret_cast< ::QObject *>(cptr));
    if (instanceType == Shiboken::SbkType< ::QPaintDevice >())
        return dynamic_cast< ::KMultiTabBarButton *>(reinterpret_cast< ::QPaintDevice *>(cptr));
    return {};
}


// Type conversion functions.

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void KMultiTabBarButton_PythonToCpp_KMultiTabBarButton_PTR(PyObject *pyIn, void *cppOut)
{
    Shiboken::Conversions::pythonToCppPointer(Sbk_KMultiTabBarButton_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_KMultiTabBarButton_PythonToCpp_KMultiTabBarButton_PTR_Convertible(PyObject *pyIn)
{
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, Sbk_KMultiTabBarButton_TypeF()))
        return KMultiTabBarButton_PythonToCpp_KMultiTabBarButton_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *KMultiTabBarButton_PTR_CppToPython_KMultiTabBarButton(const void *cppIn)
{
    return PySide::getWrapperForQObject(reinterpret_cast<::KMultiTabBarButton *>(const_cast<void *>(cppIn)), Sbk_KMultiTabBarButton_TypeF());

}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
#if PYSIDE6_COMOPT_COMPRESS == 0
static const char *KMultiTabBarButton_SignatureStrings[] = {
    "KWidgetsAddons.KMultiTabBarButton(self,icon:typing.Union[PySide6.QtGui.QIcon, PySide6.QtGui.QPixmap],arg__2:QString,id:int,parent:PySide6.QtWidgets.QWidget)",
    "KWidgetsAddons.KMultiTabBarButton.hideEvent(self,arg__1:PySide6.QtGui.QHideEvent)",
    "KWidgetsAddons.KMultiTabBarButton.id(self)->int",
    "KWidgetsAddons.KMultiTabBarButton.paintEvent(self,arg__1:PySide6.QtGui.QPaintEvent)",
    "KWidgetsAddons.KMultiTabBarButton.setText(self,text:QString)",
    "KWidgetsAddons.KMultiTabBarButton.showEvent(self,arg__1:PySide6.QtGui.QShowEvent)",
    "KWidgetsAddons.KMultiTabBarButton.slotClicked(self)",
    nullptr}; // Sentinel
#else
static constexpr size_t KMultiTabBarButton_SignatureByteSize = 210;
static constexpr uint8_t KMultiTabBarButton_SignatureBytes[210] = {
    0x78, 0xda, 0x8d, 0x90, 0x41, 0x0b, 0x82, 0x30, 0x14, 0x80, 0xef, 0xfe, 0x8a, 0x8e, 0x05, 0x6b,
    0x50, 0x87, 0x0e, 0x3b, 0x04, 0x15, 0x51, 0x21, 0x81, 0xa2, 0xd1, 0x21, 0x42, 0x96, 0x5b, 0xf6,
    0xc8, 0x36, 0xd1, 0x67, 0xe9, 0xbf, 0x6f, 0x98, 0x16, 0x74, 0x71, 0xb7, 0xc7, 0xf8, 0xde, 0xb7,
    0x8f, 0xe7, 0x1e, 0x41, 0x24, 0x12, 0x8b, 0x85, 0x10, 0x5a, 0x15, 0xd4, 0xdd, 0x97, 0x29, 0x42,
    0xc8, 0x2f, 0x4b, 0x9e, 0x2f, 0x4b, 0x44, 0xad, 0x86, 0x85, 0x4c, 0xaf, 0x04, 0x62, 0xad, 0x18,
    0xd6, 0x19, 0xa8, 0x84, 0x1e, 0x14, 0x68, 0x75, 0xf2, 0xea, 0x00, 0x84, 0x9c, 0x51, 0x1f, 0x37,
    0x25, 0x50, 0x7f, 0x67, 0x00, 0x32, 0xf8, 0x7b, 0xf4, 0xa0, 0x7a, 0xf0, 0xec, 0x4c, 0x78, 0x9e,
    0x44, 0xd1, 0x94, 0xf9, 0x01, 0xe6, 0x46, 0x40, 0x40, 0x30, 0x50, 0x48, 0x32, 0x9e, 0x4b, 0x85,
    0xec, 0xb7, 0xd3, 0xa6, 0x50, 0xff, 0x33, 0x8c, 0x1c, 0xb7, 0x2f, 0x8e, 0xde, 0xcc, 0xea, 0xfa,
    0x69, 0x34, 0x9f, 0xcc, 0xe6, 0xa3, 0x09, 0xfb, 0xcb, 0xd8, 0x76, 0x90, 0x8d, 0x11, 0x44, 0xa3,
    0x1a, 0x8d, 0xe7, 0xa6, 0xd1, 0x82, 0xcf, 0xb8, 0xe1, 0x7a, 0x13, 0xbc, 0x2f, 0x65, 0xd3, 0x50,
    0x48, 0x0c, 0x65, 0xd5, 0x0a, 0xd1, 0x4c, 0xdd, 0xe9, 0xac, 0x96, 0x6f, 0xfa, 0xd5, 0xdb, 0x13,
    0x74, 0x90, 0x95, 0x31, 0xd5, 0xb8, 0x4a, 0x21, 0xbe, 0xcb, 0xf6, 0x36, 0xce, 0x1b, 0x36, 0x0b,
    0xce, 0x43
};
#endif

PyTypeObject *init_KMultiTabBarButton(PyObject *module)
{
    if (SbkKWidgetsAddonsTypeStructs[SBK_KMultiTabBarButton_IDX].type != nullptr)
        return SbkKWidgetsAddonsTypeStructs[SBK_KMultiTabBarButton_IDX].type;

    Shiboken::AutoDecRef Sbk_KMultiTabBarButton_Type_bases(PyTuple_Pack(1,
        reinterpret_cast<PyObject *>(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QPushButton_IDX]))));

    _Sbk_KMultiTabBarButton_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "KMultiTabBarButton",
        "KMultiTabBarButton*",
        &Sbk_KMultiTabBarButton_spec,
        &Shiboken::callCppDestructor< KMultiTabBarButton >,
        Sbk_KMultiTabBarButton_Type_bases.object(),
        Shiboken::ObjectType::WrapperFlags::DeleteInMainThread);
    auto *pyType = Sbk_KMultiTabBarButton_TypeF(); // references _Sbk_KMultiTabBarButton_Type
#if PYSIDE6_COMOPT_COMPRESS == 0
    InitSignatureStrings(pyType, KMultiTabBarButton_SignatureStrings);
#else
    InitSignatureBytes(pyType, KMultiTabBarButton_SignatureBytes, KMultiTabBarButton_SignatureByteSize);
#endif
    SbkObjectType_SetPropertyStrings(pyType, Sbk_KMultiTabBarButton_PropertyStrings);
    SbkKWidgetsAddonsTypeStructs[SBK_KMultiTabBarButton_IDX].type = pyType;

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(pyType,
        KMultiTabBarButton_PythonToCpp_KMultiTabBarButton_PTR,
        is_KMultiTabBarButton_PythonToCpp_KMultiTabBarButton_PTR_Convertible,
        KMultiTabBarButton_PTR_CppToPython_KMultiTabBarButton);

    Shiboken::Conversions::registerConverterName(converter, "KMultiTabBarButton");
    Shiboken::Conversions::registerConverterName(converter, "KMultiTabBarButton*");
    Shiboken::Conversions::registerConverterName(converter, "KMultiTabBarButton&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::KMultiTabBarButton).name());
    Shiboken::Conversions::registerConverterName(converter, typeid(KMultiTabBarButtonWrapper).name());

    MultipleInheritanceInitFunction func = Shiboken::ObjectType::getMultipleInheritanceFunction(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX]));
    Shiboken::ObjectType::setMultipleInheritanceFunction(Sbk_KMultiTabBarButton_TypeF(), func);
    Shiboken::ObjectType::setCastFunction(Sbk_KMultiTabBarButton_TypeF(), &Sbk_KMultiTabBarButtonSpecialCastFunction);
    Shiboken::ObjectType::setTypeDiscoveryFunctionV2(
        Sbk_KMultiTabBarButton_TypeF(), &Sbk_KMultiTabBarButton_typeDiscovery);

    PySide::Signal::registerSignals(pyType, &::KMultiTabBarButton::staticMetaObject);
    Shiboken::ObjectType::setSubTypeInitHook(pyType, &PySide::initQObjectSubType);
    PySide::initDynamicMetaObject(pyType, &::KMultiTabBarButton::staticMetaObject, sizeof(KMultiTabBarButtonWrapper));

    return pyType;
}
