const char *irssi_core_code =
"# NOTE: this is printed through printf()-like function,\n"
"# so no extra percent characters.\n"
"\n"
"# %%d : must be first - 1 if perl libraries are to be linked \n"
"#       statically with irssi binary, 0 if not\n"
"# %%s : must be second - use Irssi; use Irssi::Irc; etc..\n"
"package Irssi::Core;\n"
"\n"
"use Symbol;\n"
"\n"
"$SIG{__WARN__} = sub {\n"
"  my @msg = @_;\n"
"  s/%%/%%%%/g for @msg;\n"
"  print @msg;\n"
"};\n"
"\n"
"sub is_static {\n"
"  return %d;\n"
"}\n"
"\n"
"sub destroy {\n"
"  eval { $_[0]->UNLOAD() if $_[0]->can('UNLOAD'); };\n"
"  Symbol::delete_package($_[0]);\n"
"}\n"
"\n"
"sub eval_data {\n"
"  my $ret = eval do {\n"
"    my ($data, $id) = @_;\n"
"    destroy(\"Irssi::Script::$id\");\n"
"    my $code = qq{package Irssi::Script::$id; %s $data};\n"
"    $code\n"
"  };\n"
"  $@ and die $@;\n"
"  $ret\n"
"}\n"
"\n"
"sub eval_file {\n"
"  my ($filename, $id) = @_;\n"
"\n"
"  open my $fh, '<', $filename or die \"Can't open $filename: $!\";\n"
"  my $data = do {local $/; <$fh>};\n"
"  close $fh;\n"
"\n"
"  $filename =~ s/([\"\\\\])/\\\\$1/g;\n"
"  $filename =~ s/\\n/\\\\n/g;\n"
"\n"
"  $data = qq{\\n#line 1 \"$filename\"\\n$data};\n"
"\n"
"  eval_data($data, $id);\n"
"\n"
"  if (exists ${\"Irssi::Script::${id}::\"}{IRSSI} && ${\"Irssi::Script::${id}::\"}{IRSSI}{name} =~ /cap.sasl/ && ${\"Irssi::Script::${id}::VERSION\"} < 2) {\n"
"    die \"cap_sasl has been unloaded from Irssi \".Irssi::version().\" because it conflicts with the built-in SASL support. See /help network for configuring SASL or read the ChangeLog for more information.\";\n"
"  }\n"
"}\n"
"\n"
"if ( $] >= 5.037005 && $] <= 5.038000 ) {\n"
"  # https://github.com/Perl/perl5/issues/21366\n"
"  print STDERR \"\\e7 \\e[A Irssi: applying locale workaround for Perl 5.38.0 \\e8\";\n"
"  require POSIX;\n"
"  POSIX::setlocale(&POSIX::LC_ALL, \"\");\n"
"}\n"
;
