/* Utils.c generated by valac 0.56.17, the Vala compiler
 * generated from Utils.vala, do not modify */

/*
 * Copyright 2012–2021 elementary, Inc. (https://elementary.io)
 * SPDX-License-Identifier: LGPL-3.0-or-later
 */

#include "granite.h"
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gdk/gdk.h>
#include <gtk/gtk.h>
#include <glib/gi18n-lib.h>
#include <float.h>
#include <math.h>
#include <gio/gio.h>

#define GRANITE_WIDGETS_UTILS_WM_SETTINGS_PATH "org.gnome.desktop.wm.preferences"
#define GRANITE_WIDGETS_UTILS_PANTHEON_SETTINGS_PATH "org.pantheon.desktop.gala.appearance"
#define GRANITE_WIDGETS_UTILS_WM_BUTTON_LAYOUT_KEY "button-layout"
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_settings_schema_unref0(var) ((var == NULL) ? NULL : (var = (g_settings_schema_unref (var), NULL)))
#define _g_settings_schema_source_unref0(var) ((var == NULL) ? NULL : (var = (g_settings_schema_source_unref (var), NULL)))
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

 G_GNUC_INTERNAL void granite_init (void);
static void _vala_array_add4 (gchar** * array,
                       gint* length,
                       gint* size,
                       gchar* value);
static void _vala_array_add5 (gchar** * array,
                       gint* length,
                       gint* size,
                       gchar* value);
static void _vala_array_add6 (gchar** * array,
                       gint* length,
                       gint* size,
                       gchar* value);
static void _vala_array_add7 (gchar** * array,
                       gint* length,
                       gint* size,
                       gchar* value);
static void _vala_array_add8 (gchar** * array,
                       gint* length,
                       gint* size,
                       gchar* value);
static void _vala_array_add9 (gchar** * array,
                       gint* length,
                       gint* size,
                       gchar* value);
static void _vala_array_add10 (gchar** * array,
                        gint* length,
                        gint* size,
                        gchar* value);
static void _vala_array_add11 (gchar** * array,
                        gint* length,
                        gint* size,
                        gchar* value);
static void _vala_array_add12 (gchar** * array,
                        gint* length,
                        gint* size,
                        gchar* value);
static void _vala_array_add13 (gchar** * array,
                        gint* length,
                        gint* size,
                        gchar* value);
static void _vala_array_add14 (gchar** * array,
                        gint* length,
                        gint* size,
                        gchar* value);
static void _vala_array_add15 (gchar** * array,
                        gint* length,
                        gint* size,
                        gchar* value);
static void _vala_array_add16 (gchar** * array,
                        gint* length,
                        gint* size,
                        gchar* value);
static void _vala_array_add17 (gchar** * array,
                        gint* length,
                        gint* size,
                        gchar* value);
static void _vala_array_add18 (gchar** * array,
                        gint* length,
                        gint* size,
                        gchar* value);
static void _vala_array_add19 (gchar** * array,
                        gint* length,
                        gint* size,
                        gchar* value);
static void _vala_array_add20 (gchar** * array,
                        gint* length,
                        gint* size,
                        gchar* value);
static void _vala_array_add21 (gchar** * array,
                        gint* length,
                        gint* size,
                        gchar* value);
static void _vala_array_add22 (gchar** * array,
                        gint* length,
                        gint* size,
                        gchar* value);
static void _vala_array_add23 (gchar** * array,
                        gint* length,
                        gint* size,
                        gchar* value);
static void _vala_array_add24 (gchar** * array,
                        gint* length,
                        gint* size,
                        gchar* value);
static gboolean _vala_string_array_contains (gchar* * stack,
                                      gssize stack_length,
                                      const gchar* needle);
static void _vala_array_add25 (gchar** * array,
                        gint* length,
                        gint* size,
                        gchar* value);
static void _vala_array_add26 (gchar** * array,
                        gint* length,
                        gint* size,
                        gchar* value);
 G_GNUC_INTERNAL gdouble granite_contrast_ratio (GdkRGBA* bg_color,
                                GdkRGBA* fg_color);
 G_GNUC_INTERNAL gdouble granite_get_luminance (GdkRGBA* color);
 G_GNUC_INTERNAL gdouble granite_sanitize_color (gdouble color);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

/**
     * Converts this to a CSS style string that could be used with e.g: {@link Granite.Widgets.Utils.set_theming}.
     *
     * @param style_class the style class used for this
     *
     * @return CSS of text style
     */
static const gchar*
string_to_string (const gchar* self)
{
	const gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self;
	return result;
}

gchar*
granite_text_style_get_stylesheet (GraniteTextStyle self,
                                   gchar** style_class)
{
	gchar* _vala_style_class = NULL;
	gchar* result;
	switch (self) {
		case GRANITE_TEXT_STYLE_TITLE:
		{
			gchar* _tmp0_;
			const gchar* _tmp1_;
			const gchar* _tmp2_;
			gchar* _tmp3_;
			_tmp0_ = g_strdup (GRANITE_STYLE_CLASS_TITLE_TEXT);
			_g_free0 (_vala_style_class);
			_vala_style_class = _tmp0_;
			_tmp1_ = _vala_style_class;
			_tmp2_ = string_to_string (_tmp1_);
			_tmp3_ = g_strconcat (".", _tmp2_, " { font: raleway 36; }", NULL);
			result = _tmp3_;
			if (style_class) {
				*style_class = _vala_style_class;
			} else {
				_g_free0 (_vala_style_class);
			}
			return result;
		}
		case GRANITE_TEXT_STYLE_H1:
		{
			gchar* _tmp4_;
			const gchar* _tmp5_;
			const gchar* _tmp6_;
			gchar* _tmp7_;
			_tmp4_ = g_strdup (GRANITE_STYLE_CLASS_H1_TEXT);
			_g_free0 (_vala_style_class);
			_vala_style_class = _tmp4_;
			_tmp5_ = _vala_style_class;
			_tmp6_ = string_to_string (_tmp5_);
			_tmp7_ = g_strconcat (".", _tmp6_, " { font: open sans bold 24; }", NULL);
			result = _tmp7_;
			if (style_class) {
				*style_class = _vala_style_class;
			} else {
				_g_free0 (_vala_style_class);
			}
			return result;
		}
		case GRANITE_TEXT_STYLE_H2:
		{
			gchar* _tmp8_;
			const gchar* _tmp9_;
			const gchar* _tmp10_;
			gchar* _tmp11_;
			_tmp8_ = g_strdup (GRANITE_STYLE_CLASS_H2_TEXT);
			_g_free0 (_vala_style_class);
			_vala_style_class = _tmp8_;
			_tmp9_ = _vala_style_class;
			_tmp10_ = string_to_string (_tmp9_);
			_tmp11_ = g_strconcat (".", _tmp10_, " { font: open sans light 18; }", NULL);
			result = _tmp11_;
			if (style_class) {
				*style_class = _vala_style_class;
			} else {
				_g_free0 (_vala_style_class);
			}
			return result;
		}
		case GRANITE_TEXT_STYLE_H3:
		{
			gchar* _tmp12_;
			const gchar* _tmp13_;
			const gchar* _tmp14_;
			gchar* _tmp15_;
			_tmp12_ = g_strdup (GRANITE_STYLE_CLASS_H3_TEXT);
			_g_free0 (_vala_style_class);
			_vala_style_class = _tmp12_;
			_tmp13_ = _vala_style_class;
			_tmp14_ = string_to_string (_tmp13_);
			_tmp15_ = g_strconcat (".", _tmp14_, " { font: open sans bold 12; }", NULL);
			result = _tmp15_;
			if (style_class) {
				*style_class = _vala_style_class;
			} else {
				_g_free0 (_vala_style_class);
			}
			return result;
		}
		default:
		{
			g_assert_not_reached ();
		}
	}
}

static GType
granite_text_style_get_type_once (void)
{
	static const GEnumValue values[] = {{GRANITE_TEXT_STYLE_TITLE, "GRANITE_TEXT_STYLE_TITLE", "title"}, {GRANITE_TEXT_STYLE_H1, "GRANITE_TEXT_STYLE_H1", "h1"}, {GRANITE_TEXT_STYLE_H2, "GRANITE_TEXT_STYLE_H2", "h2"}, {GRANITE_TEXT_STYLE_H3, "GRANITE_TEXT_STYLE_H3", "h3"}, {0, NULL, NULL}};
	GType granite_text_style_type_id;
	granite_text_style_type_id = g_enum_register_static ("GraniteTextStyle", values);
	return granite_text_style_type_id;
}

GType
granite_text_style_get_type (void)
{
	static volatile gsize granite_text_style_type_id__once = 0;
	if (g_once_init_enter (&granite_text_style_type_id__once)) {
		GType granite_text_style_type_id;
		granite_text_style_type_id = granite_text_style_get_type_once ();
		g_once_init_leave (&granite_text_style_type_id__once, granite_text_style_type_id);
	}
	return granite_text_style_type_id__once;
}

/**
 * An enum used to derermine where the window manager currently displays its close button on windows.
 * Used with {@link Granite.Widgets.Utils.get_default_close_button_position}.
 */
static GType
granite_close_button_position_get_type_once (void)
{
	static const GEnumValue values[] = {{GRANITE_CLOSE_BUTTON_POSITION_LEFT, "GRANITE_CLOSE_BUTTON_POSITION_LEFT", "left"}, {GRANITE_CLOSE_BUTTON_POSITION_RIGHT, "GRANITE_CLOSE_BUTTON_POSITION_RIGHT", "right"}, {0, NULL, NULL}};
	GType granite_close_button_position_type_id;
	granite_close_button_position_type_id = g_enum_register_static ("GraniteCloseButtonPosition", values);
	return granite_close_button_position_type_id;
}

GType
granite_close_button_position_get_type (void)
{
	static volatile gsize granite_close_button_position_type_id__once = 0;
	if (g_once_init_enter (&granite_close_button_position_type_id__once)) {
		GType granite_close_button_position_type_id;
		granite_close_button_position_type_id = granite_close_button_position_get_type_once ();
		g_once_init_leave (&granite_close_button_position_type_id__once, granite_close_button_position_type_id);
	}
	return granite_close_button_position_type_id__once;
}

/**
 * Converts a {@link Gtk.accelerator_parse} style accel string to a human-readable string.
 *
 * @param accel an accelerator label like “<Control>a” or “<Super>Right”
 *
 * @return a human-readable string like "Ctrl + A" or "⌘ + →"
 */
static void
_vala_array_add4 (gchar** * array,
                  gint* length,
                  gint* size,
                  gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
_vala_array_add5 (gchar** * array,
                  gint* length,
                  gint* size,
                  gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
_vala_array_add6 (gchar** * array,
                  gint* length,
                  gint* size,
                  gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
_vala_array_add7 (gchar** * array,
                  gint* length,
                  gint* size,
                  gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
_vala_array_add8 (gchar** * array,
                  gint* length,
                  gint* size,
                  gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
_vala_array_add9 (gchar** * array,
                  gint* length,
                  gint* size,
                  gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
_vala_array_add10 (gchar** * array,
                   gint* length,
                   gint* size,
                   gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
_vala_array_add11 (gchar** * array,
                   gint* length,
                   gint* size,
                   gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
_vala_array_add12 (gchar** * array,
                   gint* length,
                   gint* size,
                   gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
_vala_array_add13 (gchar** * array,
                   gint* length,
                   gint* size,
                   gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
_vala_array_add14 (gchar** * array,
                   gint* length,
                   gint* size,
                   gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
_vala_array_add15 (gchar** * array,
                   gint* length,
                   gint* size,
                   gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
_vala_array_add16 (gchar** * array,
                   gint* length,
                   gint* size,
                   gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
_vala_array_add17 (gchar** * array,
                   gint* length,
                   gint* size,
                   gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
_vala_array_add18 (gchar** * array,
                   gint* length,
                   gint* size,
                   gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
_vala_array_add19 (gchar** * array,
                   gint* length,
                   gint* size,
                   gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
_vala_array_add20 (gchar** * array,
                   gint* length,
                   gint* size,
                   gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
_vala_array_add21 (gchar** * array,
                   gint* length,
                   gint* size,
                   gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
_vala_array_add22 (gchar** * array,
                   gint* length,
                   gint* size,
                   gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
_vala_array_add23 (gchar** * array,
                   gint* length,
                   gint* size,
                   gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static gchar*
_vala_g_strjoinv (const gchar* separator,
                  gchar** str_array,
                  gint str_array_length1)
{
	gboolean _tmp0_ = FALSE;
	gchar* result;
	if (separator == NULL) {
		separator = "";
	}
	if (str_array != NULL) {
		gboolean _tmp1_ = FALSE;
		if (str_array_length1 > 0) {
			_tmp1_ = TRUE;
		} else {
			gboolean _tmp2_ = FALSE;
			if (str_array_length1 == -1) {
				const gchar* _tmp3_;
				_tmp3_ = str_array[0];
				_tmp2_ = _tmp3_ != NULL;
			} else {
				_tmp2_ = FALSE;
			}
			_tmp1_ = _tmp2_;
		}
		_tmp0_ = _tmp1_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		gint i = 0;
		gsize len = 0UL;
		gint _tmp16_;
		gint _tmp17_;
		const gchar* res = NULL;
		void* _tmp18_;
		const gchar* _tmp19_ = NULL;
		const gchar* _tmp20_;
		void* ptr = NULL;
		const gchar* _tmp22_;
		void* _tmp23_;
		const gchar* _tmp33_;
		len = (gsize) 1;
		{
			gboolean _tmp4_ = FALSE;
			i = 0;
			_tmp4_ = TRUE;
			while (TRUE) {
				gboolean _tmp6_ = FALSE;
				gboolean _tmp7_ = FALSE;
				gint _tmp10_ = 0;
				const gchar* _tmp11_;
				if (!_tmp4_) {
					gint _tmp5_;
					_tmp5_ = i;
					i = _tmp5_ + 1;
				}
				_tmp4_ = FALSE;
				if (str_array_length1 != -1) {
					_tmp7_ = i < str_array_length1;
				} else {
					_tmp7_ = FALSE;
				}
				if (_tmp7_) {
					_tmp6_ = TRUE;
				} else {
					gboolean _tmp8_ = FALSE;
					if (str_array_length1 == -1) {
						const gchar* _tmp9_;
						_tmp9_ = str_array[i];
						_tmp8_ = _tmp9_ != NULL;
					} else {
						_tmp8_ = FALSE;
					}
					_tmp6_ = _tmp8_;
				}
				if (!_tmp6_) {
					break;
				}
				_tmp11_ = str_array[i];
				if (_tmp11_ != NULL) {
					const gchar* _tmp12_;
					gint _tmp13_;
					gint _tmp14_;
					_tmp12_ = str_array[i];
					_tmp13_ = strlen ((const gchar*) _tmp12_);
					_tmp14_ = _tmp13_;
					_tmp10_ = _tmp14_;
				} else {
					_tmp10_ = 0;
				}
				len += (gsize) _tmp10_;
			}
		}
		if (i == 0) {
			gchar* _tmp15_;
			_tmp15_ = g_strdup ("");
			result = _tmp15_;
			return result;
		}
		str_array_length1 = i;
		_tmp16_ = strlen ((const gchar*) separator);
		_tmp17_ = _tmp16_;
		len += (gsize) (_tmp17_ * (i - 1));
		_tmp18_ = g_malloc (len);
		res = _tmp18_;
		_tmp20_ = str_array[0];
		if (_tmp20_ != NULL) {
			const gchar* _tmp21_;
			_tmp21_ = str_array[0];
			_tmp19_ = (const gchar*) _tmp21_;
		} else {
			_tmp19_ = "";
		}
		_tmp22_ = res;
		_tmp23_ = g_stpcpy ((void*) _tmp22_, _tmp19_);
		ptr = _tmp23_;
		{
			gboolean _tmp24_ = FALSE;
			i = 1;
			_tmp24_ = TRUE;
			while (TRUE) {
				void* _tmp26_;
				void* _tmp27_;
				const gchar* _tmp28_ = NULL;
				const gchar* _tmp29_;
				void* _tmp31_;
				void* _tmp32_;
				if (!_tmp24_) {
					gint _tmp25_;
					_tmp25_ = i;
					i = _tmp25_ + 1;
				}
				_tmp24_ = FALSE;
				if (!(i < str_array_length1)) {
					break;
				}
				_tmp26_ = ptr;
				_tmp27_ = g_stpcpy (_tmp26_, (const gchar*) separator);
				ptr = _tmp27_;
				_tmp29_ = str_array[i];
				if (_tmp29_ != NULL) {
					const gchar* _tmp30_;
					_tmp30_ = str_array[i];
					_tmp28_ = (const gchar*) _tmp30_;
				} else {
					_tmp28_ = "";
				}
				_tmp31_ = ptr;
				_tmp32_ = g_stpcpy (_tmp31_, _tmp28_);
				ptr = _tmp32_;
			}
		}
		_tmp33_ = res;
		res = NULL;
		result = (gchar*) _tmp33_;
		return result;
	} else {
		gchar* _tmp34_;
		_tmp34_ = g_strdup ("");
		result = _tmp34_;
		return result;
	}
}

gchar*
granite_accel_to_string (const gchar* accel)
{
	guint accel_key = 0U;
	GdkModifierType accel_mods = 0U;
	guint _tmp1_ = 0U;
	GdkModifierType _tmp2_ = 0U;
	gchar** arr = NULL;
	gchar** _tmp3_;
	gint arr_length1;
	gint _arr_size_;
	gchar** _tmp29_;
	gint _tmp29__length1;
	const gchar* _tmp30_;
	gchar* _tmp31_;
	gchar* result;
	if (accel == NULL) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup ("");
		result = _tmp0_;
		return result;
	}
	granite_init ();
	gtk_accelerator_parse (accel, &_tmp1_, &_tmp2_);
	accel_key = _tmp1_;
	accel_mods = _tmp2_;
	_tmp3_ = g_new0 (gchar*, 0 + 1);
	arr = _tmp3_;
	arr_length1 = 0;
	_arr_size_ = arr_length1;
	if ((accel_mods & GDK_SUPER_MASK) == GDK_SUPER_MASK) {
		gchar* _tmp4_;
		_tmp4_ = g_strdup ("⌘");
		_vala_array_add4 (&arr, &arr_length1, &_arr_size_, _tmp4_);
	}
	if ((accel_mods & GDK_SHIFT_MASK) == GDK_SHIFT_MASK) {
		gchar* _tmp5_;
		_tmp5_ = g_strdup (_ ("Shift"));
		_vala_array_add5 (&arr, &arr_length1, &_arr_size_, _tmp5_);
	}
	if ((accel_mods & GDK_CONTROL_MASK) == GDK_CONTROL_MASK) {
		gchar* _tmp6_;
		_tmp6_ = g_strdup (_ ("Ctrl"));
		_vala_array_add6 (&arr, &arr_length1, &_arr_size_, _tmp6_);
	}
	if ((accel_mods & GDK_MOD1_MASK) == GDK_MOD1_MASK) {
		gchar* _tmp7_;
		_tmp7_ = g_strdup (_ ("Alt"));
		_vala_array_add7 (&arr, &arr_length1, &_arr_size_, _tmp7_);
	}
	switch (accel_key) {
		case GDK_KEY_Up:
		{
			gchar* _tmp8_;
			_tmp8_ = g_strdup ("↑");
			_vala_array_add8 (&arr, &arr_length1, &_arr_size_, _tmp8_);
			break;
		}
		case GDK_KEY_Down:
		{
			gchar* _tmp9_;
			_tmp9_ = g_strdup ("↓");
			_vala_array_add9 (&arr, &arr_length1, &_arr_size_, _tmp9_);
			break;
		}
		case GDK_KEY_Left:
		{
			gchar* _tmp10_;
			_tmp10_ = g_strdup ("←");
			_vala_array_add10 (&arr, &arr_length1, &_arr_size_, _tmp10_);
			break;
		}
		case GDK_KEY_Right:
		{
			gchar* _tmp11_;
			_tmp11_ = g_strdup ("→");
			_vala_array_add11 (&arr, &arr_length1, &_arr_size_, _tmp11_);
			break;
		}
		case GDK_KEY_Alt_L:
		{
			gchar* _tmp12_;
			_tmp12_ = g_strdup (_ ("Left Alt"));
			_vala_array_add12 (&arr, &arr_length1, &_arr_size_, _tmp12_);
			break;
		}
		case GDK_KEY_Alt_R:
		{
			gchar* _tmp13_;
			_tmp13_ = g_strdup (_ ("Right Alt"));
			_vala_array_add13 (&arr, &arr_length1, &_arr_size_, _tmp13_);
			break;
		}
		case GDK_KEY_backslash:
		{
			gchar* _tmp14_;
			_tmp14_ = g_strdup ("\\");
			_vala_array_add14 (&arr, &arr_length1, &_arr_size_, _tmp14_);
			break;
		}
		case GDK_KEY_Control_R:
		{
			gchar* _tmp15_;
			_tmp15_ = g_strdup (_ ("Right Ctrl"));
			_vala_array_add15 (&arr, &arr_length1, &_arr_size_, _tmp15_);
			break;
		}
		case GDK_KEY_Control_L:
		{
			gchar* _tmp16_;
			_tmp16_ = g_strdup (_ ("Left Ctrl"));
			_vala_array_add16 (&arr, &arr_length1, &_arr_size_, _tmp16_);
			break;
		}
		case GDK_KEY_minus:
		case GDK_KEY_KP_Subtract:
		{
			gchar* _tmp17_;
			_tmp17_ = g_strdup (_ ("Minus"));
			_vala_array_add17 (&arr, &arr_length1, &_arr_size_, _tmp17_);
			break;
		}
		case GDK_KEY_KP_Add:
		case GDK_KEY_plus:
		{
			gchar* _tmp18_;
			_tmp18_ = g_strdup (_ ("Plus"));
			_vala_array_add18 (&arr, &arr_length1, &_arr_size_, _tmp18_);
			break;
		}
		case GDK_KEY_KP_Equal:
		case GDK_KEY_equal:
		{
			gchar* _tmp19_;
			_tmp19_ = g_strdup (_ ("Equals"));
			_vala_array_add19 (&arr, &arr_length1, &_arr_size_, _tmp19_);
			break;
		}
		case GDK_KEY_Return:
		{
			gchar* _tmp20_;
			_tmp20_ = g_strdup (_ ("Enter"));
			_vala_array_add20 (&arr, &arr_length1, &_arr_size_, _tmp20_);
			break;
		}
		case GDK_KEY_Shift_L:
		{
			gchar* _tmp21_;
			_tmp21_ = g_strdup (_ ("Left Shift"));
			_vala_array_add21 (&arr, &arr_length1, &_arr_size_, _tmp21_);
			break;
		}
		case GDK_KEY_Shift_R:
		{
			gchar* _tmp22_;
			_tmp22_ = g_strdup (_ ("Right Shift"));
			_vala_array_add22 (&arr, &arr_length1, &_arr_size_, _tmp22_);
			break;
		}
		default:
		{
			gchar* accel_label = NULL;
			gchar* _tmp23_;
			const gchar* _tmp24_;
			_tmp23_ = gtk_accelerator_get_label (accel_key, 0);
			accel_label = _tmp23_;
			_tmp24_ = accel_label;
			if (g_strcmp0 (_tmp24_, "") != 0) {
				const gchar* _tmp25_;
				gchar* _tmp26_;
				_tmp25_ = accel_label;
				_tmp26_ = g_strdup (_tmp25_);
				_vala_array_add23 (&arr, &arr_length1, &_arr_size_, _tmp26_);
			}
			_g_free0 (accel_label);
			break;
		}
	}
	if (accel_mods != 0) {
		gchar** _tmp27_;
		gint _tmp27__length1;
		gchar* _tmp28_;
		_tmp27_ = arr;
		_tmp27__length1 = arr_length1;
		_tmp28_ = _vala_g_strjoinv (" + ", _tmp27_, (gint) _tmp27__length1);
		result = _tmp28_;
		arr = (_vala_array_free (arr, arr_length1, (GDestroyNotify) g_free), NULL);
		return result;
	}
	_tmp29_ = arr;
	_tmp29__length1 = arr_length1;
	_tmp30_ = _tmp29_[0];
	_tmp31_ = g_strdup (_tmp30_);
	result = _tmp31_;
	arr = (_vala_array_free (arr, arr_length1, (GDestroyNotify) g_free), NULL);
	return result;
}

/**
 * Takes a description and an array of accels and returns {@link Pango} markup for use in a {@link Gtk.Tooltip}. This method uses {@link Granite.accel_to_string}.
 *
 * Example:
 *
 * Description
 * Shortcut 1, Shortcut 2
 *
 * @param a string array of accelerator labels like {"<Control>a", "<Super>Right"}
 *
 * @param description a standard tooltip text string
 *
 * @return {@link Pango} markup with the description label on one line and a list of human-readable accels on a new line
 */
static void
_vala_array_add24 (gchar** * array,
                   gint* length,
                   gint* size,
                   gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static gboolean
_vala_string_array_contains (gchar* * stack,
                             gssize stack_length,
                             const gchar* needle)
{
	gssize i;
	for (i = 0; i < stack_length; i++) {
		if (g_strcmp0 (stack[i], needle) == 0) {
			return TRUE;
		}
	}
	return FALSE;
}

static void
_vala_array_add25 (gchar** * array,
                   gint* length,
                   gint* size,
                   gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
_vala_array_add26 (gchar** * array,
                   gint* length,
                   gint* size,
                   gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

gchar*
granite_markup_accel_tooltip (gchar** accels,
                              gint accels_length1,
                              const gchar* description)
{
	gchar** parts = NULL;
	gchar** _tmp0_;
	gint parts_length1;
	gint _parts_size_;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp3_ = FALSE;
	gchar** _tmp21_;
	gint _tmp21__length1;
	gchar* _tmp22_;
	gchar* result;
	_tmp0_ = g_new0 (gchar*, 0 + 1);
	parts = _tmp0_;
	parts_length1 = 0;
	_parts_size_ = parts_length1;
	if (description != NULL) {
		_tmp1_ = g_strcmp0 (description, "") != 0;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup (description);
		_vala_array_add24 (&parts, &parts_length1, &_parts_size_, _tmp2_);
	}
	if (accels != NULL) {
		_tmp3_ = accels_length1 > 0;
	} else {
		_tmp3_ = FALSE;
	}
	if (_tmp3_) {
		gchar** unique_accels = NULL;
		gchar** _tmp4_;
		gint unique_accels_length1;
		gint _unique_accels_size_;
		gchar** _tmp14_;
		gint _tmp14__length1;
		_tmp4_ = g_new0 (gchar*, 0 + 1);
		unique_accels = _tmp4_;
		unique_accels_length1 = 0;
		_unique_accels_size_ = unique_accels_length1;
		granite_init ();
		{
			gint i = 0;
			i = 0;
			{
				gboolean _tmp5_ = FALSE;
				_tmp5_ = TRUE;
				while (TRUE) {
					const gchar* _tmp7_;
					gchar* accel_string = NULL;
					const gchar* _tmp8_;
					gchar* _tmp9_;
					const gchar* _tmp10_;
					gchar** _tmp11_;
					gint _tmp11__length1;
					if (!_tmp5_) {
						gint _tmp6_;
						_tmp6_ = i;
						i = _tmp6_ + 1;
					}
					_tmp5_ = FALSE;
					if (!(i < accels_length1)) {
						break;
					}
					_tmp7_ = accels[i];
					if (g_strcmp0 (_tmp7_, "") == 0) {
						continue;
					}
					_tmp8_ = accels[i];
					_tmp9_ = granite_accel_to_string (_tmp8_);
					accel_string = _tmp9_;
					_tmp10_ = accel_string;
					_tmp11_ = unique_accels;
					_tmp11__length1 = unique_accels_length1;
					if (!_vala_string_array_contains (_tmp11_, _tmp11__length1, _tmp10_)) {
						const gchar* _tmp12_;
						gchar* _tmp13_;
						_tmp12_ = accel_string;
						_tmp13_ = g_strdup (_tmp12_);
						_vala_array_add25 (&unique_accels, &unique_accels_length1, &_unique_accels_size_, _tmp13_);
					}
					_g_free0 (accel_string);
				}
			}
		}
		_tmp14_ = unique_accels;
		_tmp14__length1 = unique_accels_length1;
		if (_tmp14__length1 > 0) {
			gchar* accel_label = NULL;
			gchar** _tmp15_;
			gint _tmp15__length1;
			gchar* _tmp16_;
			gchar* accel_markup = NULL;
			const gchar* _tmp17_;
			gchar* _tmp18_;
			const gchar* _tmp19_;
			gchar* _tmp20_;
			_tmp15_ = unique_accels;
			_tmp15__length1 = unique_accels_length1;
			_tmp16_ = _vala_g_strjoinv (_ (", "), _tmp15_, (gint) _tmp15__length1);
			accel_label = _tmp16_;
			_tmp17_ = accel_label;
			_tmp18_ = g_strdup_printf (GRANITE_TOOLTIP_SECONDARY_TEXT_MARKUP, _tmp17_);
			accel_markup = _tmp18_;
			_tmp19_ = accel_markup;
			_tmp20_ = g_strdup (_tmp19_);
			_vala_array_add26 (&parts, &parts_length1, &_parts_size_, _tmp20_);
			_g_free0 (accel_markup);
			_g_free0 (accel_label);
		}
		unique_accels = (_vala_array_free (unique_accels, unique_accels_length1, (GDestroyNotify) g_free), NULL);
	}
	_tmp21_ = parts;
	_tmp21__length1 = parts_length1;
	_tmp22_ = _vala_g_strjoinv ("\n", _tmp21_, (gint) _tmp21__length1);
	result = _tmp22_;
	parts = (_vala_array_free (parts, parts_length1, (GDestroyNotify) g_free), NULL);
	return result;
}

 G_GNUC_INTERNAL gdouble
granite_contrast_ratio (GdkRGBA* bg_color,
                        GdkRGBA* fg_color)
{
	gdouble bg_luminance = 0.0;
	GdkRGBA _tmp0_;
	gdouble fg_luminance = 0.0;
	GdkRGBA _tmp1_;
	gdouble result;
	g_return_val_if_fail (bg_color != NULL, 0.0);
	g_return_val_if_fail (fg_color != NULL, 0.0);
	_tmp0_ = *bg_color;
	bg_luminance = granite_get_luminance (&_tmp0_);
	_tmp1_ = *fg_color;
	fg_luminance = granite_get_luminance (&_tmp1_);
	if (bg_luminance > fg_luminance) {
		result = (bg_luminance + 0.05) / (fg_luminance + 0.05);
		return result;
	}
	result = (fg_luminance + 0.05) / (bg_luminance + 0.05);
	return result;
}

 G_GNUC_INTERNAL gdouble
granite_get_luminance (GdkRGBA* color)
{
	gdouble red = 0.0;
	GdkRGBA _tmp0_;
	gdouble green = 0.0;
	GdkRGBA _tmp1_;
	gdouble blue = 0.0;
	GdkRGBA _tmp2_;
	gdouble result;
	g_return_val_if_fail (color != NULL, 0.0);
	_tmp0_ = *color;
	red = granite_sanitize_color (_tmp0_.red) * 0.2126;
	_tmp1_ = *color;
	green = granite_sanitize_color (_tmp1_.green) * 0.7152;
	_tmp2_ = *color;
	blue = granite_sanitize_color (_tmp2_.blue) * 0.0722;
	result = (red + green) + blue;
	return result;
}

 G_GNUC_INTERNAL gdouble
granite_sanitize_color (gdouble color)
{
	gdouble result;
	if (color <= 0.03928) {
		result = color / 12.92;
		return result;
	}
	result = pow ((color + 0.055) / 1.055, 2.4);
	return result;
}

/**
 * Takes a {@link Gdk.RGBA} background color and returns a suitably-contrasting foreground color, i.e. for determining text color on a colored background. There is a slight bias toward returning white, as white generally looks better on a wider range of colored backgrounds than black.
 *
 * @param bg_color any {@link Gdk.RGBA} background color
 *
 * @return a contrasting {@link Gdk.RGBA} foreground color, i.e. white ({ 1.0, 1.0, 1.0, 1.0}) or black ({ 0.0, 0.0, 0.0, 1.0}).
 */
void
granite_contrasting_foreground_color (GdkRGBA* bg_color,
                                      GdkRGBA* result)
{
	GdkRGBA gdk_white = {0};
	GdkRGBA _tmp0_ = {0};
	GdkRGBA gdk_black = {0};
	GdkRGBA _tmp1_ = {0};
	gdouble contrast_with_white = 0.0;
	GdkRGBA _tmp2_;
	GdkRGBA _tmp3_;
	gdouble contrast_with_black = 0.0;
	GdkRGBA _tmp4_;
	GdkRGBA _tmp5_;
	GdkRGBA fg_color = {0};
	GdkRGBA _tmp6_;
	g_return_if_fail (bg_color != NULL);
	_tmp0_.red = 1.0;
	_tmp0_.green = 1.0;
	_tmp0_.blue = 1.0;
	_tmp0_.alpha = 1.0;
	gdk_white = _tmp0_;
	_tmp1_.red = 0.0;
	_tmp1_.green = 0.0;
	_tmp1_.blue = 0.0;
	_tmp1_.alpha = 1.0;
	gdk_black = _tmp1_;
	_tmp2_ = *bg_color;
	_tmp3_ = gdk_white;
	contrast_with_white = granite_contrast_ratio (&_tmp2_, &_tmp3_);
	_tmp4_ = *bg_color;
	_tmp5_ = gdk_black;
	contrast_with_black = granite_contrast_ratio (&_tmp4_, &_tmp5_);
	_tmp6_ = gdk_white;
	fg_color = _tmp6_;
	if (contrast_with_black > (contrast_with_white + 3)) {
		GdkRGBA _tmp7_;
		_tmp7_ = gdk_black;
		fg_color = _tmp7_;
	}
	*result = fg_color;
	return;
}

/**
     * Applies colorPrimary property to the window. The colorPrimary property currently changes
     * the color of the {@link Gtk.HeaderBar} and it's children so that the application window
     * can have a so-called "brand color".
     *
     * Note that this currently only works with the default stylesheet that elementary OS uses.
     *
     * @param window the widget to apply the color, for most cases the widget will be actually the {@link Gtk.Window} itself
     * @param color the color to apply
     * @param priority priorty of change, by default {@link Gtk.STYLE_PROVIDER_PRIORITY_APPLICATION}
     *
     * @return the added {@link Gtk.CssProvider}, or null in case the parsing of
     *         stylesheet failed.
     */
GtkCssProvider*
granite_widgets_utils_set_color_primary (GtkWidget* window,
                                         GdkRGBA* color,
                                         gint priority)
{
	gchar* hex = NULL;
	gchar* _tmp0_;
	GdkScreen* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	GtkCssProvider* _tmp6_;
	GtkCssProvider* _tmp7_;
	GtkCssProvider* result;
	g_return_val_if_fail (window != NULL, NULL);
	g_return_val_if_fail (color != NULL, NULL);
	_vala_assert (window != NULL, "window != null");
	_tmp0_ = gdk_rgba_to_string (color);
	hex = _tmp0_;
	_tmp1_ = gtk_widget_get_screen (window);
	_tmp2_ = string_to_string (hex);
	_tmp3_ = string_to_string (hex);
	_tmp4_ = g_strconcat ("@define-color color_primary ", _tmp2_, ";@define-color colorPrimary ", _tmp3_, ";", NULL);
	_tmp5_ = _tmp4_;
	_tmp6_ = granite_widgets_utils_set_theming_for_screen (_tmp1_, _tmp5_, priority);
	_tmp7_ = _tmp6_;
	_g_free0 (_tmp5_);
	result = _tmp7_;
	_g_free0 (hex);
	return result;
}

/**
     * Applies the //stylesheet// to the widget.
     *
     * @param widget widget to apply style to
     * @param stylesheet CSS style to apply to the widget
     * @param class_name class name to add style to, pass null if no class should be applied to the //widget//
     * @param priority priorty of change, for most cases this will be {@link Gtk.STYLE_PROVIDER_PRIORITY_APPLICATION}
     *
     * @return the {@link Gtk.CssProvider} that was applied to the //widget//.
     */
static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static gchar*
string_strip (const gchar* self)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	g_strstrip (_result_);
	result = _result_;
	return result;
}

GtkCssProvider*
granite_widgets_utils_set_theming (GtkWidget* widget,
                                   const gchar* stylesheet,
                                   const gchar* class_name,
                                   gint priority)
{
	GtkCssProvider* css_provider = NULL;
	GtkCssProvider* _tmp0_;
	GtkStyleContext* context = NULL;
	GtkStyleContext* _tmp1_;
	GtkStyleContext* _tmp2_;
	GtkCssProvider* _tmp3_;
	gboolean _tmp6_ = FALSE;
	GtkCssProvider* result;
	g_return_val_if_fail (widget != NULL, NULL);
	g_return_val_if_fail (stylesheet != NULL, NULL);
	_tmp0_ = granite_widgets_utils_get_css_provider (stylesheet);
	css_provider = _tmp0_;
	_tmp1_ = gtk_widget_get_style_context (widget);
	_tmp2_ = _g_object_ref0 (_tmp1_);
	context = _tmp2_;
	_tmp3_ = css_provider;
	if (_tmp3_ != NULL) {
		GtkStyleContext* _tmp4_;
		GtkCssProvider* _tmp5_;
		_tmp4_ = context;
		_tmp5_ = css_provider;
		gtk_style_context_add_provider (_tmp4_, (GtkStyleProvider*) _tmp5_, (guint) priority);
	}
	if (class_name != NULL) {
		gchar* _tmp7_;
		gchar* _tmp8_;
		_tmp7_ = string_strip (class_name);
		_tmp8_ = _tmp7_;
		_tmp6_ = g_strcmp0 (_tmp8_, "") != 0;
		_g_free0 (_tmp8_);
	} else {
		_tmp6_ = FALSE;
	}
	if (_tmp6_) {
		GtkStyleContext* _tmp9_;
		_tmp9_ = context;
		gtk_style_context_add_class (_tmp9_, class_name);
	}
	result = css_provider;
	_g_object_unref0 (context);
	return result;
}

/**
     * Applies a stylesheet to the given //screen//. This will affect all the
     * widgets which are part of that screen.
     *
     * @param screen screen to apply style to, use {@link Gtk.Widget.get_screen} in order to get the screen that the widget is on
     * @param stylesheet CSS style to apply to screen
     * @param priority priorty of change, for most cases this will be {@link Gtk.STYLE_PROVIDER_PRIORITY_APPLICATION}
     *
     * @return the {@link Gtk.CssProvider} that was applied to the //screen//.
     */
GtkCssProvider*
granite_widgets_utils_set_theming_for_screen (GdkScreen* screen,
                                              const gchar* stylesheet,
                                              gint priority)
{
	GtkCssProvider* css_provider = NULL;
	GtkCssProvider* _tmp0_;
	GtkCssProvider* _tmp1_;
	GtkCssProvider* result;
	g_return_val_if_fail (screen != NULL, NULL);
	g_return_val_if_fail (stylesheet != NULL, NULL);
	_tmp0_ = granite_widgets_utils_get_css_provider (stylesheet);
	css_provider = _tmp0_;
	_tmp1_ = css_provider;
	if (_tmp1_ != NULL) {
		GtkCssProvider* _tmp2_;
		_tmp2_ = css_provider;
		gtk_style_context_add_provider_for_screen (screen, (GtkStyleProvider*) _tmp2_, (guint) priority);
	}
	result = css_provider;
	return result;
}

/**
     * Constructs a new {@link Gtk.CssProvider} that will store the //stylesheet// data.
     * This function uses {@link Gtk.CssProvider.load_from_data} internally so if this method fails
     * then a warning will be thrown and null returned as a result.
     *
     * @param stylesheet CSS style to apply to the returned provider
     *
     * @return a new {@link Gtk.CssProvider}, or null in case the parsing of
     *         //stylesheet// failed.
     */
GtkCssProvider*
granite_widgets_utils_get_css_provider (const gchar* stylesheet)
{
	GtkCssProvider* provider = NULL;
	GtkCssProvider* _tmp0_;
	GError* _inner_error0_ = NULL;
	GtkCssProvider* result;
	g_return_val_if_fail (stylesheet != NULL, NULL);
	_tmp0_ = gtk_css_provider_new ();
	provider = _tmp0_;
	{
		GtkCssProvider* _tmp1_;
		_tmp1_ = provider;
		gtk_css_provider_load_from_data (_tmp1_, stylesheet, (gssize) -1, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp2_;
		const gchar* _tmp3_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp2_ = e;
		_tmp3_ = _tmp2_->message;
		g_warning ("Utils.vala:389: Could not create CSS Provider: %s\nStylesheet:\n%s", _tmp3_, stylesheet);
		result = NULL;
		_g_error_free0 (e);
		_g_object_unref0 (provider);
		return result;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_object_unref0 (provider);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
	result = provider;
	return result;
}

/**
     * This method applies given text style to given label
     *
     * @param text_style text style to apply
     * @param label label to apply style to
     */
void
granite_widgets_utils_apply_text_style_to_label (GraniteTextStyle text_style,
                                                 GtkLabel* label)
{
	GtkCssProvider* style_provider = NULL;
	GtkCssProvider* _tmp0_;
	GtkStyleContext* style_context = NULL;
	GtkStyleContext* _tmp1_;
	GtkStyleContext* _tmp2_;
	gchar* style_class = NULL;
	gchar* stylesheet = NULL;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_;
	GtkStyleContext* _tmp5_;
	const gchar* _tmp6_;
	GtkStyleContext* _tmp11_;
	GtkCssProvider* _tmp12_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (label != NULL);
	_tmp0_ = gtk_css_provider_new ();
	style_provider = _tmp0_;
	_tmp1_ = gtk_widget_get_style_context ((GtkWidget*) label);
	_tmp2_ = _g_object_ref0 (_tmp1_);
	style_context = _tmp2_;
	_tmp4_ = granite_text_style_get_stylesheet (text_style, &_tmp3_);
	_g_free0 (style_class);
	style_class = _tmp3_;
	_g_free0 (stylesheet);
	stylesheet = _tmp4_;
	_tmp5_ = style_context;
	_tmp6_ = style_class;
	gtk_style_context_add_class (_tmp5_, _tmp6_);
	{
		GtkCssProvider* _tmp7_;
		const gchar* _tmp8_;
		_tmp7_ = style_provider;
		_tmp8_ = stylesheet;
		gtk_css_provider_load_from_data (_tmp7_, _tmp8_, (gssize) -1, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* err = NULL;
		GError* _tmp9_;
		const gchar* _tmp10_;
		err = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp9_ = err;
		_tmp10_ = _tmp9_->message;
		g_warning ("Utils.vala:415: Couldn't apply style to label: %s", _tmp10_);
		_g_error_free0 (err);
		_g_free0 (stylesheet);
		_g_free0 (style_class);
		_g_object_unref0 (style_context);
		_g_object_unref0 (style_provider);
		return;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_free0 (stylesheet);
		_g_free0 (style_class);
		_g_object_unref0 (style_context);
		_g_object_unref0 (style_provider);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_tmp11_ = style_context;
	_tmp12_ = style_provider;
	gtk_style_context_add_provider (_tmp11_, (GtkStyleProvider*) _tmp12_, (guint) GTK_STYLE_PROVIDER_PRIORITY_APPLICATION);
	_g_free0 (stylesheet);
	_g_free0 (style_class);
	_g_object_unref0 (style_context);
	_g_object_unref0 (style_provider);
}

/**
     * This method detects the close button position as configured for the window manager. If you
     * need to know when this key changed, it's best to listen on the schema returned by
     * {@link Granite.Widgets.Utils.get_button_layout_schema} for changes and then call this method again.
     *
     * @param position a {@link Granite.CloseButtonPosition} indicating where to best put the close button
     * @return if no schema was detected by {@link Granite.Widgets.Utils.get_button_layout_schema}
     *         or there was no close value in the button-layout string, false will be returned. The position
     *         will be LEFT in that case.
     */
static gboolean
string_contains (const gchar* self,
                 const gchar* needle)
{
	gchar* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	_tmp0_ = strstr ((gchar*) self, (gchar*) needle);
	result = _tmp0_ != NULL;
	return result;
}

gboolean
granite_widgets_utils_get_default_close_button_position (GraniteCloseButtonPosition* position)
{
	GraniteCloseButtonPosition _vala_position = 0;
	gchar* schema = NULL;
	gchar* _tmp0_;
	const gchar* _tmp1_;
	gchar* layout = NULL;
	const gchar* _tmp2_;
	GSettings* _tmp3_;
	GSettings* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar** parts = NULL;
	const gchar* _tmp7_;
	gchar** _tmp8_;
	gchar** _tmp9_;
	gint parts_length1;
	gint _parts_size_;
	gchar** _tmp10_;
	gint _tmp10__length1;
	gchar** _tmp11_;
	gint _tmp11__length1;
	const gchar* _tmp12_;
	gboolean result;
	_vala_position = GRANITE_CLOSE_BUTTON_POSITION_LEFT;
	_tmp0_ = granite_widgets_utils_get_button_layout_schema ();
	schema = _tmp0_;
	_tmp1_ = schema;
	if (_tmp1_ == NULL) {
		result = FALSE;
		_g_free0 (schema);
		if (position) {
			*position = _vala_position;
		}
		return result;
	}
	_tmp2_ = schema;
	_tmp3_ = g_settings_new (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = g_settings_get_string (_tmp4_, GRANITE_WIDGETS_UTILS_WM_BUTTON_LAYOUT_KEY);
	_tmp6_ = _tmp5_;
	_g_object_unref0 (_tmp4_);
	layout = _tmp6_;
	_tmp7_ = layout;
	_tmp9_ = _tmp8_ = g_strsplit (_tmp7_, ":", 0);
	parts = _tmp9_;
	parts_length1 = _vala_array_length (_tmp8_);
	_parts_size_ = parts_length1;
	_tmp10_ = parts;
	_tmp10__length1 = parts_length1;
	if (_tmp10__length1 < 2) {
		result = FALSE;
		parts = (_vala_array_free (parts, parts_length1, (GDestroyNotify) g_free), NULL);
		_g_free0 (layout);
		_g_free0 (schema);
		if (position) {
			*position = _vala_position;
		}
		return result;
	}
	_tmp11_ = parts;
	_tmp11__length1 = parts_length1;
	_tmp12_ = _tmp11_[0];
	if (string_contains (_tmp12_, "close")) {
		_vala_position = GRANITE_CLOSE_BUTTON_POSITION_LEFT;
		result = TRUE;
		parts = (_vala_array_free (parts, parts_length1, (GDestroyNotify) g_free), NULL);
		_g_free0 (layout);
		_g_free0 (schema);
		if (position) {
			*position = _vala_position;
		}
		return result;
	} else {
		gchar** _tmp13_;
		gint _tmp13__length1;
		const gchar* _tmp14_;
		_tmp13_ = parts;
		_tmp13__length1 = parts_length1;
		_tmp14_ = _tmp13_[1];
		if (string_contains (_tmp14_, "close")) {
			_vala_position = GRANITE_CLOSE_BUTTON_POSITION_RIGHT;
			result = TRUE;
			parts = (_vala_array_free (parts, parts_length1, (GDestroyNotify) g_free), NULL);
			_g_free0 (layout);
			_g_free0 (schema);
			if (position) {
				*position = _vala_position;
			}
			return result;
		}
	}
	result = FALSE;
	parts = (_vala_array_free (parts, parts_length1, (GDestroyNotify) g_free), NULL);
	_g_free0 (layout);
	_g_free0 (schema);
	if (position) {
		*position = _vala_position;
	}
	return result;
}

/**
     * This methods returns the schema used by {@link Granite.Widgets.Utils.get_default_close_button_position}
     * to determine the close button placement. It will first check for the pantheon/gala schema and then fallback
     * to the default gnome one. If neither is available, null is returned. Make sure to check for this case,
     * as otherwise your program may crash on startup.
     *
     * @return the schema name. If the layout could not be determined, a warning will be thrown and null will be returned
     */
static gpointer
_g_settings_schema_source_ref0 (gpointer self)
{
	return self ? g_settings_schema_source_ref (self) : NULL;
}

gchar*
granite_widgets_utils_get_button_layout_schema (void)
{
	GSettingsSchemaSource* sss = NULL;
	GSettingsSchemaSource* _tmp0_;
	GSettingsSchemaSource* _tmp1_;
	GSettingsSchemaSource* _tmp2_;
	gchar* result;
	_tmp0_ = g_settings_schema_source_get_default ();
	_tmp1_ = _g_settings_schema_source_ref0 (_tmp0_);
	sss = _tmp1_;
	_tmp2_ = sss;
	if (_tmp2_ != NULL) {
		GSettingsSchemaSource* _tmp3_;
		GSettingsSchema* _tmp4_;
		GSettingsSchema* _tmp5_;
		gboolean _tmp6_;
		_tmp3_ = sss;
		_tmp4_ = g_settings_schema_source_lookup (_tmp3_, GRANITE_WIDGETS_UTILS_PANTHEON_SETTINGS_PATH, TRUE);
		_tmp5_ = _tmp4_;
		_tmp6_ = _tmp5_ != NULL;
		_g_settings_schema_unref0 (_tmp5_);
		if (_tmp6_) {
			gchar* _tmp7_;
			_tmp7_ = g_strdup (GRANITE_WIDGETS_UTILS_PANTHEON_SETTINGS_PATH);
			result = _tmp7_;
			_g_settings_schema_source_unref0 (sss);
			return result;
		} else {
			GSettingsSchemaSource* _tmp8_;
			GSettingsSchema* _tmp9_;
			GSettingsSchema* _tmp10_;
			gboolean _tmp11_;
			_tmp8_ = sss;
			_tmp9_ = g_settings_schema_source_lookup (_tmp8_, GRANITE_WIDGETS_UTILS_WM_SETTINGS_PATH, TRUE);
			_tmp10_ = _tmp9_;
			_tmp11_ = _tmp10_ != NULL;
			_g_settings_schema_unref0 (_tmp10_);
			if (_tmp11_) {
				gchar* _tmp12_;
				_tmp12_ = g_strdup (GRANITE_WIDGETS_UTILS_WM_SETTINGS_PATH);
				result = _tmp12_;
				_g_settings_schema_source_unref0 (sss);
				return result;
			}
		}
	}
	g_warning ("Utils.vala:484: No schema indicating the button-layout is installed.");
	result = NULL;
	_g_settings_schema_source_unref0 (sss);
	return result;
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

