/* DaemonManager.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from DaemonManager.vala, do not modify */

/*
 * Copyright 2024 elementary, Inc. (https://elementary.io)
 * SPDX-License-Identifier: LGPL-3.0-or-later
 *
 * Authored by: Leonhard Kargl <leo.kargl@proton.me>
 */

#include <glib-object.h>
#include <meta/display.h>
#include <meta/meta-wayland-client.h>
#include <gio/gio.h>
#include "gala.h"
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <meta/meta-context.h>
#include <meta/window.h>
#include <mtk/mtk.h>
#include <meta/util.h>

#define GALA_DAEMON_MANAGER_DAEMON_DBUS_NAME "org.pantheon.gala.daemon"
#define GALA_DAEMON_MANAGER_DAEMON_DBUS_OBJECT_PATH "/org/pantheon/gala/daemon"
#define GALA_DAEMON_MANAGER_SPACING 12
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define GALA_TYPE_DAEMON_MANAGER (gala_daemon_manager_get_type ())
#define GALA_DAEMON_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GALA_TYPE_DAEMON_MANAGER, GalaDaemonManager))
#define GALA_DAEMON_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GALA_TYPE_DAEMON_MANAGER, GalaDaemonManagerClass))
#define GALA_IS_DAEMON_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GALA_TYPE_DAEMON_MANAGER))
#define GALA_IS_DAEMON_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GALA_TYPE_DAEMON_MANAGER))
#define GALA_DAEMON_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GALA_TYPE_DAEMON_MANAGER, GalaDaemonManagerClass))

typedef struct _GalaDaemonManager GalaDaemonManager;
typedef struct _GalaDaemonManagerClass GalaDaemonManagerClass;
typedef struct _GalaDaemonManagerPrivate GalaDaemonManagerPrivate;

#define GALA_DAEMON_MANAGER_TYPE_DAEMON (gala_daemon_manager_daemon_get_type ())
#define GALA_DAEMON_MANAGER_DAEMON(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GALA_DAEMON_MANAGER_TYPE_DAEMON, GalaDaemonManagerDaemon))
#define GALA_DAEMON_MANAGER_IS_DAEMON(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GALA_DAEMON_MANAGER_TYPE_DAEMON))
#define GALA_DAEMON_MANAGER_DAEMON_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GALA_DAEMON_MANAGER_TYPE_DAEMON, GalaDaemonManagerDaemonIface))

typedef struct _GalaDaemonManagerDaemon GalaDaemonManagerDaemon;
typedef struct _GalaDaemonManagerDaemonIface GalaDaemonManagerDaemonIface;

#define GALA_DAEMON_MANAGER_TYPE_DAEMON_PROXY (gala_daemon_manager_daemon_proxy_get_type ())
enum  {
	GALA_DAEMON_MANAGER_0_PROPERTY,
	GALA_DAEMON_MANAGER_DISPLAY_PROPERTY,
	GALA_DAEMON_MANAGER_NUM_PROPERTIES
};
static GParamSpec* gala_daemon_manager_properties[GALA_DAEMON_MANAGER_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _GalaDaemonManagerStartWaylandData GalaDaemonManagerStartWaylandData;
typedef struct _GalaDaemonManagerStartXData GalaDaemonManagerStartXData;
typedef struct _GalaDaemonManagerShowBackgroundMenuData GalaDaemonManagerShowBackgroundMenuData;
typedef struct _GalaDaemonManagerShowWindowMenuData GalaDaemonManagerShowWindowMenuData;
typedef GDBusProxy GalaDaemonManagerDaemonProxy;
typedef GDBusProxyClass GalaDaemonManagerDaemonProxyClass;
typedef struct _GalaDaemonManagerDaemonShowWindowMenuReadyData GalaDaemonManagerDaemonShowWindowMenuReadyData;
typedef struct _GalaDaemonManagerDaemonShowDesktopMenuReadyData GalaDaemonManagerDaemonShowDesktopMenuReadyData;

struct _GalaDaemonManager {
	GObject parent_instance;
	GalaDaemonManagerPrivate * priv;
};

struct _GalaDaemonManagerClass {
	GObjectClass parent_class;
};

struct _GalaDaemonManagerDaemonIface {
	GTypeInterface parent_iface;
	void (*show_window_menu) (GalaDaemonManagerDaemon* self, GalaWindowFlags flags, gint width, gint height, gint x, gint y, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*show_window_menu_finish) (GalaDaemonManagerDaemon* self, GAsyncResult* _res_, GError** error);
	void (*show_desktop_menu) (GalaDaemonManagerDaemon* self, gint display_width, gint display_height, gint x, gint y, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*show_desktop_menu_finish) (GalaDaemonManagerDaemon* self, GAsyncResult* _res_, GError** error);
};

struct _GalaDaemonManagerPrivate {
	MetaDisplay* _display;
	MetaWaylandClient* daemon_client;
	GalaDaemonManagerDaemon* daemon_proxy;
};

struct _GalaDaemonManagerStartWaylandData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GalaDaemonManager* self;
	GSubprocessLauncher* subprocess_launcher;
	GSubprocessLauncher* _tmp0_;
	MetaWaylandClient* _tmp1_;
	MetaDisplay* _tmp2_;
	MetaContext* _tmp3_;
	GSubprocessLauncher* _tmp4_;
	MetaWaylandClient* _tmp5_;
	MetaWaylandClient* _tmp6_;
	gchar** args;
	gchar* _tmp7_;
	gchar** _tmp8_;
	gint args_length1;
	gint _args_size_;
	GSubprocess* subprocess;
	MetaWaylandClient* _tmp9_;
	MetaDisplay* _tmp10_;
	gchar** _tmp11_;
	gint _tmp11__length1;
	GSubprocess* _tmp12_;
	GSubprocess* _tmp13_;
	GError* e;
	GError* _tmp14_;
	const gchar* _tmp15_;
	GError* _inner_error0_;
};

struct _GalaDaemonManagerStartXData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GalaDaemonManager* self;
	GSubprocess* subprocess;
	GSubprocess* _tmp0_;
	GSubprocess* _tmp1_;
	GError* e;
	GError* _tmp2_;
	const gchar* _tmp3_;
	GError* _inner_error0_;
};

struct _GalaDaemonManagerShowBackgroundMenuData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GalaDaemonManager* self;
	gint x;
	gint y;
	GalaDaemonManagerDaemon* _tmp0_;
	gint width;
	gint height;
	MetaDisplay* _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	GalaDaemonManagerDaemon* _tmp4_;
	GError* e;
	GError* _tmp5_;
	const gchar* _tmp6_;
	GError* _inner_error0_;
};

struct _GalaDaemonManagerShowWindowMenuData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GalaDaemonManager* self;
	GalaWindowFlags flags;
	gint x;
	gint y;
	GalaDaemonManagerDaemon* _tmp0_;
	gint width;
	gint height;
	MetaDisplay* _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	GalaDaemonManagerDaemon* _tmp4_;
	GError* e;
	GError* _tmp5_;
	const gchar* _tmp6_;
	GError* _inner_error0_;
};

struct _GalaDaemonManagerDaemonShowWindowMenuReadyData {
	GDBusMethodInvocation* _invocation_;
	GalaWindowFlags flags;
	gint width;
	gint height;
	gint x;
	gint y;
};

struct _GalaDaemonManagerDaemonShowDesktopMenuReadyData {
	GDBusMethodInvocation* _invocation_;
	gint display_width;
	gint display_height;
	gint x;
	gint y;
};

static gint GalaDaemonManager_private_offset;
static gpointer gala_daemon_manager_parent_class = NULL;

VALA_EXTERN GType gala_daemon_manager_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GalaDaemonManager, g_object_unref)
VALA_EXTERN GType gala_daemon_manager_daemon_proxy_get_type (void) G_GNUC_CONST ;
VALA_EXTERN guint gala_daemon_manager_daemon_register_object (void* object,
                                                  GDBusConnection* connection,
                                                  const gchar* path,
                                                  GError** error);
VALA_EXTERN GType gala_daemon_manager_daemon_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GalaDaemonManagerDaemon, g_object_unref)
VALA_EXTERN GalaDaemonManager* gala_daemon_manager_new (MetaDisplay* display);
VALA_EXTERN GalaDaemonManager* gala_daemon_manager_construct (GType object_type,
                                                  MetaDisplay* display);
static void gala_daemon_manager_start_wayland_data_free (gpointer _data);
static void gala_daemon_manager_start_wayland (GalaDaemonManager* self,
                                        GAsyncReadyCallback _callback_,
                                        gpointer _user_data_);
static void gala_daemon_manager_start_wayland_finish (GalaDaemonManager* self,
                                               GAsyncResult* _res_);
static gboolean gala_daemon_manager_start_wayland_co (GalaDaemonManagerStartWaylandData* _data_);
VALA_EXTERN MetaDisplay* gala_daemon_manager_get_display (GalaDaemonManager* self);
static void gala_daemon_manager_start_wayland_ready (GObject* source_object,
                                              GAsyncResult* _res_,
                                              gpointer _user_data_);
static gboolean ___lambda107_ (GalaDaemonManager* self);
static gboolean ____lambda107__gsource_func (gpointer self);
static void gala_daemon_manager_start_x_data_free (gpointer _data);
static void gala_daemon_manager_start_x (GalaDaemonManager* self,
                                  GAsyncReadyCallback _callback_,
                                  gpointer _user_data_);
static void gala_daemon_manager_start_x_finish (GalaDaemonManager* self,
                                         GAsyncResult* _res_);
static gboolean gala_daemon_manager_start_x_co (GalaDaemonManagerStartXData* _data_);
static void gala_daemon_manager_start_x_ready (GObject* source_object,
                                        GAsyncResult* _res_,
                                        gpointer _user_data_);
static gboolean ___lambda108_ (GalaDaemonManager* self);
static gboolean ____lambda108__gsource_func (gpointer self);
static void gala_daemon_manager_handle_daemon_window (GalaDaemonManager* self,
                                               MetaWindow* window);
static void gala_daemon_manager_lost_daemon (GalaDaemonManager* self);
static void gala_daemon_manager_daemon_appeared (GalaDaemonManager* self);
static void ___lambda109_ (GalaDaemonManager* self,
                    GObject* obj,
                    GAsyncResult* res);
static void ____lambda109__gasync_ready_callback (GObject* source_object,
                                           GAsyncResult* res,
                                           gpointer self);
static void gala_daemon_manager_show_background_menu_data_free (gpointer _data);
VALA_EXTERN void gala_daemon_manager_show_background_menu (GalaDaemonManager* self,
                                               gint x,
                                               gint y,
                                               GAsyncReadyCallback _callback_,
                                               gpointer _user_data_);
VALA_EXTERN void gala_daemon_manager_show_background_menu_finish (GalaDaemonManager* self,
                                                      GAsyncResult* _res_);
static gboolean gala_daemon_manager_show_background_menu_co (GalaDaemonManagerShowBackgroundMenuData* _data_);
VALA_EXTERN void gala_daemon_manager_daemon_show_desktop_menu (GalaDaemonManagerDaemon* self,
                                                   gint display_width,
                                                   gint display_height,
                                                   gint x,
                                                   gint y,
                                                   GAsyncReadyCallback _callback_,
                                                   gpointer _user_data_);
VALA_EXTERN void gala_daemon_manager_daemon_show_desktop_menu_finish (GalaDaemonManagerDaemon* self,
                                                          GAsyncResult* _res_,
                                                          GError** error);
static void gala_daemon_manager_show_background_menu_ready (GObject* source_object,
                                                     GAsyncResult* _res_,
                                                     gpointer _user_data_);
static void gala_daemon_manager_show_window_menu_data_free (gpointer _data);
VALA_EXTERN void gala_daemon_manager_show_window_menu (GalaDaemonManager* self,
                                           GalaWindowFlags flags,
                                           gint x,
                                           gint y,
                                           GAsyncReadyCallback _callback_,
                                           gpointer _user_data_);
VALA_EXTERN void gala_daemon_manager_show_window_menu_finish (GalaDaemonManager* self,
                                                  GAsyncResult* _res_);
static gboolean gala_daemon_manager_show_window_menu_co (GalaDaemonManagerShowWindowMenuData* _data_);
VALA_EXTERN void gala_daemon_manager_daemon_show_window_menu (GalaDaemonManagerDaemon* self,
                                                  GalaWindowFlags flags,
                                                  gint width,
                                                  gint height,
                                                  gint x,
                                                  gint y,
                                                  GAsyncReadyCallback _callback_,
                                                  gpointer _user_data_);
VALA_EXTERN void gala_daemon_manager_daemon_show_window_menu_finish (GalaDaemonManagerDaemon* self,
                                                         GAsyncResult* _res_,
                                                         GError** error);
static void gala_daemon_manager_show_window_menu_ready (GObject* source_object,
                                                 GAsyncResult* _res_,
                                                 gpointer _user_data_);
static void gala_daemon_manager_set_display (GalaDaemonManager* self,
                                      MetaDisplay* value);
static GType gala_daemon_manager_daemon_get_type_once (void);
static void gala_daemon_manager_daemon_proxy_g_signal (GDBusProxy* proxy,
                                                const gchar* sender_name,
                                                const gchar* signal_name,
                                                GVariant* parameters);
static void _vala_g_async_ready_callback (GObject *source_object,
                                   GAsyncResult *res,
                                   void *user_data);
static void gala_daemon_manager_daemon_proxy_show_window_menu_async (GalaDaemonManagerDaemon* self,
                                                              GalaWindowFlags flags,
                                                              gint width,
                                                              gint height,
                                                              gint x,
                                                              gint y,
                                                              GAsyncReadyCallback _callback_,
                                                              gpointer _user_data_);
static void gala_daemon_manager_daemon_proxy_show_window_menu_finish (GalaDaemonManagerDaemon* self,
                                                               GAsyncResult* _res_,
                                                               GError** error);
static void gala_daemon_manager_daemon_proxy_show_desktop_menu_async (GalaDaemonManagerDaemon* self,
                                                               gint display_width,
                                                               gint display_height,
                                                               gint x,
                                                               gint y,
                                                               GAsyncReadyCallback _callback_,
                                                               gpointer _user_data_);
static void gala_daemon_manager_daemon_proxy_show_desktop_menu_finish (GalaDaemonManagerDaemon* self,
                                                                GAsyncResult* _res_,
                                                                GError** error);
static void gala_daemon_manager_daemon_proxy_gala_daemon_manager_daemon_interface_init (GalaDaemonManagerDaemonIface* iface);
static void _dbus_gala_daemon_manager_daemon_show_window_menu (GalaDaemonManagerDaemon* self,
                                                        GVariant* _parameters_,
                                                        GDBusMethodInvocation* invocation);
static void _dbus_gala_daemon_manager_daemon_show_window_menu_ready (GObject * source_object,
                                                              GAsyncResult * _res_,
                                                              gpointer _user_data_);
static void _dbus_gala_daemon_manager_daemon_show_desktop_menu (GalaDaemonManagerDaemon* self,
                                                         GVariant* _parameters_,
                                                         GDBusMethodInvocation* invocation);
static void _dbus_gala_daemon_manager_daemon_show_desktop_menu_ready (GObject * source_object,
                                                               GAsyncResult * _res_,
                                                               gpointer _user_data_);
static void gala_daemon_manager_daemon_dbus_interface_method_call (GDBusConnection* connection,
                                                            const gchar* sender,
                                                            const gchar* object_path,
                                                            const gchar* interface_name,
                                                            const gchar* method_name,
                                                            GVariant* parameters,
                                                            GDBusMethodInvocation* invocation,
                                                            gpointer user_data);
static GVariant* gala_daemon_manager_daemon_dbus_interface_get_property (GDBusConnection* connection,
                                                                  const gchar* sender,
                                                                  const gchar* object_path,
                                                                  const gchar* interface_name,
                                                                  const gchar* property_name,
                                                                  GError** error,
                                                                  gpointer user_data);
static gboolean gala_daemon_manager_daemon_dbus_interface_set_property (GDBusConnection* connection,
                                                                 const gchar* sender,
                                                                 const gchar* object_path,
                                                                 const gchar* interface_name,
                                                                 const gchar* property_name,
                                                                 GVariant* value,
                                                                 GError** error,
                                                                 gpointer user_data);
static void _gala_daemon_manager_daemon_unregister_object (gpointer user_data);
static GObject * gala_daemon_manager_constructor (GType type,
                                           guint n_construct_properties,
                                           GObjectConstructParam * construct_properties);
static void _gala_daemon_manager_daemon_appeared_gbus_name_appeared_callback (GDBusConnection* connection,
                                                                       const gchar* name,
                                                                       const gchar* name_owner,
                                                                       gpointer self);
static void _gala_daemon_manager_lost_daemon_gbus_name_vanished_callback (GDBusConnection* connection,
                                                                   const gchar* name,
                                                                   gpointer self);
static void _gala_daemon_manager____lambda110_ (GalaDaemonManager* self,
                                         MetaWindow* window);
static void _gala_daemon_manager_handle_daemon_window_meta_window_shown (MetaWindow* _sender,
                                                                  gpointer self);
static void __gala_daemon_manager____lambda110__meta_display_window_created (MetaDisplay* _sender,
                                                                      MetaWindow* object,
                                                                      gpointer self);
static void gala_daemon_manager_finalize (GObject * obj);
static GType gala_daemon_manager_get_type_once (void);
static void _vala_gala_daemon_manager_get_property (GObject * object,
                                             guint property_id,
                                             GValue * value,
                                             GParamSpec * pspec);
static void _vala_gala_daemon_manager_set_property (GObject * object,
                                             guint property_id,
                                             const GValue * value,
                                             GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);

static const GDBusArgInfo _gala_daemon_manager_daemon_dbus_arg_info_show_window_menu_flags = {-1, "flags", "u", NULL};
static const GDBusArgInfo _gala_daemon_manager_daemon_dbus_arg_info_show_window_menu_width = {-1, "width", "i", NULL};
static const GDBusArgInfo _gala_daemon_manager_daemon_dbus_arg_info_show_window_menu_height = {-1, "height", "i", NULL};
static const GDBusArgInfo _gala_daemon_manager_daemon_dbus_arg_info_show_window_menu_x = {-1, "x", "i", NULL};
static const GDBusArgInfo _gala_daemon_manager_daemon_dbus_arg_info_show_window_menu_y = {-1, "y", "i", NULL};
static const GDBusArgInfo * const _gala_daemon_manager_daemon_dbus_arg_info_show_window_menu_in[] = {&_gala_daemon_manager_daemon_dbus_arg_info_show_window_menu_flags, &_gala_daemon_manager_daemon_dbus_arg_info_show_window_menu_width, &_gala_daemon_manager_daemon_dbus_arg_info_show_window_menu_height, &_gala_daemon_manager_daemon_dbus_arg_info_show_window_menu_x, &_gala_daemon_manager_daemon_dbus_arg_info_show_window_menu_y, NULL};
static const GDBusArgInfo * const _gala_daemon_manager_daemon_dbus_arg_info_show_window_menu_out[] = {NULL};
static const GDBusMethodInfo _gala_daemon_manager_daemon_dbus_method_info_show_window_menu = {-1, "ShowWindowMenu", (GDBusArgInfo **) (&_gala_daemon_manager_daemon_dbus_arg_info_show_window_menu_in), (GDBusArgInfo **) (&_gala_daemon_manager_daemon_dbus_arg_info_show_window_menu_out), NULL};
static const GDBusArgInfo _gala_daemon_manager_daemon_dbus_arg_info_show_desktop_menu_display_width = {-1, "display_width", "i", NULL};
static const GDBusArgInfo _gala_daemon_manager_daemon_dbus_arg_info_show_desktop_menu_display_height = {-1, "display_height", "i", NULL};
static const GDBusArgInfo _gala_daemon_manager_daemon_dbus_arg_info_show_desktop_menu_x = {-1, "x", "i", NULL};
static const GDBusArgInfo _gala_daemon_manager_daemon_dbus_arg_info_show_desktop_menu_y = {-1, "y", "i", NULL};
static const GDBusArgInfo * const _gala_daemon_manager_daemon_dbus_arg_info_show_desktop_menu_in[] = {&_gala_daemon_manager_daemon_dbus_arg_info_show_desktop_menu_display_width, &_gala_daemon_manager_daemon_dbus_arg_info_show_desktop_menu_display_height, &_gala_daemon_manager_daemon_dbus_arg_info_show_desktop_menu_x, &_gala_daemon_manager_daemon_dbus_arg_info_show_desktop_menu_y, NULL};
static const GDBusArgInfo * const _gala_daemon_manager_daemon_dbus_arg_info_show_desktop_menu_out[] = {NULL};
static const GDBusMethodInfo _gala_daemon_manager_daemon_dbus_method_info_show_desktop_menu = {-1, "ShowDesktopMenu", (GDBusArgInfo **) (&_gala_daemon_manager_daemon_dbus_arg_info_show_desktop_menu_in), (GDBusArgInfo **) (&_gala_daemon_manager_daemon_dbus_arg_info_show_desktop_menu_out), NULL};
static const GDBusMethodInfo * const _gala_daemon_manager_daemon_dbus_method_info[] = {&_gala_daemon_manager_daemon_dbus_method_info_show_window_menu, &_gala_daemon_manager_daemon_dbus_method_info_show_desktop_menu, NULL};
static const GDBusSignalInfo * const _gala_daemon_manager_daemon_dbus_signal_info[] = {NULL};
static const GDBusPropertyInfo * const _gala_daemon_manager_daemon_dbus_property_info[] = {NULL};
static const GDBusInterfaceInfo _gala_daemon_manager_daemon_dbus_interface_info = {-1, "org.pantheon.gala.daemon", (GDBusMethodInfo **) (&_gala_daemon_manager_daemon_dbus_method_info), (GDBusSignalInfo **) (&_gala_daemon_manager_daemon_dbus_signal_info), (GDBusPropertyInfo **) (&_gala_daemon_manager_daemon_dbus_property_info), NULL};
static const GDBusInterfaceVTable _gala_daemon_manager_daemon_dbus_interface_vtable = {gala_daemon_manager_daemon_dbus_interface_method_call, gala_daemon_manager_daemon_dbus_interface_get_property, gala_daemon_manager_daemon_dbus_interface_set_property};

static inline gpointer
gala_daemon_manager_get_instance_private (GalaDaemonManager* self)
{
	return G_STRUCT_MEMBER_P (self, GalaDaemonManager_private_offset);
}

GalaDaemonManager*
gala_daemon_manager_construct (GType object_type,
                               MetaDisplay* display)
{
	GalaDaemonManager * self = NULL;
	g_return_val_if_fail (display != NULL, NULL);
	self = (GalaDaemonManager*) g_object_new (object_type, "display", display, NULL);
	return self;
}

GalaDaemonManager*
gala_daemon_manager_new (MetaDisplay* display)
{
	return gala_daemon_manager_construct (GALA_TYPE_DAEMON_MANAGER, display);
}

static void
gala_daemon_manager_start_wayland_data_free (gpointer _data)
{
	GalaDaemonManagerStartWaylandData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (GalaDaemonManagerStartWaylandData, _data_);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
gala_daemon_manager_start_wayland (GalaDaemonManager* self,
                                   GAsyncReadyCallback _callback_,
                                   gpointer _user_data_)
{
	GalaDaemonManagerStartWaylandData* _data_;
	GalaDaemonManager* _tmp0_;
	g_return_if_fail (self != NULL);
	_data_ = g_slice_new0 (GalaDaemonManagerStartWaylandData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, gala_daemon_manager_start_wayland_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	gala_daemon_manager_start_wayland_co (_data_);
}

static void
gala_daemon_manager_start_wayland_finish (GalaDaemonManager* self,
                                          GAsyncResult* _res_)
{
	GalaDaemonManagerStartWaylandData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

static void
gala_daemon_manager_start_wayland_ready (GObject* source_object,
                                         GAsyncResult* _res_,
                                         gpointer _user_data_)
{
	GalaDaemonManagerStartWaylandData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	gala_daemon_manager_start_wayland_co (_data_);
}

static gboolean
___lambda107_ (GalaDaemonManager* self)
{
	gboolean result;
	gala_daemon_manager_start_wayland (self, NULL, NULL);
	result = G_SOURCE_REMOVE;
	return result;
}

static gboolean
____lambda107__gsource_func (gpointer self)
{
	gboolean result;
	result = ___lambda107_ ((GalaDaemonManager*) self);
	return result;
}

static gboolean
gala_daemon_manager_start_wayland_co (GalaDaemonManagerStartWaylandData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = g_subprocess_launcher_new (G_SUBPROCESS_FLAGS_NONE);
	_data_->subprocess_launcher = _data_->_tmp0_;
	{
		_data_->_tmp2_ = _data_->self->priv->_display;
		_data_->_tmp3_ = meta_display_get_context (_data_->_tmp2_);
		_data_->_tmp4_ = _data_->subprocess_launcher;
		_data_->_tmp5_ = meta_wayland_client_new (_data_->_tmp3_, _data_->_tmp4_, &_data_->_inner_error0_);
		_data_->_tmp1_ = _data_->_tmp5_;
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_data_->_tmp6_ = _data_->_tmp1_;
		_data_->_tmp1_ = NULL;
		_g_object_unref0 (_data_->self->priv->daemon_client);
		_data_->self->priv->daemon_client = _data_->_tmp6_;
		_data_->_tmp7_ = g_strdup ("gala-daemon");
		_data_->_tmp8_ = g_new0 (gchar*, 1 + 1);
		_data_->_tmp8_[0] = _data_->_tmp7_;
		_data_->args = _data_->_tmp8_;
		_data_->args_length1 = 1;
		_data_->_args_size_ = _data_->args_length1;
		_data_->_tmp9_ = _data_->self->priv->daemon_client;
		_data_->_tmp10_ = _data_->self->priv->_display;
		_data_->_tmp11_ = _data_->args;
		_data_->_tmp11__length1 = _data_->args_length1;
		_data_->_tmp12_ = meta_wayland_client_spawnv (_data_->_tmp9_, _data_->_tmp10_, _data_->_tmp11_, &_data_->_inner_error0_);
		_data_->subprocess = _data_->_tmp12_;
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			_data_->args = (_vala_array_free (_data_->args, _data_->args_length1, (GDestroyNotify) g_free), NULL);
			_g_object_unref0 (_data_->_tmp1_);
			goto __catch0_g_error;
		}
		_data_->_tmp13_ = _data_->subprocess;
		_data_->_state_ = 1;
		g_subprocess_wait_async (_data_->_tmp13_, NULL, gala_daemon_manager_start_wayland_ready, _data_);
		return FALSE;
		_state_1:
		g_subprocess_wait_finish (_data_->_tmp13_, _data_->_res_, &_data_->_inner_error0_);
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			_g_object_unref0 (_data_->subprocess);
			_data_->args = (_vala_array_free (_data_->args, _data_->args_length1, (GDestroyNotify) g_free), NULL);
			_g_object_unref0 (_data_->_tmp1_);
			goto __catch0_g_error;
		}
		g_timeout_add_seconds_full (G_PRIORITY_DEFAULT, (guint) 1, ____lambda107__gsource_func, g_object_ref (_data_->self), g_object_unref);
		_g_object_unref0 (_data_->subprocess);
		_data_->args = (_vala_array_free (_data_->args, _data_->args_length1, (GDestroyNotify) g_free), NULL);
		_g_object_unref0 (_data_->_tmp1_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		_data_->e = _data_->_inner_error0_;
		_data_->_inner_error0_ = NULL;
		_data_->_tmp14_ = _data_->e;
		_data_->_tmp15_ = _data_->_tmp14_->message;
		g_warning ("DaemonManager.vala:59: Failed to create dock client: %s", _data_->_tmp15_);
		_g_error_free0 (_data_->e);
		_g_object_unref0 (_data_->subprocess_launcher);
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	__finally0:
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		_g_object_unref0 (_data_->subprocess_launcher);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
		g_clear_error (&_data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_g_object_unref0 (_data_->subprocess_launcher);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
gala_daemon_manager_start_x_data_free (gpointer _data)
{
	GalaDaemonManagerStartXData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (GalaDaemonManagerStartXData, _data_);
}

static void
gala_daemon_manager_start_x (GalaDaemonManager* self,
                             GAsyncReadyCallback _callback_,
                             gpointer _user_data_)
{
	GalaDaemonManagerStartXData* _data_;
	GalaDaemonManager* _tmp0_;
	g_return_if_fail (self != NULL);
	_data_ = g_slice_new0 (GalaDaemonManagerStartXData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, gala_daemon_manager_start_x_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	gala_daemon_manager_start_x_co (_data_);
}

static void
gala_daemon_manager_start_x_finish (GalaDaemonManager* self,
                                    GAsyncResult* _res_)
{
	GalaDaemonManagerStartXData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

static void
gala_daemon_manager_start_x_ready (GObject* source_object,
                                   GAsyncResult* _res_,
                                   gpointer _user_data_)
{
	GalaDaemonManagerStartXData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	gala_daemon_manager_start_x_co (_data_);
}

static gboolean
___lambda108_ (GalaDaemonManager* self)
{
	gboolean result;
	gala_daemon_manager_start_x (self, NULL, NULL);
	result = G_SOURCE_REMOVE;
	return result;
}

static gboolean
____lambda108__gsource_func (gpointer self)
{
	gboolean result;
	result = ___lambda108_ ((GalaDaemonManager*) self);
	return result;
}

static gboolean
gala_daemon_manager_start_x_co (GalaDaemonManagerStartXData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	{
		_data_->_tmp0_ = g_subprocess_new (G_SUBPROCESS_FLAGS_NONE, &_data_->_inner_error0_, "gala-daemon-gtk3", NULL);
		_data_->subprocess = _data_->_tmp0_;
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_data_->_tmp1_ = _data_->subprocess;
		_data_->_state_ = 1;
		g_subprocess_wait_async (_data_->_tmp1_, NULL, gala_daemon_manager_start_x_ready, _data_);
		return FALSE;
		_state_1:
		g_subprocess_wait_finish (_data_->_tmp1_, _data_->_res_, &_data_->_inner_error0_);
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			_g_object_unref0 (_data_->subprocess);
			goto __catch0_g_error;
		}
		g_timeout_add_seconds_full (G_PRIORITY_DEFAULT, (guint) 1, ____lambda108__gsource_func, g_object_ref (_data_->self), g_object_unref);
		_g_object_unref0 (_data_->subprocess);
	}
	goto __finally0;
	__catch0_g_error:
	{
		_data_->e = _data_->_inner_error0_;
		_data_->_inner_error0_ = NULL;
		_data_->_tmp2_ = _data_->e;
		_data_->_tmp3_ = _data_->_tmp2_->message;
		g_warning ("DaemonManager.vala:75: Failed to create daemon subprocess with x: %s", _data_->_tmp3_);
		_g_error_free0 (_data_->e);
	}
	__finally0:
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
		g_clear_error (&_data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
gala_daemon_manager_handle_daemon_window (GalaDaemonManager* self,
                                          MetaWindow* window)
{
	gchar** info = NULL;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	gchar** _tmp2_;
	gchar** _tmp3_;
	gint info_length1;
	gint _info_size_;
	gchar** _tmp4_;
	gint _tmp4__length1;
	gchar** _tmp5_;
	gint _tmp5__length1;
	const gchar* _tmp6_;
	const gchar* _tmp7_;
	GQuark _tmp9_ = 0U;
	static GQuark _tmp8_label0 = 0;
	static GQuark _tmp8_label1 = 0;
	g_return_if_fail (self != NULL);
	g_return_if_fail (window != NULL);
	_tmp0_ = meta_window_get_title (window);
	_tmp1_ = _tmp0_;
	_tmp3_ = _tmp2_ = g_strsplit (_tmp1_, "-", 0);
	info = _tmp3_;
	info_length1 = _vala_array_length (_tmp2_);
	_info_size_ = info_length1;
	_tmp4_ = info;
	_tmp4__length1 = info_length1;
	if (_tmp4__length1 == 0) {
		g_critical ("DaemonManager.vala:83: Couldn't handle daemon window: No title provide" \
"d");
		info = (_vala_array_free (info, info_length1, (GDestroyNotify) g_free), NULL);
		return;
	}
	_tmp5_ = info;
	_tmp5__length1 = info_length1;
	_tmp6_ = _tmp5_[0];
	_tmp7_ = _tmp6_;
	_tmp9_ = (NULL == _tmp7_) ? 0 : g_quark_from_string (_tmp7_);
	if (_tmp9_ == ((0 != _tmp8_label0) ? _tmp8_label0 : (_tmp8_label0 = g_quark_from_static_string ("LABEL")))) {
		switch (0) {
			default:
			{
				gchar** _tmp10_;
				gint _tmp10__length1;
				gint index = 0;
				gchar** _tmp11_;
				gint _tmp11__length1;
				const gchar* _tmp12_;
				MtkRectangle monitor_geometry = {0};
				MetaDisplay* _tmp13_;
				MtkRectangle _tmp14_ = {0};
				MtkRectangle _tmp15_;
				MtkRectangle _tmp16_;
				_tmp10_ = info;
				_tmp10__length1 = info_length1;
				if (_tmp10__length1 < 2) {
					info = (_vala_array_free (info, info_length1, (GDestroyNotify) g_free), NULL);
					return;
				}
				_tmp11_ = info;
				_tmp11__length1 = info_length1;
				_tmp12_ = _tmp11_[1];
				index = atoi (_tmp12_);
				_tmp13_ = self->priv->_display;
				meta_display_get_monitor_geometry (_tmp13_, index, &_tmp14_);
				monitor_geometry = _tmp14_;
				_tmp15_ = monitor_geometry;
				_tmp16_ = monitor_geometry;
				meta_window_move_frame (window, FALSE, _tmp15_.x + GALA_DAEMON_MANAGER_SPACING, _tmp16_.y + GALA_DAEMON_MANAGER_SPACING);
				meta_window_make_above (window);
				break;
			}
		}
	} else if (_tmp9_ == ((0 != _tmp8_label1) ? _tmp8_label1 : (_tmp8_label1 = g_quark_from_static_string ("MODAL")))) {
		switch (0) {
			default:
			{
				MetaWaylandClient* _tmp17_;
				_tmp17_ = self->priv->daemon_client;
				meta_wayland_client_make_dock (_tmp17_, window);
				meta_window_move_frame (window, FALSE, 0, 0);
				meta_window_make_above (window);
				break;
			}
		}
	}
	info = (_vala_array_free (info, info_length1, (GDestroyNotify) g_free), NULL);
}

static void
gala_daemon_manager_lost_daemon (GalaDaemonManager* self)
{
	g_return_if_fail (self != NULL);
	_g_object_unref0 (self->priv->daemon_proxy);
	self->priv->daemon_proxy = NULL;
}

static void
___lambda109_ (GalaDaemonManager* self,
               GObject* obj,
               GAsyncResult* res)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (res != NULL);
	{
		GalaDaemonManagerDaemon* _tmp0_ = NULL;
		GalaDaemonManagerDaemon* _tmp1_;
		GalaDaemonManagerDaemon* _tmp2_;
		GalaDaemonManagerDaemon* _tmp3_;
		_tmp1_ = g_async_result_get_source_object (res);
		_tmp2_ = (GalaDaemonManagerDaemon*) g_async_initable_new_finish ((GAsyncInitable *) _tmp1_, res, &_inner_error0_);
		g_object_unref (_tmp1_);
		_tmp0_ = (GalaDaemonManagerDaemon*) _tmp2_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp3_ = _tmp0_;
		_tmp0_ = NULL;
		_g_object_unref0 (self->priv->daemon_proxy);
		self->priv->daemon_proxy = _tmp3_;
		_g_object_unref0 (_tmp0_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp4_;
		const gchar* _tmp5_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp4_ = e;
		_tmp5_ = _tmp4_->message;
		g_warning ("DaemonManager.vala:120: Failed to get Menu proxy: %s", _tmp5_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
____lambda109__gasync_ready_callback (GObject* source_object,
                                      GAsyncResult* res,
                                      gpointer self)
{
	___lambda109_ ((GalaDaemonManager*) self, source_object, res);
	g_object_unref (self);
}

static void
gala_daemon_manager_daemon_appeared (GalaDaemonManager* self)
{
	GalaDaemonManagerDaemon* _tmp0_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->daemon_proxy;
	if (_tmp0_ == NULL) {
		g_async_initable_new_async (GALA_DAEMON_MANAGER_TYPE_DAEMON_PROXY, 0, NULL, ____lambda109__gasync_ready_callback, g_object_ref (self), "g-flags", 0, "g-name", GALA_DAEMON_MANAGER_DAEMON_DBUS_NAME, "g-bus-type", G_BUS_TYPE_SESSION, "g-object-path", GALA_DAEMON_MANAGER_DAEMON_DBUS_OBJECT_PATH, "g-interface-name", "org.pantheon.gala.daemon", NULL);
	}
}

static void
gala_daemon_manager_show_background_menu_data_free (gpointer _data)
{
	GalaDaemonManagerShowBackgroundMenuData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (GalaDaemonManagerShowBackgroundMenuData, _data_);
}

void
gala_daemon_manager_show_background_menu (GalaDaemonManager* self,
                                          gint x,
                                          gint y,
                                          GAsyncReadyCallback _callback_,
                                          gpointer _user_data_)
{
	GalaDaemonManagerShowBackgroundMenuData* _data_;
	GalaDaemonManager* _tmp0_;
	g_return_if_fail (self != NULL);
	_data_ = g_slice_new0 (GalaDaemonManagerShowBackgroundMenuData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, gala_daemon_manager_show_background_menu_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_data_->x = x;
	_data_->y = y;
	gala_daemon_manager_show_background_menu_co (_data_);
}

void
gala_daemon_manager_show_background_menu_finish (GalaDaemonManager* self,
                                                 GAsyncResult* _res_)
{
	GalaDaemonManagerShowBackgroundMenuData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

static void
gala_daemon_manager_show_background_menu_ready (GObject* source_object,
                                                GAsyncResult* _res_,
                                                gpointer _user_data_)
{
	GalaDaemonManagerShowBackgroundMenuData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	gala_daemon_manager_show_background_menu_co (_data_);
}

static gboolean
gala_daemon_manager_show_background_menu_co (GalaDaemonManagerShowBackgroundMenuData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->self->priv->daemon_proxy;
	if (_data_->_tmp0_ == NULL) {
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp1_ = _data_->self->priv->_display;
	_data_->_tmp2_ = 0;
	_data_->_tmp3_ = 0;
	meta_display_get_size (_data_->_tmp1_, &_data_->_tmp2_, &_data_->_tmp3_);
	_data_->width = _data_->_tmp2_;
	_data_->height = _data_->_tmp3_;
	{
		_data_->_tmp4_ = _data_->self->priv->daemon_proxy;
		_data_->_state_ = 1;
		gala_daemon_manager_daemon_show_desktop_menu (_data_->_tmp4_, _data_->width, _data_->height, _data_->x, _data_->y, gala_daemon_manager_show_background_menu_ready, _data_);
		return FALSE;
		_state_1:
		gala_daemon_manager_daemon_show_desktop_menu_finish (_data_->_tmp4_, _data_->_res_, &_data_->_inner_error0_);
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		_data_->e = _data_->_inner_error0_;
		_data_->_inner_error0_ = NULL;
		_data_->_tmp5_ = _data_->e;
		_data_->_tmp6_ = _data_->_tmp5_->message;
		g_warning ("DaemonManager.vala:137: Error invoking MenuManager: %s", _data_->_tmp6_);
		_g_error_free0 (_data_->e);
	}
	__finally0:
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
		g_clear_error (&_data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
gala_daemon_manager_show_window_menu_data_free (gpointer _data)
{
	GalaDaemonManagerShowWindowMenuData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (GalaDaemonManagerShowWindowMenuData, _data_);
}

void
gala_daemon_manager_show_window_menu (GalaDaemonManager* self,
                                      GalaWindowFlags flags,
                                      gint x,
                                      gint y,
                                      GAsyncReadyCallback _callback_,
                                      gpointer _user_data_)
{
	GalaDaemonManagerShowWindowMenuData* _data_;
	GalaDaemonManager* _tmp0_;
	g_return_if_fail (self != NULL);
	_data_ = g_slice_new0 (GalaDaemonManagerShowWindowMenuData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, gala_daemon_manager_show_window_menu_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_data_->flags = flags;
	_data_->x = x;
	_data_->y = y;
	gala_daemon_manager_show_window_menu_co (_data_);
}

void
gala_daemon_manager_show_window_menu_finish (GalaDaemonManager* self,
                                             GAsyncResult* _res_)
{
	GalaDaemonManagerShowWindowMenuData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

static void
gala_daemon_manager_show_window_menu_ready (GObject* source_object,
                                            GAsyncResult* _res_,
                                            gpointer _user_data_)
{
	GalaDaemonManagerShowWindowMenuData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	gala_daemon_manager_show_window_menu_co (_data_);
}

static gboolean
gala_daemon_manager_show_window_menu_co (GalaDaemonManagerShowWindowMenuData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->self->priv->daemon_proxy;
	if (_data_->_tmp0_ == NULL) {
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp1_ = _data_->self->priv->_display;
	_data_->_tmp2_ = 0;
	_data_->_tmp3_ = 0;
	meta_display_get_size (_data_->_tmp1_, &_data_->_tmp2_, &_data_->_tmp3_);
	_data_->width = _data_->_tmp2_;
	_data_->height = _data_->_tmp3_;
	{
		_data_->_tmp4_ = _data_->self->priv->daemon_proxy;
		_data_->_state_ = 1;
		gala_daemon_manager_daemon_show_window_menu (_data_->_tmp4_, _data_->flags, _data_->width, _data_->height, _data_->x, _data_->y, gala_daemon_manager_show_window_menu_ready, _data_);
		return FALSE;
		_state_1:
		gala_daemon_manager_daemon_show_window_menu_finish (_data_->_tmp4_, _data_->_res_, &_data_->_inner_error0_);
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		_data_->e = _data_->_inner_error0_;
		_data_->_inner_error0_ = NULL;
		_data_->_tmp5_ = _data_->e;
		_data_->_tmp6_ = _data_->_tmp5_->message;
		g_warning ("DaemonManager.vala:152: Error invoking MenuManager: %s", _data_->_tmp6_);
		_g_error_free0 (_data_->e);
	}
	__finally0:
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
		g_clear_error (&_data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

MetaDisplay*
gala_daemon_manager_get_display (GalaDaemonManager* self)
{
	MetaDisplay* result;
	MetaDisplay* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_display;
	result = _tmp0_;
	return result;
}

static void
gala_daemon_manager_set_display (GalaDaemonManager* self,
                                 MetaDisplay* value)
{
	MetaDisplay* old_value;
	g_return_if_fail (self != NULL);
	old_value = gala_daemon_manager_get_display (self);
	if (old_value != value) {
		MetaDisplay* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_display);
		self->priv->_display = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, gala_daemon_manager_properties[GALA_DAEMON_MANAGER_DISPLAY_PROPERTY]);
	}
}

void
gala_daemon_manager_daemon_show_window_menu (GalaDaemonManagerDaemon* self,
                                             GalaWindowFlags flags,
                                             gint width,
                                             gint height,
                                             gint x,
                                             gint y,
                                             GAsyncReadyCallback _callback_,
                                             gpointer _user_data_)
{
	GalaDaemonManagerDaemonIface* _iface_;
	_iface_ = GALA_DAEMON_MANAGER_DAEMON_GET_INTERFACE (self);
	if (_iface_->show_window_menu) {
		_iface_->show_window_menu (self, flags, width, height, x, y, _callback_, _user_data_);
	}
}

void
gala_daemon_manager_daemon_show_window_menu_finish (GalaDaemonManagerDaemon* self,
                                                    GAsyncResult* _res_,
                                                    GError** error)
{
	GalaDaemonManagerDaemonIface* _iface_;
	_iface_ = GALA_DAEMON_MANAGER_DAEMON_GET_INTERFACE (self);
	if (_iface_->show_window_menu_finish) {
		_iface_->show_window_menu_finish (self, _res_, error);
	}
}

void
gala_daemon_manager_daemon_show_desktop_menu (GalaDaemonManagerDaemon* self,
                                              gint display_width,
                                              gint display_height,
                                              gint x,
                                              gint y,
                                              GAsyncReadyCallback _callback_,
                                              gpointer _user_data_)
{
	GalaDaemonManagerDaemonIface* _iface_;
	_iface_ = GALA_DAEMON_MANAGER_DAEMON_GET_INTERFACE (self);
	if (_iface_->show_desktop_menu) {
		_iface_->show_desktop_menu (self, display_width, display_height, x, y, _callback_, _user_data_);
	}
}

void
gala_daemon_manager_daemon_show_desktop_menu_finish (GalaDaemonManagerDaemon* self,
                                                     GAsyncResult* _res_,
                                                     GError** error)
{
	GalaDaemonManagerDaemonIface* _iface_;
	_iface_ = GALA_DAEMON_MANAGER_DAEMON_GET_INTERFACE (self);
	if (_iface_->show_desktop_menu_finish) {
		_iface_->show_desktop_menu_finish (self, _res_, error);
	}
}

static void
gala_daemon_manager_daemon_default_init (GalaDaemonManagerDaemonIface * iface,
                                         gpointer iface_data)
{
}

 G_GNUC_NO_INLINE static GType
gala_daemon_manager_daemon_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GalaDaemonManagerDaemonIface), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gala_daemon_manager_daemon_default_init, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
	GType gala_daemon_manager_daemon_type_id;
	gala_daemon_manager_daemon_type_id = g_type_register_static (G_TYPE_INTERFACE, "GalaDaemonManagerDaemon", &g_define_type_info, 0);
	g_type_interface_add_prerequisite (gala_daemon_manager_daemon_type_id, G_TYPE_OBJECT);
	g_type_set_qdata (gala_daemon_manager_daemon_type_id, g_quark_from_static_string ("vala-dbus-proxy-type"), (void*) gala_daemon_manager_daemon_proxy_get_type);
	g_type_set_qdata (gala_daemon_manager_daemon_type_id, g_quark_from_static_string ("vala-dbus-interface-name"), "org.pantheon.gala.daemon");
	g_type_set_qdata (gala_daemon_manager_daemon_type_id, g_quark_from_static_string ("vala-dbus-interface-info"), (void*) (&_gala_daemon_manager_daemon_dbus_interface_info));
	g_type_set_qdata (gala_daemon_manager_daemon_type_id, g_quark_from_static_string ("vala-dbus-register-object"), (void*) gala_daemon_manager_daemon_register_object);
	return gala_daemon_manager_daemon_type_id;
}

GType
gala_daemon_manager_daemon_get_type (void)
{
	static gsize gala_daemon_manager_daemon_type_id__once = 0;
	if (g_once_init_enter (&gala_daemon_manager_daemon_type_id__once)) {
		GType gala_daemon_manager_daemon_type_id;
		gala_daemon_manager_daemon_type_id = gala_daemon_manager_daemon_get_type_once ();
		g_once_init_leave (&gala_daemon_manager_daemon_type_id__once, gala_daemon_manager_daemon_type_id);
	}
	return gala_daemon_manager_daemon_type_id__once;
}

G_DEFINE_TYPE_EXTENDED (GalaDaemonManagerDaemonProxy, gala_daemon_manager_daemon_proxy, G_TYPE_DBUS_PROXY, 0, G_IMPLEMENT_INTERFACE (GALA_DAEMON_MANAGER_TYPE_DAEMON, gala_daemon_manager_daemon_proxy_gala_daemon_manager_daemon_interface_init) )
static void
gala_daemon_manager_daemon_proxy_class_init (GalaDaemonManagerDaemonProxyClass* klass)
{
	G_DBUS_PROXY_CLASS (klass)->g_signal = gala_daemon_manager_daemon_proxy_g_signal;
}

static void
gala_daemon_manager_daemon_proxy_g_signal (GDBusProxy* proxy,
                                           const gchar* sender_name,
                                           const gchar* signal_name,
                                           GVariant* parameters)
{
}

static void
gala_daemon_manager_daemon_proxy_init (GalaDaemonManagerDaemonProxy* self)
{
	g_dbus_proxy_set_interface_info (G_DBUS_PROXY (self), (GDBusInterfaceInfo *) (&_gala_daemon_manager_daemon_dbus_interface_info));
}

static void
_vala_g_async_ready_callback (GObject *source_object,
                              GAsyncResult *res,
                              void *user_data)
{
	g_task_return_pointer (user_data, g_object_ref (res), g_object_unref);
	g_object_unref (user_data);
}

static void
gala_daemon_manager_daemon_proxy_show_window_menu_async (GalaDaemonManagerDaemon* self,
                                                         GalaWindowFlags flags,
                                                         gint width,
                                                         gint height,
                                                         gint x,
                                                         gint y,
                                                         GAsyncReadyCallback _callback_,
                                                         gpointer _user_data_)
{
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "org.pantheon.gala.daemon", "ShowWindowMenu");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_uint32 (flags));
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_int32 (width));
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_int32 (height));
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_int32 (x));
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_int32 (y));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	if (_callback_ != NULL) {
		g_dbus_connection_send_message_with_reply (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, _vala_g_async_ready_callback, g_task_new ((GObject *) self, NULL, _callback_, _user_data_));
	} else {
		g_dbus_message_set_flags (_message, G_DBUS_MESSAGE_FLAGS_NO_REPLY_EXPECTED);
		g_dbus_connection_send_message (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	}
	g_object_unref (_message);
}

static void
gala_daemon_manager_daemon_proxy_show_window_menu_finish (GalaDaemonManagerDaemon* self,
                                                          GAsyncResult* _res_,
                                                          GError** error)
{
	GAsyncResult *_inner_res;
	GDBusMessage *_reply_message;
	_inner_res = g_task_propagate_pointer ((GTask *) _res_, NULL);
	_reply_message = g_dbus_connection_send_message_with_reply_finish (g_dbus_proxy_get_connection ((GDBusProxy *) self), _inner_res, error);
	g_object_unref (_inner_res);
	if (!_reply_message) {
		return;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return;
	}
	g_object_unref (_reply_message);
}

static void
gala_daemon_manager_daemon_proxy_show_desktop_menu_async (GalaDaemonManagerDaemon* self,
                                                          gint display_width,
                                                          gint display_height,
                                                          gint x,
                                                          gint y,
                                                          GAsyncReadyCallback _callback_,
                                                          gpointer _user_data_)
{
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "org.pantheon.gala.daemon", "ShowDesktopMenu");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_int32 (display_width));
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_int32 (display_height));
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_int32 (x));
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_int32 (y));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	if (_callback_ != NULL) {
		g_dbus_connection_send_message_with_reply (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, _vala_g_async_ready_callback, g_task_new ((GObject *) self, NULL, _callback_, _user_data_));
	} else {
		g_dbus_message_set_flags (_message, G_DBUS_MESSAGE_FLAGS_NO_REPLY_EXPECTED);
		g_dbus_connection_send_message (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	}
	g_object_unref (_message);
}

static void
gala_daemon_manager_daemon_proxy_show_desktop_menu_finish (GalaDaemonManagerDaemon* self,
                                                           GAsyncResult* _res_,
                                                           GError** error)
{
	GAsyncResult *_inner_res;
	GDBusMessage *_reply_message;
	_inner_res = g_task_propagate_pointer ((GTask *) _res_, NULL);
	_reply_message = g_dbus_connection_send_message_with_reply_finish (g_dbus_proxy_get_connection ((GDBusProxy *) self), _inner_res, error);
	g_object_unref (_inner_res);
	if (!_reply_message) {
		return;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return;
	}
	g_object_unref (_reply_message);
}

static void
gala_daemon_manager_daemon_proxy_gala_daemon_manager_daemon_interface_init (GalaDaemonManagerDaemonIface* iface)
{
	iface->show_window_menu = gala_daemon_manager_daemon_proxy_show_window_menu_async;
	iface->show_window_menu_finish = gala_daemon_manager_daemon_proxy_show_window_menu_finish;
	iface->show_desktop_menu = gala_daemon_manager_daemon_proxy_show_desktop_menu_async;
	iface->show_desktop_menu_finish = gala_daemon_manager_daemon_proxy_show_desktop_menu_finish;
}

static void
_dbus_gala_daemon_manager_daemon_show_window_menu (GalaDaemonManagerDaemon* self,
                                                   GVariant* _parameters_,
                                                   GDBusMethodInvocation* invocation)
{
	GVariantIter _arguments_iter;
	GalaDaemonManagerDaemonShowWindowMenuReadyData* _ready_data;
	GVariant* _tmp0_;
	GVariant* _tmp1_;
	GVariant* _tmp2_;
	GVariant* _tmp3_;
	GVariant* _tmp4_;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	_ready_data = g_slice_new0 (GalaDaemonManagerDaemonShowWindowMenuReadyData);
	_ready_data->_invocation_ = invocation;
	_tmp0_ = g_variant_iter_next_value (&_arguments_iter);
	_ready_data->flags = g_variant_get_uint32 (_tmp0_);
	g_variant_unref (_tmp0_);
	_tmp1_ = g_variant_iter_next_value (&_arguments_iter);
	_ready_data->width = g_variant_get_int32 (_tmp1_);
	g_variant_unref (_tmp1_);
	_tmp2_ = g_variant_iter_next_value (&_arguments_iter);
	_ready_data->height = g_variant_get_int32 (_tmp2_);
	g_variant_unref (_tmp2_);
	_tmp3_ = g_variant_iter_next_value (&_arguments_iter);
	_ready_data->x = g_variant_get_int32 (_tmp3_);
	g_variant_unref (_tmp3_);
	_tmp4_ = g_variant_iter_next_value (&_arguments_iter);
	_ready_data->y = g_variant_get_int32 (_tmp4_);
	g_variant_unref (_tmp4_);
	gala_daemon_manager_daemon_show_window_menu (self, _ready_data->flags, _ready_data->width, _ready_data->height, _ready_data->x, _ready_data->y, (GAsyncReadyCallback) _dbus_gala_daemon_manager_daemon_show_window_menu_ready, _ready_data);
}

static void
_dbus_gala_daemon_manager_daemon_show_window_menu_ready (GObject * source_object,
                                                         GAsyncResult * _res_,
                                                         gpointer _user_data_)
{
	GalaDaemonManagerDaemonShowWindowMenuReadyData* _ready_data;
	GDBusMethodInvocation* invocation;
	GError* error = NULL;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	_ready_data = _user_data_;
	invocation = _ready_data->_invocation_;
	gala_daemon_manager_daemon_show_window_menu_finish ((GalaDaemonManagerDaemon*) source_object, _res_, &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		goto _error;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
	_error:
	g_slice_free (GalaDaemonManagerDaemonShowWindowMenuReadyData, _ready_data);
}

static void
_dbus_gala_daemon_manager_daemon_show_desktop_menu (GalaDaemonManagerDaemon* self,
                                                    GVariant* _parameters_,
                                                    GDBusMethodInvocation* invocation)
{
	GVariantIter _arguments_iter;
	GalaDaemonManagerDaemonShowDesktopMenuReadyData* _ready_data;
	GVariant* _tmp5_;
	GVariant* _tmp6_;
	GVariant* _tmp7_;
	GVariant* _tmp8_;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	_ready_data = g_slice_new0 (GalaDaemonManagerDaemonShowDesktopMenuReadyData);
	_ready_data->_invocation_ = invocation;
	_tmp5_ = g_variant_iter_next_value (&_arguments_iter);
	_ready_data->display_width = g_variant_get_int32 (_tmp5_);
	g_variant_unref (_tmp5_);
	_tmp6_ = g_variant_iter_next_value (&_arguments_iter);
	_ready_data->display_height = g_variant_get_int32 (_tmp6_);
	g_variant_unref (_tmp6_);
	_tmp7_ = g_variant_iter_next_value (&_arguments_iter);
	_ready_data->x = g_variant_get_int32 (_tmp7_);
	g_variant_unref (_tmp7_);
	_tmp8_ = g_variant_iter_next_value (&_arguments_iter);
	_ready_data->y = g_variant_get_int32 (_tmp8_);
	g_variant_unref (_tmp8_);
	gala_daemon_manager_daemon_show_desktop_menu (self, _ready_data->display_width, _ready_data->display_height, _ready_data->x, _ready_data->y, (GAsyncReadyCallback) _dbus_gala_daemon_manager_daemon_show_desktop_menu_ready, _ready_data);
}

static void
_dbus_gala_daemon_manager_daemon_show_desktop_menu_ready (GObject * source_object,
                                                          GAsyncResult * _res_,
                                                          gpointer _user_data_)
{
	GalaDaemonManagerDaemonShowDesktopMenuReadyData* _ready_data;
	GDBusMethodInvocation* invocation;
	GError* error = NULL;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	_ready_data = _user_data_;
	invocation = _ready_data->_invocation_;
	gala_daemon_manager_daemon_show_desktop_menu_finish ((GalaDaemonManagerDaemon*) source_object, _res_, &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		goto _error;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
	_error:
	g_slice_free (GalaDaemonManagerDaemonShowDesktopMenuReadyData, _ready_data);
}

static void
gala_daemon_manager_daemon_dbus_interface_method_call (GDBusConnection* connection,
                                                       const gchar* sender,
                                                       const gchar* object_path,
                                                       const gchar* interface_name,
                                                       const gchar* method_name,
                                                       GVariant* parameters,
                                                       GDBusMethodInvocation* invocation,
                                                       gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	if (strcmp (method_name, "ShowWindowMenu") == 0) {
		_dbus_gala_daemon_manager_daemon_show_window_menu (object, parameters, invocation);
	} else if (strcmp (method_name, "ShowDesktopMenu") == 0) {
		_dbus_gala_daemon_manager_daemon_show_desktop_menu (object, parameters, invocation);
	} else {
		g_object_unref (invocation);
	}
}

static GVariant*
gala_daemon_manager_daemon_dbus_interface_get_property (GDBusConnection* connection,
                                                        const gchar* sender,
                                                        const gchar* object_path,
                                                        const gchar* interface_name,
                                                        const gchar* property_name,
                                                        GError** error,
                                                        gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return NULL;
}

static gboolean
gala_daemon_manager_daemon_dbus_interface_set_property (GDBusConnection* connection,
                                                        const gchar* sender,
                                                        const gchar* object_path,
                                                        const gchar* interface_name,
                                                        const gchar* property_name,
                                                        GVariant* value,
                                                        GError** error,
                                                        gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return FALSE;
}

guint
gala_daemon_manager_daemon_register_object (gpointer object,
                                            GDBusConnection* connection,
                                            const gchar* path,
                                            GError** error)
{
	guint result;
	gpointer *data;
	data = g_new (gpointer, 3);
	data[0] = g_object_ref (object);
	data[1] = g_object_ref (connection);
	data[2] = g_strdup (path);
	result = g_dbus_connection_register_object (connection, path, (GDBusInterfaceInfo *) (&_gala_daemon_manager_daemon_dbus_interface_info), &_gala_daemon_manager_daemon_dbus_interface_vtable, data, _gala_daemon_manager_daemon_unregister_object, error);
	if (!result) {
		return 0;
	}
	return result;
}

static void
_gala_daemon_manager_daemon_unregister_object (gpointer user_data)
{
	gpointer* data;
	data = user_data;
	g_object_unref (data[0]);
	g_object_unref (data[1]);
	g_free (data[2]);
	g_free (data);
}

static void
_gala_daemon_manager_daemon_appeared_gbus_name_appeared_callback (GDBusConnection* connection,
                                                                  const gchar* name,
                                                                  const gchar* name_owner,
                                                                  gpointer self)
{
	gala_daemon_manager_daemon_appeared ((GalaDaemonManager*) self);
}

static void
_gala_daemon_manager_lost_daemon_gbus_name_vanished_callback (GDBusConnection* connection,
                                                              const gchar* name,
                                                              gpointer self)
{
	gala_daemon_manager_lost_daemon ((GalaDaemonManager*) self);
}

static void
_gala_daemon_manager_handle_daemon_window_meta_window_shown (MetaWindow* _sender,
                                                             gpointer self)
{
	gala_daemon_manager_handle_daemon_window ((GalaDaemonManager*) self, _sender);
}

static void
_gala_daemon_manager____lambda110_ (GalaDaemonManager* self,
                                    MetaWindow* window)
{
	MetaWaylandClient* _tmp0_;
	g_return_if_fail (window != NULL);
	_tmp0_ = self->priv->daemon_client;
	if (meta_wayland_client_owns_window (_tmp0_, window)) {
		g_signal_connect_object (window, "shown", (GCallback) _gala_daemon_manager_handle_daemon_window_meta_window_shown, self, 0);
	}
}

static void
__gala_daemon_manager____lambda110__meta_display_window_created (MetaDisplay* _sender,
                                                                 MetaWindow* object,
                                                                 gpointer self)
{
	_gala_daemon_manager____lambda110_ ((GalaDaemonManager*) self, object);
}

static GObject *
gala_daemon_manager_constructor (GType type,
                                 guint n_construct_properties,
                                 GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	GalaDaemonManager * self;
	parent_class = G_OBJECT_CLASS (gala_daemon_manager_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GALA_TYPE_DAEMON_MANAGER, GalaDaemonManager);
	g_bus_watch_name_with_closures (G_BUS_TYPE_SESSION, GALA_DAEMON_MANAGER_DAEMON_DBUS_NAME, G_BUS_NAME_WATCHER_FLAGS_NONE, (GClosure*) ((_gala_daemon_manager_daemon_appeared_gbus_name_appeared_callback == NULL) ? NULL : g_cclosure_new ((GCallback) _gala_daemon_manager_daemon_appeared_gbus_name_appeared_callback, g_object_ref (self), (GClosureNotify) g_object_unref)), (GClosure*) ((_gala_daemon_manager_lost_daemon_gbus_name_vanished_callback == NULL) ? NULL : g_cclosure_new ((GCallback) _gala_daemon_manager_lost_daemon_gbus_name_vanished_callback, g_object_ref (self), (GClosureNotify) g_object_unref)));
	if (meta_is_wayland_compositor ()) {
		MetaDisplay* _tmp0_;
		gala_daemon_manager_start_wayland (self, NULL, NULL);
		_tmp0_ = self->priv->_display;
		g_signal_connect_object (_tmp0_, "window-created", (GCallback) __gala_daemon_manager____lambda110__meta_display_window_created, self, 0);
	} else {
		gala_daemon_manager_start_x (self, NULL, NULL);
	}
	return obj;
}

static void
gala_daemon_manager_class_init (GalaDaemonManagerClass * klass,
                                gpointer klass_data)
{
	gala_daemon_manager_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GalaDaemonManager_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_gala_daemon_manager_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_gala_daemon_manager_set_property;
	G_OBJECT_CLASS (klass)->constructor = gala_daemon_manager_constructor;
	G_OBJECT_CLASS (klass)->finalize = gala_daemon_manager_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GALA_DAEMON_MANAGER_DISPLAY_PROPERTY, gala_daemon_manager_properties[GALA_DAEMON_MANAGER_DISPLAY_PROPERTY] = g_param_spec_object ("display", "display", "display", meta_display_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
}

static void
gala_daemon_manager_instance_init (GalaDaemonManager * self,
                                   gpointer klass)
{
	self->priv = gala_daemon_manager_get_instance_private (self);
	self->priv->daemon_proxy = NULL;
}

static void
gala_daemon_manager_finalize (GObject * obj)
{
	GalaDaemonManager * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GALA_TYPE_DAEMON_MANAGER, GalaDaemonManager);
	_g_object_unref0 (self->priv->_display);
	_g_object_unref0 (self->priv->daemon_client);
	_g_object_unref0 (self->priv->daemon_proxy);
	G_OBJECT_CLASS (gala_daemon_manager_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
gala_daemon_manager_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GalaDaemonManagerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gala_daemon_manager_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GalaDaemonManager), 0, (GInstanceInitFunc) gala_daemon_manager_instance_init, NULL };
	GType gala_daemon_manager_type_id;
	gala_daemon_manager_type_id = g_type_register_static (G_TYPE_OBJECT, "GalaDaemonManager", &g_define_type_info, 0);
	GalaDaemonManager_private_offset = g_type_add_instance_private (gala_daemon_manager_type_id, sizeof (GalaDaemonManagerPrivate));
	return gala_daemon_manager_type_id;
}

GType
gala_daemon_manager_get_type (void)
{
	static gsize gala_daemon_manager_type_id__once = 0;
	if (g_once_init_enter (&gala_daemon_manager_type_id__once)) {
		GType gala_daemon_manager_type_id;
		gala_daemon_manager_type_id = gala_daemon_manager_get_type_once ();
		g_once_init_leave (&gala_daemon_manager_type_id__once, gala_daemon_manager_type_id);
	}
	return gala_daemon_manager_type_id__once;
}

static void
_vala_gala_daemon_manager_get_property (GObject * object,
                                        guint property_id,
                                        GValue * value,
                                        GParamSpec * pspec)
{
	GalaDaemonManager * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GALA_TYPE_DAEMON_MANAGER, GalaDaemonManager);
	switch (property_id) {
		case GALA_DAEMON_MANAGER_DISPLAY_PROPERTY:
		g_value_set_object (value, gala_daemon_manager_get_display (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_gala_daemon_manager_set_property (GObject * object,
                                        guint property_id,
                                        const GValue * value,
                                        GParamSpec * pspec)
{
	GalaDaemonManager * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GALA_TYPE_DAEMON_MANAGER, GalaDaemonManager);
	switch (property_id) {
		case GALA_DAEMON_MANAGER_DISPLAY_PROPERTY:
		gala_daemon_manager_set_display (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

