#include "eldbus_fprint_device.h"

static int _log_main = -1;
#undef ERR
#define ERR(...) EINA_LOG_DOM_ERR(_log_main, __VA_ARGS__);
int FPRINT_DEVICE_VERIFY_FINGER_SELECTED_EVENT = 0;
int FPRINT_DEVICE_VERIFY_STATUS_EVENT = 0;
int FPRINT_DEVICE_ENROLL_STATUS_EVENT = 0;

static void
cb_fprint_device_list_enrolled_fingers(void *data, const Eldbus_Message *msg, Eldbus_Pending *pending)
{
   void *user_data = eldbus_pending_data_del(pending, "__user_data");
   Fprint_Device_List_Enrolled_Fingers_Cb cb = data;
   const char *error, *error_msg;
   Eina_Value *value;
   Eldbus_Proxy *proxy = eldbus_pending_data_del(pending, "__user_proxy");
   if (eldbus_message_error_get(msg, &error, &error_msg))
     {
        Eldbus_Error_Info error_info = {error, error_msg};
        cb(proxy, user_data, pending, &error_info, NULL);
        return;
     }
   value = eldbus_message_to_eina_value(msg);
   cb(proxy, user_data, pending, NULL, value);
   eina_value_free(value);
   return;
}

Eldbus_Pending *
fprint_device_list_enrolled_fingers_call(Eldbus_Proxy *proxy, Fprint_Device_List_Enrolled_Fingers_Cb cb, const void *data, const char *username)
{
   Eldbus_Message *msg;
   Eldbus_Pending *p;
   EINA_SAFETY_ON_NULL_RETURN_VAL(proxy, NULL);
   msg = eldbus_proxy_method_call_new(proxy, "ListEnrolledFingers");
   if (!eldbus_message_arguments_append(msg, "s", username))
     {
        ERR("Error: Filling message.");
        eldbus_message_unref(msg);
        return NULL;
     }
   p = eldbus_proxy_send(proxy, msg, cb_fprint_device_list_enrolled_fingers, cb, -1);
   if (data)
     eldbus_pending_data_set(p, "__user_data", data);
   eldbus_pending_data_set(p, "__user_proxy", proxy);
   return p;
}

static void
cb_fprint_device_delete_enrolled_fingers(void *data, const Eldbus_Message *msg, Eldbus_Pending *pending)
{
   void *user_data = eldbus_pending_data_del(pending, "__user_data");
   Fprint_Device_Delete_Enrolled_Fingers_Cb cb = data;
   const char *error, *error_msg;
   Eldbus_Proxy *proxy = eldbus_pending_data_del(pending, "__user_proxy");
   if (eldbus_message_error_get(msg, &error, &error_msg))
     {
        Eldbus_Error_Info error_info = {error, error_msg};
        cb(proxy, user_data, pending, &error_info);
        return;
     }
   if (!eldbus_message_arguments_get(msg, ""))
     {
        Eldbus_Error_Info error_info = {"", ""};
        ERR("Error: Getting arguments from message.");
        cb(proxy, user_data, pending, &error_info);
        return;
     }
   cb(proxy, user_data, pending, NULL);
   return;
}

Eldbus_Pending *
fprint_device_delete_enrolled_fingers_call(Eldbus_Proxy *proxy, Fprint_Device_Delete_Enrolled_Fingers_Cb cb, const void *data, const char *username)
{
   Eldbus_Message *msg;
   Eldbus_Pending *p;
   EINA_SAFETY_ON_NULL_RETURN_VAL(proxy, NULL);
   msg = eldbus_proxy_method_call_new(proxy, "DeleteEnrolledFingers");
   if (!eldbus_message_arguments_append(msg, "s", username))
     {
        ERR("Error: Filling message.");
        eldbus_message_unref(msg);
        return NULL;
     }
   p = eldbus_proxy_send(proxy, msg, cb_fprint_device_delete_enrolled_fingers, cb, -1);
   if (data)
     eldbus_pending_data_set(p, "__user_data", data);
   eldbus_pending_data_set(p, "__user_proxy", proxy);
   return p;
}

static void
cb_fprint_device_delete_enrolled_fingers2(void *data, const Eldbus_Message *msg, Eldbus_Pending *pending)
{
   void *user_data = eldbus_pending_data_del(pending, "__user_data");
   Fprint_Device_Delete_Enrolled_Fingers2_Cb cb = data;
   const char *error, *error_msg;
   Eldbus_Proxy *proxy = eldbus_pending_data_del(pending, "__user_proxy");
   if (eldbus_message_error_get(msg, &error, &error_msg))
     {
        Eldbus_Error_Info error_info = {error, error_msg};
        cb(proxy, user_data, pending, &error_info);
        return;
     }
   if (!eldbus_message_arguments_get(msg, ""))
     {
        Eldbus_Error_Info error_info = {"", ""};
        ERR("Error: Getting arguments from message.");
        cb(proxy, user_data, pending, &error_info);
        return;
     }
   cb(proxy, user_data, pending, NULL);
   return;
}

Eldbus_Pending *
fprint_device_delete_enrolled_fingers2_call(Eldbus_Proxy *proxy, Fprint_Device_Delete_Enrolled_Fingers2_Cb cb, const void *data)
{
   Eldbus_Message *msg;
   Eldbus_Pending *p;
   EINA_SAFETY_ON_NULL_RETURN_VAL(proxy, NULL);
   msg = eldbus_proxy_method_call_new(proxy, "DeleteEnrolledFingers2");
   if (!eldbus_message_arguments_append(msg, ""))
     {
        ERR("Error: Filling message.");
        eldbus_message_unref(msg);
        return NULL;
     }
   p = eldbus_proxy_send(proxy, msg, cb_fprint_device_delete_enrolled_fingers2, cb, -1);
   if (data)
     eldbus_pending_data_set(p, "__user_data", data);
   eldbus_pending_data_set(p, "__user_proxy", proxy);
   return p;
}

static void
cb_fprint_device_delete_enrolled_finger(void *data, const Eldbus_Message *msg, Eldbus_Pending *pending)
{
   void *user_data = eldbus_pending_data_del(pending, "__user_data");
   Fprint_Device_Delete_Enrolled_Finger_Cb cb = data;
   const char *error, *error_msg;
   Eldbus_Proxy *proxy = eldbus_pending_data_del(pending, "__user_proxy");
   if (eldbus_message_error_get(msg, &error, &error_msg))
     {
        Eldbus_Error_Info error_info = {error, error_msg};
        cb(proxy, user_data, pending, &error_info);
        return;
     }
   if (!eldbus_message_arguments_get(msg, ""))
     {
        Eldbus_Error_Info error_info = {"", ""};
        ERR("Error: Getting arguments from message.");
        cb(proxy, user_data, pending, &error_info);
        return;
     }
   cb(proxy, user_data, pending, NULL);
   return;
}

Eldbus_Pending *
fprint_device_delete_enrolled_finger_call(Eldbus_Proxy *proxy, Fprint_Device_Delete_Enrolled_Finger_Cb cb, const void *data, const char *finger_name)
{
   Eldbus_Message *msg;
   Eldbus_Pending *p;
   EINA_SAFETY_ON_NULL_RETURN_VAL(proxy, NULL);
   msg = eldbus_proxy_method_call_new(proxy, "DeleteEnrolledFinger");
   if (!eldbus_message_arguments_append(msg, "s", finger_name))
     {
        ERR("Error: Filling message.");
        eldbus_message_unref(msg);
        return NULL;
     }
   p = eldbus_proxy_send(proxy, msg, cb_fprint_device_delete_enrolled_finger, cb, -1);
   if (data)
     eldbus_pending_data_set(p, "__user_data", data);
   eldbus_pending_data_set(p, "__user_proxy", proxy);
   return p;
}

static void
cb_fprint_device_claim(void *data, const Eldbus_Message *msg, Eldbus_Pending *pending)
{
   void *user_data = eldbus_pending_data_del(pending, "__user_data");
   Fprint_Device_Claim_Cb cb = data;
   const char *error, *error_msg;
   Eldbus_Proxy *proxy = eldbus_pending_data_del(pending, "__user_proxy");
   if (eldbus_message_error_get(msg, &error, &error_msg))
     {
        Eldbus_Error_Info error_info = {error, error_msg};
        cb(proxy, user_data, pending, &error_info);
        return;
     }
   if (!eldbus_message_arguments_get(msg, ""))
     {
        Eldbus_Error_Info error_info = {"", ""};
        ERR("Error: Getting arguments from message.");
        cb(proxy, user_data, pending, &error_info);
        return;
     }
   cb(proxy, user_data, pending, NULL);
   return;
}

Eldbus_Pending *
fprint_device_claim_call(Eldbus_Proxy *proxy, Fprint_Device_Claim_Cb cb, const void *data, const char *username)
{
   Eldbus_Message *msg;
   Eldbus_Pending *p;
   EINA_SAFETY_ON_NULL_RETURN_VAL(proxy, NULL);
   msg = eldbus_proxy_method_call_new(proxy, "Claim");
   if (!eldbus_message_arguments_append(msg, "s", username))
     {
        ERR("Error: Filling message.");
        eldbus_message_unref(msg);
        return NULL;
     }
   p = eldbus_proxy_send(proxy, msg, cb_fprint_device_claim, cb, -1);
   if (data)
     eldbus_pending_data_set(p, "__user_data", data);
   eldbus_pending_data_set(p, "__user_proxy", proxy);
   return p;
}

static void
cb_fprint_device_release(void *data, const Eldbus_Message *msg, Eldbus_Pending *pending)
{
   void *user_data = eldbus_pending_data_del(pending, "__user_data");
   Fprint_Device_Release_Cb cb = data;
   const char *error, *error_msg;
   Eldbus_Proxy *proxy = eldbus_pending_data_del(pending, "__user_proxy");
   if (eldbus_message_error_get(msg, &error, &error_msg))
     {
        Eldbus_Error_Info error_info = {error, error_msg};
        cb(proxy, user_data, pending, &error_info);
        return;
     }
   if (!eldbus_message_arguments_get(msg, ""))
     {
        Eldbus_Error_Info error_info = {"", ""};
        ERR("Error: Getting arguments from message.");
        cb(proxy, user_data, pending, &error_info);
        return;
     }
   cb(proxy, user_data, pending, NULL);
   return;
}

Eldbus_Pending *
fprint_device_release_call(Eldbus_Proxy *proxy, Fprint_Device_Release_Cb cb, const void *data)
{
   Eldbus_Message *msg;
   Eldbus_Pending *p;
   EINA_SAFETY_ON_NULL_RETURN_VAL(proxy, NULL);
   msg = eldbus_proxy_method_call_new(proxy, "Release");
   if (!eldbus_message_arguments_append(msg, ""))
     {
        ERR("Error: Filling message.");
        eldbus_message_unref(msg);
        return NULL;
     }
   p = eldbus_proxy_send(proxy, msg, cb_fprint_device_release, cb, -1);
   if (data)
     eldbus_pending_data_set(p, "__user_data", data);
   eldbus_pending_data_set(p, "__user_proxy", proxy);
   return p;
}

static void
cb_fprint_device_verify_start(void *data, const Eldbus_Message *msg, Eldbus_Pending *pending)
{
   void *user_data = eldbus_pending_data_del(pending, "__user_data");
   Fprint_Device_Verify_Start_Cb cb = data;
   const char *error, *error_msg;
   Eldbus_Proxy *proxy = eldbus_pending_data_del(pending, "__user_proxy");
   if (eldbus_message_error_get(msg, &error, &error_msg))
     {
        Eldbus_Error_Info error_info = {error, error_msg};
        cb(proxy, user_data, pending, &error_info);
        return;
     }
   if (!eldbus_message_arguments_get(msg, ""))
     {
        Eldbus_Error_Info error_info = {"", ""};
        ERR("Error: Getting arguments from message.");
        cb(proxy, user_data, pending, &error_info);
        return;
     }
   cb(proxy, user_data, pending, NULL);
   return;
}

Eldbus_Pending *
fprint_device_verify_start_call(Eldbus_Proxy *proxy, Fprint_Device_Verify_Start_Cb cb, const void *data, const char *finger_name)
{
   Eldbus_Message *msg;
   Eldbus_Pending *p;
   EINA_SAFETY_ON_NULL_RETURN_VAL(proxy, NULL);
   msg = eldbus_proxy_method_call_new(proxy, "VerifyStart");
   if (!eldbus_message_arguments_append(msg, "s", finger_name))
     {
        ERR("Error: Filling message.");
        eldbus_message_unref(msg);
        return NULL;
     }
   p = eldbus_proxy_send(proxy, msg, cb_fprint_device_verify_start, cb, -1);
   if (data)
     eldbus_pending_data_set(p, "__user_data", data);
   eldbus_pending_data_set(p, "__user_proxy", proxy);
   return p;
}

static void
cb_fprint_device_verify_stop(void *data, const Eldbus_Message *msg, Eldbus_Pending *pending)
{
   void *user_data = eldbus_pending_data_del(pending, "__user_data");
   Fprint_Device_Verify_Stop_Cb cb = data;
   const char *error, *error_msg;
   Eldbus_Proxy *proxy = eldbus_pending_data_del(pending, "__user_proxy");
   if (eldbus_message_error_get(msg, &error, &error_msg))
     {
        Eldbus_Error_Info error_info = {error, error_msg};
        cb(proxy, user_data, pending, &error_info);
        return;
     }
   if (!eldbus_message_arguments_get(msg, ""))
     {
        Eldbus_Error_Info error_info = {"", ""};
        ERR("Error: Getting arguments from message.");
        cb(proxy, user_data, pending, &error_info);
        return;
     }
   cb(proxy, user_data, pending, NULL);
   return;
}

Eldbus_Pending *
fprint_device_verify_stop_call(Eldbus_Proxy *proxy, Fprint_Device_Verify_Stop_Cb cb, const void *data)
{
   Eldbus_Message *msg;
   Eldbus_Pending *p;
   EINA_SAFETY_ON_NULL_RETURN_VAL(proxy, NULL);
   msg = eldbus_proxy_method_call_new(proxy, "VerifyStop");
   if (!eldbus_message_arguments_append(msg, ""))
     {
        ERR("Error: Filling message.");
        eldbus_message_unref(msg);
        return NULL;
     }
   p = eldbus_proxy_send(proxy, msg, cb_fprint_device_verify_stop, cb, -1);
   if (data)
     eldbus_pending_data_set(p, "__user_data", data);
   eldbus_pending_data_set(p, "__user_proxy", proxy);
   return p;
}

static void
cb_fprint_device_enroll_start(void *data, const Eldbus_Message *msg, Eldbus_Pending *pending)
{
   void *user_data = eldbus_pending_data_del(pending, "__user_data");
   Fprint_Device_Enroll_Start_Cb cb = data;
   const char *error, *error_msg;
   Eldbus_Proxy *proxy = eldbus_pending_data_del(pending, "__user_proxy");
   if (eldbus_message_error_get(msg, &error, &error_msg))
     {
        Eldbus_Error_Info error_info = {error, error_msg};
        cb(proxy, user_data, pending, &error_info);
        return;
     }
   if (!eldbus_message_arguments_get(msg, ""))
     {
        Eldbus_Error_Info error_info = {"", ""};
        ERR("Error: Getting arguments from message.");
        cb(proxy, user_data, pending, &error_info);
        return;
     }
   cb(proxy, user_data, pending, NULL);
   return;
}

Eldbus_Pending *
fprint_device_enroll_start_call(Eldbus_Proxy *proxy, Fprint_Device_Enroll_Start_Cb cb, const void *data, const char *finger_name)
{
   Eldbus_Message *msg;
   Eldbus_Pending *p;
   EINA_SAFETY_ON_NULL_RETURN_VAL(proxy, NULL);
   msg = eldbus_proxy_method_call_new(proxy, "EnrollStart");
   if (!eldbus_message_arguments_append(msg, "s", finger_name))
     {
        ERR("Error: Filling message.");
        eldbus_message_unref(msg);
        return NULL;
     }
   p = eldbus_proxy_send(proxy, msg, cb_fprint_device_enroll_start, cb, -1);
   if (data)
     eldbus_pending_data_set(p, "__user_data", data);
   eldbus_pending_data_set(p, "__user_proxy", proxy);
   return p;
}

static void
cb_fprint_device_enroll_stop(void *data, const Eldbus_Message *msg, Eldbus_Pending *pending)
{
   void *user_data = eldbus_pending_data_del(pending, "__user_data");
   Fprint_Device_Enroll_Stop_Cb cb = data;
   const char *error, *error_msg;
   Eldbus_Proxy *proxy = eldbus_pending_data_del(pending, "__user_proxy");
   if (eldbus_message_error_get(msg, &error, &error_msg))
     {
        Eldbus_Error_Info error_info = {error, error_msg};
        cb(proxy, user_data, pending, &error_info);
        return;
     }
   if (!eldbus_message_arguments_get(msg, ""))
     {
        Eldbus_Error_Info error_info = {"", ""};
        ERR("Error: Getting arguments from message.");
        cb(proxy, user_data, pending, &error_info);
        return;
     }
   cb(proxy, user_data, pending, NULL);
   return;
}

Eldbus_Pending *
fprint_device_enroll_stop_call(Eldbus_Proxy *proxy, Fprint_Device_Enroll_Stop_Cb cb, const void *data)
{
   Eldbus_Message *msg;
   Eldbus_Pending *p;
   EINA_SAFETY_ON_NULL_RETURN_VAL(proxy, NULL);
   msg = eldbus_proxy_method_call_new(proxy, "EnrollStop");
   if (!eldbus_message_arguments_append(msg, ""))
     {
        ERR("Error: Filling message.");
        eldbus_message_unref(msg);
        return NULL;
     }
   p = eldbus_proxy_send(proxy, msg, cb_fprint_device_enroll_stop, cb, -1);
   if (data)
     eldbus_pending_data_set(p, "__user_data", data);
   eldbus_pending_data_set(p, "__user_proxy", proxy);
   return p;
}

static void
fprint_device_verify_finger_selected_data_free(void *user_data EINA_UNUSED, void *func_data)
{
   Fprint_Device_VerifyFingerSelected_Data *s_data = func_data;
   free(s_data->finger_name);
   free(s_data);
}

static void
on_fprint_device_verify_finger_selected(void *data, const Eldbus_Message *msg)
{
   Eldbus_Proxy *proxy = data;
   Fprint_Device_VerifyFingerSelected_Data *s_data = calloc(1, sizeof(Fprint_Device_VerifyFingerSelected_Data));
   s_data->proxy = proxy;
   if (!eldbus_message_arguments_get(msg, "s", &s_data->finger_name))
     {
        ERR("Error: Getting arguments from message.");
        free(s_data);
        return;
     }
   s_data->finger_name = strdup(s_data->finger_name);
   ecore_event_add(FPRINT_DEVICE_VERIFY_FINGER_SELECTED_EVENT, s_data, fprint_device_verify_finger_selected_data_free, NULL);
}

static void
fprint_device_verify_status_data_free(void *user_data EINA_UNUSED, void *func_data)
{
   Fprint_Device_VerifyStatus_Data *s_data = func_data;
   free(s_data->result);
   free(s_data);
}

static void
on_fprint_device_verify_status(void *data, const Eldbus_Message *msg)
{
   Eldbus_Proxy *proxy = data;
   Fprint_Device_VerifyStatus_Data *s_data = calloc(1, sizeof(Fprint_Device_VerifyStatus_Data));
   s_data->proxy = proxy;
   if (!eldbus_message_arguments_get(msg, "sb", &s_data->result, &s_data->done))
     {
        ERR("Error: Getting arguments from message.");
        free(s_data);
        return;
     }
   s_data->result = strdup(s_data->result);
   ecore_event_add(FPRINT_DEVICE_VERIFY_STATUS_EVENT, s_data, fprint_device_verify_status_data_free, NULL);
}

static void
fprint_device_enroll_status_data_free(void *user_data EINA_UNUSED, void *func_data)
{
   Fprint_Device_EnrollStatus_Data *s_data = func_data;
   free(s_data->result);
   free(s_data);
}

static void
on_fprint_device_enroll_status(void *data, const Eldbus_Message *msg)
{
   Eldbus_Proxy *proxy = data;
   Fprint_Device_EnrollStatus_Data *s_data = calloc(1, sizeof(Fprint_Device_EnrollStatus_Data));
   s_data->proxy = proxy;
   if (!eldbus_message_arguments_get(msg, "sb", &s_data->result, &s_data->done))
     {
        ERR("Error: Getting arguments from message.");
        free(s_data);
        return;
     }
   s_data->result = strdup(s_data->result);
   ecore_event_add(FPRINT_DEVICE_ENROLL_STATUS_EVENT, s_data, fprint_device_enroll_status_data_free, NULL);
}

static void
cb_fprint_device_name(void *data, const Eldbus_Message *msg, Eldbus_Pending *pending)
{
   void *user_data = eldbus_pending_data_del(pending, "__user_data");
   const char *error, *error_msg;
   Eldbus_Codegen_Property_String_Get_Cb cb = data;
   Eldbus_Proxy *proxy = eldbus_pending_data_del(pending, "__user_proxy");
   Eldbus_Message_Iter *variant;
   const char *v;
   if (eldbus_message_error_get(msg, &error, &error_msg))
     {
        Eldbus_Error_Info error_info = {error, error_msg};
        cb(user_data, pending, "name", proxy, &error_info, NULL);
        return;
     }
   if (!eldbus_message_arguments_get(msg, "v", &variant))
     {
        Eldbus_Error_Info error_info = {"", ""};
        cb(user_data, pending, "name", proxy, &error_info, NULL);
        return;
     }
   if (!eldbus_message_iter_arguments_get(variant, "s", &v))
     {
        Eldbus_Error_Info error_info = {"", ""};
        cb(user_data, pending, "name", proxy, &error_info, NULL);
        return;
     }
   cb(user_data, pending, "name", proxy, NULL, v);
}

Eldbus_Pending *
fprint_device_name_propget(Eldbus_Proxy *proxy, Eldbus_Codegen_Property_String_Get_Cb cb, const void *data)
{
   Eldbus_Pending *p;
   EINA_SAFETY_ON_NULL_RETURN_VAL(proxy, NULL);
   p = eldbus_proxy_property_get(proxy, "name", cb_fprint_device_name, cb);
   if (data)
     eldbus_pending_data_set(p, "__user_data", data);
   eldbus_pending_data_set(p, "__user_proxy", proxy);
   return p;
}

static void
cb_fprint_device_num_enroll_stages(void *data, const Eldbus_Message *msg, Eldbus_Pending *pending)
{
   void *user_data = eldbus_pending_data_del(pending, "__user_data");
   const char *error, *error_msg;
   Eldbus_Codegen_Property_Int32_Get_Cb cb = data;
   Eldbus_Proxy *proxy = eldbus_pending_data_del(pending, "__user_proxy");
   Eldbus_Message_Iter *variant;
   int v;
   if (eldbus_message_error_get(msg, &error, &error_msg))
     {
        Eldbus_Error_Info error_info = {error, error_msg};
        cb(user_data, pending, "num-enroll-stages", proxy, &error_info, 0);
        return;
     }
   if (!eldbus_message_arguments_get(msg, "v", &variant))
     {
        Eldbus_Error_Info error_info = {"", ""};
        cb(user_data, pending, "num-enroll-stages", proxy, &error_info, 0);
        return;
     }
   if (!eldbus_message_iter_arguments_get(variant, "i", &v))
     {
        Eldbus_Error_Info error_info = {"", ""};
        cb(user_data, pending, "num-enroll-stages", proxy, &error_info, 0);
        return;
     }
   cb(user_data, pending, "num-enroll-stages", proxy, NULL, v);
}

Eldbus_Pending *
fprint_device_num_enroll_stages_propget(Eldbus_Proxy *proxy, Eldbus_Codegen_Property_Int32_Get_Cb cb, const void *data)
{
   Eldbus_Pending *p;
   EINA_SAFETY_ON_NULL_RETURN_VAL(proxy, NULL);
   p = eldbus_proxy_property_get(proxy, "num-enroll-stages", cb_fprint_device_num_enroll_stages, cb);
   if (data)
     eldbus_pending_data_set(p, "__user_data", data);
   eldbus_pending_data_set(p, "__user_proxy", proxy);
   return p;
}

static void
cb_fprint_device_scan_type(void *data, const Eldbus_Message *msg, Eldbus_Pending *pending)
{
   void *user_data = eldbus_pending_data_del(pending, "__user_data");
   const char *error, *error_msg;
   Eldbus_Codegen_Property_String_Get_Cb cb = data;
   Eldbus_Proxy *proxy = eldbus_pending_data_del(pending, "__user_proxy");
   Eldbus_Message_Iter *variant;
   const char *v;
   if (eldbus_message_error_get(msg, &error, &error_msg))
     {
        Eldbus_Error_Info error_info = {error, error_msg};
        cb(user_data, pending, "scan-type", proxy, &error_info, NULL);
        return;
     }
   if (!eldbus_message_arguments_get(msg, "v", &variant))
     {
        Eldbus_Error_Info error_info = {"", ""};
        cb(user_data, pending, "scan-type", proxy, &error_info, NULL);
        return;
     }
   if (!eldbus_message_iter_arguments_get(variant, "s", &v))
     {
        Eldbus_Error_Info error_info = {"", ""};
        cb(user_data, pending, "scan-type", proxy, &error_info, NULL);
        return;
     }
   cb(user_data, pending, "scan-type", proxy, NULL, v);
}

Eldbus_Pending *
fprint_device_scan_type_propget(Eldbus_Proxy *proxy, Eldbus_Codegen_Property_String_Get_Cb cb, const void *data)
{
   Eldbus_Pending *p;
   EINA_SAFETY_ON_NULL_RETURN_VAL(proxy, NULL);
   p = eldbus_proxy_property_get(proxy, "scan-type", cb_fprint_device_scan_type, cb);
   if (data)
     eldbus_pending_data_set(p, "__user_data", data);
   eldbus_pending_data_set(p, "__user_proxy", proxy);
   return p;
}

static void
cb_fprint_device_finger_present(void *data, const Eldbus_Message *msg, Eldbus_Pending *pending)
{
   void *user_data = eldbus_pending_data_del(pending, "__user_data");
   const char *error, *error_msg;
   Eldbus_Codegen_Property_Bool_Get_Cb cb = data;
   Eldbus_Proxy *proxy = eldbus_pending_data_del(pending, "__user_proxy");
   Eldbus_Message_Iter *variant;
   Eina_Bool v;
   if (eldbus_message_error_get(msg, &error, &error_msg))
     {
        Eldbus_Error_Info error_info = {error, error_msg};
        cb(user_data, pending, "finger-present", proxy, &error_info, 0);
        return;
     }
   if (!eldbus_message_arguments_get(msg, "v", &variant))
     {
        Eldbus_Error_Info error_info = {"", ""};
        cb(user_data, pending, "finger-present", proxy, &error_info, 0);
        return;
     }
   if (!eldbus_message_iter_arguments_get(variant, "b", &v))
     {
        Eldbus_Error_Info error_info = {"", ""};
        cb(user_data, pending, "finger-present", proxy, &error_info, 0);
        return;
     }
   cb(user_data, pending, "finger-present", proxy, NULL, v);
}

Eldbus_Pending *
fprint_device_finger_present_propget(Eldbus_Proxy *proxy, Eldbus_Codegen_Property_Bool_Get_Cb cb, const void *data)
{
   Eldbus_Pending *p;
   EINA_SAFETY_ON_NULL_RETURN_VAL(proxy, NULL);
   p = eldbus_proxy_property_get(proxy, "finger-present", cb_fprint_device_finger_present, cb);
   if (data)
     eldbus_pending_data_set(p, "__user_data", data);
   eldbus_pending_data_set(p, "__user_proxy", proxy);
   return p;
}

static void
cb_fprint_device_finger_needed(void *data, const Eldbus_Message *msg, Eldbus_Pending *pending)
{
   void *user_data = eldbus_pending_data_del(pending, "__user_data");
   const char *error, *error_msg;
   Eldbus_Codegen_Property_Bool_Get_Cb cb = data;
   Eldbus_Proxy *proxy = eldbus_pending_data_del(pending, "__user_proxy");
   Eldbus_Message_Iter *variant;
   Eina_Bool v;
   if (eldbus_message_error_get(msg, &error, &error_msg))
     {
        Eldbus_Error_Info error_info = {error, error_msg};
        cb(user_data, pending, "finger-needed", proxy, &error_info, 0);
        return;
     }
   if (!eldbus_message_arguments_get(msg, "v", &variant))
     {
        Eldbus_Error_Info error_info = {"", ""};
        cb(user_data, pending, "finger-needed", proxy, &error_info, 0);
        return;
     }
   if (!eldbus_message_iter_arguments_get(variant, "b", &v))
     {
        Eldbus_Error_Info error_info = {"", ""};
        cb(user_data, pending, "finger-needed", proxy, &error_info, 0);
        return;
     }
   cb(user_data, pending, "finger-needed", proxy, NULL, v);
}

Eldbus_Pending *
fprint_device_finger_needed_propget(Eldbus_Proxy *proxy, Eldbus_Codegen_Property_Bool_Get_Cb cb, const void *data)
{
   Eldbus_Pending *p;
   EINA_SAFETY_ON_NULL_RETURN_VAL(proxy, NULL);
   p = eldbus_proxy_property_get(proxy, "finger-needed", cb_fprint_device_finger_needed, cb);
   if (data)
     eldbus_pending_data_set(p, "__user_data", data);
   eldbus_pending_data_set(p, "__user_proxy", proxy);
   return p;
}

void
fprint_device_log_domain_set(int id)
{
   _log_main = id;
}

void
fprint_device_proxy_unref(Eldbus_Proxy *proxy)
{
   Eldbus_Object *obj = eldbus_proxy_object_get(proxy);
   eldbus_proxy_unref(proxy);
   eldbus_object_unref(obj);
}

Eldbus_Proxy *
fprint_device_proxy_get(Eldbus_Connection *conn, const char *bus, const char *path)
{
   Eldbus_Object *obj;
   Eldbus_Proxy *proxy;
   EINA_SAFETY_ON_NULL_RETURN_VAL(conn, NULL);
   EINA_SAFETY_ON_NULL_RETURN_VAL(bus, NULL);
   if (!path) path = "/";
   obj = eldbus_object_get(conn, bus, path);
   proxy = eldbus_proxy_get(obj, "net.reactivated.Fprint.Device");
   eldbus_proxy_signal_handler_add(proxy, "VerifyFingerSelected", on_fprint_device_verify_finger_selected, proxy);
   if (!FPRINT_DEVICE_VERIFY_FINGER_SELECTED_EVENT)
     FPRINT_DEVICE_VERIFY_FINGER_SELECTED_EVENT = ecore_event_type_new();
   eldbus_proxy_signal_handler_add(proxy, "VerifyStatus", on_fprint_device_verify_status, proxy);
   if (!FPRINT_DEVICE_VERIFY_STATUS_EVENT)
     FPRINT_DEVICE_VERIFY_STATUS_EVENT = ecore_event_type_new();
   eldbus_proxy_signal_handler_add(proxy, "EnrollStatus", on_fprint_device_enroll_status, proxy);
   if (!FPRINT_DEVICE_ENROLL_STATUS_EVENT)
     FPRINT_DEVICE_ENROLL_STATUS_EVENT = ecore_event_type_new();
   return proxy;
}
