ECORE_CON_API ECORE_CON_API_WEAK Eina_Error efl_net_socket_ssl_error_handshake_get(void)
{
   static Eina_Error err = EINA_ERROR_NO_ERROR;
   if (err == EINA_ERROR_NO_ERROR)
     err = eina_error_msg_static_register("Failed SSL handshake");
   return err;
}

ECORE_CON_API ECORE_CON_API_WEAK Eina_Error efl_net_socket_ssl_error_certificate_verify_failed_get(void)
{
   static Eina_Error err = EINA_ERROR_NO_ERROR;
   if (err == EINA_ERROR_NO_ERROR)
     err = eina_error_msg_static_register("Failed to verify peer\'s certificate");
   return err;
}

ECORE_CON_API ECORE_CON_API_WEAK const Efl_Event_Description _EFL_NET_SOCKET_SSL_EVENT_SSL_READY =
   EFL_EVENT_DESCRIPTION("ssl,ready");
ECORE_CON_API ECORE_CON_API_WEAK const Efl_Event_Description _EFL_NET_SOCKET_SSL_EVENT_SSL_ERROR =
   EFL_EVENT_DESCRIPTION("ssl,error");

void _efl_net_socket_ssl_adopt(Eo *obj, Efl_Net_Socket_Ssl_Data *pd, Efl_Net_Socket *efl_net_socket, Efl_Net_Ssl_Context *ctx);

ECORE_CON_API ECORE_CON_API_WEAK EFL_VOID_FUNC_BODYV(efl_net_socket_ssl_adopt, EFL_FUNC_CALL(efl_net_socket, ctx), Efl_Net_Socket *efl_net_socket, Efl_Net_Ssl_Context *ctx);

Eina_Bool _efl_net_socket_ssl_adopted_get(const Eo *obj, Efl_Net_Socket_Ssl_Data *pd, Efl_Net_Socket **efl_net_socket, Efl_Net_Ssl_Context **ctx);

ECORE_CON_API ECORE_CON_API_WEAK EFL_FUNC_BODYV_CONST(efl_net_socket_ssl_adopted_get, Eina_Bool, EINA_FALSE /* false */, EFL_FUNC_CALL(efl_net_socket, ctx), Efl_Net_Socket **efl_net_socket, Efl_Net_Ssl_Context **ctx);

void _efl_net_socket_ssl_verify_mode_set(Eo *obj, Efl_Net_Socket_Ssl_Data *pd, Efl_Net_Ssl_Verify_Mode verify_mode);

ECORE_CON_API ECORE_CON_API_WEAK EFL_VOID_FUNC_BODYV(efl_net_socket_ssl_verify_mode_set, EFL_FUNC_CALL(verify_mode), Efl_Net_Ssl_Verify_Mode verify_mode);

Efl_Net_Ssl_Verify_Mode _efl_net_socket_ssl_verify_mode_get(const Eo *obj, Efl_Net_Socket_Ssl_Data *pd);

ECORE_CON_API ECORE_CON_API_WEAK EFL_FUNC_BODY_CONST(efl_net_socket_ssl_verify_mode_get, Efl_Net_Ssl_Verify_Mode, 0);

void _efl_net_socket_ssl_hostname_verify_set(Eo *obj, Efl_Net_Socket_Ssl_Data *pd, Eina_Bool hostname_verify);


static Eina_Error
__eolian_efl_net_socket_ssl_hostname_verify_set_reflect(Eo *obj, Eina_Value val)
{
   Eina_Error r = 0;   Eina_Bool cval;
   if (!eina_value_bool_convert(&val, &cval))
      {
         r = EINA_ERROR_VALUE_FAILED;
         goto end;
      }
   efl_net_socket_ssl_hostname_verify_set(obj, cval);
 end:
   eina_value_flush(&val);
   return r;
}

ECORE_CON_API ECORE_CON_API_WEAK EFL_VOID_FUNC_BODYV(efl_net_socket_ssl_hostname_verify_set, EFL_FUNC_CALL(hostname_verify), Eina_Bool hostname_verify);

Eina_Bool _efl_net_socket_ssl_hostname_verify_get(const Eo *obj, Efl_Net_Socket_Ssl_Data *pd);


static Eina_Value
__eolian_efl_net_socket_ssl_hostname_verify_get_reflect(const Eo *obj)
{
   Eina_Bool val = efl_net_socket_ssl_hostname_verify_get(obj);
   return eina_value_bool_init(val);
}

ECORE_CON_API ECORE_CON_API_WEAK EFL_FUNC_BODY_CONST(efl_net_socket_ssl_hostname_verify_get, Eina_Bool, 0);

void _efl_net_socket_ssl_hostname_override_set(Eo *obj, Efl_Net_Socket_Ssl_Data *pd, const char *hostname_override);


static Eina_Error
__eolian_efl_net_socket_ssl_hostname_override_set_reflect(Eo *obj, Eina_Value val)
{
   Eina_Error r = 0;   const char *cval;
   if (!eina_value_string_convert(&val, &cval))
      {
         r = EINA_ERROR_VALUE_FAILED;
         goto end;
      }
   efl_net_socket_ssl_hostname_override_set(obj, cval);
 end:
   eina_value_flush(&val);
   return r;
}

ECORE_CON_API ECORE_CON_API_WEAK EFL_VOID_FUNC_BODYV(efl_net_socket_ssl_hostname_override_set, EFL_FUNC_CALL(hostname_override), const char *hostname_override);

const char *_efl_net_socket_ssl_hostname_override_get(const Eo *obj, Efl_Net_Socket_Ssl_Data *pd);


static Eina_Value
__eolian_efl_net_socket_ssl_hostname_override_get_reflect(const Eo *obj)
{
   const char *val = efl_net_socket_ssl_hostname_override_get(obj);
   return eina_value_string_init(val);
}

ECORE_CON_API ECORE_CON_API_WEAK EFL_FUNC_BODY_CONST(efl_net_socket_ssl_hostname_override_get, const char *, NULL);

Efl_Object *_efl_net_socket_ssl_efl_object_constructor(Eo *obj, Efl_Net_Socket_Ssl_Data *pd);


Efl_Object *_efl_net_socket_ssl_efl_object_finalize(Eo *obj, Efl_Net_Socket_Ssl_Data *pd);


void _efl_net_socket_ssl_efl_object_invalidate(Eo *obj, Efl_Net_Socket_Ssl_Data *pd);


void _efl_net_socket_ssl_efl_object_destructor(Eo *obj, Efl_Net_Socket_Ssl_Data *pd);


Eina_Error _efl_net_socket_ssl_efl_io_closer_close(Eo *obj, Efl_Net_Socket_Ssl_Data *pd);


Eina_Bool _efl_net_socket_ssl_efl_io_closer_closed_get(const Eo *obj, Efl_Net_Socket_Ssl_Data *pd);


Eina_Bool _efl_net_socket_ssl_efl_io_closer_close_on_exec_set(Eo *obj, Efl_Net_Socket_Ssl_Data *pd, Eina_Bool close_on_exec);


Eina_Bool _efl_net_socket_ssl_efl_io_closer_close_on_exec_get(const Eo *obj, Efl_Net_Socket_Ssl_Data *pd);


void _efl_net_socket_ssl_efl_io_closer_close_on_invalidate_set(Eo *obj, Efl_Net_Socket_Ssl_Data *pd, Eina_Bool close_on_invalidate);


Eina_Bool _efl_net_socket_ssl_efl_io_closer_close_on_invalidate_get(const Eo *obj, Efl_Net_Socket_Ssl_Data *pd);


Eina_Error _efl_net_socket_ssl_efl_io_reader_read(Eo *obj, Efl_Net_Socket_Ssl_Data *pd, Eina_Rw_Slice *rw_slice);


void _efl_net_socket_ssl_efl_io_reader_can_read_set(Eo *obj, Efl_Net_Socket_Ssl_Data *pd, Eina_Bool can_read);


Eina_Bool _efl_net_socket_ssl_efl_io_reader_can_read_get(const Eo *obj, Efl_Net_Socket_Ssl_Data *pd);


void _efl_net_socket_ssl_efl_io_reader_eos_set(Eo *obj, Efl_Net_Socket_Ssl_Data *pd, Eina_Bool is_eos);


Eina_Bool _efl_net_socket_ssl_efl_io_reader_eos_get(const Eo *obj, Efl_Net_Socket_Ssl_Data *pd);


Eina_Error _efl_net_socket_ssl_efl_io_writer_write(Eo *obj, Efl_Net_Socket_Ssl_Data *pd, Eina_Slice *slice, Eina_Slice *remaining);


void _efl_net_socket_ssl_efl_io_writer_can_write_set(Eo *obj, Efl_Net_Socket_Ssl_Data *pd, Eina_Bool can_write);


Eina_Bool _efl_net_socket_ssl_efl_io_writer_can_write_get(const Eo *obj, Efl_Net_Socket_Ssl_Data *pd);


const char *_efl_net_socket_ssl_efl_net_socket_address_remote_get(const Eo *obj, Efl_Net_Socket_Ssl_Data *pd);


const char *_efl_net_socket_ssl_efl_net_socket_address_local_get(const Eo *obj, Efl_Net_Socket_Ssl_Data *pd);


static Eina_Bool
_efl_net_socket_ssl_class_initializer(Efl_Class *klass)
{
   const Efl_Object_Ops *opsp = NULL;

   const Efl_Object_Property_Reflection_Ops *ropsp = NULL;

#ifndef EFL_NET_SOCKET_SSL_EXTRA_OPS
#define EFL_NET_SOCKET_SSL_EXTRA_OPS
#endif

   EFL_OPS_DEFINE(ops,
      EFL_OBJECT_OP_FUNC(efl_net_socket_ssl_adopt, _efl_net_socket_ssl_adopt),
      EFL_OBJECT_OP_FUNC(efl_net_socket_ssl_adopted_get, _efl_net_socket_ssl_adopted_get),
      EFL_OBJECT_OP_FUNC(efl_net_socket_ssl_verify_mode_set, _efl_net_socket_ssl_verify_mode_set),
      EFL_OBJECT_OP_FUNC(efl_net_socket_ssl_verify_mode_get, _efl_net_socket_ssl_verify_mode_get),
      EFL_OBJECT_OP_FUNC(efl_net_socket_ssl_hostname_verify_set, _efl_net_socket_ssl_hostname_verify_set),
      EFL_OBJECT_OP_FUNC(efl_net_socket_ssl_hostname_verify_get, _efl_net_socket_ssl_hostname_verify_get),
      EFL_OBJECT_OP_FUNC(efl_net_socket_ssl_hostname_override_set, _efl_net_socket_ssl_hostname_override_set),
      EFL_OBJECT_OP_FUNC(efl_net_socket_ssl_hostname_override_get, _efl_net_socket_ssl_hostname_override_get),
      EFL_OBJECT_OP_FUNC(efl_constructor, _efl_net_socket_ssl_efl_object_constructor),
      EFL_OBJECT_OP_FUNC(efl_finalize, _efl_net_socket_ssl_efl_object_finalize),
      EFL_OBJECT_OP_FUNC(efl_invalidate, _efl_net_socket_ssl_efl_object_invalidate),
      EFL_OBJECT_OP_FUNC(efl_destructor, _efl_net_socket_ssl_efl_object_destructor),
      EFL_OBJECT_OP_FUNC(efl_io_closer_close, _efl_net_socket_ssl_efl_io_closer_close),
      EFL_OBJECT_OP_FUNC(efl_io_closer_closed_get, _efl_net_socket_ssl_efl_io_closer_closed_get),
      EFL_OBJECT_OP_FUNC(efl_io_closer_close_on_exec_set, _efl_net_socket_ssl_efl_io_closer_close_on_exec_set),
      EFL_OBJECT_OP_FUNC(efl_io_closer_close_on_exec_get, _efl_net_socket_ssl_efl_io_closer_close_on_exec_get),
      EFL_OBJECT_OP_FUNC(efl_io_closer_close_on_invalidate_set, _efl_net_socket_ssl_efl_io_closer_close_on_invalidate_set),
      EFL_OBJECT_OP_FUNC(efl_io_closer_close_on_invalidate_get, _efl_net_socket_ssl_efl_io_closer_close_on_invalidate_get),
      EFL_OBJECT_OP_FUNC(efl_io_reader_read, _efl_net_socket_ssl_efl_io_reader_read),
      EFL_OBJECT_OP_FUNC(efl_io_reader_can_read_set, _efl_net_socket_ssl_efl_io_reader_can_read_set),
      EFL_OBJECT_OP_FUNC(efl_io_reader_can_read_get, _efl_net_socket_ssl_efl_io_reader_can_read_get),
      EFL_OBJECT_OP_FUNC(efl_io_reader_eos_set, _efl_net_socket_ssl_efl_io_reader_eos_set),
      EFL_OBJECT_OP_FUNC(efl_io_reader_eos_get, _efl_net_socket_ssl_efl_io_reader_eos_get),
      EFL_OBJECT_OP_FUNC(efl_io_writer_write, _efl_net_socket_ssl_efl_io_writer_write),
      EFL_OBJECT_OP_FUNC(efl_io_writer_can_write_set, _efl_net_socket_ssl_efl_io_writer_can_write_set),
      EFL_OBJECT_OP_FUNC(efl_io_writer_can_write_get, _efl_net_socket_ssl_efl_io_writer_can_write_get),
      EFL_OBJECT_OP_FUNC(efl_net_socket_address_remote_get, _efl_net_socket_ssl_efl_net_socket_address_remote_get),
      EFL_OBJECT_OP_FUNC(efl_net_socket_address_local_get, _efl_net_socket_ssl_efl_net_socket_address_local_get),
      EFL_NET_SOCKET_SSL_EXTRA_OPS
   );
   opsp = &ops;

   static const Efl_Object_Property_Reflection refl_table[] = {
      {"hostname_verify", __eolian_efl_net_socket_ssl_hostname_verify_set_reflect, __eolian_efl_net_socket_ssl_hostname_verify_get_reflect},
      {"hostname_override", __eolian_efl_net_socket_ssl_hostname_override_set_reflect, __eolian_efl_net_socket_ssl_hostname_override_get_reflect},
   };
   static const Efl_Object_Property_Reflection_Ops rops = {
      refl_table, EINA_C_ARRAY_LENGTH(refl_table)
   };
   ropsp = &rops;

   return efl_class_functions_set(klass, opsp, ropsp);
}

static const Efl_Class_Description _efl_net_socket_ssl_class_desc = {
   EO_VERSION,
   "Efl.Net.Socket_Ssl",
   EFL_CLASS_TYPE_REGULAR,
   sizeof(Efl_Net_Socket_Ssl_Data),
   _efl_net_socket_ssl_class_initializer,
   NULL,
   NULL
};

EFL_DEFINE_CLASS(efl_net_socket_ssl_class_get, &_efl_net_socket_ssl_class_desc, EFL_LOOP_CONSUMER_CLASS, EFL_NET_SOCKET_INTERFACE, NULL);
