/* Generated by wayland-scanner 1.23.0 */

#ifndef ORG_KDE_KWIN_OUTPUTDEVICE_CLIENT_PROTOCOL_H
#define ORG_KDE_KWIN_OUTPUTDEVICE_CLIENT_PROTOCOL_H

#include <stdint.h>
#include <stddef.h>
#include "wayland-client.h"

#ifdef  __cplusplus
extern "C" {
#endif

/**
 * @page page_org_kde_kwin_outputdevice The org_kde_kwin_outputdevice protocol
 * @section page_ifaces_org_kde_kwin_outputdevice Interfaces
 * - @subpage page_iface_org_kde_kwin_outputdevice - output configuration representation
 * @section page_copyright_org_kde_kwin_outputdevice Copyright
 * <pre>
 *
 * SPDX-FileCopyrightText: 2008-2011 Kristian Høgsberg
 * SPDX-FileCopyrightText: 2010-2011 Intel Corporation
 * SPDX-FileCopyrightText: 2012-2013 Collabora, Ltd.
 * SPDX-FileCopyrightText: 2015 Sebastian Kügler <sebas@kde.org>
 *
 * SPDX-License-Identifier: MIT-CMU
 * </pre>
 */
struct org_kde_kwin_outputdevice;

#ifndef ORG_KDE_KWIN_OUTPUTDEVICE_INTERFACE
#define ORG_KDE_KWIN_OUTPUTDEVICE_INTERFACE
/**
 * @page page_iface_org_kde_kwin_outputdevice org_kde_kwin_outputdevice
 * @section page_iface_org_kde_kwin_outputdevice_desc Description
 *
 * An outputdevice describes a display device available to the compositor.
 * outputdevice is similar to wl_output, but focuses on output
 * configuration management.
 *
 * A client can query all global outputdevice objects to enlist all
 * available display devices, even those that may currently not be
 * represented by the compositor as a wl_output.
 *
 * The client sends configuration changes to the server through the
 * outputconfiguration interface, and the server applies the configuration
 * changes to the hardware and signals changes to the outputdevices
 * accordingly.
 *
 * This object is published as global during start up for every available
 * display devices, or when one later becomes available, for example by
 * being hotplugged via a physical connector.
 * @section page_iface_org_kde_kwin_outputdevice_api API
 * See @ref iface_org_kde_kwin_outputdevice.
 */
/**
 * @defgroup iface_org_kde_kwin_outputdevice The org_kde_kwin_outputdevice interface
 *
 * An outputdevice describes a display device available to the compositor.
 * outputdevice is similar to wl_output, but focuses on output
 * configuration management.
 *
 * A client can query all global outputdevice objects to enlist all
 * available display devices, even those that may currently not be
 * represented by the compositor as a wl_output.
 *
 * The client sends configuration changes to the server through the
 * outputconfiguration interface, and the server applies the configuration
 * changes to the hardware and signals changes to the outputdevices
 * accordingly.
 *
 * This object is published as global during start up for every available
 * display devices, or when one later becomes available, for example by
 * being hotplugged via a physical connector.
 */
extern const struct wl_interface org_kde_kwin_outputdevice_interface;
#endif

#ifndef ORG_KDE_KWIN_OUTPUTDEVICE_SUBPIXEL_ENUM
#define ORG_KDE_KWIN_OUTPUTDEVICE_SUBPIXEL_ENUM
/**
 * @ingroup iface_org_kde_kwin_outputdevice
 * subpixel geometry information
 *
 * This enumeration describes how the physical pixels on an output are
 * laid out.
 */
enum org_kde_kwin_outputdevice_subpixel {
	ORG_KDE_KWIN_OUTPUTDEVICE_SUBPIXEL_UNKNOWN = 0,
	ORG_KDE_KWIN_OUTPUTDEVICE_SUBPIXEL_NONE = 1,
	ORG_KDE_KWIN_OUTPUTDEVICE_SUBPIXEL_HORIZONTAL_RGB = 2,
	ORG_KDE_KWIN_OUTPUTDEVICE_SUBPIXEL_HORIZONTAL_BGR = 3,
	ORG_KDE_KWIN_OUTPUTDEVICE_SUBPIXEL_VERTICAL_RGB = 4,
	ORG_KDE_KWIN_OUTPUTDEVICE_SUBPIXEL_VERTICAL_BGR = 5,
};
#endif /* ORG_KDE_KWIN_OUTPUTDEVICE_SUBPIXEL_ENUM */

#ifndef ORG_KDE_KWIN_OUTPUTDEVICE_TRANSFORM_ENUM
#define ORG_KDE_KWIN_OUTPUTDEVICE_TRANSFORM_ENUM
/**
 * @ingroup iface_org_kde_kwin_outputdevice
 * transform from framebuffer to output
 *
 * This describes the transform, that a compositor will apply to a
 * surface to compensate for the rotation or mirroring of an
 * output device.
 *
 * The flipped values correspond to an initial flip around a
 * vertical axis followed by rotation.
 *
 * The purpose is mainly to allow clients to render accordingly and
 * tell the compositor, so that for fullscreen surfaces, the
 * compositor is still able to scan out directly client surfaces.
 */
enum org_kde_kwin_outputdevice_transform {
	ORG_KDE_KWIN_OUTPUTDEVICE_TRANSFORM_NORMAL = 0,
	ORG_KDE_KWIN_OUTPUTDEVICE_TRANSFORM_90 = 1,
	ORG_KDE_KWIN_OUTPUTDEVICE_TRANSFORM_180 = 2,
	ORG_KDE_KWIN_OUTPUTDEVICE_TRANSFORM_270 = 3,
	ORG_KDE_KWIN_OUTPUTDEVICE_TRANSFORM_FLIPPED = 4,
	ORG_KDE_KWIN_OUTPUTDEVICE_TRANSFORM_FLIPPED_90 = 5,
	ORG_KDE_KWIN_OUTPUTDEVICE_TRANSFORM_FLIPPED_180 = 6,
	ORG_KDE_KWIN_OUTPUTDEVICE_TRANSFORM_FLIPPED_270 = 7,
};
#endif /* ORG_KDE_KWIN_OUTPUTDEVICE_TRANSFORM_ENUM */

#ifndef ORG_KDE_KWIN_OUTPUTDEVICE_MODE_ENUM
#define ORG_KDE_KWIN_OUTPUTDEVICE_MODE_ENUM
/**
 * @ingroup iface_org_kde_kwin_outputdevice
 * mode information
 *
 * These flags describe properties of an output mode. They are
 * used in the flags bitfield of the mode event.
 */
enum org_kde_kwin_outputdevice_mode {
	/**
	 * indicates this is the current mode
	 */
	ORG_KDE_KWIN_OUTPUTDEVICE_MODE_CURRENT = 0x1,
	/**
	 * indicates this is the preferred mode
	 */
	ORG_KDE_KWIN_OUTPUTDEVICE_MODE_PREFERRED = 0x2,
};
#endif /* ORG_KDE_KWIN_OUTPUTDEVICE_MODE_ENUM */

#ifndef ORG_KDE_KWIN_OUTPUTDEVICE_ENABLEMENT_ENUM
#define ORG_KDE_KWIN_OUTPUTDEVICE_ENABLEMENT_ENUM
/**
 * @ingroup iface_org_kde_kwin_outputdevice
 * describes enabled state
 *
 * Describes whether a device is enabled, i.e. device is used to
 * display content by the compositor. This wraps a boolean around
 * an int to avoid a boolean trap.
 */
enum org_kde_kwin_outputdevice_enablement {
	ORG_KDE_KWIN_OUTPUTDEVICE_ENABLEMENT_DISABLED = 0,
	ORG_KDE_KWIN_OUTPUTDEVICE_ENABLEMENT_ENABLED = 1,
};
#endif /* ORG_KDE_KWIN_OUTPUTDEVICE_ENABLEMENT_ENUM */

#ifndef ORG_KDE_KWIN_OUTPUTDEVICE_CAPABILITY_ENUM
#define ORG_KDE_KWIN_OUTPUTDEVICE_CAPABILITY_ENUM
/**
 * @ingroup iface_org_kde_kwin_outputdevice
 * describes capabilities of the outputdevice
 *
 * Describes what capabilities this device has.
 */
enum org_kde_kwin_outputdevice_capability {
	/**
	 * if this outputdevice can use overscan
	 */
	ORG_KDE_KWIN_OUTPUTDEVICE_CAPABILITY_OVERSCAN = 1,
	/**
	 * if this outputdevice supports variable refresh rate
	 * @since 4
	 */
	ORG_KDE_KWIN_OUTPUTDEVICE_CAPABILITY_VRR = 2,
};
/**
 * @ingroup iface_org_kde_kwin_outputdevice
 */
#define ORG_KDE_KWIN_OUTPUTDEVICE_CAPABILITY_VRR_SINCE_VERSION 4
#endif /* ORG_KDE_KWIN_OUTPUTDEVICE_CAPABILITY_ENUM */

#ifndef ORG_KDE_KWIN_OUTPUTDEVICE_VRR_POLICY_ENUM
#define ORG_KDE_KWIN_OUTPUTDEVICE_VRR_POLICY_ENUM
/**
 * @ingroup iface_org_kde_kwin_outputdevice
 * describes vrr policy
 *
 * Describes when the compositor may employ variable refresh rate
 */
enum org_kde_kwin_outputdevice_vrr_policy {
	ORG_KDE_KWIN_OUTPUTDEVICE_VRR_POLICY_NEVER = 0,
	ORG_KDE_KWIN_OUTPUTDEVICE_VRR_POLICY_ALWAYS = 1,
	ORG_KDE_KWIN_OUTPUTDEVICE_VRR_POLICY_AUTOMATIC = 2,
};
#endif /* ORG_KDE_KWIN_OUTPUTDEVICE_VRR_POLICY_ENUM */

/**
 * @ingroup iface_org_kde_kwin_outputdevice
 * @struct org_kde_kwin_outputdevice_listener
 */
struct org_kde_kwin_outputdevice_listener {
	/**
	 * geometric properties of the output
	 *
	 * The geometry event describes geometric properties of the
	 * output. The event is sent when binding to the output object and
	 * whenever any of the properties change.
	 * @param x x position within the global compositor space
	 * @param y y position within the global compositor space
	 * @param physical_width width in millimeters of the output
	 * @param physical_height height in millimeters of the output
	 * @param subpixel subpixel orientation of the output
	 * @param make textual description of the manufacturer
	 * @param model textual description of the model
	 * @param transform transform that maps framebuffer to output
	 */
	void (*geometry)(void *data,
			 struct org_kde_kwin_outputdevice *org_kde_kwin_outputdevice,
			 int32_t x,
			 int32_t y,
			 int32_t physical_width,
			 int32_t physical_height,
			 int32_t subpixel,
			 const char *make,
			 const char *model,
			 int32_t transform);
	/**
	 * advertise available output modes and current one
	 *
	 * The mode event describes an available mode for the output.
	 *
	 * When the client binds to the outputdevice object, the server
	 * sends this event once for every available mode the outputdevice
	 * can be operated by.
	 *
	 * There will always be at least one event sent out on initial
	 * binding, which represents the current mode.
	 *
	 * Later on if an output changes its mode the event is sent again,
	 * whereby this event represents the mode that has now become
	 * current. In other words, the current mode is always represented
	 * by the latest event sent with the current flag set.
	 *
	 * The size of a mode is given in physical hardware units of the
	 * output device. This is not necessarily the same as the output
	 * size in the global compositor space. For instance, the output
	 * may be scaled, as described in org_kde_kwin_outputdevice.scale,
	 * or transformed, as described in
	 * org_kde_kwin_outputdevice.transform.
	 *
	 * The id can be used to refer to a mode when calling set_mode on
	 * an org_kde_kwin_outputconfiguration object.
	 * @param flags bitfield of mode flags
	 * @param width width of the mode in hardware units
	 * @param height height of the mode in hardware units
	 * @param refresh vertical refresh rate in mHz
	 * @param mode_id Per outputdevice unique id to identify a mode
	 */
	void (*mode)(void *data,
		     struct org_kde_kwin_outputdevice *org_kde_kwin_outputdevice,
		     uint32_t flags,
		     int32_t width,
		     int32_t height,
		     int32_t refresh,
		     int32_t mode_id);
	/**
	 * sent all information about output
	 *
	 * This event is sent after all other properties have been sent
	 * on binding to the output object as well as after any other
	 * output property change have been applied later on. This allows
	 * to see changes to the output properties as atomic, even if
	 * multiple events successively announce them.
	 */
	void (*done)(void *data,
		     struct org_kde_kwin_outputdevice *org_kde_kwin_outputdevice);
	/**
	 * output scaling properties
	 *
	 * This event contains scaling geometry information that is not
	 * in the geometry event. It may be sent after binding the output
	 * object or if the output scale changes later. If it is not sent,
	 * the client should assume a scale of 1.
	 *
	 * A scale larger than 1 means that the compositor will
	 * automatically scale surface buffers by this amount when
	 * rendering. This is used for high resolution displays where
	 * applications rendering at the native resolution would be too
	 * small to be legible.
	 *
	 * It is intended that scaling aware clients track the current
	 * output of a surface, and if it is on a scaled output it should
	 * use wl_surface.set_buffer_scale with the scale of the output.
	 * That way the compositor can avoid scaling the surface, and the
	 * client can supply a higher detail image.
	 * @param factor scaling factor of output
	 */
	void (*scale)(void *data,
		      struct org_kde_kwin_outputdevice *org_kde_kwin_outputdevice,
		      int32_t factor);
	/**
	 * advertise EDID data for the output
	 *
	 * The edid event encapsulates the EDID data for the
	 * outputdevice.
	 *
	 * The event is sent when binding to the output object. The EDID
	 * data may be empty, in which case this event is sent anyway. If
	 * the EDID information is empty, you can fall back to the name et
	 * al. properties of the outputdevice.
	 * @param raw base64-encoded EDID string
	 */
	void (*edid)(void *data,
		     struct org_kde_kwin_outputdevice *org_kde_kwin_outputdevice,
		     const char *raw);
	/**
	 * output is enabled or disabled
	 *
	 * The enabled event notifies whether this output is currently
	 * enabled and used for displaying content by the server. The event
	 * is sent when binding to the output object and whenever later on
	 * an output changes its state by becoming enabled or disabled.
	 * @param enabled output enabled state
	 */
	void (*enabled)(void *data,
			struct org_kde_kwin_outputdevice *org_kde_kwin_outputdevice,
			int32_t enabled);
	/**
	 * A unique id for this outputdevice
	 *
	 * The uuid can be used to identify the output. It's controlled
	 * by the server entirely. The server should make sure the uuid is
	 * persistent across restarts. An empty uuid is considered invalid.
	 * @param uuid output devices ID
	 */
	void (*uuid)(void *data,
		     struct org_kde_kwin_outputdevice *org_kde_kwin_outputdevice,
		     const char *uuid);
	/**
	 * output scaling properties
	 *
	 * This event contains scaling geometry information that is not
	 * in the geometry event. It may be sent after binding the output
	 * object or if the output scale changes later. If it is not sent,
	 * the client should assume a scale of 1.
	 *
	 * A scale larger than 1 means that the compositor will
	 * automatically scale surface buffers by this amount when
	 * rendering. This is used for high resolution displays where
	 * applications rendering at the native resolution would be too
	 * small to be legible.
	 *
	 * It is intended that scaling aware clients track the current
	 * output of a surface, and if it is on a scaled output it should
	 * use wl_surface.set_buffer_scale with the scale of the output.
	 * That way the compositor can avoid scaling the surface, and the
	 * client can supply a higher detail image.
	 *
	 * wl_output will keep the output scale as an integer. In every
	 * situation except configuring the window manager you want to use
	 * that.
	 * @param factor scaling factor of output
	 * @since 2
	 */
	void (*scalef)(void *data,
		       struct org_kde_kwin_outputdevice *org_kde_kwin_outputdevice,
		       wl_fixed_t factor);
	/**
	 * output color curves
	 *
	 * Describes the color intensity profile of the output. Commonly
	 * used for gamma/color correction.
	 *
	 * The array contains all color ramp values of the output. For
	 * example on 8bit screens there are 256 of them.
	 *
	 * The array elements are unsigned 16bit integers.
	 * @param red red color ramp
	 * @param green green color ramp
	 * @param blue blue color ramp
	 * @since 2
	 */
	void (*colorcurves)(void *data,
			    struct org_kde_kwin_outputdevice *org_kde_kwin_outputdevice,
			    struct wl_array *red,
			    struct wl_array *green,
			    struct wl_array *blue);
	/**
	 * Serial Number
	 *
	 * Serial ID of the monitor, sent on startup before the first
	 * done event.
	 * @param serialNumber textual representation of serial number
	 * @since 2
	 */
	void (*serial_number)(void *data,
			      struct org_kde_kwin_outputdevice *org_kde_kwin_outputdevice,
			      const char *serialNumber);
	/**
	 * EISA ID
	 *
	 * EISA ID of the monitor, sent on startup before the first done
	 * event.
	 * @param eisaId textual representation of EISA identifier
	 * @since 2
	 */
	void (*eisa_id)(void *data,
			struct org_kde_kwin_outputdevice *org_kde_kwin_outputdevice,
			const char *eisaId);
	/**
	 * capability flags
	 *
	 * What capabilities this device has, sent on startup before the
	 * first done event.
	 * @since 3
	 */
	void (*capabilities)(void *data,
			     struct org_kde_kwin_outputdevice *org_kde_kwin_outputdevice,
			     uint32_t flags);
	/**
	 * overscan
	 *
	 * Overscan value of the monitor in percent, sent on startup
	 * before the first done event.
	 * @param overscan amount of overscan of the monitor
	 * @since 3
	 */
	void (*overscan)(void *data,
			 struct org_kde_kwin_outputdevice *org_kde_kwin_outputdevice,
			 uint32_t overscan);
	/**
	 * Variable Refresh Rate Policy
	 *
	 * What policy the compositor will employ regarding its use of
	 * variable refresh rate.
	 * @since 4
	 */
	void (*vrr_policy)(void *data,
			   struct org_kde_kwin_outputdevice *org_kde_kwin_outputdevice,
			   uint32_t vrr_policy);
};

/**
 * @ingroup iface_org_kde_kwin_outputdevice
 */
static inline int
org_kde_kwin_outputdevice_add_listener(struct org_kde_kwin_outputdevice *org_kde_kwin_outputdevice,
				       const struct org_kde_kwin_outputdevice_listener *listener, void *data)
{
	return wl_proxy_add_listener((struct wl_proxy *) org_kde_kwin_outputdevice,
				     (void (**)(void)) listener, data);
}

/**
 * @ingroup iface_org_kde_kwin_outputdevice
 */
#define ORG_KDE_KWIN_OUTPUTDEVICE_GEOMETRY_SINCE_VERSION 1
/**
 * @ingroup iface_org_kde_kwin_outputdevice
 */
#define ORG_KDE_KWIN_OUTPUTDEVICE_MODE_SINCE_VERSION 1
/**
 * @ingroup iface_org_kde_kwin_outputdevice
 */
#define ORG_KDE_KWIN_OUTPUTDEVICE_DONE_SINCE_VERSION 1
/**
 * @ingroup iface_org_kde_kwin_outputdevice
 */
#define ORG_KDE_KWIN_OUTPUTDEVICE_SCALE_SINCE_VERSION 1
/**
 * @ingroup iface_org_kde_kwin_outputdevice
 */
#define ORG_KDE_KWIN_OUTPUTDEVICE_EDID_SINCE_VERSION 1
/**
 * @ingroup iface_org_kde_kwin_outputdevice
 */
#define ORG_KDE_KWIN_OUTPUTDEVICE_ENABLED_SINCE_VERSION 1
/**
 * @ingroup iface_org_kde_kwin_outputdevice
 */
#define ORG_KDE_KWIN_OUTPUTDEVICE_UUID_SINCE_VERSION 1
/**
 * @ingroup iface_org_kde_kwin_outputdevice
 */
#define ORG_KDE_KWIN_OUTPUTDEVICE_SCALEF_SINCE_VERSION 2
/**
 * @ingroup iface_org_kde_kwin_outputdevice
 */
#define ORG_KDE_KWIN_OUTPUTDEVICE_COLORCURVES_SINCE_VERSION 2
/**
 * @ingroup iface_org_kde_kwin_outputdevice
 */
#define ORG_KDE_KWIN_OUTPUTDEVICE_SERIAL_NUMBER_SINCE_VERSION 2
/**
 * @ingroup iface_org_kde_kwin_outputdevice
 */
#define ORG_KDE_KWIN_OUTPUTDEVICE_EISA_ID_SINCE_VERSION 2
/**
 * @ingroup iface_org_kde_kwin_outputdevice
 */
#define ORG_KDE_KWIN_OUTPUTDEVICE_CAPABILITIES_SINCE_VERSION 3
/**
 * @ingroup iface_org_kde_kwin_outputdevice
 */
#define ORG_KDE_KWIN_OUTPUTDEVICE_OVERSCAN_SINCE_VERSION 3
/**
 * @ingroup iface_org_kde_kwin_outputdevice
 */
#define ORG_KDE_KWIN_OUTPUTDEVICE_VRR_POLICY_SINCE_VERSION 4


/** @ingroup iface_org_kde_kwin_outputdevice */
static inline void
org_kde_kwin_outputdevice_set_user_data(struct org_kde_kwin_outputdevice *org_kde_kwin_outputdevice, void *user_data)
{
	wl_proxy_set_user_data((struct wl_proxy *) org_kde_kwin_outputdevice, user_data);
}

/** @ingroup iface_org_kde_kwin_outputdevice */
static inline void *
org_kde_kwin_outputdevice_get_user_data(struct org_kde_kwin_outputdevice *org_kde_kwin_outputdevice)
{
	return wl_proxy_get_user_data((struct wl_proxy *) org_kde_kwin_outputdevice);
}

static inline uint32_t
org_kde_kwin_outputdevice_get_version(struct org_kde_kwin_outputdevice *org_kde_kwin_outputdevice)
{
	return wl_proxy_get_version((struct wl_proxy *) org_kde_kwin_outputdevice);
}

/** @ingroup iface_org_kde_kwin_outputdevice */
static inline void
org_kde_kwin_outputdevice_destroy(struct org_kde_kwin_outputdevice *org_kde_kwin_outputdevice)
{
	wl_proxy_destroy((struct wl_proxy *) org_kde_kwin_outputdevice);
}

#ifdef  __cplusplus
}
#endif

#endif
